/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.autorizzazione.pa;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.constants.CostantiRegistroServizi;
import org.openspcoop2.pdd.core.AbstractCore;
import org.openspcoop2.pdd.core.autenticazione.Credenziali;
import org.openspcoop2.pdd.core.autorizzazione.pa.DatiInvocazionePortaApplicativa;
import org.openspcoop2.pdd.core.autorizzazione.pa.EsitoAutorizzazioneCooperazione;
import org.openspcoop2.pdd.core.autorizzazione.pa.IAutorizzazionePortaApplicativa;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.ErroriCooperazione;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.resources.GestoreJNDI;

public class AutorizzazionePdDConsole
extends AbstractCore
implements IAutorizzazionePortaApplicativa {
    private static boolean initialized = false;
    private static DataSource dataSource = null;
    private static String checkPdd = CostantiRegistroServizi.DISABILITATO.toString();
    private static String checkFruizioneServizioApplicativo = CostantiRegistroServizi.DISABILITATO.toString();
    private static String checkFruizionePerRuolo = CostantiRegistroServizi.DISABILITATO.toString();
    private static final String ALMOST_ONE = "almostOne";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void initRisorse() {
        if (!initialized) {
            InputStream properties = null;
            try {
                properties = AutorizzazionePdDConsole.class.getResourceAsStream("/autorizzazionePdDConsole.properties");
                if (properties == null) {
                    throw new Exception("File autorizzazionePdDConsole.properties non trovato");
                }
                Properties reader = new Properties();
                reader.load(properties);
                if (Utilities.readProperties((String)"dataSource.property.", (Properties)reader) == null) {
                    throw new Exception("Proprieta' per il contesto JNDI [dataSource.property.*] non correttamente definite");
                }
                if (reader.getProperty("dataSource") == null) {
                    throw new Exception("Nome JNDI del DataSource non fornito");
                }
                GestoreJNDI jndi = new GestoreJNDI(Utilities.readProperties((String)"dataSource.property.", (Properties)reader));
                dataSource = (DataSource)jndi.lookup(reader.getProperty("dataSource").trim());
                if (dataSource == null) {
                    throw new Exception("DataSource is null");
                }
                if (reader.getProperty("checkPdd") == null) {
                    throw new Exception("Proprieta' 'checkPdd' non fornita");
                }
                if (!CostantiRegistroServizi.ABILITATO.equals(reader.getProperty("checkPdd").trim()) && !CostantiRegistroServizi.DISABILITATO.equals(reader.getProperty("checkPdd").trim())) {
                    throw new Exception("Proprieta' 'checkPdd' non possiede un valore valido");
                }
                checkPdd = reader.getProperty("checkPdd").trim();
                if (reader.getProperty("checkFruizioneServizioApplicativo") == null) {
                    throw new Exception("Proprieta' 'checkFruizioneServizioApplicativo' non fornita");
                }
                if (!(ALMOST_ONE.equals(reader.getProperty("checkFruizioneServizioApplicativo").trim()) || CostantiRegistroServizi.ABILITATO.equals(reader.getProperty("checkFruizioneServizioApplicativo").trim()) || CostantiRegistroServizi.DISABILITATO.equals(reader.getProperty("checkFruizioneServizioApplicativo").trim()))) {
                    throw new Exception("Proprieta' 'checkFruizioneServizioApplicativo' non possiede un valore valido");
                }
                checkFruizioneServizioApplicativo = reader.getProperty("checkFruizioneServizioApplicativo").trim();
                if (reader.getProperty("checkFruizionePerRuolo") == null) {
                    throw new Exception("Proprieta' 'checkFruizionePerRuolo' non fornita");
                }
                if (!(ALMOST_ONE.equals(reader.getProperty("checkFruizionePerRuolo").trim()) || CostantiRegistroServizi.ABILITATO.equals(reader.getProperty("checkFruizionePerRuolo").trim()) || CostantiRegistroServizi.DISABILITATO.equals(reader.getProperty("checkFruizionePerRuolo").trim()))) {
                    throw new Exception("Proprieta' 'checkFruizionePerRuolo' non possiede un valore valido");
                }
                checkFruizionePerRuolo = reader.getProperty("checkFruizionePerRuolo").trim();
                initialized = true;
            }
            catch (Exception e) {
                Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
                if (log == null) {
                    log = Logger.getLogger(AutorizzazionePdDConsole.class);
                }
                log.error((Object)("Errore durante l'istanziazione della classe autorizzazionePdDConsole: " + e.getMessage()), (Throwable)e);
            }
            finally {
                try {
                    properties.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static DataSource getDataSource() throws Exception {
        if (!initialized) {
            AutorizzazionePdDConsole.initRisorse();
        }
        if (!initialized) {
            throw new Exception("DataSource non disponibile");
        }
        return dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public EsitoAutorizzazioneCooperazione process(DatiInvocazionePortaApplicativa datiInvocazione) {
        EsitoAutorizzazioneCooperazione esito = new EsitoAutorizzazioneCooperazione();
        Connection connectionDB = null;
        Statement pstmt = null;
        ResultSet rs = null;
        String query = null;
        Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        if (log == null) {
            log = Logger.getLogger(AutorizzazionePdDConsole.class);
        }
        try {
            IDSoggetto idSoggetto = datiInvocazione.getIdSoggettoFruitore();
            IDServizio idServizio = datiInvocazione.getIdServizio();
            Credenziali credenzialiPdDMittente = datiInvocazione.getCredenzialiPdDMittente();
            String identitaServizioApplicativoFruitore = null;
            if (datiInvocazione.getIdentitaServizioApplicativoFruitore() != null) {
                identitaServizioApplicativoFruitore = datiInvocazione.getIdentitaServizioApplicativoFruitore().getNome();
            }
            String subjectServizioApplicativoFruitoreFromMessageSecurityHeader = datiInvocazione.getSubjectServizioApplicativoFruitoreFromMessageSecurityHeader();
            if (idSoggetto == null) throw new Exception("Dati soggetto fruitore non forniti");
            if (idSoggetto.getTipo() == null) throw new Exception("Dati soggetto fruitore non forniti");
            if (idSoggetto.getNome() == null) {
                throw new Exception("Dati soggetto fruitore non forniti");
            }
            if (idServizio == null) throw new Exception("Dati servizio non forniti");
            if (idServizio.getTipoServizio() == null) throw new Exception("Dati servizio non forniti");
            if (idServizio.getServizio() == null) {
                throw new Exception("Dati servizio non forniti");
            }
            if (idServizio.getSoggettoErogatore() == null) throw new Exception("Dati soggetto erogatore non forniti");
            if (idServizio.getSoggettoErogatore().getTipo() == null) throw new Exception("Dati soggetto erogatore non forniti");
            if (idServizio.getSoggettoErogatore().getNome() == null) {
                throw new Exception("Dati soggetto erogatore non forniti");
            }
            connectionDB = AutorizzazionePdDConsole.getDataSource().getConnection();
            if (connectionDB == null) {
                throw new Exception("Connessione al Database non disponibile");
            }
            query = "select pdd.tipo FROM pdd,soggetti where soggetti.server=pdd.nome AND soggetti.tipo_soggetto=? AND soggetti.nome_soggetto=?";
            pstmt = connectionDB.prepareStatement(query);
            pstmt.setString(1, idSoggetto.getTipo());
            pstmt.setString(2, idSoggetto.getNome());
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                rs.close();
                pstmt.close();
                String errore = "Il soggetto " + idSoggetto.getTipo() + "/" + idSoggetto.getNome() + " non appartiene a nessuna Porta di Dominio??? Non e' autorizzato ad invocare il servizio " + idServizio.getTipoServizio() + "/" + idServizio.getServizio() + " erogato da " + idServizio.getSoggettoErogatore().getTipo() + "/" + idServizio.getSoggettoErogatore().getNome();
                esito.setErroreCooperazione(ErroriCooperazione.AUTORIZZAZIONE_FALLITA.getErroreAutorizzazione(errore, CodiceErroreCooperazione.SICUREZZA_AUTORIZZAZIONE_FALLITA));
                esito.setServizioAutorizzato(false);
                EsitoAutorizzazioneCooperazione esitoAutorizzazioneCooperazione = esito;
                return esitoAutorizzazioneCooperazione;
            }
            String tipoPdd = rs.getString("tipo");
            boolean pddEsterna = false;
            if ("esterno".equals(tipoPdd)) {
                pddEsterna = true;
            }
            log.debug((Object)("Soggetto fruitore " + idSoggetto.toString() + " appartiene ad una pdd di tipo [" + tipoPdd + "]"));
            rs.close();
            pstmt.close();
            if (CostantiRegistroServizi.ABILITATO.equals(checkPdd) && credenzialiPdDMittente != null) {
                String pdd = null;
                if (credenzialiPdDMittente != null && credenzialiPdDMittente.getSubject() != null) {
                    pdd = credenzialiPdDMittente.getSubject();
                }
                Hashtable hashSubject = Utilities.getSubjectIntoHashtable(pdd);
                query = "select * from pdd,soggetti where soggetti.server=pdd.nome and soggetti.tipo_soggetto=? and soggetti.nome_soggetto=?";
                Enumeration keys = hashSubject.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    String value = (String)hashSubject.get(key);
                    String ricerca = "/" + Utilities.formatKeySubject((String)key) + "=" + Utilities.formatValueSubject((String)value) + "/";
                    query = query + " and " + "pdd" + ".subject like '%" + ricerca + "%'";
                }
                pstmt = connectionDB.prepareStatement(query);
                pstmt.setString(1, idSoggetto.getTipo());
                pstmt.setString(2, idSoggetto.getNome());
                rs = pstmt.executeQuery();
                boolean match = false;
                while (rs.next()) {
                    String subjectPotenziale = rs.getString("subject");
                    if (!Utilities.sslVerify((String)subjectPotenziale, (String)pdd)) continue;
                    match = true;
                    break;
                }
                if (!match) {
                    rs.close();
                    pstmt.close();
                    String errore = "Il soggetto " + idSoggetto.getTipo() + "/" + idSoggetto.getNome() + " non appartiene alla Porta di Dominio con subject [" + pdd + "], quindi non e' autorizzato ad invocare il servizio " + idServizio.getTipoServizio() + "/" + idServizio.getServizio() + " erogato da " + idServizio.getSoggettoErogatore().getTipo() + "/" + idServizio.getSoggettoErogatore().getNome();
                    esito.setErroreCooperazione(ErroriCooperazione.AUTORIZZAZIONE_FALLITA.getErroreAutorizzazione(errore, CodiceErroreCooperazione.SICUREZZA_FALSIFICAZIONE_MITTENTE));
                    esito.setServizioAutorizzato(false);
                    EsitoAutorizzazioneCooperazione esitoAutorizzazioneCooperazione = esito;
                    return esitoAutorizzazioneCooperazione;
                }
                rs.close();
                pstmt.close();
            }
            boolean autorizzato = false;
            if (CostantiRegistroServizi.ABILITATO.equals(checkFruizioneServizioApplicativo) || ALMOST_ONE.equals(checkFruizioneServizioApplicativo)) {
                query = "select * from politiche_sicurezza,soggetti,servizi_applicativi where politiche_sicurezza.id_fruitore=soggetti.id AND soggetti.tipo_soggetto=? AND soggetti.nome_soggetto=? AND servizi_applicativi.id_soggetto=soggetti.id AND politiche_sicurezza.id_servizio_applicativo=servizi_applicativi.id AND politiche_sicurezza.id_servizio in ( select servizi.id from servizi,soggetti where servizi.tipo_servizio=? AND servizi.nome_servizio=? AND servizi.id_soggetto=soggetti.id AND soggetti.tipo_soggetto=? AND soggetti.nome_soggetto=? )";
                boolean checkFallitoPerMancanzaIdentitaServizioApplicativo = false;
                if (!pddEsterna && CostantiRegistroServizi.ABILITATO.equals(checkFruizioneServizioApplicativo)) {
                    if (identitaServizioApplicativoFruitore != null && subjectServizioApplicativoFruitoreFromMessageSecurityHeader != null) {
                        query = query + " AND ( (" + "servizi_applicativi" + ".nome=?) OR (" + "servizi_applicativi" + ".subject=?))";
                    } else if (identitaServizioApplicativoFruitore != null) {
                        query = query + " AND " + "servizi_applicativi" + ".nome=?";
                    } else if (subjectServizioApplicativoFruitoreFromMessageSecurityHeader != null) {
                        query = query + " AND " + "servizi_applicativi" + ".subject=?";
                    } else {
                        log.debug((Object)("CheckFruizioneServizioApplicativo (sa non fornito) [" + checkFruizioneServizioApplicativo + "] QUERY[" + query + "] SA(" + identitaServizioApplicativoFruitore + ") MessageSecuritySubject(" + subjectServizioApplicativoFruitoreFromMessageSecurityHeader + "). Il soggetto " + idSoggetto.getTipo() + "/" + idSoggetto.getNome() + " non e' autorizzato ad invocare" + "il servizio " + idServizio.getTipoServizio() + "/" + idServizio.getServizio() + " erogato da " + idServizio.getSoggettoErogatore().getTipo() + "/" + idServizio.getSoggettoErogatore().getNome() + "."));
                        checkFallitoPerMancanzaIdentitaServizioApplicativo = true;
                    }
                }
                if (!checkFallitoPerMancanzaIdentitaServizioApplicativo) {
                    pstmt = connectionDB.prepareStatement(query);
                    pstmt.setString(1, idSoggetto.getTipo());
                    pstmt.setString(2, idSoggetto.getNome());
                    pstmt.setString(3, idServizio.getTipoServizio());
                    pstmt.setString(4, idServizio.getServizio());
                    pstmt.setString(5, idServizio.getSoggettoErogatore().getTipo());
                    pstmt.setString(6, idServizio.getSoggettoErogatore().getNome());
                    if (!pddEsterna && CostantiRegistroServizi.ABILITATO.equals(checkFruizioneServizioApplicativo)) {
                        if (identitaServizioApplicativoFruitore != null && subjectServizioApplicativoFruitoreFromMessageSecurityHeader != null) {
                            pstmt.setString(7, identitaServizioApplicativoFruitore);
                            pstmt.setString(8, subjectServizioApplicativoFruitoreFromMessageSecurityHeader);
                        } else if (identitaServizioApplicativoFruitore != null) {
                            pstmt.setString(7, identitaServizioApplicativoFruitore);
                        } else if (subjectServizioApplicativoFruitoreFromMessageSecurityHeader != null) {
                            pstmt.setString(8, subjectServizioApplicativoFruitoreFromMessageSecurityHeader);
                        }
                    }
                    if (!(autorizzato = (rs = pstmt.executeQuery()).next())) {
                        log.debug((Object)("CheckFruizioneServizioApplicativo[" + checkFruizioneServizioApplicativo + "] QUERY[" + query + "] SA(" + identitaServizioApplicativoFruitore + ") MessageSecuritySubject(" + subjectServizioApplicativoFruitoreFromMessageSecurityHeader + "). Il soggetto " + idSoggetto.getTipo() + "/" + idSoggetto.getNome() + " non e' autorizzato ad invocare" + "il servizio " + idServizio.getTipoServizio() + "/" + idServizio.getServizio() + " erogato da " + idServizio.getSoggettoErogatore().getTipo() + "/" + idServizio.getSoggettoErogatore().getNome() + "."));
                    }
                    rs.close();
                    pstmt.close();
                }
            }
            if (!autorizzato && (CostantiRegistroServizi.ABILITATO.equals(checkFruizionePerRuolo) || ALMOST_ONE.equals(checkFruizionePerRuolo))) {
                boolean isCorrelato = false;
                query = "select servizio_correlato from servizi,soggetti where servizi.tipo_servizio=? AND servizi.nome_servizio=? AND servizi.id_soggetto=soggetti.id AND soggetti.tipo_soggetto=? AND soggetti.nome_soggetto=?";
                pstmt = connectionDB.prepareStatement(query);
                pstmt.setString(1, idServizio.getTipoServizio());
                pstmt.setString(2, idServizio.getServizio());
                pstmt.setString(3, idServizio.getSoggettoErogatore().getTipo());
                pstmt.setString(4, idServizio.getSoggettoErogatore().getNome());
                rs = pstmt.executeQuery();
                if (!rs.next()) {
                    log.debug((Object)("CheckFruizionePerRuolo[" + checkFruizionePerRuolo + "] QUERY[" + query + "]. " + "Il soggetto " + idSoggetto.getTipo() + "/" + idSoggetto.getNome() + " cerca di usufruire di un servizio non esistente: " + idServizio.getTipoServizio() + "/" + idServizio.getServizio() + " erogato da " + idServizio.getSoggettoErogatore().getTipo() + "/" + idServizio.getSoggettoErogatore().getNome() + "."));
                    rs.close();
                    pstmt.close();
                    String errore = "Il soggetto " + idSoggetto.getTipo() + "/" + idSoggetto.getNome() + " cerca di usufruire di un servizio non esistente: " + idServizio.getTipoServizio() + "/" + idServizio.getServizio() + " erogato da " + idServizio.getSoggettoErogatore().getTipo() + "/" + idServizio.getSoggettoErogatore().getNome() + ".";
                    esito.setErroreCooperazione(ErroriCooperazione.AUTORIZZAZIONE_FALLITA.getErroreAutorizzazione(errore, CodiceErroreCooperazione.SICUREZZA_AUTORIZZAZIONE_FALLITA));
                    esito.setServizioAutorizzato(false);
                    EsitoAutorizzazioneCooperazione esitoAutorizzazioneCooperazione = esito;
                    return esitoAutorizzazioneCooperazione;
                }
                isCorrelato = CostantiRegistroServizi.ABILITATO.equals(rs.getString("servizio_correlato"));
                rs.close();
                pstmt.close();
                query = "select * from accordi,servizi,soggetti,servizi_applicativi,ruoli_sa where ruoli_sa.id_accordo=accordi.id AND accordi.id=servizi.id_accordo AND accordi.nome = servizi.nome_servizio AND servizi.tipo_servizio=? AND servizi.nome_servizio=? AND servizi.id_soggetto=soggetti.id AND soggetti.tipo_soggetto=? AND soggetti.nome_soggetto=? AND servizi.servizio_correlato=? AND ruoli_sa.servizio_correlato=? AND ruoli_sa.id_servizio_applicativo=servizi_applicativi.id";
                boolean checkFallitoPerMancanzaIdentitaServizioApplicativo = false;
                if (!pddEsterna && CostantiRegistroServizi.ABILITATO.equals(checkFruizionePerRuolo)) {
                    if (identitaServizioApplicativoFruitore != null && subjectServizioApplicativoFruitoreFromMessageSecurityHeader != null) {
                        query = query + " AND " + "( (" + "servizi_applicativi" + ".nome=?) OR (" + "servizi_applicativi" + ".subject=?)) AND" + "servizi_applicativi" + ".id_soggetto in ( select id from " + "soggetti" + " where tipo_soggetto=? AND nome_soggetto=? )";
                    } else if (identitaServizioApplicativoFruitore != null) {
                        query = query + " AND " + "servizi_applicativi" + ".nome=? AND " + "servizi_applicativi" + ".id_soggetto in ( select id from " + "soggetti" + " where tipo_soggetto=? AND nome_soggetto=? )";
                    } else if (subjectServizioApplicativoFruitoreFromMessageSecurityHeader != null) {
                        query = query + " AND " + "servizi_applicativi" + ".subject=? AND " + "servizi_applicativi" + ".id_soggetto in ( select id from " + "soggetti" + " where tipo_soggetto=? AND nome_soggetto=? )";
                    } else {
                        log.debug((Object)("CheckFruizionePerRuolo (sa non fornito) [" + checkFruizionePerRuolo + "] QUERY[" + query + "] SA(" + identitaServizioApplicativoFruitore + ") MessageSecuritySubject(" + subjectServizioApplicativoFruitoreFromMessageSecurityHeader + "). Il soggetto " + idSoggetto.getTipo() + "/" + idSoggetto.getNome() + " non e' autorizzato ad invocare" + "il servizio " + idServizio.getTipoServizio() + "/" + idServizio.getServizio() + " erogato da " + idServizio.getSoggettoErogatore().getTipo() + "/" + idServizio.getSoggettoErogatore().getNome() + "."));
                        checkFallitoPerMancanzaIdentitaServizioApplicativo = true;
                    }
                }
                if (!checkFallitoPerMancanzaIdentitaServizioApplicativo) {
                    pstmt = connectionDB.prepareStatement(query);
                    pstmt.setString(1, idServizio.getTipoServizio());
                    pstmt.setString(2, idServizio.getServizio());
                    pstmt.setString(3, idServizio.getSoggettoErogatore().getTipo());
                    pstmt.setString(4, idServizio.getSoggettoErogatore().getNome());
                    if (isCorrelato) {
                        pstmt.setString(5, CostantiRegistroServizi.ABILITATO.toString());
                    } else {
                        pstmt.setString(5, CostantiRegistroServizi.DISABILITATO.toString());
                    }
                    if (isCorrelato) {
                        pstmt.setInt(6, 1);
                    } else {
                        pstmt.setInt(6, 0);
                    }
                    if (!pddEsterna && CostantiRegistroServizi.ABILITATO.equals(checkFruizionePerRuolo)) {
                        if (identitaServizioApplicativoFruitore != null && subjectServizioApplicativoFruitoreFromMessageSecurityHeader != null) {
                            pstmt.setString(7, identitaServizioApplicativoFruitore);
                            pstmt.setString(8, subjectServizioApplicativoFruitoreFromMessageSecurityHeader);
                            pstmt.setString(9, idSoggetto.getTipo());
                            pstmt.setString(10, idSoggetto.getNome());
                        } else if (identitaServizioApplicativoFruitore != null) {
                            pstmt.setString(7, identitaServizioApplicativoFruitore);
                            pstmt.setString(8, idSoggetto.getTipo());
                            pstmt.setString(9, idSoggetto.getNome());
                        } else if (subjectServizioApplicativoFruitoreFromMessageSecurityHeader != null) {
                            pstmt.setString(7, subjectServizioApplicativoFruitoreFromMessageSecurityHeader);
                            pstmt.setString(8, idSoggetto.getTipo());
                            pstmt.setString(9, idSoggetto.getNome());
                        }
                    }
                    rs = pstmt.executeQuery();
                    autorizzato = rs.next();
                    log.debug((Object)("CheckFruizionePerRuolo[" + checkFruizionePerRuolo + "] QUERY[" + query + "] SA(" + identitaServizioApplicativoFruitore + ") MessageSecuritySubject(" + subjectServizioApplicativoFruitoreFromMessageSecurityHeader + "). Il soggetto " + idSoggetto.getTipo() + "/" + idSoggetto.getNome() + " non e' autorizzato ad invocare" + "il servizio " + idServizio.getTipoServizio() + "/" + idServizio.getServizio() + " erogato da " + idServizio.getSoggettoErogatore().getTipo() + "/" + idServizio.getSoggettoErogatore().getNome() + "."));
                    rs.close();
                    pstmt.close();
                }
            }
            if (!autorizzato) {
                String servizioApplicativoMsg = "";
                if (!pddEsterna && (CostantiRegistroServizi.ABILITATO.equals(checkFruizioneServizioApplicativo) || CostantiRegistroServizi.ABILITATO.equals(checkFruizionePerRuolo))) {
                    servizioApplicativoMsg = identitaServizioApplicativoFruitore != null && subjectServizioApplicativoFruitoreFromMessageSecurityHeader != null ? "servizio applicativo [" + identitaServizioApplicativoFruitore + "] (subject-messageSecurity [" + subjectServizioApplicativoFruitoreFromMessageSecurityHeader + "]) del " : (identitaServizioApplicativoFruitore != null ? "servizio applicativo [" + identitaServizioApplicativoFruitore + "] del " : (subjectServizioApplicativoFruitoreFromMessageSecurityHeader != null ? "servizio applicativo (subject-messageSecurity [" + identitaServizioApplicativoFruitore + "]) del " : "servizio applicativo ANONIMO (ne identita' ne subject-messageSecurity fornito) del "));
                }
                String errore = "Il " + servizioApplicativoMsg + "soggetto " + idSoggetto.getTipo() + "/" + idSoggetto.getNome() + " non e' autorizzato ad invocare il servizio " + idServizio.getTipoServizio() + "/" + idServizio.getServizio() + " erogato da " + idServizio.getSoggettoErogatore().getTipo() + "/" + idServizio.getSoggettoErogatore().getNome();
                esito.setErroreCooperazione(ErroriCooperazione.AUTORIZZAZIONE_FALLITA.getErroreAutorizzazione(errore, CodiceErroreCooperazione.SICUREZZA_AUTORIZZAZIONE_FALLITA));
                esito.setServizioAutorizzato(false);
                return esito;
            }
            esito.setServizioAutorizzato(true);
            return esito;
        }
        catch (Exception e) {
            log.error((Object)("Errore durante il processo di autorizzazione PdDConsole query[" + query + "]"), (Throwable)e);
            String errore = "Errore durante il processo di autorizzazione PdDConsole: " + e.getMessage();
            esito.setErroreCooperazione(ErroriCooperazione.AUTORIZZAZIONE_FALLITA.getErroreAutorizzazione(errore, CodiceErroreCooperazione.SICUREZZA));
            esito.setServizioAutorizzato(false);
            esito.setEccezioneProcessamento(e);
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception eClose) {
                // empty catch block
            }
            try {
                if (pstmt == null) return esito;
                pstmt.close();
                return esito;
            }
            catch (Exception eClose) {
                // empty catch block
                return esito;
            }
        }
        finally {
            try {
                if (connectionDB != null) {
                    connectionDB.close();
                }
            }
            catch (Exception eClose) {}
        }
    }

    @Override
    public boolean saveAuthorizationResultInCache() {
        return true;
    }
}

