/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.autorizzazione.pa;

import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.pdd.core.AbstractCore;
import org.openspcoop2.pdd.core.autorizzazione.AutorizzazioneException;
import org.openspcoop2.pdd.core.autorizzazione.pa.DatiInvocazionePortaApplicativa;
import org.openspcoop2.pdd.core.autorizzazione.pa.EsitoAutorizzazioneCooperazione;
import org.openspcoop2.pdd.core.autorizzazione.pa.IAutorizzazioneContenutoPortaApplicativa;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.ErroriCooperazione;
import org.w3c.dom.Node;

public class AutorizzazioneContenutoBusteKO
extends AbstractCore
implements IAutorizzazioneContenutoPortaApplicativa {
    @Override
    public EsitoAutorizzazioneCooperazione process(DatiInvocazionePortaApplicativa datiInvocazione, OpenSPCoop2Message msg) throws AutorizzazioneException {
        EsitoAutorizzazioneCooperazione esito = new EsitoAutorizzazioneCooperazione();
        try {
            byte[] msgBytes = OpenSPCoop2MessageFactory.getMessageFactory().createMessage(msg.getVersioneSoap()).getAsByte((Node)msg.getSOAPBody(), true);
            System.out.println("(TestKO) Messaggio ricevuto (Ruolo busta: " + datiInvocazione.getRuoloBusta().toString() + "): " + new String(msgBytes));
            IDSoggetto soggettoFruitore = datiInvocazione.getIdSoggettoFruitore();
            IDServizio servizio = datiInvocazione.getIdServizio();
            String errore = "Il soggetto " + soggettoFruitore.getTipo() + "/" + soggettoFruitore.getNome() + " non e' autorizzato ad invocare il servizio " + servizio.getTipoServizio() + "/" + servizio.getServizio() + " erogato da " + servizio.getSoggettoErogatore().getTipo() + "/" + servizio.getSoggettoErogatore().getNome() + " con il contenuto applicativo fornito";
            esito.setErroreCooperazione(ErroriCooperazione.AUTORIZZAZIONE_FALLITA.getErroreAutorizzazione(errore, CodiceErroreCooperazione.SICUREZZA_AUTORIZZAZIONE_FALLITA));
            esito.setServizioAutorizzato(false);
            return esito;
        }
        catch (Exception e) {
            esito.setEccezioneProcessamento(e);
            OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error((Object)"Autorizzazione per contenuto non riuscita", (Throwable)e);
            throw new AutorizzazioneException("Errore di processamento durante l'autorizzazione per contenuto buste: " + e.getMessage(), e);
        }
    }
}

