/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.autorizzazione.pa;

import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziServizioNotFound;
import org.openspcoop2.pdd.core.AbstractCore;
import org.openspcoop2.pdd.core.autenticazione.Credenziali;
import org.openspcoop2.pdd.core.autorizzazione.pa.DatiInvocazionePortaApplicativa;
import org.openspcoop2.pdd.core.autorizzazione.pa.EsitoAutorizzazioneCooperazione;
import org.openspcoop2.pdd.core.autorizzazione.pa.IAutorizzazionePortaApplicativa;
import org.openspcoop2.protocol.registry.EsitoAutorizzazioneRegistro;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.ErroriCooperazione;
import org.openspcoop2.protocol.sdk.state.IState;

public class AutorizzazioneBusteRegistro
extends AbstractCore
implements IAutorizzazionePortaApplicativa {
    @Override
    public EsitoAutorizzazioneCooperazione process(DatiInvocazionePortaApplicativa datiInvocazione) {
        EsitoAutorizzazioneCooperazione esito = new EsitoAutorizzazioneCooperazione();
        try {
            IDServizio idServizio;
            IDSoggetto idSoggetto;
            EsitoAutorizzazioneRegistro esitoAutorizzazione;
            RegistroServiziManager reg = RegistroServiziManager.getInstance((IState[])new IState[]{datiInvocazione.getState()});
            Credenziali credenzialiPdDMittente = datiInvocazione.getCredenzialiPdDMittente();
            String pdd = null;
            if (credenzialiPdDMittente != null && credenzialiPdDMittente.getSubject() != null) {
                pdd = credenzialiPdDMittente.getSubject();
            }
            String identitaServizioApplicativoFruitore = null;
            if (datiInvocazione.getIdentitaServizioApplicativoFruitore() != null) {
                identitaServizioApplicativoFruitore = datiInvocazione.getIdentitaServizioApplicativoFruitore().getNome();
            }
            if (!(esitoAutorizzazione = reg.isFruitoreServizioAutorizzato(pdd, identitaServizioApplicativoFruitore, idSoggetto = datiInvocazione.getIdSoggettoFruitore(), idServizio = datiInvocazione.getIdServizio())).isServizioAutorizzato()) {
                String errore = "Il soggetto " + idSoggetto.getTipo() + "/" + idSoggetto.getNome() + " non e' autorizzato ad invocare il servizio " + idServizio.getTipoServizio() + "/" + idServizio.getServizio() + " erogato da " + idServizio.getSoggettoErogatore().getTipo() + "/" + idServizio.getSoggettoErogatore().getNome();
                if (esitoAutorizzazione.getDetails() != null) {
                    errore = errore + " (" + esitoAutorizzazione.getDetails() + ")";
                }
                esito.setErroreCooperazione(ErroriCooperazione.AUTORIZZAZIONE_FALLITA.getErroreAutorizzazione(errore, CodiceErroreCooperazione.SICUREZZA_AUTORIZZAZIONE_FALLITA));
                esito.setServizioAutorizzato(false);
            } else {
                esito.setServizioAutorizzato(true);
                if (esitoAutorizzazione.getDetails() != null) {
                    esito.setDetails(esitoAutorizzazione.getDetails());
                }
            }
        }
        catch (DriverRegistroServiziServizioNotFound e) {
            esito.setErroreCooperazione(ErroriCooperazione.SERVIZIO_SCONOSCIUTO.getErroreCooperazione("Errore durante il processo di autorizzazione (ServizioNotFound): " + e.getMessage()));
            esito.setServizioAutorizzato(false);
            esito.setEccezioneProcessamento((Exception)((Object)e));
        }
        catch (Exception e) {
            String errore = "Errore durante il processo di autorizzazione: " + e.getMessage();
            esito.setErroreCooperazione(ErroriCooperazione.AUTORIZZAZIONE_FALLITA.getErroreAutorizzazione(errore, CodiceErroreCooperazione.SICUREZZA));
            esito.setServizioAutorizzato(false);
            esito.setEccezioneProcessamento(e);
        }
        return esito;
    }

    @Override
    public boolean saveAuthorizationResultInCache() {
        return true;
    }
}

