/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.autorizzazione;

import java.io.Serializable;
import org.apache.log4j.Logger;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.pdd.config.ClassNameProperties;
import org.openspcoop2.pdd.core.AbstractCore;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.autorizzazione.AutorizzazioneException;
import org.openspcoop2.pdd.core.autorizzazione.pa.DatiInvocazionePortaApplicativa;
import org.openspcoop2.pdd.core.autorizzazione.pa.EsitoAutorizzazioneCooperazione;
import org.openspcoop2.pdd.core.autorizzazione.pa.IAutorizzazionePortaApplicativa;
import org.openspcoop2.pdd.core.autorizzazione.pd.DatiInvocazionePortaDelegata;
import org.openspcoop2.pdd.core.autorizzazione.pd.EsitoAutorizzazioneIntegrazione;
import org.openspcoop2.pdd.core.autorizzazione.pd.IAutorizzazionePortaDelegata;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.RuoloBusta;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.cache.Cache;
import org.openspcoop2.utils.cache.CacheAlgorithm;
import org.openspcoop2.utils.cache.CacheResponse;
import org.openspcoop2.utils.resources.Loader;

public class GestoreAutorizzazione {
    private static final String AUTORIZZAZIONE_CACHE_NAME = "autorizzazione";
    private static Cache cacheAutorizzazione = null;
    private static Logger logger = null;
    private static Logger logConsole = OpenSPCoop2Logger.getLoggerOpenSPCoopConsole();
    private static ClassNameProperties className = ClassNameProperties.getInstance();

    public static void resetCache() throws AutorizzazioneException {
        if (cacheAutorizzazione != null) {
            try {
                cacheAutorizzazione.clear();
            }
            catch (Exception e) {
                throw new AutorizzazioneException(e.getMessage(), e);
            }
        }
    }

    public static String printStatsCache(String separator) throws AutorizzazioneException {
        try {
            if (cacheAutorizzazione != null) {
                return cacheAutorizzazione.printStats(separator);
            }
            throw new Exception("Cache non abilitata");
        }
        catch (Exception e) {
            throw new AutorizzazioneException("Visualizzazione Statistiche riguardante la cache delle autorizzazioni della Porta di Dominio non riuscita: " + e.getMessage(), e);
        }
    }

    public static void abilitaCache() throws AutorizzazioneException {
        if (cacheAutorizzazione != null) {
            throw new AutorizzazioneException("Cache gia' abilitata");
        }
        try {
            cacheAutorizzazione = new Cache(AUTORIZZAZIONE_CACHE_NAME);
        }
        catch (Exception e) {
            throw new AutorizzazioneException(e.getMessage(), e);
        }
    }

    public static void abilitaCache(Long dimensioneCache, Boolean algoritmoCacheLRU, Long itemIdleTime, Long itemLifeSecond) throws AutorizzazioneException {
        if (cacheAutorizzazione != null) {
            throw new AutorizzazioneException("Cache gia' abilitata");
        }
        try {
            int dimensioneCacheInt = -1;
            if (dimensioneCache != null) {
                dimensioneCacheInt = dimensioneCache.intValue();
            }
            String algoritmoCache = null;
            algoritmoCache = algoritmoCacheLRU != null ? (algoritmoCacheLRU.booleanValue() ? CostantiConfigurazione.CACHE_LRU.toString() : CostantiConfigurazione.CACHE_MRU.toString()) : CostantiConfigurazione.CACHE_LRU.toString();
            long itemIdleTimeLong = -1L;
            if (itemIdleTime != null) {
                itemIdleTimeLong = itemIdleTime;
            }
            long itemLifeSecondLong = -1L;
            if (itemLifeSecond != null) {
                itemLifeSecondLong = itemLifeSecond;
            }
            GestoreAutorizzazione.initCacheAutorizzazione(dimensioneCacheInt, algoritmoCache, itemIdleTimeLong, itemLifeSecondLong, null);
        }
        catch (Exception e) {
            throw new AutorizzazioneException(e.getMessage(), e);
        }
    }

    public static void disabilitaCache() throws AutorizzazioneException {
        if (cacheAutorizzazione == null) {
            throw new AutorizzazioneException("Cache gia' disabilitata");
        }
        try {
            cacheAutorizzazione.clear();
            cacheAutorizzazione = null;
        }
        catch (Exception e) {
            throw new AutorizzazioneException(e.getMessage(), e);
        }
    }

    public static boolean isCacheAbilitata() {
        return cacheAutorizzazione != null;
    }

    public static String listKeysCache(String separator) throws AutorizzazioneException {
        if (cacheAutorizzazione != null) {
            try {
                return cacheAutorizzazione.printKeys(separator);
            }
            catch (Exception e) {
                throw new AutorizzazioneException(e.getMessage(), e);
            }
        }
        throw new AutorizzazioneException("Cache non abilitata");
    }

    public static String getObjectCache(String key) throws AutorizzazioneException {
        if (cacheAutorizzazione != null) {
            try {
                Object o = cacheAutorizzazione.get(key);
                if (o != null) {
                    return o.toString();
                }
                return "oggetto con chiave [" + key + "] non presente";
            }
            catch (Exception e) {
                throw new AutorizzazioneException(e.getMessage(), e);
            }
        }
        throw new AutorizzazioneException("Cache non abilitata");
    }

    public static void removeObjectCache(String key) throws AutorizzazioneException {
        if (cacheAutorizzazione != null) {
            try {
                cacheAutorizzazione.remove(key);
            }
            catch (Exception e) {
                throw new AutorizzazioneException(e.getMessage(), e);
            }
        } else {
            throw new AutorizzazioneException("Cache non abilitata");
        }
    }

    public static void initialize(Logger log) throws Exception {
        GestoreAutorizzazione.initialize(false, -1, null, -1L, -1L, log);
    }

    public static void initialize(int dimensioneCache, String algoritmoCache, long idleTime, long itemLifeSecond, Logger log) throws Exception {
        GestoreAutorizzazione.initialize(true, dimensioneCache, algoritmoCache, idleTime, itemLifeSecond, log);
    }

    private static void initialize(boolean cacheAbilitata, int dimensioneCache, String algoritmoCache, long idleTime, long itemLifeSecond, Logger log) throws Exception {
        logger = log;
        if (cacheAbilitata) {
            GestoreAutorizzazione.initCacheAutorizzazione(dimensioneCache, algoritmoCache, idleTime, itemLifeSecond, log);
        }
    }

    public static void initCacheAutorizzazione(int dimensioneCache, String algoritmoCache, long idleTime, long itemLifeSecond, Logger log) throws Exception {
        String msg;
        if (log != null) {
            log.info((Object)"Inizializzazione cache Autorizzazione Buste");
        }
        cacheAutorizzazione = new Cache(AUTORIZZAZIONE_CACHE_NAME);
        if (dimensioneCache > 0 || algoritmoCache != null) {
            if (dimensioneCache > 0) {
                try {
                    msg = "Dimensione della cache (Autorizzazione Buste) impostata al valore: " + dimensioneCache;
                    if (log != null) {
                        log.info((Object)msg);
                    }
                    logConsole.info((Object)msg);
                    cacheAutorizzazione.setCacheSize(dimensioneCache);
                }
                catch (Exception error) {
                    throw new AutorizzazioneException("Parametro errato per la dimensione della cache (Gestore Messaggi): " + error.getMessage(), error);
                }
            }
            if (algoritmoCache != null) {
                msg = "Algoritmo di cache (Autorizzazione Buste) impostato al valore: " + algoritmoCache;
                if (log != null) {
                    log.info((Object)msg);
                }
                logConsole.info((Object)msg);
                if (CostantiConfigurazione.CACHE_MRU.toString().equalsIgnoreCase(algoritmoCache)) {
                    cacheAutorizzazione.setCacheAlgoritm(CacheAlgorithm.MRU);
                } else {
                    cacheAutorizzazione.setCacheAlgoritm(CacheAlgorithm.LRU);
                }
            }
        }
        if (idleTime > 0L || itemLifeSecond > 0L) {
            if (idleTime > 0L) {
                try {
                    msg = "Attributo 'IdleTime' (Autorizzazione Buste) impostato al valore: " + idleTime;
                    if (log != null) {
                        log.info((Object)msg);
                    }
                    logConsole.info((Object)msg);
                    cacheAutorizzazione.setItemIdleTime(idleTime);
                }
                catch (Exception error) {
                    throw new AutorizzazioneException("Parametro errato per l'attributo 'IdleTime' (Gestore Messaggi): " + error.getMessage(), error);
                }
            }
            if (itemLifeSecond > 0L) {
                try {
                    msg = "Attributo 'MaxLifeSecond' (Autorizzazione Buste) impostato al valore: " + itemLifeSecond;
                    if (log != null) {
                        log.info((Object)msg);
                    }
                    logConsole.info((Object)msg);
                    cacheAutorizzazione.setItemLifeTime(itemLifeSecond);
                }
                catch (Exception error) {
                    throw new AutorizzazioneException("Parametro errato per l'attributo 'MaxLifeSecond' (Gestore Messaggi): " + error.getMessage(), error);
                }
            }
        }
    }

    public static EsitoAutorizzazioneIntegrazione verificaAutorizzazionePortaDelegata(String tipoAutorizzazione, DatiInvocazionePortaDelegata datiInvocazione, PdDContext pddContext, IProtocolFactory protocolFactory) throws Exception {
        GestoreAutorizzazione.checkDatiPortaDelegata(datiInvocazione);
        IAutorizzazionePortaDelegata auth = GestoreAutorizzazione.newInstanceAuthPortaDelegata(tipoAutorizzazione, pddContext, protocolFactory);
        if (cacheAutorizzazione == null || !auth.saveAuthorizationResultInCache()) {
            return auth.process(datiInvocazione);
        }
        String keyCache = GestoreAutorizzazione.buildCacheKey(true, tipoAutorizzazione, datiInvocazione.getKeyCache());
        Cache cache = cacheAutorizzazione;
        synchronized (cache) {
            CacheResponse response = (CacheResponse)cacheAutorizzazione.get(keyCache);
            if (response != null) {
                if (response.getObject() != null) {
                    logger.debug((Object)("Oggetto (tipo:" + response.getObject().getClass().getName() + ") con chiave [" + keyCache + "] (method:verificaAutorizzazionePortaDelegata) in cache."));
                    return (EsitoAutorizzazioneIntegrazione)response.getObject();
                }
                if (response.getException() != null) {
                    logger.debug((Object)("Eccezione (tipo:" + response.getException().getClass().getName() + ") con chiave [" + keyCache + "] (method:verificaAutorizzazionePortaDelegata) in cache."));
                    throw (Exception)response.getException();
                }
                logger.error((Object)"In cache non e' presente ne un oggetto ne un'eccezione.");
            }
            logger.debug((Object)("oggetto con chiave [" + keyCache + "] (method:verificaAutorizzazionePortaDelegata) ricerco nella configurazione..."));
            EsitoAutorizzazioneIntegrazione esito = auth.process(datiInvocazione);
            if (esito != null && !esito.isNoCache()) {
                if (esito.isServizioAutorizzato() || CodiceErroreIntegrazione.CODICE_404_AUTORIZZAZIONE_FALLITA.equals(esito.getErroreIntegrazione().getCodiceErrore()) || CodiceErroreIntegrazione.CODICE_401_PD_INESISTENTE.equals(esito.getErroreIntegrazione().getCodiceErrore())) {
                    logger.info((Object)("Aggiungo oggetto [" + keyCache + "] in cache"));
                    try {
                        CacheResponse responseCache = new CacheResponse();
                        responseCache.setObject((Serializable)esito);
                        cacheAutorizzazione.put(keyCache, responseCache);
                    }
                    catch (UtilsException e) {
                        logger.error((Object)("Errore durante l'inserimento in cache [" + keyCache + "]: " + e.getMessage()));
                    }
                }
                return esito;
            }
            throw new AutorizzazioneException("Metodo (GestoreAutorizzazione.autorizzazionePortaDelegata.process) ha ritornato un valore di esito null");
        }
    }

    public static EsitoAutorizzazioneCooperazione verificaAutorizzazionePortaApplicativa(String tipoAutorizzazione, DatiInvocazionePortaApplicativa datiInvocazione, PdDContext pddContext, IProtocolFactory protocolFactory) throws Exception {
        GestoreAutorizzazione.checkDatiPortaApplicativa(datiInvocazione);
        IAutorizzazionePortaApplicativa auth = GestoreAutorizzazione.newInstanceAuthPortaApplicativa(tipoAutorizzazione, pddContext, protocolFactory);
        if (cacheAutorizzazione == null || !auth.saveAuthorizationResultInCache()) {
            return auth.process(datiInvocazione);
        }
        String keyCache = GestoreAutorizzazione.buildCacheKey(false, tipoAutorizzazione, datiInvocazione.getKeyCache());
        Cache cache = cacheAutorizzazione;
        synchronized (cache) {
            CacheResponse response = (CacheResponse)cacheAutorizzazione.get(keyCache);
            if (response != null) {
                if (response.getObject() != null) {
                    logger.debug((Object)("Oggetto (tipo:" + response.getObject().getClass().getName() + ") con chiave [" + keyCache + "] (method:verificaAutorizzazionePortaApplicativa) in cache."));
                    return (EsitoAutorizzazioneCooperazione)response.getObject();
                }
                if (response.getException() != null) {
                    logger.debug((Object)("Eccezione (tipo:" + response.getException().getClass().getName() + ") con chiave [" + keyCache + "] (method:verificaAutorizzazionePortaApplicativa) in cache."));
                    throw (Exception)response.getException();
                }
                logger.error((Object)"In cache non e' presente ne un oggetto ne un'eccezione.");
            }
            logger.debug((Object)("oggetto con chiave [" + keyCache + "] (method:verificaAutorizzazionePortaApplicativa) ricerco nella configurazione..."));
            EsitoAutorizzazioneCooperazione esito = auth.process(datiInvocazione);
            if (esito != null && !esito.isNoCache()) {
                if (esito.isServizioAutorizzato() || CodiceErroreCooperazione.SICUREZZA_AUTORIZZAZIONE_FALLITA.equals(esito.getErroreCooperazione().getCodiceErrore())) {
                    logger.info((Object)("Aggiungo oggetto [" + keyCache + "] in cache"));
                    try {
                        CacheResponse responseCache = new CacheResponse();
                        responseCache.setObject((Serializable)esito);
                        cacheAutorizzazione.put(keyCache, responseCache);
                    }
                    catch (UtilsException e) {
                        logger.error((Object)("Errore durante l'inserimento in cache [" + keyCache + "]: " + e.getMessage()));
                    }
                }
                return esito;
            }
            throw new AutorizzazioneException("Metodo (GestoreAutorizzazione.autorizzazionePortaApplicativa.process) ha ritornato un valore di esito null");
        }
    }

    private static void checkDatiPortaDelegata(DatiInvocazionePortaDelegata datiInvocazione) throws AutorizzazioneException {
        IDServizio idServizio = datiInvocazione.getIdServizio();
        if (idServizio == null) {
            throw new AutorizzazioneException("(Parametri) IDServizio non definito");
        }
        if (idServizio.getTipoServizio() == null || idServizio.getServizio() == null) {
            throw new AutorizzazioneException("(Parametri) Servizio non definito");
        }
        if (idServizio.getSoggettoErogatore() == null || idServizio.getSoggettoErogatore().getTipo() == null || idServizio.getSoggettoErogatore().getNome() == null) {
            throw new AutorizzazioneException("(Parametri) Soggetto erogatore non definito");
        }
        IDPortaDelegata idPD = datiInvocazione.getIdPD();
        if (idPD == null) {
            throw new AutorizzazioneException("(Parametri) IDPortaDelegata non definito");
        }
        if (idPD.getLocationPD() == null) {
            throw new AutorizzazioneException("(Parametri) IDPortaDelegata.locationPD non definito");
        }
        IDSoggetto idSoggettoFruitore = idPD.getSoggettoFruitore();
        if (idSoggettoFruitore == null || idSoggettoFruitore.getTipo() == null || idSoggettoFruitore.getNome() == null) {
            throw new AutorizzazioneException("(Parametri) IDPortaDelegata.Soggetto non definito");
        }
        PortaDelegata pd = datiInvocazione.getPd();
        if (pd == null) {
            throw new AutorizzazioneException("(Parametri) PortaDelegata non definito");
        }
        IDServizioApplicativo idSA = datiInvocazione.getIdServizioApplicativo();
        if (idSA == null) {
            throw new AutorizzazioneException("(Parametri) IDServizioApplicativo non definito");
        }
        if (idSA.getNome() == null) {
            throw new AutorizzazioneException("(Parametri) IDServizioApplicativo.nome non definito");
        }
        IDSoggetto idSoggettoProprietario = idSA.getIdSoggettoProprietario();
        if (idSoggettoProprietario == null || idSoggettoProprietario.getTipo() == null || idSoggettoProprietario.getNome() == null) {
            throw new AutorizzazioneException("(Parametri) IDServizioApplicativo.Soggetto non definito");
        }
    }

    private static void checkDatiPortaApplicativa(DatiInvocazionePortaApplicativa datiInvocazione) throws AutorizzazioneException {
        IDServizio idServizio = datiInvocazione.getIdServizio();
        if (idServizio == null) {
            throw new AutorizzazioneException("(Parametri) IDServizio non definito");
        }
        if (idServizio.getTipoServizio() == null || idServizio.getServizio() == null) {
            throw new AutorizzazioneException("(Parametri) Servizio non definito");
        }
        if (idServizio.getSoggettoErogatore() == null || idServizio.getSoggettoErogatore().getTipo() == null || idServizio.getSoggettoErogatore().getNome() == null) {
            throw new AutorizzazioneException("(Parametri) Soggetto erogatore non definito");
        }
        IDSoggetto idSoggettoFruitore = datiInvocazione.getIdSoggettoFruitore();
        if (idSoggettoFruitore == null || idSoggettoFruitore.getTipo() == null || idSoggettoFruitore.getNome() == null) {
            throw new AutorizzazioneException("(Parametri) IDSoggettoFruitore non definito");
        }
        RuoloBusta ruolo = datiInvocazione.getRuoloBusta();
        if (ruolo == null) {
            throw new AutorizzazioneException("(Parametri) RuoloBusta non definito");
        }
    }

    private static String buildCacheKey(boolean portaDelegata, String tipoAutorizzazione, String keyCache) throws AutorizzazioneException {
        StringBuffer bf = new StringBuffer();
        if (portaDelegata) {
            bf.append("PD ");
        } else {
            bf.append("PA ");
        }
        bf.append(" Auth:").append(tipoAutorizzazione).append(" ");
        bf.append(keyCache);
        return bf.toString();
    }

    private static IAutorizzazionePortaDelegata newInstanceAuthPortaDelegata(String tipoAutorizzazione, PdDContext pddContext, IProtocolFactory protocolFactory) throws AutorizzazioneException {
        String classType = null;
        IAutorizzazionePortaDelegata auth = null;
        try {
            classType = className.getAutorizzazione(tipoAutorizzazione);
            auth = (IAutorizzazionePortaDelegata)Loader.getInstance().newInstance(classType);
            AbstractCore.init(auth, pddContext, protocolFactory, new Object[0]);
            return auth;
        }
        catch (Exception e) {
            throw new AutorizzazioneException("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per l'autorizzazione via PD: " + e.getMessage(), e);
        }
    }

    private static IAutorizzazionePortaApplicativa newInstanceAuthPortaApplicativa(String tipoAutorizzazione, PdDContext pddContext, IProtocolFactory protocolFactory) throws AutorizzazioneException {
        String classType = null;
        IAutorizzazionePortaApplicativa auth = null;
        try {
            classType = className.getAutorizzazioneBuste(tipoAutorizzazione);
            auth = (IAutorizzazionePortaApplicativa)Loader.getInstance().newInstance(classType);
            AbstractCore.init(auth, pddContext, protocolFactory, new Object[0]);
            return auth;
        }
        catch (Exception e) {
            throw new AutorizzazioneException("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per l'autorizzazione delle buste via PA: " + e.getMessage(), e);
        }
    }
}

