/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.autenticazione;

import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.core.AbstractCore;
import org.openspcoop2.pdd.core.autenticazione.Credenziali;
import org.openspcoop2.pdd.core.autenticazione.IAutenticazione;
import org.openspcoop2.pdd.core.connettori.InfoConnettoreIngresso;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.state.IState;

public class AutenticazioneSSL
extends AbstractCore
implements IAutenticazione {
    private ErroreIntegrazione errore;
    private Exception exception;
    private IDServizioApplicativo servizioApplicativo;

    @Override
    public boolean process(InfoConnettoreIngresso infoConnettoreIngresso, IDPortaDelegata idPD, IState state) {
        Credenziali credenziali = infoConnettoreIngresso.getCredenziali();
        String subject = credenziali.getSubject();
        if (subject == null) {
            this.errore = ErroriIntegrazione.ERRORE_402_AUTENTICAZIONE_FALLITA.getErrore402_AutenticazioneFallita("Credenziali non fornite");
            return false;
        }
        try {
            this.servizioApplicativo = ConfigurazionePdDManager.getInstance(state).autenticazioneHTTPS(idPD.getSoggettoFruitore(), idPD.getLocationPD(), subject);
        }
        catch (Exception e) {
            OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error((Object)"AutenticazioneSSL non riuscita", (Throwable)e);
            this.errore = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE);
            this.exception = e;
            return false;
        }
        if (this.servizioApplicativo == null) {
            this.errore = ErroriIntegrazione.ERRORE_402_AUTENTICAZIONE_FALLITA.getErrore402_AutenticazioneFallita("Credenziali fornite non corrette", subject);
            return false;
        }
        if (this.servizioApplicativo.getIdSoggettoProprietario() != null && this.servizioApplicativo.getIdSoggettoProprietario().getCodicePorta() == null) {
            try {
                this.servizioApplicativo.getIdSoggettoProprietario().setCodicePorta(RegistroServiziManager.getInstance((IState[])new IState[]{state}).getDominio(this.servizioApplicativo.getIdSoggettoProprietario(), null, this.getProtocolFactory()));
            }
            catch (Exception e) {
                OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error((Object)"AutenticazioneSSL non riuscita (Identificazione dominio del soggetto)", (Throwable)e);
                this.errore = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE);
                this.exception = e;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean process(InfoConnettoreIngresso infoConnettoreIngresso, IState state) {
        Credenziali credenziali = infoConnettoreIngresso.getCredenziali();
        String subject = credenziali.getSubject();
        if (subject == null) {
            this.errore = ErroriIntegrazione.ERRORE_402_AUTENTICAZIONE_FALLITA.getErrore402_AutenticazioneFallita("Credenziali non fornite");
            return false;
        }
        try {
            this.servizioApplicativo = ConfigurazionePdDManager.getInstance(state).autenticazioneHTTPS(subject);
        }
        catch (Exception e) {
            OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error((Object)"AutenticazioneSSL non riuscita", (Throwable)e);
            this.errore = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE);
            this.exception = e;
            return false;
        }
        if (this.servizioApplicativo == null) {
            this.errore = ErroriIntegrazione.ERRORE_402_AUTENTICAZIONE_FALLITA.getErrore402_AutenticazioneFallita("Credenziali fornite non corrette", subject);
            return false;
        }
        if (this.servizioApplicativo.getIdSoggettoProprietario() != null && this.servizioApplicativo.getIdSoggettoProprietario().getCodicePorta() == null) {
            try {
                this.servizioApplicativo.getIdSoggettoProprietario().setCodicePorta(RegistroServiziManager.getInstance((IState[])new IState[]{state}).getDominio(this.servizioApplicativo.getIdSoggettoProprietario(), null, this.getProtocolFactory()));
            }
            catch (Exception e) {
                OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error((Object)"AutenticazioneSSL non riuscita (Identificazione dominio del soggetto)", (Throwable)e);
                this.errore = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE);
                this.exception = e;
                return false;
            }
        }
        return true;
    }

    @Override
    public IDServizioApplicativo getServizioApplicativo() {
        return this.servizioApplicativo;
    }

    @Override
    public ErroreIntegrazione getErrore() {
        return this.errore;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }
}

