/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core;

import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import org.apache.log4j.Logger;
import org.openspcoop2.core.config.ValidazioneContenutiApplicativi;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.registry.constants.TipologiaServizio;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.wsdl.AccordoServizioWrapper;
import org.openspcoop2.core.registry.wsdl.WSDLValidator;
import org.openspcoop2.message.SOAPVersion;
import org.openspcoop2.message.XMLUtils;
import org.openspcoop2.pdd.core.ValidatoreMessaggiApplicativiException;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.registry.InformationWsdlSource;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.utils.wsdl.WSDLException;
import org.openspcoop2.utils.xml.AbstractXMLUtils;

public class ValidatoreMessaggiApplicativi {
    RegistroServiziManager registroServiziManager;
    IDServizio idServizio;
    SOAPVersion soapVersion;
    SOAPEnvelope envelope;
    SOAPBody body;
    AccordoServizioWrapper accordoServizioWrapper = null;
    Logger logger = null;
    XMLUtils xmlUtils = null;
    WSDLValidator wsdlValidator = null;

    public static String getTipo(ValidazioneContenutiApplicativi validazioneContenutoApplicativoApplicativo) {
        String tipo = validazioneContenutoApplicativoApplicativo.getTipo().getValue();
        if (validazioneContenutoApplicativoApplicativo.getAcceptMtomMessage() != null) {
            if (StatoFunzionalita.ABILITATO.equals(validazioneContenutoApplicativoApplicativo.getAcceptMtomMessage())) {
                tipo = tipo + "-" + "mtom/xop";
            }
            if (CostantiConfigurazione.STATO_CON_WARNING_WARNING_ONLY.equals(validazioneContenutoApplicativoApplicativo.getStato())) {
                tipo = tipo + "-" + "warningOnly";
            }
        }
        return tipo;
    }

    public boolean isServizioCorrelato() {
        try {
            return TipologiaServizio.CORRELATO.equals(this.accordoServizioWrapper.getTipologiaServizio());
        }
        catch (Exception e) {
            return false;
        }
    }

    public ValidatoreMessaggiApplicativi(RegistroServiziManager registro, IDServizio idServizio, SOAPVersion soapVersion, SOAPEnvelope envelope, boolean readWSDLAccordoServizio) throws ValidatoreMessaggiApplicativiException {
        if (registro == null) {
            ValidatoreMessaggiApplicativiException ex = new ValidatoreMessaggiApplicativiException("Reader del Registro dei Servizi non fornito");
            ex.setErrore(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_531_VALIDAZIONE_WSDL_FALLITA));
            throw ex;
        }
        if (idServizio == null || idServizio.getSoggettoErogatore() == null || idServizio.getTipoServizio() == null || idServizio.getServizio() == null || idServizio.getSoggettoErogatore().getTipo() == null || idServizio.getSoggettoErogatore().getNome() == null) {
            ValidatoreMessaggiApplicativiException ex = new ValidatoreMessaggiApplicativiException("ID del servizio da validare, non fornito");
            ex.setErrore(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_531_VALIDAZIONE_WSDL_FALLITA));
            throw ex;
        }
        if (envelope == null) {
            ValidatoreMessaggiApplicativiException ex = new ValidatoreMessaggiApplicativiException("SOAPEnvelope non esistente");
            ex.setErrore(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_531_VALIDAZIONE_WSDL_FALLITA));
            throw ex;
        }
        this.soapVersion = soapVersion;
        this.envelope = envelope;
        try {
            this.body = this.envelope.getBody();
        }
        catch (Exception e) {
            this.logger.error((Object)("SOAPEnvelope.getBody failed: " + e.getMessage()), (Throwable)e);
            ValidatoreMessaggiApplicativiException ex = new ValidatoreMessaggiApplicativiException("SOAPEnvelope senza body");
            ex.setErrore(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_531_VALIDAZIONE_WSDL_FALLITA));
            throw ex;
        }
        if (this.body == null || !this.body.hasChildNodes()) {
            ValidatoreMessaggiApplicativiException ex = new ValidatoreMessaggiApplicativiException("SOAPBody non esistente");
            ex.setErrore(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_531_VALIDAZIONE_WSDL_FALLITA));
            throw ex;
        }
        this.registroServiziManager = registro;
        this.idServizio = idServizio;
        this.logger = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        this.xmlUtils = XMLUtils.getInstance();
        try {
            this.accordoServizioWrapper = readWSDLAccordoServizio ? this.registroServiziManager.getWsdlAccordoServizio(idServizio, InformationWsdlSource.WSDL, true) : this.registroServiziManager.getWsdlAccordoServizio(idServizio, InformationWsdlSource.REGISTRY, true);
        }
        catch (DriverRegistroServiziNotFound e) {
            this.logger.error((Object)("Riscontrato errore durante la ricerca dei wsdl/xsd che definiscono l'accordo di servizio: " + e.getMessage()), (Throwable)e);
            ValidatoreMessaggiApplicativiException ex = new ValidatoreMessaggiApplicativiException("Riscontrato errore durante la ricerca del Wsdl: " + e.getMessage());
            ex.setErrore(ErroriIntegrazione.ERRORE_405_SERVIZIO_NON_TROVATO.getErroreIntegrazione());
            throw ex;
        }
        catch (DriverRegistroServiziException e) {
            this.logger.error((Object)("Riscontrato errore durante l'inizializzazione: " + e.getMessage()), (Throwable)e);
            ValidatoreMessaggiApplicativiException ex = new ValidatoreMessaggiApplicativiException("Riscontrato errore durante l'inizializzazione: " + e.getMessage());
            if (e.getMessage() != null && e.getMessage().startsWith("[SchemaXSD]")) {
                ex.setErrore(ErroriIntegrazione.ERRORE_417_COSTRUZIONE_VALIDATORE_WSDL_FALLITA.getErrore417_CostruzioneValidatoreWSDLFallita("Schema xsd dei messaggi"));
                throw ex;
            }
            if (e.getMessage() != null && e.getMessage().startsWith("[WSDL-FRUITORE]")) {
                ex.setErrore(ErroriIntegrazione.ERRORE_417_COSTRUZIONE_VALIDATORE_WSDL_FALLITA.getErrore417_CostruzioneValidatoreWSDLFallita("Wsdl fruitore"));
                throw ex;
            }
            if (e.getMessage() != null && e.getMessage().startsWith("[WSDL-EROGATORE]")) {
                ex.setErrore(ErroriIntegrazione.ERRORE_417_COSTRUZIONE_VALIDATORE_WSDL_FALLITA.getErrore417_CostruzioneValidatoreWSDLFallita("Wsdl erogatore"));
                throw ex;
            }
            ex.setErrore(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_530_COSTRUZIONE_WSDL_FALLITA));
            throw ex;
        }
        try {
            this.wsdlValidator = new WSDLValidator(this.soapVersion, this.envelope, (AbstractXMLUtils)this.xmlUtils, this.accordoServizioWrapper, this.logger);
        }
        catch (Exception e) {
            this.logger.error((Object)("WSDLValidator initialized failed: " + e.getMessage()), (Throwable)e);
            ValidatoreMessaggiApplicativiException ex = new ValidatoreMessaggiApplicativiException(e.getMessage());
            ex.setErrore(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_531_VALIDAZIONE_WSDL_FALLITA));
            throw ex;
        }
    }

    public AccordoServizioWrapper getAccordoServizioWrapper() {
        return this.accordoServizioWrapper;
    }

    public void validateWithWsdlDefinitorio(boolean isRichiesta) throws ValidatoreMessaggiApplicativiException {
        try {
            this.wsdlValidator.validateAgainstXSDSchema(isRichiesta, this.idServizio.getAzione());
        }
        catch (WSDLException e) {
            this.logger.error((Object)("WSDL validate failed: " + e.getMessage()), (Throwable)e);
            ValidatoreMessaggiApplicativiException ex = new ValidatoreMessaggiApplicativiException(e.getMessage());
            ex.setErrore(ErroriIntegrazione.ERRORE_417_COSTRUZIONE_VALIDATORE_WSDL_FALLITA.getErrore417_CostruzioneValidatoreWSDLFallita("Schema xsd dei messaggi"));
            throw ex;
        }
        catch (Exception e) {
            ValidatoreMessaggiApplicativiException ex = new ValidatoreMessaggiApplicativiException(e.getMessage());
            if (isRichiesta) {
                ex.setErrore(ErroriIntegrazione.ERRORE_418_VALIDAZIONE_WSDL_RICHIESTA_FALLITA.getErrore418_ValidazioneWSDLRichiesta("Schema xsd dei messaggi"));
            } else {
                ex.setErrore(ErroriIntegrazione.ERRORE_419_VALIDAZIONE_WSDL_RISPOSTA_FALLITA.getErrore419_ValidazioneWSDLRisposta("Schema xsd dei messaggi"));
            }
            throw ex;
        }
    }

    public void validateWithWsdlLogicoImplementativo(boolean isRichiesta, String soapAction) throws ValidatoreMessaggiApplicativiException {
        try {
            this.wsdlValidator.wsdlConformanceCheck(isRichiesta, soapAction, this.idServizio.getAzione());
        }
        catch (Exception e) {
            ValidatoreMessaggiApplicativiException ex = new ValidatoreMessaggiApplicativiException(e.getMessage());
            if (isRichiesta) {
                if (TipologiaServizio.CORRELATO.equals(this.accordoServizioWrapper.getTipologiaServizio())) {
                    ex.setErrore(ErroriIntegrazione.ERRORE_418_VALIDAZIONE_WSDL_RICHIESTA_FALLITA.getErrore418_ValidazioneWSDLRichiesta("Wsdl fruitore"));
                } else {
                    ex.setErrore(ErroriIntegrazione.ERRORE_418_VALIDAZIONE_WSDL_RICHIESTA_FALLITA.getErrore418_ValidazioneWSDLRichiesta("Wsdl erogatore"));
                }
            } else if (TipologiaServizio.CORRELATO.equals(this.accordoServizioWrapper.getTipologiaServizio())) {
                ex.setErrore(ErroriIntegrazione.ERRORE_419_VALIDAZIONE_WSDL_RISPOSTA_FALLITA.getErrore419_ValidazioneWSDLRisposta("Wsdl fruitore"));
            } else {
                ex.setErrore(ErroriIntegrazione.ERRORE_419_VALIDAZIONE_WSDL_RISPOSTA_FALLITA.getErrore419_ValidazioneWSDLRisposta("Wsdl erogatore"));
            }
            throw ex;
        }
    }
}

