/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core;

import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.Trasmissione;

public class Utilities {
    public static void refreshIdentificativiPorta(Busta busta, IDSoggetto idSoggettoDefault, RegistroServiziManager registroServiziManager, IProtocolFactory protocolFactory) {
        if (busta.getMittente() != null && busta.getTipoMittente() != null && busta.getIdentificativoPortaMittente() == null) {
            try {
                if (idSoggettoDefault.getTipo().equals(busta.getTipoMittente()) && idSoggettoDefault.getNome().equals(busta.getMittente())) {
                    busta.setIdentificativoPortaMittente(idSoggettoDefault.getCodicePorta());
                } else {
                    busta.setIdentificativoPortaMittente(registroServiziManager.getDominio(new IDSoggetto(busta.getTipoMittente(), busta.getMittente()), null, protocolFactory));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (busta.getDestinatario() != null && busta.getTipoDestinatario() != null && busta.getIdentificativoPortaDestinatario() == null) {
            try {
                if (idSoggettoDefault.getTipo().equals(busta.getTipoDestinatario()) && idSoggettoDefault.getNome().equals(busta.getDestinatario())) {
                    busta.setIdentificativoPortaDestinatario(idSoggettoDefault.getCodicePorta());
                } else {
                    busta.setIdentificativoPortaDestinatario(registroServiziManager.getDominio(new IDSoggetto(busta.getTipoDestinatario(), busta.getDestinatario()), null, protocolFactory));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        for (int i = 0; i < busta.sizeListaTrasmissioni(); ++i) {
            Trasmissione tr = busta.getTrasmissione(i);
            if (tr.getOrigine() != null && tr.getTipoOrigine() != null && tr.getIdentificativoPortaOrigine() == null) {
                try {
                    if (idSoggettoDefault.getTipo().equals(tr.getTipoOrigine()) && idSoggettoDefault.getNome().equals(tr.getOrigine())) {
                        tr.setIdentificativoPortaOrigine(idSoggettoDefault.getCodicePorta());
                    } else {
                        tr.setIdentificativoPortaOrigine(registroServiziManager.getDominio(new IDSoggetto(tr.getTipoOrigine(), tr.getOrigine()), null, protocolFactory));
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (tr.getDestinazione() == null || tr.getTipoDestinazione() == null || tr.getIdentificativoPortaDestinazione() != null) continue;
            try {
                if (idSoggettoDefault.getTipo().equals(tr.getTipoDestinazione()) && idSoggettoDefault.getNome().equals(tr.getDestinazione())) {
                    tr.setIdentificativoPortaDestinazione(idSoggettoDefault.getCodicePorta());
                    continue;
                }
                tr.setIdentificativoPortaDestinazione(registroServiziManager.getDominio(new IDSoggetto(tr.getTipoDestinazione(), tr.getDestinazione()), null, protocolFactory));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }
}

