/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.log4j.Logger;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.SoapUtils;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.state.IOpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateless;
import org.openspcoop2.protocol.sdk.state.StateMessage;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.io.notifier.NotifierInputStreamParams;
import org.openspcoop2.utils.jdbc.IJDBCAdapter;

public class SoapMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger log = null;
    private String idMessaggio;
    private String box;
    private boolean saveOnFS;
    private String keyMsg;
    private String workDir;
    private IJDBCAdapter adapter;
    private IOpenSPCoopState openspcoopstate;
    private OpenSPCoop2Properties openspcoopProperties = OpenSPCoop2Properties.getInstance();

    public SoapMessage(String idMsg, IOpenSPCoopState openspcoopstate, String box, String workDir, Logger alog) throws UtilsException {
        this(idMsg, openspcoopstate, box, workDir, null, alog);
    }

    public SoapMessage(String idMsg, IOpenSPCoopState openspcoopstate, String box, IJDBCAdapter adapterJDBC, Logger alog) throws UtilsException {
        this(idMsg, openspcoopstate, box, null, adapterJDBC, alog);
    }

    public SoapMessage(String idMsg, IOpenSPCoopState openspcoopstate, String box, String workDir, IJDBCAdapter adapterJDBC, Logger alog) throws UtilsException {
        this.idMessaggio = idMsg;
        this.box = box;
        this.openspcoopstate = openspcoopstate;
        this.log = alog != null ? alog : Logger.getLogger(SoapMessage.class);
        try {
            this.keyMsg = this.hash(idMsg);
            if (this.keyMsg == null) {
                throw new Exception("Codifica hash non riuscita: keyMsg is null");
            }
        }
        catch (Exception e) {
            String errorMsg = "SOAP_MESSAGE, costructor error (CodificaHash): " + box + "/" + idMsg + ": " + e.getMessage();
            this.log.error((Object)errorMsg);
            throw new UtilsException(errorMsg, (Throwable)e);
        }
        if (adapterJDBC == null) {
            this.saveOnFS = true;
            this.workDir = workDir;
        } else {
            this.saveOnFS = false;
            this.adapter = adapterJDBC;
        }
    }

    private String hash(String key) throws UtilsException {
        try {
            StringBuffer returnKey = new StringBuffer();
            for (int i = 0; i < key.length(); ++i) {
                if (key.charAt(i) == '_' || key.charAt(i) == '-' || key.charAt(i) == '.' || key.charAt(i) == ':') continue;
                returnKey.append(key.charAt(i));
            }
            return returnKey.toString();
        }
        catch (Exception e) {
            throw new UtilsException("Utilities.hash error " + e.getMessage(), (Throwable)e);
        }
    }

    public String getBaseDir() throws UtilsException {
        File dir = new File(this.workDir);
        if (!dir.exists()) {
            String errorMsg = "SOAP_MESSAGE, getBaseDir: " + this.box + "/" + this.idMessaggio + ": directory di lavoro inesistente (" + this.workDir + ").";
            this.log.error((Object)errorMsg);
            throw new UtilsException(errorMsg);
        }
        String baseDir = this.workDir;
        if (!baseDir.endsWith(File.separator)) {
            baseDir = baseDir + File.separator;
        }
        if ("INBOX".equals(this.box)) {
            baseDir = baseDir + "INBOX";
        } else if ("OUTBOX".equals(this.box)) {
            baseDir = baseDir + "OUTBOX";
        } else {
            String errorMsg = "SOAP_MESSAGE, getBaseDir: " + this.box + "/" + this.idMessaggio + ": box non valido? .";
            this.log.error((Object)errorMsg);
            throw new UtilsException(errorMsg);
        }
        File dirINOUT = new File(baseDir);
        if (!dirINOUT.exists() && !dirINOUT.mkdir()) {
            String errorMsg = "SOAP_MESSAGE, getBaseDir: " + this.box + "/" + this.idMessaggio + ": directory di lavoro (" + this.workDir + ") non permette la creazione di sottodirectory INBOX/OUTBOX.";
            this.log.error((Object)errorMsg);
            throw new UtilsException(errorMsg);
        }
        return baseDir + File.separator;
    }

    public String getIdMessaggio() {
        return this.idMessaggio;
    }

    public void updateState(IOpenSPCoopState openspcoopstate) {
        this.openspcoopstate = openspcoopstate;
    }

    public void save(OpenSPCoop2Message msg, boolean isRichiesta, boolean portaDiTipoStateless) throws UtilsException {
        String soapAction = null;
        try {
            soapAction = SoapUtils.getSoapAction((OpenSPCoop2Message)msg);
        }
        catch (Exception e) {
            String errorMsg = "SOAP_MESSAGE, save (soapAction): " + this.box + "/" + this.idMessaggio + ": " + e.getMessage();
            this.log.error((Object)errorMsg);
            throw new UtilsException(errorMsg, (Throwable)e);
        }
        if (!portaDiTipoStateless) {
            StateMessage stateMsg = isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateMsg.getConnectionDB();
            Statement pstmt = null;
            try {
                StringBuffer query = new StringBuffer();
                query.append("INSERT INTO  ");
                query.append("DEFINIZIONE_MESSAGGI");
                if (this.saveOnFS) {
                    query.append(" (ID_MESSAGGIO,TIPO,SOAP_ACTION,CONTENT_TYPE,CONTENT_LOCATION) VALUES ( ? , ? , ? , ? , ?)");
                } else {
                    query.append(" (ID_MESSAGGIO,TIPO,SOAP_ACTION,CONTENT_TYPE,CONTENT_LOCATION,MSG_BYTES) VALUES ( ? , ? , ? , ? , ? , ?)");
                }
                pstmt = connectionDB.prepareStatement(query.toString());
                pstmt.setString(1, this.idMessaggio);
                if ("INBOX".equals(this.box)) {
                    pstmt.setString(2, "INBOX");
                } else {
                    pstmt.setString(2, "OUTBOX");
                }
                pstmt.setString(3, soapAction);
                pstmt.setString(5, msg.getSOAPPart().getContentLocation());
                if (this.saveOnFS) {
                    String saveDir = this.getBaseDir();
                    if (saveDir == null) {
                        String errorMsg = "WorkDir non correttamente inizializzata";
                        throw new UtilsException(errorMsg);
                    }
                    String path = saveDir + this.keyMsg;
                    SoapUtils.saveMessage((String)path, (OpenSPCoop2Message)msg);
                } else {
                    ByteArrayOutputStream msgByte = new ByteArrayOutputStream();
                    msg.writeTo((OutputStream)msgByte, true);
                    msgByte.flush();
                    msgByte.close();
                    this.adapter.setBinaryData((PreparedStatement)pstmt, 6, msgByte.toByteArray());
                }
                pstmt.setString(4, msg.getContentType());
                stateMsg.getPreparedStatement().put("INSERT (MSG_OP_STEP1a) saveMessage[" + this.keyMsg + "," + this.box + "]", (PreparedStatement)pstmt);
            }
            catch (Exception e) {
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception err) {
                    // empty catch block
                }
                String errorMsg = "SOAP_MESSAGE, save : " + this.box + "/" + this.idMessaggio + ": " + e.getMessage();
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new UtilsException(errorMsg, (Throwable)e);
            }
        }
        if (portaDiTipoStateless) {
            try {
                if (soapAction != null) {
                    msg.setProperty("SOAPAction", (Object)soapAction);
                }
            }
            catch (Exception e) {
                String errorMsg = "SOAP_MESSAGE, set (soapAction): " + this.box + "/" + this.idMessaggio + ": " + e.getMessage();
                this.log.error((Object)errorMsg);
                throw new UtilsException(errorMsg, (Throwable)e);
            }
            if (isRichiesta) {
                ((OpenSPCoopStateless)this.openspcoopstate).setRichiestaMsg(msg);
            } else {
                ((OpenSPCoopStateless)this.openspcoopstate).setRispostaMsg(msg);
            }
        } else {
            throw new UtilsException("Metodo invocato con OpenSPCoopState non valido");
        }
    }

    public OpenSPCoop2Message read(boolean isRichiesta, boolean portaDiTipoStateless) throws UtilsException {
        if (!portaDiTipoStateless) {
            Connection connectionDB = isRichiesta ? ((StateMessage)this.openspcoopstate.getStatoRichiesta()).getConnectionDB() : ((StateMessage)this.openspcoopstate.getStatoRisposta()).getConnectionDB();
            OpenSPCoop2Message msg = null;
            Statement pstmt = null;
            InputStream is = null;
            ResultSet rs = null;
            try {
                StringBuffer query = new StringBuffer();
                if (this.saveOnFS) {
                    query.append("select SOAP_ACTION,CONTENT_TYPE,CONTENT_LOCATION ");
                } else {
                    query.append("select SOAP_ACTION,CONTENT_TYPE,CONTENT_LOCATION,MSG_BYTES ");
                }
                query.append("from ");
                query.append("DEFINIZIONE_MESSAGGI");
                query.append(" WHERE ID_MESSAGGIO = ? AND TIPO = ?");
                pstmt = connectionDB.prepareStatement(query.toString());
                pstmt.setString(1, this.idMessaggio);
                if ("INBOX".equals(this.box)) {
                    pstmt.setString(2, "INBOX");
                } else {
                    pstmt.setString(2, "OUTBOX");
                }
                rs = pstmt.executeQuery();
                if (rs == null) {
                    String errorMsg = "ResultSet is null?";
                    throw new UtilsException(errorMsg);
                }
                if (!rs.next()) {
                    String errorMsg = "Messaggio non esistente";
                    throw new UtilsException(errorMsg);
                }
                String contentType = rs.getString("CONTENT_TYPE");
                String contentLocation = rs.getString("CONTENT_LOCATION");
                if (this.saveOnFS) {
                    String saveDir = this.getBaseDir();
                    if (saveDir == null) {
                        String errorMsg = "WorkDir non correttamente inizializzata";
                        throw new UtilsException(errorMsg);
                    }
                    String path = saveDir + this.keyMsg;
                    File fileCheck = new File(path);
                    if (!fileCheck.exists()) {
                        String errorMsg = "Il messaggio non risulta gia' registrato (" + path + ").";
                        throw new UtilsException(errorMsg);
                    }
                    is = new FileInputStream(path);
                } else {
                    is = new ByteArrayInputStream(this.adapter.getBinaryData(rs, 4));
                }
                OpenSPCoop2MessageFactory mf = OpenSPCoop2MessageFactory.getMessageFactory();
                NotifierInputStreamParams notifierInputStreamParams = null;
                msg = mf.createMessage(is, notifierInputStreamParams, false, contentType, contentLocation, this.openspcoopProperties.isFileCacheEnable(), this.openspcoopProperties.getAttachmentRepoDir(), this.openspcoopProperties.getFileThreshold());
                try {
                    String soapAction = rs.getString("SOAP_ACTION");
                    if (soapAction != null) {
                        msg.setProperty("SOAPAction", (Object)soapAction);
                    }
                }
                catch (Exception e) {
                    throw new UtilsException(e.getMessage(), (Throwable)e);
                }
                rs.close();
                pstmt.close();
            }
            catch (Exception e) {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                String errorMsg = "SOAP_MESSAGE, read: " + this.box + "/" + this.idMessaggio + ": " + e.getMessage();
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new UtilsException(errorMsg, (Throwable)e);
            }
            return msg;
        }
        if (portaDiTipoStateless) {
            if (isRichiesta) {
                return ((OpenSPCoopStateless)this.openspcoopstate).getRichiestaMsg();
            }
            return ((OpenSPCoopStateless)this.openspcoopstate).getRispostaMsg();
        }
        throw new UtilsException("Metodo invocato con IState non valido");
    }

    public void delete(boolean isRichiesta, boolean onewayVersione11) throws UtilsException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful || onewayVersione11) {
            StateMessage stateMSG = isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateMSG.getConnectionDB();
            Statement pstmt = null;
            try {
                if (this.saveOnFS) {
                    String saveDir = this.getBaseDir();
                    if (saveDir == null) {
                        String errorMsg = "WorkDir non correttamente inizializzata";
                        throw new UtilsException(errorMsg);
                    }
                    String path = saveDir + this.keyMsg;
                    File fileDelete = new File(path);
                    if (fileDelete.exists()) {
                        fileDelete.delete();
                    }
                }
                StringBuffer query = new StringBuffer();
                query.append("DELETE from ");
                query.append("DEFINIZIONE_MESSAGGI");
                query.append(" WHERE ID_MESSAGGIO = ? AND TIPO = ?");
                pstmt = connectionDB.prepareStatement(query.toString());
                pstmt.setString(1, this.idMessaggio);
                if ("INBOX".equals(this.box)) {
                    pstmt.setString(2, "INBOX");
                } else {
                    pstmt.setString(2, "OUTBOX");
                }
                pstmt.execute();
                pstmt.close();
            }
            catch (Exception e) {
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                String errorMsg = "SOAP_MESSAGE, delete: " + this.box + "/" + this.idMessaggio + ": " + e.getMessage();
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new UtilsException(errorMsg, (Throwable)e);
            }
        }
        if (!(this.openspcoopstate instanceof OpenSPCoopStateless)) {
            throw new UtilsException("Metodo invocato con IState non valido");
        }
    }

    public void deleteMessageFromFileSystem() {
        try {
            if (this.saveOnFS) {
                String saveDir = this.getBaseDir();
                if (saveDir == null) {
                    String errorMsg = "WorkDir non correttamente inizializzata";
                    throw new UtilsException(errorMsg);
                }
                String path = saveDir + this.keyMsg;
                File fileDelete = new File(path);
                if (fileDelete.exists()) {
                    fileDelete.delete();
                }
            }
        }
        catch (Exception e) {
            String errorMsg = "SOAP_MESSAGE, deleteMessageFromFileSystem: " + this.box + "/" + this.idMessaggio + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
        }
    }
}

