/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core;

import org.apache.log4j.Logger;
import org.openspcoop2.core.config.constants.MTOMProcessorType;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.pdd.config.MTOMProcessorConfig;
import org.openspcoop2.pdd.config.MessageSecurityConfig;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.protocol.sdk.constants.TipoTraccia;

public class MTOMProcessor {
    private MTOMProcessorConfig config;
    private MessageSecurityConfig secConfig;
    private TipoPdD tipoPdD;
    private MsgDiagnostico msgDiag;
    private Logger log;
    private PdDContext pddContext;

    public MTOMProcessor(MTOMProcessorConfig config, MessageSecurityConfig secConfig, TipoPdD tipoPdD, MsgDiagnostico msgDiag, Logger log, PdDContext pddContext) {
        this.config = config;
        this.secConfig = secConfig;
        this.tipoPdD = tipoPdD;
        this.msgDiag = msgDiag;
        this.log = log;
        this.pddContext = pddContext;
    }

    public MTOMProcessorType getMTOMProcessorType() {
        if (this.config != null) {
            return this.config.getMtomProcessorType();
        }
        return null;
    }

    public void mtomBeforeSecurity(OpenSPCoop2Message msg, TipoTraccia tipo) throws Exception {
        boolean emitDiagDisabled = false;
        if (this.isEngineEnabled()) {
            if (this.isMTOMBeforeSecurity(tipo)) {
                this.setProcessorTypeIntoDiagnostic(tipo);
                this.emitDiagnostic(tipo, "mtom.processamentoRichiestaInCorso", "mtom.processamentoRispostaInCorso");
                try {
                    this.mtomApply(msg);
                    this.emitDiagnostic(tipo, "mtom.processamentoRichiestaEffettuato", "mtom.processamentoRispostaEffettuato");
                }
                catch (Exception e) {
                    this.msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                    this.log.error((Object)("[MTOM BeforeSecurity " + tipo.getTipo() + "] " + e.getMessage()), (Throwable)e);
                    this.emitDiagnostic(tipo, "mtom.processamentoRichiestaInErrore", "mtom.processamentoRispostaInErrore");
                    throw e;
                }
            } else {
                emitDiagDisabled = true;
            }
        } else {
            emitDiagDisabled = true;
        }
        if (emitDiagDisabled) {
            this.emitDiagnostic(tipo, "mtom.beforeSecurity.processamentoRichiestaDisabilitato", "mtom.beforeSecurity.processamentoRispostaDisabilitato");
        }
    }

    public void mtomAfterSecurity(OpenSPCoop2Message msg, TipoTraccia tipo) throws Exception {
        boolean emitDiagDisabled = false;
        if (this.isEngineEnabled()) {
            if (!this.isMTOMBeforeSecurity(tipo)) {
                this.setProcessorTypeIntoDiagnostic(tipo);
                this.emitDiagnostic(tipo, "mtom.processamentoRichiestaInCorso", "mtom.processamentoRispostaInCorso");
                try {
                    this.mtomApply(msg);
                    this.emitDiagnostic(tipo, "mtom.processamentoRichiestaEffettuato", "mtom.processamentoRispostaEffettuato");
                }
                catch (Exception e) {
                    this.msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                    this.log.error((Object)("[MTOM AfterSecurity " + tipo.getTipo() + "] " + e.getMessage()), (Throwable)e);
                    this.emitDiagnostic(tipo, "mtom.processamentoRichiestaInErrore", "mtom.processamentoRispostaInErrore");
                    throw e;
                }
            } else {
                emitDiagDisabled = true;
            }
        } else {
            emitDiagDisabled = true;
        }
        if (emitDiagDisabled) {
            this.emitDiagnostic(tipo, "mtom.afterSecurity.processamentoRichiestaDisabilitato", "mtom.afterSecurity.processamentoRispostaDisabilitato");
        }
    }

    private void setProcessorTypeIntoDiagnostic(TipoTraccia tipo) {
        switch (tipo) {
            case RICHIESTA: {
                this.msgDiag.addKeyword("@TIPO_PROCESSAMENTO_MTOM_RICHIESTA@", this.config.getMtomProcessorType().getValue());
                this.pddContext.addObject("@TIPO_PROCESSAMENTO_MTOM_RICHIESTA@", this.config.getMtomProcessorType().getValue());
                break;
            }
            case RISPOSTA: {
                this.msgDiag.addKeyword("@TIPO_PROCESSAMENTO_MTOM_RISPOSTA@", this.config.getMtomProcessorType().getValue());
                this.pddContext.addObject("@TIPO_PROCESSAMENTO_MTOM_RISPOSTA@", this.config.getMtomProcessorType().getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void emitDiagnostic(TipoTraccia tipo, String idDiagnosticRichiesta, String idDiagnosticRisposta) {
        String originalPrefix = this.msgDiag.getPrefixMsgPersonalizzati();
        try {
            switch (this.tipoPdD) {
                case DELEGATA: {
                    this.msgDiag.setPrefixMsgPersonalizzati("inoltroBuste.");
                    break;
                }
                case APPLICATIVA: {
                    this.msgDiag.setPrefixMsgPersonalizzati("ricezioneBuste.");
                    break;
                }
                default: {
                    return;
                }
            }
            switch (tipo) {
                case RICHIESTA: {
                    this.msgDiag.logPersonalizzato(idDiagnosticRichiesta);
                    return;
                }
                case RISPOSTA: {
                    this.msgDiag.logPersonalizzato(idDiagnosticRisposta);
                    return;
                }
            }
            return;
        }
        finally {
            this.msgDiag.setPrefixMsgPersonalizzati(originalPrefix);
        }
    }

    private void mtomApply(OpenSPCoop2Message msg) throws Exception {
        switch (this.config.getMtomProcessorType()) {
            case PACKAGING: {
                if (this.config.getInfo() == null || this.config.getInfo().size() <= 0) break;
                msg.mtomPackaging(this.config.getInfo());
                break;
            }
            case UNPACKAGING: {
                msg.mtomUnpackaging();
                break;
            }
            case VERIFY: {
                if (this.config.getInfo() == null || this.config.getInfo().size() <= 0) break;
                msg.mtomVerify(this.config.getInfo());
                break;
            }
        }
    }

    private boolean isMTOMBeforeSecurity(TipoTraccia tipoTraccia) throws Exception {
        MTOMProcessorType processorType = null;
        processorType = this.config != null && this.config.getMtomProcessorType() != null ? this.config.getMtomProcessorType() : MTOMProcessorType.DISABLE;
        Boolean applyToMtom = null;
        if (this.secConfig != null && this.secConfig.getApplyToMtom() != null) {
            applyToMtom = this.secConfig.getApplyToMtom();
        }
        switch (this.tipoPdD) {
            case DELEGATA: {
                switch (tipoTraccia) {
                    case RICHIESTA: {
                        switch (processorType) {
                            case DISABLE: {
                                throw new Exception("Caso non previsto [" + processorType + "] Delegata.richiesta.disabile");
                            }
                            case PACKAGING: {
                                if (applyToMtom == null) {
                                    return false;
                                }
                                return applyToMtom != false;
                            }
                            case UNPACKAGING: {
                                if (applyToMtom == null) {
                                    return false;
                                }
                                return applyToMtom == false;
                            }
                            case VERIFY: {
                                return true;
                            }
                        }
                        throw new Exception("Caso non previsto Delegata.richiesta.[" + processorType + "]");
                    }
                    case RISPOSTA: {
                        switch (processorType) {
                            case DISABLE: {
                                throw new Exception("Caso non previsto [" + processorType + "] Delegata.risposta.disabile");
                            }
                            case PACKAGING: {
                                if (applyToMtom == null) {
                                    return true;
                                }
                                return applyToMtom != false;
                            }
                            case UNPACKAGING: {
                                if (applyToMtom == null) {
                                    return true;
                                }
                                return applyToMtom == false;
                            }
                            case VERIFY: {
                                return true;
                            }
                        }
                        throw new Exception("Caso non previsto Delegata.risposta.[" + processorType + "]");
                    }
                }
                throw new Exception("Tipo non gestito [" + tipoTraccia + "] in Delegata.risposta");
            }
            case APPLICATIVA: {
                switch (tipoTraccia) {
                    case RICHIESTA: {
                        switch (processorType) {
                            case DISABLE: {
                                throw new Exception("Caso non previsto [" + processorType + "] Applicativa.richiesta.disabile");
                            }
                            case PACKAGING: {
                                if (applyToMtom == null) {
                                    return true;
                                }
                                return applyToMtom != false;
                            }
                            case UNPACKAGING: {
                                if (applyToMtom == null) {
                                    return true;
                                }
                                return applyToMtom == false;
                            }
                            case VERIFY: {
                                return true;
                            }
                        }
                        throw new Exception("Caso non previsto Applicativa.richiesta.[" + processorType + "]");
                    }
                    case RISPOSTA: {
                        switch (processorType) {
                            case DISABLE: {
                                throw new Exception("Caso non previsto [" + processorType + "] Applicativa.risposta.disabile");
                            }
                            case PACKAGING: {
                                if (applyToMtom == null) {
                                    return false;
                                }
                                return applyToMtom != false;
                            }
                            case UNPACKAGING: {
                                if (applyToMtom == null) {
                                    return false;
                                }
                                return applyToMtom == false;
                            }
                            case VERIFY: {
                                return true;
                            }
                        }
                        throw new Exception("Caso non previsto Applicativa.risposta.[" + processorType + "]");
                    }
                }
                throw new Exception("Tipo non gestito [" + tipoTraccia + "] in Applicativa.risposta");
            }
        }
        throw new Exception("RuoloPdD[" + this.tipoPdD + "] non gestito");
    }

    private boolean isEngineEnabled() {
        if (!TipoPdD.DELEGATA.equals(this.tipoPdD) && !TipoPdD.APPLICATIVA.equals(this.tipoPdD)) {
            return false;
        }
        return this.config != null && this.config.getMtomProcessorType() != null && !MTOMProcessorType.DISABLE.equals(this.config.getMtomProcessorType());
    }
}

