/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.xml.soap.SOAPBody;
import org.apache.log4j.Logger;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.eccezione.details.DettaglioEccezione;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.integrazione.EsitoRichiesta;
import org.openspcoop2.core.integrazione.utils.EsitoRichiestaXMLUtils;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.SOAPVersion;
import org.openspcoop2.message.SoapUtils;
import org.openspcoop2.pdd.config.ClassNameProperties;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.RichiestaApplicativa;
import org.openspcoop2.pdd.config.RichiestaDelegata;
import org.openspcoop2.pdd.config.SoggettoVirtuale;
import org.openspcoop2.pdd.core.AbstractCore;
import org.openspcoop2.pdd.core.EJBUtilsConsegnaException;
import org.openspcoop2.pdd.core.EJBUtilsException;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.JMSSender;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.behaviour.Behaviour;
import org.openspcoop2.pdd.core.behaviour.BehaviourForwardTo;
import org.openspcoop2.pdd.core.behaviour.BehaviourForwardToConfiguration;
import org.openspcoop2.pdd.core.behaviour.BehaviourForwardToFilter;
import org.openspcoop2.pdd.core.behaviour.IBehaviour;
import org.openspcoop2.pdd.core.behaviour.StatoFunzionalita;
import org.openspcoop2.pdd.core.node.INodeSender;
import org.openspcoop2.pdd.core.state.IOpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateless;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.mdb.ConsegnaContenutiApplicativi;
import org.openspcoop2.pdd.mdb.ConsegnaContenutiApplicativiMessage;
import org.openspcoop2.pdd.mdb.EsitoLib;
import org.openspcoop2.pdd.mdb.InoltroRisposteMessage;
import org.openspcoop2.pdd.services.RicezioneBusteMessage;
import org.openspcoop2.pdd.services.RicezioneContenutiApplicativiMessage;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.builder.DettaglioEccezioneOpenSPCoop2Builder;
import org.openspcoop2.protocol.engine.builder.Imbustamento;
import org.openspcoop2.protocol.engine.driver.RepositoryBuste;
import org.openspcoop2.protocol.engine.driver.RollbackRepositoryBuste;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.Integrazione;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.config.IProtocolVersionManager;
import org.openspcoop2.protocol.sdk.constants.ErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriCooperazione;
import org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.StateMessage;
import org.openspcoop2.protocol.sdk.state.StatelessMessage;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.resources.Loader;

public class EJBUtils {
    private Logger log = null;
    private IOpenSPCoopState openSPCoopState;
    private String idModulo = null;
    private TipoPdD tipoPdD;
    private IDSoggetto identitaPdD = null;
    private String idSessione;
    private String idMessage;
    private String tipo;
    private String scenarioCooperazione;
    private MsgDiagnostico msgDiag;
    private boolean oneWayVersione11 = false;
    private boolean portaDiTipoStateless_esclusoOneWay11;
    private boolean rollbackRichiestaInCasoErrore = true;
    private boolean rollbackRichiestaInCasoErrore_rollbackHistory = true;
    private boolean routing;
    private OpenSPCoop2Properties propertiesReader;
    private ConfigurazionePdDManager configurazionePdDReader;
    private boolean functionAsRouter = false;
    private Timestamp spedizioneMsgIngresso;
    private Timestamp ricezioneMsgRisposta;
    private boolean replyOnNewConnection;
    private boolean utilizzoIndirizzoTelematico;
    private String implementazionePdDSoggettoMittente;
    private String implementazionePdDSoggettoDestinatario;
    private String servizioApplicativoErogatore;
    private PdDContext pddContext;
    private String oldFunctionName;
    private INodeSender nodeSender = null;
    IProtocolFactory protocolFactory = null;
    IProtocolVersionManager protocolManager = null;
    DettaglioEccezioneOpenSPCoop2Builder dettaglioBuilder = null;
    private boolean gestioneStatelessConIntegrationManager = false;
    private boolean gestioneSolamenteConIntegrationManager = false;

    public void setPddContext(PdDContext pddContext) {
        this.pddContext = pddContext;
    }

    public synchronized void initializeNodeSender(OpenSPCoop2Properties propertiesReader, Logger logCore) throws EJBUtilsException {
        if (this.nodeSender != null) {
            return;
        }
        String classTypeNodeSender = null;
        try {
            classTypeNodeSender = ClassNameProperties.getInstance().getNodeSender(propertiesReader.getNodeSender());
            this.nodeSender = (INodeSender)Loader.getInstance().newInstance(classTypeNodeSender);
            AbstractCore.init(this.nodeSender, this.pddContext, this.protocolFactory, new Object[0]);
            logCore.info((Object)("Inizializzazione gestore NodeSender di tipo " + classTypeNodeSender + " effettuata."));
        }
        catch (Exception e) {
            throw new EJBUtilsException("Riscontrato errore durante il caricamento della classe [" + classTypeNodeSender + "] da utilizzare per la spedizione nell'infrastruttura: " + e.getMessage());
        }
    }

    public INodeSender getNodeSender(OpenSPCoop2Properties propertiesReader, Logger log) throws EJBUtilsException {
        if (this.nodeSender == null) {
            this.initializeNodeSender(propertiesReader, log);
        }
        return this.nodeSender;
    }

    public EJBUtils(IDSoggetto identitaPdD, TipoPdD tipoPdD, String aIDModulo, String idSessione, String idMessage, String tipo, IOpenSPCoopState openspcoop_state, MsgDiagnostico msgDiag, boolean functionAsRouter, String implementazionePdDSoggettoMittente, String implementazionePdDSoggettoDestinatario, String profiloGestione, PdDContext pddContext) throws EJBUtilsException {
        this.identitaPdD = identitaPdD;
        this.tipoPdD = tipoPdD;
        this.idModulo = aIDModulo;
        this.idSessione = idSessione;
        this.idMessage = idMessage;
        this.tipo = tipo;
        this.openSPCoopState = openspcoop_state;
        this.functionAsRouter = functionAsRouter;
        this.log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        if (this.log == null) {
            this.log = Logger.getLogger(EJBUtils.class);
        }
        this.msgDiag = msgDiag;
        this.propertiesReader = OpenSPCoop2Properties.getInstance();
        this.configurazionePdDReader = openspcoop_state == null ? ConfigurazionePdDManager.getInstance() : ConfigurazionePdDManager.getInstance(openspcoop_state.getStatoRichiesta(), openspcoop_state.getStatoRisposta());
        this.implementazionePdDSoggettoMittente = implementazionePdDSoggettoMittente;
        this.implementazionePdDSoggettoDestinatario = implementazionePdDSoggettoDestinatario;
        this.pddContext = pddContext;
        try {
            this.protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)this.pddContext.getObject("PROTOCOLLO"));
            this.protocolManager = this.protocolFactory.createProtocolVersionManager(profiloGestione);
            this.dettaglioBuilder = new DettaglioEccezioneOpenSPCoop2Builder(this.log, this.protocolFactory);
        }
        catch (Exception e) {
            throw new EJBUtilsException(e.getMessage(), e);
        }
        this.initializeNodeSender(this.propertiesReader, this.log);
    }

    public void setIdMessage(String idMessage) {
        this.idMessage = idMessage;
    }

    private void setEJBSuffixFunctionName() {
        if (this.msgDiag != null) {
            this.oldFunctionName = this.msgDiag.getFunzione();
            this.msgDiag.setFunzione(this.msgDiag.getFunzione() + ".EJBUtils");
        }
    }

    private void unsetEJBSuffixFunctionName() {
        if (this.msgDiag != null && this.oldFunctionName != null) {
            this.msgDiag.setFunzione(this.oldFunctionName);
        }
    }

    public void updateOpenSPCoopState(IOpenSPCoopState openSPCoopState) {
        this.openSPCoopState = openSPCoopState;
    }

    public void updateIdSessione(String id) {
        this.idSessione = id;
    }

    public void setReplyOnNewConnection(boolean replyOnNewConnection) {
        this.replyOnNewConnection = replyOnNewConnection;
    }

    public void setUtilizzoIndirizzoTelematico(boolean utilizzoIndirizzoTelematico) {
        this.utilizzoIndirizzoTelematico = utilizzoIndirizzoTelematico;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackMessage(String motivoRollbackEJB, EsitoLib esito) {
        this.setEJBSuffixFunctionName();
        try {
            GestoreMessaggi msg = new GestoreMessaggi(this.openSPCoopState, true, this.idMessage, this.tipo, this.msgDiag, this.pddContext);
            msg.setOneWayVersione11(this.oneWayVersione11);
            msg.aggiornaErroreProcessamentoMessaggio(motivoRollbackEJB, null);
            esito.setErroreProcessamentoMessaggioAggiornato(true);
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "EJBUtils.rollbackMessage(motivoRollbackEJB)");
        }
        finally {
            this.unsetEJBSuffixFunctionName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackMessage(String motivoRollbackEJB, String servizioApplicativo, EsitoLib esito) {
        this.setEJBSuffixFunctionName();
        try {
            GestoreMessaggi msg = new GestoreMessaggi(this.openSPCoopState, true, this.idMessage, this.tipo, this.msgDiag, this.pddContext);
            msg.setOneWayVersione11(this.oneWayVersione11);
            msg.aggiornaErroreProcessamentoMessaggio(motivoRollbackEJB, servizioApplicativo);
            esito.setErroreProcessamentoMessaggioAggiornato(true);
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "EJBUtils.rollbackMessage(motivoRollbackEJB,servizioApplicativo)");
        }
        finally {
            this.unsetEJBSuffixFunctionName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackMessage(String motivoRollbackEJB, Timestamp dataRiconsegna, String servizioApplicativo, EsitoLib esito) {
        this.setEJBSuffixFunctionName();
        try {
            GestoreMessaggi msg = new GestoreMessaggi(this.openSPCoopState, true, this.idMessage, this.tipo, this.msgDiag, this.pddContext);
            msg.setOneWayVersione11(this.oneWayVersione11);
            msg.aggiornaErroreProcessamentoMessaggio(motivoRollbackEJB, servizioApplicativo);
            esito.setErroreProcessamentoMessaggioAggiornato(true);
            if (dataRiconsegna != null) {
                msg.aggiornaDataRispedizione(dataRiconsegna, servizioApplicativo);
                esito.setDataRispedizioneAggiornata(true);
            }
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "EJBUtils.rollbackMessage(motivoRollbackEJB,dataRiconsegna,servizioApplicativo)");
        }
        finally {
            this.unsetEJBSuffixFunctionName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackMessage(String motivoRollbackEJB, Timestamp dataRiconsegna, EsitoLib esito) {
        this.setEJBSuffixFunctionName();
        try {
            GestoreMessaggi msg = new GestoreMessaggi(this.openSPCoopState, true, this.idMessage, this.tipo, this.msgDiag, this.pddContext);
            msg.setOneWayVersione11(this.oneWayVersione11);
            msg.aggiornaErroreProcessamentoMessaggio(motivoRollbackEJB, null);
            esito.setErroreProcessamentoMessaggioAggiornato(true);
            if (dataRiconsegna != null) {
                msg.aggiornaDataRispedizione(dataRiconsegna, null);
                esito.setDataRispedizioneAggiornata(true);
            }
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "EJBUtils.rollbackMessage(motivoRollbackEJB,dataRiconsegna)");
        }
        finally {
            this.unsetEJBSuffixFunctionName();
        }
    }

    public void updateErroreProcessamentoMessage(String motivoRollbackEJB, EsitoLib esito) {
        this.updateErroreProcessamentoMessage(motivoRollbackEJB, null, esito);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateErroreProcessamentoMessage(String motivoRollbackEJB, Timestamp dataRispedizione, EsitoLib esito) {
        this.setEJBSuffixFunctionName();
        try {
            GestoreMessaggi msg = new GestoreMessaggi(this.openSPCoopState, true, this.idMessage, this.tipo, this.msgDiag, this.pddContext);
            msg.setOneWayVersione11(this.oneWayVersione11);
            msg.aggiornaErroreProcessamentoMessaggio(motivoRollbackEJB, null);
            esito.setErroreProcessamentoMessaggioAggiornato(true);
            if (dataRispedizione != null) {
                msg.aggiornaDataRispedizione(dataRispedizione, null);
                esito.setDataRispedizioneAggiornata(true);
            }
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "EJBUtils.updateErroreProcessamentoMessage");
        }
        finally {
            this.unsetEJBSuffixFunctionName();
        }
    }

    public void releaseOutboxMessage(boolean isMessaggioRichiesta) throws EJBUtilsException {
        this.releaseMessage(true, false, null, null, true, isMessaggioRichiesta);
    }

    public void releaseOutboxMessage(boolean cleanHistory, boolean isMessaggioRichiesta) throws EJBUtilsException {
        this.releaseMessage(true, false, null, null, cleanHistory, isMessaggioRichiesta);
    }

    public void releaseOutboxMessage(String tipo, String id, boolean isMessaggioRichiesta) throws EJBUtilsException {
        if (!"INBOX".equals(tipo) && !"OUTBOX".equals(tipo)) {
            throw new EJBUtilsException("EJBUtils.releaseOutboxMessage error: Tipo di Messaggio non definito");
        }
        if (id == null) {
            throw new EJBUtilsException("EJBUtils.releaseOutboxMessage error: ID Messaggio non definito");
        }
        this.releaseMessage(true, false, tipo, id, true, isMessaggioRichiesta);
    }

    public void releaseInboxMessage(boolean isMessaggioRichiesta) throws EJBUtilsException {
        this.releaseMessage(false, true, null, null, true, isMessaggioRichiesta);
    }

    public void releaseInboxMessage(boolean cleanHistory, boolean isMessaggioRichiesta) throws EJBUtilsException {
        this.releaseMessage(false, true, null, null, cleanHistory, isMessaggioRichiesta);
    }

    public void releaseInboxMessage(String tipo, String id, boolean isMessaggioRichiesta) throws EJBUtilsException {
        if (!"INBOX".equals(tipo) && !"OUTBOX".equals(tipo)) {
            throw new EJBUtilsException("EJBUtils.releaseOutboxMessage error: Tipo di Messaggio non definito");
        }
        if (id == null) {
            throw new EJBUtilsException("EJBUtils.releaseOutboxMessage error: ID Messaggio non definito");
        }
        this.releaseMessage(false, true, tipo, id, true, isMessaggioRichiesta);
    }

    private void releaseMessage(boolean rollbackOutbox, boolean rollbackInbox, String tipo, String id, boolean cleanHistory, boolean isMessaggioRichiesta) throws EJBUtilsException {
        StateMessage stateMSG;
        StateMessage stateMessage = stateMSG = isMessaggioRichiesta ? (StateMessage)this.openSPCoopState.getStatoRichiesta() : (StateMessage)this.openSPCoopState.getStatoRisposta();
        if (stateMSG instanceof StatelessMessage && !this.oneWayVersione11) {
            return;
        }
        RollbackRepositoryBuste rollbackBuste = null;
        RollbackRepositoryBuste rollbackBusteRifMessaggio = null;
        GestoreMessaggi msg = null;
        try {
            if (rollbackOutbox) {
                rollbackBuste = new RollbackRepositoryBuste(this.idMessage, (IState)stateMSG, this.oneWayVersione11);
                rollbackBuste.rollbackBustaIntoOutBox(cleanHistory);
            } else if (rollbackInbox) {
                rollbackBuste = new RollbackRepositoryBuste(this.idMessage, (IState)stateMSG, this.oneWayVersione11);
                rollbackBuste.rollbackBustaIntoInBox(cleanHistory);
            }
            if (tipo != null && id != null) {
                rollbackBusteRifMessaggio = new RollbackRepositoryBuste(id, (IState)stateMSG, this.oneWayVersione11);
                if ("OUTBOX".equals(tipo)) {
                    rollbackBusteRifMessaggio.rollbackBustaIntoOutBox();
                } else {
                    rollbackBusteRifMessaggio.rollbackBustaIntoInBox();
                }
            }
            msg = new GestoreMessaggi(this.openSPCoopState, true, this.idMessage, this.tipo, this.msgDiag, this.pddContext);
            msg.setOneWayVersione11(this.oneWayVersione11);
            msg.aggiornaProprietarioMessaggio("GestoreMessaggi");
            this.openSPCoopState.commit();
            String idBustaRichiestaCorrelata = null;
            if (!this.idMessage.equals(this.idSessione)) {
                idBustaRichiestaCorrelata = this.idSessione;
            }
            msg.addProprietariIntoCache_readFromTable("EJBUtils." + this.idModulo, "releaseMessage", idBustaRichiestaCorrelata, this.functionAsRouter);
        }
        catch (Exception e) {
            stateMSG.closePreparedStatement();
            throw new EJBUtilsException("EJBUtils.releaseMessage error: " + e.getMessage(), e);
        }
    }

    public void sendRispostaApplicativaErrore(OpenSPCoop2Message responseMessageError, RichiestaDelegata richiestaDelegata, PortaDelegata pd, ServizioApplicativo sa) throws EJBUtilsException {
        this.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, true, pd, sa);
    }

    public void sendRispostaApplicativaErrore(OpenSPCoop2Message responseMessageError, RichiestaDelegata richiestaDelegata, boolean rollbackRichiesta, PortaDelegata pd, ServizioApplicativo sa) throws EJBUtilsException {
        String idTransazione = (String)this.pddContext.getObject("ID");
        if (this.openSPCoopState instanceof OpenSPCoopStateless) {
            ((OpenSPCoopStateless)this.openSPCoopState).setRispostaMsg(responseMessageError);
        }
        StateMessage statoRichiesta = (StateMessage)this.openSPCoopState.getStatoRichiesta();
        StateMessage statoRisposta = (StateMessage)this.openSPCoopState.getStatoRisposta();
        String correlazioneApplicativa = null;
        if (richiestaDelegata != null) {
            correlazioneApplicativa = richiestaDelegata.getIdCorrelazioneApplicativa();
        }
        String correlazioneApplicativaRisposta = null;
        if (richiestaDelegata != null) {
            correlazioneApplicativaRisposta = richiestaDelegata.getIdCorrelazioneApplicativaRisposta();
        }
        String nomePorta = null;
        if (richiestaDelegata != null) {
            nomePorta = richiestaDelegata.getLocationPD();
        }
        RollbackRepositoryBuste rollbackBuste = null;
        RollbackRepositoryBuste rollbackBusteRifMessaggio = null;
        GestoreMessaggi msgRequest = null;
        GestoreMessaggi msgResponse = null;
        GestoreMessaggi msgSbloccoRicezioneContenutiApplicativi = null;
        this.msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_EROGATORE@", richiestaDelegata.getServizioApplicativo());
        this.setEJBSuffixFunctionName();
        try {
            String idModuloInAttesa = richiestaDelegata.getIdModuloInAttesa();
            boolean consegnaRispostaAsincrona = false;
            if (rollbackRichiesta) {
                rollbackBusteRifMessaggio = new RollbackRepositoryBuste(this.idSessione, (IState)statoRichiesta, this.oneWayVersione11);
                rollbackBusteRifMessaggio.rollbackBustaIntoOutBox(this.rollbackRichiestaInCasoErrore_rollbackHistory);
            } else {
                rollbackBusteRifMessaggio = new RollbackRepositoryBuste(this.idSessione, (IState)statoRichiesta, this.oneWayVersione11);
                rollbackBusteRifMessaggio.clearAccessiIntoOutBox(false, false, true);
            }
            if (!this.idSessione.equals(this.idMessage)) {
                rollbackBuste = new RollbackRepositoryBuste(this.idMessage, (IState)statoRichiesta, this.oneWayVersione11);
                rollbackBuste.rollbackBustaIntoInBox();
            }
            msgRequest = new GestoreMessaggi(this.openSPCoopState, true, this.idMessage, this.tipo, this.msgDiag, this.pddContext);
            msgRequest.setOneWayVersione11(this.oneWayVersione11);
            msgRequest.aggiornaProprietarioMessaggio("GestoreMessaggi");
            String idRisposta = null;
            if (consegnaRispostaAsincrona || idModuloInAttesa != null) {
                Imbustamento imbustatore = new Imbustamento(this.protocolFactory);
                idRisposta = imbustatore.buildID(this.openSPCoopState.getStatoRichiesta(), this.identitaPdD, idTransazione, this.propertiesReader.getGestioneSerializableDB_AttesaAttiva(), this.propertiesReader.getGestioneSerializableDB_CheckInterval(), Boolean.FALSE);
                if (idRisposta == null) {
                    throw new Exception("Identificativo non costruito.");
                }
                Timestamp oraRegistrazioneMessaggio = DateManager.getTimestamp();
                msgResponse = new GestoreMessaggi(this.openSPCoopState, false, idRisposta, "INBOX", this.msgDiag, this.pddContext);
                msgResponse.registraMessaggio(responseMessageError, oraRegistrazioneMessaggio, this.saveMessageStateless(pd), correlazioneApplicativa, correlazioneApplicativaRisposta);
                msgResponse.aggiornaRiferimentoMessaggio(this.idSessione);
                if (consegnaRispostaAsincrona) {
                    msgResponse.aggiornaProprietarioMessaggio("ConsegnaContenutiApplicativi");
                } else if (idModuloInAttesa != null) {
                    msgResponse.aggiornaProprietarioMessaggio(idModuloInAttesa);
                }
                boolean servizioApplicativoConConnettore = false;
                boolean getMessageAbilitato = false;
                boolean sbustamentoSoap = false;
                boolean sbustamentoInformazioniProtocollo = true;
                try {
                    servizioApplicativoConConnettore = this.configurazionePdDReader.consegnaRispostaAsincronaConConnettore(sa);
                    getMessageAbilitato = this.configurazionePdDReader.consegnaRispostaAsincronaConGetMessage(sa);
                    sbustamentoSoap = this.configurazionePdDReader.consegnaRispostaAsincronaConSbustamento(sa);
                    sbustamentoInformazioniProtocollo = this.configurazionePdDReader.consegnaRispostaAsincronaConSbustamentoInformazioniProtocollo(sa);
                }
                catch (DriverConfigurazioneNotFound de) {
                    // empty catch block
                }
                if (!getMessageAbilitato && !servizioApplicativoConConnettore && idModuloInAttesa == null) {
                    this.msgDiag.logPersonalizzato("consegnaContenutiApplicativi.", "consegnaNonDefinita");
                    return;
                }
                String tipoConsegna = "IntegrationManager";
                if (consegnaRispostaAsincrona) {
                    if (servizioApplicativoConConnettore) {
                        richiestaDelegata.setScenario("ConsegnaContenutiApplicativi");
                        this.sendToConsegnaContenutiApplicativi_rispostaConsegnataModalitaAsincrona(richiestaDelegata, idRisposta, msgResponse);
                        tipoConsegna = "Connettore";
                    } else {
                        this.msgDiag.logPersonalizzato("consegnaContenutiApplicativi.", "integrationManager.messaggioDisponibile");
                    }
                } else if (idModuloInAttesa != null) {
                    this.sendToRicezioneContenutiApplicativi(idModuloInAttesa, idRisposta, richiestaDelegata.getIdCollaborazione(), richiestaDelegata.getProfiloCollaborazione(), richiestaDelegata.getProfiloCollaborazioneValue());
                    tipoConsegna = "ConnectionReply";
                }
                msgResponse.registraDestinatarioMessaggio(richiestaDelegata.getServizioApplicativo(), sbustamentoSoap, sbustamentoInformazioniProtocollo, getMessageAbilitato, tipoConsegna, oraRegistrazioneMessaggio, nomePorta);
            }
            String idSbloccoRicezioneContenutiApplicativi = null;
            if (consegnaRispostaAsincrona && idModuloInAttesa != null) {
                Imbustamento imbustatore = new Imbustamento(this.protocolFactory);
                idSbloccoRicezioneContenutiApplicativi = imbustatore.buildID(this.openSPCoopState.getStatoRichiesta(), this.identitaPdD, idTransazione, this.propertiesReader.getGestioneSerializableDB_AttesaAttiva(), this.propertiesReader.getGestioneSerializableDB_CheckInterval(), Boolean.FALSE);
                if (idSbloccoRicezioneContenutiApplicativi == null) {
                    throw new Exception("Identificativo non costruito.");
                }
                msgSbloccoRicezioneContenutiApplicativi = new GestoreMessaggi(this.openSPCoopState, false, idSbloccoRicezioneContenutiApplicativi, "INBOX", this.msgDiag, this.pddContext);
                if (this.protocolManager.isHttpEmptyResponseOneWay()) {
                    msgSbloccoRicezioneContenutiApplicativi.registraMessaggio(SoapUtils.build_Soap_Empty((SOAPVersion)responseMessageError.getVersioneSoap()), correlazioneApplicativa, correlazioneApplicativaRisposta);
                } else {
                    msgSbloccoRicezioneContenutiApplicativi.registraMessaggio(this.buildOpenSPCoopOK_soapMsg(responseMessageError.getVersioneSoap(), this.idSessione), correlazioneApplicativa, correlazioneApplicativaRisposta);
                }
                msgSbloccoRicezioneContenutiApplicativi.aggiornaRiferimentoMessaggio(this.idSessione);
                msgSbloccoRicezioneContenutiApplicativi.aggiornaProprietarioMessaggio(idModuloInAttesa);
                this.sendToRicezioneContenutiApplicativi(idModuloInAttesa, idSbloccoRicezioneContenutiApplicativi, richiestaDelegata.getIdCollaborazione(), richiestaDelegata.getProfiloCollaborazione(), richiestaDelegata.getProfiloCollaborazioneValue());
            }
            this.openSPCoopState.commit();
            if (msgSbloccoRicezioneContenutiApplicativi != null) {
                msgSbloccoRicezioneContenutiApplicativi.addMessaggiIntoCache_readFromTable(this.idModulo, "sendRispostaApplicativaErrore [sblocco]");
            }
            if (msgResponse != null) {
                msgResponse.addMessaggiIntoCache_readFromTable(this.idModulo, "sendRispostaApplicativaErrore [risposta]");
            }
            if (msgRequest != null) {
                String idRichiestaCorrelata = null;
                if (!this.idMessage.equals(this.idSessione)) {
                    idRichiestaCorrelata = this.idSessione;
                }
                msgRequest.addProprietariIntoCache_readFromTable(this.idModulo, "sendRispostaApplicativaErrore [richiesta]", idRichiestaCorrelata, this.functionAsRouter);
            }
            if (msgSbloccoRicezioneContenutiApplicativi != null) {
                msgSbloccoRicezioneContenutiApplicativi.addProprietariIntoCache_readFromTable(this.idModulo, "sendRispostaApplicativaErrore [sblocco]", this.idSessione, this.functionAsRouter);
            }
            if (msgResponse != null) {
                msgResponse.addProprietariIntoCache_readFromTable(this.idModulo, "sendRispostaApplicativaErrore [risposta]", this.idSessione, this.functionAsRouter);
            }
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "EJBUtils.sendRispostaApplicativaErrore");
            statoRichiesta.closePreparedStatement();
            statoRisposta.closePreparedStatement();
            throw new EJBUtilsException("EJBUtils.sendRispostaApplicativaErrore error: " + e.getMessage(), e);
        }
        finally {
            this.unsetEJBSuffixFunctionName();
        }
    }

    public GestoreMessaggi sendRispostaApplicativa(RichiestaDelegata richiestaDelegata, PortaDelegata pd, ServizioApplicativo sa) throws EJBUtilsException {
        return this.sendRispostaApplicativa(null, richiestaDelegata, this.idMessage, pd, sa);
    }

    public GestoreMessaggi sendRispostaApplicativaOK(OpenSPCoop2Message msg, RichiestaDelegata richiestaDelegata, PortaDelegata pd, ServizioApplicativo sa) throws EJBUtilsException {
        return this.sendRispostaApplicativa(msg, richiestaDelegata, null, pd, sa);
    }

    private GestoreMessaggi sendRispostaApplicativa(OpenSPCoop2Message msg, RichiestaDelegata richiestaDelegata, String idBustaRisposta, PortaDelegata pd, ServizioApplicativo sa) throws EJBUtilsException {
        String idTransazione = (String)this.pddContext.getObject("ID");
        StateMessage statoRisposta = (StateMessage)this.openSPCoopState.getStatoRisposta();
        GestoreMessaggi msgResponse = null;
        GestoreMessaggi msgSbloccoRicezioneContenutiApplicativi = null;
        String correlazioneApplicativa = null;
        if (richiestaDelegata != null) {
            correlazioneApplicativa = richiestaDelegata.getIdCorrelazioneApplicativa();
        }
        String correlazioneApplicativaRisposta = null;
        if (richiestaDelegata != null) {
            correlazioneApplicativaRisposta = richiestaDelegata.getIdCorrelazioneApplicativaRisposta();
        }
        String nomePorta = null;
        if (richiestaDelegata != null) {
            nomePorta = richiestaDelegata.getLocationPD();
        }
        this.msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_EROGATORE@", richiestaDelegata.getServizioApplicativo());
        this.setEJBSuffixFunctionName();
        try {
            String idModuloInAttesa = richiestaDelegata.getIdModuloInAttesa();
            boolean existsConsegnaRispostaAsincrona = false;
            try {
                existsConsegnaRispostaAsincrona = this.configurazionePdDReader.existsConsegnaRispostaAsincrona(sa);
            }
            catch (DriverConfigurazioneNotFound de) {
                // empty catch block
            }
            boolean consegnaRispostaAsincrona = richiestaDelegata.getUtilizzoConsegnaAsincrona() && existsConsegnaRispostaAsincrona;
            String idRisposta = idBustaRisposta;
            if (consegnaRispostaAsincrona || idModuloInAttesa != null) {
                Timestamp oraRegistrazioneMessaggio = DateManager.getTimestamp();
                if (idRisposta == null) {
                    Imbustamento imbustatore = new Imbustamento(this.protocolFactory);
                    idRisposta = imbustatore.buildID(this.openSPCoopState.getStatoRichiesta(), this.identitaPdD, idTransazione, this.propertiesReader.getGestioneSerializableDB_AttesaAttiva(), this.propertiesReader.getGestioneSerializableDB_CheckInterval(), Boolean.FALSE);
                    if (idRisposta == null) {
                        throw new Exception("Identificativo non costruito.");
                    }
                    msgResponse = new GestoreMessaggi(this.openSPCoopState, false, idRisposta, "INBOX", this.msgDiag, this.pddContext);
                    msgResponse.registraMessaggio(msg, oraRegistrazioneMessaggio, this.saveMessageStateless(pd), correlazioneApplicativa, correlazioneApplicativaRisposta);
                } else {
                    msgResponse = new GestoreMessaggi(this.openSPCoopState, false, idRisposta, "INBOX", this.msgDiag, this.pddContext);
                    oraRegistrazioneMessaggio = msgResponse.getOraRegistrazioneMessaggio();
                }
                msgResponse.aggiornaRiferimentoMessaggio(this.idSessione);
                if (consegnaRispostaAsincrona) {
                    msgResponse.aggiornaProprietarioMessaggio("ConsegnaContenutiApplicativi");
                } else if (idModuloInAttesa != null) {
                    msgResponse.aggiornaProprietarioMessaggio(idModuloInAttesa);
                }
                boolean servizioApplicativoConConnettore = false;
                boolean getMessageAbilitato = false;
                boolean sbustamentoSoap = false;
                boolean sbustamentoInformazioniProtocollo = true;
                try {
                    servizioApplicativoConConnettore = this.configurazionePdDReader.consegnaRispostaAsincronaConConnettore(sa);
                    getMessageAbilitato = this.configurazionePdDReader.consegnaRispostaAsincronaConGetMessage(sa);
                    sbustamentoSoap = this.configurazionePdDReader.consegnaRispostaAsincronaConSbustamento(sa);
                    sbustamentoInformazioniProtocollo = this.configurazionePdDReader.consegnaRispostaAsincronaConSbustamentoInformazioniProtocollo(sa);
                }
                catch (DriverConfigurazioneNotFound de) {
                    // empty catch block
                }
                if (!getMessageAbilitato && !servizioApplicativoConConnettore && idModuloInAttesa == null) {
                    this.msgDiag.logPersonalizzato("consegnaContenutiApplicativi.", "consegnaNonDefinita");
                    GestoreMessaggi de = msgResponse;
                    return de;
                }
                if (!servizioApplicativoConConnettore && idModuloInAttesa == null) {
                    this.msgDiag.logPersonalizzato("consegnaContenutiApplicativi.", "integrationManager.messaggioDisponibile");
                }
                String tipoConsegna = "IntegrationManager";
                if (consegnaRispostaAsincrona) {
                    if (servizioApplicativoConConnettore) {
                        richiestaDelegata.setScenario("ConsegnaContenutiApplicativi");
                        this.sendToConsegnaContenutiApplicativi_rispostaConsegnataModalitaAsincrona(richiestaDelegata, idRisposta, msgResponse);
                        tipoConsegna = "Connettore";
                    } else {
                        this.msgDiag.logPersonalizzato("consegnaContenutiApplicativi.", "integrationManager.messaggioDisponibile");
                    }
                } else if (idModuloInAttesa != null) {
                    this.sendToRicezioneContenutiApplicativi(idModuloInAttesa, idRisposta, richiestaDelegata.getIdCollaborazione(), richiestaDelegata.getProfiloCollaborazione(), richiestaDelegata.getProfiloCollaborazioneValue());
                    tipoConsegna = "ConnectionReply";
                }
                msgResponse.registraDestinatarioMessaggio(richiestaDelegata.getServizioApplicativo(), sbustamentoSoap, sbustamentoInformazioniProtocollo, getMessageAbilitato, tipoConsegna, oraRegistrazioneMessaggio, nomePorta);
            }
            if (consegnaRispostaAsincrona && idModuloInAttesa != null) {
                Imbustamento imbustatore = new Imbustamento(this.protocolFactory);
                String idSbloccoRicezioneContenutiApplicativi = imbustatore.buildID(this.openSPCoopState.getStatoRichiesta(), this.identitaPdD, idTransazione, this.propertiesReader.getGestioneSerializableDB_AttesaAttiva(), this.propertiesReader.getGestioneSerializableDB_CheckInterval(), Boolean.FALSE);
                if (idSbloccoRicezioneContenutiApplicativi == null) {
                    throw new Exception("Identificativo non costruito.");
                }
                msgSbloccoRicezioneContenutiApplicativi = new GestoreMessaggi(this.openSPCoopState, false, idSbloccoRicezioneContenutiApplicativi, "INBOX", this.msgDiag, this.pddContext);
                if (this.protocolManager.isHttpEmptyResponseOneWay()) {
                    msgSbloccoRicezioneContenutiApplicativi.registraMessaggio(SoapUtils.build_Soap_Empty((SOAPVersion)msg.getVersioneSoap()), correlazioneApplicativa, correlazioneApplicativaRisposta);
                } else {
                    msgSbloccoRicezioneContenutiApplicativi.registraMessaggio(this.buildOpenSPCoopOK_soapMsg(msg.getVersioneSoap(), this.idSessione), correlazioneApplicativa, correlazioneApplicativaRisposta);
                }
                msgSbloccoRicezioneContenutiApplicativi.aggiornaRiferimentoMessaggio(this.idSessione);
                msgSbloccoRicezioneContenutiApplicativi.aggiornaProprietarioMessaggio(idModuloInAttesa);
                this.sendToRicezioneContenutiApplicativi(idModuloInAttesa, idSbloccoRicezioneContenutiApplicativi, richiestaDelegata.getIdCollaborazione(), richiestaDelegata.getProfiloCollaborazione(), richiestaDelegata.getProfiloCollaborazioneValue());
            }
            GestoreMessaggi gestoreMessaggi = msgResponse;
            return gestoreMessaggi;
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "EJBUtils.sendRispostaApplicativa");
            if (msgResponse != null) {
                statoRisposta.closePreparedStatement();
            }
            throw new EJBUtilsException("EJBUtils.sendRispostaApplicativa error: " + e.getMessage(), e);
        }
        finally {
            this.unsetEJBSuffixFunctionName();
        }
    }

    public void sendToRicezioneContenutiApplicativi(String idModuloInAttesa, String idRisposta, String idCollaborazione, ProfiloDiCollaborazione profiloCollaborazione, String profiloCollaborazioneValue) throws EJBUtilsException {
        if (this.openSPCoopState instanceof OpenSPCoopStateless) {
            RicezioneContenutiApplicativiMessage accettazioneMSG = new RicezioneContenutiApplicativiMessage();
            accettazioneMSG.setIdBustaRisposta(idRisposta);
            accettazioneMSG.setIdCollaborazione(idCollaborazione);
            accettazioneMSG.setProfiloCollaborazione(profiloCollaborazione, profiloCollaborazioneValue);
            accettazioneMSG.setPddContext(this.pddContext);
            ((OpenSPCoopStateless)this.openSPCoopState).setMessageLib(accettazioneMSG);
            return;
        }
        if ("jms".equals(this.propertiesReader.getNodeReceiver())) {
            try {
                this.msgDiag.highDebug("[EJBUtils] Creazione ObjectMessage for send via JMS.");
                RicezioneContenutiApplicativiMessage accettazioneMSG = new RicezioneContenutiApplicativiMessage();
                accettazioneMSG.setIdBustaRisposta(idRisposta);
                accettazioneMSG.setIdCollaborazione(idCollaborazione);
                accettazioneMSG.setProfiloCollaborazione(profiloCollaborazione, profiloCollaborazioneValue);
                accettazioneMSG.setPddContext(this.pddContext);
                if (this.openSPCoopState instanceof OpenSPCoopStateless) {
                    ((OpenSPCoopStateless)this.openSPCoopState).setMessageLib(accettazioneMSG);
                } else {
                    String idT = PdDContext.getValue("ID", this.pddContext);
                    JMSSender senderJMS = new JMSSender(this.identitaPdD, this.idModulo, this.log, idT);
                    if (!senderJMS.send(idModuloInAttesa, (Serializable)accettazioneMSG, this.idSessione)) {
                        this.msgDiag.logErroreGenerico(senderJMS.getErrore(), "EJBUtils.sendToRicezioneContenutiApplicativi.senderJMS");
                        throw new Exception("[EJBUtils]  SendJMSError: " + senderJMS.getErrore());
                    }
                    this.msgDiag.highDebug("[EJBUtils]  ObjectMessage send via JMS.");
                }
            }
            catch (Exception e) {
                this.msgDiag.logErroreGenerico(e, "EJBUtils.sendToRicezioneContenutiApplicativi");
                throw new EJBUtilsException("EJBUtils.sendToRicezioneContenutiApplicativi error: " + e.getMessage(), e);
            }
        }
    }

    public void sendToConsegnaContenutiApplicativi_rispostaConsegnataModalitaAsincrona(RichiestaDelegata richiestaDelegata, String idBustaConsegna, GestoreMessaggi gm) throws EJBUtilsException {
        try {
            this.msgDiag.highDebug("[EJBUtils]  Creazione ObjectMessage for send nell'infrastruttura.");
            ConsegnaContenutiApplicativiMessage consegnaMSG = new ConsegnaContenutiApplicativiMessage();
            consegnaMSG.setRichiestaDelegata(richiestaDelegata);
            consegnaMSG.setOneWayVersione11(this.oneWayVersione11);
            consegnaMSG.setStateless(this.portaDiTipoStateless_esclusoOneWay11);
            consegnaMSG.setImplementazionePdDSoggettoMittente(this.implementazionePdDSoggettoMittente);
            consegnaMSG.setImplementazionePdDSoggettoDestinatario(this.implementazionePdDSoggettoDestinatario);
            consegnaMSG.setPddContext(this.pddContext);
            Busta busta = new Busta(this.protocolFactory.getProtocol());
            busta.setTipoMittente(richiestaDelegata.getSoggettoFruitore().getTipo());
            busta.setMittente(richiestaDelegata.getSoggettoFruitore().getNome());
            busta.setIdentificativoPortaMittente(richiestaDelegata.getSoggettoFruitore().getCodicePorta());
            busta.setTipoDestinatario(richiestaDelegata.getIdServizio().getSoggettoErogatore().getTipo());
            busta.setDestinatario(richiestaDelegata.getIdServizio().getSoggettoErogatore().getNome());
            busta.setIdentificativoPortaDestinatario(richiestaDelegata.getIdServizio().getSoggettoErogatore().getCodicePorta());
            busta.setTipoServizio(richiestaDelegata.getIdServizio().getTipoServizio());
            busta.setServizio(richiestaDelegata.getIdServizio().getServizio());
            busta.setVersioneServizio(richiestaDelegata.getIdServizio().getVersioneServizio());
            busta.setAzione(richiestaDelegata.getIdServizio().getAzione());
            busta.setID(idBustaConsegna);
            busta.setRiferimentoMessaggio(this.idSessione);
            boolean idCollaborazione = false;
            switch (this.protocolFactory.createProtocolVersionManager(richiestaDelegata.getProfiloGestione()).getCollaborazione(richiestaDelegata.getProfiloCollaborazione())) {
                case ABILITATA: {
                    idCollaborazione = true;
                    break;
                }
                case DISABILITATA: {
                    idCollaborazione = false;
                    break;
                }
                default: {
                    idCollaborazione = this.propertiesReader.isGestioneElementoCollaborazione(this.implementazionePdDSoggettoDestinatario);
                }
            }
            if (idCollaborazione) {
                busta.setCollaborazione(richiestaDelegata.getIdCollaborazione());
            }
            consegnaMSG.setBusta(busta);
            this.nodeSender.send(consegnaMSG, "ConsegnaContenutiApplicativi", this.msgDiag, this.identitaPdD, this.idModulo, idBustaConsegna, gm);
        }
        catch (Exception e) {
            this.log.error((Object)"Spedizione->ConsegnaContenutiApplicativi(RichiestaDelegata) non riuscita", (Throwable)e);
            this.msgDiag.logErroreGenerico(e, "EJBUtils.sendToConsegnaContenutiApplicativi(RichiestaDelegata)");
            throw new EJBUtilsException("EJBUtils.sendToConsegnaContenutiApplicativi error: " + e.getMessage(), e);
        }
    }

    public void sendToConsegnaContenutiApplicativi_gestioneMessaggio(RichiestaDelegata richiestaDelegata, Busta busta, GestoreMessaggi gestoreMessaggi, ServizioApplicativo sa) throws EJBUtilsException {
        block12: {
            try {
                this.msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_EROGATORE@", richiestaDelegata.getServizioApplicativo());
                String nomePorta = null;
                if (richiestaDelegata != null) {
                    nomePorta = richiestaDelegata.getLocationPD();
                }
                this.msgDiag.setServizioApplicativo(richiestaDelegata.getServizioApplicativo());
                this.msgDiag.logCorrelazioneServizioApplicativo();
                gestoreMessaggi.aggiornaRiferimentoMessaggio(busta.getRiferimentoMessaggio());
                boolean servizioApplicativoRicezioneAsincronaConConnettore = this.configurazionePdDReader.consegnaRispostaAsincronaConConnettore(sa);
                boolean getMessageAbilitato = this.configurazionePdDReader.consegnaRispostaAsincronaConGetMessage(sa);
                if (!getMessageAbilitato && !servizioApplicativoRicezioneAsincronaConConnettore) {
                    throw new EJBUtilsConsegnaException(this.msgDiag, "consegnaContenutiApplicativi.", "consegnaNonDefinita");
                }
                boolean sbustamentoSoap = this.configurazionePdDReader.consegnaRispostaAsincronaConSbustamento(sa);
                boolean sbustamentoInformazioniProtocollo = this.configurazionePdDReader.consegnaRispostaAsincronaConSbustamentoInformazioniProtocollo(sa);
                String tipoConsegna = "IntegrationManager";
                if (servizioApplicativoRicezioneAsincronaConConnettore) {
                    tipoConsegna = "Connettore";
                }
                Timestamp oraRegistrazioneMessaggio = gestoreMessaggi.getOraRegistrazioneMessaggio();
                gestoreMessaggi.registraDestinatarioMessaggio(richiestaDelegata.getServizioApplicativo(), sbustamentoSoap, sbustamentoInformazioniProtocollo, getMessageAbilitato, tipoConsegna, oraRegistrazioneMessaggio, nomePorta);
                this.msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_EROGATORE@", richiestaDelegata.getServizioApplicativo());
                if (servizioApplicativoRicezioneAsincronaConConnettore) {
                    this.msgDiag.highDebug("[EJBUtils] Creazione ObjectMessage for send nell'infrastruttura.");
                    ConsegnaContenutiApplicativiMessage consegnaMSG = new ConsegnaContenutiApplicativiMessage();
                    consegnaMSG.setRichiestaDelegata(richiestaDelegata);
                    consegnaMSG.setBusta(busta);
                    consegnaMSG.setOneWayVersione11(this.oneWayVersione11);
                    consegnaMSG.setStateless(this.portaDiTipoStateless_esclusoOneWay11);
                    consegnaMSG.setImplementazionePdDSoggettoMittente(this.implementazionePdDSoggettoMittente);
                    consegnaMSG.setImplementazionePdDSoggettoDestinatario(this.implementazionePdDSoggettoDestinatario);
                    consegnaMSG.setPddContext(this.pddContext);
                    if (this.openSPCoopState instanceof OpenSPCoopStateless) {
                        ((OpenSPCoopStateless)this.openSPCoopState).setMessageLib(consegnaMSG);
                    } else {
                        this.nodeSender.send(consegnaMSG, "ConsegnaContenutiApplicativi", this.msgDiag, this.identitaPdD, this.idModulo, busta.getID(), gestoreMessaggi);
                    }
                    break block12;
                }
                if (richiestaDelegata.isRicevutaAsincrona() && (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(busta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals(busta.getProfiloDiCollaborazione()))) {
                    throw new EJBUtilsConsegnaException(this.msgDiag, "consegnaContenutiApplicativi.", "gestioneProfiloAsincrono.servizioNonUtilizzabile");
                }
                this.msgDiag.logPersonalizzato("consegnaContenutiApplicativi.", "integrationManager.messaggioDisponibile");
            }
            catch (EJBUtilsConsegnaException e) {
                throw e;
            }
            catch (Exception e) {
                this.log.error((Object)"Spedizione->ConsegnaContenutiApplicativi_gestoreMessaggi(RichiestaDelegata) non riuscita", (Throwable)e);
                this.msgDiag.logErroreGenerico(e, "EJBUtils.sendToConsegnaContenutiApplicativi_gestoreMessaggi(RichiestaDelegata)");
                throw new EJBUtilsException("EJBUtils.sendToConsegnaContenutiApplicativi error: " + e.getMessage(), e);
            }
        }
    }

    public boolean isGestioneStatelessConIntegrationManager() {
        return this.gestioneStatelessConIntegrationManager;
    }

    public boolean isGestioneSolamenteConIntegrationManager() {
        return this.gestioneSolamenteConIntegrationManager;
    }

    public Behaviour sendToConsegnaContenutiApplicativi(RichiestaApplicativa richiestaApplicativa, Busta busta, GestoreMessaggi gestoreMessaggi, PortaApplicativa pa, RepositoryBuste repositoryBuste) throws EJBUtilsException {
        return this.sendToConsegnaContenutiApplicativi(richiestaApplicativa, busta, gestoreMessaggi, pa, repositoryBuste, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public Behaviour sendToConsegnaContenutiApplicativi(RichiestaApplicativa richiestaApplicativa, Busta busta, GestoreMessaggi gestoreMessaggi, PortaApplicativa pa, RepositoryBuste repositoryBuste, RichiestaDelegata localForwardRichiestaDelegata) throws EJBUtilsException {
        try {
            Behaviour behaviour = null;
            boolean stateless = false;
            stateless = localForwardRichiestaDelegata != null ? this.portaDiTipoStateless_esclusoOneWay11 : this.configurazionePdDReader.isModalitaStateless(pa, busta.getProfiloDiCollaborazione());
            boolean registraNuoviMessaggiViaBehaviour = false;
            int sizeNuoviMessaggiViaBehaviour = -1;
            BehaviourForwardToFilter singleFilterBehaviour = null;
            boolean behaviourResponseTo = false;
            if (pa.getBehaviour() != null && !"".equals(pa.getBehaviour())) {
                String tipoBehaviour = ClassNameProperties.getInstance().getBehaviour(pa.getBehaviour());
                if (tipoBehaviour == null) {
                    throw new Exception("Tipo di behaviour [" + pa.getBehaviour() + "] sconosciuto");
                }
                this.msgDiag.addKeyword("@TIPO_BEHAVIOUR@", pa.getBehaviour());
                IBehaviour behaviourImpl = (IBehaviour)Loader.getInstance().newInstance(tipoBehaviour);
                gestoreMessaggi.setPortaDiTipoStateless(stateless);
                behaviour = behaviourImpl.behaviour(gestoreMessaggi, busta);
                boolean bl = behaviourResponseTo = behaviour != null && behaviour.isResponseTo();
                if (behaviour != null && behaviour.getForwardTo() != null) {
                    if (behaviour.getForwardTo().size() > 1) {
                        registraNuoviMessaggiViaBehaviour = true;
                        if (!behaviourResponseTo) {
                            throw new Exception("La consegna di messaggi multipli via custom behaviour (tipo:" + pa.getBehaviour() + ") e' permessa solo se viene abilita anche la funzione 'responseTo'");
                        }
                        for (int i = 0; i < behaviour.getForwardTo().size(); ++i) {
                            BehaviourForwardTo forwardTo = behaviour.getForwardTo().get(i);
                            if (forwardTo.getDescription() == null) {
                                forwardTo.setDescription("ForwardTo[" + i + "]");
                            }
                            if (forwardTo.getMessage() != null) continue;
                            throw new Exception("La consegna di messaggi multipli via custom behaviour (tipo:" + pa.getBehaviour() + ") richiede che vengano definiti tutti i messaggi da inoltrare. Trovato un elemento ForwardTo (" + forwardTo.getDescription() + ") che non contiene alcun messaggio");
                        }
                    } else if (behaviour.getForwardTo().size() == 1) {
                        BehaviourForwardTo forwardTo = behaviour.getForwardTo().get(0);
                        if (forwardTo.getDescription() == null) {
                            forwardTo.setDescription("ForwardTo");
                        }
                        if (forwardTo.getMessage() != null) {
                            if (behaviourResponseTo) {
                                registraNuoviMessaggiViaBehaviour = true;
                            } else if (!stateless) {
                                registraNuoviMessaggiViaBehaviour = true;
                            }
                        } else {
                            singleFilterBehaviour = behaviour.getForwardTo().get(0).getFilter();
                        }
                    }
                }
                if (registraNuoviMessaggiViaBehaviour) {
                    sizeNuoviMessaggiViaBehaviour = behaviour.getForwardTo().size();
                    if (localForwardRichiestaDelegata != null) {
                        if (stateless) {
                            repositoryBuste.eliminaUtilizzoPdDFromInBox(busta.getID(), false);
                        } else {
                            repositoryBuste.eliminaUtilizzoPdDFromInBox(busta.getID(), true);
                        }
                        gestoreMessaggi.aggiornaProprietarioMessaggio("GestoreMessaggi");
                    } else {
                        repositoryBuste.eliminaUtilizzoPdDFromInBox(busta.getID(), true);
                        boolean originalValue = gestoreMessaggi.isOneWayVersione11();
                        gestoreMessaggi.setOneWayVersione11(true);
                        gestoreMessaggi.logicDeleteMessage();
                        gestoreMessaggi.setOneWayVersione11(originalValue);
                    }
                } else if (stateless && behaviourResponseTo) {
                    throw new Exception("La definizione dell'elemento 'responseTo', via custom behaviour (tipo:" + pa.getBehaviour() + "), in una porta applicativa stateless richiede la definizione almeno di un elemento forwardTo contenente un messaggio da inoltrare.");
                }
            }
            if (!("OneWay_InvocazioneServizio".equals(richiestaApplicativa.getScenario()) || "Sincrono_InvocazioneServizio".equals(richiestaApplicativa.getScenario()) || "AsincronoSimmetrico_InvocazioneServizio".equals(richiestaApplicativa.getScenario()) || "AsincronoAsimmetrico_InvocazioneServizio".equals(richiestaApplicativa.getScenario()) || "AsincronoAsimmetrico_Polling".equals(richiestaApplicativa.getScenario()))) {
                throw new Exception("Tipo di consegna sconosciuta");
            }
            String[] serviziApplicativiConfigurazione = null;
            SoggettoVirtuale soggettiRealiMappatiInUnSoggettoVirtuale = null;
            IDSoggetto soggettoDestinatario = richiestaApplicativa.getIDServizio().getSoggettoErogatore();
            if ("AsincronoAsimmetrico_Polling".equals(richiestaApplicativa.getScenario())) {
                serviziApplicativiConfigurazione = this.configurazionePdDReader.getServiziApplicativi(pa);
                if (serviziApplicativiConfigurazione == null) {
                    throw new EJBUtilsConsegnaException(this.msgDiag, "consegnaContenutiApplicativi.", "servizioApplicativoNonDefinito");
                }
            } else if (this.configurazionePdDReader.isSoggettoVirtuale(soggettoDestinatario)) {
                SoggettoVirtuale soggettiVirtuali = this.configurazionePdDReader.getServiziApplicativi_SoggettiVirtuali(richiestaApplicativa);
                if (soggettiVirtuali == null) {
                    throw new EJBUtilsConsegnaException("(SoggettoVirtuale) " + this.msgDiag.getMessaggio_replaceKeywords("consegnaContenutiApplicativi.", "servizioApplicativoNonDefinito"), this.msgDiag.getLivello("consegnaContenutiApplicativi.", "servizioApplicativoNonDefinito"), this.msgDiag.getCodice("consegnaContenutiApplicativi.", "servizioApplicativoNonDefinito"));
                }
                serviziApplicativiConfigurazione = soggettiVirtuali.getServiziApplicativi();
            } else {
                serviziApplicativiConfigurazione = this.configurazionePdDReader.getServiziApplicativi(pa);
                if (serviziApplicativiConfigurazione == null) {
                    throw new EJBUtilsConsegnaException(this.msgDiag, "consegnaContenutiApplicativi.", "servizioApplicativoNonDefinito");
                }
            }
            if (serviziApplicativiConfigurazione.length < 1) {
                throw new EJBUtilsConsegnaException(this.msgDiag, "consegnaContenutiApplicativi.", "servizioApplicativoNonDefinito");
            }
            ArrayList<String> serviziApplicativiAbilitati = new ArrayList<String>();
            List<IDServizioApplicativo> idServiziApplicativiAbilitati = new ArrayList<IDServizioApplicativo>();
            for (int i = 0; i < serviziApplicativiConfigurazione.length; ++i) {
                IDServizioApplicativo idSA = new IDServizioApplicativo();
                idSA.setIdSoggettoProprietario(soggettoDestinatario);
                idSA.setNome(serviziApplicativiConfigurazione[i]);
                serviziApplicativiAbilitati.add(serviziApplicativiConfigurazione[i]);
                idServiziApplicativiAbilitati.add(idSA);
            }
            if (singleFilterBehaviour != null) {
                idServiziApplicativiAbilitati = singleFilterBehaviour.aggiornaDestinatariAbilitati(idServiziApplicativiAbilitati);
                serviziApplicativiAbilitati = new ArrayList();
                for (IDServizioApplicativo idServizioApplicativo : idServiziApplicativiAbilitati) {
                    serviziApplicativiAbilitati.add(idServizioApplicativo.getNome());
                }
            }
            if (serviziApplicativiAbilitati.size() < 1) {
                throw new EJBUtilsConsegnaException(this.msgDiag, "consegnaContenutiApplicativi.", "behaviour.servizioApplicativoNonDefinito");
            }
            if (!registraNuoviMessaggiViaBehaviour || !behaviourResponseTo) {
                if (!"OneWay_InvocazioneServizio".equals(richiestaApplicativa.getScenario()) && serviziApplicativiAbilitati.size() > 1) {
                    throw new EJBUtilsConsegnaException(this.msgDiag, "consegnaContenutiApplicativi.", "gestioneProfiloNonOneway.consegnaVersoNServiziApplicativi");
                }
                if ("OneWay_InvocazioneServizio".equals(richiestaApplicativa.getScenario()) && !this.oneWayVersione11 && this.openSPCoopState instanceof OpenSPCoopStateless && serviziApplicativiAbilitati.size() > 1) {
                    for (String nomeServizioApplicativo : serviziApplicativiAbilitati) {
                        ServizioApplicativo sappl = this.configurazionePdDReader.getServizioApplicativo(richiestaApplicativa.getIdPA(), nomeServizioApplicativo);
                        boolean servizioApplicativoConConnettore = this.configurazionePdDReader.invocazioneServizioConConnettore(sappl);
                        boolean getMessageAbilitato = this.configurazionePdDReader.invocazioneServizioConGetMessage(sappl);
                        if (!servizioApplicativoConConnettore && getMessageAbilitato) continue;
                        throw new EJBUtilsConsegnaException(this.msgDiag, "consegnaContenutiApplicativi.", "gestioneStateless.consegnaVersoNServiziApplicativi");
                    }
                }
            }
            if (behaviour == null || !registraNuoviMessaggiViaBehaviour) {
                this._sendMessageToServiziApplicativi(serviziApplicativiAbilitati, soggettiRealiMappatiInUnSoggettoVirtuale, richiestaApplicativa, localForwardRichiestaDelegata, gestoreMessaggi, busta, pa, repositoryBuste, null, null, stateless, this.openSPCoopState);
            } else {
                List<BehaviourForwardTo> forwardTo = behaviour.getForwardTo();
                for (int i = 0; i < forwardTo.size(); ++i) {
                    void var24_34;
                    BehaviourForwardTo behaviourForwardTo = forwardTo.get(i);
                    ArrayList<String> serviziApplicativiAbilitatiForwardTo = new ArrayList<String>();
                    List<Object> idServiziApplicativiAbilitatiForwardTo = new ArrayList<IDServizioApplicativo>();
                    serviziApplicativiAbilitatiForwardTo.addAll(serviziApplicativiAbilitati);
                    idServiziApplicativiAbilitatiForwardTo.addAll(idServiziApplicativiAbilitati);
                    if (behaviourForwardTo.getFilter() != null) {
                        idServiziApplicativiAbilitatiForwardTo = behaviourForwardTo.getFilter().aggiornaDestinatariAbilitati(idServiziApplicativiAbilitati);
                        serviziApplicativiAbilitatiForwardTo = new ArrayList();
                        for (IDServizioApplicativo iDServizioApplicativo : idServiziApplicativiAbilitatiForwardTo) {
                            serviziApplicativiAbilitatiForwardTo.add(iDServizioApplicativo.getNome());
                        }
                    }
                    if (serviziApplicativiAbilitatiForwardTo.size() < 1) {
                        throw new EJBUtilsConsegnaException(this.msgDiag, "consegnaContenutiApplicativi.", "behaviour.servizioApplicativoNonDefinito");
                    }
                    String idTransazione = (String)this.pddContext.getObject("ID");
                    OpenSPCoopState openSPCoopState = null;
                    try {
                        Busta bustaNewMessaggio;
                        if (stateless && !this.propertiesReader.isServerJ2EE().booleanValue()) {
                            OpenSPCoopStateless openSPCoopStateless = new OpenSPCoopStateless();
                            openSPCoopStateless.setUseConnection(true);
                            openSPCoopStateless.setTempiAttraversamentoPDD(((OpenSPCoopStateless)this.openSPCoopState).getTempiAttraversamentoPDD());
                            openSPCoopStateless.setDimensioneMessaggiAttraversamentoPDD(((OpenSPCoopStateless)this.openSPCoopState).getDimensioneMessaggiAttraversamentoPDD());
                            openSPCoopStateless.setIDCorrelazioneApplicativa(((OpenSPCoopStateless)this.openSPCoopState).getIDCorrelazioneApplicativa());
                            openSPCoopStateless.setIDCorrelazioneApplicativaRisposta(((OpenSPCoopStateless)this.openSPCoopState).getIDCorrelazioneApplicativaRisposta());
                            openSPCoopStateless.setPddContext(((OpenSPCoopStateless)this.openSPCoopState).getPddContext());
                            openSPCoopStateless.initResource(this.identitaPdD, "EJBUtils.behaviour_" + pa.getBehaviour(), idTransazione);
                        }
                        if ((bustaNewMessaggio = behaviourForwardTo.getBusta()) == null) {
                            bustaNewMessaggio = busta.clone();
                            bustaNewMessaggio.setID("Forward" + i + "_" + busta.getID());
                        }
                        bustaNewMessaggio.setRiferimentoMessaggio(busta.getID());
                        bustaNewMessaggio.addProperty("@DESCRIZIONE_BEHAVIOUR@", behaviourForwardTo.getDescription());
                        IOpenSPCoopState stateNuoviMessaggi = this.openSPCoopState;
                        if (var24_34 != null) {
                            stateNuoviMessaggi = var24_34;
                        }
                        GestoreMessaggi gestoreNewMessaggio = new GestoreMessaggi(stateNuoviMessaggi, true, bustaNewMessaggio.getID(), "INBOX", this.msgDiag, this.pddContext);
                        RepositoryBuste repositoryBusteNewMessaggio = new RepositoryBuste(stateNuoviMessaggi.getStatoRichiesta(), true, this.protocolFactory);
                        this._forceSaveMessage(gestoreNewMessaggio, null, bustaNewMessaggio, richiestaApplicativa, repositoryBusteNewMessaggio, behaviourForwardTo.getMessage(), stateNuoviMessaggi);
                        this._sendMessageToServiziApplicativi(serviziApplicativiAbilitatiForwardTo, soggettiRealiMappatiInUnSoggettoVirtuale, richiestaApplicativa, localForwardRichiestaDelegata, gestoreNewMessaggio, bustaNewMessaggio, pa, repositoryBusteNewMessaggio, busta.getID(), behaviourForwardTo.getConfig(), stateless, stateNuoviMessaggi);
                        if (stateless && !this.propertiesReader.isServerJ2EE().booleanValue()) {
                            if (var24_34.resourceReleased()) {
                                var24_34.updateResource(idTransazione);
                            }
                            var24_34.commit();
                        }
                        if (!stateless || this.propertiesReader.isServerJ2EE().booleanValue() || var24_34 == null) continue;
                    }
                    catch (Throwable throwable) {
                        if (stateless && !this.propertiesReader.isServerJ2EE().booleanValue() && openSPCoopState != null) {
                            openSPCoopState.releaseResource();
                        }
                        throw throwable;
                    }
                    var24_34.releaseResource();
                }
            }
            return behaviour;
        }
        catch (EJBUtilsConsegnaException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.error((Object)"Spedizione->ConsegnaContenutiApplicativi(RichiestaApplicativa) non riuscita", (Throwable)e);
            this.log.error((Object)"EJBUtils.sendToConsegnaContenutiApplicativi(RichiestaApplicativa)", (Throwable)e);
            this.msgDiag.logErroreGenerico(e, "EJBUtils.sendToConsegnaContenutiApplicativi(RichiestaApplicativa)");
            throw new EJBUtilsException("EJBUtils.sendToConsegnaContenutiApplicativi error: " + e.getMessage(), e);
        }
    }

    private void _sendMessageToServiziApplicativi(List<String> serviziApplicativi, SoggettoVirtuale soggettiRealiMappatiInUnSoggettoVirtuale, RichiestaApplicativa richiestaApplicativa, RichiestaDelegata localForwardRichiestaDelegata, GestoreMessaggi gestoreMessaggi, Busta busta, PortaApplicativa pa, RepositoryBuste repositoryBuste, String idBustaPreBehaviourNewMessage, BehaviourForwardToConfiguration behaviourForwardToConfiguration, boolean stateless, IOpenSPCoopState state) throws Exception {
        boolean registrazioneMessaggioPerStatelessEffettuata = false;
        boolean gestioneSolamenteConIntegrationManager = true;
        Hashtable<String, Boolean> mapServizioApplicativoConConnettore = new Hashtable<String, Boolean>();
        Hashtable<String, Boolean> mapSbustamentoSoap = new Hashtable<String, Boolean>();
        Hashtable<String, Boolean> mapSbustamentoInformazioniProtocollo = new Hashtable<String, Boolean>();
        Hashtable<String, Boolean> mapGetMessage = new Hashtable<String, Boolean>();
        Hashtable<String, String> mapTipoConsegna = new Hashtable<String, String>();
        Hashtable<String, Timestamp> mapOraRegistrazione = new Hashtable<String, Timestamp>();
        Hashtable<String, ConsegnaContenutiApplicativiMessage> mapConsegnaContenutiApplicativiMessage = new Hashtable<String, ConsegnaContenutiApplicativiMessage>();
        String nomePorta = null;
        if (richiestaApplicativa != null && richiestaApplicativa.getIdPAbyNome() != null) {
            nomePorta = richiestaApplicativa.getIdPAbyNome().getNome();
        }
        for (String servizioApplicativo : serviziApplicativi) {
            this.msgDiag.highDebug("[EJBUtils] Creazione ObjectMessage for send nell'infrastruttura.");
            ConsegnaContenutiApplicativiMessage consegnaMSG = new ConsegnaContenutiApplicativiMessage();
            consegnaMSG.setBusta(busta);
            consegnaMSG.setOneWayVersione11(this.oneWayVersione11);
            consegnaMSG.setStateless(this.portaDiTipoStateless_esclusoOneWay11);
            consegnaMSG.setImplementazionePdDSoggettoMittente(this.implementazionePdDSoggettoMittente);
            consegnaMSG.setImplementazionePdDSoggettoDestinatario(this.implementazionePdDSoggettoDestinatario);
            consegnaMSG.setPddContext(this.pddContext);
            consegnaMSG.setRichiestaDelegata(localForwardRichiestaDelegata);
            if (idBustaPreBehaviourNewMessage != null) {
                consegnaMSG.setIdMessaggioPreBehaviour(idBustaPreBehaviourNewMessage);
            }
            consegnaMSG.setBehaviourForwardToConfiguration(behaviourForwardToConfiguration);
            this.msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_EROGATORE@", servizioApplicativo);
            if (soggettiRealiMappatiInUnSoggettoVirtuale != null) {
                String oldDominio = richiestaApplicativa.getIDServizio().getSoggettoErogatore().getCodicePorta();
                richiestaApplicativa.getIDServizio().setSoggettoErogatore(soggettiRealiMappatiInUnSoggettoVirtuale.getSoggettoReale(servizioApplicativo));
                richiestaApplicativa.getIDServizio().getSoggettoErogatore().setCodicePorta(oldDominio);
            }
            richiestaApplicativa.setServizioApplicativo(servizioApplicativo);
            ServizioApplicativo sappl = this.configurazionePdDReader.getServizioApplicativo(richiestaApplicativa.getIdPA(), servizioApplicativo);
            this.msgDiag.setServizioApplicativo(servizioApplicativo);
            this.msgDiag.logCorrelazioneServizioApplicativo();
            boolean servizioApplicativoConConnettore = true;
            boolean getMessageAbilitato = false;
            boolean sbustamento_soap = false;
            boolean sbustamento_informazioni_protocollo = true;
            if ("AsincronoAsimmetrico_Polling".equals(richiestaApplicativa.getScenario())) {
                sbustamento_soap = this.configurazionePdDReader.consegnaRispostaAsincronaConSbustamento(sappl);
                sbustamento_informazioni_protocollo = this.configurazionePdDReader.consegnaRispostaAsincronaConSbustamentoInformazioniProtocollo(sappl);
                servizioApplicativoConConnettore = this.configurazionePdDReader.consegnaRispostaAsincronaConConnettore(sappl);
            } else {
                servizioApplicativoConConnettore = this.configurazionePdDReader.invocazioneServizioConConnettore(sappl);
                sbustamento_soap = this.configurazionePdDReader.invocazioneServizioConSbustamento(sappl);
                sbustamento_informazioni_protocollo = this.configurazionePdDReader.invocazioneServizioConSbustamentoInformazioniProtocollo(sappl);
                getMessageAbilitato = this.configurazionePdDReader.invocazioneServizioConGetMessage(sappl);
            }
            if (behaviourForwardToConfiguration != null) {
                if (behaviourForwardToConfiguration.getSbustamentoInformazioniProtocollo() != null) {
                    if (StatoFunzionalita.ABILITATA.equals(behaviourForwardToConfiguration.getSbustamentoInformazioniProtocollo())) {
                        sbustamento_informazioni_protocollo = true;
                    } else if (StatoFunzionalita.DISABILITATA.equals(behaviourForwardToConfiguration.getSbustamentoInformazioniProtocollo())) {
                        sbustamento_informazioni_protocollo = false;
                    }
                }
                if (behaviourForwardToConfiguration.getSbustamentoSoap() != null) {
                    if (StatoFunzionalita.ABILITATA.equals(behaviourForwardToConfiguration.getSbustamentoSoap())) {
                        sbustamento_soap = true;
                    } else if (StatoFunzionalita.DISABILITATA.equals(behaviourForwardToConfiguration.getSbustamentoSoap())) {
                        sbustamento_soap = false;
                    }
                }
            }
            if (localForwardRichiestaDelegata != null) {
                sbustamento_informazioni_protocollo = false;
            }
            if (!getMessageAbilitato && !servizioApplicativoConConnettore) {
                throw new EJBUtilsConsegnaException(this.msgDiag, "consegnaContenutiApplicativi.", "consegnaNonDefinita");
            }
            if (state instanceof OpenSPCoopStateless && !this.oneWayVersione11 && getMessageAbilitato && servizioApplicativoConConnettore && idBustaPreBehaviourNewMessage == null) {
                throw new EJBUtilsConsegnaException(this.msgDiag, "consegnaContenutiApplicativi.", "gestioneStateless.integrationManager");
            }
            String tipoConsegna = "IntegrationManager";
            if (servizioApplicativoConConnettore) {
                tipoConsegna = "Connettore";
            }
            Timestamp oraRegistrazioneMessaggio = gestoreMessaggi.getOraRegistrazioneMessaggio();
            if (idBustaPreBehaviourNewMessage != null) {
                gestoreMessaggi.setOneWayVersione11(true);
            }
            gestoreMessaggi.registraDestinatarioMessaggio(servizioApplicativo, sbustamento_soap, sbustamento_informazioni_protocollo, getMessageAbilitato, tipoConsegna, oraRegistrazioneMessaggio, nomePorta);
            mapServizioApplicativoConConnettore.put(servizioApplicativo, servizioApplicativoConConnettore);
            mapSbustamentoSoap.put(servizioApplicativo, sbustamento_soap);
            mapSbustamentoInformazioniProtocollo.put(servizioApplicativo, sbustamento_informazioni_protocollo);
            mapGetMessage.put(servizioApplicativo, getMessageAbilitato);
            mapTipoConsegna.put(servizioApplicativo, tipoConsegna);
            mapOraRegistrazione.put(servizioApplicativo, oraRegistrazioneMessaggio);
            mapConsegnaContenutiApplicativiMessage.put(servizioApplicativo, consegnaMSG);
        }
        boolean registrazioneDestinatarioEffettuataPerViaBehaviour = false;
        if (idBustaPreBehaviourNewMessage != null && stateless && !this.propertiesReader.isServerJ2EE().booleanValue()) {
            state.commit();
            state.releaseResource();
            registrazioneDestinatarioEffettuataPerViaBehaviour = true;
        }
        for (String servizioApplicativo : serviziApplicativi) {
            boolean servizioApplicativoConConnettore = (Boolean)mapServizioApplicativoConConnettore.get(servizioApplicativo);
            boolean sbustamento_soap = (Boolean)mapSbustamentoSoap.get(servizioApplicativo);
            boolean sbustamento_informazioni_protocollo = (Boolean)mapSbustamentoInformazioniProtocollo.get(servizioApplicativo);
            boolean getMessageAbilitato = (Boolean)mapGetMessage.get(servizioApplicativo);
            String tipoConsegna = (String)mapTipoConsegna.get(servizioApplicativo);
            Timestamp oraRegistrazioneMessaggio = (Timestamp)mapOraRegistrazione.get(servizioApplicativo);
            ConsegnaContenutiApplicativiMessage consegnaMSG = (ConsegnaContenutiApplicativiMessage)mapConsegnaContenutiApplicativiMessage.get(servizioApplicativo);
            this.msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_EROGATORE@", servizioApplicativo);
            if (soggettiRealiMappatiInUnSoggettoVirtuale != null) {
                String oldDominio = richiestaApplicativa.getIDServizio().getSoggettoErogatore().getCodicePorta();
                richiestaApplicativa.getIDServizio().setSoggettoErogatore(soggettiRealiMappatiInUnSoggettoVirtuale.getSoggettoReale(servizioApplicativo));
                richiestaApplicativa.getIDServizio().getSoggettoErogatore().setCodicePorta(oldDominio);
            }
            richiestaApplicativa.setServizioApplicativo(servizioApplicativo);
            this.msgDiag.setServizioApplicativo(servizioApplicativo);
            if (servizioApplicativoConConnettore) {
                gestioneSolamenteConIntegrationManager = false;
                consegnaMSG.setRichiestaApplicativa(richiestaApplicativa);
                if (!stateless || this.propertiesReader.isServerJ2EE().booleanValue() && idBustaPreBehaviourNewMessage != null) {
                    if (this.oneWayVersione11) {
                        OpenSPCoopStateless statelessSerializzabile = ((OpenSPCoopStateless)state).rendiSerializzabile();
                        consegnaMSG.setOpenspcoopstate(statelessSerializzabile);
                    }
                    try {
                        String idSessione = this.idSessione;
                        if (idBustaPreBehaviourNewMessage != null) {
                            idSessione = busta.getID();
                        }
                        this.nodeSender.send(consegnaMSG, "ConsegnaContenutiApplicativi", this.msgDiag, this.identitaPdD, this.idModulo, idSessione, gestoreMessaggi);
                        continue;
                    }
                    catch (Exception e) {
                        this.msgDiag.logErroreGenerico(e, "EJBUtils.sendToConsegnaContenutiApplicativi(RichiestaApplicativa).senderJMS");
                        throw e;
                    }
                }
                ((OpenSPCoopStateless)state).setMessageLib(consegnaMSG);
                ((OpenSPCoopStateless)state).setDestinatarioRequestMsgLib("ConsegnaContenutiApplicativi");
                if (idBustaPreBehaviourNewMessage == null) continue;
                ConsegnaContenutiApplicativi lib = new ConsegnaContenutiApplicativi(this.log);
                EsitoLib result = lib.onMessage(state);
                this.log.debug((Object)("Invocato ConsegnaContenutiApplicativi per [" + busta.getID() + "] con esito: " + result.getStatoInvocazione()), (Throwable)result.getErroreNonGestito());
                continue;
            }
            if (idBustaPreBehaviourNewMessage == null) {
                if (ProfiloDiCollaborazione.SINCRONO.equals(busta.getProfiloDiCollaborazione())) {
                    throw new EJBUtilsConsegnaException(this.msgDiag, "consegnaContenutiApplicativi.", "trasmissioneSincrona.servizioNonUtilizzabile");
                }
                if (richiestaApplicativa.isRicevutaAsincrona() && (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(busta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals(busta.getProfiloDiCollaborazione()))) {
                    throw new EJBUtilsConsegnaException(this.msgDiag, "consegnaContenutiApplicativi.", "gestioneProfiloAsincrono.servizioNonUtilizzabile");
                }
                if ("AsincronoAsimmetrico_Polling".equals(richiestaApplicativa.getScenario())) {
                    throw new EJBUtilsConsegnaException("(Polling AsincronoAsimmetrico) " + this.msgDiag.getMessaggio_replaceKeywords("consegnaContenutiApplicativi.", "trasmissioneSincrona.servizioNonUtilizzabile"), this.msgDiag.getLivello("consegnaContenutiApplicativi.", "trasmissioneSincrona.servizioNonUtilizzabile"), this.msgDiag.getCodice("consegnaContenutiApplicativi.", "trasmissioneSincrona.servizioNonUtilizzabile"));
                }
            }
            if (!registrazioneDestinatarioEffettuataPerViaBehaviour && state instanceof OpenSPCoopStateless && !this.oneWayVersione11) {
                this.gestioneStatelessConIntegrationManager = true;
                if (idBustaPreBehaviourNewMessage == null && !registrazioneMessaggioPerStatelessEffettuata) {
                    this._forceSaveMessage(gestoreMessaggi, gestoreMessaggi.getOraRegistrazioneMessaggio(), busta, richiestaApplicativa, repositoryBuste, ((OpenSPCoopStateless)state).getRichiestaMsg(), state);
                    registrazioneMessaggioPerStatelessEffettuata = true;
                }
                gestoreMessaggi.setOneWayVersione11(true);
                gestoreMessaggi.registraDestinatarioMessaggio(servizioApplicativo, sbustamento_soap, sbustamento_informazioni_protocollo, getMessageAbilitato, tipoConsegna, oraRegistrazioneMessaggio, nomePorta);
                gestoreMessaggi.setOneWayVersione11(false);
            }
            this.msgDiag.logPersonalizzato("consegnaContenutiApplicativi.", "integrationManager.messaggioDisponibile");
        }
        this.gestioneSolamenteConIntegrationManager = gestioneSolamenteConIntegrationManager;
    }

    private void _forceSaveMessage(GestoreMessaggi gestoreMessaggi, Timestamp oraRegistrazione, Busta busta, RichiestaApplicativa richiestaApplicativa, RepositoryBuste repositoryBuste, OpenSPCoop2Message message, IOpenSPCoopState state) throws Exception {
        gestoreMessaggi.registraInformazioniMessaggio_statelessEngine(oraRegistrazione, "ConsegnaContenutiApplicativi", busta.getRiferimentoMessaggio(), richiestaApplicativa.getIdCorrelazioneApplicativa(), null);
        gestoreMessaggi.registraMessaggio_statelessEngine(message);
        String key = "INSERT RegistrazioneBustaForHistoryINBOX_" + busta.getID();
        if (repositoryBuste.isRegistrataIntoInBox(busta.getID())) {
            repositoryBuste.aggiornaBustaIntoInBox(busta, this.propertiesReader.getRepositoryIntervalloScadenzaMessaggi());
            repositoryBuste.impostaUtilizzoPdD(busta.getID(), "INBOX");
        } else if (((StateMessage)state.getStatoRichiesta()).getPreparedStatement().containsKey(key)) {
            repositoryBuste.aggiornaBustaIntoInBox(busta, this.propertiesReader.getRepositoryIntervalloScadenzaMessaggi());
            repositoryBuste.impostaUtilizzoPdD(busta.getID(), "INBOX");
        } else {
            repositoryBuste.registraBustaIntoInBox(busta, this.propertiesReader.getRepositoryIntervalloScadenzaMessaggi());
            if (!(state instanceof OpenSPCoopStateful) && busta.sizeProperties() > 0) {
                Hashtable<String, String> bustaProperties = new Hashtable<String, String>();
                String[] propertyNames = busta.getPropertiesNames();
                if (propertyNames != null) {
                    for (int i = 0; i < propertyNames.length; ++i) {
                        String keyP = propertyNames[i];
                        String valueP = busta.getProperty(key);
                        if (keyP == null || valueP == null) continue;
                        bustaProperties.put(keyP, valueP);
                    }
                }
                repositoryBuste.aggiornaProprietaBustaIntoInBox(bustaProperties, busta.getID());
            }
        }
    }

    public void sendAsRispostaBustaErroreProcessamento(String idModuloInAttesa, Busta busta, ErroreIntegrazione errore, String idCorrelazioneApplicativa, String servizioApplicativoFruitore, Exception eProcessamento) throws EJBUtilsException, ProtocolException {
        Eccezione ecc = new Eccezione(ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreProcessamento(errore.getDescrizione(this.protocolFactory)), false, this.idModulo, this.protocolFactory);
        Vector<Eccezione> errs = new Vector<Eccezione>();
        errs.add(ecc);
        this.sendAsRispostaBustaErroreProcessamento(idModuloInAttesa, busta, errs, idCorrelazioneApplicativa, null, servizioApplicativoFruitore, eProcessamento);
    }

    public void sendAsRispostaBustaErroreProcessamento(String idModuloInAttesa, Busta busta, ErroreIntegrazione errore, String idCorrelazioneApplicativa, String idCorrelazioneApplicativaRisposta, String servizioApplicativoFruitore, Exception eProcessamento) throws EJBUtilsException, ProtocolException {
        Eccezione ecc = new Eccezione(ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreProcessamento(errore.getDescrizione(this.protocolFactory)), false, this.idModulo, this.protocolFactory);
        Vector<Eccezione> errs = new Vector<Eccezione>();
        errs.add(ecc);
        this.sendAsRispostaBustaErroreProcessamento(idModuloInAttesa, busta, errs, idCorrelazioneApplicativa, idCorrelazioneApplicativaRisposta, servizioApplicativoFruitore, eProcessamento);
    }

    public void sendAsRispostaBustaErroreProcessamento(String idModuloInAttesa, Busta busta, Vector<Eccezione> errs, String idCorrelazioneApplicativa, String idCorrelazioneApplicativaRisposta, String servizioApplicativoFruitore, Exception eProcessamento) throws EJBUtilsException, ProtocolException {
        OpenSPCoop2Message errorMsg;
        String idTransazione = (String)this.pddContext.getObject("ID");
        SOAPVersion versioneSoap = (SOAPVersion)this.pddContext.getObject("SOAP_VERSION");
        Imbustamento imbustatore = new Imbustamento(this.protocolFactory);
        String id_bustaErrore = imbustatore.buildID(this.openSPCoopState.getStatoRichiesta(), this.identitaPdD, idTransazione, this.propertiesReader.getGestioneSerializableDB_AttesaAttiva(), this.propertiesReader.getGestioneSerializableDB_CheckInterval(), Boolean.FALSE);
        busta = imbustatore.buildMessaggioErroreProtocollo_Processamento(errs, busta, id_bustaErrore, this.propertiesReader.getTipoTempoBusta(this.implementazionePdDSoggettoMittente));
        DettaglioEccezione dettaglioEccezione = null;
        if (this.protocolManager.isGenerazioneDetailsSOAPFaultProtocollo_EccezioneProcessamento()) {
            dettaglioEccezione = this.dettaglioBuilder.buildDettaglioEccezioneFromBusta(this.identitaPdD, this.tipoPdD, this.idModulo, this.servizioApplicativoErogatore, busta, eProcessamento);
        }
        imbustatore.gestioneListaEccezioniMessaggioErroreProtocolloProcessamento(busta);
        if (!this.identitaPdD.getNome().equals(busta.getMittente()) || !this.identitaPdD.getTipo().equals(busta.getTipoMittente())) {
            busta.setMittente(this.identitaPdD.getNome());
            busta.setTipoMittente(this.identitaPdD.getTipo());
            busta.setIdentificativoPortaMittente(this.identitaPdD.getCodicePorta());
            busta.setIndirizzoMittente(null);
        }
        if ((errorMsg = imbustatore.buildSoapMsgErroreProtocollo_Processamento(dettaglioEccezione, versioneSoap, this.propertiesReader.isForceSoapPrefixCompatibilitaOpenSPCoopV1())) == null) {
            throw new EJBUtilsException("EJBUtils.sendRispostaErroreProcessamentoProtocollo error: Costruzione Msg Errore Protocollo fallita.");
        }
        this.sendAsRispostaBustaErrore(idModuloInAttesa, busta, errorMsg, false, idCorrelazioneApplicativa, idCorrelazioneApplicativaRisposta, servizioApplicativoFruitore);
    }

    public void sendAsRispostaBustaErroreValidazione(String idModuloInAttesa, Busta busta, Eccezione eccezione, String idCorrelazioneApplicativa, String servizioApplicativoFruitore) throws EJBUtilsException, ProtocolException {
        Vector<Eccezione> v = new Vector<Eccezione>();
        v.add(eccezione);
        this.sendAsRispostaBustaErroreValidazione(idModuloInAttesa, busta, v, idCorrelazioneApplicativa, null, servizioApplicativoFruitore);
    }

    public void sendAsRispostaBustaErroreValidazione(String idModuloInAttesa, Busta busta, Eccezione eccezione, String idCorrelazioneApplicativa, String idCorrelazioneApplicativaRisposta, String servizioApplicativoFruitore) throws EJBUtilsException, ProtocolException {
        Vector<Eccezione> v = new Vector<Eccezione>();
        v.add(eccezione);
        this.sendAsRispostaBustaErroreValidazione(idModuloInAttesa, busta, v, idCorrelazioneApplicativa, idCorrelazioneApplicativaRisposta, servizioApplicativoFruitore);
    }

    public void sendAsRispostaBustaErroreValidazione(String idModuloInAttesa, Busta busta, Vector<Eccezione> eccezioni, String idCorrelazioneApplicativa, String idCorrelazioneApplicativaRisposta, String servizioApplicativoFruitore) throws EJBUtilsException, ProtocolException {
        OpenSPCoop2Message msg;
        SOAPVersion versioneSoap = (SOAPVersion)this.pddContext.getObject("SOAP_VERSION");
        Imbustamento imbustatore = new Imbustamento(this.protocolFactory);
        String id_bustaErrore = imbustatore.buildID(this.openSPCoopState.getStatoRichiesta(), this.identitaPdD, (String)this.pddContext.getObject("ID"), this.propertiesReader.getGestioneSerializableDB_AttesaAttiva(), this.propertiesReader.getGestioneSerializableDB_CheckInterval(), Boolean.FALSE);
        busta = imbustatore.buildMessaggioErroreProtocollo_Validazione(eccezioni, busta, id_bustaErrore, this.propertiesReader.getTipoTempoBusta(this.implementazionePdDSoggettoMittente));
        if (!this.identitaPdD.getNome().equals(busta.getMittente()) || !this.identitaPdD.getTipo().equals(busta.getTipoMittente())) {
            busta.setMittente(this.identitaPdD.getNome());
            busta.setTipoMittente(this.identitaPdD.getTipo());
            busta.setIdentificativoPortaMittente(this.identitaPdD.getCodicePorta());
            busta.setIndirizzoMittente(null);
        }
        if ((msg = imbustatore.buildSoapMsgErroreProtocollo_Validazione(versioneSoap, this.propertiesReader.isForceSoapPrefixCompatibilitaOpenSPCoopV1())) == null) {
            throw new EJBUtilsException("EJBUtils.sendRispostaErroreValidazioneProtocollo error: Costruzione messaggio Errore Protocollo fallita.");
        }
        this.sendAsRispostaBustaErrore(idModuloInAttesa, busta, msg, false, idCorrelazioneApplicativa, idCorrelazioneApplicativaRisposta, servizioApplicativoFruitore);
    }

    public void sendAsRispostaBustaErrore_inoltroSegnalazioneErrore(Busta busta, Vector<Eccezione> eccezioni) throws EJBUtilsException, ProtocolException {
        String idTransazione = (String)this.pddContext.getObject("ID");
        SOAPVersion versioneSoap = (SOAPVersion)this.pddContext.getObject("SOAP_VERSION");
        Imbustamento imbustatore = new Imbustamento(this.protocolFactory);
        String id_bustaErrore = imbustatore.buildID(this.openSPCoopState.getStatoRichiesta(), this.identitaPdD, idTransazione, this.propertiesReader.getGestioneSerializableDB_AttesaAttiva(), this.propertiesReader.getGestioneSerializableDB_CheckInterval(), Boolean.FALSE);
        busta = imbustatore.buildMessaggioErroreProtocollo_Validazione(eccezioni, busta, id_bustaErrore, this.propertiesReader.getTipoTempoBusta(this.implementazionePdDSoggettoDestinatario));
        OpenSPCoop2Message msg = imbustatore.buildSoapMsgErroreProtocollo_Validazione(versioneSoap, this.propertiesReader.isForceSoapPrefixCompatibilitaOpenSPCoopV1());
        if (msg == null) {
            throw new EJBUtilsException("EJBUtils.sendRispostaErroreProtocollo_BustaRispostaMalformata error: Costruzione Msg Errore Protocollo fallita.");
        }
        this.sendAsRispostaBustaErrore(null, busta, msg, true, null, null, null);
    }

    private void sendAsRispostaBustaErrore(String idModuloInAttesa, Busta busta, OpenSPCoop2Message msg, boolean segnalazioneBustaRispostaMalformata, String idCorrelazioneApplicativa, String idCorrelazioneApplicativaRisposta, String servizioApplicativoFruitore) throws EJBUtilsException {
        StateMessage statoRichiesta = (StateMessage)this.openSPCoopState.getStatoRichiesta();
        StateMessage statoRisposta = (StateMessage)this.openSPCoopState.getStatoRisposta();
        RollbackRepositoryBuste rollbackBuste = null;
        RepositoryBuste repositoryBuste = null;
        GestoreMessaggi msgRequest = null;
        GestoreMessaggi msgResponse = null;
        this.setEJBSuffixFunctionName();
        try {
            boolean addIntoCache = false;
            if (this.rollbackRichiestaInCasoErrore) {
                rollbackBuste = new RollbackRepositoryBuste(this.idSessione, (IState)statoRichiesta, this.oneWayVersione11);
                if (this.routing) {
                    rollbackBuste.rollbackBustaIntoOutBox(this.rollbackRichiestaInCasoErrore_rollbackHistory);
                } else {
                    rollbackBuste.rollbackBustaIntoInBox(this.rollbackRichiestaInCasoErrore_rollbackHistory);
                }
                if (!segnalazioneBustaRispostaMalformata && this.idMessage != null) {
                    msgRequest = new GestoreMessaggi(this.openSPCoopState, true, this.idMessage, this.tipo, this.msgDiag, this.pddContext);
                    msgRequest.setOneWayVersione11(this.oneWayVersione11);
                    if (msgRequest.existsMessage_noCache()) {
                        msgRequest.aggiornaProprietarioMessaggio("GestoreMessaggi");
                        addIntoCache = true;
                    } else {
                        addIntoCache = false;
                    }
                }
            } else {
                msgRequest = new GestoreMessaggi(this.openSPCoopState, true, this.idMessage, this.tipo, this.msgDiag, this.pddContext);
                addIntoCache = false;
            }
            boolean httpReply = true;
            if (this.replyOnNewConnection) {
                httpReply = false;
            }
            if (busta.getIndirizzoDestinatario() != null && this.utilizzoIndirizzoTelematico) {
                httpReply = false;
            }
            if (segnalazioneBustaRispostaMalformata) {
                httpReply = false;
            }
            if (!httpReply || idModuloInAttesa != null) {
                boolean salvaSuDatabasePerStateless = false;
                if (!httpReply) {
                    salvaSuDatabasePerStateless = true;
                }
                repositoryBuste = new RepositoryBuste((IState)statoRisposta, salvaSuDatabasePerStateless, this.protocolFactory);
                repositoryBuste.registraBustaIntoOutBox(busta, this.propertiesReader.getRepositoryIntervalloScadenzaMessaggi());
                Integrazione infoIntegrazione = new Integrazione();
                infoIntegrazione.setIdModuloInAttesa(idModuloInAttesa);
                infoIntegrazione.setScenario(this.scenarioCooperazione);
                repositoryBuste.aggiornaInfoIntegrazioneIntoOutBox(busta.getID(), infoIntegrazione);
                msgResponse = new GestoreMessaggi(this.openSPCoopState, salvaSuDatabasePerStateless, busta.getID(), "OUTBOX", this.msgDiag, this.pddContext);
                if (!httpReply) {
                    msgResponse.setOneWayVersione11(this.oneWayVersione11);
                }
                if (this.openSPCoopState instanceof OpenSPCoopStateless) {
                    msgResponse.registraMessaggio(msg, ((OpenSPCoopStateless)this.openSPCoopState).getTempiAttraversamentoPDD().getRicezioneMsgIngresso(), idCorrelazioneApplicativa, idCorrelazioneApplicativaRisposta);
                } else {
                    msgResponse.registraMessaggio(msg, idCorrelazioneApplicativa, idCorrelazioneApplicativaRisposta);
                }
                msgResponse.aggiornaRiferimentoMessaggio(this.idSessione);
                if (!httpReply) {
                    msgResponse.aggiornaProprietarioMessaggio("InoltroRisposte");
                } else if (idModuloInAttesa != null) {
                    msgResponse.aggiornaProprietarioMessaggio(idModuloInAttesa);
                }
                if (!httpReply) {
                    this.sendToInoltroRisposte(busta, segnalazioneBustaRispostaMalformata, null, msgResponse, idCorrelazioneApplicativa, idCorrelazioneApplicativaRisposta, servizioApplicativoFruitore, true);
                } else if (idModuloInAttesa != null) {
                    this.sendBustaToRicezioneBuste(idModuloInAttesa, busta, null);
                }
            }
            this.openSPCoopState.commit();
            if (msgResponse != null) {
                msgResponse.addMessaggiIntoCache_readFromTable(this.idModulo, "sendRispostaErroreProtocollo [risposta]");
            }
            if (addIntoCache) {
                String idRichiestaCorrelata = null;
                if (!this.idMessage.equals(this.idSessione)) {
                    idRichiestaCorrelata = this.idSessione;
                }
                msgRequest.addProprietariIntoCache_readFromTable(this.idModulo, "sendRispostaErroreProtocollo [richiesta]", idRichiestaCorrelata, this.functionAsRouter);
            }
            if (msgResponse != null) {
                msgResponse.addProprietariIntoCache_readFromTable(this.idModulo, "sendRispostaErroreProtocollo [risposta]", this.idSessione, this.functionAsRouter);
            }
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "EJBUtils.sendRispostaErroreProtocollo");
            statoRichiesta.closePreparedStatement();
            statoRisposta.closePreparedStatement();
            throw new EJBUtilsException("EJBUtils.sendRispostaErroreProtocollo error: " + e.getMessage(), e);
        }
        finally {
            this.unsetEJBSuffixFunctionName();
        }
    }

    public GestoreMessaggi sendSbloccoRicezioneBuste(String idModuloInAttesa) throws EJBUtilsException, ProtocolException {
        String idTransazione = (String)this.pddContext.getObject("ID");
        SOAPVersion versioneSoap = (SOAPVersion)this.pddContext.getObject("SOAP_VERSION");
        Imbustamento imbustatore = new Imbustamento(this.protocolFactory);
        String idSblocco = imbustatore.buildID(this.openSPCoopState.getStatoRichiesta(), this.identitaPdD, idTransazione, this.propertiesReader.getGestioneSerializableDB_AttesaAttiva(), this.propertiesReader.getGestioneSerializableDB_CheckInterval(), Boolean.FALSE);
        return this.sendBustaRisposta(idModuloInAttesa, null, SoapUtils.build_Soap_Empty((SOAPVersion)versioneSoap), idSblocco, null, null, null, null);
    }

    public GestoreMessaggi sendSOAPFault(String idModuloInAttesa, OpenSPCoop2Message msg) throws EJBUtilsException, ProtocolException {
        String idTransazione = (String)this.pddContext.getObject("ID");
        Imbustamento imbustatore = new Imbustamento(this.protocolFactory);
        String idSblocco = imbustatore.buildID(this.openSPCoopState.getStatoRichiesta(), this.identitaPdD, idTransazione, this.propertiesReader.getGestioneSerializableDB_AttesaAttiva(), this.propertiesReader.getGestioneSerializableDB_CheckInterval(), Boolean.FALSE);
        return this.sendBustaRisposta(idModuloInAttesa, null, msg, idSblocco, null, null, null, null);
    }

    public GestoreMessaggi buildAndSendBustaRisposta(String idModuloInAttesa, Busta busta, OpenSPCoop2Message msg, String profiloGestione, String idCorrelazioneApplicativa, String servizioApplicativoFruitore) throws EJBUtilsException, ProtocolException {
        return this.buildAndSendBustaRisposta(idModuloInAttesa, busta, msg, profiloGestione, idCorrelazioneApplicativa, null, servizioApplicativoFruitore);
    }

    public GestoreMessaggi buildAndSendBustaRisposta(String idModuloInAttesa, Busta busta, OpenSPCoop2Message msg, String profiloGestione, String idCorrelazioneApplicativa, String idCorrelazioneApplicativaRisposta, String servizioApplicativoFruitore) throws EJBUtilsException, ProtocolException {
        String idTransazione = (String)this.pddContext.getObject("ID");
        Imbustamento imbustatore = new Imbustamento(this.protocolFactory);
        String id_busta = imbustatore.buildID(this.openSPCoopState.getStatoRichiesta(), this.identitaPdD, idTransazione, this.propertiesReader.getGestioneSerializableDB_AttesaAttiva(), this.propertiesReader.getGestioneSerializableDB_CheckInterval(), Boolean.FALSE);
        if (busta != null) {
            busta.setID(id_busta);
        }
        return this.sendBustaRisposta(idModuloInAttesa, busta, msg, null, profiloGestione, idCorrelazioneApplicativa, idCorrelazioneApplicativaRisposta, servizioApplicativoFruitore);
    }

    public GestoreMessaggi sendBustaRisposta(String idModuloInAttesa, Busta busta, String profiloGestione, String idCorrelazioneApplicativa, String idCorrelazioneApplicativaRisposta, String servizioApplicativoFruitore) throws EJBUtilsException {
        return this.sendBustaRisposta(idModuloInAttesa, busta, null, null, profiloGestione, idCorrelazioneApplicativa, idCorrelazioneApplicativaRisposta, servizioApplicativoFruitore);
    }

    private GestoreMessaggi sendBustaRisposta(String idModuloInAttesa, Busta busta, OpenSPCoop2Message msg, String idSbloccoModulo, String profiloGestione, String idCorrelazioneApplicativa, String idCorrelazioneApplicativaRisposta, String servizioApplicativoFruitore) throws EJBUtilsException {
        IState statoRisposta = this.openSPCoopState.getStatoRisposta();
        GestoreMessaggi msgResponse = null;
        this.setEJBSuffixFunctionName();
        try {
            boolean httpReply = true;
            if (idSbloccoModulo == null) {
                if (this.replyOnNewConnection) {
                    httpReply = false;
                }
                if (busta != null && busta.getIndirizzoDestinatario() != null && this.utilizzoIndirizzoTelematico) {
                    httpReply = false;
                }
            }
            if (!httpReply || idModuloInAttesa != null) {
                boolean salvaSuDatabasePerStateless = false;
                if (!httpReply && !this.functionAsRouter && this.openSPCoopState instanceof OpenSPCoopStateless) {
                    salvaSuDatabasePerStateless = true;
                }
                if (busta != null) {
                    RepositoryBuste repositoryRisposta = new RepositoryBuste(statoRisposta, this.log, salvaSuDatabasePerStateless, this.protocolFactory);
                    repositoryRisposta.registraBustaIntoOutBox(busta, this.propertiesReader.getRepositoryIntervalloScadenzaMessaggi());
                    Integrazione infoIntegrazione = new Integrazione();
                    infoIntegrazione.setIdModuloInAttesa(idModuloInAttesa);
                    infoIntegrazione.setScenario(this.scenarioCooperazione);
                    repositoryRisposta.aggiornaInfoIntegrazioneIntoOutBox(busta.getID(), infoIntegrazione);
                }
                String idRisposta = null;
                idRisposta = busta != null ? busta.getID() : idSbloccoModulo;
                msgResponse = new GestoreMessaggi(this.openSPCoopState, salvaSuDatabasePerStateless, idRisposta, "OUTBOX", this.msgDiag, this.pddContext);
                if (!httpReply) {
                    msgResponse.setOneWayVersione11(this.oneWayVersione11);
                }
                if (msg != null) {
                    if (this.openSPCoopState instanceof OpenSPCoopStateless) {
                        msgResponse.registraMessaggio(msg, ((OpenSPCoopStateless)this.openSPCoopState).getTempiAttraversamentoPDD().getRicezioneMsgIngresso(), idCorrelazioneApplicativa, idCorrelazioneApplicativaRisposta);
                    } else {
                        msgResponse.registraMessaggio(msg, idCorrelazioneApplicativa, idCorrelazioneApplicativaRisposta);
                    }
                }
                msgResponse.aggiornaRiferimentoMessaggio(this.idSessione);
                if (!httpReply) {
                    msgResponse.aggiornaProprietarioMessaggio("InoltroRisposte");
                } else if (idModuloInAttesa != null) {
                    msgResponse.aggiornaProprietarioMessaggio(idModuloInAttesa);
                }
                if (!httpReply) {
                    this.sendToInoltroRisposte(busta, false, profiloGestione, msgResponse, idCorrelazioneApplicativa, idCorrelazioneApplicativaRisposta, servizioApplicativoFruitore, true);
                } else if (idModuloInAttesa != null) {
                    this.sendBustaToRicezioneBuste(idModuloInAttesa, busta, idSbloccoModulo);
                }
            }
            GestoreMessaggi gestoreMessaggi = msgResponse;
            return gestoreMessaggi;
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "EJBUtils.sendRispostaProtocollo");
            if (msgResponse != null) {
                ((StateMessage)statoRisposta).closePreparedStatement();
            }
            throw new EJBUtilsException("EJBUtils.sendRispostaProtocollo error: " + e.getMessage(), e);
        }
        finally {
            this.unsetEJBSuffixFunctionName();
        }
    }

    public void sendToInoltroRisposte(Busta busta, boolean inoltroSegnalazioneErrore, String profiloGestione, GestoreMessaggi gm, String idCorrelazioneApplicativa, String idCorrelazioneApplicativaRisposta, String servizioApplicativoFruitore, boolean imbustamento) throws EJBUtilsException {
        if (this.openSPCoopState instanceof OpenSPCoopStateful || this.oneWayVersione11) {
            try {
                this.msgDiag.highDebug("[EJBUtils] Creazione ObjectMessage for send nell'infrastruttura.");
                InoltroRisposteMessage inoltroMSG = new InoltroRisposteMessage();
                inoltroMSG.setDominio(this.identitaPdD);
                inoltroMSG.setInoltroSegnalazioneErrore(inoltroSegnalazioneErrore);
                inoltroMSG.setBustaRisposta(busta);
                inoltroMSG.setProfiloGestione(profiloGestione);
                inoltroMSG.setOneWayVersione11(this.oneWayVersione11);
                inoltroMSG.setIdCorrelazioneApplicativa(idCorrelazioneApplicativa);
                inoltroMSG.setIdCorrelazioneApplicativaRisposta(idCorrelazioneApplicativaRisposta);
                inoltroMSG.setServizioApplicativoFruitore(servizioApplicativoFruitore);
                inoltroMSG.setImbustamento(imbustamento);
                inoltroMSG.setImplementazionePdDSoggettoMittente(this.implementazionePdDSoggettoMittente);
                inoltroMSG.setImplementazionePdDSoggettoDestinatario(this.implementazionePdDSoggettoDestinatario);
                inoltroMSG.setPddContext(this.pddContext);
                if (this.oneWayVersione11) {
                    OpenSPCoopStateless statelessSerializzabile = ((OpenSPCoopStateless)this.openSPCoopState).rendiSerializzabile();
                    inoltroMSG.setOpenspcoopstate(statelessSerializzabile);
                }
                this.nodeSender.send(inoltroMSG, "InoltroRisposte", this.msgDiag, this.identitaPdD, this.idModulo, this.idSessione, gm);
            }
            catch (Exception e) {
                this.log.error((Object)"Spedizione->InoltroRisposte non riuscita", (Throwable)e);
                this.msgDiag.logErroreGenerico(e, "EJBUtils.sendToInoltroRisposte");
                throw new EJBUtilsException("EJBUtils.sendToInoltroRisposte error: " + e.getMessage(), e);
            }
        }
    }

    public OpenSPCoop2Message buildOpenSPCoopOK_soapMsg(SOAPVersion versioneSoap, String id) throws UtilsException {
        try {
            OpenSPCoop2MessageFactory mf = OpenSPCoop2MessageFactory.getMessageFactory();
            OpenSPCoop2Message responseSOAPMessage = mf.createMessage(versioneSoap);
            SOAPBody soapBody = responseSOAPMessage.getSOAPBody();
            EsitoRichiesta esito = new EsitoRichiesta();
            esito.setIdentificativoMessaggio(id);
            esito.setStato("PRESA_IN_CARICO");
            byte[] xmlEsito = EsitoRichiestaXMLUtils.generateEsitoRichiesta((EsitoRichiesta)esito);
            soapBody.addChildElement(responseSOAPMessage.createSOAPElement(xmlEsito));
            return responseSOAPMessage;
        }
        catch (Exception e) {
            throw new UtilsException("Creazione MsgOpenSPCoopOK non riuscito: " + e.getMessage(), (Throwable)e);
        }
    }

    public byte[] buildOpenSPCoopOK(SOAPVersion versioneSoap, String id) throws UtilsException {
        try {
            EsitoRichiesta esito = new EsitoRichiesta();
            esito.setIdentificativoMessaggio(id);
            esito.setStato("PRESA_IN_CARICO");
            return EsitoRichiestaXMLUtils.generateEsitoRichiesta((EsitoRichiesta)esito);
        }
        catch (Exception e) {
            throw new UtilsException("Creazione MsgOpenSPCoopOK non riuscito: " + e.getMessage(), (Throwable)e);
        }
    }

    public void sendBustaToRicezioneBuste(String idModuloInAttesa, Busta busta, String idSbloccoModulo) throws EJBUtilsException {
        RicezioneBusteMessage ricezioneMSG;
        if (this.openSPCoopState instanceof OpenSPCoopStateless) {
            ricezioneMSG = new RicezioneBusteMessage();
            ricezioneMSG.setBustaRisposta(busta);
            ricezioneMSG.setIdMessaggioSblocco(idSbloccoModulo);
            ricezioneMSG.setPddContext(this.pddContext);
            ((OpenSPCoopStateless)this.openSPCoopState).setMessageLib(ricezioneMSG);
        }
        if ("jms".equals(this.propertiesReader.getNodeReceiver())) {
            try {
                this.msgDiag.highDebug("Creazione ObjectMessage for send via JMS.");
                ricezioneMSG = new RicezioneBusteMessage();
                ricezioneMSG.setBustaRisposta(busta);
                ricezioneMSG.setIdMessaggioSblocco(idSbloccoModulo);
                ricezioneMSG.setPddContext(this.pddContext);
                if (this.openSPCoopState instanceof OpenSPCoopStateless) {
                    ((OpenSPCoopStateless)this.openSPCoopState).setMessageLib(ricezioneMSG);
                } else {
                    String idT = PdDContext.getValue("ID", this.pddContext);
                    JMSSender senderJMS = new JMSSender(this.identitaPdD, this.idModulo, this.log, idT);
                    Properties prop = new Properties();
                    prop.put("ID", this.idSessione);
                    if (!senderJMS.send(idModuloInAttesa, (Serializable)ricezioneMSG, prop)) {
                        this.msgDiag.logErroreGenerico(senderJMS.getErrore(), "EJBUtils.sendBustaToRicezioneBuste.senderJMS");
                        throw new Exception("SendJMSError: " + senderJMS.getErrore());
                    }
                    this.msgDiag.highDebug("ObjectMessage send via JMS.");
                }
            }
            catch (Exception e) {
                this.msgDiag.logErroreGenerico(e, "EJBUtils.sendBustaToRicezioneBuste");
                throw new EJBUtilsException("EJBUtils.sendToRicezioneBuste error: " + e.getMessage(), e);
            }
        }
    }

    public void setScenarioCooperazione(String scenarioCooperazione) {
        this.scenarioCooperazione = scenarioCooperazione;
    }

    public Timestamp getRicezioneMsgRisposta() {
        return this.ricezioneMsgRisposta;
    }

    public void setRicezioneMsgRisposta(Timestamp ricezioneMsgRisposta) {
        this.ricezioneMsgRisposta = ricezioneMsgRisposta;
    }

    public Timestamp getSpedizioneMsgIngresso() {
        return this.spedizioneMsgIngresso;
    }

    public void setSpedizioneMsgIngresso(Timestamp spedizioneMsgIngresso) {
        this.spedizioneMsgIngresso = spedizioneMsgIngresso;
    }

    public boolean saveMessageStateless(PortaDelegata pd) throws Exception {
        ProfiloDiCollaborazione profiloCollaborazione = EJBUtils.calcolaProfiloCollaborazione(this.scenarioCooperazione);
        return this.configurazionePdDReader.isModalitaStateless(pd, profiloCollaborazione);
    }

    public void setOneWayVersione11(boolean oneWay11) {
        this.oneWayVersione11 = oneWay11;
    }

    public void setPortaDiTipoStateless_esclusoOneWay11(boolean stateless) {
        this.portaDiTipoStateless_esclusoOneWay11 = stateless;
    }

    public void setRouting(boolean routing) {
        this.routing = routing;
    }

    public void setRollbackRichiestaInCasoErrore(boolean rollbackRichiestaInCasoErrore) {
        this.rollbackRichiestaInCasoErrore = rollbackRichiestaInCasoErrore;
    }

    public void setRollbackRichiestaInCasoErrore_rollbackHistory(boolean rollbackRichiestaInCasoErrore_rollbackHistory) {
        this.rollbackRichiestaInCasoErrore_rollbackHistory = rollbackRichiestaInCasoErrore_rollbackHistory;
    }

    public static ProfiloDiCollaborazione calcolaProfiloCollaborazione(String scenarioCooperazione) {
        ProfiloDiCollaborazione profiloCollaborazione = null;
        if ("OneWay_InvocazioneServizio".equals(scenarioCooperazione)) {
            profiloCollaborazione = ProfiloDiCollaborazione.ONEWAY;
        } else if ("Sincrono_InvocazioneServizio".equals(scenarioCooperazione)) {
            profiloCollaborazione = ProfiloDiCollaborazione.SINCRONO;
        } else if ("AsincronoAsimmetrico_Polling".equals(scenarioCooperazione) || "AsincronoAsimmetrico_InvocazioneServizio".equals(scenarioCooperazione)) {
            profiloCollaborazione = ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO;
        } else if ("AsincronoSimmetrico_InvocazioneServizio".equals(scenarioCooperazione) || "AsincronoSimmetrico_ConsegnaRisposta".equals(scenarioCooperazione)) {
            profiloCollaborazione = ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO;
        }
        return profiloCollaborazione;
    }

    public String getServizioApplicativoErogatore() {
        return this.servizioApplicativoErogatore;
    }

    public void setServizioApplicativoErogatore(String servizioApplicativoErogatore) {
        this.servizioApplicativoErogatore = servizioApplicativoErogatore;
    }
}

