/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.config;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.jms.Session;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.IMonitoraggioRisorsa;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.pdd.config.JMSObject;
import org.openspcoop2.pdd.config.OpenSPCoop2ConfigurationException;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.Resource;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.resources.GestoreJNDI;

public class QueueManager
implements Serializable,
IMonitoraggioRisorsa {
    private static final long serialVersionUID = 2542909452367582138L;
    public static Queue QUEUE_RICEZIONE_CONTENUTI_APPLICATIVI;
    public static Queue QUEUE_RICEZIONE_BUSTE;
    public static Queue QUEUE_IMBUSTAMENTO;
    public static Queue QUEUE_IMBUSTAMENTO_RISPOSTE;
    public static Queue QUEUE_SBUSTAMENTO;
    public static Queue QUEUE_SBUSTAMENTO_RISPOSTE;
    public static Queue QUEUE_INOLTRO_BUSTE;
    public static Queue QUEUE_INOLTRO_RISPOSTE;
    public static Queue QUEUE_CONSEGNA_CONTENUTI_APPLICATIVI;
    private static OpenSPCoop2Properties openspcoopProperties;
    protected static Hashtable<String, Resource> risorseInGestione;
    private static QueueManager manager;
    private ConnectionFactory qcf = null;
    private MsgDiagnostico msgDiag = new MsgDiagnostico("WrapperQueueManager", new IState[0]);

    public static String[] getStatoRisorse() throws Exception {
        Resource[] o = risorseInGestione.values().toArray(new Resource[0]);
        if (o == null) {
            return null;
        }
        Resource[] resources = o;
        if (resources == null || resources.length <= 0) {
            return null;
        }
        String[] r = new String[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            Resource rr = resources[i];
            r[i] = rr.getIdentificativoPorta() + "." + rr.getModuloFunzionale();
            if (rr.getIdTransazione() != null) {
                r[i] = r[i] + "." + rr.getIdTransazione();
            }
            r[i] = r[i] + " (" + rr.getDate().toString() + ")";
        }
        return r;
    }

    public static void initialize(String jndiName, Properties contextFactory) throws Exception {
        manager = new QueueManager(jndiName, contextFactory);
    }

    public static void initializeQueueNodeReceiver(Properties contextQueue) throws Exception {
        Hashtable<String, String> nomiJndi = OpenSPCoop2Properties.getInstance().getJNDIQueueName(true, false);
        GestoreJNDI jndiQueue = new GestoreJNDI(contextQueue);
        QUEUE_RICEZIONE_CONTENUTI_APPLICATIVI = (Queue)jndiQueue.lookup(nomiJndi.get("RicezioneContenutiApplicativi"));
        QUEUE_RICEZIONE_BUSTE = (Queue)jndiQueue.lookup(nomiJndi.get("RicezioneBuste"));
    }

    public static void initializeQueueNodeSender(Properties contextQueue) throws Exception {
        Hashtable<String, String> nomiJndi = OpenSPCoop2Properties.getInstance().getJNDIQueueName(false, true);
        GestoreJNDI jndiQueue = new GestoreJNDI(contextQueue);
        QUEUE_IMBUSTAMENTO = (Queue)jndiQueue.lookup(nomiJndi.get("Imbustamento"));
        QUEUE_IMBUSTAMENTO_RISPOSTE = (Queue)jndiQueue.lookup(nomiJndi.get("ImbustamentoRisposte"));
        QUEUE_SBUSTAMENTO = (Queue)jndiQueue.lookup(nomiJndi.get("Sbustamento"));
        QUEUE_SBUSTAMENTO_RISPOSTE = (Queue)jndiQueue.lookup(nomiJndi.get("SbustamentoRisposte"));
        QUEUE_INOLTRO_BUSTE = (Queue)jndiQueue.lookup(nomiJndi.get("InoltroBuste"));
        QUEUE_INOLTRO_RISPOSTE = (Queue)jndiQueue.lookup(nomiJndi.get("InoltroRisposte"));
        QUEUE_CONSEGNA_CONTENUTI_APPLICATIVI = (Queue)jndiQueue.lookup(nomiJndi.get("ConsegnaContenutiApplicativi"));
    }

    public static QueueManager getInstance() {
        return manager;
    }

    public Queue getQueue(String idNodo) throws Exception {
        if (idNodo.startsWith("RicezioneContenutiApplicativi")) {
            return QUEUE_RICEZIONE_CONTENUTI_APPLICATIVI;
        }
        if (idNodo.startsWith("RicezioneBuste")) {
            return QUEUE_RICEZIONE_BUSTE;
        }
        if ("Imbustamento".equals(idNodo)) {
            return QUEUE_IMBUSTAMENTO;
        }
        if ("ImbustamentoRisposte".equals(idNodo)) {
            return QUEUE_IMBUSTAMENTO_RISPOSTE;
        }
        if ("Sbustamento".equals(idNodo)) {
            return QUEUE_SBUSTAMENTO;
        }
        if ("SbustamentoRisposte".equals(idNodo)) {
            return QUEUE_SBUSTAMENTO_RISPOSTE;
        }
        if ("InoltroBuste".equals(idNodo)) {
            return QUEUE_INOLTRO_BUSTE;
        }
        if ("InoltroRisposte".equals(idNodo)) {
            return QUEUE_INOLTRO_RISPOSTE;
        }
        if ("ConsegnaContenutiApplicativi".equals(idNodo)) {
            return QUEUE_CONSEGNA_CONTENUTI_APPLICATIVI;
        }
        return null;
    }

    public QueueManager(String jndiName, Properties context) throws OpenSPCoop2ConfigurationException {
        try {
            GestoreJNDI jndi = new GestoreJNDI(context);
            this.qcf = (ConnectionFactory)jndi.lookup(jndiName);
        }
        catch (Exception e) {
            throw new OpenSPCoop2ConfigurationException("WrapperQueueManager: " + e.getMessage(), e);
        }
    }

    public Resource getResource(IDSoggetto idPDD, String modulo, String idTransazione) throws OpenSPCoop2ConfigurationException {
        Resource risorsa = new Resource();
        try {
            Connection con = this.qcf.createConnection();
            if (con == null) {
                throw new OpenSPCoop2ConfigurationException("ConnessioneNonDisponibile");
            }
            Session s = con.createSession(false, openspcoopProperties.getAcknowledgeModeSessioneConnectionFactory());
            if (s == null) {
                con.close();
                throw new OpenSPCoop2ConfigurationException("SessioneNonDisponibile");
            }
            JMSObject jms = new JMSObject();
            jms.setConnection(con);
            jms.setSession(s);
            String idUnivoco = Resource.generaIdentificatoreUnivoco(idPDD, modulo);
            risorsa.setId(idUnivoco);
            risorsa.setDate(DateManager.getDate());
            risorsa.setIdentificativoPorta(idPDD);
            risorsa.setModuloFunzionale(modulo);
            risorsa.setResource(jms);
            risorsa.setResourceType(JMSObject.class.getName());
            risorsa.setIdTransazione(idTransazione);
            risorseInGestione.put(idUnivoco, risorsa);
            return risorsa;
        }
        catch (Exception e) {
            this.msgDiag.aggiornaFiltri();
            this.msgDiag.setDominio(idPDD);
            this.msgDiag.setFunzione("QueueManager." + modulo);
            this.msgDiag.logFatalError(e, "Richiesta connessione al QueueManager");
            throw new OpenSPCoop2ConfigurationException("getJMSObject: " + e.getMessage());
        }
    }

    public void releaseResource(IDSoggetto idPDD, String modulo, Resource resource) throws OpenSPCoop2ConfigurationException {
        block9: {
            try {
                if (resource == null) break block9;
                if (resource.getResource() != null) {
                    JMSObject jms = (JMSObject)resource.getResource();
                    if (jms == null) {
                        throw new OpenSPCoop2ConfigurationException("PassivateObject[JMSObjectNull]");
                    }
                    if (jms.getConnection() == null) {
                        throw new OpenSPCoop2ConfigurationException("PassivateObject[ConnectionNull]");
                    }
                    if (jms.getSession() == null) {
                        throw new OpenSPCoop2ConfigurationException("PassivateObject[SessionNull]");
                    }
                    try {
                        jms.getSession().close();
                    }
                    catch (Exception e) {
                        jms.getConnection().close();
                        throw e;
                    }
                    jms.getConnection().close();
                }
                if (risorseInGestione.containsKey(resource.getId())) {
                    risorseInGestione.remove(resource.getId());
                }
            }
            catch (Exception e) {
                this.msgDiag.aggiornaFiltri();
                this.msgDiag.setDominio(idPDD);
                this.msgDiag.setFunzione("QueueManager." + modulo);
                this.msgDiag.logFatalError(e, "Rilasciata connessione al QueueManager");
                throw new OpenSPCoop2ConfigurationException("releaseJMSObject: " + e.getMessage());
            }
        }
    }

    public void isAlive() throws CoreException {
        Resource resource = null;
        IDSoggetto idSoggettAlive = new IDSoggetto();
        idSoggettAlive.setCodicePorta("QueueManager");
        idSoggettAlive.setTipo("QueueManager");
        idSoggettAlive.setNome("QueueManager");
        try {
            resource = this.getResource(idSoggettAlive, "CheckIsAlive", null);
            if (resource == null) {
                throw new Exception("Resource is null");
            }
            if (resource.getResource() == null) {
                throw new Exception("JMSObject is null");
            }
            JMSObject jmsObject = (JMSObject)resource.getResource();
            if (jmsObject.getConnection() == null) {
                throw new Exception("Connessione is null");
            }
            if (jmsObject.getSession() == null) {
                throw new Exception("Sessione is null");
            }
            Connection connectionJMS = jmsObject.getConnection();
            connectionJMS.getClientID();
        }
        catch (Exception e) {
            throw new CoreException("Connessione al broker JMS non disponibile: " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                this.releaseResource(idSoggettAlive, "CheckIsAlive", resource);
            }
            catch (Exception e) {}
        }
    }

    static {
        openspcoopProperties = OpenSPCoop2Properties.getInstance();
        risorseInGestione = new Hashtable();
        manager = null;
    }
}

