/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.config;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.sql.DataSource;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.IMonitoraggioRisorsa;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.pdd.config.Resource;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.resources.GestoreJNDI;

public class DBManager
implements IMonitoraggioRisorsa {
    private static DBManager manager = null;
    private static int transactionIsolationLevel = -1;
    private DataSource dataSource = null;
    private MsgDiagnostico msgDiag = new MsgDiagnostico("DBManager", new IState[0]);
    private static Hashtable<String, Resource> risorseInGestione = new Hashtable();
    private static boolean initialized = false;

    public static String[] getStatoRisorse() throws Exception {
        Resource[] o = risorseInGestione.values().toArray(new Resource[0]);
        if (o == null) {
            return null;
        }
        Resource[] resources = o;
        if (resources == null || resources.length <= 0) {
            return null;
        }
        String[] r = new String[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            Resource rr = resources[i];
            r[i] = rr.getIdentificativoPorta() + "." + rr.getModuloFunzionale();
            if (rr.getIdTransazione() != null) {
                r[i] = r[i] + "." + rr.getIdTransazione();
            }
            r[i] = r[i] + " (" + rr.getDate().toString() + ")";
        }
        return r;
    }

    public DBManager(String jndiName, Properties context) throws Exception {
        GestoreJNDI jndi = new GestoreJNDI(context);
        Object oSearch = jndi.lookup(jndiName);
        if (oSearch == null) {
            throw new Exception("Lookup jndiResource [" + jndiName + "] not found");
        }
        try {
            this.dataSource = (DataSource)oSearch;
        }
        catch (Throwable t) {
            StringBuffer bf = new StringBuffer();
            if (oSearch instanceof Reference) {
                Reference r = (Reference)oSearch;
                bf.append(" (Factory=");
                bf.append(r.getFactoryClassName());
                bf.append(" FactoryLocation=");
                bf.append(r.getFactoryClassLocation());
                Enumeration<RefAddr> enR = r.getAll();
                if (enR != null) {
                    while (enR.hasMoreElements()) {
                        RefAddr refAddr = enR.nextElement();
                        bf.append(" [").append("type=").append(refAddr.getType()).append(" content=").append(refAddr.getContent()).append("]");
                    }
                }
                bf.append(")");
            }
            throw new Exception("lookup failed (object class: " + oSearch.getClass().getName() + ")" + bf.toString() + ": " + t.getMessage(), t);
        }
        Connection connectionTest = this.dataSource.getConnection();
        transactionIsolationLevel = connectionTest.getTransactionIsolation();
        connectionTest.close();
    }

    public static boolean isInitialized() {
        return initialized;
    }

    private static void setInitialized(boolean initialized) {
        DBManager.initialized = initialized;
    }

    public static void initialize(String jndiName, Properties context) throws Exception {
        manager = new DBManager(jndiName, context);
        DBManager.setInitialized(true);
    }

    public static DBManager getInstance() {
        return manager;
    }

    public static int getTransactionIsolationLevel() {
        return transactionIsolationLevel;
    }

    public Resource getResource(IDSoggetto idPDD, String modulo, String idTransazione) throws Exception {
        if (this.dataSource == null) {
            throw new Exception("Datasource non istanziato");
        }
        Resource risorsa = new Resource();
        try {
            Connection connectionDB = this.dataSource.getConnection();
            if (connectionDB == null) {
                throw new Exception("is null");
            }
            String idUnivoco = Resource.generaIdentificatoreUnivoco(idPDD, modulo);
            risorsa.setId(idUnivoco);
            risorsa.setDate(DateManager.getDate());
            risorsa.setIdentificativoPorta(idPDD);
            risorsa.setModuloFunzionale(modulo);
            risorsa.setResource(connectionDB);
            risorsa.setResourceType(Connection.class.getName());
            risorsa.setIdTransazione(idTransazione);
            risorseInGestione.put(idUnivoco, risorsa);
        }
        catch (Exception e) {
            this.msgDiag.aggiornaFiltri();
            this.msgDiag.setDominio(idPDD);
            this.msgDiag.setFunzione("DBManager." + modulo);
            this.msgDiag.logFatalError(e, "Richiesta connessione al datasource");
            throw e;
        }
        return risorsa;
    }

    public void releaseResource(IDSoggetto idPDD, String modulo, Resource resource) {
        try {
            if (resource != null) {
                Connection connectionDB;
                if (resource.getResource() != null && (connectionDB = (Connection)resource.getResource()) != null && !connectionDB.isClosed()) {
                    connectionDB.close();
                }
                if (risorseInGestione.containsKey(resource.getId())) {
                    risorseInGestione.remove(resource.getId());
                }
            }
        }
        catch (SQLException e) {
            this.msgDiag.aggiornaFiltri();
            this.msgDiag.setDominio(idPDD);
            this.msgDiag.setFunzione("DBManager." + modulo);
            this.msgDiag.logFatalError(e, "Rilasciata connessione al datasource");
        }
    }

    public void isAlive() throws CoreException {
        Resource resource = null;
        Statement stmtTest = null;
        IDSoggetto idSoggettAlive = new IDSoggetto();
        idSoggettAlive.setCodicePorta("DBManager");
        idSoggettAlive.setTipo("DBManager");
        idSoggettAlive.setNome("DBManager");
        try {
            resource = this.getResource(idSoggettAlive, "CheckIsAlive", null);
            if (resource == null) {
                throw new Exception("Resource is null");
            }
            if (resource.getResource() == null) {
                throw new Exception("Connessione is null");
            }
            Connection con = (Connection)resource.getResource();
            stmtTest = con.createStatement();
            stmtTest.execute("SELECT * from db_info");
        }
        catch (Exception e) {
            throw new CoreException("Connessione al database OpenSPCoop non disponibile: " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (stmtTest != null) {
                    stmtTest.close();
                }
            }
            catch (Exception e) {}
            try {
                this.releaseResource(idSoggettAlive, "CheckIsAlive", resource);
            }
            catch (Exception e) {}
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }
}

