/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.config;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.IMonitoraggioRisorsa;
import org.openspcoop2.core.config.AccessoConfigurazione;
import org.openspcoop2.core.config.AccessoConfigurazionePdD;
import org.openspcoop2.core.config.AccessoDatiAutorizzazione;
import org.openspcoop2.core.config.AccessoRegistro;
import org.openspcoop2.core.config.Configurazione;
import org.openspcoop2.core.config.Connettore;
import org.openspcoop2.core.config.CorrelazioneApplicativa;
import org.openspcoop2.core.config.CorrelazioneApplicativaRisposta;
import org.openspcoop2.core.config.GestioneErrore;
import org.openspcoop2.core.config.InvocazionePortaGestioneErrore;
import org.openspcoop2.core.config.InvocazioneServizio;
import org.openspcoop2.core.config.MessageSecurity;
import org.openspcoop2.core.config.MessageSecurityFlow;
import org.openspcoop2.core.config.MessaggiDiagnostici;
import org.openspcoop2.core.config.MtomProcessor;
import org.openspcoop2.core.config.MtomProcessorFlow;
import org.openspcoop2.core.config.Openspcoop2;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.Property;
import org.openspcoop2.core.config.RispostaAsincrona;
import org.openspcoop2.core.config.Route;
import org.openspcoop2.core.config.RoutingTable;
import org.openspcoop2.core.config.RoutingTableDestinazione;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.Soggetto;
import org.openspcoop2.core.config.StatoServiziPdd;
import org.openspcoop2.core.config.SystemProperties;
import org.openspcoop2.core.config.TipoFiltroAbilitazioneServizi;
import org.openspcoop2.core.config.Tracciamento;
import org.openspcoop2.core.config.ValidazioneContenutiApplicativi;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.constants.StatoFunzionalitaConWarning;
import org.openspcoop2.core.config.driver.BeanUtilities;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.driver.IDriverConfigurazioneGet;
import org.openspcoop2.core.config.driver.ValidazioneSemantica;
import org.openspcoop2.core.config.driver.xml.DriverConfigurazioneXML;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaApplicativaByNome;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.message.DynamicNamespaceContextFactory;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.XPathExpressionEngine;
import org.openspcoop2.message.mtom.MtomXomPackageInfo;
import org.openspcoop2.pdd.config.ClassNameProperties;
import org.openspcoop2.pdd.config.ConfigurazionePdD;
import org.openspcoop2.pdd.config.MTOMProcessorConfig;
import org.openspcoop2.pdd.config.MessageSecurityConfig;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.PDIdentificazioneDinamica;
import org.openspcoop2.pdd.config.PDIdentificazioneDinamicaException;
import org.openspcoop2.pdd.config.PddProperties;
import org.openspcoop2.pdd.config.RichiestaApplicativa;
import org.openspcoop2.pdd.config.RichiestaDelegata;
import org.openspcoop2.pdd.config.SoggettoVirtuale;
import org.openspcoop2.pdd.core.autenticazione.Credenziali;
import org.openspcoop2.pdd.core.connettori.ConnettoreMsg;
import org.openspcoop2.pdd.core.connettori.GestoreErroreConnettore;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazione;
import org.openspcoop2.pdd.logger.LogLevels;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.URLProtocolContext;
import org.openspcoop2.protocol.engine.mapping.ModalitaIdentificazione;
import org.openspcoop2.protocol.engine.mapping.OperationFinder;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.builder.ProprietaErroreApplicativo;
import org.openspcoop2.protocol.sdk.constants.FunzionalitaProtocollo;
import org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;
import org.openspcoop2.utils.xml.DynamicNamespaceContext;
import org.w3c.dom.Node;

public class ConfigurazionePdDReader {
    private static ConfigurazionePdDReader configurazionePdDReader;
    private static boolean initialize;
    private ConfigurazionePdD configurazionePdD;
    private boolean configurazioneDinamica = false;
    private Logger log = null;
    private OpenSPCoop2Properties openspcoopProperties = null;
    private PddProperties pddProperties = null;
    private boolean serverJ2EE;
    private static AccessoRegistro accessoRegistroServizi;
    private static Boolean accessoRegistroServiziLetto;
    private static AccessoConfigurazione accessoConfigurazione;
    private static Boolean accessoConfigurazioneLetto;
    private static AccessoDatiAutorizzazione accessoDatiAutorizzazione;
    private static Boolean accessoDatiAutorizzazioneLetto;
    private static StatoFunzionalitaConWarning tipoValidazione;
    private static Boolean isLivelloValidazioneNormale;
    private static Boolean isLivelloValidazioneRigido;
    private static Boolean validazioneProfiloCollaborazione;
    private static Boolean validazioneManifestAttachments;
    private static Boolean newConnectionForResponse;
    private static Boolean utilizzoIndirizzoRisposta;
    private static Boolean gestioneManifestAttachments;
    private static Long timeoutRiscontro;
    private static Level livello_msgDiagnostici;
    public static Level livello_msgDiagnosticiJMX;
    private static Level livelloLog4J_msgDiagnostici;
    public static Level livelloLog4J_msgDiagnosticiJMX;
    private static Integer severita_msgDiagnostici;
    public static Integer severita_msgDiagnosticiJMX;
    private static Integer severitaLog4J_msgDiagnostici;
    public static Integer severitaLog4J_msgDiagnosticiJMX;
    private static MessaggiDiagnostici openSPCoopAppender_MsgDiagnostici;
    private static Boolean openSPCoopAppender_MsgDiagnosticiLetto;
    private static Boolean dumpMessaggi;
    public static Boolean dumpMessaggiJMX;
    private static Boolean dumpBinarioPD;
    public static Boolean dumpBinarioPDJMX;
    private static Boolean dumpBinarioPA;
    public static Boolean dumpBinarioPAJMX;
    public static Boolean tracciamentoBusteJMX;
    private static Boolean tracciamentoBuste;
    private static Tracciamento openSPCoopAppender_Tracciamento;
    private static Boolean openSPCoopAppender_TracciamentoLetto;
    private static GestioneErrore gestioneErroreConnettoreComponenteCooperazione;
    private static GestioneErrore gestioneErroreConnettoreComponenteIntegrazione;
    private static String[] integrationManagerAuthentication;
    private static ValidazioneContenutiApplicativi validazioneContenutiApplicativi;
    private static Boolean isPDServiceActive;
    private static List<TipoFiltroAbilitazioneServizi> getFiltriAbilitazionePDService;
    private static List<TipoFiltroAbilitazioneServizi> getFiltriDisabilitazionePDService;
    private static Boolean isPAServiceActive;
    private static List<TipoFiltroAbilitazioneServizi> getFiltriAbilitazionePAService;
    private static List<TipoFiltroAbilitazioneServizi> getFiltriDisabilitazionePAService;
    private static Boolean isIMServiceActive;
    private static List<Object> getExtendedInfoConfigurazione;
    private static Hashtable<String, Object> getSingleExtendedInfoConfigurazione;

    public static boolean isCacheAbilitata() throws DriverConfigurazioneException {
        try {
            ConfigurazionePdDReader configurazionePdDReader = ConfigurazionePdDReader.getInstance();
            if (configurazionePdDReader != null && configurazionePdDReader.configurazionePdD != null) {
                return configurazionePdDReader.configurazionePdD.isCacheAbilitata();
            }
            return false;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("IsCacheAbilitata, recupero informazione della cache della Configurazione della Porta di Dominio non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void resetCache() throws DriverConfigurazioneException {
        try {
            ConfigurazionePdDReader configurazionePdDReader = ConfigurazionePdDReader.getInstance();
            if (configurazionePdDReader != null && configurazionePdDReader.configurazionePdD != null) {
                configurazionePdDReader.configurazionePdD.resetCache();
            }
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Reset della cache della Configurazione della Porta di Dominio non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    public static String printStatsCache(String separator) throws DriverConfigurazioneException {
        try {
            ConfigurazionePdDReader configurazionePdDReader = ConfigurazionePdDReader.getInstance();
            if (configurazionePdDReader != null && configurazionePdDReader.configurazionePdD != null) {
                return configurazionePdDReader.configurazionePdD.printStatsCache(separator);
            }
            throw new Exception("ConfigurazionePdD Non disponibile");
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Visualizzazione Statistiche riguardante la cache della Configurazione della Porta di Dominio non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void abilitaCache() throws DriverConfigurazioneException {
        try {
            ConfigurazionePdDReader configurazionePdDReader = ConfigurazionePdDReader.getInstance();
            if (configurazionePdDReader != null && configurazionePdDReader.configurazionePdD != null) {
                configurazionePdDReader.configurazionePdD.abilitaCache();
            }
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Abilitazione cache della Configurazione della Porta di Dominio non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void abilitaCache(Long dimensioneCache, Boolean algoritmoCacheLRU, Long itemIdleTime, Long itemLifeSecond) throws DriverConfigurazioneException {
        try {
            ConfigurazionePdDReader configurazionePdDReader = ConfigurazionePdDReader.getInstance();
            if (configurazionePdDReader != null && configurazionePdDReader.configurazionePdD != null) {
                configurazionePdDReader.configurazionePdD.abilitaCache(dimensioneCache, algoritmoCacheLRU, itemIdleTime, itemLifeSecond);
            }
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Abilitazione cache della Configurazione della Porta di Dominio non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void disabilitaCache() throws DriverConfigurazioneException {
        try {
            ConfigurazionePdDReader configurazionePdDReader = ConfigurazionePdDReader.getInstance();
            if (configurazionePdDReader != null && configurazionePdDReader.configurazionePdD != null) {
                configurazionePdDReader.configurazionePdD.disabilitaCache();
            }
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Disabilitazione cache della Configurazione della Porta di Dominio non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    public static String listKeysCache(String separator) throws DriverConfigurazioneException {
        try {
            ConfigurazionePdDReader configurazionePdDReader = ConfigurazionePdDReader.getInstance();
            if (configurazionePdDReader != null && configurazionePdDReader.configurazionePdD != null) {
                return configurazionePdDReader.configurazionePdD.listKeysCache(separator);
            }
            throw new Exception("ConfigurazionePdD Non disponibile");
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Visualizzazione chiavi presenti nella cache della Configurazione della Porta di Dominio non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    public static String getObjectCache(String key) throws DriverConfigurazioneException {
        try {
            ConfigurazionePdDReader configurazionePdDReader = ConfigurazionePdDReader.getInstance();
            if (configurazionePdDReader != null && configurazionePdDReader.configurazionePdD != null) {
                return configurazionePdDReader.configurazionePdD.getObjectCache(key);
            }
            throw new Exception("ConfigurazionePdD Non disponibile");
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Visualizzazione oggetto presente nella cache della Configurazione della Porta di Dominio non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void removeObjectCache(String key) throws DriverConfigurazioneException {
        try {
            ConfigurazionePdDReader configurazionePdDReader = ConfigurazionePdDReader.getInstance();
            if (configurazionePdDReader == null || configurazionePdDReader.configurazionePdD == null) {
                throw new Exception("ConfigurazionePdD Non disponibile");
            }
            configurazionePdDReader.configurazionePdD.removeObjectCache(key);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Rimozione oggetto presente nella cache della Configurazione della Porta di Dominio non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    public static boolean initialize(AccessoConfigurazionePdD accessoConfigurazione, Logger aLog, Logger aLogconsole, Properties localProperties, String jndiNameDatasourcePdD, boolean forceDisableCache) {
        try {
            configurazionePdDReader = new ConfigurazionePdDReader(accessoConfigurazione, aLog, aLogconsole, localProperties, jndiNameDatasourcePdD, forceDisableCache);
            return initialize;
        }
        catch (Exception e) {
            aLog.error((Object)e.getMessage(), (Throwable)e);
            aLogconsole.error((Object)e.getMessage());
            return false;
        }
    }

    public static boolean isInitialize() {
        return initialize;
    }

    public static ConfigurazionePdDReader getInstance() {
        return configurazionePdDReader;
    }

    public ConfigurazionePdDReader(AccessoConfigurazionePdD accessoConfigurazione, Logger aLog, Logger aLogconsole, Properties localProperties, String jndiNameDatasourcePdD, boolean forceDisableCache) throws DriverConfigurazioneException {
        try {
            this.log = aLog != null ? aLog : Logger.getLogger(ConfigurazionePdDReader.class);
            this.configurazionePdD = new ConfigurazionePdD(accessoConfigurazione, this.log, aLogconsole, localProperties, jndiNameDatasourcePdD, forceDisableCache);
            this.openspcoopProperties = OpenSPCoop2Properties.getInstance();
            this.pddProperties = PddProperties.getInstance();
            this.configurazioneDinamica = this.openspcoopProperties.isConfigurazioneDinamica();
            this.serverJ2EE = this.openspcoopProperties.isServerJ2EE();
            initialize = true;
        }
        catch (Exception e) {
            if (this.log != null) {
                this.log.error((Object)"Configurazione non inizializzata", (Throwable)e);
            } else {
                aLogconsole.error((Object)("Configurazione non inizializzata:" + e.getMessage()), (Throwable)e);
            }
            initialize = false;
        }
    }

    protected void isAlive() throws CoreException {
        ((IMonitoraggioRisorsa)this.configurazionePdD.getDriverConfigurazionePdD()).isAlive();
    }

    protected void validazioneSemantica(String[] tipiConnettori, String[] tipiMsgDiagnosticoAppender, String[] tipiTracciamentoAppender, String[] tipiAutenticazione, String[] tipiAutorizzazione, String[] tipiAutorizzazioneContenuto, String[] tipiAutorizzazioneContenutoBuste, String[] tipiIntegrazionePD, String[] tipiIntegrazionePA, boolean validazioneSemanticaAbilitataXML, boolean validazioneSemanticaAbilitataAltreConfigurazioni, boolean validaConfigurazione, Logger logConsole) throws CoreException {
        try {
            IDriverConfigurazioneGet o = this.configurazionePdD.getDriverConfigurazionePdD();
            boolean validazione = false;
            validazione = o instanceof DriverConfigurazioneXML ? validazioneSemanticaAbilitataXML : validazioneSemanticaAbilitataAltreConfigurazioni;
            if (validazione) {
                BeanUtilities driverConfigurazione = (BeanUtilities)o;
                Openspcoop2 configurazionePdD = driverConfigurazione.getImmagineCompletaConfigurazionePdD();
                ValidazioneSemantica validazioneSemantica = new ValidazioneSemantica(configurazionePdD, tipiConnettori, ProtocolFactoryManager.getInstance().getSubjectTypesAsArray(), ProtocolFactoryManager.getInstance().getServiceTypesAsArray(), tipiMsgDiagnosticoAppender, tipiTracciamentoAppender, tipiAutenticazione, tipiAutorizzazione, tipiAutorizzazioneContenuto, tipiAutorizzazioneContenutoBuste, tipiIntegrazionePD, tipiIntegrazionePA, validaConfigurazione);
                validazioneSemantica.validazioneSemantica(false);
                if (logConsole != null) {
                    logConsole.info((Object)"Validazione semantica della configurazione della Porta di Dominio effettuata.");
                }
            }
        }
        catch (Exception e) {
            throw new CoreException(e.getMessage(), (Throwable)e);
        }
    }

    protected void setValidazioneSemanticaModificaConfigurazionePdDXML(String[] tipiConnettori, String[] tipoMsgDiagnosticiAppender, String[] tipoTracciamentoAppender, String[] tipoAutenticazione, String[] tipoAutorizzazione, String[] tipiAutorizzazioneContenuto, String[] tipiAutorizzazioneContenutoBuste, String[] tipoIntegrazionePD, String[] tipoIntegrazionePA) throws CoreException {
        try {
            IDriverConfigurazioneGet o = this.configurazionePdD.getDriverConfigurazionePdD();
            if (o instanceof DriverConfigurazioneXML) {
                DriverConfigurazioneXML driver = (DriverConfigurazioneXML)o;
                driver.abilitazioneValidazioneSemanticaDuranteModificaXML(tipiConnettori, ProtocolFactoryManager.getInstance().getSubjectTypesAsArray(), ProtocolFactoryManager.getInstance().getServiceTypesAsArray(), tipoMsgDiagnosticiAppender, tipoTracciamentoAppender, tipoAutenticazione, tipoAutorizzazione, tipiAutorizzazioneContenuto, tipiAutorizzazioneContenutoBuste, tipoIntegrazionePD, tipoIntegrazionePA);
            }
        }
        catch (Exception e) {
            throw new CoreException(e.getMessage(), (Throwable)e);
        }
    }

    protected void verificaConsistenzaConfigurazione() throws DriverConfigurazioneException {
        IDriverConfigurazioneGet o = this.configurazionePdD.getDriverConfigurazionePdD();
        if (o instanceof DriverConfigurazioneXML) {
            DriverConfigurazioneXML driver = (DriverConfigurazioneXML)o;
            driver.refreshConfigurazioneXML();
        }
    }

    protected IDSoggetto getIDSoggetto(Connection connectionPdD, String location, IProtocolFactory protocolFactory) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        Soggetto soggetto = this.configurazionePdD.getSoggetto(connectionPdD, location);
        if (soggetto == null) {
            throw new DriverConfigurazioneNotFound("Soggetto che possiede la porta delegata [" + location + "] non esistente");
        }
        IDSoggetto idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
        if (soggetto.getIdentificativoPorta() != null) {
            idSoggetto.setCodicePorta(soggetto.getIdentificativoPorta());
        } else {
            try {
                idSoggetto.setCodicePorta(protocolFactory.createTraduttore().getIdentificativoPortaDefault(idSoggetto));
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
            }
        }
        return idSoggetto;
    }

    protected String getIdentificativoPorta(Connection connectionPdD, IDSoggetto idSoggetto, IProtocolFactory protocolFactory) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        Soggetto soggetto = this.configurazionePdD.getSoggetto(connectionPdD, idSoggetto);
        if (soggetto == null) {
            throw new DriverConfigurazioneNotFound("Soggetto[" + idSoggetto.toString() + "] per lettura Dominio non trovato");
        }
        if (soggetto.getIdentificativoPorta() != null) {
            return soggetto.getIdentificativoPorta();
        }
        if (soggetto.getNome() != null) {
            try {
                return protocolFactory.createTraduttore().getIdentificativoPortaDefault(idSoggetto);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
            }
        }
        OpenSPCoop2Properties properties = OpenSPCoop2Properties.getInstance();
        return properties.getIdentificativoPortaDefault(protocolFactory.getProtocol());
    }

    protected boolean isSoggettoVirtuale(Connection connectionPdD, IDSoggetto idSoggetto) throws DriverConfigurazioneException {
        if (idSoggetto == null || idSoggetto.getTipo() == null || idSoggetto.getNome() == null) {
            return false;
        }
        HashSet<String> listaSoggettiVirtuali = null;
        try {
            listaSoggettiVirtuali = this.configurazionePdD.getSoggettiVirtuali(connectionPdD);
        }
        catch (DriverConfigurazioneNotFound de) {
            this.log.info((Object)"Soggetti virtuali non presenti.");
            return false;
        }
        String keySoggetto = idSoggetto.getTipo() + idSoggetto.getNome();
        return listaSoggettiVirtuali.contains(keySoggetto);
    }

    protected boolean existsSoggetto(Connection connectionPdD, IDSoggetto idSoggetto) throws DriverConfigurazioneException {
        Soggetto soggetto = null;
        try {
            soggetto = this.configurazionePdD.getSoggetto(connectionPdD, idSoggetto);
        }
        catch (DriverConfigurazioneNotFound e) {
            return false;
        }
        return soggetto != null;
    }

    protected HashSet<IDServizio> getServizi_SoggettiVirtuali(Connection connectionPdD) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.configurazionePdD.getServizi_SoggettiVirtuali(connectionPdD);
    }

    protected Connettore getForwardRoute(Connection connectionPdD, RegistroServiziManager registroServiziManager, IDSoggetto idSoggettoDestinatario, boolean functionAsRouter) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getForwardRoute(connectionPdD, registroServiziManager, null, new IDServizio(idSoggettoDestinatario), functionAsRouter);
    }

    protected Connettore getForwardRoute(Connection connectionPdD, RegistroServiziManager registroServiziManager, IDSoggetto idSoggettoMittente, IDServizio idServizio, boolean functionAsRouter) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        int i;
        if (idServizio == null) {
            throw new DriverConfigurazioneException("getForwardRoute error: Identificativo servizio non definito");
        }
        if (idServizio.getSoggettoErogatore() == null) {
            throw new DriverConfigurazioneException("getForwardRoute error: Soggetto Erogatore non definito");
        }
        String nome = idServizio.getSoggettoErogatore().getNome();
        String tipo = idServizio.getSoggettoErogatore().getTipo();
        if (nome == null || tipo == null) {
            throw new DriverConfigurazioneException("getForwardRoute error: Soggetto Erogatore con tipo/nome non definito");
        }
        RoutingTable routingTable = this.configurazionePdD.getRoutingTable(connectionPdD);
        if (routingTable.getAbilitata() == null || !routingTable.getAbilitata().booleanValue() || (routingTable.getDefault() == null || routingTable.getDefault().sizeRouteList() == 0) && routingTable.sizeDestinazioneList() == 0) {
            if (routingTable.getAbilitata() == null || !routingTable.getAbilitata().booleanValue()) {
                this.log.debug((Object)"getForwardRoute: routing table disabilitata");
            } else {
                this.log.debug((Object)"getForwardRoute: routing table senza rotte");
            }
            Connettore connettoreDominio = null;
            try {
                if (idSoggettoMittente != null && idServizio.getServizio() != null) {
                    connettoreDominio = registroServiziManager.getConnettore(idSoggettoMittente, idServizio, null);
                    if (!functionAsRouter) {
                        this.setPDUrlPrefixRewriter(connectionPdD, connettoreDominio, idSoggettoMittente);
                    }
                } else {
                    connettoreDominio = registroServiziManager.getConnettore(idServizio.getSoggettoErogatore(), null);
                }
            }
            catch (DriverRegistroServiziNotFound e) {
                throw new DriverConfigurazioneNotFound("getForwardRoute[RoutingTable Non Abilitata], ricerca nel RegistroServizi effettuata: " + e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("getForwardRoute[RoutingTable Non Abilitata], errore durante la lettura dal Registro dei Servizi: " + e.getMessage(), (Throwable)e);
            }
            if (connettoreDominio != null && !"none".equals(connettoreDominio.getTipo()) && !CostantiConfigurazione.DISABILITATO.equals(connettoreDominio.getTipo())) {
                return connettoreDominio;
            }
            throw new DriverConfigurazioneException("getForwardRoute[RoutingTable Non Abilitata], connettore per la busta non trovato.");
        }
        StringBuffer bf = new StringBuffer();
        bf.append("Ricerca connettore del servizio...");
        this.log.debug((Object)"getForwardRoute: routing table abilitata");
        for (i = 0; i < routingTable.sizeDestinazioneList(); ++i) {
            if (!nome.equals(routingTable.getDestinazione(i).getNome()) || !tipo.equals(routingTable.getDestinazione(i).getTipo())) continue;
            bf.append("\nRotta di destinazione [" + routingTable.getDestinazione(i).getTipo() + "/" + routingTable.getDestinazione(i).getNome() + "]...\n");
            this.log.debug((Object)("getForwardRoute: esamino routing table, destinazione [" + routingTable.getDestinazione(i).getTipo() + "/" + routingTable.getDestinazione(i).getNome() + "]"));
            RoutingTableDestinazione routingTableDest = routingTable.getDestinazione(i);
            for (int j = 0; j < routingTableDest.sizeRouteList(); ++j) {
                Route route = routingTableDest.getRoute(j);
                Connettore connettoreDominio = null;
                boolean error = false;
                String soggettoGateway = "";
                try {
                    if (route.getRegistro() != null) {
                        this.log.debug((Object)("getForwardRoute: esamino routing table, destinazione [" + routingTable.getDestinazione(i).getTipo() + "/" + routingTable.getDestinazione(i).getNome() + "] RegistroNome[" + route.getRegistro().getNome() + "]"));
                        bf.append("\tRegistro nomeRegistro[" + route.getRegistro().getNome() + "]: ");
                        if (idSoggettoMittente != null && idServizio.getServizio() != null) {
                            connettoreDominio = registroServiziManager.getConnettore(idSoggettoMittente, idServizio, route.getRegistro().getNome());
                            if (!functionAsRouter) {
                                this.setPDUrlPrefixRewriter(connectionPdD, connettoreDominio, idSoggettoMittente);
                            }
                        } else {
                            connettoreDominio = registroServiziManager.getConnettore(idServizio.getSoggettoErogatore(), route.getRegistro().getNome());
                        }
                        if (connettoreDominio != null && !"none".equals(connettoreDominio.getTipo()) && !CostantiConfigurazione.DISABILITATO.equals(connettoreDominio.getTipo())) {
                            connettoreDominio.setNomeRegistro(route.getRegistro().getNome());
                        }
                    } else if (route.getGateway() != null) {
                        this.log.debug((Object)("getForwardRoute: esamino routing table, destinazione [" + routingTable.getDestinazione(i).getTipo() + "/" + routingTable.getDestinazione(i).getNome() + "] GateWay[" + route.getGateway().getTipo() + "/" + route.getGateway().getNome() + "]"));
                        bf.append("\tGateWay[" + route.getGateway().getTipo() + "/" + route.getGateway().getNome() + "]: ");
                        IDSoggetto gateway = new IDSoggetto(route.getGateway().getTipo(), route.getGateway().getNome());
                        soggettoGateway = " [Gateway:" + gateway.toString() + "]";
                        connettoreDominio = registroServiziManager.getConnettore(gateway, null);
                        if (connettoreDominio != null && !"none".equals(connettoreDominio.getTipo()) && !CostantiConfigurazione.DISABILITATO.equals(connettoreDominio.getTipo())) {
                            connettoreDominio.setNomeDestinatarioTrasmissioneBusta(gateway.getNome());
                            connettoreDominio.setTipoDestinatarioTrasmissioneBusta(gateway.getTipo());
                        }
                    }
                }
                catch (DriverRegistroServiziNotFound e) {
                    error = true;
                    bf.append(" non trovata: " + e.getMessage());
                }
                catch (Exception e) {
                    throw new DriverConfigurazioneException("getForwardRoute: esamino routing table, destinazione [" + routingTable.getDestinazione(i).getTipo() + "/" + routingTable.getDestinazione(i).getNome() + "]: Accesso al registro non riuscito" + soggettoGateway + ": " + e.getMessage(), (Throwable)e);
                }
                if (connettoreDominio != null && !"none".equals(connettoreDominio.getTipo()) && !CostantiConfigurazione.DISABILITATO.equals(connettoreDominio.getTipo())) {
                    return connettoreDominio;
                }
                if (error) continue;
                bf.append(" non trovata: connettore non definito");
            }
        }
        if (routingTable.getDefault() != null) {
            for (i = 0; i < routingTable.getDefault().sizeRouteList(); ++i) {
                this.log.debug((Object)"getForwardRoute: esamino routing table, rotta di default");
                bf.append("\nRotta di default");
                Route route = routingTable.getDefault().getRoute(i);
                Connettore connettoreDominio = null;
                boolean error = false;
                String soggettoGateway = "";
                try {
                    if (route.getRegistro() != null) {
                        this.log.debug((Object)("getForwardRoute: esamino routing table, rotta di default, Registro nomeRegistro[" + route.getRegistro().getNome() + "]"));
                        bf.append(" Registro nomeRegistro[" + route.getRegistro().getNome() + "]: ");
                        if (idSoggettoMittente != null && idServizio.getServizio() != null) {
                            connettoreDominio = registroServiziManager.getConnettore(idSoggettoMittente, idServizio, route.getRegistro().getNome());
                            if (!functionAsRouter) {
                                this.setPDUrlPrefixRewriter(connectionPdD, connettoreDominio, idSoggettoMittente);
                            }
                        } else {
                            connettoreDominio = registroServiziManager.getConnettore(idServizio.getSoggettoErogatore(), route.getRegistro().getNome());
                        }
                        if (connettoreDominio != null && !"none".equals(connettoreDominio.getTipo()) && !CostantiConfigurazione.DISABILITATO.equals(connettoreDominio.getTipo())) {
                            connettoreDominio.setNomeRegistro(route.getRegistro().getNome());
                        }
                    } else if (route.getGateway() != null) {
                        this.log.debug((Object)("getForwardRoute: esamino routing table, rotta di default, GateWay[" + route.getGateway().getTipo() + "/" + route.getGateway().getNome() + "]"));
                        bf.append(" GateWay[" + route.getGateway().getTipo() + "/" + route.getGateway().getNome() + "]: ");
                        IDSoggetto gateway = new IDSoggetto(route.getGateway().getTipo(), route.getGateway().getNome());
                        soggettoGateway = " [Gateway:" + gateway.toString() + "]";
                        connettoreDominio = registroServiziManager.getConnettore(gateway, null);
                        if (connettoreDominio != null && !"none".equals(connettoreDominio.getTipo()) && !CostantiConfigurazione.DISABILITATO.equals(connettoreDominio.getTipo())) {
                            connettoreDominio.setNomeDestinatarioTrasmissioneBusta(gateway.getNome());
                            connettoreDominio.setTipoDestinatarioTrasmissioneBusta(gateway.getTipo());
                        }
                    }
                }
                catch (DriverRegistroServiziNotFound e) {
                    error = true;
                    bf.append(" non trovata: " + e.getMessage());
                }
                catch (Exception e) {
                    throw new DriverConfigurazioneException("getForwardRoute: esamino routing table, rotta di default: Accesso al registro non riuscito" + soggettoGateway + ": " + e.getMessage(), (Throwable)e);
                }
                if (connettoreDominio != null && !"none".equals(connettoreDominio.getTipo()) && !CostantiConfigurazione.DISABILITATO.equals(connettoreDominio.getTipo())) {
                    return connettoreDominio;
                }
                if (error) continue;
                bf.append(" non trovata: connettore non definito");
            }
        }
        throw new DriverConfigurazioneNotFound("getForwardRoute [Routing Table] error: connettore per la busta non trovato: \n" + bf.toString());
    }

    protected String getRegistroForImbustamento(Connection connectionPdD, RegistroServiziManager registroServiziManager, IDSoggetto idSoggettoMittente, IDServizio idServizio, boolean functionAsRouter) throws DriverConfigurazioneException {
        Connettore conn = null;
        try {
            conn = this.getForwardRoute(connectionPdD, registroServiziManager, idSoggettoMittente, idServizio, functionAsRouter);
        }
        catch (DriverConfigurazioneNotFound e) {
            // empty catch block
        }
        if (conn != null) {
            return conn.getNomeRegistro();
        }
        return null;
    }

    protected boolean routerFunctionActive(Connection connectionPdD) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        RoutingTable routingTable = null;
        try {
            routingTable = this.configurazionePdD.getRoutingTable(connectionPdD);
        }
        catch (Exception e) {
            this.log.debug((Object)"routerFunctionActive[getRoutingTable]", (Throwable)e);
        }
        if (routingTable == null || routingTable.getAbilitata() == null || !routingTable.getAbilitata().booleanValue() || (routingTable.getDefault() == null || routingTable.getDefault().sizeRouteList() == 0) && routingTable.sizeDestinazioneList() == 0) {
            return false;
        }
        Soggetto router = null;
        try {
            router = this.configurazionePdD.getRouter(connectionPdD);
        }
        catch (DriverConfigurazioneNotFound e) {
            return false;
        }
        return router != null;
    }

    protected IDSoggetto getRouterIdentity(Connection connectionPdD, IProtocolFactory protocolFactory) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        RoutingTable routingTable = null;
        try {
            routingTable = this.configurazionePdD.getRoutingTable(connectionPdD);
        }
        catch (Exception e) {
            this.log.debug((Object)"getRouterIdentity[routingTable]", (Throwable)e);
        }
        if (routingTable == null || routingTable.getAbilitata() == null || !routingTable.getAbilitata().booleanValue() || (routingTable.getDefault() == null || routingTable.getDefault().sizeRouteList() == 0) && routingTable.sizeDestinazioneList() == 0) {
            throw new DriverConfigurazioneException("getRouterIdentity error: RoutingTable non definita");
        }
        Soggetto router = this.configurazionePdD.getRouter(connectionPdD);
        if (router == null) {
            throw new DriverConfigurazioneNotFound("Router non trovato");
        }
        String codicePorta = router.getIdentificativoPorta();
        if (codicePorta == null) {
            if (router.getNome() != null) {
                try {
                    codicePorta = protocolFactory.createTraduttore().getIdentificativoPortaDefault(new IDSoggetto(router.getTipo(), router.getNome()));
                }
                catch (Exception e) {
                    throw new DriverConfigurazioneException("getRouterIdentity error: costruzione IdentificativoPorta per soggetto " + router.getTipo() + "/" + router.getNome() + " non riuscita: " + e.getMessage(), (Throwable)e);
                }
            } else {
                OpenSPCoop2Properties properties = OpenSPCoop2Properties.getInstance();
                codicePorta = properties.getIdentificativoPortaDefault(protocolFactory.getProtocol());
            }
        }
        return new IDSoggetto(router.getTipo(), router.getNome(), codicePorta);
    }

    protected void setPDUrlPrefixRewriter(Connection connectionPdD, Connettore connettore, IDSoggetto idSoggettoFruitore) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        if (idSoggettoFruitore == null) {
            return;
        }
        Soggetto soggettoFruitore = this.configurazionePdD.getSoggetto(connectionPdD, idSoggettoFruitore);
        this.setUrlPrefixRewriter(soggettoFruitore.getPdUrlPrefixRewriter(), "pdUrlPrefixRewriter", connettore);
    }

    protected void setPAUrlPrefixRewriter(Connection connectionPdD, Connettore connettore, IDSoggetto idSoggettoErogatore) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        if (idSoggettoErogatore == null) {
            return;
        }
        Soggetto soggettoErogatore = this.configurazionePdD.getSoggetto(connectionPdD, idSoggettoErogatore);
        this.setUrlPrefixRewriter(soggettoErogatore.getPaUrlPrefixRewriter(), "paUrlPrefixRewriter", connettore);
    }

    private void setUrlPrefixRewriter(String urlPrefix, String funzione, Connettore connettore) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        if (urlPrefix != null && !"".equals(urlPrefix)) {
            for (int i = 0; i < connettore.sizePropertyList(); ++i) {
                Property cp = connettore.getProperty(i);
                if (!cp.getNome().equalsIgnoreCase("location")) continue;
                String originale = cp.getValore();
                cp.setValore(this.urlPrefixRewriter(funzione, originale, urlPrefix.trim()));
                break;
            }
        }
    }

    private String urlPrefixRewriter(String funzione, String urlOriginale, String urlPrefix) throws DriverConfigurazioneException {
        try {
            String urlFinale = urlPrefix;
            String originale = urlOriginale;
            if (originale == null) {
                throw new DriverRegistroServiziException("[" + funzione + "] Url originale non fornita");
            }
            if ((originale = originale.trim()).startsWith(urlPrefix)) {
                return originale;
            }
            this.log.debug((Object)("[" + funzione + "]  Originale[" + originale + "] UrlPrefix[" + urlPrefix + "] ..."));
            String tmp = null;
            if (!originale.contains("://")) {
                return urlOriginale;
            }
            tmp = originale.substring(originale.indexOf("://") + 3);
            this.log.debug((Object)("[" + funzione + "]  eliminazioneProtocollo[" + tmp + "] ..."));
            if (tmp.contains("/")) {
                tmp = tmp.substring(tmp.indexOf("/") + 1);
                this.log.debug((Object)("[" + funzione + "]  salvataggioContesto[" + tmp + "] ..."));
                if (!urlFinale.endsWith("/")) {
                    urlFinale = urlFinale + "/";
                }
                urlFinale = urlFinale + tmp;
            }
            this.log.debug((Object)("[" + funzione + "]  nuova url: [" + urlFinale + "]"));
            return urlFinale;
        }
        catch (Exception e) {
            this.log.error((Object)("Processo di [" + funzione + "]  fallito (urlOriginale:" + urlOriginale + ") (urlPrefix:" + urlPrefix + ")"), (Throwable)e);
            throw new DriverConfigurazioneException("Processo di [" + funzione + "]  fallito (urlOriginale:" + urlOriginale + ") (urlPrefix:" + urlPrefix + ")", (Throwable)e);
        }
    }

    protected PortaDelegata getPortaDelegata(Connection connectionPdD, IDPortaDelegata idPD) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.configurazionePdD.getPortaDelegata(connectionPdD, idPD);
    }

    protected PortaDelegata getPortaDelegata_SafeMethod(Connection connectionPdD, IDPortaDelegata idPD) throws DriverConfigurazioneException {
        try {
            if (idPD.getLocationPD() != null) {
                return this.getPortaDelegata(connectionPdD, idPD);
            }
            return null;
        }
        catch (DriverConfigurazioneNotFound e) {
            return null;
        }
    }

    protected boolean identificazioneContentBased(PortaDelegata pd) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (pd == null) {
            throw new DriverConfigurazioneException("Porta Delegata non fornita");
        }
        if (CostantiConfigurazione.PORTA_DELEGATA_SOGGETTO_EROGATORE_CONTENT_BASED.equals(pd.getSoggettoErogatore().getIdentificazione())) {
            return true;
        }
        if (CostantiConfigurazione.PORTA_DELEGATA_SERVIZIO_CONTENT_BASED.equals(pd.getServizio().getIdentificazione())) {
            return true;
        }
        if (pd.getAzione() != null) {
            return CostantiConfigurazione.PORTA_DELEGATA_AZIONE_CONTENT_BASED.equals(pd.getAzione().getIdentificazione());
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected IDServizio getIDServizio(RegistroServiziManager registroServiziManager, PortaDelegata pd, URLProtocolContext urlProtocolContext, OpenSPCoop2Message message, SOAPEnvelope envelope, HeaderIntegrazione headerIntegrazione, boolean readFirstHeaderIntegrazione, String soapAction, IProtocolFactory protocolFactory) throws DriverConfigurazioneException, DriverConfigurazioneNotFound, Exception {
        try {
            IDServizio idServizio;
            if (pd == null) {
                throw new DriverConfigurazioneException("Porta Delegata non fornita");
            }
            String urlInvocazionePD = null;
            boolean urlBased = false;
            if (CostantiConfigurazione.PORTA_DELEGATA_SOGGETTO_EROGATORE_URL_BASED.equals(pd.getSoggettoErogatore().getIdentificazione())) {
                urlBased = true;
            } else if (CostantiConfigurazione.PORTA_DELEGATA_SERVIZIO_URL_BASED.equals(pd.getServizio().getIdentificazione())) {
                urlBased = true;
            } else if (pd.getAzione() != null && CostantiConfigurazione.PORTA_DELEGATA_AZIONE_URL_BASED.equals(pd.getAzione().getIdentificazione())) {
                urlBased = true;
            }
            if (urlBased) {
                urlInvocazionePD = urlProtocolContext.getUrlInvocazione_formBased();
            }
            DynamicNamespaceContext dnc = null;
            if (CostantiConfigurazione.PORTA_DELEGATA_SOGGETTO_EROGATORE_CONTENT_BASED.equals(pd.getSoggettoErogatore().getIdentificazione())) {
                dnc = DynamicNamespaceContextFactory.getInstance().getNamespaceContext((Node)envelope);
            } else if (CostantiConfigurazione.PORTA_DELEGATA_SERVIZIO_CONTENT_BASED.equals(pd.getServizio().getIdentificazione())) {
                dnc = DynamicNamespaceContextFactory.getInstance().getNamespaceContext((Node)envelope);
            } else if (pd.getAzione() != null && CostantiConfigurazione.PORTA_DELEGATA_AZIONE_CONTENT_BASED.equals(pd.getAzione().getIdentificazione())) {
                dnc = DynamicNamespaceContextFactory.getInstance().getNamespaceContext((Node)envelope);
            }
            XPathExpressionEngine xPathEngine = new XPathExpressionEngine();
            IDSoggetto soggettoErogatore = new IDSoggetto();
            soggettoErogatore.setTipo(pd.getSoggettoErogatore().getTipo());
            try {
                String sog;
                if (CostantiConfigurazione.PORTA_DELEGATA_SOGGETTO_EROGATORE_STATIC.equals(pd.getSoggettoErogatore().getIdentificazione()) || pd.getSoggettoErogatore().getIdentificazione() == null) {
                    soggettoErogatore.setNome(pd.getSoggettoErogatore().getNome());
                } else if (readFirstHeaderIntegrazione && headerIntegrazione.getBusta() != null && headerIntegrazione.getBusta().getDestinatario() != null) {
                    soggettoErogatore.setNome(headerIntegrazione.getBusta().getDestinatario());
                    if (headerIntegrazione.getBusta().getTipoDestinatario() != null) {
                        soggettoErogatore.setTipo(headerIntegrazione.getBusta().getTipoDestinatario());
                    }
                } else if (CostantiConfigurazione.PORTA_DELEGATA_SOGGETTO_EROGATORE_URL_BASED.equals(pd.getSoggettoErogatore().getIdentificazione())) {
                    sog = RegularExpressionEngine.getStringMatchPattern((String)urlInvocazionePD, (String)pd.getSoggettoErogatore().getPattern());
                    if (sog != null) {
                        sog = sog.replaceAll("_", "");
                    }
                    soggettoErogatore.setNome(sog);
                } else if (CostantiConfigurazione.PORTA_DELEGATA_SOGGETTO_EROGATORE_CONTENT_BASED.equals(pd.getSoggettoErogatore().getIdentificazione())) {
                    sog = xPathEngine.getStringMatchPattern((SOAPElement)envelope, dnc, pd.getSoggettoErogatore().getPattern());
                    soggettoErogatore.setNome(sog);
                } else if (CostantiConfigurazione.PORTA_DELEGATA_SOGGETTO_EROGATORE_INPUT_BASED.equals(pd.getSoggettoErogatore().getIdentificazione()) && headerIntegrazione.getBusta() != null) {
                    soggettoErogatore.setNome(headerIntegrazione.getBusta().getDestinatario());
                    if (headerIntegrazione.getBusta().getTipoDestinatario() != null) {
                        soggettoErogatore.setTipo(headerIntegrazione.getBusta().getTipoDestinatario());
                    }
                }
                try {
                    soggettoErogatore.setCodicePorta(registroServiziManager.getDominio(soggettoErogatore, null, protocolFactory));
                }
                catch (Exception e) {}
            }
            catch (Exception e) {
                throw new PDIdentificazioneDinamicaException(PDIdentificazioneDinamica.SOGGETTO_EROGATORE, e.getMessage(), e);
            }
            String servizio = null;
            String tipoServizio = pd.getServizio().getTipo();
            try {
                if (CostantiConfigurazione.PORTA_DELEGATA_SERVIZIO_STATIC.equals(pd.getServizio().getIdentificazione()) || pd.getServizio().getIdentificazione() == null) {
                    servizio = pd.getServizio().getNome();
                } else if (readFirstHeaderIntegrazione && headerIntegrazione.getBusta() != null && headerIntegrazione.getBusta().getServizio() != null) {
                    servizio = headerIntegrazione.getBusta().getServizio();
                    if (headerIntegrazione.getBusta().getTipoServizio() != null) {
                        tipoServizio = headerIntegrazione.getBusta().getTipoServizio();
                    }
                } else if (CostantiConfigurazione.PORTA_DELEGATA_SERVIZIO_URL_BASED.equals(pd.getServizio().getIdentificazione())) {
                    servizio = RegularExpressionEngine.getStringMatchPattern((String)urlInvocazionePD, (String)pd.getServizio().getPattern());
                } else if (CostantiConfigurazione.PORTA_DELEGATA_SERVIZIO_CONTENT_BASED.equals(pd.getServizio().getIdentificazione())) {
                    servizio = xPathEngine.getStringMatchPattern((SOAPElement)envelope, dnc, pd.getServizio().getPattern());
                } else if (CostantiConfigurazione.PORTA_DELEGATA_SERVIZIO_INPUT_BASED.equals(pd.getServizio().getIdentificazione()) && headerIntegrazione.getBusta() != null) {
                    servizio = headerIntegrazione.getBusta().getServizio();
                    if (headerIntegrazione.getBusta().getTipoServizio() != null) {
                        tipoServizio = headerIntegrazione.getBusta().getTipoServizio();
                    }
                }
            }
            catch (Exception e) {
                throw new PDIdentificazioneDinamicaException(PDIdentificazioneDinamica.SERVIZIO, e.getMessage(), e);
            }
            String azione = null;
            Exception eAzione = null;
            try {
                if (pd.getAzione() != null) {
                    if (CostantiConfigurazione.PORTA_DELEGATA_AZIONE_STATIC.equals(pd.getAzione().getIdentificazione()) || pd.getAzione().getIdentificazione() == null) {
                        azione = pd.getAzione().getNome();
                    } else if (readFirstHeaderIntegrazione && headerIntegrazione.getBusta() != null && headerIntegrazione.getBusta().getAzione() != null) {
                        azione = headerIntegrazione.getBusta().getAzione();
                    } else if (CostantiConfigurazione.PORTA_DELEGATA_AZIONE_URL_BASED.equals(pd.getAzione().getIdentificazione())) {
                        azione = RegularExpressionEngine.getStringMatchPattern((String)urlInvocazionePD, (String)pd.getAzione().getPattern());
                    } else if (CostantiConfigurazione.PORTA_DELEGATA_AZIONE_CONTENT_BASED.equals(pd.getAzione().getIdentificazione())) {
                        azione = xPathEngine.getStringMatchPattern((SOAPElement)envelope, dnc, pd.getAzione().getPattern());
                    } else if (CostantiConfigurazione.PORTA_DELEGATA_AZIONE_INPUT_BASED.equals(pd.getAzione().getIdentificazione())) {
                        if (headerIntegrazione.getBusta() == null) throw new DriverConfigurazioneNotFound("Azione non indicata negli header di integrazione");
                        azione = headerIntegrazione.getBusta().getAzione();
                    } else if (CostantiConfigurazione.PORTA_DELEGATA_AZIONE_SOAP_ACTION_BASED.equals(pd.getAzione().getIdentificazione())) {
                        azione = soapAction;
                        if ((azione = azione.trim()).startsWith("\"")) {
                            azione = azione.substring(1);
                        }
                        if (azione.endsWith("\"")) {
                            azione = azione.substring(0, azione.length() - 1);
                        }
                        if ("".equals(azione)) {
                            azione = null;
                            throw new DriverConfigurazioneNotFound("SoapAction vuota (" + soapAction + ") non \u00e8 utilizzabile con una identificazione 'soapActionBased'");
                        }
                    } else if (CostantiConfigurazione.PORTA_DELEGATA_AZIONE_WSDL_BASED.equals(pd.getAzione().getIdentificazione())) {
                        idServizio = new IDServizio(soggettoErogatore, tipoServizio, servizio);
                        OperationFinder.checkIDServizioPerRiconoscimentoAzione((IDServizio)idServizio, (ModalitaIdentificazione)ModalitaIdentificazione.WSDL_BASED);
                        azione = OperationFinder.searchOperationByRequestMessage((OpenSPCoop2Message)message, (RegistroServiziManager)registroServiziManager, (IDServizio)idServizio, (Logger)this.log);
                    }
                }
            }
            catch (Exception e) {
                eAzione = e;
            }
            if (azione == null && pd.getAzione() != null && StatoFunzionalita.ABILITATO.equals(pd.getAzione().getForceWsdlBased())) {
                try {
                    idServizio = new IDServizio(soggettoErogatore, tipoServizio, servizio);
                    OperationFinder.checkIDServizioPerRiconoscimentoAzione((IDServizio)idServizio, (ModalitaIdentificazione)ModalitaIdentificazione.WSDL_BASED);
                    azione = OperationFinder.searchOperationByRequestMessage((OpenSPCoop2Message)message, (RegistroServiziManager)registroServiziManager, (IDServizio)idServizio, (Logger)this.log);
                }
                catch (Exception eForceWsdl) {
                    this.log.debug((Object)("Riconoscimento forzato dell'azione non riuscito: " + eForceWsdl.getMessage()), (Throwable)eForceWsdl);
                }
            }
            if (azione != null) return new IDServizio(soggettoErogatore, tipoServizio, servizio, azione);
            if (eAzione == null) return new IDServizio(soggettoErogatore, tipoServizio, servizio, azione);
            throw new PDIdentificazioneDinamicaException(PDIdentificazioneDinamica.AZIONE, eAzione.getMessage(), eAzione);
        }
        catch (PDIdentificazioneDinamicaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    protected MTOMProcessorConfig getPD_MTOMProcessorForSender(PortaDelegata pd) throws DriverConfigurazioneException {
        MTOMProcessorConfig config = new MTOMProcessorConfig();
        ArrayList<MtomXomPackageInfo> list = new ArrayList<MtomXomPackageInfo>();
        config.setInfo(list);
        if (pd == null) {
            return config;
        }
        MtomProcessor mtomProcessor = pd.getMtomProcessor();
        if (mtomProcessor == null) {
            return config;
        }
        if (mtomProcessor.getRequestFlow() != null) {
            MtomProcessorFlow mtomFlow = mtomProcessor.getRequestFlow();
            config.setMtomProcessorType(mtomFlow.getMode());
            for (int i = 0; i < mtomFlow.sizeParameterList(); ++i) {
                String nome = mtomFlow.getParameter(i).getNome();
                if (nome == null) continue;
                MtomXomPackageInfo info = new MtomXomPackageInfo();
                info.setName(nome);
                info.setXpathExpression(mtomFlow.getParameter(i).getPattern());
                info.setContentType(mtomFlow.getParameter(i).getContentType());
                info.setRequired(mtomFlow.getParameter(i).getRequired());
                list.add(info);
            }
        }
        return config;
    }

    protected MTOMProcessorConfig getPD_MTOMProcessorForReceiver(PortaDelegata pd) throws DriverConfigurazioneException {
        MTOMProcessorConfig config = new MTOMProcessorConfig();
        ArrayList<MtomXomPackageInfo> list = new ArrayList<MtomXomPackageInfo>();
        config.setInfo(list);
        if (pd == null) {
            return config;
        }
        MtomProcessor mtomProcessor = pd.getMtomProcessor();
        if (mtomProcessor == null) {
            return config;
        }
        if (mtomProcessor.getResponseFlow() != null) {
            MtomProcessorFlow mtomFlow = mtomProcessor.getResponseFlow();
            config.setMtomProcessorType(mtomFlow.getMode());
            for (int i = 0; i < mtomFlow.sizeParameterList(); ++i) {
                String nome = mtomFlow.getParameter(i).getNome();
                if (nome == null) continue;
                MtomXomPackageInfo info = new MtomXomPackageInfo();
                info.setName(nome);
                info.setXpathExpression(mtomFlow.getParameter(i).getPattern());
                info.setContentType(mtomFlow.getParameter(i).getContentType());
                info.setRequired(mtomFlow.getParameter(i).getRequired());
                list.add(info);
            }
        }
        return config;
    }

    protected MessageSecurityConfig getPD_MessageSecurityForSender(PortaDelegata pd) throws DriverConfigurazioneException {
        MessageSecurityConfig securityConfig = new MessageSecurityConfig();
        Hashtable<String, Object> table = new Hashtable<String, Object>();
        securityConfig.setFlowParameters(table);
        if (pd == null) {
            return securityConfig;
        }
        if (pd.getStatoMessageSecurity() != null && CostantiConfigurazione.DISABILITATO.toString().equals(pd.getStatoMessageSecurity())) {
            return securityConfig;
        }
        MessageSecurity messageSecurity = pd.getMessageSecurity();
        if (messageSecurity == null) {
            return securityConfig;
        }
        if (messageSecurity.getRequestFlow() != null) {
            MessageSecurityFlow securityFlow = messageSecurity.getRequestFlow();
            if (securityFlow.getApplyToMtom() != null) {
                securityConfig.setApplyToMtom(StatoFunzionalita.ABILITATO.equals(securityFlow.getApplyToMtom()));
            }
            for (int i = 0; i < securityFlow.sizeParameterList(); ++i) {
                String nome = securityFlow.getParameter(i).getNome();
                if (nome == null) continue;
                String valore = securityFlow.getParameter(i).getValore();
                if ("actor".equals(nome)) {
                    if (valore == null) {
                        valore = "";
                    } else if ("notDefined".equals(valore)) {
                        valore = "";
                    }
                }
                table.put(nome, valore);
            }
        }
        return securityConfig;
    }

    protected MessageSecurityConfig getPD_MessageSecurityForReceiver(PortaDelegata pd) throws DriverConfigurazioneException {
        MessageSecurityConfig securityConfig = new MessageSecurityConfig();
        Hashtable<String, Object> table = new Hashtable<String, Object>();
        securityConfig.setFlowParameters(table);
        if (pd == null) {
            return securityConfig;
        }
        if (pd.getStatoMessageSecurity() != null && CostantiConfigurazione.DISABILITATO.toString().equals(pd.getStatoMessageSecurity())) {
            return securityConfig;
        }
        MessageSecurity messageSecurity = pd.getMessageSecurity();
        if (messageSecurity == null) {
            return securityConfig;
        }
        if (messageSecurity.getResponseFlow() != null) {
            MessageSecurityFlow securityFlow = messageSecurity.getResponseFlow();
            if (securityFlow.getApplyToMtom() != null) {
                securityConfig.setApplyToMtom(StatoFunzionalita.ABILITATO.equals(securityFlow.getApplyToMtom()));
            }
            for (int i = 0; i < securityFlow.sizeParameterList(); ++i) {
                String nome = securityFlow.getParameter(i).getNome();
                if (nome == null) continue;
                String valore = securityFlow.getParameter(i).getValore();
                if ("actor".equals(nome)) {
                    if (valore == null) {
                        valore = "";
                    } else if ("notDefined".equals(valore)) {
                        valore = "";
                    }
                }
                table.put(nome, valore);
            }
        }
        return securityConfig;
    }

    protected String getAutenticazione(PortaDelegata pd) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (pd == null) {
            throw new DriverConfigurazioneException("Porta Delegata non fornita");
        }
        if (pd.getAutenticazione() == null || "".equals(pd.getAutenticazione())) {
            return CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_SSL.toString();
        }
        return pd.getAutenticazione();
    }

    protected String getAutorizzazione(PortaDelegata pd) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (pd == null) {
            throw new DriverConfigurazioneException("Porta Delegata non fornita");
        }
        if (pd.getAutorizzazione() == null || "".equals(pd.getAutorizzazione())) {
            return "openspcoop";
        }
        return pd.getAutorizzazione();
    }

    protected String getAutorizzazioneContenuto(PortaDelegata pd) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (pd == null) {
            throw new DriverConfigurazioneException("Porta Delegata non fornita");
        }
        if (pd.getAutorizzazioneContenuto() == null || "".equals(pd.getAutorizzazioneContenuto())) {
            return "none";
        }
        return pd.getAutorizzazioneContenuto();
    }

    protected boolean ricevutaAsincronaSimmetricaAbilitata(PortaDelegata pd) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (pd == null) {
            return true;
        }
        return !CostantiConfigurazione.DISABILITATO.equals(pd.getRicevutaAsincronaSimmetrica());
    }

    protected boolean ricevutaAsincronaAsimmetricaAbilitata(PortaDelegata pd) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (pd == null) {
            return true;
        }
        return !CostantiConfigurazione.DISABILITATO.equals(pd.getRicevutaAsincronaAsimmetrica());
    }

    protected ValidazioneContenutiApplicativi getTipoValidazioneContenutoApplicativo(Connection connectionPdD, PortaDelegata pd, String implementazionePdDSoggetto) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        ValidazioneContenutiApplicativi val = this.getTipoValidazioneContenutoApplicativo(connectionPdD, implementazionePdDSoggetto);
        if (pd == null || pd.getValidazioneContenutiApplicativi() == null) {
            return val;
        }
        ValidazioneContenutiApplicativi valPD = new ValidazioneContenutiApplicativi();
        if (CostantiConfigurazione.STATO_CON_WARNING_ABILITATO.equals(pd.getValidazioneContenutiApplicativi().getStato())) {
            valPD.setStato(CostantiConfigurazione.STATO_CON_WARNING_ABILITATO);
        } else if (CostantiConfigurazione.STATO_CON_WARNING_WARNING_ONLY.equals(pd.getValidazioneContenutiApplicativi().getStato())) {
            valPD.setStato(CostantiConfigurazione.STATO_CON_WARNING_WARNING_ONLY);
        } else if (CostantiConfigurazione.STATO_CON_WARNING_DISABILITATO.equals(pd.getValidazioneContenutiApplicativi().getStato())) {
            valPD.setStato(CostantiConfigurazione.STATO_CON_WARNING_DISABILITATO);
        }
        if (CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_OPENSPCOOP.equals(pd.getValidazioneContenutiApplicativi().getTipo())) {
            valPD.setTipo(CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_OPENSPCOOP);
        } else if (CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_WSDL.equals(pd.getValidazioneContenutiApplicativi().getTipo())) {
            valPD.setTipo(CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_WSDL);
        } else if (CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_XSD.equals(pd.getValidazioneContenutiApplicativi().getTipo())) {
            valPD.setTipo(CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_XSD);
        }
        if (CostantiConfigurazione.ABILITATO.equals(pd.getValidazioneContenutiApplicativi().getAcceptMtomMessage())) {
            valPD.setAcceptMtomMessage(CostantiConfigurazione.ABILITATO);
        } else if (CostantiConfigurazione.DISABILITATO.equals(pd.getValidazioneContenutiApplicativi().getAcceptMtomMessage())) {
            valPD.setAcceptMtomMessage(CostantiConfigurazione.DISABILITATO);
        }
        return valPD;
    }

    protected CorrelazioneApplicativa getCorrelazioneApplicativa(PortaDelegata pd) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (pd == null) {
            throw new DriverConfigurazioneException("Porta Delegata non fornita");
        }
        return pd.getCorrelazioneApplicativa();
    }

    protected CorrelazioneApplicativaRisposta getCorrelazioneApplicativaRisposta(PortaDelegata pd) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (pd == null) {
            throw new DriverConfigurazioneException("Porta Delegata non fornita");
        }
        return pd.getCorrelazioneApplicativaRisposta();
    }

    protected String[] getTipiIntegrazione(PortaDelegata pd) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        String[] tipi = null;
        if (pd != null && pd.getIntegrazione() != null && !"".equals(pd.getIntegrazione())) {
            tipi = pd.getIntegrazione().trim().split(",");
        }
        return tipi;
    }

    protected boolean isGestioneManifestAttachments(Connection connectionPdD, PortaDelegata pd, IProtocolFactory protocolFactory) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (pd == null) {
            try {
                if (protocolFactory.createProtocolConfiguration().isSupportato(FunzionalitaProtocollo.MANIFEST_ATTACHMENTS)) {
                    return this.isGestioneManifestAttachments(connectionPdD);
                }
                return false;
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
            }
        }
        if (CostantiConfigurazione.ABILITATO.equals(pd.getGestioneManifest())) {
            return true;
        }
        if (CostantiConfigurazione.DISABILITATO.equals(pd.getGestioneManifest())) {
            return false;
        }
        try {
            if (protocolFactory.createProtocolConfiguration().isSupportato(FunzionalitaProtocollo.MANIFEST_ATTACHMENTS)) {
                return this.isGestioneManifestAttachments(connectionPdD);
            }
            return false;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    protected boolean isAllegaBody(PortaDelegata pd) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (pd == null) {
            return false;
        }
        if (CostantiConfigurazione.ABILITATO.equals(pd.getAllegaBody())) {
            return true;
        }
        if (CostantiConfigurazione.DISABILITATO.equals(pd.getAllegaBody())) {
            return false;
        }
        return false;
    }

    protected boolean isScartaBody(PortaDelegata pd) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (pd == null) {
            return false;
        }
        if (CostantiConfigurazione.ABILITATO.equals(pd.getScartaBody())) {
            return true;
        }
        if (CostantiConfigurazione.DISABILITATO.equals(pd.getScartaBody())) {
            return false;
        }
        return false;
    }

    protected boolean isModalitaStateless(PortaDelegata pd, ProfiloDiCollaborazione profiloCollaborazione) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (!this.serverJ2EE) {
            return true;
        }
        if (pd == null) {
            if (ProfiloDiCollaborazione.ONEWAY.equals(profiloCollaborazione)) {
                return CostantiConfigurazione.ABILITATO.equals(this.openspcoopProperties.getStatelessOneWay());
            }
            if (ProfiloDiCollaborazione.SINCRONO.equals(profiloCollaborazione)) {
                return CostantiConfigurazione.ABILITATO.equals(this.openspcoopProperties.getStatelessSincrono());
            }
            return CostantiConfigurazione.ABILITATO.equals(this.openspcoopProperties.getStatelessAsincroni());
        }
        if (CostantiConfigurazione.ABILITATO.equals(pd.getStateless())) {
            return true;
        }
        if (CostantiConfigurazione.DISABILITATO.equals(pd.getStateless())) {
            return false;
        }
        if (ProfiloDiCollaborazione.ONEWAY.equals(profiloCollaborazione)) {
            return CostantiConfigurazione.ABILITATO.equals(this.openspcoopProperties.getStatelessOneWay());
        }
        if (ProfiloDiCollaborazione.SINCRONO.equals(profiloCollaborazione)) {
            return CostantiConfigurazione.ABILITATO.equals(this.openspcoopProperties.getStatelessSincrono());
        }
        return CostantiConfigurazione.ABILITATO.equals(this.openspcoopProperties.getStatelessAsincroni());
    }

    protected boolean isLocalForwardMode(PortaDelegata pd) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (pd == null) {
            return false;
        }
        if (CostantiConfigurazione.ABILITATO.equals(pd.getLocalForward())) {
            return true;
        }
        if (CostantiConfigurazione.DISABILITATO.equals(pd.getLocalForward())) {
            return false;
        }
        return false;
    }

    protected List<Object> getExtendedInfo(PortaDelegata pd) throws DriverConfigurazioneException {
        if (pd == null || pd.sizeExtendedInfoList() <= 0) {
            return null;
        }
        return pd.getExtendedInfoList();
    }

    protected Hashtable<IDSoggetto, PortaApplicativa> getPorteApplicative_SoggettiVirtuali(Connection connectionPdD, IDPortaApplicativa idPA) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.configurazionePdD.getPorteApplicative_SoggettiVirtuali(connectionPdD, idPA, null, false);
    }

    protected boolean existsPA(Connection connectionPdD, RichiestaApplicativa idPA) throws DriverConfigurazioneException {
        if (idPA.getIDServizio() == null) {
            return false;
        }
        if (idPA.getIDServizio().getServizio() == null || idPA.getIDServizio().getTipoServizio() == null) {
            return false;
        }
        if (this.isSoggettoVirtuale(connectionPdD, idPA.getIDServizio().getSoggettoErogatore())) {
            Hashtable<IDSoggetto, PortaApplicativa> paConSoggetti = null;
            try {
                paConSoggetti = this.configurazionePdD.getPorteApplicative_SoggettiVirtuali(connectionPdD, idPA.getIdPA(), idPA.getFiltroProprietaPorteApplicative(), true);
            }
            catch (DriverConfigurazioneNotFound e) {
                return false;
            }
            return paConSoggetti != null && paConSoggetti.size() > 0;
        }
        PortaApplicativa pa = null;
        try {
            IDPortaApplicativaByNome idByNome = idPA.getIdPAbyNome();
            if (idByNome == null) {
                return false;
            }
            pa = this.configurazionePdD.getPortaApplicativa(connectionPdD, idByNome.getNome(), idByNome.getSoggetto());
        }
        catch (DriverConfigurazioneNotFound e) {
            return false;
        }
        return pa != null;
    }

    public IDPortaApplicativaByNome convertTo(Connection connectionPdD, IDServizio idServizio, Hashtable<String, String> proprietaPresentiBustaRicevuta) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        IDPortaApplicativa idPA = new IDPortaApplicativa();
        idPA.setIDServizio(idServizio);
        PortaApplicativa pa = this.configurazionePdD.getPortaApplicativa(connectionPdD, idPA, proprietaPresentiBustaRicevuta);
        IDPortaApplicativaByNome id = new IDPortaApplicativaByNome();
        id.setNome(pa.getNome());
        id.setSoggetto(idPA.getIDServizio().getSoggettoErogatore());
        return id;
    }

    public IDPortaApplicativaByNome convertTo_SafeMethod(Connection connectionPdD, IDServizio idServizio, Hashtable<String, String> proprietaPresentiBustaRicevuta) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        try {
            if (idServizio != null && idServizio.getTipoServizio() != null && idServizio.getServizio() != null && idServizio.getSoggettoErogatore() != null && idServizio.getSoggettoErogatore().getTipo() != null && idServizio.getSoggettoErogatore().getNome() != null) {
                return this.convertTo(connectionPdD, idServizio, proprietaPresentiBustaRicevuta);
            }
            return null;
        }
        catch (DriverConfigurazioneNotFound e) {
            return null;
        }
    }

    protected PortaApplicativa getPortaApplicativa(Connection connectionPdD, IDPortaApplicativaByNome idPA) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (idPA == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa]: Parametro non definito (idPA is null)");
        }
        return this.getPortaApplicativa(connectionPdD, idPA.getNome(), idPA.getSoggetto());
    }

    protected PortaApplicativa getPortaApplicativa_SafeMethod(Connection connectionPdD, IDPortaApplicativaByNome idPA) throws DriverConfigurazioneException {
        try {
            if (idPA != null && idPA.getNome() != null && idPA.getSoggetto() != null && idPA.getSoggetto().getTipo() != null && idPA.getSoggetto().getNome() != null) {
                return this.getPortaApplicativa(connectionPdD, idPA.getNome(), idPA.getSoggetto());
            }
            return null;
        }
        catch (DriverConfigurazioneNotFound e) {
            return null;
        }
    }

    protected PortaApplicativa getPortaApplicativa(Connection connectionPdD, String nomePA, IDSoggetto soggettoProprietario) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.configurazionePdD.getPortaApplicativa(connectionPdD, nomePA, soggettoProprietario);
    }

    protected String[] getServiziApplicativi(PortaApplicativa pa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (pa == null) {
            throw new DriverConfigurazioneException("Porta Applicativa non fornita");
        }
        String[] sa = new String[pa.sizeServizioApplicativoList()];
        for (int i = 0; i < pa.sizeServizioApplicativoList(); ++i) {
            sa[i] = pa.getServizioApplicativo(i).getNome();
        }
        return sa;
    }

    protected SoggettoVirtuale getServiziApplicativi_SoggettiVirtuali(Connection connectionPdD, RichiestaApplicativa idPA) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        Hashtable<IDSoggetto, PortaApplicativa> paConSoggetti = this.configurazionePdD.getPorteApplicative_SoggettiVirtuali(connectionPdD, idPA.getIdPA(), idPA.getFiltroProprietaPorteApplicative(), true);
        if (paConSoggetti == null) {
            throw new DriverConfigurazioneNotFound("PorteApplicative contenenti SoggettiVirtuali di [" + idPA.getIdPA() + "] non trovate");
        }
        if (paConSoggetti.size() == 0) {
            throw new DriverConfigurazioneNotFound("PorteApplicative contenenti SoggettiVirtuali di [" + idPA.getIdPA() + "] non trovate");
        }
        Vector<IDSoggetto> soggettiRealiTrovati = new Vector<IDSoggetto>();
        Vector<String> serviziApplicativiTrovati = new Vector<String>();
        Enumeration<IDSoggetto> e = paConSoggetti.keys();
        while (e.hasMoreElements()) {
            IDSoggetto soggReale = e.nextElement();
            PortaApplicativa pa = paConSoggetti.get(soggReale);
            for (int k = 0; k < pa.sizeServizioApplicativoList(); ++k) {
                serviziApplicativiTrovati.add(pa.getServizioApplicativo(k).getNome());
                soggettiRealiTrovati.add(soggReale);
            }
        }
        if (soggettiRealiTrovati.size() == 0) {
            throw new DriverConfigurazioneNotFound("PorteApplicative contenenti SoggettiVirtuali di [" + idPA.getIdPA() + "] non trovati soggetti virtuali");
        }
        IDSoggetto[] soggettiReali = new IDSoggetto[soggettiRealiTrovati.size()];
        String[] serviziApplicativi = new String[serviziApplicativiTrovati.size()];
        soggettiReali = soggettiRealiTrovati.toArray(soggettiReali);
        serviziApplicativi = serviziApplicativiTrovati.toArray(serviziApplicativi);
        SoggettoVirtuale soggVirtuale = new SoggettoVirtuale();
        soggVirtuale.setSoggettiReali(soggettiReali);
        soggVirtuale.setServiziApplicativi(serviziApplicativi);
        return soggVirtuale;
    }

    protected List<PortaApplicativa> getPorteApplicative(Connection connectionPdD, String nomePA, String tipoSoggettoProprietario, String nomeSoggettoProprietario) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.configurazionePdD.getPorteApplicative(connectionPdD, nomePA, tipoSoggettoProprietario, nomeSoggettoProprietario);
    }

    protected MTOMProcessorConfig getPA_MTOMProcessorForSender(PortaApplicativa pa) throws DriverConfigurazioneException {
        MTOMProcessorConfig config = new MTOMProcessorConfig();
        ArrayList<MtomXomPackageInfo> list = new ArrayList<MtomXomPackageInfo>();
        config.setInfo(list);
        if (pa == null) {
            return config;
        }
        MtomProcessor mtomProcessor = pa.getMtomProcessor();
        if (mtomProcessor == null) {
            return config;
        }
        if (mtomProcessor.getResponseFlow() != null) {
            MtomProcessorFlow mtomFlow = mtomProcessor.getResponseFlow();
            config.setMtomProcessorType(mtomFlow.getMode());
            for (int i = 0; i < mtomFlow.sizeParameterList(); ++i) {
                String nome = mtomFlow.getParameter(i).getNome();
                if (nome == null) continue;
                MtomXomPackageInfo info = new MtomXomPackageInfo();
                info.setName(nome);
                info.setXpathExpression(mtomFlow.getParameter(i).getPattern());
                info.setContentType(mtomFlow.getParameter(i).getContentType());
                info.setRequired(mtomFlow.getParameter(i).getRequired());
                list.add(info);
            }
        }
        return config;
    }

    protected MTOMProcessorConfig getPA_MTOMProcessorForReceiver(PortaApplicativa pa) throws DriverConfigurazioneException {
        MTOMProcessorConfig config = new MTOMProcessorConfig();
        ArrayList<MtomXomPackageInfo> list = new ArrayList<MtomXomPackageInfo>();
        config.setInfo(list);
        if (pa == null) {
            return config;
        }
        MtomProcessor mtomProcessor = pa.getMtomProcessor();
        if (mtomProcessor == null) {
            return config;
        }
        if (mtomProcessor.getRequestFlow() != null) {
            MtomProcessorFlow mtomFlow = mtomProcessor.getRequestFlow();
            config.setMtomProcessorType(mtomFlow.getMode());
            for (int i = 0; i < mtomFlow.sizeParameterList(); ++i) {
                String nome = mtomFlow.getParameter(i).getNome();
                if (nome == null) continue;
                MtomXomPackageInfo info = new MtomXomPackageInfo();
                info.setName(nome);
                info.setXpathExpression(mtomFlow.getParameter(i).getPattern());
                info.setContentType(mtomFlow.getParameter(i).getContentType());
                info.setRequired(mtomFlow.getParameter(i).getRequired());
                list.add(info);
            }
        }
        return config;
    }

    protected MessageSecurityConfig getPA_MessageSecurityForSender(PortaApplicativa pa) throws DriverConfigurazioneException {
        MessageSecurityConfig securityConfig = new MessageSecurityConfig();
        Hashtable<String, Object> table = new Hashtable<String, Object>();
        securityConfig.setFlowParameters(table);
        if (pa == null) {
            return securityConfig;
        }
        if (pa.getStatoMessageSecurity() != null && CostantiConfigurazione.DISABILITATO.toString().equals(pa.getStatoMessageSecurity())) {
            return securityConfig;
        }
        MessageSecurity messageSecurity = pa.getMessageSecurity();
        if (messageSecurity == null) {
            return securityConfig;
        }
        if (messageSecurity.getResponseFlow() != null) {
            MessageSecurityFlow securityFlow = messageSecurity.getResponseFlow();
            if (securityFlow.getApplyToMtom() != null) {
                securityConfig.setApplyToMtom(StatoFunzionalita.ABILITATO.equals(securityFlow.getApplyToMtom()));
            }
            for (int i = 0; i < securityFlow.sizeParameterList(); ++i) {
                String nome = securityFlow.getParameter(i).getNome();
                if (nome == null) continue;
                String valore = securityFlow.getParameter(i).getValore();
                if ("actor".equals(nome)) {
                    if (valore == null) {
                        valore = "";
                    } else if ("notDefined".equals(valore)) {
                        valore = "";
                    }
                }
                table.put(nome, valore);
            }
        }
        return securityConfig;
    }

    protected MessageSecurityConfig getPA_MessageSecurityForReceiver(PortaApplicativa pa) throws DriverConfigurazioneException {
        MessageSecurityConfig securityConfig = new MessageSecurityConfig();
        Hashtable<String, Object> table = new Hashtable<String, Object>();
        securityConfig.setFlowParameters(table);
        if (pa == null) {
            return securityConfig;
        }
        if (pa.getStatoMessageSecurity() != null && CostantiConfigurazione.DISABILITATO.toString().equals(pa.getStatoMessageSecurity())) {
            return securityConfig;
        }
        MessageSecurity messageSecurity = pa.getMessageSecurity();
        if (messageSecurity == null) {
            return securityConfig;
        }
        if (messageSecurity.getRequestFlow() != null) {
            MessageSecurityFlow securityFlow = messageSecurity.getRequestFlow();
            if (securityFlow.getApplyToMtom() != null) {
                securityConfig.setApplyToMtom(StatoFunzionalita.ABILITATO.equals(securityFlow.getApplyToMtom()));
            }
            for (int i = 0; i < securityFlow.sizeParameterList(); ++i) {
                String nome = securityFlow.getParameter(i).getNome();
                if (nome == null) continue;
                String valore = securityFlow.getParameter(i).getValore();
                if ("actor".equals(nome)) {
                    if (valore == null) {
                        valore = "";
                    } else if ("notDefined".equals(valore)) {
                        valore = "";
                    }
                }
                table.put(nome, valore);
            }
        }
        return securityConfig;
    }

    protected boolean ricevutaAsincronaSimmetricaAbilitata(PortaApplicativa pa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (pa == null) {
            return true;
        }
        return !CostantiConfigurazione.DISABILITATO.equals(pa.getRicevutaAsincronaSimmetrica());
    }

    protected boolean ricevutaAsincronaAsimmetricaAbilitata(PortaApplicativa pa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (pa == null) {
            return true;
        }
        return !CostantiConfigurazione.DISABILITATO.equals(pa.getRicevutaAsincronaAsimmetrica());
    }

    protected ValidazioneContenutiApplicativi getTipoValidazioneContenutoApplicativo(Connection connectionPdD, PortaApplicativa pa, String implementazionePdDSoggetto) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        ValidazioneContenutiApplicativi val = this.getTipoValidazioneContenutoApplicativo(connectionPdD, implementazionePdDSoggetto);
        if (pa == null || pa.getValidazioneContenutiApplicativi() == null) {
            return val;
        }
        ValidazioneContenutiApplicativi valPA = new ValidazioneContenutiApplicativi();
        if (CostantiConfigurazione.STATO_CON_WARNING_ABILITATO.equals(pa.getValidazioneContenutiApplicativi().getStato())) {
            valPA.setStato(CostantiConfigurazione.STATO_CON_WARNING_ABILITATO);
        } else if (CostantiConfigurazione.STATO_CON_WARNING_WARNING_ONLY.equals(pa.getValidazioneContenutiApplicativi().getStato())) {
            valPA.setStato(CostantiConfigurazione.STATO_CON_WARNING_WARNING_ONLY);
        } else if (CostantiConfigurazione.STATO_CON_WARNING_DISABILITATO.equals(pa.getValidazioneContenutiApplicativi().getStato())) {
            valPA.setStato(CostantiConfigurazione.STATO_CON_WARNING_DISABILITATO);
        }
        if (CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_OPENSPCOOP.equals(pa.getValidazioneContenutiApplicativi().getTipo())) {
            valPA.setTipo(CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_OPENSPCOOP);
        } else if (CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_WSDL.equals(pa.getValidazioneContenutiApplicativi().getTipo())) {
            valPA.setTipo(CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_WSDL);
        } else if (CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_XSD.equals(pa.getValidazioneContenutiApplicativi().getTipo())) {
            valPA.setTipo(CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_XSD);
        }
        if (CostantiConfigurazione.ABILITATO.equals(pa.getValidazioneContenutiApplicativi().getAcceptMtomMessage())) {
            valPA.setAcceptMtomMessage(CostantiConfigurazione.ABILITATO);
        } else if (CostantiConfigurazione.DISABILITATO.equals(pa.getValidazioneContenutiApplicativi().getAcceptMtomMessage())) {
            valPA.setAcceptMtomMessage(CostantiConfigurazione.DISABILITATO);
        }
        return valPA;
    }

    protected CorrelazioneApplicativa getCorrelazioneApplicativa(PortaApplicativa pa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (pa == null) {
            throw new DriverConfigurazioneException("Porta Applicativa non fornita");
        }
        return pa.getCorrelazioneApplicativa();
    }

    protected CorrelazioneApplicativaRisposta getCorrelazioneApplicativaRisposta(PortaApplicativa pa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (pa == null) {
            throw new DriverConfigurazioneException("Porta Applicativa non fornita");
        }
        return pa.getCorrelazioneApplicativaRisposta();
    }

    protected String[] getTipiIntegrazione(PortaApplicativa pa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        String[] tipi = null;
        if (pa != null && pa.getIntegrazione() != null && !"".equals(pa.getIntegrazione())) {
            tipi = pa.getIntegrazione().trim().split(",");
        }
        return tipi;
    }

    protected boolean isGestioneManifestAttachments(Connection connectionPdD, PortaApplicativa pa, IProtocolFactory protocolFactory) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (pa == null) {
            try {
                if (protocolFactory.createProtocolConfiguration().isSupportato(FunzionalitaProtocollo.MANIFEST_ATTACHMENTS)) {
                    return this.isGestioneManifestAttachments(connectionPdD);
                }
                return false;
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
            }
        }
        if (CostantiConfigurazione.ABILITATO.equals(pa.getGestioneManifest())) {
            return true;
        }
        if (CostantiConfigurazione.DISABILITATO.equals(pa.getGestioneManifest())) {
            return false;
        }
        try {
            if (protocolFactory.createProtocolConfiguration().isSupportato(FunzionalitaProtocollo.MANIFEST_ATTACHMENTS)) {
                return this.isGestioneManifestAttachments(connectionPdD);
            }
            return false;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    protected boolean isAllegaBody(PortaApplicativa pa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (pa == null) {
            return false;
        }
        if (CostantiConfigurazione.ABILITATO.equals(pa.getAllegaBody())) {
            return true;
        }
        if (CostantiConfigurazione.DISABILITATO.equals(pa.getAllegaBody())) {
            return false;
        }
        return false;
    }

    protected boolean isScartaBody(PortaApplicativa pa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (pa == null) {
            return false;
        }
        if (CostantiConfigurazione.ABILITATO.equals(pa.getScartaBody())) {
            return true;
        }
        if (CostantiConfigurazione.DISABILITATO.equals(pa.getScartaBody())) {
            return false;
        }
        return false;
    }

    protected boolean isModalitaStateless(PortaApplicativa pa, ProfiloDiCollaborazione profiloCollaborazione) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (!this.serverJ2EE) {
            return true;
        }
        if (pa == null) {
            if (ProfiloDiCollaborazione.ONEWAY.equals(profiloCollaborazione)) {
                return CostantiConfigurazione.ABILITATO.equals(this.openspcoopProperties.getStatelessOneWay());
            }
            if (ProfiloDiCollaborazione.SINCRONO.equals(profiloCollaborazione)) {
                return CostantiConfigurazione.ABILITATO.equals(this.openspcoopProperties.getStatelessSincrono());
            }
            return CostantiConfigurazione.ABILITATO.equals(this.openspcoopProperties.getStatelessAsincroni());
        }
        if (CostantiConfigurazione.ABILITATO.equals(pa.getStateless())) {
            return true;
        }
        if (CostantiConfigurazione.DISABILITATO.equals(pa.getStateless())) {
            return false;
        }
        if (ProfiloDiCollaborazione.ONEWAY.equals(profiloCollaborazione)) {
            return CostantiConfigurazione.ABILITATO.equals(this.openspcoopProperties.getStatelessOneWay());
        }
        if (ProfiloDiCollaborazione.SINCRONO.equals(profiloCollaborazione)) {
            return CostantiConfigurazione.ABILITATO.equals(this.openspcoopProperties.getStatelessSincrono());
        }
        return CostantiConfigurazione.ABILITATO.equals(this.openspcoopProperties.getStatelessAsincroni());
    }

    protected String getAutorizzazioneContenuto(PortaApplicativa pa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (pa == null) {
            throw new DriverConfigurazioneException("Porta Applicativa non fornita");
        }
        if (pa.getAutorizzazioneContenuto() == null || "".equals(pa.getAutorizzazioneContenuto())) {
            return "none";
        }
        return pa.getAutorizzazioneContenuto();
    }

    protected List<Object> getExtendedInfo(PortaApplicativa pa) throws DriverConfigurazioneException {
        if (pa == null || pa.sizeExtendedInfoList() <= 0) {
            return null;
        }
        return pa.getExtendedInfoList();
    }

    protected boolean existsServizioApplicativo(Connection connectionPdD, IDPortaDelegata idPD, String serv) throws DriverConfigurazioneException {
        ServizioApplicativo servizioApplicativo = null;
        try {
            servizioApplicativo = this.configurazionePdD.getServizioApplicativo(connectionPdD, idPD, serv);
        }
        catch (DriverConfigurazioneNotFound e) {
            return false;
        }
        return servizioApplicativo != null;
    }

    protected ServizioApplicativo getServizioApplicativo(Connection connectionPdD, IDPortaDelegata idPD, String serv) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        return this.configurazionePdD.getServizioApplicativo(connectionPdD, idPD, serv);
    }

    protected ServizioApplicativo getServizioApplicativo(Connection connectionPdD, IDPortaApplicativa idPA, String serv) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        return this.configurazionePdD.getServizioApplicativo(connectionPdD, idPA, serv);
    }

    protected IDServizioApplicativo autenticazioneHTTP(Connection connectionPdD, IDSoggetto aSoggetto, String location, String aUser, String aPassword) throws DriverConfigurazioneException {
        ServizioApplicativo servizioApplicativo = null;
        try {
            IDPortaDelegata idPD = new IDPortaDelegata();
            idPD.setSoggettoFruitore(aSoggetto);
            idPD.setLocationPD(location);
            servizioApplicativo = this.configurazionePdD.getServizioApplicativoAutenticato(connectionPdD, idPD, aUser, aPassword);
        }
        catch (DriverConfigurazioneNotFound e) {
            // empty catch block
        }
        if (servizioApplicativo != null) {
            IDServizioApplicativo idSA = new IDServizioApplicativo();
            idSA.setNome(servizioApplicativo.getNome());
            if (servizioApplicativo.getTipoSoggettoProprietario() != null && servizioApplicativo.getNomeSoggettoProprietario() != null) {
                idSA.setIdSoggettoProprietario(new IDSoggetto(servizioApplicativo.getTipoSoggettoProprietario(), servizioApplicativo.getNomeSoggettoProprietario()));
            }
            return idSA;
        }
        return null;
    }

    protected IDServizioApplicativo autenticazioneHTTP(Connection connectionPdD, String aUser, String aPassword) throws DriverConfigurazioneException {
        ServizioApplicativo servizioApplicativo = null;
        try {
            servizioApplicativo = this.configurazionePdD.getServizioApplicativoAutenticato(connectionPdD, aUser, aPassword);
        }
        catch (DriverConfigurazioneNotFound e) {
            // empty catch block
        }
        if (servizioApplicativo != null) {
            IDServizioApplicativo idSA = new IDServizioApplicativo();
            idSA.setNome(servizioApplicativo.getNome());
            if (servizioApplicativo.getTipoSoggettoProprietario() != null && servizioApplicativo.getNomeSoggettoProprietario() != null) {
                idSA.setIdSoggettoProprietario(new IDSoggetto(servizioApplicativo.getTipoSoggettoProprietario(), servizioApplicativo.getNomeSoggettoProprietario()));
            }
            return idSA;
        }
        return null;
    }

    protected IDServizioApplicativo autenticazioneHTTPS(Connection connectionPdD, IDSoggetto aSoggetto, String location, String aSubject) throws DriverConfigurazioneException {
        ServizioApplicativo servizioApplicativo = null;
        try {
            IDPortaDelegata idPD = new IDPortaDelegata();
            idPD.setSoggettoFruitore(aSoggetto);
            idPD.setLocationPD(location);
            servizioApplicativo = this.configurazionePdD.getServizioApplicativoAutenticato(connectionPdD, idPD, aSubject);
        }
        catch (DriverConfigurazioneNotFound e) {
            // empty catch block
        }
        if (servizioApplicativo != null) {
            IDServizioApplicativo idSA = new IDServizioApplicativo();
            idSA.setNome(servizioApplicativo.getNome());
            if (servizioApplicativo.getTipoSoggettoProprietario() != null && servizioApplicativo.getNomeSoggettoProprietario() != null) {
                idSA.setIdSoggettoProprietario(new IDSoggetto(servizioApplicativo.getTipoSoggettoProprietario(), servizioApplicativo.getNomeSoggettoProprietario()));
            }
            return idSA;
        }
        return null;
    }

    protected IDServizioApplicativo autenticazioneHTTPS(Connection connectionPdD, String aSubject) throws DriverConfigurazioneException {
        ServizioApplicativo servizioApplicativo = null;
        try {
            servizioApplicativo = this.configurazionePdD.getServizioApplicativoAutenticato(connectionPdD, aSubject);
        }
        catch (DriverConfigurazioneNotFound e) {
            // empty catch block
        }
        if (servizioApplicativo != null) {
            IDServizioApplicativo idSA = new IDServizioApplicativo();
            idSA.setNome(servizioApplicativo.getNome());
            if (servizioApplicativo.getTipoSoggettoProprietario() != null && servizioApplicativo.getNomeSoggettoProprietario() != null) {
                idSA.setIdSoggettoProprietario(new IDSoggetto(servizioApplicativo.getTipoSoggettoProprietario(), servizioApplicativo.getNomeSoggettoProprietario()));
            }
            return idSA;
        }
        return null;
    }

    protected boolean autorizzazione(PortaDelegata pd, String servizio) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (pd == null || servizio == null) {
            return false;
        }
        for (int j = 0; j < pd.sizeServizioApplicativoList(); ++j) {
            ServizioApplicativo sa = pd.getServizioApplicativo(j);
            if (!servizio.equals(sa.getNome())) continue;
            return true;
        }
        return false;
    }

    protected void aggiornaProprietaGestioneErrorePD(ProprietaErroreApplicativo gestioneErrore, ServizioApplicativo sa) throws DriverConfigurazioneException {
        if (sa == null) {
            return;
        }
        if (sa.getInvocazionePorta() == null) {
            return;
        }
        if (sa.getInvocazionePorta().getGestioneErrore() == null) {
            return;
        }
        InvocazionePortaGestioneErrore proprietaSA = sa.getInvocazionePorta().getGestioneErrore();
        if (CostantiConfigurazione.ERRORE_APPLICATIVO_SOAP.equals(proprietaSA.getFault())) {
            gestioneErrore.setFaultAsXML(false);
        } else if (CostantiConfigurazione.ERRORE_APPLICATIVO_XML.equals(proprietaSA.getFault())) {
            gestioneErrore.setFaultAsXML(true);
        }
        if (proprietaSA.getFaultActor() != null) {
            gestioneErrore.setFaultActor(proprietaSA.getFaultActor());
        }
        if (CostantiConfigurazione.ABILITATO.equals(proprietaSA.getGenericFaultCode())) {
            gestioneErrore.setFaultAsGenericCode(true);
        } else if (CostantiConfigurazione.DISABILITATO.equals(proprietaSA.getGenericFaultCode())) {
            gestioneErrore.setFaultAsGenericCode(false);
        }
        if (proprietaSA.getPrefixFaultCode() != null) {
            gestioneErrore.setFaultPrefixCode(proprietaSA.getPrefixFaultCode());
        }
    }

    protected boolean invocazionePortaDelegataPerRiferimento(ServizioApplicativo sa) throws DriverConfigurazioneException {
        if (sa == null) {
            return false;
        }
        if (sa.getInvocazionePorta() == null) {
            return false;
        }
        return CostantiConfigurazione.ABILITATO.equals(sa.getInvocazionePorta().getInvioPerRiferimento());
    }

    protected boolean invocazionePortaDelegataSbustamentoInformazioniProtocollo(ServizioApplicativo sa) throws DriverConfigurazioneException {
        if (sa == null) {
            return true;
        }
        if (sa.getInvocazionePorta() == null) {
            return true;
        }
        return !CostantiConfigurazione.DISABILITATO.equals(sa.getInvocazionePorta().getSbustamentoInformazioniProtocollo());
    }

    protected boolean invocazioneServizioConGetMessage(ServizioApplicativo sa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (sa == null) {
            return false;
        }
        if (sa.getInvocazioneServizio() == null) {
            return false;
        }
        InvocazioneServizio serv = sa.getInvocazioneServizio();
        return CostantiConfigurazione.ABILITATO.equals(serv.getGetMessage());
    }

    protected boolean invocazioneServizioConSbustamento(ServizioApplicativo sa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (sa == null) {
            return false;
        }
        if (sa.getInvocazioneServizio() == null) {
            return false;
        }
        InvocazioneServizio serv = sa.getInvocazioneServizio();
        return CostantiConfigurazione.ABILITATO.equals(serv.getSbustamentoSoap());
    }

    protected boolean invocazioneServizioConSbustamentoInformazioniProtocollo(ServizioApplicativo sa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (sa == null) {
            return true;
        }
        if (sa.getInvocazioneServizio() == null) {
            return true;
        }
        InvocazioneServizio serv = sa.getInvocazioneServizio();
        return !CostantiConfigurazione.DISABILITATO.equals(serv.getSbustamentoInformazioniProtocollo());
    }

    protected boolean invocazioneServizioConConnettore(ServizioApplicativo sa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (sa == null) {
            return false;
        }
        if (sa.getInvocazioneServizio() == null) {
            return false;
        }
        InvocazioneServizio serv = sa.getInvocazioneServizio();
        Connettore connettore = serv.getConnettore();
        return connettore != null && !"none".equals(connettore.getTipo()) && !CostantiConfigurazione.DISABILITATO.equals(connettore.getTipo());
    }

    protected ConnettoreMsg getInvocazioneServizio(Connection connectionPdD, ServizioApplicativo sa, RichiestaApplicativa idPA) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        int i;
        if (sa.getInvocazioneServizio() == null) {
            throw new DriverConfigurazioneNotFound("Servizio applicativo [" + idPA.getServizioApplicativo() + "] del soggetto[" + idPA.getIDServizio().getSoggettoErogatore() + "] non possieder l'elemento invocazione servizio");
        }
        InvocazioneServizio serv = sa.getInvocazioneServizio();
        IDSoggetto aSoggetto = idPA.getIDServizio().getSoggettoErogatore();
        Soggetto soggetto = this.configurazionePdD.getSoggetto(connectionPdD, aSoggetto);
        if (soggetto == null) {
            throw new DriverConfigurazioneNotFound("[getInvocazioneServizio] Soggetto erogatore non trovato");
        }
        PortaApplicativa pa = this.configurazionePdD.getPortaApplicativa(connectionPdD, idPA.getIdPAbyNome().getNome(), idPA.getIdPAbyNome().getSoggetto());
        Connettore connettore = serv.getConnettore();
        Hashtable<String, String> properties = null;
        if (connettore != null && !CostantiConfigurazione.DISABILITATO.equals(connettore.getTipo())) {
            String nome = connettore.getNome();
            if (connettore.getTipo() == null) {
                for (i = 0; i < soggetto.sizeConnettoreList(); ++i) {
                    if (!nome.equals(soggetto.getConnettore(i).getNome())) continue;
                    connettore = soggetto.getConnettore(i);
                    break;
                }
            }
            this.setPAUrlPrefixRewriter(connectionPdD, connettore, aSoggetto);
            properties = new Hashtable<String, String>();
            for (i = 0; i < connettore.sizePropertyList(); ++i) {
                properties.put(connettore.getProperty(i).getNome(), connettore.getProperty(i).getValore());
            }
        }
        Properties protocol_properties = new Properties();
        for (i = 0; i < pa.sizeProprietaProtocolloList(); ++i) {
            protocol_properties.put(pa.getProprietaProtocollo(i).getNome(), pa.getProprietaProtocollo(i).getValore());
        }
        String autenticazione = CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_NONE.toString();
        String tmp = null;
        if (serv.getAutenticazione() != null) {
            tmp = serv.getAutenticazione().toString();
        }
        if (CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_SSL.toString().equalsIgnoreCase(tmp)) {
            autenticazione = CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_SSL.toString();
        }
        if (CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_BASIC.toString().equalsIgnoreCase(tmp)) {
            autenticazione = CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_BASIC.toString();
        }
        Credenziali credenziali = null;
        if (serv.getCredenziali() != null && serv.getCredenziali().getTipo() != null && autenticazione.equals(serv.getCredenziali().getTipo().toString())) {
            credenziali = new Credenziali();
            credenziali.setUsername(serv.getCredenziali().getUser());
            credenziali.setPassword(serv.getCredenziali().getPassword());
            credenziali.setSubject(serv.getCredenziali().getSubject());
        }
        ConnettoreMsg connettoreMsg = null;
        if (connettore != null) {
            connettoreMsg = new ConnettoreMsg();
            connettoreMsg.setTipoConnettore(connettore.getTipo());
            connettoreMsg.setConnectorProperties(properties);
            connettoreMsg.setSbustamentoSOAP(CostantiConfigurazione.ABILITATO.equals(serv.getSbustamentoSoap()));
            connettoreMsg.setSbustamentoInformazioniProtocollo(!CostantiConfigurazione.DISABILITATO.equals(serv.getSbustamentoInformazioniProtocollo()));
            connettoreMsg.setPropertiesTrasporto(protocol_properties);
            connettoreMsg.setPropertiesUrlBased(protocol_properties);
            connettoreMsg.setAutenticazione(autenticazione);
            connettoreMsg.setCredenziali(credenziali);
        }
        return connettoreMsg;
    }

    protected GestioneErrore getGestioneErroreConnettore_InvocazioneServizio(Connection connectionPdD, ServizioApplicativo sa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (sa.getInvocazioneServizio() == null || sa.getInvocazioneServizio().getGestioneErrore() == null) {
            return this.getGestioneErroreConnettoreComponenteIntegrazione(connectionPdD);
        }
        InvocazioneServizio invocazione = sa.getInvocazioneServizio();
        return invocazione.getGestioneErrore();
    }

    protected boolean invocazioneServizioPerRiferimento(ServizioApplicativo sa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (sa == null) {
            return false;
        }
        if (sa.getInvocazioneServizio() == null) {
            return false;
        }
        return CostantiConfigurazione.ABILITATO.equals(sa.getInvocazioneServizio().getInvioPerRiferimento());
    }

    protected boolean invocazioneServizioRispostaPerRiferimento(ServizioApplicativo sa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (sa == null) {
            return false;
        }
        if (sa.getInvocazioneServizio() == null) {
            return false;
        }
        return CostantiConfigurazione.ABILITATO.equals(sa.getInvocazioneServizio().getRispostaPerRiferimento());
    }

    protected boolean existsConsegnaRispostaAsincrona(ServizioApplicativo sa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (sa == null) {
            return false;
        }
        if (sa.getRispostaAsincrona() == null) {
            return false;
        }
        if (CostantiConfigurazione.ABILITATO.equals(sa.getRispostaAsincrona().getGetMessage())) {
            return true;
        }
        return sa.getRispostaAsincrona().getConnettore() != null && !CostantiConfigurazione.DISABILITATO.equals(sa.getRispostaAsincrona().getConnettore().getTipo());
    }

    protected boolean consegnaRispostaAsincronaConGetMessage(ServizioApplicativo sa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (sa == null) {
            return false;
        }
        if (sa.getRispostaAsincrona() == null) {
            return false;
        }
        RispostaAsincrona serv = sa.getRispostaAsincrona();
        return CostantiConfigurazione.ABILITATO.equals(serv.getGetMessage());
    }

    protected boolean consegnaRispostaAsincronaConSbustamento(ServizioApplicativo sa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (sa == null) {
            return false;
        }
        if (sa.getRispostaAsincrona() == null) {
            return false;
        }
        RispostaAsincrona serv = sa.getRispostaAsincrona();
        return CostantiConfigurazione.ABILITATO.equals(serv.getSbustamentoSoap());
    }

    protected boolean consegnaRispostaAsincronaConSbustamentoInformazioniProtocollo(ServizioApplicativo sa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (sa == null) {
            return true;
        }
        if (sa.getRispostaAsincrona() == null) {
            return true;
        }
        RispostaAsincrona serv = sa.getRispostaAsincrona();
        return !CostantiConfigurazione.DISABILITATO.equals(serv.getSbustamentoInformazioniProtocollo());
    }

    protected boolean consegnaRispostaAsincronaConConnettore(ServizioApplicativo sa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (sa == null) {
            return false;
        }
        if (sa.getRispostaAsincrona() == null) {
            return false;
        }
        RispostaAsincrona serv = sa.getRispostaAsincrona();
        Connettore connettore = serv.getConnettore();
        return connettore != null && !"none".equals(connettore.getTipo()) && !CostantiConfigurazione.DISABILITATO.equals(connettore.getTipo());
    }

    protected ConnettoreMsg getConsegnaRispostaAsincrona(Connection connectionPdD, ServizioApplicativo sa, RichiestaDelegata idPD) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (sa.getRispostaAsincrona() == null) {
            throw new DriverConfigurazioneNotFound("Servizio applicativo [" + idPD.getServizioApplicativo() + "] del soggetto[" + idPD.getSoggettoFruitore() + "] non possiede una risposta Asincrona");
        }
        RispostaAsincrona serv = sa.getRispostaAsincrona();
        IDSoggetto aSoggetto = idPD.getSoggettoFruitore();
        Soggetto soggetto = this.configurazionePdD.getSoggetto(connectionPdD, aSoggetto);
        if (soggetto == null) {
            throw new DriverConfigurazioneNotFound("[getConsegnaRispostaAsincrona] Soggetto non trovato");
        }
        Connettore connettore = serv.getConnettore();
        Hashtable<String, String> properties = null;
        if (connettore != null && !CostantiConfigurazione.DISABILITATO.equals(connettore.getTipo())) {
            int i;
            String nome = connettore.getNome();
            if (connettore.getTipo() == null) {
                for (i = 0; i < soggetto.sizeConnettoreList(); ++i) {
                    if (!nome.equals(soggetto.getConnettore(i).getNome())) continue;
                    connettore = soggetto.getConnettore(i);
                    break;
                }
            }
            this.setPAUrlPrefixRewriter(connectionPdD, connettore, aSoggetto);
            properties = new Hashtable<String, String>();
            for (i = 0; i < connettore.sizePropertyList(); ++i) {
                properties.put(connettore.getProperty(i).getNome(), connettore.getProperty(i).getValore());
            }
        }
        String autenticazione = CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_NONE.toString();
        String tmp = null;
        if (serv.getAutenticazione() != null) {
            tmp = serv.getAutenticazione().toString();
        }
        if (CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_SSL.toString().equalsIgnoreCase(tmp)) {
            autenticazione = CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_SSL.toString();
        }
        if (CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_BASIC.toString().equalsIgnoreCase(tmp)) {
            autenticazione = CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_BASIC.toString();
        }
        Credenziali credenziali = null;
        if (serv.getCredenziali() != null && serv.getCredenziali().getTipo() != null && autenticazione.equals(serv.getCredenziali().getTipo().toString())) {
            credenziali = new Credenziali();
            credenziali.setUsername(serv.getCredenziali().getUser());
            credenziali.setPassword(serv.getCredenziali().getPassword());
            credenziali.setSubject(serv.getCredenziali().getSubject());
        }
        ConnettoreMsg connettoreMsg = null;
        if (connettore != null) {
            connettoreMsg = new ConnettoreMsg();
            connettoreMsg.setTipoConnettore(connettore.getTipo());
            connettoreMsg.setConnectorProperties(properties);
            connettoreMsg.setSbustamentoSOAP(CostantiConfigurazione.ABILITATO.equals(serv.getSbustamentoSoap()));
            connettoreMsg.setSbustamentoInformazioniProtocollo(!CostantiConfigurazione.DISABILITATO.equals(serv.getSbustamentoInformazioniProtocollo()));
            connettoreMsg.setAutenticazione(autenticazione);
            connettoreMsg.setCredenziali(credenziali);
        }
        return connettoreMsg;
    }

    protected ConnettoreMsg getConsegnaRispostaAsincrona(Connection connectionPdD, ServizioApplicativo sa, RichiestaApplicativa idPA) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        int i;
        if (sa.getRispostaAsincrona() == null) {
            throw new DriverConfigurazioneNotFound("Servizio applicativo [" + idPA.getServizioApplicativo() + "] del soggetto[" + idPA.getSoggettoFruitore() + "] non possiede l'elemento invocazione servizio");
        }
        RispostaAsincrona serv = sa.getRispostaAsincrona();
        IDSoggetto aSoggetto = idPA.getIDServizio().getSoggettoErogatore();
        Soggetto soggetto = this.configurazionePdD.getSoggetto(connectionPdD, aSoggetto);
        if (soggetto == null) {
            throw new DriverConfigurazioneNotFound("[getConsegnaRispostaAsincrona] Soggetto non trovato");
        }
        PortaApplicativa pa = this.configurazionePdD.getPortaApplicativa(connectionPdD, idPA.getIdPAbyNome().getNome(), idPA.getIdPAbyNome().getSoggetto());
        Connettore connettore = serv.getConnettore();
        Hashtable<String, String> properties = null;
        if (connettore != null && !CostantiConfigurazione.DISABILITATO.equals(connettore.getTipo())) {
            String nome = connettore.getNome();
            if (connettore.getTipo() == null) {
                for (i = 0; i < soggetto.sizeConnettoreList(); ++i) {
                    if (!nome.equals(soggetto.getConnettore(i).getNome())) continue;
                    connettore = soggetto.getConnettore(i);
                    break;
                }
            }
            this.setPAUrlPrefixRewriter(connectionPdD, connettore, aSoggetto);
            properties = new Hashtable<String, String>();
            for (i = 0; i < connettore.sizePropertyList(); ++i) {
                properties.put(connettore.getProperty(i).getNome(), connettore.getProperty(i).getValore());
            }
        }
        Properties protocol_properties = new Properties();
        for (i = 0; i < pa.sizeProprietaProtocolloList(); ++i) {
            protocol_properties.put(pa.getProprietaProtocollo(i).getNome(), pa.getProprietaProtocollo(i).getValore());
        }
        String autenticazione = CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_NONE.toString();
        String tmp = null;
        if (serv.getAutenticazione() != null) {
            tmp = serv.getAutenticazione().toString();
        }
        if (CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_SSL.toString().equalsIgnoreCase(tmp)) {
            autenticazione = CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_SSL.toString();
        }
        if (CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_BASIC.toString().equalsIgnoreCase(tmp)) {
            autenticazione = CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_BASIC.toString();
        }
        Credenziali credenziali = null;
        if (serv.getCredenziali() != null && serv.getCredenziali().getTipo() != null && autenticazione.equals(serv.getCredenziali().getTipo().toString())) {
            credenziali = new Credenziali();
            credenziali.setUsername(serv.getCredenziali().getUser());
            credenziali.setPassword(serv.getCredenziali().getPassword());
            credenziali.setSubject(serv.getCredenziali().getSubject());
        }
        ConnettoreMsg connettoreMsg = null;
        if (connettore != null) {
            connettoreMsg = new ConnettoreMsg();
            connettoreMsg.setTipoConnettore(connettore.getTipo());
            connettoreMsg.setConnectorProperties(properties);
            connettoreMsg.setSbustamentoSOAP(CostantiConfigurazione.ABILITATO.equals(serv.getSbustamentoSoap()));
            connettoreMsg.setSbustamentoInformazioniProtocollo(!CostantiConfigurazione.DISABILITATO.equals(serv.getSbustamentoInformazioniProtocollo()));
            connettoreMsg.setPropertiesTrasporto(protocol_properties);
            connettoreMsg.setPropertiesUrlBased(protocol_properties);
            connettoreMsg.setAutenticazione(autenticazione);
            connettoreMsg.setCredenziali(credenziali);
        }
        return connettoreMsg;
    }

    protected GestioneErrore getGestioneErroreConnettore_RispostaAsincrona(Connection connectionPdD, ServizioApplicativo sa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (sa.getRispostaAsincrona() == null || sa.getRispostaAsincrona().getGestioneErrore() == null) {
            return this.getGestioneErroreConnettoreComponenteIntegrazione(connectionPdD);
        }
        RispostaAsincrona asincrona = sa.getRispostaAsincrona();
        return asincrona.getGestioneErrore();
    }

    protected boolean consegnaRispostaAsincronaPerRiferimento(ServizioApplicativo sa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (sa == null) {
            return false;
        }
        if (sa.getRispostaAsincrona() == null) {
            return false;
        }
        return CostantiConfigurazione.ABILITATO.equals(sa.getRispostaAsincrona().getInvioPerRiferimento());
    }

    protected boolean consegnaRispostaAsincronaRispostaPerRiferimento(ServizioApplicativo sa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (sa == null) {
            return false;
        }
        if (sa.getRispostaAsincrona() == null) {
            return false;
        }
        return CostantiConfigurazione.ABILITATO.equals(sa.getRispostaAsincrona().getRispostaPerRiferimento());
    }

    protected AccessoRegistro getAccessoRegistroServizi(Connection connectionPdD) {
        if (this.configurazioneDinamica || !accessoRegistroServiziLetto.booleanValue()) {
            AccessoRegistro configRegistro = null;
            try {
                configRegistro = this.configurazionePdD.getAccessoRegistro(connectionPdD);
            }
            catch (DriverConfigurazioneNotFound e) {
                this.log.debug((Object)("getAccessoRegistroServizi (not found): " + e.getMessage()));
            }
            catch (Exception e) {
                this.log.error((Object)"getAccessoRegistroServizi", (Throwable)e);
            }
            accessoRegistroServizi = configRegistro;
            accessoRegistroServiziLetto = true;
        }
        return accessoRegistroServizi;
    }

    protected AccessoConfigurazione getAccessoConfigurazione(Connection connectionPdD) {
        if (this.configurazioneDinamica || !accessoConfigurazioneLetto.booleanValue()) {
            AccessoConfigurazione tmp = null;
            try {
                tmp = this.configurazionePdD.getAccessoConfigurazione(connectionPdD);
            }
            catch (DriverConfigurazioneNotFound e) {
                this.log.debug((Object)("getAccessoConfigurazione (not found): " + e.getMessage()));
            }
            catch (Exception e) {
                this.log.error((Object)"getAccessoConfigurazione", (Throwable)e);
            }
            accessoConfigurazione = tmp;
            accessoConfigurazioneLetto = true;
        }
        return accessoConfigurazione;
    }

    protected AccessoDatiAutorizzazione getAccessoDatiAutorizzazione(Connection connectionPdD) {
        if (this.configurazioneDinamica || !accessoDatiAutorizzazioneLetto.booleanValue()) {
            AccessoDatiAutorizzazione tmp = null;
            try {
                tmp = this.configurazionePdD.getAccessoDatiAutorizzazione(connectionPdD);
            }
            catch (DriverConfigurazioneNotFound e) {
                this.log.debug((Object)("getAccessoDatiAutorizzazione (not found): " + e.getMessage()));
            }
            catch (Exception e) {
                this.log.error((Object)"getAccessoDatiAutorizzazione", (Throwable)e);
            }
            accessoDatiAutorizzazione = tmp;
            accessoDatiAutorizzazioneLetto = true;
        }
        return accessoDatiAutorizzazione;
    }

    protected StatoFunzionalitaConWarning getTipoValidazione(Connection connectionPdD, String implementazionePdDSoggetto) {
        String tipo = this.pddProperties.getValidazioneBuste_Stato(implementazionePdDSoggetto);
        if (tipo != null && (CostantiConfigurazione.STATO_CON_WARNING_ABILITATO.toString().equals(tipo) || CostantiConfigurazione.STATO_CON_WARNING_DISABILITATO.toString().equals(tipo) || CostantiConfigurazione.STATO_CON_WARNING_WARNING_ONLY.toString().equals(tipo))) {
            if (CostantiConfigurazione.STATO_CON_WARNING_ABILITATO.toString().equals(tipo)) {
                return CostantiConfigurazione.STATO_CON_WARNING_ABILITATO;
            }
            if (CostantiConfigurazione.STATO_CON_WARNING_DISABILITATO.toString().equals(tipo)) {
                return CostantiConfigurazione.STATO_CON_WARNING_DISABILITATO;
            }
            return CostantiConfigurazione.STATO_CON_WARNING_WARNING_ONLY;
        }
        if (this.configurazioneDinamica || tipoValidazione == null) {
            Configurazione configurazione = null;
            try {
                configurazione = this.configurazionePdD.getConfigurazioneGenerale(connectionPdD);
            }
            catch (DriverConfigurazioneNotFound e) {
                this.log.debug((Object)("getTipoValidazione (not found): " + e.getMessage()));
            }
            catch (Exception e) {
                this.log.error((Object)"getTipoValidazione", (Throwable)e);
            }
            tipoValidazione = configurazione == null || configurazione.getValidazioneBuste() == null ? CostantiConfigurazione.STATO_CON_WARNING_ABILITATO : (CostantiConfigurazione.STATO_CON_WARNING_ABILITATO.equals(configurazione.getValidazioneBuste().getStato()) ? CostantiConfigurazione.STATO_CON_WARNING_ABILITATO : (CostantiConfigurazione.STATO_CON_WARNING_DISABILITATO.equals(configurazione.getValidazioneBuste().getStato()) ? CostantiConfigurazione.STATO_CON_WARNING_DISABILITATO : (CostantiConfigurazione.STATO_CON_WARNING_WARNING_ONLY.equals(configurazione.getValidazioneBuste().getStato()) ? CostantiConfigurazione.STATO_CON_WARNING_WARNING_ONLY : CostantiConfigurazione.STATO_CON_WARNING_ABILITATO)));
        }
        return tipoValidazione;
    }

    protected boolean isLivelloValidazioneNormale(Connection connectionPdD, String implementazionePdDSoggetto) {
        String value = this.pddProperties.getValidazioneBuste_Controllo(implementazionePdDSoggetto);
        if (value != null && (CostantiConfigurazione.VALIDAZIONE_PROTOCOL_LIVELLO_NORMALE.toString().equalsIgnoreCase(value) || CostantiConfigurazione.VALIDAZIONE_PROTOCOL_LIVELLO_RIGIDO.toString().equalsIgnoreCase(value))) {
            return CostantiConfigurazione.VALIDAZIONE_PROTOCOL_LIVELLO_NORMALE.toString().equalsIgnoreCase(value);
        }
        if (this.configurazioneDinamica || isLivelloValidazioneNormale == null) {
            Configurazione configurazione = null;
            try {
                configurazione = this.configurazionePdD.getConfigurazioneGenerale(connectionPdD);
            }
            catch (DriverConfigurazioneNotFound e) {
                this.log.debug((Object)("isLivelloValidazioneNormale (not found): " + e.getMessage()));
            }
            catch (Exception e) {
                this.log.error((Object)"isLivelloValidazioneNormale", (Throwable)e);
            }
            isLivelloValidazioneNormale = configurazione == null || configurazione.getValidazioneBuste() == null ? Boolean.valueOf(true) : (CostantiConfigurazione.VALIDAZIONE_PROTOCOL_LIVELLO_NORMALE.equals(configurazione.getValidazioneBuste().getControllo()) ? Boolean.valueOf(true) : Boolean.valueOf(false));
        }
        return isLivelloValidazioneNormale;
    }

    protected boolean isLivelloValidazioneRigido(Connection connectionPdD, String implementazionePdDSoggetto) {
        String value = this.pddProperties.getValidazioneBuste_Controllo(implementazionePdDSoggetto);
        if (value != null && (CostantiConfigurazione.VALIDAZIONE_PROTOCOL_LIVELLO_NORMALE.toString().equalsIgnoreCase(value) || CostantiConfigurazione.VALIDAZIONE_PROTOCOL_LIVELLO_RIGIDO.toString().equalsIgnoreCase(value))) {
            return CostantiConfigurazione.VALIDAZIONE_PROTOCOL_LIVELLO_RIGIDO.toString().equalsIgnoreCase(value);
        }
        if (this.configurazioneDinamica || isLivelloValidazioneRigido == null) {
            Configurazione configurazione = null;
            try {
                configurazione = this.configurazionePdD.getConfigurazioneGenerale(connectionPdD);
            }
            catch (DriverConfigurazioneNotFound e) {
                this.log.debug((Object)("isLivelloValidazioneRigido (not found): " + e.getMessage()));
            }
            catch (Exception e) {
                this.log.error((Object)"isLivelloValidazioneRigido", (Throwable)e);
            }
            isLivelloValidazioneRigido = configurazione == null || configurazione.getValidazioneBuste() == null ? Boolean.valueOf(false) : (CostantiConfigurazione.VALIDAZIONE_PROTOCOL_LIVELLO_RIGIDO.equals(configurazione.getValidazioneBuste().getControllo()) ? Boolean.valueOf(true) : Boolean.valueOf(false));
        }
        return isLivelloValidazioneRigido;
    }

    protected boolean isValidazioneProfiloCollaborazione(Connection connectionPdD, String implementazionePdDSoggetto) {
        String value = this.pddProperties.getValidazioneBuste_ProfiloCollaborazione(implementazionePdDSoggetto);
        if (value != null && (CostantiConfigurazione.ABILITATO.toString().equalsIgnoreCase(value) || CostantiConfigurazione.DISABILITATO.toString().equalsIgnoreCase(value))) {
            return CostantiConfigurazione.ABILITATO.toString().equalsIgnoreCase(value);
        }
        if (this.configurazioneDinamica || validazioneProfiloCollaborazione == null) {
            Configurazione configurazione = null;
            try {
                configurazione = this.configurazionePdD.getConfigurazioneGenerale(connectionPdD);
            }
            catch (DriverConfigurazioneNotFound e) {
                this.log.debug((Object)("isValidazioneProfiloCollaborazione (not found): " + e.getMessage()));
            }
            catch (Exception e) {
                this.log.error((Object)"isValidazioneProfiloCollaborazione", (Throwable)e);
            }
            validazioneProfiloCollaborazione = configurazione == null || configurazione.getValidazioneBuste() == null ? Boolean.valueOf(false) : (CostantiConfigurazione.ABILITATO.equals(configurazione.getValidazioneBuste().getProfiloCollaborazione()) ? Boolean.valueOf(true) : Boolean.valueOf(false));
        }
        return validazioneProfiloCollaborazione;
    }

    protected boolean isValidazioneManifestAttachments(Connection connectionPdD, String implementazionePdDSoggetto) {
        String value = this.pddProperties.getValidazioneBuste_ManifestAttachments(implementazionePdDSoggetto);
        if (value != null && (CostantiConfigurazione.ABILITATO.toString().equalsIgnoreCase(value) || CostantiConfigurazione.DISABILITATO.toString().equalsIgnoreCase(value))) {
            return CostantiConfigurazione.ABILITATO.toString().equalsIgnoreCase(value);
        }
        if (this.configurazioneDinamica || validazioneManifestAttachments == null) {
            Configurazione configurazione = null;
            try {
                configurazione = this.configurazionePdD.getConfigurazioneGenerale(connectionPdD);
            }
            catch (DriverConfigurazioneNotFound e) {
                this.log.debug((Object)("isValidazioneManifestAttachments (not found): " + e.getMessage()));
            }
            catch (Exception e) {
                this.log.debug((Object)"isValidazioneManifestAttachments", (Throwable)e);
            }
            validazioneManifestAttachments = configurazione == null || configurazione.getValidazioneBuste() == null ? Boolean.valueOf(true) : (CostantiConfigurazione.DISABILITATO.equals(configurazione.getValidazioneBuste().getManifestAttachments()) ? Boolean.valueOf(false) : Boolean.valueOf(true));
        }
        return validazioneManifestAttachments;
    }

    protected boolean newConnectionForResponse(Connection connectionPdD) {
        if (this.configurazioneDinamica || newConnectionForResponse == null) {
            Configurazione configurazione = null;
            try {
                configurazione = this.configurazionePdD.getConfigurazioneGenerale(connectionPdD);
            }
            catch (DriverConfigurazioneNotFound e) {
                this.log.debug((Object)("newConnectionForResponse (not found): " + e.getMessage()));
            }
            catch (Exception e) {
                this.log.error((Object)"newConnectionForResponse", (Throwable)e);
            }
            newConnectionForResponse = configurazione == null || configurazione.getRisposte() == null ? Boolean.valueOf(false) : (CostantiConfigurazione.NEW_CONNECTION.equals(configurazione.getRisposte().getConnessione()) ? Boolean.valueOf(true) : Boolean.valueOf(false));
        }
        return newConnectionForResponse;
    }

    protected boolean isUtilizzoIndirizzoTelematico(Connection connectionPdD) {
        if (this.configurazioneDinamica || utilizzoIndirizzoRisposta == null) {
            Configurazione configurazione = null;
            try {
                configurazione = this.configurazionePdD.getConfigurazioneGenerale(connectionPdD);
            }
            catch (DriverConfigurazioneNotFound e) {
                this.log.debug((Object)("isUtilizzoIndirizzoRisposta (not found): " + e.getMessage()));
            }
            catch (Exception e) {
                this.log.error((Object)"isUtilizzoIndirizzoRisposta", (Throwable)e);
            }
            utilizzoIndirizzoRisposta = configurazione == null || configurazione.getIndirizzoRisposta() == null ? Boolean.valueOf(false) : (CostantiConfigurazione.ABILITATO.equals(configurazione.getIndirizzoRisposta().getUtilizzo()) ? Boolean.valueOf(true) : Boolean.valueOf(false));
        }
        return utilizzoIndirizzoRisposta;
    }

    protected boolean isGestioneManifestAttachments(Connection connectionPdD) {
        if (this.configurazioneDinamica || gestioneManifestAttachments == null) {
            Configurazione configurazione = null;
            try {
                configurazione = this.configurazionePdD.getConfigurazioneGenerale(connectionPdD);
            }
            catch (DriverConfigurazioneNotFound e) {
                this.log.debug((Object)("isGestioneManifestAttachments (not found): " + e.getMessage()));
            }
            catch (Exception e) {
                this.log.error((Object)"isGestioneManifestAttachments", (Throwable)e);
            }
            gestioneManifestAttachments = configurazione == null || configurazione.getAttachments() == null ? Boolean.valueOf(false) : (CostantiConfigurazione.ABILITATO.equals(configurazione.getAttachments().getGestioneManifest()) ? Boolean.valueOf(true) : Boolean.valueOf(false));
        }
        return gestioneManifestAttachments;
    }

    protected long getTimeoutRiscontro(Connection connectionPdD) {
        if (this.configurazioneDinamica || timeoutRiscontro == null) {
            Configurazione configurazione = null;
            try {
                configurazione = this.configurazionePdD.getConfigurazioneGenerale(connectionPdD);
            }
            catch (DriverConfigurazioneNotFound e) {
                this.log.debug((Object)("getTimeoutRiscontro (not found): " + e.getMessage()));
            }
            catch (Exception e) {
                this.log.error((Object)"getTimeoutRiscontro", (Throwable)e);
            }
            if (configurazione == null || configurazione.getInoltroBusteNonRiscontrate() == null) {
                timeoutRiscontro = -1L;
            } else if (configurazione.getInoltroBusteNonRiscontrate().getCadenza() == null) {
                timeoutRiscontro = -1L;
            } else {
                Long longValue = null;
                try {
                    longValue = new Long(configurazione.getInoltroBusteNonRiscontrate().getCadenza());
                }
                catch (Exception e) {
                    // empty catch block
                }
                timeoutRiscontro = longValue == null ? Long.valueOf(-1L) : longValue;
            }
        }
        return timeoutRiscontro;
    }

    protected Level getLivello_msgDiagnostici(Connection connectionPdD) {
        if (livello_msgDiagnosticiJMX != null) {
            return livello_msgDiagnosticiJMX;
        }
        if (this.configurazioneDinamica || livello_msgDiagnostici == null) {
            try {
                Configurazione configurazione = null;
                try {
                    configurazione = this.configurazionePdD.getConfigurazioneGenerale(connectionPdD);
                }
                catch (DriverConfigurazioneNotFound e) {
                    this.log.debug((Object)("getLivello_msgDiagnostici (not found): " + e.getMessage()));
                }
                catch (Exception e) {
                    this.log.error((Object)"getLivello_msgDiagnostici", (Throwable)e);
                }
                if (configurazione != null && configurazione.getMessaggiDiagnostici() != null) {
                    String readLevel = configurazione.getMessaggiDiagnostici().getSeverita().toString();
                    livello_msgDiagnostici = LogLevels.toLog4J(readLevel);
                } else {
                    livello_msgDiagnostici = LogLevels.LOG_LEVEL_INFO_PROTOCOL;
                }
            }
            catch (Exception e) {
                livello_msgDiagnostici = LogLevels.LOG_LEVEL_INFO_PROTOCOL;
            }
        }
        return livello_msgDiagnostici;
    }

    protected Level getLivelloLog4J_msgDiagnostici(Connection connectionPdD) {
        if (livelloLog4J_msgDiagnosticiJMX != null) {
            return livelloLog4J_msgDiagnosticiJMX;
        }
        if (this.configurazioneDinamica || livelloLog4J_msgDiagnostici == null) {
            try {
                Configurazione configurazione = null;
                try {
                    configurazione = this.configurazionePdD.getConfigurazioneGenerale(connectionPdD);
                }
                catch (DriverConfigurazioneNotFound e) {
                    this.log.debug((Object)("getLivelloLog4J_msgDiagnostici (not found): " + e.getMessage()));
                }
                catch (Exception e) {
                    this.log.error((Object)"getLivelloLog4J_msgDiagnostici", (Throwable)e);
                }
                if (configurazione != null && configurazione.getMessaggiDiagnostici() != null) {
                    String readLevel = configurazione.getMessaggiDiagnostici().getSeveritaLog4j().toString();
                    livelloLog4J_msgDiagnostici = LogLevels.toLog4J(readLevel);
                } else {
                    livelloLog4J_msgDiagnostici = LogLevels.LOG_LEVEL_INFO_PROTOCOL;
                }
            }
            catch (Exception e) {
                livelloLog4J_msgDiagnostici = LogLevels.LOG_LEVEL_INFO_PROTOCOL;
            }
        }
        return livelloLog4J_msgDiagnostici;
    }

    protected int getSeverita_msgDiagnostici(Connection connectionPdD) {
        if (severita_msgDiagnosticiJMX != null) {
            return severita_msgDiagnosticiJMX;
        }
        if (this.configurazioneDinamica || severita_msgDiagnostici == null) {
            try {
                Configurazione configurazione = null;
                try {
                    configurazione = this.configurazionePdD.getConfigurazioneGenerale(connectionPdD);
                }
                catch (DriverConfigurazioneNotFound e) {
                    this.log.debug((Object)("getSeverita_msgDiagnostici (not found): " + e.getMessage()));
                }
                catch (Exception e) {
                    this.log.error((Object)"getSeverita_msgDiagnostici", (Throwable)e);
                }
                if (configurazione != null && configurazione.getMessaggiDiagnostici() != null) {
                    String readLevel = configurazione.getMessaggiDiagnostici().getSeverita().toString();
                    severita_msgDiagnostici = LogLevels.toOpenSPCoop2(readLevel);
                } else {
                    severita_msgDiagnostici = 3;
                }
            }
            catch (Exception e) {
                severita_msgDiagnostici = 3;
            }
        }
        return severita_msgDiagnostici;
    }

    public static Integer getSeveritaLog4J_msgDiagnosticiJMX() {
        return severitaLog4J_msgDiagnosticiJMX;
    }

    public static void setSeveritaLog4J_msgDiagnosticiJMX(Integer severitaLog4J_msgDiagnosticiJMX) {
        ConfigurazionePdDReader.severitaLog4J_msgDiagnosticiJMX = severitaLog4J_msgDiagnosticiJMX;
    }

    protected int getSeveritaLog4J_msgDiagnostici(Connection connectionPdD) {
        if (severitaLog4J_msgDiagnosticiJMX != null) {
            return severitaLog4J_msgDiagnosticiJMX;
        }
        if (this.configurazioneDinamica || severitaLog4J_msgDiagnostici == null) {
            try {
                Configurazione configurazione = null;
                try {
                    configurazione = this.configurazionePdD.getConfigurazioneGenerale(connectionPdD);
                }
                catch (DriverConfigurazioneNotFound e) {
                    this.log.debug((Object)("getSeveritaOpenSPCoop_msgDiagnostici (not found): " + e.getMessage()));
                }
                catch (Exception e) {
                    this.log.error((Object)"getSeveritaOpenSPCoop_msgDiagnostici", (Throwable)e);
                }
                if (configurazione != null && configurazione.getMessaggiDiagnostici() != null) {
                    String readLevel = configurazione.getMessaggiDiagnostici().getSeveritaLog4j().toString();
                    severitaLog4J_msgDiagnostici = LogLevels.toOpenSPCoop2(readLevel);
                } else {
                    severitaLog4J_msgDiagnostici = 3;
                }
            }
            catch (Exception e) {
                severitaLog4J_msgDiagnostici = 3;
            }
        }
        return severitaLog4J_msgDiagnostici;
    }

    protected MessaggiDiagnostici getOpenSPCoopAppender_MsgDiagnostici(Connection connectionPdD) {
        if (this.configurazioneDinamica || !openSPCoopAppender_MsgDiagnosticiLetto.booleanValue()) {
            try {
                Configurazione configurazione = null;
                try {
                    configurazione = this.configurazionePdD.getConfigurazioneGenerale(connectionPdD);
                }
                catch (DriverConfigurazioneNotFound e) {
                    this.log.debug((Object)("getOpenSPCoopAppender_MsgDiagnostici (not found): " + e.getMessage()));
                }
                catch (Exception e) {
                    this.log.error((Object)"getOpenSPCoopAppender_MsgDiagnostici", (Throwable)e);
                }
                openSPCoopAppender_MsgDiagnostici = configurazione != null ? configurazione.getMessaggiDiagnostici() : null;
            }
            catch (Exception e) {
                openSPCoopAppender_MsgDiagnostici = null;
            }
            openSPCoopAppender_MsgDiagnosticiLetto = true;
        }
        return openSPCoopAppender_MsgDiagnostici;
    }

    protected boolean dumpMessaggi(Connection connectionPdD) {
        if (dumpMessaggiJMX != null) {
            return dumpMessaggiJMX;
        }
        if (this.configurazioneDinamica || dumpMessaggi == null) {
            try {
                StatoFunzionalita read;
                Configurazione configurazione = null;
                try {
                    configurazione = this.configurazionePdD.getConfigurazioneGenerale(connectionPdD);
                }
                catch (DriverConfigurazioneNotFound e) {
                    this.log.debug((Object)("dumpMessaggi (not found): " + e.getMessage()));
                }
                catch (Exception e) {
                    this.log.error((Object)"dumpMessaggi", (Throwable)e);
                }
                dumpMessaggi = configurazione != null && configurazione.getTracciamento() != null ? (CostantiConfigurazione.ABILITATO.equals(read = configurazione.getTracciamento().getDump()) ? Boolean.valueOf(true) : Boolean.valueOf(false)) : Boolean.valueOf(false);
            }
            catch (Exception e) {
                dumpMessaggi = false;
            }
        }
        return dumpMessaggi;
    }

    protected boolean dumpBinarioPD(Connection connectionPdD) {
        if (dumpBinarioPDJMX != null) {
            return dumpBinarioPDJMX;
        }
        if (this.configurazioneDinamica || dumpBinarioPD == null) {
            try {
                StatoFunzionalita read;
                Configurazione configurazione = null;
                try {
                    configurazione = this.configurazionePdD.getConfigurazioneGenerale(connectionPdD);
                }
                catch (DriverConfigurazioneNotFound e) {
                    this.log.debug((Object)("dumpBinarioPD (not found): " + e.getMessage()));
                }
                catch (Exception e) {
                    this.log.error((Object)"dumpBinarioPD", (Throwable)e);
                }
                dumpBinarioPD = configurazione != null && configurazione.getTracciamento() != null ? (CostantiConfigurazione.ABILITATO.equals(read = configurazione.getTracciamento().getDumpBinarioPortaDelegata()) ? Boolean.valueOf(true) : Boolean.valueOf(false)) : Boolean.valueOf(false);
            }
            catch (Exception e) {
                dumpBinarioPD = false;
            }
        }
        return dumpBinarioPD;
    }

    protected boolean dumpBinarioPA(Connection connectionPdD) {
        if (dumpBinarioPAJMX != null) {
            return dumpBinarioPAJMX;
        }
        if (this.configurazioneDinamica || dumpBinarioPA == null) {
            try {
                StatoFunzionalita read;
                Configurazione configurazione = null;
                try {
                    configurazione = this.configurazionePdD.getConfigurazioneGenerale(connectionPdD);
                }
                catch (DriverConfigurazioneNotFound e) {
                    this.log.debug((Object)("dumpBinarioPA (not found): " + e.getMessage()));
                }
                catch (Exception e) {
                    this.log.error((Object)"dumpBinarioPA", (Throwable)e);
                }
                dumpBinarioPA = configurazione != null && configurazione.getTracciamento() != null ? (CostantiConfigurazione.ABILITATO.equals(read = configurazione.getTracciamento().getDumpBinarioPortaApplicativa()) ? Boolean.valueOf(true) : Boolean.valueOf(false)) : Boolean.valueOf(false);
            }
            catch (Exception e) {
                dumpBinarioPA = false;
            }
        }
        return dumpBinarioPA;
    }

    protected boolean tracciamentoBuste(Connection connectionPdD) {
        if (tracciamentoBusteJMX != null) {
            return tracciamentoBusteJMX;
        }
        if (this.configurazioneDinamica || tracciamentoBuste == null) {
            try {
                StatoFunzionalita read;
                Configurazione configurazione = null;
                try {
                    configurazione = this.configurazionePdD.getConfigurazioneGenerale(connectionPdD);
                }
                catch (DriverConfigurazioneNotFound e) {
                    this.log.debug((Object)("tracciamentoBuste (not found): " + e.getMessage()));
                }
                catch (Exception e) {
                    this.log.error((Object)"tracciamentoBuste", (Throwable)e);
                }
                tracciamentoBuste = configurazione != null && configurazione.getTracciamento() != null ? (CostantiConfigurazione.DISABILITATO.equals(read = configurazione.getTracciamento().getBuste()) ? Boolean.valueOf(false) : Boolean.valueOf(true)) : Boolean.valueOf(true);
            }
            catch (Exception e) {
                tracciamentoBuste = true;
            }
        }
        return tracciamentoBuste;
    }

    protected Tracciamento getOpenSPCoopAppender_Tracciamento(Connection connectionPdD) {
        if (this.configurazioneDinamica || !openSPCoopAppender_TracciamentoLetto.booleanValue()) {
            try {
                Configurazione configurazione = null;
                try {
                    configurazione = this.configurazionePdD.getConfigurazioneGenerale(connectionPdD);
                }
                catch (DriverConfigurazioneNotFound e) {
                    this.log.debug((Object)("getOpenSPCoopAppender_Tracciamento (not found): " + e.getMessage()));
                }
                catch (Exception e) {
                    this.log.error((Object)"getOpenSPCoopAppender_Tracciamento", (Throwable)e);
                }
                if (configurazione != null) {
                    openSPCoopAppender_Tracciamento = configurazione.getTracciamento();
                }
            }
            catch (Exception e) {
                openSPCoopAppender_Tracciamento = null;
            }
            openSPCoopAppender_TracciamentoLetto = true;
        }
        return openSPCoopAppender_Tracciamento;
    }

    protected GestioneErrore getGestioneErroreConnettoreComponenteCooperazione(Connection connectionPdD) {
        if (this.configurazioneDinamica || gestioneErroreConnettoreComponenteCooperazione == null) {
            try {
                GestioneErrore gestione = null;
                try {
                    gestione = this.configurazionePdD.getGestioneErroreComponenteCooperazione(connectionPdD);
                }
                catch (DriverConfigurazioneNotFound e) {
                    this.log.debug((Object)("getGestioneErroreConnettoreComponenteCooperazione (not found): " + e.getMessage()));
                }
                catch (Exception e) {
                    this.log.error((Object)"getGestioneErroreConnettoreComponenteCooperazione", (Throwable)e);
                }
                gestioneErroreConnettoreComponenteCooperazione = gestione == null ? GestoreErroreConnettore.getGestioneErroreDefaultComponenteCooperazione() : gestione;
            }
            catch (Exception e) {
                gestioneErroreConnettoreComponenteCooperazione = GestoreErroreConnettore.getGestioneErroreDefaultComponenteCooperazione();
            }
        }
        return gestioneErroreConnettoreComponenteCooperazione;
    }

    protected GestioneErrore getGestioneErroreConnettoreComponenteIntegrazione(Connection connectionPdD) {
        if (this.configurazioneDinamica || gestioneErroreConnettoreComponenteIntegrazione == null) {
            try {
                GestioneErrore gestione = null;
                try {
                    gestione = this.configurazionePdD.getGestioneErroreComponenteIntegrazione(connectionPdD);
                }
                catch (DriverConfigurazioneNotFound e) {
                    this.log.debug((Object)("getGestioneErroreConnettoreComponenteIntegrazione (not found): " + e.getMessage()));
                }
                catch (Exception e) {
                    this.log.error((Object)"getGestioneErroreConnettoreComponenteIntegrazione", (Throwable)e);
                }
                gestioneErroreConnettoreComponenteIntegrazione = gestione == null ? GestoreErroreConnettore.getGestioneErroreDefaultComponenteIntegrazione() : gestione;
            }
            catch (Exception e) {
                gestioneErroreConnettoreComponenteIntegrazione = GestoreErroreConnettore.getGestioneErroreDefaultComponenteIntegrazione();
            }
        }
        return gestioneErroreConnettoreComponenteIntegrazione;
    }

    protected String[] getIntegrationManagerAuthentication(Connection connectionPdD) {
        block10: {
            if (this.configurazioneDinamica || integrationManagerAuthentication == null) {
                try {
                    Configurazione configurazione = null;
                    try {
                        configurazione = this.configurazionePdD.getConfigurazioneGenerale(connectionPdD);
                    }
                    catch (DriverConfigurazioneNotFound e) {
                        this.log.debug((Object)("getIntegrationManagerAuthentication (not found): " + e.getMessage()));
                    }
                    catch (Exception e) {
                        this.log.error((Object)"getIntegrationManagerAuthentication", (Throwable)e);
                    }
                    if (configurazione == null || configurazione.getIntegrationManager() == null || configurazione.getIntegrationManager().getAutenticazione() == null) {
                        integrationManagerAuthentication = new String[]{CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_BASIC.toString(), CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_SSL.toString()};
                        break block10;
                    }
                    String[] values = configurazione.getIntegrationManager().getAutenticazione().split(",");
                    Vector<String> v = new Vector<String>();
                    ClassNameProperties classNameProperties = ClassNameProperties.getInstance();
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = values[i].trim();
                        if (classNameProperties.getAutenticazione(values[i]) == null) {
                            this.log.error((Object)("Meccanismo di autenticazione [" + values[i] + "] non registrato nella Porta di Dominio"));
                            continue;
                        }
                        v.add(values[i]);
                    }
                    if (v.size() > 0) {
                        integrationManagerAuthentication = v.toArray(new String[1]);
                        break block10;
                    }
                    throw new Exception("Nessun meccanismo di autenticazione valido tra quelli esistenti");
                }
                catch (Exception e) {
                    this.log.error((Object)("Errore durante la lettura del tipo di autenticazione associato al servizio di IntegrationManager: " + e.getMessage()));
                    integrationManagerAuthentication = new String[]{CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_BASIC.toString(), CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_SSL.toString()};
                }
            }
        }
        return integrationManagerAuthentication;
    }

    protected ValidazioneContenutiApplicativi getTipoValidazioneContenutoApplicativo(Connection connectionPdD, String implementazionePdDSoggetto) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        ValidazioneContenutiApplicativi valDefault = new ValidazioneContenutiApplicativi();
        valDefault.setStato(CostantiConfigurazione.STATO_CON_WARNING_DISABILITATO);
        valDefault.setTipo(CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_XSD);
        String stato = this.pddProperties.getValidazioneContenutiApplicativi_Stato(implementazionePdDSoggetto);
        String tipo = this.pddProperties.getValidazioneContenutiApplicativi_Tipo(implementazionePdDSoggetto);
        String acceptMtomMessage = this.pddProperties.getValidazioneContenutiApplicativi_AcceptMtomMessage(implementazionePdDSoggetto);
        boolean pddPropertiesPresente = false;
        if (stato != null && (CostantiConfigurazione.STATO_CON_WARNING_ABILITATO.toString().equalsIgnoreCase(stato) || CostantiConfigurazione.STATO_CON_WARNING_DISABILITATO.toString().equalsIgnoreCase(stato) || CostantiConfigurazione.STATO_CON_WARNING_WARNING_ONLY.toString().equalsIgnoreCase(stato))) {
            if (CostantiConfigurazione.STATO_CON_WARNING_ABILITATO.toString().equalsIgnoreCase(stato)) {
                valDefault.setStato(CostantiConfigurazione.STATO_CON_WARNING_ABILITATO);
            } else if (CostantiConfigurazione.STATO_CON_WARNING_DISABILITATO.toString().equalsIgnoreCase(stato)) {
                valDefault.setStato(CostantiConfigurazione.STATO_CON_WARNING_DISABILITATO);
            } else {
                valDefault.setStato(CostantiConfigurazione.STATO_CON_WARNING_WARNING_ONLY);
            }
            pddPropertiesPresente = true;
        }
        if (tipo != null && (CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_WSDL.toString().equalsIgnoreCase(stato) || CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_XSD.toString().equalsIgnoreCase(stato) || CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_OPENSPCOOP.toString().equalsIgnoreCase(stato))) {
            if (CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_WSDL.toString().equalsIgnoreCase(stato)) {
                valDefault.setTipo(CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_WSDL);
            } else if (CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_XSD.toString().equalsIgnoreCase(stato)) {
                valDefault.setTipo(CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_XSD);
            } else {
                valDefault.setTipo(CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_OPENSPCOOP);
            }
            pddPropertiesPresente = true;
        }
        if (acceptMtomMessage != null && (CostantiConfigurazione.ABILITATO.toString().equalsIgnoreCase(acceptMtomMessage) || CostantiConfigurazione.DISABILITATO.toString().equalsIgnoreCase(acceptMtomMessage))) {
            if (CostantiConfigurazione.ABILITATO.toString().equalsIgnoreCase(stato)) {
                valDefault.setAcceptMtomMessage(CostantiConfigurazione.ABILITATO);
            } else if (CostantiConfigurazione.DISABILITATO.toString().equalsIgnoreCase(stato)) {
                valDefault.setAcceptMtomMessage(CostantiConfigurazione.DISABILITATO);
            } else {
                valDefault.setAcceptMtomMessage(CostantiConfigurazione.DISABILITATO);
            }
            pddPropertiesPresente = true;
        }
        if (pddPropertiesPresente) {
            return valDefault;
        }
        if (this.configurazioneDinamica || validazioneContenutiApplicativi == null) {
            try {
                Configurazione configurazione = null;
                try {
                    configurazione = this.configurazionePdD.getConfigurazioneGenerale(connectionPdD);
                }
                catch (DriverConfigurazioneNotFound e) {
                    this.log.debug((Object)("getTipoValidazioneContenutoApplicativo (not found): " + e.getMessage()));
                }
                catch (Exception e) {
                    this.log.error((Object)"getTipoValidazioneContenutoApplicativo", (Throwable)e);
                }
                if (configurazione == null || configurazione.getValidazioneContenutiApplicativi() == null) {
                    validazioneContenutiApplicativi = valDefault;
                } else {
                    ValidazioneContenutiApplicativi val = new ValidazioneContenutiApplicativi();
                    if (configurazione.getValidazioneContenutiApplicativi().getStato() == null) {
                        val.setStato(CostantiConfigurazione.STATO_CON_WARNING_DISABILITATO);
                    } else if (CostantiConfigurazione.STATO_CON_WARNING_ABILITATO.equals(configurazione.getValidazioneContenutiApplicativi().getStato())) {
                        val.setStato(CostantiConfigurazione.STATO_CON_WARNING_ABILITATO);
                    } else if (CostantiConfigurazione.STATO_CON_WARNING_WARNING_ONLY.equals(configurazione.getValidazioneContenutiApplicativi().getStato())) {
                        val.setStato(CostantiConfigurazione.STATO_CON_WARNING_WARNING_ONLY);
                    } else {
                        val.setStato(CostantiConfigurazione.STATO_CON_WARNING_DISABILITATO);
                    }
                    if (configurazione.getValidazioneContenutiApplicativi().getTipo() == null) {
                        val.setTipo(CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_XSD);
                    } else if (CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_WSDL.equals(configurazione.getValidazioneContenutiApplicativi().getTipo())) {
                        val.setTipo(CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_WSDL);
                    } else if (CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_OPENSPCOOP.equals(configurazione.getValidazioneContenutiApplicativi().getTipo())) {
                        val.setTipo(CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_OPENSPCOOP);
                    } else {
                        val.setTipo(CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_XSD);
                    }
                    if (configurazione.getValidazioneContenutiApplicativi().getAcceptMtomMessage() == null) {
                        val.setAcceptMtomMessage(CostantiConfigurazione.DISABILITATO);
                    } else if (CostantiConfigurazione.ABILITATO.equals(configurazione.getValidazioneContenutiApplicativi().getAcceptMtomMessage())) {
                        val.setAcceptMtomMessage(CostantiConfigurazione.ABILITATO);
                    } else if (CostantiConfigurazione.DISABILITATO.equals(configurazione.getValidazioneContenutiApplicativi().getAcceptMtomMessage())) {
                        val.setAcceptMtomMessage(CostantiConfigurazione.DISABILITATO);
                    } else {
                        val.setAcceptMtomMessage(CostantiConfigurazione.DISABILITATO);
                    }
                    validazioneContenutiApplicativi = val;
                }
            }
            catch (Exception e) {
                validazioneContenutiApplicativi = valDefault;
            }
        }
        return validazioneContenutiApplicativi;
    }

    protected Boolean isPDServiceActive() {
        if (this.configurazioneDinamica || isPDServiceActive == null) {
            try {
                StatoServiziPdd stato = null;
                try {
                    stato = this.configurazionePdD.getStatoServiziPdD();
                }
                catch (DriverConfigurazioneNotFound e) {
                    this.log.debug((Object)("isPDServiceActive (not found): " + e.getMessage()));
                }
                catch (Exception e) {
                    this.log.error((Object)"isPDServiceActive", (Throwable)e);
                }
                isPDServiceActive = stato == null || stato.getPortaDelegata() == null || stato.getPortaDelegata().getStato() == null ? Boolean.valueOf(true) : Boolean.valueOf(!CostantiConfigurazione.DISABILITATO.equals(stato.getPortaDelegata().getStato()));
            }
            catch (Exception e) {
                this.log.error((Object)("Errore durante la lettura dell'indicazione se il servizio porta delegata e' attivo: " + e.getMessage()));
                isPDServiceActive = false;
            }
        }
        return isPDServiceActive;
    }

    protected List<TipoFiltroAbilitazioneServizi> getFiltriAbilitazionePDService() {
        if (this.configurazioneDinamica || isPDServiceActive == null) {
            try {
                StatoServiziPdd stato = null;
                try {
                    stato = this.configurazionePdD.getStatoServiziPdD();
                }
                catch (DriverConfigurazioneNotFound e) {
                    this.log.debug((Object)("getFiltriAbilitazionePDService (not found): " + e.getMessage()));
                }
                catch (Exception e) {
                    this.log.error((Object)"getFiltriAbilitazionePDService", (Throwable)e);
                }
                getFiltriAbilitazionePDService = stato == null || stato.getPortaDelegata() == null || stato.getPortaDelegata().sizeFiltroAbilitazioneList() <= 0 ? new ArrayList<TipoFiltroAbilitazioneServizi>() : stato.getPortaDelegata().getFiltroAbilitazioneList();
            }
            catch (Exception e) {
                this.log.error((Object)("Errore durante la raccolta dei filtri di abilitazione PD: " + e.getMessage()));
                getFiltriAbilitazionePDService = new ArrayList<TipoFiltroAbilitazioneServizi>();
            }
        }
        return getFiltriAbilitazionePDService;
    }

    protected List<TipoFiltroAbilitazioneServizi> getFiltriDisabilitazionePDService() {
        if (this.configurazioneDinamica || isPDServiceActive == null) {
            try {
                StatoServiziPdd stato = null;
                try {
                    stato = this.configurazionePdD.getStatoServiziPdD();
                }
                catch (DriverConfigurazioneNotFound e) {
                    this.log.debug((Object)("getFiltriDisabilitazionePDService (not found): " + e.getMessage()));
                }
                catch (Exception e) {
                    this.log.error((Object)"getFiltriDisabilitazionePDService", (Throwable)e);
                }
                getFiltriDisabilitazionePDService = stato == null || stato.getPortaDelegata() == null || stato.getPortaDelegata().sizeFiltroDisabilitazioneList() <= 0 ? new ArrayList<TipoFiltroAbilitazioneServizi>() : stato.getPortaDelegata().getFiltroDisabilitazioneList();
            }
            catch (Exception e) {
                this.log.error((Object)("Errore durante la raccolta dei filtri di disabilitazione PD: " + e.getMessage()));
                getFiltriDisabilitazionePDService = new ArrayList<TipoFiltroAbilitazioneServizi>();
            }
        }
        return getFiltriDisabilitazionePDService;
    }

    protected Boolean isPAServiceActive() {
        if (this.configurazioneDinamica || isPAServiceActive == null) {
            try {
                StatoServiziPdd stato = null;
                try {
                    stato = this.configurazionePdD.getStatoServiziPdD();
                }
                catch (DriverConfigurazioneNotFound e) {
                    this.log.debug((Object)("isPAServiceActive (not found): " + e.getMessage()));
                }
                catch (Exception e) {
                    this.log.error((Object)"isPAServiceActive", (Throwable)e);
                }
                isPAServiceActive = stato == null || stato.getPortaApplicativa() == null || stato.getPortaApplicativa().getStato() == null ? Boolean.valueOf(true) : Boolean.valueOf(!CostantiConfigurazione.DISABILITATO.equals(stato.getPortaApplicativa().getStato()));
            }
            catch (Exception e) {
                this.log.error((Object)("Errore durante la lettura dell'indicazione se il servizio porta applicativa e' attivo: " + e.getMessage()));
                isPAServiceActive = false;
            }
        }
        return isPAServiceActive;
    }

    protected List<TipoFiltroAbilitazioneServizi> getFiltriAbilitazionePAService() {
        if (this.configurazioneDinamica || isPAServiceActive == null) {
            try {
                StatoServiziPdd stato = null;
                try {
                    stato = this.configurazionePdD.getStatoServiziPdD();
                }
                catch (DriverConfigurazioneNotFound e) {
                    this.log.debug((Object)("getFiltriAbilitazionePAService (not found): " + e.getMessage()));
                }
                catch (Exception e) {
                    this.log.error((Object)"getFiltriAbilitazionePAService", (Throwable)e);
                }
                getFiltriAbilitazionePAService = stato == null || stato.getPortaApplicativa() == null || stato.getPortaApplicativa().sizeFiltroAbilitazioneList() <= 0 ? new ArrayList<TipoFiltroAbilitazioneServizi>() : stato.getPortaApplicativa().getFiltroAbilitazioneList();
            }
            catch (Exception e) {
                this.log.error((Object)("Errore durante la raccolta dei filtri di abilitazione PA: " + e.getMessage()));
                getFiltriAbilitazionePAService = new ArrayList<TipoFiltroAbilitazioneServizi>();
            }
        }
        return getFiltriAbilitazionePAService;
    }

    protected List<TipoFiltroAbilitazioneServizi> getFiltriDisabilitazionePAService() {
        if (this.configurazioneDinamica || isPAServiceActive == null) {
            try {
                StatoServiziPdd stato = null;
                try {
                    stato = this.configurazionePdD.getStatoServiziPdD();
                }
                catch (DriverConfigurazioneNotFound e) {
                    this.log.debug((Object)("getFiltriDisabilitazionePAService (not found): " + e.getMessage()));
                }
                catch (Exception e) {
                    this.log.error((Object)"getFiltriDisabilitazionePAService", (Throwable)e);
                }
                getFiltriDisabilitazionePAService = stato == null || stato.getPortaApplicativa() == null || stato.getPortaApplicativa().sizeFiltroDisabilitazioneList() <= 0 ? new ArrayList<TipoFiltroAbilitazioneServizi>() : stato.getPortaApplicativa().getFiltroDisabilitazioneList();
            }
            catch (Exception e) {
                this.log.error((Object)("Errore durante la raccolta dei filtri di disabilitazione PA: " + e.getMessage()));
                getFiltriDisabilitazionePAService = new ArrayList<TipoFiltroAbilitazioneServizi>();
            }
        }
        return getFiltriDisabilitazionePAService;
    }

    protected Boolean isIMServiceActive() {
        if (this.configurazioneDinamica || isIMServiceActive == null) {
            try {
                StatoServiziPdd stato = null;
                try {
                    stato = this.configurazionePdD.getStatoServiziPdD();
                }
                catch (DriverConfigurazioneNotFound e) {
                    this.log.debug((Object)("isIMServiceActive (not found): " + e.getMessage()));
                }
                catch (Exception e) {
                    this.log.error((Object)"isIMServiceActive", (Throwable)e);
                }
                isIMServiceActive = stato == null || stato.getIntegrationManager() == null || stato.getIntegrationManager().getStato() == null ? Boolean.valueOf(true) : Boolean.valueOf(!CostantiConfigurazione.DISABILITATO.equals(stato.getIntegrationManager().getStato()));
            }
            catch (Exception e) {
                this.log.error((Object)("Errore durante la lettura dell'indicazione se il servizio porta applicativa e' attivo: " + e.getMessage()));
                isIMServiceActive = false;
            }
        }
        return isIMServiceActive;
    }

    protected StatoServiziPdd getStatoServiziPdD() throws DriverConfigurazioneException {
        try {
            return this.configurazionePdD.getStatoServiziPdD();
        }
        catch (DriverConfigurazioneNotFound dNot) {
            return null;
        }
    }

    protected void updateStatoServiziPdD(StatoServiziPdd servizi) throws DriverConfigurazioneException {
        this.configurazionePdD.updateStatoServiziPdD(servizi);
    }

    protected SystemProperties getSystemPropertiesPdD() throws DriverConfigurazioneException {
        try {
            return this.configurazionePdD.getSystemPropertiesPdD();
        }
        catch (DriverConfigurazioneNotFound dNot) {
            return null;
        }
    }

    protected void updateSystemPropertiesPdD(SystemProperties systemProperties) throws DriverConfigurazioneException {
        this.configurazionePdD.updateSystemPropertiesPdD(systemProperties);
    }

    protected List<Object> getExtendedInfoConfigurazione(Connection connectionPdD) throws DriverConfigurazioneException {
        if (this.configurazioneDinamica || getExtendedInfoConfigurazione == null) {
            try {
                Configurazione configurazione = null;
                try {
                    configurazione = this.configurazionePdD.getConfigurazioneGenerale(connectionPdD);
                }
                catch (DriverConfigurazioneNotFound e) {
                    this.log.debug((Object)("getExtendedInfoConfigurazione (not found): " + e.getMessage()));
                }
                getExtendedInfoConfigurazione = configurazione.getExtendedInfoList();
            }
            catch (Exception e) {
                this.log.error((Object)("Errore durante la lettura delle informazioni extra della configurazione: " + e.getMessage()), (Throwable)e);
                throw new DriverConfigurazioneException("Errore durante la lettura delle informazioni extra della configurazione: " + e.getMessage(), (Throwable)e);
            }
        }
        return getExtendedInfoConfigurazione;
    }

    protected Object getSingleExtendedInfoConfigurazione(String id, Connection connectionPdD) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (this.configurazioneDinamica || !getSingleExtendedInfoConfigurazione.containsKey(id)) {
            try {
                Object result = null;
                try {
                    result = this.configurazionePdD.getSingleExtendedInfoConfigurazione(id, connectionPdD);
                }
                catch (DriverConfigurazioneNotFound e) {
                    this.log.debug((Object)("getSingleExtendedInfoConfigurazione (not found): " + e.getMessage()));
                }
                if (result != null) {
                    getSingleExtendedInfoConfigurazione.put(id, result);
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Errore durante la lettura delle informazioni extra con id '" + id + "' della configurazione: " + e.getMessage()), (Throwable)e);
                throw new DriverConfigurazioneException("Errore durante la lettura delle informazioni extra con id '" + id + "' della configurazione: " + e.getMessage(), (Throwable)e);
            }
        }
        return getSingleExtendedInfoConfigurazione.get(id);
    }

    protected List<Object> getExtendedInfoConfigurazioneFromCache(Connection connectionPdD) throws DriverConfigurazioneException {
        try {
            Configurazione configurazione = null;
            try {
                configurazione = this.configurazionePdD.getConfigurazioneWithOnlyExtendedInfo(connectionPdD);
            }
            catch (DriverConfigurazioneNotFound e) {
                this.log.debug((Object)("getConfigurazioneWithOnlyExtendedInfo (not found): " + e.getMessage()));
            }
            return configurazione.getExtendedInfoList();
        }
        catch (Exception e) {
            this.log.error((Object)("Errore durante la lettura delle informazioni extra della configurazione (via cache): " + e.getMessage()), (Throwable)e);
            throw new DriverConfigurazioneException("Errore durante la lettura delle informazioni extra della configurazione  (via cache): " + e.getMessage(), (Throwable)e);
        }
    }

    protected Object getSingleExtendedInfoConfigurazioneFromCache(String id, Connection connectionPdD) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        try {
            Object result = null;
            try {
                result = this.configurazionePdD.getSingleExtendedInfoConfigurazione(id, connectionPdD);
            }
            catch (DriverConfigurazioneNotFound e) {
                this.log.debug((Object)("getSingleExtendedInfoConfigurazioneFromCache (not found): " + e.getMessage()));
            }
            return result;
        }
        catch (Exception e) {
            this.log.error((Object)("Errore durante la lettura delle informazioni extra con id '" + id + "' della configurazione (via cache): " + e.getMessage()), (Throwable)e);
            throw new DriverConfigurazioneException("Errore durante la lettura delle informazioni extra con id '" + id + "' della configurazione  (via cache): " + e.getMessage(), (Throwable)e);
        }
    }

    static {
        initialize = false;
        accessoRegistroServizi = null;
        accessoRegistroServiziLetto = false;
        accessoConfigurazione = null;
        accessoConfigurazioneLetto = false;
        accessoDatiAutorizzazione = null;
        accessoDatiAutorizzazioneLetto = false;
        tipoValidazione = null;
        isLivelloValidazioneNormale = null;
        isLivelloValidazioneRigido = null;
        validazioneProfiloCollaborazione = null;
        validazioneManifestAttachments = null;
        newConnectionForResponse = null;
        utilizzoIndirizzoRisposta = null;
        gestioneManifestAttachments = null;
        timeoutRiscontro = null;
        livello_msgDiagnostici = null;
        livello_msgDiagnosticiJMX = null;
        livelloLog4J_msgDiagnostici = null;
        livelloLog4J_msgDiagnosticiJMX = null;
        severita_msgDiagnostici = null;
        severita_msgDiagnosticiJMX = null;
        severitaLog4J_msgDiagnostici = null;
        severitaLog4J_msgDiagnosticiJMX = null;
        openSPCoopAppender_MsgDiagnostici = null;
        openSPCoopAppender_MsgDiagnosticiLetto = false;
        dumpMessaggi = null;
        dumpMessaggiJMX = null;
        dumpBinarioPD = null;
        dumpBinarioPDJMX = null;
        dumpBinarioPA = null;
        dumpBinarioPAJMX = null;
        tracciamentoBusteJMX = null;
        tracciamentoBuste = null;
        openSPCoopAppender_Tracciamento = null;
        openSPCoopAppender_TracciamentoLetto = false;
        gestioneErroreConnettoreComponenteCooperazione = null;
        gestioneErroreConnettoreComponenteIntegrazione = null;
        integrationManagerAuthentication = null;
        validazioneContenutiApplicativi = null;
        isPDServiceActive = null;
        getFiltriAbilitazionePDService = null;
        getFiltriDisabilitazionePDService = null;
        isPAServiceActive = null;
        getFiltriAbilitazionePAService = null;
        getFiltriDisabilitazionePAService = null;
        isIMServiceActive = null;
        getExtendedInfoConfigurazione = null;
        getSingleExtendedInfoConfigurazione = new Hashtable();
    }
}

