/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.config;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.pdd.config.ClassNameInstanceProperties;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;

public class ClassNameProperties {
    private Logger log = OpenSPCoop2Startup.initialize ? OpenSPCoop2Logger.getLoggerOpenSPCoopCore() : Logger.getLogger(ClassNameProperties.class);
    private ClassNameInstanceProperties reader;
    private static ClassNameProperties classNameProperties = null;

    public ClassNameProperties() throws Exception {
        Properties propertiesReader = new Properties();
        InputStream properties = null;
        try {
            properties = ClassNameProperties.class.getResourceAsStream("/className.properties");
            if (properties == null) {
                throw new Exception("File '/className.properties' not found");
            }
            propertiesReader.load(properties);
        }
        catch (Exception e) {
            this.log.error((Object)("Riscontrato errore durante la lettura del file 'className.properties': \n\n" + e.getMessage()));
            throw new Exception("ClassName initialize error: " + e.getMessage());
        }
        finally {
            try {
                if (properties != null) {
                    properties.close();
                }
            }
            catch (Exception er) {}
        }
        this.reader = new ClassNameInstanceProperties(propertiesReader, this.log);
    }

    public void refreshLocalProperties(Properties localProp, String confDir) {
        this.reader.searchLocalFileImplementation(confDir);
        if (localProp != null) {
            this.reader.setLocalObjectImplementation(localProp);
        }
    }

    public static boolean initialize() {
        try {
            classNameProperties = new ClassNameProperties();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static ClassNameProperties getInstance() {
        if (classNameProperties == null) {
            ClassNameProperties.initialize();
        }
        return classNameProperties;
    }

    public String getConnettore(String nome) {
        return this.getValue("org.openspcoop2.connettore.", nome);
    }

    public String[] getConnettore() throws Exception {
        return this.getTipiGestiti("org.openspcoop2.connettore.", CostantiConfigurazione.DISABILITATO.toString());
    }

    public String getAutenticazione(String nome) {
        return this.getValue("org.openspcoop2.autenticazione.", nome);
    }

    public String[] getAutenticazione() throws Exception {
        return this.getTipiGestiti("org.openspcoop2.autenticazione.", CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_NONE.toString());
    }

    public String getAutorizzazione(String nome) {
        return this.getValue("org.openspcoop2.autorizzazione.", nome);
    }

    public String[] getAutorizzazione() throws Exception {
        return this.getTipiGestiti("org.openspcoop2.autorizzazione.", "none");
    }

    public String getAutorizzazioneBuste(String nome) {
        return this.getValue("org.openspcoop2.autorizzazioneBuste.", nome);
    }

    public String[] getAutorizzazioneBuste() throws Exception {
        return this.getTipiGestiti("org.openspcoop2.autorizzazioneBuste.", "none");
    }

    public String getAutorizzazioneContenuto(String nome) {
        return this.getValue("org.openspcoop2.autorizzazioneContenuto.", nome);
    }

    public String[] getAutorizzazioneContenuto() throws Exception {
        return this.getTipiGestiti("org.openspcoop2.autorizzazioneContenuto.", "none");
    }

    public String getAutorizzazioneContenutoBuste(String nome) {
        return this.getValue("org.openspcoop2.autorizzazioneContenutoBuste.", nome);
    }

    public String[] getAutorizzazioneContenutoBuste() throws Exception {
        return this.getTipiGestiti("org.openspcoop2.autorizzazioneContenutoBuste.", "none");
    }

    public String getIntegrazionePortaDelegata(String nome) {
        return this.getValue("org.openspcoop2.integrazione.pd.", nome);
    }

    public String[] getIntegrazionePortaDelegata() throws Exception {
        return this.getTipiGestiti("org.openspcoop2.integrazione.pd.", new String[0]);
    }

    public String getIntegrazionePortaApplicativa(String nome) {
        return this.getValue("org.openspcoop2.integrazione.pa.", nome);
    }

    public String[] getIntegrazionePortaApplicativa() throws Exception {
        return this.getTipiGestiti("org.openspcoop2.integrazione.pa.", new String[0]);
    }

    public String getJDBCAdapter(String nome) {
        return this.getValue("org.openspcoop2.jdbcAdapter.", nome);
    }

    public String[] getJDBCAdapter() throws Exception {
        return this.getTipiGestiti("org.openspcoop2.jdbcAdapter.", new String[0]);
    }

    public String getThreshold(String nome) {
        return this.getValue("org.openspcoop2.threshold.", nome);
    }

    public String[] getThreshold() throws Exception {
        return this.getTipiGestiti("org.openspcoop2.threshold.", new String[0]);
    }

    public String getMsgDiagnosticoOpenSPCoopAppender(String nome) {
        return this.getValue("org.openspcoop2.msgdiagnosticoAppender.", nome);
    }

    public String[] getMsgDiagnosticoOpenSPCoopAppender() throws Exception {
        return this.getTipiGestiti("org.openspcoop2.msgdiagnosticoAppender.", new String[0]);
    }

    public String getTracciamentoOpenSPCoopAppender(String nome) {
        return this.getValue("org.openspcoop2.tracciamentoAppender.", nome);
    }

    public String[] getTracciamentoOpenSPCoopAppender() throws Exception {
        return this.getTipiGestiti("org.openspcoop2.tracciamentoAppender.", new String[0]);
    }

    public String getNodeReceiver(String nome) {
        return this.getValue("org.openspcoop2.nodeReceiver.", nome);
    }

    public String[] getNodeReceiver() throws Exception {
        return this.getTipiGestiti("org.openspcoop2.nodeReceiver.", new String[0]);
    }

    public String getNodeSender(String nome) {
        return this.getValue("org.openspcoop2.nodeSender.", nome);
    }

    public String[] getNodeSender() throws Exception {
        return this.getTipiGestiti("org.openspcoop2.nodeSender.", new String[0]);
    }

    public String getRepositoryBuste(String nome) {
        return this.getValue("org.openspcoop2.repositoryBuste.", nome);
    }

    public String[] getRepositoryBuste() throws Exception {
        return this.getTipiGestiti("org.openspcoop2.repositoryBuste.", new String[0]);
    }

    public String getSQLQueryObject(String nome) {
        return this.getValue("org.openspcoop2.sqlQueryObject.", nome);
    }

    public String[] getSQLQueryObject() throws Exception {
        return this.getTipiGestiti("org.openspcoop2.sqlQueryObject.", new String[0]);
    }

    public String getDateManager(String nome) {
        return this.getValue("org.openspcoop2.date.", nome);
    }

    public String[] getDateManager() throws Exception {
        return this.getTipiGestiti("org.openspcoop2.date.", new String[0]);
    }

    public String getUniqueIdentifier(String nome) {
        return this.getValue("org.openspcoop2.id.", nome);
    }

    public String[] getUniqueIdentifier() throws Exception {
        return this.getTipiGestiti("org.openspcoop2.id.", new String[0]);
    }

    public String getFiltroDuplicati(String nome) {
        return this.getValue("org.openspcoop2.protocol.filtroDuplicati.", nome);
    }

    public String[] getFiltroDuplicati() throws Exception {
        return this.getTipiGestiti("org.openspcoop2.protocol.filtroDuplicati.", new String[0]);
    }

    public String getInitHandler(String nome) {
        return this.getValue("org.openspcoop2.pdd.handler.init.", nome);
    }

    public String[] getInitHandler() throws Exception {
        return this.getTipiGestiti("org.openspcoop2.pdd.handler.init.", new String[0]);
    }

    public String getExitHandler(String nome) {
        return this.getValue("org.openspcoop2.pdd.handler.exit.", nome);
    }

    public String[] getExitHandler() throws Exception {
        return this.getTipiGestiti("org.openspcoop2.pdd.handler.exit.", new String[0]);
    }

    public String getPreInRequestHandler(String nome) {
        return this.getValue("org.openspcoop2.pdd.handler.pre-in-request.", nome);
    }

    public String[] getPreInRequestHandler() throws Exception {
        return this.getTipiGestiti("org.openspcoop2.pdd.handler.pre-in-request.", new String[0]);
    }

    public String getInRequestHandler(String nome) {
        return this.getValue("org.openspcoop2.pdd.handler.in-request.", nome);
    }

    public String[] getInRequestHandler() throws Exception {
        return this.getTipiGestiti("org.openspcoop2.pdd.handler.in-request.", new String[0]);
    }

    public String getInRequestProtocolHandler(String nome) {
        return this.getValue("org.openspcoop2.pdd.handler.in-protocol-request.", nome);
    }

    public String[] getInRequestProtocolHandler() throws Exception {
        return this.getTipiGestiti("org.openspcoop2.pdd.handler.in-protocol-request.", new String[0]);
    }

    public String getOutRequestHandler(String nome) {
        return this.getValue("org.openspcoop2.pdd.handler.out-request.", nome);
    }

    public String[] getOutRequestHandler() throws Exception {
        return this.getTipiGestiti("org.openspcoop2.pdd.handler.out-request.", new String[0]);
    }

    public String getPostOutRequestHandler(String nome) {
        return this.getValue("org.openspcoop2.pdd.handler.post-out-request.", nome);
    }

    public String[] getPostOutRequestHandler() throws Exception {
        return this.getTipiGestiti("org.openspcoop2.pdd.handler.post-out-request.", new String[0]);
    }

    public String getPreInResponseHandler(String nome) {
        return this.getValue("org.openspcoop2.pdd.handler.pre-in-response.", nome);
    }

    public String[] getPreInResponseHandler() throws Exception {
        return this.getTipiGestiti("org.openspcoop2.pdd.handler.pre-in-response.", new String[0]);
    }

    public String getInResponseHandler(String nome) {
        return this.getValue("org.openspcoop2.pdd.handler.in-response.", nome);
    }

    public String[] getInResponseHandler() throws Exception {
        return this.getTipiGestiti("org.openspcoop2.pdd.handler.in-response.", new String[0]);
    }

    public String getOutResponseHandler(String nome) {
        return this.getValue("org.openspcoop2.pdd.handler.out-response.", nome);
    }

    public String[] getOutResponseHandler() throws Exception {
        return this.getTipiGestiti("org.openspcoop2.pdd.handler.out-response.", new String[0]);
    }

    public String getPostOutResponseHandler(String nome) {
        return this.getValue("org.openspcoop2.pdd.handler.post-out-response.", nome);
    }

    public String[] getPostOutResponseHandler() throws Exception {
        return this.getTipiGestiti("org.openspcoop2.pdd.handler.post-out-response.", new String[0]);
    }

    public String getIntegrationManagerRequestHandler(String nome) {
        return this.getValue("org.openspcoop2.pdd.integrationManager.handler.request.", nome);
    }

    public String[] getIntegrationManagerRequestHandler() throws Exception {
        return this.getTipiGestiti("org.openspcoop2.pdd.integrationManager.handler.request.", new String[0]);
    }

    public String getIntegrationManagerResponseHandler(String nome) {
        return this.getValue("org.openspcoop2.pdd.integrationManager.handler.response.", nome);
    }

    public String[] getIntegrationManagerResponseHandler() throws Exception {
        return this.getTipiGestiti("org.openspcoop2.pdd.integrationManager.handler.response.", new String[0]);
    }

    public String getOpenSPCoop2MessageFactory(String nome) {
        if (nome == null) {
            return null;
        }
        return this.getValue("org.openspcoop2.pdd.messagefactory.", nome);
    }

    public String[] getOpenSPCoop2MessageFactory() throws Exception {
        return this.getTipiGestiti("org.openspcoop2.pdd.messagefactory.", new String[0]);
    }

    public String getMessageSecurityContext(String nome) {
        if (nome == null) {
            return null;
        }
        return this.getValue("org.openspcoop2.pdd.messageSecurity.context.", nome);
    }

    public String[] getMessageSecurityContext() throws Exception {
        return this.getTipiGestiti("org.openspcoop2.pdd.messageSecurity.context.", new String[0]);
    }

    public String getMessageSecurityDigestReader(String nome) {
        if (nome == null) {
            return null;
        }
        return this.getValue("org.openspcoop2.pdd.messageSecurity.digestReader.", nome);
    }

    public String[] getMessageSecurityDigestReader() throws Exception {
        return this.getTipiGestiti("org.openspcoop2.pdd.messageSecurity.digestReader.", new String[0]);
    }

    public String getGestoreCredenziali(String nome) {
        return this.getValue("org.openspcoop2.pdd.gestoreCredenziali.", nome);
    }

    public String[] getGestoreCredenziali() throws Exception {
        return this.getTipiGestiti("org.openspcoop2.pdd.gestoreCredenziali.", new String[0]);
    }

    public String getGestoreCredenzialiIM(String nome) {
        return this.getValue("org.openspcoop2.integrationManager.gestoreCredenziali.", nome);
    }

    public String[] getGestoreCredenzialiIM() throws Exception {
        return this.getTipiGestiti("org.openspcoop2.integrationManager.gestoreCredenziali.", new String[0]);
    }

    public String getProtocol(String nome) {
        return this.getValue("org.openspcoop2.protocol.", nome);
    }

    public String[] getProtocol() throws Exception {
        return this.getTipiGestiti("org.openspcoop2.protocol.", new String[0]);
    }

    public String getNotifierCallback(String nome) {
        return this.getValue("org.openspcoop2.notifierCallback.", nome);
    }

    public String[] getNotifierCallback() throws Exception {
        return this.getTipiGestiti("org.openspcoop2.notifierCallback.", new String[0]);
    }

    public String getBehaviour(String nome) {
        return this.getValue("org.openspcoop2.behaviour.", nome);
    }

    public String[] getBehaviour() throws Exception {
        return this.getTipiGestiti("org.openspcoop2.behaviour.", new String[0]);
    }

    public String getExtended(String tipologia, String nome) {
        return this.getValue("org.openspcoop2.pdd.extended.", tipologia + "." + nome);
    }

    public String[] getExtended(String tipologia) throws Exception {
        return this.getTipiGestiti("org.openspcoop2.pdd.extended." + tipologia + ".", new String[0]);
    }

    private String getValue(String prop, String nome) {
        try {
            String value = this.reader.getValue(prop + nome);
            if (value != null) {
                value = value.trim();
            } else {
                value = this.reader.getValue(prop + nome.toLowerCase());
                if (value != null) {
                    value = value.trim();
                } else {
                    value = this.reader.getValue(prop + nome.toUpperCase());
                    if (value != null) {
                        value = value.trim();
                    }
                }
            }
            return value;
        }
        catch (Exception e) {
            this.log.error((Object)("Errore durante la lettura della proprieta [" + prop + nome + "]: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    private String[] getTipiGestiti(String prefix, String ... defaults) throws Exception {
        Properties prop = this.reader.readProperties(prefix);
        Enumeration<Object> en = prop.keys();
        Vector<String> tipi = new Vector<String>();
        if (defaults != null && defaults.length > 0) {
            for (int i = 0; i < defaults.length; ++i) {
                tipi.add(defaults[i]);
            }
        }
        while (en.hasMoreElements()) {
            Object o = en.nextElement();
            if (o == null) continue;
            String v = (String)o;
            tipi.add(v.trim());
        }
        if (tipi.size() > 0) {
            return tipi.toArray(new String[1]);
        }
        return null;
    }
}

