/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.modipa.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import org.openspcoop2.protocol.modipa.utils.MockServletInputStream;

public class MockHttpServletRequest
implements HttpServletRequest {
    private AsyncContext asyncContext = null;
    private Map<String, Object> attributes = null;
    private Map<String, List<String>> headers = null;
    private String characterEncoding = null;
    private DispatcherType dispatcherType = null;
    private HttpServletRequest req = null;
    private MockServletInputStream is = null;

    public MockHttpServletRequest() {
    }

    public MockHttpServletRequest(HttpServletRequest req) {
        this.req = req;
    }

    public AsyncContext getAsyncContext() {
        if (this.asyncContext != null) {
            return this.asyncContext;
        }
        return this.req.getAsyncContext();
    }

    public void setAsyncContext(AsyncContext asyncContext) {
        this.asyncContext = asyncContext;
    }

    public Object getAttribute(String arg0) {
        if (this.attributes != null) {
            return this.attributes.get(arg0);
        }
        return this.req.getAttribute(arg0);
    }

    public Enumeration<String> getAttributeNames() {
        if (this.attributes != null) {
            return Collections.enumeration(this.attributes.keySet());
        }
        return this.req.getAttributeNames();
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public String getCharacterEncoding() {
        if (this.characterEncoding != null) {
            return this.characterEncoding;
        }
        return this.req.getCharacterEncoding();
    }

    public void setWrappedCharacterEncoding(String enc) {
        this.characterEncoding = enc;
    }

    public int getContentLength() {
        return this.getIntHeader("Content-Length");
    }

    public long getContentLengthLong() {
        return this.getIntHeader("Content-Length");
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public DispatcherType getDispatcherType() {
        if (this.dispatcherType != null) {
            return this.dispatcherType;
        }
        return this.req.getDispatcherType();
    }

    public void setDispatcherType(DispatcherType dispatcherType) {
        this.dispatcherType = dispatcherType;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.is != null) {
            return this.is;
        }
        return this.req.getInputStream();
    }

    public String getLocalAddr() {
        return this.req.getLocalAddr();
    }

    public String getLocalName() {
        return this.req.getLocalName();
    }

    public int getLocalPort() {
        return this.req.getLocalPort();
    }

    public Locale getLocale() {
        return this.req.getLocale();
    }

    public Enumeration<Locale> getLocales() {
        return this.req.getLocales();
    }

    public String getParameter(String arg0) {
        return this.req.getParameter(arg0);
    }

    public Map<String, String[]> getParameterMap() {
        return this.req.getParameterMap();
    }

    public Enumeration<String> getParameterNames() {
        return this.req.getParameterNames();
    }

    public String[] getParameterValues(String arg0) {
        return this.req.getParameterValues(arg0);
    }

    public String getProtocol() {
        return this.req.getProtocol();
    }

    public BufferedReader getReader() throws IOException {
        if (this.is != null) {
            return new BufferedReader(new InputStreamReader((InputStream)((Object)this.is), StandardCharsets.UTF_8));
        }
        return this.req.getReader();
    }

    @Deprecated(since="3.3")
    public String getRealPath(String arg0) {
        return this.req.getRealPath(arg0);
    }

    public String getRemoteAddr() {
        return this.req.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.req.getRemoteHost();
    }

    public int getRemotePort() {
        return this.req.getRemotePort();
    }

    public RequestDispatcher getRequestDispatcher(String arg0) {
        return this.req.getRequestDispatcher(arg0);
    }

    public String getScheme() {
        return this.req.getScheme();
    }

    public String getServerName() {
        return this.req.getServerName();
    }

    public int getServerPort() {
        return this.req.getServerPort();
    }

    public ServletContext getServletContext() {
        return this.req.getServletContext();
    }

    public boolean isAsyncStarted() {
        return this.req.isAsyncStarted();
    }

    public boolean isAsyncSupported() {
        return this.req.isAsyncSupported();
    }

    public boolean isSecure() {
        return this.req.isSecure();
    }

    public void removeAttribute(String arg0) {
        this.req.removeAttribute(arg0);
    }

    public void setAttribute(String arg0, Object arg1) {
        this.req.setAttribute(arg0, arg1);
    }

    public void setCharacterEncoding(String arg0) throws UnsupportedEncodingException {
        this.req.setCharacterEncoding(arg0);
    }

    public AsyncContext startAsync() throws IllegalStateException {
        return this.req.startAsync();
    }

    public AsyncContext startAsync(ServletRequest arg0, ServletResponse arg1) throws IllegalStateException {
        return this.req.startAsync(arg0, arg1);
    }

    public boolean authenticate(HttpServletResponse arg0) throws IOException, ServletException {
        return this.req.authenticate(arg0);
    }

    public String changeSessionId() {
        return this.req.changeSessionId();
    }

    public String getAuthType() {
        return this.req.getAuthType();
    }

    public String getContextPath() {
        return this.req.getContextPath();
    }

    public Cookie[] getCookies() {
        return this.req.getCookies();
    }

    public long getDateHeader(String arg0) {
        return Long.valueOf(this.getHeader(arg0));
    }

    private String preProcessHeaderName(String name) {
        if (name != null) {
            return name.toLowerCase();
        }
        return name;
    }

    public String getHeader(String arg0) {
        List<String> v;
        arg0 = this.preProcessHeaderName(arg0);
        if (this.headers != null && this.headers.containsKey(arg0) && (v = this.headers.get(arg0)) != null && !v.isEmpty()) {
            return String.join((CharSequence)",", (Iterable<? extends CharSequence>)this.headers.get(arg0));
        }
        return this.req.getHeader(arg0);
    }

    public Enumeration<String> getHeaderNames() {
        HashSet<String> names = new HashSet<String>();
        if (this.headers != null) {
            names.addAll(this.headers.keySet());
        }
        if (this.req != null) {
            this.req.getHeaderNames().asIterator().forEachRemaining(name -> names.add(this.preProcessHeaderName((String)name)));
        }
        return Collections.enumeration(names);
    }

    public Enumeration<String> getHeaders(String arg0) {
        arg0 = this.preProcessHeaderName(arg0);
        HashSet values = new HashSet();
        if (this.headers != null) {
            values.addAll(Objects.requireNonNullElse(this.headers.getOrDefault(arg0, List.of()), List.of()));
        }
        if (this.req != null && values.isEmpty()) {
            this.req.getHeaders(arg0).asIterator().forEachRemaining(values::add);
        }
        return Collections.enumeration(values.stream().filter(o -> o != null).collect(Collectors.toList()));
    }

    public int getIntHeader(String arg0) {
        return Integer.valueOf(this.getHeader(arg0));
    }

    public String getMethod() {
        return this.req.getMethod();
    }

    public Part getPart(String arg0) throws IOException, ServletException {
        return this.req.getPart(arg0);
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return this.req.getParts();
    }

    public String getPathInfo() {
        return this.req.getPathInfo();
    }

    public String getPathTranslated() {
        return this.req.getPathTranslated();
    }

    public String getQueryString() {
        return this.req.getQueryString();
    }

    public String getRemoteUser() {
        return this.req.getRemoteUser();
    }

    public String getRequestURI() {
        return this.req.getRequestURI();
    }

    public StringBuffer getRequestURL() {
        return this.req.getRequestURL();
    }

    public String getRequestedSessionId() {
        return null;
    }

    public String getServletPath() {
        return this.req.getServletPath();
    }

    public HttpSession getSession() {
        return this.req.getSession();
    }

    public HttpSession getSession(boolean arg0) {
        return this.req.getSession(arg0);
    }

    public Principal getUserPrincipal() {
        return this.req.getUserPrincipal();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.req.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.req.isRequestedSessionIdFromURL();
    }

    @Deprecated(since="3.3")
    public boolean isRequestedSessionIdFromUrl() {
        return this.req.isRequestedSessionIdFromUrl();
    }

    public boolean isRequestedSessionIdValid() {
        return this.req.isRequestedSessionIdValid();
    }

    public boolean isUserInRole(String arg0) {
        return this.req.isUserInRole(arg0);
    }

    public void login(String arg0, String arg1) throws ServletException {
        this.req.login(arg0, arg1);
    }

    public void logout() throws ServletException {
        this.req.logout();
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> arg0) throws IOException, ServletException {
        return (T)this.req.upgrade(arg0);
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.headers = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            this.headers.put(this.preProcessHeaderName(entry.getKey()), entry.getValue());
        }
    }

    public void setHeader(String name, List<String> value) {
        name = this.preProcessHeaderName(name);
        if (this.headers == null) {
            this.headers = new HashMap<String, List<String>>();
        }
        this.headers.put(name, value);
    }

    public void setInputStream(MockServletInputStream is) {
        this.is = is;
    }
}

