/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.modipa.properties;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.config.ConfigurazioneMultitenant;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mvc.properties.provider.InputValidationUtils;
import org.openspcoop2.core.registry.ProtocolProperty;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.constants.PddTipologia;
import org.openspcoop2.protocol.modipa.config.ModIProperties;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.ConsoleItemType;
import org.openspcoop2.protocol.sdk.constants.ConsoleItemValueType;
import org.openspcoop2.protocol.sdk.constants.ConsoleOperationType;
import org.openspcoop2.protocol.sdk.properties.AbstractConsoleItem;
import org.openspcoop2.protocol.sdk.properties.BaseConsoleItem;
import org.openspcoop2.protocol.sdk.properties.ConsoleConfiguration;
import org.openspcoop2.protocol.sdk.properties.IConsoleHelper;
import org.openspcoop2.protocol.sdk.properties.ProtocolProperties;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesFactory;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesUtils;
import org.openspcoop2.protocol.sdk.properties.StringConsoleItem;
import org.openspcoop2.protocol.sdk.properties.StringProperty;
import org.openspcoop2.protocol.sdk.registry.IConfigIntegrationReader;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.protocol.sdk.registry.ProtocolFiltroRicercaSoggetti;
import org.openspcoop2.protocol.sdk.registry.RegistryNotFound;

public class ModIDynamicConfigurationSoggettiUtilities {
    private ModIDynamicConfigurationSoggettiUtilities() {
    }

    static ConsoleConfiguration getDynamicConfigSoggetto(ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDSoggetto id) throws ProtocolException {
        boolean esterno = ModIDynamicConfigurationSoggettiUtilities.isEsterno(consoleOperationType, consoleHelper, registryReader, id);
        ConsoleConfiguration configuration = new ConsoleConfiguration();
        BaseConsoleItem titolo = ProtocolPropertiesFactory.newTitleItem((String)"modipaSoggettiTitleId", (String)"ModI");
        configuration.addConsoleItem(titolo);
        BaseConsoleItem subTitlePdnd = ProtocolPropertiesFactory.newSubTitleItem((String)"modipaSoggettiSubtitleId", (String)"Informazioni PDND");
        configuration.addConsoleItem(subTitlePdnd);
        StringConsoleItem tokenClientIdItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.TEXT_AREA, (String)"modipaSoggettoIDEnte", (String)"ID Ente");
        tokenClientIdItem.setRows(Integer.valueOf(1));
        tokenClientIdItem.setRequired(false);
        configuration.addConsoleItem((BaseConsoleItem)tokenClientIdItem);
        if (!esterno && ModIProperties.getInstance().isTracingPDNDEnabled()) {
            ConfigurazioneMultitenant multitenant = null;
            try {
                if (configIntegrationReader != null) {
                    multitenant = configIntegrationReader.getConfigurazioneMultitenant();
                }
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            boolean multitenantEnabled = multitenant != null && StatoFunzionalita.ABILITATO.equals((Object)multitenant.getStato());
            ModIDynamicConfigurationSoggettiUtilities.getDynamicConfigSoggettoTracciamentoPdnd(multitenantEnabled, configuration, registryReader, id);
        }
        return configuration;
    }

    private static boolean isEsterno(ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, IRegistryReader registryReader, IDSoggetto id) throws ProtocolException {
        boolean esterno = false;
        try {
            String dominio = consoleHelper.getParameter("dominio");
            if ((dominio == null || "".equals(dominio)) && ConsoleOperationType.CHANGE.equals((Object)consoleOperationType)) {
                List<String> pddOperative;
                Soggetto soggetto = registryReader.getSoggetto(id);
                dominio = soggetto.getPortaDominio() == null || "".equals(soggetto.getPortaDominio()) ? PddTipologia.ESTERNO.toString() : ((pddOperative = ModIDynamicConfigurationSoggettiUtilities.getPddOperative(registryReader)) == null || pddOperative.isEmpty() || !pddOperative.contains(soggetto.getPortaDominio()) ? PddTipologia.ESTERNO.toString() : PddTipologia.OPERATIVO.toString());
            }
            esterno = PddTipologia.ESTERNO.toString().equals(dominio);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
        return esterno;
    }

    private static void getDynamicConfigSoggettoTracciamentoPdnd(boolean multitenantEnabled, ConsoleConfiguration configuration, IRegistryReader registryReader, IDSoggetto id) throws ProtocolException {
        if (multitenantEnabled) {
            BaseConsoleItem subTitleTracciamentoPdnd = ProtocolPropertiesFactory.newSubTitleItem((String)"modipaSoggettiTracciamentoPdndSubtitleId", (String)"Tracciamento PDND");
            configuration.addConsoleItem(subTitleTracciamentoPdnd);
        }
        StringConsoleItem soggettoPdndTracingEnabledItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.SELECT, (String)"modipaSoggettoPdndTracingEnabled", (String)(multitenantEnabled ? "Stato" : "Tracciamento PDND"));
        soggettoPdndTracingEnabledItem.addLabelValue("Default", (Object)"-1");
        soggettoPdndTracingEnabledItem.addLabelValue("Abilitato", (Object)"1");
        soggettoPdndTracingEnabledItem.addLabelValue("Disabilitato", (Object)"0");
        soggettoPdndTracingEnabledItem.setDefaultValue((Object)"-1");
        if (multitenantEnabled) {
            soggettoPdndTracingEnabledItem.setReloadOnChange(true);
        }
        configuration.addConsoleItem((BaseConsoleItem)soggettoPdndTracingEnabledItem);
        if (multitenantEnabled) {
            StringConsoleItem soggettoPdndTracingAggregatoItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.SELECT, (String)"modipaSoggettoPdndTracingAggregato", (String)"Aggregato a");
            soggettoPdndTracingAggregatoItem.setNote("Le statistiche verranno aggregate al report del soggetto indicato");
            List<String> soggettiOperativiNonAggregati = ModIDynamicConfigurationSoggettiUtilities.getSoggettiOperativiNonAggregati(registryReader);
            soggettoPdndTracingAggregatoItem.addLabelValue("-", (Object)"-");
            if (!soggettiOperativiNonAggregati.isEmpty()) {
                for (String s : soggettiOperativiNonAggregati) {
                    if (id != null && id.getNome() != null && id.getNome().equals(s)) continue;
                    soggettoPdndTracingAggregatoItem.addLabelValue(s, (Object)s);
                }
            }
            soggettoPdndTracingAggregatoItem.setDefaultValue((Object)"-");
            configuration.addConsoleItem((BaseConsoleItem)soggettoPdndTracingAggregatoItem);
            StringConsoleItem soggettoPdndTracingAggregatoNoteItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.TEXT, (String)"modipaSoggettoPdndTracingAggregatoNote", (String)"Aggregatore per");
            configuration.addConsoleItem((BaseConsoleItem)soggettoPdndTracingAggregatoNoteItem);
        }
    }

    static void updateDynamicConfigSoggetto(ConsoleConfiguration consoleConfiguration, ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, ProtocolProperties properties, IConfigIntegrationReader configIntegrationReader, IRegistryReader registryReader, IDSoggetto id) throws ProtocolException {
        boolean multitenantEnabled;
        if (consoleOperationType != null || consoleHelper != null) {
            // empty if block
        }
        ConfigurazioneMultitenant multitenant = null;
        try {
            if (configIntegrationReader != null) {
                multitenant = configIntegrationReader.getConfigurazioneMultitenant();
            }
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
        boolean bl = multitenantEnabled = multitenant != null && StatoFunzionalita.ABILITATO.equals((Object)multitenant.getStato());
        if (multitenantEnabled) {
            StringProperty idTracciamentoItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSoggettoPdndTracingEnabled");
            boolean tracciamentoAbilitato = idTracciamentoItemValue != null && idTracciamentoItemValue.getValue() != null && "1".equals(idTracciamentoItemValue.getValue());
            boolean isSoggettoAggregatore = false;
            if (id != null && tracciamentoAbilitato) {
                isSoggettoAggregatore = ModIDynamicConfigurationSoggettiUtilities.isSoggettoAggregatore(id.getNome(), registryReader);
            }
            ModIDynamicConfigurationSoggettiUtilities.updateDynamicConfigSoggettoAggregato(tracciamentoAbilitato, isSoggettoAggregatore, consoleConfiguration, properties, id, registryReader);
        }
    }

    private static void updateDynamicConfigSoggettoAggregato(boolean tracciamentoAbilitato, boolean isSoggettoAggregatore, ConsoleConfiguration consoleConfiguration, ProtocolProperties properties, IDSoggetto idSoggetto, IRegistryReader registryReader) throws ProtocolException {
        ModIDynamicConfigurationSoggettiUtilities.updateDynamicConfigSoggettoAggregatoGestioneSelectList(consoleConfiguration, properties, tracciamentoAbilitato, isSoggettoAggregatore);
        ModIDynamicConfigurationSoggettiUtilities.updateDynamicConfigSoggettoAggregatoGestioneNote(consoleConfiguration, properties, tracciamentoAbilitato, isSoggettoAggregatore, idSoggetto, registryReader);
    }

    private static void updateDynamicConfigSoggettoAggregatoGestioneSelectList(ConsoleConfiguration consoleConfiguration, ProtocolProperties properties, boolean tracciamentoAbilitato, boolean isSoggettoAggregatore) throws ProtocolException {
        AbstractConsoleItem idAggregatoItemV = null;
        if (consoleConfiguration != null) {
            idAggregatoItemV = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSoggettoPdndTracingAggregato");
        }
        StringProperty idAggregatoItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSoggettoPdndTracingAggregato");
        if (!tracciamentoAbilitato || isSoggettoAggregatore) {
            if (idAggregatoItemV != null) {
                idAggregatoItemV.setType(ConsoleItemType.HIDDEN);
            }
            if (idAggregatoItemValue != null) {
                idAggregatoItemValue.setValue(null);
            }
        } else if (idAggregatoItemV != null) {
            idAggregatoItemV.setType(ConsoleItemType.SELECT);
        }
    }

    private static void updateDynamicConfigSoggettoAggregatoGestioneNote(ConsoleConfiguration consoleConfiguration, ProtocolProperties properties, boolean tracciamentoAbilitato, boolean isSoggettoAggregatore, IDSoggetto idSoggetto, IRegistryReader registryReader) throws ProtocolException {
        AbstractConsoleItem idAggregatoNoteItemV = null;
        if (consoleConfiguration != null) {
            idAggregatoNoteItemV = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSoggettoPdndTracingAggregatoNote");
        }
        StringProperty idAggregatoNoteItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSoggettoPdndTracingAggregatoNote");
        if (tracciamentoAbilitato && isSoggettoAggregatore) {
            if (idAggregatoNoteItemV != null) {
                idAggregatoNoteItemV.setType(ConsoleItemType.TEXT);
            }
            ModIDynamicConfigurationSoggettiUtilities.processAggregateNote(idAggregatoNoteItemV, idAggregatoNoteItemValue, idSoggetto, registryReader);
        } else {
            if (idAggregatoNoteItemV != null) {
                idAggregatoNoteItemV.setType(ConsoleItemType.HIDDEN);
            }
            if (idAggregatoNoteItemValue != null) {
                idAggregatoNoteItemValue.setValue(null);
            }
        }
    }

    private static void processAggregateNote(AbstractConsoleItem<?> idAggregatoNoteItemV, StringProperty idAggregatoNoteItemValue, IDSoggetto idSoggetto, IRegistryReader registryReader) throws ProtocolException {
        if (idAggregatoNoteItemValue != null) {
            List<String> l;
            boolean addNote = false;
            if (idSoggetto != null && idSoggetto.getNome() != null && !(l = ModIDynamicConfigurationSoggettiUtilities.getSoggettiOperativiRiferisconoSoggettoAggregato(idSoggetto.getNome(), registryReader)).isEmpty()) {
                idAggregatoNoteItemValue.setValue((Object)StringUtils.join(l, (String)", "));
                addNote = true;
            }
            if (!addNote) {
                idAggregatoNoteItemValue.setValue(null);
                if (idAggregatoNoteItemV != null) {
                    idAggregatoNoteItemV.setType(ConsoleItemType.HIDDEN);
                }
            }
        }
    }

    static void validateDynamicConfigSoggetto(ConsoleConfiguration consoleConfiguration, ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, ProtocolProperties properties, IConfigIntegrationReader configIntegrationReader, IDSoggetto id, IRegistryReader registryReader) throws ProtocolException {
        boolean multitenantEnabled;
        if (consoleConfiguration == null || consoleOperationType == null || consoleHelper == null || configIntegrationReader == null || id != null) {
            // empty if block
        }
        ModIDynamicConfigurationSoggettiUtilities.validateDynamicConfigSoggettoIdEnte(properties, id, registryReader);
        ConfigurazioneMultitenant multitenant = null;
        try {
            if (configIntegrationReader != null) {
                multitenant = configIntegrationReader.getConfigurazioneMultitenant();
            }
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
        boolean bl = multitenantEnabled = multitenant != null && StatoFunzionalita.ABILITATO.equals((Object)multitenant.getStato());
        if (multitenantEnabled) {
            boolean tracciamentoAbilitato;
            StringProperty idTracciamentoItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSoggettoPdndTracingEnabled");
            boolean bl2 = tracciamentoAbilitato = idTracciamentoItemValue != null && idTracciamentoItemValue.getValue() != null && "1".equals(idTracciamentoItemValue.getValue());
            if (!tracciamentoAbilitato) {
                ModIDynamicConfigurationSoggettiUtilities.validateDynamicConfigTracciamentoDisabilitato(registryReader, id);
            }
            boolean isSoggettoAggregatore = false;
            if (id != null) {
                isSoggettoAggregatore = ModIDynamicConfigurationSoggettiUtilities.isSoggettoAggregatore(id.getNome(), registryReader);
            }
            if (!tracciamentoAbilitato && isSoggettoAggregatore) {
                throw new ProtocolException("Impossibile modificare lo stato del tracciamento: il soggetto \u00e8 indicato come aggregatore di report da altri soggetti");
            }
            ModIDynamicConfigurationSoggettiUtilities.validateDynamicConfigSoggettoAggregato(properties, registryReader);
        }
    }

    private static void validateDynamicConfigSoggettoIdEnte(ProtocolProperties properties, IDSoggetto id, IRegistryReader registryReader) throws ProtocolException {
        StringProperty idEnteItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSoggettoIDEnte");
        if (idEnteItemValue != null && idEnteItemValue.getValue() != null && StringUtils.isNotEmpty((String)((String)idEnteItemValue.getValue()))) {
            try {
                InputValidationUtils.validateTextAreaInput((String)((String)idEnteItemValue.getValue()), (String)"ID Ente");
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            if (ModIProperties.getInstance().isPdndProducerIdCheckUnique()) {
                ModIDynamicConfigurationSoggettiUtilities.validatePdndInfoIdExists(registryReader, id, "modipaSoggettoIDEnte", "ID Ente", (String)idEnteItemValue.getValue());
            }
        }
    }

    private static void validateDynamicConfigTracciamentoDisabilitato(IRegistryReader registryReader, IDSoggetto id) throws ProtocolException {
        List<String> list = null;
        if (id != null && id.getNome() != null) {
            list = ModIDynamicConfigurationSoggettiUtilities.getSoggettiOperativiRiferisconoSoggettoAggregato(id.getNome(), registryReader);
        }
        if (list != null && !list.isEmpty()) {
            throw new ProtocolException("Non \u00e8 possibile disabilitare il tracciamento PDND; il soggetto '" + id.getNome() + "' risulta selezionato come aggregatore di report per altri soggetti: " + list);
        }
    }

    private static void validateDynamicConfigSoggettoAggregato(ProtocolProperties properties, IRegistryReader registryReader) throws ProtocolException {
        StringProperty idAggregatoItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSoggettoPdndTracingAggregato");
        if (idAggregatoItemValue != null && idAggregatoItemValue.getValue() != null && StringUtils.isNotEmpty((String)((String)idAggregatoItemValue.getValue())) && !"-".equals(idAggregatoItemValue.getValue())) {
            String soggettoSelezionato = (String)idAggregatoItemValue.getValue();
            List<String> soggettiOperativiNonAggregati = ModIDynamicConfigurationSoggettiUtilities.getSoggettiOperativiNonAggregati(registryReader);
            if (!soggettiOperativiNonAggregati.contains(soggettoSelezionato)) {
                throw new ProtocolException("Il soggetto selezionato '" + soggettoSelezionato + "' risulta gi\u00e0 aggregato in altri report");
            }
        }
    }

    private static void validatePdndInfoIdExists(IRegistryReader registryReader, IDSoggetto idSoggetto, String id, String label, String idValue) throws ProtocolException {
        ProtocolFiltroRicercaSoggetti filtro = new ProtocolFiltroRicercaSoggetti();
        filtro.setProtocolProperties(new ProtocolProperties());
        filtro.getProtocolProperties().addProperty(id, idValue);
        List list = null;
        try {
            list = registryReader.findIdSoggetti(filtro);
            if (list != null && !list.isEmpty()) {
                for (IDSoggetto check : list) {
                    if (check.equals((Object)idSoggetto)) continue;
                    String msg = "Il soggetto '" + check.getNome() + "' risulta gi\u00e0 registrata con il campo '" + label + "' valorizzato con l'identificativo fornito";
                    msg = msg + " '" + idValue + "'";
                    throw new ProtocolException(msg);
                }
            }
        }
        catch (RegistryNotFound registryNotFound) {
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public static List<String> getPddOperative(IRegistryReader registryReader) throws ProtocolException {
        List pddOperative = null;
        try {
            pddOperative = registryReader.findIdPorteDominio(Boolean.valueOf(true));
        }
        catch (RegistryNotFound registryNotFound) {
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
        return pddOperative;
    }

    public static List<String> getSoggettiOperativi(IRegistryReader registryReader) throws ProtocolException {
        List<String> listPddOperative = ModIDynamicConfigurationSoggettiUtilities.getPddOperative(registryReader);
        if (listPddOperative == null || listPddOperative.isEmpty()) {
            throw new ProtocolException("Non risultano configurate porte di dominio di tipo 'operativo'");
        }
        ArrayList<String> listSoggettiOperativi = new ArrayList<String>();
        ProtocolFiltroRicercaSoggetti filtro = new ProtocolFiltroRicercaSoggetti();
        filtro.setTipo("modipa");
        for (String pdd : listPddOperative) {
            ModIDynamicConfigurationSoggettiUtilities.fillSoggettiOperativi(registryReader, listSoggettiOperativi, filtro, pdd);
        }
        if (listSoggettiOperativi.isEmpty()) {
            throw new ProtocolException("Non risultano configurati soggetti di tipo 'operativo'");
        }
        return listSoggettiOperativi;
    }

    private static void fillSoggettiOperativi(IRegistryReader registryReader, List<String> listSoggettiOperativi, ProtocolFiltroRicercaSoggetti filtro, String pdd) {
        filtro.setNomePdd(pdd);
        try {
            List l = registryReader.findIdSoggetti(filtro);
            if (l != null && !l.isEmpty()) {
                for (IDSoggetto idS : l) {
                    if (listSoggettiOperativi.contains(idS.getNome())) continue;
                    listSoggettiOperativi.add(idS.getNome());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static List<String> getSoggettiOperativiAggregati(IRegistryReader registryReader) throws ProtocolException {
        List<String> listSoggettiOperativi = ModIDynamicConfigurationSoggettiUtilities.getSoggettiOperativi(registryReader);
        return ModIDynamicConfigurationSoggettiUtilities.filtraSoggettiAggregati(listSoggettiOperativi, registryReader);
    }

    public static List<String> getSoggettiOperativiNonAggregati(IRegistryReader registryReader) throws ProtocolException {
        List<String> listSoggettiOperativi = ModIDynamicConfigurationSoggettiUtilities.getSoggettiOperativi(registryReader);
        return ModIDynamicConfigurationSoggettiUtilities.filtraSoggettiNonAggregati(listSoggettiOperativi, registryReader);
    }

    private static List<String> filtraSoggettiAggregati(List<String> list, IRegistryReader registryReader) {
        return ModIDynamicConfigurationSoggettiUtilities.filtraSoggettiAggregati(list, registryReader, true);
    }

    private static List<String> filtraSoggettiNonAggregati(List<String> list, IRegistryReader registryReader) {
        return ModIDynamicConfigurationSoggettiUtilities.filtraSoggettiAggregati(list, registryReader, false);
    }

    private static List<String> filtraSoggettiAggregati(List<String> list, IRegistryReader registryReader, boolean includiSoloSoggettiAggregati) {
        ArrayList<String> newList = new ArrayList<String>();
        if (list != null && !list.isEmpty()) {
            ModIDynamicConfigurationSoggettiUtilities.filtraSoggettiAggregati(list, registryReader, includiSoloSoggettiAggregati, newList);
        }
        return newList;
    }

    private static void filtraSoggettiAggregati(List<String> list, IRegistryReader registryReader, boolean includiSoloSoggettiAggregati, List<String> newList) {
        for (String s : list) {
            boolean soggettoAggregato = ModIDynamicConfigurationSoggettiUtilities.isSoggettoAggregato(s, registryReader);
            if (soggettoAggregato) {
                if (!includiSoloSoggettiAggregati) continue;
                newList.add(s);
                continue;
            }
            if (includiSoloSoggettiAggregati) continue;
            newList.add(s);
        }
    }

    private static boolean isSoggettoAggregato(String nome, IRegistryReader registryReader) {
        return ModIDynamicConfigurationSoggettiUtilities.readInfoSoggettoAggregato(nome, registryReader) != null;
    }

    private static boolean isSoggettoAggregatore(String nome, IRegistryReader registryReader) throws ProtocolException {
        List<String> listSoggettiOperativi = ModIDynamicConfigurationSoggettiUtilities.getSoggettiOperativi(registryReader);
        if (!listSoggettiOperativi.isEmpty()) {
            for (String s : listSoggettiOperativi) {
                String check = ModIDynamicConfigurationSoggettiUtilities.readInfoSoggettoAggregato(s, registryReader);
                if (nome == null || !nome.equals(check)) continue;
                return true;
            }
        }
        return false;
    }

    private static String readInfoSoggettoAggregato(String nome, IRegistryReader registryReader) {
        IDSoggetto idS = new IDSoggetto("modipa", nome);
        Soggetto sog = null;
        try {
            sog = registryReader.getSoggetto(idS);
            if (sog != null && sog.sizeProtocolPropertyList() > 0) {
                for (ProtocolProperty pp : sog.getProtocolProperty()) {
                    if (!"modipaSoggettoPdndTracingAggregato".equals(pp.getName())) continue;
                    if (pp.getValue() == null || !org.apache.commons.lang3.StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{pp.getValue()}) || "-".equals(pp.getValue())) break;
                    return pp.getValue();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static List<String> getSoggettiOperativiRiferisconoSoggettoAggregato(String nomeSoggetto, IRegistryReader registryReader) throws ProtocolException {
        ArrayList<String> listSoggetti = new ArrayList<String>();
        List<String> listSoggettiOperativi = ModIDynamicConfigurationSoggettiUtilities.getSoggettiOperativi(registryReader);
        if (!listSoggettiOperativi.isEmpty()) {
            for (String s : listSoggettiOperativi) {
                String check = ModIDynamicConfigurationSoggettiUtilities.readInfoSoggettoAggregato(s, registryReader);
                if (!nomeSoggetto.equals(check)) continue;
                listSoggetti.add(s);
            }
        }
        return listSoggetti;
    }
}

