/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.modipa.properties;

import java.security.cert.X509Certificate;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.config.ConfigurazioneMultitenant;
import org.openspcoop2.core.config.GenericProperties;
import org.openspcoop2.core.config.ProtocolProperty;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.constants.PortaApplicativaSoggettiFruitori;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mvc.properties.provider.InputValidationUtils;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.constants.PddTipologia;
import org.openspcoop2.pdd.core.dynamic.DynamicHelperCostanti;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.utils.NamingUtils;
import org.openspcoop2.protocol.modipa.constants.ModIConsoleCostanti;
import org.openspcoop2.protocol.modipa.properties.ModIDynamicConfigurationKeystoreUtilities;
import org.openspcoop2.protocol.modipa.validator.IdentificazioneApplicativoMittenteUtils;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.ConsoleItemType;
import org.openspcoop2.protocol.sdk.constants.ConsoleItemValueType;
import org.openspcoop2.protocol.sdk.constants.ConsoleOperationType;
import org.openspcoop2.protocol.sdk.properties.AbstractConsoleItem;
import org.openspcoop2.protocol.sdk.properties.BaseConsoleItem;
import org.openspcoop2.protocol.sdk.properties.BinaryProperty;
import org.openspcoop2.protocol.sdk.properties.BooleanConsoleItem;
import org.openspcoop2.protocol.sdk.properties.BooleanProperty;
import org.openspcoop2.protocol.sdk.properties.ConsoleConfiguration;
import org.openspcoop2.protocol.sdk.properties.ConsoleItemInfo;
import org.openspcoop2.protocol.sdk.properties.IConsoleHelper;
import org.openspcoop2.protocol.sdk.properties.ProtocolProperties;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesFactory;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesUtils;
import org.openspcoop2.protocol.sdk.properties.StringConsoleItem;
import org.openspcoop2.protocol.sdk.properties.StringProperty;
import org.openspcoop2.protocol.sdk.registry.IConfigIntegrationReader;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.protocol.sdk.registry.RegistryException;
import org.openspcoop2.protocol.sdk.registry.RegistryNotFound;

public class ModIDynamicConfigurationApplicativiUtilities {
    private static final String VERIFICARE_CONFIG_ASSOCIAZIONE_APPLICATIVO = "Verificare le configurazioni dove risulta associato l'applicativo.";

    private ModIDynamicConfigurationApplicativiUtilities() {
    }

    private static List<String> getPddOperative(IRegistryReader registryReader) throws RegistryException {
        List pddOperative = null;
        try {
            pddOperative = registryReader.findIdPorteDominio(Boolean.valueOf(true));
        }
        catch (RegistryNotFound registryNotFound) {
            // empty catch block
        }
        return pddOperative;
    }

    static ConsoleConfiguration getDynamicConfigServizioApplicativo(ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDServizioApplicativo id) throws ProtocolException {
        ConsoleConfiguration configuration = new ConsoleConfiguration();
        boolean esterno = false;
        try {
            String dominio = consoleHelper.getParameter("dominio");
            if ((dominio == null || "".equals(dominio)) && ConsoleOperationType.CHANGE.equals((Object)consoleOperationType)) {
                List<String> pddOperative;
                Soggetto soggetto = registryReader.getSoggetto(id.getIdSoggettoProprietario());
                dominio = soggetto.getPortaDominio() == null || "".equals(soggetto.getPortaDominio()) ? PddTipologia.ESTERNO.toString() : ((pddOperative = ModIDynamicConfigurationApplicativiUtilities.getPddOperative(registryReader)) == null || pddOperative.isEmpty() || !pddOperative.contains(soggetto.getPortaDominio()) ? PddTipologia.ESTERNO.toString() : PddTipologia.OPERATIVO.toString());
            }
            esterno = PddTipologia.ESTERNO.toString().equals(dominio);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
        boolean isClient = true;
        try {
            String client = consoleHelper.getParameter("tipoSA");
            boolean bl = isClient = client == null || "".equals(client) || "client".equals(client) || "clientORserver".equals(client);
            if (ConsoleOperationType.CHANGE.equals((Object)consoleOperationType)) {
                ServizioApplicativo sa = configIntegrationReader.getServizioApplicativo(id);
                isClient = "client".equals(sa.getTipo()) || sa.isUseAsClient();
            }
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
        if (isClient) {
            if (!esterno) {
                BaseConsoleItem titolo = ProtocolPropertiesFactory.newTitleItem((String)"modipaApplicativiTitleId", (String)"ModI - Sicurezza Messaggio");
                configuration.addConsoleItem(titolo);
                BaseConsoleItem subTitolo = ProtocolPropertiesFactory.newSubTitleItem((String)"modipaSicurezzaSubTitleId", (String)"KeyStore");
                configuration.addConsoleItem(subTitolo);
                BooleanConsoleItem booleanConsoleItem = (BooleanConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.BOOLEAN, (ConsoleItemType)ConsoleItemType.CHECKBOX, (String)"modipaSecurityMessage", (String)"Abilitato");
                booleanConsoleItem.setDefaultValue((Object)false);
                booleanConsoleItem.setReloadOnChange(true, true);
                configuration.addConsoleItem((BaseConsoleItem)booleanConsoleItem);
                ModIDynamicConfigurationKeystoreUtilities.addKeystoreConfig(configuration, false, true, true);
                BaseConsoleItem subTitoloModiAUTH = ProtocolPropertiesFactory.newSubTitleItem((String)"modipaSicurezzaModIAuthSubTitleId", (String)"Authorization ModI");
                configuration.addConsoleItem(subTitoloModiAUTH);
            }
            if (esterno) {
                BaseConsoleItem subTitolo = ProtocolPropertiesFactory.newSubTitleItem((String)"modipaSicurezzaSubTitleId", (String)"Parametri della Risposta");
                configuration.addConsoleItem(subTitolo);
            }
            String labelSicurezzaMessaggioAudienceItem = esterno ? "Reply Audience/WSA-To" : "Identificativo Client";
            StringConsoleItem profiloSicurezzaMessaggioAudienceItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.TEXT_AREA, (String)"modipaSecurityMessageResponseAud", (String)labelSicurezzaMessaggioAudienceItem);
            profiloSicurezzaMessaggioAudienceItem.setRows(Integer.valueOf(2));
            profiloSicurezzaMessaggioAudienceItem.setNote(esterno ? "Identificativo dell'Applicativo indicato nel token di sicurezza della risposta" : "Identificativo dell'Applicativo scambiato nei token di sicurezza");
            ConsoleItemInfo infoAud = new ConsoleItemInfo(labelSicurezzaMessaggioAudienceItem);
            if (esterno) {
                infoAud.setHeaderBody("Identificativo dell\u2019applicativo utilizzato per valorizzare il claim 'aud' per API REST e l'header 'wsa:To' per API SOAP nel token di sicurezza associato alla risposta. Se non definito viene utilizzato il nome dell'erogazione");
            } else {
                infoAud.setHeaderBody("Identificativo dell\u2019applicativo utilizzato per valorizzare gli elementi indicati di seguito, generati all'interno del token di sicurezza:<BR/>- in una fruzione viene utilizzato per valorizzare il claim 'client_id' per API REST e l'header 'wsa:From' per API SOAP del token associato alla richiesta (<b>Nota:</b> se non definito viene utilizzato il nome dell'applicativo);<BR/>- in un'erogazione viene utilizzato per valorizzare il claim 'aud' per API REST e l'header 'wsa:To' per API SOAP del token associato alla risposta.<BR/><BR/>In una fruizione, inoltre, se \u00e8 abilitata la funzionalit\u00e0 'Verifica Audience / WSAddressing To' nella configurazione ModI di sicurezza della risposta, viene verificato che nel token associato alla risposta ricevuta vi sia un claim 'aud' per API REST o un header 'wsa:To' per API SOAP che possiede un valore identico all'identificato fornito.");
            }
            profiloSicurezzaMessaggioAudienceItem.setInfo(infoAud);
            profiloSicurezzaMessaggioAudienceItem.setRequired(false);
            configuration.addConsoleItem((BaseConsoleItem)profiloSicurezzaMessaggioAudienceItem);
            if (!esterno) {
                StringConsoleItem profiloSicurezzaMessaggioX5UItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.TEXT_AREA, (String)"modipaSecurityMessageRestRequestX509Url", (String)"URL (x5u)");
                profiloSicurezzaMessaggioX5UItem.setRows(Integer.valueOf(2));
                profiloSicurezzaMessaggioX5UItem.setNote("URL che riferisce un certificato (o certificate chain) X.509 corrispondente alla chiave firmataria del security token");
                ConsoleItemInfo infoX5U = new ConsoleItemInfo("URL (x5u)");
                infoX5U.setHeaderBody("URL che riferisce un certificato (o certificate chain) X.509 corrispondente alla chiave firmataria del security token.<BR/>Deve essere obbligatoriamente definito se l'applicativo fruisce di API REST configurate per generare un token di sicurezza tramite il claim 'x5u'");
                profiloSicurezzaMessaggioX5UItem.setInfo(infoX5U);
                profiloSicurezzaMessaggioX5UItem.setRequired(false);
                configuration.addConsoleItem((BaseConsoleItem)profiloSicurezzaMessaggioX5UItem);
            }
            if (!esterno) {
                int i;
                BaseConsoleItem subTitolo = ProtocolPropertiesFactory.newSubTitleItem((String)"modipaTokenSubTitleId", (String)"Authorization OAuth");
                configuration.addConsoleItem(subTitolo);
                BooleanConsoleItem booleanConsoleItem = (BooleanConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.BOOLEAN, (ConsoleItemType)ConsoleItemType.CHECKBOX, (String)"modipaSecurityToken", (String)"Abilitato");
                booleanConsoleItem.setDefaultValue((Object)false);
                booleanConsoleItem.setReloadOnChange(true, true);
                configuration.addConsoleItem((BaseConsoleItem)booleanConsoleItem);
                StringConsoleItem tokenPolicyItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.SELECT, (String)"modipaSecurityTokenPolicy", (String)"Token Policy di Validazione");
                List gestorePolicyTokenList = null;
                try {
                    gestorePolicyTokenList = configIntegrationReader.getTokenPolicyValidazione();
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
                String[] policyLabels = null;
                String[] policyValues = null;
                boolean tokenPolicyUndefined = true;
                if (tokenPolicyUndefined) {
                    policyLabels = new String[gestorePolicyTokenList.size() + 1];
                    policyValues = new String[gestorePolicyTokenList.size() + 1];
                    policyLabels[0] = "-";
                    policyValues[0] = "-";
                } else {
                    policyLabels = new String[gestorePolicyTokenList.size()];
                    policyValues = new String[gestorePolicyTokenList.size()];
                }
                for (i = 0; i < gestorePolicyTokenList.size(); ++i) {
                    GenericProperties genericProperties = (GenericProperties)gestorePolicyTokenList.get(i);
                    if (tokenPolicyUndefined) {
                        policyLabels[i + 1] = genericProperties.getNome();
                        policyValues[i + 1] = genericProperties.getNome();
                        continue;
                    }
                    policyLabels[i] = genericProperties.getNome();
                    policyValues[i] = genericProperties.getNome();
                }
                for (i = 0; i < policyValues.length; ++i) {
                    tokenPolicyItem.addLabelValue(policyLabels[i], (Object)policyValues[i]);
                }
                if (!ConsoleOperationType.CHANGE.equals((Object)consoleOperationType)) {
                    tokenPolicyItem.setDefaultValue((Object)"-");
                }
                tokenPolicyItem.setReloadOnChange(false, true);
                configuration.addConsoleItem((BaseConsoleItem)tokenPolicyItem);
                StringConsoleItem tokenClientIdItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.TEXT_AREA, (String)"modipaSecurityTokenClientId", (String)"Identificativo");
                tokenClientIdItem.setRows(Integer.valueOf(1));
                tokenClientIdItem.setRequired(true);
                configuration.addConsoleItem((BaseConsoleItem)tokenClientIdItem);
                StringConsoleItem tokenKIDItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.TEXT_AREA, (String)"modipaSecurityTokenKID", (String)"Key Id (kid) del Certificato");
                tokenKIDItem.setRows(Integer.valueOf(1));
                tokenKIDItem.setRequired(false);
                ConsoleItemInfo info = new ConsoleItemInfo("Key Id (kid) del Certificato");
                info.setHeaderBody("Il valore pu\u00f2 essere definito come costante o contenere parti dinamiche risolte a runtime dal Gateway.<br/>Le espressioni utilizzabili sono:");
                info.setListBody(DynamicHelperCostanti.LABEL_PARAMETRO_MODIPA_API_IMPL_PROFILO_SICUREZZA_OAUTH_REST_INFO_VALORI_REQUEST);
                tokenKIDItem.setInfo(info);
                configuration.addConsoleItem((BaseConsoleItem)tokenKIDItem);
            }
            return configuration;
        }
        return null;
    }

    static void updateDynamicConfigServizioApplicativo(ConsoleConfiguration consoleConfiguration, ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, ProtocolProperties properties, IConfigIntegrationReader configIntegrationReader, IDServizioApplicativo id) throws ProtocolException {
        boolean esterno = false;
        try {
            String dominio = consoleHelper.getParameter("dominio");
            esterno = PddTipologia.ESTERNO.toString().equals(dominio);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
        boolean isClient = true;
        try {
            String client = consoleHelper.getParameter("tipoSA");
            boolean bl = isClient = client == null || "".equals(client) || "client".equals(client) || "clientORserver".equals(client);
            if (ConsoleOperationType.CHANGE.equals((Object)consoleOperationType)) {
                ServizioApplicativo sa = configIntegrationReader.getServizioApplicativo(id);
                isClient = "client".equals(sa.getTipo()) || sa.isUseAsClient();
            }
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
        if (!esterno && isClient) {
            AbstractConsoleItem tokenKidItem;
            ConfigurazioneMultitenant configurazioneMultitenant = null;
            BooleanProperty booleanModeItemValue = (BooleanProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityMessage");
            if (booleanModeItemValue != null && booleanModeItemValue.getValue() != null && ((Boolean)booleanModeItemValue.getValue()).booleanValue()) {
                boolean hideSceltaArchivioFilePath = false;
                try {
                    configurazioneMultitenant = configIntegrationReader.getConfigurazioneMultitenant();
                }
                catch (RegistryNotFound registryNotFound) {
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
                boolean addHiddenSubjectIssuer = true;
                boolean rest = true;
                ModIDynamicConfigurationKeystoreUtilities.updateKeystoreConfig(consoleConfiguration, properties, false, hideSceltaArchivioFilePath, addHiddenSubjectIssuer, true, configurazioneMultitenant, rest);
                BaseConsoleItem subTitoloModIAuth = ProtocolPropertiesUtils.getBaseConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSicurezzaModIAuthSubTitleId");
                if (subTitoloModIAuth != null) {
                    subTitoloModIAuth.setType(ConsoleItemType.SUBTITLE);
                }
            } else {
                BaseConsoleItem subTitoloModIAuth;
                StringProperty profiloSicurezzaMessaggioX5UItemValue;
                AbstractConsoleItem profiloSicurezzaMessaggioX5UItem;
                StringProperty profiloSicurezzaMessaggioAudienceItemValue;
                AbstractConsoleItem profiloSicurezzaMessaggioAudienceItem;
                StringProperty keystoreByokPolicyMODIItemValue;
                StringProperty keystoreTypeMODIItemValue;
                StringProperty keystoreKeyAlgoMODIItemValue;
                StringProperty keystorePathPublicKeyMODIItemValue;
                StringProperty keystorePathMODIItemValue;
                StringProperty keystorePasswordMODIItemValue;
                StringProperty keystoreModeMODIItemValue;
                StringProperty keyCNSubjectMODIItemValue;
                StringProperty keyCNIssuerMODIItemValue;
                StringProperty keyPasswordMODIItemValue;
                StringProperty keyAliasMODIItemValue;
                BinaryProperty certificateItemValue;
                BinaryProperty archiveItemValue = (BinaryProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystoreArchive");
                if (archiveItemValue != null) {
                    archiveItemValue.setValue(null);
                    archiveItemValue.setFileName(null);
                    archiveItemValue.setClearContent(true);
                }
                if ((certificateItemValue = (BinaryProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystoreCertificate")) != null) {
                    certificateItemValue.setValue(null);
                    certificateItemValue.setFileName(null);
                    certificateItemValue.setClearContent(true);
                }
                if ((keyAliasMODIItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeyAlias")) != null) {
                    keyAliasMODIItemValue.setValue(null);
                }
                if ((keyPasswordMODIItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeyPassword")) != null) {
                    keyPasswordMODIItemValue.setValue(null);
                }
                if ((keyCNIssuerMODIItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeyCNIssuer")) != null) {
                    keyCNIssuerMODIItemValue.setValue(null);
                }
                if ((keyCNSubjectMODIItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeyCNSubject")) != null) {
                    keyCNSubjectMODIItemValue.setValue(null);
                }
                if ((keystoreModeMODIItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystoreMode")) != null) {
                    keystoreModeMODIItemValue.setValue(null);
                }
                if ((keystorePasswordMODIItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystorePassword")) != null) {
                    keystorePasswordMODIItemValue.setValue(null);
                }
                if ((keystorePathMODIItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystorePath")) != null) {
                    keystorePathMODIItemValue.setValue(null);
                }
                if ((keystorePathPublicKeyMODIItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystorePathPublicKey")) != null) {
                    keystorePathPublicKeyMODIItemValue.setValue(null);
                }
                if ((keystoreKeyAlgoMODIItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystoreKeyPairAlgo")) != null) {
                    keystoreKeyAlgoMODIItemValue.setValue(null);
                }
                if ((keystoreTypeMODIItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystoreType")) != null) {
                    keystoreTypeMODIItemValue.setValue(null);
                }
                if ((keystoreByokPolicyMODIItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystoreByokPolicy")) != null) {
                    keystoreByokPolicyMODIItemValue.setValue(null);
                }
                if ((profiloSicurezzaMessaggioAudienceItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityMessageResponseAud")) != null) {
                    profiloSicurezzaMessaggioAudienceItem.setType(ConsoleItemType.HIDDEN);
                }
                if ((profiloSicurezzaMessaggioAudienceItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityMessageResponseAud")) != null) {
                    profiloSicurezzaMessaggioAudienceItemValue.setValue(null);
                }
                if ((profiloSicurezzaMessaggioX5UItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityMessageRestRequestX509Url")) != null) {
                    profiloSicurezzaMessaggioX5UItem.setType(ConsoleItemType.HIDDEN);
                }
                if ((profiloSicurezzaMessaggioX5UItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityMessageRestRequestX509Url")) != null) {
                    profiloSicurezzaMessaggioX5UItemValue.setValue(null);
                }
                if ((subTitoloModIAuth = ProtocolPropertiesUtils.getBaseConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSicurezzaModIAuthSubTitleId")) != null) {
                    subTitoloModIAuth.setType(ConsoleItemType.HIDDEN);
                }
            }
            BooleanProperty booleanModeItemTokenValue = (BooleanProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityToken");
            if (booleanModeItemTokenValue != null && booleanModeItemTokenValue.getValue() != null && ((Boolean)booleanModeItemTokenValue.getValue()).booleanValue()) {
                AbstractConsoleItem tokenClientIdItem;
                StringProperty tokenPolicyItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityTokenPolicy");
                AbstractConsoleItem tokenPolicyItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityTokenPolicy");
                boolean tokenPolicyDefined = false;
                if (tokenPolicyItem != null) {
                    if (configurazioneMultitenant == null) {
                        try {
                            configurazioneMultitenant = configIntegrationReader.getConfigurazioneMultitenant();
                        }
                        catch (RegistryNotFound keyCNIssuerMODIItemValue) {
                        }
                        catch (Exception e) {
                            throw new ProtocolException(e.getMessage(), (Throwable)e);
                        }
                    }
                    if (configurazioneMultitenant != null && StatoFunzionalita.ABILITATO.equals((Object)configurazioneMultitenant.getStato()) && !PortaApplicativaSoggettiFruitori.SOGGETTI_ESTERNI.equals((Object)configurazioneMultitenant.getErogazioneSceltaSoggettiFruitori())) {
                        if (tokenPolicyItemValue == null || tokenPolicyItemValue.getValue() == null || StringUtils.isEmpty((String)((String)tokenPolicyItemValue.getValue())) || "-".equals(tokenPolicyItemValue.getValue())) {
                            tokenPolicyItem.setNote("<b>!!Attenzione!!</b> Per consentire un'identificazione dell'applicativo su API erogate da altri soggetti di dominio interno selezionare una token policy.");
                        } else {
                            tokenPolicyDefined = true;
                        }
                        tokenPolicyItem.setType(ConsoleItemType.SELECT);
                        tokenPolicyItem.setRequired(false);
                        tokenPolicyItem.setReloadOnChange(true, true);
                    } else {
                        tokenPolicyItem.setNote(null);
                        tokenPolicyItem.setType(ConsoleItemType.HIDDEN);
                        tokenPolicyItem.setRequired(false);
                    }
                }
                if ((tokenClientIdItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityTokenClientId")) != null) {
                    tokenClientIdItem.setType(ConsoleItemType.TEXT_AREA);
                    tokenClientIdItem.setRequired(true);
                    if (tokenPolicyDefined) {
                        tokenClientIdItem.setInfo(null);
                    } else {
                        ConsoleItemInfo info = new ConsoleItemInfo("Identificativo");
                        info.setHeaderBody("Il valore pu\u00f2 essere definito come costante o contenere parti dinamiche risolte a runtime dal Gateway.<br/>Le espressioni utilizzabili sono:");
                        info.setListBody(DynamicHelperCostanti.LABEL_PARAMETRO_MODIPA_API_IMPL_PROFILO_SICUREZZA_OAUTH_REST_INFO_VALORI_REQUEST);
                        tokenClientIdItem.setInfo(info);
                    }
                }
                if ((tokenKidItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityTokenKID")) != null) {
                    if (booleanModeItemValue != null && booleanModeItemValue.getValue() != null && ((Boolean)booleanModeItemValue.getValue()).booleanValue()) {
                        tokenKidItem.setType(ConsoleItemType.TEXT_AREA);
                    } else {
                        tokenKidItem.setType(ConsoleItemType.HIDDEN);
                    }
                }
            } else {
                StringProperty tokenKidItemValue;
                StringProperty tokenClientIdItemValue;
                AbstractConsoleItem tokenClientIdItem;
                AbstractConsoleItem tokenPolicyItem;
                StringProperty tokenPolicyItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityTokenPolicy");
                if (tokenPolicyItemValue != null) {
                    tokenPolicyItemValue.setValue(null);
                }
                if ((tokenPolicyItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityTokenPolicy")) != null) {
                    tokenPolicyItem.setType(ConsoleItemType.HIDDEN);
                    tokenPolicyItem.setRequired(false);
                    tokenPolicyItem.setNote(null);
                }
                if ((tokenClientIdItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityTokenClientId")) != null) {
                    tokenClientIdItem.setType(ConsoleItemType.HIDDEN);
                    tokenClientIdItem.setRequired(false);
                }
                if ((tokenClientIdItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityTokenClientId")) != null) {
                    tokenClientIdItemValue.setValue(null);
                }
                if ((tokenKidItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityTokenKID")) != null) {
                    tokenKidItem.setType(ConsoleItemType.HIDDEN);
                }
                if ((tokenKidItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityTokenKID")) != null) {
                    tokenKidItemValue.setValue(null);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    static void validateDynamicConfigServizioApplicativo(ConsoleConfiguration consoleConfiguration, ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, ProtocolProperties properties, IConfigIntegrationReader configIntegrationReader, IDServizioApplicativo id) throws ProtocolException {
        esterno = false;
        try {
            dominio = consoleHelper.getParameter("dominio");
            esterno = PddTipologia.ESTERNO.toString().equals(dominio);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
        isClient = true;
        try {
            client = consoleHelper.getParameter("tipoSA");
            v0 = isClient = client == null || "".equals(client) != false || "client".equals(client) != false || "clientORserver".equals(client) != false;
            if (ConsoleOperationType.CHANGE.equals((Object)consoleOperationType)) {
                sa = configIntegrationReader.getServizioApplicativo(id);
                isClient = "client".equals(sa.getTipo()) != false || sa.isUseAsClient() != false;
            }
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
        if (isClient) {
            verifyKeystoreConfig = false;
            verifyCertificateConfig = false;
            changeBinary = false;
            if (ConsoleOperationType.CHANGE.equals((Object)consoleOperationType)) {
                try {
                    p = consoleHelper.getParameter("changeBinary");
                    if ("true".equalsIgnoreCase(p)) {
                        verifyKeystoreConfig = true;
                        changeBinary = true;
                        selectModeItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystoreMode");
                        if (selectModeItemValue != null && selectModeItemValue.getValue() != null && !"".equals(selectModeItemValue.getValue())) {
                            modalita = (String)selectModeItemValue.getValue();
                            if ("archive".equals(modalita)) {
                                verifyKeystoreConfig = true;
                            } else {
                                verifyCertificateConfig = true;
                                verifyKeystoreConfig = false;
                            }
                        }
                        if (verifyKeystoreConfig) {
                            archiveItemValue = (BinaryProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystoreArchive");
                            if (archiveItemValue != null && archiveItemValue.getValue() != null) ** GOTO lbl58
                            throw new ProtocolException("Archivio non fornito");
                        }
                        if (!verifyCertificateConfig || (certificateItemValue = (BinaryProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystoreCertificate")) != null && certificateItemValue.getValue() != null) ** GOTO lbl58
                        throw new ProtocolException("Certificato non fornito");
                    }
                    selectModeItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystoreMode");
                    if (selectModeItemValue == null || selectModeItemValue.getValue() == null || "".equals(selectModeItemValue.getValue())) ** GOTO lbl58
                    modalita = (String)selectModeItemValue.getValue();
                    if ("archive".equals(modalita)) {
                        verifyKeystoreConfig = true;
                    }
                    verifyCertificateConfig = true;
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
            } else if (ConsoleOperationType.ADD.equals((Object)consoleOperationType) && (selectModeItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystoreMode")) != null && selectModeItemValue.getValue() != null && !"".equals(selectModeItemValue.getValue())) {
                modalita = (String)selectModeItemValue.getValue();
                if ("archive".equals(modalita)) {
                    verifyKeystoreConfig = true;
                } else {
                    verifyCertificateConfig = true;
                }
            }
lbl58:
            // 9 sources

            cert = null;
            if (!esterno) {
                if (verifyKeystoreConfig) {
                    try {
                        cert = ModIDynamicConfigurationKeystoreUtilities.readKeystoreConfig(properties, false);
                    }
                    catch (Exception e) {
                        throw new ProtocolException("Verificare i parametri indicati per il keystore in ModI - Sicurezza Messaggio - KeyStore: " + e.getMessage(), (Throwable)e);
                    }
                }
                if (verifyCertificateConfig) {
                    try {
                        cert = ModIDynamicConfigurationKeystoreUtilities.readKeystoreConfig(properties, true);
                    }
                    catch (Exception e) {
                        throw new ProtocolException("Verificare il certificato caricato in ModI - Sicurezza Messaggio - KeyStore: " + e.getMessage(), (Throwable)e);
                    }
                }
                if (verifyCertificateConfig && cert != null && cert.getSubject() != null) {
                    filtro = IdentificazioneApplicativoMittenteUtils.createFilter(cert.getSubject().toString(), cert.getIssuer().toString());
                    list = null;
                    try {
                        list = configIntegrationReader.findIdServiziApplicativi(filtro);
                    }
                    catch (RegistryNotFound var14_23) {
                    }
                    catch (Exception t) {
                        throw new ProtocolException("Errore non atteso durante la verfica del certificato caricato in ModI - Sicurezza Messaggio - KeyStore: " + t.getMessage(), (Throwable)t);
                    }
                    if (list != null) {
                        for (IDServizioApplicativo idServizioApplicativoSubjectIssuerCheck : list) {
                            certificatoCheck = null;
                            try {
                                sa = configIntegrationReader.getServizioApplicativo(idServizioApplicativoSubjectIssuerCheck);
                                certificatoCheck = IdentificazioneApplicativoMittenteUtils.readServizioApplicativoByCertificate(sa, null);
                            }
                            catch (Exception t) {
                                throw new ProtocolException("Errore non atteso durante la verfica del certificato caricato in ModI - Sicurezza Messaggio - KeyStore: " + t.getMessage(), (Throwable)t);
                            }
                            if (!(certificatoCheck instanceof X509Certificate) || !cert.equals((X509Certificate)certificatoCheck, true) || !ConsoleOperationType.ADD.equals((Object)consoleOperationType) && idServizioApplicativoSubjectIssuerCheck.equals((Object)id)) continue;
                            throw new ProtocolException("Il certificato caricato in ModI - Sicurezza Messaggio - KeyStore risulta gi\u00e0 assegnato all'applicativo '" + idServizioApplicativoSubjectIssuerCheck.getNome() + "'");
                        }
                    }
                }
                if (changeBinary) {
                    try {
                        if (cert != null && cert.getSubject() != null) {
                            subjectItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeyCNSubject");
                            subjectItemValue.setValue((Object)cert.getSubject().toString());
                            issuerItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeyCNIssuer");
                            if (cert.getIssuer() != null) {
                                issuerItemValue.setValue((Object)cert.getIssuer().toString());
                            } else if (issuerItemValue != null) {
                                issuerItemValue.setValue(null);
                            }
                        }
                    }
                    catch (Exception subjectItemValue) {
                        // empty catch block
                    }
                }
            }
            if ((audienceRispostaItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityMessageResponseAud")) != null && (audienceRispostaItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityMessageResponseAud")) != null && audienceRispostaItemValue.getValue() != null && !"".equals(audienceRispostaItemValue.getValue())) {
                try {
                    labelSicurezzaMessaggioAudienceItem = esterno != false ? "Reply Audience/WSA-To" : "Identificativo Client";
                    InputValidationUtils.validateTextAreaInput((String)((String)audienceRispostaItemValue.getValue()), (String)labelSicurezzaMessaggioAudienceItem);
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
            }
            if (!esterno && (x5uUrlItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityMessageRestRequestX509Url")) != null && (x5uUrlItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityMessageRestRequestX509Url")) != null && x5uUrlItemValue.getValue() != null && !"".equals(x5uUrlItemValue.getValue())) {
                try {
                    InputValidationUtils.validateTextAreaInput((String)((String)x5uUrlItemValue.getValue()), (String)"URL (x5u)");
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
            }
            if ((keystorePathItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaKeystorePath")) != null && (keystorePathItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystorePath")) != null && keystorePathItemValue.getValue() != null && !"".equals(keystorePathItemValue.getValue())) {
                try {
                    keystoreType = null;
                    keystoreTypeItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystoreType");
                    if (keystoreTypeItemValue != null && keystoreTypeItemValue.getValue() != null) {
                        keystoreType = (String)keystoreTypeItemValue.getValue();
                    }
                    InputValidationUtils.validateTextAreaInput((String)((String)keystorePathItemValue.getValue()), (String)("Sicurezza Messaggio - " + (ModIConsoleCostanti.MODIPA_KEYSTORE_TYPE_VALUE_KEY_PAIR.equals(keystoreType) != false ? "Chiave Privata" : "Path")));
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
            }
            if ((keystorePathPublicKeyItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaKeystorePathPublicKey")) != null && (keystorePathPublicKeyItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystorePathPublicKey")) != null && keystorePathPublicKeyItemValue.getValue() != null && !"".equals(keystorePathPublicKeyItemValue.getValue())) {
                try {
                    InputValidationUtils.validateTextAreaInput((String)((String)keystorePathPublicKeyItemValue.getValue()), (String)"Sicurezza Messaggio - Chiave Pubblica");
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
            }
            if ((keystorePasswordItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaKeystorePassword")) != null && (keystoreItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeystorePassword")) != null && keystoreItemValue.getValue() != null && !"".equals(keystoreItemValue.getValue())) {
                try {
                    InputValidationUtils.validateTextInput((String)((String)keystoreItemValue.getValue()), (String)"KeyStore - Password");
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
            }
            if ((keyPasswordItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaKeyPassword")) != null && (keystoreItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeyPassword")) != null && keystoreItemValue.getValue() != null && !"".equals(keystoreItemValue.getValue())) {
                try {
                    InputValidationUtils.validateTextInput((String)((String)keystoreItemValue.getValue()), (String)"KeyStore - Password Chiave Privata");
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
            }
            if ((keyAliasItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaKeyAlias")) != null && (keystoreItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaKeyAlias")) != null && keystoreItemValue.getValue() != null && !"".equals(keystoreItemValue.getValue())) {
                try {
                    InputValidationUtils.validateTextInput((String)((String)keystoreItemValue.getValue()), (String)"KeyStore - Alias Chiave Privata");
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
            }
            tokenPolicyName = null;
            if (!esterno) {
                booleanModeItemTokenValue = (BooleanProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityToken");
                if (booleanModeItemTokenValue != null && booleanModeItemTokenValue.getValue() != null && ((Boolean)booleanModeItemTokenValue.getValue()).booleanValue()) {
                    tokenPolicyItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityTokenPolicy");
                    if (tokenPolicyItemValue != null && tokenPolicyItemValue.getValue() != null && !StringUtils.isEmpty((String)((String)tokenPolicyItemValue.getValue())) && !"-".equals(tokenPolicyItemValue.getValue())) {
                        tokenPolicyName = (String)tokenPolicyItemValue.getValue();
                    }
                    if (tokenPolicyName != null) {
                        gp = null;
                        try {
                            gp = configIntegrationReader.getTokenPolicyValidazione(tokenPolicyName);
                        }
                        catch (RegistryNotFound var22_42) {
                        }
                        catch (RegistryException e) {
                            throw new ProtocolException("Token Policy di Validazione indicata '" + tokenPolicyName + "' non esiste? (errore: " + e.getMessage() + ")", (Throwable)e);
                        }
                        if (gp == null) {
                            throw new ProtocolException("Token Policy di Validazione indicata '" + tokenPolicyName + "' non esiste");
                        }
                    }
                    if ((tokenClientIdItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityTokenClientId")) == null || tokenClientIdItemValue.getValue() == null || StringUtils.isEmpty((String)((String)tokenClientIdItemValue.getValue()))) {
                        throw new ProtocolException("Deve essere indicato un Identificativo");
                    }
                    try {
                        InputValidationUtils.validateTextAreaInput((String)((String)tokenClientIdItemValue.getValue()), (String)"Identificativo");
                    }
                    catch (Exception e) {
                        throw new ProtocolException(e.getMessage(), (Throwable)e);
                    }
                    tokenKidItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityTokenKID");
                    if (tokenKidItemValue != null && tokenKidItemValue.getValue() != null && StringUtils.isNotEmpty((String)((String)tokenKidItemValue.getValue()))) {
                        try {
                            InputValidationUtils.validateTextAreaInput((String)((String)tokenKidItemValue.getValue()), (String)"Key Id (kid) del Certificato");
                        }
                        catch (Exception e) {
                            throw new ProtocolException(e.getMessage(), (Throwable)e);
                        }
                    }
                    tokenWithHttpsEnabled = false;
                    for (IProtocolFactory protocolFactory : ProtocolFactoryManager.getInstance().getProtocolFactories().values()) {
                        if (!protocolFactory.createProtocolConfiguration().isSupportatoAutenticazioneApplicativiHttpsConToken()) continue;
                        tokenWithHttpsEnabled = true;
                        break;
                    }
                    sa = null;
                    if (tokenPolicyName != null) {
                        try {
                            sa = configIntegrationReader.getServizioApplicativoByCredenzialiToken(tokenPolicyName, (String)tokenClientIdItemValue.getValue(), tokenWithHttpsEnabled);
                            alreadyExists = false;
                            if (sa != null) {
                                if (ConsoleOperationType.ADD.equals((Object)consoleOperationType)) {
                                    alreadyExists = true;
                                } else {
                                    idSAFind = new IDServizioApplicativo();
                                    idSAFind.setIdSoggettoProprietario(new IDSoggetto(sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
                                    idSAFind.setNome(sa.getNome());
                                    if (!id.equals((Object)idSAFind)) {
                                        alreadyExists = true;
                                    }
                                }
                            }
                            if (alreadyExists) {
                                labelSoggetto = NamingUtils.getLabelSoggetto((IDSoggetto)new IDSoggetto(sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
                                throw new ProtocolException("L'applicativo " + sa.getNome() + " (soggetto: " + labelSoggetto + ") possiede gi\u00e0 l'identificativo client indicato");
                            }
                        }
                        catch (RegistryNotFound alreadyExists) {
                        }
                        catch (Exception e) {
                            throw new ProtocolException(e.getMessage(), (Throwable)e);
                        }
                    }
                }
                if (ConsoleOperationType.CHANGE.equals((Object)consoleOperationType)) {
                    booleanModeItemSicurezzaMessaggioValue = (BooleanProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityMessage");
                    sicurezzaMessaggio = false;
                    if (booleanModeItemSicurezzaMessaggioValue != null && booleanModeItemSicurezzaMessaggioValue.getValue() != null) {
                        sicurezzaMessaggio = (Boolean)booleanModeItemSicurezzaMessaggioValue.getValue();
                    }
                    sa = null;
                    try {
                        sa = configIntegrationReader.getServizioApplicativo(id);
                    }
                    catch (Exception tokenWithHttpsEnabled) {
                        // empty catch block
                    }
                    if (sa != null) {
                        oldTokenPolicyName = null;
                        oldCnSubject = null;
                        if (sa.sizeProtocolPropertyList() > 0) {
                            for (ProtocolProperty pp : sa.getProtocolPropertyList()) {
                                if ("modipaSecurityTokenPolicy".equals(pp.getName())) {
                                    oldTokenPolicyName = pp.getValue();
                                    continue;
                                }
                                if (!"modipaKeyCNSubject".equals(pp.getName())) continue;
                                oldCnSubject = pp.getValue();
                            }
                        }
                        sbWarningChange = new StringBuilder();
                        if (oldTokenPolicyName != null && StringUtils.isNotEmpty(oldTokenPolicyName) && !"-".equals(oldTokenPolicyName)) {
                            if (tokenPolicyName == null || StringUtils.isEmpty((String)tokenPolicyName)) {
                                sbWarningChange.append("L'applicativo potrebbe essere stato associato ad una erogazione o fruizione che richiede la token policy '" + oldTokenPolicyName + "' eliminata.");
                                sbWarningChange.append("<br/>");
                                sbWarningChange.append("Verificare le configurazioni dove risulta associato l'applicativo.");
                            } else if (!oldTokenPolicyName.equals(tokenPolicyName)) {
                                sbWarningChange.append("L'applicativo potrebbe essere stato associato ad una erogazione o fruizione che richiede la precedente token policy '" + oldTokenPolicyName + "' modificata in '" + tokenPolicyName + "'.");
                                sbWarningChange.append("<br/>");
                                sbWarningChange.append("Verificare le configurazioni dove risulta associato l'applicativo.");
                            }
                        }
                        if (oldCnSubject != null && StringUtils.isNotEmpty(oldCnSubject) && !sicurezzaMessaggio) {
                            if (sbWarningChange.length() > 0) {
                                sbWarningChange.append("<br/>");
                                sbWarningChange.append("<br/>");
                            }
                            sbWarningChange.append("L'applicativo potrebbe essere stato associato ad una erogazione o fruizione che richiede il certificato eliminato (" + oldCnSubject + ").");
                            sbWarningChange.append("<br/>");
                            sbWarningChange.append("Verificare le configurazioni dove risulta associato l'applicativo.");
                        }
                        if (sbWarningChange.length() > 0) {
                            try {
                                consoleHelper.setMessage(sbWarningChange.toString(), true, "warn");
                            }
                            catch (Exception var26_56) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        }
    }
}

