/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.modipa.connettori;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.SOAPBody;
import javax.xml.transform.TransformerException;
import org.openspcoop2.core.config.ResponseCachingConfigurazione;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.IDriverConfigurazioneGet;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.registry.ProtocolProperty;
import org.openspcoop2.core.transazioni.constants.TipoMessaggio;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2MessageParseResult;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.message.exception.MessageNotSupportedException;
import org.openspcoop2.message.soap.TunnelSoapUtils;
import org.openspcoop2.message.xml.MessageDynamicNamespaceContextFactory;
import org.openspcoop2.pdd.config.ConfigurazionePdDReader;
import org.openspcoop2.pdd.config.CostantiProprieta;
import org.openspcoop2.pdd.config.DigestServiceParams;
import org.openspcoop2.pdd.config.DigestServiceParamsDriver;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.Utilities;
import org.openspcoop2.pdd.core.connettori.ConnettoreBaseWithResponse;
import org.openspcoop2.pdd.core.connettori.ConnettoreException;
import org.openspcoop2.pdd.core.connettori.ConnettoreLogger;
import org.openspcoop2.pdd.core.connettori.ConnettoreMsg;
import org.openspcoop2.protocol.modipa.config.ModIProperties;
import org.openspcoop2.protocol.modipa.utils.SignalHubUtils;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.digest.DigestType;
import org.openspcoop2.utils.io.DumpByteArrayOutputStream;
import org.openspcoop2.utils.io.notifier.NotifierInputStreamParams;
import org.openspcoop2.utils.json.JSONUtils;
import org.openspcoop2.utils.rest.problem.JsonSerializer;
import org.openspcoop2.utils.rest.problem.ProblemRFC7807;
import org.openspcoop2.utils.transport.TransportResponseContext;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.xml.DynamicNamespaceContext;
import org.openspcoop2.utils.xml.XMLException;
import org.openspcoop2.utils.xml.XMLUtils;
import org.openspcoop2.utils.xml.XPathException;
import org.openspcoop2.utils.xml.XPathExpressionEngine;
import org.openspcoop2.utils.xml.XPathNotFoundException;
import org.openspcoop2.utils.xml.XPathNotValidException;
import org.openspcoop2.utils.xml.XPathReturnType;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ConnettoreSignalHubPseudonymization
extends ConnettoreBaseWithResponse {
    public static final String LOCATION = "govway://signalHubPseudonymization";
    private DumpByteArrayOutputStream requestBout = null;

    public String getProtocollo() {
        return "http";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DigestServiceParams initCryptoInfo(DigestServiceParamsDriver driver, PdDContext context) throws UtilsException, DriverConfigurazioneException, ProtocolException {
        RequestInfo reqInfo = (RequestInfo)context.getObject(Costanti.REQUEST_INFO);
        IDServizio idServizio = reqInfo.getIdServizio();
        DigestServiceParams param = null;
        List<ProtocolProperty> protocolProperty = SignalHubUtils.obtainSignalHubProtocolProperty((Context)context);
        driver.acquireLock(reqInfo.getIdTransazione());
        try {
            param = driver.getLastEntry(idServizio);
            if (param != null) {
                DigestServiceParams digestServiceParams = param;
                return digestServiceParams;
            }
            param = SignalHubUtils.generateDigestServiceParams(idServizio, protocolProperty, null);
            driver.addNewEntry(param);
        }
        finally {
            driver.releaseLock();
        }
        return param;
    }

    private String getSignalHubNS() throws ProtocolException {
        List props = null;
        if (this.pa != null) {
            props = this.pa.getProprieta();
        }
        if (this.pd != null) {
            props = this.pd.getProprieta();
        }
        return CostantiProprieta.getPdndSignalHubNamespace((List)props, (String)ModIProperties.getInstance().getSignalHubSoapNamespace());
    }

    private String getSoapNS() {
        return this.messageTypeResponse == MessageType.SOAP_11 ? "http://schemas.xmlsoap.org/soap/envelope/" : "http://www.w3.org/2003/05/soap-envelope";
    }

    private void setResponseOk(boolean isSoap, DigestType digest, byte[] seed) throws UtilsException, IOException, SAXException, ParserConfigurationException, XMLException, TransformerException, ProtocolException {
        if (isSoap) {
            XMLUtils xmlUtils = XMLUtils.getInstance();
            String signalHubNS = this.getSignalHubNS();
            Document doc = xmlUtils.newDocument();
            Element response = doc.createElementNS(signalHubNS, "cr:pseudonymizationResponse");
            Element seedElement = doc.createElementNS(signalHubNS, "cr:seed");
            seedElement.appendChild(doc.createTextNode(new String(seed)));
            Element digestElement = doc.createElementNS(signalHubNS, "cr:cryptoHashFunction");
            digestElement.appendChild(doc.createTextNode(digest.toString()));
            response.appendChild(digestElement);
            response.appendChild(seedElement);
            String envNS = this.getSoapNS();
            this.isResponse = new ByteArrayInputStream(("<?xml version='1.0' encoding='UTF-8'?><soapenv:Envelope xmlns:soapenv=\"" + envNS + "\"><soapenv:Body>" + xmlUtils.toString(response, true) + "</soapenv:Body></soapenv:Envelope>").getBytes());
            this.tipoRisposta = this.messageTypeResponse == MessageType.SOAP_11 ? "text/xml" : "application/soap+xml";
            this.codice = 200;
        } else {
            JSONUtils jsonUtils = JSONUtils.getInstance();
            ObjectNode node = jsonUtils.newObjectNode();
            node.put("seed", new String(seed));
            node.put("cryptoHashFunction", digest.toString());
            this.isResponse = new ByteArrayInputStream(jsonUtils.toByteArray((JsonNode)node));
            this.tipoRisposta = "application/json";
            this.codice = 200;
        }
    }

    private void setResponse404(boolean isSoap) throws UtilsException {
        String detail = "Informazioni di pseudoanonimizzazione non trovate";
        if (isSoap) {
            this.responseMsg = OpenSPCoop2MessageFactory.getDefaultMessageFactory().createFaultMessage(this.requestMsg.getMessageType(), true, detail);
        } else {
            JsonSerializer jsonSerializer = new JsonSerializer();
            ProblemRFC7807 problemRFC7807 = new ProblemRFC7807();
            problemRFC7807.setStatus(Integer.valueOf(404));
            problemRFC7807.setDetail(detail);
            problemRFC7807.setTitle("Not Found");
            problemRFC7807.setType("https://httpstatuses.com/404");
            this.isResponse = new ByteArrayInputStream(jsonSerializer.toByteArray(problemRFC7807));
            this.tipoRisposta = "application/problem+json";
            this.codice = 404;
            this.responseMsg = null;
        }
    }

    private Long retrieveSignalId(boolean isSoap, RequestInfo reqInfo) throws MessageException, MessageNotSupportedException, ProtocolException, XPathException, XPathNotValidException {
        String signalId = null;
        if (isSoap) {
            String signalHubNS = this.getSignalHubNS();
            String soapNS = this.getSoapNS();
            DynamicNamespaceContext nsc = MessageDynamicNamespaceContextFactory.getInstance((OpenSPCoop2MessageFactory)this.requestMsg.getFactory()).getNamespaceContext((Node)this.requestMsg.castAsSoap().getSOAPPart());
            if (nsc.getPrefix(signalHubNS) == null || nsc.getPrefix(signalHubNS).isBlank()) {
                this.responseMsg = OpenSPCoop2MessageFactory.getDefaultMessageFactory().createFaultMessage(this.requestMsg.getMessageType(), true, "namespace per signal hub (" + signalHubNS + ") non individuato");
                return null;
            }
            XPathExpressionEngine engine = new XPathExpressionEngine();
            String query = String.format("/{%1$s}:Envelope/{%1$s}:Body/{%2$s}:pseudonymization/{%2$s}:signalId/text()", soapNS, signalHubNS);
            try {
                signalId = (String)engine.getMatchPattern((Document)this.requestMsg.castAsSoap().getSOAPPart(), nsc, query, XPathReturnType.STRING);
            }
            catch (XPathNotFoundException xPathNotFoundException) {}
        } else {
            signalId = reqInfo.getProtocolContext().getParameterFirstValue("signalId");
        }
        return signalId != null && !signalId.trim().isBlank() ? Long.valueOf(Long.parseLong(signalId)) : null;
    }

    private void retrieveCryptoInfo(boolean isSoap, PdDContext pddContext) throws UtilsException, DriverConfigurazioneException, ProtocolException, ConnettoreException, IOException, SAXException, ParserConfigurationException, XMLException, TransformerException {
        RequestInfo reqInfo = (RequestInfo)pddContext.getObject(Costanti.REQUEST_INFO);
        IDServizio idServizio = reqInfo.getIdServizio();
        IDriverConfigurazioneGet db = ConfigurazionePdDReader.getDriverConfigurazionePdD();
        if (!(db instanceof DriverConfigurazioneDB)) {
            throw new UtilsException("driver trovato non di tipo db");
        }
        DigestServiceParams param = null;
        try {
            Long signalId = this.retrieveSignalId(isSoap, reqInfo);
            if (this.responseMsg != null) {
                return;
            }
            DigestServiceParamsDriver driver = new DigestServiceParamsDriver((DriverConfigurazioneDB)db);
            param = driver.getEntry(idServizio, signalId);
            if (param == null && signalId == null) {
                param = this.initCryptoInfo(driver, pddContext);
            }
        }
        catch (NumberFormatException | MessageException | MessageNotSupportedException | XPathException | XPathNotValidException e) {
            throw new ConnettoreException("signalId params non int64");
        }
        if (param == null) {
            this.setResponse404(isSoap);
            return;
        }
        this.setResponseOk(isSoap, param.getDigestAlgorithm(), param.getSeed());
    }

    protected boolean initializePreSend(ResponseCachingConfigurazione responseCachingConfig, ConnettoreMsg request) {
        return this.initialize(request, false, responseCachingConfig);
    }

    protected boolean send(ConnettoreMsg request) {
        PdDContext pddContext = request.getOutRequestContext().getPddContext();
        this.codice = 200;
        try {
            TransportResponseContext responseContext;
            MessageType requestMessageType = this.requestMsg.getMessageType();
            OpenSPCoop2SoapMessage soapMessageRequest = null;
            if (this.debug) {
                this.logger.debug("Tipologia Servizio: " + this.requestMsg.getServiceBinding());
            }
            if (this.isSoap) {
                soapMessageRequest = this.requestMsg.castAsSoap();
            }
            HashMap<String, List<String>> propertiesTrasportoDebug = null;
            if (this.isDumpBinarioRichiesta()) {
                propertiesTrasportoDebug = new HashMap<String, List<String>>();
            }
            String contentTypeRichiesta = null;
            if (this.debug) {
                this.logger.debug("Impostazione content type...");
            }
            if (this.isSoap) {
                contentTypeRichiesta = this.sbustamentoSoap && soapMessageRequest.countAttachments() > 0 && TunnelSoapUtils.isTunnelOpenSPCoopSoap((OpenSPCoop2SoapMessage)soapMessageRequest) ? TunnelSoapUtils.getContentTypeTunnelOpenSPCoopSoap((SOAPBody)soapMessageRequest.getSOAPBody()) : this.requestMsg.getContentType();
                if (contentTypeRichiesta == null) {
                    throw new ConnettoreException("Content-Type del messaggio da spedire non definito");
                }
            } else {
                contentTypeRichiesta = this.requestMsg.getContentType();
            }
            if (this.debug) {
                this.logger.info("Impostazione Content-Type [" + contentTypeRichiesta + "]", false);
            }
            if (contentTypeRichiesta != null) {
                this.setRequestHeader("Content-Type", contentTypeRichiesta, this.logger, propertiesTrasportoDebug);
            }
            if (this.debug) {
                this.logger.debug("Impostazione timeout...");
            }
            int readConnectionTimeout = -1;
            boolean readConnectionTimeoutConfigurazioneGlobale = true;
            if (this.properties.get("readConnectionTimeout") != null) {
                try {
                    readConnectionTimeout = Integer.parseInt((String)this.properties.get("readConnectionTimeout"));
                    readConnectionTimeoutConfigurazioneGlobale = this.properties.containsKey("readConnectionTimeoutGlobale");
                }
                catch (Exception e) {
                    this.logger.error("Parametro readConnectionTimeout errato", (Throwable)e);
                }
            }
            if (readConnectionTimeout == -1) {
                readConnectionTimeout = 120000;
            }
            if (this.debug) {
                this.logger.info("Impostazione read timeout [" + readConnectionTimeout + "]", false);
            }
            if (this.debug) {
                this.logger.debug("Impostazione header di trasporto...");
            }
            this.forwardHttpRequestHeader();
            if (this.propertiesTrasporto != null) {
                for (String key : this.propertiesTrasporto.keySet()) {
                    List values = (List)this.propertiesTrasporto.get(key);
                    if (this.debug && values != null && !values.isEmpty()) {
                        for (String value : values) {
                            this.logger.info("Set propriet\u00e0 trasporto [" + key + "]=[" + value + "]", false);
                        }
                    }
                    this.setRequestHeader(key, values, this.logger, propertiesTrasportoDebug);
                }
            }
            if (this.isSoap && !this.sbustamentoSoap) {
                if (this.debug) {
                    this.logger.debug("Impostazione soap action...");
                }
                boolean existsTransportProperties = false;
                if (TransportUtils.containsKey((Map)this.propertiesTrasporto, (String)"SOAPAction")) {
                    this.soapAction = TransportUtils.getFirstValue((Map)this.propertiesTrasporto, (String)"SOAPAction");
                    boolean bl = existsTransportProperties = this.soapAction != null;
                }
                if (!existsTransportProperties) {
                    this.soapAction = soapMessageRequest.getSoapAction();
                }
                if (this.soapAction == null) {
                    this.soapAction = "\"OpenSPCoop\"";
                }
                if (MessageType.SOAP_11.equals((Object)this.requestMsg.getMessageType()) && !existsTransportProperties) {
                    this.setRequestHeader("SOAPAction", this.soapAction, propertiesTrasportoDebug);
                }
                if (this.debug) {
                    this.logger.info("SOAP Action inviata [" + this.soapAction + "]", false);
                }
            }
            boolean consumeRequestMessage = false;
            if (this.debug) {
                this.logger.debug("Serializzazione (consume-request-message:" + consumeRequestMessage + ")...");
            }
            if (this.isDumpBinarioRichiesta()) {
                this.requestBout = new DumpByteArrayOutputStream(this.dumpBinario_soglia, this.dumpBinario_repositoryFile, this.idTransazione, "NullEcho-" + TipoMessaggio.RICHIESTA_USCITA_DUMP_BINARIO.getValue());
                this.emitDiagnosticStartDumpBinarioRichiestaUscita();
                if (this.isSoap && this.sbustamentoSoap) {
                    this.logger.debug("Sbustamento...");
                    TunnelSoapUtils.sbustamentoMessaggio((OpenSPCoop2Message)soapMessageRequest, (OutputStream)this.requestBout);
                } else {
                    this.requestMsg.writeTo((OutputStream)this.requestBout, consumeRequestMessage);
                }
                this.requestBout.flush();
                this.requestBout.close();
                this.dataRichiestaInoltrata = DateManager.getDate();
                this.dumpBinarioRichiestaUscita(this.requestBout, requestMessageType, contentTypeRichiesta, this.location, propertiesTrasportoDebug);
            } else {
                this.requestBout = new DumpByteArrayOutputStream(this.dumpBinario_soglia, this.dumpBinario_repositoryFile, this.idTransazione, "NullEcho-" + TipoMessaggio.RICHIESTA_USCITA_DUMP_BINARIO.getValue());
                if (this.isSoap && this.sbustamentoSoap) {
                    this.logger.debug("Sbustamento...");
                    TunnelSoapUtils.sbustamentoMessaggio((OpenSPCoop2Message)soapMessageRequest, (OutputStream)this.requestBout);
                } else {
                    this.requestMsg.writeTo((OutputStream)this.requestBout, consumeRequestMessage);
                }
                this.requestBout.flush();
                this.requestBout.close();
                this.dataRichiestaInoltrata = DateManager.getDate();
            }
            this.postOutRequest();
            this.preInResponse();
            NotifierInputStreamParams notifierInputStreamParams = null;
            if (this.preInResponseContext != null) {
                notifierInputStreamParams = this.preInResponseContext.getNotifierInputStreamParams();
            }
            this.messageTypeResponse = this.requestMsg.getMessageType();
            this.responseMsg = null;
            this.retrieveCryptoInfo(this.isSoap, pddContext);
            this.normalizeInputStreamResponse(readConnectionTimeout, readConnectionTimeoutConfigurazioneGlobale);
            this.initCheckContentTypeConfiguration();
            if (this.isDumpBinarioRisposta()) {
                this.dumpResponse(this.propertiesTrasportoRisposta);
            }
            if (this.isResponse != null) {
                this.emitDiagnosticResponseRead(this.isResponse);
            }
            OpenSPCoop2MessageFactory messageFactory = Utilities.getOpenspcoop2MessageFactory((Logger)this.logger.getLogger(), (OpenSPCoop2Message)this.requestMsg, (RequestInfo)this.requestInfo, (MessageRole)MessageRole.RESPONSE);
            OpenSPCoop2MessageParseResult pr = null;
            if (this.isResponse != null) {
                responseContext = new TransportResponseContext(this.logger.getLogger());
                responseContext.setCodiceTrasporto("" + this.codice);
                responseContext.setContentLength(this.contentLength);
                TransportUtils.addHeader((Map)this.propertiesTrasportoRisposta, (String)"Content-Type", (String)this.tipoRisposta);
                responseContext.setHeaders(this.propertiesTrasportoRisposta);
                pr = messageFactory.createMessage(this.messageTypeResponse, responseContext, this.isResponse, notifierInputStreamParams, this.openspcoopProperties.getAttachmentsProcessingMode());
            } else if (this.responseMsg == null) {
                responseContext = new TransportResponseContext(this.logger.getLogger());
                responseContext.setContentLength(0L);
                pr = messageFactory.createMessage(this.messageTypeResponse, responseContext, this.isResponse, notifierInputStreamParams, this.openspcoopProperties.getAttachmentsProcessingMode());
            }
            if (pr != null && pr.getParseException() != null) {
                this.getPddContext().addObject(Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO_PARSE_EXCEPTION, (Object)pr.getParseException());
            }
            if (this.responseMsg == null && pr != null) {
                this.responseMsg = pr.getMessage_throwParseException();
            }
            if (this.responseMsg != null) {
                this.contentLength = this.responseMsg.getIncomingMessageContentLength();
            }
        }
        catch (Exception e) {
            this.eccezioneProcessamento = e;
            String msgErrore = this.readExceptionMessageFromException(e);
            this.errore = this.generateErrorWithConnectorPrefix ? "rilevata anomalia; " + msgErrore : msgErrore;
            this.logger.error("Rilevata anomalia: " + msgErrore, (Throwable)e);
            return false;
        }
        return true;
    }

    private void setRequestHeader(String key, String value, ConnettoreLogger logger, Map<String, List<String>> propertiesTrasportoDebug) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add(value);
        this.setRequestHeader(key, list, logger, propertiesTrasportoDebug);
    }

    private void setRequestHeader(String key, List<String> values, ConnettoreLogger logger, Map<String, List<String>> propertiesTrasportoDebug) throws Exception {
        if (this.debug && values != null && !values.isEmpty()) {
            for (String value : values) {
                logger.info("Set propriet\u00e0 trasporto [" + key + "]=[" + value + "]", false);
            }
        }
        this.setRequestHeader(key, values, propertiesTrasportoDebug);
    }

    protected void setRequestHeader(String key, List<String> values) throws Exception {
        this.propertiesTrasportoRisposta.put(key, values);
    }

    public String getLocation() throws ConnettoreException {
        return LOCATION;
    }

    public void disconnect() throws ConnettoreException {
        try {
            if (this.requestBout != null) {
                this.requestBout.clearResources();
            }
        }
        catch (Exception e) {
            this.logger.error("Release resources failed: " + e.getMessage(), (Throwable)e);
        }
    }
}

