/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.modipa.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.protocol.modipa.config.ModISignalHubParamConfig;
import org.openspcoop2.protocol.sdk.ProtocolException;

public class ModISignalHubConfig {
    public static final String PROPERTY_PARAMS = "params";
    private List<ModISignalHubParamConfig> params;

    public ModISignalHubConfig copyNewInstance() {
        ModISignalHubConfig config = new ModISignalHubConfig();
        config.params = new ArrayList<ModISignalHubParamConfig>();
        if (this.params != null && !this.params.isEmpty()) {
            for (ModISignalHubParamConfig modISignalHubParamConfig : this.params) {
                config.params.add(modISignalHubParamConfig.copyNewInstance());
            }
        }
        return config;
    }

    private ModISignalHubConfig() {
    }

    ModISignalHubConfig(String prefix, Properties p) throws ProtocolException {
        String claimsP = ModISignalHubConfig.getProperty(prefix, p, PROPERTY_PARAMS, true);
        String[] tmp = claimsP.split(",");
        if (tmp == null || tmp.length <= 0) {
            throw new ProtocolException("Property 'params' empty");
        }
        this.params = new ArrayList<ModISignalHubParamConfig>();
        for (String c : tmp) {
            c = c.trim();
            this.params.add(new ModISignalHubParamConfig(prefix, c, p));
        }
        if (!this.params.isEmpty()) {
            this.verify();
        }
    }

    private void verify() throws ProtocolException {
        for (ModISignalHubParamConfig modISignalHubParamConfig : this.params) {
            String name = modISignalHubParamConfig.getNome();
            int count = 0;
            for (ModISignalHubParamConfig modISignalHubParamConfigCheck : this.params) {
                if (!name.equals(modISignalHubParamConfigCheck.getNome())) continue;
                ++count;
            }
            if (count <= true) continue;
            throw new ProtocolException("Property params.xx.nome=" + name + " defined more then one time (" + count + ")");
        }
    }

    static String getProperty(String prefixProperty, Properties p, String name, boolean required) throws ProtocolException {
        String tmp = p.getProperty(name);
        if (tmp != null) {
            return tmp.trim();
        }
        if (required) {
            throw new ProtocolException("Property '" + prefixProperty + "." + name + "' notFound");
        }
        return null;
    }

    static boolean getBooleanProperty(String prefixProperty, Properties p, String name, boolean required, boolean defaultValue) throws ProtocolException {
        String tmp = ModISignalHubConfig.getProperty(prefixProperty, p, name, required);
        if (tmp != null && StringUtils.isNotEmpty((String)tmp)) {
            try {
                return Boolean.valueOf(tmp);
            }
            catch (Exception t) {
                throw new ProtocolException("Boolean property '" + prefixProperty + "." + name + "' invalid (found value:[" + tmp + "]): " + t.getMessage(), (Throwable)t);
            }
        }
        return defaultValue;
    }

    static int getIntProperty(String prefixProperty, Properties p, String name, boolean required, int defaultValue) throws ProtocolException {
        String tmp = ModISignalHubConfig.getProperty(prefixProperty, p, name, required);
        if (tmp != null && StringUtils.isNotEmpty((String)tmp)) {
            try {
                return Integer.valueOf(tmp);
            }
            catch (Exception t) {
                throw new ProtocolException("Int property '" + prefixProperty + "." + name + "' invalid (found value:[" + tmp + "]): " + t.getMessage(), (Throwable)t);
            }
        }
        return defaultValue;
    }

    public List<ModISignalHubParamConfig> getClaims() {
        return this.params;
    }

    public void setClaims(List<ModISignalHubParamConfig> claims) {
        this.params = claims;
    }
}

