/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.v2_3.reader;

import it.link.pdd.tools.migrazione_govway.drivers.DriverConfigurazioneServiziOpenSPCoopV2;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaApplicativa;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaDelegata;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.ServizioApplicativo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Soggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.DriverConfigurazioneNotFound;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.FiltroRicercaPorteApplicative;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.FiltroRicercaPorteDelegate;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.FiltroRicercaServiziApplicativi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.FiltroRicercaSoggetti;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.IDriverConfigurazioneGet;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.db.DriverConfigurazioneDB;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDPortaApplicativaByNome;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDPortaDelegata;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDRuolo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizioApplicativo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteComune;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteSpecifica;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Ruolo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.TipologiaServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.DriverRegistroServiziNotFound;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicerca;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicercaAccordi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicercaRuoli;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicercaServizi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDriverRegistroServiziGet;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.db.DriverRegistroServiziDB;
import it.link.pdd.tools.migrazione_govway.properties.DatabaseProperties;
import it.link.pdd.tools.migrazione_govway.reader.IConfigurazioneServiziReader;
import it.link.pdd.tools.migrazione_govway.wrapper.ConnettoriProperty;
import it.link.pdd.tools.migrazione_govway.wrapper.PortaApplicativaV2Wrapper;
import it.link.pdd.tools.migrazione_govway.wrapper.PortaDelegataV2Wrapper;
import it.link.pdd.tools.migrazione_govway.wrapper.PortaDominioV2Wrapper;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class ConfigurazioneServiziReader
implements IConfigurazioneServiziReader {
    private IDriverRegistroServiziGet driverRegistro;
    private IDriverConfigurazioneGet driverConfigurazione;
    private DriverConfigurazioneServiziOpenSPCoopV2 driverAvanzato;
    private boolean dsMode;
    private Connection connection;

    public void closeConnection() throws SQLException {
        if (!this.dsMode) {
            this.connection.close();
        }
    }

    public ConfigurazioneServiziReader(DatabaseProperties initIn, DatabaseProperties initOut, Logger log) throws Exception {
        try {
            this.dsMode = initIn.isDataSourceMode();
            if (this.dsMode) {
                this.driverRegistro = new DriverRegistroServiziDB(initIn.getJndiName(), initIn.getJndiProp(), initIn.getTipoDatabase());
                this.driverConfigurazione = new DriverConfigurazioneDB(initIn.getJndiName(), initIn.getJndiProp(), initIn.getTipoDatabase());
                this.driverAvanzato = new DriverConfigurazioneServiziOpenSPCoopV2(initIn.getJndiName(), initIn.getJndiProp(), log, initIn.getTipoDatabase());
            } else {
                Class.forName(initIn.getDriverJDBC());
                this.connection = DriverManager.getConnection(initIn.getConnectionURL(), initIn.getUsername(), initIn.getPassword());
                this.driverRegistro = new DriverRegistroServiziDB(this.connection, log, initIn.getTipoDatabase());
                this.driverConfigurazione = new DriverConfigurazioneDB(this.connection, log, initIn.getTipoDatabase());
                this.driverAvanzato = new DriverConfigurazioneServiziOpenSPCoopV2(this.connection, log, initIn.getTipoDatabase());
            }
        }
        catch (Exception e) {
            log.error("Impossibile inizializzare il driver del database OpenSPCoop2 di partenza: " + e.getMessage(), (Throwable)e);
            throw new Exception("Impossibile inizializzare il driver del database OpenSPCoop2 di partenza: " + e.getMessage(), e);
        }
    }

    public List<PortaDominioV2Wrapper> findAllPdD() throws Exception {
        ArrayList<PortaDominioV2Wrapper> lst = new ArrayList<PortaDominioV2Wrapper>();
        List allId = null;
        try {
            allId = this.driverRegistro.getAllIdPorteDominio(new FiltroRicerca());
        }
        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            // empty catch block
        }
        if (allId != null) {
            for (String id : allId) {
                PortaDominioV2Wrapper wrapper = new PortaDominioV2Wrapper();
                wrapper.setPorta(this.driverRegistro.getPortaDominio(id));
                wrapper.setTipo(PortaDominioV2Wrapper.TIPO.fromValue((String)this.driverAvanzato.getTipoPortaDominio(id)));
                lst.add(wrapper);
            }
        }
        return lst;
    }

    public List<it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto> findAllSoggettiRegistro() throws Exception {
        ArrayList<it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto> lst = new ArrayList<it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto>();
        List allId = null;
        try {
            allId = this.driverRegistro.getAllIdSoggetti(new it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicercaSoggetti());
        }
        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            // empty catch block
        }
        if (allId != null) {
            for (IDSoggetto id : allId) {
                lst.add(this.driverRegistro.getSoggetto(id));
            }
        }
        return lst;
    }

    public List<AccordoServizioParteComune> findAllAccordiParteComuneNonComposti() throws Exception {
        ArrayList<AccordoServizioParteComune> lst = new ArrayList<AccordoServizioParteComune>();
        try {
            List allId = null;
            try {
                allId = this.driverRegistro.getAllIdAccordiServizioParteComune(new FiltroRicercaAccordi());
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
            if (allId != null) {
                for (IDAccordo id : allId) {
                    AccordoServizioParteComune accordo = ((DriverRegistroServiziDB)this.driverRegistro).getAccordoServizioParteComune(id, true);
                    if (accordo.getServizioComposto() != null) continue;
                    lst.add(accordo);
                }
            }
        }
        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            // empty catch block
        }
        return lst;
    }

    public List<AccordoServizioParteSpecifica> findAllServizi(List<IDAccordo> lstIds) throws Exception {
        return this.findAllServizi(lstIds, TipologiaServizio.NORMALE);
    }

    public List<AccordoServizioParteSpecifica> findAllServiziCorrelati(List<IDAccordo> lstIds) throws Exception {
        return this.findAllServizi(lstIds, TipologiaServizio.CORRELATO);
    }

    private List<AccordoServizioParteSpecifica> findAllServizi(List<IDAccordo> lstIds, TipologiaServizio tipologia) throws Exception {
        ArrayList<AccordoServizioParteSpecifica> lst = new ArrayList<AccordoServizioParteSpecifica>();
        for (IDAccordo idAccordo : lstIds) {
            FiltroRicercaServizi filtro = new FiltroRicercaServizi();
            filtro.setIdAccordo(idAccordo);
            filtro.setTipologiaServizio(tipologia.getValue());
            try {
                List allId = this.driverRegistro.getAllIdServizi(filtro);
                if (allId == null) continue;
                for (IDServizio id : allId) {
                    lst.add(((DriverRegistroServiziDB)this.driverRegistro).getAccordoServizioParteSpecifica(id, true));
                }
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            }
        }
        return lst;
    }

    public List<AccordoServizioParteComune> findAllAccordiParteComuneComposti() throws Exception {
        ArrayList<AccordoServizioParteComune> lst = new ArrayList<AccordoServizioParteComune>();
        try {
            List allId = this.driverRegistro.getAllIdAccordiServizioParteComune(new FiltroRicercaAccordi());
            if (allId != null) {
                for (IDAccordo id : allId) {
                    AccordoServizioParteComune accordo = ((DriverRegistroServiziDB)this.driverRegistro).getAccordoServizioParteComune(id, true);
                    if (accordo.getServizioComposto() == null) continue;
                    lst.add(accordo);
                }
            }
        }
        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            // empty catch block
        }
        return lst;
    }

    public List<AccordoCooperazione> findAllAccordiCooperazione() throws Exception {
        ArrayList<AccordoCooperazione> lst = new ArrayList<AccordoCooperazione>();
        try {
            List allId = this.driverRegistro.getAllIdAccordiCooperazione(new FiltroRicercaAccordi());
            if (allId != null) {
                for (IDAccordoCooperazione id : allId) {
                    lst.add(((DriverRegistroServiziDB)this.driverRegistro).getAccordoCooperazione(id, true));
                }
            }
        }
        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            // empty catch block
        }
        return lst;
    }

    public List<Soggetto> findAllSoggettiConfig() throws Exception {
        ArrayList<Soggetto> lst = new ArrayList<Soggetto>();
        try {
            FiltroRicercaSoggetti filtro = new FiltroRicercaSoggetti();
            List allId = this.driverConfigurazione.getAllIdSoggetti(filtro);
            if (allId != null) {
                for (IDSoggetto id : allId) {
                    lst.add(this.driverConfigurazione.getSoggetto(id));
                }
            }
        }
        catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
            // empty catch block
        }
        return lst;
    }

    public List<ServizioApplicativo> findAllServiziApplicativi() throws Exception {
        ArrayList<ServizioApplicativo> lst = new ArrayList<ServizioApplicativo>();
        try {
            List allId = this.driverConfigurazione.getAllIdServiziApplicativi(new FiltroRicercaServiziApplicativi());
            if (allId != null) {
                for (IDServizioApplicativo id : allId) {
                    lst.add(this.driverConfigurazione.getServizioApplicativo(id));
                }
            }
        }
        catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
            // empty catch block
        }
        return lst;
    }

    public List<PortaApplicativaV2Wrapper> findAllPorteApplicative() throws Exception {
        ArrayList<PortaApplicativaV2Wrapper> lst = new ArrayList<PortaApplicativaV2Wrapper>();
        try {
            List allId = this.driverConfigurazione.getAllIdPorteApplicative(new FiltroRicercaPorteApplicative());
            if (allId != null) {
                for (IDPortaApplicativaByNome id : allId) {
                    PortaApplicativaV2Wrapper wrapper = new PortaApplicativaV2Wrapper();
                    PortaApplicativa pa = this.driverConfigurazione.getPortaApplicativa(id);
                    wrapper.setPortaApplicativa(pa);
                    wrapper.setCorrelazioneRisposta(this.driverAvanzato.getPACorrelazioneRisposta(pa.getId().longValue()));
                    lst.add(wrapper);
                }
            }
        }
        catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
            // empty catch block
        }
        return lst;
    }

    public List<PortaDelegataV2Wrapper> findAllPorteDelegate() throws Exception {
        ArrayList<PortaDelegataV2Wrapper> lst = new ArrayList<PortaDelegataV2Wrapper>();
        try {
            List allId = this.driverConfigurazione.getAllIdPorteDelegate(new FiltroRicercaPorteDelegate());
            if (allId != null) {
                for (IDPortaDelegata id : allId) {
                    PortaDelegataV2Wrapper wrapper = new PortaDelegataV2Wrapper();
                    PortaDelegata pd = this.driverConfigurazione.getPortaDelegata(id);
                    wrapper.setPortaDelegata(pd);
                    wrapper.setCorrelazioneRisposta(this.driverAvanzato.getPDCorrelazioneRisposta(pd.getId().longValue()));
                    lst.add(wrapper);
                }
            }
        }
        catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
            // empty catch block
        }
        return lst;
    }

    public List<Ruolo> findAllRuoli() throws Exception {
        ArrayList<Ruolo> lst = new ArrayList<Ruolo>();
        try {
            List allId = this.driverRegistro.getAllIdRuoli(new FiltroRicercaRuoli());
            if (allId != null) {
                for (IDRuolo id : allId) {
                    Ruolo ruolo = this.driverRegistro.getRuolo(id);
                    lst.add(ruolo);
                }
            }
        }
        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            // empty catch block
        }
        return lst;
    }

    public List<IDAccordo> findIdAccordiNonComposti() throws Exception {
        return this.findIdAccordi(false);
    }

    public List<IDAccordo> findIdAccordiComposti() throws Exception {
        return this.findIdAccordi(true);
    }

    private List<IDAccordo> findIdAccordi(boolean servizioComposto) throws Exception {
        List<Object> lst = new ArrayList<IDAccordo>();
        try {
            FiltroRicercaAccordi filtroRicerca = new FiltroRicercaAccordi();
            filtroRicerca.setServizioComposto(Boolean.valueOf(servizioComposto));
            lst = this.driverRegistro.getAllIdAccordiServizioParteComune(filtroRicerca);
        }
        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            // empty catch block
        }
        return lst;
    }

    public List<ConnettoriProperty> findAllConnettoriProperties() throws Exception {
        ArrayList<ConnettoriProperty> lst = new ArrayList<ConnettoriProperty>();
        List ids = this.driverAvanzato.findAllIdConnettoreProperties();
        for (String id : ids) {
            lst.add(this.driverAvanzato.getConnettoreProperties(id));
        }
        return lst;
    }
}

