/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.utils.xml;

import java.util.List;
import java.util.Vector;
import org.openspcoop.utils.xml.XMLException;
import org.openspcoop.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDUtils {
    public static boolean isXSDSchema(byte[] xsd) throws XMLException {
        try {
            if (!XMLUtils.isDocument(xsd)) {
                return false;
            }
            Document docXML = XMLUtils.newDocument(xsd);
            Element elemXML = docXML.getDocumentElement();
            return XSDUtils.isXSDSchema(elemXML);
        }
        catch (Exception e) {
            throw new XMLException(e.getMessage(), e);
        }
    }

    public static boolean isXSDSchema(Document xsd) throws XMLException {
        Element elemXML = xsd.getDocumentElement();
        return XSDUtils.isXSDSchema(elemXML);
    }

    public static boolean isXSDSchema(Element xsd) throws XMLException {
        return XSDUtils.isXSDSchema((Node)xsd);
    }

    public static boolean isXSDSchema(Node xsd) throws XMLException {
        try {
            if (xsd == null) {
                throw new Exception("Schema xsd da verificare non definito");
            }
            if (!"schema".equals(xsd.getLocalName())) {
                return false;
            }
            return "http://www.w3.org/2001/XMLSchema".equals(xsd.getNamespaceURI());
        }
        catch (Exception e) {
            throw new XMLException(e.getMessage(), e);
        }
    }

    public static String getTargetNamespace(byte[] xsd) throws XMLException {
        try {
            if (!XMLUtils.isDocument(xsd)) {
                throw new Exception("Schema xsd non e' un documento valido");
            }
            Document docXML = XMLUtils.newDocument(xsd);
            Element elemXML = docXML.getDocumentElement();
            return XSDUtils.getTargetNamespace(elemXML);
        }
        catch (Exception e) {
            throw new XMLException(e.getMessage(), e);
        }
    }

    public static String getTargetNamespace(Document xsd) throws XMLException {
        Element elemXML = xsd.getDocumentElement();
        return XSDUtils.getTargetNamespace(elemXML);
    }

    public static String getTargetNamespace(Element xsd) throws XMLException {
        return XSDUtils.getTargetNamespace((Node)xsd);
    }

    public static String getTargetNamespace(Node xsd) throws XMLException {
        try {
            if (xsd == null) {
                throw new Exception("Schema xsd non e' un documento valido");
            }
            if (!"schema".equals(xsd.getLocalName())) {
                throw new Exception("Root element non e' uno schema xsd (" + xsd.getLocalName() + ")");
            }
            String targetNamespace = XMLUtils.getAttributeValue(xsd, "targetNamespace");
            return targetNamespace;
        }
        catch (Exception e) {
            throw new XMLException(e.getMessage(), e);
        }
    }

    public static String getImportNamespace(Node xsd) throws XMLException {
        try {
            if (xsd == null) {
                throw new Exception("Non e' un import valido");
            }
            if (!"import".equals(xsd.getLocalName())) {
                throw new Exception("Root element non e' un import di uno schema xsd (" + xsd.getLocalName() + ")");
            }
            String targetNamespace = XMLUtils.getAttributeValue(xsd, "namespace");
            return targetNamespace;
        }
        catch (Exception e) {
            throw new XMLException(e.getMessage(), e);
        }
    }

    public static String getImportSchemaLocation(Node xsd) throws XMLException {
        try {
            if (xsd == null) {
                throw new Exception("Non e' un import valido");
            }
            if (!"import".equals(xsd.getLocalName())) {
                throw new Exception("Root element non e' un import di uno schema xsd (" + xsd.getLocalName() + ")");
            }
            String targetNamespace = XMLUtils.getAttributeValue(xsd, "schemaLocation");
            return targetNamespace;
        }
        catch (Exception e) {
            throw new XMLException(e.getMessage(), e);
        }
    }

    public static String getIncludeSchemaLocation(Node xsd) throws XMLException {
        try {
            if (xsd == null) {
                throw new Exception("Non e' un import valido");
            }
            if (!"include".equals(xsd.getLocalName())) {
                throw new Exception("Root element non e' un include di uno schema xsd (" + xsd.getLocalName() + ")");
            }
            String targetNamespace = XMLUtils.getAttributeValue(xsd, "schemaLocation");
            return targetNamespace;
        }
        catch (Exception e) {
            throw new XMLException(e.getMessage(), e);
        }
    }

    public static List<Node> readImportsAndIncludes(Document xsd) throws XMLException {
        return XSDUtils.readImportsIncludes(null, xsd, null, true, true);
    }

    public static List<Node> readImports(Document xsd) throws XMLException {
        return XSDUtils.readImportsIncludes(null, xsd, null, true, false);
    }

    public static List<Node> readIncludes(Document xsd) throws XMLException {
        return XSDUtils.readImportsIncludes(null, xsd, null, false, true);
    }

    public static List<Node> readImportsAndIncludes(Element xsd) throws XMLException {
        return XSDUtils.readImportsIncludes(null, null, xsd, true, true);
    }

    public static List<Node> readImports(Element xsd) throws XMLException {
        return XSDUtils.readImportsIncludes(null, null, xsd, true, false);
    }

    public static List<Node> readIncludes(Element xsd) throws XMLException {
        return XSDUtils.readImportsIncludes(null, null, xsd, false, true);
    }

    public static List<Node> readImportsAndIncludes(String targetNamespaceSchema, Element xsd) throws XMLException {
        return XSDUtils.readImportsIncludes(targetNamespaceSchema, null, xsd, true, true);
    }

    public static List<Node> readImports(String targetNamespaceSchema, Element xsd) throws XMLException {
        return XSDUtils.readImportsIncludes(targetNamespaceSchema, null, xsd, true, false);
    }

    public static List<Node> readIncludes(String targetNamespaceSchema, Element xsd) throws XMLException {
        return XSDUtils.readImportsIncludes(targetNamespaceSchema, null, xsd, false, true);
    }

    public static List<Node> readImportsAndIncludes(Node xsd) throws XMLException {
        return XSDUtils.readImportsIncludes(null, null, xsd, true, true);
    }

    public static List<Node> readImports(Node xsd) throws XMLException {
        return XSDUtils.readImportsIncludes(null, null, xsd, true, false);
    }

    public static List<Node> readIncludes(Node xsd) throws XMLException {
        return XSDUtils.readImportsIncludes(null, null, xsd, false, true);
    }

    public static List<Node> readImportsAndIncludes(String targetNamespaceSchema, Node xsd) throws XMLException {
        return XSDUtils.readImportsIncludes(targetNamespaceSchema, null, xsd, true, true);
    }

    public static List<Node> readImports(String targetNamespaceSchema, Node xsd) throws XMLException {
        return XSDUtils.readImportsIncludes(targetNamespaceSchema, null, xsd, true, false);
    }

    public static List<Node> readIncludes(String targetNamespaceSchema, Node xsd) throws XMLException {
        return XSDUtils.readImportsIncludes(targetNamespaceSchema, null, xsd, false, true);
    }

    private static List<Node> readImportsIncludes(String targetNamespaceSchema, Document xsdD, Node xsdE, boolean imports, boolean includes) throws XMLException {
        try {
            Vector<Node> nodes = new Vector<Node>();
            NodeList list = null;
            list = xsdD != null ? xsdD.getChildNodes() : xsdE.getChildNodes();
            if (list != null) {
                for (int i = 0; i < list.getLength(); ++i) {
                    Node child = list.item(i);
                    if ("schema".equals(child.getLocalName())) {
                        NodeList listDefinition;
                        if (targetNamespaceSchema == null) {
                            try {
                                targetNamespaceSchema = XSDUtils.getTargetNamespace(child);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        if ((listDefinition = child.getChildNodes()) == null) continue;
                        for (int j = 0; j < listDefinition.getLength(); ++j) {
                            Node childDefinition = listDefinition.item(j);
                            if (imports && "import".equals(childDefinition.getLocalName())) {
                                childDefinition.setUserData("TargetNamespaceSchema", targetNamespaceSchema, null);
                                nodes.add(childDefinition);
                            }
                            if (!includes || !"include".equals(childDefinition.getLocalName())) continue;
                            childDefinition.setUserData("TargetNamespaceSchema", targetNamespaceSchema, null);
                            nodes.add(childDefinition);
                        }
                        continue;
                    }
                    if ("import".equals(child.getLocalName())) {
                        if (!imports) continue;
                        child.setUserData("TargetNamespaceSchema", targetNamespaceSchema, null);
                        nodes.add(child);
                        continue;
                    }
                    if (!"include".equals(child.getLocalName()) || !includes) continue;
                    child.setUserData("TargetNamespaceSchema", targetNamespaceSchema, null);
                    nodes.add(child);
                }
            }
            return nodes;
        }
        catch (Exception e) {
            throw new XMLException("Riscontrato errore durante la lettura dello schema: " + e.getMessage(), e);
        }
    }

    public static void removeImport(Document xsd, Node importNode) {
        XSDUtils.removeImports_engine(xsd, null, true, false, importNode);
    }

    public static void removeInclude(Document xsd, Node includeNode) {
        XSDUtils.removeImports_engine(xsd, null, false, true, includeNode);
    }

    public static void removeImport(Element xsd, Node importNode) {
        XSDUtils.removeImports_engine(null, xsd, true, false, importNode);
    }

    public static void removeInclude(Element xsd, Node includeNode) {
        XSDUtils.removeImports_engine(null, xsd, false, true, includeNode);
    }

    public static void removeImport(Node xsd, Node importNode) {
        XSDUtils.removeImports_engine(null, xsd, true, false, importNode);
    }

    public static void removeInclude(Node xsd, Node includeNode) {
        XSDUtils.removeImports_engine(null, xsd, false, true, includeNode);
    }

    public static void removeImports(Document xsd) {
        XSDUtils.removeImports_engine(xsd, null, true, false, null);
    }

    public static void removeIncludes(Document xsd) {
        XSDUtils.removeImports_engine(xsd, null, false, true, null);
    }

    public static void removeImportsAndIncludes(Document xsd) {
        XSDUtils.removeImports_engine(xsd, null, true, true, null);
    }

    public static void removeImports(Element xsd) {
        XSDUtils.removeImports_engine(null, xsd, true, false, null);
    }

    public static void removeIncludes(Element xsd) {
        XSDUtils.removeImports_engine(null, xsd, false, true, null);
    }

    public static void removeImportsAndIncludes(Element xsd) {
        XSDUtils.removeImports_engine(null, xsd, true, true, null);
    }

    public static void removeImports(Node xsd) {
        XSDUtils.removeImports_engine(null, xsd, true, false, null);
    }

    public static void removeIncludes(Node xsd) {
        XSDUtils.removeImports_engine(null, xsd, false, true, null);
    }

    public static void removeImportsAndIncludes(Node xsd) {
        XSDUtils.removeImports_engine(null, xsd, true, true, null);
    }

    private static void removeImports_engine(Document xsdD, Node xsdE, boolean imports, boolean includes, Node importIncludeNode) {
        NodeList list = null;
        list = xsdD != null ? xsdD.getChildNodes() : xsdE.getChildNodes();
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node child = list.item(i);
                if ("schema".equals(child.getLocalName())) {
                    NodeList listDefinition = child.getChildNodes();
                    if (listDefinition == null) continue;
                    for (int j = 0; j < listDefinition.getLength(); ++j) {
                        Node childDefinition = listDefinition.item(j);
                        if (imports && "import".equals(childDefinition.getLocalName())) {
                            if (importIncludeNode == null) {
                                child.removeChild(childDefinition);
                            } else if (importIncludeNode.equals(childDefinition)) {
                                child.removeChild(childDefinition);
                            }
                        }
                        if (!includes || !"include".equals(childDefinition.getLocalName())) continue;
                        if (importIncludeNode == null) {
                            child.removeChild(childDefinition);
                            continue;
                        }
                        if (!importIncludeNode.equals(childDefinition)) continue;
                        child.removeChild(childDefinition);
                    }
                    continue;
                }
                if ("import".equals(child.getLocalName())) {
                    if (!imports) continue;
                    if (importIncludeNode == null) {
                        if (xsdD != null) {
                            xsdD.removeChild(child);
                            continue;
                        }
                        xsdE.removeChild(child);
                        continue;
                    }
                    if (!importIncludeNode.equals(child)) continue;
                    if (xsdD != null) {
                        xsdD.removeChild(child);
                        continue;
                    }
                    xsdE.removeChild(child);
                    continue;
                }
                if (!"include".equals(child.getLocalName()) || !includes) continue;
                if (importIncludeNode == null) {
                    if (xsdD != null) {
                        xsdD.removeChild(child);
                        continue;
                    }
                    xsdE.removeChild(child);
                    continue;
                }
                if (!importIncludeNode.equals(child)) continue;
                if (xsdD != null) {
                    xsdD.removeChild(child);
                    continue;
                }
                xsdE.removeChild(child);
            }
        }
    }
}

