/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.utils.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.openspcoop.utils.UtilsException;
import org.openspcoop.utils.xml.XMLErrorHandler;
import org.openspcoop.utils.xml.XMLErrorListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLUtils {
    public static DocumentBuilderFactory documentFactory = null;
    public static TransformerFactory transformerFactory = null;

    public static synchronized void initBuilder() throws ParserConfigurationException {
        if (documentFactory == null) {
            documentFactory = DocumentBuilderFactory.newInstance();
            documentFactory.setNamespaceAware(true);
        }
    }

    public static synchronized void initTransformer() throws TransformerConfigurationException {
        if (transformerFactory == null) {
            transformerFactory = TransformerFactory.newInstance();
        }
    }

    public static DocumentBuilderFactory getDocumentFactory() throws ParserConfigurationException {
        if (documentFactory == null) {
            XMLUtils.initBuilder();
        }
        return documentFactory;
    }

    public static TransformerFactory getTransformerFactory() throws TransformerConfigurationException {
        if (transformerFactory == null) {
            XMLUtils.initTransformer();
        }
        return transformerFactory;
    }

    public static Document getAsDocument(Element element) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        return XMLUtils.newDocument(XMLUtils.toByteArray(element));
    }

    public static Document getAsDocument(Element element, ErrorHandler errorHandler) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        return XMLUtils.newDocument(XMLUtils.toByteArray(element), errorHandler);
    }

    public static Document getAsDocument(Node Node2) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        return XMLUtils.newDocument(XMLUtils.toByteArray(Node2));
    }

    public static Document getAsDocument(Node Node2, ErrorHandler errorHandler) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        return XMLUtils.newDocument(XMLUtils.toByteArray(Node2), errorHandler);
    }

    public static Document newDocument() throws IOException, SAXException, ParserConfigurationException {
        return XMLUtils.newDocument_engine(null);
    }

    public static Document newDocument(ErrorHandler errorHandler) throws IOException, SAXException, ParserConfigurationException {
        return XMLUtils.newDocument_engine(errorHandler);
    }

    private static Document newDocument_engine(ErrorHandler errorHandler) throws IOException, SAXException, ParserConfigurationException {
        if (documentFactory == null) {
            XMLUtils.initBuilder();
        }
        DocumentBuilder documentBuilder = documentFactory.newDocumentBuilder();
        documentBuilder.setErrorHandler(errorHandler);
        return documentBuilder.newDocument();
    }

    public static Document newDocument(byte[] xml) throws IOException, SAXException, ParserConfigurationException {
        return XMLUtils.newDocument(xml, (ErrorHandler)new XMLErrorHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document newDocument(byte[] xml, ErrorHandler errorHandler) throws IOException, SAXException, ParserConfigurationException {
        if (documentFactory == null) {
            XMLUtils.initBuilder();
        }
        ByteArrayInputStream bin = null;
        try {
            bin = new ByteArrayInputStream(xml);
            Document document = XMLUtils.newDocument(bin, errorHandler);
            return document;
        }
        finally {
            if (bin != null) {
                try {
                    bin.close();
                }
                catch (Exception eClose) {}
            }
        }
    }

    public static Document newDocument(InputStream is) throws IOException, SAXException, ParserConfigurationException {
        return XMLUtils.newDocument(is, (ErrorHandler)new XMLErrorHandler());
    }

    public static Document newDocument(InputStream is, ErrorHandler errorHandler) throws IOException, SAXException, ParserConfigurationException {
        if (documentFactory == null) {
            XMLUtils.initBuilder();
        }
        DocumentBuilder documentBuilder = documentFactory.newDocumentBuilder();
        documentBuilder.setErrorHandler(errorHandler);
        return documentBuilder.parse(is);
    }

    public static Document newDocument(File f) throws IOException, SAXException, ParserConfigurationException {
        return XMLUtils.newDocument(f, (ErrorHandler)new XMLErrorHandler());
    }

    public static Document newDocument(File f, ErrorHandler errorHandler) throws IOException, SAXException, ParserConfigurationException {
        if (documentFactory == null) {
            XMLUtils.initBuilder();
        }
        DocumentBuilder documentBuilder = documentFactory.newDocumentBuilder();
        documentBuilder.setErrorHandler(errorHandler);
        return documentBuilder.parse(f);
    }

    public static Document newDocument(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        return XMLUtils.newDocument(is, (ErrorHandler)new XMLErrorHandler());
    }

    public static Document newDocument(InputSource is, ErrorHandler errorHandler) throws IOException, SAXException, ParserConfigurationException {
        if (documentFactory == null) {
            XMLUtils.initBuilder();
        }
        DocumentBuilder documentBuilder = documentFactory.newDocumentBuilder();
        documentBuilder.setErrorHandler(errorHandler);
        return documentBuilder.parse(is);
    }

    public static Element newElement() throws IOException, SAXException, ParserConfigurationException {
        return XMLUtils.newElement_engine(null);
    }

    public static Element newElement(ErrorHandler errorHandler) throws IOException, SAXException, ParserConfigurationException {
        return XMLUtils.newElement_engine(errorHandler);
    }

    private static Element newElement_engine(ErrorHandler errorHandler) throws IOException, SAXException, ParserConfigurationException {
        if (documentFactory == null) {
            XMLUtils.initBuilder();
        }
        DocumentBuilder documentBuilder = documentFactory.newDocumentBuilder();
        documentBuilder.setErrorHandler(errorHandler);
        return documentBuilder.newDocument().getDocumentElement();
    }

    public static Element newElement(byte[] xml) throws IOException, SAXException, ParserConfigurationException {
        return XMLUtils.newDocument(xml).getDocumentElement();
    }

    public static Element newElement(byte[] xml, ErrorHandler errorHandler) throws IOException, SAXException, ParserConfigurationException {
        return XMLUtils.newDocument(xml, errorHandler).getDocumentElement();
    }

    public static Element newElement(InputStream is) throws IOException, SAXException, ParserConfigurationException {
        return XMLUtils.newDocument(is).getDocumentElement();
    }

    public static Element newElement(InputStream is, ErrorHandler errorHandler) throws IOException, SAXException, ParserConfigurationException {
        return XMLUtils.newDocument(is, errorHandler).getDocumentElement();
    }

    public static Element newElement(File f) throws IOException, SAXException, ParserConfigurationException {
        return XMLUtils.newDocument(f).getDocumentElement();
    }

    public static Element newElement(File f, ErrorHandler errorHandler) throws IOException, SAXException, ParserConfigurationException {
        return XMLUtils.newDocument(f, errorHandler).getDocumentElement();
    }

    public static Element newElement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        return XMLUtils.newDocument(is).getDocumentElement();
    }

    public static Element newElement(InputSource is, ErrorHandler errorHandler) throws IOException, SAXException, ParserConfigurationException {
        return XMLUtils.newDocument(is, errorHandler).getDocumentElement();
    }

    public static byte[] toByteArray(Document doc) throws TransformerException, IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        XMLUtils.writeTo(doc, (OutputStream)bout);
        bout.close();
        return bout.toByteArray();
    }

    public static byte[] toByteArray(Document doc, boolean omitXMLDeclaration) throws TransformerException, IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        XMLUtils.writeTo(doc, (OutputStream)bout, omitXMLDeclaration);
        bout.close();
        return bout.toByteArray();
    }

    public static byte[] toByteArray(Element element) throws TransformerException, IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        XMLUtils.writeTo(element, (OutputStream)bout);
        bout.close();
        return bout.toByteArray();
    }

    public static byte[] toByteArray(Element element, boolean omitXMLDeclaration) throws TransformerException, IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        XMLUtils.writeTo(element, (OutputStream)bout, omitXMLDeclaration);
        bout.close();
        return bout.toByteArray();
    }

    public static byte[] toByteArray(Node node) throws TransformerException, IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        XMLUtils.writeTo(node, (OutputStream)bout);
        bout.close();
        return bout.toByteArray();
    }

    public static byte[] toByteArray(Node node, boolean omitXMLDeclaration) throws TransformerException, IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        XMLUtils.writeTo(node, (OutputStream)bout, omitXMLDeclaration);
        bout.close();
        return bout.toByteArray();
    }

    public static String toString(Document doc) throws TransformerException, IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        XMLUtils.writeTo(doc, (OutputStream)bout);
        bout.close();
        return bout.toString();
    }

    public static String toString(Document doc, boolean omitXMLDeclaration) throws TransformerException, IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        XMLUtils.writeTo(doc, (OutputStream)bout, omitXMLDeclaration);
        bout.close();
        return bout.toString();
    }

    public static String toString(Element element) throws TransformerException, IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        XMLUtils.writeTo(element, (OutputStream)bout);
        bout.close();
        return bout.toString();
    }

    public static String toString(Element element, boolean omitXMLDeclaration) throws TransformerException, IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        XMLUtils.writeTo(element, (OutputStream)bout, omitXMLDeclaration);
        bout.close();
        return bout.toString();
    }

    public static String toString(Node node) throws TransformerException, IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        XMLUtils.writeTo(node, (OutputStream)bout);
        bout.close();
        return bout.toString();
    }

    public static String toString(Node node, boolean omitXMLDeclaration) throws TransformerException, IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        XMLUtils.writeTo(node, (OutputStream)bout, omitXMLDeclaration);
        bout.close();
        return bout.toString();
    }

    public static void writeTo(Document doc, OutputStream os) throws TransformerException, IOException {
        XMLUtils.writeNodeTo((Node)doc, os, (ErrorListener)new XMLErrorListener(), false);
    }

    public static void writeTo(Document doc, OutputStream os, ErrorListener errorListener) throws TransformerException, IOException {
        XMLUtils.writeNodeTo((Node)doc, os, errorListener, false);
    }

    public static void writeTo(Document doc, OutputStream os, boolean omitXMLDeclaration) throws TransformerException, IOException {
        XMLUtils.writeNodeTo((Node)doc, os, (ErrorListener)new XMLErrorListener(), omitXMLDeclaration);
    }

    public static void writeTo(Document doc, OutputStream os, ErrorListener errorListener, boolean omitXMLDeclaration) throws TransformerException, IOException {
        XMLUtils.writeNodeTo((Node)doc, os, errorListener, omitXMLDeclaration);
    }

    public static void writeTo(Document doc, Writer writer) throws TransformerException, IOException {
        XMLUtils.writeNodeTo((Node)doc, writer, (ErrorListener)new XMLErrorListener(), false);
    }

    public static void writeTo(Document doc, Writer writer, ErrorListener errorListener) throws TransformerException, IOException {
        XMLUtils.writeNodeTo((Node)doc, writer, errorListener, false);
    }

    public static void writeTo(Document doc, Writer writer, boolean omitXMLDeclaration) throws TransformerException, IOException {
        XMLUtils.writeNodeTo((Node)doc, writer, (ErrorListener)new XMLErrorListener(), omitXMLDeclaration);
    }

    public static void writeTo(Document doc, Writer writer, ErrorListener errorListener, boolean omitXMLDeclaration) throws TransformerException, IOException {
        XMLUtils.writeNodeTo((Node)doc, writer, errorListener, omitXMLDeclaration);
    }

    public static void writeTo(Document doc, File file) throws TransformerException, IOException {
        XMLUtils.writeNodeTo((Node)doc, file, (ErrorListener)new XMLErrorListener(), false);
    }

    public static void writeTo(Document doc, File file, ErrorListener errorListener) throws TransformerException, IOException {
        XMLUtils.writeNodeTo((Node)doc, file, errorListener, false);
    }

    public static void writeTo(Document doc, File file, boolean omitXMLDeclaration) throws TransformerException, IOException {
        XMLUtils.writeNodeTo((Node)doc, file, (ErrorListener)new XMLErrorListener(), omitXMLDeclaration);
    }

    public static void writeTo(Document doc, File file, ErrorListener errorListener, boolean omitXMLDeclaration) throws TransformerException, IOException {
        XMLUtils.writeNodeTo((Node)doc, file, errorListener, omitXMLDeclaration);
    }

    public static void writeTo(Element element, OutputStream os) throws TransformerException, IOException {
        XMLUtils.writeNodeTo((Node)element, os, (ErrorListener)new XMLErrorListener(), false);
    }

    public static void writeTo(Element element, OutputStream os, ErrorListener errorListener) throws TransformerException, IOException {
        XMLUtils.writeNodeTo((Node)element, os, errorListener, false);
    }

    public static void writeTo(Element element, OutputStream os, boolean omitXMLDeclaration) throws TransformerException, IOException {
        XMLUtils.writeNodeTo((Node)element, os, (ErrorListener)new XMLErrorListener(), omitXMLDeclaration);
    }

    public static void writeTo(Element element, OutputStream os, ErrorListener errorListener, boolean omitXMLDeclaration) throws TransformerException, IOException {
        XMLUtils.writeNodeTo((Node)element, os, errorListener, omitXMLDeclaration);
    }

    public static void writeTo(Element element, Writer writer) throws TransformerException, IOException {
        XMLUtils.writeNodeTo((Node)element, writer, (ErrorListener)new XMLErrorListener(), false);
    }

    public static void writeTo(Element element, Writer writer, ErrorListener errorListener) throws TransformerException, IOException {
        XMLUtils.writeNodeTo((Node)element, writer, errorListener, false);
    }

    public static void writeTo(Element element, Writer writer, boolean omitXMLDeclaration) throws TransformerException, IOException {
        XMLUtils.writeNodeTo((Node)element, writer, (ErrorListener)new XMLErrorListener(), omitXMLDeclaration);
    }

    public static void writeTo(Element element, Writer writer, ErrorListener errorListener, boolean omitXMLDeclaration) throws TransformerException, IOException {
        XMLUtils.writeNodeTo((Node)element, writer, errorListener, omitXMLDeclaration);
    }

    public static void writeTo(Element element, File file) throws TransformerException, IOException {
        XMLUtils.writeNodeTo((Node)element, file, (ErrorListener)new XMLErrorListener(), false);
    }

    public static void writeTo(Element element, File file, ErrorListener errorListener) throws TransformerException, IOException {
        XMLUtils.writeNodeTo((Node)element, file, errorListener, false);
    }

    public static void writeTo(Element element, File file, boolean omitXMLDeclaration) throws TransformerException, IOException {
        XMLUtils.writeNodeTo((Node)element, file, (ErrorListener)new XMLErrorListener(), omitXMLDeclaration);
    }

    public static void writeTo(Element element, File file, ErrorListener errorListener, boolean omitXMLDeclaration) throws TransformerException, IOException {
        XMLUtils.writeNodeTo((Node)element, file, errorListener, omitXMLDeclaration);
    }

    public static void writeTo(Node node, OutputStream os) throws TransformerException, IOException {
        XMLUtils.writeNodeTo(node, os, (ErrorListener)new XMLErrorListener(), false);
    }

    public static void writeTo(Node node, OutputStream os, ErrorListener errorListener) throws TransformerException, IOException {
        XMLUtils.writeNodeTo(node, os, errorListener, false);
    }

    public static void writeTo(Node node, OutputStream os, boolean omitXMLDeclaration) throws TransformerException, IOException {
        XMLUtils.writeNodeTo(node, os, (ErrorListener)new XMLErrorListener(), omitXMLDeclaration);
    }

    public static void writeTo(Node node, OutputStream os, ErrorListener errorListener, boolean omitXMLDeclaration) throws TransformerException, IOException {
        XMLUtils.writeNodeTo(node, os, errorListener, omitXMLDeclaration);
    }

    public static void writeTo(Node node, Writer writer) throws TransformerException, IOException {
        XMLUtils.writeNodeTo(node, writer, (ErrorListener)new XMLErrorListener(), false);
    }

    public static void writeTo(Node node, Writer writer, ErrorListener errorListener) throws TransformerException, IOException {
        XMLUtils.writeNodeTo(node, writer, errorListener, false);
    }

    public static void writeTo(Node node, Writer writer, boolean omitXMLDeclaration) throws TransformerException, IOException {
        XMLUtils.writeNodeTo(node, writer, (ErrorListener)new XMLErrorListener(), omitXMLDeclaration);
    }

    public static void writeTo(Node node, Writer writer, ErrorListener errorListener, boolean omitXMLDeclaration) throws TransformerException, IOException {
        XMLUtils.writeNodeTo(node, writer, errorListener, omitXMLDeclaration);
    }

    public static void writeTo(Node node, File file) throws TransformerException, IOException {
        XMLUtils.writeNodeTo(node, file, (ErrorListener)new XMLErrorListener(), false);
    }

    public static void writeTo(Node node, File file, ErrorListener errorListener) throws TransformerException, IOException {
        XMLUtils.writeNodeTo(node, file, errorListener, false);
    }

    public static void writeTo(Node node, File file, boolean omitXMLDeclaration) throws TransformerException, IOException {
        XMLUtils.writeNodeTo(node, file, (ErrorListener)new XMLErrorListener(), omitXMLDeclaration);
    }

    public static void writeTo(Node node, File file, ErrorListener errorListener, boolean omitXMLDeclaration) throws TransformerException, IOException {
        XMLUtils.writeNodeTo(node, file, errorListener, omitXMLDeclaration);
    }

    private static void writeNodeTo(Node node, OutputStream os, ErrorListener errorListener, boolean omitXMLDeclaration) throws TransformerException, IOException {
        if (transformerFactory == null) {
            XMLUtils.initTransformer();
        }
        DOMSource source = new DOMSource(node);
        StreamResult result = new StreamResult(os);
        Transformer transformer = transformerFactory.newTransformer();
        if (omitXMLDeclaration) {
            transformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        transformer.setErrorListener(errorListener);
        transformer.transform(source, result);
        os.flush();
    }

    private static void writeNodeTo(Node node, Writer writer, ErrorListener errorListener, boolean omitXMLDeclaration) throws TransformerException, IOException {
        if (transformerFactory == null) {
            XMLUtils.initTransformer();
        }
        DOMSource source = new DOMSource(node);
        StreamResult result = new StreamResult(writer);
        Transformer transformer = transformerFactory.newTransformer();
        if (omitXMLDeclaration) {
            transformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        transformer.setErrorListener(errorListener);
        transformer.transform(source, result);
        writer.flush();
    }

    private static void writeNodeTo(Node node, File file, ErrorListener errorListener, boolean omitXMLDeclaration) throws TransformerException, IOException {
        if (transformerFactory == null) {
            XMLUtils.initTransformer();
        }
        DOMSource source = new DOMSource(node);
        StreamResult result = new StreamResult(file);
        Transformer transformer = transformerFactory.newTransformer();
        if (omitXMLDeclaration) {
            transformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        transformer.setErrorListener(errorListener);
        transformer.transform(source, result);
    }

    @Deprecated
    public static byte[] eraserXML(byte[] xml) {
        return XMLUtils.eraserXML(new String(xml)).getBytes();
    }

    @Deprecated
    public static String eraserXML(String xml) {
        String tmp = xml.trim();
        if (tmp.startsWith("<?xml")) {
            int indexOf = tmp.indexOf(">");
            return tmp.substring(indexOf + 1);
        }
        return xml;
    }

    @Deprecated
    public static byte[] eraserXsiType(byte[] xml) throws UtilsException {
        ByteArrayOutputStream cleanXML = null;
        try {
            String eraserString = " xsi:type=\"xsd:string\"";
            cleanXML = new ByteArrayOutputStream();
            int i = 0;
            while (i < xml.length) {
                if (xml[i] == 32) {
                    if (i + eraserString.length() < xml.length) {
                        StringBuffer test = new StringBuffer();
                        for (int k = 0; k < eraserString.length(); ++k) {
                            test.append((char)xml[i + k]);
                        }
                        if (test.toString().equals(eraserString)) {
                            i += eraserString.length();
                            continue;
                        }
                    }
                    cleanXML.write(xml[i]);
                    ++i;
                    continue;
                }
                cleanXML.write(xml[i]);
                ++i;
            }
            byte[] risultato = cleanXML.toByteArray();
            cleanXML.close();
            return risultato;
        }
        catch (Exception e) {
            try {
                if (cleanXML != null) {
                    cleanXML.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new UtilsException("Utilities.eraserType error " + e.getMessage(), e);
        }
    }

    public static boolean isDocument(byte[] xml) {
        try {
            return XMLUtils.newDocument(xml) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isElement(byte[] xml) {
        try {
            return XMLUtils.newElement(xml) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getAttributeValue(Node n, String attrName) {
        Node nA;
        NamedNodeMap att = n.getAttributes();
        if (att != null && (nA = att.getNamedItem(attrName)) != null) {
            return nA.getNodeValue();
        }
        return null;
    }
}

