/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.utils.xml;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.openspcoop.utils.xml.XMLUtils;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;

public class ValidatoreXSD {
    private Schema schema;

    public Schema getSchema() {
        return this.schema;
    }

    public ValidatoreXSD(Schema schema) throws Exception {
        try {
            if (schema == null) {
                throw new Exception("Schema is null?");
            }
            this.schema = schema;
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante la costruzione dello schema (InputStream): " + e.getMessage(), e);
        }
    }

    public ValidatoreXSD(InputStream inputStream) throws Exception {
        try {
            StreamSource streamSource = new StreamSource(inputStream);
            this.initializeSchema(null, streamSource);
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante la costruzione dello schema (InputStream): " + e.getMessage(), e);
        }
    }

    public ValidatoreXSD(LSResourceResolver lsResourceResolver, InputStream inputStream) throws Exception {
        try {
            StreamSource streamSource = new StreamSource(inputStream);
            this.initializeSchema(lsResourceResolver, streamSource);
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante la costruzione dello schema (InputStream): " + e.getMessage(), e);
        }
    }

    public ValidatoreXSD(InputStream ... inputStream) throws Exception {
        try {
            StreamSource[] ss = new StreamSource[inputStream.length];
            for (int i = 0; i < inputStream.length; ++i) {
                ss[i] = new StreamSource(inputStream[i]);
            }
            this.initializeSchema(null, ss);
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante la costruzione dello schema (InputStream): " + e.getMessage(), e);
        }
    }

    public ValidatoreXSD(LSResourceResolver lsResourceResolver, InputStream ... inputStream) throws Exception {
        try {
            StreamSource[] ss = new StreamSource[inputStream.length];
            for (int i = 0; i < inputStream.length; ++i) {
                ss[i] = new StreamSource(inputStream[i]);
            }
            this.initializeSchema(lsResourceResolver, ss);
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante la costruzione dello schema (InputStream): " + e.getMessage(), e);
        }
    }

    public ValidatoreXSD(File file) throws Exception {
        try {
            StreamSource streamSource = new StreamSource(file);
            this.initializeSchema(null, streamSource);
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante la costruzione dello schema (File:" + file.getName() + "): " + e.getMessage(), e);
        }
    }

    public ValidatoreXSD(LSResourceResolver lsResourceResolver, File file) throws Exception {
        try {
            StreamSource streamSource = new StreamSource(file);
            this.initializeSchema(lsResourceResolver, streamSource);
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante la costruzione dello schema (File:" + file.getName() + "): " + e.getMessage(), e);
        }
    }

    public ValidatoreXSD(File ... file) throws Exception {
        try {
            StreamSource[] ss = new StreamSource[file.length];
            for (int i = 0; i < file.length; ++i) {
                ss[i] = new StreamSource(file[i]);
            }
            this.initializeSchema(null, ss);
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante la costruzione dello schema (Files): " + e.getMessage(), e);
        }
    }

    public ValidatoreXSD(LSResourceResolver lsResourceResolver, File ... file) throws Exception {
        try {
            StreamSource[] ss = new StreamSource[file.length];
            for (int i = 0; i < file.length; ++i) {
                ss[i] = new StreamSource(file[i]);
            }
            this.initializeSchema(lsResourceResolver, ss);
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante la costruzione dello schema (Files): " + e.getMessage(), e);
        }
    }

    public ValidatoreXSD(String url) throws Exception {
        try {
            StreamSource streamSource = new StreamSource(url);
            this.initializeSchema(null, streamSource);
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante la costruzione dello schema (URL:" + url + "): " + e.getMessage(), e);
        }
    }

    public ValidatoreXSD(LSResourceResolver lsResourceResolver, String url) throws Exception {
        try {
            StreamSource streamSource = new StreamSource(url);
            this.initializeSchema(lsResourceResolver, streamSource);
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante la costruzione dello schema (URL:" + url + "): " + e.getMessage(), e);
        }
    }

    public ValidatoreXSD(String ... url) throws Exception {
        try {
            StreamSource[] ss = new StreamSource[url.length];
            for (int i = 0; i < url.length; ++i) {
                ss[i] = new StreamSource(url[i]);
            }
            this.initializeSchema(null, ss);
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante la costruzione dello schema (URL:" + url + "): " + e.getMessage(), e);
        }
    }

    public ValidatoreXSD(LSResourceResolver lsResourceResolver, String ... url) throws Exception {
        try {
            StreamSource[] ss = new StreamSource[url.length];
            for (int i = 0; i < url.length; ++i) {
                ss[i] = new StreamSource(url[i]);
            }
            this.initializeSchema(lsResourceResolver, ss);
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante la costruzione dello schema (URL:" + url + "): " + e.getMessage(), e);
        }
    }

    private void initializeSchema(LSResourceResolver lsResourceResolver, StreamSource streamSource) throws Exception {
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            if (lsResourceResolver != null) {
                factory.setResourceResolver(lsResourceResolver);
            }
            this.schema = factory.newSchema(streamSource);
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante l'inizializzazione dello schema: " + e.getMessage(), e);
        }
    }

    private void initializeSchema(LSResourceResolver lsResourceResolver, StreamSource[] streamSource) throws Exception {
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            if (lsResourceResolver != null) {
                factory.setResourceResolver(lsResourceResolver);
            }
            this.schema = factory.newSchema(streamSource);
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante l'inizializzazione dello schema: " + e.getMessage(), e);
        }
    }

    public void valida(Node nodeXML) throws Exception {
        this.valida(new DOMSource(nodeXML));
    }

    public void valida(Node nodeXML, ErrorHandler errorHandler) throws Exception {
        this.valida(new DOMSource(nodeXML), errorHandler);
    }

    public void valida(Node nodeXML, boolean streamSource) throws Exception {
        this.valida(nodeXML, streamSource, null);
    }

    public void valida(Node nodeXML, boolean streamSource, ErrorHandler errorHandler) throws Exception {
        if (streamSource) {
            ByteArrayInputStream bin = new ByteArrayInputStream(XMLUtils.toByteArray(nodeXML));
            this.valida(new StreamSource(bin), errorHandler);
        } else {
            this.valida(nodeXML, errorHandler);
        }
    }

    public void valida(InputStream inputStreamXML) throws Exception {
        this.valida(new StreamSource(inputStreamXML));
    }

    public void valida(InputStream inputStreamXML, ErrorHandler errorHandler) throws Exception {
        this.valida(new StreamSource(inputStreamXML), errorHandler);
    }

    public void valida(File fileXML) throws Exception {
        this.valida(new StreamSource(fileXML));
    }

    public void valida(File fileXML, ErrorHandler errorHandler) throws Exception {
        this.valida(new StreamSource(fileXML), errorHandler);
    }

    public void valida(String urlXML) throws Exception {
        this.valida(new StreamSource(urlXML));
    }

    public void valida(String urlXML, ErrorHandler errorHandler) throws Exception {
        this.valida(new StreamSource(urlXML), errorHandler);
    }

    public void valida(Source source) throws Exception {
        this.valida(source, null);
    }

    public void valida(Source source, ErrorHandler errorHandler) throws Exception {
        Validator validator = this.schema.newValidator();
        if (errorHandler != null) {
            validator.setErrorHandler(errorHandler);
        }
        validator.validate(source);
    }
}

