/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.utils.xml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.xml.namespace.NamespaceContext;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import org.apache.axis.message.SOAPEnvelope;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicNamespaceContext
implements NamespaceContext {
    private Properties context = new Properties();
    private String prefixChildSoapBody = null;
    private boolean soapFault = false;
    private boolean soapBodyEmpty = false;

    public boolean isSoapBodyEmpty() {
        return this.soapBodyEmpty;
    }

    public void setSoapBodyEmpty(boolean soapBodyEmpty) {
        this.soapBodyEmpty = soapBodyEmpty;
    }

    public boolean isSoapFault() {
        return this.soapFault;
    }

    public void setSoapFault(boolean soapFault) {
        this.soapFault = soapFault;
    }

    public String getPrefixChildSoapBody() {
        return this.prefixChildSoapBody;
    }

    public void setPrefixChildSoapBody(String prefixChildSoapBody) {
        this.prefixChildSoapBody = prefixChildSoapBody;
    }

    public void addNamespace(String prefix, String url) {
        if (!this.context.containsKey(prefix)) {
            this.context.setProperty(prefix, url);
        }
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (!this.context.containsKey(prefix)) {
            return "";
        }
        Enumeration<?> en = this.context.propertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (!key.equals(prefix)) continue;
            return this.context.getProperty(key);
        }
        return "";
    }

    @Override
    public String getPrefix(String namespace) {
        if (!this.context.containsValue(namespace)) {
            return "";
        }
        Enumeration<?> en = this.context.propertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (!this.context.getProperty(key).equals(namespace)) continue;
            return key;
        }
        return "";
    }

    public Iterator<?> getPrefixes(String namespace) {
        Vector<String> v = new Vector<String>();
        Enumeration<?> en = this.context.propertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (!this.context.getProperty(key).equals(namespace)) continue;
            v.add(key);
        }
        return v.iterator();
    }

    public void findPrefixNamespace(Node node) {
        NodeList list;
        if (node == null) {
            return;
        }
        String namespace = node.getNamespaceURI();
        if (namespace != null && !"".equals(namespace)) {
            String prefix = node.getPrefix();
            if (prefix == null) {
                prefix = "";
            }
            this.addNamespace(prefix, node.getNamespaceURI());
        }
        if ((list = node.getChildNodes()) == null) {
            return;
        }
        int nodes = list.getLength();
        for (int i = 0; i < nodes; ++i) {
            Node child = list.item(i);
            this.findPrefixNamespace(child);
        }
    }

    public static DynamicNamespaceContext getNamespaceContext(Node node) {
        DynamicNamespaceContext dnc = new DynamicNamespaceContext();
        dnc.findPrefixNamespace(node);
        return dnc;
    }

    public static DynamicNamespaceContext getNamespaceContextFromSoapEnvelope(byte[] soapenvelope) throws SAXException, SOAPException {
        SOAPEnvelope envelope = new SOAPEnvelope((InputStream)new ByteArrayInputStream(soapenvelope));
        return DynamicNamespaceContext.getNamespaceContextFromSoapEnvelope((javax.xml.soap.SOAPEnvelope)envelope);
    }

    public static DynamicNamespaceContext getNamespaceContextFromSoapEnvelope(javax.xml.soap.SOAPEnvelope soapenvelope) throws SAXException, SOAPException {
        DynamicNamespaceContext dnc = new DynamicNamespaceContext();
        SOAPBody body = soapenvelope.getBody();
        if (body.hasFault()) {
            dnc.setSoapFault(true);
        } else if (!body.hasChildNodes()) {
            dnc.setSoapBodyEmpty(true);
        } else {
            String prefix = body.getFirstChild().getPrefix();
            if (prefix == null) {
                prefix = "";
            } else if (prefix != null && !"".equals(prefix)) {
                prefix = prefix + ":";
            }
            dnc.setPrefixChildSoapBody(prefix);
        }
        dnc.findPrefixNamespace((Node)soapenvelope);
        return dnc;
    }
}

