/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.utils.sql;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.openspcoop.utils.sql.ISQLQueryObject;
import org.openspcoop.utils.sql.SQLQueryObjectException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SQLQueryObjectCore
implements ISQLQueryObject {
    Vector<String> fields = new Vector();
    Vector<String> fieldNames = new Vector();
    Vector<String> tables = new Vector();
    Vector<String> tableNames = new Vector();
    Vector<String> tableAlias = new Vector();
    Hashtable<String, String> alias = new Hashtable();
    Vector<String> conditions = new Vector();
    Vector<String> forceIndexTableNames = new Vector();
    boolean andLogicOperator = false;
    boolean notBeforeConditions = false;
    Vector<String> groupBy = new Vector();
    Vector<String> orderBy = new Vector();
    boolean sortTypeAsc = true;
    boolean distinct = false;
    int limit = -1;
    int offset = -1;
    Vector<String> updateFieldsName = new Vector();
    Vector<String> updateFieldsValue = new Vector();
    String updateTable = null;
    Vector<String> insertFieldsName = new Vector();
    Vector<String> insertFieldsValue = new Vector();
    String insertTable = null;
    private int serial = 0;

    protected String getAliasFieldKeyword() {
        return " as ";
    }

    protected String getAliasTableKeyword() {
        return " as ";
    }

    protected List<String> getSupportedAliasesField() {
        ArrayList<String> lista = new ArrayList<String>();
        lista.add(" as ");
        lista.add(" ");
        return lista;
    }

    protected List<String> getSupportedAliasesTable() {
        ArrayList<String> lista = new ArrayList<String>();
        lista.add(" as ");
        lista.add(" ");
        return lista;
    }

    protected synchronized int getSerial() {
        ++this.serial;
        return this.serial;
    }

    @Override
    public ISQLQueryObject addSelectField(String nomeField) throws SQLQueryObjectException {
        return this.addSelectField(null, nomeField);
    }

    @Override
    public ISQLQueryObject addSelectField(String nomeTabella, String nomeField) throws SQLQueryObjectException {
        return this.addSelectField(nomeTabella, nomeField, null, true);
    }

    @Override
    public ISQLQueryObject addSelectAliasField(String nomeField, String alias) throws SQLQueryObjectException {
        return this.addSelectField(null, nomeField, alias, true);
    }

    @Override
    public ISQLQueryObject addSelectAliasField(String nomeTabella, String nomeField, String alias) throws SQLQueryObjectException {
        return this.addSelectField(nomeTabella, nomeField, alias, true);
    }

    @Override
    public ISQLQueryObject addSelectCoalesceField(String nomeField, String alias, String valore) throws SQLQueryObjectException {
        return this.addSelectField(null, nomeField, alias, true, "coalesce(", ",'" + SQLQueryObjectCore.escapeStringValue(valore) + "')");
    }

    @Override
    public ISQLQueryObject addSelectCoalesceField(String aliasTabella, String nomeField, String alias, String valore) throws SQLQueryObjectException {
        if (!this.tableAlias.contains(aliasTabella)) {
            throw new SQLQueryObjectException("L'alias indicato non corrisponde ad un alias effettivo associato ad una tabella");
        }
        return this.addSelectField(aliasTabella, nomeField, alias, true, "coalesce(", ",'" + SQLQueryObjectCore.escapeStringValue(valore) + "')");
    }

    @Override
    public ISQLQueryObject addSelectCountField(String alias) throws SQLQueryObjectException {
        String fieldSQL = "count(*)";
        if (alias != null) {
            fieldSQL = fieldSQL + this.getAliasFieldKeyword() + alias;
        }
        this.addSelectField(null, fieldSQL, null, false);
        this.fieldNames.add(alias);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectCountField(String fieldCount, String alias) throws SQLQueryObjectException {
        if (fieldCount == null) {
            fieldCount = "*";
        }
        String fieldSQL = "count(" + fieldCount + ")";
        if (alias != null) {
            fieldSQL = fieldSQL + this.getAliasFieldKeyword() + alias;
        }
        this.addSelectField(null, fieldSQL, null, false);
        this.fieldNames.add(alias);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectCountField(String fieldCount, String alias, boolean distinct) throws SQLQueryObjectException {
        if (fieldCount == null && distinct) {
            throw new SQLQueryObjectException("Non e' possibile utilizzare DISTINCT senza specificare un fieldCount");
        }
        this.addSelectCountField("DISTINCT " + fieldCount, alias);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectCountField(String aliasTabella, String fieldCount, String alias) throws SQLQueryObjectException {
        if (!this.tableAlias.contains(aliasTabella)) {
            throw new SQLQueryObjectException("L'alias indicato non corrisponde ad un alias effettivo associato ad una tabella");
        }
        this.addSelectCountField(aliasTabella + "." + fieldCount, alias);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectCountField(String aliasTabella, String fieldCount, String alias, boolean distinct) throws SQLQueryObjectException {
        if (!this.tableAlias.contains(aliasTabella)) {
            throw new SQLQueryObjectException("L'alias indicato non corrisponde ad un alias effettivo associato ad una tabella");
        }
        this.addSelectCountField(aliasTabella + "." + fieldCount, alias, distinct);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectAvgField(String fieldAvg, String alias) throws SQLQueryObjectException {
        if (fieldAvg == null) {
            throw new SQLQueryObjectException("field avg non puo' essere null");
        }
        this.addSelectField(null, fieldAvg, alias, true, "avg(", ")");
        return this;
    }

    @Override
    public ISQLQueryObject addSelectAvgField(String aliasTabella, String fieldAvg, String alias) throws SQLQueryObjectException {
        if (fieldAvg == null) {
            throw new SQLQueryObjectException("field avg non puo' essere null");
        }
        if (aliasTabella == null) {
            throw new SQLQueryObjectException("nomeTabella non puo' essere null");
        }
        if (!this.tableAlias.contains(aliasTabella)) {
            throw new SQLQueryObjectException("L'alias indicato non corrisponde ad un alias effettivo associato ad una tabella");
        }
        this.addSelectField(aliasTabella, fieldAvg, alias, true, "avg(", ")");
        return this;
    }

    @Override
    public abstract ISQLQueryObject addSelectAvgTimestampField(String var1, String var2) throws SQLQueryObjectException;

    @Override
    public ISQLQueryObject addSelectAvgTimestampField(String aliasTabella, String fieldAvg, String alias) throws SQLQueryObjectException {
        if (!this.tableAlias.contains(aliasTabella)) {
            throw new SQLQueryObjectException("L'alias indicato non corrisponde ad un alias effettivo associato ad una tabella");
        }
        this.addSelectAvgTimestampField(aliasTabella + "." + fieldAvg, alias);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectMaxField(String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException("field non puo' essere null");
        }
        this.addSelectField(null, field, alias, true, "max(", ")");
        return this;
    }

    @Override
    public ISQLQueryObject addSelectMaxField(String aliasTabella, String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException("field non puo' essere null");
        }
        if (aliasTabella == null) {
            throw new SQLQueryObjectException("nomeTabella non puo' essere null");
        }
        if (!this.tableAlias.contains(aliasTabella)) {
            throw new SQLQueryObjectException("L'alias indicato non corrisponde ad un alias effettivo associato ad una tabella");
        }
        this.addSelectField(aliasTabella, field, alias, true, "max(", ")");
        return this;
    }

    @Override
    public abstract ISQLQueryObject addSelectMaxTimestampField(String var1, String var2) throws SQLQueryObjectException;

    @Override
    public ISQLQueryObject addSelectMaxTimestampField(String aliasTabella, String field, String alias) throws SQLQueryObjectException {
        if (!this.tableAlias.contains(aliasTabella)) {
            throw new SQLQueryObjectException("L'alias indicato non corrisponde ad un alias effettivo associato ad una tabella");
        }
        this.addSelectMaxTimestampField(aliasTabella + "." + field, alias);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectMinField(String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException("field non puo' essere null");
        }
        this.addSelectField(null, field, alias, true, "min(", ")");
        return this;
    }

    @Override
    public ISQLQueryObject addSelectMinField(String aliasTabella, String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException("field non puo' essere null");
        }
        if (aliasTabella == null) {
            throw new SQLQueryObjectException("nomeTabella non puo' essere null");
        }
        if (!this.tableAlias.contains(aliasTabella)) {
            throw new SQLQueryObjectException("L'alias indicato non corrisponde ad un alias effettivo associato ad una tabella");
        }
        this.addSelectField(aliasTabella, field, alias, true, "min(", ")");
        return this;
    }

    @Override
    public abstract ISQLQueryObject addSelectMinTimestampField(String var1, String var2) throws SQLQueryObjectException;

    @Override
    public ISQLQueryObject addSelectMinTimestampField(String aliasTabella, String field, String alias) throws SQLQueryObjectException {
        if (!this.tableAlias.contains(aliasTabella)) {
            throw new SQLQueryObjectException("L'alias indicato non corrisponde ad un alias effettivo associato ad una tabella");
        }
        this.addSelectMinTimestampField(aliasTabella + "." + field, alias);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectSumField(String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException("field non puo' essere null");
        }
        this.addSelectField(null, field, alias, true, "sum(", ")");
        return this;
    }

    @Override
    public ISQLQueryObject addSelectSumField(String aliasTabella, String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException("field non puo' essere null");
        }
        if (aliasTabella == null) {
            throw new SQLQueryObjectException("nomeTabella non puo' essere null");
        }
        if (!this.tableAlias.contains(aliasTabella)) {
            throw new SQLQueryObjectException("L'alias indicato non corrisponde ad un alias effettivo associato ad una tabella");
        }
        this.addSelectField(aliasTabella, field, alias, true, "sum(", ")");
        return this;
    }

    @Override
    public abstract ISQLQueryObject addSelectSumTimestampField(String var1, String var2) throws SQLQueryObjectException;

    @Override
    public ISQLQueryObject addSelectSumTimestampField(String aliasTabella, String field, String alias) throws SQLQueryObjectException {
        if (!this.tableAlias.contains(aliasTabella)) {
            throw new SQLQueryObjectException("L'alias indicato non corrisponde ad un alias effettivo associato ad una tabella");
        }
        this.addSelectSumTimestampField(aliasTabella + "." + field, alias);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectForceIndex(String nomeTabella, String indexName) throws SQLQueryObjectException {
        if (nomeTabella == null || "".equals(nomeTabella)) {
            throw new SQLQueryObjectException("Nome tabela is null or empty string");
        }
        if (indexName == null || "".equals(indexName)) {
            throw new SQLQueryObjectException("Nome indice is null or empty string");
        }
        String forceIndex = "/*+ index(" + nomeTabella + " " + indexName + ") */";
        if (this.forceIndexTableNames.contains(forceIndex)) {
            throw new SQLQueryObjectException("Forzatura all'utilizzo dell'indice (" + forceIndex + ") gia inserito tra le forzature");
        }
        this.forceIndexTableNames.add(forceIndex);
        return this;
    }

    @Override
    public void setSelectDistinct(boolean value) throws SQLQueryObjectException {
        this.distinct = value;
    }

    @Override
    public Vector<String> getFieldsName() throws SQLQueryObjectException {
        if (this.fieldNames == null || this.fieldNames.size() == 0) {
            throw new SQLQueryObjectException("Nessun field impostato");
        }
        return this.fieldNames;
    }

    protected ISQLQueryObject addSelectField(String nomeTabella, String nomeField, String alias, boolean addFieldName) throws SQLQueryObjectException {
        return this.addSelectField(nomeTabella, nomeField, alias, addFieldName, null, null);
    }

    protected ISQLQueryObject addSelectField(String nomeTabella, String nomeField, String alias, boolean addFieldName, String functionPrefix, String functionSuffix) throws SQLQueryObjectException {
        if (nomeField == null || "".equals(nomeField)) {
            throw new SQLQueryObjectException("Field is null or empty string");
        }
        if (alias != null) {
            if (this.fields.contains("*")) {
                throw new SQLQueryObjectException("Alias " + alias + " del field " + nomeField + " non utilizzabile tra i select fields. La presenza del select field '*' non permette di inserirne altri");
            }
            if (this.fieldNames.contains(alias)) {
                throw new SQLQueryObjectException("Alias " + alias + " gia inserito tra i select fields");
            }
        } else {
            if (!"*".equals(nomeField) && this.fields.contains("*")) {
                throw new SQLQueryObjectException("Field " + nomeField + " non utilizzabile tra i select fields. La presenza del select field '*' non permette di inserirne altri");
            }
            if (this.fields.contains(nomeField)) {
                throw new SQLQueryObjectException("Field " + nomeField + " gia inserito per tra i select fields");
            }
        }
        if (nomeTabella != null && !"".equals(nomeTabella)) {
            if (!this.tableNames.contains(nomeTabella)) {
                throw new SQLQueryObjectException("Tabella " + nomeTabella + " non esiste tra le tabella su cui effettuare la ricerca");
            }
            String nomeTabellaConField = nomeTabella + "." + nomeField;
            if (functionPrefix != null) {
                nomeTabellaConField = functionPrefix + nomeTabellaConField;
            }
            if (functionSuffix != null) {
                nomeTabellaConField = nomeTabellaConField + functionSuffix;
            }
            if (alias != null) {
                this.fields.add(nomeTabellaConField + this.getAliasFieldKeyword() + alias);
                this.alias.put(alias, nomeTabellaConField);
            } else {
                this.fields.add(nomeTabellaConField);
            }
        } else {
            String tmp = new String(nomeField);
            if (functionPrefix != null) {
                tmp = functionPrefix + tmp;
            }
            if (functionSuffix != null) {
                tmp = tmp + functionSuffix;
            }
            if (alias != null) {
                this.fields.add(tmp + this.getAliasFieldKeyword() + alias);
                this.alias.put(alias, tmp);
            } else {
                this.fields.add(tmp);
            }
        }
        if (addFieldName) {
            if (alias != null) {
                this.fieldNames.add(alias);
            } else {
                this.fieldNames.add(nomeField);
            }
        }
        return this;
    }

    @Override
    public ISQLQueryObject addFromTable(String tabella) throws SQLQueryObjectException {
        if (tabella == null || "".equals(tabella)) {
            throw new SQLQueryObjectException("Tabella is null or empty string");
        }
        if (this.tableNames.contains(tabella)) {
            throw new SQLQueryObjectException("Tabella " + tabella + " gia' esistente tra le tabella su cui effettuare la ricerca");
        }
        this.tableNames.add(tabella);
        this.tables.add(tabella);
        return this;
    }

    @Override
    public ISQLQueryObject addFromTable(String tabella, String alias) throws SQLQueryObjectException {
        if (tabella == null || "".equals(tabella)) {
            throw new SQLQueryObjectException("Tabella is null or empty string");
        }
        if (alias == null || "".equals(alias)) {
            throw new SQLQueryObjectException("Alias tabella is null or empty string");
        }
        if (this.tableNames.contains(alias)) {
            throw new SQLQueryObjectException("Tabella " + tabella + " gia' esistente tra le tabella su cui effettuare la ricerca");
        }
        this.tableNames.add(alias);
        this.tables.add(tabella + this.getAliasTableKeyword() + alias);
        this.tableAlias.add(alias);
        return this;
    }

    @Override
    public ISQLQueryObject addWhereCondition(String condition) throws SQLQueryObjectException {
        if (condition == null || "".equals(condition)) {
            throw new SQLQueryObjectException("Where Condition is null or empty string");
        }
        String buildCondition = "( " + condition + " )";
        if (buildCondition.indexOf("?") == -1 && this.conditions.contains(buildCondition)) {
            throw new SQLQueryObjectException("Where Condition " + condition + " gia' esistente tra le condizioni di where");
        }
        this.conditions.add(buildCondition);
        return this;
    }

    @Override
    public ISQLQueryObject addWhereCondition(boolean andLogicOperator, String ... conditions) throws SQLQueryObjectException {
        this.addWhereCondition(andLogicOperator, false, conditions);
        return this;
    }

    @Override
    public ISQLQueryObject addWhereCondition(boolean andLogicOperator, boolean not, String ... conditions) throws SQLQueryObjectException {
        if (conditions == null || conditions.length <= 0) {
            throw new SQLQueryObjectException("Where Conditions non esistenti");
        }
        StringBuffer buildCondition = new StringBuffer();
        if (not) {
            buildCondition.append("( NOT ");
        }
        buildCondition.append("( ");
        for (int i = 0; i < conditions.length; ++i) {
            if (i > 0) {
                if (andLogicOperator) {
                    buildCondition.append(" AND ");
                } else {
                    buildCondition.append(" OR ");
                }
            }
            if (conditions[i] == null || "".equals(conditions[i])) {
                throw new SQLQueryObjectException("Where Condition[" + i + "] is null or empty string");
            }
            buildCondition.append("(");
            buildCondition.append(conditions[i]);
            buildCondition.append(")");
        }
        buildCondition.append(" )");
        if (not) {
            buildCondition.append(")");
        }
        if (buildCondition.indexOf("?") == -1 && this.conditions.contains(buildCondition.toString())) {
            throw new SQLQueryObjectException("Where Condition " + buildCondition.toString() + " gia' esistente tra le condizioni di where");
        }
        this.conditions.add(buildCondition.toString());
        return this;
    }

    @Override
    public ISQLQueryObject addWhereIsNullCondition(String field) throws SQLQueryObjectException {
        if (field == null || "".equals(field)) {
            throw new SQLQueryObjectException("IsNullCondition field non puo' essere null");
        }
        this.addWhereCondition(field + " is null");
        return this;
    }

    @Override
    public ISQLQueryObject addWhereIsNotNullCondition(String field) throws SQLQueryObjectException {
        if (field == null || "".equals(field)) {
            throw new SQLQueryObjectException("IsNullCondition field non puo' essere null");
        }
        this.addWhereCondition(field + " is not null");
        return this;
    }

    private String createWhereLikeCondition(String columnName, String searchPattern) throws SQLQueryObjectException {
        if (columnName == null || "".equals(columnName)) {
            throw new SQLQueryObjectException("Where Condition column name is null or empty string");
        }
        if (searchPattern == null || "".equals(searchPattern)) {
            throw new SQLQueryObjectException("Where Condition searchPattern is null or empty string");
        }
        if (searchPattern.length() > 1) {
            if (searchPattern.startsWith("'")) {
                searchPattern = searchPattern.substring(1);
            }
            if (searchPattern.endsWith("'")) {
                searchPattern = searchPattern.substring(0, searchPattern.length() - 1);
            }
        }
        String escapeValue = SQLQueryObjectCore.escapeStringValue(searchPattern);
        String buildCondition = "( " + columnName + " LIKE '" + escapeValue + "' )";
        return buildCondition;
    }

    @Override
    public ISQLQueryObject addWhereLikeCondition(String columnName, String searchPattern) throws SQLQueryObjectException {
        String buildCondition = this.createWhereLikeCondition(columnName, searchPattern);
        if (buildCondition.indexOf("?") == -1 && this.conditions.contains(buildCondition.toString())) {
            throw new SQLQueryObjectException("Where Condition " + buildCondition.toString() + " gia' esistente tra le condizioni di where");
        }
        this.conditions.add(buildCondition);
        return this;
    }

    @Override
    public String getWhereLikeCondition(String columnName, String searchPattern) throws SQLQueryObjectException {
        return this.createWhereLikeCondition(columnName, searchPattern);
    }

    private String createWhereLikeCondition(String columnName, String searchPattern, boolean contains, boolean caseInsensitive) throws SQLQueryObjectException {
        if (columnName == null || "".equals(columnName)) {
            throw new SQLQueryObjectException("Where Condition column name is null or empty string");
        }
        if (searchPattern == null || "".equals(searchPattern)) {
            throw new SQLQueryObjectException("Where Condition searchPattern is null or empty string");
        }
        if (searchPattern.length() > 1) {
            if (searchPattern.startsWith("'")) {
                searchPattern = searchPattern.substring(1);
            }
            if (searchPattern.endsWith("'")) {
                searchPattern = searchPattern.substring(0, searchPattern.length() - 1);
            }
        }
        String buildCondition = null;
        String escapeValue = SQLQueryObjectCore.escapeStringValue(searchPattern);
        buildCondition = contains && caseInsensitive ? "( lower(" + columnName + ") LIKE '%" + escapeValue.toLowerCase() + "%' )" : (contains ? "( " + columnName + " LIKE '%" + escapeValue + "%' )" : (caseInsensitive ? "( lower(" + columnName + ") LIKE '" + escapeValue.toLowerCase() + "' )" : "( " + columnName + " LIKE '" + escapeValue + "' )"));
        return buildCondition;
    }

    @Override
    public ISQLQueryObject addWhereLikeCondition(String columnName, String searchPattern, boolean contains, boolean caseInsensitive) throws SQLQueryObjectException {
        String buildCondition = this.createWhereLikeCondition(columnName, searchPattern, contains, caseInsensitive);
        if (buildCondition.indexOf("?") == -1 && this.conditions.contains(buildCondition.toString())) {
            throw new SQLQueryObjectException("Where Condition " + buildCondition.toString() + " gia' esistente tra le condizioni di where");
        }
        this.conditions.add(buildCondition);
        return this;
    }

    @Override
    public String getWhereLikeCondition(String columnName, String searchPattern, boolean contains, boolean caseInsensitive) throws SQLQueryObjectException {
        return this.createWhereLikeCondition(columnName, searchPattern, contains, caseInsensitive);
    }

    private String createWhereExistsCondition(boolean notExists, ISQLQueryObject sqlQueryObject) throws SQLQueryObjectException {
        if (sqlQueryObject == null) {
            throw new SQLQueryObjectException("ISQLQueryObject, su cui viene effettuato il controllo di exists, non fornito");
        }
        StringBuffer bf = new StringBuffer();
        if (notExists) {
            bf.append("NOT ");
        }
        bf.append("EXISTS (");
        bf.append(sqlQueryObject.createSQLQuery());
        bf.append(" )");
        return bf.toString();
    }

    @Override
    public ISQLQueryObject addWhereExistsCondition(boolean notExists, ISQLQueryObject sqlQueryObject) throws SQLQueryObjectException {
        this.addWhereCondition(this.createWhereExistsCondition(notExists, sqlQueryObject));
        return this;
    }

    @Override
    public String getWhereExistsCondition(boolean notExists, ISQLQueryObject sqlQueryObject) throws SQLQueryObjectException {
        return this.createWhereExistsCondition(notExists, sqlQueryObject);
    }

    @Override
    public ISQLQueryObject addWhereSelectSQLCondition(boolean notExists, String field, ISQLQueryObject sqlQueryObject) throws SQLQueryObjectException {
        this.addWhereCondition(this.createWhereSQLConditionCondition(notExists, false, field, sqlQueryObject));
        return this;
    }

    @Override
    public ISQLQueryObject addWhereINSelectSQLCondition(boolean notExists, String field, ISQLQueryObject sqlQueryObject) throws SQLQueryObjectException {
        this.addWhereCondition(this.createWhereSQLConditionCondition(notExists, true, field, sqlQueryObject));
        return this;
    }

    private String createWhereSQLConditionCondition(boolean notExists, boolean in, String field, ISQLQueryObject sqlQueryObject) throws SQLQueryObjectException {
        if (sqlQueryObject == null) {
            throw new SQLQueryObjectException("ISQLQueryObject, su cui viene costruita la ricerca, non fornito");
        }
        if (field == null) {
            throw new SQLQueryObjectException("Field non fornito");
        }
        StringBuffer bf = new StringBuffer();
        if (notExists) {
            bf.append("NOT ");
        }
        bf.append(field);
        if (in) {
            bf.append(" IN ");
        } else {
            bf.append(" = ");
        }
        bf.append(" (");
        bf.append(sqlQueryObject.createSQLQuery());
        bf.append(" )");
        return bf.toString();
    }

    @Override
    public void setANDLogicOperator(boolean andLogicOperator) throws SQLQueryObjectException {
        this.andLogicOperator = andLogicOperator;
    }

    @Override
    public void setNOTBeforeConditions(boolean not) throws SQLQueryObjectException {
        this.notBeforeConditions = not;
    }

    @Override
    public ISQLQueryObject addGroupBy(String groupByNomeField) throws SQLQueryObjectException {
        if (groupByNomeField == null || "".equals(groupByNomeField)) {
            throw new SQLQueryObjectException("GroupBy Condition is null or empty string");
        }
        if (this.alias.containsKey(groupByNomeField)) {
            this.groupBy.add(this.alias.get(groupByNomeField));
        } else {
            this.groupBy.add(groupByNomeField);
        }
        return this;
    }

    @Override
    public ISQLQueryObject addOrderBy(String orderByNomeField) throws SQLQueryObjectException {
        if (orderByNomeField == null || "".equals(orderByNomeField)) {
            throw new SQLQueryObjectException("OrderBy Condition is null or empty string");
        }
        this.orderBy.add(orderByNomeField);
        return this;
    }

    @Override
    public void setSortType(boolean sort) throws SQLQueryObjectException {
        if (this.orderBy.isEmpty()) {
            throw new SQLQueryObjectException("OrderBy Conditions non definite");
        }
        this.sortTypeAsc = sort;
    }

    @Override
    public void setLimit(int limit) throws SQLQueryObjectException {
        this.limit = limit;
    }

    @Override
    public void setOffset(int offset) throws SQLQueryObjectException {
        this.offset = offset;
    }

    @Override
    public abstract String createSQLQuery() throws SQLQueryObjectException;

    public String toString() {
        try {
            return this.createSQLQuery();
        }
        catch (Exception e) {
            return "Oggetto non corretto: " + e.getMessage();
        }
    }

    @Override
    public String toString(boolean delete) {
        try {
            if (delete) {
                return this.createSQLDelete();
            }
            return this.createSQLQuery();
        }
        catch (Exception e) {
            return "Oggetto non corretto: " + e.getMessage();
        }
    }

    protected void checkUnionField(ISQLQueryObject ... sqlQueryObject) throws SQLQueryObjectException {
        int i;
        if (sqlQueryObject == null || sqlQueryObject.length <= 0) {
            throw new SQLQueryObjectException("Parametro is null");
        }
        if (sqlQueryObject.length == 1) {
            throw new SQLQueryObjectException("Parametro contiene un solo sqlQueryObject (minimo 2)");
        }
        for (i = 0; i < sqlQueryObject.length; ++i) {
            ISQLQueryObject sqlQueryObjectDaVerificare = sqlQueryObject[i];
            Vector<String> nomiFieldSqlQueryObjectDaVerificare = sqlQueryObjectDaVerificare.getFieldsName();
            if (nomiFieldSqlQueryObjectDaVerificare != null && nomiFieldSqlQueryObjectDaVerificare.size() != 0) continue;
            throw new SQLQueryObjectException("La select numero " + (i + 1) + " non possiede fields?");
        }
        for (i = 0; i < sqlQueryObject.length; ++i) {
            Vector<String> nomiFieldSqlQueryObjectDaVerificare = sqlQueryObject[i].getFieldsName();
            String[] nomi = nomiFieldSqlQueryObjectDaVerificare.toArray(new String[1]);
            for (int indiceField = 0; indiceField < nomi.length; ++indiceField) {
                String fieldDaVerificare = nomi[indiceField];
                for (int altriSqlObject = 0; altriSqlObject < sqlQueryObject.length; ++altriSqlObject) {
                    if (altriSqlObject == i || sqlQueryObject[altriSqlObject].getFieldsName().contains(fieldDaVerificare) || sqlQueryObject[altriSqlObject].getFieldsName().contains("*")) continue;
                    throw new SQLQueryObjectException("Field [" + fieldDaVerificare + "] trovato nella select numero " + (i + 1) + " non presente nella select numero " + (altriSqlObject + 1));
                }
            }
        }
    }

    @Override
    public ISQLQueryObject addUpdateTable(String nomeTabella) throws SQLQueryObjectException {
        if (nomeTabella == null || "".equals(nomeTabella)) {
            throw new SQLQueryObjectException("Nome tabella is null or empty string");
        }
        this.updateTable = nomeTabella;
        return this;
    }

    @Override
    public ISQLQueryObject addUpdateField(String nomeField, String valueField) throws SQLQueryObjectException {
        if (nomeField == null || "".equals(nomeField)) {
            throw new SQLQueryObjectException("Field name is null or empty string");
        }
        if (valueField == null) {
            throw new SQLQueryObjectException("Field value is null");
        }
        if (this.updateFieldsName.contains(nomeField)) {
            throw new SQLQueryObjectException("Field name " + nomeField + " gia inserito tra gli update fields");
        }
        this.updateFieldsName.add(nomeField);
        this.updateFieldsValue.add(valueField);
        return this;
    }

    @Override
    public ISQLQueryObject addInsertTable(String nomeTabella) throws SQLQueryObjectException {
        if (nomeTabella == null || "".equals(nomeTabella)) {
            throw new SQLQueryObjectException("Nome tabella is null or empty string");
        }
        this.insertTable = nomeTabella;
        return this;
    }

    @Override
    public ISQLQueryObject addInsertField(String nomeField, String valueField) throws SQLQueryObjectException {
        if (nomeField == null || "".equals(nomeField)) {
            throw new SQLQueryObjectException("Field name is null or empty string");
        }
        if (valueField == null) {
            throw new SQLQueryObjectException("Field value is null");
        }
        if (this.insertFieldsName.contains(nomeField)) {
            throw new SQLQueryObjectException("Field name " + nomeField + " gia inserito tra gli insert fields");
        }
        this.insertFieldsName.add(nomeField);
        this.insertFieldsValue.add(valueField);
        return this;
    }

    @Override
    public String createSQLInsert() throws SQLQueryObjectException {
        int i;
        if (this.insertTable == null) {
            throw new SQLQueryObjectException("Nome Tabella per l'inserimento non definito");
        }
        if (this.insertFieldsName.size() <= 0) {
            throw new SQLQueryObjectException("Nessuna coppia nome/valore da inserire presente");
        }
        if (this.insertFieldsName.size() != this.insertFieldsValue.size()) {
            throw new SQLQueryObjectException("FieldsName.size <> FieldsValue.size");
        }
        StringBuffer bf = new StringBuffer();
        bf.append("INSERT INTO ");
        bf.append(this.insertTable);
        bf.append(" (");
        for (i = 0; i < this.insertFieldsName.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.insertFieldsName.get(i));
        }
        bf.append(") VALUES (");
        for (i = 0; i < this.insertFieldsValue.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.insertFieldsValue.get(i));
        }
        bf.append(")");
        return bf.toString();
    }

    @Override
    public ISQLQueryObject addDeleteTable(String tabella) throws SQLQueryObjectException {
        this.checkDeleteTable(tabella);
        this.addFromTable(tabella);
        return this;
    }

    protected void checkDeleteTable(String tabella) throws SQLQueryObjectException {
        if (tabella.contains(" as ") || tabella.contains(" ")) {
            throw new SQLQueryObjectException("Non e' possibile utilizzare tabelle definite tramite alias in caso di delete");
        }
        List<String> asModeSupportati = this.getSupportedAliasesTable();
        for (String aliasMode : asModeSupportati) {
            if (!tabella.contains(aliasMode)) continue;
            throw new SQLQueryObjectException("Non e' possibile utilizzare tabelle definite tramite alias in caso di delete");
        }
    }

    public static String escapeStringValue(String value) throws SQLQueryObjectException {
        if (value == null) {
            throw new SQLQueryObjectException("Valore non fornito per escape");
        }
        int index = value.indexOf(39);
        if (index >= 0) {
            StringBuffer str = new StringBuffer();
            char[] v = value.toCharArray();
            for (int i = 0; i < v.length; ++i) {
                if (v[i] == '\'') {
                    str.append('\'');
                }
                str.append(v[i]);
            }
            return str.toString();
        }
        return value;
    }
}

