/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.utils.sql;

import java.util.Iterator;
import org.openspcoop.utils.sql.ISQLQueryObject;
import org.openspcoop.utils.sql.SQLQueryObjectCore;
import org.openspcoop.utils.sql.SQLQueryObjectException;

public class PostgreSQLQueryObject
extends SQLQueryObjectCore {
    public ISQLQueryObject addSelectAvgTimestampField(String fieldAvg, String alias) throws SQLQueryObjectException {
        if (fieldAvg == null) {
            throw new SQLQueryObjectException("field avg non puo' essere null");
        }
        String fieldSQL = "avg(date_part('epoch'," + fieldAvg + "))*1000";
        if (alias != null) {
            fieldSQL = fieldSQL + this.getAliasFieldKeyword() + alias;
        }
        this.addSelectField(null, fieldSQL, null, false);
        this.fieldNames.add(alias);
        return this;
    }

    public ISQLQueryObject addSelectMaxTimestampField(String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException("field non puo' essere null");
        }
        String fieldSQL = "max(date_part('epoch'," + field + "))*1000";
        if (alias != null) {
            fieldSQL = fieldSQL + this.getAliasFieldKeyword() + alias;
        }
        this.addSelectField(null, fieldSQL, null, false);
        this.fieldNames.add(alias);
        return this;
    }

    public ISQLQueryObject addSelectMinTimestampField(String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException("field non puo' essere null");
        }
        String fieldSQL = "min(date_part('epoch'," + field + "))*1000";
        if (alias != null) {
            fieldSQL = fieldSQL + this.getAliasFieldKeyword() + alias;
        }
        this.addSelectField(null, fieldSQL, null, false);
        this.fieldNames.add(alias);
        return this;
    }

    public ISQLQueryObject addSelectSumTimestampField(String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException("field non puo' essere null");
        }
        String fieldSQL = "sum(date_part('epoch'," + field + "))*1000";
        if (alias != null) {
            fieldSQL = fieldSQL + this.getAliasFieldKeyword() + alias;
        }
        this.addSelectField(null, fieldSQL, null, false);
        this.fieldNames.add(alias);
        return this;
    }

    public ISQLQueryObject addFromTable(ISQLQueryObject subSelect) throws SQLQueryObjectException {
        StringBuffer bf = new StringBuffer();
        bf.append(" ( ");
        bf.append(subSelect.createSQLQuery());
        bf.append(" ) as subquery" + this.getSerial() + " ");
        this.addFromTable(bf.toString());
        return this;
    }

    public String createSQLQuery() throws SQLQueryObjectException {
        StringBuffer bf = new StringBuffer();
        bf.append("SELECT ");
        Iterator itForceIndex = this.forceIndexTableNames.iterator();
        while (itForceIndex.hasNext()) {
            bf.append(" " + (String)itForceIndex.next() + " ");
        }
        if (this.distinct) {
            bf.append(" DISTINCT ");
        }
        if (this.fields.size() == 0) {
            bf.append("*");
        } else {
            Iterator it = this.fields.iterator();
            boolean first = true;
            while (it.hasNext()) {
                if (!first) {
                    bf.append(",");
                } else {
                    first = false;
                }
                bf.append((String)it.next());
            }
        }
        bf.append(this.getSQL(false, false, false));
        return bf.toString();
    }

    public String createSQLDelete() throws SQLQueryObjectException {
        StringBuffer bf = new StringBuffer();
        if (this.tables.size() == 0) {
            throw new SQLQueryObjectException("Non e' possibile creare un comando di delete senza aver definito le tabelle su cui apportare l'eliminazione dei dati");
        }
        for (String table : this.tables) {
            this.checkDeleteTable(table);
        }
        bf.append("DELETE ");
        bf.append(this.getSQL(true, false, false));
        return bf.toString();
    }

    private String getSQL(boolean delete, boolean update, boolean conditions) throws SQLQueryObjectException {
        boolean first;
        Iterator it;
        StringBuffer bf = new StringBuffer();
        if (!update && !conditions) {
            bf.append(" FROM ");
            if (this.tables.size() == 0) {
                throw new SQLQueryObjectException("Tabella di ricerca (... FROM Table ...) non definita");
            }
            if (delete && this.tables.size() > 2) {
                throw new SQLQueryObjectException("Non e' possibile effettuare una delete con piu' di una tabella alla volta");
            }
            it = this.tables.iterator();
            first = true;
            while (it.hasNext()) {
                if (!first) {
                    bf.append(",");
                } else {
                    first = false;
                }
                bf.append((String)it.next());
            }
        }
        if (this.conditions.size() > 0) {
            if (!conditions) {
                bf.append(" WHERE ");
            }
            if (this.notBeforeConditions) {
                bf.append("NOT (");
            }
            for (int i = 0; i < this.conditions.size(); ++i) {
                if (i > 0) {
                    if (this.andLogicOperator) {
                        bf.append(" AND ");
                    } else {
                        bf.append(" OR ");
                    }
                }
                bf.append((String)this.conditions.get(i));
            }
            if (this.notBeforeConditions) {
                bf.append(")");
            }
        }
        if (!(this.groupBy.size() <= 0 || delete || update || conditions)) {
            bf.append(" GROUP BY ");
            it = this.groupBy.iterator();
            first = true;
            while (it.hasNext()) {
                if (!first) {
                    bf.append(",");
                } else {
                    first = false;
                }
                bf.append((String)it.next());
            }
        }
        if (!(this.orderBy.size() <= 0 || delete || update || conditions)) {
            bf.append(" ORDER BY ");
            it = this.orderBy.iterator();
            first = true;
            while (it.hasNext()) {
                if (!first) {
                    bf.append(",");
                } else {
                    first = false;
                }
                bf.append((String)it.next());
            }
            if (this.sortTypeAsc) {
                bf.append(" ASC ");
            } else {
                bf.append(" DESC ");
            }
        }
        if ((this.limit > 0 || this.offset > 0) && this.orderBy.size() == 0) {
            throw new SQLQueryObjectException("Condizioni di OrderBy richieste");
        }
        if (!(this.limit <= 0 || delete || update || conditions)) {
            bf.append(" LIMIT ");
            bf.append(this.limit);
        }
        if (!(this.offset < 0 || delete || update || conditions)) {
            bf.append(" OFFSET ");
            bf.append(this.offset);
        }
        return bf.toString();
    }

    public String createSQLUnion(boolean unionAll, ISQLQueryObject ... sqlQueryObject) throws SQLQueryObjectException {
        this.checkUnionField(sqlQueryObject);
        StringBuffer bf = new StringBuffer();
        bf.append("SELECT * FROM ( ");
        for (int i = 0; i < sqlQueryObject.length; ++i) {
            if (i > 0) {
                bf.append(" UNION ");
                if (unionAll) {
                    bf.append(" ALL ");
                }
            }
            bf.append("( ");
            bf.append(sqlQueryObject[i].createSQLQuery());
            bf.append(") ");
        }
        bf.append(" ) as subquery" + this.getSerial() + " ");
        if (this.orderBy.size() > 0) {
            bf.append(" ORDER BY ");
            Iterator it = this.orderBy.iterator();
            boolean first = true;
            while (it.hasNext()) {
                if (!first) {
                    bf.append(",");
                } else {
                    first = false;
                }
                bf.append((String)it.next());
            }
            if (this.sortTypeAsc) {
                bf.append(" ASC ");
            } else {
                bf.append(" DESC ");
            }
        }
        if ((this.limit > 0 || this.offset > 0) && this.orderBy.size() == 0) {
            throw new SQLQueryObjectException("Condizioni di OrderBy richieste");
        }
        if (this.limit > 0) {
            bf.append(" LIMIT ");
            bf.append(this.limit);
        }
        if (this.offset >= 0) {
            bf.append(" OFFSET ");
            bf.append(this.offset);
        }
        return bf.toString();
    }

    public String createSQLUnionCount(boolean unionAll, String aliasCount, ISQLQueryObject ... sqlQueryObject) throws SQLQueryObjectException {
        this.checkUnionField(sqlQueryObject);
        if (aliasCount == null) {
            throw new SQLQueryObjectException("Alias per il count non definito");
        }
        StringBuffer bf = new StringBuffer();
        bf.append("SELECT count(*) " + this.getAliasFieldKeyword() + " ");
        bf.append(aliasCount);
        bf.append(" FROM ( ");
        for (int i = 0; i < sqlQueryObject.length; ++i) {
            if (i > 0) {
                bf.append(" UNION ");
                if (unionAll) {
                    bf.append(" ALL ");
                }
            }
            bf.append("( ");
            bf.append(sqlQueryObject[i].createSQLQuery());
            bf.append(") ");
        }
        bf.append(" ) as subquery" + this.getSerial() + " ");
        return bf.toString();
    }

    public String createSQLUpdate() throws SQLQueryObjectException {
        if (this.updateTable == null) {
            throw new SQLQueryObjectException("Nome Tabella per l'aggiornamento non definito");
        }
        if (this.updateFieldsName.size() <= 0) {
            throw new SQLQueryObjectException("Nessuna coppia nome/valore da aggiornare presente");
        }
        if (this.updateFieldsName.size() != this.updateFieldsValue.size()) {
            throw new SQLQueryObjectException("FieldsName.size <> FieldsValue.size");
        }
        StringBuffer bf = new StringBuffer();
        bf.append("UPDATE ");
        bf.append(this.updateTable);
        bf.append(" SET ");
        for (int i = 0; i < this.updateFieldsName.size(); ++i) {
            if (i > 0) {
                bf.append(" , ");
            }
            bf.append((String)this.updateFieldsName.get(i));
            bf.append(" = ");
            bf.append((String)this.updateFieldsValue.get(i));
        }
        bf.append(this.getSQL(false, true, false));
        return bf.toString();
    }

    public String createSQLConditions() throws SQLQueryObjectException {
        if (this.conditions == null) {
            throw new SQLQueryObjectException("Condizioni non definite");
        }
        if (this.conditions.size() <= 0) {
            throw new SQLQueryObjectException("Nessuna condizione presente");
        }
        StringBuffer bf = new StringBuffer();
        bf.append(this.getSQL(false, false, true));
        return bf.toString();
    }
}

