/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.utils.serialization;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;
import net.sf.json.xml.XMLSerializer;
import org.openspcoop.utils.serialization.ExclusionPropertyFilter;
import org.openspcoop.utils.serialization.IDeserializer;
import org.openspcoop.utils.serialization.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLDeserializer
implements IDeserializer {
    private XMLSerializer xmlSerializer = new XMLSerializer();
    private JsonConfig jsonConfig;

    public XMLDeserializer() {
        this(null);
    }

    public XMLDeserializer(String[] excludes) {
        JsonConfig jsonConfig = new JsonConfig();
        if (excludes != null) {
            jsonConfig.setJavaPropertyFilter((PropertyFilter)new ExclusionPropertyFilter(excludes));
        }
        this.jsonConfig = jsonConfig;
    }

    @Override
    public Object getObject(String s, Class<?> classType) throws IOException {
        return this.getObject(s, classType, null);
    }

    public Object getListObject(String s, Class<?> listType, Class<?> elementsTypes) throws IOException {
        Object o = this.getObject(s, listType, elementsTypes);
        if (!(o instanceof List)) {
            throw new IOException("Object de-serializzato di tipo non java.util.List: " + o.getClass().getName());
        }
        return o;
    }

    public Object getSetObject(String s, Class<?> setType, Class<?> elementsTypes) throws IOException {
        Object o = this.getObject(s, setType, elementsTypes);
        if (!(o instanceof Set)) {
            throw new IOException("Object de-serializzato di tipo non java.util.Set: " + o.getClass().getName());
        }
        return o;
    }

    private Object getObject(String s, Class<?> classType, Class<?> elementsTypes) throws IOException {
        try {
            return this.readObject_engine(s, classType, elementsTypes);
        }
        catch (Exception e) {
            throw new IOException("Trasformazione in oggetto non riuscita: " + e.getMessage(), e);
        }
    }

    @Override
    public Object readObject(InputStream is, Class<?> classType) throws IOException {
        return this.readObject(is, classType, null);
    }

    public Object readListObject(InputStream is, Class<?> listType, Class<?> elementsTypes) throws IOException {
        Object o = this.readObject(is, listType, elementsTypes);
        if (!(o instanceof List)) {
            throw new IOException("Object de-serializzato di tipo non java.util.List: " + o.getClass().getName());
        }
        return o;
    }

    public Object readSetObject(InputStream is, Class<?> setType, Class<?> elementsTypes) throws IOException {
        Object o = this.readObject(is, setType, elementsTypes);
        if (!(o instanceof Set)) {
            throw new IOException("Object de-serializzato di tipo non java.util.Set: " + o.getClass().getName());
        }
        return o;
    }

    private Object readObject(InputStream is, Class<?> classType, Class<?> elementsTypes) throws IOException {
        try {
            byte[] reads = new byte[65536];
            int letti = 0;
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            while ((letti = is.read(reads)) != -1) {
                bout.write(reads, 0, letti);
            }
            bout.flush();
            bout.close();
            return this.readObject_engine(bout.toString(), classType, elementsTypes);
        }
        catch (Exception e) {
            throw new IOException("Trasformazione in oggetto non riuscita: " + e.getMessage(), e);
        }
    }

    @Override
    public Object readObject(Reader reader, Class<?> classType) throws IOException {
        return this.readObject(reader, classType, null);
    }

    public Object readListObject(Reader reader, Class<?> listType, Class<?> elementsTypes) throws IOException {
        Object o = this.readObject(reader, listType, elementsTypes);
        if (!(o instanceof List)) {
            throw new IOException("Object de-serializzato di tipo non java.util.List: " + o.getClass().getName());
        }
        return o;
    }

    public Object readSetObject(Reader reader, Class<?> setType, Class<?> elementsTypes) throws IOException {
        Object o = this.readObject(reader, setType, elementsTypes);
        if (!(o instanceof Set)) {
            throw new IOException("Object de-serializzato di tipo non java.util.Set: " + o.getClass().getName());
        }
        return o;
    }

    private Object readObject(Reader reader, Class<?> classType, Class<?> elementsTypes) throws IOException {
        try {
            char[] reads = new char[65536];
            int letti = 0;
            StringBuffer bf = new StringBuffer();
            while ((letti = reader.read(reads)) != -1) {
                bf.append(reads, 0, letti);
            }
            return this.readObject_engine(bf.toString(), classType, elementsTypes);
        }
        catch (Exception e) {
            throw new IOException("Trasformazione in oggetto non riuscita: " + e.getMessage(), e);
        }
    }

    private Object readObject_engine(String object, Class<?> classType, Class<?> elementsTypes) throws Exception {
        boolean list = false;
        try {
            classType.asSubclass(List.class);
            list = true;
        }
        catch (ClassCastException cc) {
            // empty catch block
        }
        boolean set = false;
        try {
            classType.asSubclass(Set.class);
            set = true;
        }
        catch (ClassCastException cc) {
            // empty catch block
        }
        if (classType.isEnum()) {
            JSON oResult = this.xmlSerializer.read(object);
            Object en = null;
            if (oResult instanceof JSONObject) {
                JSONObject jsonObject = (JSONObject)oResult;
                en = jsonObject.get(jsonObject.keys().next());
            } else {
                JSONArray jsonArray = (JSONArray)oResult;
                en = jsonArray.toArray()[0];
            }
            ?[] o = classType.getEnumConstants();
            Class<?> enumeration = o[0].getClass();
            Method method = enumeration.getMethod("valueOf", String.class);
            Object value = method.invoke(enumeration, en);
            return value;
        }
        if (classType.isArray()) {
            JSON oResult = this.xmlSerializer.read(object);
            if (oResult instanceof JSONObject) {
                JSONObject jsonObject = (JSONObject)oResult;
                Iterator it = jsonObject.keys();
                Object[] array = new Object[jsonObject.values().size()];
                int i = 0;
                while (it.hasNext()) {
                    Object key = it.next();
                    Object value = jsonObject.get(key);
                    JSONObject json = (JSONObject)value;
                    this.jsonConfig.setRootClass(classType.getComponentType());
                    array[i] = JSONObject.toBean((JSONObject)json, (JsonConfig)this.jsonConfig);
                    ++i;
                }
                return array;
            }
            JSONArray jsonArray = (JSONArray)oResult;
            Object[] oarray = jsonArray.toArray();
            Object[] array = new Object[oarray.length];
            for (int i = 0; i < oarray.length; ++i) {
                JSONObject json = (JSONObject)oarray[i];
                this.jsonConfig.setRootClass(classType.getComponentType());
                array[i] = JSONObject.toBean((JSONObject)json, (JsonConfig)this.jsonConfig);
            }
            return array;
        }
        if (list) {
            if (elementsTypes == null) {
                throw new Exception("elementsTypes non definito, e' obbligatorio per il tipo che si desidera de-serializzare: " + classType.getName());
            }
            JSON oResult = this.xmlSerializer.read(object);
            if (oResult instanceof JSONObject) {
                JSONObject jsonObject = (JSONObject)oResult;
                Iterator it = jsonObject.keys();
                List listReturn = (List)classType.newInstance();
                while (it.hasNext()) {
                    Object key = it.next();
                    Object value = jsonObject.get(key);
                    JSONObject json = (JSONObject)value;
                    this.jsonConfig.setRootClass(elementsTypes);
                    Object o = JSONObject.toBean((JSONObject)json, (JsonConfig)this.jsonConfig);
                    listReturn.add(o);
                }
                return listReturn;
            }
            JSONArray jsonArray = (JSONArray)oResult;
            Object[] oarray = jsonArray.toArray();
            List listReturn = (List)classType.newInstance();
            for (int i = 0; i < oarray.length; ++i) {
                JSONObject json = (JSONObject)oarray[i];
                this.jsonConfig.setRootClass(elementsTypes);
                Object o = JSONObject.toBean((JSONObject)json, (JsonConfig)this.jsonConfig);
                listReturn.add(o);
            }
            return listReturn;
        }
        if (set) {
            if (elementsTypes == null) {
                throw new Exception("elementsTypes non definito, e' obbligatorio per il tipo che si desidera de-serializzare: " + classType.getName());
            }
            JSON oResult = this.xmlSerializer.read(object);
            if (oResult instanceof JSONObject) {
                JSONObject jsonObject = (JSONObject)oResult;
                Iterator it = jsonObject.keys();
                Set setReturn = (Set)classType.newInstance();
                while (it.hasNext()) {
                    Object key = it.next();
                    Object value = jsonObject.get(key);
                    JSONObject json = (JSONObject)value;
                    this.jsonConfig.setRootClass(elementsTypes);
                    Object o = JSONObject.toBean((JSONObject)json, (JsonConfig)this.jsonConfig);
                    setReturn.add(o);
                }
                return setReturn;
            }
            JSONArray jsonArray = (JSONArray)oResult;
            Object[] oarray = jsonArray.toArray();
            Set setReturn = (Set)classType.newInstance();
            for (int i = 0; i < oarray.length; ++i) {
                JSONObject json = (JSONObject)oarray[i];
                this.jsonConfig.setRootClass(elementsTypes);
                Object o = JSONObject.toBean((JSONObject)json, (JsonConfig)this.jsonConfig);
                setReturn.add(o);
            }
            return setReturn;
        }
        JSONObject jsonObject = (JSONObject)this.xmlSerializer.read(object);
        this.jsonConfig.setRootClass(classType);
        return JSONObject.toBean((JSONObject)jsonObject, (JsonConfig)this.jsonConfig);
    }
}

