/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.utils.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.StringReader;
import org.openspcoop.utils.serialization.IDeserializer;
import org.openspcoop.utils.serialization.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaDeserializer
implements IDeserializer {
    @Override
    public Object getObject(String s, Class<?> classType) throws IOException {
        StringReader reader = new StringReader(s);
        return this.readObject(reader, classType);
    }

    @Override
    public Object readObject(InputStream is, Class<?> classType) throws IOException {
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(is);
            Object o = ois.readObject();
            if (classType.isInstance(o)) {
                Object object = o;
                return object;
            }
            try {
                throw new Exception("Oggetto deserializzato non e' di tipo [" + classType.getName() + "] bensi' di tipo [" + o.getClass().getName() + "]");
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (Exception eClose) {}
        }
    }

    @Override
    public Object readObject(Reader reader, Class<?> classType) throws IOException {
        ObjectInputStream ois = null;
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            int letti = 0;
            char[] buffer = new char[65536];
            while ((letti = reader.read(buffer)) != -1) {
                for (int i = 0; i < letti; ++i) {
                    bout.write(buffer[i]);
                }
            }
            bout.flush();
            bout.close();
            ois = new ObjectInputStream(new ByteArrayInputStream(bout.toByteArray()));
            Object o = ois.readObject();
            if (classType.isInstance(o)) {
                Object object = o;
                return object;
            }
            try {
                throw new Exception("Oggetto deserializzato non e' di tipo [" + classType.getName() + "] bensi' di tipo [" + o.getClass().getName() + "]");
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (Exception eClose) {}
        }
    }
}

