/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.utils.serialization;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.openspcoop.dao.registry.AccordoServizio;
import org.openspcoop.dao.registry.AccordoServizioSoggettoReferente;
import org.openspcoop.dao.registry.Connettore;
import org.openspcoop.dao.registry.ConnettoreProperty;
import org.openspcoop.dao.registry.Documento;
import org.openspcoop.dao.registry.SoggettoSpcoop;
import org.openspcoop.dao.registry.driver.IDAccordo;
import org.openspcoop.utils.Utilities;
import org.openspcoop.utils.date.DateManager;
import org.openspcoop.utils.serialization.Filter;
import org.openspcoop.utils.serialization.JSonDeserializer;
import org.openspcoop.utils.serialization.JSonSerializer;
import org.openspcoop.utils.serialization.JavaDeserializer;
import org.openspcoop.utils.serialization.JavaSerializer;
import org.openspcoop.utils.serialization.XMLDeserializer;
import org.openspcoop.utils.serialization.XMLSerializer;

public class ClientTest {
    public static void main(String[] args) throws Exception {
        long dataInizio = -1L;
        long dataFine = -1L;
        File dir = new File(".");
        if (args.length > 0) {
            dir = new File(args[0].trim());
            if (dir.exists()) {
                if (dir.isDirectory()) {
                    throw new Exception("Directory [" + dir.getAbsolutePath() + "] gia' esistente");
                }
                throw new Exception("Location [" + dir.getAbsolutePath() + "] gia' esistente e inoltre non e' una directory");
            }
            if (!dir.mkdir()) {
                throw new Exception("Directory [" + dir.getAbsolutePath() + "] non creabile");
            }
        }
        SoggettoSpcoop soggettoTest = new SoggettoSpcoop();
        soggettoTest.setTipo("SPC");
        soggettoTest.setNome("SoggettoTest");
        soggettoTest.setCodiceIpa("o=test,c=it");
        soggettoTest.setIdentificativoPorta("SoggettoTestSPCoopIT");
        soggettoTest.setDescrizione("Test package");
        soggettoTest.setIsRouter(false);
        soggettoTest.setOraRegistrazione(DateManager.getDate());
        soggettoTest.setPortaDominio("pdd");
        soggettoTest.setPrivato(false);
        soggettoTest.setProfilo("linee guida");
        soggettoTest.setSuperUser("amministratore");
        Connettore connettore = new Connettore();
        connettore.setNome("ConnettoreTest");
        connettore.setTipo("http");
        ConnettoreProperty pr = new ConnettoreProperty();
        pr.setNome("location");
        pr.setValore("http://localhost:8080/openspcoop/PA");
        connettore.addProperty(pr);
        soggettoTest.setConnettore(connettore);
        AccordoServizio as = new AccordoServizio();
        as.setNome("ASTEST");
        as.setVersione("1");
        AccordoServizioSoggettoReferente sogg = new AccordoServizioSoggettoReferente();
        sogg.setTipo("SPC");
        sogg.setNome("SoggettoReferente");
        as.setSoggettoReferente(sogg);
        as.setByteWsdlDefinitorio("<xsd>TEST<xsd>".getBytes());
        as.setByteWsdlConcettuale("<wsdl>TEST<wsdl>".getBytes());
        as.setByteWsdlLogicoErogatore("<wsdl>TEST<wsdl>".getBytes());
        as.setPrivato(false);
        Documento allegato1 = new Documento();
        allegato1.setFile("TEST.txt");
        allegato1.setByteContenuto("TEST HELLO WORLD".getBytes());
        as.addAllegato(allegato1);
        SoggettoSpcoop s1 = (SoggettoSpcoop)soggettoTest.clone();
        s1.setNome("SoggettoTest1");
        SoggettoSpcoop s2 = (SoggettoSpcoop)soggettoTest.clone();
        s2.setNome("SoggettoTest2");
        SoggettoSpcoop s3 = (SoggettoSpcoop)soggettoTest.clone();
        s3.setNome("SoggettoTest3");
        SoggettoSpcoop s4 = (SoggettoSpcoop)soggettoTest.clone();
        s4.setNome("SoggettoTest4");
        SoggettoSpcoop s5 = (SoggettoSpcoop)soggettoTest.clone();
        s5.setNome("SoggettoTest5");
        SoggettoSpcoop s6 = (SoggettoSpcoop)soggettoTest.clone();
        s6.setNome("SoggettoTest6");
        SoggettoSpcoop s7 = (SoggettoSpcoop)soggettoTest.clone();
        s7.setNome("SoggettoTest7");
        String[] excludesJson_SoggettoSPCoop = new String[]{"servizio", "servizioCorrelato", "property"};
        String[] excludesJson_AccordiServizio = new String[]{"specificaSemiformale", "allegato", "azione", "portType"};
        String[] excludesJson_date = new String[]{"day", "timezoneOffset"};
        LinkedList<Cloneable> testSerializzazioneLista = new LinkedList<Cloneable>();
        testSerializzazioneLista.add(as);
        testSerializzazioneLista.add(s1);
        testSerializzazioneLista.add(s2);
        testSerializzazioneLista.add(s3);
        testSerializzazioneLista.add(s4);
        testSerializzazioneLista.add(s5);
        testSerializzazioneLista.add(s6);
        testSerializzazioneLista.add(s7);
        LinkedList<SoggettoSpcoop> testSerializzazioneListaSoggetti = new LinkedList<SoggettoSpcoop>();
        testSerializzazioneListaSoggetti.add(s1);
        testSerializzazioneListaSoggetti.add(s2);
        testSerializzazioneListaSoggetti.add(s3);
        testSerializzazioneListaSoggetti.add(s4);
        testSerializzazioneListaSoggetti.add(s5);
        testSerializzazioneListaSoggetti.add(s6);
        testSerializzazioneListaSoggetti.add(s7);
        LinkedList<AccordoServizio> testSerializzazioneListaAccordi = new LinkedList<AccordoServizio>();
        testSerializzazioneListaAccordi.add(as);
        HashSet<Cloneable> testSerializzazioneSet = new HashSet<Cloneable>();
        testSerializzazioneSet.add(as);
        testSerializzazioneSet.add(s1);
        testSerializzazioneSet.add(s2);
        testSerializzazioneSet.add(s3);
        testSerializzazioneSet.add(s4);
        testSerializzazioneSet.add(s5);
        testSerializzazioneSet.add(s6);
        testSerializzazioneSet.add(s7);
        HashSet<SoggettoSpcoop> testSerializzazioneSetSoggetti = new HashSet<SoggettoSpcoop>();
        testSerializzazioneSetSoggetti.add(s1);
        testSerializzazioneSetSoggetti.add(s2);
        testSerializzazioneSetSoggetti.add(s3);
        testSerializzazioneSetSoggetti.add(s4);
        testSerializzazioneSetSoggetti.add(s5);
        testSerializzazioneSetSoggetti.add(s6);
        testSerializzazioneSetSoggetti.add(s7);
        HashSet<AccordoServizio> testSerializzazioneSetAccordi = new HashSet<AccordoServizio>();
        testSerializzazioneSetAccordi.add(as);
        System.out.println();
        System.out.println("********** Serializzazione Java (SingleObject) ****************");
        System.out.println();
        File javaFileStream = new File(dir, "singleObjectStream.ser");
        FileOutputStream foutJava = new FileOutputStream(javaFileStream);
        FileInputStream finJava = new FileInputStream(javaFileStream);
        System.out.print("- Serializzazione (Stream in/out): ");
        JavaSerializer javaSerializer = new JavaSerializer();
        dataInizio = DateManager.getTimeMillis();
        javaSerializer.writeObject((Object)soggettoTest, foutJava);
        dataFine = DateManager.getTimeMillis();
        foutJava.flush();
        foutJava.close();
        System.out.print("OK\n");
        System.out.println("- Costo ms serializzazione java: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println("- Dimensione oggetto serializzato: " + Utilities.convertBytesToFormatString(javaFileStream.length()));
        System.out.print("- Deserializzazione (Stream in/out): ");
        JavaDeserializer javaDeserializer = new JavaDeserializer();
        dataInizio = DateManager.getTimeMillis();
        Object oJavaRead = javaDeserializer.readObject(finJava, soggettoTest.getClass());
        dataFine = DateManager.getTimeMillis();
        finJava.close();
        ClientTest.equals(soggettoTest, (SoggettoSpcoop)oJavaRead, dir);
        System.out.print("OK, nome soggetto: " + ((SoggettoSpcoop)oJavaRead).getTipo() + "/" + ((SoggettoSpcoop)oJavaRead).getNome() + "\n");
        System.out.println("- Costo ms deserializzazione java: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println();
        File javaFileReader = new File(dir, "singleObjectReader.ser");
        FileWriter fwriterJava = new FileWriter(javaFileReader);
        FileReader freaderJava = new FileReader(javaFileReader);
        System.out.print("- Serializzazione (Reader/Writer): ");
        javaSerializer = new JavaSerializer();
        dataInizio = DateManager.getTimeMillis();
        javaSerializer.writeObject((Object)as, fwriterJava);
        dataFine = DateManager.getTimeMillis();
        fwriterJava.flush();
        fwriterJava.close();
        System.out.print("OK\n");
        System.out.println("- Costo ms serializzazione java: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println("- Dimensione oggetto serializzato: " + Utilities.convertBytesToFormatString(javaFileStream.length()));
        System.out.print("- Deserializzazione (Reader/Writer): ");
        javaDeserializer = new JavaDeserializer();
        dataInizio = DateManager.getTimeMillis();
        oJavaRead = javaDeserializer.readObject(freaderJava, as.getClass());
        dataFine = DateManager.getTimeMillis();
        freaderJava.close();
        ClientTest.equals(as, (AccordoServizio)oJavaRead, dir);
        System.out.print("OK, accordo: " + IDAccordo.getUriFromAccordo((AccordoServizio)oJavaRead) + " allegati:(" + ((AccordoServizio)oJavaRead).sizeAllegatoList() + ")\n");
        System.out.println("- Costo ms deserializzazione java: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println();
        System.out.print("- Serializzazione (Object): ");
        javaSerializer = new JavaSerializer();
        dataInizio = DateManager.getTimeMillis();
        String javaSerializationObject = javaSerializer.getObject(as);
        dataFine = DateManager.getTimeMillis();
        System.out.print("OK\n");
        System.out.println("- Costo ms serializzazione java: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println("- Dimensione oggetto serializzato: " + Utilities.convertBytesToFormatString(javaFileStream.length()));
        System.out.print("- Deserializzazione (Object): ");
        javaDeserializer = new JavaDeserializer();
        dataInizio = DateManager.getTimeMillis();
        oJavaRead = javaDeserializer.getObject(javaSerializationObject, as.getClass());
        dataFine = DateManager.getTimeMillis();
        freaderJava.close();
        ClientTest.equals(as, (AccordoServizio)oJavaRead, dir);
        System.out.print("OK, accordo: " + IDAccordo.getUriFromAccordo((AccordoServizio)oJavaRead) + " allegati:(" + ((AccordoServizio)oJavaRead).sizeAllegatoList() + ")\n");
        System.out.println("- Costo ms deserializzazione java: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println();
        System.out.print("- Serializzazione (Enumerations): ");
        javaSerializer = new JavaSerializer();
        dataInizio = DateManager.getTimeMillis();
        javaSerializationObject = javaSerializer.getObject(TestEnumerations.VALORE1);
        dataFine = DateManager.getTimeMillis();
        System.out.print("OK\n");
        System.out.println("- Costo ms serializzazione java: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println("- Dimensione oggetto serializzato: " + Utilities.convertBytesToFormatString(javaFileStream.length()));
        System.out.print("- Deserializzazione (Enumerations): ");
        javaDeserializer = new JavaDeserializer();
        dataInizio = DateManager.getTimeMillis();
        oJavaRead = javaDeserializer.getObject(javaSerializationObject, TestEnumerations.class);
        dataFine = DateManager.getTimeMillis();
        freaderJava.close();
        if (!((TestEnumerations)oJavaRead).toString().equals(TestEnumerations.VALORE1.toString())) {
            throw new Exception("Enumeration originale [" + TestEnumerations.VALORE1.toString() + "] e ricostruita[" + ((TestEnumerations)oJavaRead).toString() + "] differiscono");
        }
        System.out.print("OK, enum value: " + (TestEnumerations)oJavaRead + "\n");
        System.out.println("- Costo ms deserializzazione java: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println();
        System.out.println();
        System.out.println("********** Serializzazione Java (Array/List/Set) ****************");
        System.out.println();
        javaFileStream = new File(dir, "array.ser");
        foutJava = new FileOutputStream(javaFileStream);
        finJava = new FileInputStream(javaFileStream);
        System.out.print("- Serializzazione (Array): ");
        javaSerializer = new JavaSerializer();
        dataInizio = DateManager.getTimeMillis();
        javaSerializer.writeObject((Object)testSerializzazioneLista.toArray(), foutJava);
        dataFine = DateManager.getTimeMillis();
        foutJava.flush();
        foutJava.close();
        System.out.print("OK\n");
        System.out.println("- Costo ms serializzazione java: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println("- Dimensione oggetto serializzato: " + Utilities.convertBytesToFormatString(javaFileStream.length()));
        System.out.print("- Deserializzazione (Array): ");
        javaDeserializer = new JavaDeserializer();
        dataInizio = DateManager.getTimeMillis();
        oJavaRead = javaDeserializer.readObject(finJava, testSerializzazioneLista.toArray().getClass());
        dataFine = DateManager.getTimeMillis();
        finJava.close();
        Object[] vJavaArray = (Object[])oJavaRead;
        ClientTest.equalsOpenSPCoopObject(testSerializzazioneLista.toArray(), vJavaArray, dir);
        System.out.print("OK, nome soggetto: " + ((SoggettoSpcoop)vJavaArray[1]).getTipo() + "/" + ((SoggettoSpcoop)vJavaArray[1]).getNome() + "   nome accordo: " + IDAccordo.getUriFromAccordo((AccordoServizio)vJavaArray[0]) + " allegati:(" + ((AccordoServizio)vJavaArray[0]).sizeAllegatoList() + ")\n");
        System.out.println("- Costo ms deserializzazione java: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println();
        javaFileStream = new File(dir, "list.ser");
        foutJava = new FileOutputStream(javaFileStream);
        finJava = new FileInputStream(javaFileStream);
        System.out.print("- Serializzazione (List): ");
        javaSerializer = new JavaSerializer();
        dataInizio = DateManager.getTimeMillis();
        javaSerializer.writeObject(testSerializzazioneLista, foutJava);
        dataFine = DateManager.getTimeMillis();
        foutJava.flush();
        foutJava.close();
        System.out.print("OK\n");
        System.out.println("- Costo ms serializzazione java: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println("- Dimensione oggetto serializzato: " + Utilities.convertBytesToFormatString(javaFileStream.length()));
        System.out.print("- Deserializzazione (List): ");
        javaDeserializer = new JavaDeserializer();
        dataInizio = DateManager.getTimeMillis();
        oJavaRead = javaDeserializer.readObject(finJava, testSerializzazioneLista.getClass());
        dataFine = DateManager.getTimeMillis();
        finJava.close();
        List vJavaList = (List)oJavaRead;
        ClientTest.equalsOpenSPCoopObject(testSerializzazioneLista.toArray(), vJavaList.toArray(), dir);
        System.out.print("OK, nome soggetto: " + ((SoggettoSpcoop)vJavaList.get(1)).getTipo() + "/" + ((SoggettoSpcoop)vJavaList.get(1)).getNome() + "   nome accordo: " + IDAccordo.getUriFromAccordo((AccordoServizio)vJavaList.get(0)) + " allegati:(" + ((AccordoServizio)vJavaList.get(0)).sizeAllegatoList() + ")\n");
        System.out.println("- Costo ms deserializzazione java: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println();
        javaFileStream = new File(dir, "set.ser");
        foutJava = new FileOutputStream(javaFileStream);
        finJava = new FileInputStream(javaFileStream);
        System.out.print("- Serializzazione (Set): ");
        javaSerializer = new JavaSerializer();
        dataInizio = DateManager.getTimeMillis();
        javaSerializer.writeObject(testSerializzazioneSet, foutJava);
        dataFine = DateManager.getTimeMillis();
        foutJava.flush();
        foutJava.close();
        System.out.print("OK\n");
        System.out.println("- Costo ms serializzazione java: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println("- Dimensione oggetto serializzato: " + Utilities.convertBytesToFormatString(javaFileStream.length()));
        System.out.print("- Deserializzazione (Set): ");
        javaDeserializer = new JavaDeserializer();
        dataInizio = DateManager.getTimeMillis();
        oJavaRead = javaDeserializer.readObject(finJava, testSerializzazioneSet.getClass());
        dataFine = DateManager.getTimeMillis();
        finJava.close();
        Set vJavaSet = (Set)oJavaRead;
        ClientTest.equalsOpenSPCoopObject(testSerializzazioneLista.toArray(), vJavaSet.toArray(), dir);
        System.out.print("OK, dimensione set: " + vJavaSet.size() + ")\n");
        System.out.println("- Costo ms deserializzazione java: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println("********** Serializzazione Json (SingleObject) ****************");
        System.out.println();
        File jsonFileStream = new File(dir, "singleObjectStream.json");
        FileOutputStream foutJson = new FileOutputStream(jsonFileStream);
        FileInputStream finJson = new FileInputStream(jsonFileStream);
        System.out.print("- Serializzazione (Stream in/out): ");
        Filter filter = new Filter();
        JSonSerializer jsonSerializer = new JSonSerializer(filter, excludesJson_SoggettoSPCoop);
        dataInizio = DateManager.getTimeMillis();
        jsonSerializer.writeObject((Object)soggettoTest, foutJson);
        dataFine = DateManager.getTimeMillis();
        foutJson.flush();
        foutJson.close();
        System.out.print("OK\n");
        System.out.println("- Costo ms serializzazione json: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println("- Dimensione oggetto serializzato: " + Utilities.convertBytesToFormatString(jsonFileStream.length()));
        System.out.print("- Deserializzazione (Stream in/out): ");
        JSonDeserializer jsonDeserializer = new JSonDeserializer(excludesJson_date);
        dataInizio = DateManager.getTimeMillis();
        Object oJsonRead = jsonDeserializer.readObject(finJson, soggettoTest.getClass());
        dataFine = DateManager.getTimeMillis();
        finJson.close();
        ClientTest.equals(soggettoTest, (SoggettoSpcoop)oJsonRead, dir);
        System.out.print("OK, nome soggetto: " + ((SoggettoSpcoop)oJsonRead).getTipo() + "/" + ((SoggettoSpcoop)oJsonRead).getNome() + "\n");
        System.out.println("- Costo ms deserializzazione json: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println();
        File jsonFileReader = new File(dir, "singleObjectReader.json");
        FileWriter fwriterJson = new FileWriter(jsonFileReader);
        FileReader freaderJson = new FileReader(jsonFileReader);
        System.out.print("- Serializzazione (Reader/Writer): ");
        jsonSerializer = new JSonSerializer(filter, excludesJson_AccordiServizio);
        dataInizio = DateManager.getTimeMillis();
        jsonSerializer.writeObject((Object)as, fwriterJson);
        dataFine = DateManager.getTimeMillis();
        fwriterJson.flush();
        fwriterJson.close();
        System.out.print("OK\n");
        System.out.println("- Costo ms serializzazione json: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println("- Dimensione oggetto serializzato: " + Utilities.convertBytesToFormatString(jsonFileStream.length()));
        System.out.print("- Deserializzazione (Reader/Writer): ");
        jsonDeserializer = new JSonDeserializer(excludesJson_date);
        dataInizio = DateManager.getTimeMillis();
        oJsonRead = jsonDeserializer.readObject(freaderJson, as.getClass());
        dataFine = DateManager.getTimeMillis();
        freaderJson.close();
        ClientTest.equals(as, (AccordoServizio)oJsonRead, dir);
        System.out.print("OK, accordo: " + IDAccordo.getUriFromAccordo((AccordoServizio)oJsonRead) + " allegati:(" + ((AccordoServizio)oJsonRead).sizeAllegatoList() + ")\n");
        System.out.println("- Costo ms deserializzazione json: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println();
        System.out.print("- Serializzazione (Object): ");
        jsonSerializer = new JSonSerializer(filter, excludesJson_AccordiServizio);
        dataInizio = DateManager.getTimeMillis();
        String jsonSerializationObject = jsonSerializer.getObject(as);
        dataFine = DateManager.getTimeMillis();
        System.out.print("OK\n");
        System.out.println("- Costo ms serializzazione json: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println("- Dimensione oggetto serializzato: " + Utilities.convertBytesToFormatString(jsonFileStream.length()));
        System.out.print("- Deserializzazione (Object): ");
        jsonDeserializer = new JSonDeserializer(excludesJson_date);
        dataInizio = DateManager.getTimeMillis();
        oJsonRead = jsonDeserializer.getObject(jsonSerializationObject, as.getClass());
        dataFine = DateManager.getTimeMillis();
        freaderJson.close();
        ClientTest.equals(as, (AccordoServizio)oJsonRead, dir);
        System.out.print("OK, accordo: " + IDAccordo.getUriFromAccordo((AccordoServizio)oJsonRead) + " allegati:(" + ((AccordoServizio)oJsonRead).sizeAllegatoList() + ")\n");
        System.out.println("- Costo ms deserializzazione json: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println();
        System.out.print("- Serializzazione (Enumerations): ");
        jsonSerializer = new JSonSerializer(filter);
        dataInizio = DateManager.getTimeMillis();
        jsonSerializationObject = jsonSerializer.getObject(TestEnumerations.VALORE1);
        dataFine = DateManager.getTimeMillis();
        System.out.print("OK\n");
        System.out.println("- Costo ms serializzazione json: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println("- Dimensione oggetto serializzato: " + Utilities.convertBytesToFormatString(jsonFileStream.length()));
        System.out.print("- Deserializzazione (Enumerations): ");
        jsonDeserializer = new JSonDeserializer();
        dataInizio = DateManager.getTimeMillis();
        oJsonRead = jsonDeserializer.getObject(jsonSerializationObject, TestEnumerations.class);
        dataFine = DateManager.getTimeMillis();
        freaderJson.close();
        if (!((TestEnumerations)oJsonRead).toString().equals(TestEnumerations.VALORE1.toString())) {
            throw new Exception("Enumeration originale [" + TestEnumerations.VALORE1.toString() + "] e ricostruita[" + ((TestEnumerations)oJsonRead).toString() + "] differiscono");
        }
        System.out.print("OK, enum value: " + (TestEnumerations)oJsonRead + "\n");
        System.out.println("- Costo ms deserializzazione json: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println();
        System.out.println();
        System.out.println("********** Serializzazione Json (Array/List/Set) ****************");
        System.out.println();
        jsonFileStream = new File(dir, "array.accordi.json");
        foutJson = new FileOutputStream(jsonFileStream);
        finJson = new FileInputStream(jsonFileStream);
        System.out.print("- Serializzazione (Array)(Accordi): ");
        jsonSerializer = new JSonSerializer(filter, excludesJson_AccordiServizio);
        dataInizio = DateManager.getTimeMillis();
        AccordoServizio[] arrayJsonTestAccordi = testSerializzazioneListaAccordi.toArray(new AccordoServizio[1]);
        jsonSerializer.writeObject((Object)arrayJsonTestAccordi, foutJson);
        dataFine = DateManager.getTimeMillis();
        foutJson.flush();
        foutJson.close();
        System.out.print("OK\n");
        System.out.println("- Costo ms serializzazione json: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println("- Dimensione oggetto serializzato: " + Utilities.convertBytesToFormatString(jsonFileStream.length()));
        System.out.print("- Deserializzazione (Array)(Accordi): ");
        jsonDeserializer = new JSonDeserializer(excludesJson_date);
        dataInizio = DateManager.getTimeMillis();
        oJsonRead = jsonDeserializer.readObject(finJson, AccordoServizio[].class);
        dataFine = DateManager.getTimeMillis();
        finJson.close();
        Object[] vJsonArray = (Object[])oJsonRead;
        AccordoServizio[] vJsonArrayTestAccordi = new AccordoServizio[vJsonArray.length];
        for (int i = 0; i < vJsonArray.length; ++i) {
            vJsonArrayTestAccordi[i] = (AccordoServizio)vJsonArray[i];
        }
        ClientTest.equals(arrayJsonTestAccordi, vJsonArrayTestAccordi, dir);
        System.out.print("OK, nome accordo: " + IDAccordo.getUriFromAccordo((AccordoServizio)vJsonArray[0]) + " allegati:(" + ((AccordoServizio)vJsonArray[0]).sizeAllegatoList() + ")\n");
        System.out.println("- Costo ms deserializzazione json: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println();
        jsonFileStream = new File(dir, "array.soggetti.json");
        foutJson = new FileOutputStream(jsonFileStream);
        finJson = new FileInputStream(jsonFileStream);
        System.out.print("- Serializzazione (Array)(Soggetti): ");
        jsonSerializer = new JSonSerializer(filter, excludesJson_SoggettoSPCoop);
        dataInizio = DateManager.getTimeMillis();
        SoggettoSpcoop[] arrayJsonTestSoggetti = testSerializzazioneListaSoggetti.toArray(new SoggettoSpcoop[testSerializzazioneListaSoggetti.size()]);
        jsonSerializer.writeObject((Object)arrayJsonTestSoggetti, foutJson);
        dataFine = DateManager.getTimeMillis();
        foutJson.flush();
        foutJson.close();
        System.out.print("OK\n");
        System.out.println("- Costo ms serializzazione json: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println("- Dimensione oggetto serializzato: " + Utilities.convertBytesToFormatString(jsonFileStream.length()));
        System.out.print("- Deserializzazione (Array)(Soggetti): ");
        jsonDeserializer = new JSonDeserializer(excludesJson_date);
        dataInizio = DateManager.getTimeMillis();
        oJsonRead = jsonDeserializer.readObject(finJson, SoggettoSpcoop[].class);
        dataFine = DateManager.getTimeMillis();
        finJson.close();
        vJsonArray = (Object[])oJsonRead;
        SoggettoSpcoop[] vJsonArrayTestSoggetti = new SoggettoSpcoop[vJsonArray.length];
        for (int i = 0; i < vJsonArray.length; ++i) {
            vJsonArrayTestSoggetti[i] = (SoggettoSpcoop)vJsonArray[i];
        }
        ClientTest.equals(arrayJsonTestSoggetti, vJsonArrayTestSoggetti, dir);
        System.out.print("OK, nome soggetto: " + ((SoggettoSpcoop)vJsonArray[1]).getTipo() + "/" + ((SoggettoSpcoop)vJsonArray[1]).getNome() + "\n");
        System.out.println("- Costo ms deserializzazione json: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println();
        jsonFileStream = new File(dir, "list.accordi.json");
        foutJson = new FileOutputStream(jsonFileStream);
        finJson = new FileInputStream(jsonFileStream);
        System.out.print("- Serializzazione (List)(Accordi): ");
        jsonSerializer = new JSonSerializer(filter, excludesJson_AccordiServizio);
        dataInizio = DateManager.getTimeMillis();
        jsonSerializer.writeObject(testSerializzazioneListaAccordi, foutJson);
        dataFine = DateManager.getTimeMillis();
        foutJson.flush();
        foutJson.close();
        System.out.print("OK\n");
        System.out.println("- Costo ms serializzazione json: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println("- Dimensione oggetto serializzato: " + Utilities.convertBytesToFormatString(jsonFileStream.length()));
        System.out.print("- Deserializzazione (List)(Accordi): ");
        jsonDeserializer = new JSonDeserializer(excludesJson_date);
        dataInizio = DateManager.getTimeMillis();
        oJsonRead = jsonDeserializer.readListObject(finJson, testSerializzazioneListaAccordi.getClass(), AccordoServizio.class);
        dataFine = DateManager.getTimeMillis();
        finJson.close();
        List vJsonList = (List)oJsonRead;
        AccordoServizio[] originaleAccordi = testSerializzazioneSetAccordi.toArray(new AccordoServizio[1]);
        AccordoServizio[] ricostruitoAccordi = vJsonList.toArray(new AccordoServizio[1]);
        ClientTest.equals(originaleAccordi, ricostruitoAccordi, dir);
        System.out.print("OK, nome accordo: " + IDAccordo.getUriFromAccordo((AccordoServizio)vJsonList.get(0)) + " allegati:(" + ((AccordoServizio)vJsonList.get(0)).sizeAllegatoList() + ")\n");
        System.out.println("- Costo ms deserializzazione json: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println();
        jsonFileStream = new File(dir, "list.soggetti.json");
        foutJson = new FileOutputStream(jsonFileStream);
        finJson = new FileInputStream(jsonFileStream);
        System.out.print("- Serializzazione (List)(Soggetti): ");
        jsonSerializer = new JSonSerializer(filter, excludesJson_SoggettoSPCoop);
        dataInizio = DateManager.getTimeMillis();
        jsonSerializer.writeObject(testSerializzazioneListaSoggetti, foutJson);
        dataFine = DateManager.getTimeMillis();
        foutJson.flush();
        foutJson.close();
        System.out.print("OK\n");
        System.out.println("- Costo ms serializzazione json: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println("- Dimensione oggetto serializzato: " + Utilities.convertBytesToFormatString(jsonFileStream.length()));
        System.out.print("- Deserializzazione (List)(Soggetti): ");
        jsonDeserializer = new JSonDeserializer(excludesJson_date);
        dataInizio = DateManager.getTimeMillis();
        oJsonRead = jsonDeserializer.readListObject(finJson, testSerializzazioneListaSoggetti.getClass(), SoggettoSpcoop.class);
        dataFine = DateManager.getTimeMillis();
        finJson.close();
        vJsonList = (List)oJsonRead;
        SoggettoSpcoop[] originaleSoggetti = testSerializzazioneSetSoggetti.toArray(new SoggettoSpcoop[1]);
        SoggettoSpcoop[] ricostruitoSoggetti = vJsonList.toArray(new SoggettoSpcoop[1]);
        System.out.print("OK, nome soggetto: " + ((SoggettoSpcoop)vJsonList.get(1)).getTipo() + "/" + ((SoggettoSpcoop)vJsonList.get(1)).getNome() + ")\n");
        System.out.println("- Costo ms deserializzazione json: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println();
        jsonFileStream = new File(dir, "set.accordi.json");
        foutJson = new FileOutputStream(jsonFileStream);
        finJson = new FileInputStream(jsonFileStream);
        System.out.print("- Serializzazione (Set)(Accordi) (E' normale uno stackatrace: IllegalArgumentException): ");
        jsonSerializer = new JSonSerializer(filter, excludesJson_AccordiServizio);
        dataInizio = DateManager.getTimeMillis();
        jsonSerializer.writeObject(testSerializzazioneSetAccordi, foutJson);
        dataFine = DateManager.getTimeMillis();
        foutJson.flush();
        foutJson.close();
        System.out.print("OK\n");
        System.out.println("- Costo ms serializzazione json: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println("- Dimensione oggetto serializzato: " + Utilities.convertBytesToFormatString(jsonFileStream.length()));
        System.out.print("- Deserializzazione (Set)(Accordi): ");
        jsonDeserializer = new JSonDeserializer(excludesJson_date);
        dataInizio = DateManager.getTimeMillis();
        oJsonRead = jsonDeserializer.readSetObject(finJson, testSerializzazioneSetAccordi.getClass(), AccordoServizio.class);
        dataFine = DateManager.getTimeMillis();
        finJson.close();
        Set vJsonSet = (Set)oJsonRead;
        originaleAccordi = testSerializzazioneSetAccordi.toArray(new AccordoServizio[1]);
        ricostruitoAccordi = vJsonSet.toArray(new AccordoServizio[1]);
        ClientTest.equals(originaleAccordi, ricostruitoAccordi, dir);
        System.out.print("OK, dimensione set: " + vJsonSet.size() + ")\n");
        System.out.println("- Costo ms deserializzazione json: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println();
        System.out.println();
        jsonFileStream = new File(dir, "set.soggetti.json");
        foutJson = new FileOutputStream(jsonFileStream);
        finJson = new FileInputStream(jsonFileStream);
        System.out.print("- Serializzazione (Set)(Soggetti): ");
        jsonSerializer = new JSonSerializer(filter, excludesJson_SoggettoSPCoop);
        dataInizio = DateManager.getTimeMillis();
        jsonSerializer.writeObject(testSerializzazioneSetSoggetti, foutJson);
        dataFine = DateManager.getTimeMillis();
        foutJson.flush();
        foutJson.close();
        System.out.print("OK\n");
        System.out.println("- Costo ms serializzazione json: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println("- Dimensione oggetto serializzato: " + Utilities.convertBytesToFormatString(jsonFileStream.length()));
        System.out.print("- Deserializzazione (Set)(Soggetti): ");
        jsonDeserializer = new JSonDeserializer(excludesJson_date);
        dataInizio = DateManager.getTimeMillis();
        oJsonRead = jsonDeserializer.readSetObject(finJson, testSerializzazioneSetSoggetti.getClass(), SoggettoSpcoop.class);
        dataFine = DateManager.getTimeMillis();
        finJson.close();
        vJsonSet = (Set)oJsonRead;
        originaleSoggetti = testSerializzazioneSetSoggetti.toArray(new SoggettoSpcoop[1]);
        ricostruitoSoggetti = vJsonSet.toArray(new SoggettoSpcoop[1]);
        ClientTest.equals(originaleSoggetti, ricostruitoSoggetti, dir);
        System.out.print("OK, dimensione set: " + vJsonSet.size() + ")\n");
        System.out.println("- Costo ms deserializzazione json: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println("********** Serializzazione JsonXML (SingleObject) ****************");
        System.out.println();
        File jsonXMLFileStream = new File(dir, "singleObjectStream.jsonXML");
        FileOutputStream foutJsonXML = new FileOutputStream(jsonXMLFileStream);
        FileInputStream finJsonXML = new FileInputStream(jsonXMLFileStream);
        System.out.print("- Serializzazione (Stream in/out): ");
        XMLSerializer jsonXMLSerializer = new XMLSerializer(filter, excludesJson_SoggettoSPCoop);
        dataInizio = DateManager.getTimeMillis();
        jsonXMLSerializer.writeObject((Object)soggettoTest, foutJsonXML);
        dataFine = DateManager.getTimeMillis();
        foutJsonXML.flush();
        foutJsonXML.close();
        System.out.print("OK\n");
        System.out.println("- Costo ms serializzazione jsonXML: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println("- Dimensione oggetto serializzato: " + Utilities.convertBytesToFormatString(jsonXMLFileStream.length()));
        System.out.print("- Deserializzazione (Stream in/out): ");
        XMLDeserializer jsonXMLDeserializer = new XMLDeserializer(excludesJson_date);
        dataInizio = DateManager.getTimeMillis();
        Object oJsonXMLRead = jsonXMLDeserializer.readObject(finJsonXML, soggettoTest.getClass());
        dataFine = DateManager.getTimeMillis();
        finJsonXML.close();
        ClientTest.equals(soggettoTest, (SoggettoSpcoop)oJsonXMLRead, dir);
        System.out.print("OK, nome soggetto: " + ((SoggettoSpcoop)oJsonXMLRead).getTipo() + "/" + ((SoggettoSpcoop)oJsonXMLRead).getNome() + "\n");
        System.out.println("- Costo ms deserializzazione jsonXML: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println();
        File jsonXMLFileReader = new File(dir, "singleObjectReader.jsonXML");
        FileWriter fwriterJsonXML = new FileWriter(jsonXMLFileReader);
        FileReader freaderJsonXML = new FileReader(jsonXMLFileReader);
        System.out.print("- Serializzazione (Reader/Writer): ");
        jsonXMLSerializer = new XMLSerializer(filter, excludesJson_AccordiServizio);
        dataInizio = DateManager.getTimeMillis();
        jsonXMLSerializer.writeObject((Object)as, fwriterJsonXML);
        dataFine = DateManager.getTimeMillis();
        fwriterJsonXML.flush();
        fwriterJsonXML.close();
        System.out.print("OK\n");
        System.out.println("- Costo ms serializzazione jsonXML: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println("- Dimensione oggetto serializzato: " + Utilities.convertBytesToFormatString(jsonXMLFileStream.length()));
        System.out.print("- Deserializzazione (Reader/Writer): ");
        jsonXMLDeserializer = new XMLDeserializer(excludesJson_date);
        dataInizio = DateManager.getTimeMillis();
        oJsonXMLRead = jsonXMLDeserializer.readObject(freaderJsonXML, as.getClass());
        dataFine = DateManager.getTimeMillis();
        freaderJsonXML.close();
        ClientTest.equals(as, (AccordoServizio)oJsonXMLRead, dir);
        System.out.print("OK, accordo: " + IDAccordo.getUriFromAccordo((AccordoServizio)oJsonXMLRead) + " allegati:(" + ((AccordoServizio)oJsonXMLRead).sizeAllegatoList() + ")\n");
        System.out.println("- Costo ms deserializzazione jsonXML: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println();
        System.out.print("- Serializzazione (Object): ");
        jsonXMLSerializer = new XMLSerializer(filter, excludesJson_AccordiServizio);
        dataInizio = DateManager.getTimeMillis();
        String jsonXMLSerializationObject = jsonXMLSerializer.getObject(as);
        dataFine = DateManager.getTimeMillis();
        System.out.print("OK\n");
        System.out.println("- Costo ms serializzazione jsonXML: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println("- Dimensione oggetto serializzato: " + Utilities.convertBytesToFormatString(jsonXMLFileStream.length()));
        System.out.print("- Deserializzazione (Object): ");
        jsonXMLDeserializer = new XMLDeserializer(excludesJson_date);
        dataInizio = DateManager.getTimeMillis();
        oJsonXMLRead = jsonXMLDeserializer.getObject(jsonXMLSerializationObject, as.getClass());
        dataFine = DateManager.getTimeMillis();
        freaderJsonXML.close();
        ClientTest.equals(as, (AccordoServizio)oJsonXMLRead, dir);
        System.out.print("OK, accordo: " + IDAccordo.getUriFromAccordo((AccordoServizio)oJsonXMLRead) + " allegati:(" + ((AccordoServizio)oJsonXMLRead).sizeAllegatoList() + ")\n");
        System.out.println("- Costo ms deserializzazione jsonXML: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println();
        System.out.print("- Serializzazione (Enumerations): ");
        jsonXMLSerializer = new XMLSerializer(filter);
        dataInizio = DateManager.getTimeMillis();
        jsonXMLSerializationObject = jsonXMLSerializer.getObject(TestEnumerations.VALORE1);
        dataFine = DateManager.getTimeMillis();
        System.out.print("OK\n");
        System.out.println("- Costo ms serializzazione jsonXML: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println("- Dimensione oggetto serializzato: " + Utilities.convertBytesToFormatString(jsonXMLFileStream.length()));
        System.out.print("- Deserializzazione (Enumerations): ");
        jsonXMLDeserializer = new XMLDeserializer();
        dataInizio = DateManager.getTimeMillis();
        oJsonXMLRead = jsonXMLDeserializer.getObject(jsonXMLSerializationObject, TestEnumerations.class);
        dataFine = DateManager.getTimeMillis();
        freaderJsonXML.close();
        if (!((TestEnumerations)oJsonXMLRead).toString().equals(TestEnumerations.VALORE1.toString())) {
            throw new Exception("Enumeration originale [" + TestEnumerations.VALORE1.toString() + "] e ricostruita[" + ((TestEnumerations)oJsonXMLRead).toString() + "] differiscono");
        }
        System.out.print("OK, enum value: " + (TestEnumerations)oJsonXMLRead + "\n");
        System.out.println("- Costo ms deserializzazione jsonXML: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println();
        System.out.println();
        System.out.println("********** Serializzazione JsonXML (Array/List/Set) ****************");
        System.out.println();
        jsonXMLFileStream = new File(dir, "array.accordi.jsonXML");
        foutJsonXML = new FileOutputStream(jsonXMLFileStream);
        finJsonXML = new FileInputStream(jsonXMLFileStream);
        System.out.print("- Serializzazione (Array)(Accordi): ");
        jsonXMLSerializer = new XMLSerializer(filter, excludesJson_AccordiServizio);
        dataInizio = DateManager.getTimeMillis();
        AccordoServizio[] arrayJsonXMLTestAccordi = testSerializzazioneListaAccordi.toArray(new AccordoServizio[1]);
        jsonXMLSerializer.writeObject((Object)arrayJsonXMLTestAccordi, foutJsonXML);
        dataFine = DateManager.getTimeMillis();
        foutJsonXML.flush();
        foutJsonXML.close();
        System.out.print("OK\n");
        System.out.println("- Costo ms serializzazione jsonXML: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println("- Dimensione oggetto serializzato: " + Utilities.convertBytesToFormatString(jsonXMLFileStream.length()));
        System.out.print("- Deserializzazione (Array)(Accordi): ");
        jsonXMLDeserializer = new XMLDeserializer(excludesJson_date);
        dataInizio = DateManager.getTimeMillis();
        oJsonXMLRead = jsonXMLDeserializer.readObject(finJsonXML, AccordoServizio[].class);
        dataFine = DateManager.getTimeMillis();
        finJsonXML.close();
        Object[] vJsonXMLArray = (Object[])oJsonXMLRead;
        AccordoServizio[] vJsonXMLArrayTestAccordi = new AccordoServizio[vJsonXMLArray.length];
        for (int i = 0; i < vJsonXMLArray.length; ++i) {
            vJsonXMLArrayTestAccordi[i] = (AccordoServizio)vJsonXMLArray[i];
        }
        ClientTest.equals(arrayJsonXMLTestAccordi, vJsonXMLArrayTestAccordi, dir);
        System.out.print("OK, nome accordo: " + IDAccordo.getUriFromAccordo((AccordoServizio)vJsonXMLArray[0]) + " allegati:(" + ((AccordoServizio)vJsonXMLArray[0]).sizeAllegatoList() + ")\n");
        System.out.println("- Costo ms deserializzazione jsonXML: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println();
        jsonXMLFileStream = new File(dir, "array.soggetti.jsonXML");
        foutJsonXML = new FileOutputStream(jsonXMLFileStream);
        finJsonXML = new FileInputStream(jsonXMLFileStream);
        System.out.print("- Serializzazione (Array)(Soggetti): ");
        jsonXMLSerializer = new XMLSerializer(filter, excludesJson_SoggettoSPCoop);
        dataInizio = DateManager.getTimeMillis();
        SoggettoSpcoop[] arrayJsonXMLTestSoggetti = testSerializzazioneListaSoggetti.toArray(new SoggettoSpcoop[testSerializzazioneListaSoggetti.size()]);
        jsonXMLSerializer.writeObject((Object)arrayJsonXMLTestSoggetti, foutJsonXML);
        dataFine = DateManager.getTimeMillis();
        foutJsonXML.flush();
        foutJsonXML.close();
        System.out.print("OK\n");
        System.out.println("- Costo ms serializzazione jsonXML: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println("- Dimensione oggetto serializzato: " + Utilities.convertBytesToFormatString(jsonXMLFileStream.length()));
        System.out.print("- Deserializzazione (Array)(Soggetti): ");
        jsonXMLDeserializer = new XMLDeserializer(excludesJson_date);
        dataInizio = DateManager.getTimeMillis();
        oJsonXMLRead = jsonXMLDeserializer.readObject(finJsonXML, SoggettoSpcoop[].class);
        dataFine = DateManager.getTimeMillis();
        finJsonXML.close();
        vJsonXMLArray = (Object[])oJsonXMLRead;
        SoggettoSpcoop[] vJsonXMLArrayTestSoggetti = new SoggettoSpcoop[vJsonXMLArray.length];
        for (int i = 0; i < vJsonXMLArray.length; ++i) {
            vJsonXMLArrayTestSoggetti[i] = (SoggettoSpcoop)vJsonXMLArray[i];
        }
        ClientTest.equals(arrayJsonXMLTestSoggetti, vJsonXMLArrayTestSoggetti, dir);
        System.out.print("OK, nome soggetto: " + ((SoggettoSpcoop)vJsonXMLArray[1]).getTipo() + "/" + ((SoggettoSpcoop)vJsonXMLArray[1]).getNome() + "\n");
        System.out.println("- Costo ms deserializzazione jsonXML: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println();
        jsonXMLFileStream = new File(dir, "list.accordi.jsonXML");
        foutJsonXML = new FileOutputStream(jsonXMLFileStream);
        finJsonXML = new FileInputStream(jsonXMLFileStream);
        System.out.print("- Serializzazione (List)(Accordi): ");
        jsonXMLSerializer = new XMLSerializer(filter, excludesJson_AccordiServizio);
        dataInizio = DateManager.getTimeMillis();
        jsonXMLSerializer.writeObject(testSerializzazioneListaAccordi, foutJsonXML);
        dataFine = DateManager.getTimeMillis();
        foutJsonXML.flush();
        foutJsonXML.close();
        System.out.print("OK\n");
        System.out.println("- Costo ms serializzazione jsonXML: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println("- Dimensione oggetto serializzato: " + Utilities.convertBytesToFormatString(jsonXMLFileStream.length()));
        System.out.print("- Deserializzazione (List)(Accordi): ");
        jsonXMLDeserializer = new XMLDeserializer(excludesJson_date);
        dataInizio = DateManager.getTimeMillis();
        oJsonXMLRead = jsonXMLDeserializer.readListObject(finJsonXML, testSerializzazioneListaAccordi.getClass(), AccordoServizio.class);
        dataFine = DateManager.getTimeMillis();
        finJsonXML.close();
        List vJsonXMLList = (List)oJsonXMLRead;
        originaleAccordi = testSerializzazioneSetAccordi.toArray(new AccordoServizio[1]);
        ricostruitoAccordi = vJsonXMLList.toArray(new AccordoServizio[1]);
        ClientTest.equals(originaleAccordi, ricostruitoAccordi, dir);
        System.out.print("OK, nome accordo: " + IDAccordo.getUriFromAccordo((AccordoServizio)vJsonXMLList.get(0)) + " allegati:(" + ((AccordoServizio)vJsonXMLList.get(0)).sizeAllegatoList() + ")\n");
        System.out.println("- Costo ms deserializzazione jsonXML: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println();
        jsonXMLFileStream = new File(dir, "list.soggetti.jsonXML");
        foutJsonXML = new FileOutputStream(jsonXMLFileStream);
        finJsonXML = new FileInputStream(jsonXMLFileStream);
        System.out.print("- Serializzazione (List)(Soggetti): ");
        jsonXMLSerializer = new XMLSerializer(filter, excludesJson_SoggettoSPCoop);
        dataInizio = DateManager.getTimeMillis();
        jsonXMLSerializer.writeObject(testSerializzazioneListaSoggetti, foutJsonXML);
        dataFine = DateManager.getTimeMillis();
        foutJsonXML.flush();
        foutJsonXML.close();
        System.out.print("OK\n");
        System.out.println("- Costo ms serializzazione jsonXML: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println("- Dimensione oggetto serializzato: " + Utilities.convertBytesToFormatString(jsonXMLFileStream.length()));
        System.out.print("- Deserializzazione (List)(Soggetti): ");
        jsonXMLDeserializer = new XMLDeserializer(excludesJson_date);
        dataInizio = DateManager.getTimeMillis();
        oJsonXMLRead = jsonXMLDeserializer.readListObject(finJsonXML, testSerializzazioneListaSoggetti.getClass(), SoggettoSpcoop.class);
        dataFine = DateManager.getTimeMillis();
        finJsonXML.close();
        vJsonXMLList = (List)oJsonXMLRead;
        originaleSoggetti = testSerializzazioneSetSoggetti.toArray(new SoggettoSpcoop[1]);
        ricostruitoSoggetti = vJsonXMLList.toArray(new SoggettoSpcoop[1]);
        System.out.print("OK, nome soggetto: " + ((SoggettoSpcoop)vJsonXMLList.get(1)).getTipo() + "/" + ((SoggettoSpcoop)vJsonXMLList.get(1)).getNome() + ")\n");
        System.out.println("- Costo ms deserializzazione jsonXML: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println();
        jsonXMLFileStream = new File(dir, "set.accordi.jsonXML");
        foutJsonXML = new FileOutputStream(jsonXMLFileStream);
        finJsonXML = new FileInputStream(jsonXMLFileStream);
        System.out.print("- Serializzazione (Set)(Accordi) (E' normale uno stackatrace: IllegalArgumentException): ");
        jsonXMLSerializer = new XMLSerializer(filter, excludesJson_AccordiServizio);
        dataInizio = DateManager.getTimeMillis();
        jsonXMLSerializer.writeObject(testSerializzazioneSetAccordi, foutJsonXML);
        dataFine = DateManager.getTimeMillis();
        foutJsonXML.flush();
        foutJsonXML.close();
        System.out.print("OK\n");
        System.out.println("- Costo ms serializzazione jsonXML: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println("- Dimensione oggetto serializzato: " + Utilities.convertBytesToFormatString(jsonXMLFileStream.length()));
        System.out.print("- Deserializzazione (Set)(Accordi): ");
        jsonXMLDeserializer = new XMLDeserializer(excludesJson_date);
        dataInizio = DateManager.getTimeMillis();
        oJsonXMLRead = jsonXMLDeserializer.readSetObject(finJsonXML, testSerializzazioneSetAccordi.getClass(), AccordoServizio.class);
        dataFine = DateManager.getTimeMillis();
        finJsonXML.close();
        Set vJsonXMLSet = (Set)oJsonXMLRead;
        originaleAccordi = testSerializzazioneSetAccordi.toArray(new AccordoServizio[1]);
        ricostruitoAccordi = vJsonXMLSet.toArray(new AccordoServizio[1]);
        ClientTest.equals(originaleAccordi, ricostruitoAccordi, dir);
        System.out.print("OK, dimensione set: " + vJsonXMLSet.size() + ")\n");
        System.out.println("- Costo ms deserializzazione jsonXML: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println();
        System.out.println();
        jsonXMLFileStream = new File(dir, "set.soggetti.jsonXML");
        foutJsonXML = new FileOutputStream(jsonXMLFileStream);
        finJsonXML = new FileInputStream(jsonXMLFileStream);
        System.out.print("- Serializzazione (Set)(Soggetti): ");
        jsonXMLSerializer = new XMLSerializer(filter, excludesJson_SoggettoSPCoop);
        dataInizio = DateManager.getTimeMillis();
        jsonXMLSerializer.writeObject(testSerializzazioneSetSoggetti, foutJsonXML);
        dataFine = DateManager.getTimeMillis();
        foutJsonXML.flush();
        foutJsonXML.close();
        System.out.print("OK\n");
        System.out.println("- Costo ms serializzazione jsonXML: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println("- Dimensione oggetto serializzato: " + Utilities.convertBytesToFormatString(jsonXMLFileStream.length()));
        System.out.print("- Deserializzazione (Set)(Soggetti): ");
        jsonXMLDeserializer = new XMLDeserializer(excludesJson_date);
        dataInizio = DateManager.getTimeMillis();
        oJsonXMLRead = jsonXMLDeserializer.readSetObject(finJsonXML, testSerializzazioneSetSoggetti.getClass(), SoggettoSpcoop.class);
        dataFine = DateManager.getTimeMillis();
        finJsonXML.close();
        vJsonXMLSet = (Set)oJsonXMLRead;
        originaleSoggetti = testSerializzazioneSetSoggetti.toArray(new SoggettoSpcoop[1]);
        ricostruitoSoggetti = vJsonXMLSet.toArray(new SoggettoSpcoop[1]);
        ClientTest.equals(originaleSoggetti, ricostruitoSoggetti, dir);
        System.out.print("OK, dimensione set: " + vJsonXMLSet.size() + ")\n");
        System.out.println("- Costo ms deserializzazione jsonXML: " + Utilities.convertSystemTimeIntoString_millisecondi(dataFine - dataInizio, true));
        System.out.println();
        System.out.println();
    }

    private static void equalsOpenSPCoopObject(Object[] originale, Object[] ricostruito, File dir) throws Exception {
        for (int i = 0; i < originale.length; ++i) {
            boolean find = false;
            for (int j = 0; j < ricostruito.length; ++j) {
                try {
                    if (originale[i] instanceof SoggettoSpcoop && ricostruito[j] instanceof SoggettoSpcoop) {
                        ClientTest.equals((SoggettoSpcoop)originale[i], (SoggettoSpcoop)ricostruito[j], dir);
                        find = true;
                    }
                    if (!(originale[i] instanceof AccordoServizio) || !(ricostruito[j] instanceof AccordoServizio)) continue;
                    ClientTest.equals((AccordoServizio)originale[i], (AccordoServizio)ricostruito[j], dir);
                    find = true;
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (find) continue;
            File tmp = new File(dir, "originaleTestFailed.xml");
            FileOutputStream fout = new FileOutputStream(tmp);
            if (originale[i] instanceof SoggettoSpcoop) {
                fout.write(((SoggettoSpcoop)originale[i]).toString(false, true).getBytes());
            } else {
                fout.write(((AccordoServizio)originale[i]).toString(false, true).getBytes());
            }
            fout.flush();
            fout.close();
            for (int j = 0; j < ricostruito.length; ++j) {
                tmp = new File(dir, "ricostruitoTestFailed(" + j + ").xml");
                fout = new FileOutputStream(tmp);
                if (ricostruito[j] instanceof SoggettoSpcoop) {
                    fout.write(((SoggettoSpcoop)ricostruito[j]).toString(false, true).getBytes());
                } else {
                    fout.write(((AccordoServizio)ricostruito[j]).toString(false, true).getBytes());
                }
                fout.flush();
                fout.close();
            }
            throw new Exception("Liste non uguali: vedi file originaleTestFailed.xml e files ricostruitoTestFailed(i).xml per capire le differenze");
        }
    }

    private static void equals(SoggettoSpcoop[] originale, SoggettoSpcoop[] ricostruito, File dir) throws Exception {
        for (int i = 0; i < originale.length; ++i) {
            boolean find = false;
            for (int j = 0; j < ricostruito.length; ++j) {
                try {
                    ClientTest.equals(originale[i], ricostruito[j], dir);
                    find = true;
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (find) continue;
            File tmp = new File(dir, "originaleTestFailed.xml");
            FileOutputStream fout = new FileOutputStream(tmp);
            fout.write(originale[i].toString(false, true).getBytes());
            fout.flush();
            fout.close();
            for (int j = 0; j < ricostruito.length; ++j) {
                tmp = new File(dir, "ricostruitoTestFailed(" + j + ").xml");
                fout = new FileOutputStream(tmp);
                fout.write(ricostruito[j].toString(false, true).getBytes());
                fout.flush();
                fout.close();
            }
            throw new Exception("Liste non uguali: vedi file originaleTestFailed.xml e files ricostruitoTestFailed(i).xml per capire le differenze");
        }
    }

    private static void equals(AccordoServizio[] originale, AccordoServizio[] ricostruito, File dir) throws Exception {
        for (int i = 0; i < originale.length; ++i) {
            boolean find = false;
            for (int j = 0; j < ricostruito.length; ++j) {
                try {
                    ClientTest.equals(originale[i], ricostruito[j], dir);
                    find = true;
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (find) continue;
            File tmp = new File(dir, "originaleTestFailed.xml");
            FileOutputStream fout = new FileOutputStream(tmp);
            fout.write(originale[i].toString(false, true).getBytes());
            fout.flush();
            fout.close();
            for (int j = 0; j < ricostruito.length; ++j) {
                tmp = new File(dir, "ricostruitoTestFailed(" + j + ").xml");
                fout = new FileOutputStream(tmp);
                fout.write(ricostruito[j].toString(false, true).getBytes());
                fout.flush();
                fout.close();
            }
            throw new Exception("Liste non uguali: vedi file originaleTestFailed.xml e files ricostruitoTestFailed(i).xml per capire le differenze");
        }
    }

    private static void equals(SoggettoSpcoop o1, SoggettoSpcoop o2, File dir) throws Exception {
        if (!o1.toString(false, true).equals(o2.toString(false, true))) {
            File tmp1 = new File(dir, "originaleTestFailed.xml");
            File tmp2 = new File(dir, "ricostruitoTestFailed.xml");
            FileOutputStream fout1 = new FileOutputStream(tmp1);
            fout1.write(o1.toString(false, true).getBytes());
            fout1.flush();
            fout1.close();
            FileOutputStream fout2 = new FileOutputStream(tmp2);
            fout2.write(o2.toString(false, true).getBytes());
            fout2.flush();
            fout2.close();
            throw new Exception("Soggetti non uguali: vedi file originaleTestFailed.xml e ricostruitoTestFailed.xml per capire le differenze");
        }
    }

    private static void equals(AccordoServizio o1, AccordoServizio o2, File dir) throws Exception {
        if (!o1.toString(false, true).equals(o2.toString(false, true))) {
            File tmp1 = new File(dir, "originaleTestFailed.xml");
            File tmp2 = new File(dir, "ricostruitoTestFailed.xml");
            FileOutputStream fout1 = new FileOutputStream(tmp1);
            fout1.write(o1.toString(false, true).getBytes());
            fout1.flush();
            fout1.close();
            FileOutputStream fout2 = new FileOutputStream(tmp2);
            fout2.write(o2.toString(false, true).getBytes());
            fout2.flush();
            fout2.close();
            throw new Exception("Accordi non uguali: vedi file originaleTestFailed.xml e ricostruitoTestFailed.xml per capire le differenze");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TestEnumerations implements Serializable
    {
        VALORE1,
        VALORE2,
        VALORE3;

    }
}

