/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.utils.regexp;

import com.sun.org.apache.xpath.internal.XPathException;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.soap.SOAPElement;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.commons.lang.StringEscapeUtils;
import org.openspcoop.utils.Utilities;
import org.openspcoop.utils.UtilsException;
import org.openspcoop.utils.regexp.ExpressionException;
import org.openspcoop.utils.regexp.ExpressionNotFoundException;
import org.openspcoop.utils.regexp.ExpressionNotValidException;
import org.openspcoop.utils.regexp.XPathReturnType;
import org.openspcoop.utils.xml.DynamicNamespaceContext;
import org.openspcoop.utils.xml.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XPathExpressionEngine {
    private static XPathFactory xPathFactory = null;
    private static Integer synchronizedObjectForBugFWK005ParseXerces = new Integer(1);

    public static XPathFactory getXPathFactory() throws ExpressionException {
        if (xPathFactory == null) {
            XPathExpressionEngine.initXPathFactory();
        }
        return xPathFactory;
    }

    public static synchronized void initXPathFactory() throws ExpressionException {
        try {
            if (xPathFactory == null) {
                xPathFactory = XPathFactory.newInstance();
            }
        }
        catch (Exception e) {
            throw new ExpressionException("Inizializzazione XPathFactory non riuscita", e);
        }
    }

    public static String getStringMatchPattern(SOAPElement element, DynamicNamespaceContext dnc, String pattern) throws ExpressionException, ExpressionNotFoundException, ExpressionNotValidException {
        return (String)XPathExpressionEngine.getMatchPattern(element, dnc, pattern, XPathReturnType.STRING);
    }

    public static String getStringMatchPattern(Document document, DynamicNamespaceContext dnc, String pattern) throws ExpressionException, ExpressionNotFoundException, ExpressionNotValidException {
        return (String)XPathExpressionEngine.getMatchPattern(document.getDocumentElement(), dnc, pattern, XPathReturnType.STRING);
    }

    public static String getStringMatchPattern(Element element, DynamicNamespaceContext dnc, String pattern) throws ExpressionException, ExpressionNotFoundException, ExpressionNotValidException {
        return (String)XPathExpressionEngine.getMatchPattern(element, dnc, pattern, XPathReturnType.STRING);
    }

    public static String getStringMatchPattern(String contenuto, DynamicNamespaceContext dnc, String pattern) throws ExpressionException, ExpressionNotFoundException, ExpressionNotValidException {
        return (String)XPathExpressionEngine.getMatchPattern(contenuto, dnc, pattern, XPathReturnType.STRING);
    }

    public static Object getMatchPattern(SOAPElement element, DynamicNamespaceContext dnc, String pattern, XPathReturnType returnType) throws ExpressionException, ExpressionNotFoundException, ExpressionNotValidException {
        String envelopeString = null;
        try {
            if (element == null) {
                throw new ExpressionNotFoundException("elemento xml non fornito");
            }
            String msg = ((SOAPEnvelope)element).getAsString();
            if (msg.indexOf("&lt;") >= 0) {
                msg = StringEscapeUtils.unescapeXml((String)msg);
            }
            String xmlInstruction = "<?xml";
            int instructionStart = msg.indexOf(xmlInstruction);
            while (instructionStart >= 0) {
                int instructionEnd = msg.indexOf(">", instructionStart + xmlInstruction.length());
                String replaceMsg = msg.substring(instructionStart, instructionEnd + 1);
                msg = msg.replace(replaceMsg, "");
                instructionStart = msg.indexOf(xmlInstruction);
            }
            envelopeString = msg;
        }
        catch (Exception e) {
            throw new ExpressionException("getMatchPattern pattern[" + pattern + "] error: " + e.getMessage(), e);
        }
        return XPathExpressionEngine.getMatchPattern(envelopeString, dnc, pattern, returnType);
    }

    public static Object getMatchPattern(Document document, DynamicNamespaceContext dnc, String pattern, XPathReturnType returnType) throws ExpressionException, ExpressionNotFoundException, ExpressionNotValidException {
        return XPathExpressionEngine.getMatchPattern(document.getDocumentElement(), dnc, pattern, returnType);
    }

    public static Object getMatchPattern(Element element, DynamicNamespaceContext dnc, String pattern, XPathReturnType returnType) throws ExpressionException, ExpressionNotFoundException, ExpressionNotValidException {
        String envelopeString = null;
        try {
            if (element == null) {
                throw new ExpressionNotFoundException("elemento xml non fornito");
            }
            boolean omitXMLDeclaration = true;
            String msg = XMLUtils.toString(element, omitXMLDeclaration);
            if (msg.indexOf("&lt;") >= 0) {
                msg = StringEscapeUtils.unescapeXml((String)msg);
            }
            envelopeString = msg;
        }
        catch (Exception e) {
            throw new ExpressionException("getMatchPattern pattern[" + pattern + "] error: " + e.getMessage(), e);
        }
        return XPathExpressionEngine.getMatchPattern(envelopeString, dnc, pattern, returnType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getMatchPattern(String contenuto, DynamicNamespaceContext dnc, String pattern, XPathReturnType returnType) throws ExpressionException, ExpressionNotFoundException, ExpressionNotValidException {
        if (pattern == null || pattern.length() == 0) {
            throw new ExpressionNotFoundException("Pattern di ricerca non fornito");
        }
        if (contenuto == null) {
            throw new ExpressionNotFoundException("Contenuto su cui effettuare la ricerca non fornito");
        }
        pattern = pattern.trim();
        XPathExpressionEngine.validate(pattern);
        try {
            XPathFactory factory = XPathExpressionEngine.getXPathFactory();
            XPath xpath = factory.newXPath();
            if (xpath == null) {
                throw new Exception("Costruzione xpath non riuscita");
            }
            if (dnc != null) {
                xpath.setNamespaceContext(dnc);
            }
            if (dnc != null) {
                pattern = pattern.replaceAll("}:", "}");
                pattern = XPathExpressionEngine.convertNamespaces(pattern, dnc);
            }
            if (!dnc.getNamespaceURI("").equals("")) {
                contenuto = contenuto.replace("xmlns=\"" + dnc.getNamespaceURI("") + "\"", "");
            }
            if (pattern.startsWith("concat_openspcoop") && pattern.endsWith(")")) {
                if (!returnType.equals(XPathReturnType.STRING)) {
                    throw new ExpressionException("Funzione concat_openspcoop non compatibile con un tipo di ritorno: " + returnType.toString());
                }
                String param = pattern.substring("concat_openspcoop(".length(), pattern.length() - 1);
                String[] params = param.split(",");
                StringBuffer bfResult = new StringBuffer();
                for (int i = 0; i < params.length; ++i) {
                    if (params[i].startsWith("\"") && params[i].endsWith("\"")) {
                        bfResult.append(params[i].substring(1, params[i].length() - 1));
                        continue;
                    }
                    StringReader reader = null;
                    try {
                        reader = new StringReader(contenuto);
                    }
                    catch (Exception e) {
                        try {
                            if (reader != null) {
                                ((Reader)reader).close();
                            }
                        }
                        catch (Exception er) {
                            // empty catch block
                        }
                        throw e;
                    }
                    XPathExpression expression = null;
                    try {
                        expression = xpath.compile(params[i]);
                    }
                    catch (Exception e) {
                        if (Utilities.existsInnerMessageException(e, "Prefix must resolve to a namespace", true)) {
                            throw new ExpressionNotFoundException("Espressione XPATH contenuta in concat_openspcoop (" + params[i] + ") non applicabile al messaggio: " + Utilities.getInnerMessageException(e, "Prefix must resolve to a namespace", true));
                        }
                        if (Utilities.existsInnerException((Throwable)e, TransformerException.class)) {
                            throw new Exception("Compilazione dell'espressione XPATH contenuta in concat_openspcoop (" + params[i] + ") ha causato un errore (" + Utilities.getInnerException((Throwable)e, TransformerException.class).getMessage() + ")", e);
                        }
                        if (e.getCause() != null) {
                            throw new Exception("Compilazione dell'espressione XPATH contenuta in concat_openspcoop (" + params[i] + ") ha causato un errore (" + Utilities.getLastInnerException(e.getCause()).getMessage() + ")", e);
                        }
                        throw new Exception("Compilazione dell'espressione XPATH contenuta in concat_openspcoop (" + params[i] + ") ha causato un errore (" + e.getMessage() + ")", e);
                    }
                    if (expression == null) {
                        throw new Exception("Costruzione XPathExpression non riuscita per espressione contenuta in concat_openspcoop (" + params[i] + ")");
                    }
                    String result = null;
                    try {
                        Integer n = synchronizedObjectForBugFWK005ParseXerces;
                        synchronized (n) {
                            result = expression.evaluate(new InputSource(reader));
                        }
                    }
                    catch (Exception e) {
                        if (Utilities.existsInnerException((Throwable)e, XPathException.class)) {
                            throw new Exception("Valutazione dell'espressione XPATH contenuta in concat_openspcoop (" + params[i] + ") ha causato un errore (" + Utilities.getInnerException((Throwable)e, XPathException.class).getMessage() + ")", e);
                        }
                        if (e.getCause() != null) {
                            throw new Exception("Valutazione dell'espressione XPATH contenuta in concat_openspcoop (" + params[i] + ") ha causato un errore (" + Utilities.getLastInnerException(e.getCause()).getMessage() + ")", e);
                        }
                        throw new Exception("Valutazione dell'espressione XPATH contenuta in concat_openspcoop (" + params[i] + ") ha causato un errore (" + e.getMessage() + ")", e);
                    }
                    ((Reader)reader).close();
                    if (result == null || "".equals(result)) {
                        throw new ExpressionNotFoundException("nessun match trovato per l'espressione xpath contenuta in concat_openspcoop (" + params[i] + ")");
                    }
                    bfResult.append(result);
                }
                if (bfResult.length() <= 0) {
                    throw new ExpressionNotFoundException("nessun match trovato per l'espressione xpath (concat_openspcoop) [" + pattern + "]");
                }
                return bfResult.toString();
            }
            StringReader reader = null;
            try {
                reader = new StringReader(contenuto);
            }
            catch (Exception e) {
                try {
                    if (reader != null) {
                        ((Reader)reader).close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                throw e;
            }
            XPathExpression expression = null;
            try {
                expression = xpath.compile(pattern);
            }
            catch (Exception e) {
                if (Utilities.existsInnerMessageException(e, "Prefix must resolve to a namespace", true)) {
                    throw new ExpressionNotFoundException("Espressione XPATH non applicabile al messaggio: " + Utilities.getInnerMessageException(e, "Prefix must resolve to a namespace", true));
                }
                if (Utilities.existsInnerException((Throwable)e, TransformerException.class)) {
                    throw new Exception("Compilazione dell'espressione XPATH ha causato un errore (" + Utilities.getInnerException((Throwable)e, TransformerException.class).getMessage() + ")", e);
                }
                if (e.getCause() != null) {
                    throw new Exception("Compilazione dell'espressione XPATH ha causato un errore (" + Utilities.getLastInnerException(e.getCause()).getMessage() + ")", e);
                }
                throw new Exception("Compilazione dell'espressione XPATH ha causato un errore (" + e.getMessage() + ")", e);
            }
            if (expression == null) {
                throw new Exception("Costruzione XPathExpression non riuscita");
            }
            Object result = null;
            try {
                Integer i = synchronizedObjectForBugFWK005ParseXerces;
                synchronized (i) {
                    result = expression.evaluate(new InputSource(reader), returnType.getValore());
                }
            }
            catch (Exception e) {
                if (Utilities.existsInnerException((Throwable)e, XPathException.class)) {
                    throw new Exception("Valutazione dell'espressione XPATH ha causato un errore (" + Utilities.getInnerException((Throwable)e, XPathException.class).getMessage() + ")", e);
                }
                if (e.getCause() != null) {
                    throw new Exception("Valutazione dell'espressione XPATH ha causato un errore (" + Utilities.getLastInnerException(e.getCause()).getMessage() + ")", e);
                }
                throw new Exception("Valutazione dell'espressione XPATH ha causato un errore (" + e.getMessage() + ")", e);
            }
            ((Reader)reader).close();
            if (result == null || "".equals(result)) {
                throw new ExpressionNotFoundException("nessun match trovato per l'espressione xpath [" + pattern + "]");
            }
            return result;
        }
        catch (ExpressionNotFoundException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExpressionException("getMatchPattern pattern[" + pattern + "] error: " + e.getMessage(), e);
        }
    }

    public static void validate(String path) throws ExpressionNotValidException {
        block18: {
            try {
                path = path.trim();
                XPathFactory factory = XPathExpressionEngine.getXPathFactory();
                XPath xpath = factory.newXPath();
                if (xpath == null) {
                    throw new Exception("Costruzione xpath non riuscita");
                }
                path = path.replaceAll("}:", "}");
                int index = 0;
                if (path.indexOf("{") != -1) {
                    while (path.indexOf("{") != -1) {
                        int indexStart = path.indexOf("{");
                        int indexEnd = path.indexOf("}");
                        if (indexEnd == -1) {
                            throw new Exception("{ utilizzato senza la rispettiva chiusura }");
                        }
                        String namespace = path.substring(indexStart + "{".length(), indexEnd);
                        if (namespace == null || namespace.equals("")) {
                            throw new Exception("Namespace non indicato tra {}");
                        }
                        String prefix = "a" + index + ":";
                        ++index;
                        path = path.replace("{" + namespace + "}", prefix);
                    }
                }
                if (path.startsWith("concat_openspcoop")) {
                    String param = path.substring("concat_openspcoop(".length(), path.length() - 1);
                    String[] params = param.split(",");
                    for (int i = 0; i < params.length; ++i) {
                        if (params[i].startsWith("\"") && params[i].endsWith("\"")) continue;
                        XPathExpression expression = null;
                        try {
                            expression = xpath.compile(params[i]);
                        }
                        catch (Exception e) {
                            if (Utilities.existsInnerException((Throwable)e, TransformerException.class)) {
                                throw new Exception("Compilazione dell'espressione XPATH contenuta in concat_openspcoop (" + params[i] + ") ha causato un errore (" + Utilities.getInnerException((Throwable)e, TransformerException.class).getMessage() + ")", e);
                            }
                            if (e.getCause() != null) {
                                throw new Exception("Compilazione dell'espressione XPATH contenuta in concat_openspcoop (" + params[i] + ") ha causato un errore (" + Utilities.getLastInnerException(e.getCause()).getMessage() + ")", e);
                            }
                            throw new Exception("Compilazione dell'espressione XPATH contenuta in concat_openspcoop (" + params[i] + ") ha causato un errore (" + e.getMessage() + ")", e);
                        }
                        if (expression != null) continue;
                        throw new Exception("Costruzione XPathExpression non riuscita per espressione contenuta in concat_openspcoop (" + params[i] + ")");
                    }
                    break block18;
                }
                XPathExpression expression = null;
                try {
                    expression = xpath.compile(path);
                }
                catch (Exception e) {
                    if (Utilities.existsInnerException((Throwable)e, TransformerException.class)) {
                        throw new Exception("Compilazione dell'espressione XPATH ha causato un errore (" + Utilities.getInnerException((Throwable)e, TransformerException.class).getMessage() + ")", e);
                    }
                    if (e.getCause() != null) {
                        throw new Exception("Compilazione dell'espressione XPATH ha causato un errore (" + Utilities.getLastInnerException(e.getCause()).getMessage() + ")", e);
                    }
                    throw new Exception("Compilazione dell'espressione XPATH ha causato un errore (" + e.getMessage() + ")", e);
                }
                if (expression == null) {
                    throw new Exception("Costruzione XPathExpression non riuscita");
                }
            }
            catch (Exception e) {
                throw new ExpressionNotValidException("Validazione dell'xpath indicato [" + path + "] fallita: " + e.getMessage(), e);
            }
        }
    }

    public static String toString(NodeList rootNode) {
        StringBuffer resultBuffer = new StringBuffer();
        XPathExpressionEngine.toString(rootNode, resultBuffer, 1);
        return resultBuffer.toString();
    }

    private static String convertNamespaces(String path, DynamicNamespaceContext dnc) throws UtilsException {
        if (path.indexOf("{") != -1) {
            while (path.indexOf("{") != -1) {
                int indexStart = path.indexOf("{");
                int indexEnd = path.indexOf("}");
                if (indexEnd == -1) {
                    throw new UtilsException("Errore durante l'interpretazione del valore [" + path + "]: { utilizzato senza la rispettiva chiusura }");
                }
                String namespace = path.substring(indexStart + "{".length(), indexEnd);
                String prefix = dnc.getPrefix(namespace);
                if (prefix != null && !"".equals(prefix)) {
                    prefix = prefix + ":";
                }
                path = path.replace("{" + namespace + "}", prefix);
            }
        }
        return path;
    }

    private static void toString(NodeList rootNode, StringBuffer resultBuffer, int livello) {
        if (rootNode.getLength() == 1 && rootNode.item(0).getNodeType() == 3 && resultBuffer.length() == 0) {
            resultBuffer.append(rootNode.item(0).getTextContent());
            return;
        }
        boolean findElementoRisultatoMultiplo = false;
        for (int index = 0; index < rootNode.getLength(); ++index) {
            Node aNode = rootNode.item(index);
            if (aNode.getNodeType() == 1) {
                NodeList childNodes = aNode.getChildNodes();
                if (childNodes.getLength() <= 0) continue;
                boolean hasChildNodes = false;
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    Node n = childNodes.item(i);
                    if (!n.hasChildNodes()) continue;
                    hasChildNodes = true;
                    break;
                }
                if (hasChildNodes) {
                    resultBuffer.append("<" + aNode.getNodeName());
                    XPathExpressionEngine.printAttributes(aNode, resultBuffer);
                    resultBuffer.append(">");
                    XPathExpressionEngine.toString(aNode.getChildNodes(), resultBuffer, livello + 1);
                    resultBuffer.append("</" + aNode.getNodeName() + ">");
                    continue;
                }
                resultBuffer.append("<" + aNode.getNodeName());
                XPathExpressionEngine.printAttributes(aNode, resultBuffer);
                resultBuffer.append(">" + aNode.getTextContent() + "</" + aNode.getNodeName() + ">");
                continue;
            }
            if (livello != 1 || aNode.getNodeType() != 3) continue;
            if (findElementoRisultatoMultiplo) {
                resultBuffer.append(", ");
            } else {
                findElementoRisultatoMultiplo = true;
            }
            resultBuffer.append("[" + index + "]=" + aNode.getTextContent());
        }
    }

    private static void printAttributes(Node aNode, StringBuffer resultBuffer) {
        NamedNodeMap attr = aNode.getAttributes();
        for (int i = 0; i < attr.getLength(); ++i) {
            Node item = attr.item(i);
            if (item instanceof Attr) {
                Attr attribute = (Attr)item;
                String prefix = attribute.getPrefix();
                prefix = prefix != null && !"".equals(prefix) ? prefix + ":" : "";
                String value = attribute.getNodeValue();
                resultBuffer.append(" " + prefix + attribute.getLocalName() + "=\"" + value + "\"");
                continue;
            }
            resultBuffer.append(" " + item.toString());
        }
    }
}

