/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.utils.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.openspcoop.utils.UtilsException;
import org.openspcoop.utils.jdbc.IJDBCAdapter;

public class StreamJDBCAdapter
implements IJDBCAdapter {
    public byte[] getBinaryData(ResultSet rs, int index) throws UtilsException, SQLException {
        InputStream is = rs.getBinaryStream(index);
        ByteArrayOutputStream os = null;
        try {
            os = new ByteArrayOutputStream();
            byte[] readB = new byte[65536];
            int readByte = 0;
            while ((readByte = is.read(readB)) != -1) {
                os.write(readB, 0, readByte);
            }
            is.close();
            byte[] dati = os.toByteArray();
            os.close();
            return dati;
        }
        catch (Exception e) {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception io) {
                // empty catch block
            }
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception io) {
                // empty catch block
            }
            throw new UtilsException("StreamJDBCAppender error, reading binary parameter [indice:" + index + "]" + e.getMessage());
        }
    }

    public void setBinaryData(PreparedStatement s, int index, byte[] data) throws UtilsException, SQLException {
        ByteArrayInputStream bin = null;
        try {
            bin = data != null ? new ByteArrayInputStream(data) : new ByteArrayInputStream("".getBytes());
        }
        catch (Exception e) {
            throw new UtilsException("StreamJDBCAppender error, set binary parameter [indice:" + index + "]" + e.getMessage());
        }
        s.setBinaryStream(index, (InputStream)bin, data.length);
    }
}

