/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.utils.jdbc;

import org.openspcoop.utils.jdbc.BlobJDBCAdapter;
import org.openspcoop.utils.jdbc.BytesJDBCAdapter;
import org.openspcoop.utils.jdbc.IJDBCAdapter;
import org.openspcoop.utils.jdbc.JDBCAdapterException;
import org.openspcoop.utils.sql.TipiDatabase;

public class JDBCAdapterFactory {
    public static IJDBCAdapter createJDBCAdapter(String tipoDatabase) throws JDBCAdapterException {
        IJDBCAdapter jdbcAdapter = null;
        if (TipiDatabase.POSTGRESQL.equals(tipoDatabase)) {
            jdbcAdapter = new BytesJDBCAdapter();
        } else if (TipiDatabase.MYSQL.equals(tipoDatabase)) {
            jdbcAdapter = new BlobJDBCAdapter();
        } else if (TipiDatabase.ORACLE.equals(tipoDatabase)) {
            jdbcAdapter = new BlobJDBCAdapter();
        } else {
            throw new JDBCAdapterException("Tipo database non gestito [" + tipoDatabase + "]");
        }
        return jdbcAdapter;
    }
}

