/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.utils.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.openspcoop.utils.FileSystemUtilities;
import org.openspcoop.utils.UtilsException;

public class ZipUtilities {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzipFile(String zipFile, String dest) throws UtilsException {
        try {
            File destFile = new File(dest);
            if (!destFile.exists()) {
                if (!destFile.mkdir()) {
                    throw new Exception("Destinazione [" + dest + "] non esistente e creazione non riuscita");
                }
            } else {
                if (!destFile.isDirectory()) {
                    throw new Exception("Destinazione [" + dest + "] non e' una directory");
                }
                if (!destFile.canWrite()) {
                    throw new Exception("Destinazione [" + dest + "] non accessibile in scrittura ");
                }
            }
            OutputStream out = null;
            InputStream iZip = null;
            ZipFile zf = new ZipFile(zipFile);
            try {
                Enumeration<? extends ZipEntry> em = zf.entries();
                while (em.hasMoreElements()) {
                    int len;
                    ZipEntry ze = em.nextElement();
                    String targetfile = destFile.getAbsolutePath() + File.separatorChar + ze.getName();
                    FileSystemUtilities.mkdirParentDirectory(targetfile);
                    if (ze.getName() != null && (ze.getName().endsWith("/") || ze.getName().endsWith("\\"))) {
                        File fDir = new File(targetfile);
                        if (fDir.mkdir()) continue;
                        throw new Exception("Creazione directory [" + fDir.getAbsolutePath() + "] per entry [" + ze.getName() + "] non riuscita");
                    }
                    iZip = zf.getInputStream(ze);
                    out = new FileOutputStream(targetfile);
                    byte[] buf = new byte[1024];
                    while ((len = iZip.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                    iZip.close();
                    iZip = null;
                    out.flush();
                    out.close();
                    out = null;
                }
            }
            finally {
                if (out != null) {
                    out.close();
                }
                if (iZip != null) {
                    iZip.close();
                }
            }
        }
        catch (Exception e) {
            throw new UtilsException("Unzip non riuscito: " + e.getMessage(), e);
        }
    }
}

