/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.openspcoop.utils.HttpUtilities;
import org.openspcoop.utils.UtilsException;
import org.openspcoop.utils.date.DateManager;
import org.openspcoop.utils.regexp.RegularExpressionEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utilities {
    public static final int DIMENSIONE_BUFFER = 65536;
    private static final double KB = 1024.0;
    private static final double MB = 1048576.0;
    private static long serialNumber = 0L;
    private static final String oneAlpha = "(.)*((\\p{Alpha})|[-])(.)*";
    private static final String domainIdentifier = "((\\p{Alnum})([-]|(\\p{Alnum}))*(\\p{Alnum}))|(\\p{Alnum})";
    private static final String domainNameRule = "(((\\p{Alnum})([-]|(\\p{Alnum}))*(\\p{Alnum}))|(\\p{Alnum}))((\\.)(((\\p{Alnum})([-]|(\\p{Alnum}))*(\\p{Alnum}))|(\\p{Alnum})))*";

    public static byte[] getAsByteArray(InputStream is) throws UtilsException {
        try {
            return Utilities.getAsByteArrayOuputStream(is).toByteArray();
        }
        catch (Exception e) {
            throw new UtilsException("Utilities.readBytes error " + e.getMessage(), e);
        }
    }

    public static ByteArrayOutputStream getAsByteArrayOuputStream(InputStream is) throws UtilsException {
        try {
            byte[] buffer = new byte[65536];
            int letti = 0;
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            while ((letti = is.read(buffer)) != -1) {
                bout.write(buffer, 0, letti);
            }
            bout.flush();
            bout.close();
            return bout;
        }
        catch (Exception e) {
            throw new UtilsException("Utilities.readBytes error " + e.getMessage(), e);
        }
    }

    public static String hash(String key) throws UtilsException {
        try {
            StringBuffer returnKey = new StringBuffer();
            for (int i = 0; i < key.length(); ++i) {
                if (key.charAt(i) == '_' || key.charAt(i) == '-' || key.charAt(i) == '.' || key.charAt(i) == ':') continue;
                returnKey.append(key.charAt(i));
            }
            return returnKey.toString();
        }
        catch (Exception e) {
            throw new UtilsException("Utilities.hash error " + e.getMessage(), e);
        }
    }

    public static Properties readProperties(String prefix, Properties sorgente) throws UtilsException {
        Properties prop = new Properties();
        try {
            Enumeration<?> en = sorgente.propertyNames();
            while (en.hasMoreElements()) {
                String value;
                String property = (String)en.nextElement();
                if (!property.startsWith(prefix)) continue;
                String key = property.substring(prefix.length());
                if (key != null) {
                    key = key.trim();
                }
                if ((value = sorgente.getProperty(property)) != null) {
                    value = value.trim();
                }
                if (key == null || value == null) continue;
                prop.setProperty(key, value);
            }
            return prop;
        }
        catch (Exception e) {
            throw new UtilsException("Utilities.readProperties Riscontrato errore durante la lettura delle propriete con prefisso [" + prefix + "]: " + e.getMessage(), e);
        }
    }

    public static Properties readProperties(String prefix, String[] key, String[] name) throws UtilsException {
        Properties sorgente = new Properties();
        if (key != null && name != null && key.length == name.length) {
            for (int i = 0; i < key.length; ++i) {
                sorgente.put(key[i], name[i]);
            }
        }
        return Utilities.readProperties(prefix, sorgente);
    }

    public static String convertSystemTimeIntoString_millisecondi(long time, boolean millisecondiCheck) {
        long millisecondi = time % 1000L;
        long diff = time / 1000L;
        long ore = diff / 3600L;
        long minuti = diff % 3600L / 60L;
        long secondi = diff % 3600L % 60L;
        StringBuffer bf = new StringBuffer();
        if (ore == 1L) {
            bf.append(ore + " ora ");
        } else if (ore > 0L) {
            bf.append(ore + " ore ");
        }
        if (minuti == 1L) {
            bf.append(minuti + " minuto ");
        } else if (minuti > 0L) {
            bf.append(minuti + " minuti ");
        }
        if (secondi == 1L) {
            bf.append(secondi + " secondo ");
        } else if (secondi > 0L) {
            bf.append(secondi + " secondi ");
        }
        if (millisecondiCheck) {
            if (millisecondi == 1L) {
                bf.append(millisecondi + " millisecondo");
            } else if (millisecondi >= 0L) {
                bf.append(millisecondi + " millisecondi");
            }
        }
        if (bf.length() == 0) {
            bf.append("conversione non riuscita");
        }
        return bf.toString();
    }

    public static String convertBytesToFormatString(long value) {
        MessageFormat mf = new MessageFormat("{0,number,#.##}");
        Double len = null;
        String res = "";
        len = new Long(value).doubleValue();
        long d = Math.round(len / 1024.0);
        if (d <= 1L) {
            Object[] objs = new Object[]{len};
            res = mf.format(objs);
            res = res + " B";
        } else if (d > 1L && d < 1000L) {
            Object[] objs = new Object[]{len / 1024.0};
            res = mf.format(objs);
            res = res + " KB";
        } else {
            Object[] objs = new Object[]{len / 1048576.0};
            res = mf.format(objs);
            res = res + " MB";
        }
        return res;
    }

    public static synchronized String getUniqueID() {
        if (serialNumber + 1L > Long.MAX_VALUE) {
            serialNumber = 0L;
        }
        return "T:" + DateManager.getTimeMillis() + "_S:" + ++serialNumber;
    }

    public static void validateUrl(String url) throws MalformedURLException {
        URL testUrl = new URL(url);
        testUrl.toString();
    }

    public static void validateUri(String uri, boolean checkEsistenzaFile) throws UtilsException, MalformedURLException {
        if (uri.startsWith("http://") || uri.startsWith("file://")) {
            if (checkEsistenzaFile) {
                HttpUtilities.requestHTTPFile(uri);
            } else {
                Utilities.validateUrl(uri);
            }
        } else {
            File f = new File(uri);
            if (checkEsistenzaFile) {
                if (!f.exists()) {
                    throw new UtilsException("File non esistente");
                }
                if (f.isDirectory()) {
                    throw new UtilsException("File e' una directory");
                }
                if (!f.canRead()) {
                    throw new UtilsException("File non accessibile");
                }
            }
        }
    }

    public static boolean validateDomainName(String domainName) {
        if (domainName == null || domainName.length() > 63) {
            return false;
        }
        return domainName.matches(domainNameRule) && domainName.matches(oneAlpha);
    }

    public static boolean isIPOrHostname(String stringToCheck) {
        boolean ok = true;
        try {
            if (!RegularExpressionEngine.isMatch(stringToCheck, "^[0-9]+.[0-9]+.[0-9]+.[0-9]+$") && !Utilities.validateDomainName(stringToCheck)) {
                ok = false;
            }
        }
        catch (Exception e) {
            Date now = new Date();
            System.err.println(now + " Exception " + e.getMessage());
        }
        return ok;
    }

    public static boolean sslVerify(String subjectPresenteNellaConfigurazione, String subjectArrivatoConnessioneSSL) throws UtilsException {
        Hashtable<String, String> hashSubjectArrivatoConnessioneSSL = Utilities.getSubjectIntoHashtable(subjectArrivatoConnessioneSSL);
        Hashtable<String, String> hashSubjectPresenteNellaConfigurazione = Utilities.getSubjectIntoHashtable(subjectPresenteNellaConfigurazione);
        if (hashSubjectArrivatoConnessioneSSL.size() != hashSubjectPresenteNellaConfigurazione.size()) {
            return false;
        }
        Enumeration<String> keys = hashSubjectArrivatoConnessioneSSL.keys();
        while (keys.hasMoreElements()) {
            String configurazioneInternaValue;
            String key = keys.nextElement();
            if (!hashSubjectPresenteNellaConfigurazione.containsKey(key)) {
                return false;
            }
            String connessioneSSLValue = hashSubjectArrivatoConnessioneSSL.get(key);
            if (connessioneSSLValue.equals(configurazioneInternaValue = hashSubjectPresenteNellaConfigurazione.get(key))) continue;
            return false;
        }
        return true;
    }

    public static String formatSubject(String subject) throws UtilsException {
        Hashtable<String, String> hashSubject = Utilities.getSubjectIntoHashtable(subject);
        StringBuffer bf = new StringBuffer();
        bf.append("/");
        Enumeration<String> keys = hashSubject.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String value = hashSubject.get(key);
            bf.append(Utilities.formatKeySubject(key));
            bf.append("=");
            bf.append(Utilities.formatValueSubject(value));
            bf.append("/");
        }
        return bf.toString();
    }

    public static void validaSubject(String subject) throws UtilsException {
        if (subject.contains(",") && subject.contains("/")) {
            throw new UtilsException("Non possono coesistere i separatore \",\" e \"/\", solo uno dei due tipi deve essere utilizzato come delimitatore");
        }
        if (!(subject.contains(",") || subject.contains("/") || subject.contains("="))) {
            throw new UtilsException("Subject non valido, nemmeno una coppia nome=valore trovata");
        }
        String[] valoriSubject = Utilities.getValoriSubject(subject);
        boolean campoObbligatorioCN = false;
        boolean campoObbligatorioOU = false;
        boolean campoObbligatorioO = false;
        boolean campoObbligatorioL = false;
        boolean campoObbligatorioST = false;
        boolean campoObbligatorioC = false;
        boolean campoObbligatorioE = false;
        for (int i = 0; i < valoriSubject.length; ++i) {
            if (!valoriSubject[i].contains("=")) {
                throw new UtilsException("Comprensione subject non riuscita: [" + valoriSubject[i] + "] non separata dal carattere \"=\"");
            }
            String[] keyValue = valoriSubject[i].trim().split("=");
            if (keyValue.length != 2) {
                throw new UtilsException("Comprensione subject non riuscita: [" + valoriSubject[i] + "] contiene piu' di un carattere \"=\"");
            }
            if (keyValue[0].trim().contains(" ")) {
                throw new UtilsException("Comprensione subject non riuscita: il campo [" + valoriSubject[i] + "] contiene spazi nella chiave identificativa [" + keyValue[0].trim() + "]");
            }
            if (Utilities.formatKeySubject(keyValue[0]).equalsIgnoreCase("CN")) {
                campoObbligatorioCN = true;
                continue;
            }
            if (Utilities.formatKeySubject(keyValue[0]).equalsIgnoreCase("OU")) {
                campoObbligatorioOU = true;
                continue;
            }
            if (Utilities.formatKeySubject(keyValue[0]).equalsIgnoreCase("O")) {
                campoObbligatorioO = true;
                continue;
            }
            if (Utilities.formatKeySubject(keyValue[0]).equalsIgnoreCase("L")) {
                campoObbligatorioL = true;
                continue;
            }
            if (Utilities.formatKeySubject(keyValue[0]).equalsIgnoreCase("ST")) {
                campoObbligatorioST = true;
                continue;
            }
            if (Utilities.formatKeySubject(keyValue[0]).equalsIgnoreCase("C")) {
                campoObbligatorioC = true;
                continue;
            }
            if (!Utilities.formatKeySubject(keyValue[0]).equalsIgnoreCase("E")) continue;
            campoObbligatorioE = true;
        }
        if (!(campoObbligatorioCN || campoObbligatorioOU || campoObbligatorioO || campoObbligatorioL || campoObbligatorioST || campoObbligatorioC || campoObbligatorioE)) {
            throw new UtilsException("Almeno un attributo di certificato tra 'CN', 'OU', 'O', 'L', 'ST', 'C' e 'E' deve essere valorizzato.");
        }
    }

    public static String[] getValoriSubject(String subject) throws UtilsException {
        String[] valori;
        if (subject.contains(",")) {
            if (subject.startsWith(",")) {
                subject = subject.substring(1);
            }
            if (subject.endsWith(",")) {
                subject = subject.substring(0, subject.length() - 1);
            }
            valori = subject.split(",");
        } else if (!subject.contains("/")) {
            int indexOf = subject.indexOf("=");
            if (indexOf <= 0) {
                throw new UtilsException("Separatore validi per il subject interno alla configurazione di OpenSPCoop non trovati:  \",\" o \"/\" e carattere \"=\" non presente");
            }
            if (subject.indexOf("=", indexOf + 1) >= 0) {
                throw new UtilsException("Separatore validi per il subject interno alla configurazione di OpenSPCoop non trovati:  \",\" o \"/\"");
            }
            valori = new String[]{subject};
        } else {
            if (subject.startsWith("/")) {
                subject = subject.substring(1);
            }
            if (subject.endsWith("/")) {
                subject = subject.substring(0, subject.length() - 1);
            }
            valori = subject.split("/");
        }
        if (valori == null || valori.length < 1) {
            throw new UtilsException("Comprensione subject interno alla configurazione di OpenSPCoop non riuscita: null??");
        }
        return valori;
    }

    public static Hashtable<String, String> getSubjectIntoHashtable(String subject) throws UtilsException {
        Hashtable<String, String> hashSubject = new Hashtable<String, String>();
        String[] valoriSubject = Utilities.getValoriSubject(subject);
        for (int i = 0; i < valoriSubject.length; ++i) {
            if (!valoriSubject[i].contains("=")) {
                throw new UtilsException("Comprensione subject non riuscita: [" + valoriSubject[i] + "] non separata dal carattere \"=\"");
            }
            String[] keyValue = valoriSubject[i].trim().split("=");
            if (keyValue.length != 2) {
                throw new UtilsException("Comprensione subject non riuscita: [" + valoriSubject[i] + "] contiene piu' di un carattere \"=\"");
            }
            hashSubject.put(Utilities.formatKeySubject(keyValue[0]), Utilities.formatValueSubject(keyValue[1]));
        }
        return hashSubject;
    }

    public static String formatKeySubject(String keySubject) {
        return keySubject.trim().toLowerCase();
    }

    public static String formatValueSubject(String valueSubject) {
        return valueSubject.trim();
    }

    public static boolean existsInnerException(Throwable e, Class<?> found) {
        return Utilities.existsInnerException(e, found.getName());
    }

    public static boolean existsInnerException(Throwable e, String found) {
        if (e.getClass().getName().equals(found)) {
            return true;
        }
        if (e.getCause() != null) {
            return Utilities.existsInnerException(e.getCause(), found);
        }
        return false;
    }

    public static Throwable getInnerException(Throwable e, Class<?> found) {
        return Utilities.getInnerException(e, found.getName());
    }

    public static Throwable getInnerException(Throwable e, String found) {
        if (e.getClass().getName().equals(found)) {
            return e;
        }
        if (e.getCause() != null) {
            return Utilities.getInnerException(e.getCause(), found);
        }
        return null;
    }

    public static Throwable getLastInnerException(Throwable e) {
        if (e.getCause() == null) {
            return e;
        }
        return Utilities.getLastInnerException(e.getCause());
    }

    public static boolean existsInnerMessageException(Throwable e, String msg, boolean contains) {
        boolean search = false;
        if (contains) {
            search = e.getMessage() != null && e.getMessage().contains(msg);
        } else {
            boolean bl = search = e.getMessage() != null && e.getMessage().equals(msg);
        }
        if (search) {
            return true;
        }
        if (e.getCause() != null) {
            return Utilities.existsInnerMessageException(e.getCause(), msg, contains);
        }
        return false;
    }

    public static Throwable getInnerMessageException(Throwable e, String msg, boolean contains) {
        boolean search = false;
        if (contains) {
            search = e.getMessage() != null && e.getMessage().contains(msg);
        } else {
            boolean bl = search = e.getMessage() != null && e.getMessage().equals(msg);
        }
        if (search) {
            return e;
        }
        if (e.getCause() != null) {
            return Utilities.getInnerMessageException(e.getCause(), msg, contains);
        }
        return null;
    }
}

