/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.SOAPPart;
import org.apache.axis.client.AxisClient;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.message.Detail;
import org.apache.axis.message.InputStreamBody;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.PrefixedQName;
import org.apache.axis.message.SOAPBody;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeader;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.server.AxisServer;
import org.apache.axis.soap.MessageFactoryImpl;
import org.apache.axis.soap.SOAPFactoryImpl;
import org.openspcoop.dao.eccezione.DettaglioEccezione;
import org.openspcoop.utils.AttachmentsUtils;
import org.openspcoop.utils.OpenSPCoopDataContentHandler;
import org.openspcoop.utils.OpenSPCoopDataContentHandlerInputStream;
import org.openspcoop.utils.UtilsException;
import org.openspcoop.utils.xml.XMLUtils;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SoapUtils {
    private static SOAPFactory soapfactory = null;
    private static MessageFactory messagefactory = null;
    private static AxisServer axisServer = null;
    private static AxisClient axisClient = null;
    private static MessageContext msgContext = null;

    public static SOAPFactory getSoapFactory() throws SOAPException {
        if (soapfactory == null) {
            SoapUtils.initSoapFactory();
        }
        return soapfactory;
    }

    public static synchronized void initSoapFactory() throws SOAPException {
        if (soapfactory == null) {
            soapfactory = new SOAPFactoryImpl();
        }
    }

    public static MessageFactory getMessageFactory() throws SOAPException {
        if (messagefactory == null) {
            SoapUtils.initMessageFactory();
        }
        return messagefactory;
    }

    public static synchronized void initMessageFactory() throws SOAPException {
        if (messagefactory == null) {
            messagefactory = new MessageFactoryImpl();
        }
    }

    public static synchronized void initAxisServer() {
        if (axisServer == null) {
            axisServer = new AxisServer();
        }
    }

    public static AxisServer getAxisServer() {
        if (axisServer == null) {
            SoapUtils.initAxisServer();
        }
        return axisServer;
    }

    public static synchronized void initAxisClient() {
        if (axisClient == null) {
            axisClient = new AxisClient();
        }
    }

    public static AxisClient getAxisClient() {
        if (axisClient == null) {
            SoapUtils.initAxisClient();
        }
        return axisClient;
    }

    public static synchronized void initMessageContext() {
        if (msgContext == null) {
            msgContext = new MessageContext((AxisEngine)new AxisServer());
            msgContext.setProperty("sendXsiTypes", (Object)false);
        }
    }

    public static String getSoapAction(Message msg) throws UtilsException {
        String soapAction = null;
        try {
            MimeHeaders mhs = msg.getMimeHeaders();
            Iterator it = mhs.getAllHeaders();
            while (it.hasNext()) {
                MimeHeader mh = (MimeHeader)it.next();
                if (!"soapaction".equalsIgnoreCase(mh.getName())) continue;
                soapAction = mh.getValue();
            }
            if (soapAction == null) {
                if (msg.getProperty("SOAPAction") != null) {
                    soapAction = (String)msg.getProperty("SOAPAction");
                } else if (msg.getProperty("soapaction") != null) {
                    soapAction = (String)msg.getProperty("soapaction");
                } else if (msg.getProperty("soapAction") != null) {
                    soapAction = (String)msg.getProperty("soapAction");
                } else if (msg.getProperty("SoapAction") != null) {
                    soapAction = (String)msg.getProperty("SoapAction");
                } else if (msg.getProperty("SOAPACTION") != null) {
                    soapAction = (String)msg.getProperty("SOAPACTION");
                }
            }
            return soapAction;
        }
        catch (Exception e) {
            throw new UtilsException("Lettura SOAPAction non riuscita", e);
        }
    }

    public static boolean matchLocalName(Node nodo, String nodeName, String prefix, String namespace) {
        if (nodo == null) {
            return false;
        }
        if (nodo.getNodeName() == null) {
            return false;
        }
        if (nodo.getNodeName().equals(prefix + nodeName)) {
            return true;
        }
        String namespaceNodo = nodo.getNamespaceURI();
        if (namespaceNodo != null && namespaceNodo.equals(namespace)) {
            String xmlns = nodo.getPrefix();
            if (xmlns == null) {
                xmlns = "";
            } else if (!xmlns.equals("")) {
                xmlns = xmlns + ":";
            }
            if (nodo.getNodeName().equals(xmlns + nodeName)) {
                return true;
            }
        }
        return false;
    }

    public static Node getAttributeNode(Node node, String attributeName) {
        if (node == null) {
            return null;
        }
        NamedNodeMap map = node.getAttributes();
        if (map == null || map.getLength() == 0) {
            return null;
        }
        return map.getNamedItem(attributeName);
    }

    public static Node getQualifiedAttributeNode(Node node, String attributeName, String namespace) {
        if (node == null) {
            return null;
        }
        NamedNodeMap map = node.getAttributes();
        if (map == null || map.getLength() == 0) {
            return null;
        }
        return map.getNamedItemNS(namespace, attributeName);
    }

    public static Message buildOpenSPCoopOK_axisMsg(String idEGov) throws UtilsException {
        try {
            ByteArrayInputStream inputBody = new ByteArrayInputStream(SoapUtils.buildOpenSPCoopOK(idEGov));
            MessageFactoryImpl mf = new MessageFactoryImpl();
            Message responseAxisMessage = (Message)mf.createMessage();
            javax.xml.soap.SOAPBody soapBody = responseAxisMessage.getSOAPBody();
            InputStreamBody isBody = new InputStreamBody((InputStream)inputBody);
            soapBody.addChildElement((SOAPElement)isBody);
            inputBody.close();
            return responseAxisMessage;
        }
        catch (Exception e) {
            throw new UtilsException("Creazione MsgOpenSPCoopOK non riuscito: " + e.getMessage(), e);
        }
    }

    public static byte[] buildOpenSPCoopOK(String idEGov) throws UtilsException {
        try {
            PrefixedQName name = new PrefixedQName("http://www.openspcoop.org/pdd/services/PD", "RispostaOK", "OpenSPCoop");
            MessageElement ok = new MessageElement((Name)name);
            ok.setAttribute("ID", idEGov);
            return SoapUtils.getAsString(ok).getBytes();
        }
        catch (Exception e) {
            throw new UtilsException("Creazione MsgOpenSPCoopOK non riuscito: " + e.getMessage(), e);
        }
    }

    public static String toString(SOAPFault fault) throws UtilsException {
        return SoapUtils.toString(fault, true);
    }

    public static String toString(SOAPFault fault, boolean printDetails) throws UtilsException {
        try {
            if (printDetails && fault != null && fault instanceof org.apache.axis.message.SOAPFault) {
                AxisFault af = ((org.apache.axis.message.SOAPFault)fault).getFault();
                af.removeHostname();
                af.removeFaultDetail(new QName("http://xml.apache.org/axis/", "stackTrace"));
                String print = af.dumpToString();
                if (print.startsWith("AxisFault")) {
                    print = print.substring("AxisFault".length());
                }
                return print;
            }
            StringBuffer bf = new StringBuffer();
            if (fault != null) {
                bf.append("SOAPFault");
                if (fault.getFaultCode() != null && !"".equals(fault.getFaultCode())) {
                    bf.append(" faultCode[" + fault.getFaultCode() + "]");
                }
                if (fault.getFaultActor() != null && !"".equals(fault.getFaultActor())) {
                    bf.append(" faultActor[" + fault.getFaultActor() + "]");
                }
                if (fault.getFaultString() != null && !"".equals(fault.getFaultString())) {
                    bf.append(" faultString[" + fault.getFaultString() + "]");
                }
                if (printDetails) {
                    Detail details = (Detail)fault.addDetail();
                    details = (Detail)fault.getDetail();
                    Iterator elemChilds = fault.getDetail().getChildElements();
                    while (elemChilds.hasNext()) {
                        MessageElement mChild = (MessageElement)elemChilds.next();
                        bf.append(" detail[" + mChild.getAsString() + "]");
                    }
                }
            } else {
                return "SOAPFault non presente";
            }
            return bf.toString();
        }
        catch (Exception e) {
            throw new UtilsException("toString SOAPFault: " + e.getMessage(), e);
        }
    }

    public static Message build_Soap_Empty() {
        try {
            MessageFactoryImpl mf = new MessageFactoryImpl();
            Message msg = (Message)mf.createMessage();
            return msg;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] build_Soap_Fault(String aFault, String aActor, String aCode, DettaglioEccezione dettaglioEccezione, boolean generaDetails) throws UtilsException {
        ByteArrayOutputStream byteEGOV = null;
        try {
            MessageFactoryImpl mf = new MessageFactoryImpl();
            SOAPMessage msg = mf.createMessage();
            javax.xml.soap.SOAPEnvelope env = msg.getSOAPPart().getEnvelope();
            javax.xml.soap.SOAPBody bdy = env.getBody();
            bdy.addFault();
            SOAPFault fault = bdy.getFault();
            if (aFault != null) {
                fault.setFaultString(aFault);
            } else {
                fault.setFaultString("");
            }
            if (aCode != null) {
                fault.setFaultCode(aCode);
            }
            if (aActor != null) {
                fault.setFaultActor(aActor);
            }
            if (generaDetails && dettaglioEccezione != null) {
                fault.addDetail();
                javax.xml.soap.Detail d = fault.getDetail();
                d.addChildElement((SOAPElement)new MessageElement(XMLUtils.newElement(org.openspcoop.dao.eccezione.driver.XMLUtils.generateDettaglioEccezione(dettaglioEccezione))));
            }
            byteEGOV = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)byteEGOV);
            byte[] risultato = byteEGOV.toByteArray();
            byteEGOV.close();
            return risultato;
        }
        catch (Exception e) {
            try {
                if (byteEGOV != null) {
                    byteEGOV.close();
                }
            }
            catch (Exception eis) {
                // empty catch block
            }
            throw new UtilsException("Creazione MsgSOAPFault non riuscito: " + e.getMessage(), e);
        }
    }

    public static boolean isTunnelOpenSPCoopSoap(javax.xml.soap.SOAPBody body) {
        return body != null && body.hasChildNodes() && body.getFirstChild() != null && "SOAPTunnel".equals(body.getFirstChild().getLocalName()) && "http://www.openspcoop.org/pdd/services/PDtoSOAP".equals(body.getFirstChild().getNamespaceURI()) && "OpenSPCoop".equals(body.getFirstChild().getPrefix());
    }

    public static String getContentTypeTunnelOpenSPCoopSoap(javax.xml.soap.SOAPBody body) throws UtilsException {
        if (body != null && body.hasChildNodes()) {
            return ((SOAPElement)body.getChildElements().next()).getValue();
        }
        throw new UtilsException("Body non presente");
    }

    public static void sbustamentoMessaggio(Message msg, OutputStream stream) throws UtilsException {
        try {
            if (msg.countAttachments() == 0) {
                SOAPBody bd = (SOAPBody)msg.getSOAPBody();
                if (bd.hasFault()) {
                    org.apache.axis.message.SOAPFault fault = (org.apache.axis.message.SOAPFault)bd.getFault();
                    stream.write(fault.getAsString().getBytes());
                } else {
                    Iterator it = bd.getChildElements();
                    while (it.hasNext()) {
                        MessageElement bodyElement = (MessageElement)it.next();
                        stream.write(bodyElement.getAsString().getBytes());
                    }
                }
            } else {
                javax.xml.soap.SOAPBody body = msg.getSOAPBody();
                if (SoapUtils.isTunnelOpenSPCoopSoap(body)) {
                    AttachmentPart ap = (AttachmentPart)msg.getAttachments().next();
                    Object o = ap.getContent();
                    InputStream inputDH = null;
                    if (o instanceof OpenSPCoopDataContentHandlerInputStream) {
                        inputDH = (OpenSPCoopDataContentHandlerInputStream)o;
                    } else if (o instanceof InputStream) {
                        inputDH = (InputStream)OpenSPCoopDataContentHandler.getContent((InputStream)o);
                    } else {
                        throw new Exception("Tipo non gestito: " + o.getClass().getName());
                    }
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    byte[] readB = new byte[8192];
                    int readByte = 0;
                    while ((readByte = inputDH.read(readB)) != -1) {
                        bout.write(readB, 0, readByte);
                    }
                    inputDH.close();
                    bout.close();
                    stream.write(bout.toByteArray());
                } else {
                    ByteArrayOutputStream sbustamentoAttachments = new ByteArrayOutputStream();
                    msg.writeTo((OutputStream)sbustamentoAttachments);
                    String msgString = sbustamentoAttachments.toString();
                    byte[] msgByte = sbustamentoAttachments.toByteArray();
                    String soapEnvelopeStart = "<" + msg.getSOAPEnvelope().getPrefix() + ":" + msg.getSOAPEnvelope().getName();
                    String xmlTagDecode = "<?xml";
                    String soapEnvelopeStop = "</" + msg.getSOAPEnvelope().getPrefix() + ":" + msg.getSOAPEnvelope().getName() + ">";
                    if (msgString.indexOf(xmlTagDecode) != -1) {
                        stream.write(msgByte, 0, msgString.indexOf(xmlTagDecode));
                    } else {
                        stream.write(msgByte, 0, msgString.indexOf(soapEnvelopeStart));
                    }
                    SOAPBody bd = (SOAPBody)msg.getSOAPBody();
                    if (bd.hasFault()) {
                        org.apache.axis.message.SOAPFault fault = (org.apache.axis.message.SOAPFault)bd.getFault();
                        stream.write(fault.getAsString().getBytes());
                    } else {
                        Iterator it = bd.getChildElements();
                        while (it.hasNext()) {
                            MessageElement bodyElement = (MessageElement)it.next();
                            stream.write(bodyElement.getAsString().getBytes());
                        }
                    }
                    int indexOf = msgString.indexOf(soapEnvelopeStop) + soapEnvelopeStop.length();
                    stream.write(msgByte, indexOf, msgByte.length - indexOf);
                }
            }
        }
        catch (Exception e) {
            throw new UtilsException("Sbustamento AxisMsg_inputStream non riuscito: " + e.getMessage(), e);
        }
    }

    public static byte[] sbustamentoMessaggio(Message msg) throws UtilsException {
        ByteArrayOutputStream bodySbustato = new ByteArrayOutputStream();
        try {
            SoapUtils.sbustamentoMessaggio(msg, bodySbustato);
            return bodySbustato.toByteArray();
        }
        catch (Exception e) {
            try {
                if (bodySbustato != null) {
                    bodySbustato.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new UtilsException("Sbustamento AxisMsg non riuscito: " + e.getMessage(), e);
        }
    }

    public static byte[] sbustamentoSOAPEnvelope(SOAPEnvelope env) throws UtilsException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            SOAPBody bd = (SOAPBody)env.getBody();
            if (bd.hasFault()) {
                org.apache.axis.message.SOAPFault fault = (org.apache.axis.message.SOAPFault)bd.getFault();
                stream.write(fault.getAsString().getBytes());
            } else {
                Iterator it = bd.getChildElements();
                while (it.hasNext()) {
                    MessageElement bodyElement = (MessageElement)it.next();
                    stream.write(bodyElement.getAsString().getBytes());
                }
            }
            byte[] body = stream.toByteArray();
            stream.close();
            return body;
        }
        catch (Exception e) {
            try {
                stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new UtilsException("Sbustamento SoapEnvelope non riuscito: " + e.getMessage(), e);
        }
    }

    public static Message imbustamentoMessaggioConAttachment(InputStream inputBody, String tipoAttachment, boolean buildAsDataHandler, String contentTypeMessaggioOriginale) throws UtilsException {
        try {
            ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
            byte[] readB = new byte[65536];
            int readByte = 0;
            while ((readByte = inputBody.read(readB)) != -1) {
                byteBuffer.write(readB, 0, readByte);
            }
            inputBody.close();
            if (byteBuffer.size() == 0) {
                throw new UtilsException("Contenuto da imbustare non presente");
            }
            return SoapUtils.imbustamentoMessaggioConAttachment(byteBuffer.toByteArray(), tipoAttachment, buildAsDataHandler, contentTypeMessaggioOriginale);
        }
        catch (Exception e) {
            throw new UtilsException("Imbustamento msgConAttachment_inputStream non riuscito: " + e.getMessage(), e);
        }
    }

    public static Message imbustamentoMessaggioConAttachment(byte[] inputBody, String tipoAttachment, boolean buildAsDataHandler, String contentTypeMessaggioOriginale) throws UtilsException {
        Message msg = null;
        try {
            if (inputBody == null || inputBody.length <= 0) {
                throw new UtilsException("Contenuto da imbustare non presente");
            }
            MessageFactoryImpl mf = new MessageFactoryImpl();
            msg = (Message)mf.createMessage();
            javax.xml.soap.SOAPBody soapBody = msg.getSOAPBody();
            PrefixedQName name = null;
            name = "application/openspcoop".equals(tipoAttachment) ? new PrefixedQName("http://www.openspcoop.org/pdd/services/PDtoSOAP", "SOAPTunnel", "OpenSPCoop") : new PrefixedQName("http://www.openspcoop.org/pdd/services/PDtoSOAP", "Attachments", "OpenSPCoop");
            SOAPBodyElement bodyElement = soapBody.addBodyElement((Name)name);
            if ("application/openspcoop".equals(tipoAttachment)) {
                if (contentTypeMessaggioOriginale == null) {
                    throw new Exception("ContentType messaggio per cui applicare il tunnel non definito?");
                }
                bodyElement.setValue(contentTypeMessaggioOriginale);
            }
            org.apache.axis.attachments.AttachmentPart ap = (org.apache.axis.attachments.AttachmentPart)msg.createAttachmentPart();
            if (buildAsDataHandler) {
                ap.setDataHandler(new DataHandler((Object)new ByteArrayInputStream(inputBody), tipoAttachment));
                SoapUtils.saveAttachmentOpenSPCoop(ap);
            } else {
                ap.setContent((Object)new ByteArrayInputStream(inputBody), tipoAttachment);
            }
            msg.addAttachmentPart((AttachmentPart)ap);
            return msg;
        }
        catch (Exception e) {
            throw new UtilsException("Imbustamento msgConAttachment_inputStream non riuscito: " + e.getMessage(), e);
        }
    }

    private static void saveAttachmentOpenSPCoop(org.apache.axis.attachments.AttachmentPart ap) throws SOAPException, IOException {
        DataHandler dh = ap.getDataHandler();
        InputStream inputDH = dh.getInputStream();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] readB = new byte[8192];
        int readByte = 0;
        while ((readByte = inputDH.read(readB)) != -1) {
            bout.write(readB, 0, readByte);
        }
        inputDH.close();
        bout.flush();
        bout.close();
        ap.setDataHandler(new DataHandler((Object)bout.toByteArray(), ap.getContentType()));
    }

    public static Message imbustamentoMessaggioConAttachment(byte[] body) throws UtilsException {
        Message risposta = null;
        try {
            risposta = SoapUtils.imbustamentoMessaggioConAttachment(body, "text/plain", false, null);
            return risposta;
        }
        catch (Exception e) {
            throw new UtilsException("Imbustamento msgConAttachment non riuscito: " + e.getMessage(), e);
        }
    }

    public static Message imbustamentoMessaggio(byte[] body, boolean eraserXMLTag) throws UtilsException {
        return SoapUtils.build(body, true, eraserXMLTag);
    }

    public static Message build(byte[] byteMsg, boolean isBodyStream) throws UtilsException {
        return SoapUtils.build(byteMsg, isBodyStream, false, true);
    }

    public static Message build(byte[] byteMsg, boolean isBodyStream, boolean eraserXMLTag) throws UtilsException {
        return SoapUtils.build(byteMsg, isBodyStream, eraserXMLTag, true);
    }

    public static Message build(byte[] byteMsg, boolean isBodyStream, boolean eraserXMLTag, boolean checkEmptyBody) throws UtilsException {
        try {
            if (byteMsg == null || byteMsg.length == 0) {
                throw new Exception("Nessun contenuto su cui costruire il messaggio");
            }
            int offset = 0;
            String contentType = "text/xml";
            if (AttachmentsUtils.messageWithAttachment(byteMsg)) {
                String IDfirst = AttachmentsUtils.firstContentID(byteMsg);
                String boundary = AttachmentsUtils.findBoundary(byteMsg);
                if (boundary == null) {
                    throw new Exception("Errore avvenuto durante la lettura del boundary associato al multipart message.");
                }
                contentType = IDfirst == null ? "multipart/related; type=\"text/xml\"; \tboundary=\"" + boundary.substring(2, boundary.length()) + "\" " : "multipart/related; type=\"text/xml\"; start=\"" + IDfirst + "\"; \tboundary=\"" + boundary.substring(2, boundary.length()) + "\" ";
                if (isBodyStream) {
                    int puliziaSpaziBianchi_e_XML;
                    String msg = new String(byteMsg);
                    int firstBound = msg.indexOf(boundary);
                    int secondBound = msg.indexOf(boundary, firstBound + boundary.length());
                    if (firstBound == -1 || secondBound == -1) {
                        throw new Exception("multipart/related non correttamente formato (bound not found)");
                    }
                    String bodyOriginal = msg.substring(firstBound + boundary.length(), secondBound);
                    int indexCarriage = bodyOriginal.indexOf("\r\n\r\n");
                    if (indexCarriage == -1) {
                        throw new Exception("multipart/related non correttamente formato (\\r\\n\\r\\n not found)");
                    }
                    String contenutoBody = bodyOriginal.substring(indexCarriage + "\r\n\r\n".length());
                    for (puliziaSpaziBianchi_e_XML = 0; puliziaSpaziBianchi_e_XML < contenutoBody.length() && contenutoBody.charAt(puliziaSpaziBianchi_e_XML) == ' '; ++puliziaSpaziBianchi_e_XML) {
                    }
                    String bodyPulito = contenutoBody.substring(puliziaSpaziBianchi_e_XML);
                    if (bodyPulito.startsWith("<?xml")) {
                        if (eraserXMLTag) {
                            for (puliziaSpaziBianchi_e_XML = 0; puliziaSpaziBianchi_e_XML < contenutoBody.length() && contenutoBody.charAt(puliziaSpaziBianchi_e_XML) != '>'; ++puliziaSpaziBianchi_e_XML) {
                            }
                            bodyPulito = bodyPulito.substring(puliziaSpaziBianchi_e_XML + 1);
                        } else {
                            throw new Exception("Tag <?xml non permesso con la funzionalita di imbustamento SOAP");
                        }
                    }
                    String contenutoBodyImbustato = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Body>" + bodyPulito + "</soapenv:Body></soapenv:Envelope>\r\n";
                    String bodyOriginalImbustato = bodyOriginal.replace(contenutoBody, contenutoBodyImbustato);
                    msg = msg.replace(bodyOriginal, bodyOriginalImbustato);
                    byteMsg = msg.getBytes();
                    isBodyStream = false;
                }
            } else if (isBodyStream) {
                int i;
                for (i = 0; i < byteMsg.length && (char)byteMsg[i] == ' '; ++i) {
                }
                String xml = "";
                if (byteMsg.length > i + 5 && (xml = "" + (char)byteMsg[i] + (char)byteMsg[i + 1] + (char)byteMsg[i + 2] + (char)byteMsg[i + 3] + (char)byteMsg[i + 4]).equals("<?xml")) {
                    if (eraserXMLTag) {
                        while (i < byteMsg.length && (char)byteMsg[i] != '>') {
                            ++i;
                        }
                        offset = i + 1;
                    } else {
                        throw new Exception("Tag <?xml non permesso con la funzionalita di imbustamento SOAP");
                    }
                }
            }
            ByteArrayInputStream messageInput = new ByteArrayInputStream(byteMsg, offset, byteMsg.length);
            Message message = new Message((Object)messageInput, isBodyStream, contentType, null);
            if (message.countAttachments() == 0) {
                message.getSOAPPartAsBytes();
            }
            try {
                message.getSOAPEnvelope().getAsString();
            }
            catch (Exception e) {
                throw new Exception("Costruzione di un msg soap non riuscita per il pacchetto [" + new String(byteMsg) + "]: " + e.getMessage(), e);
            }
            if (checkEmptyBody && (message.getSOAPBody() == null || !message.getSOAPBody().hasChildNodes())) {
                throw new Exception("Costruzione di un msg soap non riuscita: soap body senza contenuto");
            }
            return message;
        }
        catch (Exception e) {
            throw new UtilsException("Build msg non riuscito: " + e.getMessage(), e);
        }
    }

    public static byte[] msgElementoToByte(MessageElement elem) throws UtilsException {
        try {
            byte[] risultato = SoapUtils.getAsString(elem).getBytes();
            return risultato;
        }
        catch (Exception e) {
            throw new UtilsException("MsgElementToByte non riuscito: " + e.getMessage(), e);
        }
    }

    public static String getAsString(MessageElement me) throws UtilsException {
        return SoapUtils.getAsString(me, false);
    }

    public static String getAsString(MessageElement me, boolean pretty) throws UtilsException {
        try {
            StringWriter writer = new StringWriter();
            if (msgContext == null) {
                SoapUtils.initMessageContext();
            }
            MessageContext msgContext = SoapUtils.msgContext;
            SerializationContext serializeContext = new SerializationContext((Writer)writer, msgContext);
            if (pretty) {
                serializeContext.setPretty(true);
            }
            serializeContext.setSendDecl(false);
            me.setDirty(false);
            me.output(serializeContext);
            writer.close();
            return writer.getBuffer().toString();
        }
        catch (Exception e) {
            throw new UtilsException("Utilities.getAsString, errore: " + e.getMessage(), e);
        }
    }

    public static void saveAxisMessage(String path, Message msg) throws UtilsException {
        FileOutputStream fos = null;
        try {
            File fileMsg = new File(path);
            if (fileMsg.exists()) {
                throw new UtilsException("L'identificativo del Messaggio risulta gia' registrato: " + path);
            }
            fos = new FileOutputStream(path);
            msg.writeTo((OutputStream)fos);
            fos.close();
        }
        catch (Exception e) {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new UtilsException("Utilities.saveAxisMessage error " + e.getMessage(), e);
        }
    }

    public static long getLength(Message msg, boolean permettiUlterioriModifiche) throws Exception {
        if (msg.getSOAPBody() != null) {
            msg.getSOAPBody().hasFault();
        }
        long length = msg.getContentLength();
        if (msg.countAttachments() > 0) {
            if (permettiUlterioriModifiche) {
                org.apache.axis.attachments.AttachmentPart ap = (org.apache.axis.attachments.AttachmentPart)msg.createAttachmentPart();
                ap.setContent((Object)"GESTONE_CONTENT_LENGTH", "text/txt");
                msg.addAttachmentPart((AttachmentPart)ap);
                msg.getAttachmentsImpl().removeAttachmentPart(ap.getContentIdRef());
            }
        } else {
            msg.getSOAPBody();
            String xml = msg.getSOAPEnvelope().getAsString();
            length = xml.length();
            if (!xml.startsWith("<?xml")) {
                StringBuffer bf = new StringBuffer();
                bf.append("<?xml version=\"1.0\" encoding=\"");
                bf.append(((SOAPPart)msg.getSOAPPart()).getEncoding());
                bf.append("\"?>");
                length += (long)bf.length();
            }
        }
        return length;
    }

    public static void bypassMustUnderstandAxisHeaderElement(SOAPHeader header, Properties filtri, boolean isProcessed) throws UtilsException {
        try {
            Iterator it = header.getChildElements();
            block2: while (it.hasNext()) {
                SOAPHeaderElement element = (SOAPHeaderElement)it.next();
                if (element.getActor() != null || !element.getMustUnderstand()) continue;
                Enumeration<Object> en = filtri.keys();
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    if (!key.equals(element.getLocalName()) || !filtri.get(key).equals(element.getNamespaceURI())) continue;
                    element.setProcessed(isProcessed);
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            throw new UtilsException("Utilities.bypassMustUnderstandAxisHeaderElement Riscontrato errore durante l'applicazione del bypassFilter: " + e.getMessage(), e);
        }
    }

    public static void bypassMustUnderstandAxisHeaderElement(SOAPHeader header, boolean isProcessed) throws UtilsException {
        try {
            Iterator it = header.getChildElements();
            while (it.hasNext()) {
                SOAPHeaderElement element = (SOAPHeaderElement)it.next();
                if (element.getActor() != null || !element.getMustUnderstand()) continue;
                element.setProcessed(isProcessed);
            }
        }
        catch (Exception e) {
            throw new UtilsException("Utilities.bypassMustUnderstandAxisHeaderElement Riscontrato errore durante l'applicazione del bypassFilter: " + e.getMessage(), e);
        }
    }
}

