/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.utils;

import java.awt.datatransfer.DataFlavor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;
import org.apache.axis.encoding.Base64;
import org.openspcoop.utils.Loader;
import org.openspcoop.utils.OpenSPCoopDataContentHandlerInputStream;

public class OpenSPCoopDataContentHandler
implements DataContentHandler {
    public static final String OPENSPCOOP_SIGNATURE = "===SIGNATURE=OPENSPCOOP===";

    public static Object getContent(InputStream inputstream) throws IOException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] bRead = new byte[8094];
            int byteLetti = 0;
            while ((byteLetti = inputstream.read(bRead)) != -1) {
                bout.write(bRead, 0, byteLetti);
            }
            bout.flush();
            bout.close();
            if (bout.size() <= OPENSPCOOP_SIGNATURE.length()) {
                throw new Exception("OpenSPCoopDataContentHandler Signature non presente (length is too small)");
            }
            boolean giaCodificato = true;
            String attach = bout.toString();
            for (int i = 0; i < OPENSPCOOP_SIGNATURE.length(); ++i) {
                if (attach.charAt(i) == OPENSPCOOP_SIGNATURE.charAt(i)) continue;
                giaCodificato = false;
                break;
            }
            if (!giaCodificato) {
                throw new Exception("OpenSPCoopDataContentHandler Signature non presente");
            }
            attach = attach.substring(OPENSPCOOP_SIGNATURE.length(), attach.length());
            OpenSPCoopDataContentHandlerInputStream bin = new OpenSPCoopDataContentHandlerInputStream(Base64.decode((String)attach));
            return bin;
        }
        catch (Exception e) {
            throw new IOException("@@@ OpenSPCoopDataContentHandler.getContent() error: " + e.getMessage());
        }
    }

    public Object getContent(DataSource datasource) throws IOException {
        try {
            InputStream inputstream = datasource.getInputStream();
            return OpenSPCoopDataContentHandler.getContent(inputstream);
        }
        catch (Exception e) {
            throw new IOException("@@@ OpenSPCoopDataContentHandler.getContent() error: " + e.getMessage());
        }
    }

    public Object getTransferData(DataFlavor dataflavor, DataSource datasource) throws IOException {
        return null;
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] adataflavor = new DataFlavor[1];
        try {
            adataflavor[0] = new ActivationDataFlavor(Loader.getInstance().forName("org.openspcoop.utils.OpenSPCoopDataContentHandler"), "application/openspcoop", "OpenSPCoopAttachmentsTunnel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return adataflavor;
    }

    public void writeTo(Object obj, String s, OutputStream outputstream) throws IOException {
        try {
            byte[] content = null;
            if (obj instanceof InputStream) {
                InputStream inputstream = (InputStream)obj;
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                byte[] bRead = new byte[8094];
                int byteLetti = 0;
                while ((byteLetti = inputstream.read(bRead)) != -1) {
                    bout.write(bRead, 0, byteLetti);
                }
                bout.flush();
                bout.close();
                content = bout.toByteArray();
            } else {
                content = (byte[])obj;
            }
            boolean giaCodificato = true;
            if (content.length >= OPENSPCOOP_SIGNATURE.length() + 1) {
                for (int i = 0; i < OPENSPCOOP_SIGNATURE.length(); ++i) {
                    if ((char)content[i] == OPENSPCOOP_SIGNATURE.charAt(i)) continue;
                    giaCodificato = false;
                    break;
                }
            }
            if (giaCodificato) {
                outputstream.write(content);
            } else {
                String encoded = OPENSPCOOP_SIGNATURE + Base64.encode((byte[])content);
                outputstream.write(encoded.getBytes());
            }
        }
        catch (Exception exception) {
            throw new IOException("@@@ OpenSPCoopDataContentHandler.writeTo: Unable to run the Binary decoding on a stream " + exception.getMessage());
        }
    }
}

