/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.dao.registry.wsdl;

import com.ibm.wsdl.xml.WSDLReaderImpl;
import com.ibm.wsdl.xml.WSDLWriterImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Types;
import javax.wsdl.extensions.schema.Schema;
import javax.xml.transform.TransformerException;
import org.apache.axis.utils.ByteArrayOutputStream;
import org.openspcoop.dao.registry.wsdl.DefinitionWrapper;
import org.openspcoop.dao.registry.wsdl.WSDLException;
import org.openspcoop.utils.xml.PrettyPrintXMLUtils;
import org.openspcoop.utils.xml.XMLUtils;
import org.openspcoop.utils.xml.XSDUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLUtilities {
    public static WSDLReaderImpl getWSDLReader(boolean verbose, boolean importDocuments) {
        WSDLReaderImpl wsdlReader = new WSDLReaderImpl();
        wsdlReader.setFeature("javax.wsdl.verbose", verbose);
        wsdlReader.setFeature("javax.wsdl.importDocuments", importDocuments);
        return wsdlReader;
    }

    public static boolean isWSDL(byte[] wsdl) throws WSDLException {
        try {
            if (!XMLUtils.isDocument(wsdl)) {
                return false;
            }
            Document docXML = XMLUtils.newDocument(wsdl);
            Element elemXML = docXML.getDocumentElement();
            return WSDLUtilities.isWSDL(elemXML);
        }
        catch (Exception e) {
            throw new WSDLException(e.getMessage(), e);
        }
    }

    public static boolean isWSDL(Document wsdl) throws WSDLException {
        Element elemXML = wsdl.getDocumentElement();
        return WSDLUtilities.isWSDL(elemXML);
    }

    public static boolean isWSDL(Element wsdl) throws WSDLException {
        return WSDLUtilities.isWSDL((Node)wsdl);
    }

    public static boolean isWSDL(Node wsdl) throws WSDLException {
        try {
            if (wsdl == null) {
                throw new Exception("Documento wsdl da verificare non definito");
            }
            if (!"definitions".equals(wsdl.getLocalName())) {
                return false;
            }
            return "http://schemas.xmlsoap.org/wsdl/".equals(wsdl.getNamespaceURI());
        }
        catch (Exception e) {
            throw new WSDLException(e.getMessage(), e);
        }
    }

    public static String getTargetNamespace(byte[] xsd) throws WSDLException {
        try {
            if (!XMLUtils.isDocument(xsd)) {
                throw new Exception("Wsdl non e' un documento valido");
            }
            Document docXML = XMLUtils.newDocument(xsd);
            Element elemXML = docXML.getDocumentElement();
            return WSDLUtilities.getTargetNamespace(elemXML);
        }
        catch (Exception e) {
            throw new WSDLException(e.getMessage(), e);
        }
    }

    public static String getTargetNamespace(Document xsd) throws WSDLException {
        Element elemXML = xsd.getDocumentElement();
        return WSDLUtilities.getTargetNamespace(elemXML);
    }

    public static String getTargetNamespace(Element elemXML) throws WSDLException {
        return WSDLUtilities.getTargetNamespace((Node)elemXML);
    }

    public static String getTargetNamespace(Node elemXML) throws WSDLException {
        try {
            if (elemXML == null) {
                throw new Exception("Wsdl non e' un documento valido");
            }
            if (!"definitions".equals(elemXML.getLocalName())) {
                throw new Exception("Root element non e' un definition wsdl (" + elemXML.getLocalName() + ")");
            }
            String targetNamespace = XMLUtils.getAttributeValue(elemXML, "targetNamespace");
            return targetNamespace;
        }
        catch (Exception e) {
            throw new WSDLException(e.getMessage(), e);
        }
    }

    public static String getTargetNamespace(Schema schema) {
        NamedNodeMap attributi = schema.getElement().getAttributes();
        if (attributi != null) {
            for (int i = 0; i < attributi.getLength(); ++i) {
                Node a = attributi.item(i);
                if (!"targetNamespace".equals(a.getLocalName())) continue;
                return a.getNodeValue();
            }
        }
        return null;
    }

    public static String getImportNamespace(Node elemXML) throws WSDLException {
        try {
            if (elemXML == null) {
                throw new Exception("Non e' un import valido");
            }
            if (!"import".equals(elemXML.getLocalName())) {
                throw new Exception("Root element non e' un import wsdl (" + elemXML.getLocalName() + ")");
            }
            String targetNamespace = XMLUtils.getAttributeValue(elemXML, "namespace");
            return targetNamespace;
        }
        catch (Exception e) {
            throw new WSDLException(e.getMessage(), e);
        }
    }

    public static String getImportLocation(Node elemXML) throws WSDLException {
        try {
            if (elemXML == null) {
                throw new Exception("Non e' un import valido");
            }
            if (!"import".equals(elemXML.getLocalName())) {
                throw new Exception("Root element non e' un import wsdl (" + elemXML.getLocalName() + ")");
            }
            String targetNamespace = XMLUtils.getAttributeValue(elemXML, "location");
            return targetNamespace;
        }
        catch (Exception e) {
            throw new WSDLException(e.getMessage(), e);
        }
    }

    public static void writeWsdlTo(Definition wsdl, String absoluteFilename) throws javax.wsdl.WSDLException, IOException, WSDLException {
        WSDLUtilities.writeWsdlTo(wsdl, absoluteFilename, false);
    }

    public static void writeWsdlTo(Definition wsdl, String absoluteFilename, boolean prettyPrint) throws javax.wsdl.WSDLException, IOException, WSDLException {
        if (wsdl == null) {
            return;
        }
        WSDLWriterImpl writer = new WSDLWriterImpl();
        if (prettyPrint) {
            WSDLUtilities.writeWsdlTo(wsdl, new File(absoluteFilename), prettyPrint);
        } else {
            writer.writeWSDL(wsdl, (Writer)new FileWriter(absoluteFilename));
        }
    }

    public static void writeWsdlTo(Definition wsdl, File file) throws javax.wsdl.WSDLException, IOException, WSDLException {
        WSDLUtilities.writeWsdlTo(wsdl, file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeWsdlTo(Definition wsdl, File file, boolean prettyPrint) throws javax.wsdl.WSDLException, IOException, WSDLException {
        block11: {
            WSDLWriterImpl writer;
            block10: {
                if (wsdl == null) {
                    return;
                }
                writer = new WSDLWriterImpl();
                if (!prettyPrint) break block10;
                FileOutputStream fout = null;
                try {
                    fout = new FileOutputStream(file);
                    WSDLUtilities.writeWsdlTo(wsdl, fout, prettyPrint);
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    try {
                        fout.flush();
                    }
                    catch (Exception eClose) {
                        // empty catch block
                    }
                    try {
                        fout.close();
                    }
                    catch (Exception eClose) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    fout.flush();
                }
                catch (Exception eClose) {
                    // empty catch block
                }
                try {
                    fout.close();
                }
                catch (Exception eClose) {}
                break block11;
            }
            writer.writeWSDL(wsdl, (Writer)new FileWriter(file));
        }
    }

    public static void writeWsdlTo(Definition wsdl, OutputStream out) throws javax.wsdl.WSDLException, IOException, WSDLException {
        WSDLUtilities.writeWsdlTo(wsdl, out, false);
    }

    public static void writeWsdlTo(Definition wsdl, OutputStream out, boolean prettyPrint) throws javax.wsdl.WSDLException, IOException, WSDLException {
        if (wsdl == null) {
            return;
        }
        WSDLWriterImpl writer = new WSDLWriterImpl();
        if (prettyPrint) {
            out.write(WSDLUtilities.prettyPrintWsdl(wsdl).getBytes());
        } else {
            writer.writeWSDL(wsdl, out);
        }
    }

    public static void writeWsdlTo(Definition wsdl, Writer writer) throws javax.wsdl.WSDLException, IOException, WSDLException {
        WSDLUtilities.writeWsdlTo(wsdl, writer, false);
    }

    public static void writeWsdlTo(Definition wsdl, Writer writer, boolean prettyPrint) throws javax.wsdl.WSDLException, IOException, WSDLException {
        if (wsdl == null) {
            return;
        }
        WSDLWriterImpl writerWsdl = new WSDLWriterImpl();
        if (prettyPrint) {
            writer.append(WSDLUtilities.prettyPrintWsdl(wsdl));
        } else {
            writerWsdl.writeWSDL(wsdl, writer);
        }
    }

    private static String prettyPrintWsdl(Definition wsdl) throws javax.wsdl.WSDLException, IOException, WSDLException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            WSDLUtilities.writeWsdlTo(wsdl, (OutputStream)bout, false);
            bout.flush();
            bout.close();
            Document wsdlDocument = XMLUtils.newDocument(bout.toByteArray());
            return PrettyPrintXMLUtils.prettyPrintWithTrAX(wsdlDocument);
        }
        catch (Exception e) {
            throw new WSDLException(e.getMessage(), e);
        }
    }

    public static Definition readWSDLFromFile(File file) throws javax.wsdl.WSDLException {
        return WSDLUtilities.readWSDLFromFile(file, false, true);
    }

    public static Definition readWSDLFromFile(File file, boolean verbose, boolean importsDocument) throws javax.wsdl.WSDLException {
        try {
            if (file == null) {
                throw new Exception("Path non definito");
            }
            WSDLReaderImpl reader = WSDLUtilities.getWSDLReader(verbose, importsDocument);
            Definition def = reader.readWSDL(file.getAbsolutePath());
            return def;
        }
        catch (Exception e) {
            throw new javax.wsdl.WSDLException("WSDLDefinitorio.readWSDLFromLocation(String path)", "Lettura del wsdl non riuscita: " + e.getMessage());
        }
    }

    public static Definition readWSDLFromLocation(String path) throws javax.wsdl.WSDLException {
        return WSDLUtilities.readWSDLFromLocation(path, false, true);
    }

    public static Definition readWSDLFromLocation(String path, boolean verbose, boolean importsDocument) throws javax.wsdl.WSDLException {
        try {
            if (path == null) {
                throw new Exception("Path non definito");
            }
            WSDLReaderImpl reader = WSDLUtilities.getWSDLReader(verbose, importsDocument);
            Definition def = reader.readWSDL(path);
            return def;
        }
        catch (Exception e) {
            throw new javax.wsdl.WSDLException("WSDLDefinitorio.readWSDLFromLocation(String path)", "Lettura del wsdl non riuscita: " + e.getMessage());
        }
    }

    public static Definition readWSDLFromLocation(byte[] wsdl) throws javax.wsdl.WSDLException {
        return WSDLUtilities.readWSDLFromBytes(wsdl, false, true);
    }

    public static Definition readWSDLFromBytes(byte[] wsdl, boolean verbose, boolean importsDocument) throws javax.wsdl.WSDLException {
        try {
            if (wsdl == null) {
                throw new Exception("Bytes non definiti");
            }
            WSDLReaderImpl reader = WSDLUtilities.getWSDLReader(verbose, importsDocument);
            Document document = XMLUtils.newDocument(wsdl);
            Definition def = reader.readWSDL(null, document);
            return def;
        }
        catch (Exception e) {
            throw new javax.wsdl.WSDLException("WSDLDefinitorio.readWSDLFromBytes(byte[] wsdl)", "Lettura del wsdl non riuscita: " + e.getMessage());
        }
    }

    public static Definition readWSDLFromDocument(Document doc) throws javax.wsdl.WSDLException {
        return WSDLUtilities.readWSDLFromDocument(doc, false, true);
    }

    public static Definition readWSDLFromDocument(Document doc, boolean verbose, boolean importsDocument) throws javax.wsdl.WSDLException {
        try {
            if (doc == null) {
                throw new Exception("Document non definito");
            }
            WSDLReaderImpl reader = WSDLUtilities.getWSDLReader(verbose, importsDocument);
            Definition def = reader.readWSDL(null, doc);
            return def;
        }
        catch (Exception e) {
            throw new javax.wsdl.WSDLException("WSDLDefinitorio.readWSDLFromDocument(Document doc)", "Lettura del wsdl non riuscita: " + e.getMessage());
        }
    }

    public static Definition readWSDLFromElement(Element elem) throws javax.wsdl.WSDLException {
        return WSDLUtilities.readWSDLFromElement(elem, false, true);
    }

    public static Definition readWSDLFromElement(Element elem, boolean verbose, boolean importsDocument) throws javax.wsdl.WSDLException {
        try {
            if (elem == null) {
                throw new Exception("Element non definito");
            }
            WSDLReaderImpl reader = WSDLUtilities.getWSDLReader(verbose, importsDocument);
            String param = null;
            Definition def = reader.readWSDL(param, elem);
            return def;
        }
        catch (Exception e) {
            throw new javax.wsdl.WSDLException("WSDLDefinitorio.readWSDLFromElement(Element elem)", "Lettura del wsdl non riuscita: " + e.getMessage());
        }
    }

    public static Definition readWSDLFromURI(URI uri) throws javax.wsdl.WSDLException {
        return WSDLUtilities.readWSDLFromURI(uri, false, true);
    }

    public static Definition readWSDLFromURI(URI uri, boolean verbose, boolean importsDocument) throws javax.wsdl.WSDLException {
        try {
            if (uri == null) {
                throw new Exception("URI non definita");
            }
            WSDLReaderImpl reader = WSDLUtilities.getWSDLReader(verbose, importsDocument);
            Definition def = reader.readWSDL(null, uri.getPath());
            return def;
        }
        catch (Exception e) {
            throw new javax.wsdl.WSDLException("WSDLDefinitorio.readWSDLFromURI(URI uri)", "Lettura del wsdl non riuscita: " + e.getMessage());
        }
    }

    public static Node getIfExistsDefinitionsElementIntoWSDL(Document wsdl) throws WSDLException {
        try {
            NodeList list = wsdl.getChildNodes();
            if (list != null) {
                for (int i = 0; i < list.getLength(); ++i) {
                    Node child = list.item(i);
                    if (!"definitions".equals(child.getLocalName())) continue;
                    return child;
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new WSDLException("Riscontrato errore durante la lettura del wsdl: " + e.getMessage(), e);
        }
    }

    public static Node getIfExistsTypesElementIntoWSDL(Document wsdl) throws WSDLException {
        try {
            NodeList list = wsdl.getChildNodes();
            if (list != null) {
                for (int i = 0; i < list.getLength(); ++i) {
                    NodeList listDefinition;
                    Node child = list.item(i);
                    if (!"definitions".equals(child.getLocalName()) || (listDefinition = child.getChildNodes()) == null) continue;
                    for (int j = 0; j < listDefinition.getLength(); ++j) {
                        Node childDefinition = listDefinition.item(j);
                        if (!"types".equals(childDefinition.getLocalName())) continue;
                        return childDefinition;
                    }
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new WSDLException("Riscontrato errore durante la lettura del wsdl: " + e.getMessage(), e);
        }
    }

    public static List<Node> readImports(Document wsdl) throws WSDLException {
        try {
            Vector<Node> imports = new Vector<Node>();
            NodeList list = wsdl.getChildNodes();
            if (list != null) {
                for (int i = 0; i < list.getLength(); ++i) {
                    NodeList listDefinition;
                    Node child = list.item(i);
                    if (!"definitions".equals(child.getLocalName()) || (listDefinition = child.getChildNodes()) == null) continue;
                    for (int j = 0; j < listDefinition.getLength(); ++j) {
                        Node childDefinition = listDefinition.item(j);
                        if (!"import".equals(childDefinition.getLocalName())) continue;
                        imports.add(childDefinition);
                    }
                }
            }
            return imports;
        }
        catch (Exception e) {
            throw new WSDLException("Riscontrato errore durante la lettura del wsdl: " + e.getMessage(), e);
        }
    }

    public static List<Node> readImportsAndIncludesSchemaIntoTypes(Document wsdl) throws WSDLException {
        return WSDLUtilities.readImportsIncludesSchemaIntoTypes(wsdl, true, true);
    }

    public static List<Node> readImportsSchemaIntoTypes(Document wsdl) throws WSDLException {
        return WSDLUtilities.readImportsIncludesSchemaIntoTypes(wsdl, true, false);
    }

    public static List<Node> readIncludesSchemaIntoTypes(Document wsdl) throws WSDLException {
        return WSDLUtilities.readImportsIncludesSchemaIntoTypes(wsdl, false, true);
    }

    private static List<Node> readImportsIncludesSchemaIntoTypes(Document wsdl, boolean readImport, boolean readInclude) throws WSDLException {
        try {
            Vector<Node> imports = new Vector<Node>();
            NodeList list = wsdl.getChildNodes();
            if (list != null) {
                for (int i = 0; i < list.getLength(); ++i) {
                    NodeList listDefinition;
                    Node child = list.item(i);
                    if (!"definitions".equals(child.getLocalName()) || (listDefinition = child.getChildNodes()) == null) continue;
                    for (int j = 0; j < listDefinition.getLength(); ++j) {
                        NodeList listTypes;
                        Node childDefinition = listDefinition.item(j);
                        if (!"types".equals(childDefinition.getLocalName()) || (listTypes = childDefinition.getChildNodes()) == null) continue;
                        for (int h = 0; h < listTypes.getLength(); ++h) {
                            List<Node> includesSchemi;
                            List<Node> importsSchemi;
                            Node childTypes = listTypes.item(h);
                            if (!"schema".equals(childTypes.getLocalName())) continue;
                            String targetNamespaceSchema = null;
                            if (targetNamespaceSchema == null) {
                                try {
                                    targetNamespaceSchema = XSDUtils.getTargetNamespace(childTypes);
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                            if (readImport && (importsSchemi = XSDUtils.readImports(targetNamespaceSchema, childTypes)) != null && importsSchemi.size() > 0) {
                                imports.addAll(importsSchemi);
                            }
                            if (!readInclude || (includesSchemi = XSDUtils.readIncludes(targetNamespaceSchema, childTypes)) == null || includesSchemi.size() <= 0) continue;
                            imports.addAll(includesSchemi);
                        }
                    }
                }
            }
            return imports;
        }
        catch (Exception e) {
            throw new WSDLException("Riscontrato errore durante la lettura del wsdl: " + e.getMessage(), e);
        }
    }

    public static List<Node> readImportsAndIncludesFromSchemaXSD(Schema xsd) throws WSDLException {
        try {
            return XSDUtils.readImportsAndIncludes(WSDLUtilities.getTargetNamespace(xsd), xsd.getElement());
        }
        catch (Exception e) {
            throw new WSDLException(e.getMessage(), e);
        }
    }

    public static List<Node> readImportsFromSchemaXSD(Schema xsd) throws WSDLException {
        try {
            return XSDUtils.readImports(WSDLUtilities.getTargetNamespace(xsd), xsd.getElement());
        }
        catch (Exception e) {
            throw new WSDLException(e.getMessage(), e);
        }
    }

    public static List<Node> readIncludesFromSchemaXSD(Schema xsd) throws WSDLException {
        try {
            return XSDUtils.readIncludes(WSDLUtilities.getTargetNamespace(xsd), xsd.getElement());
        }
        catch (Exception e) {
            throw new WSDLException(e.getMessage(), e);
        }
    }

    public static Vector<byte[]> getSchemiXSD(Definition wsdlNormalizzato) throws IOException, TransformerException {
        Vector<byte[]> v = new Vector<byte[]>();
        Types types = wsdlNormalizzato.getTypes();
        List xsdTypes = types.getExtensibilityElements();
        for (int i = 0; i < xsdTypes.size(); ++i) {
            Schema schema = (Schema)xsdTypes.get(i);
            v.add(XMLUtils.toByteArray(schema.getElement()));
        }
        return v;
    }

    public static String normalizzazioneSchemaPerInserimentoInWsdl(Element schemaXSD, Element wsdl, HashMap<String, String> prefixForWSDL, boolean docImportato, String targetNamespaceParent) throws WSDLException {
        String targetNamespace = null;
        if (docImportato) {
            targetNamespace = WSDLUtilities.readPrefixForWsdl(schemaXSD, wsdl, prefixForWSDL, true);
            NamedNodeMap attributi = schemaXSD.getAttributes();
            Vector<Attr> attributiDaMantenere = new Vector<Attr>();
            while (attributi.getLength() > 0) {
                Attr attr = (Attr)attributi.item(0);
                if (targetNamespace.equals(attr.getNodeValue())) {
                    attributiDaMantenere.add(attr);
                }
                schemaXSD.removeAttributeNode(attr);
            }
            while (attributiDaMantenere.size() > 0) {
                schemaXSD.setAttributeNode((Attr)attributiDaMantenere.remove(0));
            }
        } else {
            targetNamespace = targetNamespaceParent;
            NamedNodeMap attributi = schemaXSD.getAttributes();
            while (attributi.getLength() > 0) {
                Attr attr = (Attr)attributi.item(0);
                schemaXSD.removeAttributeNode(attr);
            }
            schemaXSD.setAttribute("targetNamespace", targetNamespace);
        }
        return targetNamespace;
    }

    public static String readPrefixForWsdl(Element schemaXSD, Element wsdl, HashMap<String, String> prefixForWSDL, boolean targetNamespaceObbligatorio) throws WSDLException {
        String targetNamespace = null;
        NamedNodeMap attributi = schemaXSD.getAttributes();
        if (attributi != null) {
            NamedNodeMap attributi_wsdl;
            for (int i = 0; i < attributi.getLength(); ++i) {
                Node attr = attributi.item(i);
                if (!"targetNamespace".equals(attr.getLocalName())) continue;
                targetNamespace = attr.getNodeValue();
                break;
            }
            if (targetNamespace == null) {
                if (targetNamespaceObbligatorio) {
                    throw new WSDLException("Target namespace non trovato");
                }
                return null;
            }
            String prefixTargetNamespaceXSD = null;
            for (int i = 0; i < attributi.getLength(); ++i) {
                Node attr = attributi.item(i);
                if (!targetNamespace.equals(attr.getNodeValue()) || !"xmlns".equals(attr.getPrefix())) continue;
                prefixTargetNamespaceXSD = attr.getLocalName();
                break;
            }
            if ((attributi_wsdl = wsdl.getAttributes()) != null) {
                boolean findIntoWSDL = false;
                for (int i = 0; i < attributi_wsdl.getLength(); ++i) {
                    Node attr = attributi_wsdl.item(i);
                    if (!targetNamespace.equals(attr.getNodeValue()) || !"xmlns".equals(attr.getPrefix())) continue;
                    if (prefixTargetNamespaceXSD == null) {
                        findIntoWSDL = attr.getLocalName() == null;
                        break;
                    }
                    if (!prefixTargetNamespaceXSD.equals(attr.getLocalName())) continue;
                    findIntoWSDL = true;
                    break;
                }
                if (!findIntoWSDL) {
                    if (prefixTargetNamespaceXSD == null) {
                        prefixForWSDL.put("xmlns", targetNamespace);
                    } else {
                        prefixForWSDL.put("xmlns:" + prefixTargetNamespaceXSD, targetNamespace);
                    }
                }
            }
        }
        return targetNamespace;
    }

    public static void removeImports(Document document) {
        WSDLUtilities.removeImport(document, null);
    }

    public static void removeImport(Document document, Node importNode) {
        NodeList list = document.getChildNodes();
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                NodeList listDefinition;
                Node child = list.item(i);
                if (!"definitions".equals(child.getLocalName()) || (listDefinition = child.getChildNodes()) == null) continue;
                for (int j = 0; j < listDefinition.getLength(); ++j) {
                    Node childDefinition = listDefinition.item(j);
                    if (!"import".equals(childDefinition.getLocalName())) continue;
                    if (importNode == null) {
                        child.removeChild(childDefinition);
                        continue;
                    }
                    if (!importNode.equals(childDefinition)) continue;
                    child.removeChild(childDefinition);
                }
            }
        }
    }

    public static void removeSchemiIntoTypes(Document document) throws WSDLException {
        try {
            NodeList list = document.getChildNodes();
            if (list != null) {
                for (int i = 0; i < list.getLength(); ++i) {
                    NodeList listDefinition;
                    Node child = list.item(i);
                    if (!"definitions".equals(child.getLocalName()) || (listDefinition = child.getChildNodes()) == null) continue;
                    for (int j = 0; j < listDefinition.getLength(); ++j) {
                        NodeList listTypes;
                        Node childDefinition = listDefinition.item(j);
                        if (!"types".equals(childDefinition.getLocalName()) || (listTypes = childDefinition.getChildNodes()) == null) continue;
                        for (int h = 0; h < listTypes.getLength(); ++h) {
                            Node childTypes = listTypes.item(h);
                            if (!"schema".equals(childTypes.getLocalName())) continue;
                            childDefinition.removeChild(childTypes);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new WSDLException("Riscontrato errore durante la lettura del wsdl: " + e.getMessage(), e);
        }
    }

    public static void removeTypes(Document wsdl) throws WSDLException {
        try {
            NodeList list = wsdl.getChildNodes();
            if (list != null) {
                for (int i = 0; i < list.getLength(); ++i) {
                    NodeList listDefinition;
                    Node child = list.item(i);
                    if (!"definitions".equals(child.getLocalName()) || (listDefinition = child.getChildNodes()) == null) continue;
                    for (int j = 0; j < listDefinition.getLength(); ++j) {
                        Node childDefinition = listDefinition.item(j);
                        if (!"types".equals(childDefinition.getLocalName())) continue;
                        child.removeChild(childDefinition);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new WSDLException("Riscontrato errore durante la rimozione dell'elemento Types: " + e.getMessage(), e);
        }
    }

    public static void removeImportsFromSchemaXSD(Schema xsd) {
        XSDUtils.removeImports(xsd.getElement());
    }

    public static void removeIncludesFromSchemaXSD(Schema xsd) {
        XSDUtils.removeIncludes(xsd.getElement());
    }

    public static void removeImportsAndIncludesFromSchemaXSD(Schema xsd) {
        XSDUtils.removeImportsAndIncludes(xsd.getElement());
    }

    public static void removeAllImports(Definition definition) throws javax.wsdl.WSDLException {
        if (definition == null) {
            throw new javax.wsdl.WSDLException("removeAllImports(Definition definition)", "WSDL non fornito");
        }
        DefinitionWrapper wsdl = new DefinitionWrapper(definition);
        wsdl.removeAllImports();
    }

    public static void removeAllMessages(Definition definition) throws javax.wsdl.WSDLException {
        if (definition == null) {
            throw new javax.wsdl.WSDLException("removeAllMessages(Definition definition)", "WSDL non fornito");
        }
        DefinitionWrapper wsdl = new DefinitionWrapper(definition);
        wsdl.removeAllMessages();
    }

    public static void removeAllPortTypes(Definition definition) throws javax.wsdl.WSDLException {
        if (definition == null) {
            throw new javax.wsdl.WSDLException("removeAllPortTypes(Definition definition)", "WSDL non fornito");
        }
        DefinitionWrapper wsdl = new DefinitionWrapper(definition);
        wsdl.removeAllPortTypes();
    }

    public static void removeAllBindings(Definition definition) throws javax.wsdl.WSDLException {
        if (definition == null) {
            throw new javax.wsdl.WSDLException("removeAllBindings(Definition definition)", "WSDL non fornito");
        }
        DefinitionWrapper wsdl = new DefinitionWrapper(definition);
        wsdl.removeAllBindings();
    }

    public static void removeAllServices(Definition definition) throws javax.wsdl.WSDLException {
        if (definition == null) {
            throw new javax.wsdl.WSDLException("removeAllServices(Definition definition)", "WSDL non fornito");
        }
        DefinitionWrapper wsdl = new DefinitionWrapper(definition);
        wsdl.removeAllServices();
    }
}

