/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.dao.registry.wsdl;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.wsdl.WSDLException;
import org.openspcoop.dao.registry.wsdl.DefinitionWrapper;
import org.openspcoop.dao.registry.wsdl.SPCoopWSDL;
import org.openspcoop.dao.registry.wsdl.SchemaXSDAccordoServizio;
import org.openspcoop.dao.registry.wsdl.StandardWSDL;
import org.openspcoop.dao.registry.wsdl.StandardWSDLOutputMode;
import org.openspcoop.dao.registry.wsdl.TipoSchemaXSDAccordoServizio;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDL2SPCoop {
    File outputDir = null;
    boolean prettyPrint = false;
    public List<SchemaXSDAccordoServizio> schemiErogatore;
    public List<SchemaXSDAccordoServizio> schemiFruitore;
    public DefinitionWrapper wsdlErogatore;
    public DefinitionWrapper wsdlFruitore;
    public DefinitionWrapper wsdlConcettuale;
    public DefinitionWrapper wsdlLogicoErogatore;
    public DefinitionWrapper wsdlLogicoFruitore;
    public DefinitionWrapper wsdlImplementativoErogatore;
    public DefinitionWrapper wsdlImplementativoFruitore;
    private boolean debug = false;

    public WSDL2SPCoop(File outputDir) throws WSDLException {
        this(outputDir, false);
    }

    public WSDL2SPCoop(File outputDir, boolean prettyPrint) throws WSDLException {
        this(outputDir.getAbsolutePath(), prettyPrint);
    }

    public WSDL2SPCoop(String outputDir) throws WSDLException {
        this(outputDir, false);
    }

    public WSDL2SPCoop(String outputDir, boolean prettyPrint) throws WSDLException {
        try {
            this.prettyPrint = prettyPrint;
            this.outputDir = new File(outputDir);
            if (this.outputDir.exists()) {
                if (!this.outputDir.isDirectory()) {
                    throw new Exception("Path indicato [" + outputDir + "] esiste e non \u00e8 una directory");
                }
            } else if (!this.outputDir.mkdir()) {
                throw new Exception("Path indicato [" + outputDir + "] non esiste e non \u00e8 possibile crearlo come directory");
            }
        }
        catch (Exception e) {
            throw new WSDLException("WSDL2SPCoopUtility(String tmpDir)", "Errore durante l'inizializzazione della directory: " + e.getMessage(), (Throwable)e);
        }
    }

    public WSDL2SPCoop() throws WSDLException {
    }

    public List<SchemaXSDAccordoServizio> getSchemiErogatore() {
        return this.schemiErogatore;
    }

    public List<SchemaXSDAccordoServizio> getSchemiFruitore() {
        return this.schemiFruitore;
    }

    public DefinitionWrapper getWsdlErogatore() {
        return this.wsdlErogatore;
    }

    public DefinitionWrapper getWsdlFruitore() {
        return this.wsdlFruitore;
    }

    public void buildWSDLStandard(String pathWsdlImplementativoErogatore, StandardWSDLOutputMode outputMode) throws WSDLException {
        this.buildWSDLStandard(pathWsdlImplementativoErogatore, null, outputMode, false);
    }

    public void buildWSDLStandard(String pathWsdlImplementativoErogatore, String pathWsdlImplementativoFruitore, StandardWSDLOutputMode outputMode, boolean unicoWSDLDestinazione) throws WSDLException {
        try {
            StandardWSDL standardWSDL = new StandardWSDL(pathWsdlImplementativoErogatore, pathWsdlImplementativoFruitore, outputMode);
            if (unicoWSDLDestinazione) {
                this.wsdlErogatore = standardWSDL.getWsdlUnificato();
                this.schemiErogatore = standardWSDL.getSchemiWsdlUnificato();
                if (this.outputDir != null) {
                    standardWSDL.writeWsdlUnificatoTo(this.outputDir, this.prettyPrint);
                }
            } else {
                this.wsdlErogatore = standardWSDL.getWsdlErogatore();
                this.schemiErogatore = standardWSDL.getSchemiWsdlErogatore();
                if (this.outputDir != null) {
                    standardWSDL.writeWsdlErogatoreTo(this.outputDir, this.prettyPrint);
                }
                if (pathWsdlImplementativoFruitore != null) {
                    this.wsdlFruitore = standardWSDL.getWsdlFruitore();
                    this.schemiFruitore = standardWSDL.getSchemiWsdlFruitore();
                    if (this.outputDir != null) {
                        standardWSDL.writeWsdlFruitoreTo(this.outputDir, this.prettyPrint);
                    }
                }
            }
        }
        catch (Exception e) {
            if (this.debug) {
                e.printStackTrace();
            }
            throw new WSDLException("WSDL2SPCoopUtility(String pathWsdlImplementativoErogatore,WSDL pathWsdlImplementativoFruitore)", "Costruzione non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    public void buildWSDLStandard(SchemaXSDAccordoServizio definitorio, byte[] byteWsdlLogicoErogatore, byte[] byteWsdlImplementativoErogatore, StandardWSDLOutputMode outputMode) throws WSDLException {
        this.buildWSDLStandard(definitorio, byteWsdlLogicoErogatore, byteWsdlImplementativoErogatore, null, null, false, outputMode);
    }

    public void buildWSDLStandard(List<SchemaXSDAccordoServizio> schemi, byte[] byteWsdlLogicoErogatore, byte[] byteWsdlImplementativoErogatore, StandardWSDLOutputMode outputMode) throws WSDLException {
        this.buildWSDLStandard(schemi, byteWsdlLogicoErogatore, byteWsdlImplementativoErogatore, null, null, false, outputMode);
    }

    public void buildWSDLStandard(SchemaXSDAccordoServizio definitorio, byte[] byteWsdlLogicoErogatore, byte[] byteWsdlImplementativoErogatore, byte[] byteWsdlLogicoFruitore, byte[] byteWsdlImplementativoFruitore, boolean unicoWSDLDestinazione, StandardWSDLOutputMode outputMode) throws WSDLException {
        ArrayList<SchemaXSDAccordoServizio> schemi = new ArrayList<SchemaXSDAccordoServizio>();
        schemi.add(definitorio);
        this.buildWSDLStandard(schemi, byteWsdlImplementativoErogatore, byteWsdlLogicoErogatore, byteWsdlImplementativoFruitore, byteWsdlLogicoFruitore, unicoWSDLDestinazione, outputMode);
    }

    public void buildWSDLStandard(List<SchemaXSDAccordoServizio> schemi, byte[] byteWsdlLogicoErogatore, byte[] byteWsdlImplementativoErogatore, byte[] byteWsdlLogicoFruitore, byte[] byteWsdlImplementativoFruitore, boolean unicoWSDLDestinazione, StandardWSDLOutputMode outputMode) throws WSDLException {
        try {
            StandardWSDL standardWSDL = new StandardWSDL(schemi, byteWsdlLogicoErogatore, byteWsdlImplementativoErogatore, byteWsdlLogicoFruitore, byteWsdlImplementativoFruitore, outputMode);
            if (unicoWSDLDestinazione) {
                this.wsdlErogatore = standardWSDL.getWsdlUnificato();
                this.schemiErogatore = standardWSDL.getSchemiWsdlUnificato();
                if (this.outputDir != null) {
                    standardWSDL.writeWsdlUnificatoTo(this.outputDir, this.prettyPrint);
                }
            } else {
                this.wsdlErogatore = standardWSDL.getWsdlErogatore();
                this.schemiErogatore = standardWSDL.getSchemiWsdlErogatore();
                if (this.outputDir != null) {
                    standardWSDL.writeWsdlErogatoreTo(this.outputDir, this.prettyPrint);
                }
                if (byteWsdlImplementativoFruitore != null) {
                    this.wsdlFruitore = standardWSDL.getWsdlFruitore();
                    this.schemiFruitore = standardWSDL.getSchemiWsdlFruitore();
                    if (this.outputDir != null) {
                        standardWSDL.writeWsdlFruitoreTo(this.outputDir, this.prettyPrint);
                    }
                }
            }
        }
        catch (Exception e) {
            if (this.debug) {
                e.printStackTrace();
            }
            throw new WSDLException("WSDL2SPCoopUtility(Byte)", "Costruzione non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    public DefinitionWrapper getWsdlConcettuale() {
        return this.wsdlConcettuale;
    }

    public DefinitionWrapper getWsdlLogicoErogatore() {
        return this.wsdlLogicoErogatore;
    }

    public DefinitionWrapper getWsdlLogicoFruitore() {
        return this.wsdlLogicoFruitore;
    }

    public DefinitionWrapper getWsdlImplementativoErogatore() {
        return this.wsdlImplementativoErogatore;
    }

    public DefinitionWrapper getWsdlImplementativoFruitore() {
        return this.wsdlImplementativoFruitore;
    }

    public void splitIntoWSDLSPCoop(String wsdlErogatore) throws WSDLException {
        String fruitore = null;
        this.splitIntoWSDLSPCoop(wsdlErogatore, fruitore);
    }

    public void splitIntoWSDLSPCoop(String wsdlErogatore, String wsdlFruitore) throws WSDLException {
        this.splitIntoWSDLSPCoop(wsdlErogatore, wsdlFruitore, TipoSchemaXSDAccordoServizio.ALLEGATO);
    }

    public void splitIntoWSDLSPCoop(String wsdlErogatore, TipoSchemaXSDAccordoServizio tipoSchema) throws WSDLException {
        String fruitore = null;
        this.splitIntoWSDLSPCoop(wsdlErogatore, fruitore, tipoSchema);
    }

    public void splitIntoWSDLSPCoop(String wsdlErogatore, String wsdlFruitore, TipoSchemaXSDAccordoServizio tipoSchema) throws WSDLException {
        this.splitIntoWSDLSPCoop(wsdlErogatore, wsdlFruitore, tipoSchema, false);
    }

    public void splitIntoWSDLSPCoop(String wsdlErogatore, String wsdlFruitore, TipoSchemaXSDAccordoServizio tipoSchema, boolean permettiSchemaLocationNonDefiniti) throws WSDLException {
        try {
            SPCoopWSDL spcoopWSDL = new SPCoopWSDL(wsdlErogatore, wsdlFruitore, tipoSchema, permettiSchemaLocationNonDefiniti);
            this.wsdlConcettuale = spcoopWSDL.getWsdlConcettuale();
            this.wsdlLogicoErogatore = spcoopWSDL.getWsdlLogicoErogatore();
            this.wsdlImplementativoErogatore = spcoopWSDL.getWsdlImplementativoErogatore();
            this.schemiErogatore = spcoopWSDL.getSchemiErogatore();
            if (wsdlFruitore != null) {
                this.wsdlLogicoFruitore = spcoopWSDL.getWsdlLogicoFruitore();
                this.wsdlImplementativoFruitore = spcoopWSDL.getWsdlImplementativoFruitore();
                this.schemiFruitore = spcoopWSDL.getSchemiFruitore();
            }
            if (this.outputDir != null) {
                spcoopWSDL.writeTo(this.outputDir, this.prettyPrint);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (this.debug) {
                e.printStackTrace();
            }
            throw new WSDLException("splitIntoWSDLSPCoop(String)", "Split non riuscito: " + e.getMessage(), (Throwable)e);
        }
    }

    public void splitIntoWSDLSPCoop(String wsdl, String[] porttypesErogatore, String[] operationPorttypesErogatore) throws WSDLException {
        this.splitIntoWSDLSPCoop(wsdl, porttypesErogatore, operationPorttypesErogatore, null, null, TipoSchemaXSDAccordoServizio.ALLEGATO);
    }

    public void splitIntoWSDLSPCoop(String wsdl, String[] porttypesErogatore, String[] operationPorttypesErogatore, TipoSchemaXSDAccordoServizio tipoSchema) throws WSDLException {
        this.splitIntoWSDLSPCoop(wsdl, porttypesErogatore, operationPorttypesErogatore, null, null, tipoSchema);
    }

    public void splitIntoWSDLSPCoop(String wsdl, String[] porttypesErogatore, String[] operationPorttypesErogatore, String[] porttypesFruitore, String[] operationPorttypesFruitore) throws WSDLException {
        this.splitIntoWSDLSPCoop(wsdl, porttypesErogatore, operationPorttypesErogatore, porttypesFruitore, operationPorttypesFruitore, TipoSchemaXSDAccordoServizio.ALLEGATO);
    }

    public void splitIntoWSDLSPCoop(String wsdl, String[] porttypesErogatore, String[] operationPorttypesErogatore, String[] porttypesFruitore, String[] operationPorttypesFruitore, TipoSchemaXSDAccordoServizio tipoSchema) throws WSDLException {
        try {
            SPCoopWSDL spcoopWSDL = null;
            spcoopWSDL = porttypesFruitore == null ? new SPCoopWSDL(wsdl, porttypesErogatore, operationPorttypesErogatore, tipoSchema, true) : new SPCoopWSDL(wsdl, porttypesErogatore, operationPorttypesErogatore, porttypesFruitore, operationPorttypesFruitore, tipoSchema, true);
            this.wsdlConcettuale = spcoopWSDL.getWsdlConcettuale();
            this.wsdlLogicoErogatore = spcoopWSDL.getWsdlLogicoErogatore();
            this.wsdlImplementativoErogatore = spcoopWSDL.getWsdlImplementativoErogatore();
            this.schemiErogatore = spcoopWSDL.getSchemiErogatore();
            if (porttypesFruitore != null) {
                this.wsdlLogicoFruitore = spcoopWSDL.getWsdlLogicoFruitore();
                this.wsdlImplementativoFruitore = spcoopWSDL.getWsdlImplementativoFruitore();
                this.schemiFruitore = spcoopWSDL.getSchemiFruitore();
            }
            if (this.outputDir != null) {
                spcoopWSDL.writeTo(this.outputDir, this.prettyPrint);
            }
        }
        catch (Exception e) {
            if (this.debug) {
                e.printStackTrace();
            }
            throw new WSDLException("splitIntoWSDLSPCoop(String,portTypes...)", "Split non riuscito: " + e.getMessage(), (Throwable)e);
        }
    }

    public void splitIntoWSDLSPCoop(byte[] wsdlErogatore) throws WSDLException {
        byte[] fruitore = null;
        this.splitIntoWSDLSPCoop(wsdlErogatore, fruitore, TipoSchemaXSDAccordoServizio.ALLEGATO);
    }

    public void splitIntoWSDLSPCoop(byte[] wsdlErogatore, TipoSchemaXSDAccordoServizio tipoSchema) throws WSDLException {
        byte[] fruitore = null;
        this.splitIntoWSDLSPCoop(wsdlErogatore, fruitore, tipoSchema);
    }

    public void splitIntoWSDLSPCoop(byte[] wsdlErogatore, byte[] wsdlFruitore) throws WSDLException {
        this.splitIntoWSDLSPCoop(wsdlErogatore, wsdlFruitore, TipoSchemaXSDAccordoServizio.ALLEGATO);
    }

    public void splitIntoWSDLSPCoop(byte[] wsdlErogatore, byte[] wsdlFruitore, TipoSchemaXSDAccordoServizio tipoSchema) throws WSDLException {
        this.splitIntoWSDLSPCoop(wsdlErogatore, wsdlFruitore, tipoSchema, false);
    }

    public void splitIntoWSDLSPCoop(byte[] wsdlErogatore, byte[] wsdlFruitore, TipoSchemaXSDAccordoServizio tipoSchema, boolean permettiSchemaLocationNonDefiniti) throws WSDLException {
        try {
            File wsdlErogatoreTmpFile = File.createTempFile("WSDLErogatoreFromByte-", "-spcoop", this.outputDir);
            if (!wsdlErogatoreTmpFile.exists()) {
                wsdlErogatoreTmpFile.createNewFile();
            }
            FileOutputStream fout = new FileOutputStream(wsdlErogatoreTmpFile);
            fout.write(wsdlErogatore);
            fout.flush();
            fout.close();
            String pathFileErogatore = wsdlErogatoreTmpFile.getAbsolutePath();
            String pathFileFruitore = null;
            File wsdlFruitoreTmpFile = null;
            if (wsdlFruitore != null) {
                wsdlFruitoreTmpFile = File.createTempFile("WSDLFruitoreFromByte-", "-spcoop", this.outputDir);
                if (!wsdlFruitoreTmpFile.exists()) {
                    wsdlFruitoreTmpFile.createNewFile();
                }
                fout = new FileOutputStream(wsdlFruitoreTmpFile);
                fout.write(wsdlFruitore);
                fout.flush();
                fout.close();
                pathFileFruitore = wsdlFruitoreTmpFile.getAbsolutePath();
            }
            this.splitIntoWSDLSPCoop(pathFileErogatore, pathFileFruitore, tipoSchema, permettiSchemaLocationNonDefiniti);
            wsdlErogatoreTmpFile.delete();
            if (wsdlFruitore != null) {
                wsdlFruitoreTmpFile.delete();
            }
        }
        catch (Exception e) {
            if (this.debug) {
                e.printStackTrace();
            }
            throw new WSDLException("splitIntoWSDLSPCoop(Byte)", "Split non riuscito: " + e.getMessage(), (Throwable)e);
        }
    }

    public void splitIntoWSDLSPCoop(byte[] wsdl, String[] porttypesErogatore, String[] operationPorttypesErogatore) throws WSDLException {
        this.splitIntoWSDLSPCoop(wsdl, porttypesErogatore, operationPorttypesErogatore, null, null, TipoSchemaXSDAccordoServizio.ALLEGATO);
    }

    public void splitIntoWSDLSPCoop(byte[] wsdl, String[] porttypesErogatore, String[] operationPorttypesErogatore, TipoSchemaXSDAccordoServizio tipoSchema) throws WSDLException {
        this.splitIntoWSDLSPCoop(wsdl, porttypesErogatore, operationPorttypesErogatore, null, null, tipoSchema);
    }

    public void splitIntoWSDLSPCoop(byte[] wsdl, String[] porttypesErogatore, String[] operationPorttypesErogatore, String[] porttypesFruitore, String[] operationPorttypesFruitore) throws WSDLException {
        this.splitIntoWSDLSPCoop(wsdl, porttypesErogatore, operationPorttypesErogatore, porttypesFruitore, operationPorttypesFruitore, TipoSchemaXSDAccordoServizio.ALLEGATO);
    }

    public void splitIntoWSDLSPCoop(byte[] wsdl, String[] porttypesErogatore, String[] operationPorttypesErogatore, String[] porttypesFruitore, String[] operationPorttypesFruitore, TipoSchemaXSDAccordoServizio tipoSchema) throws WSDLException {
        try {
            File wsdlErogatoreTmpFile = File.createTempFile("WSDLErogatoreFromByte-", "-spcoop", this.outputDir);
            if (!wsdlErogatoreTmpFile.exists()) {
                wsdlErogatoreTmpFile.createNewFile();
            }
            FileOutputStream fout = new FileOutputStream(wsdlErogatoreTmpFile);
            fout.write(wsdl);
            fout.flush();
            fout.close();
            String pathFileErogatore = wsdlErogatoreTmpFile.getAbsolutePath();
            this.splitIntoWSDLSPCoop(pathFileErogatore, porttypesErogatore, operationPorttypesErogatore, porttypesFruitore, operationPorttypesFruitore, tipoSchema);
            wsdlErogatoreTmpFile.delete();
        }
        catch (Exception e) {
            if (this.debug) {
                e.printStackTrace();
            }
            throw new WSDLException("splitIntoWSDLSPCoop(Byte,PortType...)", "Split non riuscito: " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

