/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.dao.registry.wsdl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.openspcoop.utils.FileSystemUtilities;
import org.openspcoop.utils.xml.PrettyPrintXMLUtils;
import org.openspcoop.utils.xml.XMLUtils;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SchemaXSD {
    private Element xml;
    private String filename;
    private File source;

    public SchemaXSD(Element xml, String filename, File source) {
        this.xml = xml;
        this.filename = filename;
        this.source = source;
    }

    public SchemaXSD(byte[] xml, String filename, File source) throws IOException, SAXException, ParserConfigurationException {
        this.xml = XMLUtils.newElement(xml);
        this.filename = filename;
        this.source = source;
    }

    public Element getXml() {
        return this.xml;
    }

    public String getFilename() {
        return this.filename;
    }

    public File getSource() {
        return this.source;
    }

    public String getSourceAbsolutePath() {
        return this.source.getAbsolutePath();
    }

    public boolean compareSource(SchemaXSD definitorio) {
        return this.source.getAbsolutePath().equalsIgnoreCase(definitorio.getSource().getAbsolutePath());
    }

    public boolean compareFilename(SchemaXSD definitorio) {
        return this.filename.equalsIgnoreCase(definitorio.getFilename());
    }

    public void writeTo(File folder) throws ParserConfigurationException, TransformerFactoryConfigurationError, FileNotFoundException, TransformerException, IOException {
        this.writeTo(folder, false);
    }

    public void writeTo(File folder, boolean prettyPrint) throws ParserConfigurationException, TransformerFactoryConfigurationError, FileNotFoundException, TransformerException, IOException {
        if (this.filename == null) {
            throw new FileNotFoundException("File name non impostato");
        }
        File out = new File(folder.getAbsolutePath() + File.separator + this.getFilename());
        try {
            FileSystemUtilities.mkdirParentDirectory(out);
        }
        catch (Exception e) {
            throw new TransformerException(e.getMessage(), e);
        }
        if (prettyPrint) {
            PrettyPrintXMLUtils.prettyPrintWithTrAX(this.xml, out);
        } else {
            XMLUtils.writeTo(this.xml, out);
        }
    }

    public byte[] toByteArray() throws ParserConfigurationException, TransformerFactoryConfigurationError, FileNotFoundException, TransformerException, IOException {
        return this.toByteArray(false);
    }

    public byte[] toByteArray(boolean prettyPrint) throws ParserConfigurationException, TransformerFactoryConfigurationError, FileNotFoundException, TransformerException, IOException {
        if (prettyPrint) {
            return PrettyPrintXMLUtils.prettyPrintWithTrAX(this.xml).getBytes();
        }
        return XMLUtils.toByteArray(this.xml);
    }
}

