/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.dao.registry.wsdl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Part;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPOperation;
import org.apache.log4j.Logger;
import org.openspcoop.dao.registry.AccordoServizio;
import org.openspcoop.dao.registry.Documento;
import org.openspcoop.dao.registry.Message;
import org.openspcoop.dao.registry.MessagePart;
import org.openspcoop.dao.registry.Operation;
import org.openspcoop.dao.registry.PortType;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziException;
import org.openspcoop.dao.registry.wsdl.AccordoServizioWrapper;
import org.openspcoop.dao.registry.wsdl.RegistroOpenSPCoopUtilities;
import org.openspcoop.dao.registry.wsdl.WSDLUtilities;
import org.openspcoop.utils.FileSystemUtilities;
import org.openspcoop.utils.HttpUtilities;
import org.openspcoop.utils.xml.ValidatoreXSD;
import org.openspcoop.utils.xml.XMLException;
import org.openspcoop.utils.xml.XMLUtils;
import org.openspcoop.utils.xml.XSDResourceResolver;
import org.openspcoop.utils.xml.XSDUtils;
import org.w3c.dom.Document;
import org.w3c.dom.ls.LSResourceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccordoServizioWrapperUtilities {
    private Logger logger = null;
    private RegistroOpenSPCoopUtilities openspcoopUtilities = null;
    private AccordoServizioWrapper accordoServizioWrapper = null;

    public AccordoServizioWrapperUtilities(Logger log) {
        this.logger = log != null ? log : Logger.getLogger((String)"AccordoServizioUtilities");
        this.openspcoopUtilities = new RegistroOpenSPCoopUtilities(this.logger);
    }

    public AccordoServizioWrapperUtilities(AccordoServizioWrapper accordoServizio) {
        this.accordoServizioWrapper = accordoServizio;
    }

    public AccordoServizioWrapper getAccordoServizioWrapper() {
        return this.accordoServizioWrapper;
    }

    public void setAccordoServizio(AccordoServizioWrapper accordoServizio) {
        this.accordoServizioWrapper = accordoServizio;
    }

    private void registraMappingNamespaceLocations(byte[] resource, String location, Hashtable<String, String> mappingNamespaceLocations) throws XMLException {
        String targetNamespaceXSD = XSDUtils.getTargetNamespace(resource);
        if (targetNamespaceXSD != null) {
            if (mappingNamespaceLocations.containsKey(targetNamespaceXSD)) {
                String locationGiaAssociataTargetNamespace = mappingNamespaceLocations.remove(targetNamespaceXSD);
                String newValue = locationGiaAssociataTargetNamespace + " " + location;
                mappingNamespaceLocations.put(targetNamespaceXSD, newValue);
            } else {
                mappingNamespaceLocations.put(targetNamespaceXSD, location);
            }
        }
    }

    public void buildSchema(boolean fromBytes) throws DriverRegistroServiziException {
        File f;
        URL url;
        String location;
        String systemId;
        byte[] resource;
        if (this.accordoServizioWrapper == null) {
            throw new DriverRegistroServiziException("Accordo di Servizio Wrapper non definito, utilizza setAccordoServizioWrapper()");
        }
        if (this.accordoServizioWrapper.getAccordoServizio() == null) {
            throw new DriverRegistroServiziException("Accordo di Servizio OpenSPCoop non definito all'interno dell'Accordo di Servizio Wrapper");
        }
        AccordoServizio as = this.accordoServizioWrapper.getAccordoServizio();
        if (as.getWsdlDefinitorio() == null && as.sizeAllegatoList() == 0 && as.sizeSpecificaSemiformaleList() == 0) {
            throw new DriverRegistroServiziException("Accordo di Servizio OpenSPCoop definito all'interno dell'Accordo di Servizio Wrapper, non contiene schemi");
        }
        Hashtable<String, byte[]> resources = new Hashtable<String, byte[]>();
        Hashtable<String, String> mappingNamespaceLocations = new Hashtable<String, String>();
        if (fromBytes && as.getByteWsdlDefinitorio() != null || !fromBytes && as.getWsdlDefinitorio() != null) {
            byte[] resource2 = null;
            String systemId2 = null;
            if (fromBytes) {
                systemId2 = "InterfacciaDefinitoria.xsd";
                resource2 = as.getByteWsdlDefinitorio();
            } else {
                String location2 = as.getWsdlDefinitorio();
                try {
                    if (location2.startsWith("http://") || location2.startsWith("file://")) {
                        URL url2 = new URL(location2);
                        resource2 = HttpUtilities.requestHTTPFile(url2.toString());
                        systemId2 = new File(url2.getFile()).getName();
                    } else {
                        File f2 = new File(location2);
                        resource2 = FileSystemUtilities.readBytesFromFile(f2);
                        systemId2 = f2.getName();
                    }
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("Accordo di Servizio OpenSPCoop definito all'interno dell'Accordo di Servizio Wrapper, indirizza un wsdl definitorio non esistente");
                }
            }
            try {
                if (XSDUtils.isXSDSchema(resource2)) {
                    resources.put(systemId2, resource2);
                    this.registraMappingNamespaceLocations(resource2, systemId2, mappingNamespaceLocations);
                }
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("La lettura del wsdl definitorio ha causato un errore: " + e.getMessage(), e);
            }
        }
        if (as.sizeAllegatoList() > 0) {
            for (int i = 0; i < as.sizeAllegatoList(); ++i) {
                Documento allegato = as.getAllegato(i);
                resource = null;
                systemId = null;
                if (fromBytes) {
                    systemId = allegato.getFile();
                    resource = allegato.getByteContenuto();
                    if (resource == null) {
                        throw new DriverRegistroServiziException("Allegato [" + systemId + "] non contiene i bytes che ne definiscono il contenuto");
                    }
                } else {
                    location = allegato.getFile();
                    try {
                        if (location.startsWith("http://") || location.startsWith("file://")) {
                            url = new URL(location);
                            resource = HttpUtilities.requestHTTPFile(url.toString());
                            systemId = new File(url.getFile()).getName();
                        } else {
                            f = new File(location);
                            resource = FileSystemUtilities.readBytesFromFile(f);
                            systemId = f.getName();
                        }
                    }
                    catch (Exception e) {
                        throw new DriverRegistroServiziException("Allegato [" + location + "] indirizza un documento non esistente");
                    }
                }
                try {
                    if (!XSDUtils.isXSDSchema(resource)) continue;
                    if (resources.containsKey(systemId)) {
                        throw new Exception("Esiste pi\u00f9 di un documento xsd, registrato tra allegati e specifiche semiformali, con nome [" + systemId + "] (La validazione xsd di OpenSPCoop richiede l'utilizzo di nomi diversi)");
                    }
                    resources.put(systemId, resource);
                    this.registraMappingNamespaceLocations(resource, systemId, mappingNamespaceLocations);
                    continue;
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("La lettura dell'allegato [" + systemId + "] ha causato un errore: " + e.getMessage(), e);
                }
            }
        }
        if (as.sizeSpecificaSemiformaleList() > 0) {
            for (int i = 0; i < as.sizeSpecificaSemiformaleList(); ++i) {
                Documento specificaSemiformale = as.getSpecificaSemiformale(i);
                resource = null;
                systemId = null;
                if (fromBytes) {
                    systemId = specificaSemiformale.getFile();
                    resource = specificaSemiformale.getByteContenuto();
                    if (resource == null) {
                        throw new DriverRegistroServiziException("Specifica Semiformale [" + systemId + "] non contiene i bytes che ne definiscono il contenuto");
                    }
                } else {
                    location = specificaSemiformale.getFile();
                    try {
                        if (location.startsWith("http://") || location.startsWith("file://")) {
                            url = new URL(location);
                            resource = HttpUtilities.requestHTTPFile(url.toString());
                            systemId = new File(url.getFile()).getName();
                        } else {
                            f = new File(location);
                            resource = FileSystemUtilities.readBytesFromFile(f);
                            systemId = f.getName();
                        }
                    }
                    catch (Exception e) {
                        throw new DriverRegistroServiziException("Specifica Semiformale [" + location + "] indirizza un documento non esistente");
                    }
                }
                try {
                    if (!XSDUtils.isXSDSchema(resource)) continue;
                    if (resources.containsKey(systemId)) {
                        throw new Exception("Esiste pi\u00f9 di un documento xsd, registrato tra allegati e specifiche semiformali, con nome [" + systemId + "] (La validazione xsd di OpenSPCoop richiede l'utilizzo di nomi diversi)");
                    }
                    resources.put(systemId, resource);
                    this.registraMappingNamespaceLocations(resource, systemId, mappingNamespaceLocations);
                    continue;
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("La lettura della specifica semiformale [" + systemId + "] ha causato un errore: " + e.getMessage(), e);
                }
            }
        }
        if (resources.size() == 0) {
            throw new DriverRegistroServiziException("Accordo di Servizio OpenSPCoop definito all'interno dell'Accordo di Servizio Wrapper, non contiene schemi (dopo lettura)");
        }
        byte[] schemaPerValidazione = null;
        try {
            StringBuffer bf = new StringBuffer();
            bf.append("<xsd:schema targetNamespace=\"http://openspcoop.org/validazione_engine\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">\n");
            Enumeration targetNamespaces = mappingNamespaceLocations.keys();
            int indexSystemId = 0;
            while (targetNamespaces.hasMoreElements()) {
                String targetNamespace = (String)targetNamespaces.nextElement();
                String locations = mappingNamespaceLocations.get(targetNamespace);
                String[] splitLocations = locations.split(" ");
                if (splitLocations.length == 1) {
                    bf.append("\t<xsd:import namespace=\"" + targetNamespace + "\" schemaLocation=\"" + splitLocations[0] + "\" />\n");
                    continue;
                }
                String systemIdNewSchema = "System_OpenSPCoop_Id_" + indexSystemId;
                ++indexSystemId;
                bf.append("\t<xsd:import namespace=\"" + targetNamespace + "\" schemaLocation=\"" + systemIdNewSchema + "\" />\n");
                StringBuffer bfStessoNamespace = new StringBuffer();
                bfStessoNamespace.append("<xsd:schema targetNamespace=\"" + targetNamespace + "\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">\n");
                for (int i = 0; i < splitLocations.length; ++i) {
                    bfStessoNamespace.append("\t<xsd:include schemaLocation=\"" + splitLocations[i] + "\" />\n");
                }
                bfStessoNamespace.append("</xsd:schema>");
                resources.put(systemIdNewSchema, bfStessoNamespace.toString().getBytes());
            }
            bf.append("</xsd:schema>");
            schemaPerValidazione = bf.toString().getBytes();
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Creazione schema da utilizzare per la validazione fallita: " + e.getMessage(), e);
        }
        XSDResourceResolver resourceResolver = new XSDResourceResolver(resources);
        try {
            ValidatoreXSD validatoreXSD = new ValidatoreXSD((LSResourceResolver)resourceResolver, (InputStream)new ByteArrayInputStream(schemaPerValidazione));
            this.accordoServizioWrapper.setSchema(validatoreXSD.getSchema());
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Riscontrato errore durante l'inizializzazione dello schema tramite validatore: " + e.getMessage(), e);
        }
    }

    public Definition buildWsdlErogatore() throws DriverRegistroServiziException {
        if (this.accordoServizioWrapper == null) {
            throw new DriverRegistroServiziException("Accordo di Servizio Wrapper non definito, utilizza setAccordoServizioWrapper()");
        }
        if (this.accordoServizioWrapper.getAccordoServizio() == null) {
            throw new DriverRegistroServiziException("Accordo di Servizio OpenSPCoop non definito all'interno dell'Accordo di Servizio Wrapper");
        }
        AccordoServizio as = this.accordoServizioWrapper.getAccordoServizio();
        if (as.getWsdlLogicoErogatore() == null || "".equals(as.getWsdlLogicoErogatore())) {
            throw new DriverRegistroServiziException("Location del WsdlLogicoErogatore non definito");
        }
        Definition wsdl = this.buildWsdl(as.getWsdlLogicoErogatore());
        if (this.accordoServizioWrapper.getLocationWsdlImplementativoErogatore() != null && !"".equals(this.accordoServizioWrapper.getLocationWsdlImplementativoErogatore())) {
            Definition wsdlImplementativo = this.buildWsdl(this.accordoServizioWrapper.getLocationWsdlImplementativoErogatore());
            this.logger.debug((Object)"Add parte implementativa...");
            this.openspcoopUtilities.addParteImplementativa(wsdl, wsdlImplementativo);
        }
        return wsdl;
    }

    public Definition buildWsdlFruitore() throws DriverRegistroServiziException {
        if (this.accordoServizioWrapper == null) {
            throw new DriverRegistroServiziException("Accordo di Servizio non definito, utilizza setAccordoServizio()");
        }
        if (this.accordoServizioWrapper.getAccordoServizio() == null) {
            throw new DriverRegistroServiziException("Accordo di Servizio OpenSPCoop non definito all'interno dell'Accordo di Servizio Wrapper");
        }
        AccordoServizio as = this.accordoServizioWrapper.getAccordoServizio();
        if (as.getWsdlLogicoFruitore() == null || "".equals(as.getWsdlLogicoFruitore())) {
            throw new DriverRegistroServiziException("Location del WsdlLogicoFruitore non definito, utilizza setLocationWsdlLogicoFruitore(String)");
        }
        Definition wsdl = this.buildWsdl(as.getWsdlLogicoFruitore());
        if (this.accordoServizioWrapper.getLocationWsdlImplementativoFruitore() != null && !"".equals(this.accordoServizioWrapper.getLocationWsdlImplementativoFruitore())) {
            Definition wsdlImplementativo = this.buildWsdl(this.accordoServizioWrapper.getLocationWsdlImplementativoFruitore());
            this.logger.debug((Object)"Add parte implementativa...");
            this.openspcoopUtilities.addParteImplementativa(wsdl, wsdlImplementativo);
        }
        return wsdl;
    }

    public Definition buildWsdlErogatoreFromBytes() throws DriverRegistroServiziException {
        if (this.accordoServizioWrapper == null) {
            throw new DriverRegistroServiziException("Accordo di Servizio non definito, utilizza setAccordoServizio()");
        }
        if (this.accordoServizioWrapper.getAccordoServizio() == null) {
            throw new DriverRegistroServiziException("Accordo di Servizio OpenSPCoop non definito all'interno dell'Accordo di Servizio Wrapper");
        }
        AccordoServizio as = this.accordoServizioWrapper.getAccordoServizio();
        Definition wsdl = this.openspcoopUtilities.buildWsdlFromObjects(as, this.accordoServizioWrapper.getBytesWsdlImplementativoErogatore(), true);
        return wsdl;
    }

    public Definition buildWsdlFruitoreFromBytes() throws DriverRegistroServiziException {
        if (this.accordoServizioWrapper == null) {
            throw new DriverRegistroServiziException("Accordo di Servizio non definito, utilizza setAccordoServizio()");
        }
        if (this.accordoServizioWrapper.getAccordoServizio() == null) {
            throw new DriverRegistroServiziException("Accordo di Servizio OpenSPCoop non definito all'interno dell'Accordo di Servizio Wrapper");
        }
        AccordoServizio as = this.accordoServizioWrapper.getAccordoServizio();
        Definition wsdl = this.openspcoopUtilities.buildWsdlFromObjects(as, this.accordoServizioWrapper.getBytesWsdlImplementativoFruitore(), false);
        return wsdl;
    }

    private Definition buildWsdl(String url) throws DriverRegistroServiziException {
        try {
            Document document = null;
            document = url.startsWith("http://") || url.startsWith("file://") ? XMLUtils.newDocument(HttpUtilities.requestHTTPFile(url)) : XMLUtils.newDocument(FileSystemUtilities.readBytesFromFile(url));
            WSDLUtilities.removeSchemiIntoTypes(document);
            WSDLUtilities.removeImports(document);
            Definition wsdl = WSDLUtilities.readWSDLFromDocument(document);
            return wsdl;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Riscontrato errore durante la costruzione del wsdl [" + url + "]: " + e.getMessage(), e);
        }
    }

    public void buildAccordoServizioWrapperFromWsdl(Definition wsdl, boolean readParteImplementativa) throws DriverRegistroServiziException {
        try {
            if (this.accordoServizioWrapper == null) {
                this.accordoServizioWrapper = new AccordoServizioWrapper();
            }
            javax.wsdl.PortType portTypeWSDL2 = null;
            Map portTypes = wsdl.getPortTypes();
            if (portTypes == null || portTypes.size() <= 0) {
                throw new DriverRegistroServiziException("Port types non presenti");
            }
            for (javax.wsdl.PortType portTypeWSDL2 : portTypes.values()) {
                PortType ptAS = new PortType();
                ptAS.setNome(portTypeWSDL2.getQName().getLocalPart());
                this.logger.debug((Object)("add port type: [" + portTypeWSDL2.getQName().getLocalPart() + "]"));
                List operations = portTypeWSDL2.getOperations();
                if (operations == null || operations.size() <= 0) {
                    throw new DriverRegistroServiziException("operations per il port type [" + ptAS.getNome() + "] non presenti");
                }
                for (int opIndex = 0; opIndex < operations.size(); ++opIndex) {
                    Map argumentsOperationOutput;
                    String elementName;
                    Part argument;
                    MessagePart partAS;
                    Iterator argumentsIterator;
                    Map argumentsOperationInput;
                    javax.wsdl.Operation operationWSDL = (javax.wsdl.Operation)operations.get(opIndex);
                    Operation operationAS = new Operation();
                    operationAS.setNome(operationWSDL.getName());
                    this.logger.debug((Object)("add operation: [" + operationWSDL.getName() + "]"));
                    if (operationWSDL.getInput() != null && operationWSDL.getInput().getMessage() != null && operationWSDL.getInput().getMessage().getParts() != null && (argumentsOperationInput = operationWSDL.getInput().getMessage().getParts()) != null && argumentsOperationInput.size() > 0) {
                        Message mInputAS = new Message();
                        argumentsIterator = argumentsOperationInput.values().iterator();
                        while (argumentsIterator.hasNext()) {
                            partAS = new MessagePart();
                            argument = (Part)argumentsIterator.next();
                            elementName = argument.getElementName().getLocalPart();
                            partAS.setElementName(elementName);
                            mInputAS.addPart(partAS);
                            this.logger.debug((Object)("add message input dell'operation[" + operationWSDL.getName() + "] con element-name: " + elementName));
                        }
                        operationAS.setMessageInput(mInputAS);
                    }
                    if (operationWSDL.getOutput() != null && operationWSDL.getOutput().getMessage() != null && operationWSDL.getOutput().getMessage().getParts() != null && (argumentsOperationOutput = operationWSDL.getOutput().getMessage().getParts()) != null && argumentsOperationOutput.size() > 0) {
                        Message mOutputAS = new Message();
                        argumentsIterator = argumentsOperationOutput.values().iterator();
                        while (argumentsIterator.hasNext()) {
                            partAS = new MessagePart();
                            argument = (Part)argumentsIterator.next();
                            elementName = argument.getElementName().getLocalPart();
                            partAS.setElementName(elementName);
                            mOutputAS.addPart(partAS);
                            this.logger.debug((Object)("add message output dell'operation[" + operationWSDL.getName() + "] con element-name: " + elementName));
                        }
                        operationAS.setMessageOutput(mOutputAS);
                    }
                    ptAS.addAzione(operationAS);
                }
                this.accordoServizioWrapper.addPortType(ptAS);
            }
            if (readParteImplementativa) {
                Map bindings = wsdl.getAllBindings();
                if (bindings == null || bindings.size() <= 0) {
                    throw new DriverRegistroServiziException("bindings non presenti");
                }
                this.logger.debug((Object)("bindings presenti [" + bindings.size() + "]"));
                Binding bindingWSDL2 = null;
                for (Binding bindingWSDL2 : bindings.values()) {
                    List bindingsOperation;
                    String nomePortType = bindingWSDL2.getPortType().getQName().getLocalPart();
                    PortType ptAS = this.accordoServizioWrapper.removePortType(nomePortType);
                    if (ptAS == null) {
                        throw new DriverRegistroServiziException("Port type [" + nomePortType + "] non presente, nella lista dei port type, durante l'analisi della parte di binding");
                    }
                    this.logger.debug((Object)("esamino binding per port type: [" + nomePortType + "]"));
                    List extendibleElements = bindingWSDL2.getExtensibilityElements();
                    if (extendibleElements != null) {
                        this.logger.debug((Object)("esamino binding extendibles [" + extendibleElements.size() + "] per port type: [" + nomePortType + "]"));
                        for (int i = 0; i < extendibleElements.size(); ++i) {
                            ExtensibilityElement elem = (ExtensibilityElement)extendibleElements.get(i);
                            this.logger.debug((Object)("esamino binding extendibles di tipo:" + elem.getClass().getName() + " instance of SOAPBinding:" + (elem instanceof SOAPBinding)));
                            if (!(elem instanceof SOAPBinding)) continue;
                            SOAPBinding soapBinding = (SOAPBinding)elem;
                            ptAS.setStyle(soapBinding.getStyle());
                            this.logger.debug((Object)("add style port type [" + nomePortType + "]: " + soapBinding.getStyle()));
                        }
                    }
                    if ((bindingsOperation = bindingWSDL2.getBindingOperations()) == null || bindingsOperation.size() <= 0) {
                        throw new DriverRegistroServiziException("Bindings operations per il port type [" + ptAS.getNome() + "] non presenti");
                    }
                    for (int i = 0; i < bindingsOperation.size(); ++i) {
                        List extendibleElementsMessageOutput;
                        BindingOutput bindingOutput;
                        List extendibleElementsMessageInput;
                        BindingInput bindingInput;
                        BindingOperation bindingOperation = (BindingOperation)bindingsOperation.get(i);
                        String nomeOperation = bindingOperation.getName();
                        Operation operationAS = null;
                        for (int j = 0; j < ptAS.sizeAzioneList(); ++j) {
                            if (!nomeOperation.equals(ptAS.getAzione(j).getNome())) continue;
                            operationAS = ptAS.removeAzione(j);
                            ++j;
                        }
                        if (operationAS == null) {
                            throw new DriverRegistroServiziException("Operation [" + nomeOperation + "] del Port type [" + ptAS.getNome() + "] non presente, nella lista delle operation, durante l'analisi della parte di binding");
                        }
                        List extendibleElementsOperations = bindingOperation.getExtensibilityElements();
                        if (extendibleElementsOperations != null) {
                            this.logger.debug((Object)("esamino binding extendibles [" + extendibleElementsOperations.size() + "] per azione[" + nomeOperation + "] del port type[" + nomePortType + "]"));
                            for (int j = 0; j < extendibleElementsOperations.size(); ++j) {
                                ExtensibilityElement elem = (ExtensibilityElement)extendibleElementsOperations.get(j);
                                this.logger.debug((Object)("esamino binding extendibles di tipo:" + elem.getClass().getName() + " instance of SOAPOperation:" + (elem instanceof SOAPOperation)));
                                if (!(elem instanceof SOAPOperation)) continue;
                                SOAPOperation soapOperation = (SOAPOperation)elem;
                                operationAS.setStyle(soapOperation.getStyle());
                                this.logger.debug((Object)("add style Operation [" + nomeOperation + "] del Port type [" + ptAS.getNome() + "]: " + soapOperation.getStyle()));
                                operationAS.setSoapAction(soapOperation.getSoapActionURI());
                                this.logger.debug((Object)("add SOAPAction Operation [" + nomeOperation + "] del Port type [" + ptAS.getNome() + "]: " + soapOperation.getSoapActionURI()));
                            }
                        }
                        if ((bindingInput = bindingOperation.getBindingInput()) != null && (extendibleElementsMessageInput = bindingInput.getExtensibilityElements()) != null) {
                            this.logger.debug((Object)("esamino binding extendibles [" + extendibleElementsMessageInput.size() + "] per message-input dell'azione[" + nomeOperation + "] del port type[" + nomePortType + "]"));
                            for (int j = 0; j < extendibleElementsMessageInput.size(); ++j) {
                                ExtensibilityElement elem = (ExtensibilityElement)extendibleElementsMessageInput.get(j);
                                this.logger.debug((Object)("esamino binding extendibles di tipo:" + elem.getClass().getName() + " instance of SOAPBody:" + (elem instanceof SOAPBody)));
                                if (!(elem instanceof SOAPBody)) continue;
                                SOAPBody soapBody = (SOAPBody)elem;
                                operationAS.getMessageInput().setUse(soapBody.getUse());
                                this.logger.debug((Object)("add use message input Operation [" + nomeOperation + "] del Port type [" + ptAS.getNome() + "]: " + soapBody.getUse()));
                            }
                        }
                        if ((bindingOutput = bindingOperation.getBindingOutput()) != null && (extendibleElementsMessageOutput = bindingOutput.getExtensibilityElements()) != null) {
                            this.logger.debug((Object)("esamino binding extendibles [" + extendibleElementsMessageOutput.size() + "] per message-output dell'azione[" + nomeOperation + "] del port type[" + nomePortType + "]"));
                            for (int j = 0; j < extendibleElementsMessageOutput.size(); ++j) {
                                ExtensibilityElement elem = (ExtensibilityElement)extendibleElementsMessageOutput.get(j);
                                this.logger.debug((Object)("esamino binding extendibles di tipo:" + elem.getClass().getName() + " instance of SOAPBody:" + (elem instanceof SOAPBody)));
                                if (!(elem instanceof SOAPBody)) continue;
                                SOAPBody soapBody = (SOAPBody)elem;
                                operationAS.getMessageOutput().setUse(soapBody.getUse());
                                this.logger.debug((Object)("add use message output Operation [" + nomeOperation + "] del Port type [" + ptAS.getNome() + "]: " + soapBody.getUse()));
                            }
                        }
                        ptAS.addAzione(operationAS);
                    }
                    this.accordoServizioWrapper.addPortType(ptAS);
                }
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Riscontrato errore durante la lettura del wsdl: " + e.getMessage(), e);
        }
    }

    public void buildAccordoServizioWrapperFromOpenSPCoopAS(AccordoServizio as) throws DriverRegistroServiziException {
        if (this.accordoServizioWrapper == null) {
            this.accordoServizioWrapper = new AccordoServizioWrapper();
        }
        for (int i = 0; i < as.sizePortTypeList(); ++i) {
            this.accordoServizioWrapper.addPortType(as.getPortType(i));
        }
    }
}

