/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.dao.registry.driver;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Connection;
import java.util.Properties;
import java.util.Vector;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.log4j.Logger;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.commons.TipiConnettore;
import org.openspcoop.dao.config.AccessoRegistroRegistro;
import org.openspcoop.dao.registry.AccordoCooperazione;
import org.openspcoop.dao.registry.AccordoServizio;
import org.openspcoop.dao.registry.Connettore;
import org.openspcoop.dao.registry.ConnettoreProperty;
import org.openspcoop.dao.registry.Operation;
import org.openspcoop.dao.registry.PortType;
import org.openspcoop.dao.registry.PortaDominio;
import org.openspcoop.dao.registry.RegistroServizi;
import org.openspcoop.dao.registry.ServizioSpcoop;
import org.openspcoop.dao.registry.ServizioSpcoopAccordoParteSpecifica;
import org.openspcoop.dao.registry.SoggettoSpcoop;
import org.openspcoop.dao.registry.driver.BeanUtilities;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziDB;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziException;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziUDDI;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziWEB;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziXML;
import org.openspcoop.dao.registry.driver.IDAccordo;
import org.openspcoop.dao.registry.driver.IDAccordoCooperazione;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.dao.registry.driver.IDriverRegistroServiziCRUD;
import org.openspcoop.dao.registry.driver.IDriverRegistroServiziGet;
import org.openspcoop.dao.registry.driver.ProprietariDocumento;
import org.openspcoop.dao.registry.driver.RuoliDocumento;
import org.openspcoop.dao.registry.driver.SICAtoOpenSPCoopUtilities;
import org.openspcoop.dao.registry.driver.StatiAccordo;
import org.openspcoop.utils.HttpUtilities;
import org.openspcoop.utils.xml.ValidatoreXSD;

public class XMLDataConverter {
    private IDriverRegistroServiziCRUD gestoreCRUD = null;
    private RegistroServizi sorgenteRegistro;
    private Logger log = null;
    private Logger logDriver = null;
    private String superUser = null;
    private String tipoBEDestinazione;
    private File parentFile = null;

    public XMLDataConverter(String sorgente, AccessoRegistroRegistro destinazione, String superUser) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, destinazione, superUser, null, null);
    }

    public XMLDataConverter(String sorgente, AccessoRegistroRegistro destinazione, String superUser, Logger log) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, destinazione, superUser, log, null);
    }

    public XMLDataConverter(String sorgente, AccessoRegistroRegistro destinazione, String superUser, Logger log, Logger logDriver) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, destinazione, superUser, log, logDriver);
    }

    public XMLDataConverter(byte[] sorgente, AccessoRegistroRegistro destinazione, String superUser) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, destinazione, superUser, null, null);
    }

    public XMLDataConverter(byte[] sorgente, AccessoRegistroRegistro destinazione, String superUser, Logger log) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, destinazione, superUser, log, null);
    }

    public XMLDataConverter(byte[] sorgente, AccessoRegistroRegistro destinazione, String superUser, Logger log, Logger logDriver) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, destinazione, superUser, log, logDriver);
    }

    public XMLDataConverter(InputStream sorgente, AccessoRegistroRegistro destinazione, String superUser) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, destinazione, superUser, null, null);
    }

    public XMLDataConverter(InputStream sorgente, AccessoRegistroRegistro destinazione, String superUser, Logger log) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, destinazione, superUser, log, null);
    }

    public XMLDataConverter(InputStream sorgente, AccessoRegistroRegistro destinazione, String superUser, Logger log, Logger logDriver) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, destinazione, superUser, log, logDriver);
    }

    public XMLDataConverter(File sorgente, AccessoRegistroRegistro destinazione, String superUser) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, destinazione, superUser, null, null);
    }

    public XMLDataConverter(File sorgente, AccessoRegistroRegistro destinazione, String superUser, Logger log) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, destinazione, superUser, log, null);
    }

    public XMLDataConverter(File sorgente, AccessoRegistroRegistro destinazione, String superUser, Logger log, Logger logDriver) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, destinazione, superUser, log, logDriver);
    }

    private void XMLDataConverterSetup(Object sorgente, AccessoRegistroRegistro destinazione, String superUser, Logger log, Logger logDriver) throws DriverRegistroServiziException {
        block38: {
            block37: {
                this.log = log == null ? Logger.getLogger((String)"RegistroServiziXMLDataConverter") : log;
                this.logDriver = logDriver;
                if (destinazione == null) {
                    throw new DriverRegistroServiziException("GestoreCRUD non definito");
                }
                this.tipoBEDestinazione = destinazione.getTipo();
                this.superUser = superUser;
                try {
                    File f;
                    if (sorgente instanceof String) {
                        this.createSorgente((String)sorgente);
                        try {
                            f = new File((String)sorgente);
                            if (f.getParentFile() != null) {
                                this.parentFile = f.getParentFile();
                            }
                            break block37;
                        }
                        catch (Exception e) {}
                        break block37;
                    }
                    if (sorgente instanceof byte[]) {
                        this.createSorgente((byte[])sorgente);
                        break block37;
                    }
                    if (sorgente instanceof InputStream) {
                        ByteArrayOutputStream bout = new ByteArrayOutputStream();
                        InputStream is = (InputStream)sorgente;
                        int letti = 0;
                        byte[] reads = new byte[65536];
                        while ((letti = is.read(reads)) != -1) {
                            bout.write(reads, 0, letti);
                        }
                        bout.flush();
                        bout.close();
                        this.createSorgente(bout.toByteArray());
                        break block37;
                    }
                    if (!(sorgente instanceof File)) break block37;
                    this.createSorgente(((File)sorgente).getAbsolutePath());
                    try {
                        f = (File)sorgente;
                        if (f.getParentFile() != null) {
                            this.parentFile = f.getParentFile();
                        }
                    }
                    catch (Exception e) {}
                }
                catch (DriverRegistroServiziException d) {
                    throw d;
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("Creazione sorgente [" + sorgente.getClass().getName() + "] non riuscita: " + e.getMessage(), e);
                }
            }
            try {
                if ("db".equals(destinazione.getTipo())) {
                    if (destinazione.getLocation() == null) {
                        throw new Exception("Location (DataSource) non definita");
                    }
                    if (destinazione.getTipoDatabase() == null) {
                        throw new Exception("TipoDatabase (DataSource) non definita");
                    }
                    if (destinazione.getGenericProperties() == null) {
                        throw new Exception("Contesto di localizzazione del datasource non definito in GenericProperties");
                    }
                    if (destinazione.getGenericProperties().size() != 1) {
                        throw new Exception("Contesto di localizzazione del datasource non definito in GenericProperties (size:" + destinazione.getGenericProperties().size() + ")");
                    }
                    if (!(destinazione.getGenericProperties().get(0) instanceof Properties)) {
                        throw new Exception("Contesto di localizzazione del datasource definito in GenericProperties non e' un oggetto java.util.Properties");
                    }
                    this.gestoreCRUD = new DriverRegistroServiziDB(destinazione.getLocation(), (Properties)destinazione.getGenericProperties().get(0), this.logDriver, destinazione.getTipoDatabase());
                    if (((DriverRegistroServiziDB)this.gestoreCRUD).create) {
                        this.log.info((Object)"Inizializzato Registro dei Servizi DB");
                        break block38;
                    }
                    throw new Exception("RegistroServizi DB non inizializzato");
                }
                if ("uddi".equals(destinazione.getTipo())) {
                    if (destinazione.getLocation() == null) {
                        throw new Exception("Location (InquiryURL) non definita");
                    }
                    if (destinazione.getGenericProperties() == null) {
                        throw new Exception("PublishURL/UrlPrefix/PathPrefix non definita in GenericProperties");
                    }
                    if (destinazione.getGenericProperties().size() != 3) {
                        throw new Exception("PublishURL/UrlPrefix/PathPrefix non definita in GenericProperties (size:" + destinazione.getGenericProperties().size() + ")");
                    }
                    if (!(destinazione.getGenericProperties().get(0) instanceof String)) {
                        throw new Exception("PublishURL definita in GenericProperties non e' un oggetto String");
                    }
                    if (!(destinazione.getGenericProperties().get(1) instanceof String)) {
                        throw new Exception("UrlPrefix definita in GenericProperties non e' un oggetto String");
                    }
                    if (!(destinazione.getGenericProperties().get(2) instanceof String)) {
                        throw new Exception("PathPrefix definita in GenericProperties non e' un oggetto String");
                    }
                    this.gestoreCRUD = new DriverRegistroServiziUDDI(destinazione.getLocation(), (String)destinazione.getGenericProperties().get(0), destinazione.getUser(), destinazione.getPassword(), (String)destinazione.getGenericProperties().get(1), (String)destinazione.getGenericProperties().get(2), this.logDriver);
                    if (((DriverRegistroServiziUDDI)this.gestoreCRUD).create) {
                        this.log.info((Object)"Inizializzato Registro dei Servizi UDDI");
                        break block38;
                    }
                    throw new Exception("RegistroServizi UDDI non inizializzato");
                }
                if ("web".equals(destinazione.getTipo())) {
                    if (destinazione.getLocation() == null) {
                        throw new Exception("Location (UrlPrefix) non definita");
                    }
                    if (destinazione.getGenericProperties() == null) {
                        throw new Exception("PathPrefix non definita in GenericProperties");
                    }
                    if (destinazione.getGenericProperties().size() != 1) {
                        throw new Exception("PathPrefix non definita in GenericProperties (size:" + destinazione.getGenericProperties().size() + ")");
                    }
                    if (!(destinazione.getGenericProperties().get(0) instanceof String)) {
                        throw new Exception("PathPrefix definita in GenericProperties non e' un oggetto String");
                    }
                    this.gestoreCRUD = new DriverRegistroServiziWEB(destinazione.getLocation(), (String)destinazione.getGenericProperties().get(0), this.logDriver);
                    this.log.info((Object)"Inizializzato Registro dei Servizi WEB");
                    if (((DriverRegistroServiziWEB)this.gestoreCRUD).create) {
                        this.log.info((Object)"Inizializzato Registro dei Servizi WEB");
                        break block38;
                    }
                    throw new Exception("RegistroServizi WEB non inizializzato");
                }
                throw new Exception("Tipo di registro CRUD non gestito: " + destinazione.getTipo());
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("Errore durante l'istanziazione del driver di CRUD: " + e.getMessage(), e);
            }
        }
    }

    public XMLDataConverter(String sorgente, Connection connection, String tipoDatabase, String superUser) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, null, null, superUser);
    }

    public XMLDataConverter(String sorgente, Connection connection, String tipoDatabase, Logger log, String superUser) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, log, null, superUser);
    }

    public XMLDataConverter(String sorgente, Connection connection, String tipoDatabase, Logger log, Logger logDriver, String superUser) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, log, logDriver, superUser);
    }

    public XMLDataConverter(byte[] sorgente, Connection connection, String tipoDatabase, String superUser) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, null, null, superUser);
    }

    public XMLDataConverter(byte[] sorgente, Connection connection, String tipoDatabase, Logger log, String superUser) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, log, null, superUser);
    }

    public XMLDataConverter(byte[] sorgente, Connection connection, String tipoDatabase, Logger log, Logger logDriver, String superUser) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, log, logDriver, superUser);
    }

    public XMLDataConverter(InputStream sorgente, Connection connection, String tipoDatabase, String superUser) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, null, null, superUser);
    }

    public XMLDataConverter(InputStream sorgente, Connection connection, String tipoDatabase, Logger log, String superUser) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, log, null, superUser);
    }

    public XMLDataConverter(InputStream sorgente, Connection connection, String tipoDatabase, Logger log, Logger logDriver, String superUser) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, log, logDriver, superUser);
    }

    public XMLDataConverter(File sorgente, Connection connection, String tipoDatabase, String superUser) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, null, null, superUser);
    }

    public XMLDataConverter(File sorgente, Connection connection, String tipoDatabase, Logger log, String superUser) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, log, null, superUser);
    }

    public XMLDataConverter(File sorgente, Connection connection, String tipoDatabase, Logger log, Logger logDriver, String superUser) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, log, logDriver, superUser);
    }

    private void XMLDataConverterSetup(Object sorgente, Connection connection, String tipoDatabase, Logger log, Logger logDriver, String superUser) throws DriverRegistroServiziException {
        block16: {
            this.log = log == null ? Logger.getLogger((String)"ConfigurazioneXMLDataConverter [connection version]") : log;
            this.logDriver = logDriver;
            this.superUser = superUser;
            this.tipoBEDestinazione = "db";
            try {
                File f;
                if (sorgente instanceof String) {
                    this.createSorgente((String)sorgente);
                    try {
                        f = new File((String)sorgente);
                        if (f.getParentFile() != null) {
                            this.parentFile = f.getParentFile();
                        }
                        break block16;
                    }
                    catch (Exception e) {}
                    break block16;
                }
                if (sorgente instanceof byte[]) {
                    this.createSorgente((byte[])sorgente);
                    break block16;
                }
                if (sorgente instanceof InputStream) {
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    InputStream is = (InputStream)sorgente;
                    int letti = 0;
                    byte[] reads = new byte[65536];
                    while ((letti = is.read(reads)) != -1) {
                        bout.write(reads, 0, letti);
                    }
                    bout.flush();
                    bout.close();
                    this.createSorgente(bout.toByteArray());
                    break block16;
                }
                if (!(sorgente instanceof File)) break block16;
                this.createSorgente(((File)sorgente).getAbsolutePath());
                try {
                    f = (File)sorgente;
                    if (f.getParentFile() != null) {
                        this.parentFile = f.getParentFile();
                    }
                }
                catch (Exception e) {}
            }
            catch (DriverRegistroServiziException d) {
                throw d;
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("Creazione sorgente [" + sorgente.getClass().getName() + "] non riuscita: " + e.getMessage(), e);
            }
        }
        try {
            this.gestoreCRUD = new DriverRegistroServiziDB(connection, this.logDriver, tipoDatabase);
            if (!((DriverRegistroServiziDB)this.gestoreCRUD).create) {
                throw new Exception("Configurazione DB non inizializzato");
            }
            this.log.info((Object)"Inizializzato Configurazione DB");
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante l'istanziazione del driver di CRUD: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createSorgente(String sorgente) throws DriverRegistroServiziException {
        block33: {
            if (sorgente == null) {
                throw new DriverRegistroServiziException("Sorgente non definita");
            }
            ValidatoreXSD validatoreRegistro = null;
            try {
                validatoreRegistro = new ValidatoreXSD(DriverRegistroServiziXML.class.getResourceAsStream("/registroServizi.xsd"));
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("Riscontrato errore durante l'inizializzazione dello schema del Registro dei Servizi di OpenSPCoop: " + e.getMessage());
            }
            FileInputStream fXML = null;
            try {
                try {
                    if (sorgente.startsWith("http://") || sorgente.startsWith("file://")) {
                        validatoreRegistro.valida(sorgente);
                    } else {
                        fXML = new FileInputStream(sorgente);
                        validatoreRegistro.valida(fXML);
                    }
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("Riscontrato errore durante la validazione XSD del Registro dei Servizi XML di OpenSPCoop: " + e.getMessage());
                }
                Object var6_5 = null;
                if (fXML == null) break block33;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (fXML == null) throw throwable;
                try {
                    fXML.close();
                    throw throwable;
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception e) {}
            fXML.close();
        }
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
            IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
            InputStreamReader iStream = null;
            HttpURLConnection httpConn = null;
            if (sorgente.startsWith("http://") || sorgente.startsWith("file://")) {
                try {
                    URL url = new URL(sorgente);
                    URLConnection connection = url.openConnection();
                    httpConn = (HttpURLConnection)connection;
                    httpConn.setRequestMethod("GET");
                    httpConn.setDoOutput(true);
                    httpConn.setDoInput(true);
                    iStream = new InputStreamReader(httpConn.getInputStream());
                }
                catch (Exception e) {
                    try {
                        if (iStream != null) {
                            iStream.close();
                        }
                        if (httpConn == null) throw new DriverRegistroServiziException("Riscontrato errore durante la creazione dell'inputStream del registro dei servizi (HTTP) : \n\n" + e.getMessage());
                        httpConn.disconnect();
                        throw new DriverRegistroServiziException("Riscontrato errore durante la creazione dell'inputStream del registro dei servizi (HTTP) : \n\n" + e.getMessage());
                    }
                    catch (Exception ef) {
                        // empty catch block
                    }
                    throw new DriverRegistroServiziException("Riscontrato errore durante la creazione dell'inputStream del registro dei servizi (HTTP) : \n\n" + e.getMessage());
                }
            }
            try {
                iStream = new InputStreamReader(new FileInputStream(sorgente));
            }
            catch (FileNotFoundException e) {
                try {
                    if (iStream == null) throw new DriverRegistroServiziException("Riscontrato errore durante la creazione dell'inputStream del registro dei servizi (FILE) : \n\n" + e.getMessage());
                    iStream.close();
                    throw new DriverRegistroServiziException("Riscontrato errore durante la creazione dell'inputStream del registro dei servizi (FILE) : \n\n" + e.getMessage());
                }
                catch (IOException ef) {
                    // empty catch block
                }
                throw new DriverRegistroServiziException("Riscontrato errore durante la creazione dell'inputStream del registro dei servizi (FILE) : \n\n" + e.getMessage());
            }
            try {
                this.sorgenteRegistro = (RegistroServizi)uctx.unmarshalDocument((Reader)iStream, null);
            }
            catch (JiBXException e) {
                try {
                    if (iStream != null) {
                        iStream.close();
                    }
                    if (httpConn == null) throw new DriverRegistroServiziException("Riscontrato errore durante l'unmarshall del file di configurazione: " + e.getMessage());
                    httpConn.disconnect();
                    throw new DriverRegistroServiziException("Riscontrato errore durante l'unmarshall del file di configurazione: " + e.getMessage());
                }
                catch (Exception ef) {
                    // empty catch block
                }
                throw new DriverRegistroServiziException("Riscontrato errore durante l'unmarshall del file di configurazione: " + e.getMessage());
            }
            try {
                if (iStream != null) {
                    iStream.close();
                }
                if (httpConn == null) return;
                httpConn.disconnect();
                return;
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("Riscontrato errore durante la chiusura dell'Input Stream: " + e.getMessage());
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Riscontrato errore durante l'istanziazione del registro: " + e.getMessage(), e);
        }
    }

    private void createSorgente(byte[] sorgente) throws DriverRegistroServiziException {
        if (sorgente == null) {
            throw new DriverRegistroServiziException("Sorgente non definita");
        }
        ValidatoreXSD validatoreRegistro = null;
        try {
            validatoreRegistro = new ValidatoreXSD(DriverRegistroServiziXML.class.getResourceAsStream("/registroServizi.xsd"));
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Riscontrato errore durante l'inizializzazione dello schema del Registro dei Servizi di OpenSPCoop: " + e.getMessage());
        }
        try {
            validatoreRegistro.valida(new ByteArrayInputStream(sorgente));
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Riscontrato errore durante la validazione XSD del Registro dei Servizi XML di OpenSPCoop: " + e.getMessage());
        }
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
            IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
            InputStreamReader iStream = null;
            try {
                iStream = new InputStreamReader(new ByteArrayInputStream(sorgente));
            }
            catch (Exception e) {
                try {
                    if (iStream != null) {
                        iStream.close();
                    }
                }
                catch (IOException ef) {
                    // empty catch block
                }
                throw new DriverRegistroServiziException("Riscontrato errore durante la creazione dell'inputStreamReader del registro dei servizi : \n\n" + e.getMessage());
            }
            try {
                this.sorgenteRegistro = (RegistroServizi)uctx.unmarshalDocument((Reader)iStream, null);
            }
            catch (JiBXException e) {
                try {
                    if (iStream != null) {
                        iStream.close();
                    }
                }
                catch (Exception ef) {
                    // empty catch block
                }
                throw new DriverRegistroServiziException("Riscontrato errore durante l'unmarshall del file di configurazione: " + e.getMessage());
            }
            try {
                if (iStream != null) {
                    iStream.close();
                }
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("Riscontrato errore durante la chiusura dell'Input Stream: " + e.getMessage());
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Riscontrato errore durante l'istanziazione del registro: " + e.getMessage(), e);
        }
    }

    public void convertXML(boolean reset, boolean mantieniFruitoriEsistenti, boolean aggiornamentoSoggetti, StatiAccordo statoAccordo) throws DriverRegistroServiziException {
        this.convertXML(reset, null, mantieniFruitoriEsistenti, aggiornamentoSoggetti, statoAccordo);
    }

    public void convertXML(boolean reset, String pddOperativaCtrlstatSinglePdd, boolean mantieniFruitoriEsistenti, boolean aggiornamentoSoggetti, StatiAccordo statoAccordo) throws DriverRegistroServiziException {
        SoggettoSpcoop soggetto;
        int i;
        if (reset) {
            try {
                this.log.info((Object)"RegistroServizi, reset in corso...");
                this.gestoreCRUD.reset();
                this.log.info((Object)"RegistroServizi, reset effettuato.");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new DriverRegistroServiziException("Reset del RegistroServizi non riuscita: " + e.getMessage(), e);
            }
        }
        try {
            for (i = 0; i < this.sorgenteRegistro.sizePortaDominioList(); ++i) {
                PortaDominio pdd = this.sorgenteRegistro.getPortaDominio(i);
                pdd.setSuperUser(this.superUser);
                if (pdd.getImplementazione() == null) {
                    pdd.setImplementazione("standard");
                }
                if (!reset && this.gestoreCRUD.existsPortaDominio(pdd.getNome())) {
                    this.log.info((Object)("Porta di Dominio " + pdd.getNome() + " aggiornamento in corso..."));
                    this.gestoreCRUD.updatePortaDominio(pdd);
                    this.log.info((Object)("Porta di Dominio " + pdd.getNome() + " aggiornata."));
                } else {
                    this.log.info((Object)("Porta di Dominio " + pdd.getNome() + " creazione in corso..."));
                    this.gestoreCRUD.createPortaDominio(pdd);
                    this.log.info((Object)("Porta di Dominio " + pdd.getNome() + " creata."));
                }
                if (!"db".equals(this.tipoBEDestinazione) || pddOperativaCtrlstatSinglePdd == null) continue;
                if (pdd.getNome().equals(pddOperativaCtrlstatSinglePdd)) {
                    this.log.info((Object)("Porta di Dominio " + pdd.getNome() + " aggiornamento tipo[operativo] in corso..."));
                    ((DriverRegistroServiziDB)this.gestoreCRUD).updateTipoPortaDominio(pdd.getNome(), "operativo");
                    this.log.info((Object)("Porta di Dominio " + pdd.getNome() + " aggiornata con tipo operativo."));
                    continue;
                }
                this.log.info((Object)("Porta di Dominio " + pdd.getNome() + " aggiornamento tipo[esterno] in corso..."));
                ((DriverRegistroServiziDB)this.gestoreCRUD).updateTipoPortaDominio(pdd.getNome(), "esterno");
                this.log.info((Object)("Porta di Dominio " + pdd.getNome() + " aggiornata con tipo esterno."));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DriverRegistroServiziException("Errore durante la conversione XML delle porte di dominio: " + e.getMessage(), e);
        }
        try {
            for (i = 0; i < this.sorgenteRegistro.sizeSoggettoSpcoopList(); ++i) {
                SoggettoSpcoop soggetto2 = this.sorgenteRegistro.getSoggettoSpcoop(i);
                this.gestioneSoggetto(soggetto2, reset, aggiornamentoSoggetti, pddOperativaCtrlstatSinglePdd);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DriverRegistroServiziException("Errore durante la conversione XML dei soggetti: " + e.getMessage(), e);
        }
        try {
            for (i = 0; i < this.sorgenteRegistro.sizeAccordoCooperazioneList(); ++i) {
                AccordoCooperazione ac = this.sorgenteRegistro.getAccordoCooperazione(i);
                if ("db".equals(this.tipoBEDestinazione)) {
                    ac.setStatoPackage(statoAccordo.toString());
                }
                this.gestioneAccordoCooperazione(ac, reset);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DriverRegistroServiziException("Errore durante la conversione XML degli accordi di cooperazione: " + e.getMessage(), e);
        }
        Vector<AccordoServizio> accordiServizioComposti = new Vector<AccordoServizio>();
        Vector<String> accordiServizioCompostiID = new Vector<String>();
        try {
            for (int i2 = 0; i2 < this.sorgenteRegistro.sizeAccordoServizioList(); ++i2) {
                AccordoServizio as = this.sorgenteRegistro.getAccordoServizio(i2);
                if ("db".equals(this.tipoBEDestinazione)) {
                    as.setStatoPackage(statoAccordo.toString());
                }
                if (as.getServizioComposto() == null) {
                    this.gestioneAccordoServizio(as, reset);
                    continue;
                }
                String idAccordoServizioComposto = IDAccordo.getUriFromAccordo(as);
                this.log.debug((Object)("AccordoServizio [" + idAccordoServizioComposto + "] e' un accordo di servizio composto, verra posticipata la gestione dopo la creazione dei servizi"));
                accordiServizioComposti.add(as);
                accordiServizioCompostiID.add(idAccordoServizioComposto);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DriverRegistroServiziException("Errore durante la conversione XML degli accordi: " + e.getMessage(), e);
        }
        Vector<ServizioSpcoop> servizioComposti = new Vector<ServizioSpcoop>();
        Vector<SoggettoSpcoop> servizioComposti_Soggetti = new Vector<SoggettoSpcoop>();
        try {
            for (int i3 = 0; i3 < this.sorgenteRegistro.sizeSoggettoSpcoopList(); ++i3) {
                SoggettoSpcoop soggetto3 = this.sorgenteRegistro.getSoggettoSpcoop(i3);
                for (int j = 0; j < soggetto3.sizeServizioList(); ++j) {
                    boolean servizioComposto;
                    ServizioSpcoop servizio = soggetto3.getServizio(j);
                    if ("db".equals(this.tipoBEDestinazione)) {
                        servizio.setStatoPackage(statoAccordo.toString());
                    }
                    if ("db".equals(this.tipoBEDestinazione)) {
                        if (servizio.getAccordoParteSpecifica() == null) {
                            ServizioSpcoopAccordoParteSpecifica aps = new ServizioSpcoopAccordoParteSpecifica();
                            aps.setNome(servizio.getNome());
                            aps.setVersione("1");
                            servizio.setAccordoParteSpecifica(aps);
                        } else if (servizio.getAccordoParteSpecifica().getVersione() == null) {
                            servizio.getAccordoParteSpecifica().setVersione("1");
                        }
                    }
                    if (!(servizioComposto = accordiServizioCompostiID.contains(servizio.getAccordoServizio()))) {
                        this.gestioneServizioSPCoop(servizio, soggetto3, reset, mantieniFruitoriEsistenti, statoAccordo);
                        continue;
                    }
                    this.log.debug((Object)("ServizioSPCoop [" + soggetto3.getTipo() + "/" + soggetto3.getNome() + "_" + servizio.getTipo() + "/" + servizio.getNome() + "] e' un servizio composto, verra posticipata la gestione dopo la creazione degli accordi di servizio composti"));
                    servizioComposti.add(servizio);
                    servizioComposti_Soggetti.add(soggetto3);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DriverRegistroServiziException("Errore durante la conversione XML dei servizi: " + e.getMessage(), e);
        }
        Vector<ServizioSpcoop> servizioCompostiCorrelati = new Vector<ServizioSpcoop>();
        Vector<SoggettoSpcoop> servizioCompostiCorrelati_Soggetti = new Vector<SoggettoSpcoop>();
        try {
            for (int i4 = 0; i4 < this.sorgenteRegistro.sizeSoggettoSpcoopList(); ++i4) {
                soggetto = this.sorgenteRegistro.getSoggettoSpcoop(i4);
                for (int j = 0; j < soggetto.sizeServizioCorrelatoList(); ++j) {
                    boolean servizioComposto;
                    ServizioSpcoop servizio = soggetto.getServizioCorrelato(j);
                    if ("db".equals(this.tipoBEDestinazione)) {
                        servizio.setStatoPackage(statoAccordo.toString());
                    }
                    if ("db".equals(this.tipoBEDestinazione)) {
                        if (servizio.getAccordoParteSpecifica() == null) {
                            ServizioSpcoopAccordoParteSpecifica aps = new ServizioSpcoopAccordoParteSpecifica();
                            aps.setNome(servizio.getNome() + soggetto.getNome());
                            aps.setVersione("1");
                            servizio.setAccordoParteSpecifica(aps);
                        } else if (servizio.getAccordoParteSpecifica().getVersione() == null) {
                            servizio.getAccordoParteSpecifica().setVersione("1");
                        }
                    }
                    if (!(servizioComposto = accordiServizioCompostiID.contains(servizio.getAccordoServizio()))) {
                        this.gestioneServizioSPCoopCorrelato(servizio, soggetto, reset, mantieniFruitoriEsistenti, statoAccordo);
                        continue;
                    }
                    this.log.debug((Object)("ServizioSPCoopCorrelato [" + soggetto.getTipo() + "/" + soggetto.getNome() + "_" + servizio.getTipo() + "/" + servizio.getNome() + "] e' un servizio composto, verra posticipata la gestione dopo la creazione degli accordi di servizio composti"));
                    servizioCompostiCorrelati.add(servizio);
                    servizioCompostiCorrelati_Soggetti.add(soggetto);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DriverRegistroServiziException("Errore durante la conversione XML dei servizi correlati: " + e.getMessage(), e);
        }
        try {
            while (accordiServizioComposti.size() > 0) {
                AccordoServizio as = (AccordoServizio)accordiServizioComposti.remove(0);
                this.gestioneAccordoServizio(as, reset);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DriverRegistroServiziException("Errore durante la conversione XML degli accordi di servizio composti: " + e.getMessage(), e);
        }
        try {
            while (servizioComposti.size() > 0) {
                ServizioSpcoop servizio = (ServizioSpcoop)servizioComposti.remove(0);
                soggetto = (SoggettoSpcoop)servizioComposti_Soggetti.remove(0);
                this.gestioneServizioSPCoop(servizio, soggetto, reset, mantieniFruitoriEsistenti, statoAccordo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DriverRegistroServiziException("Errore durante la conversione XML dei servizi degli accordi di servizio composti: " + e.getMessage(), e);
        }
        try {
            while (servizioCompostiCorrelati.size() > 0) {
                ServizioSpcoop servizio = (ServizioSpcoop)servizioCompostiCorrelati.remove(0);
                soggetto = (SoggettoSpcoop)servizioCompostiCorrelati_Soggetti.remove(0);
                this.gestioneServizioSPCoopCorrelato(servizio, soggetto, reset, mantieniFruitoriEsistenti, statoAccordo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DriverRegistroServiziException("Errore durante la conversione XML dei servizi degli accordi di servizio composti: " + e.getMessage(), e);
        }
    }

    private void mantieniFruitori(ServizioSpcoop old, ServizioSpcoop servizio) {
        for (int fr = 0; fr < old.sizeFruitoreList(); ++fr) {
            boolean find = false;
            for (int frNew = 0; frNew < servizio.sizeFruitoreList(); ++frNew) {
                if (!servizio.getFruitore(frNew).getTipo().equals(old.getFruitore(fr).getTipo()) || !servizio.getFruitore(frNew).getNome().equals(old.getFruitore(fr).getNome())) continue;
                find = true;
                break;
            }
            if (find) continue;
            servizio.addFruitore(old.getFruitore(fr));
        }
    }

    private void aggiornatoStatoFruitori(ServizioSpcoop servizio, StatiAccordo statoAccordo) {
        for (int i = 0; i < servizio.sizeFruitoreList(); ++i) {
            servizio.getFruitore(i).setStatoPackage(statoAccordo.toString());
        }
    }

    public void delete(boolean deleteSoggetti) throws DriverRegistroServiziException {
        int i;
        IDServizio idServizio;
        IDSoggetto idSoggetto;
        ServizioSpcoop servizio;
        int j;
        SoggettoSpcoop soggetto;
        int i2;
        try {
            for (i2 = 0; i2 < this.sorgenteRegistro.sizeSoggettoSpcoopList(); ++i2) {
                soggetto = this.sorgenteRegistro.getSoggettoSpcoop(i2);
                for (j = 0; j < soggetto.sizeServizioList(); ++j) {
                    servizio = soggetto.getServizio(j);
                    idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
                    idServizio = new IDServizio(idSoggetto, servizio.getTipo(), servizio.getNome());
                    this.log.info((Object)("Servizio " + servizio.getTipo() + "/" + servizio.getNome() + " erogato da " + soggetto.getTipo() + "/" + soggetto.getNome() + " eliminazione in corso..."));
                    if (this.gestoreCRUD.existsServizioSpcoopCorrelato(idServizio)) {
                        this.gestoreCRUD.deleteServizioSpcoopCorrelato(((IDriverRegistroServiziGet)((Object)this.gestoreCRUD)).getServizioCorrelato(idServizio));
                    } else if (this.gestoreCRUD.existsServizioSpcoop(idServizio)) {
                        this.gestoreCRUD.deleteServizioSpcoop(((IDriverRegistroServiziGet)((Object)this.gestoreCRUD)).getServizio(idServizio));
                    }
                    this.log.info((Object)("Servizio " + servizio.getTipo() + "/" + servizio.getNome() + " erogato da " + soggetto.getTipo() + "/" + soggetto.getNome() + " eliminato."));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DriverRegistroServiziException("Errore durante l'eliminazione dei servizi: " + e.getMessage(), e);
        }
        try {
            for (i2 = 0; i2 < this.sorgenteRegistro.sizeSoggettoSpcoopList(); ++i2) {
                soggetto = this.sorgenteRegistro.getSoggettoSpcoop(i2);
                for (j = 0; j < soggetto.sizeServizioCorrelatoList(); ++j) {
                    servizio = soggetto.getServizioCorrelato(j);
                    idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
                    idServizio = new IDServizio(idSoggetto, servizio.getTipo(), servizio.getNome());
                    this.log.info((Object)("Servizio " + servizio.getTipo() + "/" + servizio.getNome() + " erogato da " + soggetto.getTipo() + "/" + soggetto.getNome() + " eliminazione in corso..."));
                    if (this.gestoreCRUD.existsServizioSpcoopCorrelato(idServizio)) {
                        this.gestoreCRUD.deleteServizioSpcoopCorrelato(((IDriverRegistroServiziGet)((Object)this.gestoreCRUD)).getServizioCorrelato(idServizio));
                    } else if (this.gestoreCRUD.existsServizioSpcoop(idServizio)) {
                        this.gestoreCRUD.deleteServizioSpcoop(((IDriverRegistroServiziGet)((Object)this.gestoreCRUD)).getServizio(idServizio));
                    }
                    this.log.info((Object)("Servizio " + servizio.getTipo() + "/" + servizio.getNome() + " erogato da " + soggetto.getTipo() + "/" + soggetto.getNome() + " eliminato."));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DriverRegistroServiziException("Errore durante l'eliminazione dei servizi correlati: " + e.getMessage(), e);
        }
        Vector<AccordoServizio> asServiziNonComposti = new Vector<AccordoServizio>();
        try {
            for (int i3 = 0; i3 < this.sorgenteRegistro.sizeAccordoServizioList(); ++i3) {
                AccordoServizio as = this.sorgenteRegistro.getAccordoServizio(i3);
                if (as.getServizioComposto() == null) {
                    asServiziNonComposti.add(as);
                    continue;
                }
                this.log.info((Object)("Accordo di Servizio Composto " + IDAccordo.getUriFromAccordo(as) + " eliminazione in corso..."));
                if (this.gestoreCRUD.existsAccordoServizio(IDAccordo.getIDAccordoFromAccordo(as))) {
                    this.gestoreCRUD.deleteAccordoServizio(((IDriverRegistroServiziGet)((Object)this.gestoreCRUD)).getAccordoServizio(IDAccordo.getIDAccordoFromAccordo(as)));
                }
                this.log.info((Object)("Accordo di Servizio Composto " + IDAccordo.getUriFromAccordo(as) + " eliminato"));
            }
            while (asServiziNonComposti.size() > 0) {
                AccordoServizio as = (AccordoServizio)asServiziNonComposti.remove(0);
                this.log.info((Object)("Accordo di Servizio " + IDAccordo.getUriFromAccordo(as) + " eliminazione in corso..."));
                if (this.gestoreCRUD.existsAccordoServizio(IDAccordo.getIDAccordoFromAccordo(as))) {
                    this.gestoreCRUD.deleteAccordoServizio(((IDriverRegistroServiziGet)((Object)this.gestoreCRUD)).getAccordoServizio(IDAccordo.getIDAccordoFromAccordo(as)));
                }
                this.log.info((Object)("Accordo di Servizio " + IDAccordo.getUriFromAccordo(as) + " eliminato"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DriverRegistroServiziException("Errore durante l'eliminazione degli accordi: " + e.getMessage(), e);
        }
        try {
            for (i = 0; i < this.sorgenteRegistro.sizeAccordoCooperazioneList(); ++i) {
                AccordoCooperazione ac = this.sorgenteRegistro.getAccordoCooperazione(i);
                this.log.info((Object)("Accordo di Cooperazione " + IDAccordoCooperazione.getUriFromAccordo(ac) + " eliminazione in corso..."));
                if (this.gestoreCRUD.existsAccordoCooperazione(IDAccordoCooperazione.getIDAccordoFromAccordo(ac))) {
                    this.gestoreCRUD.deleteAccordoCooperazione(((IDriverRegistroServiziGet)((Object)this.gestoreCRUD)).getAccordoCooperazione(IDAccordoCooperazione.getIDAccordoFromAccordo(ac)));
                }
                this.log.info((Object)("Accordo di Cooperazione " + IDAccordoCooperazione.getUriFromAccordo(ac) + " eliminato"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DriverRegistroServiziException("Errore durante l'eliminazione degli accordi di cooperazione: " + e.getMessage(), e);
        }
        if (deleteSoggetti) {
            try {
                for (i = 0; i < this.sorgenteRegistro.sizeSoggettoSpcoopList(); ++i) {
                    SoggettoSpcoop soggetto2 = this.sorgenteRegistro.getSoggettoSpcoop(i);
                    IDSoggetto idSoggetto2 = new IDSoggetto(soggetto2.getTipo(), soggetto2.getNome());
                    this.log.info((Object)("Soggetto " + soggetto2.getTipo() + "/" + soggetto2.getNome() + " eliminazione in corso..."));
                    if (this.gestoreCRUD.existsSoggetto(idSoggetto2)) {
                        this.gestoreCRUD.deleteSoggetto(((IDriverRegistroServiziGet)((Object)this.gestoreCRUD)).getSoggettoRegistro(idSoggetto2));
                    }
                    this.log.info((Object)("Soggetto " + soggetto2.getTipo() + "/" + soggetto2.getNome() + " eliminato."));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new DriverRegistroServiziException("Errore durante l'eliminazione dei soggetti: " + e.getMessage(), e);
            }
            try {
                for (i = 0; i < this.sorgenteRegistro.sizePortaDominioList(); ++i) {
                    PortaDominio pdd = this.sorgenteRegistro.getPortaDominio(i);
                    this.log.info((Object)("Porta di Dominio " + pdd.getNome() + " eliminazione in corso..."));
                    if (this.gestoreCRUD.existsPortaDominio(pdd.getNome())) {
                        this.gestoreCRUD.deletePortaDominio(((IDriverRegistroServiziGet)((Object)this.gestoreCRUD)).getPortaDominio(pdd.getNome()));
                    }
                    this.log.info((Object)("Porta di Dominio " + pdd.getNome() + " eliminata."));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new DriverRegistroServiziException("Errore durante l'eliminazione delle porte di dominio: " + e.getMessage(), e);
            }
        }
    }

    private byte[] gestioneBytesDocumenti_Wsdl_Wsbl(String documento) throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        if (documento != null && !documento.equals("http://undefined")) {
            if (documento.startsWith("http://") || documento.startsWith("file://")) {
                byte[] file = HttpUtilities.requestHTTPFile(documento);
                if (file == null) {
                    throw new Exception("byte[] is null");
                }
                bout.write(file);
            } else {
                File f = new File(documento);
                if (f.exists()) {
                    FileInputStream file = new FileInputStream(f);
                    byte[] reads = new byte[65536];
                    int letti = 0;
                    while ((letti = file.read(reads)) >= 0) {
                        bout.write(reads, 0, letti);
                    }
                } else if (this.parentFile != null) {
                    File fWithParent = new File(this.parentFile, documento);
                    if (fWithParent.exists()) {
                        FileInputStream file = new FileInputStream(fWithParent);
                        byte[] reads = new byte[65536];
                        int letti = 0;
                        while ((letti = file.read(reads)) >= 0) {
                            bout.write(reads, 0, letti);
                        }
                    }
                } else {
                    throw new Exception("File [" + documento + "] non esistente");
                }
            }
            bout.flush();
            bout.close();
            if (bout.size() > 0) {
                return bout.toByteArray();
            }
        }
        return null;
    }

    private void initializeWSDLBytes(AccordoServizio as) throws DriverRegistroServiziException {
        String uriAS = IDAccordo.getUriFromAccordo(as);
        if (as.getWsdlDefinitorio() != null) {
            try {
                as.setByteWsdlDefinitorio(this.gestioneBytesDocumenti_Wsdl_Wsbl(as.getWsdlDefinitorio()));
            }
            catch (Exception e) {
                this.log.warn((Object)("Accordo di Servizio " + uriAS + ", lettura wsdl definitorio [" + as.getWsdlDefinitorio() + "] non riuscita:"), (Throwable)e);
            }
        }
        if (as.getWsdlConcettuale() != null) {
            try {
                as.setByteWsdlConcettuale(this.gestioneBytesDocumenti_Wsdl_Wsbl(as.getWsdlConcettuale()));
            }
            catch (Exception e) {
                this.log.warn((Object)("Accordo di Servizio " + uriAS + ", lettura wsdl concettuale [" + as.getWsdlConcettuale() + "] non riuscita:"), (Throwable)e);
            }
        }
        if (as.getWsdlLogicoErogatore() != null) {
            try {
                as.setByteWsdlLogicoErogatore(this.gestioneBytesDocumenti_Wsdl_Wsbl(as.getWsdlLogicoErogatore()));
            }
            catch (Exception e) {
                this.log.warn((Object)("Accordo di Servizio " + uriAS + ", lettura wsdl logico erogatore [" + as.getWsdlLogicoErogatore() + "] non riuscita:"), (Throwable)e);
            }
        }
        if (as.getWsdlLogicoFruitore() != null) {
            try {
                as.setByteWsdlLogicoFruitore(this.gestioneBytesDocumenti_Wsdl_Wsbl(as.getWsdlLogicoFruitore()));
            }
            catch (Exception e) {
                this.log.warn((Object)("Accordo di Servizio " + uriAS + ", lettura wsdl logico fruitore [" + as.getWsdlLogicoFruitore() + "] non riuscita:"), (Throwable)e);
            }
        }
    }

    private void initializeWSBLBytes(AccordoServizio as) throws DriverRegistroServiziException {
        String uriAS = IDAccordo.getUriFromAccordo(as);
        if (as.getWsblConcettuale() != null) {
            try {
                as.setByteWsblConcettuale(this.gestioneBytesDocumenti_Wsdl_Wsbl(as.getWsblConcettuale()));
            }
            catch (Exception e) {
                this.log.warn((Object)("Accordo di Servizio " + uriAS + ", lettura wsbl concettuale [" + as.getWsblConcettuale() + "] non riuscita:"), (Throwable)e);
            }
        }
        if (as.getWsblLogicoErogatore() != null) {
            try {
                as.setByteWsblLogicoErogatore(this.gestioneBytesDocumenti_Wsdl_Wsbl(as.getWsblLogicoErogatore()));
            }
            catch (Exception e) {
                this.log.warn((Object)("Accordo di Servizio " + uriAS + ", lettura wsbl logico erogatore [" + as.getWsblLogicoErogatore() + "] non riuscita:"), (Throwable)e);
            }
        }
        if (as.getWsblLogicoFruitore() != null) {
            try {
                as.setByteWsblLogicoFruitore(this.gestioneBytesDocumenti_Wsdl_Wsbl(as.getWsblLogicoFruitore()));
            }
            catch (Exception e) {
                this.log.warn((Object)("Accordo di Servizio " + uriAS + ", lettura wsbl logico fruitore [" + as.getWsblLogicoFruitore() + "] non riuscita:"), (Throwable)e);
            }
        }
    }

    private void initializeCatalogoSchemiOntologie(AccordoServizio as) throws DriverRegistroServiziException {
        String uriAS = IDAccordo.getUriFromAccordo(as);
        if (as.getCatalogoSchemiOntologie() != null) {
            try {
                as.setByteCatalogoSchemiOntologie(this.gestioneBytesDocumenti_Wsdl_Wsbl(as.getCatalogoSchemiOntologie()));
            }
            catch (Exception e) {
                this.log.warn((Object)("Accordo di Servizio " + uriAS + ", lettura catalogo schemi ontologie [" + as.getCatalogoSchemiOntologie() + "] non riuscita:"), (Throwable)e);
            }
        }
    }

    private void initializeWSDLBytes(ServizioSpcoop s) {
        if (s.getWsdlImplementativoErogatore() != null) {
            try {
                s.setByteWsdlImplementativoErogatore(this.gestioneBytesDocumenti_Wsdl_Wsbl(s.getWsdlImplementativoErogatore()));
            }
            catch (Exception e) {
                this.log.warn((Object)("Servizio " + s.getTipo() + s.getNome() + ", lettura wsdl implementativo erogatore [" + s.getWsdlImplementativoErogatore() + "] non riuscita:"), (Throwable)e);
            }
        }
        if (s.getWsdlImplementativoFruitore() != null) {
            try {
                s.setByteWsdlImplementativoFruitore(this.gestioneBytesDocumenti_Wsdl_Wsbl(s.getWsdlImplementativoFruitore()));
            }
            catch (Exception e) {
                this.log.warn((Object)("Servizio " + s.getTipo() + s.getNome() + ", lettura wsdl implementativo fruitore [" + s.getWsdlImplementativoFruitore() + "] non riuscita:"), (Throwable)e);
            }
        }
    }

    private byte[] readDocumento(String fileName) throws DriverRegistroServiziException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            if (fileName.startsWith("http://") || fileName.startsWith("file://")) {
                byte[] file = HttpUtilities.requestHTTPFile(fileName);
                if (file == null) {
                    throw new Exception("byte[] is null");
                }
                bout.write(file);
            } else {
                File f = new File(fileName);
                if (f.exists()) {
                    FileInputStream file = new FileInputStream(f);
                    byte[] reads = new byte[65536];
                    int letti = 0;
                    while ((letti = file.read(reads)) >= 0) {
                        bout.write(reads, 0, letti);
                    }
                } else if (this.parentFile != null) {
                    File fWithParent = new File(this.parentFile, fileName);
                    if (fWithParent.exists()) {
                        FileInputStream file = new FileInputStream(fWithParent);
                        byte[] reads = new byte[65536];
                        int letti = 0;
                        while ((letti = file.read(reads)) >= 0) {
                            bout.write(reads, 0, letti);
                        }
                    }
                } else {
                    throw new Exception("File [" + fileName + "] non esistente");
                }
            }
            bout.flush();
            bout.close();
            if (bout.size() > 0) {
                return bout.toByteArray();
            }
        }
        catch (Exception e) {
            this.log.warn((Object)("File " + fileName + ", lettura documento non riuscita:"), (Throwable)e);
        }
        throw new DriverRegistroServiziException("Contenuto non letto??");
    }

    private void gestioneDefaultConnettoreHTTP(Connettore connettore) {
        if (connettore.getProperties() != null) {
            ConnettoreProperty cp;
            if (!connettore.getProperties().containsKey("trustStoreType")) {
                cp = new ConnettoreProperty();
                cp.setNome("trustStoreType");
                cp.setValore("jks");
                connettore.addProperty(cp);
            }
            if (!connettore.getProperties().containsKey("trustManagementAlgorithm")) {
                cp = new ConnettoreProperty();
                cp.setNome("trustManagementAlgorithm");
                cp.setValore(TrustManagerFactory.getDefaultAlgorithm());
                connettore.addProperty(cp);
            }
            if (connettore.getProperties().containsKey("keyStoreLocation")) {
                if (!connettore.getProperties().containsKey("keyStoreType")) {
                    cp = new ConnettoreProperty();
                    cp.setNome("keyStoreType");
                    cp.setValore("jks");
                    connettore.addProperty(cp);
                }
                if (!connettore.getProperties().containsKey("keyManagementAlgorithm")) {
                    cp = new ConnettoreProperty();
                    cp.setNome("keyManagementAlgorithm");
                    cp.setValore(KeyManagerFactory.getDefaultAlgorithm());
                    connettore.addProperty(cp);
                }
            }
        }
    }

    private void gestioneSoggetto(SoggettoSpcoop soggetto, boolean reset, boolean aggiornamentoSoggetti, String pddOperativaCtrlstatSinglePdd) throws Exception {
        soggetto.setSuperUser(this.superUser);
        IDSoggetto idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
        if ("db".equals(this.tipoBEDestinazione)) {
            if (soggetto.getConnettore() != null) {
                soggetto.getConnettore().setNome(null);
                String tipoConnettore = soggetto.getConnettore().getTipo();
                if (!(TipiConnettore.JMS.getNome().equals(tipoConnettore) || TipiConnettore.HTTP.getNome().equals(tipoConnettore) || TipiConnettore.DISABILITATO.getNome().equals(tipoConnettore) || TipiConnettore.NULL.getNome().equals(tipoConnettore) || TipiConnettore.NULLECHO.getNome().equals(tipoConnettore))) {
                    soggetto.getConnettore().setCustom(true);
                }
                if (TipiConnettore.HTTPS.getNome().equals(tipoConnettore)) {
                    this.gestioneDefaultConnettoreHTTP(soggetto.getConnettore());
                }
            }
            if (soggetto.getIdentificativoPorta() == null || "".equals(soggetto.getIdentificativoPorta())) {
                soggetto.setIdentificativoPorta(soggetto.getNome() + "SPCoopIT");
            }
            if (soggetto.getCodiceIpa() == null || "".equals(soggetto.getCodiceIpa())) {
                soggetto.setCodiceIpa(SICAtoOpenSPCoopUtilities.buildIDSoggettoSica(idSoggetto, false));
            }
            if (pddOperativaCtrlstatSinglePdd != null && soggetto.getPortaDominio() == null) {
                soggetto.setPortaDominio(pddOperativaCtrlstatSinglePdd);
            }
        }
        if (!reset && this.gestoreCRUD.existsSoggetto(idSoggetto)) {
            if (aggiornamentoSoggetti) {
                this.log.info((Object)("Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " aggiornamento in corso..."));
                SoggettoSpcoop old = ((IDriverRegistroServiziGet)((Object)this.gestoreCRUD)).getSoggettoRegistro(idSoggetto);
                if (soggetto.getConnettore() == null) {
                    soggetto.setConnettore(old.getConnettore());
                } else {
                    soggetto.getConnettore().setId(old.getConnettore().getId());
                    soggetto.getConnettore().setNome(old.getConnettore().getNome());
                }
                this.gestoreCRUD.updateSoggetto(soggetto);
                this.log.info((Object)("Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " aggiornato."));
            }
        } else {
            this.log.info((Object)("Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " creazione in corso..."));
            this.gestoreCRUD.createSoggetto(soggetto);
            this.log.info((Object)("Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " creato."));
        }
    }

    private void gestioneAccordoCooperazione(AccordoCooperazione ac, boolean reset) throws Exception {
        int index;
        String name;
        String fileName;
        int k;
        ac.setSuperUser(this.superUser);
        for (k = 0; k < ac.sizeAllegatoList(); ++k) {
            name = fileName = ac.getAllegato(k).getFile();
            index = name.lastIndexOf(File.separatorChar);
            if (fileName.startsWith("http://")) {
                index = name.lastIndexOf("/");
            }
            if (index > 0) {
                name = name.substring(index + 1, name.length());
            }
            ac.getAllegato(k).setByteContenuto(this.readDocumento(fileName));
            ac.getAllegato(k).setFile(name);
            ac.getAllegato(k).setRuolo(RuoliDocumento.allegato.toString());
            ac.getAllegato(k).setTipoProprietarioDocumento(ProprietariDocumento.accordoCooperazione.toString());
        }
        for (k = 0; k < ac.sizeSpecificaSemiformaleList(); ++k) {
            name = fileName = ac.getSpecificaSemiformale(k).getFile();
            index = name.lastIndexOf(File.separatorChar);
            if (fileName.startsWith("http://")) {
                index = name.lastIndexOf("/");
            }
            if (index > 0) {
                name = name.substring(index + 1, name.length());
            }
            ac.getSpecificaSemiformale(k).setByteContenuto(this.readDocumento(fileName));
            ac.getSpecificaSemiformale(k).setFile(name);
            ac.getSpecificaSemiformale(k).setRuolo(RuoliDocumento.specificaSemiformale.toString());
            ac.getSpecificaSemiformale(k).setTipoProprietarioDocumento(ProprietariDocumento.accordoCooperazione.toString());
        }
        IDAccordoCooperazione idAccordo = IDAccordoCooperazione.getIDAccordoFromValues(ac.getNome(), ac.getVersione());
        String uriAC = IDAccordoCooperazione.getUriFromIDAccordo(idAccordo);
        if (!reset && this.gestoreCRUD.existsAccordoCooperazione(idAccordo)) {
            this.log.info((Object)("Accordo di Cooperazione " + uriAC + " aggiornamento in corso..."));
            this.gestoreCRUD.updateAccordoCooperazione(ac);
            this.log.info((Object)("Accordo di Cooperazione " + uriAC + " aggiornato"));
        } else {
            this.log.info((Object)("Accordo di Cooperazione " + uriAC + " creazione in corso..."));
            this.gestoreCRUD.createAccordoCooperazione(ac);
            this.log.info((Object)("Accordo di Cooperazione " + uriAC + " creato."));
        }
    }

    private void gestioneAccordoServizio(AccordoServizio as, boolean reset) throws Exception {
        int index;
        String name;
        int k;
        as.setSuperUser(this.superUser);
        if ("db".equals(this.tipoBEDestinazione)) {
            int k2;
            String profiloCollaborazione = as.getProfiloCollaborazione();
            for (k2 = 0; k2 < as.sizeAzioneList(); ++k2) {
                if (as.getAzione(k2).getConfermaRicezione() != null || as.getAzione(k2).getConsegnaInOrdine() != null || as.getAzione(k2).getFiltroDuplicati() != null || as.getAzione(k2).getIdCollaborazione() != null || as.getAzione(k2).getProfiloCollaborazione() != null || as.getAzione(k2).getScadenza() != null) {
                    as.getAzione(k2).setProfAzione("ridefinito");
                } else {
                    as.getAzione(k2).setProfAzione("default");
                }
                if (as.getAzione(k2).getProfiloCollaborazione() != null) continue;
                as.getAzione(k2).setProfiloCollaborazione(profiloCollaborazione);
            }
            for (k2 = 0; k2 < as.sizePortTypeList(); ++k2) {
                PortType pt = as.getPortType(k2);
                if (pt.getConfermaRicezione() != null || pt.getConsegnaInOrdine() != null || pt.getFiltroDuplicati() != null || pt.getIdCollaborazione() != null || pt.getProfiloCollaborazione() != null || pt.getScadenza() != null) {
                    pt.setProfiloPT("ridefinito");
                } else {
                    pt.setProfiloPT("default");
                }
                if (pt.getProfiloCollaborazione() == null) {
                    pt.setProfiloCollaborazione(profiloCollaborazione);
                }
                for (int l = 0; l < pt.sizeAzioneList(); ++l) {
                    Operation op = pt.getAzione(l);
                    if (op.getConfermaRicezione() != null || op.getConsegnaInOrdine() != null || op.getFiltroDuplicati() != null || op.getIdCollaborazione() != null || op.getProfiloCollaborazione() != null || op.getScadenza() != null) {
                        op.setProfAzione("ridefinito");
                    } else {
                        op.setProfAzione("default");
                    }
                    if (op.getProfiloCollaborazione() != null) continue;
                    op.setProfiloCollaborazione(pt.getProfiloCollaborazione());
                }
            }
        }
        this.initializeWSDLBytes(as);
        this.initializeWSBLBytes(as);
        this.initializeCatalogoSchemiOntologie(as);
        for (k = 0; k < as.sizeAllegatoList(); ++k) {
            String fileName;
            name = fileName = as.getAllegato(k).getFile();
            index = name.lastIndexOf(File.separatorChar);
            if (fileName.startsWith("http://")) {
                index = name.lastIndexOf("/");
            }
            if (index > 0) {
                name = name.substring(index + 1, name.length());
            }
            as.getAllegato(k).setByteContenuto(this.readDocumento(fileName));
            as.getAllegato(k).setFile(name);
            as.getAllegato(k).setRuolo(RuoliDocumento.allegato.toString());
            as.getAllegato(k).setTipoProprietarioDocumento(ProprietariDocumento.accordoServizio.toString());
        }
        for (k = 0; k < as.sizeSpecificaSemiformaleList(); ++k) {
            String fileName;
            name = fileName = as.getSpecificaSemiformale(k).getFile();
            index = name.lastIndexOf(File.separatorChar);
            if (fileName.startsWith("http://")) {
                index = name.lastIndexOf("/");
            }
            if (index > 0) {
                name = name.substring(index + 1, name.length());
            }
            as.getSpecificaSemiformale(k).setByteContenuto(this.readDocumento(fileName));
            as.getSpecificaSemiformale(k).setFile(name);
            as.getSpecificaSemiformale(k).setRuolo(RuoliDocumento.specificaSemiformale.toString());
            as.getSpecificaSemiformale(k).setTipoProprietarioDocumento(ProprietariDocumento.accordoServizio.toString());
        }
        if (as.getServizioComposto() != null) {
            for (k = 0; k < as.getServizioComposto().sizeSpecificaCoordinamentoList(); ++k) {
                String fileName;
                name = fileName = as.getServizioComposto().getSpecificaCoordinamento(k).getFile();
                index = name.lastIndexOf(File.separatorChar);
                if (fileName.startsWith("http://")) {
                    index = name.lastIndexOf("/");
                }
                if (index > 0) {
                    name = name.substring(index + 1, name.length());
                }
                as.getServizioComposto().getSpecificaCoordinamento(k).setByteContenuto(this.readDocumento(fileName));
                as.getServizioComposto().getSpecificaCoordinamento(k).setFile(name);
                as.getServizioComposto().getSpecificaCoordinamento(k).setRuolo(RuoliDocumento.specificaCoordinamento.toString());
                as.getServizioComposto().getSpecificaCoordinamento(k).setTipoProprietarioDocumento(ProprietariDocumento.accordoServizio.toString());
            }
        }
        IDAccordo idAccordo = IDAccordo.getIDAccordoFromValues(as.getNome(), BeanUtilities.getSoggettoReferenteID(as.getSoggettoReferente()), as.getVersione());
        String uriAS = IDAccordo.getUriFromIDAccordo(idAccordo);
        if (!reset && this.gestoreCRUD.existsAccordoServizio(idAccordo)) {
            this.log.info((Object)("Accordo di Servizio " + uriAS + " aggiornamento in corso..."));
            this.gestoreCRUD.updateAccordoServizio(as);
            this.log.info((Object)("Accordo di Servizio " + uriAS + " aggiornato"));
        } else {
            this.log.info((Object)("Accordo di Servizio " + uriAS + " creazione in corso..."));
            this.gestoreCRUD.createAccordoServizio(as);
            this.log.info((Object)("Accordo di Servizio " + uriAS + " creato."));
        }
    }

    private void gestioneServizioSPCoop(ServizioSpcoop servizio, SoggettoSpcoop soggetto, boolean reset, boolean mantieniFruitoriEsistenti, StatiAccordo statoAccordo) throws Exception {
        int index;
        String name;
        String fileName;
        int k;
        servizio.setSuperUser(this.superUser);
        servizio.setTipoSoggettoErogatore(soggetto.getTipo());
        servizio.setNomeSoggettoErogatore(soggetto.getNome());
        if ("db".equals(this.tipoBEDestinazione)) {
            String tipoConnettore;
            if (servizio.getConnettore() != null) {
                servizio.getConnettore().setNome(null);
                String tipoConnettore2 = servizio.getConnettore().getTipo();
                if (!(TipiConnettore.JMS.getNome().equals(tipoConnettore2) || TipiConnettore.HTTP.getNome().equals(tipoConnettore2) || TipiConnettore.DISABILITATO.getNome().equals(tipoConnettore2) || TipiConnettore.NULL.getNome().equals(tipoConnettore2) || TipiConnettore.NULLECHO.getNome().equals(tipoConnettore2))) {
                    servizio.getConnettore().setCustom(true);
                }
                if (TipiConnettore.HTTPS.getNome().equals(tipoConnettore2)) {
                    this.gestioneDefaultConnettoreHTTP(servizio.getConnettore());
                }
            }
            for (k = 0; k < servizio.sizeFruitoreList(); ++k) {
                if (servizio.getFruitore(k).getConnettore() == null) continue;
                servizio.getFruitore(k).getConnettore().setNome(null);
                tipoConnettore = servizio.getFruitore(k).getConnettore().getTipo();
                if (!(TipiConnettore.JMS.getNome().equals(tipoConnettore) || TipiConnettore.HTTP.getNome().equals(tipoConnettore) || TipiConnettore.DISABILITATO.getNome().equals(tipoConnettore) || TipiConnettore.NULL.getNome().equals(tipoConnettore) || TipiConnettore.NULLECHO.getNome().equals(tipoConnettore))) {
                    servizio.getFruitore(k).getConnettore().setCustom(true);
                }
                if (!TipiConnettore.HTTPS.getNome().equals(tipoConnettore)) continue;
                this.gestioneDefaultConnettoreHTTP(servizio.getFruitore(k).getConnettore());
            }
            for (k = 0; k < servizio.sizeAzioneList(); ++k) {
                if (servizio.getAzione(k).getConnettore() == null) continue;
                servizio.getAzione(k).getConnettore().setNome(null);
                tipoConnettore = servizio.getAzione(k).getConnettore().getTipo();
                if (!(TipiConnettore.JMS.getNome().equals(tipoConnettore) || TipiConnettore.HTTP.getNome().equals(tipoConnettore) || TipiConnettore.DISABILITATO.getNome().equals(tipoConnettore) || TipiConnettore.NULL.getNome().equals(tipoConnettore) || TipiConnettore.NULLECHO.getNome().equals(tipoConnettore))) {
                    servizio.getAzione(k).getConnettore().setCustom(true);
                }
                if (!TipiConnettore.HTTPS.getNome().equals(tipoConnettore)) continue;
                this.gestioneDefaultConnettoreHTTP(servizio.getAzione(k).getConnettore());
            }
        }
        this.initializeWSDLBytes(servizio);
        for (k = 0; k < servizio.sizeAllegatoList(); ++k) {
            name = fileName = servizio.getAllegato(k).getFile();
            index = name.lastIndexOf(File.separatorChar);
            if (fileName.startsWith("http://")) {
                index = name.lastIndexOf("/");
            }
            if (index > 0) {
                name = name.substring(index + 1, name.length());
            }
            servizio.getAllegato(k).setByteContenuto(this.readDocumento(fileName));
            servizio.getAllegato(k).setFile(name);
            servizio.getAllegato(k).setRuolo(RuoliDocumento.allegato.toString());
            servizio.getAllegato(k).setTipoProprietarioDocumento(ProprietariDocumento.servizio.toString());
        }
        for (k = 0; k < servizio.sizeSpecificaSemiformaleList(); ++k) {
            name = fileName = servizio.getSpecificaSemiformale(k).getFile();
            index = name.lastIndexOf(File.separatorChar);
            if (fileName.startsWith("http://")) {
                index = name.lastIndexOf("/");
            }
            if (index > 0) {
                name = name.substring(index + 1, name.length());
            }
            servizio.getSpecificaSemiformale(k).setByteContenuto(this.readDocumento(fileName));
            servizio.getSpecificaSemiformale(k).setFile(name);
            servizio.getSpecificaSemiformale(k).setRuolo(RuoliDocumento.specificaSemiformale.toString());
            servizio.getSpecificaSemiformale(k).setTipoProprietarioDocumento(ProprietariDocumento.servizio.toString());
        }
        for (k = 0; k < servizio.sizeSpecificaLivelloServizioList(); ++k) {
            name = fileName = servizio.getSpecificaLivelloServizio(k).getFile();
            index = name.lastIndexOf(File.separatorChar);
            if (fileName.startsWith("http://")) {
                index = name.lastIndexOf("/");
            }
            if (index > 0) {
                name = name.substring(index + 1, name.length());
            }
            servizio.getSpecificaLivelloServizio(k).setByteContenuto(this.readDocumento(fileName));
            servizio.getSpecificaLivelloServizio(k).setFile(name);
            servizio.getSpecificaLivelloServizio(k).setRuolo(RuoliDocumento.specificaLivelloServizio.toString());
            servizio.getSpecificaLivelloServizio(k).setTipoProprietarioDocumento(ProprietariDocumento.servizio.toString());
        }
        for (k = 0; k < servizio.sizeSpecificaSicurezzaList(); ++k) {
            name = fileName = servizio.getSpecificaSicurezza(k).getFile();
            index = name.lastIndexOf(File.separatorChar);
            if (fileName.startsWith("http://")) {
                index = name.lastIndexOf("/");
            }
            if (index > 0) {
                name = name.substring(index + 1, name.length());
            }
            servizio.getSpecificaSicurezza(k).setByteContenuto(this.readDocumento(fileName));
            servizio.getSpecificaSicurezza(k).setFile(name);
            servizio.getSpecificaSicurezza(k).setRuolo(RuoliDocumento.specificaSicurezza.toString());
            servizio.getSpecificaSicurezza(k).setTipoProprietarioDocumento(ProprietariDocumento.servizio.toString());
        }
        IDSoggetto idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
        IDServizio idServizio = new IDServizio(idSoggetto, servizio.getTipo(), servizio.getNome());
        if (!reset && this.gestoreCRUD.existsServizioSpcoop(idServizio) || this.gestoreCRUD.existsServizioSpcoopCorrelato(idServizio)) {
            ServizioSpcoop old;
            this.log.info((Object)("Servizio " + servizio.getTipo() + "/" + servizio.getNome() + " erogato da " + soggetto.getTipo() + "/" + soggetto.getNome() + " aggiornamento in corso..."));
            if (this.gestoreCRUD.existsServizioSpcoopCorrelato(idServizio)) {
                old = ((IDriverRegistroServiziGet)((Object)this.gestoreCRUD)).getServizioCorrelato(idServizio);
                if (servizio.getConnettore() == null) {
                    servizio.setConnettore(old.getConnettore());
                } else {
                    servizio.getConnettore().setId(old.getConnettore().getId());
                    servizio.getConnettore().setNome(old.getConnettore().getNome());
                }
                if (mantieniFruitoriEsistenti) {
                    this.mantieniFruitori(old, servizio);
                }
                if ("db".equals(this.tipoBEDestinazione)) {
                    this.aggiornatoStatoFruitori(servizio, statoAccordo);
                }
                this.gestoreCRUD.updateServizioSpcoopCorrelato(servizio);
            } else {
                old = ((IDriverRegistroServiziGet)((Object)this.gestoreCRUD)).getServizio(idServizio);
                if (servizio.getConnettore() == null) {
                    servizio.setConnettore(old.getConnettore());
                } else {
                    servizio.getConnettore().setId(old.getConnettore().getId());
                    servizio.getConnettore().setNome(old.getConnettore().getNome());
                }
                if (mantieniFruitoriEsistenti) {
                    this.mantieniFruitori(old, servizio);
                }
                if ("db".equals(this.tipoBEDestinazione)) {
                    this.aggiornatoStatoFruitori(servizio, statoAccordo);
                }
                this.gestoreCRUD.updateServizioSpcoop(servizio);
            }
            this.log.info((Object)("Servizio " + servizio.getTipo() + "/" + servizio.getNome() + " erogato da " + soggetto.getTipo() + "/" + soggetto.getNome() + " aggiornato."));
        } else {
            this.log.info((Object)("Servizio " + servizio.getTipo() + "/" + servizio.getNome() + " erogato da " + soggetto.getTipo() + "/" + soggetto.getNome() + " creazione in corso..."));
            if ("db".equals(this.tipoBEDestinazione)) {
                this.aggiornatoStatoFruitori(servizio, statoAccordo);
            }
            this.gestoreCRUD.createServizioSpcoop(servizio);
            this.log.info((Object)("Servizio " + servizio.getTipo() + "/" + servizio.getNome() + " erogato da " + soggetto.getTipo() + "/" + soggetto.getNome() + " creato."));
        }
    }

    private void gestioneServizioSPCoopCorrelato(ServizioSpcoop servizio, SoggettoSpcoop soggetto, boolean reset, boolean mantieniFruitoriEsistenti, StatiAccordo statoAccordo) throws Exception {
        int index;
        String name;
        String fileName;
        int k;
        servizio.setServizioCorrelato(true);
        servizio.setSuperUser(this.superUser);
        servizio.setTipoSoggettoErogatore(soggetto.getTipo());
        servizio.setNomeSoggettoErogatore(soggetto.getNome());
        if ("db".equals(this.tipoBEDestinazione)) {
            String tipoConnettore;
            if (servizio.getConnettore() != null) {
                servizio.getConnettore().setNome(null);
                String tipoConnettore2 = servizio.getConnettore().getTipo();
                if (!(TipiConnettore.JMS.getNome().equals(tipoConnettore2) || TipiConnettore.HTTP.getNome().equals(tipoConnettore2) || TipiConnettore.DISABILITATO.getNome().equals(tipoConnettore2) || TipiConnettore.NULL.getNome().equals(tipoConnettore2) || TipiConnettore.NULLECHO.getNome().equals(tipoConnettore2))) {
                    servizio.getConnettore().setCustom(true);
                }
                if (TipiConnettore.HTTPS.getNome().equals(tipoConnettore2)) {
                    this.gestioneDefaultConnettoreHTTP(servizio.getConnettore());
                }
            }
            for (k = 0; k < servizio.sizeFruitoreList(); ++k) {
                if (servizio.getFruitore(k).getConnettore() == null) continue;
                servizio.getFruitore(k).getConnettore().setNome(null);
                tipoConnettore = servizio.getFruitore(k).getConnettore().getTipo();
                if (!(TipiConnettore.JMS.getNome().equals(tipoConnettore) || TipiConnettore.HTTP.getNome().equals(tipoConnettore) || TipiConnettore.DISABILITATO.getNome().equals(tipoConnettore) || TipiConnettore.NULL.getNome().equals(tipoConnettore) || TipiConnettore.NULLECHO.getNome().equals(tipoConnettore))) {
                    servizio.getFruitore(k).getConnettore().setCustom(true);
                }
                if (!TipiConnettore.HTTPS.getNome().equals(tipoConnettore)) continue;
                this.gestioneDefaultConnettoreHTTP(servizio.getFruitore(k).getConnettore());
            }
            for (k = 0; k < servizio.sizeAzioneList(); ++k) {
                if (servizio.getAzione(k).getConnettore() == null) continue;
                servizio.getAzione(k).getConnettore().setNome(null);
                tipoConnettore = servizio.getAzione(k).getConnettore().getTipo();
                if (!(TipiConnettore.JMS.getNome().equals(tipoConnettore) || TipiConnettore.HTTP.getNome().equals(tipoConnettore) || TipiConnettore.DISABILITATO.getNome().equals(tipoConnettore) || TipiConnettore.NULL.getNome().equals(tipoConnettore) || TipiConnettore.NULLECHO.getNome().equals(tipoConnettore))) {
                    servizio.getAzione(k).getConnettore().setCustom(true);
                }
                if (!TipiConnettore.HTTPS.getNome().equals(tipoConnettore)) continue;
                this.gestioneDefaultConnettoreHTTP(servizio.getAzione(k).getConnettore());
            }
        }
        this.initializeWSDLBytes(servizio);
        for (k = 0; k < servizio.sizeAllegatoList(); ++k) {
            name = fileName = servizio.getAllegato(k).getFile();
            index = name.lastIndexOf(File.separatorChar);
            if (fileName.startsWith("http://")) {
                index = name.lastIndexOf("/");
            }
            if (index > 0) {
                name = name.substring(index + 1, name.length());
            }
            servizio.getAllegato(k).setByteContenuto(this.readDocumento(fileName));
            servizio.getAllegato(k).setFile(name);
            servizio.getAllegato(k).setRuolo(RuoliDocumento.allegato.toString());
            servizio.getAllegato(k).setTipoProprietarioDocumento(ProprietariDocumento.servizio.toString());
        }
        for (k = 0; k < servizio.sizeSpecificaSemiformaleList(); ++k) {
            name = fileName = servizio.getSpecificaSemiformale(k).getFile();
            index = name.lastIndexOf(File.separatorChar);
            if (fileName.startsWith("http://")) {
                index = name.lastIndexOf("/");
            }
            if (index > 0) {
                name = name.substring(index + 1, name.length());
            }
            servizio.getSpecificaSemiformale(k).setByteContenuto(this.readDocumento(fileName));
            servizio.getSpecificaSemiformale(k).setFile(name);
            servizio.getSpecificaSemiformale(k).setRuolo(RuoliDocumento.specificaSemiformale.toString());
            servizio.getSpecificaSemiformale(k).setTipoProprietarioDocumento(ProprietariDocumento.servizio.toString());
        }
        for (k = 0; k < servizio.sizeSpecificaLivelloServizioList(); ++k) {
            name = fileName = servizio.getSpecificaLivelloServizio(k).getFile();
            index = name.lastIndexOf(File.separatorChar);
            if (fileName.startsWith("http://")) {
                index = name.lastIndexOf("/");
            }
            if (index > 0) {
                name = name.substring(index + 1, name.length());
            }
            servizio.getSpecificaLivelloServizio(k).setByteContenuto(this.readDocumento(fileName));
            servizio.getSpecificaLivelloServizio(k).setFile(name);
            servizio.getSpecificaLivelloServizio(k).setRuolo(RuoliDocumento.specificaLivelloServizio.toString());
            servizio.getSpecificaLivelloServizio(k).setTipoProprietarioDocumento(ProprietariDocumento.servizio.toString());
        }
        for (k = 0; k < servizio.sizeSpecificaSicurezzaList(); ++k) {
            name = fileName = servizio.getSpecificaSicurezza(k).getFile();
            index = name.lastIndexOf(File.separatorChar);
            if (fileName.startsWith("http://")) {
                index = name.lastIndexOf("/");
            }
            if (index > 0) {
                name = name.substring(index + 1, name.length());
            }
            servizio.getSpecificaSicurezza(k).setByteContenuto(this.readDocumento(fileName));
            servizio.getSpecificaSicurezza(k).setFile(name);
            servizio.getSpecificaSicurezza(k).setRuolo(RuoliDocumento.specificaSicurezza.toString());
            servizio.getSpecificaSicurezza(k).setTipoProprietarioDocumento(ProprietariDocumento.servizio.toString());
        }
        IDSoggetto idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
        IDServizio idServizio = new IDServizio(idSoggetto, servizio.getTipo(), servizio.getNome());
        if (!reset && this.gestoreCRUD.existsServizioSpcoop(idServizio) || this.gestoreCRUD.existsServizioSpcoopCorrelato(idServizio)) {
            ServizioSpcoop old;
            this.log.info((Object)("ServizioCorrelato " + servizio.getTipo() + "/" + servizio.getNome() + " erogato da " + soggetto.getTipo() + "/" + soggetto.getNome() + " aggiornamento in corso..."));
            if (this.gestoreCRUD.existsServizioSpcoopCorrelato(idServizio)) {
                old = ((IDriverRegistroServiziGet)((Object)this.gestoreCRUD)).getServizioCorrelato(idServizio);
                if (servizio.getConnettore() == null) {
                    servizio.setConnettore(old.getConnettore());
                } else {
                    servizio.getConnettore().setId(old.getConnettore().getId());
                    servizio.getConnettore().setNome(old.getConnettore().getNome());
                }
                if (mantieniFruitoriEsistenti) {
                    this.mantieniFruitori(old, servizio);
                }
                if ("db".equals(this.tipoBEDestinazione)) {
                    this.aggiornatoStatoFruitori(servizio, statoAccordo);
                }
                this.gestoreCRUD.updateServizioSpcoopCorrelato(servizio);
            } else {
                old = ((IDriverRegistroServiziGet)((Object)this.gestoreCRUD)).getServizio(idServizio);
                if (servizio.getConnettore() == null) {
                    servizio.setConnettore(old.getConnettore());
                } else {
                    servizio.getConnettore().setId(old.getConnettore().getId());
                    servizio.getConnettore().setNome(old.getConnettore().getNome());
                }
                if (mantieniFruitoriEsistenti) {
                    this.mantieniFruitori(old, servizio);
                }
                if ("db".equals(this.tipoBEDestinazione)) {
                    this.aggiornatoStatoFruitori(servizio, statoAccordo);
                }
                this.gestoreCRUD.updateServizioSpcoop(servizio);
            }
            this.log.info((Object)("ServizioCorrelato " + servizio.getTipo() + "/" + servizio.getNome() + " erogato da " + soggetto.getTipo() + "/" + soggetto.getNome() + " aggiornato."));
        } else {
            this.log.info((Object)("ServizioCorrelato " + servizio.getTipo() + "/" + servizio.getNome() + " erogato da " + soggetto.getTipo() + "/" + soggetto.getNome() + " creazione in corso..."));
            if ("db".equals(this.tipoBEDestinazione)) {
                this.aggiornatoStatoFruitori(servizio, statoAccordo);
            }
            this.gestoreCRUD.createServizioSpcoopCorrelato(servizio);
            this.log.info((Object)("ServizioCorrelato " + servizio.getTipo() + "/" + servizio.getNome() + " erogato da " + soggetto.getTipo() + "/" + soggetto.getNome() + " creato."));
        }
    }
}

