/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.dao.registry.driver;

import it.gov.spcoop.sica.manifest.driver.TipiDocumentoCoordinamento;
import it.gov.spcoop.sica.manifest.driver.TipiDocumentoLivelloServizio;
import it.gov.spcoop.sica.manifest.driver.TipiDocumentoSemiformale;
import it.gov.spcoop.sica.manifest.driver.TipiDocumentoSicurezza;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.TipiConnettore;
import org.openspcoop.dao.registry.AccordoCooperazione;
import org.openspcoop.dao.registry.AccordoCooperazioneElencoPartecipantiSoggetto;
import org.openspcoop.dao.registry.AccordoCooperazioneSoggettoReferente;
import org.openspcoop.dao.registry.AccordoServizio;
import org.openspcoop.dao.registry.AccordoServizioServizioComposto;
import org.openspcoop.dao.registry.AccordoServizioServizioCompostoServizioComponente;
import org.openspcoop.dao.registry.AccordoServizioSoggettoReferente;
import org.openspcoop.dao.registry.Azione;
import org.openspcoop.dao.registry.Connettore;
import org.openspcoop.dao.registry.ConnettoreProperty;
import org.openspcoop.dao.registry.Documento;
import org.openspcoop.dao.registry.Fruitore;
import org.openspcoop.dao.registry.Message;
import org.openspcoop.dao.registry.MessagePart;
import org.openspcoop.dao.registry.Operation;
import org.openspcoop.dao.registry.PortType;
import org.openspcoop.dao.registry.PortaDominio;
import org.openspcoop.dao.registry.RegistroServizi;
import org.openspcoop.dao.registry.ServizioSpcoop;
import org.openspcoop.dao.registry.ServizioSpcoopAzione;
import org.openspcoop.dao.registry.ServizioSpcoopAzioneFruitore;
import org.openspcoop.dao.registry.SoggettoSpcoop;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziException;
import org.openspcoop.dao.registry.driver.IDAccordo;
import org.openspcoop.dao.registry.driver.IDAccordoCooperazione;
import org.openspcoop.dao.registry.driver.RuoliDocumento;
import org.openspcoop.utils.Utilities;
import org.openspcoop.utils.regexp.RegularExpressionEngine;

public class ValidazioneSemantica {
    private RegistroServizi registro = null;
    private List<String> errori = new ArrayList<String>();
    private Logger log = null;
    private boolean checkEsistenzaFileDefinitoTramiteURI = false;
    private List<String> tipoConnettori = new ArrayList<String>();
    private List<String> tipoSoggetti = new ArrayList<String>();
    private List<String> tipoServizi = new ArrayList<String>();

    private String getTipoConnettori() {
        StringBuffer bf = new StringBuffer();
        for (int i = 0; i < this.tipoConnettori.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoConnettori.get(i));
        }
        return bf.toString();
    }

    private String getTipoSoggetti() {
        StringBuffer bf = new StringBuffer();
        for (int i = 0; i < this.tipoSoggetti.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoSoggetti.get(i));
        }
        return bf.toString();
    }

    private String getTipoServizi() {
        StringBuffer bf = new StringBuffer();
        for (int i = 0; i < this.tipoServizi.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoServizi.get(i));
        }
        return bf.toString();
    }

    public ValidazioneSemantica(RegistroServizi registro, boolean checkEsistenzaFileDefinitoTramiteURI, String[] tipoConnettori, String[] tipoSoggetti, String[] tipoServizi, Logger log) throws DriverRegistroServiziException {
        int i;
        this.registro = registro;
        this.checkEsistenzaFileDefinitoTramiteURI = checkEsistenzaFileDefinitoTramiteURI;
        this.log = log;
        if (tipoConnettori != null && tipoConnettori.length > 0) {
            for (i = 0; i < tipoConnettori.length; ++i) {
                this.tipoConnettori.add(tipoConnettori[i]);
            }
        } else {
            throw new DriverRegistroServiziException("Tipo di connettori ammissibili non definiti");
        }
        if (tipoSoggetti != null && tipoSoggetti.length > 0) {
            for (i = 0; i < tipoSoggetti.length; ++i) {
                this.tipoSoggetti.add(tipoSoggetti[i]);
            }
        } else {
            throw new DriverRegistroServiziException("Tipo di soggetti ammissibili non definiti");
        }
        if (tipoServizi != null && tipoServizi.length > 0) {
            for (i = 0; i < tipoServizi.length; ++i) {
                this.tipoServizi.add(tipoServizi[i]);
            }
        } else {
            throw new DriverRegistroServiziException("Tipo di servizi ammissibili non definiti");
        }
    }

    public ValidazioneSemantica(RegistroServizi registro, boolean checkEsistenzaFileDefinitoTramiteURI, String[] tipoConnettori, String[] tipoSoggetti, String[] tipoServizi) throws DriverRegistroServiziException {
        this(registro, checkEsistenzaFileDefinitoTramiteURI, tipoConnettori, tipoSoggetti, tipoServizi, null);
    }

    private void printMsg(String msg) {
        if (this.log == null) {
            System.out.println(msg);
        } else {
            this.log.debug((Object)msg);
        }
    }

    public void validazioneSemantica(boolean showIDOggettiAnalizzati) throws DriverRegistroServiziException {
        int i;
        if (showIDOggettiAnalizzati) {
            this.printMsg("---------------------------------------AccordiCooperazione(" + this.registro.sizeAccordoCooperazioneList() + ")--------------------------------------------------");
        }
        for (i = 0; i < this.registro.sizeAccordoCooperazioneList(); ++i) {
            AccordoCooperazione ac = this.registro.getAccordoCooperazione(i);
            if (showIDOggettiAnalizzati) {
                this.printMsg("Accordo di cooperazione: " + IDAccordoCooperazione.getUriFromAccordo(ac));
            }
            this.validaAccordoCooperazione(ac);
        }
        if (showIDOggettiAnalizzati) {
            this.printMsg("\n\n------------------------------------AccordiServizio(" + this.registro.sizeAccordoServizioList() + ")-----------------------------------------------------");
        }
        for (i = 0; i < this.registro.sizeAccordoServizioList(); ++i) {
            AccordoServizio as = this.registro.getAccordoServizio(i);
            if (showIDOggettiAnalizzati) {
                this.printMsg("Accordo di servizio: " + IDAccordo.getUriFromAccordo(as));
            }
            this.validaAccordoServizio(as);
        }
        if (showIDOggettiAnalizzati) {
            this.printMsg("\n\n------------------------------------Soggetti(" + this.registro.sizeSoggettoSpcoopList() + ")-----------------------------------------------------");
        }
        for (i = 0; i < this.registro.sizeSoggettoSpcoopList(); ++i) {
            SoggettoSpcoop sogg = this.registro.getSoggettoSpcoop(i);
            if (showIDOggettiAnalizzati) {
                this.printMsg("Soggetto SPCoop: " + sogg.getTipo() + "/" + sogg.getNome());
            }
            this.validaSoggettoSpcoop(sogg, showIDOggettiAnalizzati);
        }
        if (showIDOggettiAnalizzati) {
            this.printMsg("\n\n------------------------------------Porte di Dominio(" + this.registro.sizePortaDominioList() + ")-----------------------------------------------------");
        }
        for (i = 0; i < this.registro.sizePortaDominioList(); ++i) {
            PortaDominio pd = this.registro.getPortaDominio(i);
            if (showIDOggettiAnalizzati) {
                this.printMsg("Porta di dominio: " + pd.getNome());
            }
            this.validaPortaDominio(pd);
        }
        if (showIDOggettiAnalizzati) {
            this.printMsg("\n\n------------------------------------Connettori(" + this.registro.sizeConnettoreList() + ")-----------------------------------------------------");
        }
        for (i = 0; i < this.registro.sizeConnettoreList(); ++i) {
            Connettore con = this.registro.getConnettore(i);
            if (showIDOggettiAnalizzati) {
                this.printMsg("Connettore: " + con.getNome());
            }
            this.validaConnettore(con, null, null);
        }
        if (showIDOggettiAnalizzati) {
            this.printMsg("\n\n-----------------------------------------------------------------------------------------");
        }
        if (!this.errori.isEmpty()) {
            StringBuffer stringB = new StringBuffer().append("\n");
            Iterator<String> itE = this.errori.iterator();
            while (itE.hasNext()) {
                stringB.append(itE.next()).append("\n");
            }
            throw new DriverRegistroServiziException(stringB.toString());
        }
    }

    private void validaAccordoCooperazione(AccordoCooperazione ac) throws DriverRegistroServiziException {
        int i;
        if (ac.getNome() == null) {
            this.errori.add("Esiste un accordo di cooperazione senza nome");
            return;
        }
        IDAccordoCooperazione idAccordoCooperazione = IDAccordoCooperazione.getIDAccordoFromAccordo(ac);
        String uriAC = IDAccordoCooperazione.getUriFromIDAccordo(idAccordoCooperazione);
        AccordoCooperazioneSoggettoReferente acsr = ac.getSoggettoReferente();
        if (acsr != null) {
            if (acsr.getTipo() == null) {
                this.errori.add("Tipo di un soggetto referente dell'accordo cooperazione " + uriAC + " non definito");
            } else if (acsr.getNome() == null) {
                this.errori.add("Nome di un soggetto referente dell'accordo cooperazione " + uriAC + " non definito");
            } else if (!this.existsSoggettoSPCoop(acsr.getTipo(), acsr.getNome())) {
                this.errori.add("Il soggetto referente [" + acsr.getTipo() + "/" + acsr.getNome() + "] dell'accordo cooperazione " + uriAC + " non corrisponde a nessuno dei soggetti registrati");
            }
        }
        for (i = 0; i < ac.sizeElencoPartecipantiList(); ++i) {
            AccordoCooperazioneElencoPartecipantiSoggetto partecipante = ac.getElencoPartecipanti(i);
            if (partecipante.getTipo() == null) {
                this.errori.add("Tipo di un soggetto partecipante dell'accordo cooperazione " + uriAC + " non definito");
                continue;
            }
            if (partecipante.getNome() == null) {
                this.errori.add("Nome di un soggetto partecipante dell'accordo cooperazione " + uriAC + " non definito");
                continue;
            }
            if (this.existsSoggettoSPCoop(partecipante.getTipo(), partecipante.getNome())) continue;
            this.errori.add("Il soggetto partecipante [" + partecipante.getTipo() + "/" + partecipante.getNome() + "] dell'accordo cooperazione " + uriAC + " non corrisponde a nessuno dei soggetti registrati");
        }
        if (ac.sizeElencoPartecipantiList() < 2) {
            this.errori.add("L'accordo di cooperazione [" + uriAC + "] non possiede il numero minimo di soggetti partecipanti (2)");
        }
        for (i = 0; i < ac.sizeAllegatoList(); ++i) {
            Documento allegato = ac.getAllegato(i);
            this.validateDocumento(allegato, RuoliDocumento.allegato, "accordoCooperazione[" + uriAC + "]");
        }
        for (i = 0; i < ac.sizeSpecificaSemiformaleList(); ++i) {
            Documento specificaSemiformale = ac.getSpecificaSemiformale(i);
            this.validateDocumento(specificaSemiformale, RuoliDocumento.specificaSemiformale, "accordoCooperazione[" + uriAC + "]");
        }
        try {
            if (!RegularExpressionEngine.isMatch(ac.getNome(), "^[0-9A-Za-z_\\-\\.]+$")) {
                this.errori.add("Il nome dell'accordo di cooperazione [" + uriAC + "] dev'essere formato solo caratteri, cifre, '_' , '-' e '.'");
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante l'analisi tramite espressione regolare del nome dell'accordo di cooperazione [" + uriAC + "]: " + e.getMessage(), e);
        }
        if (ac.getVersione() != null) {
            try {
                if (!RegularExpressionEngine.isMatch(ac.getVersione(), "^[1-9]+[0-9]*$")) {
                    this.errori.add("La versione dell'accordo di cooperazione [" + uriAC + "] dev'essere rappresentata da un numero intero");
                }
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("Errore durante l'analisi tramite espressione regolare della versione dell'accordo di cooperazione [" + uriAC + "]: " + e.getMessage(), e);
            }
        }
        int numAc = 0;
        for (int j = 0; j < this.registro.sizeAccordoCooperazioneList(); ++j) {
            AccordoCooperazione tmpAc = this.registro.getAccordoCooperazione(j);
            if (!IDAccordoCooperazione.getUriFromAccordo(ac).equals(IDAccordoCooperazione.getUriFromAccordo(tmpAc))) continue;
            ++numAc;
        }
        if (numAc > 1) {
            this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un accordo di cooperazione con uri " + uriAC);
        }
    }

    private void validaAccordoServizio(AccordoServizio as) throws DriverRegistroServiziException {
        String consOrd;
        String idColl;
        String confRic;
        int i;
        int j;
        if (as.getNome() == null) {
            this.errori.add("Esiste un accordo di servizio senza nome");
            return;
        }
        IDAccordo idAccordoServizio = IDAccordo.getIDAccordoFromAccordo(as);
        String uriAS = IDAccordo.getUriFromIDAccordo(idAccordoServizio);
        AccordoServizioServizioComposto assc = as.getServizioComposto();
        uriAS = assc != null ? "servizio composto [" + uriAS + "]" : "accordo di servizio [" + uriAS + "]";
        AccordoServizioSoggettoReferente assr = as.getSoggettoReferente();
        if (assr != null) {
            if (assr.getTipo() == null) {
                this.errori.add("Tipo di un soggetto referente nel " + uriAS + " non definito");
            } else if (assr.getNome() == null) {
                this.errori.add("Nome di un soggetto referente nel " + uriAS + " non definito");
            } else if (!this.existsSoggettoSPCoop(assr.getTipo(), assr.getNome())) {
                this.errori.add("Il soggetto referente [" + assr.getTipo() + "/" + assr.getNome() + "] nel " + uriAS + " non corrisponde a nessuno dei soggetti registrati");
            }
        }
        if (assc != null) {
            AccordoServizioServizioCompostoServizioComponente[] asscscArray = assc.getServizioComponenteList();
            for (j = 0; j < assc.sizeServizioComponenteList(); ++j) {
                AccordoServizioServizioCompostoServizioComponente asscsc = asscscArray[j];
                if (asscsc.getTipo() == null) {
                    this.errori.add("Tipo di un servizio componente nel " + uriAS + " non definito");
                } else if (asscsc.getNome() == null) {
                    this.errori.add("Nome di un servizio componente nel " + uriAS + " non definito");
                } else if (asscsc.getTipoSoggetto() == null) {
                    this.errori.add("Tipo dell'erogatore di un servizio componente nel " + uriAS + " non definito");
                } else if (asscsc.getNomeSoggetto() == null) {
                    this.errori.add("Nome dell'erogatore di un servizio componente nel " + uriAS + " non definito");
                } else if (!this.existsServizioSPCoop(asscsc.getTipo(), asscsc.getNome(), asscsc.getTipoSoggetto(), asscsc.getNomeSoggetto())) {
                    this.errori.add("Il servizio componente [" + asscsc.getTipo() + "/" + asscsc.getNome() + "] erogato dal soggetto [" + asscsc.getTipoSoggetto() + "/" + asscsc.getNomeSoggetto() + "], referenziato nel " + uriAS + ", non corrisponde a nessun servizio registrato");
                }
                if (asscsc.getAzione() == null) continue;
                ServizioSpcoop serv = this.getServizioSPCoop(asscsc.getTipo(), asscsc.getNome(), asscsc.getTipoSoggetto(), asscsc.getNomeSoggetto());
                if (this.existsAccordoServizio(serv.getAccordoServizio())) {
                    AccordoServizio asServizioComposto = this.getAccordoServizio(serv.getAccordoServizio());
                    if (serv.getPortType() != null) {
                        if (this.existsPortType_AccordoServizio(asServizioComposto, serv.getPortType())) {
                            PortType pt = this.getPortType_AccordoServizio(asServizioComposto, serv.getPortType());
                            if (this.existsAzione_PortType_AccordoServizio(pt, asscsc.getAzione())) continue;
                            this.errori.add("Il servizio componente [" + asscsc.getTipo() + "/" + asscsc.getNome() + "] erogato dal soggetto [" + asscsc.getTipoSoggetto() + "/" + asscsc.getNomeSoggetto() + "], referenziato nel " + uriAS + ", utilizza un'azione [" + asscsc.getAzione() + "] che non risulta definita nell'accordo di servizio [" + serv.getAccordoServizio() + "] implementato dal servizio componente (istanziato per il servizio [" + serv.getPortType() + "])");
                            continue;
                        }
                        this.errori.add("Il servizio componente [" + asscsc.getTipo() + "/" + asscsc.getNome() + "] erogato dal soggetto [" + asscsc.getTipoSoggetto() + "/" + asscsc.getNomeSoggetto() + "], referenziato nel " + uriAS + ", implementa un accordo di servizio [" + serv.getAccordoServizio() + "] che e' istanziato per uno specifico servizio [" + serv.getPortType() + "] che non risulta registrato");
                        continue;
                    }
                    if (this.existsAzione_AccordoServizio(asServizioComposto, asscsc.getAzione())) continue;
                    this.errori.add("Il servizio componente [" + asscsc.getTipo() + "/" + asscsc.getNome() + "] erogato dal soggetto [" + asscsc.getTipoSoggetto() + "/" + asscsc.getNomeSoggetto() + "], referenziato nel " + uriAS + ", utilizza un'azione [" + asscsc.getAzione() + "] che non risulta definita nell'accordo di servizio [" + serv.getAccordoServizio() + "] implementato dal servizio componente");
                    continue;
                }
                this.errori.add("Il servizio componente [" + asscsc.getTipo() + "/" + asscsc.getNome() + "] erogato dal soggetto [" + asscsc.getTipoSoggetto() + "/" + asscsc.getNomeSoggetto() + "], referenziato nel " + uriAS + ", implementa un accordo di servizio [" + serv.getAccordoServizio() + "] che non risulta registrato");
            }
            for (int i2 = 0; i2 < assc.sizeSpecificaCoordinamentoList(); ++i2) {
                Documento specificaCoordinamento = assc.getSpecificaCoordinamento(i2);
                this.validateDocumento(specificaCoordinamento, RuoliDocumento.specificaCoordinamento, uriAS);
            }
            if (assc.getNomeAccordoCooperazione() == null) {
                this.errori.add("Nome dell'accordo di cooperazione implementato nel " + uriAS + " non definito");
            } else if (!this.existsAccordoCooperazione(assc.getNomeAccordoCooperazione())) {
                this.errori.add("L'accordo di cooperazione [" + assc.getNomeAccordoCooperazione() + "] referenziato nel " + uriAS + " non corrisponde a nessuno degli accordi di cooperazione registrati");
            }
        }
        Azione[] azArray = as.getAzioneList();
        for (j = 0; j < as.sizeAzioneList(); ++j) {
            String consOrd2;
            String idColl2;
            String confRic2;
            String filtroDup;
            String profColl;
            String correlata;
            Azione az = azArray[j];
            if (az.getNome() == null) {
                this.errori.add("Non \u00e8 stato definito il nome di un'azione nel " + uriAS);
                continue;
            }
            try {
                if (!RegularExpressionEngine.isMatch(az.getNome(), "^[_A-Za-z][\\-\\._A-Za-z0-9]*$")) {
                    this.errori.add("Il nome dell'azione [" + az.getNome() + "] nel " + uriAS + " non e' valido; puo' iniziare solo con un carattere [A-Za-z] o il simbolo '_' e dev'essere formato solo da caratteri, cifre, '_' , '-' e '.'");
                }
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("Errore durante l'analisi tramite espressione regolare del nome dell'azione [" + az.getNome() + "] nel " + uriAS + " :" + e.getMessage(), e);
            }
            int numAz = 0;
            for (int k = 0; k < as.sizeAzioneList(); ++k) {
                Azione tmpAz = as.getAzione(k);
                if (!az.getNome().equals(tmpAz.getNome())) continue;
                ++numAz;
            }
            if (numAz > 1) {
                this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un'azione con nome " + az.getNome() + " nel " + uriAS);
            }
            if ((correlata = az.getCorrelata()) != null && !this.existsAzione_AccordoServizio(as, correlata)) {
                this.errori.add("L'azione [" + correlata + "] correlata all'azione " + az.getNome() + " nel " + uriAS + " non corrisponde a nessuna delle azioni registrate");
            }
            if (!((profColl = az.getProfiloCollaborazione()) == null || profColl.equals("oneway") || profColl.equals("sincrono") || profColl.equals("asincronoSimmetrico") || profColl.equals("asincronoAsimmetrico"))) {
                this.errori.add("Il profilo di collaborazione dell'azione " + az.getNome() + " nel " + uriAS + " deve possedere un profilo " + "oneway" + ", " + "sincrono" + ", " + "asincronoSimmetrico" + " o " + "asincronoAsimmetrico");
            }
            if ((filtroDup = az.getFiltroDuplicati()) != null && !filtroDup.equals("abilitato") && !filtroDup.equals("disabilitato")) {
                this.errori.add("Il filtro duplicati dell'azione " + az.getNome() + " nel " + uriAS + " deve possedere il valore " + "abilitato" + " o " + "disabilitato");
            }
            if ((confRic2 = az.getConfermaRicezione()) != null && !confRic2.equals("abilitato") && !confRic2.equals("disabilitato")) {
                this.errori.add("La conferma ricezione dell'azione " + az.getNome() + " nel " + uriAS + " deve possedere il valore " + "abilitato" + " o " + "disabilitato");
            }
            if ((idColl2 = az.getIdCollaborazione()) != null && !idColl2.equals("abilitato") && !idColl2.equals("disabilitato")) {
                this.errori.add("L'id collaborazione dell'azione " + az.getNome() + " nel " + uriAS + " deve possedere il valore " + "abilitato" + " o " + "disabilitato");
            }
            if ((consOrd2 = az.getConsegnaInOrdine()) != null && !consOrd2.equals("abilitato") && !consOrd2.equals("disabilitato")) {
                this.errori.add("La consegna in ordine dell'azione " + az.getNome() + " nel " + uriAS + " deve possedere il valore " + "abilitato" + " o " + "disabilitato");
            }
            if (az.getScadenza() == null) continue;
            try {
                Integer.parseInt(az.getScadenza());
                continue;
            }
            catch (Exception e) {
                this.errori.add("Il valore associato alla scadenza dell'azione " + az.getNome() + " nel " + uriAS + " dev'essere un numero intero");
            }
        }
        PortType[] ptArray = as.getPortTypeList();
        for (int j2 = 0; j2 < as.sizePortTypeList(); ++j2) {
            String consOrd3;
            String idColl3;
            String confRic3;
            String filtroDup;
            String profColl;
            String style;
            PortType pt = ptArray[j2];
            if (pt.getNome() == null) {
                this.errori.add("Non \u00e8 stato definito il nome di un servizio nel " + uriAS);
                continue;
            }
            try {
                if (!RegularExpressionEngine.isMatch(pt.getNome(), "^[_A-Za-z][\\-\\._A-Za-z0-9]*$")) {
                    this.errori.add("Il nome del servizio [" + pt.getNome() + "] nel " + uriAS + " non e' valido; puo' iniziare solo con un carattere [A-Za-z] o il simbolo '_' e dev'essere formato solo da caratteri, cifre, '_' , '-' e '.'");
                }
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("Errore durante l'analisi tramite espressione regolare del nome del servizio [" + pt.getNome() + "] nel " + uriAS + " :" + e.getMessage(), e);
            }
            int numPt = 0;
            for (int k = 0; k < as.sizePortTypeList(); ++k) {
                PortType tmpPt = as.getPortType(k);
                if (!pt.getNome().equals(tmpPt.getNome())) continue;
                ++numPt;
            }
            if (numPt > 1) {
                this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un port-type con nome " + pt.getNome() + " nel " + uriAS);
            }
            if ((style = pt.getStyle()) != null && !style.equals("document") && !style.equals("rpc")) {
                this.errori.add("Lo style del servizio " + pt.getNome() + " nel " + uriAS + " deve possedere il valore " + "document" + " o " + "rpc" + "");
            }
            if (!((profColl = pt.getProfiloCollaborazione()) == null || profColl.equals("oneway") || profColl.equals("sincrono") || profColl.equals("asincronoSimmetrico") || profColl.equals("asincronoAsimmetrico"))) {
                this.errori.add("Il profilo di collaborazione del servizio " + pt.getNome() + " nel " + uriAS + " deve possedere un profilo " + "oneway" + ", " + "sincrono" + ", " + "asincronoSimmetrico" + " o " + "asincronoAsimmetrico");
            }
            if ((filtroDup = pt.getFiltroDuplicati()) != null && !filtroDup.equals("abilitato") && !filtroDup.equals("disabilitato")) {
                this.errori.add("Il filtro duplicati del servizio " + pt.getNome() + " nel " + uriAS + " deve possedere il valore " + "abilitato" + " o " + "disabilitato");
            }
            if ((confRic3 = pt.getConfermaRicezione()) != null && !confRic3.equals("abilitato") && !confRic3.equals("disabilitato")) {
                this.errori.add("La conferma ricezione del servizio " + pt.getNome() + " nel " + uriAS + " deve possedere il valore " + "abilitato" + " o " + "disabilitato");
            }
            if ((idColl3 = pt.getIdCollaborazione()) != null && !idColl3.equals("abilitato") && !idColl3.equals("disabilitato")) {
                this.errori.add("L'id collaborazione del servizio " + pt.getNome() + " nel " + uriAS + " deve possedere il valore " + "abilitato" + " o " + "disabilitato");
            }
            if ((consOrd3 = pt.getConsegnaInOrdine()) != null && !consOrd3.equals("abilitato") && !consOrd3.equals("disabilitato")) {
                this.errori.add("La consegna in ordine del servizio " + pt.getNome() + " nel " + uriAS + " deve possedere il valore " + "abilitato" + " o " + "disabilitato");
            }
            if (pt.getScadenza() != null) {
                try {
                    Integer.parseInt(pt.getScadenza());
                }
                catch (Exception e) {
                    this.errori.add("Il valore associato alla scadenza del servizio " + pt.getNome() + " nel " + uriAS + " dev'essere un numero intero");
                }
            }
            Operation[] opArray = pt.getAzioneList();
            for (int k = 0; k < pt.sizeAzioneList(); ++k) {
                Message mo;
                Message mi;
                Operation op = opArray[k];
                if (op.getNome() == null) {
                    this.errori.add("Non \u00e8 stato definito il nome di un'azione del servizio " + pt.getNome() + " nel " + uriAS);
                    continue;
                }
                try {
                    if (!RegularExpressionEngine.isMatch(op.getNome(), "^[_A-Za-z][\\-\\._A-Za-z0-9]*$")) {
                        this.errori.add("Il nome dell'azione " + op.getNome() + " nel " + uriAS + " puo' iniziare solo con un carattere [A-Za-z] o il simbolo '_' e dev'essere formato solo da caratteri, cifre, '_' , '-' e '.'");
                    }
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("Errore durante l'analisi tramite espressione regolare del nome dell'azione " + op.getNome() + " nel " + uriAS + " :" + e.getMessage(), e);
                }
                int numOp = 0;
                for (int h = 0; h < pt.sizeAzioneList(); ++h) {
                    Operation tmpOp = pt.getAzione(h);
                    if (!op.getNome().equals(tmpOp.getNome())) continue;
                    ++numOp;
                }
                if (numOp > 1) {
                    this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un'azione con nome " + op.getNome() + " nel " + uriAS);
                }
                String correlata = op.getCorrelata();
                String correlataServizio = op.getCorrelataServizio();
                if (correlata != null && correlataServizio != null) {
                    PortType ptCorrelata;
                    if (!this.existsPortType_AccordoServizio(as, correlataServizio)) {
                        this.errori.add("Il servizio [" + correlataServizio + "] correlata all'azione " + op.getNome() + " nel servizio " + pt.getNome() + " non corrisponde a nessuno dei servizi registrati nel " + uriAS);
                    }
                    if (!this.existsAzione_PortType_AccordoServizio(ptCorrelata = this.getPortType_AccordoServizio(as, correlataServizio), correlata)) {
                        this.errori.add("L'azione [" + correlata + "] correlata all'azione " + op.getNome() + " nel servizio " + pt.getNome() + " non corrisponde a nessuna delle azioni registrate nel servizio correlato [" + correlataServizio + "] nel " + uriAS);
                    }
                } else if (correlata != null) {
                    if (!this.existsAzione_PortType_AccordoServizio(pt, correlata)) {
                        this.errori.add("L'azione [" + correlata + "] correlata all'azione " + op.getNome() + " nel servizio " + pt.getNome() + " non corrisponde a nessuna delle azioni registrate nel " + uriAS);
                    }
                } else if (correlataServizio != null) {
                    this.errori.add("L'azione " + op.getNome() + " nel servizio " + pt.getNome() + " del " + uriAS + " contiene una correlazione verso un altro servizio [" + correlataServizio + "] senza pero' aver definito l'azione correlata");
                }
                style = op.getStyle();
                if (style != null && !style.equals("document") && !style.equals("rpc")) {
                    this.errori.add("Lo style dell'azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + uriAS + " deve possedere il valore " + "document" + " o " + "rpc" + "");
                }
                if (!((profColl = op.getProfiloCollaborazione()) == null || profColl.equals("oneway") || profColl.equals("sincrono") || profColl.equals("asincronoSimmetrico") || profColl.equals("asincronoAsimmetrico"))) {
                    this.errori.add("Il profilo di collaborazione dell'azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + uriAS + " deve possedere un profilo " + "oneway" + ", " + "sincrono" + ", " + "asincronoSimmetrico" + " o " + "asincronoAsimmetrico");
                }
                if ((filtroDup = op.getFiltroDuplicati()) != null && !filtroDup.equals("abilitato") && !filtroDup.equals("disabilitato")) {
                    this.errori.add("Il filtro duplicati dell'azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + uriAS + " deve possedere il valore " + "abilitato" + " o " + "disabilitato");
                }
                if ((confRic3 = op.getConfermaRicezione()) != null && !confRic3.equals("abilitato") && !confRic3.equals("disabilitato")) {
                    this.errori.add("La conferma ricezione del dell'azione " + op.getNome() + " servizio " + pt.getNome() + " nel " + uriAS + " deve possedere il valore " + "abilitato" + " o " + "disabilitato");
                }
                if ((idColl3 = op.getIdCollaborazione()) != null && !idColl3.equals("abilitato") && !idColl3.equals("disabilitato")) {
                    this.errori.add("L'id collaborazione dell'azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + uriAS + " deve possedere il valore " + "abilitato" + " o " + "disabilitato");
                }
                if ((consOrd3 = op.getConsegnaInOrdine()) != null && !consOrd3.equals("abilitato") && !consOrd3.equals("disabilitato")) {
                    this.errori.add("La consegna in ordine ddell'azione " + op.getNome() + " el servizio " + pt.getNome() + " nel " + uriAS + " deve possedere il valore " + "abilitato" + " o " + "disabilitato");
                }
                if (op.getScadenza() != null) {
                    try {
                        Integer.parseInt(op.getScadenza());
                    }
                    catch (Exception e) {
                        this.errori.add("Il valore associato alla scadenza dell'azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + uriAS + " dev'essere un numero intero");
                    }
                }
                if ((mi = op.getMessageInput()) != null) {
                    String useI = mi.getUse();
                    if (useI != null && !useI.equals("literal") && !useI.equals("encoded")) {
                        this.errori.add("L'uso del message-input dell'azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + uriAS + " dev'essere " + "encoded" + " o " + "literal");
                    }
                    for (int l = 0; l < mi.sizePartList(); ++l) {
                        MessagePart part = mi.getPart(l);
                        if (part.getElementName() != null) continue;
                        this.errori.add("Non \u00e8 stato definito l'element-name del message-input dell'azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + uriAS);
                    }
                }
                if ((mo = op.getMessageOutput()) == null) continue;
                String useO = mo.getUse();
                if (useO != null && !useO.equals("literal") && !useO.equals("encoded")) {
                    this.errori.add("L'uso del message-output dell'azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + uriAS + " dev'essere " + "encoded" + " o " + "literal");
                }
                for (int l = 0; l < mo.sizePartList(); ++l) {
                    MessagePart part = mo.getPart(l);
                    if (part.getElementName() != null) continue;
                    this.errori.add("Non \u00e8 stato definito l'element-name del message-output dell'azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + uriAS);
                }
            }
        }
        for (i = 0; i < as.sizeAllegatoList(); ++i) {
            Documento allegato = as.getAllegato(i);
            this.validateDocumento(allegato, RuoliDocumento.allegato, uriAS);
        }
        for (i = 0; i < as.sizeSpecificaSemiformaleList(); ++i) {
            Documento specificaSemiformale = as.getSpecificaSemiformale(i);
            this.validateDocumento(specificaSemiformale, RuoliDocumento.specificaSemiformale, uriAS);
        }
        try {
            if (!RegularExpressionEngine.isMatch(as.getNome(), "^[0-9A-Za-z_\\-\\.]+$")) {
                this.errori.add("Il nome nel " + uriAS + " dev'essere formato solo caratteri, cifre, '_' , '-' e '.'");
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante l'analisi tramite espressione regolare del nome nel " + uriAS + " :" + e.getMessage(), e);
        }
        String profColl = as.getProfiloCollaborazione();
        if (profColl == null) {
            this.errori.add("Il profilo di collaborazione nel " + uriAS + " non \u00e8 definito; deve possedere un profilo " + "oneway" + ", " + "sincrono" + ", " + "asincronoSimmetrico" + " o " + "asincronoAsimmetrico");
        } else if (!(profColl.equals("oneway") || profColl.equals("sincrono") || profColl.equals("asincronoSimmetrico") || profColl.equals("asincronoAsimmetrico"))) {
            this.errori.add("Il profilo di collaborazione nel " + uriAS + " deve possedere un profilo " + "oneway" + ", " + "sincrono" + ", " + "asincronoSimmetrico" + " o " + "asincronoAsimmetrico");
        }
        String filtroDup = as.getFiltroDuplicati();
        if (filtroDup != null && !filtroDup.equals("abilitato") && !filtroDup.equals("disabilitato")) {
            this.errori.add("Il filtro duplicati nel " + uriAS + " deve possedere il valore " + "abilitato" + " o " + "disabilitato");
        }
        if ((confRic = as.getConfermaRicezione()) != null && !confRic.equals("abilitato") && !confRic.equals("disabilitato")) {
            this.errori.add("La conferma ricezione nel " + uriAS + " deve possedere il valore " + "abilitato" + " o " + "disabilitato");
        }
        if ((idColl = as.getIdCollaborazione()) != null && idColl != null && !idColl.equals("abilitato") && !idColl.equals("disabilitato")) {
            this.errori.add("L'id collaborazione nel " + uriAS + " deve possedere il valore " + "abilitato" + " o " + "disabilitato");
        }
        if ((consOrd = as.getConsegnaInOrdine()) != null && consOrd != null && !consOrd.equals("abilitato") && !consOrd.equals("disabilitato")) {
            this.errori.add("La consegna in ordine nel " + uriAS + " deve possedere il valore " + "abilitato" + " o " + "disabilitato");
        }
        if (as.getScadenza() != null) {
            try {
                Integer.parseInt(as.getScadenza());
            }
            catch (Exception e) {
                this.errori.add("Il valore associato alla scadenza nel " + uriAS + " dev'essere un numero intero");
            }
        }
        if (as.getWsdlConcettuale() != null) {
            try {
                Utilities.validateUri(as.getWsdlConcettuale(), this.checkEsistenzaFileDefinitoTramiteURI);
            }
            catch (Exception e) {
                this.errori.add("Il wsdl concettuale nel " + uriAS + " non \u00e8 valido: " + e.getMessage());
            }
        }
        if (as.getWsdlDefinitorio() != null) {
            try {
                Utilities.validateUri(as.getWsdlDefinitorio(), this.checkEsistenzaFileDefinitoTramiteURI);
            }
            catch (Exception e) {
                this.errori.add("Il wsdl definitorio nel " + uriAS + " non \u00e8 valido: " + e.getMessage());
            }
        }
        if (as.getWsdlLogicoErogatore() != null) {
            try {
                Utilities.validateUri(as.getWsdlLogicoErogatore(), this.checkEsistenzaFileDefinitoTramiteURI);
            }
            catch (Exception e) {
                this.errori.add("Il wsdl logico erogatore nel " + uriAS + " non \u00e8 valido: " + e.getMessage());
            }
        }
        if (as.getWsdlLogicoFruitore() != null) {
            try {
                Utilities.validateUri(as.getWsdlLogicoFruitore(), this.checkEsistenzaFileDefinitoTramiteURI);
            }
            catch (Exception e) {
                this.errori.add("Il wsdl logico fruitore nel " + uriAS + " non \u00e8 valido: " + e.getMessage());
            }
        }
        if (as.getWsblConcettuale() != null) {
            try {
                Utilities.validateUri(as.getWsblConcettuale(), this.checkEsistenzaFileDefinitoTramiteURI);
            }
            catch (Exception e) {
                this.errori.add("Il wsbl concettuale nel " + uriAS + " non \u00e8 valido: " + e.getMessage());
            }
        }
        if (as.getWsblLogicoErogatore() != null) {
            try {
                Utilities.validateUri(as.getWsblLogicoErogatore(), this.checkEsistenzaFileDefinitoTramiteURI);
            }
            catch (Exception e) {
                this.errori.add("Il wsbl logico erogatore nel " + uriAS + " non \u00e8 valido: " + e.getMessage());
            }
        }
        if (as.getWsblLogicoFruitore() != null) {
            try {
                Utilities.validateUri(as.getWsblLogicoFruitore(), this.checkEsistenzaFileDefinitoTramiteURI);
            }
            catch (Exception e) {
                this.errori.add("Il wsbl logico fruitore nel " + uriAS + " non \u00e8 valido: " + e.getMessage());
            }
        }
        if (as.getCatalogoSchemiOntologie() != null) {
            try {
                Utilities.validateUri(as.getCatalogoSchemiOntologie(), this.checkEsistenzaFileDefinitoTramiteURI);
            }
            catch (Exception e) {
                this.errori.add("Il catalogo schemi ontologie nel " + uriAS + " non \u00e8 valido: " + e.getMessage());
            }
        }
        if (!as.getUtilizzoSenzaAzione() && as.sizeAzioneList() == 0 && as.sizePortTypeList() == 0) {
            this.errori.add("Il " + uriAS + " non prevede l'utilizzo senza azioni, quindi dev'essere definita almeno un'azione o almeno un servizio (con relative azioni)");
        }
        if (as.getVersione() != null) {
            try {
                if (!RegularExpressionEngine.isMatch(as.getVersione(), "^[1-9]+[0-9]*$")) {
                    this.errori.add("La versione nel " + uriAS + " dev'essere rappresentata da un numero intero");
                }
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("Errore durante l'analisi tramite espressione regolare della versione nel " + uriAS + " :" + e.getMessage(), e);
            }
        }
        int numAs = 0;
        for (int j3 = 0; j3 < this.registro.sizeAccordoServizioList(); ++j3) {
            AccordoServizio tmpAs = this.registro.getAccordoServizio(j3);
            if (!IDAccordo.getUriFromAccordo(tmpAs).equals(IDAccordo.getUriFromAccordo(as))) continue;
            ++numAs;
        }
        if (numAs > 1) {
            this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un accordo di servizio (o servizio composto) con nome " + IDAccordo.getUriFromAccordo(as));
        }
    }

    private void validaSoggettoSpcoop(SoggettoSpcoop sogg, boolean showIDOggettiAnalizzati) throws DriverRegistroServiziException {
        String prof;
        ServizioSpcoop serv;
        int j;
        if (sogg.getNome() == null) {
            this.errori.add("Esiste un soggetto spcoop senza nome");
            return;
        }
        if (sogg.getTipo() == null) {
            this.errori.add("Esiste un soggetto spcoop senza tipo");
            return;
        }
        Connettore conn = sogg.getConnettore();
        if (conn != null) {
            this.validaConnettore(conn, "soggetto", sogg.getTipo() + "/" + sogg.getNome());
        }
        for (j = 0; j < sogg.sizeServizioList(); ++j) {
            serv = sogg.getServizio(j);
            if (showIDOggettiAnalizzati) {
                this.printMsg("\tServizio SPCoop: " + sogg.getTipo() + "/" + sogg.getNome() + "_" + serv.getTipo() + "/" + serv.getNome());
            }
            this.validaServizioSpcoop(serv, sogg);
        }
        for (j = 0; j < sogg.sizeServizioCorrelatoList(); ++j) {
            serv = sogg.getServizioCorrelato(j);
            if (showIDOggettiAnalizzati) {
                this.printMsg("\tServizio SPCoop Correlato: " + sogg.getTipo() + "/" + sogg.getNome() + "_" + serv.getTipo() + "/" + serv.getNome());
            }
            this.validaServizioSpcoop(serv, sogg);
        }
        if (!this.tipoSoggetti.contains(sogg.getTipo())) {
            this.errori.add("Il tipo del soggetto " + sogg.getTipo() + "/" + sogg.getNome() + " non \u00e8 valido (Tipi utilizzabili: " + this.getTipoSoggetti() + ")");
        }
        try {
            if (!RegularExpressionEngine.isMatch(sogg.getNome(), "^[0-9A-Za-z]+$")) {
                this.errori.add("Il nome del soggetto " + sogg.getTipo() + "/" + sogg.getNome() + " dev'essere formato solo caratteri e cifre");
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante l'analisi tramite espressione regolare del nome del soggetto " + sogg.getTipo() + "/" + sogg.getNome() + " :" + e.getMessage(), e);
        }
        int numS = 0;
        for (int j2 = 0; j2 < this.registro.sizeSoggettoSpcoopList(); ++j2) {
            SoggettoSpcoop tmpSogg = this.registro.getSoggettoSpcoop(j2);
            if (!sogg.getNome().equals(tmpSogg.getNome()) || !sogg.getTipo().equals(tmpSogg.getTipo())) continue;
            ++numS;
        }
        if (numS > 1) {
            this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un soggetto con nome " + sogg.getNome() + " e tipo " + sogg.getTipo());
        }
        if (sogg.getPortaDominio() != null && !this.existsPortaDominio(sogg.getPortaDominio())) {
            this.errori.add("La porta di dominio [" + sogg.getPortaDominio() + "] del soggetto " + sogg.getTipo() + "/" + sogg.getNome() + " non corrisponde a nessuna delle porte di dominio registrate");
        }
        if ((prof = sogg.getProfilo()) != null && !prof.equals("eGov1.1") && !prof.equals("eGov1.1-lineeGuida1.1")) {
            this.errori.add("Il profilo del soggetto " + sogg.getTipo() + "/" + sogg.getNome() + " deve possedere il valore eGov1.1 o eGov1.1-lineeGuida1.1");
        }
    }

    private void validaServizioSpcoop(ServizioSpcoop serv, SoggettoSpcoop sogg) throws DriverRegistroServiziException {
        String prof;
        String consOrd;
        String idColl;
        String confRic;
        String filtroDup;
        int i;
        int k;
        if (serv.getNome() == null) {
            this.errori.add("Esiste un servizio spcoop senza nome");
            return;
        }
        if (serv.getTipo() == null) {
            this.errori.add("Esiste un servizio spcoop senza tipo");
            return;
        }
        String idServizio = sogg.getTipo() + "/" + sogg.getNome() + "_" + serv.getTipo() + "/" + serv.getNome();
        Connettore conn = serv.getConnettore();
        if (conn != null) {
            this.validaConnettore(conn, "servizio", serv.getTipo() + "/" + serv.getNome());
        } else if (sogg.getConnettore() == null || "disabilitato".equals(sogg.getConnettore().getTipo())) {
            this.errori.add("Il servizio [" + idServizio + "] deve obbligatoriamente definire un connettore, poiche' il soggetto erogatore non ne possiede uno");
        }
        for (k = 0; k < serv.sizeAzioneList(); ++k) {
            ServizioSpcoopAzione az = serv.getAzione(k);
            if (az.getNome() == null) {
                this.errori.add("Esiste un'azione del servizio " + idServizio + " per cui non \u00e8 definito il nome");
                continue;
            }
            int numA = 0;
            for (int h = 0; h < serv.sizeAzioneList(); ++h) {
                ServizioSpcoopAzione tmpSsa = serv.getAzione(h);
                if (!az.getNome().equals(tmpSsa.getNome())) continue;
                ++numA;
            }
            if (numA > 1) {
                this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un'azione con nome " + az.getNome() + " nel servizio " + idServizio);
            }
            if (this.existsAccordoServizio(serv.getAccordoServizio())) {
                AccordoServizio as = this.getAccordoServizio(serv.getAccordoServizio());
                if (serv.getPortType() != null) {
                    PortType pt;
                    if (this.existsPortType_AccordoServizio(as, serv.getPortType()) && !this.existsAzione_PortType_AccordoServizio(pt = this.getPortType_AccordoServizio(as, serv.getPortType()), az.getNome())) {
                        this.errori.add("Il servizio [" + idServizio + "], utilizza un'azione [" + az.getNome() + "] che non risulta definita nell'accordo di servizio [" + serv.getAccordoServizio() + "] implementato dal servizio spcoop (istanziato per il servizio [" + serv.getPortType() + "])");
                    }
                } else if (!this.existsAzione_AccordoServizio(as, az.getNome())) {
                    this.errori.add("Il servizio [" + idServizio + "], utilizza un'azione [" + az.getNome() + "] che non risulta definita nell'accordo di servizio [" + serv.getAccordoServizio() + "] implementato dal servizio");
                }
            }
            if ((az.getConnettore() == null || "disabilitato".equals(az.getConnettore().getTipo())) && az.sizeFruitoreList() == 0) {
                this.errori.add("Non pu\u00f2 esistere un'azione con nome " + az.getNome() + " nel servizio " + idServizio + " che non definisce ne al suo interno un connettore, ne una lista di fruitori");
            }
            if ((conn = az.getConnettore()) != null) {
                this.validaConnettore(conn, "Azione [" + az.getNome() + "] ridefinita nel Servizio SPCoop", idServizio);
            }
            for (int w = 0; w < az.sizeFruitoreList(); ++w) {
                ServizioSpcoopAzioneFruitore ssaf = az.getFruitore(w);
                String tipoSsaf = ssaf.getTipo();
                String nomeSsaf = ssaf.getNome();
                if (tipoSsaf == null) {
                    this.errori.add("Esiste un fruitore dell'azione " + az.getNome() + " del servizio " + serv.getTipo() + "/" + serv.getNome() + " per cui non \u00e8 definito il tipo");
                    continue;
                }
                if (nomeSsaf == null) {
                    this.errori.add("Esiste un fruitore dell'azione " + az.getNome() + " del servizio " + serv.getTipo() + "/" + serv.getNome() + " per cui non \u00e8 definito il nome");
                    continue;
                }
                if (!this.existsSoggettoSPCoop(tipoSsaf, nomeSsaf)) {
                    this.errori.add("Il fruitore " + tipoSsaf + "/" + nomeSsaf + " dell'azione " + az.getNome() + " del servizio " + serv.getTipo() + "/" + serv.getNome() + " non corrisponde a nessuno dei soggetti registrati");
                }
                if ((conn = ssaf.getConnettore()) != null) {
                    this.validaConnettore(conn, "", idServizio);
                    continue;
                }
                this.errori.add("Non e' stato definito il connettore per il Fruitore [" + tipoSsaf + "/" + nomeSsaf + "] dell'azione [" + az.getNome() + "] ridefinita nel Servizio SPCoop " + idServizio);
            }
        }
        for (k = 0; k < serv.sizeFruitoreList(); ++k) {
            String clA;
            String prof2;
            String consOrd2;
            String idColl2;
            String confRic2;
            String filtroDup2;
            Fruitore fru = serv.getFruitore(k);
            if (fru.getTipo() == null) {
                this.errori.add("Esiste un fruitore del servizio [" + idServizio + "] per cui non \u00e8 definito il tipo");
                continue;
            }
            if (fru.getNome() == null) {
                this.errori.add("Esiste un fruitore del servizio [" + idServizio + "] per cui non \u00e8 definito il nome");
                continue;
            }
            if (!this.existsSoggettoSPCoop(fru.getTipo(), fru.getNome())) {
                this.errori.add("Il fruitore " + fru.getTipo() + "/" + fru.getNome() + " del servizio " + idServizio + " non corrisponde a nessuno dei soggetti registrati");
            }
            int numF = 0;
            for (int h = 0; h < serv.sizeFruitoreList(); ++h) {
                Fruitore tmpF = serv.getFruitore(h);
                if (!fru.getNome().equals(tmpF.getNome()) || !fru.getTipo().equals(tmpF.getTipo())) continue;
                ++numF;
            }
            if (numF > 1) {
                this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un fruitore con nome " + fru.getNome() + " e tipo " + fru.getTipo() + " per il servizio " + idServizio);
            }
            if ((conn = fru.getConnettore()) != null) {
                this.validaConnettore(conn, "fruitore [" + fru.getTipo() + "/" + fru.getNome() + "] del servizio SPCoop", idServizio);
            }
            if (fru.getWsdlImplementativoErogatore() != null) {
                try {
                    Utilities.validateUri(fru.getWsdlImplementativoErogatore(), this.checkEsistenzaFileDefinitoTramiteURI);
                }
                catch (Exception e) {
                    this.errori.add("Il wsdl implementativo erogatore del fruitore [" + fru.getTipo() + "/" + fru.getNome() + "] del servizio " + idServizio + " non \u00e8 valido: " + e.getMessage());
                }
            }
            if (fru.getWsdlImplementativoFruitore() != null) {
                try {
                    Utilities.validateUri(fru.getWsdlImplementativoFruitore(), this.checkEsistenzaFileDefinitoTramiteURI);
                }
                catch (Exception e) {
                    this.errori.add("Il wsdl implementativo fruitore del fruitore [" + fru.getTipo() + "/" + fru.getNome() + "] del servizio " + idServizio + " non \u00e8 valido: " + e.getMessage());
                }
            }
            if ((filtroDup2 = fru.getFiltroDuplicati()) != null && !filtroDup2.equals("abilitato") && !filtroDup2.equals("disabilitato")) {
                this.errori.add("Il filtro duplicati del fruitore [" + fru.getTipo() + "/" + fru.getNome() + "] nel servizio SPCoop " + idServizio + " deve possedere il valore " + "abilitato" + " o " + "disabilitato");
            }
            if ((confRic2 = fru.getConfermaRicezione()) != null && !confRic2.equals("abilitato") && !confRic2.equals("disabilitato")) {
                this.errori.add("La conferma ricezione del fruitore [" + fru.getTipo() + "/" + fru.getNome() + "] nel servizio SPCoop " + idServizio + " deve possedere il valore " + "abilitato" + " o " + "disabilitato");
            }
            if ((idColl2 = fru.getIdCollaborazione()) != null && !idColl2.equals("abilitato") && !idColl2.equals("disabilitato")) {
                this.errori.add("L'id collaborazione del fruitore [" + fru.getTipo() + "/" + fru.getNome() + "] nel servizio SPCoop " + idServizio + " deve possedere il valore " + "abilitato" + " o " + "disabilitato");
            }
            if ((consOrd2 = fru.getConsegnaInOrdine()) != null && !consOrd2.equals("abilitato") && !consOrd2.equals("disabilitato")) {
                this.errori.add("La consegna in ordine del fruitore [" + fru.getTipo() + "/" + fru.getNome() + "] nel servizio SPCoop " + idServizio + " deve possedere il valore " + "abilitato" + " o " + "disabilitato");
            }
            if (fru.getScadenza() != null) {
                try {
                    Integer.parseInt(fru.getScadenza());
                }
                catch (Exception e) {
                    this.errori.add("Il valore associato alla scadenza del fruitore [" + fru.getTipo() + "/" + fru.getNome() + "] nel servizio SPCoop " + idServizio + " dev'essere un numero intero");
                }
            }
            if ((prof2 = fru.getProfilo()) != null && !prof2.equals("eGov1.1") && !prof2.equals("eGov1.1-lineeGuida1.1")) {
                this.errori.add("Il profilo del fruitore [" + fru.getTipo() + "/" + fru.getNome() + "] nel servizio SPCoop " + idServizio + " deve possedere il valore eGov1.1 o eGov1.1-lineeGuida1.1");
            }
            if ((clA = fru.getClientAuth()) == null || clA.equals("abilitato") || clA.equals("disabilitato") || clA.equals("default")) continue;
            this.errori.add("Il client-auth del fruitore " + fru.getTipo() + "/" + fru.getNome() + " nel servizio SPCoop " + idServizio + " deve possedere il valore " + "abilitato" + "," + "disabilitato" + " o default");
        }
        for (i = 0; i < serv.sizeAllegatoList(); ++i) {
            Documento allegato = serv.getAllegato(i);
            this.validateDocumento(allegato, RuoliDocumento.allegato, "ServizioSPCoop[" + idServizio + "]");
        }
        for (i = 0; i < serv.sizeSpecificaSemiformaleList(); ++i) {
            Documento specificaSemiformale = serv.getSpecificaSemiformale(i);
            this.validateDocumento(specificaSemiformale, RuoliDocumento.specificaSemiformale, "ServizioSPCoop[" + idServizio + "]");
        }
        for (i = 0; i < serv.sizeSpecificaLivelloServizioList(); ++i) {
            Documento specificaLivelloServizio = serv.getSpecificaLivelloServizio(i);
            this.validateDocumento(specificaLivelloServizio, RuoliDocumento.specificaLivelloServizio, "ServizioSPCoop[" + idServizio + "]");
        }
        for (i = 0; i < serv.sizeSpecificaSicurezzaList(); ++i) {
            Documento specificaSicurezza = serv.getSpecificaSicurezza(i);
            this.validateDocumento(specificaSicurezza, RuoliDocumento.specificaSicurezza, "ServizioSPCoop[" + idServizio + "]");
        }
        if (!this.tipoServizi.contains(serv.getTipo())) {
            this.errori.add("Il tipo del servizio " + serv.getTipo() + "/" + serv.getNome() + " non \u00e8 valido (tipi utilizzabili: " + this.getTipoServizi() + ")");
        }
        try {
            if (!RegularExpressionEngine.isMatch(serv.getNome(), "^[0-9A-Za-z_\\-\\.]+$")) {
                this.errori.add("Il nome del servizio " + serv.getTipo() + "/" + serv.getNome() + " dev'essere formato solo caratteri, cifre, '_' , '-' e '.'");
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante l'analisi tramite espressione regolare del servizio " + serv.getTipo() + "/" + serv.getNome() + " :" + e.getMessage(), e);
        }
        if (serv.getAccordoServizio() == null) {
            this.errori.add("Il Servizio " + idServizio + " non implementa un accordo di servizio");
        } else if (!this.existsAccordoServizio(serv.getAccordoServizio())) {
            this.errori.add("L'accordo servizio " + serv.getAccordoServizio() + " del servizio " + idServizio + " non corrisponde a nessuno degli accordi servizio registrati");
        } else {
            AccordoServizio as;
            String nomePT = serv.getPortType();
            if (nomePT != null && !this.existsPortType_AccordoServizio(as = this.getAccordoServizio(serv.getAccordoServizio()), nomePT)) {
                this.errori.add("Il servizio " + nomePT + " del servizio SPCoop " + idServizio + " non corrisponde a nessuno dei servizi dell'accordo servizio implementato [" + serv.getAccordoServizio() + "]");
            }
        }
        int numS = 0;
        for (int j = 0; j < sogg.sizeServizioList(); ++j) {
            ServizioSpcoop tmpS = sogg.getServizio(j);
            if (!serv.getNome().equals(tmpS.getNome()) || !serv.getTipo().equals(tmpS.getTipo()) || (serv.getNomeSoggettoErogatore() != null || tmpS.getNomeSoggettoErogatore() != null) && !serv.getNomeSoggettoErogatore().equals(tmpS.getNomeSoggettoErogatore()) || (serv.getTipoSoggettoErogatore() != null || tmpS.getTipoSoggettoErogatore() != null) && !serv.getTipoSoggettoErogatore().equals(tmpS.getTipoSoggettoErogatore())) continue;
            ++numS;
        }
        if (numS > 1) {
            this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un servizio con nome " + serv.getNome() + " e tipo " + serv.getTipo() + " e nome soggetto erogatore " + serv.getNomeSoggettoErogatore() + " e tipo soggetto erogatore " + serv.getTipoSoggettoErogatore());
        }
        if (serv.getWsdlImplementativoErogatore() != null) {
            try {
                Utilities.validateUri(serv.getWsdlImplementativoErogatore(), this.checkEsistenzaFileDefinitoTramiteURI);
            }
            catch (Exception e) {
                this.errori.add("Il wsdl implementativo erogatore del servizio " + idServizio + " non \u00e8 valido: " + e.getMessage());
            }
        }
        if (serv.getWsdlImplementativoFruitore() != null) {
            try {
                Utilities.validateUri(serv.getWsdlImplementativoFruitore(), this.checkEsistenzaFileDefinitoTramiteURI);
            }
            catch (Exception e) {
                this.errori.add("Il wsdl implementativo fruitore del servizio " + idServizio + " non \u00e8 valido: " + e.getMessage());
            }
        }
        if ((filtroDup = serv.getFiltroDuplicati()) != null && !filtroDup.equals("abilitato") && !filtroDup.equals("disabilitato")) {
            this.errori.add("Il filtro duplicati del servizio SPCoop " + idServizio + " deve possedere il valore " + "abilitato" + " o " + "disabilitato");
        }
        if ((confRic = serv.getConfermaRicezione()) != null && !confRic.equals("abilitato") && !confRic.equals("disabilitato")) {
            this.errori.add("La conferma ricezione del servizio SPCoop " + idServizio + " deve possedere il valore " + "abilitato" + " o " + "disabilitato");
        }
        if ((idColl = serv.getIdCollaborazione()) != null && !idColl.equals("abilitato") && !idColl.equals("disabilitato")) {
            this.errori.add("L'id collaborazione del servizio SPCoop " + idServizio + " deve possedere il valore " + "abilitato" + " o " + "disabilitato");
        }
        if ((consOrd = serv.getConsegnaInOrdine()) != null && !consOrd.equals("abilitato") && !consOrd.equals("disabilitato")) {
            this.errori.add("La consegna in ordine del servizio SPCoop " + idServizio + " deve possedere il valore " + "abilitato" + " o " + "disabilitato");
        }
        if (serv.getScadenza() != null) {
            try {
                Integer.parseInt(serv.getScadenza());
            }
            catch (Exception e) {
                this.errori.add("Il valore associato alla scadenza del servizio SPCoop " + idServizio + " dev'essere un numero intero");
            }
        }
        if ((prof = serv.getProfilo()) != null && !prof.equals("eGov1.1") && !prof.equals("eGov1.1-lineeGuida1.1")) {
            this.errori.add("Il profilo del servizio SPCoop " + idServizio + " deve possedere il valore eGov1.1 o eGov1.1-lineeGuida1.1");
        }
        if (serv.getAccordoParteSpecifica() != null) {
            if (serv.getAccordoParteSpecifica().getNome() == null) {
                this.errori.add("Non e' stato fornito un nome per l'accordo di servizio parte specifica del servizio SPCoop " + idServizio + ", ma e' presente l'elemento?");
                return;
            }
            if (serv.getAccordoParteSpecifica().getVersione() != null) {
                try {
                    if (!RegularExpressionEngine.isMatch(serv.getAccordoParteSpecifica().getVersione(), "^[1-9]+[0-9]*$")) {
                        this.errori.add("La versione nell'accordo di servizio parte specifica del servizio SPCoop " + idServizio + " dev'essere rappresentata da un numero intero");
                    }
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("Errore durante l'analisi tramite espressione regolare della versione nell'accordo di servizio parte specifica del servizio SPCoop " + idServizio + " :" + e.getMessage(), e);
                }
            }
        }
    }

    private void validaPortaDominio(PortaDominio pdd) throws DriverRegistroServiziException {
        if (pdd.getNome() == null) {
            this.errori.add("Esiste una porta di dominio senza nome");
            return;
        }
        try {
            if (!RegularExpressionEngine.isMatch(pdd.getNome(), "^[0-9A-Za-z_\\-\\.]+$")) {
                this.errori.add("Il nome della porta di dominio dev'essere formato solo da caratteri, cifre, '_' , '-' e '.'");
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante l'analisi tramite espressione regolare del nome della porta di dominio :" + e.getMessage(), e);
        }
        String clA = pdd.getClientAuth();
        if (clA != null && !clA.equals("abilitato") && !clA.equals("disabilitato")) {
            this.errori.add("Il client-auth della porta di dominio " + pdd.getNome() + " dev'essere abilitato o disabilitato");
        }
        if (pdd.getClientAuth() != null && pdd.getClientAuth().equals("abilitato") && (pdd.getSubject() == null || pdd.getSubject().equals(""))) {
            this.errori.add("Il subject della porta di dominio " + pdd.getNome() + " dev'essere fornito quando client-auth \u00e8 abilitato");
        }
        int numPd = 0;
        for (int j = 0; j < this.registro.sizePortaDominioList(); ++j) {
            PortaDominio tmpPd = this.registro.getPortaDominio(j);
            if (!pdd.getNome().equals(tmpPd.getNome())) continue;
            ++numPd;
        }
        if (numPd > 1) {
            this.errori.add("Non pu\u00f2 esistere pi\u00f9 di una porta di dominio con nome " + pdd.getNome());
        }
    }

    private void validaConnettore(Connettore conn, String oggetto, String tipoEnomeOggetto) throws DriverRegistroServiziException {
        block117: {
            int j;
            String nomeConn = conn.getNome();
            String tipoConn = conn.getTipo();
            if (nomeConn == null) {
                if (oggetto == null) {
                    this.errori.add("Esiste un connettore nella radice del registro per cui non \u00e8 definito il nome");
                } else {
                    this.errori.add("Esiste un connettore del " + oggetto + " " + tipoEnomeOggetto + " per cui non \u00e8 definito il nome");
                }
                return;
            }
            if (oggetto == null) {
                int numC = 0;
                for (j = 0; j < this.registro.sizeConnettoreList(); ++j) {
                    Connettore tmpC = this.registro.getConnettore(j);
                    if (!nomeConn.equals(tmpC.getNome())) continue;
                    ++numC;
                }
                if (numC > 1) {
                    this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un connettore con nome " + nomeConn + " definito come elemento radice del registro servizi");
                }
            } else {
                if (tipoConn == null) {
                    conn = null;
                    for (int j2 = 0; j2 < this.registro.sizeConnettoreList(); ++j2) {
                        Connettore connettore = this.registro.getConnettore(j2);
                        if (!nomeConn.equals(connettore.getNome())) continue;
                        conn = connettore;
                        break;
                    }
                }
                if (conn == null) {
                    this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " non corrisponde a nessuno dei connettori registrati");
                } else {
                    tipoConn = conn.getTipo();
                }
            }
            if (!this.tipoConnettori.contains(tipoConn)) {
                if (oggetto == null) {
                    this.errori.add("Il tipo [" + tipoConn + "] del connettore " + nomeConn + ", definito nella radice del registro, non \u00e8 valido (Tipi conosciuti: " + this.getTipoConnettori() + ")");
                } else {
                    this.errori.add("Il tipo [" + tipoConn + "] del connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " non \u00e8 valido (Tipi conosciuti: " + this.getTipoConnettori() + ")");
                }
            } else {
                ConnettoreProperty[] cpArray = conn.getPropertyList();
                if (cpArray != null) {
                    for (j = 0; j < cpArray.length; ++j) {
                        ConnettoreProperty cp = cpArray[j];
                        if (cp.getNome() == null) {
                            if (oggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, possiede una propriet\u00e0 per cui non \u00e8 definito il nome");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " possiede una propriet\u00e0 per cui non \u00e8 definito il nome");
                            }
                            return;
                        }
                        if (cp.getValore() != null) continue;
                        if (oggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, possiede una propriet\u00e0 per cui non \u00e8 definito il valore");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " possiede una propriet\u00e0 per cui non \u00e8 definito il valore");
                        }
                        return;
                    }
                }
                if (tipoConn.equals(TipiConnettore.HTTP.getNome())) {
                    String urlConn = null;
                    for (int j3 = 0; j3 < cpArray.length; ++j3) {
                        ConnettoreProperty cp = cpArray[j3];
                        if (!cp.getNome().equals("location")) continue;
                        urlConn = cp.getValore();
                        break;
                    }
                    if (urlConn == null) {
                        if (oggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, \u00e8 di tipo http, ma non ha una url definita");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " \u00e8 di tipo http, ma non ha una url definita");
                        }
                    } else {
                        try {
                            this.validaUrl(urlConn);
                        }
                        catch (Exception e) {
                            if (oggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, \u00e8 di tipo http, ma non ha una url valida: " + e.getMessage());
                                break block117;
                            }
                            this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " \u00e8 di tipo http, ma non ha una url valida: " + e.getMessage());
                        }
                    }
                } else if (tipoConn.equals(TipiConnettore.JMS.getNome())) {
                    String jmsNome = null;
                    String jmsTipo = null;
                    String jmsConnFact = null;
                    String jmsSendAs = null;
                    for (int j4 = 0; j4 < cpArray.length; ++j4) {
                        ConnettoreProperty cp = cpArray[j4];
                        if (cp.getNome().equals("location")) {
                            jmsNome = cp.getValore();
                        }
                        if (cp.getNome().equals("tipo")) {
                            jmsTipo = cp.getValore();
                        }
                        if (cp.getNome().equals("connection-factory")) {
                            jmsConnFact = cp.getValore();
                        }
                        if (!cp.getNome().equals("send-as")) continue;
                        jmsSendAs = cp.getValore();
                    }
                    if (jmsNome == null) {
                        if (oggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, \u00e8 di tipo jms, ma non ha un nome coda/topic definito");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " \u00e8 di tipo jms, ma non ha un nome coda/topic definito");
                        }
                    }
                    if (jmsTipo == null) {
                        if (oggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, \u00e8 di tipo jms, ma non ha un tipo coda/topic definito");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " \u00e8 di tipo jms, ma non ha un tipo coda/topic definito");
                        }
                    } else if (!jmsTipo.equals("queue") && !jmsTipo.equals("topic")) {
                        if (oggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, \u00e8 di tipo jms, ma non ha un tipo coda/topic valido (valori assumibili sono topic/queue)");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " \u00e8 di tipo jms, ma non ha un tipo coda/topic valido (valori assumibili sono topic/queue)");
                        }
                    }
                    if (jmsConnFact == null) {
                        if (oggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, \u00e8 di tipo jms, ma non ha una connection factory definita");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " \u00e8 di tipo jms, ma non ha una connection factory definita");
                        }
                    }
                    if (jmsSendAs == null) {
                        if (oggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, \u00e8 di tipo jms, ma non ha un tipo di messaggio (sendAs) definito");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " \u00e8 di tipo jms, ma non ha un tipo di messaggio (sendAs) definito");
                        }
                    } else if (!jmsSendAs.equals("TextMessage") && !jmsSendAs.equals("BytesMessage")) {
                        if (oggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, \u00e8 di tipo jms, ma non ha un tipo di messaggio (sendAs) (valori assumibili sono TextMessage/BytesMessage)");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " \u00e8 di tipo jms, ma non ha un tipo di messaggio (sendAs) (valori assumibili sono TextMessage/BytesMessage)");
                        }
                    }
                } else if (tipoConn.equals(TipiConnettore.HTTPS.getNome())) {
                    String urlConn = null;
                    String trustStoreLocation = null;
                    String trustStorePassword = null;
                    String keyStoreLocation = null;
                    String keyStorePassword = null;
                    String keyPassword = null;
                    String hostNameVerifier = null;
                    for (int j5 = 0; j5 < cpArray.length; ++j5) {
                        ConnettoreProperty cp = cpArray[j5];
                        if (cp.getNome().equals("location")) {
                            urlConn = cp.getValore();
                            continue;
                        }
                        if (cp.getNome().equals("trustStoreLocation")) {
                            trustStoreLocation = cp.getValore();
                            continue;
                        }
                        if (cp.getNome().equals("trustStorePassword")) {
                            trustStorePassword = cp.getValore();
                            continue;
                        }
                        if (cp.getNome().equals("keyStoreLocation")) {
                            keyStoreLocation = cp.getValore();
                            continue;
                        }
                        if (cp.getNome().equals("keyStorePassword")) {
                            keyStorePassword = cp.getValore();
                            continue;
                        }
                        if (cp.getNome().equals("keyPassword")) {
                            keyPassword = cp.getValore();
                            continue;
                        }
                        if (!cp.getNome().equals("hostnameVerifier")) continue;
                        hostNameVerifier = cp.getValore();
                    }
                    if (urlConn == null) {
                        if (oggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, \u00e8 di tipo http, ma non ha una url definita");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " \u00e8 di tipo http, ma non ha una url definita");
                        }
                    } else {
                        try {
                            this.validaUrl(urlConn);
                        }
                        catch (Exception e) {
                            if (oggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, \u00e8 di tipo http, ma non ha una url valida: " + e.getMessage());
                            }
                            this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " \u00e8 di tipo http, ma non ha una url valida: " + e.getMessage());
                        }
                    }
                    if (trustStoreLocation != null) {
                        File f = new File(trustStoreLocation);
                        if (!f.exists()) {
                            if (oggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, definisce un truststore " + trustStoreLocation + " che non esiste");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " definisce un truststore " + trustStoreLocation + " che non esiste");
                            }
                        } else if (!f.isFile()) {
                            if (oggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, definisce un truststore " + trustStoreLocation + " che non e' un file");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " definisce un truststore " + trustStoreLocation + " che non e' un file");
                            }
                        } else if (!f.canRead()) {
                            if (oggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, definisce un truststore " + trustStoreLocation + " che non e' accessibile (permessi in lettura non forniti)");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " definisce un truststore " + trustStoreLocation + " che non e' accessibile (permessi in lettura non forniti)");
                            }
                        } else if (trustStorePassword == null) {
                            if (oggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, definisce un truststore " + trustStoreLocation + " per cui non e' stata specificata una password");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " definisce un truststore " + trustStoreLocation + " per cui non e' stata specificata una password");
                            }
                        }
                    }
                    if (keyStoreLocation != null) {
                        File f = new File(keyStoreLocation);
                        if (!f.exists()) {
                            if (oggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, definisce un keystore " + keyStoreLocation + " che non esiste");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " definisce un keystore " + keyStoreLocation + " che non esiste");
                            }
                        } else if (!f.isFile()) {
                            if (oggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, definisce un keystore " + keyStoreLocation + " che non e' un file");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " definisce un keystore " + keyStoreLocation + " che non e' un file");
                            }
                        } else if (!f.canRead()) {
                            if (oggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, definisce un keystore " + keyStoreLocation + " che non e' accessibile (permessi in lettura non forniti)");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " definisce un keystore " + keyStoreLocation + " che non e' accessibile (permessi in lettura non forniti)");
                            }
                        } else if (keyStorePassword == null) {
                            if (oggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, definisce un keystore " + keyStoreLocation + " per cui non e' stata specificata una password");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " definisce un keystore " + keyStoreLocation + " per cui non e' stata specificata una password");
                            }
                        } else if (keyPassword == null) {
                            if (oggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, definisce un keystore " + keyStoreLocation + " per cui non e' stata specificata una password per la chiave privata");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " definisce un keystore " + keyStoreLocation + " per cui non e' stata specificata una password per la chiave privata");
                            }
                        }
                    }
                    if (hostNameVerifier != null) {
                        try {
                            Boolean.parseBoolean(hostNameVerifier);
                        }
                        catch (Exception e) {
                            if (oggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, associa un valore non valido  alla proprieta' 'hostNameVerifier'; valori utilizzabili: true e false");
                                break block117;
                            }
                            this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " associa un valore non valido  alla proprieta' 'hostNameVerifier'; valori utilizzabili: true e false");
                        }
                    }
                } else if (tipoConn.equals(TipiConnettore.DISABILITATO.getNome()) && cpArray != null) {
                    if (oggetto == null) {
                        this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, \u00e8 di tipo disabilitato, ma ha delle properties definite");
                    } else {
                        this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " \u00e8 di tipo disabilitato, ma ha delle properties definite");
                    }
                }
            }
        }
    }

    private void validateDocumento(Documento doc, RuoliDocumento ruolo, String oggetto) {
        if (doc.getTipo() == null) {
            this.errori.add("Esiste un documento con ruolo (" + ruolo.toString() + ") per l'oggetto " + oggetto + " per cui non \u00e8 definito il tipo");
            return;
        }
        if (doc.getFile() == null) {
            this.errori.add("Esiste un documento con ruolo (" + ruolo.toString() + ") per l'oggetto " + oggetto + " per cui non \u00e8 definito il file");
            return;
        }
        String idDocumento = "(" + ruolo.toString() + ")(" + doc.getTipo() + ")(" + doc.getFile() + ") ";
        if (!RuoliDocumento.allegato.toString().equals(ruolo.toString())) {
            String[] tipi;
            if (RuoliDocumento.specificaSemiformale.toString().equals(ruolo.toString())) {
                if (TipiDocumentoSemiformale.toEnumConstant(doc.getTipo()) == null) {
                    tipi = TipiDocumentoSemiformale.toStringArray();
                    StringBuffer bf = new StringBuffer();
                    for (int i = 0; i < tipi.length; ++i) {
                        if (i > 0) {
                            bf.append(",");
                        }
                        bf.append(tipi[i]);
                    }
                    this.errori.add(idDocumento + " tipo non utilizzabile in una specifica semiformale (oggetto: " + oggetto + "), valori ammessi: ");
                }
            } else if (RuoliDocumento.specificaCoordinamento.toString().equals(ruolo.toString())) {
                if (TipiDocumentoCoordinamento.toEnumConstant(doc.getTipo()) == null) {
                    tipi = TipiDocumentoCoordinamento.toStringArray();
                    StringBuffer bf = new StringBuffer();
                    for (int i = 0; i < tipi.length; ++i) {
                        if (i > 0) {
                            bf.append(",");
                        }
                        bf.append(tipi[i]);
                    }
                    this.errori.add(idDocumento + " tipo non utilizzabile in una specifica di coordinamento (oggetto: " + oggetto + "), valori ammessi: ");
                }
            } else if (RuoliDocumento.specificaLivelloServizio.toString().equals(ruolo.toString())) {
                if (TipiDocumentoLivelloServizio.toEnumConstant(doc.getTipo()) == null) {
                    tipi = TipiDocumentoLivelloServizio.toStringArray();
                    StringBuffer bf = new StringBuffer();
                    for (int i = 0; i < tipi.length; ++i) {
                        if (i > 0) {
                            bf.append(",");
                        }
                        bf.append(tipi[i]);
                    }
                    this.errori.add(idDocumento + " tipo non utilizzabile in una specifica dei livelli di servizio (oggetto: " + oggetto + "), valori ammessi: ");
                }
            } else if (RuoliDocumento.specificaSicurezza.toString().equals(ruolo.toString())) {
                if (TipiDocumentoSicurezza.toEnumConstant(doc.getTipo()) == null) {
                    tipi = TipiDocumentoSicurezza.toStringArray();
                    StringBuffer bf = new StringBuffer();
                    for (int i = 0; i < tipi.length; ++i) {
                        if (i > 0) {
                            bf.append(",");
                        }
                        bf.append(tipi[i]);
                    }
                    this.errori.add(idDocumento + " tipo non utilizzabile in una specifica di sicurezza (oggetto: " + oggetto + "), valori ammessi: ");
                }
            } else {
                this.errori.add(idDocumento + " ruolo non conosciuto (oggetto: " + oggetto + "): " + ruolo.toString());
            }
        }
        try {
            Utilities.validateUri(doc.getFile(), this.checkEsistenzaFileDefinitoTramiteURI);
        }
        catch (Exception e) {
            this.errori.add(idDocumento + " file non valido (oggetto: " + oggetto + "): " + e.getMessage());
        }
    }

    private void validaUrl(String url) throws MalformedURLException {
        URL testUrl = new URL(url);
        testUrl.toString();
    }

    private boolean existsAccordoCooperazione(String uriAccordo) throws DriverRegistroServiziException {
        return this.getAccordoCooperazione(uriAccordo) != null;
    }

    private AccordoCooperazione getAccordoCooperazione(String uriAccordo) throws DriverRegistroServiziException {
        for (int j = 0; j < this.registro.sizeAccordoCooperazioneList(); ++j) {
            AccordoCooperazione ac = this.registro.getAccordoCooperazione(j);
            if (!IDAccordoCooperazione.getUriFromAccordo(ac).equals(uriAccordo)) continue;
            return ac;
        }
        return null;
    }

    private boolean existsAccordoServizio(String uriAccordo) throws DriverRegistroServiziException {
        return this.getAccordoServizio(uriAccordo) != null;
    }

    private AccordoServizio getAccordoServizio(String uriAccordo) throws DriverRegistroServiziException {
        for (int j = 0; j < this.registro.sizeAccordoServizioList(); ++j) {
            AccordoServizio as = this.registro.getAccordoServizio(j);
            if (!IDAccordo.getUriFromAccordo(as).equals(uriAccordo)) continue;
            return as;
        }
        return null;
    }

    private boolean existsAzione_AccordoServizio(AccordoServizio as, String azione) throws DriverRegistroServiziException {
        return this.getAzione_AccordoServizio(as, azione) != null;
    }

    private Azione getAzione_AccordoServizio(AccordoServizio as, String azione) throws DriverRegistroServiziException {
        for (int j = 0; j < as.sizeAzioneList(); ++j) {
            Azione az = as.getAzione(j);
            if (!az.getNome().equals(azione)) continue;
            return az;
        }
        return null;
    }

    private boolean existsPortType_AccordoServizio(AccordoServizio as, String porttype) throws DriverRegistroServiziException {
        return this.getPortType_AccordoServizio(as, porttype) != null;
    }

    private PortType getPortType_AccordoServizio(AccordoServizio as, String porttype) throws DriverRegistroServiziException {
        for (int j = 0; j < as.sizePortTypeList(); ++j) {
            PortType pt = as.getPortType(j);
            if (!pt.getNome().equals(porttype)) continue;
            return pt;
        }
        return null;
    }

    private boolean existsAzione_PortType_AccordoServizio(PortType pt, String azione) throws DriverRegistroServiziException {
        return this.getAzione_PortType_AccordoServizio(pt, azione) != null;
    }

    private Operation getAzione_PortType_AccordoServizio(PortType pt, String azione) throws DriverRegistroServiziException {
        for (int j = 0; j < pt.sizeAzioneList(); ++j) {
            Operation az = pt.getAzione(j);
            if (!az.getNome().equals(azione)) continue;
            return az;
        }
        return null;
    }

    private boolean existsPortaDominio(String nome) {
        return this.getPortaDominio(nome) != null;
    }

    private PortaDominio getPortaDominio(String nome) {
        for (int j = 0; j < this.registro.sizePortaDominioList(); ++j) {
            PortaDominio pdd = this.registro.getPortaDominio(j);
            if (!nome.equals(pdd.getNome())) continue;
            return pdd;
        }
        return null;
    }

    private boolean existsSoggettoSPCoop(String tipo, String nome) {
        return this.getSoggettoSPCoop(tipo, nome) != null;
    }

    private SoggettoSpcoop getSoggettoSPCoop(String tipo, String nome) {
        for (int j = 0; j < this.registro.sizeSoggettoSpcoopList(); ++j) {
            SoggettoSpcoop ss = this.registro.getSoggettoSpcoop(j);
            if (!tipo.equals(ss.getTipo()) || !nome.equals(ss.getNome())) continue;
            return ss;
        }
        return null;
    }

    private boolean existsServizioSPCoop(String tipo, String nome, String tipoSoggetto, String nomeSoggetto) {
        return this.getServizioSPCoop(tipo, nome, tipoSoggetto, nomeSoggetto) != null;
    }

    private ServizioSpcoop getServizioSPCoop(String tipo, String nome, String tipoSoggetto, String nomeSoggetto) {
        for (int j = 0; j < this.registro.sizeSoggettoSpcoopList(); ++j) {
            ServizioSpcoop serv;
            int h;
            SoggettoSpcoop ss = this.registro.getSoggettoSpcoop(j);
            if (!tipoSoggetto.equals(ss.getTipo()) || !nomeSoggetto.equals(ss.getNome())) continue;
            for (h = 0; h < ss.sizeServizioList(); ++h) {
                serv = ss.getServizio(h);
                if (!tipo.equals(serv.getTipo()) || !nome.equals(serv.getNome())) continue;
                return serv;
            }
            for (h = 0; h < ss.sizeServizioCorrelatoList(); ++h) {
                serv = ss.getServizioCorrelato(h);
                if (!tipo.equals(serv.getTipo()) || !nome.equals(serv.getNome())) continue;
                return serv;
            }
        }
        return null;
    }
}

