/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.dao.registry.driver;

import java.net.MalformedURLException;
import java.util.Vector;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziException;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop.dao.registry.driver.IDAccordo;
import org.openspcoop.dao.registry.driver.IDAccordoCooperazione;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.uddi4j.UDDIException;
import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.Name;
import org.uddi4j.datatype.OverviewDoc;
import org.uddi4j.datatype.OverviewURL;
import org.uddi4j.datatype.binding.AccessPoint;
import org.uddi4j.datatype.binding.BindingTemplate;
import org.uddi4j.datatype.binding.BindingTemplates;
import org.uddi4j.datatype.binding.TModelInstanceDetails;
import org.uddi4j.datatype.binding.TModelInstanceInfo;
import org.uddi4j.datatype.business.BusinessEntity;
import org.uddi4j.datatype.service.BusinessService;
import org.uddi4j.datatype.service.BusinessServices;
import org.uddi4j.datatype.tmodel.TModel;
import org.uddi4j.response.AuthToken;
import org.uddi4j.response.BindingDetail;
import org.uddi4j.response.BusinessDetail;
import org.uddi4j.response.BusinessInfo;
import org.uddi4j.response.BusinessList;
import org.uddi4j.response.ServiceDetail;
import org.uddi4j.response.ServiceInfo;
import org.uddi4j.response.ServiceList;
import org.uddi4j.response.TModelDetail;
import org.uddi4j.response.TModelInfo;
import org.uddi4j.response.TModelList;
import org.uddi4j.transport.TransportException;
import org.uddi4j.util.CategoryBag;
import org.uddi4j.util.FindQualifier;
import org.uddi4j.util.FindQualifiers;
import org.uddi4j.util.IdentifierBag;
import org.uddi4j.util.KeyedReference;
import org.uddi4j.util.TModelBag;
import org.uddi4j.util.TModelKey;

public class UDDILib {
    protected String tmkID = "uuid:b6ba2f0c-b4e5-40c4-a4f4-6212aa8d389f";
    private static int MAX_SEARCH = Integer.MAX_VALUE;
    protected UDDIProxy proxy = null;
    protected String username;
    protected String password;
    public boolean create = false;
    protected String error;
    public static final String TMODEL_OPENSPCOOP = "OpenSPCoop:SPCoopIdentifier";
    public static final String ACCORDO_SERVIZIO = "AccordoServizio";
    public static final String PORTA_DOMINIO = "PortaDominio";
    public static final String PORTA_DOMINIO_PREFIX = "PdD@";
    public static final String ACCORDO_COOPERAZIONE = "AccordoCooperazione";
    public static final String ACCORDO_COOPERAZIONE_PREFIX = "AccordoCooperazione@";

    public String getErrore() {
        return this.error;
    }

    public UDDILib(String inquiry, String publish, String user, String password) {
        try {
            this.proxy = new UDDIProxy();
            if (inquiry != null) {
                this.proxy.setInquiryURL(inquiry);
            }
            if (publish != null) {
                this.proxy.setPublishURL(publish);
            }
            this.username = user;
            this.password = password;
            this.create = true;
        }
        catch (MalformedURLException e) {
            this.error = e.getMessage();
            this.create = false;
        }
        catch (Exception e) {
            this.error = e.getMessage();
            this.create = false;
        }
    }

    public UDDILib(String inquiry, String user, String password) {
        this(inquiry, null, user, password);
    }

    public UDDILib(String inquiry) {
        this(inquiry, null, null, null);
    }

    protected TModel getTModel(String tipoOggetto, String nome) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (nome == null) {
            throw new DriverRegistroServiziException("[UDDILib.getTModel(" + tipoOggetto + ")]: Alcuni parametri non definiti");
        }
        TModel tm = null;
        try {
            FindQualifiers findQualifiers = new FindQualifiers();
            Vector<FindQualifier> qualifier = new Vector<FindQualifier>();
            qualifier.add(new FindQualifier("exactNameMatch"));
            qualifier.add(new FindQualifier("caseSensitiveMatch"));
            findQualifiers.setFindQualifierVector(qualifier);
            TModelList tmodelList = this.proxy.find_tModel(nome, null, null, findQualifiers, 1);
            if (tmodelList.getTModelInfos() == null || tmodelList.getTModelInfos().size() == 0) {
                throw new DriverRegistroServiziNotFound("TModel(" + tipoOggetto + ") non trovata");
            }
            Vector tmodelInfoVector = tmodelList.getTModelInfos().getTModelInfoVector();
            TModelInfo tmodelInfo = (TModelInfo)tmodelInfoVector.elementAt(0);
            TModelDetail tmd = this.proxy.get_tModelDetail(tmodelInfo.getTModelKey());
            Vector tmv = tmd.getTModelVector();
            tm = (TModel)tmv.elementAt(0);
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (UDDIException e) {
            throw new DriverRegistroServiziException("[UDDILib.getTModel(" + tipoOggetto + ")]: " + e.getMessage(), e);
        }
        catch (TransportException e) {
            throw new DriverRegistroServiziException("[UDDILib.getTModel(" + tipoOggetto + ")]: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.getTModel(" + tipoOggetto + ")]: " + e.getMessage(), e);
        }
        return tm;
    }

    private TModel[] getTModelByFilter(String tipoOggetto, String searchNome, String urlRepository, boolean ricercaEsatta) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            String nomeRicerca = null;
            nomeRicerca = searchNome != null ? searchNome : "%";
            FindQualifiers findQualifiers = null;
            if (ricercaEsatta && !nomeRicerca.equals("%")) {
                findQualifiers = new FindQualifiers();
                Vector<FindQualifier> qualifier = new Vector<FindQualifier>();
                qualifier.add(new FindQualifier("exactNameMatch"));
                qualifier.add(new FindQualifier("caseSensitiveMatch"));
                findQualifiers.setFindQualifierVector(qualifier);
            }
            TModelList tmodelList = this.proxy.find_tModel(nomeRicerca, null, null, findQualifiers, MAX_SEARCH);
            Vector<TModel> tmodels = new Vector<TModel>();
            if (tmodelList.getTModelInfos() != null) {
                Vector tmodelInfoVector = tmodelList.getTModelInfos().getTModelInfoVector();
                for (int i = 0; i < tmodelInfoVector.size(); ++i) {
                    TModelInfo tmodelInfo = (TModelInfo)tmodelInfoVector.elementAt(i);
                    TModelDetail tmd = this.proxy.get_tModelDetail(tmodelInfo.getTModelKey());
                    Vector tmv = tmd.getTModelVector();
                    TModel t = (TModel)tmv.elementAt(0);
                    if (urlRepository != null) {
                        if (t.getOverviewDoc() == null || t.getOverviewDoc().getOverviewURLString() == null || !t.getOverviewDoc().getOverviewURLString().startsWith(urlRepository)) continue;
                        if (ACCORDO_SERVIZIO.equals(tipoOggetto)) {
                            if (t.getNameString().startsWith(ACCORDO_COOPERAZIONE_PREFIX) || t.getNameString().startsWith(PORTA_DOMINIO_PREFIX)) continue;
                            tmodels.add(t);
                            continue;
                        }
                        tmodels.add(t);
                        continue;
                    }
                    if (ACCORDO_SERVIZIO.equals(tipoOggetto)) {
                        if (t.getNameString().startsWith(ACCORDO_COOPERAZIONE_PREFIX) || t.getNameString().startsWith(PORTA_DOMINIO_PREFIX)) continue;
                        tmodels.add(t);
                        continue;
                    }
                    tmodels.add(t);
                }
            }
            if (tmodels.size() > 0) {
                TModel[] tm = new TModel[1];
                tm = tmodels.toArray(tm);
                return tm;
            }
            throw new DriverRegistroServiziNotFound("Non sono state trovate TModelByFilter(" + tipoOggetto + ") nel registro UDDI con nome: " + searchNome);
        }
        catch (UDDIException e) {
            throw new DriverRegistroServiziException("[UDDILib.getTModelByFilter(" + tipoOggetto + ")]: " + e.getMessage(), e);
        }
        catch (TransportException e) {
            throw new DriverRegistroServiziException("[UDDILib.getTModelByFilter(" + tipoOggetto + ")]: " + e.getMessage(), e);
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.getTModelByFilter(" + tipoOggetto + ")]: " + e.getMessage(), e);
        }
    }

    private void createTModel(String tipoOggetto, String nome, String url) throws DriverRegistroServiziException {
        if (nome == null || url == null) {
            throw new DriverRegistroServiziException("[UDDILib.createTModel(" + tipoOggetto + ")]: Alcuni parametri non definiti");
        }
        try {
            AuthToken token = this.proxy.get_authToken(this.username, this.password);
            Vector<TModel> tms = new Vector<TModel>();
            TModel tm = new TModel("", nome);
            OverviewDoc od = new OverviewDoc();
            OverviewURL ou = new OverviewURL();
            ou.setText(url);
            od.setOverviewURL(ou);
            tm.setOverviewDoc(od);
            tms.add(tm);
            this.proxy.save_tModel(token.getAuthInfoString(), tms);
        }
        catch (UDDIException e) {
            throw new DriverRegistroServiziException("[UDDILib.createTModel(" + tipoOggetto + ")]: " + e.getMessage(), e);
        }
        catch (TransportException e) {
            throw new DriverRegistroServiziException("[UDDILib.createTModel(" + tipoOggetto + ")]: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.createTModel(" + tipoOggetto + ")]: " + e.getMessage(), e);
        }
    }

    private void updateTModel(String tipoOggetto, String nomeOLD, String nomeNEW, String url) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (nomeOLD == null || url == null || nomeNEW == null) {
            throw new DriverRegistroServiziException("[UDDILib.updateTModel(" + tipoOggetto + ")]: Alcuni parametri non definiti");
        }
        TModel tm = null;
        try {
            AuthToken token = this.proxy.get_authToken(this.username, this.password);
            tm = this.getTModel(tipoOggetto, nomeOLD);
            OverviewDoc od = tm.getOverviewDoc();
            OverviewURL ou = od.getOverviewURL();
            ou.setText(url);
            od.setOverviewURL(ou);
            tm.setOverviewDoc(od);
            tm.setName(nomeNEW);
            Vector<TModel> tms = new Vector<TModel>();
            tms.add(tm);
            this.proxy.save_tModel(token.getAuthInfoString(), tms);
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (UDDIException e) {
            throw new DriverRegistroServiziException("[UDDILib.updateTModel(" + tipoOggetto + ")]: " + e.getMessage(), e);
        }
        catch (TransportException e) {
            throw new DriverRegistroServiziException("[UDDILib.updateTModel(" + tipoOggetto + ")]: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.updateTModel(" + tipoOggetto + ")]: " + e.getMessage(), e);
        }
    }

    private void deleteTModel(String tipoOggetto, String nome) throws DriverRegistroServiziException {
        if (nome == null) {
            throw new DriverRegistroServiziException("[UDDILib.deleteTModel(" + tipoOggetto + ")]: Alcuni parametri non definiti");
        }
        try {
            AuthToken token = this.proxy.get_authToken(this.username, this.password);
            FindQualifiers findQualifiers = new FindQualifiers();
            Vector<FindQualifier> qualifier = new Vector<FindQualifier>();
            qualifier.add(new FindQualifier("exactNameMatch"));
            qualifier.add(new FindQualifier("caseSensitiveMatch"));
            findQualifiers.setFindQualifierVector(qualifier);
            TModelList tmodelList = this.proxy.find_tModel(nome, null, null, findQualifiers, 1);
            Vector tmodelInfoVector = tmodelList.getTModelInfos().getTModelInfoVector();
            TModelInfo tmodelInfo = (TModelInfo)tmodelInfoVector.elementAt(0);
            this.proxy.delete_tModel(token.getAuthInfoString(), tmodelInfo.getTModelKey());
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.deleteTModel(" + tipoOggetto + ")]: " + e.getMessage(), e);
        }
    }

    private void updateUrlXmlTModel(String tipoOggetto, String nome, String url) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (nome == null || url == null) {
            throw new DriverRegistroServiziException("[UDDILib.updateUrlXmlTModel(" + tipoOggetto + ")]: Alcuni parametri non definiti");
        }
        try {
            AuthToken token = this.proxy.get_authToken(this.username, this.password);
            TModel tm = this.getTModel(tipoOggetto, nome);
            Vector<TModel> tms = new Vector<TModel>();
            OverviewDoc od = tm.getOverviewDoc();
            OverviewURL ou = od.getOverviewURL();
            ou.setText(url);
            od.setOverviewURL(ou);
            tm.setOverviewDoc(od);
            tms.add(tm);
            this.proxy.save_tModel(token.getAuthInfoString(), tms);
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.updateUrlXmlTModel(" + tipoOggetto + ")]: " + e.getMessage(), e);
        }
    }

    public TModel getAccordoCooperazione(IDAccordoCooperazione idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        String uriAccordo = IDAccordoCooperazione.getUriFromIDAccordo(idAccordo);
        return this.getTModel(ACCORDO_COOPERAZIONE, ACCORDO_COOPERAZIONE_PREFIX + uriAccordo);
    }

    public TModel[] getAccordiCooperazione(String urlRepository) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getTModelByFilter(ACCORDO_COOPERAZIONE, ACCORDO_COOPERAZIONE_PREFIX, urlRepository, false);
    }

    public void createAccordoCooperazione(IDAccordoCooperazione idAccordo, String url) throws DriverRegistroServiziException {
        String uriAccordo = IDAccordoCooperazione.getUriFromIDAccordo(idAccordo);
        this.createTModel(ACCORDO_COOPERAZIONE, ACCORDO_COOPERAZIONE_PREFIX + uriAccordo, url);
    }

    public boolean existsAccordoCooperazione(IDAccordoCooperazione idAccordo) throws DriverRegistroServiziException {
        if (idAccordo == null) {
            throw new DriverRegistroServiziException("[UDDILib.existsAccordoCooperazione]: Alcuni parametri non definiti");
        }
        String uriAccordo = IDAccordoCooperazione.getUriFromIDAccordo(idAccordo);
        try {
            TModel t = this.getTModel(ACCORDO_COOPERAZIONE, ACCORDO_COOPERAZIONE_PREFIX + uriAccordo);
            if (t == null) {
                throw new Exception("TModel is null");
            }
        }
        catch (DriverRegistroServiziNotFound e) {
            return false;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        return true;
    }

    public void updateAccordoCooperazione(IDAccordoCooperazione idAccordoOLD, IDAccordoCooperazione idAccordoNEW, String url) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        String uriAccordoOLD = IDAccordoCooperazione.getUriFromIDAccordo(idAccordoOLD);
        String uriAccordoNEW = IDAccordoCooperazione.getUriFromIDAccordo(idAccordoNEW);
        this.updateTModel(ACCORDO_COOPERAZIONE, ACCORDO_COOPERAZIONE_PREFIX + uriAccordoOLD, ACCORDO_COOPERAZIONE_PREFIX + uriAccordoNEW, url);
    }

    public void deleteAccordoCooperazione(IDAccordoCooperazione idAccordo) throws DriverRegistroServiziException {
        String uriAccordo = IDAccordoCooperazione.getUriFromIDAccordo(idAccordo);
        this.deleteTModel(ACCORDO_COOPERAZIONE, ACCORDO_COOPERAZIONE_PREFIX + uriAccordo);
    }

    public void updateUrlXmlAccordoCooperazione(IDAccordoCooperazione idAccordo, String url) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        String uriAccordo = IDAccordoCooperazione.getUriFromIDAccordo(idAccordo);
        this.updateUrlXmlTModel(ACCORDO_COOPERAZIONE, ACCORDO_COOPERAZIONE_PREFIX + uriAccordo, url);
    }

    public String getUrlXmlAccordoCooperazione(IDAccordoCooperazione idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idAccordo == null) {
            throw new DriverRegistroServiziException("[UDDILib.getUrlXmlAccordoCooperazione]: Alcuni parametri non definiti");
        }
        try {
            String uriAccordo = IDAccordoCooperazione.getUriFromIDAccordo(idAccordo);
            TModel tm = this.getTModel(ACCORDO_COOPERAZIONE, ACCORDO_COOPERAZIONE_PREFIX + uriAccordo);
            return tm.getOverviewDoc().getOverviewURLString();
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.getUrlXmlAccordoCooperazione]: " + e.getMessage(), e);
        }
    }

    public String[] getUrlXmlAccordiCooperazione(IDAccordoCooperazione idAccordo, String urlPrefix) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            TModel[] tm = null;
            if (idAccordo != null) {
                String uriAccordo = IDAccordoCooperazione.getUriFromIDAccordo(idAccordo);
                tm = this.getTModelByFilter(ACCORDO_COOPERAZIONE, ACCORDO_COOPERAZIONE_PREFIX + uriAccordo, urlPrefix, true);
            } else {
                tm = this.getTModelByFilter(ACCORDO_COOPERAZIONE, ACCORDO_COOPERAZIONE_PREFIX, urlPrefix, false);
            }
            if (tm != null) {
                String[] url = new String[tm.length];
                for (int i = 0; i < tm.length; ++i) {
                    url[i] = tm[i].getOverviewDoc().getOverviewURLString();
                }
                return url;
            }
            throw new DriverRegistroServiziNotFound("Accordi di Cooperazione (definizione XML) non trovati");
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.getUrlXmlAccordiCooperazione]: " + e.getMessage(), e);
        }
    }

    public TModel getAccordoServizio(IDAccordo idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        String uriAccordo = IDAccordo.getUriFromIDAccordo(idAccordo);
        return this.getTModel(ACCORDO_SERVIZIO, uriAccordo);
    }

    public TModel[] getAccordiServizio(String urlRepository) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getTModelByFilter(ACCORDO_SERVIZIO, null, urlRepository, false);
    }

    public void createAccordoServizio(IDAccordo idAccordo, String url) throws DriverRegistroServiziException {
        String uriAccordo = IDAccordo.getUriFromIDAccordo(idAccordo);
        this.createTModel(ACCORDO_SERVIZIO, uriAccordo, url);
    }

    public boolean existsAccordoServizio(IDAccordo idAccordo) throws DriverRegistroServiziException {
        if (idAccordo == null) {
            throw new DriverRegistroServiziException("[UDDILib.existsAccordoServizio]: Alcuni parametri non definiti");
        }
        String uriAccordo = IDAccordo.getUriFromIDAccordo(idAccordo);
        try {
            TModel t = this.getTModel(ACCORDO_SERVIZIO, uriAccordo);
            if (t == null) {
                throw new Exception("TModel is null");
            }
        }
        catch (DriverRegistroServiziNotFound e) {
            return false;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        return true;
    }

    public void updateAccordoServizio(IDAccordo idAccordoOLD, IDAccordo idAccordoNEW, String url) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        String uriAccordoOLD = IDAccordo.getUriFromIDAccordo(idAccordoOLD);
        String uriAccordoNEW = IDAccordo.getUriFromIDAccordo(idAccordoNEW);
        this.updateTModel(ACCORDO_SERVIZIO, uriAccordoOLD, uriAccordoNEW, url);
    }

    public void deleteAccordoServizio(IDAccordo idAccordo) throws DriverRegistroServiziException {
        String uriAccordo = IDAccordo.getUriFromIDAccordo(idAccordo);
        this.deleteTModel(ACCORDO_SERVIZIO, uriAccordo);
    }

    public void updateUrlXmlAccordoServizio(IDAccordo idAccordo, String url) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        String uriAccordo = IDAccordo.getUriFromIDAccordo(idAccordo);
        this.updateUrlXmlTModel(ACCORDO_SERVIZIO, uriAccordo, url);
    }

    public String getUrlXmlAccordoServizio(IDAccordo idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idAccordo == null) {
            throw new DriverRegistroServiziException("[UDDILib.getUrlXmlAccordoServizio]: Alcuni parametri non definiti");
        }
        try {
            String uriAccordo = IDAccordo.getUriFromIDAccordo(idAccordo);
            TModel tm = this.getTModel(ACCORDO_SERVIZIO, uriAccordo);
            return tm.getOverviewDoc().getOverviewURLString();
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.getUrlXmlAccordoServizio]: " + e.getMessage(), e);
        }
    }

    public String[] getUrlXmlAccordiServizio(IDAccordo idAccordo, String urlRepository) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            TModel[] tm = null;
            if (idAccordo != null) {
                String uriAccordo = IDAccordo.getUriFromIDAccordo(idAccordo);
                tm = this.getTModelByFilter(ACCORDO_SERVIZIO, uriAccordo, urlRepository, true);
            } else {
                tm = this.getTModelByFilter(ACCORDO_SERVIZIO, null, urlRepository, false);
            }
            if (tm != null) {
                String[] url = new String[tm.length];
                for (int i = 0; i < tm.length; ++i) {
                    url[i] = tm[i].getOverviewDoc().getOverviewURLString();
                }
                return url;
            }
            throw new DriverRegistroServiziNotFound("Accordi di Servizio (definizione XML) non trovati");
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.getUrlXmlAccordoServizio]: " + e.getMessage(), e);
        }
    }

    public TModel getPortaDominio(String nome) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getTModel(PORTA_DOMINIO, PORTA_DOMINIO_PREFIX + nome);
    }

    public TModel[] getPorteDominio(String urlRepository) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getTModelByFilter(PORTA_DOMINIO, PORTA_DOMINIO_PREFIX, urlRepository, false);
    }

    public void createPortaDominio(String nome, String url) throws DriverRegistroServiziException {
        this.createTModel(PORTA_DOMINIO, PORTA_DOMINIO_PREFIX + nome, url);
    }

    public boolean existsPortaDominio(String nome) throws DriverRegistroServiziException {
        if (nome == null) {
            throw new DriverRegistroServiziException("[UDDILib.existsPortaDominio]: Alcuni parametri non definiti");
        }
        try {
            TModel t = this.getTModel(PORTA_DOMINIO, PORTA_DOMINIO_PREFIX + nome);
            if (t == null) {
                throw new Exception("TModel is null");
            }
        }
        catch (DriverRegistroServiziNotFound e) {
            return false;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        return true;
    }

    public void updatePortaDominio(String nomeOLD, String nomeNEW, String url) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        this.updateTModel(PORTA_DOMINIO, PORTA_DOMINIO_PREFIX + nomeOLD, PORTA_DOMINIO_PREFIX + nomeNEW, url);
    }

    public void deletePortaDominio(String nome) throws DriverRegistroServiziException {
        this.deleteTModel(PORTA_DOMINIO, PORTA_DOMINIO_PREFIX + nome);
    }

    public void updateUrlXmlPortaDominio(String nome, String url) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        this.updateUrlXmlTModel(PORTA_DOMINIO, PORTA_DOMINIO_PREFIX + nome, url);
    }

    public String getUrlXmlPortaDominio(String nome) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (nome == null) {
            throw new DriverRegistroServiziException("[UDDILib.getUrlXmlPortaDominio]: Alcuni parametri non definiti");
        }
        try {
            TModel tm = this.getTModel(PORTA_DOMINIO, PORTA_DOMINIO_PREFIX + nome);
            return tm.getOverviewDoc().getOverviewURLString();
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.getUrlXmlPortaDominio]: " + e.getMessage(), e);
        }
    }

    public String[] getUrlXmlPortaDominio(String searchNome, String urlRepository) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            TModel[] tm = null;
            tm = searchNome != null ? this.getTModelByFilter(PORTA_DOMINIO, PORTA_DOMINIO_PREFIX + searchNome, urlRepository, true) : this.getTModelByFilter(PORTA_DOMINIO, PORTA_DOMINIO_PREFIX, urlRepository, false);
            if (tm != null) {
                String[] url = new String[tm.length];
                for (int i = 0; i < tm.length; ++i) {
                    url[i] = tm[i].getOverviewDoc().getOverviewURLString();
                }
                return url;
            }
            throw new DriverRegistroServiziNotFound("Porte di Dominio (definizione XML) non trovate");
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.getUrlXmlPortaDominio]: " + e.getMessage(), e);
        }
    }

    protected BusinessEntity getBusinessEntity(IDSoggetto idSogg) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idSogg == null || idSogg.getNome() == null || idSogg.getTipo() == null) {
            throw new DriverRegistroServiziException("[UDDILib.getBusinessEntity]: Alcuni parametri non definiti");
        }
        String keyBE = idSogg.getTipo() + "/" + idSogg.getNome();
        BusinessEntity be = null;
        try {
            Vector<Name> names = new Vector<Name>();
            names.add(new Name("%"));
            IdentifierBag identifierBag = new IdentifierBag();
            KeyedReference k1 = new KeyedReference();
            k1.setKeyValue(keyBE);
            k1.setTModelKey(this.tmkID);
            Vector<KeyedReference> keyedReferenceVector = new Vector<KeyedReference>();
            keyedReferenceVector.add(k1);
            identifierBag.setKeyedReferenceVector(keyedReferenceVector);
            BusinessList businessList = this.proxy.find_business(names, null, identifierBag, null, null, null, 1);
            if (businessList.getBusinessInfos() == null || businessList.getBusinessInfos().size() == 0) {
                throw new DriverRegistroServiziNotFound("BusinessEntity non trovata");
            }
            Vector businessInfoVector = businessList.getBusinessInfos().getBusinessInfoVector();
            BusinessInfo bi = (BusinessInfo)businessInfoVector.elementAt(0);
            BusinessDetail bd = this.proxy.get_businessDetail(bi.getBusinessKey());
            Vector v = bd.getBusinessEntityVector();
            be = (BusinessEntity)v.elementAt(0);
        }
        catch (UDDIException e) {
            throw new DriverRegistroServiziException("[UDDILib.getBusinessEntity]: " + e.getMessage(), e);
        }
        catch (TransportException e) {
            throw new DriverRegistroServiziException("[UDDILib.getBusinessEntity]: " + e.getMessage(), e);
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.getBusinessEntity]: " + e.getMessage(), e);
        }
        return be;
    }

    protected BusinessEntity[] getBusinessEntities() throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            Vector<Name> names = new Vector<Name>();
            names.add(new Name("%"));
            Vector<BusinessEntity> bus = new Vector<BusinessEntity>();
            BusinessList businessList = this.proxy.find_business(names, null, null, null, null, null, MAX_SEARCH);
            if (businessList != null && businessList.getBusinessInfos() != null) {
                Vector businessInfoVector = businessList.getBusinessInfos().getBusinessInfoVector();
                for (int i = 0; i < businessInfoVector.size(); ++i) {
                    BusinessInfo bi = (BusinessInfo)businessInfoVector.elementAt(i);
                    BusinessDetail bd = this.proxy.get_businessDetail(bi.getBusinessKey());
                    Vector v = bd.getBusinessEntityVector();
                    BusinessEntity be = (BusinessEntity)v.elementAt(0);
                    bus.add(be);
                }
            }
            if (bus.size() > 0) {
                BusinessEntity[] be = new BusinessEntity[1];
                be = bus.toArray(be);
                return be;
            }
            throw new DriverRegistroServiziNotFound("Non sono state trovate BusinessEntity nel registro UDDI");
        }
        catch (UDDIException e) {
            throw new DriverRegistroServiziException("[UDDILib.getBusinessEntity]: " + e.getMessage(), e);
        }
        catch (TransportException e) {
            throw new DriverRegistroServiziException("[UDDILib.getBusinessEntity]: " + e.getMessage(), e);
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.getBusinessEntity]: " + e.getMessage(), e);
        }
    }

    protected BusinessEntity addBusinessEntity(IDSoggetto idSogg) throws DriverRegistroServiziException {
        if (idSogg == null || idSogg.getNome() == null || idSogg.getTipo() == null || idSogg.getCodicePorta() == null) {
            throw new DriverRegistroServiziException("[UDDILib.addBusinessEntity]: Alcuni parametri non definiti");
        }
        String keyBE = idSogg.getTipo() + "/" + idSogg.getNome();
        try {
            AuthToken token = this.proxy.get_authToken(this.username, this.password);
            KeyedReference k1 = new KeyedReference();
            k1.setKeyName(idSogg.getCodicePorta());
            k1.setKeyValue(keyBE);
            k1.setTModelKey(this.tmkID);
            Vector<KeyedReference> keyedReferenceVector1 = new Vector<KeyedReference>();
            keyedReferenceVector1.add(k1);
            BusinessEntity be = new BusinessEntity("", keyBE);
            IdentifierBag ib = new IdentifierBag();
            ib.setKeyedReferenceVector(keyedReferenceVector1);
            be.setIdentifierBag(ib);
            CategoryBag cb = new CategoryBag();
            be.setCategoryBag(cb);
            Vector<BusinessEntity> entities = new Vector<BusinessEntity>();
            entities.addElement(be);
            BusinessDetail bd = this.proxy.save_business(token.getAuthInfoString(), entities);
            Vector businessEntities = bd.getBusinessEntityVector();
            be = (BusinessEntity)businessEntities.elementAt(0);
            return be;
        }
        catch (UDDIException e) {
            throw new DriverRegistroServiziException("[UDDILib.addBusinessEntity]: " + e.getMessage(), e);
        }
        catch (TransportException e) {
            throw new DriverRegistroServiziException("[UDDILib.addBusinessEntity]: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.addBusinessEntity]: " + e.getMessage(), e);
        }
    }

    protected void deleteBusinessEntity(IDSoggetto idSogg) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idSogg == null || idSogg.getNome() == null || idSogg.getTipo() == null) {
            throw new DriverRegistroServiziException("[UDDILib.deleteBusinessEntity]: Alcuni parametri non definiti");
        }
        try {
            AuthToken token = this.proxy.get_authToken(this.username, this.password);
            BusinessEntity be = this.getBusinessEntity(idSogg);
            this.proxy.delete_business(token.getAuthInfoString(), be.getBusinessKey());
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.deleteBusinessEntity]: " + e.getMessage(), e);
        }
    }

    protected BusinessEntity updateNomeBusinessEntity(BusinessEntity be, String nome) throws DriverRegistroServiziException {
        if (be == null || nome == null) {
            throw new DriverRegistroServiziException("[UDDILib.updateNomeBusinessEntity]: Alcuni parametri non definiti");
        }
        try {
            be.setDefaultName(new Name(nome));
            Vector<BusinessEntity> entities = new Vector<BusinessEntity>();
            entities.addElement(be);
            AuthToken token = this.proxy.get_authToken(this.username, this.password);
            this.proxy.save_business(token.getAuthInfoString(), entities);
        }
        catch (UDDIException e) {
            throw new DriverRegistroServiziException("[UDDILib.updateDescrizioneBusinessEntity]: " + e.getMessage(), e);
        }
        catch (TransportException e) {
            throw new DriverRegistroServiziException("[UDDILib.updateDescrizioneBusinessEntity]: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.updateDescrizioneBusinessEntity]: " + e.getMessage(), e);
        }
        return be;
    }

    protected String getNomeBusinessEntity(BusinessEntity be) throws DriverRegistroServiziException {
        if (be == null) {
            throw new DriverRegistroServiziException("[UDDILib.getNomeBusinessEntity]: Alcuni parametri non definiti");
        }
        try {
            return be.getDefaultName().getText();
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.getNomeBusinessEntity]: " + e.getMessage(), e);
        }
    }

    protected BusinessEntity updateDescrizioneBusinessEntity(BusinessEntity be, String descrizione) throws DriverRegistroServiziException {
        if (be == null || descrizione == null) {
            throw new DriverRegistroServiziException("[UDDILib.updateDescrizioneBusinessEntity]: Alcuni parametri non definiti");
        }
        try {
            AuthToken token = this.proxy.get_authToken(this.username, this.password);
            be.setDefaultDescriptionString(descrizione);
            Vector<BusinessEntity> entities = new Vector<BusinessEntity>();
            entities.addElement(be);
            this.proxy.save_business(token.getAuthInfoString(), entities);
        }
        catch (UDDIException e) {
            throw new DriverRegistroServiziException("[UDDILib.updateDescrizioneBusinessEntity]: " + e.getMessage(), e);
        }
        catch (TransportException e) {
            throw new DriverRegistroServiziException("[UDDILib.updateDescrizioneBusinessEntity]: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.updateDescrizioneBusinessEntity]: " + e.getMessage(), e);
        }
        return be;
    }

    protected BusinessEntity updateUrlXmlBusinessEntity(BusinessEntity be, String url) throws DriverRegistroServiziException {
        if (be == null || url == null) {
            throw new DriverRegistroServiziException("[UDDILib.updateUrlXmlBusinessEntity]: Alcuni parametri non definiti");
        }
        try {
            AuthToken token = this.proxy.get_authToken(this.username, this.password);
            KeyedReference k1 = new KeyedReference();
            k1.setKeyName("OpenSPCoop");
            k1.setKeyValue(url);
            Vector<BusinessEntity> entities = new Vector<BusinessEntity>();
            CategoryBag ib = be.getCategoryBag();
            if (ib == null) {
                ib = new CategoryBag();
            }
            ib.add(k1);
            be.setCategoryBag(ib);
            entities.addElement(be);
            this.proxy.save_business(token.getAuthInfoString(), entities);
        }
        catch (UDDIException e) {
            throw new DriverRegistroServiziException("[UDDILib.updateUrlXmlBusinessEntity]: " + e.getMessage(), e);
        }
        catch (TransportException e) {
            throw new DriverRegistroServiziException("[UDDILib.updateUrlXmlBusinessEntity]: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.updateUrlXmlBusinessEntity]: " + e.getMessage(), e);
        }
        return be;
    }

    protected void updateCategoryBagKeyNameBusinessEntity(IDSoggetto idSogg, String categoryBagName) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idSogg == null || idSogg.getNome() == null || idSogg.getTipo() == null || categoryBagName == null) {
            throw new DriverRegistroServiziException("[UDDILib.updateCategoryBagKeyNameBusinessEntity]: Alcuni parametri non definiti");
        }
        try {
            AuthToken token = this.proxy.get_authToken(this.username, this.password);
            BusinessEntity be = this.getBusinessEntity(idSogg);
            CategoryBag cb = be.getCategoryBag();
            Vector krv = cb.getKeyedReferenceVector();
            KeyedReference kr = (KeyedReference)krv.elementAt(0);
            kr.setKeyName(categoryBagName);
            cb.setKeyedReferenceVector(krv);
            be.setCategoryBag(cb);
            Vector<BusinessEntity> entities = new Vector<BusinessEntity>();
            entities.addElement(be);
            this.proxy.save_business(token.getAuthInfoString(), entities);
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.updateCategoryBagKeyNameBusinessEntity]: " + e.getMessage(), e);
        }
    }

    public void createSoggetto(IDSoggetto idSogg, String descrizione, String urlXML) throws DriverRegistroServiziException {
        if (idSogg == null || idSogg.getNome() == null || idSogg.getTipo() == null || descrizione == null || idSogg.getCodicePorta() == null || urlXML == null) {
            throw new DriverRegistroServiziException("[UDDILib.createSoggetto]: Alcuni parametri non definiti");
        }
        try {
            BusinessEntity be = this.addBusinessEntity(idSogg);
            try {
                be = this.updateNomeBusinessEntity(be, descrizione);
            }
            catch (Exception e) {
                try {
                    this.deleteBusinessEntity(idSogg);
                }
                catch (Exception rollbackE) {
                    // empty catch block
                }
                throw e;
            }
            try {
                this.updateUrlXmlBusinessEntity(be, urlXML);
            }
            catch (Exception e) {
                try {
                    this.deleteBusinessEntity(idSogg);
                }
                catch (Exception rollbackE) {
                    // empty catch block
                }
                throw e;
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.createSoggetto]: " + e.getMessage(), e);
        }
    }

    public boolean existsSoggetto(IDSoggetto idSogg) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idSogg == null) {
            throw new DriverRegistroServiziException("[UDDILib.existsSoggetto]: Alcuni parametri non definiti");
        }
        BusinessEntity be = null;
        try {
            be = this.getBusinessEntity(idSogg);
            if (be == null) {
                throw new Exception("BusinessEntity is null");
            }
        }
        catch (DriverRegistroServiziNotFound e) {
            return false;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        return true;
    }

    public String getUrlXmlSoggetto(IDSoggetto idSogg) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idSogg == null) {
            throw new DriverRegistroServiziException("[UDDILib.getUrlXmlSoggetto]: Alcuni parametri non definiti");
        }
        try {
            BusinessEntity be = this.getBusinessEntity(idSogg);
            return be.getCategoryBag().get(0).getKeyValue();
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.getUrlXmlSoggetto]: " + e.getMessage(), e);
        }
    }

    public String[] getUrlXmlSoggetti() throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            BusinessEntity[] be = this.getBusinessEntities();
            String[] url = new String[be.length];
            for (int i = 0; i < be.length; ++i) {
                url[i] = be[i].getCategoryBag().get(0).getKeyValue();
            }
            return url;
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.getUrlXmlSoggetto]: " + e.getMessage(), e);
        }
    }

    public void updateUrlXmlSoggetto(IDSoggetto idSogg, String url) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idSogg == null || url == null) {
            throw new DriverRegistroServiziException("[UDDILib.updateUrlXmlSoggetto]: Alcuni parametri non definiti");
        }
        try {
            AuthToken token = this.proxy.get_authToken(this.username, this.password);
            BusinessEntity be = this.getBusinessEntity(idSogg);
            CategoryBag cb = be.getCategoryBag();
            Vector krv = cb.getKeyedReferenceVector();
            KeyedReference kr = (KeyedReference)krv.elementAt(0);
            kr.setKeyValue(url);
            cb.setKeyedReferenceVector(krv);
            be.setCategoryBag(cb);
            Vector<BusinessEntity> entities = new Vector<BusinessEntity>();
            entities.addElement(be);
            this.proxy.save_business(token.getAuthInfoString(), entities);
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.updateUrlXmlSoggetto]: " + e.getMessage(), e);
        }
    }

    public void updateDescrizioneSoggetto(IDSoggetto idSogg, String descrizione) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idSogg == null || descrizione == null) {
            throw new DriverRegistroServiziException("[UDDILib.updateDescrizioneSoggetto]: Alcuni parametri non definiti");
        }
        try {
            BusinessEntity be = this.getBusinessEntity(idSogg);
            this.updateNomeBusinessEntity(be, descrizione);
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.updateDescrizioneSoggetto]: " + e.getMessage(), e);
        }
    }

    public void updateIdSoggetto(IDSoggetto idSoggOLD, IDSoggetto idSoggNEW) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idSoggOLD == null || idSoggOLD.getNome() == null || idSoggOLD.getTipo() == null || idSoggNEW == null || idSoggNEW.getNome() == null || idSoggNEW.getTipo() == null) {
            throw new DriverRegistroServiziException("[UDDILib.updateIdSoggetto]: Alcuni parametri non definiti");
        }
        try {
            AuthToken token = this.proxy.get_authToken(this.username, this.password);
            BusinessEntity be = this.getBusinessEntity(idSoggOLD);
            IdentifierBag ib = be.getIdentifierBag();
            Vector v = ib.getKeyedReferenceVector();
            KeyedReference kr = (KeyedReference)v.elementAt(0);
            String newValue = idSoggNEW.getTipo() + "/" + idSoggNEW.getNome();
            kr.setKeyValue(newValue);
            ib.setKeyedReferenceVector(v);
            be.setIdentifierBag(ib);
            Vector<BusinessEntity> entities = new Vector<BusinessEntity>();
            entities.addElement(be);
            BusinessDetail bd = this.proxy.save_business(token.getAuthInfoString(), entities);
            Vector businessEntities = bd.getBusinessEntityVector();
            be = (BusinessEntity)businessEntities.elementAt(0);
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.updateIdSoggetto]: " + e.getMessage(), e);
        }
    }

    public void deleteSoggetto(IDSoggetto idSogg) throws DriverRegistroServiziException {
        if (idSogg == null) {
            throw new DriverRegistroServiziException("[UDDILib.deleteSoggetto]: Alcuni parametri non definiti");
        }
        try {
            this.deleteBusinessEntity(idSogg);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.deleteSoggetto]: " + e.getMessage(), e);
        }
    }

    public void updateIdentificativoPortaSoggetto(IDSoggetto idSogg, String newIdentificativoPorta) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idSogg == null || newIdentificativoPorta == null) {
            throw new DriverRegistroServiziException("[UDDILib.updateIdentificativoPortaSoggetto]: Alcuni parametri non definiti");
        }
        try {
            AuthToken token = this.proxy.get_authToken(this.username, this.password);
            BusinessEntity be = this.getBusinessEntity(idSogg);
            IdentifierBag ib = be.getIdentifierBag();
            Vector v = ib.getKeyedReferenceVector();
            KeyedReference kr = (KeyedReference)v.elementAt(0);
            kr.setKeyName(newIdentificativoPorta);
            ib.setKeyedReferenceVector(v);
            be.setIdentifierBag(ib);
            Vector<BusinessEntity> entities = new Vector<BusinessEntity>();
            entities.addElement(be);
            BusinessDetail bd = this.proxy.save_business(token.getAuthInfoString(), entities);
            Vector businessEntities = bd.getBusinessEntityVector();
            be = (BusinessEntity)businessEntities.elementAt(0);
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.updateIdentificativoPortaSoggetto]: Alcuni parametri non definiti");
        }
    }

    protected BusinessService getBusinessService(BusinessEntity be, IDServizio idServ) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (be == null || idServ == null || idServ.getTipoServizio() == null || idServ.getServizio() == null) {
            throw new DriverRegistroServiziException("[UDDILib.getBusinessService]: Alcuni parametri non definiti");
        }
        try {
            String keyService = idServ.getTipoServizio() + "/" + idServ.getServizio();
            BusinessService bs = null;
            Name nome = new Name(keyService);
            Vector<Name> nomi = new Vector<Name>();
            nomi.add(nome);
            FindQualifiers findQualifiers = new FindQualifiers();
            Vector<FindQualifier> qualifier = new Vector<FindQualifier>();
            qualifier.add(new FindQualifier("exactNameMatch"));
            qualifier.add(new FindQualifier("caseSensitiveMatch"));
            findQualifiers.setFindQualifierVector(qualifier);
            ServiceList serviceList = this.proxy.find_service(be.getBusinessKey(), nomi, null, null, findQualifiers, 1);
            if (serviceList.getServiceInfos() == null || serviceList.getServiceInfos().size() == 0) {
                throw new DriverRegistroServiziNotFound("BusinessService non trovata");
            }
            Vector serviceInfoVector = serviceList.getServiceInfos().getServiceInfoVector();
            ServiceInfo serviceInfo = (ServiceInfo)serviceInfoVector.elementAt(0);
            ServiceDetail sd = this.proxy.get_serviceDetail(serviceInfo.getServiceKey());
            Vector v = sd.getBusinessServiceVector();
            bs = (BusinessService)v.elementAt(0);
            return bs;
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (UDDIException e) {
            throw new DriverRegistroServiziException("[UDDILib.getBusinessService]: " + e.getMessage(), e);
        }
        catch (TransportException e) {
            throw new DriverRegistroServiziException("[UDDILib.getBusinessService]: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.getBusinessService]: " + e.getMessage(), e);
        }
    }

    protected BusinessService createBusinessService(BusinessEntity be, IDServizio idServ) throws DriverRegistroServiziException {
        if (be == null || idServ == null || idServ.getTipoServizio() == null || idServ.getServizio() == null) {
            throw new DriverRegistroServiziException("[UDDILib.createBusinessService]: Alcuni parametri non definiti");
        }
        BusinessService bs = null;
        try {
            AuthToken token = this.proxy.get_authToken(this.username, this.password);
            String keyService = idServ.getTipoServizio() + "/" + idServ.getServizio();
            String businessKey = be.getBusinessKey();
            try {
                bs = this.getBusinessService(be, idServ);
            }
            catch (DriverRegistroServiziNotFound e) {
                // empty catch block
            }
            if (bs == null) {
                bs = new BusinessService("");
                bs.setDefaultNameString(keyService, null);
                bs.setBusinessKey(businessKey);
                Vector<BusinessService> services = new Vector<BusinessService>();
                services.addElement(bs);
                ServiceDetail sd = this.proxy.save_service(token.getAuthInfoString(), services);
                Vector businessServices = sd.getBusinessServiceVector();
                bs = (BusinessService)businessServices.elementAt(0);
                BusinessServices bds = be.getBusinessServices();
                bds.add(bs);
                be.setBusinessServices(bds);
                Vector<BusinessEntity> entities = new Vector<BusinessEntity>();
                entities.addElement(be);
                this.proxy.save_business(token.getAuthInfoString(), entities);
            }
        }
        catch (UDDIException e) {
            throw new DriverRegistroServiziException("[UDDILib.createBusinessService]: " + e.getMessage(), e);
        }
        catch (TransportException e) {
            throw new DriverRegistroServiziException("[UDDILib.createBusinessService]: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.createBusinessService]: " + e.getMessage(), e);
        }
        return bs;
    }

    protected void deleteBusinessService(IDServizio idServ) throws DriverRegistroServiziException {
        if (idServ == null || idServ.getTipoServizio() == null || idServ.getServizio() == null || idServ.getSoggettoErogatore() == null || idServ.getSoggettoErogatore().getTipo() == null || idServ.getSoggettoErogatore().getNome() == null) {
            throw new DriverRegistroServiziException("[UDDILib.deleteBusinessService]: Alcuni parametri non definiti");
        }
        try {
            AuthToken token = this.proxy.get_authToken(this.username, this.password);
            FindQualifiers findQualifiers = new FindQualifiers();
            Vector<FindQualifier> qualifier = new Vector<FindQualifier>();
            qualifier.add(new FindQualifier("exactNameMatch"));
            qualifier.add(new FindQualifier("caseSensitiveMatch"));
            findQualifiers.setFindQualifierVector(qualifier);
            IdentifierBag ib = new IdentifierBag();
            KeyedReference k1 = new KeyedReference();
            String keyBE = idServ.getSoggettoErogatore().getTipo() + "/" + idServ.getSoggettoErogatore().getNome();
            k1.setKeyValue(keyBE);
            k1.setTModelKey(this.tmkID);
            Vector<KeyedReference> keyedReferenceVector = new Vector<KeyedReference>();
            keyedReferenceVector.add(k1);
            ib.setKeyedReferenceVector(keyedReferenceVector);
            Vector<Name> names = new Vector<Name>();
            String keyService = idServ.getTipoServizio() + "/" + idServ.getServizio();
            names.add(new Name(keyService));
            BusinessList businessList = this.proxy.find_business(null, null, ib, null, null, null, 1);
            Vector businessInfoVector = businessList.getBusinessInfos().getBusinessInfoVector();
            BusinessInfo businessInfo = (BusinessInfo)businessInfoVector.elementAt(0);
            ServiceList serviceList = this.proxy.find_service(businessInfo.getBusinessKey(), names, null, null, findQualifiers, 1);
            Vector serviceInfoVector = serviceList.getServiceInfos().getServiceInfoVector();
            ServiceInfo serviceInfo = (ServiceInfo)serviceInfoVector.elementAt(0);
            this.proxy.delete_service(token.getAuthInfoString(), serviceInfo.getServiceKey());
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.deleteBusinessService]: " + e.getMessage(), e);
        }
    }

    protected String getNomeBusinessService(BusinessService bs) throws DriverRegistroServiziException {
        if (bs == null) {
            throw new DriverRegistroServiziException("[UDDILib.getNomeBusinessService]: Alcuni parametri non definiti");
        }
        try {
            return bs.getDefaultName().getText();
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.getNomeBusinessService]: " + e.getMessage(), e);
        }
    }

    protected BusinessService updateNomeBusinessService(BusinessService bs, IDServizio idServ) throws DriverRegistroServiziException {
        if (bs == null || idServ == null || idServ.getTipoServizio() == null || idServ.getServizio() == null) {
            throw new DriverRegistroServiziException("[UDDILib.updateNomeBusinessService]: Alcuni parametri non definiti");
        }
        try {
            AuthToken token = this.proxy.get_authToken(this.username, this.password);
            String keyService = idServ.getTipoServizio() + "/" + idServ.getServizio();
            bs.setDefaultName(new Name(keyService));
            Vector<BusinessService> services = new Vector<BusinessService>();
            services.addElement(bs);
            this.proxy.save_service(token.getAuthInfoString(), services);
        }
        catch (UDDIException e) {
            throw new DriverRegistroServiziException("[UDDILib.updateNomeBusinessService]: " + e.getMessage(), e);
        }
        catch (TransportException e) {
            throw new DriverRegistroServiziException("[UDDILib.updateNomeBusinessService]: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.updateNomeBusinessService]: " + e.getMessage(), e);
        }
        return bs;
    }

    protected BindingTemplate getBindingTemplate(BusinessService bs) throws DriverRegistroServiziException {
        if (bs == null) {
            throw new DriverRegistroServiziException("[UDDILib.getBindingTemplate]: Alcuni parametri non definiti");
        }
        BindingTemplate bt = null;
        try {
            BindingDetail bindingDetailReturned = this.proxy.find_binding(null, bs.getServiceKey(), null, 1);
            Vector bindingTemplatesFound = bindingDetailReturned.getBindingTemplateVector();
            bt = (BindingTemplate)bindingTemplatesFound.elementAt(0);
        }
        catch (TransportException e) {
            throw new DriverRegistroServiziException("[UDDILib.getBindingTemplate]: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.getBindingTemplate]: " + e.getMessage(), e);
        }
        return bt;
    }

    protected BindingTemplate createBindingTemplate(BusinessService bs) throws DriverRegistroServiziException {
        if (bs == null) {
            throw new DriverRegistroServiziException("[UDDILib.createBindingTemplate]: Alcuni parametri non definiti");
        }
        try {
            AuthToken token = this.proxy.get_authToken(this.username, this.password);
            BindingTemplate bt = null;
            BindingTemplates bts = new BindingTemplates();
            String serviceKey = bs.getServiceKey();
            bt = new BindingTemplate();
            bt.setServiceKey(serviceKey);
            AccessPoint ap = new AccessPoint();
            ap.setText("url di default");
            bt.setAccessPoint(ap);
            Vector<BindingTemplate> templates = new Vector<BindingTemplate>();
            templates.addElement(bt);
            BindingDetail bindingDetail = this.proxy.save_binding(token.getAuthInfoString(), templates);
            Vector bd = bindingDetail.getBindingTemplateVector();
            bt = (BindingTemplate)bd.elementAt(bd.size() - 1);
            bts.add(bt);
            bs.setBindingTemplates(bts);
            Vector<BusinessService> services = new Vector<BusinessService>();
            services.addElement(bs);
            this.proxy.save_service(token.getAuthInfoString(), services);
            return bt;
        }
        catch (UDDIException e) {
            throw new DriverRegistroServiziException("[UDDILib.createBindingTemplate]: " + e.getMessage(), e);
        }
        catch (TransportException e) {
            throw new DriverRegistroServiziException("[UDDILib.createBindingTemplate]: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.createBindingTemplate]: " + e.getMessage(), e);
        }
    }

    protected TModel getTModel(BindingTemplate bt) throws DriverRegistroServiziException {
        if (bt == null) {
            throw new DriverRegistroServiziException("[UDDILib.getTModel]: Alcuni parametri non definiti");
        }
        TModel tm = null;
        try {
            TModelInstanceDetails tmid = bt.getTModelInstanceDetails();
            TModelInstanceInfo tmii = tmid.get(0);
            TModelDetail tmd = this.proxy.get_tModelDetail(tmii.getTModelKey());
            Vector v = tmd.getTModelVector();
            tm = (TModel)v.elementAt(0);
        }
        catch (UDDIException e) {
            throw new DriverRegistroServiziException("[UDDILib.getTModel]: " + e.getMessage(), e);
        }
        catch (TransportException e) {
            throw new DriverRegistroServiziException("[UDDILib.getTModel]: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.getTModel]: " + e.getMessage(), e);
        }
        return tm;
    }

    protected void createTModelServizio(BindingTemplate bt, IDAccordo idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (bt == null || idAccordo == null) {
            throw new DriverRegistroServiziException("[UDDILib.createTModelServizio]: Alcuni parametri non definiti");
        }
        TModel tm = null;
        try {
            AuthToken token = this.proxy.get_authToken(this.username, this.password);
            tm = this.getAccordoServizio(idAccordo);
            TModelInstanceInfo tmii = new TModelInstanceInfo(tm.getTModelKey());
            TModelInstanceDetails tmids = new TModelInstanceDetails();
            tmids.add(tmii);
            bt.setTModelInstanceDetails(tmids);
            Vector<BindingTemplate> templates = new Vector<BindingTemplate>();
            templates.addElement(bt);
            this.proxy.save_binding(token.getAuthInfoString(), templates);
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (UDDIException e) {
            throw new DriverRegistroServiziException("[UDDILib.createTModelServizio]: " + e.getMessage(), e);
        }
        catch (TransportException e) {
            throw new DriverRegistroServiziException("[UDDILib.createTModelServizio]: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.createTModelServizio]: " + e.getMessage(), e);
        }
    }

    protected String getAccessPoint(BindingTemplate bt) throws DriverRegistroServiziException {
        if (bt == null) {
            throw new DriverRegistroServiziException("[UDDILib.getAccessPoint]: Alcuni parametri non definiti");
        }
        try {
            return bt.getAccessPoint().getText();
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.getAccessPoint]: " + e.getMessage(), e);
        }
    }

    protected BindingTemplate updateAccessPoint(BindingTemplate bt, String URL2) throws DriverRegistroServiziException {
        if (bt == null || URL2 == null) {
            throw new DriverRegistroServiziException("[UDDILib.updateAccessPoint]: Alcuni parametri non definiti");
        }
        try {
            AuthToken token = this.proxy.get_authToken(this.username, this.password);
            AccessPoint ap = bt.getAccessPoint();
            ap.setText(URL2);
            bt.setAccessPoint(ap);
            Vector<BindingTemplate> templates = new Vector<BindingTemplate>();
            templates.addElement(bt);
            this.proxy.save_binding(token.getAuthInfoString(), templates);
        }
        catch (UDDIException e) {
            throw new DriverRegistroServiziException("[UDDILib.updateAccessPoint]: " + e.getMessage(), e);
        }
        catch (TransportException e) {
            throw new DriverRegistroServiziException("[UDDILib.updateAccessPoint]: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.updateAccessPoint]: " + e.getMessage(), e);
        }
        return bt;
    }

    protected BindingTemplate deleteAccessPoint(BindingTemplate bt) throws DriverRegistroServiziException {
        if (bt == null) {
            throw new DriverRegistroServiziException("[UDDILib.deleteAccessPoint]: Alcuni parametri non definiti");
        }
        try {
            bt = this.updateAccessPoint(bt, "");
            return bt;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.deleteAccessPoint]: " + e.getMessage(), e);
        }
    }

    public boolean existsServizio(IDServizio idServ) throws DriverRegistroServiziException {
        if (idServ == null || idServ.getSoggettoErogatore() == null) {
            throw new DriverRegistroServiziException("[UDDILib.existsServizio]: Alcuni parametri non definiti");
        }
        BusinessService bs = null;
        try {
            BusinessEntity be = this.getBusinessEntity(idServ.getSoggettoErogatore());
            if (be == null) {
                throw new Exception("BusinessEntity is null");
            }
            bs = this.getBusinessService(be, idServ);
            if (bs == null) {
                throw new Exception("BusinessService is null");
            }
        }
        catch (DriverRegistroServiziNotFound e) {
            return false;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        return true;
    }

    public void createServizio(IDServizio idServ, String urlXML, IDAccordo idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idServ == null || idServ.getSoggettoErogatore() == null || urlXML == null || idAccordo == null) {
            throw new DriverRegistroServiziException("[UDDILib.createServizio]: Alcuni parametri non definiti");
        }
        try {
            BusinessEntity be = this.getBusinessEntity(idServ.getSoggettoErogatore());
            BusinessService bs = this.createBusinessService(be, idServ);
            BindingTemplate bt = null;
            try {
                bt = this.createBindingTemplate(bs);
            }
            catch (Exception e) {
                try {
                    this.deleteBusinessService(idServ);
                }
                catch (Exception eRollback) {
                    // empty catch block
                }
                throw e;
            }
            try {
                bt = this.updateAccessPoint(bt, urlXML);
            }
            catch (Exception e) {
                try {
                    this.deleteBusinessService(idServ);
                }
                catch (Exception eRollback) {
                    // empty catch block
                }
                throw e;
            }
            try {
                this.createTModelServizio(bt, idAccordo);
            }
            catch (Exception e) {
                try {
                    this.deleteBusinessService(idServ);
                }
                catch (Exception eRollback) {
                    // empty catch block
                }
                throw e;
            }
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.createServizio]: " + e.getMessage(), e);
        }
    }

    public String getUrlXmlServizio(IDServizio idServ) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idServ == null || idServ.getSoggettoErogatore() == null) {
            throw new DriverRegistroServiziException("[UDDILib.getUrlXmlServizio]: Alcuni parametri non definiti");
        }
        try {
            BusinessEntity be = this.getBusinessEntity(idServ.getSoggettoErogatore());
            BusinessService bs = this.getBusinessService(be, idServ);
            BindingTemplate bt = this.getBindingTemplate(bs);
            return this.getAccessPoint(bt);
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.getUrlXmlServizio]: " + e.getMessage(), e);
        }
    }

    public void updateUrlXmlServizio(IDServizio idServ, String url) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (url == null || idServ == null || idServ.getSoggettoErogatore() == null) {
            throw new DriverRegistroServiziException("[UDDILib.updateUrlXmlServizio]: Alcuni parametri non definiti");
        }
        try {
            BusinessEntity be = this.getBusinessEntity(idServ.getSoggettoErogatore());
            BusinessService bs = this.getBusinessService(be, idServ);
            BindingTemplate bt = this.getBindingTemplate(bs);
            bt = this.updateAccessPoint(bt, url);
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.updateUrlXmlServizio]: " + e.getMessage(), e);
        }
    }

    public void updateIdServizio(IDServizio idServOLD, IDServizio idServNEW) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idServOLD == null || idServOLD.getTipoServizio() == null || idServOLD.getServizio() == null || idServOLD.getSoggettoErogatore() == null || idServOLD.getSoggettoErogatore().getTipo() == null || idServOLD.getSoggettoErogatore().getNome() == null) {
            throw new DriverRegistroServiziException("[UDDILib.modificaNomeServizio]: Alcuni parametri non definiti");
        }
        if (idServNEW == null || idServNEW.getTipoServizio() == null || idServNEW.getServizio() == null || idServNEW.getSoggettoErogatore() == null || idServNEW.getSoggettoErogatore().getTipo() == null || idServNEW.getSoggettoErogatore().getNome() == null) {
            throw new DriverRegistroServiziException("[UDDILib.modificaNomeServizio]: Alcuni parametri non definiti");
        }
        try {
            BusinessEntity be = this.getBusinessEntity(idServOLD.getSoggettoErogatore());
            BusinessService bs = this.getBusinessService(be, idServOLD);
            this.updateNomeBusinessService(bs, idServNEW);
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.modificaNomeServizio]: " + e.getMessage(), e);
        }
    }

    public void deleteServizio(IDServizio idServ) throws DriverRegistroServiziException {
        if (idServ == null || idServ.getSoggettoErogatore() == null) {
            throw new DriverRegistroServiziException("[UDDILib.deleteServizio]: Alcuni parametri non definiti");
        }
        try {
            this.deleteBusinessService(idServ);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.deleteServizio]: " + e.getMessage(), e);
        }
    }

    public void updateAccordoServizio(IDServizio idServ, IDAccordo newIDAccordoServizio) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idServ == null || idServ.getSoggettoErogatore() == null || newIDAccordoServizio == null) {
            throw new DriverRegistroServiziException("[UDDILib.updateAccordoServizio]: Alcuni parametri non definiti");
        }
        try {
            BusinessEntity be = this.getBusinessEntity(idServ.getSoggettoErogatore());
            BusinessService bs = this.getBusinessService(be, idServ);
            BindingTemplate bt = this.getBindingTemplate(bs);
            this.createTModelServizio(bt, newIDAccordoServizio);
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.updateAccordoServizio]: " + e.getMessage(), e);
        }
    }

    public String[] getUrlXmlServizi(IDSoggetto idSogg, IDAccordo idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idSogg == null || idAccordo == null) {
            throw new DriverRegistroServiziException("[UDDILib.getUrlXmlServizi]: Alcuni parametri non definiti");
        }
        try {
            BusinessEntity be = this.getBusinessEntity(idSogg);
            TModelBag bagAccordo = new TModelBag();
            TModel accordoS = this.getAccordoServizio(idAccordo);
            bagAccordo.add(new TModelKey(accordoS.getTModelKey()));
            FindQualifiers findQualifiers = new FindQualifiers();
            Vector<FindQualifier> qualifier = new Vector<FindQualifier>();
            qualifier.add(new FindQualifier("exactNameMatch"));
            qualifier.add(new FindQualifier("caseSensitiveMatch"));
            findQualifiers.setFindQualifierVector(qualifier);
            ServiceList serviceList = this.proxy.find_service(be.getBusinessKey(), null, null, bagAccordo, findQualifiers, -1);
            if (serviceList.getServiceInfos() == null || serviceList.getServiceInfos().size() == 0) {
                throw new DriverRegistroServiziNotFound("BusinessServices non trovate");
            }
            Vector serviceInfoVector = serviceList.getServiceInfos().getServiceInfoVector();
            if (serviceInfoVector.size() == 0) {
                throw new Exception("Servizi non trovati");
            }
            String[] url = new String[serviceInfoVector.size()];
            for (int i = 0; i < serviceInfoVector.size(); ++i) {
                ServiceInfo serviceInfo = (ServiceInfo)serviceInfoVector.elementAt(i);
                ServiceDetail sd = this.proxy.get_serviceDetail(serviceInfo.getServiceKey());
                Vector v = sd.getBusinessServiceVector();
                BusinessService bs = (BusinessService)v.elementAt(0);
                BindingTemplate bt = this.getBindingTemplate(bs);
                url[i] = this.getAccessPoint(bt);
                if (url[i] != null) continue;
                throw new Exception("access point non presente?");
            }
            return url;
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (TransportException e) {
            throw new DriverRegistroServiziException("[UDDILib.getUrlXmlServizi]: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.getUrlXmlServizi]: " + e.getMessage(), e);
        }
    }

    protected String[] getUrlXMLServiziBySearch(IDAccordo idAccordo, IDSoggetto soggettoErogatore, String tipoServizio, String nomeServizio) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            ServiceList serviceList;
            Vector serviceInfoVector;
            String businessKey = null;
            if (soggettoErogatore != null && soggettoErogatore.getTipo() != null && soggettoErogatore.getNome() != null) {
                try {
                    BusinessEntity be = this.getBusinessEntity(soggettoErogatore);
                    if (be != null) {
                        businessKey = be.getBusinessKey();
                    }
                }
                catch (DriverRegistroServiziNotFound e) {
                    throw new DriverRegistroServiziNotFound("[getBusinessServices] Soggetto SPCoop [" + soggettoErogatore + "] usato come filtro non presente", e);
                }
            }
            TModelBag bagAccordo = null;
            if (idAccordo != null) {
                try {
                    bagAccordo = new TModelBag();
                    TModel accordoS = this.getAccordoServizio(idAccordo);
                    bagAccordo.add(new TModelKey(accordoS.getTModelKey()));
                }
                catch (DriverRegistroServiziNotFound e) {
                    throw new DriverRegistroServiziNotFound("[getBusinessServices] Accordo [" + idAccordo.toString() + "] usato come filtro non presente", e);
                }
            }
            String keyService = null;
            keyService = tipoServizio != null && nomeServizio != null ? tipoServizio + "/" + nomeServizio : (tipoServizio != null ? tipoServizio + "/%" : (nomeServizio != null ? "%/" + nomeServizio : "%/%"));
            Name nome = new Name(keyService);
            Vector<Name> nomi = new Vector<Name>();
            nomi.add(nome);
            FindQualifiers findQualifiers = null;
            if (!"%/%".equals(keyService)) {
                findQualifiers = new FindQualifiers();
                Vector<FindQualifier> qualifier = new Vector<FindQualifier>();
                qualifier.add(new FindQualifier("exactNameMatch"));
                qualifier.add(new FindQualifier("caseSensitiveMatch"));
                findQualifiers.setFindQualifierVector(qualifier);
            }
            if ((serviceInfoVector = (serviceList = this.proxy.find_service(businessKey, nomi, null, bagAccordo, findQualifiers, MAX_SEARCH)).getServiceInfos().getServiceInfoVector()).size() == 0) {
                throw new DriverRegistroServiziNotFound("Non esistono BusinessService che rispettano il filtro selezionato accordo[" + idAccordo + "] soggetto[" + soggettoErogatore + "] tipo_servizio[" + tipoServizio + "] nome_servizio[" + nomeServizio + "]");
            }
            String[] url = new String[serviceInfoVector.size()];
            for (int i = 0; i < serviceInfoVector.size(); ++i) {
                ServiceInfo serviceInfo = (ServiceInfo)serviceInfoVector.elementAt(i);
                ServiceDetail sd = this.proxy.get_serviceDetail(serviceInfo.getServiceKey());
                Vector v = sd.getBusinessServiceVector();
                BusinessService bs = (BusinessService)v.elementAt(0);
                BindingTemplate bt = this.getBindingTemplate(bs);
                url[i] = this.getAccessPoint(bt);
                if (url[i] != null) continue;
                throw new Exception("access point non presente?");
            }
            return url;
        }
        catch (UDDIException e) {
            throw new DriverRegistroServiziException("[UDDILib.getBusinessService]: " + e.getMessage(), e);
        }
        catch (TransportException e) {
            throw new DriverRegistroServiziException("[UDDILib.getBusinessService]: " + e.getMessage(), e);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw de;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[UDDILib.getBusinessService]: " + e.getMessage(), e);
        }
    }
}

