/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.dao.registry.driver;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.openspcoop.dao.config.AccessoRegistroRegistro;
import org.openspcoop.dao.registry.driver.StatiAccordo;
import org.openspcoop.dao.registry.driver.XMLDataConverter;
import org.openspcoop.utils.Loader;
import org.openspcoop.utils.Utilities;

public class TestXMLDataConverter {
    private static Boolean resetEffettuata = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws Exception {
        block39: {
            if (args.length < 8) {
                String errorMsg = "ERROR, Usage:  java TestXMLDataConverter sorgenteXML tipoRegistroCRUD proprietaRegistroCRUD reset tipoConversione gestioneSoggetti mantieniFruitori statoAccordiImportati [[logger] [nomePddOperativa Logger]]";
                System.err.println(errorMsg);
                throw new Exception(errorMsg);
            }
            String loggerValue = null;
            try {
                if (args.length == 10) {
                    loggerValue = args[9];
                    PropertyConfigurator.configure((String)loggerValue);
                    break block39;
                }
                if (args.length == 9) {
                    loggerValue = args[8];
                    PropertyConfigurator.configure((String)loggerValue);
                } else {
                    PropertyConfigurator.configure((URL)TestXMLDataConverter.class.getResource("/tracer.log4j.properties"));
                }
            }
            catch (Exception e) {
                String errorMsg = "Errore durante il caricamento del file di log loggerValue[" + loggerValue + "] : " + e.getMessage();
                System.err.println(errorMsg);
                throw new Exception(errorMsg);
            }
        }
        Logger log = Logger.getLogger((String)"gestoreDatiRegistro");
        String statoAccordo = args[7].trim();
        if (!(StatiAccordo.bozza.toString().equals(statoAccordo) || StatiAccordo.operativo.toString().equals(statoAccordo) || StatiAccordo.finale.toString().equals(statoAccordo))) {
            String errorMsg = "Opzione 'statoAccordiImportati' non valida (" + statoAccordo + "), valori possibili sono: " + StatiAccordo.bozza.toString() + "," + StatiAccordo.operativo.toString() + "," + StatiAccordo.finale.toString();
            System.err.println(errorMsg);
            throw new Exception(errorMsg);
        }
        StatiAccordo statoAccordoObject = StatiAccordo.valueOf(statoAccordo);
        Properties reader = new Properties();
        try {
            reader.load(new FileInputStream(args[2]));
        }
        catch (IOException e) {
            String errorMsg = "Errore durante il caricamento del file di properties [" + args[2] + "] : " + e.getMessage();
            log.error((Object)errorMsg, (Throwable)e);
            throw new Exception(errorMsg, e);
        }
        AccessoRegistroRegistro acCRUD = new AccessoRegistroRegistro();
        Vector<Object> genericProperties = new Vector<Object>();
        String superUser = null;
        boolean connectionDB = false;
        String connection = null;
        String username = null;
        String password = null;
        String driver = null;
        String tipoDatabase = null;
        try {
            block42: {
                block41: {
                    acCRUD.setTipo(args[1]);
                    superUser = reader.getProperty("openspcoop.superuser");
                    if (superUser != null) {
                        superUser.trim();
                    }
                    if (!"db".equals(args[1])) break block41;
                    tipoDatabase = reader.getProperty("openspcoop.registroServizi.db.tipo");
                    if (tipoDatabase == null) {
                        throw new Exception("Non e' stato definito il tipo di database");
                    }
                    tipoDatabase = tipoDatabase.trim();
                    String dataSource = reader.getProperty("openspcoop.registroServizi.db.dataSource");
                    if (dataSource != null) {
                        dataSource = dataSource.trim();
                        Properties context = Utilities.readProperties("openspcoop.registroServizi.db.context.", reader);
                        acCRUD.setLocation(dataSource);
                        acCRUD.setTipoDatabase(tipoDatabase);
                        genericProperties.add(context);
                        break block42;
                    } else {
                        connectionDB = true;
                        connection = reader.getProperty("openspcoop.registroServizi.db.url");
                        if (connection == null) {
                            throw new Exception("Non e' stata definita una destinazione ne attraverso un datasource, ne attraverso una connessione diretta");
                        }
                        connection = connection.trim();
                        driver = reader.getProperty("openspcoop.registroServizi.db.driver");
                        if (driver == null) {
                            throw new Exception("Connessione diretta: non e' stato definito il Driver");
                        }
                        driver = driver.trim();
                        username = reader.getProperty("openspcoop.registroServizi.db.user");
                        password = reader.getProperty("openspcoop.registroServizi.db.password");
                        if (username != null) {
                            username = username.trim();
                        }
                        if (password != null) {
                            password = password.trim();
                        }
                    }
                    break block42;
                }
                if ("uddi".equals(args[1])) {
                    String pathPrefix;
                    String urlPrefix;
                    String passwordUDDI;
                    String usernameUDDI;
                    String publishUrl;
                    String inquiryUrl = reader.getProperty("openspcoop.registroServizi.uddi.inquiryUrl");
                    if (inquiryUrl != null) {
                        inquiryUrl = inquiryUrl.trim();
                    }
                    if ((publishUrl = reader.getProperty("openspcoop.registroServizi.uddi.publishUrl")) != null) {
                        publishUrl = publishUrl.trim();
                    }
                    if ((usernameUDDI = reader.getProperty("openspcoop.registroServizi.uddi.username")) != null) {
                        usernameUDDI = usernameUDDI.trim();
                    }
                    if ((passwordUDDI = reader.getProperty("openspcoop.registroServizi.uddi.password")) != null) {
                        passwordUDDI = passwordUDDI.trim();
                    }
                    if ((urlPrefix = reader.getProperty("openspcoop.registroServizi.uddi.urlPrefix")) != null) {
                        urlPrefix = urlPrefix.trim();
                    }
                    if ((pathPrefix = reader.getProperty("openspcoop.registroServizi.uddi.pathPrefix")) != null) {
                        pathPrefix = pathPrefix.trim();
                    }
                    acCRUD.setLocation(inquiryUrl);
                    acCRUD.setUser(usernameUDDI);
                    acCRUD.setPassword(passwordUDDI);
                    genericProperties.add(publishUrl);
                    genericProperties.add(urlPrefix);
                    genericProperties.add(pathPrefix);
                } else if ("web".equals(args[1])) {
                    String pathPrefix;
                    String urlPrefix = reader.getProperty("openspcoop.registroServizi.web.urlPrefix");
                    if (urlPrefix != null) {
                        urlPrefix = urlPrefix.trim();
                    }
                    if ((pathPrefix = reader.getProperty("openspcoop.registroServizi.web.pathPrefix")) != null) {
                        pathPrefix = pathPrefix.trim();
                    }
                    acCRUD.setLocation(urlPrefix);
                    genericProperties.add(pathPrefix);
                }
            }
            acCRUD.setGenericProperties(genericProperties);
        }
        catch (Exception e) {
            String errorMsg = "Errore durante la lettura del file di properties [" + args[2] + "] : " + e.getMessage();
            log.error((Object)errorMsg, (Throwable)e);
            throw new Exception(errorMsg, e);
        }
        Connection connectionSQL = null;
        try {
            try {
                File fSorgente = new File(args[0]);
                if (connectionDB) {
                    Loader.getInstance().newInstance(driver);
                    connectionSQL = username != null && password != null ? DriverManager.getConnection(connection, username, password) : DriverManager.getConnection(connection);
                }
                TestXMLDataConverter.letturaSorgenti(fSorgente, connectionDB, connectionSQL, tipoDatabase, log, superUser, acCRUD, args, statoAccordoObject);
            }
            catch (Exception e) {
                String errorMsg = "Errore durante la conversione XML dei dati: " + e.getMessage();
                log.error((Object)errorMsg, (Throwable)e);
                throw new Exception(errorMsg, e);
            }
            Object var22_30 = null;
        }
        catch (Throwable throwable) {
            Object var22_31 = null;
            try {
                if (connectionSQL == null) throw throwable;
                connectionSQL.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        if (connectionSQL == null) return;
        connectionSQL.close();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean reset(boolean b) {
        if (b) {
            Boolean bl = resetEffettuata;
            synchronized (bl) {
                if (!resetEffettuata.booleanValue()) {
                    resetEffettuata = true;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private static void letturaSorgenti(File fSorgente, boolean connectionDB, Connection connectionSQL, String tipoDatabase, Logger log, String superUser, AccessoRegistroRegistro acCRUD, String[] args, StatiAccordo statoAccordoObject) throws Exception {
        if (fSorgente.isFile()) {
            if (!fSorgente.canRead()) {
                throw new Exception("Sorgente XML [" + fSorgente.getAbsolutePath() + "] non accessibile in lettura");
            }
            if (fSorgente.getName().endsWith(".xml")) {
                TestXMLDataConverter.converti(fSorgente, connectionDB, connectionSQL, tipoDatabase, log, superUser, acCRUD, args, statoAccordoObject);
            } else {
                log.debug((Object)("File [" + fSorgente.getAbsolutePath() + "] ignorato. Non possiede l'estensione .xml"));
            }
        } else if (fSorgente.isDirectory()) {
            if (!fSorgente.canRead()) {
                throw new Exception("Directory contenente gli XML [" + fSorgente.getAbsolutePath() + "] non accessibile in lettura");
            }
            File[] f = fSorgente.listFiles();
            if (f == null || f.length <= 0) {
                throw new Exception("Directory [" + fSorgente.getAbsolutePath() + "] non contiene XML");
            }
            for (int i = 0; i < f.length; ++i) {
                TestXMLDataConverter.letturaSorgenti(f[i], connectionDB, connectionSQL, tipoDatabase, log, superUser, acCRUD, args, statoAccordoObject);
            }
        }
    }

    private static void converti(File f, boolean connectionDB, Connection connectionSQL, String tipoDatabase, Logger log, String superUser, AccessoRegistroRegistro acCRUD, String[] args, StatiAccordo statoAccordoObject) throws Exception {
        Logger logDriver = null;
        if ("uddi".equals(acCRUD.getTipo()) || "web".equals(acCRUD.getTipo())) {
            logDriver = log;
        }
        XMLDataConverter dataConverter = null;
        dataConverter = connectionDB ? new XMLDataConverter(f.getAbsolutePath(), connectionSQL, tipoDatabase, log, logDriver, superUser) : new XMLDataConverter(f.getAbsolutePath(), acCRUD, superUser, log, logDriver);
        if ("insertUpdate".equals(args[4].trim())) {
            log.info((Object)"Inizio conversione...");
            if (args.length == 9) {
                String pddOperativa = args[7].trim();
                dataConverter.convertXML(TestXMLDataConverter.reset(Boolean.parseBoolean(args[3])), pddOperativa, Boolean.parseBoolean(args[6]), Boolean.parseBoolean(args[5]), statoAccordoObject);
            } else {
                dataConverter.convertXML(TestXMLDataConverter.reset(Boolean.parseBoolean(args[3])), Boolean.parseBoolean(args[6]), Boolean.parseBoolean(args[5]), statoAccordoObject);
            }
            log.info((Object)"Conversione terminata.");
        } else if ("delete".equals(args[4].trim())) {
            log.info((Object)"Inizio conversione...");
            dataConverter.delete(Boolean.parseBoolean(args[5]));
            log.info((Object)"Conversione terminata.");
        } else {
            throw new Exception("Valore opzione 'tipoConversioneRegistroServizi' non gestito (valori possibili insertUpdate/delete): " + args[4]);
        }
    }
}

