/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.dao.registry.driver;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.openspcoop.dao.registry.RegistroServizi;
import org.openspcoop.dao.registry.driver.BeanUtilities;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziDB;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziUDDI;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziWEB;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziWS;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziXML;
import org.openspcoop.dao.registry.driver.ValidazioneSemantica;
import org.openspcoop.utils.Loader;
import org.openspcoop.utils.Utilities;

public class TestValidazioneSemantica {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] args) throws Exception {
        RegistroServizi registro;
        Logger log;
        block45: {
            BeanUtilities driver;
            Properties reader;
            block47: {
                Connection connectionDB;
                block46: {
                    if (args.length < 3) {
                        String errorMsg = "ERROR, Usage:  java TestValidazioneSemantica tipoRegistro proprietaRegistro checkURI";
                        System.err.println(errorMsg);
                        throw new Exception(errorMsg);
                    }
                    try {
                        if (args.length == 4) {
                            PropertyConfigurator.configure((String)args[3]);
                        } else {
                            PropertyConfigurator.configure((URL)TestValidazioneSemantica.class.getResource("/tracer.log4j.properties"));
                        }
                    }
                    catch (Exception e) {
                        String errorMsg = "Errore durante il caricamento del file di log args3[" + args[3] + "] : " + e.getMessage();
                        System.err.println(errorMsg);
                        throw new Exception(errorMsg);
                    }
                    log = Logger.getLogger((String)"validatoreDatiRegistro");
                    reader = new Properties();
                    try {
                        reader.load(new FileInputStream(args[1]));
                    }
                    catch (IOException e) {
                        String errorMsg = "Errore durante il caricamento del file di properties [" + args[1] + "] : " + e.getMessage();
                        log.error((Object)errorMsg, (Throwable)e);
                        throw new Exception(errorMsg, e);
                    }
                    registro = null;
                    connectionDB = null;
                    if (!"xml".equals(args[0])) break block46;
                    String path = reader.getProperty("openspcoop.registroServizi.xml");
                    if (path == null) {
                        throw new Exception("Non e' stato definito il path dove localizzare il registro servizi xml");
                    }
                    path = path.trim();
                    DriverRegistroServiziXML driver2 = new DriverRegistroServiziXML(path, log);
                    if (!driver2.create) {
                        throw new Exception("RegistroServizi XML non inizializzato");
                    }
                    log.info((Object)"Inizializzato Registro dei Servizi XML");
                    registro = driver2.getImmagineCompletaRegistroServizi();
                    break block45;
                }
                if (!"db".equals(args[0])) break block47;
                String tipoDatabase = reader.getProperty("openspcoop.registroServizi.db.tipo");
                if (tipoDatabase == null) {
                    throw new Exception("Non e' stato definito il tipo di database");
                }
                tipoDatabase = tipoDatabase.trim();
                String dataSource = reader.getProperty("openspcoop.registroServizi.db.dataSource");
                if (dataSource != null) {
                    dataSource = dataSource.trim();
                    Properties context = Utilities.readProperties("openspcoop.registroServizi.db.context.", reader);
                    driver = new DriverRegistroServiziDB(dataSource, context, log, tipoDatabase);
                    if (!((DriverRegistroServiziDB)driver).create) {
                        throw new Exception("RegistroServizi DB non inizializzato");
                    }
                    log.info((Object)"Inizializzato Registro dei Servizi DB");
                    registro = driver.getImmagineCompletaRegistroServizi();
                } else {
                    String connection = reader.getProperty("openspcoop.registroServizi.db.url");
                    if (connection == null) {
                        throw new Exception("Non e' stata definita una destinazione ne attraverso un datasource, ne attraverso una connessione diretta");
                    }
                    connection = connection.trim();
                    String driverJDBC = reader.getProperty("openspcoop.registroServizi.db.driver");
                    if (driverJDBC == null) {
                        throw new Exception("Connessione diretta: non e' stato definito il Driver");
                    }
                    driverJDBC = driverJDBC.trim();
                    String username = reader.getProperty("openspcoop.registroServizi.db.user");
                    String password = reader.getProperty("openspcoop.registroServizi.db.password");
                    if (username != null) {
                        username = username.trim();
                    }
                    if (password != null) {
                        password = password.trim();
                    }
                    Loader.getInstance().newInstance(driverJDBC);
                    connectionDB = username != null ? DriverManager.getConnection(connection, username, password) : DriverManager.getConnection(connection);
                    DriverRegistroServiziDB driver3 = new DriverRegistroServiziDB(connectionDB, log, tipoDatabase);
                    if (!driver3.create) {
                        throw new Exception("RegistroServizi DB non inizializzato");
                    }
                    log.info((Object)"Inizializzato Registro dei Servizi DB");
                    registro = driver3.getImmagineCompletaRegistroServizi();
                    Object var13_19 = null;
                    try {
                        if (connectionDB != null) {
                            connectionDB.close();
                        }
                        break block45;
                    }
                    catch (Exception e) {}
                }
                break block45;
                catch (Throwable throwable) {
                    Object var13_20 = null;
                    try {
                        if (connectionDB != null) {
                            connectionDB.close();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            if ("web".equals(args[0])) {
                String urlPrefix = reader.getProperty("openspcoop.registroServizi.web.urlPrefix");
                if (urlPrefix == null) {
                    throw new Exception("Non e' stato definito la url dove localizzare il registro servizi web");
                }
                urlPrefix = urlPrefix.trim();
                String pathPrefix = reader.getProperty("openspcoop.registroServizi.web.pathPrefix");
                if (pathPrefix == null) {
                    throw new Exception("Non e' stato definito il path dove localizzare il registro servizi web");
                }
                pathPrefix = pathPrefix.trim();
                DriverRegistroServiziWEB driver4 = new DriverRegistroServiziWEB(urlPrefix, pathPrefix, log);
                if (!driver4.create) {
                    throw new Exception("RegistroServizi WEB non inizializzato");
                }
                log.info((Object)"Inizializzato Registro dei Servizi WEB");
                registro = driver4.getImmagineCompletaRegistroServizi();
            } else if ("uddi".equals(args[0])) {
                String passwordUDDI;
                String inquiryUrl = reader.getProperty("openspcoop.registroServizi.uddi.inquiryUrl");
                if (inquiryUrl == null) {
                    throw new Exception("Non e' stato definito la url dove localizzare il registro servizi uddi");
                }
                inquiryUrl = inquiryUrl.trim();
                String urlPrefix = reader.getProperty("openspcoop.registroServizi.uddi.urlPrefix");
                if (urlPrefix == null) {
                    throw new Exception("Non e' stato definito la url prefix dove localizzare il registro servizi uddi (repository http)");
                }
                urlPrefix = urlPrefix.trim();
                String usernameUDDI = reader.getProperty("openspcoop.registroServizi.uddi.username");
                if (usernameUDDI != null) {
                    usernameUDDI = usernameUDDI.trim();
                }
                if ((passwordUDDI = reader.getProperty("openspcoop.registroServizi.uddi.password")) != null) {
                    passwordUDDI = passwordUDDI.trim();
                }
                DriverRegistroServiziUDDI driver5 = new DriverRegistroServiziUDDI(inquiryUrl, null, usernameUDDI, passwordUDDI, urlPrefix, null, log);
                if (!driver5.create) {
                    throw new Exception("RegistroServizi UDDI non inizializzato");
                }
                log.info((Object)"Inizializzato Registro dei Servizi UDDI");
                registro = driver5.getImmagineCompletaRegistroServizi();
            } else if ("ws".equals(args[0])) {
                String password;
                String url = reader.getProperty("openspcoop.registroServizi.ws.url");
                if (url == null) {
                    throw new Exception("Non e' stato definito la url dove localizzare il registro servizi ws");
                }
                url = url.trim();
                String username = reader.getProperty("openspcoop.registroServizi.ws.username");
                if (username != null) {
                    username = username.trim();
                }
                if ((password = reader.getProperty("openspcoop.registroServizi.ws.password")) != null) {
                    password = password.trim();
                }
                driver = null;
                driver = username != null ? new DriverRegistroServiziWS(url, username, password, log) : new DriverRegistroServiziWS(url, log);
                if (!((DriverRegistroServiziWS)driver).create) {
                    throw new Exception("RegistroServizi WS non inizializzato");
                }
                log.info((Object)"Inizializzato Registro dei Servizi WS");
                registro = driver.getImmagineCompletaRegistroServizi();
            } else {
                throw new Exception("Tipo di registro servizi [" + args[0] + "] non gestito");
            }
        }
        try {
            String[] tipoConnettori = new String[]{"http", "jms", "saaj", "null", "nullEcho", "disabilitato"};
            String[] tipoSoggetti = new String[]{"SPC", "TEST", "AOO"};
            String[] tipoServizi = new String[]{"SPC", "TEST", "URL", "WSDL", "LDAP", "UDDI", "ebXMLRegistry"};
            ValidazioneSemantica validatore = new ValidazioneSemantica(registro, Boolean.parseBoolean(args[2]), tipoConnettori, tipoSoggetti, tipoServizi, log);
            validatore.validazioneSemantica(true);
        }
        catch (Exception e) {
            log.error((Object)("Errore: " + e.getMessage()));
            throw e;
        }
    }
}

