/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.dao.registry.driver;

import it.gov.spcoop.sica.dao.AccordoServizioComposto;
import it.gov.spcoop.sica.dao.AccordoServizioParteSpecifica;
import it.gov.spcoop.sica.firma.Firma;
import it.gov.spcoop.sica.manifest.AccordoServizioParteComune;
import it.gov.spcoop.sica.manifest.DocumentoConversazione;
import it.gov.spcoop.sica.manifest.DocumentoCoordinamento;
import it.gov.spcoop.sica.manifest.DocumentoInterfaccia;
import it.gov.spcoop.sica.manifest.DocumentoLivelloServizio;
import it.gov.spcoop.sica.manifest.DocumentoSemiformale;
import it.gov.spcoop.sica.manifest.DocumentoSicurezza;
import it.gov.spcoop.sica.manifest.ElencoAllegati;
import it.gov.spcoop.sica.manifest.ElencoPartecipanti;
import it.gov.spcoop.sica.manifest.ElencoServiziComponenti;
import it.gov.spcoop.sica.manifest.ElencoServiziComposti;
import it.gov.spcoop.sica.manifest.ServizioComposto;
import it.gov.spcoop.sica.manifest.SpecificaConversazione;
import it.gov.spcoop.sica.manifest.SpecificaCoordinamento;
import it.gov.spcoop.sica.manifest.SpecificaInterfaccia;
import it.gov.spcoop.sica.manifest.SpecificaLivelliServizio;
import it.gov.spcoop.sica.manifest.SpecificaPortiAccesso;
import it.gov.spcoop.sica.manifest.SpecificaSemiformale;
import it.gov.spcoop.sica.manifest.SpecificaSicurezza;
import it.gov.spcoop.sica.manifest.driver.TipiDocumentoConversazione;
import it.gov.spcoop.sica.manifest.driver.TipiDocumentoInterfaccia;
import java.io.File;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.registry.AccordoCooperazione;
import org.openspcoop.dao.registry.AccordoCooperazioneElencoPartecipantiSoggetto;
import org.openspcoop.dao.registry.AccordoCooperazioneSoggettoReferente;
import org.openspcoop.dao.registry.AccordoServizio;
import org.openspcoop.dao.registry.AccordoServizioServizioComposto;
import org.openspcoop.dao.registry.AccordoServizioServizioCompostoServizioComponente;
import org.openspcoop.dao.registry.AccordoServizioSoggettoReferente;
import org.openspcoop.dao.registry.Connettore;
import org.openspcoop.dao.registry.ConnettoreProperty;
import org.openspcoop.dao.registry.Documento;
import org.openspcoop.dao.registry.ServizioSpcoop;
import org.openspcoop.dao.registry.ServizioSpcoopAccordoParteSpecifica;
import org.openspcoop.dao.registry.driver.IDAccordo;
import org.openspcoop.dao.registry.driver.IDAccordoCooperazione;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.dao.registry.driver.RuoliDocumento;
import org.openspcoop.dao.registry.driver.SICAToOpenSPCoopUtilitiesException;
import org.openspcoop.dao.registry.driver.SICAtoOpenSPCoopContext;
import org.openspcoop.dao.registry.wsdl.DefinitionWrapper;
import org.openspcoop.dao.registry.wsdl.RegistroOpenSPCoopUtilities;
import org.openspcoop.dao.registry.wsdl.WSDLUtilities;
import org.openspcoop.utils.Utilities;
import org.openspcoop.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SICAtoOpenSPCoopUtilities {
    private static String[] getValoriDN(String dn) throws SICAToOpenSPCoopUtilitiesException {
        int indexOf = dn.indexOf("=");
        if (indexOf <= 0) {
            throw new SICAToOpenSPCoopUtilitiesException("Separatore validi per il dn non trovati");
        }
        String[] valori = dn.split(",");
        if (valori == null || valori.length < 1) {
            throw new SICAToOpenSPCoopUtilitiesException("Comprensione dn non riuscita: null??");
        }
        return valori;
    }

    public static void validateIDSoggettoSICA(String dn) throws SICAToOpenSPCoopUtilitiesException {
        String tmp = new String(dn);
        if (tmp.startsWith("uri:dn:")) {
            tmp = tmp.substring("uri:dn:".length());
        }
        if (tmp == null || "".equals(tmp)) {
            throw new SICAToOpenSPCoopUtilitiesException("DN non fornita");
        }
        if (!tmp.contains("c=it")) {
            throw new SICAToOpenSPCoopUtilitiesException("c=it non presente");
        }
        if (!tmp.contains(",")) {
            throw new SICAToOpenSPCoopUtilitiesException("Nessuna amministrazione definita nella radice c=it");
        }
        if (!tmp.contains("=")) {
            throw new SICAToOpenSPCoopUtilitiesException("Nessuna amministrazione definita nella radice c=it");
        }
        String[] valoriDN = SICAtoOpenSPCoopUtilities.getValoriDN(tmp);
        boolean campoObbligatorioO = false;
        for (int i = 0; i < valoriDN.length; ++i) {
            if (!valoriDN[i].contains("=")) {
                throw new SICAToOpenSPCoopUtilitiesException("Comprensione dn non riuscita: [" + valoriDN[i] + "] non separata dal carattere \"=\"");
            }
            String[] keyValue = valoriDN[i].trim().split("=");
            if (keyValue.length != 2) {
                throw new SICAToOpenSPCoopUtilitiesException("Comprensione dn non riuscita: [" + valoriDN[i] + "] contiene piu' di un carattere \"=\"");
            }
            if (keyValue[0].trim().contains(" ")) {
                throw new SICAToOpenSPCoopUtilitiesException("Comprensione dn non riuscita: il campo [" + valoriDN[i] + "] contiene spazi nella chiave identificativa [" + keyValue[0].trim() + "]");
            }
            if (!Utilities.formatKeySubject(keyValue[0]).equalsIgnoreCase("O")) continue;
            campoObbligatorioO = true;
        }
        if (!campoObbligatorioO) {
            throw new SICAToOpenSPCoopUtilitiesException("Nessuna amministrazione definita nella radice c=it (o=XX non trovato)");
        }
    }

    public static String appendURI_IDSoggettoSica(String dn) throws SICAToOpenSPCoopUtilitiesException {
        SICAtoOpenSPCoopUtilities.validateIDSoggettoSICA(dn);
        return "uri:dn:" + dn;
    }

    public static String removeURI_IDSoggettoSica(String uri_dn) throws SICAToOpenSPCoopUtilitiesException {
        SICAtoOpenSPCoopUtilities.validateIDSoggettoSICA(uri_dn);
        if (uri_dn.startsWith("uri:dn:")) {
            uri_dn = uri_dn.substring("uri:dn:".length());
        }
        return uri_dn;
    }

    public static String buildIDSoggettoSica(IDSoggetto idSoggetto, boolean createURI) throws SICAToOpenSPCoopUtilitiesException {
        String soggetto = null;
        soggetto = "SPC".equals(idSoggetto.getTipo()) ? idSoggetto.getNome() : idSoggetto.toString();
        return SICAtoOpenSPCoopUtilities.buildIDSoggettoSica(soggetto, createURI);
    }

    public static String buildIDSoggettoSica(String soggetto, boolean createURI) throws SICAToOpenSPCoopUtilitiesException {
        if (soggetto == null || "".equals(soggetto)) {
            throw new SICAToOpenSPCoopUtilitiesException("Identificativo soggetto non fornito");
        }
        StringBuffer bf = new StringBuffer();
        if (createURI) {
            bf.append("uri:dn:");
        }
        bf.append("o=");
        bf.append(soggetto);
        bf.append(",c=it");
        return bf.toString();
    }

    public static String idSoggetto_openspcoopToSica(IDSoggetto idSoggetto) throws SICAToOpenSPCoopUtilitiesException {
        if (idSoggetto == null) {
            throw new SICAToOpenSPCoopUtilitiesException("IDSoggetto non definito");
        }
        if (idSoggetto.getTipo() == null) {
            throw new SICAToOpenSPCoopUtilitiesException("IDSoggetto.tipo non definito");
        }
        if (idSoggetto.getNome() == null) {
            throw new SICAToOpenSPCoopUtilitiesException("IDSoggetto.nome non definito");
        }
        if (!"SPC".equals(idSoggetto.getTipo())) {
            throw new SICAToOpenSPCoopUtilitiesException("Tipo soggetto diverso da SPC non utilizzabile");
        }
        return SICAtoOpenSPCoopUtilities.buildIDSoggettoSica(idSoggetto.getNome(), true);
    }

    public static IDSoggetto idSoggetto_sicaToOpenspcoop(String uriSoggetto) throws SICAToOpenSPCoopUtilitiesException {
        return SICAtoOpenSPCoopUtilities.idSoggetto_sicaToOpenspcoop(uriSoggetto, true);
    }

    public static IDSoggetto idSoggetto_sicaToOpenspcoop(String uriSoggetto, boolean uri) throws SICAToOpenSPCoopUtilitiesException {
        if (uriSoggetto == null) {
            throw new SICAToOpenSPCoopUtilitiesException("uriSoggetto non definito");
        }
        String senzaSpazi = uriSoggetto.replaceAll("", "");
        if (!senzaSpazi.startsWith("uri:dn:") && uri) {
            throw new SICAToOpenSPCoopUtilitiesException("Formato uriSoggetto (" + uriSoggetto + ") non corretto (uri:dn:o=<identificativo soggetto>,c=it)");
        }
        if (senzaSpazi.indexOf(",c=it") <= 0 && senzaSpazi.indexOf(" c=it") <= 0) {
            throw new SICAToOpenSPCoopUtilitiesException("Formato uriSoggetto (" + uriSoggetto + ") non corretto (uri:dn:o=<identificativo soggetto>,c=it)");
        }
        if (uri) {
            if (senzaSpazi.indexOf(",o=") <= 0 && senzaSpazi.indexOf(":o=") <= 0 && senzaSpazi.indexOf(" o=") <= 0) {
                throw new SICAToOpenSPCoopUtilitiesException("Formato uriSoggetto (" + uriSoggetto + ") non corretto (uri:dn:o=<identificativo soggetto>,c=it)");
            }
        } else if (senzaSpazi.indexOf(",o=") <= 0 && senzaSpazi.indexOf("o=") < 0) {
            throw new SICAToOpenSPCoopUtilitiesException("Formato uriSoggetto (" + uriSoggetto + ") non corretto (o=<identificativo soggetto>,c=it)");
        }
        int index = -1;
        int lenghtPrefixO = 3;
        if (uri) {
            index = senzaSpazi.indexOf(",o=");
            if (index <= 0) {
                index = senzaSpazi.indexOf(":o=");
            }
            if (index <= 0) {
                index = senzaSpazi.indexOf(" o=");
            }
        } else {
            index = senzaSpazi.indexOf(",o=");
            if (index <= 0) {
                index = senzaSpazi.indexOf("o=");
                lenghtPrefixO = 2;
            }
        }
        int endSoggetto = senzaSpazi.length();
        if (senzaSpazi.indexOf(",", index + 1) > 0) {
            endSoggetto = senzaSpazi.indexOf(",", index + 1);
        }
        IDSoggetto idSoggetto = new IDSoggetto("SPC", senzaSpazi.substring(index + lenghtPrefixO, endSoggetto));
        return idSoggetto;
    }

    public static String readDNSoggettoFromUriAccordo(String uriAccordo) throws SICAToOpenSPCoopUtilitiesException {
        if (uriAccordo == null) {
            throw new SICAToOpenSPCoopUtilitiesException("uriAccordo non definito");
        }
        String[] values = uriAccordo.split(":");
        if (values.length != 5) {
            throw new SICAToOpenSPCoopUtilitiesException("Formato uriAccordo (" + uriAccordo + ") non valido (urn:<tipo_accordo>:<soggetto_organizzativo>:<nome_accordo>:<versione>)");
        }
        String urn = values[0];
        if (!"urn".equals(urn)) {
            throw new SICAToOpenSPCoopUtilitiesException("Formato uriAccordo (" + uriAccordo + ") non valido (urn:<tipo_accordo>:<soggetto_organizzativo>:<nome_accordo>:<versione>)");
        }
        String soggetto = values[2];
        if (soggetto == null) {
            throw new SICAToOpenSPCoopUtilitiesException("Soggetto non presente nell'uriAccordo (" + uriAccordo + ")");
        }
        return soggetto;
    }

    public static String buildIDAccordoCooperazioneSica(String nome_accordo, String versione) throws SICAToOpenSPCoopUtilitiesException {
        if (nome_accordo == null || "".equals(nome_accordo)) {
            throw new SICAToOpenSPCoopUtilitiesException("Nome accordo non fornito");
        }
        if (versione == null || "".equals(versione)) {
            throw new SICAToOpenSPCoopUtilitiesException("Versione non fornita");
        }
        StringBuffer bf = new StringBuffer();
        bf.append("urn:");
        bf.append("adc");
        bf.append(":");
        bf.append(nome_accordo);
        bf.append(":");
        bf.append(versione);
        return bf.toString();
    }

    public static String idAccordoCooperazione_openspcoopToSica(IDAccordoCooperazione idAccordo) throws SICAToOpenSPCoopUtilitiesException {
        if (idAccordo == null) {
            throw new SICAToOpenSPCoopUtilitiesException("IDAccordo non definito");
        }
        if (idAccordo.getNome() == null) {
            throw new SICAToOpenSPCoopUtilitiesException("IDAccordo.nome non definito");
        }
        if (idAccordo.getVersione() == null) {
            throw new SICAToOpenSPCoopUtilitiesException("IDAccordo.versione non definito");
        }
        return SICAtoOpenSPCoopUtilities.buildIDAccordoCooperazioneSica(idAccordo.getNome(), idAccordo.getVersione());
    }

    public static IDAccordoCooperazione idAccordoCooperazione_sicaToOpenspcoop(String uriAccordo) throws SICAToOpenSPCoopUtilitiesException {
        if (uriAccordo == null) {
            throw new SICAToOpenSPCoopUtilitiesException("uriAccordo non definito");
        }
        String[] values = uriAccordo.split(":");
        if (values.length != 4) {
            throw new SICAToOpenSPCoopUtilitiesException("Formato uriAccordo (" + uriAccordo + ") non valido (urn:adc:<nome_accordo>:<versione>)");
        }
        String urn = values[0];
        if (!"urn".equals(urn)) {
            throw new SICAToOpenSPCoopUtilitiesException("Formato uriAccordo (" + uriAccordo + ") non valido (urn:adc:<nome_accordo>:<versione>)");
        }
        String tipoAccordo = values[1];
        if (!"adc".equals(tipoAccordo)) {
            throw new SICAToOpenSPCoopUtilitiesException("Tipo presente nell'uriAccordo (" + tipoAccordo + ") non corrisponde quello atteso (adc)");
        }
        String nome = values[2];
        if (nome == null) {
            throw new SICAToOpenSPCoopUtilitiesException("Nome non presente nell'uriAccordo (" + uriAccordo + ")");
        }
        String versione = values[3];
        if (versione == null) {
            throw new SICAToOpenSPCoopUtilitiesException("Versione non presente nell'uriAccordo (" + uriAccordo + ")");
        }
        IDAccordoCooperazione idAccordo = null;
        try {
            idAccordo = IDAccordoCooperazione.getIDAccordoFromValues(nome, versione);
        }
        catch (Exception e) {
            throw new SICAToOpenSPCoopUtilitiesException("Costruzione IDAccordo (" + uriAccordo + ") non riuscita: " + e.getMessage(), e);
        }
        return idAccordo;
    }

    public static String buildIDAccordoSica(String tipo_accordo, String soggetto, String nome_accordo, String versione) throws SICAToOpenSPCoopUtilitiesException {
        if (tipo_accordo == null || "".equals(tipo_accordo)) {
            throw new SICAToOpenSPCoopUtilitiesException("Tipo accordo non fornito");
        }
        if (soggetto == null || "".equals(soggetto)) {
            throw new SICAToOpenSPCoopUtilitiesException("Soggetto organizzativo non fornito");
        }
        if (nome_accordo == null || "".equals(nome_accordo)) {
            throw new SICAToOpenSPCoopUtilitiesException("Nome accordo non fornito");
        }
        if (versione == null || "".equals(versione)) {
            throw new SICAToOpenSPCoopUtilitiesException("Versione non fornita");
        }
        StringBuffer bf = new StringBuffer();
        bf.append("urn:");
        bf.append(tipo_accordo);
        bf.append(":");
        bf.append(soggetto);
        bf.append(":");
        bf.append(nome_accordo);
        bf.append(":");
        bf.append(versione);
        return bf.toString();
    }

    public static String idAccordoServizioParteComune_openspcoopToSica(IDAccordo idAccordo, SICAtoOpenSPCoopContext sicaToOpenSPCoopContext) throws SICAToOpenSPCoopUtilitiesException {
        return SICAtoOpenSPCoopUtilities.idAccordo_openspcoopToSica(idAccordo, "adsc", sicaToOpenSPCoopContext);
    }

    public static IDAccordo idAccordoServizioParteComune_sicaToOpenspcoop(String uriAccordo, SICAtoOpenSPCoopContext sicaToOpenSPCoopContext) throws SICAToOpenSPCoopUtilitiesException {
        return SICAtoOpenSPCoopUtilities.idAccordo_sicaToOpenspcoop(uriAccordo, "adsc", sicaToOpenSPCoopContext);
    }

    public static String idAccordoServizioComposto_openspcoopToSica(IDAccordo idAccordo, SICAtoOpenSPCoopContext sicaToOpenSPCoopContext) throws SICAToOpenSPCoopUtilitiesException {
        return SICAtoOpenSPCoopUtilities.idAccordo_openspcoopToSica(idAccordo, "sc", sicaToOpenSPCoopContext);
    }

    public static IDAccordo idAccordoServizioComposto_sicaToOpenspcoop(String uriAccordo, SICAtoOpenSPCoopContext sicaToOpenSPCoopContext) throws SICAToOpenSPCoopUtilitiesException {
        return SICAtoOpenSPCoopUtilities.idAccordo_sicaToOpenspcoop(uriAccordo, "sc", sicaToOpenSPCoopContext);
    }

    public static String idAccordoServizioParteSpecifica_openspcoopToSica(IDAccordo idAccordo, SICAtoOpenSPCoopContext sicaToOpenSPCoopContext) throws SICAToOpenSPCoopUtilitiesException {
        return SICAtoOpenSPCoopUtilities.idAccordo_openspcoopToSica(idAccordo, "ads", sicaToOpenSPCoopContext);
    }

    public static IDAccordo idAccordoServizioParteSpecifica_sicaToOpenspcoop(String uriAccordo, SICAtoOpenSPCoopContext sicaToOpenSPCoopContext) throws SICAToOpenSPCoopUtilitiesException {
        return SICAtoOpenSPCoopUtilities.idAccordo_sicaToOpenspcoop(uriAccordo, "ads", sicaToOpenSPCoopContext);
    }

    private static String idAccordo_openspcoopToSica(IDAccordo idAccordo, String tipo, SICAtoOpenSPCoopContext sicaToOpenSPCoopContext) throws SICAToOpenSPCoopUtilitiesException {
        if (idAccordo == null) {
            throw new SICAToOpenSPCoopUtilitiesException("IDAccordo non definito");
        }
        if (idAccordo.getNome() == null) {
            throw new SICAToOpenSPCoopUtilitiesException("IDAccordo.nome non definito");
        }
        if (idAccordo.getVersione() == null) {
            throw new SICAToOpenSPCoopUtilitiesException("IDAccordo.versione non definito");
        }
        if (idAccordo.getSoggettoReferente() == null) {
            throw new SICAToOpenSPCoopUtilitiesException("IDAccordo.soggettoReferente non definito");
        }
        if (idAccordo.getSoggettoReferente().getTipo() == null) {
            throw new SICAToOpenSPCoopUtilitiesException("IDAccordo.soggettoReferente.tipo non definito");
        }
        if (idAccordo.getSoggettoReferente().getNome() == null) {
            throw new SICAToOpenSPCoopUtilitiesException("IDAccordo.soggettoReferente.nome non definito");
        }
        if (!"SPC".equals(idAccordo.getSoggettoReferente().getTipo())) {
            throw new SICAToOpenSPCoopUtilitiesException("Tipo soggetto referente diverso da SPC non utilizzabile");
        }
        String codiceIPASoggettoReferente = sicaToOpenSPCoopContext.getCodiceIPA(new IDSoggetto(idAccordo.getSoggettoReferente().getTipo(), idAccordo.getSoggettoReferente().getNome()));
        if (codiceIPASoggettoReferente == null) {
            codiceIPASoggettoReferente = SICAtoOpenSPCoopUtilities.buildIDSoggettoSica(idAccordo.getSoggettoReferente().getNome(), false);
        }
        return SICAtoOpenSPCoopUtilities.buildIDAccordoSica(tipo, codiceIPASoggettoReferente, idAccordo.getNome(), idAccordo.getVersione());
    }

    public static IDAccordo idAccordo_sicaToOpenspcoop(String uriAccordo, String tipoAtteso, SICAtoOpenSPCoopContext sicaToOpenSPCoopContext) throws SICAToOpenSPCoopUtilitiesException {
        String nome;
        if (uriAccordo == null) {
            throw new SICAToOpenSPCoopUtilitiesException("uriAccordo non definito");
        }
        String[] values = uriAccordo.split(":");
        if (values.length != 5) {
            throw new SICAToOpenSPCoopUtilitiesException("Formato uriAccordo (" + uriAccordo + ") non valido (urn:<tipo_accordo>:<soggetto_organizzativo>:<nome_accordo>:<versione>)");
        }
        String urn = values[0];
        if (!"urn".equals(urn)) {
            throw new SICAToOpenSPCoopUtilitiesException("Formato uriAccordo (" + uriAccordo + ") non valido (urn:<tipo_accordo>:<soggetto_organizzativo>:<nome_accordo>:<versione>)");
        }
        String tipoAccordo = values[1];
        if (!tipoAtteso.equals(tipoAccordo)) {
            throw new SICAToOpenSPCoopUtilitiesException("Tipo presente nell'uriAccordo (" + tipoAccordo + ") non corrisponde quello atteso (" + tipoAtteso + ")");
        }
        String soggetto = values[2];
        if (soggetto == null) {
            throw new SICAToOpenSPCoopUtilitiesException("Soggetto non presente nell'uriAccordo (" + uriAccordo + ")");
        }
        IDSoggetto idSoggetto = sicaToOpenSPCoopContext.getIDSoggetto(soggetto);
        if (idSoggetto == null) {
            idSoggetto = SICAtoOpenSPCoopUtilities.idSoggetto_sicaToOpenspcoop(soggetto, false);
        }
        if ((nome = values[3]) == null) {
            throw new SICAToOpenSPCoopUtilitiesException("Nome non presente nell'uriAccordo (" + uriAccordo + ")");
        }
        String versione = values[4];
        if (versione == null) {
            throw new SICAToOpenSPCoopUtilitiesException("Versione non presente nell'uriAccordo (" + uriAccordo + ")");
        }
        IDAccordo idAccordo = null;
        try {
            idAccordo = IDAccordo.getIDAccordoFromValues(nome, idSoggetto, versione);
        }
        catch (Exception e) {
            throw new SICAToOpenSPCoopUtilitiesException("Costruzione IDAccordo (" + uriAccordo + ") non riuscita: " + e.getMessage(), e);
        }
        return idAccordo;
    }

    public static String readConnettoreFromWsdlImplementativo(byte[] wsdlImplementativo) throws SICAToOpenSPCoopUtilitiesException {
        try {
            Document documentLogico = XMLUtils.newDocument(wsdlImplementativo);
            NodeList list = documentLogico.getChildNodes();
            if (list != null) {
                for (int i = 0; i < list.getLength(); ++i) {
                    NodeList listDefinition;
                    Node child = list.item(i);
                    if (!"definitions".equals(child.getLocalName()) || (listDefinition = child.getChildNodes()) == null) continue;
                    for (int j = 0; j < listDefinition.getLength(); ++j) {
                        NodeList listPort;
                        Node childDefinition = listDefinition.item(j);
                        if (!"service".equals(childDefinition.getLocalName()) || (listPort = childDefinition.getChildNodes()) == null) continue;
                        for (int z = 0; z < listPort.getLength(); ++z) {
                            NodeList addressList;
                            Node port = listPort.item(z);
                            if (!"port".equals(port.getLocalName()) || (addressList = port.getChildNodes()) == null) continue;
                            for (int m = 0; m < addressList.getLength(); ++m) {
                                Node address = addressList.item(m);
                                if (!"address".equals(address.getLocalName())) continue;
                                return address.getAttributes().getNamedItem("location").getNodeValue();
                            }
                        }
                    }
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new SICAToOpenSPCoopUtilitiesException("readWsdlImplementativo error: " + e.getMessage(), e);
        }
    }

    public static byte[] saveConnettoreIntoWsdlImplementativo(byte[] wsdlImplementativo, String url) throws SICAToOpenSPCoopUtilitiesException {
        try {
            Document documentLogico = XMLUtils.newDocument(wsdlImplementativo);
            NodeList list = documentLogico.getChildNodes();
            if (list != null) {
                for (int i = 0; i < list.getLength(); ++i) {
                    NodeList listDefinition;
                    Node child = list.item(i);
                    if (!"definitions".equals(child.getLocalName()) || (listDefinition = child.getChildNodes()) == null) continue;
                    for (int j = 0; j < listDefinition.getLength(); ++j) {
                        NodeList listPort;
                        Node childDefinition = listDefinition.item(j);
                        if (!"service".equals(childDefinition.getLocalName()) || (listPort = childDefinition.getChildNodes()) == null) continue;
                        for (int z = 0; z < listPort.getLength(); ++z) {
                            NodeList addressList;
                            Node port = listPort.item(z);
                            if (!"port".equals(port.getLocalName()) || (addressList = port.getChildNodes()) == null) continue;
                            for (int m = 0; m < addressList.getLength(); ++m) {
                                Node address = addressList.item(m);
                                if (!"address".equals(address.getLocalName())) continue;
                                address.getAttributes().getNamedItem("location").setNodeValue(url);
                            }
                        }
                    }
                }
            }
            return XMLUtils.toByteArray(documentLogico);
        }
        catch (Exception e) {
            throw new SICAToOpenSPCoopUtilitiesException("readWsdlImplementativo error: " + e.getMessage(), e);
        }
    }

    public static boolean isWsdlEmpty(byte[] wsdl) {
        try {
            String tmp = new String(wsdl).trim();
            if (tmp.startsWith("<?xml")) {
                int indexOf = tmp.indexOf(">");
                tmp = tmp.substring(indexOf + 1);
            }
            if ("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wsdl:definitions xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\"/>".equals(tmp)) {
                return true;
            }
            int presenzaDiElementi = 0;
            int indexOf = tmp.indexOf("<");
            while (indexOf >= 0) {
                ++presenzaDiElementi;
                indexOf = tmp.indexOf("<", indexOf + 1);
            }
            return presenzaDiElementi <= 2;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static AccordoCooperazione accordoCooperazione_sicaToOpenspcoop(it.gov.spcoop.sica.dao.AccordoCooperazione accordoCooperazioneSICA, SICAtoOpenSPCoopContext sicaToOpenspcoopContext) throws SICAToOpenSPCoopUtilitiesException {
        ElencoServiziComposti serviziComposti;
        ElencoPartecipanti elencoPartecipantiSICA;
        Documento docOpenspcoop;
        int i;
        AccordoCooperazione accCooperazioneOpenspcoop = new AccordoCooperazione();
        it.gov.spcoop.sica.manifest.AccordoCooperazione manifest = accordoCooperazioneSICA.getManifesto();
        accCooperazioneOpenspcoop.setDescrizione(manifest.getDescrizione());
        accCooperazioneOpenspcoop.setNome(manifest.getNome());
        accCooperazioneOpenspcoop.setVersione(manifest.getVersione());
        accCooperazioneOpenspcoop.setOraRegistrazione(manifest.getDataCreazione());
        accCooperazioneOpenspcoop.setDataPubblicazione(manifest.getDataPubblicazione());
        AccordoCooperazioneSoggettoReferente soggettoReferente = new AccordoCooperazioneSoggettoReferente();
        IDSoggetto soggettoCoordinatore = sicaToOpenspcoopContext.getIDSoggetto(SICAtoOpenSPCoopUtilities.removeURI_IDSoggettoSica(manifest.getCoordinatore()));
        if (soggettoCoordinatore == null) {
            soggettoCoordinatore = SICAtoOpenSPCoopUtilities.idSoggetto_sicaToOpenspcoop(manifest.getCoordinatore());
        }
        soggettoReferente.setNome(soggettoCoordinatore.getNome());
        soggettoReferente.setTipo(soggettoCoordinatore.getTipo());
        accCooperazioneOpenspcoop.setSoggettoReferente(soggettoReferente);
        if (manifest.getAllegati() != null) {
            for (i = 0; i < manifest.getAllegati().sizeGenericoDocumentoList(); ++i) {
                String fileName = manifest.getAllegati().getGenericoDocumento(i);
                docOpenspcoop = new Documento();
                docOpenspcoop.setFile(fileName);
                docOpenspcoop.setRuolo(RuoliDocumento.allegato.toString());
                it.gov.spcoop.sica.dao.Documento docSICA = null;
                for (int j = 0; j < accordoCooperazioneSICA.sizeAllegati(); ++j) {
                    if (!fileName.equals(accordoCooperazioneSICA.getAllegato(j).getNome())) continue;
                    docSICA = accordoCooperazioneSICA.getAllegato(j);
                }
                if (docSICA == null) {
                    throw new SICAToOpenSPCoopUtilitiesException("Allegato con nome[" + fileName + "] non trovato");
                }
                docOpenspcoop.setTipo(docSICA.getTipo());
                docOpenspcoop.setByteContenuto(docSICA.getContenuto());
                accCooperazioneOpenspcoop.addAllegato(docOpenspcoop);
            }
        }
        if (manifest.getSpecificaSemiformale() != null) {
            for (i = 0; i < manifest.getSpecificaSemiformale().sizeDocumentoSemiformaleList(); ++i) {
                DocumentoSemiformale specificaSemiformale = manifest.getSpecificaSemiformale().getDocumentoSemiformale(i);
                docOpenspcoop = new Documento();
                String fileName = specificaSemiformale.getBase();
                docOpenspcoop.setFile(fileName);
                docOpenspcoop.setRuolo(RuoliDocumento.specificaSemiformale.toString());
                it.gov.spcoop.sica.dao.Documento docSICA = null;
                for (int j = 0; j < accordoCooperazioneSICA.sizeSpecificheSemiformali(); ++j) {
                    if (!fileName.equals(accordoCooperazioneSICA.getSpecificaSemiformale(j).getNome())) continue;
                    docSICA = accordoCooperazioneSICA.getSpecificaSemiformale(j);
                }
                if (docSICA == null) {
                    throw new SICAToOpenSPCoopUtilitiesException("SpecificaSemiformale con nome[" + fileName + "] non trovato");
                }
                docOpenspcoop.setTipo(docSICA.getTipo());
                docOpenspcoop.setByteContenuto(docSICA.getContenuto());
                accCooperazioneOpenspcoop.addSpecificaSemiformale(docOpenspcoop);
            }
        }
        if ((elencoPartecipantiSICA = manifest.getElencoPartecipanti()) != null) {
            for (int i2 = 0; i2 < elencoPartecipantiSICA.sizePartecipanteList(); ++i2) {
                String partecipante = elencoPartecipantiSICA.getPartecipante(i2);
                AccordoCooperazioneElencoPartecipantiSoggetto soggetto = new AccordoCooperazioneElencoPartecipantiSoggetto();
                IDSoggetto soggettoPartecipante = sicaToOpenspcoopContext.getIDSoggetto(SICAtoOpenSPCoopUtilities.removeURI_IDSoggettoSica(partecipante));
                if (soggettoPartecipante == null) {
                    soggettoPartecipante = SICAtoOpenSPCoopUtilities.idSoggetto_sicaToOpenspcoop(partecipante);
                }
                soggetto.setNome(soggettoPartecipante.getNome());
                soggetto.setTipo(soggettoPartecipante.getTipo());
                accCooperazioneOpenspcoop.addElencoPartecipanti(soggetto);
            }
        }
        if ((serviziComposti = manifest.getServiziComposti()) != null) {
            for (int i3 = 0; i3 < serviziComposti.sizeServizioCompostoList(); ++i3) {
                String servizioComposto = serviziComposti.getServizioComposto(i3);
                IDAccordo idAccordo = SICAtoOpenSPCoopUtilities.idAccordoServizioComposto_sicaToOpenspcoop(servizioComposto, sicaToOpenspcoopContext);
                try {
                    accCooperazioneOpenspcoop.addUriServiziComposti(IDAccordo.getUriFromIDAccordo(idAccordo));
                    continue;
                }
                catch (Exception e) {
                    throw new SICAToOpenSPCoopUtilitiesException("uri IDAccordo servizio composto [" + servizioComposto + "] non costruibile: " + e.getMessage(), e);
                }
            }
        }
        if (manifest.getFirmato()) {
            accCooperazioneOpenspcoop.setByteFirma(accordoCooperazioneSICA.getFirma().getBytes());
        }
        return accCooperazioneOpenspcoop;
    }

    public static it.gov.spcoop.sica.dao.AccordoCooperazione accordoCooperazione_openspcoopToSica(AccordoCooperazione accordoCooperazioneOpenspcoop, SICAtoOpenSPCoopContext sicaToOpenspcoopContext) throws SICAToOpenSPCoopUtilitiesException {
        Documento docOpenspcoop;
        boolean includiInfoRegistroGenerale = sicaToOpenspcoopContext.isSICAClient_includiInfoRegistroGenerale();
        it.gov.spcoop.sica.dao.AccordoCooperazione accCooperazioneSICA = new it.gov.spcoop.sica.dao.AccordoCooperazione();
        it.gov.spcoop.sica.manifest.AccordoCooperazione manifest = new it.gov.spcoop.sica.manifest.AccordoCooperazione();
        manifest.setDescrizione(accordoCooperazioneOpenspcoop.getDescrizione());
        manifest.setNome(accordoCooperazioneOpenspcoop.getNome());
        manifest.setDataCreazione(accordoCooperazioneOpenspcoop.getOraRegistrazione());
        if (includiInfoRegistroGenerale) {
            manifest.setVersione(accordoCooperazioneOpenspcoop.getVersione());
            manifest.setDataPubblicazione(accordoCooperazioneOpenspcoop.getDataPubblicazione());
            if (accordoCooperazioneOpenspcoop.getByteFirma() != null) {
                manifest.setFirmato(true);
            }
            if (accordoCooperazioneOpenspcoop.getSoggettoReferente() == null) {
                throw new SICAToOpenSPCoopUtilitiesException("Soggetto referente non definito");
            }
            IDSoggetto soggettoCoordinatore = new IDSoggetto(accordoCooperazioneOpenspcoop.getSoggettoReferente().getTipo(), accordoCooperazioneOpenspcoop.getSoggettoReferente().getNome());
            String uriCoordinatore = sicaToOpenspcoopContext.getCodiceIPA(soggettoCoordinatore);
            uriCoordinatore = uriCoordinatore == null ? SICAtoOpenSPCoopUtilities.idSoggetto_openspcoopToSica(soggettoCoordinatore) : SICAtoOpenSPCoopUtilities.appendURI_IDSoggettoSica(uriCoordinatore);
            manifest.setCoordinatore(uriCoordinatore);
            ElencoServiziComposti sComposti = null;
            for (int i = 0; i < accordoCooperazioneOpenspcoop.sizeUriServiziCompostiList(); ++i) {
                String uriServizioComposto = accordoCooperazioneOpenspcoop.getUriServiziComposti(i);
                if (sComposti == null) {
                    sComposti = new ElencoServiziComposti();
                }
                try {
                    sComposti.addServizioComposto(SICAtoOpenSPCoopUtilities.idAccordoServizioComposto_openspcoopToSica(IDAccordo.getIDAccordoFromUri(uriServizioComposto), sicaToOpenspcoopContext));
                    continue;
                }
                catch (Exception e) {
                    throw new SICAToOpenSPCoopUtilitiesException("Costruzione IDAccordo servizio composto [" + uriServizioComposto + "] non riuscito: " + e.getMessage(), e);
                }
            }
            if (sComposti != null) {
                manifest.setServiziComposti(sComposti);
            }
        }
        if (accordoCooperazioneOpenspcoop.sizeAllegatoList() > 0) {
            ElencoAllegati allegato = new ElencoAllegati();
            for (int i = 0; i < accordoCooperazioneOpenspcoop.sizeAllegatoList(); ++i) {
                docOpenspcoop = accordoCooperazioneOpenspcoop.getAllegato(i);
                allegato.addGenericoDocumento(docOpenspcoop.getFile());
                it.gov.spcoop.sica.dao.Documento docSICA = new it.gov.spcoop.sica.dao.Documento();
                docSICA.setTipo(docOpenspcoop.getTipo());
                docSICA.setNome(docOpenspcoop.getFile());
                if (docOpenspcoop.getByteContenuto() == null) {
                    throw new SICAToOpenSPCoopUtilitiesException("Byte dell'allegato " + docOpenspcoop.getFile() + " di tipo " + docOpenspcoop.getTipo() + " non forniti");
                }
                docSICA.setContenuto(docOpenspcoop.getByteContenuto());
                accCooperazioneSICA.addAllegato(docSICA);
            }
            manifest.setAllegati(allegato);
        }
        if (accordoCooperazioneOpenspcoop.sizeSpecificaSemiformaleList() > 0) {
            SpecificaSemiformale specificaSemiformale = new SpecificaSemiformale();
            for (int i = 0; i < accordoCooperazioneOpenspcoop.sizeSpecificaSemiformaleList(); ++i) {
                docOpenspcoop = accordoCooperazioneOpenspcoop.getSpecificaSemiformale(i);
                DocumentoSemiformale docSemiformale = new DocumentoSemiformale();
                docSemiformale.setTipo(docOpenspcoop.getTipo());
                docSemiformale.setBase(docOpenspcoop.getFile());
                specificaSemiformale.addDocumentoSemiformale(docSemiformale);
                it.gov.spcoop.sica.dao.Documento docSICA = new it.gov.spcoop.sica.dao.Documento();
                docSICA.setTipo(docOpenspcoop.getTipo());
                docSICA.setNome(docOpenspcoop.getFile());
                if (docOpenspcoop.getByteContenuto() == null) {
                    throw new SICAToOpenSPCoopUtilitiesException("Byte della specifica semiformale " + docOpenspcoop.getFile() + " di tipo " + docOpenspcoop.getTipo() + " non forniti");
                }
                docSICA.setContenuto(docOpenspcoop.getByteContenuto());
                accCooperazioneSICA.addSpecificaSemiformale(docSICA);
            }
            manifest.setSpecificaSemiformale(specificaSemiformale);
        }
        ElencoPartecipanti partecipanti = null;
        for (int i = 0; i < accordoCooperazioneOpenspcoop.sizeElencoPartecipantiList(); ++i) {
            String codiceIPAPartecipante;
            AccordoCooperazioneElencoPartecipantiSoggetto soggetto = accordoCooperazioneOpenspcoop.getElencoPartecipanti(i);
            IDSoggetto idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
            if (partecipanti == null) {
                partecipanti = new ElencoPartecipanti();
            }
            codiceIPAPartecipante = (codiceIPAPartecipante = sicaToOpenspcoopContext.getCodiceIPA(idSoggetto)) == null ? SICAtoOpenSPCoopUtilities.idSoggetto_openspcoopToSica(idSoggetto) : SICAtoOpenSPCoopUtilities.appendURI_IDSoggettoSica(codiceIPAPartecipante);
            partecipanti.addPartecipante(codiceIPAPartecipante);
        }
        if (partecipanti != null) {
            manifest.setElencoPartecipanti(partecipanti);
        }
        if (includiInfoRegistroGenerale && accordoCooperazioneOpenspcoop.getByteFirma() != null) {
            Firma firma = new Firma();
            accCooperazioneSICA.setFirma(firma);
        }
        accCooperazioneSICA.setManifesto(manifest);
        return accCooperazioneSICA;
    }

    public static AccordoServizio accordoServizioParteComune_sicaToOpenspcoop(it.gov.spcoop.sica.dao.AccordoServizioParteComune accordoServizioSICA, SICAtoOpenSPCoopContext sicaToOpenspcoopContext) throws SICAToOpenSPCoopUtilitiesException {
        int i;
        boolean verificaCorreggiLocationWSDL = sicaToOpenspcoopContext.isWSDL_XSD_allineaImportInclude();
        boolean prettyDocument = sicaToOpenspcoopContext.isWSDL_XSD_prettyDocuments();
        boolean documentoSpecificaEGOV_asClientSICADisabled_childUnquilified = sicaToOpenspcoopContext.isInformazioniEGov_wscpDisabled_childUnqualified();
        boolean documentoSpecificaEGOV_asClientSICAEnabled_childUnquilified = sicaToOpenspcoopContext.isInformazioniEGov_wscpEnabled_childUnqualified();
        AccordoServizio accServizioOpenspcoop = new AccordoServizio();
        it.gov.spcoop.sica.manifest.AccordoServizio manifest = accordoServizioSICA.getManifesto();
        accServizioOpenspcoop.setDescrizione(manifest.getDescrizione());
        accServizioOpenspcoop.setNome(manifest.getNome());
        accServizioOpenspcoop.setVersione(manifest.getVersione());
        accServizioOpenspcoop.setOraRegistrazione(manifest.getDataCreazione());
        accServizioOpenspcoop.setDataPubblicazione(manifest.getDataPubblicazione());
        accServizioOpenspcoop.setProfiloCollaborazione("oneway");
        AccordoServizioParteComune parteComune = manifest.getParteComune();
        SpecificaInterfaccia specificaInterfaccia = parteComune.getSpecificaInterfaccia();
        if (accordoServizioSICA.getInterfacciaConcettuale() != null || accordoServizioSICA.getInterfacciaLogicaLatoErogatore() != null || accordoServizioSICA.getInterfacciaLogicaLatoFruitore() != null) {
            if (specificaInterfaccia.getInterfacciaConcettuale() != null && accordoServizioSICA.getInterfacciaConcettuale() != null && !SICAtoOpenSPCoopUtilities.isWsdlEmpty(accordoServizioSICA.getInterfacciaConcettuale().getContenuto())) {
                accServizioOpenspcoop.setByteWsdlConcettuale(accordoServizioSICA.getInterfacciaConcettuale().getContenuto());
            }
            if (specificaInterfaccia.getInterfacciaLogicaLatoErogatore() != null && accordoServizioSICA.getInterfacciaLogicaLatoErogatore() != null && !SICAtoOpenSPCoopUtilities.isWsdlEmpty(accordoServizioSICA.getInterfacciaLogicaLatoErogatore().getContenuto())) {
                accServizioOpenspcoop.setByteWsdlLogicoErogatore(accordoServizioSICA.getInterfacciaLogicaLatoErogatore().getContenuto());
            }
            if (specificaInterfaccia.getInterfacciaLogicaLatoFruitore() != null && accordoServizioSICA.getInterfacciaLogicaLatoFruitore() != null && !SICAtoOpenSPCoopUtilities.isWsdlEmpty(accordoServizioSICA.getInterfacciaLogicaLatoFruitore().getContenuto())) {
                accServizioOpenspcoop.setByteWsdlLogicoFruitore(accordoServizioSICA.getInterfacciaLogicaLatoFruitore().getContenuto());
            }
        }
        SpecificaConversazione specificaConversazione = parteComune.getSpecificaConversazione();
        if (accordoServizioSICA.getConversazioneConcettuale() != null || accordoServizioSICA.getConversazioneLogicaErogatore() != null || accordoServizioSICA.getConversazioneLogicaFruitore() != null) {
            if (specificaConversazione.getConversazioneConcettuale() != null && accordoServizioSICA.getConversazioneConcettuale() != null) {
                accServizioOpenspcoop.setByteWsblConcettuale(accordoServizioSICA.getConversazioneConcettuale().getContenuto());
            }
            if (specificaConversazione.getConversazioneLogicaLatoErogatore() != null && accordoServizioSICA.getConversazioneLogicaErogatore() != null) {
                accServizioOpenspcoop.setByteWsblLogicoErogatore(accordoServizioSICA.getConversazioneLogicaErogatore().getContenuto());
            }
            if (specificaConversazione.getConversazioneLogicaLatoFruitore() != null && accordoServizioSICA.getConversazioneLogicaFruitore() != null) {
                accServizioOpenspcoop.setByteWsblLogicoFruitore(accordoServizioSICA.getConversazioneLogicaFruitore().getContenuto());
            }
        }
        AccordoServizioSoggettoReferente soggettoReferente = new AccordoServizioSoggettoReferente();
        IDSoggetto soggettoPubblicatore = sicaToOpenspcoopContext.getIDSoggetto(SICAtoOpenSPCoopUtilities.removeURI_IDSoggettoSica(parteComune.getPubblicatore()));
        if (soggettoPubblicatore == null) {
            soggettoPubblicatore = SICAtoOpenSPCoopUtilities.idSoggetto_sicaToOpenspcoop(parteComune.getPubblicatore());
        }
        soggettoReferente.setNome(soggettoPubblicatore.getNome());
        soggettoReferente.setTipo(soggettoPubblicatore.getTipo());
        accServizioOpenspcoop.setSoggettoReferente(soggettoReferente);
        boolean findDocumentoSpecificaEGOV = false;
        String tipoDocumentoSpecificaEGovTrovato = null;
        String fileNameSpecificaEGovTrovata = null;
        if (manifest.getAllegati() != null) {
            for (i = 0; i < manifest.getAllegati().sizeGenericoDocumentoList(); ++i) {
                Documento docOpenspcoop = new Documento();
                String fileName = manifest.getAllegati().getGenericoDocumento(i);
                docOpenspcoop.setFile(fileName);
                docOpenspcoop.setRuolo(RuoliDocumento.allegato.toString());
                it.gov.spcoop.sica.dao.Documento docSICA = null;
                for (int j = 0; j < accordoServizioSICA.sizeAllegati(); ++j) {
                    if (!fileName.equals(accordoServizioSICA.getAllegato(j).getNome())) continue;
                    docSICA = accordoServizioSICA.getAllegato(j);
                }
                if (docSICA == null) {
                    throw new SICAToOpenSPCoopUtilitiesException("Allegato con nome[" + fileName + "] non trovato");
                }
                if ("InterfacciaDefinitoria.xsd".equals(fileName)) {
                    accServizioOpenspcoop.setByteWsdlDefinitorio(docSICA.getContenuto());
                    continue;
                }
                boolean specificaEGovAsClientSICA = it.gov.spcoop.sica.wscp.driver.XMLUtils.isProfiloCollaborazioneEGOV(docSICA.getContenuto());
                boolean specificaEGovAsDocumentoCNIPA = it.cnipa.collprofiles.driver.XMLUtils.isProfiloCollaborazioneEGOV(docSICA.getContenuto());
                if (findDocumentoSpecificaEGOV) {
                    String fileNameTmp = "allegati" + File.separatorChar + fileName;
                    if (specificaEGovAsClientSICA) {
                        throw new SICAToOpenSPCoopUtilitiesException("Nel package sono presenti piu' di una specifica delle informazioni egov. E' stata gia' processata una specifica di tipo " + tipoDocumentoSpecificaEGovTrovato + " (" + fileNameSpecificaEGovTrovata + ") e adesso e' stato riscontrato una specifica di tipo " + "http://spcoop.gov.it/sica/wscp" + " (" + fileNameTmp + ")");
                    }
                    if (specificaEGovAsDocumentoCNIPA) {
                        throw new SICAToOpenSPCoopUtilitiesException("Nel package sono presenti piu' di una specifica delle informazioni egov. E' stata gia' processata una specifica di tipo " + tipoDocumentoSpecificaEGovTrovato + " (" + fileNameSpecificaEGovTrovata + ") e adesso e' stato riscontrato una specifica di tipo " + "http://www.cnipa.it/collProfiles" + " (" + fileNameTmp + ")");
                    }
                } else {
                    if (specificaEGovAsClientSICA && specificaEGovAsDocumentoCNIPA) {
                        throw new SICAToOpenSPCoopUtilitiesException("Trovata specifica delle informazioni egov sia di tipo http://spcoop.gov.it/sica/wscp che di tipo http://www.cnipa.it/collProfiles ??");
                    }
                    if (specificaEGovAsClientSICA || specificaEGovAsDocumentoCNIPA) {
                        findDocumentoSpecificaEGOV = true;
                        fileNameSpecificaEGovTrovata = "allegati" + File.separatorChar + fileName;
                    }
                }
                if (specificaEGovAsClientSICA) {
                    try {
                        it.gov.spcoop.sica.wscp.driver.XMLUtils.mapProfiloCollaborazioneEGOVIntoAS(docSICA.getContenuto(), accServizioOpenspcoop, documentoSpecificaEGOV_asClientSICAEnabled_childUnquilified);
                        tipoDocumentoSpecificaEGovTrovato = "http://spcoop.gov.it/sica/wscp";
                        continue;
                    }
                    catch (Exception e) {
                        throw new SICAToOpenSPCoopUtilitiesException("Errore durante la verifica dell'esistenza del documento di tipo 'ProfiloCollaborazioneEGOV' per il file [" + fileName + "] : " + e.getMessage(), e);
                    }
                }
                if (specificaEGovAsDocumentoCNIPA) {
                    try {
                        it.cnipa.collprofiles.driver.XMLUtils.mapProfiloCollaborazioneEGOVIntoAS(docSICA.getContenuto(), accServizioOpenspcoop, documentoSpecificaEGOV_asClientSICADisabled_childUnquilified);
                        tipoDocumentoSpecificaEGovTrovato = "http://www.cnipa.it/collProfiles";
                        continue;
                    }
                    catch (Exception e) {
                        throw new SICAToOpenSPCoopUtilitiesException("Errore durante la verifica dell'esistenza del documento di tipo 'ProfiloCollaborazioneEGOV' per il file [" + fileName + "] : " + e.getMessage(), e);
                    }
                }
                docOpenspcoop.setTipo(docSICA.getTipo());
                docOpenspcoop.setByteContenuto(docSICA.getContenuto());
                accServizioOpenspcoop.addAllegato(docOpenspcoop);
            }
        }
        if (manifest.getSpecificaSemiformale() != null) {
            for (i = 0; i < manifest.getSpecificaSemiformale().sizeDocumentoSemiformaleList(); ++i) {
                DocumentoSemiformale specificaSemiformale = manifest.getSpecificaSemiformale().getDocumentoSemiformale(i);
                Documento docOpenspcoop = new Documento();
                String fileName = specificaSemiformale.getBase();
                it.gov.spcoop.sica.dao.Documento docSICA = null;
                for (int j = 0; j < accordoServizioSICA.sizeSpecificheSemiformali(); ++j) {
                    if (!fileName.equals(accordoServizioSICA.getSpecificaSemiformale(j).getNome())) continue;
                    docSICA = accordoServizioSICA.getSpecificaSemiformale(j);
                }
                if (docSICA == null) {
                    throw new SICAToOpenSPCoopUtilitiesException("SpecificaSemiformale con nome[" + fileName + "] non trovato");
                }
                boolean specificaEGovAsClientSICA = it.gov.spcoop.sica.wscp.driver.XMLUtils.isProfiloCollaborazioneEGOV(docSICA.getContenuto());
                boolean specificaEGovAsDocumentoCNIPA = it.cnipa.collprofiles.driver.XMLUtils.isProfiloCollaborazioneEGOV(docSICA.getContenuto());
                if (findDocumentoSpecificaEGOV) {
                    String fileNameTmp = "specificaSemiformale" + File.separatorChar + fileName;
                    if (specificaEGovAsClientSICA) {
                        throw new SICAToOpenSPCoopUtilitiesException("Nel package sono presenti piu' di una specifica delle informazioni egov. E' stata gia' processata una specifica di tipo " + tipoDocumentoSpecificaEGovTrovato + " (" + fileNameSpecificaEGovTrovata + ") e adesso e' stato riscontrato una specifica di tipo " + "http://spcoop.gov.it/sica/wscp" + " (" + fileNameTmp + ")");
                    }
                    if (specificaEGovAsDocumentoCNIPA) {
                        throw new SICAToOpenSPCoopUtilitiesException("Nel package sono presenti piu' di una specifica delle informazioni egov. E' stata gia' processata una specifica di tipo " + tipoDocumentoSpecificaEGovTrovato + " (" + fileNameSpecificaEGovTrovata + ") e adesso e' stato riscontrato una specifica di tipo " + "http://www.cnipa.it/collProfiles" + " (" + fileNameTmp + ")");
                    }
                } else {
                    if (specificaEGovAsClientSICA && specificaEGovAsDocumentoCNIPA) {
                        throw new SICAToOpenSPCoopUtilitiesException("La specifica delle informazioni egov e' sia di tipo http://spcoop.gov.it/sica/wscp che di tipo http://www.cnipa.it/collProfiles ??");
                    }
                    if (specificaEGovAsClientSICA || specificaEGovAsDocumentoCNIPA) {
                        findDocumentoSpecificaEGOV = true;
                        fileNameSpecificaEGovTrovata = "specificaSemiformale" + File.separatorChar + fileName;
                    }
                }
                if (specificaEGovAsClientSICA) {
                    try {
                        it.gov.spcoop.sica.wscp.driver.XMLUtils.mapProfiloCollaborazioneEGOVIntoAS(docSICA.getContenuto(), accServizioOpenspcoop, documentoSpecificaEGOV_asClientSICAEnabled_childUnquilified);
                        tipoDocumentoSpecificaEGovTrovato = "http://spcoop.gov.it/sica/wscp";
                        findDocumentoSpecificaEGOV = true;
                        continue;
                    }
                    catch (Exception e) {
                        throw new SICAToOpenSPCoopUtilitiesException("Errore durante la verifica dell'esistenza del documento di tipo 'ProfiloCollaborazioneEGOV' per il file [" + fileName + "] : " + e.getMessage(), e);
                    }
                }
                if (specificaEGovAsDocumentoCNIPA) {
                    try {
                        it.cnipa.collprofiles.driver.XMLUtils.mapProfiloCollaborazioneEGOVIntoAS(docSICA.getContenuto(), accServizioOpenspcoop, documentoSpecificaEGOV_asClientSICADisabled_childUnquilified);
                        tipoDocumentoSpecificaEGovTrovato = "http://www.cnipa.it/collProfiles";
                        findDocumentoSpecificaEGOV = true;
                        continue;
                    }
                    catch (Exception e) {
                        throw new SICAToOpenSPCoopUtilitiesException("Errore durante la verifica dell'esistenza del documento di tipo 'ProfiloCollaborazioneEGOV' per il file [" + fileName + "] : " + e.getMessage(), e);
                    }
                }
                docOpenspcoop.setFile(fileName);
                docOpenspcoop.setRuolo(RuoliDocumento.specificaSemiformale.toString());
                docOpenspcoop.setTipo(docSICA.getTipo());
                docOpenspcoop.setByteContenuto(docSICA.getContenuto());
                accServizioOpenspcoop.addSpecificaSemiformale(docOpenspcoop);
            }
        }
        if (manifest.getFirmato()) {
            accServizioOpenspcoop.setByteFirma(accordoServizioSICA.getFirma().getBytes());
        }
        if (verificaCorreggiLocationWSDL) {
            try {
                RegistroOpenSPCoopUtilities registroOpenSPCoopUtilities = new RegistroOpenSPCoopUtilities(Logger.getLogger((String)"openspcoop.core"));
                registroOpenSPCoopUtilities.updateLocation(accServizioOpenspcoop, false, prettyDocument);
            }
            catch (Exception e) {
                throw new SICAToOpenSPCoopUtilitiesException("RegistroOpenSPCoopUtilities.setImportLocation error: " + e.getMessage(), e);
            }
        }
        return accServizioOpenspcoop;
    }

    public static it.gov.spcoop.sica.dao.AccordoServizioParteComune accordoServizioParteComune_openspcoopToSica(AccordoServizio accordoServizioOpenspcoop, SICAtoOpenSPCoopContext sicaToOpenspcoopContext) throws SICAToOpenSPCoopUtilitiesException {
        it.gov.spcoop.sica.dao.Documento doc;
        DocumentoConversazione docConversazione;
        it.gov.spcoop.sica.dao.Documento doc2;
        DocumentoInterfaccia docInterfaccia;
        boolean documentoSpecificaEGOV_asClientSICA = sicaToOpenspcoopContext.isInformazioniEGov_wscp();
        boolean documentoSpecificaEGOV_asSpecificaSemiformale = sicaToOpenspcoopContext.isInformazioniEGov_specificaSemiformale();
        boolean documentoSpecificaEGOV_asClientSICADisabled_namespaceCNIPA = sicaToOpenspcoopContext.isInformazioniEGov_wscpDisabled_namespaceCnipa();
        boolean documentoSpecificaEGOV_asClientSICAEnabled_childUnquilified = sicaToOpenspcoopContext.isInformazioniEGov_wscpEnabled_childUnqualified();
        boolean documentoSpecificaEGOV_nomiSPCoopQualified = sicaToOpenspcoopContext.isInformazioniEGov_nomiSPCoop_qualified();
        boolean verificaCorreggiLocationWSDL = sicaToOpenspcoopContext.isWSDL_XSD_allineaImportInclude();
        boolean prettyDocument = sicaToOpenspcoopContext.isWSDL_XSD_prettyDocuments();
        boolean includiInfoRegistroGenerale = sicaToOpenspcoopContext.isSICAClient_includiInfoRegistroGenerale();
        boolean wsdlEmptySeNonDefiniti = sicaToOpenspcoopContext.isWSDL_XSD_accordiParteSpecifica_wsdlEmpty();
        if (verificaCorreggiLocationWSDL) {
            try {
                RegistroOpenSPCoopUtilities registroOpenSPCoopUtilities = new RegistroOpenSPCoopUtilities(Logger.getLogger((String)"openspcoop.core"));
                registroOpenSPCoopUtilities.updateLocation(accordoServizioOpenspcoop, true, prettyDocument);
            }
            catch (Exception e) {
                throw new SICAToOpenSPCoopUtilitiesException("RegistroOpenSPCoopUtilities.setImportLocation error: " + e.getMessage(), e);
            }
        }
        it.gov.spcoop.sica.dao.AccordoServizioParteComune accServParteComuneSICA = new it.gov.spcoop.sica.dao.AccordoServizioParteComune();
        it.gov.spcoop.sica.manifest.AccordoServizio manifest = new it.gov.spcoop.sica.manifest.AccordoServizio();
        manifest.setDescrizione(accordoServizioOpenspcoop.getDescrizione());
        manifest.setNome(accordoServizioOpenspcoop.getNome());
        manifest.setDataCreazione(accordoServizioOpenspcoop.getOraRegistrazione());
        AccordoServizioParteComune parteComune = new AccordoServizioParteComune();
        if (includiInfoRegistroGenerale) {
            manifest.setVersione(accordoServizioOpenspcoop.getVersione());
            manifest.setDataPubblicazione(accordoServizioOpenspcoop.getDataPubblicazione());
            if (accordoServizioOpenspcoop.getByteFirma() != null) {
                manifest.setFirmato(true);
            }
            if (accordoServizioOpenspcoop.getSoggettoReferente() == null) {
                throw new SICAToOpenSPCoopUtilitiesException("Soggetto referente non definito");
            }
            IDSoggetto soggettoPubblicatore = new IDSoggetto(accordoServizioOpenspcoop.getSoggettoReferente().getTipo(), accordoServizioOpenspcoop.getSoggettoReferente().getNome());
            String uriPubblicatore = sicaToOpenspcoopContext.getCodiceIPA(soggettoPubblicatore);
            uriPubblicatore = uriPubblicatore == null ? SICAtoOpenSPCoopUtilities.idSoggetto_openspcoopToSica(soggettoPubblicatore) : SICAtoOpenSPCoopUtilities.appendURI_IDSoggettoSica(uriPubblicatore);
            parteComune.setPubblicatore(uriPubblicatore);
        }
        SpecificaInterfaccia specificaInterfaccia = null;
        if (accordoServizioOpenspcoop.getByteWsdlConcettuale() != null || accordoServizioOpenspcoop.getByteWsdlLogicoErogatore() != null || accordoServizioOpenspcoop.getByteWsdlLogicoFruitore() != null) {
            specificaInterfaccia = new SpecificaInterfaccia();
        }
        if (wsdlEmptySeNonDefiniti || accordoServizioOpenspcoop.getByteWsdlConcettuale() != null) {
            docInterfaccia = new DocumentoInterfaccia();
            docInterfaccia.setBase("InterfacciaConcettuale.wsdl");
            docInterfaccia.setTipo(TipiDocumentoInterfaccia.WSDL.toString());
            specificaInterfaccia.setInterfacciaConcettuale(docInterfaccia);
            doc2 = new it.gov.spcoop.sica.dao.Documento();
            doc2.setTipo(TipiDocumentoInterfaccia.WSDL.toString());
            doc2.setNome("InterfacciaConcettuale.wsdl");
            if (accordoServizioOpenspcoop.getByteWsdlConcettuale() != null) {
                doc2.setContenuto(accordoServizioOpenspcoop.getByteWsdlConcettuale());
            } else {
                doc2.setContenuto("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wsdl:definitions xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\"/>".getBytes());
            }
            accServParteComuneSICA.setInterfacciaConcettuale(doc2);
        }
        if (wsdlEmptySeNonDefiniti || accordoServizioOpenspcoop.getByteWsdlLogicoErogatore() != null) {
            docInterfaccia = new DocumentoInterfaccia();
            docInterfaccia.setBase("InterfacciaLogicaErogatore.wsdl");
            docInterfaccia.setTipo(TipiDocumentoInterfaccia.WSDL.toString());
            specificaInterfaccia.setInterfacciaLogicaLatoErogatore(docInterfaccia);
            doc2 = new it.gov.spcoop.sica.dao.Documento();
            doc2.setTipo(TipiDocumentoInterfaccia.WSDL.toString());
            doc2.setNome("InterfacciaLogicaErogatore.wsdl");
            if (accordoServizioOpenspcoop.getByteWsdlLogicoErogatore() != null) {
                doc2.setContenuto(accordoServizioOpenspcoop.getByteWsdlLogicoErogatore());
            } else {
                doc2.setContenuto("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wsdl:definitions xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\"/>".getBytes());
            }
            accServParteComuneSICA.setInterfacciaLogicaLatoErogatore(doc2);
        }
        if (wsdlEmptySeNonDefiniti || accordoServizioOpenspcoop.getByteWsdlLogicoFruitore() != null) {
            docInterfaccia = new DocumentoInterfaccia();
            docInterfaccia.setBase("InterfacciaLogicaFruitore.wsdl");
            docInterfaccia.setTipo(TipiDocumentoInterfaccia.WSDL.toString());
            specificaInterfaccia.setInterfacciaLogicaLatoFruitore(docInterfaccia);
            doc2 = new it.gov.spcoop.sica.dao.Documento();
            doc2.setTipo(TipiDocumentoInterfaccia.WSDL.toString());
            doc2.setNome("InterfacciaLogicaFruitore.wsdl");
            if (accordoServizioOpenspcoop.getByteWsdlLogicoFruitore() != null) {
                doc2.setContenuto(accordoServizioOpenspcoop.getByteWsdlLogicoFruitore());
            } else {
                doc2.setContenuto("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wsdl:definitions xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\"/>".getBytes());
            }
            accServParteComuneSICA.setInterfacciaLogicaLatoFruitore(doc2);
        }
        if (specificaInterfaccia != null) {
            parteComune.setSpecificaInterfaccia(specificaInterfaccia);
        }
        SpecificaConversazione specificaConversazione = null;
        if (accordoServizioOpenspcoop.getByteWsblConcettuale() != null || accordoServizioOpenspcoop.getByteWsblLogicoErogatore() != null || accordoServizioOpenspcoop.getByteWsblLogicoFruitore() != null) {
            specificaConversazione = new SpecificaConversazione();
        }
        if (accordoServizioOpenspcoop.getByteWsblConcettuale() != null) {
            docConversazione = new DocumentoConversazione();
            docConversazione.setBase("ConversazioneConcettuale.wsbl");
            docConversazione.setTipo(TipiDocumentoConversazione.WSBL.toString());
            specificaConversazione.setConversazioneConcettuale(docConversazione);
            doc = new it.gov.spcoop.sica.dao.Documento();
            doc.setTipo(TipiDocumentoConversazione.WSBL.toString());
            doc.setNome("ConversazioneConcettuale.wsbl");
            doc.setContenuto(accordoServizioOpenspcoop.getByteWsblConcettuale());
            accServParteComuneSICA.setConversazioneConcettuale(doc);
        }
        if (accordoServizioOpenspcoop.getByteWsblLogicoErogatore() != null) {
            docConversazione = new DocumentoConversazione();
            docConversazione.setBase("ConversazioneLogicaLatoErogatore.wsbl");
            docConversazione.setTipo(TipiDocumentoConversazione.WSBL.toString());
            specificaConversazione.setConversazioneLogicaLatoErogatore(docConversazione);
            doc = new it.gov.spcoop.sica.dao.Documento();
            doc.setTipo(TipiDocumentoConversazione.WSBL.toString());
            doc.setNome("ConversazioneLogicaLatoErogatore.wsbl");
            doc.setContenuto(accordoServizioOpenspcoop.getByteWsblLogicoErogatore());
            accServParteComuneSICA.setConversazioneLogicaErogatore(doc);
        }
        if (accordoServizioOpenspcoop.getByteWsblLogicoFruitore() != null) {
            docConversazione = new DocumentoConversazione();
            docConversazione.setBase("ConversazioneLogicaLatoFruitore.wsbl");
            docConversazione.setTipo(TipiDocumentoConversazione.WSBL.toString());
            specificaConversazione.setConversazioneLogicaLatoFruitore(docConversazione);
            doc = new it.gov.spcoop.sica.dao.Documento();
            doc.setTipo(TipiDocumentoConversazione.WSBL.toString());
            doc.setNome("ConversazioneLogicaLatoFruitore.wsbl");
            doc.setContenuto(accordoServizioOpenspcoop.getByteWsblLogicoFruitore());
            accServParteComuneSICA.setConversazioneLogicaFruitore(doc);
        }
        if (specificaConversazione != null) {
            parteComune.setSpecificaConversazione(specificaConversazione);
        }
        ElencoAllegati allegati = null;
        if (accordoServizioOpenspcoop.sizePortTypeList() > 0 && !documentoSpecificaEGOV_asSpecificaSemiformale) {
            String docGenerico = null;
            if (documentoSpecificaEGOV_asClientSICA) {
                try {
                    docGenerico = it.gov.spcoop.sica.wscp.driver.XMLUtils.generaGenericoDocumento(accordoServizioOpenspcoop, accServParteComuneSICA, documentoSpecificaEGOV_nomiSPCoopQualified, documentoSpecificaEGOV_asClientSICAEnabled_childUnquilified);
                }
                catch (Exception e) {
                    throw new SICAToOpenSPCoopUtilitiesException("Errore durante la conversione delle informazioni eGov in Allegati (http://spcoop.gov.it/sica/wscp): " + e.getMessage(), e);
                }
            }
            try {
                docGenerico = it.cnipa.collprofiles.driver.XMLUtils.generaGenericoDocumento(accordoServizioOpenspcoop, accServParteComuneSICA, documentoSpecificaEGOV_asClientSICADisabled_namespaceCNIPA, documentoSpecificaEGOV_nomiSPCoopQualified);
            }
            catch (Exception e) {
                throw new SICAToOpenSPCoopUtilitiesException("Errore durante la conversione delle informazioni eGov in Allegati (http://www.cnipa.it/collProfiles): " + e.getMessage(), e);
            }
            if (docGenerico != null) {
                if (allegati == null) {
                    allegati = new ElencoAllegati();
                }
                allegati.addGenericoDocumento(docGenerico);
                manifest.setAllegati(allegati);
            }
        }
        if (accordoServizioOpenspcoop.sizeAllegatoList() > 0) {
            if (allegati == null) {
                allegati = new ElencoAllegati();
            }
            for (int i = 0; i < accordoServizioOpenspcoop.sizeAllegatoList(); ++i) {
                Documento docOpenspcoop = accordoServizioOpenspcoop.getAllegato(i);
                allegati.addGenericoDocumento(docOpenspcoop.getFile());
                it.gov.spcoop.sica.dao.Documento docSICA = new it.gov.spcoop.sica.dao.Documento();
                docSICA.setTipo(docOpenspcoop.getTipo());
                docSICA.setNome(docOpenspcoop.getFile());
                if (docOpenspcoop.getByteContenuto() == null) {
                    throw new SICAToOpenSPCoopUtilitiesException("Byte dell'allegato " + docOpenspcoop.getFile() + " di tipo " + docOpenspcoop.getTipo() + " non forniti");
                }
                docSICA.setContenuto(docOpenspcoop.getByteContenuto());
                accServParteComuneSICA.addAllegato(docSICA);
            }
            manifest.setAllegati(allegati);
        }
        if (accordoServizioOpenspcoop.getByteWsdlDefinitorio() != null) {
            if (allegati == null) {
                allegati = new ElencoAllegati();
            }
            allegati.addGenericoDocumento("InterfacciaDefinitoria.xsd");
            manifest.setAllegati(allegati);
            it.gov.spcoop.sica.dao.Documento docSICA = new it.gov.spcoop.sica.dao.Documento();
            docSICA.setTipo("XSD");
            docSICA.setNome("InterfacciaDefinitoria.xsd");
            docSICA.setContenuto(accordoServizioOpenspcoop.getByteWsdlDefinitorio());
            accServParteComuneSICA.addAllegato(docSICA);
        }
        SpecificaSemiformale specificaSemiformale = null;
        if (accordoServizioOpenspcoop.sizePortTypeList() > 0 && documentoSpecificaEGOV_asSpecificaSemiformale) {
            DocumentoSemiformale docSemiformale = null;
            if (documentoSpecificaEGOV_asClientSICA) {
                try {
                    docSemiformale = it.gov.spcoop.sica.wscp.driver.XMLUtils.generaDocumentoSemiformale(accordoServizioOpenspcoop, accServParteComuneSICA, documentoSpecificaEGOV_nomiSPCoopQualified, documentoSpecificaEGOV_asClientSICAEnabled_childUnquilified);
                }
                catch (Exception e) {
                    throw new SICAToOpenSPCoopUtilitiesException("Errore durante la conversione delle informazioni eGov in SpecificaSemiformale (http://spcoop.gov.it/sica/wscp): " + e.getMessage(), e);
                }
            }
            try {
                docSemiformale = it.cnipa.collprofiles.driver.XMLUtils.generaDocumentoSemiformale(accordoServizioOpenspcoop, accServParteComuneSICA, documentoSpecificaEGOV_asClientSICADisabled_namespaceCNIPA, documentoSpecificaEGOV_nomiSPCoopQualified);
            }
            catch (Exception e) {
                throw new SICAToOpenSPCoopUtilitiesException("Errore durante la conversione delle informazioni eGov in SpecificaSemiformale (http://www.cnipa.it/collProfiles): " + e.getMessage(), e);
            }
            if (docSemiformale != null) {
                if (specificaSemiformale == null) {
                    specificaSemiformale = new SpecificaSemiformale();
                }
                specificaSemiformale.addDocumentoSemiformale(docSemiformale);
                manifest.setSpecificaSemiformale(specificaSemiformale);
            }
        }
        if (accordoServizioOpenspcoop.sizeSpecificaSemiformaleList() > 0) {
            if (specificaSemiformale == null) {
                specificaSemiformale = new SpecificaSemiformale();
            }
            for (int i = 0; i < accordoServizioOpenspcoop.sizeSpecificaSemiformaleList(); ++i) {
                Documento docOpenspcoop = accordoServizioOpenspcoop.getSpecificaSemiformale(i);
                DocumentoSemiformale docSemiformale = new DocumentoSemiformale();
                docSemiformale.setTipo(docOpenspcoop.getTipo());
                docSemiformale.setBase(docOpenspcoop.getFile());
                specificaSemiformale.addDocumentoSemiformale(docSemiformale);
                it.gov.spcoop.sica.dao.Documento docSICA = new it.gov.spcoop.sica.dao.Documento();
                docSICA.setTipo(docOpenspcoop.getTipo());
                docSICA.setNome(docOpenspcoop.getFile());
                if (docOpenspcoop.getByteContenuto() == null) {
                    throw new SICAToOpenSPCoopUtilitiesException("Byte della specifica semiformale " + docOpenspcoop.getFile() + " di tipo " + docOpenspcoop.getTipo() + " non forniti");
                }
                docSICA.setContenuto(docOpenspcoop.getByteContenuto());
                accServParteComuneSICA.addSpecificaSemiformale(docSICA);
            }
            manifest.setSpecificaSemiformale(specificaSemiformale);
        }
        if (includiInfoRegistroGenerale && accordoServizioOpenspcoop.getByteFirma() != null) {
            Firma firma = new Firma();
            accServParteComuneSICA.setFirma(firma);
        }
        manifest.setParteComune(parteComune);
        accServParteComuneSICA.setManifesto(manifest);
        return accServParteComuneSICA;
    }

    public static ServizioSpcoop accordoServizioParteSpecifica_sicaToOpenspcoop(AccordoServizioParteSpecifica accordoServizioSICA, SICAtoOpenSPCoopContext sicaToOpenspcoopContext) throws SICAToOpenSPCoopUtilitiesException {
        return SICAtoOpenSPCoopUtilities.accordoServizioParteSpecifica_sicaToOpenspcoop(accordoServizioSICA, sicaToOpenspcoopContext, null);
    }

    public static ServizioSpcoop accordoServizioParteSpecifica_sicaToOpenspcoop(AccordoServizioParteSpecifica accordoServizioSICA, SICAtoOpenSPCoopContext sicaToOpenspcoopContext, String servizioSPCoop) throws SICAToOpenSPCoopUtilitiesException {
        SpecificaLivelliServizio specificaLivelliServizio;
        SpecificaSicurezza specificaSicurezza;
        it.gov.spcoop.sica.manifest.AccordoServizioParteSpecifica parteSpecifica;
        it.gov.spcoop.sica.manifest.AccordoServizio manifest;
        ServizioSpcoop accServizioOpenspcoop;
        boolean sicaToOpenspcoopAggiuntaImportParteComune;
        boolean eliminaInformazioniASParteComuneWSDL;
        boolean prettyDocument;
        boolean verificaCorreggiLocationWSDL;
        block70: {
            verificaCorreggiLocationWSDL = sicaToOpenspcoopContext.isWSDL_XSD_allineaImportInclude();
            prettyDocument = sicaToOpenspcoopContext.isWSDL_XSD_prettyDocuments();
            eliminaInformazioniASParteComuneWSDL = sicaToOpenspcoopContext.isWSDL_XSD_accordiParteSpecifica_gestioneParteComune();
            sicaToOpenspcoopAggiuntaImportParteComune = sicaToOpenspcoopContext.isWSDL_XSD_accordiParteSpecifica_sicaToOpenspcoop_aggiuntaImportParteComune();
            accServizioOpenspcoop = new ServizioSpcoop();
            manifest = accordoServizioSICA.getManifesto();
            ServizioSpcoopAccordoParteSpecifica accServizioAPSOpenspcoop = new ServizioSpcoopAccordoParteSpecifica();
            accServizioAPSOpenspcoop.setNome(manifest.getNome());
            accServizioAPSOpenspcoop.setVersione(manifest.getVersione());
            accServizioOpenspcoop.setAccordoParteSpecifica(accServizioAPSOpenspcoop);
            accServizioOpenspcoop.setDescrizione(manifest.getDescrizione());
            accServizioOpenspcoop.setOraRegistrazione(manifest.getDataCreazione());
            accServizioOpenspcoop.setDataPubblicazione(manifest.getDataPubblicazione());
            parteSpecifica = manifest.getParteSpecifica();
            try {
                String[] split = parteSpecifica.getRiferimentoParteComune().split(":");
                if (split.length < 2) {
                    throw new Exception("Riferimento parte comune non corretto (split non riuscito) [" + parteSpecifica.getRiferimentoParteComune() + "]");
                }
                if (split[1].equals("sc")) {
                    accServizioOpenspcoop.setAccordoServizio(IDAccordo.getUriFromIDAccordo(SICAtoOpenSPCoopUtilities.idAccordoServizioComposto_sicaToOpenspcoop(parteSpecifica.getRiferimentoParteComune(), sicaToOpenspcoopContext)));
                    break block70;
                }
                if (split[1].equals("adsc")) {
                    accServizioOpenspcoop.setAccordoServizio(IDAccordo.getUriFromIDAccordo(SICAtoOpenSPCoopUtilities.idAccordoServizioParteComune_sicaToOpenspcoop(parteSpecifica.getRiferimentoParteComune(), sicaToOpenspcoopContext)));
                    break block70;
                }
                throw new Exception("Tipo accordo [" + split[1] + "] non conosciuto");
            }
            catch (Exception e) {
                throw new SICAToOpenSPCoopUtilitiesException("Trasformazione riferimento parte comune [" + parteSpecifica.getRiferimentoParteComune() + "] non riuscita: " + e.getMessage(), e);
            }
        }
        String nomeServizioSPCoop = servizioSPCoop;
        String nomeServizioSPCoopCorrelato = servizioSPCoop;
        SpecificaPortiAccesso specificaInterfaccia = parteSpecifica.getSpecificaPortiAccesso();
        if (accordoServizioSICA.getPortiAccessoFruitore() != null || accordoServizioSICA.getPortiAccessoErogatore() != null) {
            Map<?, ?> bindings;
            DefinitionWrapper wsdl;
            Document d;
            RegistroOpenSPCoopUtilities registroOpenSPCoopUtilities;
            byte[] doc;
            if (specificaInterfaccia.getPortiAccessoErogatore() != null && accordoServizioSICA.getPortiAccessoErogatore() != null && !SICAtoOpenSPCoopUtilities.isWsdlEmpty(accordoServizioSICA.getPortiAccessoErogatore().getContenuto())) {
                doc = accordoServizioSICA.getPortiAccessoErogatore().getContenuto();
                if (eliminaInformazioniASParteComuneWSDL) {
                    try {
                        registroOpenSPCoopUtilities = new RegistroOpenSPCoopUtilities(Logger.getLogger((String)"openspcoop.core"));
                        doc = registroOpenSPCoopUtilities.eliminaASParteComune(doc, true);
                    }
                    catch (Exception e) {
                        throw new SICAToOpenSPCoopUtilitiesException("RegistroOpenSPCoopUtilities.eliminaASParteComune error: " + e.getMessage(), e);
                    }
                }
                if (sicaToOpenspcoopAggiuntaImportParteComune) {
                    try {
                        registroOpenSPCoopUtilities = new RegistroOpenSPCoopUtilities(Logger.getLogger((String)"openspcoop.core"));
                        doc = registroOpenSPCoopUtilities.aggiungiImportASParteComune(doc, true);
                    }
                    catch (Exception e) {
                        throw new SICAToOpenSPCoopUtilitiesException("RegistroOpenSPCoopUtilities.aggiungiImportASParteComune error: " + e.getMessage(), e);
                    }
                }
                accServizioOpenspcoop.setByteWsdlImplementativoErogatore(doc);
                accServizioOpenspcoop.setServizioCorrelato(false);
                if (nomeServizioSPCoop == null) {
                    try {
                        d = XMLUtils.newDocument(doc);
                        WSDLUtilities.removeImports(d);
                        wsdl = new DefinitionWrapper(d);
                        bindings = wsdl.getAllBindings();
                        if (bindings == null || bindings.size() <= 0) {
                            throw new Exception("Bindings non presenti");
                        }
                        for (Binding binding : bindings.values()) {
                            if (binding.getPortType() == null) {
                                throw new Exception("Un binding non specifica il port type implementato");
                            }
                            if (binding.getPortType().getQName() == null) {
                                throw new Exception("Binding con port type che non possiede QName");
                            }
                            if (nomeServizioSPCoop == null) {
                                nomeServizioSPCoop = binding.getPortType().getQName().getLocalPart();
                                continue;
                            }
                            nomeServizioSPCoop = nomeServizioSPCoop + "," + binding.getPortType().getQName().getLocalPart();
                        }
                    }
                    catch (Exception e) {
                        throw new SICAToOpenSPCoopUtilitiesException("Comprensione servizio spcoop da wsdl implementativo erogatore non riuscita: " + e.getMessage(), e);
                    }
                }
            }
            if (specificaInterfaccia.getPortiAccessoFruitore() != null && accordoServizioSICA.getPortiAccessoFruitore() != null && !SICAtoOpenSPCoopUtilities.isWsdlEmpty(accordoServizioSICA.getPortiAccessoFruitore().getContenuto())) {
                doc = accordoServizioSICA.getPortiAccessoFruitore().getContenuto();
                if (eliminaInformazioniASParteComuneWSDL) {
                    try {
                        registroOpenSPCoopUtilities = new RegistroOpenSPCoopUtilities(Logger.getLogger((String)"openspcoop.core"));
                        doc = registroOpenSPCoopUtilities.eliminaASParteComune(doc, false);
                    }
                    catch (Exception e) {
                        throw new SICAToOpenSPCoopUtilitiesException("RegistroOpenSPCoopUtilities.eliminaASParteComune error: " + e.getMessage(), e);
                    }
                }
                if (sicaToOpenspcoopAggiuntaImportParteComune) {
                    try {
                        registroOpenSPCoopUtilities = new RegistroOpenSPCoopUtilities(Logger.getLogger((String)"openspcoop.core"));
                        doc = registroOpenSPCoopUtilities.aggiungiImportASParteComune(doc, false);
                    }
                    catch (Exception e) {
                        throw new SICAToOpenSPCoopUtilitiesException("RegistroOpenSPCoopUtilities.aggiungiImportASParteComune error: " + e.getMessage(), e);
                    }
                }
                accServizioOpenspcoop.setByteWsdlImplementativoFruitore(doc);
                accServizioOpenspcoop.setServizioCorrelato(true);
                if (nomeServizioSPCoopCorrelato == null) {
                    try {
                        d = XMLUtils.newDocument(doc);
                        WSDLUtilities.removeImports(d);
                        wsdl = new DefinitionWrapper(d);
                        bindings = wsdl.getAllBindings();
                        if (bindings == null || bindings.size() <= 0) {
                            throw new Exception("Bindings non presenti");
                        }
                        for (Binding binding : bindings.values()) {
                            if (binding.getPortType() == null) {
                                throw new Exception("Un binding non specifica il port type implementato");
                            }
                            if (binding.getPortType().getQName() == null) {
                                throw new Exception("Binding con port type che non possiede QName");
                            }
                            if (nomeServizioSPCoopCorrelato == null) {
                                nomeServizioSPCoopCorrelato = binding.getPortType().getQName().getLocalPart();
                                continue;
                            }
                            nomeServizioSPCoopCorrelato = nomeServizioSPCoop + "," + binding.getPortType().getQName().getLocalPart();
                        }
                    }
                    catch (Exception e) {
                        throw new SICAToOpenSPCoopUtilitiesException("Comprensione servizio spcoop da wsdl implementativo fruitore non riuscita: " + e.getMessage(), e);
                    }
                }
            }
        }
        if (accServizioOpenspcoop.getServizioCorrelato()) {
            if (nomeServizioSPCoopCorrelato == null) {
                throw new SICAToOpenSPCoopUtilitiesException("Comprensione nome del Servizio SPCoop correlato non riuscita tramite la lettura dei wsdl implementativi");
            }
            accServizioOpenspcoop.setTipo("SPC");
            accServizioOpenspcoop.setNome(nomeServizioSPCoopCorrelato);
            accServizioOpenspcoop.setPortType(nomeServizioSPCoopCorrelato);
        } else {
            if (nomeServizioSPCoop == null) {
                throw new SICAToOpenSPCoopUtilitiesException("Comprensione nome del Servizio SPCoop non riuscita tramite la lettura dei wsdl implementativi");
            }
            accServizioOpenspcoop.setTipo("SPC");
            accServizioOpenspcoop.setNome(nomeServizioSPCoop);
            accServizioOpenspcoop.setPortType(nomeServizioSPCoop);
        }
        accServizioOpenspcoop.setTipoAdesione(parteSpecifica.getAdesione());
        IDSoggetto soggettoErogatore = sicaToOpenspcoopContext.getIDSoggetto(SICAtoOpenSPCoopUtilities.removeURI_IDSoggettoSica(parteSpecifica.getErogatore()));
        if (soggettoErogatore == null) {
            soggettoErogatore = SICAtoOpenSPCoopUtilities.idSoggetto_sicaToOpenspcoop(parteSpecifica.getErogatore());
        }
        accServizioOpenspcoop.setTipoSoggettoErogatore(soggettoErogatore.getTipo());
        accServizioOpenspcoop.setNomeSoggettoErogatore(soggettoErogatore.getNome());
        if (manifest.getAllegati() != null) {
            for (int i = 0; i < manifest.getAllegati().sizeGenericoDocumentoList(); ++i) {
                Documento docOpenspcoop = new Documento();
                String fileName = manifest.getAllegati().getGenericoDocumento(i);
                docOpenspcoop.setFile(fileName);
                docOpenspcoop.setRuolo(RuoliDocumento.allegato.toString());
                it.gov.spcoop.sica.dao.Documento docSICA = null;
                for (int j = 0; j < accordoServizioSICA.sizeAllegati(); ++j) {
                    if (!fileName.equals(accordoServizioSICA.getAllegato(j).getNome())) continue;
                    docSICA = accordoServizioSICA.getAllegato(j);
                }
                if (docSICA == null) {
                    throw new SICAToOpenSPCoopUtilitiesException("Allegato con nome[" + fileName + "] non trovato");
                }
                docOpenspcoop.setTipo(docSICA.getTipo());
                docOpenspcoop.setByteContenuto(docSICA.getContenuto());
                accServizioOpenspcoop.addAllegato(docOpenspcoop);
            }
        }
        if (manifest.getSpecificaSemiformale() != null) {
            for (int i = 0; i < manifest.getSpecificaSemiformale().sizeDocumentoSemiformaleList(); ++i) {
                DocumentoSemiformale specificaSemiformale = manifest.getSpecificaSemiformale().getDocumentoSemiformale(i);
                Documento docOpenspcoop = new Documento();
                String fileName = specificaSemiformale.getBase();
                it.gov.spcoop.sica.dao.Documento docSICA = null;
                for (int j = 0; j < accordoServizioSICA.sizeSpecificheSemiformali(); ++j) {
                    if (!fileName.equals(accordoServizioSICA.getSpecificaSemiformale(j).getNome())) continue;
                    docSICA = accordoServizioSICA.getSpecificaSemiformale(j);
                }
                if (docSICA == null) {
                    throw new SICAToOpenSPCoopUtilitiesException("SpecificaSemiformale con nome[" + fileName + "] non trovato");
                }
                docOpenspcoop.setFile(fileName);
                docOpenspcoop.setRuolo(RuoliDocumento.specificaSemiformale.toString());
                docOpenspcoop.setTipo(docSICA.getTipo());
                docOpenspcoop.setByteContenuto(docSICA.getContenuto());
                accServizioOpenspcoop.addSpecificaSemiformale(docOpenspcoop);
            }
        }
        if ((specificaSicurezza = parteSpecifica.getSpecificaSicurezza()) != null) {
            for (int i = 0; i < specificaSicurezza.sizeDocumentoSicurezzaList(); ++i) {
                DocumentoSicurezza docSicurezzaSICA = specificaSicurezza.getDocumentoSicurezza(i);
                Documento docOpenspcoop = new Documento();
                String fileName = docSicurezzaSICA.getBase();
                it.gov.spcoop.sica.dao.Documento docSICA = null;
                for (int j = 0; j < accordoServizioSICA.sizeSpecificheSicurezza(); ++j) {
                    if (!fileName.equals(accordoServizioSICA.getSpecificaSicurezza(j).getNome())) continue;
                    docSICA = accordoServizioSICA.getSpecificaSicurezza(j);
                }
                if (docSICA == null) {
                    throw new SICAToOpenSPCoopUtilitiesException("SpecificaSicurezza con nome[" + fileName + "] non trovato");
                }
                docOpenspcoop.setFile(fileName);
                docOpenspcoop.setRuolo(RuoliDocumento.specificaSicurezza.toString());
                docOpenspcoop.setTipo(docSICA.getTipo());
                docOpenspcoop.setByteContenuto(docSICA.getContenuto());
                accServizioOpenspcoop.addSpecificaSicurezza(docOpenspcoop);
            }
        }
        if ((specificaLivelliServizio = parteSpecifica.getSpecificaLivelliServizio()) != null) {
            for (int i = 0; i < specificaLivelliServizio.sizeDocumentoLivelloServizioList(); ++i) {
                DocumentoLivelloServizio docLS = specificaLivelliServizio.getDocumentoLivelloServizio(i);
                Documento docOpenspcoop = new Documento();
                String fileName = docLS.getBase();
                it.gov.spcoop.sica.dao.Documento docSICA = null;
                for (int j = 0; j < accordoServizioSICA.sizeSpecificheLivelliServizio(); ++j) {
                    if (!fileName.equals(accordoServizioSICA.getSpecificaLivelloServizio(j).getNome())) continue;
                    docSICA = accordoServizioSICA.getSpecificaLivelloServizio(j);
                }
                if (docSICA == null) {
                    throw new SICAToOpenSPCoopUtilitiesException("SpecificaLivelloServizio con nome[" + fileName + "] non trovato");
                }
                docOpenspcoop.setFile(fileName);
                docOpenspcoop.setRuolo(RuoliDocumento.specificaLivelloServizio.toString());
                docOpenspcoop.setTipo(docSICA.getTipo());
                docOpenspcoop.setByteContenuto(docSICA.getContenuto());
                accServizioOpenspcoop.addSpecificaLivelloServizio(docOpenspcoop);
            }
        }
        String url = null;
        if (accServizioOpenspcoop.getByteWsdlImplementativoErogatore() != null) {
            try {
                url = SICAtoOpenSPCoopUtilities.readConnettoreFromWsdlImplementativo(accServizioOpenspcoop.getByteWsdlImplementativoErogatore());
            }
            catch (Exception e) {
                Logger.getLogger((String)"openspcoop.core").info((Object)("Lettura WsdlLocation non riuscita (ImplementativoErogatore): " + e.getMessage()), (Throwable)e);
            }
        } else if (accServizioOpenspcoop.getByteWsdlImplementativoFruitore() != null) {
            try {
                url = SICAtoOpenSPCoopUtilities.readConnettoreFromWsdlImplementativo(accServizioOpenspcoop.getByteWsdlImplementativoFruitore());
            }
            catch (Exception e) {
                Logger.getLogger((String)"openspcoop.core").info((Object)("Lettura WsdlLocation non riuscita (ImplementativoFruitore): " + e.getMessage()), (Throwable)e);
            }
        }
        String nomeConn = "CNT_" + soggettoErogatore.getTipo() + "/" + soggettoErogatore.getNome() + "_" + accServizioOpenspcoop.getTipo() + "/" + accServizioOpenspcoop.getNome();
        Connettore connettore = new Connettore();
        connettore.setNome(nomeConn);
        if (url != null) {
            connettore.setTipo("http");
            ConnettoreProperty prop = new ConnettoreProperty();
            prop.setNome("location");
            prop.setValore(url);
            connettore.addProperty(prop);
        } else {
            connettore.setTipo("disabilitato");
        }
        accServizioOpenspcoop.setConnettore(connettore);
        if (manifest.getFirmato()) {
            accServizioOpenspcoop.setByteFirma(accordoServizioSICA.getFirma().getBytes());
        }
        if (verificaCorreggiLocationWSDL) {
            try {
                RegistroOpenSPCoopUtilities registroOpenSPCoopUtilities = new RegistroOpenSPCoopUtilities(Logger.getLogger((String)"openspcoop.core"));
                registroOpenSPCoopUtilities.updateLocation(accServizioOpenspcoop, false, prettyDocument);
            }
            catch (Exception e) {
                throw new SICAToOpenSPCoopUtilitiesException("RegistroOpenSPCoopUtilities.setImportLocation error: " + e.getMessage(), e);
            }
        }
        return accServizioOpenspcoop;
    }

    public static AccordoServizioParteSpecifica accordoServizioParteSpecifica_openspcoopToSica(ServizioSpcoop accordoServizioOpenspcoop, boolean implementazioneAccordoServizioComposto, AccordoServizio parteComuneDaIncludereWSDLImplementativo, SICAtoOpenSPCoopContext sicaToOpenspcoopContext) throws SICAToOpenSPCoopUtilitiesException {
        it.gov.spcoop.sica.dao.Documento docSICA;
        Documento docOpenspcoop;
        DefinitionWrapper wsdlOpenSPCoop;
        Definition wsdl;
        RegistroOpenSPCoopUtilities registroOpenSPCoopUtilities;
        boolean verificaCorreggiLocationWSDL = sicaToOpenspcoopContext.isWSDL_XSD_allineaImportInclude();
        boolean prettyDocument = sicaToOpenspcoopContext.isWSDL_XSD_prettyDocuments();
        boolean includiInfoRegistroGenerale = sicaToOpenspcoopContext.isSICAClient_includiInfoRegistroGenerale();
        boolean wsdlEmptySeNonDefiniti = sicaToOpenspcoopContext.isWSDL_XSD_accordiParteSpecifica_wsdlEmpty();
        boolean openspcoopToSicaEliminazioneImportParteComune = sicaToOpenspcoopContext.isWSDL_XSD_accordiParteSpecifica_openspcoopToSica_eliminazioneImportParteComune();
        if (verificaCorreggiLocationWSDL) {
            try {
                RegistroOpenSPCoopUtilities registroOpenSPCoopUtilities2 = new RegistroOpenSPCoopUtilities(Logger.getLogger((String)"openspcoop.core"));
                registroOpenSPCoopUtilities2.updateLocation(accordoServizioOpenspcoop, true, prettyDocument);
            }
            catch (Exception e) {
                throw new SICAToOpenSPCoopUtilitiesException("RegistroOpenSPCoopUtilities.setImportLocation error: " + e.getMessage(), e);
            }
        }
        AccordoServizioParteSpecifica accServParteSpecificaSICA = new AccordoServizioParteSpecifica();
        it.gov.spcoop.sica.manifest.AccordoServizio manifest = new it.gov.spcoop.sica.manifest.AccordoServizio();
        manifest.setDescrizione(accordoServizioOpenspcoop.getDescrizione());
        manifest.setNome(accordoServizioOpenspcoop.getAccordoParteSpecifica().getNome());
        manifest.setDataCreazione(accordoServizioOpenspcoop.getOraRegistrazione());
        it.gov.spcoop.sica.manifest.AccordoServizioParteSpecifica parteSpecifica = new it.gov.spcoop.sica.manifest.AccordoServizioParteSpecifica();
        if (includiInfoRegistroGenerale) {
            manifest.setVersione(accordoServizioOpenspcoop.getAccordoParteSpecifica().getVersione());
            manifest.setDataPubblicazione(accordoServizioOpenspcoop.getDataPubblicazione());
            IDSoggetto soggettoErogatore = new IDSoggetto(accordoServizioOpenspcoop.getTipoSoggettoErogatore(), accordoServizioOpenspcoop.getNomeSoggettoErogatore());
            String uriErogatore = sicaToOpenspcoopContext.getCodiceIPA(soggettoErogatore);
            uriErogatore = uriErogatore == null ? SICAtoOpenSPCoopUtilities.idSoggetto_openspcoopToSica(soggettoErogatore) : SICAtoOpenSPCoopUtilities.appendURI_IDSoggettoSica(uriErogatore);
            parteSpecifica.setErogatore(uriErogatore);
            if (accordoServizioOpenspcoop.getByteFirma() != null) {
                manifest.setFirmato(true);
            }
        }
        try {
            if (implementazioneAccordoServizioComposto) {
                parteSpecifica.setRiferimentoParteComune(SICAtoOpenSPCoopUtilities.idAccordoServizioComposto_openspcoopToSica(IDAccordo.getIDAccordoFromUri(accordoServizioOpenspcoop.getAccordoServizio()), sicaToOpenspcoopContext));
            } else {
                parteSpecifica.setRiferimentoParteComune(SICAtoOpenSPCoopUtilities.idAccordoServizioParteComune_openspcoopToSica(IDAccordo.getIDAccordoFromUri(accordoServizioOpenspcoop.getAccordoServizio()), sicaToOpenspcoopContext));
            }
        }
        catch (Exception e) {
            throw new SICAToOpenSPCoopUtilitiesException("Trasformazione riferimento parte comune [" + accordoServizioOpenspcoop.getAccordoServizio() + "] non riuscita: " + e.getMessage(), e);
        }
        String urlConnettore = null;
        if (accordoServizioOpenspcoop.getConnettore() != null && ("http".equals(accordoServizioOpenspcoop.getConnettore().getTipo()) || "https".equals(accordoServizioOpenspcoop.getConnettore().getTipo())) && accordoServizioOpenspcoop.getConnettore().sizePropertyList() > 0) {
            for (int i = 0; i < accordoServizioOpenspcoop.getConnettore().sizePropertyList(); ++i) {
                if (!"location".equals(accordoServizioOpenspcoop.getConnettore().getProperty(i).getNome())) continue;
                urlConnettore = accordoServizioOpenspcoop.getConnettore().getProperty(i).getValore();
            }
        }
        SpecificaPortiAccesso specificaPortiAccesso = null;
        if (accordoServizioOpenspcoop.getByteWsdlImplementativoErogatore() != null || accordoServizioOpenspcoop.getByteWsdlImplementativoFruitore() != null) {
            specificaPortiAccesso = new SpecificaPortiAccesso();
        }
        if (wsdlEmptySeNonDefiniti || accordoServizioOpenspcoop.getByteWsdlImplementativoErogatore() != null) {
            DocumentoInterfaccia docInterfacciaErogatore = new DocumentoInterfaccia();
            docInterfacciaErogatore.setBase("PortiAccessoErogatore.wsdl");
            docInterfacciaErogatore.setTipo(TipiDocumentoInterfaccia.WSDL.toString());
            specificaPortiAccesso.setPortiAccessoErogatore(docInterfacciaErogatore);
            it.gov.spcoop.sica.dao.Documento docErogatore = new it.gov.spcoop.sica.dao.Documento();
            docErogatore.setTipo(TipiDocumentoInterfaccia.WSDL.toString());
            docErogatore.setNome("PortiAccessoErogatore.wsdl");
            byte[] wsdlImplementativoErogatore = null;
            if (accordoServizioOpenspcoop.getByteWsdlImplementativoErogatore() != null) {
                wsdlImplementativoErogatore = accordoServizioOpenspcoop.getByteWsdlImplementativoErogatore();
                if (parteComuneDaIncludereWSDLImplementativo != null) {
                    try {
                        registroOpenSPCoopUtilities = new RegistroOpenSPCoopUtilities(Logger.getLogger((String)"openspcoop.core"));
                        wsdl = registroOpenSPCoopUtilities.buildWsdlFromObjects(parteComuneDaIncludereWSDLImplementativo, wsdlImplementativoErogatore, true);
                        wsdlOpenSPCoop = new DefinitionWrapper(wsdl);
                        wsdlImplementativoErogatore = wsdlOpenSPCoop.toByteArray();
                    }
                    catch (Exception e) {
                        Logger.getLogger((String)"openspcoop.core").info((Object)("Inserimento parte comune nel wsdl non riuscito (ImplementativoErogatore): " + e.getMessage()), (Throwable)e);
                    }
                } else if (openspcoopToSicaEliminazioneImportParteComune) {
                    try {
                        registroOpenSPCoopUtilities = new RegistroOpenSPCoopUtilities(Logger.getLogger((String)"openspcoop.core"));
                        wsdlImplementativoErogatore = registroOpenSPCoopUtilities.eliminaImportASParteComune(wsdlImplementativoErogatore);
                    }
                    catch (Exception e) {
                        throw new SICAToOpenSPCoopUtilitiesException("RegistroOpenSPCoopUtilities.eliminaImportASParteComune error: " + e.getMessage(), e);
                    }
                }
                if (urlConnettore != null) {
                    try {
                        wsdlImplementativoErogatore = SICAtoOpenSPCoopUtilities.saveConnettoreIntoWsdlImplementativo(wsdlImplementativoErogatore, urlConnettore);
                    }
                    catch (Exception e) {
                        Logger.getLogger((String)"openspcoop.core").info((Object)("Impostazione WsdlLocation non riuscita (ImplementativoErogatore): " + e.getMessage()), (Throwable)e);
                    }
                }
            } else {
                wsdlImplementativoErogatore = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wsdl:definitions xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\"/>".getBytes();
            }
            docErogatore.setContenuto(wsdlImplementativoErogatore);
            accServParteSpecificaSICA.setPortiAccessoErogatore(docErogatore);
        }
        if (wsdlEmptySeNonDefiniti || accordoServizioOpenspcoop.getByteWsdlImplementativoFruitore() != null) {
            DocumentoInterfaccia docInterfacciaFruitore = new DocumentoInterfaccia();
            docInterfacciaFruitore.setBase("PortiAccessoFruitore.wsdl");
            docInterfacciaFruitore.setTipo(TipiDocumentoInterfaccia.WSDL.toString());
            specificaPortiAccesso.setPortiAccessoFruitore(docInterfacciaFruitore);
            it.gov.spcoop.sica.dao.Documento docFruitore = new it.gov.spcoop.sica.dao.Documento();
            docFruitore.setTipo(TipiDocumentoInterfaccia.WSDL.toString());
            docFruitore.setNome("PortiAccessoFruitore.wsdl");
            byte[] wsdlImplementativoFruitore = null;
            if (accordoServizioOpenspcoop.getByteWsdlImplementativoFruitore() != null) {
                wsdlImplementativoFruitore = accordoServizioOpenspcoop.getByteWsdlImplementativoFruitore();
                if (parteComuneDaIncludereWSDLImplementativo != null) {
                    try {
                        registroOpenSPCoopUtilities = new RegistroOpenSPCoopUtilities(Logger.getLogger((String)"openspcoop.core"));
                        wsdl = registroOpenSPCoopUtilities.buildWsdlFromObjects(parteComuneDaIncludereWSDLImplementativo, wsdlImplementativoFruitore, false);
                        wsdlOpenSPCoop = new DefinitionWrapper(wsdl);
                        wsdlImplementativoFruitore = wsdlOpenSPCoop.toByteArray();
                    }
                    catch (Exception e) {
                        Logger.getLogger((String)"openspcoop.core").info((Object)("Inserimento parte comune nel wsdl non riuscito (ImplementativoFruitore): " + e.getMessage()), (Throwable)e);
                    }
                } else if (openspcoopToSicaEliminazioneImportParteComune) {
                    try {
                        registroOpenSPCoopUtilities = new RegistroOpenSPCoopUtilities(Logger.getLogger((String)"openspcoop.core"));
                        wsdlImplementativoFruitore = registroOpenSPCoopUtilities.eliminaImportASParteComune(wsdlImplementativoFruitore);
                    }
                    catch (Exception e) {
                        throw new SICAToOpenSPCoopUtilitiesException("RegistroOpenSPCoopUtilities.eliminaImportASParteComune error: " + e.getMessage(), e);
                    }
                }
                if (urlConnettore != null) {
                    try {
                        wsdlImplementativoFruitore = SICAtoOpenSPCoopUtilities.saveConnettoreIntoWsdlImplementativo(wsdlImplementativoFruitore, urlConnettore);
                    }
                    catch (Exception e) {
                        Logger.getLogger((String)"openspcoop.core").info((Object)("Impostazione WsdlLocation non riuscita (ImplementativoFruitore): " + e.getMessage()), (Throwable)e);
                    }
                }
            } else {
                wsdlImplementativoFruitore = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wsdl:definitions xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\"/>".getBytes();
            }
            docFruitore.setContenuto(wsdlImplementativoFruitore);
            accServParteSpecificaSICA.setPortiAccessoFruitore(docFruitore);
        }
        if (specificaPortiAccesso != null) {
            parteSpecifica.setSpecificaPortiAccesso(specificaPortiAccesso);
        }
        parteSpecifica.setAdesione(accordoServizioOpenspcoop.getTipoAdesione());
        if (accordoServizioOpenspcoop.sizeAllegatoList() > 0) {
            ElencoAllegati allegati = new ElencoAllegati();
            for (int i = 0; i < accordoServizioOpenspcoop.sizeAllegatoList(); ++i) {
                docOpenspcoop = accordoServizioOpenspcoop.getAllegato(i);
                allegati.addGenericoDocumento(docOpenspcoop.getFile());
                it.gov.spcoop.sica.dao.Documento docSICA2 = new it.gov.spcoop.sica.dao.Documento();
                docSICA2.setTipo(docOpenspcoop.getTipo());
                docSICA2.setNome(docOpenspcoop.getFile());
                if (docOpenspcoop.getByteContenuto() == null) {
                    throw new SICAToOpenSPCoopUtilitiesException("Byte dell'allegato " + docOpenspcoop.getFile() + " di tipo " + docOpenspcoop.getTipo() + " non forniti");
                }
                docSICA2.setContenuto(docOpenspcoop.getByteContenuto());
                accServParteSpecificaSICA.addAllegato(docSICA2);
            }
            manifest.setAllegati(allegati);
        }
        if (accordoServizioOpenspcoop.sizeSpecificaSemiformaleList() > 0) {
            SpecificaSemiformale specificaSemiformale = new SpecificaSemiformale();
            for (int i = 0; i < accordoServizioOpenspcoop.sizeSpecificaSemiformaleList(); ++i) {
                docOpenspcoop = accordoServizioOpenspcoop.getSpecificaSemiformale(i);
                DocumentoSemiformale docSemiformale = new DocumentoSemiformale();
                docSemiformale.setTipo(docOpenspcoop.getTipo());
                docSemiformale.setBase(docOpenspcoop.getFile());
                specificaSemiformale.addDocumentoSemiformale(docSemiformale);
                docSICA = new it.gov.spcoop.sica.dao.Documento();
                docSICA.setTipo(docOpenspcoop.getTipo());
                docSICA.setNome(docOpenspcoop.getFile());
                if (docOpenspcoop.getByteContenuto() == null) {
                    throw new SICAToOpenSPCoopUtilitiesException("Byte della specifica semiformale " + docOpenspcoop.getFile() + " di tipo " + docOpenspcoop.getTipo() + " non forniti");
                }
                docSICA.setContenuto(docOpenspcoop.getByteContenuto());
                accServParteSpecificaSICA.addSpecificaSemiformale(docSICA);
            }
            manifest.setSpecificaSemiformale(specificaSemiformale);
        }
        SpecificaSicurezza specificaSicurezza = null;
        for (int i = 0; i < accordoServizioOpenspcoop.sizeSpecificaSicurezzaList(); ++i) {
            docOpenspcoop = accordoServizioOpenspcoop.getSpecificaSicurezza(i);
            if (specificaSicurezza == null) {
                specificaSicurezza = new SpecificaSicurezza();
            }
            DocumentoSicurezza docSicurezza = new DocumentoSicurezza();
            docSicurezza.setTipo(docOpenspcoop.getTipo());
            docSicurezza.setBase(docOpenspcoop.getFile());
            specificaSicurezza.addDocumentoSicurezza(docSicurezza);
            docSICA = new it.gov.spcoop.sica.dao.Documento();
            docSICA.setTipo(docOpenspcoop.getTipo());
            docSICA.setNome(docOpenspcoop.getFile());
            if (docOpenspcoop.getByteContenuto() == null) {
                throw new SICAToOpenSPCoopUtilitiesException("Byte della specifica di sicurezza " + docOpenspcoop.getFile() + " di tipo " + docOpenspcoop.getTipo() + " non forniti");
            }
            docSICA.setContenuto(docOpenspcoop.getByteContenuto());
            accServParteSpecificaSICA.addSpecificaSicurezza(docSICA);
        }
        if (specificaSicurezza != null) {
            parteSpecifica.setSpecificaSicurezza(specificaSicurezza);
        }
        SpecificaLivelliServizio specificaLivelliServizio = null;
        for (int i = 0; i < accordoServizioOpenspcoop.sizeSpecificaLivelloServizioList(); ++i) {
            Documento docOpenspcoop2 = accordoServizioOpenspcoop.getSpecificaLivelloServizio(i);
            if (specificaLivelliServizio == null) {
                specificaLivelliServizio = new SpecificaLivelliServizio();
            }
            DocumentoLivelloServizio docLivelliServizio = new DocumentoLivelloServizio();
            docLivelliServizio.setTipo(docOpenspcoop2.getTipo());
            docLivelliServizio.setBase(docOpenspcoop2.getFile());
            specificaLivelliServizio.addDocumentoLivelloServizio(docLivelliServizio);
            it.gov.spcoop.sica.dao.Documento docSICA3 = new it.gov.spcoop.sica.dao.Documento();
            docSICA3.setTipo(docOpenspcoop2.getTipo());
            docSICA3.setNome(docOpenspcoop2.getFile());
            if (docOpenspcoop2.getByteContenuto() == null) {
                throw new SICAToOpenSPCoopUtilitiesException("Byte della specifica del livello di servizio " + docOpenspcoop2.getFile() + " di tipo " + docOpenspcoop2.getTipo() + " non forniti");
            }
            docSICA3.setContenuto(docOpenspcoop2.getByteContenuto());
            accServParteSpecificaSICA.addSpecificaLivelloServizio(docSICA3);
        }
        if (specificaLivelliServizio != null) {
            parteSpecifica.setSpecificaLivelliServizio(specificaLivelliServizio);
        }
        if (includiInfoRegistroGenerale && accordoServizioOpenspcoop.getByteFirma() != null) {
            Firma firma = new Firma();
            accServParteSpecificaSICA.setFirma(firma);
        }
        manifest.setParteSpecifica(parteSpecifica);
        accServParteSpecificaSICA.setManifesto(manifest);
        return accServParteSpecificaSICA;
    }

    public static AccordoServizio accordoServizioComposto_sicaToOpenspcoop(AccordoServizioComposto accordoServizioSICA, SICAtoOpenSPCoopContext sicaToOpenspcoopContext) throws SICAToOpenSPCoopUtilitiesException {
        SpecificaCoordinamento specificaCoordinamento;
        boolean verificaCorreggiLocationWSDL = sicaToOpenspcoopContext.isWSDL_XSD_allineaImportInclude();
        boolean prettyDocument = sicaToOpenspcoopContext.isWSDL_XSD_prettyDocuments();
        boolean documentoSpecificaEGOV_asClientSICADisabled_childUnquilified = sicaToOpenspcoopContext.isInformazioniEGov_wscpDisabled_childUnqualified();
        boolean documentoSpecificaEGOV_asClientSICAEnabled_childUnquilified = sicaToOpenspcoopContext.isInformazioniEGov_wscpEnabled_childUnqualified();
        AccordoServizio accServizioOpenspcoop = new AccordoServizio();
        ServizioComposto manifest = accordoServizioSICA.getManifesto();
        accServizioOpenspcoop.setDescrizione(manifest.getDescrizione());
        accServizioOpenspcoop.setNome(manifest.getNome());
        accServizioOpenspcoop.setVersione(manifest.getVersione());
        accServizioOpenspcoop.setOraRegistrazione(manifest.getDataCreazione());
        accServizioOpenspcoop.setDataPubblicazione(manifest.getDataPubblicazione());
        accServizioOpenspcoop.setProfiloCollaborazione("oneway");
        SpecificaInterfaccia specificaInterfaccia = manifest.getSpecificaInterfaccia();
        if (accordoServizioSICA.getInterfacciaConcettuale() != null || accordoServizioSICA.getInterfacciaLogicaLatoErogatore() != null || accordoServizioSICA.getInterfacciaLogicaLatoFruitore() != null) {
            if (specificaInterfaccia.getInterfacciaConcettuale() != null && accordoServizioSICA.getInterfacciaConcettuale() != null && !SICAtoOpenSPCoopUtilities.isWsdlEmpty(accordoServizioSICA.getInterfacciaConcettuale().getContenuto())) {
                accServizioOpenspcoop.setByteWsdlConcettuale(accordoServizioSICA.getInterfacciaConcettuale().getContenuto());
            }
            if (specificaInterfaccia.getInterfacciaLogicaLatoErogatore() != null && accordoServizioSICA.getInterfacciaLogicaLatoErogatore() != null && !SICAtoOpenSPCoopUtilities.isWsdlEmpty(accordoServizioSICA.getInterfacciaLogicaLatoErogatore().getContenuto())) {
                accServizioOpenspcoop.setByteWsdlLogicoErogatore(accordoServizioSICA.getInterfacciaLogicaLatoErogatore().getContenuto());
            }
            if (specificaInterfaccia.getInterfacciaLogicaLatoFruitore() != null && accordoServizioSICA.getInterfacciaLogicaLatoFruitore() != null && !SICAtoOpenSPCoopUtilities.isWsdlEmpty(accordoServizioSICA.getInterfacciaLogicaLatoFruitore().getContenuto())) {
                accServizioOpenspcoop.setByteWsdlLogicoFruitore(accordoServizioSICA.getInterfacciaLogicaLatoFruitore().getContenuto());
            }
        }
        SpecificaConversazione specificaConversazione = manifest.getSpecificaConversazione();
        if (accordoServizioSICA.getConversazioneConcettuale() != null || accordoServizioSICA.getConversazioneLogicaErogatore() != null || accordoServizioSICA.getConversazioneLogicaFruitore() != null) {
            if (specificaConversazione.getConversazioneConcettuale() != null && accordoServizioSICA.getConversazioneConcettuale() != null) {
                accServizioOpenspcoop.setByteWsblConcettuale(accordoServizioSICA.getConversazioneConcettuale().getContenuto());
            }
            if (specificaConversazione.getConversazioneLogicaLatoErogatore() != null && accordoServizioSICA.getConversazioneLogicaErogatore() != null) {
                accServizioOpenspcoop.setByteWsblLogicoErogatore(accordoServizioSICA.getConversazioneLogicaErogatore().getContenuto());
            }
            if (specificaConversazione.getConversazioneLogicaLatoFruitore() != null && accordoServizioSICA.getConversazioneLogicaFruitore() != null) {
                accServizioOpenspcoop.setByteWsblLogicoFruitore(accordoServizioSICA.getConversazioneLogicaFruitore().getContenuto());
            }
        }
        AccordoServizioSoggettoReferente soggettoReferente = new AccordoServizioSoggettoReferente();
        IDSoggetto soggettoPubblicatore = sicaToOpenspcoopContext.getIDSoggetto(SICAtoOpenSPCoopUtilities.removeURI_IDSoggettoSica(manifest.getPubblicatore()));
        if (soggettoPubblicatore == null) {
            soggettoPubblicatore = SICAtoOpenSPCoopUtilities.idSoggetto_sicaToOpenspcoop(manifest.getPubblicatore());
        }
        soggettoReferente.setNome(soggettoPubblicatore.getNome());
        soggettoReferente.setTipo(soggettoPubblicatore.getTipo());
        accServizioOpenspcoop.setSoggettoReferente(soggettoReferente);
        AccordoServizioServizioComposto servizioComposto = new AccordoServizioServizioComposto();
        IDAccordoCooperazione idAccordo = SICAtoOpenSPCoopUtilities.idAccordoCooperazione_sicaToOpenspcoop(manifest.getRiferimentoAccordoCooperazione());
        try {
            servizioComposto.setNomeAccordoCooperazione(IDAccordoCooperazione.getUriFromIDAccordo(idAccordo));
        }
        catch (Exception e) {
            throw new SICAToOpenSPCoopUtilitiesException("Trasformazione IDAccordo di cooperazione [" + manifest.getRiferimentoAccordoCooperazione() + "] non riuscito: " + e.getMessage(), e);
        }
        if (manifest.getServiziComponenti() != null) {
            for (int i = 0; i < manifest.getServiziComponenti().sizeServizioComponenteList(); ++i) {
                String servComponente = manifest.getServiziComponenti().getServizioComponente(i);
                IDServizio idServizioComponente = sicaToOpenspcoopContext.getIDServizio(servComponente);
                if (idServizioComponente == null) {
                    throw new SICAToOpenSPCoopUtilitiesException("Trasformazione uriAPS[" + servComponente + "] in IDServizio SPCoop non riuscita");
                }
                AccordoServizioServizioCompostoServizioComponente servComponenteOpenspcoop = new AccordoServizioServizioCompostoServizioComponente();
                try {
                    servComponenteOpenspcoop.setTipo(idServizioComponente.getTipoServizio());
                    servComponenteOpenspcoop.setNome(idServizioComponente.getServizio());
                    servComponenteOpenspcoop.setTipoSoggetto(idServizioComponente.getSoggettoErogatore().getTipo());
                    servComponenteOpenspcoop.setNomeSoggetto(idServizioComponente.getSoggettoErogatore().getNome());
                }
                catch (Exception e) {
                    throw new SICAToOpenSPCoopUtilitiesException("Trasformazione IDAccordo di servizio composto [" + servComponente + "] non riuscito: " + e.getMessage(), e);
                }
                servizioComposto.addServizioComponente(servComponenteOpenspcoop);
            }
        }
        boolean findDocumentoSpecificaEGOV = false;
        String tipoDocumentoSpecificaEGovTrovato = null;
        String fileNameSpecificaEGovTrovata = null;
        if (manifest.getAllegati() != null) {
            for (int i = 0; i < manifest.getAllegati().sizeGenericoDocumentoList(); ++i) {
                Documento docOpenspcoop = new Documento();
                String fileName = manifest.getAllegati().getGenericoDocumento(i);
                docOpenspcoop.setFile(fileName);
                docOpenspcoop.setRuolo(RuoliDocumento.allegato.toString());
                it.gov.spcoop.sica.dao.Documento docSICA = null;
                for (int j = 0; j < accordoServizioSICA.sizeAllegati(); ++j) {
                    if (!fileName.equals(accordoServizioSICA.getAllegato(j).getNome())) continue;
                    docSICA = accordoServizioSICA.getAllegato(j);
                }
                if (docSICA == null) {
                    throw new SICAToOpenSPCoopUtilitiesException("Allegato con nome[" + fileName + "] non trovato");
                }
                if ("InterfacciaDefinitoria.xsd".equals(fileName)) {
                    accServizioOpenspcoop.setByteWsdlDefinitorio(docSICA.getContenuto());
                    continue;
                }
                boolean specificaEGovAsClientSICA = it.gov.spcoop.sica.wscp.driver.XMLUtils.isProfiloCollaborazioneEGOV(docSICA.getContenuto());
                boolean specificaEGovAsDocumentoCNIPA = it.cnipa.collprofiles.driver.XMLUtils.isProfiloCollaborazioneEGOV(docSICA.getContenuto());
                if (findDocumentoSpecificaEGOV) {
                    String fileNameTmp = "allegati" + File.separatorChar + fileName;
                    if (specificaEGovAsClientSICA) {
                        throw new SICAToOpenSPCoopUtilitiesException("Nel package sono presenti piu' di una specifica delle informazioni egov. E' stata gia' processata una specifica di tipo " + tipoDocumentoSpecificaEGovTrovato + " (" + fileNameSpecificaEGovTrovata + ") e adesso e' stato riscontrato una specifica di tipo " + "http://spcoop.gov.it/sica/wscp" + " (" + fileNameTmp + ")");
                    }
                    if (specificaEGovAsDocumentoCNIPA) {
                        throw new SICAToOpenSPCoopUtilitiesException("Nel package sono presenti piu' di una specifica delle informazioni egov. E' stata gia' processata una specifica di tipo " + tipoDocumentoSpecificaEGovTrovato + " (" + fileNameSpecificaEGovTrovata + ") e adesso e' stato riscontrato una specifica di tipo " + "http://www.cnipa.it/collProfiles" + " (" + fileNameTmp + ")");
                    }
                } else {
                    if (specificaEGovAsClientSICA && specificaEGovAsDocumentoCNIPA) {
                        throw new SICAToOpenSPCoopUtilitiesException("Trovata specifica delle informazioni egov sia di tipo http://spcoop.gov.it/sica/wscp che di tipo http://www.cnipa.it/collProfiles ??");
                    }
                    if (specificaEGovAsClientSICA || specificaEGovAsDocumentoCNIPA) {
                        findDocumentoSpecificaEGOV = true;
                        fileNameSpecificaEGovTrovata = "allegati" + File.separatorChar + fileName;
                    }
                }
                if (specificaEGovAsClientSICA) {
                    try {
                        it.gov.spcoop.sica.wscp.driver.XMLUtils.mapProfiloCollaborazioneEGOVIntoAS(docSICA.getContenuto(), accServizioOpenspcoop, documentoSpecificaEGOV_asClientSICAEnabled_childUnquilified);
                        tipoDocumentoSpecificaEGovTrovato = "http://spcoop.gov.it/sica/wscp";
                        continue;
                    }
                    catch (Exception e) {
                        throw new SICAToOpenSPCoopUtilitiesException("Errore durante la verifica dell'esistenza del documento di tipo 'ProfiloCollaborazioneEGOV' per il file [" + fileName + "] : " + e.getMessage(), e);
                    }
                }
                if (specificaEGovAsDocumentoCNIPA) {
                    try {
                        it.cnipa.collprofiles.driver.XMLUtils.mapProfiloCollaborazioneEGOVIntoAS(docSICA.getContenuto(), accServizioOpenspcoop, documentoSpecificaEGOV_asClientSICADisabled_childUnquilified);
                        tipoDocumentoSpecificaEGovTrovato = "http://www.cnipa.it/collProfiles";
                        continue;
                    }
                    catch (Exception e) {
                        throw new SICAToOpenSPCoopUtilitiesException("Errore durante la verifica dell'esistenza del documento di tipo 'ProfiloCollaborazioneEGOV' per il file [" + fileName + "] : " + e.getMessage(), e);
                    }
                }
                docOpenspcoop.setTipo(docSICA.getTipo());
                docOpenspcoop.setByteContenuto(docSICA.getContenuto());
                accServizioOpenspcoop.addAllegato(docOpenspcoop);
            }
        }
        if (manifest.getSpecificaSemiformale() != null) {
            for (int i = 0; i < manifest.getSpecificaSemiformale().sizeDocumentoSemiformaleList(); ++i) {
                DocumentoSemiformale specificaSemiformale = manifest.getSpecificaSemiformale().getDocumentoSemiformale(i);
                Documento docOpenspcoop = new Documento();
                String fileName = specificaSemiformale.getBase();
                it.gov.spcoop.sica.dao.Documento docSICA = null;
                for (int j = 0; j < accordoServizioSICA.sizeSpecificheSemiformali(); ++j) {
                    if (!fileName.equals(accordoServizioSICA.getSpecificaSemiformale(j).getNome())) continue;
                    docSICA = accordoServizioSICA.getSpecificaSemiformale(j);
                }
                if (docSICA == null) {
                    throw new SICAToOpenSPCoopUtilitiesException("SpecificaSemiformale con nome[" + fileName + "] non trovato");
                }
                boolean specificaEGovAsClientSICA = it.gov.spcoop.sica.wscp.driver.XMLUtils.isProfiloCollaborazioneEGOV(docSICA.getContenuto());
                boolean specificaEGovAsDocumentoCNIPA = it.cnipa.collprofiles.driver.XMLUtils.isProfiloCollaborazioneEGOV(docSICA.getContenuto());
                if (findDocumentoSpecificaEGOV) {
                    String fileNameTmp = "specificaSemiformale" + File.separatorChar + fileName;
                    if (specificaEGovAsClientSICA) {
                        throw new SICAToOpenSPCoopUtilitiesException("Nel package sono presenti piu' di una specifica delle informazioni egov. E' stata gia' processata una specifica di tipo " + tipoDocumentoSpecificaEGovTrovato + " (" + fileNameSpecificaEGovTrovata + ") e adesso e' stato riscontrato una specifica di tipo " + "http://spcoop.gov.it/sica/wscp" + " (" + fileNameTmp + ")");
                    }
                    if (specificaEGovAsDocumentoCNIPA) {
                        throw new SICAToOpenSPCoopUtilitiesException("Nel package sono presenti piu' di una specifica delle informazioni egov. E' stata gia' processata una specifica di tipo " + tipoDocumentoSpecificaEGovTrovato + " (" + fileNameSpecificaEGovTrovata + ") e adesso e' stato riscontrato una specifica di tipo " + "http://www.cnipa.it/collProfiles" + " (" + fileNameTmp + ")");
                    }
                } else {
                    if (specificaEGovAsClientSICA && specificaEGovAsDocumentoCNIPA) {
                        throw new SICAToOpenSPCoopUtilitiesException("La specifica delle informazioni egov e' sia di tipo http://spcoop.gov.it/sica/wscp che di tipo http://www.cnipa.it/collProfiles ??");
                    }
                    if (specificaEGovAsClientSICA || specificaEGovAsDocumentoCNIPA) {
                        findDocumentoSpecificaEGOV = true;
                        fileNameSpecificaEGovTrovata = "specificaSemiformale" + File.separatorChar + fileName;
                    }
                }
                if (specificaEGovAsClientSICA) {
                    try {
                        it.gov.spcoop.sica.wscp.driver.XMLUtils.mapProfiloCollaborazioneEGOVIntoAS(docSICA.getContenuto(), accServizioOpenspcoop, documentoSpecificaEGOV_asClientSICAEnabled_childUnquilified);
                        tipoDocumentoSpecificaEGovTrovato = "http://spcoop.gov.it/sica/wscp";
                        findDocumentoSpecificaEGOV = true;
                        continue;
                    }
                    catch (Exception e) {
                        throw new SICAToOpenSPCoopUtilitiesException("Errore durante la verifica dell'esistenza del documento di tipo 'ProfiloCollaborazioneEGOV' per il file [" + fileName + "] : " + e.getMessage(), e);
                    }
                }
                if (specificaEGovAsDocumentoCNIPA) {
                    try {
                        it.cnipa.collprofiles.driver.XMLUtils.mapProfiloCollaborazioneEGOVIntoAS(docSICA.getContenuto(), accServizioOpenspcoop, documentoSpecificaEGOV_asClientSICADisabled_childUnquilified);
                        tipoDocumentoSpecificaEGovTrovato = "http://www.cnipa.it/collProfiles";
                        findDocumentoSpecificaEGOV = true;
                        continue;
                    }
                    catch (Exception e) {
                        throw new SICAToOpenSPCoopUtilitiesException("Errore durante la verifica dell'esistenza del documento di tipo 'ProfiloCollaborazioneEGOV' per il file [" + fileName + "] : " + e.getMessage(), e);
                    }
                }
                docOpenspcoop.setFile(fileName);
                docOpenspcoop.setRuolo(RuoliDocumento.specificaSemiformale.toString());
                docOpenspcoop.setTipo(docSICA.getTipo());
                docOpenspcoop.setByteContenuto(docSICA.getContenuto());
                accServizioOpenspcoop.addSpecificaSemiformale(docOpenspcoop);
            }
        }
        if ((specificaCoordinamento = manifest.getSpecificaCoordinamento()) != null) {
            for (int i = 0; i < specificaCoordinamento.sizeDocumentoCoordinamentoList(); ++i) {
                DocumentoCoordinamento docCoordinamento = specificaCoordinamento.getDocumentoCoordinamento(i);
                Documento docOpenspcoop = new Documento();
                String fileName = docCoordinamento.getBase();
                docOpenspcoop.setFile(fileName);
                docOpenspcoop.setRuolo(RuoliDocumento.specificaCoordinamento.toString());
                it.gov.spcoop.sica.dao.Documento docSICA = null;
                for (int j = 0; j < accordoServizioSICA.sizeSpecificheCoordinamento(); ++j) {
                    if (!fileName.equals(accordoServizioSICA.getSpecificaCoordinamento(j).getNome())) continue;
                    docSICA = accordoServizioSICA.getSpecificaCoordinamento(j);
                }
                if (docSICA == null) {
                    throw new SICAToOpenSPCoopUtilitiesException("SpecificaCoordinamento con nome[" + fileName + "] non trovato");
                }
                docOpenspcoop.setTipo(docSICA.getTipo());
                docOpenspcoop.setByteContenuto(docSICA.getContenuto());
                servizioComposto.addSpecificaCoordinamento(docOpenspcoop);
            }
        }
        if (manifest.getFirmato()) {
            accServizioOpenspcoop.setByteFirma(accordoServizioSICA.getFirma().getBytes());
        }
        accServizioOpenspcoop.setServizioComposto(servizioComposto);
        if (verificaCorreggiLocationWSDL) {
            try {
                RegistroOpenSPCoopUtilities registroOpenSPCoopUtilities = new RegistroOpenSPCoopUtilities(Logger.getLogger((String)"openspcoop.core"));
                registroOpenSPCoopUtilities.updateLocation(accServizioOpenspcoop, false, prettyDocument);
            }
            catch (Exception e) {
                throw new SICAToOpenSPCoopUtilitiesException("RegistroOpenSPCoopUtilities.setImportLocation error: " + e.getMessage(), e);
            }
        }
        return accServizioOpenspcoop;
    }

    public static AccordoServizioComposto accordoServizioComposto_openspcoopToSica(AccordoServizio accordoServizioOpenspcoop, SICAtoOpenSPCoopContext sicaToOpenspcoopContext) throws SICAToOpenSPCoopUtilitiesException {
        it.gov.spcoop.sica.dao.Documento doc;
        DocumentoConversazione docConversazione;
        it.gov.spcoop.sica.dao.Documento doc2;
        DocumentoInterfaccia docInterfaccia;
        boolean documentoSpecificaEGOV_asClientSICA = sicaToOpenspcoopContext.isInformazioniEGov_wscp();
        boolean documentoSpecificaEGOV_asSpecificaSemiformale = sicaToOpenspcoopContext.isInformazioniEGov_specificaSemiformale();
        boolean documentoSpecificaEGOV_asClientSICADisabled_namespaceCNIPA = sicaToOpenspcoopContext.isInformazioniEGov_wscpDisabled_namespaceCnipa();
        boolean documentoSpecificaEGOV_nomiSPCoopQualified = sicaToOpenspcoopContext.isInformazioniEGov_nomiSPCoop_qualified();
        boolean documentoSpecificaEGOV_asClientSICAEnabled_childUnquilified = sicaToOpenspcoopContext.isInformazioniEGov_wscpEnabled_childUnqualified();
        boolean verificaCorreggiLocationWSDL = sicaToOpenspcoopContext.isWSDL_XSD_allineaImportInclude();
        boolean prettyDocument = sicaToOpenspcoopContext.isWSDL_XSD_prettyDocuments();
        boolean includiInfoRegistroGenerale = sicaToOpenspcoopContext.isSICAClient_includiInfoRegistroGenerale();
        boolean wsdlEmptySeNonDefiniti = sicaToOpenspcoopContext.isWSDL_XSD_accordiParteSpecifica_wsdlEmpty();
        if (verificaCorreggiLocationWSDL) {
            try {
                RegistroOpenSPCoopUtilities registroOpenSPCoopUtilities = new RegistroOpenSPCoopUtilities(Logger.getLogger((String)"openspcoop.core"));
                registroOpenSPCoopUtilities.updateLocation(accordoServizioOpenspcoop, true, prettyDocument);
            }
            catch (Exception e) {
                throw new SICAToOpenSPCoopUtilitiesException("RegistroOpenSPCoopUtilities.setImportLocation error: " + e.getMessage(), e);
            }
        }
        AccordoServizioComposto accServCompostoSICA = new AccordoServizioComposto();
        ServizioComposto manifest = new ServizioComposto();
        manifest.setDescrizione(accordoServizioOpenspcoop.getDescrizione());
        manifest.setNome(accordoServizioOpenspcoop.getNome());
        manifest.setDataCreazione(accordoServizioOpenspcoop.getOraRegistrazione());
        if (includiInfoRegistroGenerale) {
            manifest.setVersione(accordoServizioOpenspcoop.getVersione());
            manifest.setDataPubblicazione(accordoServizioOpenspcoop.getDataPubblicazione());
            if (accordoServizioOpenspcoop.getSoggettoReferente() == null) {
                throw new SICAToOpenSPCoopUtilitiesException("Soggetto referente non definito");
            }
            IDSoggetto soggettoPubblicatore = new IDSoggetto(accordoServizioOpenspcoop.getSoggettoReferente().getTipo(), accordoServizioOpenspcoop.getSoggettoReferente().getNome());
            String uriPubblicatore = sicaToOpenspcoopContext.getCodiceIPA(soggettoPubblicatore);
            uriPubblicatore = uriPubblicatore == null ? SICAtoOpenSPCoopUtilities.idSoggetto_openspcoopToSica(soggettoPubblicatore) : SICAtoOpenSPCoopUtilities.appendURI_IDSoggettoSica(uriPubblicatore);
            manifest.setPubblicatore(uriPubblicatore);
            if (accordoServizioOpenspcoop.getByteFirma() != null) {
                manifest.setFirmato(true);
            }
        }
        SpecificaInterfaccia specificaInterfaccia = null;
        if (accordoServizioOpenspcoop.getByteWsdlConcettuale() != null || accordoServizioOpenspcoop.getByteWsdlLogicoErogatore() != null || accordoServizioOpenspcoop.getByteWsdlLogicoFruitore() != null) {
            specificaInterfaccia = new SpecificaInterfaccia();
        }
        if (wsdlEmptySeNonDefiniti || accordoServizioOpenspcoop.getByteWsdlConcettuale() != null) {
            docInterfaccia = new DocumentoInterfaccia();
            docInterfaccia.setBase("InterfacciaConcettuale.wsdl");
            docInterfaccia.setTipo(TipiDocumentoInterfaccia.WSDL.toString());
            specificaInterfaccia.setInterfacciaConcettuale(docInterfaccia);
            doc2 = new it.gov.spcoop.sica.dao.Documento();
            doc2.setTipo(TipiDocumentoInterfaccia.WSDL.toString());
            doc2.setNome("InterfacciaConcettuale.wsdl");
            if (accordoServizioOpenspcoop.getByteWsdlConcettuale() != null) {
                doc2.setContenuto(accordoServizioOpenspcoop.getByteWsdlConcettuale());
            } else {
                doc2.setContenuto("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wsdl:definitions xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\"/>".getBytes());
            }
            accServCompostoSICA.setInterfacciaConcettuale(doc2);
        }
        if (wsdlEmptySeNonDefiniti || accordoServizioOpenspcoop.getByteWsdlLogicoErogatore() != null) {
            docInterfaccia = new DocumentoInterfaccia();
            docInterfaccia.setBase("InterfacciaLogicaErogatore.wsdl");
            docInterfaccia.setTipo(TipiDocumentoInterfaccia.WSDL.toString());
            specificaInterfaccia.setInterfacciaLogicaLatoErogatore(docInterfaccia);
            doc2 = new it.gov.spcoop.sica.dao.Documento();
            doc2.setTipo(TipiDocumentoInterfaccia.WSDL.toString());
            doc2.setNome("InterfacciaLogicaErogatore.wsdl");
            if (accordoServizioOpenspcoop.getByteWsdlLogicoErogatore() != null) {
                doc2.setContenuto(accordoServizioOpenspcoop.getByteWsdlLogicoErogatore());
            } else {
                doc2.setContenuto("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wsdl:definitions xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\"/>".getBytes());
            }
            accServCompostoSICA.setInterfacciaLogicaLatoErogatore(doc2);
        }
        if (wsdlEmptySeNonDefiniti || accordoServizioOpenspcoop.getByteWsdlLogicoFruitore() != null) {
            docInterfaccia = new DocumentoInterfaccia();
            docInterfaccia.setBase("InterfacciaLogicaFruitore.wsdl");
            docInterfaccia.setTipo(TipiDocumentoInterfaccia.WSDL.toString());
            specificaInterfaccia.setInterfacciaLogicaLatoFruitore(docInterfaccia);
            doc2 = new it.gov.spcoop.sica.dao.Documento();
            doc2.setTipo(TipiDocumentoInterfaccia.WSDL.toString());
            doc2.setNome("InterfacciaLogicaFruitore.wsdl");
            if (accordoServizioOpenspcoop.getByteWsdlLogicoFruitore() != null) {
                doc2.setContenuto(accordoServizioOpenspcoop.getByteWsdlLogicoFruitore());
            } else {
                doc2.setContenuto("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wsdl:definitions xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\"/>".getBytes());
            }
            accServCompostoSICA.setInterfacciaLogicaLatoFruitore(doc2);
        }
        if (specificaInterfaccia != null) {
            manifest.setSpecificaInterfaccia(specificaInterfaccia);
        }
        SpecificaConversazione specificaConversazione = null;
        if (accordoServizioOpenspcoop.getByteWsblConcettuale() != null || accordoServizioOpenspcoop.getByteWsblLogicoErogatore() != null || accordoServizioOpenspcoop.getByteWsblLogicoFruitore() != null) {
            specificaConversazione = new SpecificaConversazione();
        }
        if (accordoServizioOpenspcoop.getByteWsblConcettuale() != null) {
            docConversazione = new DocumentoConversazione();
            docConversazione.setBase("ConversazioneConcettuale.wsbl");
            docConversazione.setTipo(TipiDocumentoConversazione.WSBL.toString());
            specificaConversazione.setConversazioneConcettuale(docConversazione);
            doc = new it.gov.spcoop.sica.dao.Documento();
            doc.setTipo(TipiDocumentoConversazione.WSBL.toString());
            doc.setNome("ConversazioneConcettuale.wsbl");
            doc.setContenuto(accordoServizioOpenspcoop.getByteWsblConcettuale());
            accServCompostoSICA.setConversazioneConcettuale(doc);
        }
        if (accordoServizioOpenspcoop.getByteWsblLogicoErogatore() != null) {
            docConversazione = new DocumentoConversazione();
            docConversazione.setBase("ConversazioneLogicaLatoErogatore.wsbl");
            docConversazione.setTipo(TipiDocumentoConversazione.WSBL.toString());
            specificaConversazione.setConversazioneLogicaLatoErogatore(docConversazione);
            doc = new it.gov.spcoop.sica.dao.Documento();
            doc.setTipo(TipiDocumentoConversazione.WSBL.toString());
            doc.setNome("ConversazioneLogicaLatoErogatore.wsbl");
            doc.setContenuto(accordoServizioOpenspcoop.getByteWsblLogicoErogatore());
            accServCompostoSICA.setConversazioneLogicaErogatore(doc);
        }
        if (accordoServizioOpenspcoop.getByteWsblLogicoFruitore() != null) {
            docConversazione = new DocumentoConversazione();
            docConversazione.setBase("ConversazioneLogicaLatoFruitore.wsbl");
            docConversazione.setTipo(TipiDocumentoConversazione.WSBL.toString());
            specificaConversazione.setConversazioneLogicaLatoFruitore(docConversazione);
            doc = new it.gov.spcoop.sica.dao.Documento();
            doc.setTipo(TipiDocumentoConversazione.WSBL.toString());
            doc.setNome("ConversazioneLogicaLatoFruitore.wsbl");
            doc.setContenuto(accordoServizioOpenspcoop.getByteWsblLogicoFruitore());
            accServCompostoSICA.setConversazioneLogicaFruitore(doc);
        }
        if (specificaConversazione != null) {
            manifest.setSpecificaConversazione(specificaConversazione);
        }
        String uriAccordoCooperazione = null;
        if (accordoServizioOpenspcoop.getServizioComposto() == null) {
            throw new SICAToOpenSPCoopUtilitiesException("ServizioComposto non definito");
        }
        try {
            uriAccordoCooperazione = SICAtoOpenSPCoopUtilities.idAccordoCooperazione_openspcoopToSica(IDAccordoCooperazione.getIDAccordoFromUri(accordoServizioOpenspcoop.getServizioComposto().getNomeAccordoCooperazione()));
        }
        catch (Exception e) {
            throw new SICAToOpenSPCoopUtilitiesException("Trasformazione IDAccordo di cooperazione [" + accordoServizioOpenspcoop.getServizioComposto().getNomeAccordoCooperazione() + "] non riuscito: " + e.getMessage(), e);
        }
        manifest.setRiferimentoAccordoCooperazione(uriAccordoCooperazione);
        ElencoServiziComponenti servComponentiSICA = null;
        for (int i = 0; i < accordoServizioOpenspcoop.getServizioComposto().sizeServizioComponenteList(); ++i) {
            AccordoServizioServizioCompostoServizioComponente servComponente = accordoServizioOpenspcoop.getServizioComposto().getServizioComponente(i);
            if (servComponentiSICA == null) {
                servComponentiSICA = new ElencoServiziComponenti();
            }
            IDServizio idServ = new IDServizio(servComponente.getTipoSoggetto(), servComponente.getNomeSoggetto(), servComponente.getTipo(), servComponente.getNome());
            try {
                String uriAPS = sicaToOpenspcoopContext.getUriAPS(idServ);
                if (uriAPS == null) {
                    throw new SICAToOpenSPCoopUtilitiesException("Trasformazione IDServizio [" + idServ + "] in uri accordo servizio parte specifica non riuscita");
                }
                servComponentiSICA.addServizioComponente(uriAPS);
                continue;
            }
            catch (Exception e) {
                throw new SICAToOpenSPCoopUtilitiesException("Trasformazione IDServizio [" + idServ + "] non riuscito: " + e.getMessage(), e);
            }
        }
        if (servComponentiSICA != null) {
            manifest.setServiziComponenti(servComponentiSICA);
        }
        ElencoAllegati allegati = null;
        if (accordoServizioOpenspcoop.sizePortTypeList() > 0 && !documentoSpecificaEGOV_asSpecificaSemiformale) {
            String docGenerico = null;
            if (documentoSpecificaEGOV_asClientSICA) {
                try {
                    docGenerico = it.gov.spcoop.sica.wscp.driver.XMLUtils.generaGenericoDocumento(accordoServizioOpenspcoop, accServCompostoSICA, documentoSpecificaEGOV_nomiSPCoopQualified, documentoSpecificaEGOV_asClientSICAEnabled_childUnquilified);
                }
                catch (Exception e) {
                    throw new SICAToOpenSPCoopUtilitiesException("Errore durante la conversione delle informazioni eGov in Allegati (http://spcoop.gov.it/sica/wscp): " + e.getMessage(), e);
                }
            }
            try {
                docGenerico = it.cnipa.collprofiles.driver.XMLUtils.generaGenericoDocumento(accordoServizioOpenspcoop, accServCompostoSICA, documentoSpecificaEGOV_asClientSICADisabled_namespaceCNIPA, documentoSpecificaEGOV_nomiSPCoopQualified);
            }
            catch (Exception e) {
                throw new SICAToOpenSPCoopUtilitiesException("Errore durante la conversione delle informazioni eGov in Allegati (http://www.cnipa.it/collProfiles): " + e.getMessage(), e);
            }
            if (docGenerico != null) {
                if (allegati == null) {
                    allegati = new ElencoAllegati();
                }
                allegati.addGenericoDocumento(docGenerico);
                manifest.setAllegati(allegati);
            }
        }
        if (accordoServizioOpenspcoop.sizeAllegatoList() > 0) {
            if (allegati == null) {
                allegati = new ElencoAllegati();
            }
            for (int i = 0; i < accordoServizioOpenspcoop.sizeAllegatoList(); ++i) {
                Documento docOpenspcoop = accordoServizioOpenspcoop.getAllegato(i);
                allegati.addGenericoDocumento(docOpenspcoop.getFile());
                it.gov.spcoop.sica.dao.Documento docSICA = new it.gov.spcoop.sica.dao.Documento();
                docSICA.setTipo(docOpenspcoop.getTipo());
                docSICA.setNome(docOpenspcoop.getFile());
                if (docOpenspcoop.getByteContenuto() == null) {
                    throw new SICAToOpenSPCoopUtilitiesException("Byte dell'allegato " + docOpenspcoop.getFile() + " di tipo " + docOpenspcoop.getTipo() + " non forniti");
                }
                docSICA.setContenuto(docOpenspcoop.getByteContenuto());
                accServCompostoSICA.addAllegato(docSICA);
            }
            manifest.setAllegati(allegati);
        }
        if (accordoServizioOpenspcoop.getByteWsdlDefinitorio() != null) {
            if (allegati == null) {
                allegati = new ElencoAllegati();
            }
            allegati.addGenericoDocumento("InterfacciaDefinitoria.xsd");
            manifest.setAllegati(allegati);
            it.gov.spcoop.sica.dao.Documento docSICA = new it.gov.spcoop.sica.dao.Documento();
            docSICA.setTipo("XSD");
            docSICA.setNome("InterfacciaDefinitoria.xsd");
            docSICA.setContenuto(accordoServizioOpenspcoop.getByteWsdlDefinitorio());
            accServCompostoSICA.addAllegato(docSICA);
        }
        SpecificaSemiformale specificaSemiformale = null;
        if (accordoServizioOpenspcoop.sizePortTypeList() > 0 && documentoSpecificaEGOV_asSpecificaSemiformale) {
            DocumentoSemiformale docSemiformale = null;
            if (documentoSpecificaEGOV_asClientSICA) {
                try {
                    docSemiformale = it.gov.spcoop.sica.wscp.driver.XMLUtils.generaDocumentoSemiformale(accordoServizioOpenspcoop, accServCompostoSICA, documentoSpecificaEGOV_nomiSPCoopQualified, documentoSpecificaEGOV_asClientSICAEnabled_childUnquilified);
                }
                catch (Exception e) {
                    throw new SICAToOpenSPCoopUtilitiesException("Errore durante la conversione delle informazioni eGov in SpecificaSemiformale (http://spcoop.gov.it/sica/wscp): " + e.getMessage(), e);
                }
            }
            try {
                docSemiformale = it.cnipa.collprofiles.driver.XMLUtils.generaDocumentoSemiformale(accordoServizioOpenspcoop, accServCompostoSICA, documentoSpecificaEGOV_asClientSICADisabled_namespaceCNIPA, documentoSpecificaEGOV_nomiSPCoopQualified);
            }
            catch (Exception e) {
                throw new SICAToOpenSPCoopUtilitiesException("Errore durante la conversione delle informazioni eGov in SpecificaSemiformale (http://www.cnipa.it/collProfiles): " + e.getMessage(), e);
            }
            if (docSemiformale != null) {
                if (specificaSemiformale == null) {
                    specificaSemiformale = new SpecificaSemiformale();
                }
                specificaSemiformale.addDocumentoSemiformale(docSemiformale);
                manifest.setSpecificaSemiformale(specificaSemiformale);
            }
        }
        if (accordoServizioOpenspcoop.sizeSpecificaSemiformaleList() > 0) {
            if (specificaSemiformale == null) {
                specificaSemiformale = new SpecificaSemiformale();
            }
            for (int i = 0; i < accordoServizioOpenspcoop.sizeSpecificaSemiformaleList(); ++i) {
                Documento docOpenspcoop = accordoServizioOpenspcoop.getSpecificaSemiformale(i);
                DocumentoSemiformale docSemiformale = new DocumentoSemiformale();
                docSemiformale.setTipo(docOpenspcoop.getTipo());
                docSemiformale.setBase(docOpenspcoop.getFile());
                specificaSemiformale.addDocumentoSemiformale(docSemiformale);
                it.gov.spcoop.sica.dao.Documento docSICA = new it.gov.spcoop.sica.dao.Documento();
                docSICA.setTipo(docOpenspcoop.getTipo());
                docSICA.setNome(docOpenspcoop.getFile());
                if (docOpenspcoop.getByteContenuto() == null) {
                    throw new SICAToOpenSPCoopUtilitiesException("Byte della specifica semiformale " + docOpenspcoop.getFile() + " di tipo " + docOpenspcoop.getTipo() + " non forniti");
                }
                docSICA.setContenuto(docOpenspcoop.getByteContenuto());
                accServCompostoSICA.addSpecificaSemiformale(docSICA);
            }
            manifest.setSpecificaSemiformale(specificaSemiformale);
        }
        SpecificaCoordinamento coordinamento = null;
        for (int i = 0; i < accordoServizioOpenspcoop.getServizioComposto().sizeSpecificaCoordinamentoList(); ++i) {
            Documento docOpenspcoop = accordoServizioOpenspcoop.getServizioComposto().getSpecificaCoordinamento(i);
            if (coordinamento == null) {
                coordinamento = new SpecificaCoordinamento();
            }
            DocumentoCoordinamento docCoordinamento = new DocumentoCoordinamento();
            docCoordinamento.setTipo(docOpenspcoop.getTipo());
            docCoordinamento.setBase(docOpenspcoop.getFile());
            coordinamento.addDocumentoCoordinamento(docCoordinamento);
            it.gov.spcoop.sica.dao.Documento docSICA = new it.gov.spcoop.sica.dao.Documento();
            docSICA.setTipo(docOpenspcoop.getTipo());
            docSICA.setNome(docOpenspcoop.getFile());
            if (docOpenspcoop.getByteContenuto() == null) {
                throw new SICAToOpenSPCoopUtilitiesException("Byte della specifica di coordinamento " + docOpenspcoop.getFile() + " di tipo " + docOpenspcoop.getTipo() + " non forniti");
            }
            docSICA.setContenuto(docOpenspcoop.getByteContenuto());
            accServCompostoSICA.addSpecificaCoordinamento(docSICA);
        }
        if (coordinamento != null) {
            manifest.setSpecificaCoordinamento(coordinamento);
        }
        if (includiInfoRegistroGenerale && accordoServizioOpenspcoop.getByteFirma() != null) {
            Firma firma = new Firma();
            accServCompostoSICA.setFirma(firma);
        }
        accServCompostoSICA.setManifesto(manifest);
        return accServCompostoSICA;
    }
}

