/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.dao.registry.driver;

import java.util.Vector;
import org.openspcoop.dao.registry.AccordoCooperazione;
import org.openspcoop.dao.registry.AccordoServizio;
import org.openspcoop.dao.registry.Documento;
import org.openspcoop.dao.registry.Fruitore;
import org.openspcoop.dao.registry.PortType;
import org.openspcoop.dao.registry.PortaDominio;
import org.openspcoop.dao.registry.ServizioSpcoop;
import org.openspcoop.dao.registry.SoggettoSpcoop;
import org.openspcoop.dao.registry.driver.IDAccordo;
import org.openspcoop.dao.registry.driver.IDAccordoCooperazione;
import org.openspcoop.utils.serialization.IOException;

public class IDBuilder
implements org.openspcoop.utils.serialization.IDBuilder {
    protected boolean prefix = false;

    public IDBuilder(boolean insertClassNamePrefix) {
        this.prefix = insertClassNamePrefix;
    }

    public IDBuilder() {
        this.prefix = false;
    }

    public static IDBuilder getIDBuilder() {
        return new IDBuilder();
    }

    public String toID(Object o) throws IOException {
        if (o == null) {
            throw new IOException("Oggetto is null");
        }
        try {
            if (o instanceof AccordoCooperazione) {
                AccordoCooperazione ac = (AccordoCooperazione)o;
                String id = IDAccordoCooperazione.getUriFromAccordo(ac);
                if (this.prefix) {
                    return "[AccordoCooperazione] " + id;
                }
                return id;
            }
            if (o instanceof AccordoServizio) {
                AccordoServizio as = (AccordoServizio)o;
                String id = IDAccordo.getUriFromAccordo(as);
                if (this.prefix) {
                    return "[AS] " + id;
                }
                return id;
            }
            if (o instanceof PortType) {
                PortType p = (PortType)o;
                String id = "IDAccordo[" + p.getIdAccordo() + "]_" + p.getNome();
                if (this.prefix) {
                    return "[PortType] " + id;
                }
                return id;
            }
            if (o instanceof Documento) {
                Documento d = (Documento)o;
                String id = "[" + d.getRuolo() + "][" + d.getTipo() + "]" + " " + d.getFile();
                if (this.prefix) {
                    return "[Documento] " + id;
                }
                return id;
            }
            if (o instanceof PortaDominio) {
                PortaDominio p = (PortaDominio)o;
                String id = p.getNome();
                if (this.prefix) {
                    return "[PdD] " + id;
                }
                return id;
            }
            if (o instanceof ServizioSpcoop) {
                ServizioSpcoop s = (ServizioSpcoop)o;
                String id = s.getTipoSoggettoErogatore() + "/" + s.getNomeSoggettoErogatore() + "#" + s.getTipo() + "/" + s.getNome();
                if (this.prefix) {
                    return "[ServizioSPCoop] " + id;
                }
                return id;
            }
            if (o instanceof Fruitore) {
                Fruitore fr = (Fruitore)o;
                String id = fr.getTipo() + "/" + fr.getNome();
                if (fr.getIdServizio() != null && fr.getIdServizio() > 0L) {
                    id = id + "#idServizio:" + fr.getIdServizio();
                }
                if (this.prefix) {
                    return "[FruitoreServizioSPCoop] " + id;
                }
                return id;
            }
            if (o instanceof SoggettoSpcoop) {
                SoggettoSpcoop s = (SoggettoSpcoop)o;
                String id = s.getTipo() + "/" + s.getNome();
                if (this.prefix) {
                    return "[SoggettoSPCoop] " + id;
                }
                return id;
            }
        }
        catch (Exception e) {
            throw new IOException("Trasformazione non riuscita: " + e.getMessage(), e);
        }
        throw new IOException("Tipo di Oggetto non gestito [" + o.getClass().getName() + "]");
    }

    public String toID(Object o, String field) throws IOException {
        if (o != null && o instanceof Documento) {
            return this.toID(o);
        }
        return this.toID(o) + "." + field;
    }

    public String toOldID(Object o) throws IOException {
        if (o == null) {
            throw new IOException("Oggetto is null");
        }
        try {
            if (o instanceof AccordoCooperazione) {
                AccordoCooperazione ac = (AccordoCooperazione)o;
                IDAccordoCooperazione idOLD = ac.getOldIDAccordoForUpdate();
                if (idOLD == null) {
                    return null;
                }
                String id = IDAccordoCooperazione.getUriFromIDAccordo(idOLD);
                if (this.prefix) {
                    return "[AccordoCooperazione] " + id;
                }
                return id;
            }
            if (o instanceof AccordoServizio) {
                AccordoServizio as = (AccordoServizio)o;
                IDAccordo idOLD = as.getOldIDAccordoForUpdate();
                if (idOLD == null) {
                    return null;
                }
                String id = IDAccordo.getUriFromIDAccordo(idOLD);
                if (this.prefix) {
                    return "[AS] " + id;
                }
                return id;
            }
            if (o instanceof PortType) {
                return null;
            }
            if (o instanceof Documento) {
                return null;
            }
            if (o instanceof PortaDominio) {
                PortaDominio p = (PortaDominio)o;
                if (p.getOldNomeForUpdate() == null) {
                    return null;
                }
                String id = p.getOldNomeForUpdate();
                if (this.prefix) {
                    return "[PdD] " + id;
                }
                return id;
            }
            if (o instanceof ServizioSpcoop) {
                ServizioSpcoop s = (ServizioSpcoop)o;
                if (s.getOldTipoSoggettoErogatoreForUpdate() == null && s.getOldNomeSoggettoErogatoreForUpdate() == null && s.getOldTipoForUpdate() == null && s.getOldNomeForUpdate() == null) {
                    return null;
                }
                String id = null;
                id = s.getOldTipoSoggettoErogatoreForUpdate() != null && s.getOldNomeSoggettoErogatoreForUpdate() != null && s.getOldTipoForUpdate() != null && s.getOldNomeForUpdate() != null ? s.getOldTipoSoggettoErogatoreForUpdate() + "/" + s.getOldNomeSoggettoErogatoreForUpdate() + "#" + s.getOldTipoForUpdate() + "/" + s.getOldNomeForUpdate() : (s.getOldTipoSoggettoErogatoreForUpdate() == null && s.getOldNomeSoggettoErogatoreForUpdate() == null ? s.getTipoSoggettoErogatore() + "/" + s.getNomeSoggettoErogatore() + "#" + s.getOldTipoForUpdate() + "/" + s.getOldNomeForUpdate() : s.getOldTipoSoggettoErogatoreForUpdate() + "/" + s.getOldNomeSoggettoErogatoreForUpdate() + "#" + s.getTipo() + "/" + s.getNome());
                if (this.prefix) {
                    return "[ServizioSPCoop] " + id;
                }
                return id;
            }
            if (o instanceof SoggettoSpcoop) {
                SoggettoSpcoop s = (SoggettoSpcoop)o;
                if (s.getOldTipoForUpdate() == null || s.getOldNomeForUpdate() == null) {
                    return null;
                }
                String id = s.getOldTipoForUpdate() + "/" + s.getOldNomeForUpdate();
                if (this.prefix) {
                    return "[SoggettoSPCoop] " + id;
                }
                return id;
            }
        }
        catch (Exception e) {
            throw new IOException("Trasformazione non riuscita: " + e.getMessage(), e);
        }
        throw new IOException("Tipo di Oggetto non gestito [" + o.getClass().getName() + "]");
    }

    public String[] getManagedObjects(boolean simpleName) throws IOException {
        Vector<String> oggetti = new Vector<String>();
        if (simpleName) {
            oggetti.add(AccordoCooperazione.class.getSimpleName());
            oggetti.add(AccordoServizio.class.getSimpleName());
            oggetti.add(PortType.class.getSimpleName());
            oggetti.add(Documento.class.getSimpleName());
            oggetti.add(ServizioSpcoop.class.getSimpleName());
            oggetti.add(SoggettoSpcoop.class.getSimpleName());
        } else {
            oggetti.add(AccordoCooperazione.class.getName());
            oggetti.add(AccordoServizio.class.getName());
            oggetti.add(PortType.class.getName());
            oggetti.add(Documento.class.getName());
            oggetti.add(ServizioSpcoop.class.getName());
            oggetti.add(SoggettoSpcoop.class.getName());
        }
        String[] tmp = new String[1];
        return oggetti.toArray(tmp);
    }

    public String getSimpleName(Object o) throws IOException {
        return o.getClass().getSimpleName();
    }
}

