/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.dao.registry.driver;

import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;
import org.openspcoop.dao.commons.DriverException;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.commons.IDriverWS;
import org.openspcoop.dao.commons.IMonitoraggioRisorsa;
import org.openspcoop.dao.registry.AccordoCooperazione;
import org.openspcoop.dao.registry.AccordoServizio;
import org.openspcoop.dao.registry.Fruitore;
import org.openspcoop.dao.registry.PortaDominio;
import org.openspcoop.dao.registry.RegistroServizi;
import org.openspcoop.dao.registry.ServizioSpcoop;
import org.openspcoop.dao.registry.ServizioSpcoopAzione;
import org.openspcoop.dao.registry.ServizioSpcoopAzioneFruitore;
import org.openspcoop.dao.registry.SoggettoSpcoop;
import org.openspcoop.dao.registry.driver.BeanUtilities;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziException;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop.dao.registry.driver.FiltroAccordiSPCoop;
import org.openspcoop.dao.registry.driver.FiltroSPCoop;
import org.openspcoop.dao.registry.driver.FiltroServiziSPCoop;
import org.openspcoop.dao.registry.driver.IDAccordo;
import org.openspcoop.dao.registry.driver.IDAccordoCooperazione;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.dao.registry.driver.IDriverRegistroServiziCRUD;
import org.openspcoop.dao.registry.driver.IDriverRegistroServiziGet;
import org.openspcoop.dao.registry.driver.SICAtoOpenSPCoopUtilities;
import org.openspcoop.dao.registry.driver.XMLLib;
import org.openspcoop.utils.HttpUtilities;
import org.openspcoop.utils.UtilsException;
import org.openspcoop.utils.xml.ValidatoreXSD;

public class DriverRegistroServiziWEB
extends BeanUtilities
implements IDriverRegistroServiziGet,
IDriverRegistroServiziCRUD,
IDriverWS,
IMonitoraggioRisorsa {
    public boolean create = false;
    private String urlPrefix;
    private XMLLib generatoreXML;
    private ValidatoreXSD validatoreRegistro = null;
    private Logger log = null;

    public DriverRegistroServiziWEB(String urlPrefix, Logger alog) {
        this(urlPrefix, null, alog);
    }

    public DriverRegistroServiziWEB(String urlPrefix, String pathPrefix, Logger alog) {
        try {
            this.log = alog == null ? Logger.getLogger((String)"Registro Servizi WEB") : alog;
            this.urlPrefix = !urlPrefix.endsWith("/") ? urlPrefix + "/" : urlPrefix;
            try {
                this.validatoreRegistro = new ValidatoreXSD(DriverRegistroServiziWEB.class.getResourceAsStream("/registroServizi.xsd"));
            }
            catch (Exception e) {
                throw new Exception("Riscontrato errore durante l'inizializzazione dello schema del Registro dei Servizi di OpenSPCoop: " + e.getMessage(), e);
            }
            if (pathPrefix != null) {
                this.generatoreXML = new XMLLib(pathPrefix, urlPrefix);
            }
            this.create = true;
        }
        catch (Exception e) {
            this.log.error((Object)("Inizializzazione fallita: " + e.getMessage()));
            this.create = false;
        }
    }

    public AccordoCooperazione getAccordoCooperazione(IDAccordoCooperazione idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idAccordo == null) {
            throw new DriverRegistroServiziException("[getAccordoCooperazione] Parametro Non Valido");
        }
        if (idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("[getAccordoCooperazione] Nome accordo cooperazione non fornito");
        }
        AccordoCooperazione accRichiesto = null;
        String fileName = this.generatoreXML.mappingIDAccordoCooperazioneToFileName(idAccordo);
        String urlXMLAccordoCooperazione = this.urlPrefix + "accordi_cooperazione" + "/" + fileName + ".xml";
        ByteArrayInputStream bin = null;
        InputStreamReader istr = null;
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
            IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
            byte[] fileXML = null;
            try {
                fileXML = HttpUtilities.requestHTTPFile(urlXMLAccordoCooperazione);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[getAccordoCooperazione] Accordo richiesto non esiste: " + fileName);
                }
                throw e;
            }
            try {
                this.validatoreRegistro.valida(urlXMLAccordoCooperazione);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[getAccordoCooperazione] Riscontrato errore durante la validazione XSD del Registro dei Servizi XML di OpenSPCoop: " + e.getMessage(), e);
            }
            bin = new ByteArrayInputStream(fileXML);
            istr = new InputStreamReader(bin);
            RegistroServizi rs = (RegistroServizi)uctx.unmarshalDocument((Reader)istr, null);
            if (rs.sizeAccordoCooperazioneList() > 0) {
                accRichiesto = rs.getAccordoCooperazione(0);
            }
            istr.close();
            bin.close();
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                if (istr != null) {
                    istr.close();
                }
            }
            catch (Exception eis) {
                // empty catch block
            }
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception eis) {
                // empty catch block
            }
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[getAccordoCooperazione] Errore durante il parsing xml: " + e.getMessage(), e);
        }
        if (accRichiesto == null) {
            throw new DriverRegistroServiziNotFound("[getAccordoCooperazione] Accordo di Cooperazione non trovato.");
        }
        return accRichiesto;
    }

    public IDAccordoCooperazione[] getAllIdAccordiCooperazione(FiltroAccordiSPCoop filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            if (this.generatoreXML == null) {
                throw new DriverRegistroServiziException("[getAllIdAccordiCooperazione] Gestore repository XML non istanziato. Necessario per l'implementazione di questo metodo.");
            }
            AccordoCooperazione[] acList = this.generatoreXML.getAccordiCooperazione();
            if (acList == null) {
                throw new DriverRegistroServiziNotFound("Accordi non esistenti nel repository WEB");
            }
            Vector<IDAccordoCooperazione> idAccordi = new Vector<IDAccordoCooperazione>();
            for (int i = 0; i < acList.length; ++i) {
                String fileName = this.generatoreXML.mappingUriToFileName_accordoCooperazione(IDAccordoCooperazione.getUriFromAccordo(acList[i]));
                String acUrlXML = this.urlPrefix + "accordi_cooperazione" + "/" + fileName + ".xml";
                String acURI = IDAccordoCooperazione.getUriFromAccordo(acList[i]);
                try {
                    this.validatoreRegistro.valida(acUrlXML);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[getAllIdAccordiCooperazione] Riscontrato errore durante la validazione XSD (" + acUrlXML + "): " + e.getMessage(), e);
                }
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (acList[i].getOraRegistrazione() == null) {
                            this.log.debug((Object)("[getAllIdAccordiCooperazione](FiltroByMinDate) Accordo di servizio [" + acURI + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata."));
                            continue;
                        }
                        if (acList[i].getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (acList[i].getOraRegistrazione() == null) {
                            this.log.debug((Object)("[getAllIdAccordiCooperazione](FiltroByMaxDate) Accordo di servizio [" + acURI + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata."));
                            continue;
                        }
                        if (acList[i].getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getNomeAccordo() != null && !acList[i].getNome().equals(filtroRicerca.getNomeAccordo()) || filtroRicerca.getVersione() != null && !acList[i].getVersione().equals(filtroRicerca.getVersione()) || (filtroRicerca.getTipoSoggettoReferente() != null || filtroRicerca.getNomeSoggettoReferente() != null) && (acList[i].getSoggettoReferente() == null || filtroRicerca.getTipoSoggettoReferente() != null && !acList[i].getSoggettoReferente().getTipo().equals(filtroRicerca.getTipoSoggettoReferente()) || filtroRicerca.getNomeSoggettoReferente() != null && !acList[i].getSoggettoReferente().getNome().equals(filtroRicerca.getNomeSoggettoReferente()))) continue;
                }
                idAccordi.add(IDAccordoCooperazione.getIDAccordoFromValues(acList[i].getNome(), acList[i].getVersione()));
            }
            if (idAccordi.size() == 0) {
                throw new DriverRegistroServiziNotFound("Accordi non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            IDAccordoCooperazione[] res = new IDAccordoCooperazione[1];
            return idAccordi.toArray(res);
        }
        catch (Exception e) {
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("getAllIdAccordiCooperazione error", e);
        }
    }

    public AccordoServizio getAccordoServizio(IDAccordo idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idAccordo == null) {
            throw new DriverRegistroServiziException("[getAccordoServizio] Parametro Non Valido");
        }
        if (idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("[getAccordoServizio] Nome accordo servizio non fornito");
        }
        AccordoServizio accRichiesto = null;
        String fileName = this.generatoreXML.mappingIDAccordoToFileName(idAccordo);
        String urlXMLAccordoServizio = this.urlPrefix + "accordi" + "/" + fileName + ".xml";
        ByteArrayInputStream bin = null;
        InputStreamReader istr = null;
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
            IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
            byte[] fileXML = null;
            try {
                fileXML = HttpUtilities.requestHTTPFile(urlXMLAccordoServizio);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[getAccordoServizio] Accordo richiesto non esiste: " + fileName);
                }
                throw e;
            }
            try {
                this.validatoreRegistro.valida(urlXMLAccordoServizio);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[getAccordoServizio] Riscontrato errore durante la validazione XSD del Registro dei Servizi XML di OpenSPCoop: " + e.getMessage(), e);
            }
            bin = new ByteArrayInputStream(fileXML);
            istr = new InputStreamReader(bin);
            RegistroServizi rs = (RegistroServizi)uctx.unmarshalDocument((Reader)istr, null);
            if (rs.sizeAccordoServizioList() > 0) {
                accRichiesto = rs.getAccordoServizio(0);
            }
            istr.close();
            bin.close();
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                if (istr != null) {
                    istr.close();
                }
            }
            catch (Exception eis) {
                // empty catch block
            }
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception eis) {
                // empty catch block
            }
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[getAccordoServizio] Errore durante il parsing xml: " + e.getMessage(), e);
        }
        if (accRichiesto == null) {
            throw new DriverRegistroServiziNotFound("[getAccordoServizio] Accordo di Servizio non trovato.");
        }
        accRichiesto.setNomiAzione(accRichiesto.readNomiAzione());
        return accRichiesto;
    }

    public IDAccordo[] getAllIdAccordiServizio(FiltroAccordiSPCoop filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            if (this.generatoreXML == null) {
                throw new DriverRegistroServiziException("[getAllIdAccordiServizio] Gestore repository XML non istanziato. Necessario per l'implementazione di questo metodo.");
            }
            AccordoServizio[] asList = this.generatoreXML.getAccordiServizio();
            if (asList == null) {
                throw new DriverRegistroServiziNotFound("Accordi non esistenti nel repository WEB");
            }
            Vector<IDAccordo> idAccordi = new Vector<IDAccordo>();
            for (int i = 0; i < asList.length; ++i) {
                String fileName = this.generatoreXML.mappingUriToFileName(IDAccordo.getUriFromAccordo(asList[i]));
                String asUrlXML = this.urlPrefix + "accordi" + "/" + fileName + ".xml";
                String asURI = IDAccordo.getUriFromAccordo(asList[i]);
                try {
                    this.validatoreRegistro.valida(asUrlXML);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[getAllIdAccordiServizio] Riscontrato errore durante la validazione XSD (" + asUrlXML + "): " + e.getMessage(), e);
                }
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (asList[i].getOraRegistrazione() == null) {
                            this.log.debug((Object)("[getAllIdAccordiServizio](FiltroByMinDate) Accordo di servizio [" + asURI + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata."));
                            continue;
                        }
                        if (asList[i].getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (asList[i].getOraRegistrazione() == null) {
                            this.log.debug((Object)("[getAllIdAccordiServizio](FiltroByMaxDate) Accordo di servizio [" + asURI + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata."));
                            continue;
                        }
                        if (asList[i].getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getNomeAccordo() != null && !asList[i].getNome().equals(filtroRicerca.getNomeAccordo()) || filtroRicerca.getVersione() != null && !asList[i].getVersione().equals(filtroRicerca.getVersione()) || (filtroRicerca.getTipoSoggettoReferente() != null || filtroRicerca.getNomeSoggettoReferente() != null) && (asList[i].getSoggettoReferente() == null || filtroRicerca.getTipoSoggettoReferente() != null && !asList[i].getSoggettoReferente().getTipo().equals(filtroRicerca.getTipoSoggettoReferente()) || filtroRicerca.getNomeSoggettoReferente() != null && !asList[i].getSoggettoReferente().getNome().equals(filtroRicerca.getNomeSoggettoReferente()))) continue;
                }
                idAccordi.add(IDAccordo.getIDAccordoFromValues(asList[i].getNome(), BeanUtilities.getSoggettoReferenteID(asList[i].getSoggettoReferente()), asList[i].getVersione()));
            }
            if (idAccordi.size() == 0) {
                throw new DriverRegistroServiziNotFound("Accordi non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            IDAccordo[] res = new IDAccordo[1];
            return idAccordi.toArray(res);
        }
        catch (Exception e) {
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("getAllIdAccordiServizio error", e);
        }
    }

    public PortaDominio getPortaDominio(String nomePdD) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (nomePdD == null) {
            throw new DriverRegistroServiziException("[getPortaDominio] Parametro Non Valido");
        }
        PortaDominio pddRichiesta = null;
        String urlXMLPortaDominio = this.urlPrefix + "porte_di_dominio" + "/" + nomePdD + ".xml";
        ByteArrayInputStream bin = null;
        InputStreamReader istr = null;
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
            IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
            byte[] fileXML = null;
            try {
                fileXML = HttpUtilities.requestHTTPFile(urlXMLPortaDominio);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[getPortaDominio] Porta di dominio richiesta non esiste: " + nomePdD);
                }
                throw e;
            }
            try {
                this.validatoreRegistro.valida(urlXMLPortaDominio);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[getPortaDominio] Riscontrato errore durante la validazione XSD del Registro dei Servizi XML di OpenSPCoop: " + e.getMessage(), e);
            }
            bin = new ByteArrayInputStream(fileXML);
            istr = new InputStreamReader(bin);
            RegistroServizi rs = (RegistroServizi)uctx.unmarshalDocument((Reader)istr, null);
            if (rs.sizePortaDominioList() > 0) {
                pddRichiesta = rs.getPortaDominio(0);
            }
            istr.close();
            bin.close();
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                if (istr != null) {
                    istr.close();
                }
            }
            catch (Exception eis) {
                // empty catch block
            }
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception eis) {
                // empty catch block
            }
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[getPortaDominio] Errore durante il parsing xml: " + e.getMessage(), e);
        }
        if (pddRichiesta == null) {
            throw new DriverRegistroServiziNotFound("[getPortaDominio] Porta di Dominio non trovata.");
        }
        return pddRichiesta;
    }

    public String[] getAllIdPorteDominio(FiltroSPCoop filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            if (this.generatoreXML == null) {
                throw new DriverRegistroServiziException("[getAllIdPorteDominio] Gestore repository XML non istanziato. Necessario per l'implementazione di questo metodo.");
            }
            PortaDominio[] pddList = this.generatoreXML.getPorteDominio();
            if (pddList == null) {
                throw new DriverRegistroServiziNotFound("Porte di dominio non esistenti nel repository WEB");
            }
            Vector<String> nomiPdd = new Vector<String>();
            for (int i = 0; i < pddList.length; ++i) {
                String pdUrlXML = this.urlPrefix + "porte_di_dominio" + "/" + pddList[i].getNome() + ".xml";
                try {
                    this.validatoreRegistro.valida(pdUrlXML);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[getAllIdPorteDominio] Riscontrato errore durante la validazione XSD (" + pdUrlXML + "): " + e.getMessage(), e);
                }
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (pddList[i].getOraRegistrazione() == null) {
                            this.log.debug((Object)("[getAllIdPorteDominio](FiltroByMinDate) Porta di Dominio [" + pddList[i].getNome() + "] non valorizzata nell'ora-registrazione. Non inserito nella lista ritornata."));
                            continue;
                        }
                        if (pddList[i].getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (pddList[i].getOraRegistrazione() == null) {
                            this.log.debug((Object)("[getAllIdPorteDominio](FiltroByMaxDate) Porta di Dominio [" + pddList[i].getNome() + "] non valorizzata nell'ora-registrazione. Non inserito nella lista ritornata."));
                            continue;
                        }
                        if (pddList[i].getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getNome() != null && !pddList[i].getNome().equals(filtroRicerca.getNome())) continue;
                }
                nomiPdd.add(pddList[i].getNome());
            }
            if (nomiPdd.size() == 0) {
                throw new DriverRegistroServiziNotFound("Porte di dominio non trovate che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            String[] res = new String[1];
            return nomiPdd.toArray(res);
        }
        catch (Exception e) {
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("getAllIdPorteDominio error", e);
        }
    }

    public SoggettoSpcoop getSoggettoRegistro(IDSoggetto idSoggetto) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idSoggetto == null) {
            throw new DriverRegistroServiziException("[getSoggetto] Parametro Non Valido");
        }
        String tipo = idSoggetto.getTipo();
        String nome = idSoggetto.getNome();
        if (tipo == null || nome == null) {
            throw new DriverRegistroServiziException("[getSoggetto] Parametri Non Validi");
        }
        SoggettoSpcoop soggRichiesto = null;
        String idSoggettoXML = tipo + nome;
        String urlXMLSoggetto = this.urlPrefix + idSoggettoXML + "/" + idSoggettoXML + ".xml";
        ByteArrayInputStream bin = null;
        InputStreamReader istr = null;
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
            IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
            byte[] fileXML = null;
            try {
                fileXML = HttpUtilities.requestHTTPFile(urlXMLSoggetto);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[getSoggetto] Il soggetto [" + idSoggetto.getTipo() + "/" + idSoggetto.getNome() + "] non risulta gia' inserito nel registro dei servizi.");
                }
                throw e;
            }
            try {
                this.validatoreRegistro.valida(urlXMLSoggetto);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[getSoggetto] Riscontrato errore durante la validazione XSD del Registro dei Servizi XML di OpenSPCoop: " + e.getMessage(), e);
            }
            bin = new ByteArrayInputStream(fileXML);
            istr = new InputStreamReader(bin);
            RegistroServizi rs = (RegistroServizi)uctx.unmarshalDocument((Reader)istr, null);
            if (rs.sizeSoggettoSpcoopList() > 0) {
                soggRichiesto = rs.getSoggettoSpcoop(0);
            }
            istr.close();
            bin.close();
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                if (istr != null) {
                    istr.close();
                }
            }
            catch (Exception eis) {
                // empty catch block
            }
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception eis) {
                // empty catch block
            }
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[getSoggetto] Errore durante il parsing xml: " + e.getMessage(), e);
        }
        if (soggRichiesto == null) {
            throw new DriverRegistroServiziNotFound("[getSoggetto] Soggetto non trovato.");
        }
        return soggRichiesto;
    }

    public IDSoggetto[] getAllIdSoggettiRegistro(FiltroSPCoop filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            if (this.generatoreXML == null) {
                throw new DriverRegistroServiziException("[getAllIdSoggettiRegistro] Gestore repository XML non istanziato. Necessario per l'implementazione di questo metodo.");
            }
            SoggettoSpcoop[] ssList = this.generatoreXML.getSoggetti();
            if (ssList == null) {
                throw new DriverRegistroServiziNotFound("Soggetti non esistenti nel repository WEB");
            }
            Vector<IDSoggetto> idSoggetti = new Vector<IDSoggetto>();
            for (int i = 0; i < ssList.length; ++i) {
                String idSoggettoXML = ssList[i].getTipo() + ssList[i].getNome();
                String urlXMLSoggetto = this.urlPrefix + idSoggettoXML + "/" + idSoggettoXML + ".xml";
                try {
                    this.validatoreRegistro.valida(urlXMLSoggetto);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[getAllIdSoggettiRegistro] Riscontrato errore durante la validazione XSD (" + urlXMLSoggetto + "): " + e.getMessage(), e);
                }
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (ssList[i].getOraRegistrazione() == null) {
                            this.log.debug((Object)("[getAllIdSoggettiRegistro](FiltroByMinDate) Soggetto [" + ssList[i].getTipo() + "/" + ssList[i].getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata."));
                            continue;
                        }
                        if (ssList[i].getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (ssList[i].getOraRegistrazione() == null) {
                            this.log.debug((Object)("[getAllIdSoggettiRegistro](FiltroByMaxDate) Soggetto [" + ssList[i].getTipo() + "/" + ssList[i].getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata."));
                            continue;
                        }
                        if (ssList[i].getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getTipo() != null && !ssList[i].getTipo().equals(filtroRicerca.getTipo()) || filtroRicerca.getNome() != null && !ssList[i].getNome().equals(filtroRicerca.getNome())) continue;
                }
                IDSoggetto idS = new IDSoggetto(ssList[i].getTipo(), ssList[i].getNome());
                idSoggetti.add(idS);
            }
            if (idSoggetti.size() == 0) {
                throw new DriverRegistroServiziNotFound("Soggetti non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            IDSoggetto[] res = new IDSoggetto[1];
            return idSoggetti.toArray(res);
        }
        catch (Exception e) {
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("getAllIdSoggettiRegistro error", e);
        }
    }

    public ServizioSpcoop getServizio(IDServizio idService) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idService == null) {
            throw new DriverRegistroServiziException("[getServizio] Parametro Non Valido");
        }
        String servizio = idService.getServizio();
        String tipoServizio = idService.getTipoServizio();
        if (servizio == null || tipoServizio == null) {
            throw new DriverRegistroServiziException("[getServizio] Parametri (Servizio) Non Validi");
        }
        String tipoSogg = idService.getSoggettoErogatore().getTipo();
        String nomeSogg = idService.getSoggettoErogatore().getNome();
        if (tipoSogg == null || nomeSogg == null) {
            throw new DriverRegistroServiziException("[getServizio] Parametri (Soggetto) Non Validi");
        }
        ServizioSpcoop servRichiesto = null;
        String idSoggettoXML = tipoSogg + nomeSogg;
        String idServizioXML = tipoServizio + servizio;
        String urlXMLServizio = this.urlPrefix + idSoggettoXML + "/" + "servizi" + "/" + idServizioXML + ".xml";
        ByteArrayInputStream bin = null;
        InputStreamReader istr = null;
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
            IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
            byte[] fileXML = null;
            try {
                fileXML = HttpUtilities.requestHTTPFile(urlXMLServizio);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[getServizio] Il servizio [" + idService.getTipoServizio() + "/" + idService.getServizio() + "] erogato dal soggetto [" + idService.getSoggettoErogatore() + "] non risulta gia' registrato nel registro");
                }
                throw e;
            }
            try {
                this.validatoreRegistro.valida(urlXMLServizio);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[getServizio] Riscontrato errore durante la validazione XSD del Registro dei Servizi XML di OpenSPCoop: " + e.getMessage(), e);
            }
            bin = new ByteArrayInputStream(fileXML);
            istr = new InputStreamReader(bin);
            RegistroServizi rs = (RegistroServizi)uctx.unmarshalDocument((Reader)istr, null);
            if (rs.sizeSoggettoSpcoopList() > 0 && rs.getSoggettoSpcoop(0).sizeServizioList() > 0) {
                servRichiesto = rs.getSoggettoSpcoop(0).getServizio(0);
                servRichiesto.setNomeSoggettoErogatore(idService.getSoggettoErogatore().getNome());
                servRichiesto.setTipoSoggettoErogatore(idService.getSoggettoErogatore().getTipo());
            }
            istr.close();
            bin.close();
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                if (istr != null) {
                    istr.close();
                }
            }
            catch (Exception eis) {
                // empty catch block
            }
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception eis) {
                // empty catch block
            }
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[getServizio] Errore durante il parsing xml: " + e.getMessage(), e);
        }
        if (servRichiesto == null) {
            throw new DriverRegistroServiziNotFound("[getServizio] Servizio non trovato.");
        }
        servRichiesto.setServizioCorrelato(false);
        return servRichiesto;
    }

    public ServizioSpcoop getServizioCorrelato(IDServizio idService) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idService == null) {
            throw new DriverRegistroServiziException("[getServizioCorrelato] Parametro Non Valido");
        }
        String servizio = idService.getServizio();
        String tipoServizio = idService.getTipoServizio();
        if (servizio == null || tipoServizio == null) {
            throw new DriverRegistroServiziException("[getServizioCorrelato] Parametri (Servizio) Non Validi");
        }
        String tipoSogg = idService.getSoggettoErogatore().getTipo();
        String nomeSogg = idService.getSoggettoErogatore().getNome();
        if (tipoSogg == null || nomeSogg == null) {
            throw new DriverRegistroServiziException("[getServizioCorrelato] Parametri (Soggetto) Non Validi");
        }
        ServizioSpcoop servRichiesto = null;
        String idSoggettoXML = tipoSogg + nomeSogg;
        String idServizioXML = tipoServizio + servizio;
        String urlXMLServizio = this.urlPrefix + idSoggettoXML + "/" + "servizi" + "/" + idServizioXML + ".xml";
        ByteArrayInputStream bin = null;
        InputStreamReader istr = null;
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
            IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
            byte[] fileXML = null;
            try {
                fileXML = HttpUtilities.requestHTTPFile(urlXMLServizio);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[getServizioCorrelato] Il servizio [" + idService.getTipoServizio() + "/" + idService.getServizio() + "] erogato dal soggetto [" + idService.getSoggettoErogatore() + "] non risulta gia' registrato nel registro");
                }
                throw e;
            }
            try {
                this.validatoreRegistro.valida(urlXMLServizio);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[getServizioCorrelato] Riscontrato errore durante la validazione XSD del Registro dei Servizi XML di OpenSPCoop: " + e.getMessage(), e);
            }
            bin = new ByteArrayInputStream(fileXML);
            istr = new InputStreamReader(bin);
            RegistroServizi rs = (RegistroServizi)uctx.unmarshalDocument((Reader)istr, null);
            if (rs.sizeSoggettoSpcoopList() > 0 && rs.getSoggettoSpcoop(0).sizeServizioCorrelatoList() > 0) {
                servRichiesto = rs.getSoggettoSpcoop(0).getServizioCorrelato(0);
                servRichiesto.setNomeSoggettoErogatore(idService.getSoggettoErogatore().getNome());
                servRichiesto.setTipoSoggettoErogatore(idService.getSoggettoErogatore().getTipo());
            }
            istr.close();
            bin.close();
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                if (istr != null) {
                    istr.close();
                }
            }
            catch (Exception eis) {
                // empty catch block
            }
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception eis) {
                // empty catch block
            }
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[getServizioCorrelato] Errore durante il parsing xml: " + e.getMessage(), e);
        }
        if (servRichiesto == null) {
            throw new DriverRegistroServiziNotFound("[getServizioCorrelato] Servizio non trovato.");
        }
        servRichiesto.setServizioCorrelato(true);
        return servRichiesto;
    }

    public ServizioSpcoop getServizioCorrelato(IDSoggetto idSoggetto, IDAccordo idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idSoggetto == null) {
            throw new DriverRegistroServiziException("[getServizioCorrelatoByAccordo] Parametro Non Valido");
        }
        String nomeSoggetto = idSoggetto.getNome();
        String tipoSoggetto = idSoggetto.getTipo();
        if (nomeSoggetto == null || tipoSoggetto == null) {
            throw new DriverRegistroServiziException("[getServizioCorrelatoByAccordo] Parametri (Soggetto) Non Validi");
        }
        if (idAccordo == null || idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("[getServizioCorrelatoByAccordo] Parametri (Accordo) Non Valido");
        }
        ServizioSpcoop servRichiesto = null;
        String idSoggettoXML = tipoSoggetto + nomeSoggetto;
        String urlXMLIndexServizi = this.urlPrefix + idSoggettoXML + "/" + "servizi" + "/" + "servizi.index";
        String uriAccordo = IDAccordo.getUriFromIDAccordo(idAccordo);
        IDServizio[] lista = null;
        try {
            byte[] fileXML = null;
            try {
                fileXML = HttpUtilities.requestHTTPFile(urlXMLIndexServizi);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[getServizioCorrelatoByAccordo] Il soggetto [" + idSoggetto + "] non possiede un index dei servizi erogati");
                }
                throw e;
            }
            lista = XMLLib.mappingIndexServizi(new String(fileXML));
            if (lista == null) {
                throw new DriverRegistroServiziNotFound("[getServizioCorrelatoByAccordo] Il soggetto [" + idSoggetto + "] non possiede una lista di servizi erogati");
            }
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[getServizioCorrelatoByAccordo] Errore durante la get Servizi List Index: " + e.getMessage(), e);
        }
        String urlXMLServizio = null;
        String tipoServizio = null;
        String nomeServizio = null;
        try {
            for (int i = 0; i < lista.length; ++i) {
                if (!uriAccordo.equals(lista[i].getUriAccordo()) || !lista[i].isCorrelato() || !idSoggetto.getTipo().equals(lista[i].getSoggettoErogatore().getTipo()) || !idSoggetto.getNome().equals(lista[i].getSoggettoErogatore().getNome())) continue;
                urlXMLServizio = this.urlPrefix + idSoggettoXML + "/" + "servizi" + "/" + lista[i].getTipoServizio() + lista[i].getServizio() + ".xml";
                tipoServizio = lista[i].getTipoServizio();
                nomeServizio = lista[i].getServizio();
                break;
            }
            if (urlXMLServizio == null) {
                throw new DriverRegistroServiziNotFound("[getServizioCorrelatoByAccordo] Il soggetto [" + idSoggetto + "] non possiede un servizio correlato che implementa l'accordo con uri [" + uriAccordo + "]");
            }
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[getServizioCorrelatoByAccordo] Errore durante la ricerca: " + e.getMessage(), e);
        }
        ByteArrayInputStream bin = null;
        InputStreamReader istr = null;
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
            IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
            byte[] fileXML = null;
            try {
                fileXML = HttpUtilities.requestHTTPFile(urlXMLServizio);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[getServizioCorrelatoByAccordo] Il servizio [" + tipoServizio + "/" + nomeServizio + "] erogato dal soggetto [" + idSoggetto + "] non risulta gia' registrato nel registro");
                }
                throw e;
            }
            try {
                this.validatoreRegistro.valida(urlXMLServizio);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[getServizioCorrelatoByAccordo] Riscontrato errore durante la validazione XSD del Registro dei Servizi XML di OpenSPCoop: " + e.getMessage(), e);
            }
            bin = new ByteArrayInputStream(fileXML);
            istr = new InputStreamReader(bin);
            RegistroServizi rs = (RegistroServizi)uctx.unmarshalDocument((Reader)istr, null);
            if (rs.sizeSoggettoSpcoopList() > 0 && rs.getSoggettoSpcoop(0).sizeServizioCorrelatoList() > 0) {
                servRichiesto = rs.getSoggettoSpcoop(0).getServizioCorrelato(0);
                servRichiesto.setNomeSoggettoErogatore(idSoggetto.getNome());
                servRichiesto.setTipoSoggettoErogatore(idSoggetto.getTipo());
            }
            istr.close();
            bin.close();
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                if (istr != null) {
                    istr.close();
                }
            }
            catch (Exception eis) {
                // empty catch block
            }
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception eis) {
                // empty catch block
            }
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[getServizioCorrelatoByAccordo] Errore durante il parsing xml: " + e.getMessage(), e);
        }
        if (servRichiesto == null) {
            throw new DriverRegistroServiziNotFound("[getServizioCorrelatoByAccordo] Servizio non trovato.");
        }
        servRichiesto.setServizioCorrelato(true);
        return servRichiesto;
    }

    public IDServizio[] getAllIdServizi(FiltroServiziSPCoop filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAllIdServizi(false, filtroRicerca);
    }

    public IDServizio[] getAllIdServiziCorrelati(FiltroServiziSPCoop filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAllIdServizi(true, filtroRicerca);
    }

    private IDServizio[] getAllIdServizi(boolean serviziCorrelati, FiltroServiziSPCoop filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        String operazione = null;
        operazione = serviziCorrelati ? "getAllIdServiziCorrelati" : "getAllIdServizi";
        try {
            if (this.generatoreXML == null) {
                throw new DriverRegistroServiziException("[" + operazione + "] Gestore repository XML non istanziato. Necessario per l'implementazione di questo metodo.");
            }
            ServizioSpcoop[] servList = this.generatoreXML.getServizi(serviziCorrelati);
            if (servList == null && serviziCorrelati) {
                throw new DriverRegistroServiziNotFound("Servizi correlati non esistenti nel repository WEB");
            }
            if (servList == null) {
                throw new DriverRegistroServiziNotFound("Servizi non esistenti nel repository WEB");
            }
            Vector<IDServizio> idServizi = new Vector<IDServizio>();
            for (int i = 0; i < servList.length; ++i) {
                String idSoggettoXML = servList[i].getTipoSoggettoErogatore() + servList[i].getNomeSoggettoErogatore();
                String idServizioXML = servList[i].getTipo() + servList[i].getNome();
                String urlXMLServizio = this.urlPrefix + idSoggettoXML + "/" + "servizi" + "/" + idServizioXML + ".xml";
                try {
                    this.validatoreRegistro.valida(urlXMLServizio);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[" + operazione + "] Riscontrato errore durante la validazione XSD URL(" + urlXMLServizio + "): " + e.getMessage(), e);
                }
                if (filtroRicerca == null || filtroRicerca.getTipoSoggettoErogatore() != null && !servList[i].getTipoSoggettoErogatore().equals(filtroRicerca.getTipoSoggettoErogatore()) || filtroRicerca.getNomeSoggettoErogatore() != null && !servList[i].getNomeSoggettoErogatore().equals(filtroRicerca.getNomeSoggettoErogatore())) continue;
                if (filtroRicerca.getMinDate() != null) {
                    if (servList[i].getOraRegistrazione() == null) {
                        this.log.debug((Object)("[" + operazione + "](FiltroByMinDate) Servizio[" + servList[i].getTipo() + "/" + servList[i].getNome() + "] SoggettoErogatore[" + servList[i].getTipoSoggettoErogatore() + "/" + servList[i].getNomeSoggettoErogatore() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata."));
                        continue;
                    }
                    if (servList[i].getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                }
                if (filtroRicerca.getMaxDate() != null) {
                    if (servList[i].getOraRegistrazione() == null) {
                        this.log.debug((Object)("[" + operazione + "](FiltroByMaxDate) Servizio[" + servList[i].getTipo() + "/" + servList[i].getNome() + "] SoggettoErogatore[" + servList[i].getTipoSoggettoErogatore() + "/" + servList[i].getNomeSoggettoErogatore() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata."));
                        continue;
                    }
                    if (servList[i].getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                }
                if (filtroRicerca.getTipo() != null && !servList[i].getTipo().equals(filtroRicerca.getTipo()) || filtroRicerca.getNome() != null && !servList[i].getNome().equals(filtroRicerca.getNome())) continue;
                if (filtroRicerca.getIdAccordo() != null) {
                    String uriAccordo = IDAccordo.getUriFromIDAccordo(filtroRicerca.getIdAccordo());
                    if (!servList[i].getAccordoServizio().equals(uriAccordo)) continue;
                }
                IDServizio idServ = new IDServizio(servList[i].getTipoSoggettoErogatore(), servList[i].getNomeSoggettoErogatore(), servList[i].getTipo(), servList[i].getNome());
                idServ.setUriAccordo(servList[i].getAccordoServizio());
                idServ.setCorrelato(serviziCorrelati);
                idServizi.add(idServ);
            }
            if (idServizi.size() == 0) {
                throw new DriverRegistroServiziNotFound("Servizi non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            IDServizio[] res = new IDServizio[1];
            return idServizi.toArray(res);
        }
        catch (Exception e) {
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException(operazione + " error", e);
        }
    }

    public void createAccordoCooperazione(AccordoCooperazione accordoCooperazione) throws DriverRegistroServiziException {
        if (accordoCooperazione == null) {
            throw new DriverRegistroServiziException("[createAccordoCooperazione] Parametro Non Valido");
        }
        IDAccordoCooperazione idAccordo = null;
        try {
            idAccordo = IDAccordoCooperazione.getIDAccordoFromAccordo(accordoCooperazione);
            if (accordoCooperazione.getNome() == null) {
                throw new DriverRegistroServiziException("Accordo Cooperazione non completamente definito nei parametri obbligatori");
            }
            if (this.generatoreXML.existsAccordoCooperazione(idAccordo)) {
                throw new DriverRegistroServiziException("L'accordo di cooperazione [" + idAccordo.toString() + "] risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.createAccordoCooperazione(idAccordo, accordoCooperazione);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[createAccordoCooperazione] Errore generatosi durante la creazione di un nuovo accordo di cooperazione [" + idAccordo + "]: " + e.getMessage(), e);
        }
    }

    public boolean existsAccordoCooperazione(IDAccordoCooperazione idAccordo) throws DriverRegistroServiziException {
        if (idAccordo == null) {
            return false;
        }
        if (idAccordo.getNome() == null) {
            return false;
        }
        try {
            return this.generatoreXML.existsAccordoCooperazione(idAccordo);
        }
        catch (Exception e) {
            this.log.error((Object)("[existsAccordoCooperazione] Accordo non trovato: " + e.getMessage()));
            return false;
        }
    }

    public void updateAccordoCooperazione(AccordoCooperazione accordoCooperazione) throws DriverRegistroServiziException {
        if (accordoCooperazione == null) {
            throw new DriverRegistroServiziException("[updateAccordoCooperazione] Parametro Non Valido");
        }
        IDAccordoCooperazione idAccordoOLD = null;
        idAccordoOLD = accordoCooperazione.getOldIDAccordoForUpdate() != null ? accordoCooperazione.getOldIDAccordoForUpdate() : IDAccordoCooperazione.getIDAccordoFromAccordo(accordoCooperazione);
        try {
            if (idAccordoOLD == null) {
                throw new DriverRegistroServiziException("Accordo Cooperazione da modificare non definito");
            }
            if (accordoCooperazione.getNome() == null) {
                throw new DriverRegistroServiziException("Accordo Cooperazione modificato non completamente definito nei parametri obbligatori");
            }
            if (!this.generatoreXML.existsAccordoCooperazione(idAccordoOLD)) {
                throw new DriverRegistroServiziException("L'accordo di cooperazione [" + idAccordoOLD + "] non risulta gia' inserito nel registro dei servizi.");
            }
            IDAccordoCooperazione idAccordoNEW = IDAccordoCooperazione.getIDAccordoFromAccordo(accordoCooperazione);
            if (!idAccordoOLD.equals(idAccordoNEW) && this.generatoreXML.existsAccordoCooperazione(idAccordoNEW)) {
                throw new DriverRegistroServiziException("L'accordo di cooperazione [" + idAccordoNEW + "] risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.createAccordoCooperazione(idAccordoOLD, accordoCooperazione);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[updateAccordoCooperazione] Errore generatosi durante la modifica dell'accordo di cooperazione [" + idAccordoOLD + "]: " + e, e);
        }
    }

    public void deleteAccordoCooperazione(AccordoCooperazione accordoCooperazione) throws DriverRegistroServiziException {
        if (accordoCooperazione == null) {
            throw new DriverRegistroServiziException("[deleteAccordoCooperazione] Parametro Non Valido");
        }
        IDAccordoCooperazione idAccordo = null;
        try {
            idAccordo = IDAccordoCooperazione.getIDAccordoFromAccordo(accordoCooperazione);
            if (accordoCooperazione.getNome() == null) {
                throw new DriverRegistroServiziException("Accordo Cooperazione da eliminare non definito");
            }
            if (!this.generatoreXML.existsAccordoCooperazione(idAccordo)) {
                throw new DriverRegistroServiziException("L'accordo di cooperazione [" + idAccordo + "] non risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.deleteAccordoCooperazione(idAccordo);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[deleteAccordoCooperazione] Errore generatosi durante l'eliminazione dell'accordo di cooperazione [" + idAccordo + "]: " + e.getMessage(), e);
        }
    }

    public void createAccordoServizio(AccordoServizio accordoServizio) throws DriverRegistroServiziException {
        if (accordoServizio == null) {
            throw new DriverRegistroServiziException("[createAccordoServizio] Parametro Non Valido");
        }
        IDAccordo idAccordo = null;
        try {
            idAccordo = IDAccordo.getIDAccordoFromAccordo(accordoServizio);
            if (accordoServizio.getNome() == null || accordoServizio.getProfiloCollaborazione() == null) {
                throw new DriverRegistroServiziException("Accordo SPCoop non completamente definito nei parametri obbligatori");
            }
            if (this.generatoreXML.existsAccordoServizio(idAccordo)) {
                throw new DriverRegistroServiziException("L'accordo di servizio [" + idAccordo.toString() + "] risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.createAccordoServizio(idAccordo, accordoServizio);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[createAccordoServizio] Errore generatosi durante la creazione di un nuovo accordo di servizio [" + idAccordo + "]: " + e.getMessage(), e);
        }
    }

    public boolean existsAccordoServizio(IDAccordo idAccordo) throws DriverRegistroServiziException {
        if (idAccordo == null) {
            return false;
        }
        if (idAccordo.getNome() == null) {
            return false;
        }
        try {
            return this.generatoreXML.existsAccordoServizio(idAccordo);
        }
        catch (Exception e) {
            this.log.error((Object)("[existsAccordoServizio] Accordo non trovato: " + e.getMessage()));
            return false;
        }
    }

    public void updateAccordoServizio(AccordoServizio accordoServizio) throws DriverRegistroServiziException {
        if (accordoServizio == null) {
            throw new DriverRegistroServiziException("[updateAccordoServizio] Parametro Non Valido");
        }
        IDAccordo idAccordoOLD = null;
        idAccordoOLD = accordoServizio.getOldIDAccordoForUpdate() != null ? accordoServizio.getOldIDAccordoForUpdate() : IDAccordo.getIDAccordoFromAccordo(accordoServizio);
        try {
            if (idAccordoOLD == null) {
                throw new DriverRegistroServiziException("Accordo SPCoop da modificare non definito");
            }
            if (accordoServizio.getNome() == null || accordoServizio.getProfiloCollaborazione() == null) {
                throw new DriverRegistroServiziException("Accordo SPCoop modificato non completamente definito nei parametri obbligatori");
            }
            if (!this.generatoreXML.existsAccordoServizio(idAccordoOLD)) {
                throw new DriverRegistroServiziException("L'accordo di servizio [" + idAccordoOLD + "] non risulta gia' inserito nel registro dei servizi.");
            }
            IDAccordo idAccordoNEW = IDAccordo.getIDAccordoFromAccordo(accordoServizio);
            if (!idAccordoOLD.equals(idAccordoNEW) && this.generatoreXML.existsAccordoServizio(idAccordoNEW)) {
                throw new DriverRegistroServiziException("L'accordo di servizio [" + idAccordoNEW + "] risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.createAccordoServizio(idAccordoOLD, accordoServizio);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[updateAccordoServizio] Errore generatosi durante la modifica dell'accordo di servizio [" + idAccordoOLD + "]: " + e, e);
        }
    }

    public void deleteAccordoServizio(AccordoServizio accordoServizio) throws DriverRegistroServiziException {
        if (accordoServizio == null) {
            throw new DriverRegistroServiziException("[deleteAccordoServizio] Parametro Non Valido");
        }
        IDAccordo idAccordo = null;
        try {
            idAccordo = IDAccordo.getIDAccordoFromAccordo(accordoServizio);
            if (accordoServizio.getNome() == null) {
                throw new DriverRegistroServiziException("Accordo SPCoop da eliminare non definito");
            }
            if (!this.generatoreXML.existsAccordoServizio(idAccordo)) {
                throw new DriverRegistroServiziException("L'accordo di servizio [" + idAccordo + "] non risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.deleteAccordoServizio(idAccordo);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[deleteAccordoServizio] Errore generatosi durante l'eliminazione dell'accordo di servizio [" + idAccordo + "]: " + e.getMessage(), e);
        }
    }

    public void createPortaDominio(PortaDominio pdd) throws DriverRegistroServiziException {
        if (pdd == null) {
            throw new DriverRegistroServiziException("[createPortaDominio] Parametro Non Valido");
        }
        try {
            if (pdd.getNome() == null) {
                throw new DriverRegistroServiziException("Porta di dominio non completamente definita nei parametri obbligatori");
            }
            if (this.generatoreXML.existsPortaDominio(pdd.getNome())) {
                throw new DriverRegistroServiziException("La porta di dominio [" + pdd.getNome() + "] risulta gia' inserita nel registro dei servizi.");
            }
            this.generatoreXML.createPortaDominio(pdd.getNome(), pdd);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[createPortaDominio] Errore generatosi durante la creazione di una nuova porta di dominio [" + pdd.getNome() + "]: " + e.getMessage(), e);
        }
    }

    public boolean existsPortaDominio(String nome) throws DriverRegistroServiziException {
        if (nome == null) {
            return false;
        }
        try {
            return this.generatoreXML.existsPortaDominio(nome);
        }
        catch (Exception e) {
            this.log.error((Object)("[existsPortaDominio] Porta di dominio non trovata: " + e.getMessage()));
            return false;
        }
    }

    public void updatePortaDominio(PortaDominio pdd) throws DriverRegistroServiziException {
        if (pdd == null) {
            throw new DriverRegistroServiziException("[updatePortaDominio] Parametro Non Valido");
        }
        String pddOLD = null;
        pddOLD = pdd.getNome();
        try {
            if (pddOLD == null) {
                throw new DriverRegistroServiziException("Porta di dominio da modificare non definita");
            }
            if (pdd.getNome() == null) {
                throw new DriverRegistroServiziException("Porta di dominio modificata non completamente definita nei parametri obbligatori");
            }
            if (!this.generatoreXML.existsPortaDominio(pddOLD)) {
                throw new DriverRegistroServiziException("La porta di dominio [" + pddOLD + "] non risulta gia' inserita nel registro dei servizi.");
            }
            String pddNEW = pdd.getNome();
            if (!pddOLD.equals(pddNEW) && this.generatoreXML.existsPortaDominio(pddNEW)) {
                throw new DriverRegistroServiziException("La porta di dominio [" + pddNEW + "] risulta gia' inserita nel registro dei servizi.");
            }
            this.generatoreXML.createPortaDominio(pddOLD, pdd);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[updatePortaDominio] Errore generatosi durante la modifica della porta di dominio [" + pddOLD + "]: " + e, e);
        }
    }

    public void deletePortaDominio(PortaDominio pdd) throws DriverRegistroServiziException {
        if (pdd == null) {
            throw new DriverRegistroServiziException("[deletePortaDominio] Parametro Non Valido");
        }
        try {
            if (pdd.getNome() == null) {
                throw new DriverRegistroServiziException("Porta di dominio da eliminare non definita");
            }
            if (!this.generatoreXML.existsPortaDominio(pdd.getNome())) {
                throw new DriverRegistroServiziException("La porta di dominio [" + pdd.getNome() + "] non risulta gia' inserita nel registro dei servizi.");
            }
            this.generatoreXML.deletePortaDominio(pdd.getNome());
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[deletePortaDominio] Errore generatosi durante l'eliminazione della porta di dominio [" + pdd.getNome() + "]: " + e.getMessage(), e);
        }
    }

    public void createSoggetto(SoggettoSpcoop soggetto) throws DriverRegistroServiziException {
        if (soggetto == null) {
            throw new DriverRegistroServiziException("[createSoggetto] Parametro Non Valido");
        }
        try {
            if (soggetto.getNome() == null || soggetto.getTipo() == null) {
                throw new DriverRegistroServiziException("Soggetto SPCoop non definito");
            }
            if (soggetto.getConnettore() != null && !"disabilitato".equals(soggetto.getConnettore().getTipo())) {
                boolean connettoreNonDefinito = false;
                if (soggetto.getConnettore().getTipo() == null) {
                    connettoreNonDefinito = true;
                }
                if (connettoreNonDefinito) {
                    throw new DriverRegistroServiziException("Definizione del punto di accesso del dominio del soggetto non corretta");
                }
            }
            if (soggetto.getIdentificativoPorta() == null || "".equals(soggetto.getIdentificativoPorta())) {
                soggetto.setIdentificativoPorta(soggetto.getNome() + "SPCoopIT");
            }
            if (soggetto.getDescrizione() == null || "".equals(soggetto.getDescrizione())) {
                soggetto.setDescrizione("Soggetto SPCoop " + soggetto.getTipo() + "/" + soggetto.getNome());
            }
            IDSoggetto idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome(), soggetto.getIdentificativoPorta());
            if (soggetto.getCodiceIpa() == null || "".equals(soggetto.getCodiceIpa())) {
                soggetto.setCodiceIpa(SICAtoOpenSPCoopUtilities.buildIDSoggettoSica(idSoggetto, false));
            }
            String idSoggetto_string = soggetto.getTipo() + soggetto.getNome();
            if (this.generatoreXML.existsSoggetto(idSoggetto)) {
                throw new DriverRegistroServiziException("Il soggetto [" + idSoggetto_string + "] risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.createSoggetto(idSoggetto, soggetto);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[createSoggetto] Errore generatosi durante la creazione del nuovo Soggetto [" + soggetto.getTipo() + soggetto.getNome() + "]: " + e.getMessage(), e);
        }
    }

    public boolean existsSoggetto(IDSoggetto idSoggetto) throws DriverRegistroServiziException {
        if (idSoggetto == null) {
            return false;
        }
        try {
            return this.generatoreXML.existsSoggetto(idSoggetto);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void updateSoggetto(SoggettoSpcoop soggetto) throws DriverRegistroServiziException {
        if (soggetto == null) {
            throw new DriverRegistroServiziException("[updateSoggetto] Parametro Non Valido");
        }
        String tipoOLD = soggetto.getOldTipoForUpdate();
        String nomeOLD = soggetto.getOldNomeForUpdate();
        if (tipoOLD == null || nomeOLD == null) {
            tipoOLD = soggetto.getTipo();
            nomeOLD = soggetto.getNome();
        }
        String idSoggettoOLD_string = tipoOLD + nomeOLD;
        IDSoggetto idSoggettoOLD = new IDSoggetto(tipoOLD, nomeOLD);
        try {
            if (tipoOLD == null || nomeOLD == null) {
                throw new DriverRegistroServiziException("Soggetto SPCoop da modificare non definito");
            }
            if (soggetto.getNome() == null || soggetto.getTipo() == null) {
                throw new DriverRegistroServiziException("Soggetto SPCoop modificato non definito");
            }
            if (soggetto.getConnettore() != null && !"disabilitato".equals(soggetto.getConnettore().getTipo())) {
                boolean connettoreNonDefinito = false;
                if (soggetto.getConnettore().getTipo() == null) {
                    connettoreNonDefinito = true;
                }
                if (connettoreNonDefinito) {
                    throw new DriverRegistroServiziException("Definizione del punto di accesso del dominio del soggetto non corretta");
                }
            }
            if (soggetto.getIdentificativoPorta() == null || "".equals(soggetto.getIdentificativoPorta())) {
                soggetto.setIdentificativoPorta(soggetto.getNome() + "SPCoopIT");
            }
            if (soggetto.getDescrizione() == null || "".equals(soggetto.getDescrizione())) {
                soggetto.setDescrizione("Soggetto SPCoop " + soggetto.getTipo() + "/" + soggetto.getNome());
            }
            IDSoggetto idSoggettoNEW = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
            if (soggetto.getCodiceIpa() == null || "".equals(soggetto.getCodiceIpa())) {
                soggetto.setCodiceIpa(SICAtoOpenSPCoopUtilities.buildIDSoggettoSica(idSoggettoNEW, false));
            }
            if (!this.generatoreXML.existsSoggetto(idSoggettoOLD)) {
                throw new DriverRegistroServiziException("Il soggetto [" + idSoggettoOLD_string + "] non risulta gia' inserito nel registro dei servizi.");
            }
            String idSoggettoNEW_string = soggetto.getTipo() + soggetto.getNome();
            if (!idSoggettoOLD_string.equals(idSoggettoNEW_string) && this.generatoreXML.existsSoggetto(idSoggettoNEW)) {
                throw new DriverRegistroServiziException("La nuova identita da associare al soggetto [" + idSoggettoNEW_string + "] risulta gia' utilizzata nel registro dei servizi.");
            }
            this.generatoreXML.createSoggetto(idSoggettoOLD, soggetto);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[updateSoggetto] Errore generatosi durante la modifica del Soggetto [" + idSoggettoOLD + "]: " + e.getMessage(), e);
        }
    }

    public void deleteSoggetto(SoggettoSpcoop soggetto) throws DriverRegistroServiziException {
        if (soggetto == null) {
            throw new DriverRegistroServiziException("[deleteSoggetto] Parametro Non Valido");
        }
        try {
            if (soggetto.getTipo() == null || soggetto.getNome() == null) {
                throw new DriverRegistroServiziException("Soggetto SPCoop da eliminare non definito");
            }
            IDSoggetto idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
            if (!this.generatoreXML.existsSoggetto(idSoggetto)) {
                throw new DriverRegistroServiziException("Il soggetto [" + idSoggetto + "] non risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.deleteSoggetto(idSoggetto);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[deleteSoggetto] Errore generatosi durante l'eliminazione del Soggetto [" + soggetto.getTipo() + soggetto.getNome() + "]: " + e.getMessage(), e);
        }
    }

    public void createServizioSpcoop(ServizioSpcoop servizio) throws DriverRegistroServiziException {
        servizio.setServizioCorrelato(false);
        this.createServizio_engine(servizio);
    }

    public boolean existsServizioSpcoop(IDServizio idServizio) throws DriverRegistroServiziException {
        return this.existsServizio_engine(idServizio, false);
    }

    public void updateServizioSpcoop(ServizioSpcoop servizio) throws DriverRegistroServiziException {
        servizio.setServizioCorrelato(false);
        this.updateServizio_engine(servizio);
    }

    public void deleteServizioSpcoop(ServizioSpcoop servizio) throws DriverRegistroServiziException {
        servizio.setServizioCorrelato(false);
        this.deleteServizio_engine(servizio);
    }

    public void createServizioSpcoopCorrelato(ServizioSpcoop servizioCorrelato) throws DriverRegistroServiziException {
        servizioCorrelato.setServizioCorrelato(true);
        this.createServizio_engine(servizioCorrelato);
    }

    public boolean existsServizioSpcoopCorrelato(IDServizio idServizio) throws DriverRegistroServiziException {
        return this.existsServizio_engine(idServizio, true);
    }

    public void updateServizioSpcoopCorrelato(ServizioSpcoop servizioCorrelato) throws DriverRegistroServiziException {
        servizioCorrelato.setServizioCorrelato(true);
        this.updateServizio_engine(servizioCorrelato);
    }

    public void deleteServizioSpcoopCorrelato(ServizioSpcoop servizioCorrelato) throws DriverRegistroServiziException {
        servizioCorrelato.setServizioCorrelato(true);
        this.deleteServizio_engine(servizioCorrelato);
    }

    private void createServizio_engine(ServizioSpcoop servizio) throws DriverRegistroServiziException {
        String method = "createServizio";
        if (servizio == null) {
            throw new DriverRegistroServiziException("[createServizio_engine] Parametro Non Valido");
        }
        if (servizio.getServizioCorrelato()) {
            method = method + "Correlato";
        }
        try {
            int i;
            if (servizio.getNomeSoggettoErogatore() == null || servizio.getTipoSoggettoErogatore() == null) {
                throw new DriverRegistroServiziException("Soggetto SPCoop, erogatore del servizio, non definito");
            }
            if (servizio.getNome() == null || servizio.getTipo() == null) {
                throw new DriverRegistroServiziException("Servizio SPCoop, non definito");
            }
            if (servizio.getAccordoServizio() == null) {
                throw new DriverRegistroServiziException("Accordo di Servizio, da associare al servizio, non definito");
            }
            if (servizio.getConnettore() != null && !"disabilitato".equals(servizio.getConnettore().getTipo())) {
                boolean connettoreNonDefinito = false;
                if (servizio.getConnettore().getTipo() == null) {
                    connettoreNonDefinito = true;
                }
                if (connettoreNonDefinito) {
                    throw new DriverRegistroServiziException("Definizione del punto di accesso del dominio del servizio non corretta");
                }
            }
            for (i = 0; i < servizio.sizeFruitoreList(); ++i) {
                Fruitore checkFr = servizio.getFruitore(i);
                if (checkFr.getNome() == null || checkFr.getTipo() == null) {
                    throw new DriverRegistroServiziException("Definizione di un fruitore senza nome o tipo");
                }
                String idSoggettoFruitore_string = checkFr.getTipo() + checkFr.getNome();
                IDSoggetto idSoggettoFruitore = new IDSoggetto(checkFr.getTipo(), checkFr.getNome());
                if (this.generatoreXML.existsSoggetto(idSoggettoFruitore)) continue;
                throw new DriverRegistroServiziException("Il fruitore [" + idSoggettoFruitore_string + "] non risulta gia' inserito nel registro dei servizi.");
            }
            for (i = 0; i < servizio.sizeAzioneList(); ++i) {
                ServizioSpcoopAzione checkAz = servizio.getAzione(i);
                if (checkAz.getNome() == null || checkAz.getConnettore() == null) {
                    throw new DriverRegistroServiziException("Definizione di un azione senza nome o connettore");
                }
                if (checkAz.getConnettore() != null && !"disabilitato".equals(checkAz.getConnettore().getTipo())) {
                    boolean connettoreNonDefinito = false;
                    if (checkAz.getConnettore().getTipo() == null) {
                        connettoreNonDefinito = true;
                    }
                    if (connettoreNonDefinito) {
                        throw new DriverRegistroServiziException("Definizione del punto di accesso dell'azione " + checkAz.getNome() + " del servizio non corretta");
                    }
                }
                for (int j = 0; j < checkAz.sizeFruitoreList(); ++j) {
                    ServizioSpcoopAzioneFruitore checkAzFr = checkAz.getFruitore(j);
                    if (checkAzFr.getNome() == null || checkAzFr.getTipo() == null || checkAzFr.getConnettore() == null) {
                        throw new DriverRegistroServiziException("Definizione di un fruitore di una azione senza nome o connettore");
                    }
                    if (checkAzFr.getConnettore() == null || "disabilitato".equals(checkAzFr.getConnettore().getTipo())) continue;
                    boolean connettoreNonDefinito = false;
                    if (checkAzFr.getConnettore().getTipo() == null) {
                        connettoreNonDefinito = true;
                    }
                    if (!connettoreNonDefinito) continue;
                    throw new DriverRegistroServiziException("Definizione del punto di accesso del fruitore " + checkAzFr.getTipo() + checkAzFr.getNome() + " dell'azione " + checkAz.getNome() + " del servizio non corretta");
                }
            }
            IDSoggetto idSoggettoErogatore = new IDSoggetto(servizio.getTipoSoggettoErogatore(), servizio.getNomeSoggettoErogatore());
            String idSoggettoErogatore_string = servizio.getTipoSoggettoErogatore() + servizio.getNomeSoggettoErogatore();
            if (!this.generatoreXML.existsSoggetto(idSoggettoErogatore)) {
                throw new DriverRegistroServiziException("Il soggetto [" + idSoggettoErogatore_string + "] non risulta gia' inserito nel registro dei servizi.");
            }
            String idServizio_string = servizio.getTipo() + servizio.getNome();
            IDServizio idServizio = new IDServizio(idSoggettoErogatore, servizio.getTipo(), servizio.getNome());
            if (this.generatoreXML.existsServizio(idServizio)) {
                throw new DriverRegistroServiziException("Il servizio [" + idServizio_string + "] erogato dal soggetto [" + idSoggettoErogatore_string + "] risulta gia' registrato nel registro");
            }
            this.generatoreXML.createServizio(idServizio, servizio);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[" + method + "] Errore generatosi durante la creazione del nuovo Servizio [" + servizio.getTipo() + servizio.getNome() + "] erogato dal soggetto [" + servizio.getTipoSoggettoErogatore() + servizio.getNomeSoggettoErogatore() + "]: " + e.getMessage(), e);
        }
    }

    private boolean existsServizio_engine(IDServizio idServizio, boolean isServizioCorrelato) {
        String method = "existsServizio";
        if (isServizioCorrelato) {
            method = method + "Correlato";
        }
        if (idServizio == null) {
            return false;
        }
        try {
            if (isServizioCorrelato) {
                this.getServizioCorrelato(idServizio);
            } else {
                this.getServizio(idServizio);
            }
            return true;
        }
        catch (DriverRegistroServiziNotFound notFound) {
            return false;
        }
        catch (Exception e) {
            this.log.error((Object)("[" + method + "] Servizio non trovato: " + e.getMessage()));
            return false;
        }
    }

    private void updateServizio_engine(ServizioSpcoop servizio) throws DriverRegistroServiziException {
        String method = "updateServizio";
        if (servizio == null) {
            throw new DriverRegistroServiziException("[updateServizio_engine] Parametro Non Valido");
        }
        if (servizio.getServizioCorrelato()) {
            method = method + "Correlato";
        }
        String tipoServizioOLD = servizio.getOldTipoForUpdate();
        String nomeServizioOLD = servizio.getOldNomeForUpdate();
        if (tipoServizioOLD == null || nomeServizioOLD == null) {
            tipoServizioOLD = servizio.getTipo();
            nomeServizioOLD = servizio.getNome();
        }
        String tipoSoggettoOLD = servizio.getOldTipoSoggettoErogatoreForUpdate();
        String nomeSoggettoOLD = servizio.getOldNomeSoggettoErogatoreForUpdate();
        if (tipoSoggettoOLD == null || nomeSoggettoOLD == null) {
            tipoSoggettoOLD = servizio.getTipoSoggettoErogatore();
            nomeSoggettoOLD = servizio.getNomeSoggettoErogatore();
        }
        String idSoggettoOLD_string = tipoSoggettoOLD + nomeSoggettoOLD;
        IDSoggetto idSoggettoOLD = new IDSoggetto(tipoSoggettoOLD, nomeSoggettoOLD);
        String idServizioOLD_string = tipoServizioOLD + nomeServizioOLD;
        IDServizio idServizioOLD = new IDServizio(idSoggettoOLD, tipoServizioOLD, nomeServizioOLD);
        try {
            int i;
            if (tipoSoggettoOLD == null || nomeSoggettoOLD == null) {
                throw new DriverRegistroServiziException("Soggetto SPCoop da modificare, erogatore del servizio, non definito");
            }
            if (servizio.getTipoSoggettoErogatore() == null || servizio.getNomeSoggettoErogatore() == null) {
                throw new DriverRegistroServiziException("Soggetto SPCoop, erogatore del servizio, non definito");
            }
            if (tipoServizioOLD == null || nomeServizioOLD == null) {
                throw new DriverRegistroServiziException("Servizio da modificare non definito");
            }
            if (servizio.getNome() == null || servizio.getTipo() == null) {
                throw new DriverRegistroServiziException("Dati del nuovo servizio SPCoop, non definiti");
            }
            if (servizio.getAccordoServizio() == null) {
                throw new DriverRegistroServiziException("Accordo di Servizio, da associare al servizio, non definito");
            }
            if (servizio.getConnettore() != null && !"disabilitato".equals(servizio.getConnettore().getTipo())) {
                boolean connettoreNonDefinito = false;
                if (servizio.getConnettore().getTipo() == null) {
                    connettoreNonDefinito = true;
                }
                if (connettoreNonDefinito) {
                    throw new DriverRegistroServiziException("Definizione del punto di accesso del dominio del servizio non corretta");
                }
            }
            for (i = 0; i < servizio.sizeFruitoreList(); ++i) {
                Fruitore checkFr = servizio.getFruitore(i);
                if (checkFr.getNome() != null && checkFr.getTipo() != null) continue;
                throw new DriverRegistroServiziException("Definizione di un fruitore senza nome o tipo");
            }
            for (i = 0; i < servizio.sizeAzioneList(); ++i) {
                ServizioSpcoopAzione checkAz = servizio.getAzione(i);
                if (checkAz.getNome() == null || checkAz.getConnettore() == null) {
                    throw new DriverRegistroServiziException("Definizione di un fruitore senza nome o connettore");
                }
                if (checkAz.getConnettore() != null && !"disabilitato".equals(checkAz.getConnettore().getTipo())) {
                    boolean connettoreNonDefinito = false;
                    if (checkAz.getConnettore().getTipo() == null) {
                        connettoreNonDefinito = true;
                    }
                    if (connettoreNonDefinito) {
                        throw new DriverRegistroServiziException("Definizione del punto di accesso dell'azione " + checkAz.getNome() + " del servizio non corretta");
                    }
                }
                for (int j = 0; j < checkAz.sizeFruitoreList(); ++j) {
                    ServizioSpcoopAzioneFruitore checkAzFr = checkAz.getFruitore(j);
                    if (checkAzFr.getNome() == null || checkAzFr.getNome() == null || checkAzFr.getConnettore() == null) {
                        throw new DriverRegistroServiziException("Definizione di un fruitore di una azione senza nome/tipo o connettore");
                    }
                    if (checkAzFr.getConnettore() == null || "disabilitato".equals(checkAzFr.getConnettore().getTipo())) continue;
                    boolean connettoreNonDefinito = false;
                    if (checkAzFr.getConnettore().getTipo() == null) {
                        connettoreNonDefinito = true;
                    }
                    if (!connettoreNonDefinito) continue;
                    throw new DriverRegistroServiziException("Definizione del punto di accesso del fruitore " + checkAzFr.getTipo() + checkAzFr.getNome() + " dell'azione " + checkAz.getNome() + " del servizio non corretta");
                }
            }
            if (!this.generatoreXML.existsSoggetto(idSoggettoOLD)) {
                throw new DriverRegistroServiziException("Il soggetto [" + idSoggettoOLD_string + "] da modificare, non risulta gia' inserito nel registro dei servizi.");
            }
            String idSoggettoNEW_string = servizio.getTipoSoggettoErogatore() + servizio.getNomeSoggettoErogatore();
            IDSoggetto idSoggettoNEW = new IDSoggetto(servizio.getTipoSoggettoErogatore(), servizio.getNomeSoggettoErogatore());
            if (!idSoggettoOLD_string.equals(idSoggettoNEW_string) && !this.generatoreXML.existsSoggetto(idSoggettoNEW)) {
                throw new DriverRegistroServiziException("Il soggetto [" + idSoggettoNEW_string + "] a cui re-assegnare il servizio, non risulta gia' inserito nel registro dei servizi.");
            }
            if (!this.generatoreXML.existsServizio(idServizioOLD)) {
                throw new DriverRegistroServiziException("Il servizio [" + idServizioOLD_string + "] erogato dal soggetto [" + idSoggettoOLD_string + "] non risulta gia' registrato nel registro");
            }
            IDServizio idServizioNEW = new IDServizio(idSoggettoNEW, servizio.getTipo(), servizio.getNome());
            String idServizioNEW_string = servizio.getTipo() + servizio.getNome();
            if (!(idServizioOLD_string.equals(idServizioNEW_string) && idSoggettoOLD_string.equals(idSoggettoNEW_string) || !this.generatoreXML.existsServizio(idServizioNEW))) {
                throw new DriverRegistroServiziException("Il servizio [" + idServizioNEW_string + "] erogato dal soggetto [" + idSoggettoNEW_string + "] risulta gia' registrato nel registro");
            }
            if (idSoggettoOLD_string.equals(idSoggettoNEW_string)) {
                this.generatoreXML.createServizio(idServizioOLD, servizio);
            } else {
                this.generatoreXML.deleteServizio(idServizioOLD);
                this.generatoreXML.createServizio(idServizioNEW, servizio);
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[" + method + "] Errore generatosi durante la modifica del Servizio [" + idServizioOLD_string + "] erogato dal soggetto [" + idSoggettoOLD_string + "]: " + e.getMessage(), e);
        }
    }

    private void deleteServizio_engine(ServizioSpcoop servizio) throws DriverRegistroServiziException {
        String method = "deleteServizio";
        if (servizio == null) {
            throw new DriverRegistroServiziException("[deleteServizio_engine] Parametro Non Valido");
        }
        if (servizio.getServizioCorrelato()) {
            method = method + "Correlato";
        }
        String idSoggetto_string = servizio.getTipoSoggettoErogatore() + servizio.getNomeSoggettoErogatore();
        String idServizio_string = servizio.getTipo() + servizio.getNome();
        try {
            if (servizio.getTipoSoggettoErogatore() == null || servizio.getNomeSoggettoErogatore() == null) {
                throw new DriverRegistroServiziException("Soggetto SPCoop non definito");
            }
            if (servizio.getTipo() == null || servizio.getNome() == null) {
                throw new DriverRegistroServiziException("Servizio SPCoop da eliminare non definito");
            }
            IDSoggetto idSoggetto = new IDSoggetto(servizio.getTipoSoggettoErogatore(), servizio.getNomeSoggettoErogatore());
            if (!this.generatoreXML.existsSoggetto(idSoggetto)) {
                throw new DriverRegistroServiziException("Il soggetto [" + idSoggetto_string + "] non risulta gia' inserito nel registro dei servizi.");
            }
            IDServizio idServizio = new IDServizio(idSoggetto, servizio.getTipo(), servizio.getNome());
            if (!this.generatoreXML.existsServizio(idServizio)) {
                throw new DriverRegistroServiziException("Il servizio [" + idServizio_string + "] erogato dal soggetto [" + idSoggetto_string + "] non risulta gia' registrato nel registro");
            }
            this.generatoreXML.deleteServizio(idServizio);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[" + method + "] Errore generatosi durante l'eliminazione del Servizio [" + idServizio_string + "] erogato dal soggetto [" + idSoggetto_string + "]: " + e.getMessage(), e);
        }
    }

    public void reset() throws DriverRegistroServiziException {
        ServizioSpcoop[] serviziRegistrati;
        int i;
        try {
            AccordoServizio[] accordiRegistrati = this.generatoreXML.getAccordiServizio();
            if (accordiRegistrati != null) {
                for (i = 0; i < accordiRegistrati.length; ++i) {
                    this.log.info((Object)("eliminazione accordo di servizio [" + IDAccordo.getUriFromAccordo(accordiRegistrati[i]) + "] in corso..."));
                    this.deleteAccordoServizio(accordiRegistrati[i]);
                    this.log.info((Object)("eliminazione accordo di servizio [" + IDAccordo.getUriFromAccordo(accordiRegistrati[i]) + "] effettuata."));
                }
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante la cancellazione degli accordi registrati: " + e.getMessage(), e);
        }
        try {
            AccordoCooperazione[] accordiCooperazioneRegistrati = this.generatoreXML.getAccordiCooperazione();
            if (accordiCooperazioneRegistrati != null) {
                for (i = 0; i < accordiCooperazioneRegistrati.length; ++i) {
                    this.log.info((Object)("eliminazione accordo di cooperazione [" + IDAccordoCooperazione.getUriFromAccordo(accordiCooperazioneRegistrati[i]) + "] in corso..."));
                    this.deleteAccordoCooperazione(accordiCooperazioneRegistrati[i]);
                    this.log.info((Object)("eliminazione accordo di cooperazione [" + IDAccordoCooperazione.getUriFromAccordo(accordiCooperazioneRegistrati[i]) + "] effettuata."));
                }
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante la cancellazione degli accordi di cooperazione registrati: " + e.getMessage(), e);
        }
        try {
            serviziRegistrati = this.generatoreXML.getServizi(false);
            if (serviziRegistrati != null) {
                for (i = 0; i < serviziRegistrati.length; ++i) {
                    this.log.info((Object)("eliminazione servizio [" + serviziRegistrati[i].getTipo() + "/" + serviziRegistrati[i].getNome() + "] erogato da [" + serviziRegistrati[i].getTipoSoggettoErogatore() + "/" + serviziRegistrati[i].getNomeSoggettoErogatore() + "] in corso..."));
                    this.deleteServizioSpcoop(serviziRegistrati[i]);
                    this.log.info((Object)("eliminazione servizio [" + serviziRegistrati[i].getTipo() + "/" + serviziRegistrati[i].getNome() + "] erogato da [" + serviziRegistrati[i].getTipoSoggettoErogatore() + "/" + serviziRegistrati[i].getNomeSoggettoErogatore() + "] effettuata."));
                }
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante la cancellazione dei servizi registrati: " + e.getMessage(), e);
        }
        try {
            serviziRegistrati = this.generatoreXML.getServizi(true);
            if (serviziRegistrati != null) {
                for (i = 0; i < serviziRegistrati.length; ++i) {
                    this.log.info((Object)("eliminazione servizio correlato [" + serviziRegistrati[i].getTipo() + "/" + serviziRegistrati[i].getNome() + "] erogato da [" + serviziRegistrati[i].getTipoSoggettoErogatore() + "/" + serviziRegistrati[i].getNomeSoggettoErogatore() + "] in corso..."));
                    this.deleteServizioSpcoopCorrelato(serviziRegistrati[i]);
                    this.log.info((Object)("eliminazione servizio correlato [" + serviziRegistrati[i].getTipo() + "/" + serviziRegistrati[i].getNome() + "] erogato da [" + serviziRegistrati[i].getTipoSoggettoErogatore() + "/" + serviziRegistrati[i].getNomeSoggettoErogatore() + "] effettuata."));
                }
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante la cancellazione dei servizi registrati: " + e.getMessage(), e);
        }
        try {
            SoggettoSpcoop[] soggettiRegistrati = this.generatoreXML.getSoggetti();
            if (soggettiRegistrati != null) {
                for (i = 0; i < soggettiRegistrati.length; ++i) {
                    this.log.info((Object)("eliminazione soggetto [" + soggettiRegistrati[i].getTipo() + "/" + soggettiRegistrati[i].getNome() + "] in corso..."));
                    this.deleteSoggetto(soggettiRegistrati[i]);
                    this.log.info((Object)("eliminazione soggetto [" + soggettiRegistrati[i].getTipo() + "/" + soggettiRegistrati[i].getNome() + "] effettuata."));
                }
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante la cancellazione dei soggetti registrati: " + e.getMessage(), e);
        }
        try {
            PortaDominio[] pddRegistrate = this.generatoreXML.getPorteDominio();
            if (pddRegistrate != null) {
                for (i = 0; i < pddRegistrate.length; ++i) {
                    this.log.info((Object)("eliminazione porta di dominio [" + pddRegistrate[i].getNome() + "] in corso..."));
                    this.deletePortaDominio(pddRegistrate[i]);
                    this.log.info((Object)("eliminazione porta di dominio [" + pddRegistrate[i].getNome() + "] effettuata."));
                }
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante la cancellazione delle porte di dominio registrate: " + e.getMessage(), e);
        }
    }

    public void resetCtrlstat() throws DriverRegistroServiziException {
    }

    public void isAlive() throws DriverException {
        if (!this.create) {
            throw new DriverException("Driver non inizializzato");
        }
        String urlVerifica = this.urlPrefix + "/";
        try {
            byte[] dir = HttpUtilities.requestHTTPFile(urlVerifica);
            if (dir == null) {
                throw new Exception("Directory accordi richiesta non ritornata");
            }
        }
        catch (Exception e) {
            throw new DriverException("Connessione al registro non disponibile [" + urlVerifica + "]: " + e.getMessage(), e);
        }
    }
}

