/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.dao.registry.driver;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.DBUtils;
import org.openspcoop.dao.commons.DriverException;
import org.openspcoop.dao.commons.ErrorsHandlerCostant;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.commons.IDriverWS;
import org.openspcoop.dao.commons.IMonitoraggioRisorsa;
import org.openspcoop.dao.commons.ISearch;
import org.openspcoop.dao.commons.TipiConnettore;
import org.openspcoop.dao.config.driver.IDPortaDelegata;
import org.openspcoop.dao.registry.AccordoCooperazione;
import org.openspcoop.dao.registry.AccordoCooperazioneElencoPartecipantiSoggetto;
import org.openspcoop.dao.registry.AccordoCooperazioneSoggettoReferente;
import org.openspcoop.dao.registry.AccordoServizio;
import org.openspcoop.dao.registry.AccordoServizioServizioComposto;
import org.openspcoop.dao.registry.AccordoServizioServizioCompostoServizioComponente;
import org.openspcoop.dao.registry.AccordoServizioSoggettoReferente;
import org.openspcoop.dao.registry.Azione;
import org.openspcoop.dao.registry.Connettore;
import org.openspcoop.dao.registry.ConnettoreProperty;
import org.openspcoop.dao.registry.Documento;
import org.openspcoop.dao.registry.Fruitore;
import org.openspcoop.dao.registry.Message;
import org.openspcoop.dao.registry.MessagePart;
import org.openspcoop.dao.registry.Operation;
import org.openspcoop.dao.registry.PortType;
import org.openspcoop.dao.registry.PortaDominio;
import org.openspcoop.dao.registry.ServizioSpcoop;
import org.openspcoop.dao.registry.ServizioSpcoopAccordoParteSpecifica;
import org.openspcoop.dao.registry.ServizioSpcoopAzione;
import org.openspcoop.dao.registry.SoggettoSpcoop;
import org.openspcoop.dao.registry.driver.BeanUtilities;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziDB_LIB;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziException;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop.dao.registry.driver.FiltroAccordiSPCoop;
import org.openspcoop.dao.registry.driver.FiltroSPCoop;
import org.openspcoop.dao.registry.driver.FiltroServiziSPCoop;
import org.openspcoop.dao.registry.driver.IDAccordo;
import org.openspcoop.dao.registry.driver.IDAccordoCooperazione;
import org.openspcoop.dao.registry.driver.IDPortType;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.dao.registry.driver.IDriverRegistroServiziCRUD;
import org.openspcoop.dao.registry.driver.IDriverRegistroServiziGet;
import org.openspcoop.dao.registry.driver.IDriverRegistroServiziSearch;
import org.openspcoop.dao.registry.driver.IDriverRegistroServiziUtils;
import org.openspcoop.dao.registry.driver.ProprietariDocumento;
import org.openspcoop.dao.registry.driver.RuoliDocumento;
import org.openspcoop.dao.registry.driver.StatiAccordo;
import org.openspcoop.dao.registry.driver.ValidazioneStatoPackageException;
import org.openspcoop.utils.Utilities;
import org.openspcoop.utils.sql.ISQLQueryObject;
import org.openspcoop.utils.sql.SQLObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverRegistroServiziDB
extends BeanUtilities
implements IDriverRegistroServiziGet,
IDriverRegistroServiziCRUD,
IDriverRegistroServiziSearch,
IDriverWS,
IDriverRegistroServiziUtils,
IMonitoraggioRisorsa {
    public boolean create = false;
    public DataSource datasource = null;
    private Connection globalConnection = null;
    private boolean atomica = true;
    String tabellaSoggetti = "soggetti";
    private Logger log = null;
    private String tipoDB = null;

    public DriverRegistroServiziDB(String nomeDataSource, Properties prop, String tipoDB) {
        this(nomeDataSource, prop, null, tipoDB);
    }

    public DriverRegistroServiziDB(String nomeDataSource, Properties prop, Logger alog, String tipoDB) {
        try {
            if (alog == null) {
                this.log = Logger.getLogger((String)"DRIVER_DB_REGISTRO");
            } else {
                this.log = alog;
                DriverRegistroServiziDB_LIB.initStaticLogger(this.log);
            }
            this.log.info((Object)"Inizializzo DriverRegistroServiziDB..");
            InitialContext initCtx = new InitialContext(prop);
            this.datasource = (DataSource)initCtx.lookup(nomeDataSource);
            if (this.datasource != null) {
                this.create = true;
            }
            initCtx.close();
        }
        catch (NamingException ne) {
            this.log.error((Object)("Eccezione acquisendo il datasource: " + ne.getMessage()), (Throwable)ne);
            this.create = false;
        }
        if (tipoDB == null) {
            this.log.error((Object)"Il tipoDatabase non puo essere null.");
            this.create = false;
        }
        this.atomica = true;
        this.tipoDB = tipoDB;
        DriverRegistroServiziDB_LIB.setTipoDB(tipoDB);
    }

    public DriverRegistroServiziDB(Connection connection, String tipoDB) throws DriverRegistroServiziException {
        this(connection, null, tipoDB);
    }

    public DriverRegistroServiziDB(Connection connection, Logger alog, String tipoDB) throws DriverRegistroServiziException {
        if (alog == null) {
            this.log = Logger.getLogger((String)"DRIVER_DB_REGISTRO");
        } else {
            this.log = alog;
            DriverRegistroServiziDB_LIB.initStaticLogger(this.log);
        }
        if (connection == null) {
            this.create = false;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::DriverRegistroServiziDB(Connection ) La connection non puo essere null.");
        }
        if (tipoDB == null) {
            this.create = false;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::DriverRegistroServiziDB(Connection ) Il tipoDatabase non puo essere null.");
        }
        this.globalConnection = connection;
        this.create = true;
        this.atomica = false;
        this.tipoDB = tipoDB;
        DriverRegistroServiziDB_LIB.setTipoDB(tipoDB);
    }

    @Override
    public AccordoCooperazione getAccordoCooperazione(IDAccordoCooperazione idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoCooperazione(idAccordo, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public AccordoCooperazione getAccordoCooperazione(IDAccordoCooperazione idAccordo, boolean readContenutoAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idAccordo == null) {
            throw new DriverRegistroServiziException("[getAccordoCooperazione] Parametro idAccordo is null");
        }
        if (idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("[getAccordoCooperazione] Parametro idAccordo.getNome is null");
        }
        if (idAccordo.getNome().trim().equals("")) {
            throw new DriverRegistroServiziException("[getAccordoCooperazione] Parametro idAccordo.getNome non e' definito");
        }
        this.log.debug((Object)("richiesto getAccordoCooperazione: " + idAccordo.toString()));
        AccordoCooperazione accordoCooperazione = null;
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        Statement stm2 = null;
        ResultSet rs2 = null;
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
        long idAccordoLong = DBUtils.getIdAccordoCooperazione(idAccordo, con, this.tipoDB);
        if (idAccordoLong <= 0L) {
            throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getAccordoCooperazione] Accordo non trovato (id:" + idAccordoLong + ")");
        }
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("accordi_cooperazione");
        sqlQueryObject.addSelectField("*");
        sqlQueryObject.addWhereCondition("id = ?");
        sqlQueryObject.setANDLogicOperator(true);
        String sqlQuery = sqlQueryObject.createSQLQuery();
        stm = con.prepareStatement(sqlQuery);
        stm.setLong(1, idAccordoLong);
        this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idAccordoLong)));
        rs = stm.executeQuery();
        if (rs.next()) {
            accordoCooperazione = new AccordoCooperazione();
            accordoCooperazione.setId(rs.getLong("id"));
            String tmp = rs.getString("nome");
            accordoCooperazione.setNome(tmp == null || tmp.equals("") ? null : tmp);
            tmp = rs.getString("descrizione");
            accordoCooperazione.setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
            if (rs.getInt("id_referente") > 0) {
                SoggettoSpcoop soggRef = this.getSoggettoRegistro(new Long(rs.getInt("id_referente")), con);
                AccordoCooperazioneSoggettoReferente assr = new AccordoCooperazioneSoggettoReferente();
                assr.setTipo(soggRef.getTipo());
                assr.setNome(soggRef.getNome());
                accordoCooperazione.setSoggettoReferente(assr);
            }
            if (rs.getString("versione") != null && !"".equals(rs.getString("versione"))) {
                accordoCooperazione.setVersione(rs.getString("versione"));
            }
            if (rs.getTimestamp("data_pubblicazione") != null) {
                accordoCooperazione.setDataPubblicazione(new Date(rs.getTimestamp("data_pubblicazione").getTime()));
            }
            accordoCooperazione.setByteFirma((tmp = rs.getString("firma")) == null || tmp.trim().equals("") ? null : tmp.getBytes());
            tmp = rs.getString("stato");
            accordoCooperazione.setStatoPackage(tmp == null || tmp.equals("") ? null : tmp);
            if (rs.getInt("privato") == 1) {
                accordoCooperazione.setPrivato(true);
            } else {
                accordoCooperazione.setPrivato(false);
            }
            tmp = rs.getString("superuser");
            accordoCooperazione.setSuperUser(tmp == null || tmp.equals("") ? null : tmp);
            if (rs.getTimestamp("ora_registrazione") != null) {
                accordoCooperazione.setOraRegistrazione(new Date(rs.getTimestamp("ora_registrazione").getTime()));
            }
            rs.close();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("acc_serv_composti");
            sqlQueryObject.addSelectField("id_accordo");
            sqlQueryObject.addWhereCondition("id_accordo_cooperazione = ?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordoLong);
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idAccordoLong)));
            rs = stm.executeQuery();
            while (rs.next()) {
                IDSoggetto soggettoReferente;
                long idAccServizioComposto = rs.getLong("id_accordo");
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("accordi");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("versione");
                sqlQueryObject.addSelectField("id_referente");
                sqlQueryObject.addWhereCondition("id = ?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm2 = con.prepareStatement(sqlQuery);
                stm2.setLong(1, idAccServizioComposto);
                rs2 = stm2.executeQuery();
                if (rs2.next()) {
                    soggettoReferente = null;
                    if (rs2.getLong("id_referente") > 0L) {
                        SoggettoSpcoop s = this.getSoggettoRegistro(rs2.getLong("id_referente"));
                        soggettoReferente = new IDSoggetto(s.getTipo(), s.getNome());
                    }
                } else {
                    throw new DriverRegistroServiziException("IDAccordo con id [" + rs.getLong("id_accordo_servizio") + "] non presente");
                }
                String uriAccordo = IDAccordo.getUriFromValues(rs2.getString("nome"), soggettoReferente, rs2.getString("versione"));
                accordoCooperazione.addUriServiziComposti(uriAccordo);
                rs2.close();
                stm2.close();
            }
            rs.close();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("accordi_coop_partecipanti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_accordo_cooperazione = ?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordoLong);
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idAccordoLong)));
            rs = stm.executeQuery();
            AccordoCooperazioneElencoPartecipantiSoggetto accCompPartecipante = null;
            while (rs.next()) {
                accCompPartecipante = new AccordoCooperazioneElencoPartecipantiSoggetto();
                accCompPartecipante.setIdSoggetto(rs.getLong("id_soggetto"));
                SoggettoSpcoop s = this.getSoggettoRegistro(rs.getLong("id_soggetto"), con);
                accCompPartecipante.setTipo(s.getTipo());
                accCompPartecipante.setNome(s.getNome());
                accordoCooperazione.addElencoPartecipanti(accCompPartecipante);
            }
            rs.close();
            stm.close();
            try {
                List<Documento> allegati = DriverRegistroServiziDB_LIB.getListaDocumenti(RuoliDocumento.allegato.toString(), idAccordoLong, ProprietariDocumento.accordoCooperazione, readContenutoAllegati, con);
                for (int i = 0; i < allegati.size(); ++i) {
                    accordoCooperazione.addAllegato(allegati.get(i));
                }
            }
            catch (DriverRegistroServiziNotFound dNotFound) {
                // empty catch block
            }
            try {
                List<Documento> specificheSemiformali = DriverRegistroServiziDB_LIB.getListaDocumenti(RuoliDocumento.specificaSemiformale.toString(), idAccordoLong, ProprietariDocumento.accordoCooperazione, readContenutoAllegati, con);
                for (int i = 0; i < specificheSemiformali.size(); ++i) {
                    accordoCooperazione.addSpecificaSemiformale(specificheSemiformali.get(i));
                }
            }
            catch (DriverRegistroServiziNotFound dNotFound) {}
        } else {
            throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getAccordoCooperazione] rs.next non ha restituito valori con la seguente interrogazione :\n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idAccordoLong));
        }
        AccordoCooperazione accordoCooperazione2 = accordoCooperazione;
        Object var19_25 = null;
        try {
            if (rs2 != null) {
                rs2.close();
            }
            if (stm2 != null) {
                stm2.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (rs != null) {
                rs.close();
            }
            if (stm != null) {
                stm.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessione al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        {
            return accordoCooperazione2;
            catch (DriverRegistroServiziNotFound e) {
                throw e;
            }
            catch (Exception se) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoCooperazione] SQLException :" + se.getMessage(), se);
            }
        }
        catch (Throwable throwable) {
            Object var19_26 = null;
            try {
                if (rs2 != null) {
                    rs2.close();
                }
                if (stm2 != null) {
                    stm2.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
            throw throwable;
        }
    }

    public AccordoCooperazione getAccordoCooperazione(long id) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoCooperazione(id, null);
    }

    /*
     * Loose catch block
     */
    public AccordoCooperazione getAccordoCooperazione(long id, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        IDAccordoCooperazione idAccordo;
        block21: {
            this.log.debug((Object)("richiesto getAccordoCooperazione: " + id));
            if (id <= 0L) {
                return null;
            }
            Connection con = null;
            Statement stm = null;
            ResultSet rs = null;
            idAccordo = null;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("accordi_cooperazione");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            con = conParam != null ? conParam : (this.atomica ? this.datasource.getConnection() : this.globalConnection);
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, id);
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id)));
            rs = stm.executeQuery();
            if (!rs.next()) {
                rs.close();
                stm.close();
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getAccordoCooperazione] rs.next non ha restituito valori con la seguente interrogazione :\n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id));
            }
            idAccordo = IDAccordoCooperazione.getIDAccordoFromValues(rs.getString("nome"), rs.getString("versione"));
            rs.close();
            stm.close();
            Object var11_12 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (conParam == null && this.atomica) {
                    this.log.debug((Object)"rilascio connessione al db...");
                    con.close();
                }
                break block21;
            }
            catch (Exception e) {}
            break block21;
            {
                catch (SQLException se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoCooperazione] SQLException :" + se.getMessage(), se);
                }
                catch (DriverRegistroServiziNotFound e) {
                    throw e;
                }
                catch (Exception se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoCooperazione] Exception :" + se.getMessage(), se);
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (conParam == null && this.atomica) {
                        this.log.debug((Object)"rilascio connessione al db...");
                        con.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return this.getAccordoCooperazione(idAccordo);
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public IDAccordoCooperazione[] getAllIdAccordiCooperazione(FiltroAccordiSPCoop filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug((Object)"getAllIdAccordiCooperazione...");
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("accordi_cooperazione");
        if (filtroRicerca != null && (filtroRicerca.getTipoSoggettoReferente() != null || filtroRicerca.getNomeSoggettoReferente() != null)) {
            sqlQueryObject.addFromTable(this.tabellaSoggetti);
        }
        sqlQueryObject.addSelectField("accordi_cooperazione", "nome");
        sqlQueryObject.addSelectField("accordi_cooperazione", "versione");
        if (filtroRicerca != null) {
            if (filtroRicerca.getMinDate() != null) {
                sqlQueryObject.addWhereCondition("accordi_cooperazione.ora_registrazione > ?");
            }
            if (filtroRicerca.getMaxDate() != null) {
                sqlQueryObject.addWhereCondition("accordi_cooperazione.ora_registrazione < ?");
            }
            if (filtroRicerca.getNomeAccordo() != null) {
                sqlQueryObject.addWhereCondition("accordi_cooperazione.nome = ?");
            }
            if (filtroRicerca.getVersione() != null) {
                sqlQueryObject.addWhereCondition("accordi_cooperazione.versione = ?");
            }
            if (filtroRicerca.getTipoSoggettoReferente() != null || filtroRicerca.getNomeSoggettoReferente() != null) {
                sqlQueryObject.addWhereCondition("accordi_cooperazione.id_referente=" + this.tabellaSoggetti + ".id");
                if (filtroRicerca.getTipoSoggettoReferente() != null) {
                    sqlQueryObject.addWhereCondition(this.tabellaSoggetti + ".tipo_soggetto=?");
                }
                if (filtroRicerca.getNomeSoggettoReferente() != null) {
                    sqlQueryObject.addWhereCondition(this.tabellaSoggetti + ".nome_soggetto=?");
                }
            }
        }
        sqlQueryObject.setANDLogicOperator(true);
        String sqlQuery = sqlQueryObject.createSQLQuery();
        this.log.debug((Object)("eseguo query : " + sqlQuery));
        stm = con.prepareStatement(sqlQuery);
        int indexStmt = 1;
        if (filtroRicerca != null) {
            if (filtroRicerca.getMinDate() != null) {
                this.log.debug((Object)("minDate stmt.setTimestamp(" + filtroRicerca.getMinDate() + ")"));
                stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMinDate().getTime()));
                ++indexStmt;
            }
            if (filtroRicerca.getMaxDate() != null) {
                this.log.debug((Object)("maxDate stmt.setTimestamp(" + filtroRicerca.getMaxDate() + ")"));
                stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMaxDate().getTime()));
                ++indexStmt;
            }
            if (filtroRicerca.getNomeAccordo() != null) {
                this.log.debug((Object)("nomeAccordo stmt.setString(" + filtroRicerca.getNomeAccordo() + ")"));
                stm.setString(indexStmt, filtroRicerca.getNomeAccordo());
                ++indexStmt;
            }
            if (filtroRicerca.getVersione() != null) {
                this.log.debug((Object)("versioneAccordo stmt.setString(" + filtroRicerca.getVersione() + ")"));
                stm.setString(indexStmt, filtroRicerca.getVersione());
                ++indexStmt;
            }
            if (filtroRicerca.getTipoSoggettoReferente() != null || filtroRicerca.getNomeSoggettoReferente() != null) {
                if (filtroRicerca.getTipoSoggettoReferente() != null) {
                    this.log.debug((Object)("tipoSoggettoReferenteAccordo stmt.setString(" + filtroRicerca.getTipoSoggettoReferente() + ")"));
                    stm.setString(indexStmt, filtroRicerca.getTipoSoggettoReferente());
                    ++indexStmt;
                }
                if (filtroRicerca.getNomeSoggettoReferente() != null) {
                    this.log.debug((Object)("nomeSoggettoReferenteAccordo stmt.setString(" + filtroRicerca.getNomeSoggettoReferente() + ")"));
                    stm.setString(indexStmt, filtroRicerca.getNomeSoggettoReferente());
                    ++indexStmt;
                }
            }
        }
        rs = stm.executeQuery();
        Vector<IDAccordoCooperazione> idAccordi = new Vector<IDAccordoCooperazione>();
        while (rs.next()) {
            IDAccordoCooperazione idAccordo = IDAccordoCooperazione.getIDAccordoFromValues(rs.getString("nome"), rs.getString("versione"));
            idAccordi.add(idAccordo);
        }
        if (idAccordi.size() == 0) {
            if (filtroRicerca != null) {
                throw new DriverRegistroServiziNotFound("Accordi non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            throw new DriverRegistroServiziNotFound("Accordi non trovati");
        }
        IDAccordoCooperazione[] res = new IDAccordoCooperazione[1];
        IDAccordoCooperazione[] iDAccordoCooperazioneArray = idAccordi.toArray(res);
        Object var12_13 = null;
        try {
            if (rs != null) {
                rs.close();
            }
            if (stm != null) {
                stm.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessione al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        {
            return iDAccordoCooperazioneArray;
            catch (DriverRegistroServiziNotFound de) {
                throw de;
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("getAllIdAccordiCooperazione error", e);
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void createAccordoCooperazione(AccordoCooperazione accordoCooperazione) throws DriverRegistroServiziException {
        if (accordoCooperazione == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createAccordoCooperazione] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createAccordoCooperazione] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            try {
                this.log.debug((Object)"CRUDServizio tupe=1");
                DriverRegistroServiziDB_LIB.CRUDAccordoCooperazione(1, accordoCooperazione, con);
            }
            catch (Exception qe) {
                error = true;
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createAccordoCooperazione] Errore durante la creazione dell'accordo : " + qe.getMessage(), qe);
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                    throw throwable;
                }
                if (error) throw throwable;
                if (!this.atomica) throw throwable;
                this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                con.commit();
                con.setAutoCommit(true);
                con.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        if (error && this.atomica) {
            this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
            con.rollback();
            con.setAutoCommit(true);
            con.close();
            return;
        }
        if (error) return;
        if (!this.atomica) return;
        this.log.debug((Object)"eseguo commit e rilascio connessioni...");
        con.commit();
        con.setAutoCommit(true);
        con.close();
        return;
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean existsAccordoCooperazione(IDAccordoCooperazione idAccordo) throws DriverRegistroServiziException {
        boolean bl;
        Connection connection;
        block15: {
            block13: {
                boolean bl2;
                block14: {
                    if (this.atomica) {
                        try {
                            connection = this.datasource.getConnection();
                            connection.setAutoCommit(false);
                        }
                        catch (SQLException e) {
                            throw new DriverRegistroServiziException("DriverRegistroServiziDB::createAccordoServizio] SQLException accedendo al datasource :" + e.getMessage(), e);
                        }
                    } else {
                        connection = this.globalConnection;
                    }
                    this.log.debug((Object)("operazione atomica = " + this.atomica));
                    long idAccordoLong = DBUtils.getIdAccordoCooperazione(idAccordo, connection, this.tipoDB);
                    if (idAccordoLong > 0L) break block13;
                    bl2 = false;
                    Object var7_8 = null;
                    if (!this.atomica) break block14;
                    try {
                        connection.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                return bl2;
            }
            bl = true;
            Object var7_9 = null;
            if (!this.atomica) break block15;
            try {
                connection.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        return bl;
        catch (Exception e) {
            try {
                throw new DriverRegistroServiziException(e);
            }
            catch (Throwable throwable) {
                block16: {
                    Object var7_10 = null;
                    if (!this.atomica) break block16;
                    try {
                        connection.close();
                    }
                    catch (Exception e2) {}
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public void updateAccordoCooperazione(AccordoCooperazione accordoCooperazione) throws DriverRegistroServiziException {
        block26: {
            if (accordoCooperazione == null) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateAccordoCooperazione] Parametro non valido.");
            }
            Statement stm = null;
            ResultSet rs = null;
            Connection con = null;
            boolean error = false;
            if (this.atomica) {
                try {
                    con = this.datasource.getConnection();
                    con.setAutoCommit(false);
                }
                catch (SQLException e) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateAccordoCooperazione] SQLException accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.globalConnection;
            }
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            DriverRegistroServiziDB_LIB.CRUDAccordoCooperazione(2, accordoCooperazione, con);
            Object var8_8 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
                break block26;
            }
            catch (Exception e) {}
            break block26;
            {
                catch (Exception qe) {
                    error = true;
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateAccordoCooperazione] Errore durante l'update dell'accordo : " + qe.getMessage(), qe);
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (error && this.atomica) {
                        this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                        con.rollback();
                        con.setAutoCommit(true);
                        con.close();
                    } else if (!error && this.atomica) {
                        this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                        con.commit();
                        con.setAutoCommit(true);
                        con.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void deleteAccordoCooperazione(AccordoCooperazione accordoCooperazione) throws DriverRegistroServiziException {
        if (accordoCooperazione == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteAccordoCooperazione] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteAccordoCooperazione] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            try {
                this.log.debug((Object)"CRUDServizio type = 3");
                DriverRegistroServiziDB_LIB.CRUDAccordoCooperazione(3, accordoCooperazione, con);
            }
            catch (Exception qe) {
                error = true;
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteAccordoCooperazione] Errore durante la delete dell'accordo : " + qe.getMessage(), qe);
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                    throw throwable;
                }
                if (error) throw throwable;
                if (!this.atomica) throw throwable;
                this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                con.commit();
                con.setAutoCommit(true);
                con.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        if (error && this.atomica) {
            this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
            con.rollback();
            con.setAutoCommit(true);
            con.close();
            return;
        }
        if (error) return;
        if (!this.atomica) return;
        this.log.debug((Object)"eseguo commit e rilascio connessioni...");
        con.commit();
        con.setAutoCommit(true);
        con.close();
        return;
    }

    @Override
    public AccordoServizio getAccordoServizio(IDAccordo idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizio(idAccordo, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public AccordoServizio getAccordoServizio(IDAccordo idAccordo, boolean readContenutoAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idAccordo == null) {
            throw new DriverRegistroServiziException("[getAccordoServizio] Parametro idAccordo is null");
        }
        if (idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("[getAccordoServizio] Parametro idAccordo.getNome is null");
        }
        if (idAccordo.getNome().trim().equals("")) {
            throw new DriverRegistroServiziException("[getAccordoServizio] Parametro idAccordo.getNome non e' definito");
        }
        this.log.debug((Object)("richiesto getAccordoServizio: " + idAccordo.toString()));
        AccordoServizio accordoServizio = null;
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
        long idAccordoLong = DBUtils.getIdAccordoServizio(idAccordo, con, this.tipoDB);
        if (idAccordoLong <= 0L) {
            throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getAccordoServizio] Accordo non trovato (id:" + idAccordo + ")");
        }
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("accordi");
        sqlQueryObject.addSelectField("*");
        sqlQueryObject.addWhereCondition("id = ?");
        sqlQueryObject.setANDLogicOperator(true);
        String sqlQuery = sqlQueryObject.createSQLQuery();
        stm = con.prepareStatement(sqlQuery);
        stm.setLong(1, idAccordoLong);
        this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idAccordoLong)));
        rs = stm.executeQuery();
        if (rs.next()) {
            int i;
            accordoServizio = new AccordoServizio();
            accordoServizio.setId(rs.getLong("id"));
            String tmp = rs.getString("nome");
            accordoServizio.setNome(tmp == null || tmp.equals("") ? null : tmp);
            tmp = rs.getString("descrizione");
            accordoServizio.setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
            tmp = rs.getString("profilo_collaborazione");
            accordoServizio.setProfiloCollaborazione(tmp == null || tmp.equals("") ? null : tmp);
            tmp = rs.getString("wsdl_definitorio");
            accordoServizio.setByteWsdlDefinitorio(tmp == null || tmp.trim().equals("") ? null : tmp.getBytes());
            tmp = rs.getString("wsdl_concettuale");
            accordoServizio.setByteWsdlConcettuale(tmp == null || tmp.trim().equals("") ? null : tmp.getBytes());
            tmp = rs.getString("wsdl_logico_erogatore");
            accordoServizio.setByteWsdlLogicoErogatore(tmp == null || tmp.trim().equals("") ? null : tmp.getBytes());
            tmp = rs.getString("wsdl_logico_fruitore");
            accordoServizio.setByteWsdlLogicoFruitore(tmp == null || tmp.trim().equals("") ? null : tmp.getBytes());
            tmp = rs.getString("wsbl_concettuale");
            accordoServizio.setByteWsblConcettuale(tmp == null || tmp.trim().equals("") ? null : tmp.getBytes());
            tmp = rs.getString("wsbl_logico_erogatore");
            accordoServizio.setByteWsblLogicoErogatore(tmp == null || tmp.trim().equals("") ? null : tmp.getBytes());
            tmp = rs.getString("wsbl_logico_fruitore");
            accordoServizio.setByteWsblLogicoFruitore(tmp == null || tmp.trim().equals("") ? null : tmp.getBytes());
            tmp = rs.getString("riferimento");
            accordoServizio.setByteCatalogoSchemiOntologie(tmp == null || tmp.trim().equals("") ? null : tmp.getBytes());
            accordoServizio.setUtilizzoSenzaAzione(rs.getInt("utilizzo_senza_azione") == 1);
            tmp = rs.getString("filtro_duplicati");
            accordoServizio.setFiltroDuplicati(tmp == null || tmp.equals("") ? null : tmp);
            tmp = rs.getString("conferma_ricezione");
            accordoServizio.setConfermaRicezione(tmp == null || tmp.equals("") ? null : tmp);
            tmp = rs.getString("identificativo_collaborazione");
            accordoServizio.setIdCollaborazione(tmp == null || tmp.equals("") ? null : tmp);
            tmp = rs.getString("consegna_in_ordine");
            accordoServizio.setConsegnaInOrdine(tmp == null || tmp.equals("") ? null : tmp);
            tmp = rs.getString("scadenza");
            accordoServizio.setScadenza(tmp == null || tmp.equals("") ? null : tmp);
            tmp = rs.getString("superuser");
            accordoServizio.setSuperUser(tmp == null || tmp.equals("") ? null : tmp);
            if (rs.getInt("privato") == 1) {
                accordoServizio.setPrivato(true);
            } else {
                accordoServizio.setPrivato(false);
            }
            if (rs.getTimestamp("ora_registrazione") != null) {
                accordoServizio.setOraRegistrazione(new Date(rs.getTimestamp("ora_registrazione").getTime()));
            }
            if (rs.getInt("id_referente") > 0) {
                SoggettoSpcoop soggRef = this.getSoggettoRegistro(new Long(rs.getInt("id_referente")), con);
                AccordoServizioSoggettoReferente assr = new AccordoServizioSoggettoReferente();
                assr.setTipo(soggRef.getTipo());
                assr.setNome(soggRef.getNome());
                assr.setId(soggRef.getId());
                accordoServizio.setSoggettoReferente(assr);
            }
            if (rs.getString("versione") != null && !"".equals(rs.getString("versione"))) {
                accordoServizio.setVersione(rs.getString("versione"));
            }
            accordoServizio.setStatoPackage((tmp = rs.getString("stato")) == null || tmp.equals("") ? null : tmp);
            tmp = rs.getString("firma");
            accordoServizio.setByteFirma(tmp == null || tmp.trim().equals("") ? null : tmp.getBytes());
            if (rs.getTimestamp("data_pubblicazione") != null) {
                accordoServizio.setDataPubblicazione(new Date(rs.getTimestamp("data_pubblicazione").getTime()));
            }
            rs.close();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("accordi_azioni");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordoLong);
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idAccordoLong)));
            rs = stm.executeQuery();
            Azione azione = null;
            while (rs.next()) {
                azione = new Azione();
                tmp = rs.getString("conferma_ricezione");
                azione.setConfermaRicezione(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("consegna_in_ordine");
                azione.setConsegnaInOrdine(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("filtro_duplicati");
                azione.setFiltroDuplicati(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("identificativo_collaborazione");
                azione.setIdCollaborazione(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("nome");
                azione.setNome(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("scadenza");
                azione.setScadenza(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("profilo_collaborazione");
                azione.setProfiloCollaborazione(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("correlata");
                azione.setCorrelata(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("profilo_azione");
                if (tmp == null || tmp.equals("")) {
                    azione.setProfAzione("default");
                } else {
                    azione.setProfAzione(tmp);
                }
                accordoServizio.addAzione(azione);
            }
            rs.close();
            stm.close();
            this.readPortTypes(accordoServizio, con);
            this.readAccordoServizioComposto(accordoServizio, con);
            try {
                List<Documento> allegati = DriverRegistroServiziDB_LIB.getListaDocumenti(RuoliDocumento.allegato.toString(), idAccordoLong, ProprietariDocumento.accordoServizio, readContenutoAllegati, con);
                for (i = 0; i < allegati.size(); ++i) {
                    accordoServizio.addAllegato(allegati.get(i));
                }
            }
            catch (DriverRegistroServiziNotFound dNotFound) {
                // empty catch block
            }
            try {
                List<Documento> specificheSemiformali = DriverRegistroServiziDB_LIB.getListaDocumenti(RuoliDocumento.specificaSemiformale.toString(), idAccordoLong, ProprietariDocumento.accordoServizio, readContenutoAllegati, con);
                for (i = 0; i < specificheSemiformali.size(); ++i) {
                    accordoServizio.addSpecificaSemiformale(specificheSemiformali.get(i));
                }
            }
            catch (DriverRegistroServiziNotFound dNotFound) {
                // empty catch block
            }
            if (accordoServizio.getServizioComposto() != null) {
                try {
                    List<Documento> specificheCoordinamento = DriverRegistroServiziDB_LIB.getListaDocumenti(RuoliDocumento.specificaCoordinamento.toString(), idAccordoLong, ProprietariDocumento.accordoServizio, readContenutoAllegati, con);
                    for (i = 0; i < specificheCoordinamento.size(); ++i) {
                        accordoServizio.getServizioComposto().addSpecificaCoordinamento(specificheCoordinamento.get(i));
                    }
                }
                catch (DriverRegistroServiziNotFound dNotFound) {}
            }
        } else {
            throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getAccordoServizio] rs.next non ha restituito valori con la seguente interrogazione :\n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idAccordoLong));
        }
        if (accordoServizio != null) {
            accordoServizio.setNomiAzione(accordoServizio.readNomiAzione());
        }
        AccordoServizio accordoServizio2 = accordoServizio;
        Object var16_19 = null;
        try {
            if (rs != null) {
                rs.close();
            }
            if (stm != null) {
                stm.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessione al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        {
            return accordoServizio2;
            catch (DriverRegistroServiziNotFound e) {
                throw e;
            }
            catch (Exception se) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoServizio] SQLException :" + se.getMessage(), se);
            }
        }
        catch (Throwable throwable) {
            Object var16_20 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    private void readPortTypes(AccordoServizio as, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        block22: {
            Connection con = null;
            Statement stm = null;
            ResultSet rs = null;
            String sqlQuery = null;
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            con = conParam != null ? conParam : (this.atomica ? this.datasource.getConnection() : this.globalConnection);
            if (as.getId() == null || as.getId() <= 0L) {
                throw new Exception("Accordo id non definito");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("port_type");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, as.getId());
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, as.getId())));
            rs = stm.executeQuery();
            while (rs.next()) {
                PortType pt = new PortType();
                String tmp = rs.getString("nome");
                pt.setNome(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("descrizione");
                pt.setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("profilo_collaborazione");
                pt.setProfiloCollaborazione(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("filtro_duplicati");
                pt.setFiltroDuplicati(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("conferma_ricezione");
                pt.setConfermaRicezione(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("identificativo_collaborazione");
                pt.setIdCollaborazione(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("consegna_in_ordine");
                pt.setConsegnaInOrdine(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("scadenza");
                pt.setScadenza(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("profilo_pt");
                if (tmp == null || tmp.equals("")) {
                    pt.setProfiloPT("default");
                } else {
                    pt.setProfiloPT(tmp);
                }
                tmp = rs.getString("soap_style");
                pt.setStyle(tmp == null || tmp.equals("") ? null : tmp);
                pt.setIdAccordo(as.getId());
                long idPortType = rs.getLong("id");
                pt.setId(idPortType);
                this.readAzioniPortTypes(pt, con);
                as.addPortType(pt);
            }
            rs.close();
            stm.close();
            Object var13_13 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (conParam == null && this.atomica) {
                    this.log.debug((Object)"rilascio connessione al db...");
                    con.close();
                }
                break block22;
            }
            catch (Exception e) {}
            break block22;
            {
                catch (DriverRegistroServiziNotFound e) {
                    throw e;
                }
                catch (Exception se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::readPortTypes] SQLException :" + se.getMessage(), se);
                }
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (conParam == null && this.atomica) {
                        this.log.debug((Object)"rilascio connessione al db...");
                        con.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    private void readAzioniPortTypes(PortType pt, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        block24: {
            Connection con = null;
            Statement stm = null;
            ResultSet rs = null;
            String sqlQuery = null;
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            con = conParam != null ? conParam : (this.atomica ? this.datasource.getConnection() : this.globalConnection);
            if (pt.getId() == null || pt.getId() <= 0L) {
                throw new Exception("Port Type id non definito");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("port_type_azioni");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_port_type = ?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, pt.getId());
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, pt.getId())));
            rs = stm.executeQuery();
            Operation azionePT = null;
            while (rs.next()) {
                azionePT = new Operation();
                String tmp = rs.getString("conferma_ricezione");
                azionePT.setConfermaRicezione(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("consegna_in_ordine");
                azionePT.setConsegnaInOrdine(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("filtro_duplicati");
                azionePT.setFiltroDuplicati(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("identificativo_collaborazione");
                azionePT.setIdCollaborazione(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("nome");
                azionePT.setNome(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("scadenza");
                azionePT.setScadenza(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("profilo_collaborazione");
                azionePT.setProfiloCollaborazione(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("correlata_servizio");
                azionePT.setCorrelataServizio(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("correlata");
                azionePT.setCorrelata(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("profilo_pt_azione");
                if (tmp == null || tmp.equals("")) {
                    azionePT.setProfAzione("default");
                } else {
                    azionePT.setProfAzione(tmp);
                }
                tmp = rs.getString("soap_style");
                azionePT.setStyle(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("soap_action");
                azionePT.setSoapAction(tmp == null || tmp.equals("") ? null : tmp);
                azionePT.setIdPortType(pt.getId());
                long idAzionePortType = rs.getLong("id");
                azionePT.setId(idAzionePortType);
                this.readMessagesAzioniPortTypes(azionePT, con);
                if (azionePT.getMessageInput() != null) {
                    tmp = rs.getString("soap_use_msg_input");
                    azionePT.getMessageInput().setUse(tmp == null || tmp.equals("") ? null : tmp);
                }
                if (azionePT.getMessageOutput() != null) {
                    tmp = rs.getString("soap_use_msg_output");
                    azionePT.getMessageOutput().setUse(tmp == null || tmp.equals("") ? null : tmp);
                }
                pt.addAzione(azionePT);
            }
            rs.close();
            stm.close();
            Object var13_13 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (conParam == null && this.atomica) {
                    this.log.debug((Object)"rilascio connessione al db...");
                    con.close();
                }
                break block24;
            }
            catch (Exception e) {}
            break block24;
            {
                catch (DriverRegistroServiziNotFound e) {
                    throw e;
                }
                catch (Exception se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::readAzioniPortTypes] SQLException :" + se.getMessage(), se);
                }
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (conParam == null && this.atomica) {
                        this.log.debug((Object)"rilascio connessione al db...");
                        con.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    private void readMessagesAzioniPortTypes(Operation azionePT, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        block26: {
            Connection con = null;
            Statement stm = null;
            ResultSet rs = null;
            String sqlQuery = null;
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            con = conParam != null ? conParam : (this.atomica ? this.datasource.getConnection() : this.globalConnection);
            if (azionePT.getId() == null || azionePT.getId() <= 0L) {
                throw new Exception("Port Type azione id non definito");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("operation_messages");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_port_type_azione = ?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, azionePT.getId());
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, azionePT.getId())));
            rs = stm.executeQuery();
            Message messageInputPart = null;
            Message messageOutputPart = null;
            while (rs.next()) {
                String element_name;
                boolean isInputMessage = false;
                if (rs.getInt("input_message") == 1) {
                    isInputMessage = true;
                }
                element_name = (element_name = rs.getString("element_name")) == null || element_name.equals("") ? null : element_name;
                MessagePart part = new MessagePart();
                part.setElementName(element_name);
                long idMessage = rs.getLong("id");
                part.setId(idMessage);
                if (isInputMessage) {
                    if (messageInputPart == null) {
                        messageInputPart = new Message();
                    }
                    messageInputPart.addPart(part);
                    continue;
                }
                if (messageOutputPart == null) {
                    messageOutputPart = new Message();
                }
                messageOutputPart.addPart(part);
            }
            if (messageInputPart != null) {
                azionePT.setMessageInput(messageInputPart);
            }
            if (messageOutputPart != null) {
                azionePT.setMessageOutput(messageOutputPart);
            }
            rs.close();
            stm.close();
            Object var16_16 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (conParam == null && this.atomica) {
                    this.log.debug((Object)"rilascio connessione al db...");
                    con.close();
                }
                break block26;
            }
            catch (Exception e) {}
            break block26;
            {
                catch (DriverRegistroServiziNotFound e) {
                    throw e;
                }
                catch (Exception se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::readMessagesAzioniPortTypes] SQLException :" + se.getMessage(), se);
                }
            }
            catch (Throwable throwable) {
                Object var16_17 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (conParam == null && this.atomica) {
                        this.log.debug((Object)"rilascio connessione al db...");
                        con.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    private void readAccordoServizioComposto(AccordoServizio as, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        block31: {
            ResultSet rs2;
            Statement stm2;
            ResultSet rs;
            Statement stm;
            Connection con;
            block28: {
                con = null;
                stm = null;
                rs = null;
                stm2 = null;
                rs2 = null;
                String sqlQuery = null;
                this.log.debug((Object)("operazione atomica = " + this.atomica));
                con = conParam != null ? conParam : (this.atomica ? this.datasource.getConnection() : this.globalConnection);
                if (as.getId() == null || as.getId() <= 0L) {
                    throw new Exception("Accordo id non definito");
                }
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("acc_serv_composti");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_accordo = ?");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setLong(1, as.getId());
                this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, as.getId())));
                rs = stm.executeQuery();
                AccordoServizioServizioComposto asComposto = null;
                if (rs.next()) {
                    asComposto = new AccordoServizioServizioComposto();
                    asComposto.setId(rs.getLong("id"));
                    asComposto.setIdAccordoCooperazione(rs.getLong("id_accordo_cooperazione"));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                    sqlQueryObject.addFromTable("accordi_cooperazione");
                    sqlQueryObject.addSelectField("nome");
                    sqlQueryObject.addSelectField("versione");
                    sqlQueryObject.addWhereCondition("id = ?");
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm2 = con.prepareStatement(sqlQuery);
                    stm2.setLong(1, rs.getLong("id_accordo_cooperazione"));
                    rs2 = stm2.executeQuery();
                    if (!rs2.next()) {
                        throw new DriverRegistroServiziException("IDAccordoCooperazione con id [" + rs.getLong("id_accordo_cooperazione") + "] non presente");
                    }
                    String uriAccordo = IDAccordoCooperazione.getUriFromValues(rs2.getString("nome"), rs2.getString("versione"));
                    asComposto.setNomeAccordoCooperazione(uriAccordo);
                    rs2.close();
                    stm2.close();
                }
                rs.close();
                stm.close();
                if (asComposto == null) break block28;
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("acc_serv_componenti");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_servizio_composto = ?");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setLong(1, asComposto.getId());
                this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, asComposto.getId())));
                rs = stm.executeQuery();
                while (rs.next()) {
                    AccordoServizioServizioCompostoServizioComponente asComponente = new AccordoServizioServizioCompostoServizioComponente();
                    asComponente.setIdServizioComponente(rs.getLong("id_servizio_componente"));
                    asComponente.setAzione(rs.getString("azione"));
                    ServizioSpcoop servizioComponente = this.getServizioSpcoop((long)asComponente.getIdServizioComponente(), con);
                    asComponente.setTipo(servizioComponente.getTipo());
                    asComponente.setNome(servizioComponente.getNome());
                    asComponente.setTipoSoggetto(servizioComponente.getTipoSoggettoErogatore());
                    asComponente.setNomeSoggetto(servizioComponente.getNomeSoggettoErogatore());
                    asComposto.addServizioComponente(asComponente);
                }
                rs.close();
                stm.close();
                as.setServizioComposto(asComposto);
            }
            Object var14_15 = null;
            try {
                if (rs2 != null) {
                    rs2.close();
                }
                if (stm2 != null) {
                    stm2.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (conParam == null && this.atomica) {
                    this.log.debug((Object)"rilascio connessione al db...");
                    con.close();
                }
                break block31;
            }
            catch (Exception e) {}
            break block31;
            {
                catch (DriverRegistroServiziNotFound e) {
                    throw e;
                }
                catch (Exception se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::readPortTypes] SQLException :" + se.getMessage(), se);
                }
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                try {
                    if (rs2 != null) {
                        rs2.close();
                    }
                    if (stm2 != null) {
                        stm2.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (conParam == null && this.atomica) {
                        this.log.debug((Object)"rilascio connessione al db...");
                        con.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public IDAccordo[] getAllIdAccordiServizio(FiltroAccordiSPCoop filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug((Object)"getAllIdAccordiServizio...");
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("accordi");
        if (filtroRicerca != null && (filtroRicerca.getTipoSoggettoReferente() != null || filtroRicerca.getNomeSoggettoReferente() != null)) {
            sqlQueryObject.addFromTable(this.tabellaSoggetti);
        }
        sqlQueryObject.addSelectField("accordi", "nome");
        sqlQueryObject.addSelectField("accordi", "versione");
        sqlQueryObject.addSelectField("accordi", "id_referente");
        if (filtroRicerca != null) {
            if (filtroRicerca.getMinDate() != null) {
                sqlQueryObject.addWhereCondition("accordi.ora_registrazione > ?");
            }
            if (filtroRicerca.getMaxDate() != null) {
                sqlQueryObject.addWhereCondition("accordi.ora_registrazione < ?");
            }
            if (filtroRicerca.getNomeAccordo() != null) {
                sqlQueryObject.addWhereCondition("accordi.nome = ?");
            }
            if (filtroRicerca.getVersione() != null) {
                sqlQueryObject.addWhereCondition("accordi.versione = ?");
            }
            if (filtroRicerca.getTipoSoggettoReferente() != null || filtroRicerca.getNomeSoggettoReferente() != null) {
                sqlQueryObject.addWhereCondition("accordi.id_referente=" + this.tabellaSoggetti + ".id");
                if (filtroRicerca.getTipoSoggettoReferente() != null) {
                    sqlQueryObject.addWhereCondition(this.tabellaSoggetti + ".tipo_soggetto=?");
                }
                if (filtroRicerca.getNomeSoggettoReferente() != null) {
                    sqlQueryObject.addWhereCondition(this.tabellaSoggetti + ".nome_soggetto=?");
                }
            }
        }
        sqlQueryObject.setANDLogicOperator(true);
        String sqlQuery = sqlQueryObject.createSQLQuery();
        this.log.debug((Object)("eseguo query : " + sqlQuery));
        stm = con.prepareStatement(sqlQuery);
        int indexStmt = 1;
        if (filtroRicerca != null) {
            if (filtroRicerca.getMinDate() != null) {
                this.log.debug((Object)("minDate stmt.setTimestamp(" + filtroRicerca.getMinDate() + ")"));
                stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMinDate().getTime()));
                ++indexStmt;
            }
            if (filtroRicerca.getMaxDate() != null) {
                this.log.debug((Object)("maxDate stmt.setTimestamp(" + filtroRicerca.getMaxDate() + ")"));
                stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMaxDate().getTime()));
                ++indexStmt;
            }
            if (filtroRicerca.getNomeAccordo() != null) {
                this.log.debug((Object)("nomeAccordo stmt.setString(" + filtroRicerca.getNomeAccordo() + ")"));
                stm.setString(indexStmt, filtroRicerca.getNomeAccordo());
                ++indexStmt;
            }
            if (filtroRicerca.getVersione() != null) {
                this.log.debug((Object)("versioneAccordo stmt.setString(" + filtroRicerca.getVersione() + ")"));
                stm.setString(indexStmt, filtroRicerca.getVersione());
                ++indexStmt;
            }
            if (filtroRicerca.getTipoSoggettoReferente() != null || filtroRicerca.getNomeSoggettoReferente() != null) {
                if (filtroRicerca.getTipoSoggettoReferente() != null) {
                    this.log.debug((Object)("tipoSoggettoReferenteAccordo stmt.setString(" + filtroRicerca.getTipoSoggettoReferente() + ")"));
                    stm.setString(indexStmt, filtroRicerca.getTipoSoggettoReferente());
                    ++indexStmt;
                }
                if (filtroRicerca.getNomeSoggettoReferente() != null) {
                    this.log.debug((Object)("nomeSoggettoReferenteAccordo stmt.setString(" + filtroRicerca.getNomeSoggettoReferente() + ")"));
                    stm.setString(indexStmt, filtroRicerca.getNomeSoggettoReferente());
                    ++indexStmt;
                }
            }
        }
        rs = stm.executeQuery();
        Vector<IDAccordo> idAccordi = new Vector<IDAccordo>();
        while (rs.next()) {
            long idReferente = rs.getLong("id_referente");
            IDSoggetto idSoggettoReferente = null;
            if (idReferente > 0L) {
                SoggettoSpcoop soggettoReferente = this.getSoggettoRegistro(idReferente, con);
                if (soggettoReferente == null) {
                    throw new Exception("Soggetto referente [" + idReferente + "] presente nell'accordo [" + rs.getString("nome") + "] (versione [" + rs.getString("versione") + "]) non presente?");
                }
                idSoggettoReferente = new IDSoggetto(soggettoReferente.getTipo(), soggettoReferente.getNome());
            }
            IDAccordo idAccordo = IDAccordo.getIDAccordoFromValues(rs.getString("nome"), idSoggettoReferente, rs.getString("versione"));
            idAccordi.add(idAccordo);
        }
        if (idAccordi.size() == 0) {
            if (filtroRicerca != null) {
                throw new DriverRegistroServiziNotFound("Accordi non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            throw new DriverRegistroServiziNotFound("Accordi non trovati");
        }
        IDAccordo[] res = new IDAccordo[1];
        IDAccordo[] iDAccordoArray = idAccordi.toArray(res);
        Object var14_16 = null;
        try {
            if (rs != null) {
                rs.close();
            }
            if (stm != null) {
                stm.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessione al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        {
            return iDAccordoArray;
            catch (DriverRegistroServiziNotFound de) {
                throw de;
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("getAllIdAccordiServizio error", e);
            }
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public void createAccordoServizio(AccordoServizio accordoServizio) throws DriverRegistroServiziException {
        block47: {
            Documento doc;
            int i;
            IDAccordo idAccordoObject;
            long idAccordo;
            if (accordoServizio == null) {
                throw new DriverRegistroServiziException("L'AccordoServizio non puo' essere null.");
            }
            String nome = accordoServizio.getNome();
            if (nome == null || nome.equals("")) {
                throw new DriverRegistroServiziException("Il nome dell'AccordoServizio non e' valido.");
            }
            String confermaRicezione = accordoServizio.getConfermaRicezione();
            String conegnaInOrdine = accordoServizio.getConsegnaInOrdine();
            String descrizione = accordoServizio.getDescrizione();
            String filtroDuplicati = accordoServizio.getFiltroDuplicati();
            String identificativoCollaborazione = accordoServizio.getIdCollaborazione();
            String profiloCollaborazione = accordoServizio.getProfiloCollaborazione();
            String scadenza = accordoServizio.getScadenza();
            boolean utilizzioSenzaAzione = accordoServizio.getUtilizzoSenzaAzione();
            String wsdlConcettuale = accordoServizio.getByteWsdlConcettuale() != null ? new String(accordoServizio.getByteWsdlConcettuale()) : null;
            String wsdlDefinitorio = accordoServizio.getByteWsdlDefinitorio() != null ? new String(accordoServizio.getByteWsdlDefinitorio()) : null;
            String wsdlLogicoErogatore = accordoServizio.getByteWsdlLogicoErogatore() != null ? new String(accordoServizio.getByteWsdlLogicoErogatore()) : null;
            String wsdlLogicoFruitore = accordoServizio.getByteWsdlLogicoFruitore() != null ? new String(accordoServizio.getByteWsdlLogicoFruitore()) : null;
            String wsblConcettuale = accordoServizio.getByteWsblConcettuale() != null ? new String(accordoServizio.getByteWsblConcettuale()) : null;
            String wsblLogicoErogatore = accordoServizio.getByteWsblLogicoErogatore() != null ? new String(accordoServizio.getByteWsblLogicoErogatore()) : null;
            String wsblLogicoFruitore = accordoServizio.getByteWsblLogicoFruitore() != null ? new String(accordoServizio.getByteWsblLogicoFruitore()) : null;
            String riferimento = accordoServizio.getByteCatalogoSchemiOntologie() != null ? new String(accordoServizio.getByteCatalogoSchemiOntologie()) : null;
            String firma = accordoServizio.getByteFirma() != null ? new String(accordoServizio.getByteFirma()) : null;
            String superUser = accordoServizio.getSuperUser();
            wsdlConcettuale = wsdlConcettuale != null && !"".equals(wsdlConcettuale.trim().replaceAll("\n", "")) ? wsdlConcettuale : null;
            wsdlDefinitorio = wsdlDefinitorio != null && !"".equals(wsdlDefinitorio.trim().replaceAll("\n", "")) ? wsdlDefinitorio : null;
            wsdlLogicoErogatore = wsdlLogicoErogatore != null && !"".equals(wsdlLogicoErogatore.trim().replaceAll("\n", "")) ? wsdlLogicoErogatore : null;
            wsdlLogicoFruitore = wsdlLogicoFruitore != null && !"".equals(wsdlLogicoFruitore.trim().replaceAll("\n", "")) ? wsdlLogicoFruitore : null;
            wsblConcettuale = wsblConcettuale != null && !"".equals(wsblConcettuale.trim().replaceAll("\n", "")) ? wsblConcettuale : null;
            wsblLogicoErogatore = wsblLogicoErogatore != null && !"".equals(wsblLogicoErogatore.trim().replaceAll("\n", "")) ? wsblLogicoErogatore : null;
            wsblLogicoFruitore = wsblLogicoFruitore != null && !"".equals(wsblLogicoFruitore.trim().replaceAll("\n", "")) ? wsblLogicoFruitore : null;
            riferimento = riferimento != null && !"".equals(riferimento.trim().replaceAll("\n", "")) ? riferimento : null;
            firma = firma != null && !"".equals(firma.trim().replaceAll("\n", "")) ? firma : null;
            String sqlQuery = "";
            Connection connection = null;
            Statement stm = null;
            boolean error = false;
            if (this.atomica) {
                try {
                    connection = this.datasource.getConnection();
                    connection.setAutoCommit(false);
                }
                catch (SQLException e) {
                    throw new DriverRegistroServiziException("DriverRegistroServiziDB::createAccordoServizio] SQLException accedendo al datasource :" + e.getMessage());
                }
            } else {
                connection = this.globalConnection;
            }
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addInsertTable("accordi");
            sqlQueryObject.addInsertField("conferma_ricezione", "?");
            sqlQueryObject.addInsertField("consegna_in_ordine", "?");
            sqlQueryObject.addInsertField("descrizione", "?");
            sqlQueryObject.addInsertField("filtro_duplicati", "?");
            sqlQueryObject.addInsertField("identificativo_collaborazione", "?");
            sqlQueryObject.addInsertField("nome", "?");
            sqlQueryObject.addInsertField("profilo_collaborazione", "?");
            sqlQueryObject.addInsertField("scadenza", "?");
            sqlQueryObject.addInsertField("wsdl_concettuale", "?");
            sqlQueryObject.addInsertField("wsdl_definitorio", "?");
            sqlQueryObject.addInsertField("wsdl_logico_erogatore", "?");
            sqlQueryObject.addInsertField("wsdl_logico_fruitore", "?");
            sqlQueryObject.addInsertField("wsbl_concettuale", "?");
            sqlQueryObject.addInsertField("wsbl_logico_erogatore", "?");
            sqlQueryObject.addInsertField("wsbl_logico_fruitore", "?");
            sqlQueryObject.addInsertField("riferimento", "?");
            sqlQueryObject.addInsertField("superuser", "?");
            sqlQueryObject.addInsertField("utilizzo_senza_azione", "?");
            sqlQueryObject.addInsertField("privato", "?");
            sqlQueryObject.addInsertField("firma", "?");
            if (accordoServizio.getStatoPackage() != null) {
                sqlQueryObject.addInsertField("stato", "?");
            }
            if (accordoServizio.getSoggettoReferente() != null) {
                sqlQueryObject.addInsertField("id_referente", "?");
            }
            sqlQueryObject.addInsertField("versione", "?");
            if (accordoServizio.getOraRegistrazione() != null) {
                sqlQueryObject.addInsertField("ora_registrazione", "?");
            }
            sqlQueryObject.addInsertField("data_pubblicazione", "?");
            sqlQuery = sqlQueryObject.createSQLInsert();
            stm = connection.prepareStatement(sqlQuery);
            stm.setString(1, confermaRicezione);
            stm.setString(2, conegnaInOrdine);
            stm.setString(3, descrizione);
            stm.setString(4, filtroDuplicati);
            stm.setString(5, identificativoCollaborazione);
            stm.setString(6, nome);
            stm.setString(7, profiloCollaborazione);
            stm.setString(8, scadenza);
            stm.setString(9, wsdlConcettuale != null && !wsdlConcettuale.trim().equals("") ? wsdlConcettuale : null);
            stm.setString(10, wsdlDefinitorio != null && !wsdlDefinitorio.trim().equals("") ? wsdlDefinitorio : null);
            stm.setString(11, wsdlLogicoErogatore != null && !wsdlLogicoErogatore.trim().equals("") ? wsdlLogicoErogatore : null);
            stm.setString(12, wsdlLogicoFruitore != null && !wsdlLogicoFruitore.trim().equals("") ? wsdlLogicoFruitore : null);
            stm.setString(13, wsblConcettuale != null && !wsblConcettuale.trim().equals("") ? wsblConcettuale : null);
            stm.setString(14, wsblLogicoErogatore != null && !wsblLogicoErogatore.trim().equals("") ? wsblLogicoErogatore : null);
            stm.setString(15, wsblLogicoFruitore != null && !wsblLogicoFruitore.trim().equals("") ? wsblLogicoFruitore : null);
            stm.setString(16, riferimento != null && !riferimento.trim().equals("") ? riferimento : null);
            stm.setString(17, superUser);
            stm.setInt(18, utilizzioSenzaAzione ? 1 : 0);
            if (accordoServizio.getPrivato() != null && accordoServizio.getPrivato().booleanValue()) {
                stm.setInt(19, 1);
            } else {
                stm.setInt(19, 0);
            }
            stm.setString(20, firma);
            int index = 21;
            if (accordoServizio.getStatoPackage() != null) {
                stm.setString(index, accordoServizio.getStatoPackage());
                ++index;
            }
            if (accordoServizio.getSoggettoReferente() != null) {
                long idReferente = DBUtils.getIdSoggetto(accordoServizio.getSoggettoReferente().getNome(), accordoServizio.getSoggettoReferente().getTipo(), connection, this.tipoDB, this.tabellaSoggetti);
                if (idReferente <= 0L) {
                    throw new DriverRegistroServiziException("Soggetto Referente [" + accordoServizio.getSoggettoReferente().getTipo() + "/" + accordoServizio.getSoggettoReferente().getNome() + "] non trovato");
                }
                stm.setLong(index, idReferente);
                ++index;
            }
            if (accordoServizio.getVersione() != null && !"".equals(accordoServizio.getVersione())) {
                stm.setString(index, accordoServizio.getVersione());
            } else {
                stm.setString(index, "");
            }
            ++index;
            if (accordoServizio.getOraRegistrazione() != null) {
                stm.setTimestamp(index, new Timestamp(accordoServizio.getOraRegistrazione().getTime()));
                ++index;
            }
            if (accordoServizio.getDataPubblicazione() != null) {
                stm.setTimestamp(index, new Timestamp(accordoServizio.getDataPubblicazione().getTime()));
            } else {
                stm.setTimestamp(index, new Timestamp(System.currentTimeMillis()));
            }
            ++index;
            this.log.debug((Object)("inserisco accordoServizio : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, confermaRicezione, conegnaInOrdine, descrizione, filtroDuplicati, identificativoCollaborazione, nome, profiloCollaborazione, scadenza, wsdlConcettuale, wsdlDefinitorio, wsdlLogicoErogatore, wsdlLogicoFruitore, wsblConcettuale, wsblLogicoErogatore, wsblLogicoFruitore, riferimento, superUser, accordoServizio.getUtilizzoSenzaAzione(), accordoServizio.getPrivato())));
            stm.executeUpdate();
            stm.close();
            IDSoggetto soggettoReferente = null;
            if (accordoServizio.getSoggettoReferente() != null) {
                soggettoReferente = new IDSoggetto(accordoServizio.getSoggettoReferente().getTipo(), accordoServizio.getSoggettoReferente().getNome());
            }
            if ((idAccordo = DBUtils.getIdAccordoServizio(idAccordoObject = IDAccordo.getIDAccordoFromValues(accordoServizio.getNome(), soggettoReferente, accordoServizio.getVersione()), connection, this.tipoDB)) <= 0L) {
                error = true;
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createAccordoServizio] non riesco a trovare l'id del'Accordo inserito");
            }
            accordoServizio.setId(idAccordo);
            Azione azione = null;
            for (int i2 = 0; i2 < accordoServizio.sizeAzioneList(); ++i2) {
                azione = accordoServizio.getAzione(i2);
                DriverRegistroServiziDB_LIB.CRUDAzione(1, accordoServizio, azione, connection, idAccordo);
            }
            this.log.debug((Object)("inserite " + accordoServizio.sizeAzioneList() + " azioni relative all'accordo :" + nome + " id :" + idAccordo));
            PortType pt = null;
            for (int i3 = 0; i3 < accordoServizio.sizePortTypeList(); ++i3) {
                pt = accordoServizio.getPortType(i3);
                DriverRegistroServiziDB_LIB.CRUDPortType(1, accordoServizio, pt, connection, idAccordo);
            }
            this.log.debug((Object)("inserite " + accordoServizio.sizePortTypeList() + " porttype relative all'accordo :" + nome + " id :" + idAccordo));
            if (accordoServizio.getServizioComposto() != null) {
                DriverRegistroServiziDB_LIB.CRUDAccordoServizioServizioComposto(1, accordoServizio.getServizioComposto(), connection, idAccordo);
            }
            ArrayList<Documento> documenti = new ArrayList<Documento>();
            for (i = 0; i < accordoServizio.sizeAllegatoList(); ++i) {
                doc = accordoServizio.getAllegato(i);
                doc.setRuolo(RuoliDocumento.allegato.toString());
                documenti.add(doc);
            }
            for (i = 0; i < accordoServizio.sizeSpecificaSemiformaleList(); ++i) {
                doc = accordoServizio.getSpecificaSemiformale(i);
                doc.setRuolo(RuoliDocumento.specificaSemiformale.toString());
                documenti.add(doc);
            }
            if (accordoServizio.getServizioComposto() != null) {
                for (i = 0; i < accordoServizio.getServizioComposto().sizeSpecificaCoordinamentoList(); ++i) {
                    doc = accordoServizio.getServizioComposto().getSpecificaCoordinamento(i);
                    doc.setRuolo(RuoliDocumento.specificaCoordinamento.toString());
                    documenti.add(doc);
                }
            }
            DriverRegistroServiziDB_LIB.CRUDDocumento(1, documenti, idAccordo, ProprietariDocumento.accordoServizio, connection);
            Object var37_42 = null;
            try {
                stm.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    connection.rollback();
                    connection.setAutoCommit(true);
                    connection.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    connection.commit();
                    connection.setAutoCommit(true);
                    connection.close();
                }
                break block47;
            }
            catch (Exception e) {}
            break block47;
            {
                catch (SQLException se) {
                    error = true;
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createAccordoServizio] SQLException [" + se.getMessage() + "].", se);
                }
                catch (DriverRegistroServiziException e) {
                    error = true;
                    throw new DriverRegistroServiziException(e);
                }
                catch (Exception e) {
                    error = true;
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createAccordoServizio] Exception [" + e.getMessage() + "].", e);
                }
            }
            catch (Throwable throwable) {
                Object var37_43 = null;
                try {
                    stm.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (error && this.atomica) {
                        this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                        connection.rollback();
                        connection.setAutoCommit(true);
                        connection.close();
                    } else if (!error && this.atomica) {
                        this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                        connection.commit();
                        connection.setAutoCommit(true);
                        connection.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean existsAccordoServizio(IDAccordo idAccordo) throws DriverRegistroServiziException {
        boolean bl;
        Connection connection;
        block19: {
            block17: {
                boolean bl2;
                block18: {
                    block15: {
                        boolean e22;
                        block16: {
                            if (this.atomica) {
                                try {
                                    connection = this.datasource.getConnection();
                                    connection.setAutoCommit(false);
                                }
                                catch (SQLException e22) {
                                    throw new DriverRegistroServiziException("DriverRegistroServiziDB::createAccordoServizio] SQLException accedendo al datasource :" + e22.getMessage(), e22);
                                }
                            } else {
                                connection = this.globalConnection;
                            }
                            this.log.debug((Object)("operazione atomica = " + this.atomica));
                            if (idAccordo.getSoggettoReferente() == null || this.existsSoggetto(idAccordo.getSoggettoReferente())) break block15;
                            e22 = false;
                            Object var7_7 = null;
                            if (!this.atomica) break block16;
                            try {
                                connection.close();
                            }
                            catch (Exception e3) {
                                // empty catch block
                            }
                        }
                        return e22;
                    }
                    long idAccordoLong = DBUtils.getIdAccordoServizio(idAccordo, connection, this.tipoDB);
                    if (idAccordoLong > 0L) break block17;
                    bl2 = false;
                    Object var7_8 = null;
                    if (!this.atomica) break block18;
                    try {
                        connection.close();
                    }
                    catch (Exception e3) {
                        // empty catch block
                    }
                }
                return bl2;
            }
            bl = true;
            Object var7_9 = null;
            if (!this.atomica) break block19;
            try {
                connection.close();
            }
            catch (Exception e3) {
                // empty catch block
            }
        }
        return bl;
        catch (Exception e) {
            try {
                throw new DriverRegistroServiziException(e);
            }
            catch (Throwable throwable) {
                block20: {
                    Object var7_10 = null;
                    if (!this.atomica) break block20;
                    try {
                        connection.close();
                    }
                    catch (Exception e3) {}
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public boolean existsAccordoServizio(long idAccordo) throws DriverRegistroServiziException {
        boolean bl;
        ResultSet rs;
        Statement stm;
        Connection connection;
        block21: {
            block19: {
                boolean bl2;
                block20: {
                    if (this.atomica) {
                        try {
                            connection = this.datasource.getConnection();
                            connection.setAutoCommit(false);
                        }
                        catch (SQLException e) {
                            throw new DriverRegistroServiziException("DriverRegistroServiziDB::createAccordoServizio] SQLException accedendo al datasource :" + e.getMessage());
                        }
                    } else {
                        connection = this.globalConnection;
                    }
                    this.log.debug((Object)("operazione atomica = " + this.atomica));
                    stm = null;
                    rs = null;
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                    sqlQueryObject.addFromTable("accordi");
                    sqlQueryObject.addSelectField("*");
                    sqlQueryObject.addWhereCondition("id = ?");
                    String sqlQuery = sqlQueryObject.createSQLQuery();
                    stm = connection.prepareStatement(sqlQuery);
                    stm.setLong(1, idAccordo);
                    rs = stm.executeQuery();
                    if (!rs.next()) break block19;
                    bl2 = true;
                    Object var10_11 = null;
                    if (!this.atomica) break block20;
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (stm != null) {
                            stm.close();
                        }
                        connection.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                return bl2;
            }
            bl = false;
            Object var10_12 = null;
            if (!this.atomica) break block21;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
                connection.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        return bl;
        catch (Exception e) {
            try {
                throw new DriverRegistroServiziException(e);
            }
            catch (Throwable throwable) {
                block22: {
                    Object var10_13 = null;
                    if (!this.atomica) break block22;
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (stm != null) {
                            stm.close();
                        }
                        connection.close();
                    }
                    catch (Exception e2) {}
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean existsAccordoServizioAzione(String nome, IDAccordo idAccordo) throws DriverRegistroServiziException {
        boolean e222;
        Connection connection;
        if (this.atomica) {
            try {
                connection = this.datasource.getConnection();
                connection.setAutoCommit(false);
            }
            catch (SQLException e222) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioAzione] SQLException accedendo al datasource :" + e222.getMessage());
            }
        } else {
            connection = this.globalConnection;
        }
        try {
            try {
                e222 = this.existsAccordoServizioAzione(nome, DBUtils.getIdAccordoServizio(idAccordo, connection, this.tipoDB));
                Object var6_7 = null;
                if (!this.atomica) return e222;
            }
            catch (Exception e4) {
                throw new DriverRegistroServiziException(e4);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (!this.atomica) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (Exception e3) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e3) {
            // empty catch block
            return e222;
        }
        connection.close();
        return e222;
    }

    /*
     * Loose catch block
     */
    public boolean existsAccordoServizioAzione(String nome, long idAccordo) throws DriverRegistroServiziException {
        boolean exist;
        block22: {
            Connection connection;
            exist = false;
            Statement stm = null;
            ResultSet rs = null;
            if (this.atomica) {
                try {
                    connection = this.datasource.getConnection();
                    connection.setAutoCommit(false);
                }
                catch (SQLException e) {
                    throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioAzione] SQLException accedendo al datasource :" + e.getMessage());
                }
            } else {
                connection = this.globalConnection;
            }
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("accordi_azioni");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordo);
            stm.setString(2, nome);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
            Object var11_11 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.atomica) {
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
            break block22;
            {
                catch (Exception e) {
                    exist = false;
                    throw new DriverRegistroServiziException(e);
                }
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (this.atomica) {
                    try {
                        connection.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return exist;
    }

    /*
     * Loose catch block
     */
    public boolean existsAccordoServizioAzione(long idAzione) throws DriverRegistroServiziException {
        boolean exist;
        block22: {
            Connection connection;
            exist = false;
            Statement stm = null;
            ResultSet rs = null;
            if (this.atomica) {
                try {
                    connection = this.datasource.getConnection();
                    connection.setAutoCommit(false);
                }
                catch (SQLException e) {
                    throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioAzione] SQLException accedendo al datasource :" + e.getMessage());
                }
            } else {
                connection = this.globalConnection;
            }
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("accordi_azioni");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idAzione);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
            Object var10_10 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.atomica) {
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
            break block22;
            {
                catch (Exception e) {
                    exist = false;
                    throw new DriverRegistroServiziException(e);
                }
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (this.atomica) {
                    try {
                        connection.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return exist;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean existsAccordoServizioPorttype(String nome, IDAccordo idAccordo) throws DriverRegistroServiziException {
        boolean e222;
        Connection connection;
        if (this.atomica) {
            try {
                connection = this.datasource.getConnection();
                connection.setAutoCommit(false);
            }
            catch (SQLException e222) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioAzione] SQLException accedendo al datasource :" + e222.getMessage());
            }
        } else {
            connection = this.globalConnection;
        }
        try {
            try {
                e222 = this.existsAccordoServizioPorttype(nome, DBUtils.getIdAccordoServizio(idAccordo, connection, this.tipoDB));
                Object var6_7 = null;
                if (!this.atomica) return e222;
            }
            catch (Exception e4) {
                throw new DriverRegistroServiziException(e4);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (!this.atomica) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (Exception e3) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e3) {
            // empty catch block
            return e222;
        }
        connection.close();
        return e222;
    }

    /*
     * Loose catch block
     */
    public boolean existsAccordoServizioOperation(long idAzione) throws DriverRegistroServiziException {
        boolean exist;
        block22: {
            Connection connection;
            exist = false;
            Statement stm = null;
            ResultSet rs = null;
            if (this.atomica) {
                try {
                    connection = this.datasource.getConnection();
                    connection.setAutoCommit(false);
                }
                catch (SQLException e) {
                    throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioAzione] SQLException accedendo al datasource :" + e.getMessage());
                }
            } else {
                connection = this.globalConnection;
            }
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("port_type_azioni");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idAzione);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
            Object var10_10 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.atomica) {
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
            break block22;
            {
                catch (Exception e) {
                    exist = false;
                    throw new DriverRegistroServiziException(e);
                }
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (this.atomica) {
                    try {
                        connection.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return exist;
    }

    /*
     * Loose catch block
     */
    public boolean existsAccordoServizioPorttype(String nome, long idAccordo) throws DriverRegistroServiziException {
        boolean exist;
        block22: {
            Connection connection;
            exist = false;
            Statement stm = null;
            ResultSet rs = null;
            if (this.atomica) {
                try {
                    connection = this.datasource.getConnection();
                    connection.setAutoCommit(false);
                }
                catch (SQLException e) {
                    throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioPorttype] SQLException accedendo al datasource :" + e.getMessage());
                }
            } else {
                connection = this.globalConnection;
            }
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("port_type");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordo);
            stm.setString(2, nome);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
            Object var11_11 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.atomica) {
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
            break block22;
            {
                catch (Exception e) {
                    exist = false;
                    throw new DriverRegistroServiziException(e);
                }
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (this.atomica) {
                    try {
                        connection.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return exist;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean existsAccordoServizioPorttypeOperation(String nome, IDPortType idPortType) throws DriverRegistroServiziException {
        boolean bl;
        Connection connection;
        if (this.atomica) {
            try {
                connection = this.datasource.getConnection();
                connection.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioAzione] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            connection = this.globalConnection;
        }
        try {
            try {
                long idAccordo = DBUtils.getIdAccordoServizio(idPortType.getIdAccordo(), connection, this.tipoDB);
                bl = this.existsAccordoServizioPorttypeOperation(nome, DBUtils.getIdPortType(idAccordo, idPortType.getNome(), connection));
                Object var8_8 = null;
                if (!this.atomica) return bl;
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException(e);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (!this.atomica) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (Exception e2) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e2) {
            // empty catch block
            return bl;
        }
        connection.close();
        return bl;
    }

    /*
     * Loose catch block
     */
    public boolean existsAccordoServizioPorttypeOperation(String nome, long idPortType) throws DriverRegistroServiziException {
        boolean exist;
        block22: {
            Connection connection;
            exist = false;
            Statement stm = null;
            ResultSet rs = null;
            if (this.atomica) {
                try {
                    connection = this.datasource.getConnection();
                    connection.setAutoCommit(false);
                }
                catch (SQLException e) {
                    throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioPorttypeOperation] SQLException accedendo al datasource :" + e.getMessage());
                }
            } else {
                connection = this.globalConnection;
            }
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("port_type_azioni");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_port_type = ?");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idPortType);
            stm.setString(2, nome);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
            Object var11_11 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.atomica) {
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
            break block22;
            {
                catch (Exception e) {
                    exist = false;
                    throw new DriverRegistroServiziException(e);
                }
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (this.atomica) {
                    try {
                        connection.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return exist;
    }

    /*
     * Loose catch block
     */
    @Override
    public void updateAccordoServizio(AccordoServizio accordoServizio) throws DriverRegistroServiziException {
        block62: {
            Documento doc;
            int i;
            if (accordoServizio == null) {
                throw new DriverRegistroServiziException("L'AccordoServizio non puo' essere null.");
            }
            String nome = accordoServizio.getNome();
            if (nome == null || nome.equals("")) {
                throw new DriverRegistroServiziException("Il nome dell'AccordoServizio non e' valido.");
            }
            Connection connection = null;
            Statement stm = null;
            ResultSet rs = null;
            String sqlQuery = "";
            String confermaRicezione = accordoServizio.getConfermaRicezione();
            String conegnaInOrdine = accordoServizio.getConsegnaInOrdine();
            String descrizione = accordoServizio.getDescrizione();
            String filtroDuplicati = accordoServizio.getFiltroDuplicati();
            String identificativoCollaborazione = accordoServizio.getIdCollaborazione();
            String profiloCollaborazione = accordoServizio.getProfiloCollaborazione();
            String scadenza = accordoServizio.getScadenza();
            boolean utilizzioSenzaAzione = accordoServizio.getUtilizzoSenzaAzione();
            String wsdlConcettuale = accordoServizio.getByteWsdlConcettuale() != null ? new String(accordoServizio.getByteWsdlConcettuale()) : null;
            String wsdlDefinitorio = accordoServizio.getByteWsdlDefinitorio() != null ? new String(accordoServizio.getByteWsdlDefinitorio()) : null;
            String wsdlLogicoErogatore = accordoServizio.getByteWsdlLogicoErogatore() != null ? new String(accordoServizio.getByteWsdlLogicoErogatore()) : null;
            String wsdlLogicoFruitore = accordoServizio.getByteWsdlLogicoFruitore() != null ? new String(accordoServizio.getByteWsdlLogicoFruitore()) : null;
            String wsblConcettuale = accordoServizio.getByteWsblConcettuale() != null ? new String(accordoServizio.getByteWsblConcettuale()) : null;
            String wsblLogicoErogatore = accordoServizio.getByteWsblLogicoErogatore() != null ? new String(accordoServizio.getByteWsblLogicoErogatore()) : null;
            String wsblLogicoFruitore = accordoServizio.getByteWsblLogicoFruitore() != null ? new String(accordoServizio.getByteWsblLogicoFruitore()) : null;
            String riferimento = accordoServizio.getByteCatalogoSchemiOntologie() != null ? new String(accordoServizio.getByteCatalogoSchemiOntologie()) : null;
            String firma = accordoServizio.getByteFirma() != null ? new String(accordoServizio.getByteFirma()) : null;
            String superUser = accordoServizio.getSuperUser();
            wsdlConcettuale = wsdlConcettuale != null && !"".equals(wsdlConcettuale.trim().replaceAll("\n", "")) ? wsdlConcettuale : null;
            wsdlDefinitorio = wsdlDefinitorio != null && !"".equals(wsdlDefinitorio.trim().replaceAll("\n", "")) ? wsdlDefinitorio : null;
            wsdlLogicoErogatore = wsdlLogicoErogatore != null && !"".equals(wsdlLogicoErogatore.trim().replaceAll("\n", "")) ? wsdlLogicoErogatore : null;
            wsdlLogicoFruitore = wsdlLogicoFruitore != null && !"".equals(wsdlLogicoFruitore.trim().replaceAll("\n", "")) ? wsdlLogicoFruitore : null;
            wsblConcettuale = wsblConcettuale != null && !"".equals(wsblConcettuale.trim().replaceAll("\n", "")) ? wsblConcettuale : null;
            wsblLogicoErogatore = wsblLogicoErogatore != null && !"".equals(wsblLogicoErogatore.trim().replaceAll("\n", "")) ? wsblLogicoErogatore : null;
            wsblLogicoFruitore = wsblLogicoFruitore != null && !"".equals(wsblLogicoFruitore.trim().replaceAll("\n", "")) ? wsblLogicoFruitore : null;
            riferimento = riferimento != null && !"".equals(riferimento.trim().replaceAll("\n", "")) ? riferimento : null;
            firma = firma != null && !"".equals(firma.trim().replaceAll("\n", "")) ? firma : null;
            boolean error = false;
            if (this.atomica) {
                try {
                    connection = this.datasource.getConnection();
                    connection.setAutoCommit(false);
                }
                catch (SQLException e) {
                    throw new DriverRegistroServiziException("DriverRegistroServiziDB::createAccordoServizio] SQLException accedendo al datasource :" + e.getMessage());
                }
            } else {
                connection = this.globalConnection;
            }
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            IDAccordo idAccordoAttualeInseritoDB = null;
            idAccordoAttualeInseritoDB = accordoServizio.getOldIDAccordoForUpdate() != null ? accordoServizio.getOldIDAccordoForUpdate() : IDAccordo.getIDAccordoFromAccordo(accordoServizio);
            long idAccordoLong = -1L;
            try {
                idAccordoLong = DBUtils.getIdAccordoServizio(idAccordoAttualeInseritoDB, connection, this.tipoDB);
            }
            catch (Exception e) {
                if (accordoServizio.getOldIDAccordoForUpdate() != null) {
                    idAccordoAttualeInseritoDB = accordoServizio.getSoggettoReferente() != null ? IDAccordo.getIDAccordoFromValues(idAccordoAttualeInseritoDB.getNome(), new IDSoggetto(accordoServizio.getSoggettoReferente().getTipo(), accordoServizio.getSoggettoReferente().getNome()), idAccordoAttualeInseritoDB.getVersione()) : IDAccordo.getIDAccordoFromValues(idAccordoAttualeInseritoDB.getNome(), null, idAccordoAttualeInseritoDB.getVersione());
                    idAccordoLong = DBUtils.getIdAccordoServizio(idAccordoAttualeInseritoDB, connection, this.tipoDB);
                }
                throw e;
            }
            if (idAccordoLong <= 0L) {
                throw new DriverRegistroServiziException("Impossibile recuperare l'id dell'Accordo di Servizio : " + nome);
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addUpdateTable("accordi");
            sqlQueryObject.addUpdateField("conferma_ricezione", "?");
            sqlQueryObject.addUpdateField("consegna_in_ordine", "?");
            sqlQueryObject.addUpdateField("descrizione", "?");
            sqlQueryObject.addUpdateField("filtro_duplicati", "?");
            sqlQueryObject.addUpdateField("identificativo_collaborazione", "?");
            sqlQueryObject.addUpdateField("nome", "?");
            sqlQueryObject.addUpdateField("profilo_collaborazione", "?");
            sqlQueryObject.addUpdateField("scadenza", "?");
            sqlQueryObject.addUpdateField("wsdl_concettuale", "?");
            sqlQueryObject.addUpdateField("wsdl_definitorio", "?");
            sqlQueryObject.addUpdateField("wsdl_logico_erogatore", "?");
            sqlQueryObject.addUpdateField("wsdl_logico_fruitore", "?");
            sqlQueryObject.addUpdateField("wsbl_concettuale", "?");
            sqlQueryObject.addUpdateField("wsbl_logico_erogatore", "?");
            sqlQueryObject.addUpdateField("wsbl_logico_fruitore", "?");
            sqlQueryObject.addUpdateField("riferimento", "?");
            sqlQueryObject.addUpdateField("superuser", "?");
            sqlQueryObject.addUpdateField("utilizzo_senza_azione", "?");
            sqlQueryObject.addUpdateField("privato", "?");
            sqlQueryObject.addUpdateField("firma", "?");
            if (accordoServizio.getStatoPackage() != null) {
                sqlQueryObject.addUpdateField("stato", "?");
            }
            if (accordoServizio.getOraRegistrazione() != null) {
                sqlQueryObject.addUpdateField("ora_registrazione", "?");
            }
            sqlQueryObject.addUpdateField("id_referente", "?");
            sqlQueryObject.addUpdateField("versione", "?");
            sqlQueryObject.addUpdateField("data_pubblicazione", "?");
            sqlQueryObject.addWhereCondition("id=?");
            sqlQuery = sqlQueryObject.createSQLUpdate();
            stm = connection.prepareStatement(sqlQuery);
            stm.setString(1, confermaRicezione);
            stm.setString(2, conegnaInOrdine);
            stm.setString(3, descrizione);
            stm.setString(4, filtroDuplicati);
            stm.setString(5, identificativoCollaborazione);
            stm.setString(6, nome);
            stm.setString(7, profiloCollaborazione);
            stm.setString(8, scadenza);
            stm.setString(9, wsdlConcettuale);
            stm.setString(10, wsdlDefinitorio);
            stm.setString(11, wsdlLogicoErogatore);
            stm.setString(12, wsdlLogicoFruitore);
            stm.setString(13, wsblConcettuale);
            stm.setString(14, wsblLogicoErogatore);
            stm.setString(15, wsblLogicoFruitore);
            stm.setString(16, riferimento);
            stm.setString(17, superUser);
            stm.setInt(18, utilizzioSenzaAzione ? 1 : 0);
            if (accordoServizio.getPrivato() != null && accordoServizio.getPrivato().booleanValue()) {
                stm.setInt(19, 1);
            } else {
                stm.setInt(19, 0);
            }
            stm.setString(20, firma);
            int param_index = 21;
            if (accordoServizio.getStatoPackage() != null) {
                stm.setString(param_index, accordoServizio.getStatoPackage());
                ++param_index;
            }
            if (accordoServizio.getOraRegistrazione() != null) {
                stm.setTimestamp(param_index, new Timestamp(accordoServizio.getOraRegistrazione().getTime()));
                ++param_index;
            }
            if (accordoServizio.getSoggettoReferente() != null) {
                long idSRef = DBUtils.getIdSoggetto(accordoServizio.getSoggettoReferente().getNome(), accordoServizio.getSoggettoReferente().getTipo(), connection, this.tipoDB, this.tabellaSoggetti);
                stm.setLong(param_index, idSRef);
                ++param_index;
            } else {
                stm.setLong(param_index, 0L);
                ++param_index;
            }
            if (accordoServizio.getVersione() != null && !"".equals(accordoServizio.getVersione())) {
                stm.setString(param_index, accordoServizio.getVersione());
                ++param_index;
            } else {
                stm.setString(param_index, "");
                ++param_index;
            }
            if (accordoServizio.getDataPubblicazione() != null) {
                stm.setTimestamp(param_index, new Timestamp(accordoServizio.getDataPubblicazione().getTime()));
            } else {
                stm.setTimestamp(param_index, new Timestamp(System.currentTimeMillis()));
            }
            stm.setLong(++param_index, idAccordoLong);
            ++param_index;
            this.log.debug((Object)("update accordoServizio : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, confermaRicezione, conegnaInOrdine, descrizione, filtroDuplicati, identificativoCollaborazione, nome, profiloCollaborazione, scadenza, wsdlConcettuale, wsdlDefinitorio, wsdlLogicoErogatore, wsdlLogicoFruitore, wsblConcettuale, wsblLogicoErogatore, wsblLogicoFruitore, riferimento, superUser, utilizzioSenzaAzione, idAccordoLong)));
            stm.executeUpdate();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("accordi_azioni");
            sqlQueryObject.addWhereCondition("id_accordo=?");
            String updateString = sqlQueryObject.createSQLDelete();
            stm = connection.prepareStatement(updateString);
            stm.setLong(1, idAccordoLong);
            int n = stm.executeUpdate();
            stm.close();
            this.log.debug((Object)("Cancellate " + n + " azioni associate all'accordo " + idAccordoLong));
            for (int i2 = 0; i2 < accordoServizio.sizeAzioneList(); ++i2) {
                Azione azione = accordoServizio.getAzione(i2);
                String profiloAzione = azione.getProfAzione();
                if (profiloAzione != null && profiloAzione.equals("default")) {
                    azione.setProfiloCollaborazione(profiloCollaborazione);
                }
                DriverRegistroServiziDB_LIB.CRUDAzione(1, accordoServizio, azione, connection, idAccordoLong);
            }
            this.log.debug((Object)("Inserite " + accordoServizio.sizeAzioneList() + " azioni associate all'accordo " + idAccordoLong));
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("port_type");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordoLong);
            rs = stm.executeQuery();
            Vector<Long> idPT = new Vector<Long>();
            while (rs.next()) {
                idPT.add(rs.getLong("id"));
            }
            rs.close();
            stm.close();
            this.log.debug((Object)("Trovati " + idPT.size() + " port type..."));
            while (idPT.size() > 0) {
                Long idPortType = (Long)idPT.remove(0);
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("port_type_azioni");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addWhereCondition("id_port_type=?");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = connection.prepareStatement(sqlQuery);
                stm.setLong(1, idPortType);
                rs = stm.executeQuery();
                Vector<Long> idPTAzione = new Vector<Long>();
                while (rs.next()) {
                    idPTAzione.add(rs.getLong("id"));
                }
                rs.close();
                stm.close();
                this.log.debug((Object)("Trovati " + idPTAzione.size() + " port type azioni..."));
                while (idPTAzione.size() > 0) {
                    Long idPortTypeAzione = (Long)idPTAzione.remove(0);
                    this.log.debug((Object)("Eliminazione message con id[" + idPortTypeAzione + "]..."));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                    sqlQueryObject.addDeleteTable("operation_messages");
                    sqlQueryObject.addWhereCondition("id_port_type_azione=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = connection.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortTypeAzione);
                    n = stm.executeUpdate();
                    stm.close();
                    this.log.debug((Object)("Cancellate " + n + " messages di un'azione con id[" + idPortTypeAzione + "] del port type [" + idPortType + "] associate all'accordo " + idAccordoLong));
                }
                this.log.debug((Object)("Elimino port type azione del port types [" + idPortType + "]..."));
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addDeleteTable("port_type_azioni");
                sqlQueryObject.addWhereCondition("id_port_type=?");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQuery = sqlQueryObject.createSQLDelete();
                stm = connection.prepareStatement(sqlQuery);
                stm.setLong(1, idPortType);
                n = stm.executeUpdate();
                stm.close();
                this.log.debug((Object)("Cancellate " + n + " azioni del port type [" + idPortType + "] associate all'accordo " + idAccordoLong));
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("port_type");
            sqlQueryObject.addWhereCondition("id_accordo=?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLDelete();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordoLong);
            n = stm.executeUpdate();
            stm.close();
            this.log.debug((Object)("Cancellate " + n + " port type associate all'accordo " + idAccordoLong));
            PortType pt = null;
            for (int i3 = 0; i3 < accordoServizio.sizePortTypeList(); ++i3) {
                pt = accordoServizio.getPortType(i3);
                DriverRegistroServiziDB_LIB.CRUDPortType(1, accordoServizio, pt, connection, idAccordoLong);
            }
            this.log.debug((Object)("inserite " + accordoServizio.sizePortTypeList() + " porttype relative all'accordo :" + nome + " id :" + idAccordoLong));
            if (accordoServizio.getServizioComposto() != null) {
                DriverRegistroServiziDB_LIB.CRUDAccordoServizioServizioComposto(3, null, connection, idAccordoLong);
                DriverRegistroServiziDB_LIB.CRUDAccordoServizioServizioComposto(1, accordoServizio.getServizioComposto(), connection, idAccordoLong);
            } else {
                DriverRegistroServiziDB_LIB.CRUDAccordoServizioServizioComposto(3, null, connection, idAccordoLong);
            }
            ArrayList<Documento> documenti = new ArrayList<Documento>();
            for (i = 0; i < accordoServizio.sizeAllegatoList(); ++i) {
                doc = accordoServizio.getAllegato(i);
                doc.setRuolo(RuoliDocumento.allegato.toString());
                documenti.add(doc);
            }
            for (i = 0; i < accordoServizio.sizeSpecificaSemiformaleList(); ++i) {
                doc = accordoServizio.getSpecificaSemiformale(i);
                doc.setRuolo(RuoliDocumento.specificaSemiformale.toString());
                documenti.add(doc);
            }
            if (accordoServizio.getServizioComposto() != null) {
                for (i = 0; i < accordoServizio.getServizioComposto().sizeSpecificaCoordinamentoList(); ++i) {
                    doc = accordoServizio.getServizioComposto().getSpecificaCoordinamento(i);
                    doc.setRuolo(RuoliDocumento.specificaCoordinamento.toString());
                    documenti.add(doc);
                }
            }
            DriverRegistroServiziDB_LIB.CRUDDocumento(2, documenti, idAccordoLong, ProprietariDocumento.accordoServizio, connection);
            Object var39_47 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    connection.rollback();
                    connection.setAutoCommit(true);
                    connection.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    connection.commit();
                    connection.setAutoCommit(true);
                    connection.close();
                }
                break block62;
            }
            catch (Exception e) {}
            break block62;
            {
                catch (DriverException e) {
                    error = true;
                    this.log.error((Object)"Driver Error.", (Throwable)e);
                    throw new DriverRegistroServiziException(e);
                }
                catch (SQLException se) {
                    this.log.error((Object)se);
                    error = true;
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateAccordoServizio] SQLException [" + se.getMessage() + "].", se);
                }
                catch (Exception se) {
                    this.log.error((Object)se);
                    error = true;
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateAccordoServizio] Exception [" + se.getMessage() + "].", se);
                }
            }
            catch (Throwable throwable) {
                Object var39_48 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (error && this.atomica) {
                        this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                        connection.rollback();
                        connection.setAutoCommit(true);
                        connection.close();
                    } else if (!error && this.atomica) {
                        this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                        connection.commit();
                        connection.setAutoCommit(true);
                        connection.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void updatePortType(PortType portType) throws DriverRegistroServiziException {
        block62: {
            if (portType == null) {
                throw new DriverRegistroServiziException("Il port-type non puo' essere null.");
            }
            String nome = portType.getNome();
            if (nome == null || nome.equals("")) {
                throw new DriverRegistroServiziException("Il nome del port-type non e' valido.");
            }
            Connection connection = null;
            Statement stm = null;
            Statement updateStmt = null;
            ResultSet rs = null;
            String sqlQuery = "";
            String updateQuery = "";
            boolean error = false;
            if (this.atomica) {
                try {
                    connection = this.datasource.getConnection();
                    connection.setAutoCommit(false);
                }
                catch (SQLException e) {
                    throw new DriverRegistroServiziException("DriverRegistroServiziDB::updatePortType] SQLException accedendo al datasource :" + e.getMessage());
                }
            } else {
                connection = this.globalConnection;
            }
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            AccordoServizio as = this.getAccordoServizio(portType.getIdAccordo(), connection);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("port_type_azioni");
            sqlQueryObject.addWhereCondition("id_port_type=?");
            sqlQuery = sqlQueryObject.createSQLDelete();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, portType.getId());
            int n = stm.executeUpdate();
            stm.close();
            this.log.debug((Object)("Cancellate " + n + " azioni del port type [" + portType.getId() + "]"));
            Operation azione = null;
            for (int i = 0; i < portType.sizeAzioneList(); ++i) {
                azione = portType.getAzione(i);
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addInsertTable("port_type_azioni");
                sqlQueryObject.addInsertField("id_port_type", "?");
                sqlQueryObject.addInsertField("nome", "?");
                sqlQueryObject.addInsertField("profilo_pt_azione", "?");
                sqlQueryObject.addInsertField("filtro_duplicati", "?");
                sqlQueryObject.addInsertField("conferma_ricezione", "?");
                sqlQueryObject.addInsertField("identificativo_collaborazione", "?");
                sqlQueryObject.addInsertField("consegna_in_ordine", "?");
                sqlQueryObject.addInsertField("scadenza", "?");
                sqlQueryObject.addInsertField("profilo_collaborazione", "?");
                sqlQueryObject.addInsertField("correlata", "?");
                sqlQueryObject.addInsertField("correlata_servizio", "?");
                updateQuery = sqlQueryObject.createSQLInsert();
                updateStmt = connection.prepareStatement(updateQuery);
                updateStmt.setLong(1, portType.getId());
                updateStmt.setString(2, azione.getNome());
                updateStmt.setString(3, azione.getProfAzione());
                if ("ridefinito".equals(azione.getProfAzione())) {
                    updateStmt.setString(4, azione.getFiltroDuplicati());
                    updateStmt.setString(5, azione.getConfermaRicezione());
                    updateStmt.setString(6, azione.getIdCollaborazione());
                    updateStmt.setString(7, azione.getConsegnaInOrdine());
                    updateStmt.setString(8, azione.getScadenza());
                    updateStmt.setString(9, azione.getProfiloCollaborazione());
                    updateStmt.setString(10, azione.getCorrelata());
                    updateStmt.setString(11, azione.getCorrelataServizio());
                } else {
                    if (azione.getFiltroDuplicati() != null) {
                        updateStmt.setString(4, azione.getFiltroDuplicati());
                    } else if (portType.getFiltroDuplicati() != null) {
                        updateStmt.setString(4, portType.getFiltroDuplicati());
                    } else {
                        updateStmt.setString(4, as.getFiltroDuplicati());
                    }
                    if (azione.getConfermaRicezione() != null) {
                        updateStmt.setString(5, azione.getConfermaRicezione());
                    } else if (portType.getConfermaRicezione() != null) {
                        updateStmt.setString(5, portType.getConfermaRicezione());
                    } else {
                        updateStmt.setString(5, as.getConfermaRicezione());
                    }
                    if (azione.getIdCollaborazione() != null) {
                        updateStmt.setString(6, azione.getIdCollaborazione());
                    } else if (portType.getIdCollaborazione() != null) {
                        updateStmt.setString(6, portType.getIdCollaborazione());
                    } else {
                        updateStmt.setString(6, as.getIdCollaborazione());
                    }
                    if (azione.getConsegnaInOrdine() != null) {
                        updateStmt.setString(7, azione.getConsegnaInOrdine());
                    } else if (portType.getConsegnaInOrdine() != null) {
                        updateStmt.setString(7, portType.getConsegnaInOrdine());
                    } else {
                        updateStmt.setString(7, as.getConsegnaInOrdine());
                    }
                    if (azione.getScadenza() != null) {
                        updateStmt.setString(8, azione.getScadenza());
                    } else if (portType.getScadenza() != null) {
                        updateStmt.setString(8, portType.getScadenza());
                    } else {
                        updateStmt.setString(8, as.getScadenza());
                    }
                    if (azione.getProfiloCollaborazione() != null) {
                        updateStmt.setString(9, azione.getProfiloCollaborazione());
                    } else if (portType.getProfiloCollaborazione() != null) {
                        updateStmt.setString(9, portType.getProfiloCollaborazione());
                    } else {
                        updateStmt.setString(9, as.getProfiloCollaborazione());
                    }
                    updateStmt.setString(10, azione.getCorrelata());
                    updateStmt.setString(11, azione.getCorrelataServizio());
                }
                n = updateStmt.executeUpdate();
                updateStmt.close();
            }
            DriverRegistroServiziDB_LIB.log.debug((Object)("inserite " + portType.sizeAzioneList() + " azioni relative al port type[" + portType.getNome() + "] id-porttype[" + portType.getId() + "]"));
            Object var16_19 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (stm != null) {
                    stm.close();
                }
                if (updateStmt != null) {
                    updateStmt.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    connection.rollback();
                    connection.setAutoCommit(true);
                    connection.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    connection.commit();
                    connection.setAutoCommit(true);
                    connection.close();
                }
                break block62;
            }
            catch (Exception e) {}
            break block62;
            {
                catch (DriverException e) {
                    error = true;
                    this.log.error((Object)"Driver Error.", (Throwable)e);
                    throw new DriverRegistroServiziException(e);
                }
                catch (SQLException se) {
                    this.log.error((Object)se);
                    error = true;
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updatePortType] SQLException [" + se.getMessage() + "].", se);
                }
                catch (Exception se) {
                    this.log.error((Object)se);
                    error = true;
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updatePortType] Exception [" + se.getMessage() + "].", se);
                }
            }
            catch (Throwable throwable) {
                Object var16_20 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (stm != null) {
                        stm.close();
                    }
                    if (updateStmt != null) {
                        updateStmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (error && this.atomica) {
                        this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                        connection.rollback();
                        connection.setAutoCommit(true);
                        connection.close();
                    } else if (!error && this.atomica) {
                        this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                        connection.commit();
                        connection.setAutoCommit(true);
                        connection.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public void deleteAccordoServizio(AccordoServizio accordoServizio) throws DriverRegistroServiziException {
        block36: {
            if (accordoServizio == null) {
                throw new DriverRegistroServiziException("L'AccordoServizio non puo' essere null.");
            }
            String nome = accordoServizio.getNome();
            if (nome == null || nome.equals("")) {
                throw new DriverRegistroServiziException("Il nome dell'AccordoServizio non e' valido.");
            }
            Connection connection = null;
            Statement stm = null;
            ResultSet rs = null;
            String sqlQuery = "";
            boolean error = false;
            if (this.atomica) {
                try {
                    connection = this.datasource.getConnection();
                    connection.setAutoCommit(false);
                }
                catch (SQLException e) {
                    throw new DriverRegistroServiziException("DriverRegistroServiziDB::createAccordoServizio] SQLException accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                connection = this.globalConnection;
            }
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            IDAccordo idAccordo = IDAccordo.getIDAccordoFromValues(nome, BeanUtilities.getSoggettoReferenteID(accordoServizio.getSoggettoReferente()), accordoServizio.getVersione());
            long idAccordoLong = DBUtils.getIdAccordoServizio(idAccordo, connection, this.tipoDB);
            if (idAccordoLong <= 0L) {
                throw new DriverRegistroServiziException("Impossibile recuperare l'id dell'Accordo di Servizio : " + nome);
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("accordi_azioni");
            sqlQueryObject.addWhereCondition("id_accordo=?");
            String updateString = sqlQueryObject.createSQLDelete();
            stm = connection.prepareStatement(updateString);
            stm.setLong(1, idAccordoLong);
            this.log.debug((Object)("delete azioni :" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idAccordoLong)));
            int n = stm.executeUpdate();
            stm.close();
            this.log.debug((Object)("cancellate " + n + " azioni."));
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("port_type");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordoLong);
            rs = stm.executeQuery();
            Vector<Long> idPT = new Vector<Long>();
            while (rs.next()) {
                idPT.add(rs.getLong("id"));
            }
            rs.close();
            stm.close();
            while (idPT.size() > 0) {
                Long idPortType = (Long)idPT.remove(0);
                Vector<Long> idPortTypeAzioni = new Vector<Long>();
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("port_type_azioni");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addWhereCondition("id_port_type=?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = connection.prepareStatement(sqlQuery);
                stm.setLong(1, idPortType);
                rs = stm.executeQuery();
                while (rs.next()) {
                    idPortTypeAzioni.add(rs.getLong("id"));
                }
                rs.close();
                stm.close();
                while (idPortTypeAzioni.size() > 0) {
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                    sqlQueryObject.addDeleteTable("operation_messages");
                    sqlQueryObject.addWhereCondition("id_port_type_azione=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = connection.prepareStatement(sqlQuery);
                    stm.setLong(1, (Long)idPortTypeAzioni.remove(0));
                    n = stm.executeUpdate();
                    stm.close();
                }
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addDeleteTable("port_type_azioni");
                sqlQueryObject.addWhereCondition("id_port_type=?");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQuery = sqlQueryObject.createSQLDelete();
                stm = connection.prepareStatement(sqlQuery);
                stm.setLong(1, idPortType);
                n = stm.executeUpdate();
                stm.close();
                this.log.debug((Object)("Cancellate " + n + " azioni del port type [" + idPortType + "] associate all'accordo " + idAccordoLong));
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("port_type");
            sqlQueryObject.addWhereCondition("id_accordo=?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLDelete();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordoLong);
            n = stm.executeUpdate();
            stm.close();
            this.log.debug((Object)("Cancellate " + n + " port type associate all'accordo " + idAccordoLong));
            DriverRegistroServiziDB_LIB.CRUDDocumento(3, null, idAccordoLong, ProprietariDocumento.accordoServizio, connection);
            if (accordoServizio.getServizioComposto() != null) {
                DriverRegistroServiziDB_LIB.CRUDAccordoServizioServizioComposto(3, accordoServizio.getServizioComposto(), connection, idAccordoLong);
            } else {
                DriverRegistroServiziDB_LIB.CRUDAccordoServizioServizioComposto(3, null, connection, idAccordoLong);
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("accordi");
            sqlQueryObject.addWhereCondition("id=?");
            updateString = sqlQueryObject.createSQLDelete();
            stm = connection.prepareStatement(updateString);
            stm.setLong(1, idAccordoLong);
            this.log.debug((Object)("delete accordoServizio :" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idAccordoLong)));
            stm.executeUpdate();
            stm.close();
            Object var18_20 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    connection.rollback();
                    connection.setAutoCommit(true);
                    connection.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    connection.commit();
                    connection.setAutoCommit(true);
                    connection.close();
                }
                break block36;
            }
            catch (Exception e) {}
            break block36;
            {
                catch (DriverException e) {
                    error = true;
                    this.log.error((Object)"Driver Error.", (Throwable)e);
                    throw new DriverRegistroServiziException(e);
                }
                catch (SQLException se) {
                    error = true;
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteAccordoServizio] SQLException [" + se.getMessage() + "].", se);
                }
                catch (Exception se) {
                    error = true;
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteAccordoServizio] Exception [" + se.getMessage() + "].", se);
                }
            }
            catch (Throwable throwable) {
                Object var18_21 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (error && this.atomica) {
                        this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                        connection.rollback();
                        connection.setAutoCommit(true);
                        connection.close();
                    } else if (!error && this.atomica) {
                        this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                        connection.commit();
                        connection.setAutoCommit(true);
                        connection.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public PortaDominio getPortaDominio(String nomePdD) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        this.log.debug((Object)("richiesto getPortaDominio: " + nomePdD));
        if (nomePdD == null) {
            throw new DriverRegistroServiziException("[getPortaDominio] Parametro nomePdD is null");
        }
        if (nomePdD.trim().equals("")) {
            throw new DriverRegistroServiziException("[getPortaDominio] Parametro nomePdD non e' definito");
        }
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::getPortaDominio] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("pdd");
        sqlQueryObject.addSelectField("*");
        sqlQueryObject.addWhereCondition("nome = ?");
        String queryString = sqlQueryObject.createSQLQuery();
        stm = con.prepareStatement(queryString);
        stm.setString(1, nomePdD);
        rs = stm.executeQuery();
        PortaDominio pdd = null;
        if (rs.next()) {
            pdd = new PortaDominio();
            pdd.setId(rs.getLong("id"));
            pdd.setNome(rs.getString("nome"));
            pdd.setDescrizione(rs.getString("descrizione"));
            pdd.setImplementazione(rs.getString("implementazione"));
            pdd.setSubject(rs.getString("subject"));
            pdd.setClientAuth(rs.getString("client_auth"));
            pdd.setSuperUser(rs.getString("superuser"));
            if (rs.getTimestamp("ora_registrazione") != null) {
                pdd.setOraRegistrazione(new Date(rs.getTimestamp("ora_registrazione").getTime()));
            }
        } else {
            throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getPortaDominio] rs.next non ha restituito valori con la seguente interrogazione :\n" + DriverRegistroServiziDB_LIB.formatSQLString(queryString, nomePdD));
        }
        PortaDominio portaDominio = pdd;
        Object var10_13 = null;
        try {
            rs.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            stm.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessioni al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        {
            return portaDominio;
            catch (DriverRegistroServiziNotFound e) {
                throw e;
            }
            catch (SQLException se) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getPortaDominio] SqlException: " + se.getMessage(), se);
            }
            catch (Exception se) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getPortaDominio] Exception: " + se.getMessage(), se);
            }
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            try {
                rs.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                stm.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public String[] getAllIdPorteDominio(FiltroSPCoop filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug((Object)"getAllIdPorteDominio...");
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("pdd");
        sqlQueryObject.addSelectField("*");
        if (filtroRicerca != null) {
            if (filtroRicerca.getMinDate() != null) {
                sqlQueryObject.addWhereCondition("ora_registrazione > ?");
            }
            if (filtroRicerca.getMaxDate() != null) {
                sqlQueryObject.addWhereCondition("ora_registrazione < ?");
            }
            if (filtroRicerca.getNome() != null) {
                sqlQueryObject.addWhereCondition("nome = ?");
            }
        }
        sqlQueryObject.setANDLogicOperator(true);
        String sqlQuery = sqlQueryObject.createSQLQuery();
        this.log.debug((Object)("eseguo query : " + sqlQuery));
        stm = con.prepareStatement(sqlQuery);
        int indexStmt = 1;
        if (filtroRicerca != null) {
            if (filtroRicerca.getMinDate() != null) {
                this.log.debug((Object)("minDate stmt.setTimestamp(" + filtroRicerca.getMinDate() + ")"));
                stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMinDate().getTime()));
                ++indexStmt;
            }
            if (filtroRicerca.getMaxDate() != null) {
                this.log.debug((Object)("maxDate stmt.setTimestamp(" + filtroRicerca.getMaxDate() + ")"));
                stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMaxDate().getTime()));
                ++indexStmt;
            }
            if (filtroRicerca.getNome() != null) {
                this.log.debug((Object)("nomeAccordo stmt.setString(" + filtroRicerca.getNome() + ")"));
                stm.setString(indexStmt, filtroRicerca.getNome());
                ++indexStmt;
            }
        }
        rs = stm.executeQuery();
        Vector<String> nomiPdd = new Vector<String>();
        while (rs.next()) {
            nomiPdd.add(rs.getString("nome"));
        }
        if (nomiPdd.size() == 0) {
            if (filtroRicerca != null) {
                throw new DriverRegistroServiziNotFound("Porte di Dominio non trovate che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            throw new DriverRegistroServiziNotFound("Porte di Dominio non trovate");
        }
        String[] res = new String[1];
        String[] stringArray = nomiPdd.toArray(res);
        Object var12_13 = null;
        try {
            if (rs != null) {
                rs.close();
            }
            if (stm != null) {
                stm.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessione al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        {
            return stringArray;
            catch (DriverRegistroServiziNotFound de) {
                throw de;
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("getAllIdPorteDominio error", e);
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void createPortaDominio(PortaDominio pdd) throws DriverRegistroServiziException {
        if (pdd == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createPortaDominio] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createPortaDominio] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            try {
                this.log.debug((Object)"CRUDPortaDominio type = 1");
                DriverRegistroServiziDB_LIB.CRUDPortaDominio(1, pdd, con);
            }
            catch (Exception qe) {
                error = true;
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createPortaDominio] Errore durante la creazione del soggetto : " + qe.getMessage(), qe);
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                    throw throwable;
                }
                if (error) throw throwable;
                if (!this.atomica) throw throwable;
                this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                con.commit();
                con.setAutoCommit(true);
                con.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        if (error && this.atomica) {
            this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
            con.rollback();
            con.setAutoCommit(true);
            con.close();
            return;
        }
        if (error) return;
        if (!this.atomica) return;
        this.log.debug((Object)"eseguo commit e rilascio connessioni...");
        con.commit();
        con.setAutoCommit(true);
        con.close();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean existsPortaDominio(String nome) throws DriverRegistroServiziException {
        boolean exist;
        block30: {
            exist = false;
            Connection con = null;
            Statement stm = null;
            ResultSet rs = null;
            if (nome == null) {
                throw new DriverRegistroServiziException("Parametro non valido");
            }
            if (nome.equals("")) {
                throw new DriverRegistroServiziException("Parametro vuoto non valido");
            }
            if (this.atomica) {
                try {
                    con = this.datasource.getConnection();
                    con.setAutoCommit(false);
                }
                catch (SQLException e) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::existsPortaDominio] SQLException accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.globalConnection;
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("pdd");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, nome);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
            Object var9_10 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            if (this.atomica) {
                try {
                    con.close();
                }
                catch (Exception e2) {}
            }
            break block30;
            {
                catch (Exception e) {
                    exist = false;
                    this.log.error((Object)"Errore durante verifica esistenza porta di dominio :", (Throwable)e);
                    Object var9_11 = null;
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (stm != null) {
                            stm.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    if (this.atomica) {
                        try {
                            con.close();
                        }
                        catch (Exception e2) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                if (this.atomica) {
                    try {
                        con.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return exist;
    }

    /*
     * Loose catch block
     */
    @Override
    public void updatePortaDominio(PortaDominio pdd) throws DriverRegistroServiziException {
        block26: {
            if (pdd == null) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updatePortaDominio] Parametro non valido.");
            }
            Statement stm = null;
            ResultSet rs = null;
            Connection con = null;
            boolean error = false;
            if (this.atomica) {
                try {
                    con = this.datasource.getConnection();
                    con.setAutoCommit(false);
                }
                catch (SQLException e) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updatePortaDominio] SQLException accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.globalConnection;
            }
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            DriverRegistroServiziDB_LIB.CRUDPortaDominio(2, pdd, con);
            Object var8_8 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
                break block26;
            }
            catch (Exception e) {}
            break block26;
            {
                catch (Exception qe) {
                    error = true;
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updatePortaDominio] Errore durante l'aggiornamento della porta di dominio : " + qe.getMessage(), qe);
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (error && this.atomica) {
                        this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                        con.rollback();
                        con.setAutoCommit(true);
                        con.close();
                    } else if (!error && this.atomica) {
                        this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                        con.commit();
                        con.setAutoCommit(true);
                        con.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void updateTipoPortaDominio(String nomePdd, String tipo) throws DriverRegistroServiziException {
        block27: {
            if (nomePdd == null) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateTipoPortaDominio] Parametro non valido.");
            }
            if (tipo == null) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateTipoPortaDominio] Parametro.tipo non valido.");
            }
            Statement stm = null;
            ResultSet rs = null;
            Connection con = null;
            boolean error = false;
            if (this.atomica) {
                try {
                    con = this.datasource.getConnection();
                    con.setAutoCommit(false);
                }
                catch (SQLException e) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updatePortaDominio] SQLException accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.globalConnection;
            }
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addUpdateTable("pdd");
            sqlQueryObject.addUpdateField("tipo", "?");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLUpdate();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, tipo);
            stm.setString(2, nomePdd);
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, tipo, nomePdd)));
            stm.executeUpdate();
            Object var10_11 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
                break block27;
            }
            catch (Exception e) {}
            break block27;
            {
                catch (Exception qe) {
                    error = true;
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updatePortaDominio] Errore durante l'aggiornamento della porta di dominio : " + qe.getMessage(), qe);
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (error && this.atomica) {
                        this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                        con.rollback();
                        con.setAutoCommit(true);
                        con.close();
                    } else if (!error && this.atomica) {
                        this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                        con.commit();
                        con.setAutoCommit(true);
                        con.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void deletePortaDominio(PortaDominio pdd) throws DriverRegistroServiziException {
        if (pdd == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deletePortaDominio] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deletePortaDominio] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            try {
                this.log.debug((Object)"CRUDSoggetto type = 3");
                DriverRegistroServiziDB_LIB.CRUDPortaDominio(3, pdd, con);
            }
            catch (Exception qe) {
                error = true;
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deletePortaDominio] Errore durante l'eliminazione della porta di dominio : " + qe.getMessage(), qe);
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                    throw throwable;
                }
                if (error) throw throwable;
                if (!this.atomica) throw throwable;
                this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                con.commit();
                con.setAutoCommit(true);
                con.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        if (error && this.atomica) {
            this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
            con.rollback();
            con.setAutoCommit(true);
            con.close();
            return;
        }
        if (error) return;
        if (!this.atomica) return;
        this.log.debug((Object)"eseguo commit e rilascio connessioni...");
        con.commit();
        con.setAutoCommit(true);
        con.close();
        return;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public SoggettoSpcoop getSoggettoRegistro(IDSoggetto idSoggetto) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connettore connettore;
        if (idSoggetto == null) {
            throw new DriverRegistroServiziException("[getSoggettoRegistro] Parametro idSoggetto is null");
        }
        String nomeSogg = idSoggetto.getNome();
        String tipoSogg = idSoggetto.getTipo();
        if (nomeSogg == null || nomeSogg.trim().equals("") || tipoSogg == null || tipoSogg.trim().equals("")) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getSoggetto] : soggetto non specificato.");
        }
        SoggettoSpcoop soggettoSPcoop = null;
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::getSoggetto] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("soggetti");
        sqlQueryObject.addSelectField("*");
        sqlQueryObject.addWhereCondition("nome_soggetto = ?");
        sqlQueryObject.addWhereCondition("tipo_soggetto = ?");
        sqlQueryObject.setANDLogicOperator(true);
        String sqlQuery = sqlQueryObject.createSQLQuery();
        stm = con.prepareStatement(sqlQuery);
        stm.setString(1, nomeSogg);
        stm.setString(2, tipoSogg);
        this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, nomeSogg, tipoSogg)));
        rs = stm.executeQuery();
        if (rs.next()) {
            soggettoSPcoop = new SoggettoSpcoop();
            soggettoSPcoop.setId(rs.getLong("id"));
            soggettoSPcoop.setNome(nomeSogg);
            soggettoSPcoop.setTipo(tipoSogg);
            String tmp = rs.getString("descrizione");
            soggettoSPcoop.setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
            tmp = rs.getString("identificativo_porta");
            soggettoSPcoop.setIdentificativoPorta(tmp == null || tmp.equals("") ? null : tmp);
            tmp = rs.getString("server");
            soggettoSPcoop.setPortaDominio(tmp == null || tmp.equals("") ? null : tmp);
            tmp = rs.getString("superuser");
            soggettoSPcoop.setSuperUser(tmp == null || tmp.equals("") ? null : tmp);
            if (rs.getInt("privato") == 1) {
                soggettoSPcoop.setPrivato(true);
            } else {
                soggettoSPcoop.setPrivato(false);
            }
            tmp = rs.getString("codice_ipa");
            soggettoSPcoop.setCodiceIpa(tmp == null || tmp.equals("") ? null : tmp);
            if (rs.getTimestamp("ora_registrazione") != null) {
                soggettoSPcoop.setOraRegistrazione(new Date(rs.getTimestamp("ora_registrazione").getTime()));
            }
            long idConnettore = rs.getLong("id_connettore");
            connettore = this.getConnettore(idConnettore, con);
            String profilo = rs.getString("profilo");
            if (profilo != null) {
                profilo = profilo.trim();
                soggettoSPcoop.setProfilo(profilo);
            }
        } else {
            throw new DriverRegistroServiziNotFound("Nessun soggetto trovato eseguendo: " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, nomeSogg, tipoSogg));
        }
        soggettoSPcoop.setConnettore(connettore);
        SoggettoSpcoop soggettoSpcoop = soggettoSPcoop;
        Object var16_18 = null;
        try {
            rs.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            stm.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessioni al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        {
            return soggettoSpcoop;
            catch (DriverRegistroServiziNotFound e) {
                throw e;
            }
            catch (SQLException se) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getSoggetto] SqlException: " + se.getMessage(), se);
            }
            catch (Exception se) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getSoggetto] Exception: " + se.getMessage(), se);
            }
        }
        catch (Throwable throwable) {
            Object var16_19 = null;
            try {
                rs.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                stm.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public IDSoggetto[] getAllIdSoggettiRegistro(FiltroSPCoop filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug((Object)"getAllIdSoggettiRegistro...");
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("soggetti");
        sqlQueryObject.addSelectField("*");
        if (filtroRicerca != null) {
            if (filtroRicerca.getMinDate() != null) {
                sqlQueryObject.addWhereCondition("ora_registrazione > ?");
            }
            if (filtroRicerca.getMaxDate() != null) {
                sqlQueryObject.addWhereCondition("ora_registrazione < ?");
            }
            if (filtroRicerca.getTipo() != null) {
                sqlQueryObject.addWhereCondition("tipo_soggetto = ?");
            }
            if (filtroRicerca.getNome() != null) {
                sqlQueryObject.addWhereCondition("nome_soggetto = ?");
            }
        }
        sqlQueryObject.setANDLogicOperator(true);
        String sqlQuery = sqlQueryObject.createSQLQuery();
        this.log.debug((Object)("eseguo query : " + sqlQuery));
        stm = con.prepareStatement(sqlQuery);
        int indexStmt = 1;
        if (filtroRicerca != null) {
            if (filtroRicerca.getMinDate() != null) {
                this.log.debug((Object)("minDate stmt.setTimestamp(" + filtroRicerca.getMinDate() + ")"));
                stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMinDate().getTime()));
                ++indexStmt;
            }
            if (filtroRicerca.getMaxDate() != null) {
                this.log.debug((Object)("maxDate stmt.setTimestamp(" + filtroRicerca.getMaxDate() + ")"));
                stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMaxDate().getTime()));
                ++indexStmt;
            }
            if (filtroRicerca.getTipo() != null) {
                this.log.debug((Object)("tipoSoggetto stmt.setString(" + filtroRicerca.getTipo() + ")"));
                stm.setString(indexStmt, filtroRicerca.getTipo());
                ++indexStmt;
            }
            if (filtroRicerca.getNome() != null) {
                this.log.debug((Object)("nomeSoggetto stmt.setString(" + filtroRicerca.getNome() + ")"));
                stm.setString(indexStmt, filtroRicerca.getNome());
                ++indexStmt;
            }
        }
        rs = stm.executeQuery();
        Vector<IDSoggetto> idSoggetti = new Vector<IDSoggetto>();
        while (rs.next()) {
            IDSoggetto idS = new IDSoggetto(rs.getString("tipo_soggetto"), rs.getString("nome_soggetto"));
            idSoggetti.add(idS);
        }
        if (idSoggetti.size() == 0) {
            if (filtroRicerca != null) {
                throw new DriverRegistroServiziNotFound("Soggetti non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            throw new DriverRegistroServiziNotFound("Soggetti non trovati");
        }
        IDSoggetto[] res = new IDSoggetto[1];
        IDSoggetto[] iDSoggettoArray = idSoggetti.toArray(res);
        Object var12_13 = null;
        try {
            if (rs != null) {
                rs.close();
            }
            if (stm != null) {
                stm.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessione al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        {
            return iDSoggettoArray;
            catch (DriverRegistroServiziNotFound de) {
                throw de;
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("getAllIdSoggettiRegistro error", e);
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void createSoggetto(SoggettoSpcoop soggetto) throws DriverRegistroServiziException {
        if (soggetto == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createSoggetto] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createSoggetto] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            try {
                this.log.debug((Object)"CRUDSoggetto type = 1");
                DriverRegistroServiziDB_LIB.CRUDSoggetto(1, soggetto, con);
            }
            catch (Exception qe) {
                error = true;
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createSoggetto] Errore durante la creazione del soggetto : " + qe.getMessage(), qe);
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                    throw throwable;
                }
                if (error) throw throwable;
                if (!this.atomica) throw throwable;
                this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                con.commit();
                con.setAutoCommit(true);
                con.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        if (error && this.atomica) {
            this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
            con.rollback();
            con.setAutoCommit(true);
            con.close();
            return;
        }
        if (error) return;
        if (!this.atomica) return;
        this.log.debug((Object)"eseguo commit e rilascio connessioni...");
        con.commit();
        con.setAutoCommit(true);
        con.close();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean existsSoggetto(IDSoggetto idSoggetto) throws DriverRegistroServiziException {
        boolean exist;
        block31: {
            exist = false;
            Connection con = null;
            Statement stm = null;
            ResultSet rs = null;
            if (idSoggetto == null) {
                throw new DriverRegistroServiziException("Parametro non valido");
            }
            String nome_soggetto = idSoggetto.getNome();
            String tipo_soggetto = idSoggetto.getTipo();
            if (nome_soggetto == null || nome_soggetto.equals("")) {
                throw new DriverRegistroServiziException("Parametro Nome non valido");
            }
            if (tipo_soggetto == null || tipo_soggetto.equals("")) {
                throw new DriverRegistroServiziException("Parametro Tipo non valido");
            }
            if (this.atomica) {
                try {
                    con = this.datasource.getConnection();
                    con.setAutoCommit(false);
                }
                catch (SQLException e) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::existsSoggetto] SQLException accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.globalConnection;
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome_soggetto = ?");
            sqlQueryObject.addWhereCondition("tipo_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, nome_soggetto);
            stm.setString(2, tipo_soggetto);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
            Object var11_12 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            if (this.atomica) {
                try {
                    con.close();
                }
                catch (Exception e2) {}
            }
            break block31;
            {
                catch (Exception e) {
                    exist = false;
                    this.log.error((Object)"Errore durante verifica esistenza soggetto :", (Throwable)e);
                    Object var11_13 = null;
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (stm != null) {
                            stm.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    if (this.atomica) {
                        try {
                            con.close();
                        }
                        catch (Exception e2) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                if (this.atomica) {
                    try {
                        con.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return exist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean existsSoggetto(long idSoggetto) throws DriverRegistroServiziException {
        boolean exist;
        block28: {
            exist = false;
            Connection con = null;
            Statement stm = null;
            ResultSet rs = null;
            if (this.atomica) {
                try {
                    con = this.datasource.getConnection();
                    con.setAutoCommit(false);
                }
                catch (SQLException e) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::existsSoggetto] SQLException accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.globalConnection;
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idSoggetto);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
            Object var10_10 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            if (this.atomica) {
                try {
                    con.close();
                }
                catch (Exception e2) {}
            }
            break block28;
            {
                catch (Exception e) {
                    exist = false;
                    this.log.error((Object)"Errore durante verifica esistenza soggetto :", (Throwable)e);
                    Object var10_11 = null;
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (stm != null) {
                            stm.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    if (this.atomica) {
                        try {
                            con.close();
                        }
                        catch (Exception e2) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                if (this.atomica) {
                    try {
                        con.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return exist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean existsSoggetto(String codiceIPA) throws DriverRegistroServiziException {
        boolean exist;
        block29: {
            exist = false;
            Connection con = null;
            Statement stm = null;
            ResultSet rs = null;
            if (codiceIPA == null || codiceIPA.equals("")) {
                throw new DriverRegistroServiziException("Parametro non valido");
            }
            if (this.atomica) {
                try {
                    con = this.datasource.getConnection();
                    con.setAutoCommit(false);
                }
                catch (SQLException e) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::existsSoggetto] SQLException accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.globalConnection;
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("codice_ipa = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, codiceIPA);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
            Object var9_10 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            if (this.atomica) {
                try {
                    con.close();
                }
                catch (Exception e2) {}
            }
            break block29;
            {
                catch (Exception e) {
                    exist = false;
                    this.log.error((Object)"Errore durante verifica esistenza soggetto :", (Throwable)e);
                    Object var9_11 = null;
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (stm != null) {
                            stm.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    if (this.atomica) {
                        try {
                            con.close();
                        }
                        catch (Exception e2) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                if (this.atomica) {
                    try {
                        con.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return exist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public SoggettoSpcoop getSoggetto(String codiceIPA) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        long idSoggetto;
        block30: {
            Connection con = null;
            Statement stm = null;
            ResultSet rs = null;
            idSoggetto = -1L;
            if (codiceIPA == null || codiceIPA.equals("")) {
                throw new DriverRegistroServiziException("Parametro non valido");
            }
            if (this.atomica) {
                try {
                    con = this.datasource.getConnection();
                    con.setAutoCommit(false);
                }
                catch (SQLException e) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::existsSoggetto] SQLException accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.globalConnection;
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("codice_ipa = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, codiceIPA);
            rs = stm.executeQuery();
            if (rs.next()) {
                idSoggetto = rs.getLong("id");
            }
            rs.close();
            stm.close();
            Object var10_10 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            if (this.atomica) {
                try {
                    con.close();
                }
                catch (Exception e2) {}
            }
            break block30;
            {
                catch (Exception e) {
                    this.log.error((Object)"Errore durante verifica esistenza soggetto :", (Throwable)e);
                    Object var10_11 = null;
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (stm != null) {
                            stm.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    if (this.atomica) {
                        try {
                            con.close();
                        }
                        catch (Exception e2) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                if (this.atomica) {
                    try {
                        con.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        if (idSoggetto <= 0L) {
            throw new DriverRegistroServiziNotFound("Soggetto con Codice IPA [" + codiceIPA + "] non trovato");
        }
        return this.getSoggettoRegistro(idSoggetto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String getCodiceIPA(IDSoggetto idSoggetto) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        String tipo_soggetto;
        String nome_soggetto;
        String codiceIPA;
        block32: {
            Connection con = null;
            Statement stm = null;
            ResultSet rs = null;
            codiceIPA = null;
            if (idSoggetto == null) {
                throw new DriverRegistroServiziException("Parametro non valido");
            }
            nome_soggetto = idSoggetto.getNome();
            tipo_soggetto = idSoggetto.getTipo();
            if (nome_soggetto == null || nome_soggetto.equals("")) {
                throw new DriverRegistroServiziException("Parametro Nome non valido");
            }
            if (tipo_soggetto == null || tipo_soggetto.equals("")) {
                throw new DriverRegistroServiziException("Parametro Tipo non valido");
            }
            if (this.atomica) {
                try {
                    con = this.datasource.getConnection();
                    con.setAutoCommit(false);
                }
                catch (SQLException e) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::existsSoggetto] SQLException accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.globalConnection;
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("tipo_soggetto = ?");
            sqlQueryObject.addWhereCondition("nome_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, tipo_soggetto);
            stm.setString(2, nome_soggetto);
            rs = stm.executeQuery();
            if (rs.next()) {
                codiceIPA = rs.getString("codice_ipa");
            }
            rs.close();
            stm.close();
            Object var11_12 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            if (this.atomica) {
                try {
                    con.close();
                }
                catch (Exception e2) {}
            }
            break block32;
            {
                catch (Exception e) {
                    this.log.error((Object)"Errore durante verifica esistenza soggetto :", (Throwable)e);
                    Object var11_13 = null;
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (stm != null) {
                            stm.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    if (this.atomica) {
                        try {
                            con.close();
                        }
                        catch (Exception e2) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                if (this.atomica) {
                    try {
                        con.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        if (codiceIPA == null) {
            throw new DriverRegistroServiziNotFound("Soggetto [" + tipo_soggetto + "/" + nome_soggetto + "] non trovato");
        }
        return codiceIPA;
    }

    /*
     * Loose catch block
     */
    @Override
    public void updateSoggetto(SoggettoSpcoop soggetto) throws DriverRegistroServiziException {
        block33: {
            if (soggetto == null) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateSoggetto] Parametro non valido.");
            }
            Statement stm = null;
            ResultSet rs = null;
            Connection con = null;
            boolean error = false;
            if (this.atomica) {
                try {
                    con = this.datasource.getConnection();
                    con.setAutoCommit(false);
                }
                catch (SQLException e) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateSoggetto] SQLException accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.globalConnection;
            }
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            String oldNomeSoggetto = soggetto.getOldNomeForUpdate();
            String oldTipoSoggetto = soggetto.getOldTipoForUpdate();
            String nomeSoggetto = soggetto.getNome();
            String tipoSoggetto = soggetto.getTipo();
            if (tipoSoggetto == null || tipoSoggetto.equals("")) {
                throw new DriverRegistroServiziException("Parametro Tipo Soggetto non valido.");
            }
            if (nomeSoggetto == null || nomeSoggetto.equals("")) {
                throw new DriverRegistroServiziException("Parametro Nome Soggetto non valido.");
            }
            if (oldNomeSoggetto == null || oldNomeSoggetto.equals("")) {
                oldNomeSoggetto = nomeSoggetto;
            }
            if (oldTipoSoggetto == null || oldTipoSoggetto.equals("")) {
                oldTipoSoggetto = tipoSoggetto;
            }
            if (!tipoSoggetto.equals(oldTipoSoggetto) || !nomeSoggetto.equals(oldNomeSoggetto)) {
                String newNomeConnettore;
                String[] val;
                String oldNomeConnettore;
                Connettore connettore;
                long idConnettore;
                String regex = "CNT_SF_(.*)\\/(.*)_(.*)\\/(.*)_(.*)\\/(.*)";
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addFromTable("servizi_fruitori");
                sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
                sqlQueryObject.addSelectField("soggetti.nome_soggetto");
                sqlQueryObject.addSelectField("servizi_fruitori.id_connettore");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = servizi.id");
                sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
                sqlQueryObject.addWhereCondition("soggetti.tipo_soggetto = ?");
                sqlQueryObject.addWhereCondition("soggetti.nome_soggetto = ?");
                sqlQueryObject.setANDLogicOperator(true);
                String sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setString(1, oldTipoSoggetto);
                stm.setString(2, oldNomeSoggetto);
                rs = stm.executeQuery();
                while (rs.next()) {
                    idConnettore = rs.getLong("id_connettore");
                    connettore = this.getConnettore(idConnettore, con);
                    oldNomeConnettore = connettore.getNome();
                    if (!oldNomeConnettore.matches(regex)) continue;
                    this.log.debug((Object)("Tento aggiornamento connettore id: [" + idConnettore + "] oldNome: [" + oldNomeConnettore + "]..."));
                    val = oldNomeConnettore.split("_");
                    newNomeConnettore = "CNT_SF_" + val[2] + tipoSoggetto + "/" + nomeSoggetto + val[4];
                    this.log.debug((Object)("nuovo nome connettore [" + newNomeConnettore + "]"));
                    connettore.setNome(newNomeConnettore);
                    DriverRegistroServiziDB_LIB.CRUDConnettore(2, connettore, con);
                }
                rs.close();
                stm.close();
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addFromTable("servizi_fruitori");
                sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
                sqlQueryObject.addSelectField("soggetti.nome_soggetto");
                sqlQueryObject.addSelectField("servizi_fruitori.id_connettore");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
                sqlQueryObject.addWhereCondition("soggetti.tipo_soggetto = ?");
                sqlQueryObject.addWhereCondition("soggetti.nome_soggetto = ?");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setString(1, oldTipoSoggetto);
                stm.setString(2, oldNomeSoggetto);
                rs = stm.executeQuery();
                while (rs.next()) {
                    idConnettore = rs.getLong("id_connettore");
                    connettore = this.getConnettore(idConnettore, con);
                    oldNomeConnettore = connettore.getNome();
                    if (!oldNomeConnettore.matches(regex)) continue;
                    this.log.debug((Object)("Tento aggiornamento connettore id: [" + idConnettore + "] oldNome: [" + oldNomeConnettore + "]..."));
                    val = oldNomeConnettore.split("_");
                    newNomeConnettore = "CNT_SF_" + tipoSoggetto + "/" + nomeSoggetto + val[3] + val[4];
                    this.log.debug((Object)("nuovo nome connettore [" + newNomeConnettore + "]"));
                    connettore.setNome(newNomeConnettore);
                    DriverRegistroServiziDB_LIB.CRUDConnettore(2, connettore, con);
                }
                rs.close();
                stm.close();
            }
            DriverRegistroServiziDB_LIB.CRUDSoggetto(2, soggetto, con);
            Object var20_20 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
                break block33;
            }
            catch (Exception e) {}
            break block33;
            {
                catch (Exception qe) {
                    error = true;
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateSoggetto] Errore durante l'aggiornamento del soggetto : " + qe.getMessage(), qe);
                }
            }
            catch (Throwable throwable) {
                Object var20_21 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (error && this.atomica) {
                        this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                        con.rollback();
                        con.setAutoCommit(true);
                        con.close();
                    } else if (!error && this.atomica) {
                        this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                        con.commit();
                        con.setAutoCommit(true);
                        con.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void deleteSoggetto(SoggettoSpcoop soggetto) throws DriverRegistroServiziException {
        if (soggetto == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteSoggetto] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteSoggetto] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            try {
                this.log.debug((Object)"CRUDSoggetto type = 3");
                DriverRegistroServiziDB_LIB.CRUDSoggetto(3, soggetto, con);
            }
            catch (Exception qe) {
                error = true;
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteSoggetto] Errore durante l'eliminazione del soggetto : " + qe.getMessage(), qe);
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                    throw throwable;
                }
                if (error) throw throwable;
                if (!this.atomica) throw throwable;
                this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                con.commit();
                con.setAutoCommit(true);
                con.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        if (error && this.atomica) {
            this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
            con.rollback();
            con.setAutoCommit(true);
            con.close();
            return;
        }
        if (error) return;
        if (!this.atomica) return;
        this.log.debug((Object)"eseguo commit e rilascio connessioni...");
        con.commit();
        con.setAutoCommit(true);
        con.close();
        return;
    }

    /*
     * Loose catch block
     */
    public IDSoggetto[] getSoggettiWithSuperuser(String user) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        IDSoggetto[] idSoggetti;
        block24: {
            ResultSet rs;
            Statement stm;
            Connection con;
            block22: {
                idSoggetti = null;
                con = null;
                stm = null;
                rs = null;
                String sqlQuery = "";
                if (this.atomica) {
                    try {
                        con = this.datasource.getConnection();
                    }
                    catch (SQLException e) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziException::getSoggettiWithSuperuser] SQLException accedendo al datasource :" + e.getMessage(), e);
                    }
                } else {
                    con = this.globalConnection;
                }
                this.log.debug((Object)("operazione this.atomica = " + this.atomica));
                Vector<IDSoggetto> idTrovati = new Vector<IDSoggetto>();
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("tipo_soggetto");
                sqlQueryObject.addSelectField("nome_soggetto");
                sqlQueryObject.addWhereCondition("superuser = ?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setString(1, user);
                this.log.debug((Object)("eseguo query : " + DBUtils.formatSQLString(sqlQuery, "abilitato")));
                rs = stm.executeQuery();
                while (rs.next()) {
                    IDSoggetto id = new IDSoggetto();
                    id.setTipo(rs.getString("tipo_soggetto"));
                    id.setNome(rs.getString("nome_soggetto"));
                    idTrovati.add(id);
                }
                if (idTrovati.size() <= 0) break block22;
                idSoggetti = new IDSoggetto[1];
                idSoggetti = idTrovati.toArray(idSoggetti);
            }
            Object var11_13 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
                break block24;
            }
            catch (Exception e) {}
            break block24;
            {
                catch (SQLException se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziException::getSoggettiWithSuperuser] SqlException: " + se.getMessage(), se);
                }
                catch (Exception se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziException::getSoggettiWithSuperuser] Exception: " + se.getMessage(), se);
                }
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return idSoggetti;
    }

    @Override
    public ServizioSpcoop getServizio(IDServizio idService) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getServizio(idService, false, null);
    }

    public ServizioSpcoop getServizio(IDServizio idService, Connection con) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getServizio(idService, false, con);
    }

    public ServizioSpcoop getServizio(IDServizio idService, boolean readContenutoAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getServizio(idService, readContenutoAllegati, null);
    }

    public ServizioSpcoop getServizio(IDServizio idService, boolean readContenutoAllegati, Connection con) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ServizioSpcoop servizio = this.getServizioSPCoop(1, idService, null, null, readContenutoAllegati, con);
        if (servizio != null) {
            servizio.setServizioCorrelato(false);
        }
        return servizio;
    }

    @Override
    public IDServizio[] getAllIdServizi(FiltroServiziSPCoop filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAllIdServizi(false, filtroRicerca);
    }

    @Override
    public IDServizio[] getAllIdServiziCorrelati(FiltroServiziSPCoop filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAllIdServizi(true, filtroRicerca);
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private IDServizio[] getAllIdServizi(boolean serviziCorrelati, FiltroServiziSPCoop filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        String operazione = null;
        operazione = serviziCorrelati ? "getAllIdServiziCorrelati" : "getAllIdServizi";
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug((Object)(operazione + "..."));
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("servizi");
        sqlQueryObject.addFromTable("soggetti");
        sqlQueryObject.addFromTable("accordi");
        sqlQueryObject.addSelectField("*");
        if (serviziCorrelati) {
            sqlQueryObject.addWhereCondition("servizi.servizio_correlato = ?");
        } else {
            sqlQueryObject.addWhereCondition(false, "servizi.servizio_correlato = ?", "servizi.servizio_correlato is null");
        }
        sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
        sqlQueryObject.addWhereCondition("servizi.id_accordo = accordi.id");
        if (filtroRicerca != null) {
            if (filtroRicerca.getMinDate() != null) {
                sqlQueryObject.addWhereCondition("servizi.ora_registrazione > ?");
            }
            if (filtroRicerca.getMaxDate() != null) {
                sqlQueryObject.addWhereCondition("servizi.ora_registrazione < ?");
            }
            if (filtroRicerca.getTipo() != null) {
                sqlQueryObject.addWhereCondition("servizi.tipo_servizio = ?");
            }
            if (filtroRicerca.getNome() != null) {
                sqlQueryObject.addWhereCondition("servizi.nome_servizio = ?");
            }
            if (filtroRicerca.getTipoSoggettoErogatore() != null) {
                sqlQueryObject.addWhereCondition("soggetti.tipo_soggetto = ?");
            }
            if (filtroRicerca.getNomeSoggettoErogatore() != null) {
                sqlQueryObject.addWhereCondition("soggetti.nome_soggetto = ?");
            }
            if (filtroRicerca.getIdAccordo() != null) {
                IDAccordo idAccordo = filtroRicerca.getIdAccordo();
                if (idAccordo.getNome() != null) {
                    sqlQueryObject.addWhereCondition("accordi.nome = ?");
                }
                if (idAccordo.getSoggettoReferente() != null) {
                    sqlQueryObject.addWhereCondition("accordi.id_referente = ?");
                }
                if (idAccordo.getVersione() != null) {
                    sqlQueryObject.addWhereCondition("accordi.versione = ?");
                }
            }
        }
        sqlQueryObject.setANDLogicOperator(true);
        String sqlQuery = sqlQueryObject.createSQLQuery();
        this.log.debug((Object)("eseguo query : " + sqlQuery));
        stm = con.prepareStatement(sqlQuery);
        if (serviziCorrelati) {
            stm.setString(1, "abilitato");
        } else {
            stm.setString(1, "disabilitato");
        }
        int indexStmt = 2;
        if (filtroRicerca != null) {
            if (filtroRicerca.getMinDate() != null) {
                this.log.debug((Object)("minDate stmt.setTimestamp(" + filtroRicerca.getMinDate() + ")"));
                stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMinDate().getTime()));
                ++indexStmt;
            }
            if (filtroRicerca.getMaxDate() != null) {
                this.log.debug((Object)("maxDate stmt.setTimestamp(" + filtroRicerca.getMaxDate() + ")"));
                stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMaxDate().getTime()));
                ++indexStmt;
            }
            if (filtroRicerca.getTipo() != null) {
                this.log.debug((Object)("tipoServizio stmt.setString(" + filtroRicerca.getTipo() + ")"));
                stm.setString(indexStmt, filtroRicerca.getTipo());
                ++indexStmt;
            }
            if (filtroRicerca.getNome() != null) {
                this.log.debug((Object)("nomeServizio stmt.setString(" + filtroRicerca.getNome() + ")"));
                stm.setString(indexStmt, filtroRicerca.getNome());
                ++indexStmt;
            }
            if (filtroRicerca.getTipoSoggettoErogatore() != null) {
                this.log.debug((Object)("tipoSoggettoErogatore stmt.setString(" + filtroRicerca.getTipoSoggettoErogatore() + ")"));
                stm.setString(indexStmt, filtroRicerca.getTipoSoggettoErogatore());
                ++indexStmt;
            }
            if (filtroRicerca.getNomeSoggettoErogatore() != null) {
                this.log.debug((Object)("nomeSoggettoErogatore stmt.setString(" + filtroRicerca.getNomeSoggettoErogatore() + ")"));
                stm.setString(indexStmt, filtroRicerca.getNomeSoggettoErogatore());
                ++indexStmt;
            }
            if (filtroRicerca.getIdAccordo() != null) {
                IDAccordo idAccordo = filtroRicerca.getIdAccordo();
                if (idAccordo.getNome() != null) {
                    this.log.debug((Object)("nomeAccordo stmt.setString(" + idAccordo.getNome() + ")"));
                    stm.setString(indexStmt, idAccordo.getNome());
                    ++indexStmt;
                }
                if (idAccordo.getSoggettoReferente() != null) {
                    long idSoggettoReferente = DBUtils.getIdSoggetto(idAccordo.getSoggettoReferente().getNome(), idAccordo.getSoggettoReferente().getTipo(), con, this.tipoDB, this.tabellaSoggetti);
                    if (idSoggettoReferente <= 0L) {
                        throw new Exception("Soggetto referente [" + idAccordo.getSoggettoReferente().toString() + "] non trovato");
                    }
                    this.log.debug((Object)("idReferenteAccordi stmt.setLong(" + idSoggettoReferente + ")"));
                    stm.setLong(indexStmt, idSoggettoReferente);
                    ++indexStmt;
                }
                if (idAccordo.getVersione() != null) {
                    this.log.debug((Object)("versioneAccordo stmt.setString(" + idAccordo.getVersione() + ")"));
                    stm.setString(indexStmt, idAccordo.getVersione());
                    ++indexStmt;
                }
            }
        }
        rs = stm.executeQuery();
        Vector<IDServizio> idServizi = new Vector<IDServizio>();
        while (rs.next()) {
            IDServizio idServ = new IDServizio(rs.getString("tipo_soggetto"), rs.getString("nome_soggetto"), rs.getString("tipo_servizio"), rs.getString("nome_servizio"));
            IDSoggetto soggettoReferente = null;
            long idSoggettoReferente = rs.getLong("id_referente");
            if (idSoggettoReferente > 0L) {
                SoggettoSpcoop s = this.getSoggettoRegistro(idSoggettoReferente, con);
                soggettoReferente = new IDSoggetto(s.getTipo(), s.getNome());
            }
            IDAccordo idAccordo = IDAccordo.getIDAccordoFromValues(rs.getString("nome"), soggettoReferente, rs.getString("versione"));
            idServ.setUriAccordo(IDAccordo.getUriFromIDAccordo(idAccordo));
            idServ.setCorrelato(serviziCorrelati);
            idServizi.add(idServ);
        }
        if (idServizi.size() == 0) {
            if (filtroRicerca != null) {
                throw new DriverRegistroServiziNotFound("Servizi non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            throw new DriverRegistroServiziNotFound("Servizi non trovati");
        }
        IDServizio[] res = new IDServizio[1];
        IDServizio[] iDServizioArray = idServizi.toArray(res);
        Object var17_19 = null;
        try {
            if (rs != null) {
                rs.close();
            }
            if (stm != null) {
                stm.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessione al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        {
            return iDServizioArray;
            catch (DriverRegistroServiziNotFound de) {
                throw de;
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException(operazione + " error", e);
            }
        }
        catch (Throwable throwable) {
            Object var17_20 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public IDServizio[] getAllIdServiziWithSoggettoErogatore(Long idSoggetto) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        String operazione = "getAllIdServiziWithSoggettoErogatore";
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug((Object)(operazione + "..."));
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("servizi");
        sqlQueryObject.addFromTable("soggetti");
        sqlQueryObject.addSelectField("*");
        sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
        sqlQueryObject.addWhereCondition("soggetti.id = ?");
        sqlQueryObject.setANDLogicOperator(true);
        String sqlQuery = sqlQueryObject.createSQLQuery();
        this.log.debug((Object)("eseguo query : " + sqlQuery));
        stm = con.prepareStatement(sqlQuery);
        stm.setLong(1, idSoggetto);
        rs = stm.executeQuery();
        Vector<IDServizio> idServizi = new Vector<IDServizio>();
        while (rs.next()) {
            IDServizio idServ = new IDServizio(rs.getString("tipo_soggetto"), rs.getString("nome_soggetto"), rs.getString("tipo_servizio"), rs.getString("nome_servizio"));
            idServizi.add(idServ);
        }
        if (idServizi.size() == 0) {
            throw new DriverRegistroServiziNotFound("Servizi non trovati per il soggetto con id: " + idSoggetto);
        }
        IDServizio[] res = new IDServizio[1];
        IDServizio[] iDServizioArray = idServizi.toArray(res);
        Object var12_13 = null;
        try {
            if (rs != null) {
                rs.close();
            }
            if (stm != null) {
                stm.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessione al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        {
            return iDServizioArray;
            catch (DriverRegistroServiziNotFound de) {
                throw de;
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException(operazione + " error", e);
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void createServizioSpcoop(ServizioSpcoop servizio) throws DriverRegistroServiziException {
        if (servizio == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createServizio] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createServizio] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            try {
                this.log.debug((Object)"CRUDServizio tupe=1");
                DriverRegistroServiziDB_LIB.CRUDServizio(1, servizio, con);
            }
            catch (Exception qe) {
                error = true;
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createServizio] Errore durante la creazione del servizio : " + qe.getMessage(), qe);
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                    throw throwable;
                }
                if (error) throw throwable;
                if (!this.atomica) throw throwable;
                this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                con.commit();
                con.setAutoCommit(true);
                con.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        if (error && this.atomica) {
            this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
            con.rollback();
            con.setAutoCommit(true);
            con.close();
            return;
        }
        if (error) return;
        if (!this.atomica) return;
        this.log.debug((Object)"eseguo commit e rilascio connessioni...");
        con.commit();
        con.setAutoCommit(true);
        con.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean existsServizioSpcoop(IDServizio idServizio) throws DriverRegistroServiziException {
        boolean bl;
        if (idServizio == null) {
            throw new DriverRegistroServiziException("IDServizio non valido.");
        }
        IDSoggetto erogatore = idServizio.getSoggettoErogatore();
        if (erogatore == null) {
            throw new DriverRegistroServiziException("Soggetto Erogatore non valido.");
        }
        String nomeServizio = idServizio.getServizio();
        String tipoServizio = idServizio.getTipoServizio();
        String nomeProprietario = erogatore.getNome();
        String tipoProprietario = erogatore.getTipo();
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            try {
                long idS = DBUtils.getIdServizio(nomeServizio, tipoServizio, nomeProprietario, tipoProprietario, con, true, this.tipoDB);
                bl = idS > 0L;
                Object var13_13 = null;
            }
            catch (Exception qe) {
                error = true;
                throw new DriverRegistroServiziException("Errore durante existsServizioSpcoop : " + qe.getMessage(), qe);
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                    throw throwable;
                }
                if (error) throw throwable;
                if (!this.atomica) throw throwable;
                this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                con.commit();
                con.setAutoCommit(true);
                con.close();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return bl;
        }
        if (error && this.atomica) {
            this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
            con.rollback();
            con.setAutoCommit(true);
            con.close();
            return bl;
        }
        if (error) return bl;
        if (!this.atomica) return bl;
        this.log.debug((Object)"eseguo commit e rilascio connessioni...");
        con.commit();
        con.setAutoCommit(true);
        con.close();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean existsServizioSpcoopWithTipoAndNome(String tipoServizio, String nomeServizio) throws DriverRegistroServiziException {
        boolean bl;
        if (tipoServizio == null) {
            throw new DriverRegistroServiziException("TipoServizio non valido.");
        }
        if (nomeServizio == null) {
            throw new DriverRegistroServiziException("NomeServizio non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            try {
                int idServ = 0;
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("tipo_servizio = ?");
                sqlQueryObject.addWhereCondition("nome_servizio = ?");
                sqlQueryObject.setANDLogicOperator(true);
                String sqlQuery = sqlQueryObject.createSQLQuery();
                PreparedStatement stm = con.prepareStatement(sqlQuery);
                stm.setString(1, tipoServizio);
                stm.setString(2, nomeServizio);
                ResultSet rs = stm.executeQuery();
                if (rs.next()) {
                    idServ = rs.getInt("id");
                }
                rs.close();
                stm.close();
                bl = idServ > 0;
                Object var12_13 = null;
            }
            catch (Exception qe) {
                error = true;
                throw new DriverRegistroServiziException("Errore durante existsServizioSpcoop : " + qe.getMessage(), qe);
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                    throw throwable;
                }
                if (error) throw throwable;
                if (!this.atomica) throw throwable;
                this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                con.commit();
                con.setAutoCommit(true);
                con.close();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return bl;
        }
        if (error && this.atomica) {
            this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
            con.rollback();
            con.setAutoCommit(true);
            con.close();
            return bl;
        }
        if (error) return bl;
        if (!this.atomica) return bl;
        this.log.debug((Object)"eseguo commit e rilascio connessioni...");
        con.commit();
        con.setAutoCommit(true);
        con.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean existsServizioSpcoop(long idServizio) throws DriverRegistroServiziException {
        boolean exist;
        block28: {
            exist = false;
            Connection con = null;
            Statement stm = null;
            ResultSet rs = null;
            if (this.atomica) {
                try {
                    con = this.datasource.getConnection();
                    con.setAutoCommit(false);
                }
                catch (SQLException e) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::existsServizioSpcoop] SQLException accedendo al datasource :" + e.getMessage());
                }
            } else {
                con = this.globalConnection;
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idServizio);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
            Object var10_10 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            if (this.atomica) {
                try {
                    con.close();
                }
                catch (Exception e2) {}
            }
            break block28;
            {
                catch (Exception e) {
                    exist = false;
                    this.log.error((Object)"Errore durante verifica esistenza servizio :", (Throwable)e);
                    Object var10_11 = null;
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (stm != null) {
                            stm.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    if (this.atomica) {
                        try {
                            con.close();
                        }
                        catch (Exception e2) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                if (this.atomica) {
                    try {
                        con.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return exist;
    }

    /*
     * Loose catch block
     */
    public boolean existsAccordoServizioParteSpecifica(IDAccordo idAccordo) throws DriverRegistroServiziException {
        boolean bl;
        Connection connection;
        block19: {
            block17: {
                boolean bl2;
                block18: {
                    block15: {
                        boolean e22;
                        block16: {
                            if (this.atomica) {
                                try {
                                    connection = this.datasource.getConnection();
                                    connection.setAutoCommit(false);
                                }
                                catch (SQLException e22) {
                                    throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioParteSpecifica] SQLException accedendo al datasource :" + e22.getMessage(), e22);
                                }
                            } else {
                                connection = this.globalConnection;
                            }
                            this.log.debug((Object)("operazione atomica = " + this.atomica));
                            if (this.existsSoggetto(idAccordo.getSoggettoReferente())) break block15;
                            e22 = false;
                            Object var7_7 = null;
                            if (!this.atomica) break block16;
                            try {
                                connection.close();
                            }
                            catch (Exception e3) {
                                // empty catch block
                            }
                        }
                        return e22;
                    }
                    long idAccordoLong = DBUtils.getIdAccordoServizioParteSpecifica(idAccordo, connection, this.tipoDB);
                    if (idAccordoLong > 0L) break block17;
                    bl2 = false;
                    Object var7_8 = null;
                    if (!this.atomica) break block18;
                    try {
                        connection.close();
                    }
                    catch (Exception e3) {
                        // empty catch block
                    }
                }
                return bl2;
            }
            bl = true;
            Object var7_9 = null;
            if (!this.atomica) break block19;
            try {
                connection.close();
            }
            catch (Exception e3) {
                // empty catch block
            }
        }
        return bl;
        catch (Exception e) {
            try {
                throw new DriverRegistroServiziException(e);
            }
            catch (Throwable throwable) {
                block20: {
                    Object var7_10 = null;
                    if (!this.atomica) break block20;
                    try {
                        connection.close();
                    }
                    catch (Exception e3) {}
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServizioSpcoop getAccordoServizioParteSpecifica(IDAccordo idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection connection;
        if (this.atomica) {
            try {
                connection = this.datasource.getConnection();
                connection.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::getAccordoServizioParteSpecifica] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        long idAccordoLong = -1L;
        try {
            try {
                if (!this.existsSoggetto(idAccordo.getSoggettoReferente())) {
                    throw new DriverRegistroServiziNotFound("Soggetto erogatore [" + idAccordo.getSoggettoReferente() + "] non esistente");
                }
                idAccordoLong = DBUtils.getIdAccordoServizioParteSpecifica(idAccordo, connection, this.tipoDB);
                if (idAccordoLong <= 0L) {
                    throw new DriverRegistroServiziNotFound("Accordo di Servizio Parte Specifica [" + idAccordo.toString() + "] non esistente");
                }
                Object var7_5 = null;
                if (!this.atomica) return this.getServizioSpcoop(idAccordoLong);
            }
            catch (DriverRegistroServiziNotFound dNot) {
                throw dNot;
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException(e);
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (!this.atomica) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        connection.close();
        return this.getServizioSpcoop(idAccordoLong);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public IDAccordo getIDAccordoServizioParteSpecifica(IDServizio idServizio) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        IDAccordo idAccordo;
        block35: {
            Connection con = null;
            Statement stm = null;
            ResultSet rs = null;
            idAccordo = null;
            if (idServizio == null) {
                throw new DriverRegistroServiziException("Parametro non valido");
            }
            if (idServizio.getSoggettoErogatore() == null) {
                throw new DriverRegistroServiziException("Parametro non valido (soggetto erogatore)");
            }
            String nome_soggetto = idServizio.getSoggettoErogatore().getNome();
            String tipo_soggetto = idServizio.getSoggettoErogatore().getTipo();
            if (nome_soggetto == null || nome_soggetto.equals("")) {
                throw new DriverRegistroServiziException("Parametro Nome soggetto non valido");
            }
            if (tipo_soggetto == null || tipo_soggetto.equals("")) {
                throw new DriverRegistroServiziException("Parametro Tipo soggetto non valido");
            }
            String nome_servizio = idServizio.getServizio();
            String tipo_servizio = idServizio.getTipoServizio();
            if (nome_servizio == null || nome_servizio.equals("")) {
                throw new DriverRegistroServiziException("Parametro Nome servizio non valido");
            }
            if (tipo_servizio == null || tipo_servizio.equals("")) {
                throw new DriverRegistroServiziException("Parametro Tipo servizio non valido");
            }
            if (this.atomica) {
                try {
                    con = this.datasource.getConnection();
                    con.setAutoCommit(false);
                }
                catch (SQLException e) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::existsSoggetto] SQLException accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.globalConnection;
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("aps_nome");
            sqlQueryObject.addSelectField("aps_versione");
            sqlQueryObject.addWhereCondition("tipo_soggetto = ?");
            sqlQueryObject.addWhereCondition("nome_soggetto = ?");
            sqlQueryObject.addWhereCondition("servizi.id_soggetto=soggetti.id");
            sqlQueryObject.addWhereCondition("tipo_servizio = ?");
            sqlQueryObject.addWhereCondition("nome_servizio = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, tipo_soggetto);
            stm.setString(2, nome_soggetto);
            stm.setString(3, tipo_servizio);
            stm.setString(4, nome_servizio);
            rs = stm.executeQuery();
            if (rs.next()) {
                idAccordo = IDAccordo.getIDAccordoFromValues(rs.getString("aps_nome"), idServizio.getSoggettoErogatore(), rs.getString("aps_versione"));
            }
            rs.close();
            stm.close();
            Object var13_14 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            if (this.atomica) {
                try {
                    con.close();
                }
                catch (Exception e2) {}
            }
            break block35;
            {
                catch (Exception e) {
                    this.log.error((Object)"Errore durante verifica esistenza soggetto :", (Throwable)e);
                    Object var13_15 = null;
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (stm != null) {
                            stm.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    if (this.atomica) {
                        try {
                            con.close();
                        }
                        catch (Exception e2) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                if (this.atomica) {
                    try {
                        con.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        if (idAccordo == null) {
            throw new DriverRegistroServiziNotFound("Servizio [" + idServizio.toString() + "] non trovato");
        }
        return idAccordo;
    }

    public int getServizioWithSoggettoAccordoServCorr(long idSoggetto, long idAccordo, IDServizio idServizio, String servizioCorrelato) throws DriverRegistroServiziException {
        return this._getServizioWithSoggettoAccordoServCorrPT(idSoggetto, idAccordo, idServizio, servizioCorrelato, null);
    }

    /*
     * Loose catch block
     */
    private int _getServizioWithSoggettoAccordoServCorrPT(long idSoggetto, long idAccordo, IDServizio idServizio, String servizioCorrelato, String portType) throws DriverRegistroServiziException {
        int idServ;
        block25: {
            Connection connection;
            idServ = 0;
            Statement stm = null;
            ResultSet rs = null;
            if (this.atomica) {
                try {
                    connection = this.datasource.getConnection();
                    connection.setAutoCommit(false);
                }
                catch (SQLException e) {
                    throw new DriverRegistroServiziException("DriverRegistroServiziDB::getServizioWithSoggettoAccordoServCorr] SQLException accedendo al datasource :" + e.getMessage());
                }
            } else {
                connection = this.globalConnection;
            }
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQueryObject.addWhereCondition("servizio_correlato = ?");
            sqlQueryObject.addWhereCondition(false, "nome_servizio != ?", "tipo_servizio != ?");
            if (portType != null) {
                sqlQueryObject.addWhereCondition("port_type = ?");
            } else {
                sqlQueryObject.addWhereCondition("port_type is null");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idSoggetto);
            stm.setLong(2, idAccordo);
            stm.setString(3, servizioCorrelato);
            stm.setString(4, idServizio.getServizio());
            stm.setString(5, idServizio.getTipoServizio());
            if (portType != null) {
                stm.setString(6, portType);
            }
            if ((rs = stm.executeQuery()).next()) {
                idServ = rs.getInt("id");
            }
            rs.close();
            stm.close();
            Object var15_14 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.atomica) {
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
            break block25;
            {
                catch (Exception e) {
                    throw new DriverRegistroServiziException(e);
                }
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (this.atomica) {
                    try {
                        connection.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return idServ;
    }

    public int getServizioWithSoggettoAccordoServCorrPt(long idSoggetto, long idAccordo, IDServizio idServizio, String servizioCorrelato, String portType) throws DriverRegistroServiziException {
        return this._getServizioWithSoggettoAccordoServCorrPT(idSoggetto, idAccordo, idServizio, servizioCorrelato, portType);
    }

    /*
     * Loose catch block
     */
    public int getServizioFruitore(IDServizio idServizio, long idSogg) throws DriverRegistroServiziException {
        int idFru;
        block23: {
            Connection connection;
            idFru = 0;
            Statement stm = null;
            ResultSet rs = null;
            if (this.atomica) {
                try {
                    connection = this.datasource.getConnection();
                    connection.setAutoCommit(false);
                }
                catch (SQLException e) {
                    throw new DriverRegistroServiziException("DriverRegistroServiziDB::getServizioWithSoggettoAccordoServCorr] SQLException accedendo al datasource :" + e.getMessage());
                }
            } else {
                connection = this.globalConnection;
            }
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            int idServ = 0;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("servizi.id");
            sqlQueryObject.addWhereCondition("servizi.nome_servizio = ?");
            sqlQueryObject.addWhereCondition("servizi.tipo_servizio = ?");
            sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
            sqlQueryObject.addWhereCondition("soggetti.nome_soggetto = ?");
            sqlQueryObject.addWhereCondition("soggetti.tipo_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setString(1, idServizio.getServizio());
            stm.setString(2, idServizio.getTipoServizio());
            stm.setString(3, idServizio.getSoggettoErogatore().getNome());
            stm.setString(4, idServizio.getSoggettoErogatore().getTipo());
            rs = stm.executeQuery();
            if (rs.next()) {
                idServ = rs.getInt("id");
            }
            rs.close();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_servizio = ?");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idServ);
            stm.setLong(2, idSogg);
            rs = stm.executeQuery();
            if (rs.next()) {
                idFru = rs.getInt("id");
            }
            rs.close();
            stm.close();
            Object var12_12 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.atomica) {
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
            break block23;
            {
                catch (Exception e) {
                    throw new DriverRegistroServiziException(e);
                }
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (this.atomica) {
                    try {
                        connection.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return idFru;
    }

    /*
     * Loose catch block
     */
    public int getServizioFruitoreSoggettoFruitoreID(int idServizioFruitore) throws DriverRegistroServiziException {
        int idSoggFru;
        block22: {
            Connection connection;
            idSoggFru = 0;
            Statement stm = null;
            ResultSet rs = null;
            if (this.atomica) {
                try {
                    connection = this.datasource.getConnection();
                    connection.setAutoCommit(false);
                }
                catch (SQLException e) {
                    throw new DriverRegistroServiziException("DriverRegistroServiziDB::getServizioFruitoreSoggettoFruitoreID] SQLException accedendo al datasource :" + e.getMessage());
                }
            } else {
                connection = this.globalConnection;
            }
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addSelectField("id_soggetto");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setInt(1, idServizioFruitore);
            rs = stm.executeQuery();
            if (rs.next()) {
                idSoggFru = rs.getInt("id_soggetto");
            }
            rs.close();
            stm.close();
            Object var9_10 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.atomica) {
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
            break block22;
            {
                catch (Exception e) {
                    throw new DriverRegistroServiziException(e);
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (this.atomica) {
                    try {
                        connection.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return idSoggFru;
    }

    /*
     * Loose catch block
     */
    public int getServizioFruitoreServizioID(int idServizioFruitore) throws DriverRegistroServiziException {
        int idServ;
        block22: {
            Connection connection;
            idServ = 0;
            Statement stm = null;
            ResultSet rs = null;
            if (this.atomica) {
                try {
                    connection = this.datasource.getConnection();
                    connection.setAutoCommit(false);
                }
                catch (SQLException e) {
                    throw new DriverRegistroServiziException("DriverRegistroServiziDB::getServizioFruitoreServizioID] SQLException accedendo al datasource :" + e.getMessage());
                }
            } else {
                connection = this.globalConnection;
            }
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addSelectField("id_servizio");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setInt(1, idServizioFruitore);
            rs = stm.executeQuery();
            if (rs.next()) {
                idServ = rs.getInt("id_servizio");
            }
            rs.close();
            stm.close();
            Object var9_10 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.atomica) {
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
            break block22;
            {
                catch (Exception e) {
                    throw new DriverRegistroServiziException(e);
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (this.atomica) {
                    try {
                        connection.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return idServ;
    }

    /*
     * Loose catch block
     */
    @Override
    public void updateServizioSpcoop(ServizioSpcoop servizio) throws DriverRegistroServiziException {
        block26: {
            if (servizio == null) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateServizio] Parametro non valido.");
            }
            Statement stm = null;
            ResultSet rs = null;
            Connection con = null;
            boolean error = false;
            if (this.atomica) {
                try {
                    con = this.datasource.getConnection();
                    con.setAutoCommit(false);
                }
                catch (SQLException e) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateServizio] SQLException accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.globalConnection;
            }
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            DriverRegistroServiziDB_LIB.CRUDServizio(2, servizio, con);
            Object var8_8 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
                break block26;
            }
            catch (Exception e) {}
            break block26;
            {
                catch (Exception qe) {
                    error = true;
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateServizio] Errore durante l'update del servizio : " + qe.getMessage(), qe);
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (error && this.atomica) {
                        this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                        con.rollback();
                        con.setAutoCommit(true);
                        con.close();
                    } else if (!error && this.atomica) {
                        this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                        con.commit();
                        con.setAutoCommit(true);
                        con.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void deleteServizioSpcoop(ServizioSpcoop servizio) throws DriverRegistroServiziException {
        if (servizio == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteServizio] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createServizio] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            try {
                this.log.debug((Object)"CRUDServizio type = 3");
                DriverRegistroServiziDB_LIB.CRUDServizio(3, servizio, con);
            }
            catch (Exception qe) {
                error = true;
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createServizio] Errore durante la delete del servizio : " + qe.getMessage(), qe);
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                    throw throwable;
                }
                if (error) throw throwable;
                if (!this.atomica) throw throwable;
                this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                con.commit();
                con.setAutoCommit(true);
                con.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        if (error && this.atomica) {
            this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
            con.rollback();
            con.setAutoCommit(true);
            con.close();
            return;
        }
        if (error) return;
        if (!this.atomica) return;
        this.log.debug((Object)"eseguo commit e rilascio connessioni...");
        con.commit();
        con.setAutoCommit(true);
        con.close();
        return;
    }

    @Override
    public ServizioSpcoop getServizioCorrelato(IDServizio idService) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getServizioCorrelato(idService, false, null);
    }

    public ServizioSpcoop getServizioCorrelato(IDServizio idService, Connection con) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getServizioCorrelato(idService, false, con);
    }

    public ServizioSpcoop getServizioCorrelato(IDServizio idService, boolean readContenutoAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getServizioCorrelato(idService, readContenutoAllegati, null);
    }

    public ServizioSpcoop getServizioCorrelato(IDServizio idService, boolean readContenutoAllegati, Connection con) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ServizioSpcoop servizio = this.getServizioSPCoop(2, idService, null, null, readContenutoAllegati, con);
        return servizio;
    }

    @Override
    public void createServizioSpcoopCorrelato(ServizioSpcoop servizioCorrelato) throws DriverRegistroServiziException {
        this.createServizioSpcoop(servizioCorrelato);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean existsServizioSpcoopCorrelato(IDServizio idServizio) throws DriverRegistroServiziException {
        boolean bl;
        if (idServizio == null) {
            throw new DriverRegistroServiziException("IDServizio non valido.");
        }
        IDSoggetto erogatore = idServizio.getSoggettoErogatore();
        if (erogatore == null) {
            throw new DriverRegistroServiziException("Soggetto Erogatore non valido.");
        }
        String nomeServizio = idServizio.getServizio();
        String tipoServizio = idServizio.getTipoServizio();
        String nomeProprietario = erogatore.getNome();
        String tipoProprietario = erogatore.getTipo();
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            try {
                long idS = this.getIdServizioCorrelato(nomeServizio, tipoServizio, nomeProprietario, tipoProprietario, con);
                bl = idS > 0L;
                Object var13_13 = null;
            }
            catch (Exception qe) {
                error = true;
                throw new DriverRegistroServiziException("Errore durante l'update del servizio : " + qe.getMessage(), qe);
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                    throw throwable;
                }
                if (error) throw throwable;
                if (!this.atomica) throw throwable;
                this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                con.commit();
                con.setAutoCommit(true);
                con.close();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return bl;
        }
        if (error && this.atomica) {
            this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
            con.rollback();
            con.setAutoCommit(true);
            con.close();
            return bl;
        }
        if (error) return bl;
        if (!this.atomica) return bl;
        this.log.debug((Object)"eseguo commit e rilascio connessioni...");
        con.commit();
        con.setAutoCommit(true);
        con.close();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean existsSoggettoServiziWithoutConnettore(int idSoggetto) throws DriverRegistroServiziException {
        boolean bl;
        if (idSoggetto == 0) {
            throw new DriverRegistroServiziException("idSoggetto non valido.");
        }
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        boolean trovatoServ = false;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            try {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addFromTable("connettori");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("servizi.id_connettore = connettori.id");
                sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
                sqlQueryObject.addWhereCondition("id_soggetto = ?");
                sqlQueryObject.addWhereCondition("endpointtype = ?");
                sqlQueryObject.setANDLogicOperator(true);
                String sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setInt(1, idSoggetto);
                stm.setString(2, "disabilitato");
                rs = stm.executeQuery();
                if (rs.next()) {
                    trovatoServ = true;
                }
                rs.close();
                stm.close();
                bl = trovatoServ;
                Object var11_12 = null;
            }
            catch (Exception qe) {
                error = true;
                throw new DriverRegistroServiziException("Errore durante existsSoggettoServiziWithoutConnettore: " + qe.getMessage(), qe);
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                    throw throwable;
                }
                if (error) throw throwable;
                if (!this.atomica) throw throwable;
                this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                con.commit();
                con.setAutoCommit(true);
                con.close();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return bl;
        }
        if (error && this.atomica) {
            this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
            con.rollback();
            con.setAutoCommit(true);
            con.close();
            return bl;
        }
        if (error) return bl;
        if (!this.atomica) return bl;
        this.log.debug((Object)"eseguo commit e rilascio connessioni...");
        con.commit();
        con.setAutoCommit(true);
        con.close();
        return bl;
    }

    @Override
    public void updateServizioSpcoopCorrelato(ServizioSpcoop servizioCorrelato) throws DriverRegistroServiziException {
        this.updateServizioSpcoop(servizioCorrelato);
    }

    @Override
    public void deleteServizioSpcoopCorrelato(ServizioSpcoop servizioCorrelato) throws DriverRegistroServiziException {
        this.deleteServizioSpcoop(servizioCorrelato);
    }

    @Override
    public ServizioSpcoop getServizioCorrelato(IDSoggetto idSoggetto, IDAccordo idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getServizioCorrelato(idSoggetto, idAccordo, false);
    }

    public ServizioSpcoop getServizioCorrelato(IDSoggetto idSoggetto, IDAccordo idAccordo, boolean readContenutoAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ServizioSpcoop servizio = this.getServizioSPCoop(3, null, idSoggetto, idAccordo, readContenutoAllegati, null);
        return servizio;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Connettore getConnettore(long idConnettore, Connection connection) throws DriverRegistroServiziException {
        Connettore connettore;
        Connettore connettore2 = null;
        Statement stm = null;
        ResultSet rs = null;
        try {
            try {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("connettori");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id = ?");
                String sqlQuery = sqlQueryObject.createSQLQuery();
                stm = connection.prepareStatement(sqlQuery);
                stm.setLong(1, idConnettore);
                this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idConnettore)));
                rs = stm.executeQuery();
                if (rs.next()) {
                    String endpoint = rs.getString("endpointtype");
                    if (endpoint == null || endpoint.equals("") || endpoint.equals(TipiConnettore.DISABILITATO.getNome())) {
                        connettore2 = new Connettore();
                        connettore2.setNome(rs.getString("nome_connettore"));
                        connettore2.setTipo(TipiConnettore.DISABILITATO.getNome());
                        connettore2.setId(idConnettore);
                    } else {
                        ConnettoreProperty prop = null;
                        connettore2 = new Connettore();
                        connettore2.setNome(rs.getString("nome_connettore"));
                        connettore2.setTipo(endpoint);
                        connettore2.setId(idConnettore);
                        if (rs.getInt("debug") == 1) {
                            prop = new ConnettoreProperty();
                            prop.setNome("debug");
                            prop.setValore("true");
                            connettore2.addProperty(prop);
                        }
                        if (endpoint.equals("http")) {
                            String value = rs.getString("url");
                            if (value != null) {
                                value = value.trim();
                            }
                            if (value == null) throw new DriverRegistroServiziException("Connettore di tipo http possiede una url non definita");
                            if ("".equals(value)) throw new DriverRegistroServiziException("Connettore di tipo http possiede una url non definita");
                            if (" ".equals(value)) {
                                throw new DriverRegistroServiziException("Connettore di tipo http possiede una url non definita");
                            }
                            prop = new ConnettoreProperty();
                            prop.setNome("location");
                            prop.setValore(value);
                            connettore2.addProperty(prop);
                        } else if (endpoint.equals(TipiConnettore.JMS.getNome())) {
                            String provurl;
                            String urlpkg;
                            String initcont;
                            String pwd;
                            String value = rs.getString("nome");
                            if (value != null) {
                                value = value.trim();
                            }
                            if (value == null) throw new DriverRegistroServiziException("Connettore di tipo jms possiede il nome della coda/topic non definito");
                            if ("".equals(value)) throw new DriverRegistroServiziException("Connettore di tipo jms possiede il nome della coda/topic non definito");
                            if (" ".equals(value)) {
                                throw new DriverRegistroServiziException("Connettore di tipo jms possiede il nome della coda/topic non definito");
                            }
                            prop = new ConnettoreProperty();
                            prop.setNome("location");
                            prop.setValore(value);
                            connettore2.addProperty(prop);
                            value = rs.getString("tipo");
                            if (value != null) {
                                value = value.trim();
                            }
                            if (value == null) throw new DriverRegistroServiziException("Connettore di tipo jms possiede il tipo della coda non definito");
                            if ("".equals(value)) throw new DriverRegistroServiziException("Connettore di tipo jms possiede il tipo della coda non definito");
                            if (" ".equals(value)) {
                                throw new DriverRegistroServiziException("Connettore di tipo jms possiede il tipo della coda non definito");
                            }
                            prop = new ConnettoreProperty();
                            prop.setNome("tipo");
                            prop.setValore(value);
                            connettore2.addProperty(prop);
                            value = rs.getString("connection_factory");
                            if (value != null) {
                                value = value.trim();
                            }
                            if (value == null) throw new DriverRegistroServiziException("Connettore di tipo jms non possiede la definizione di una Connection Factory");
                            if ("".equals(value)) throw new DriverRegistroServiziException("Connettore di tipo jms non possiede la definizione di una Connection Factory");
                            if (" ".equals(value)) {
                                throw new DriverRegistroServiziException("Connettore di tipo jms non possiede la definizione di una Connection Factory");
                            }
                            prop = new ConnettoreProperty();
                            prop.setNome("connection-factory");
                            prop.setValore(value);
                            connettore2.addProperty(prop);
                            value = rs.getString("send_as");
                            if (value != null) {
                                value = value.trim();
                            }
                            if (value == null) throw new DriverRegistroServiziException("Connettore di tipo jms possiede il tipo dell'oggetto JMS non definito");
                            if ("".equals(value)) throw new DriverRegistroServiziException("Connettore di tipo jms possiede il tipo dell'oggetto JMS non definito");
                            if (" ".equals(value)) {
                                throw new DriverRegistroServiziException("Connettore di tipo jms possiede il tipo dell'oggetto JMS non definito");
                            }
                            prop = new ConnettoreProperty();
                            prop.setNome("send-as");
                            prop.setValore(value);
                            connettore2.addProperty(prop);
                            String usr = rs.getString("utente");
                            if (usr != null && !usr.trim().equals("")) {
                                prop = new ConnettoreProperty();
                                prop.setNome("user");
                                prop.setValore(usr);
                                connettore2.addProperty(prop);
                            }
                            if ((pwd = rs.getString("password")) != null && !pwd.trim().equals("")) {
                                prop = new ConnettoreProperty();
                                prop.setNome("password");
                                prop.setValore(pwd);
                                connettore2.addProperty(prop);
                            }
                            if ((initcont = rs.getString("initcont")) != null && !initcont.trim().equals("")) {
                                prop = new ConnettoreProperty();
                                prop.setNome("context-java.naming.factory.initial");
                                prop.setValore(initcont);
                                connettore2.addProperty(prop);
                            }
                            if ((urlpkg = rs.getString("urlpkg")) != null && !urlpkg.trim().equals("")) {
                                prop = new ConnettoreProperty();
                                prop.setNome("context-java.naming.factory.url.pkgs");
                                prop.setValore(urlpkg);
                                connettore2.addProperty(prop);
                            }
                            if ((provurl = rs.getString("provurl")) != null && !provurl.trim().equals("")) {
                                prop = new ConnettoreProperty();
                                prop.setNome("context-java.naming.provider.url");
                                prop.setValore(provurl);
                                connettore2.addProperty(prop);
                            }
                        } else if (!(endpoint.equals(TipiConnettore.NULL.getNome()) || endpoint.equals(TipiConnettore.NULLECHO.getNome()) || endpoint.equals(TipiConnettore.DISABILITATO.getNome()))) {
                            if (rs.getLong("custom") == 1L) {
                                this.readPropertiesConnettoreCustom(idConnettore, connettore2, connection);
                                connettore2.setCustom(true);
                            } else {
                                connettore2.setPropertyList(DBUtils.getPropertiesConnettore(endpoint, connection, this.tipoDB));
                            }
                        }
                    }
                }
                connettore = connettore2;
                Object var18_20 = null;
            }
            catch (SQLException sqle) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getConnettore] SQLException : " + sqle.getMessage(), sqle);
            }
            catch (DriverException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getConnettore] DriverException : " + e.getMessage(), e);
            }
            catch (Exception sqle) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getConnettore] Exception : " + sqle.getMessage(), sqle);
            }
        }
        catch (Throwable throwable) {
            Object var18_21 = null;
            try {
                rs.close();
                stm.close();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return connettore;
        }
        rs.close();
        stm.close();
        return connettore;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readPropertiesConnettoreCustom(long idConnettore, Connettore connettore, Connection connection) throws DriverRegistroServiziException {
        Statement stm = null;
        ResultSet rs = null;
        try {
            try {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("connettori_custom");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_connettore = ?");
                String sqlQuery = sqlQueryObject.createSQLQuery();
                stm = connection.prepareStatement(sqlQuery);
                stm.setLong(1, idConnettore);
                DriverRegistroServiziDB_LIB.log.debug((Object)("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idConnettore)));
                rs = stm.executeQuery();
                while (rs.next()) {
                    String nome = rs.getString("name");
                    String valore = rs.getString("value");
                    ConnettoreProperty prop = new ConnettoreProperty();
                    prop.setNome(nome);
                    prop.setValore(valore);
                    connettore.addProperty(prop);
                }
                rs.close();
                stm.close();
            }
            catch (SQLException sqle) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::readPropertiesConnettoreCustom] SQLException : " + sqle.getMessage(), sqle);
            }
            catch (Exception sqle) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::readPropertiesConnettoreCustom] Exception : " + sqle.getMessage(), sqle);
            }
            Object var13_13 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm == null) throw throwable;
                stm.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        if (rs != null) {
            rs.close();
        }
        if (stm == null) return;
        stm.close();
        return;
    }

    public ConnettoreProperty[] getPropertiesConnettore(String nomeConnettore) throws DriverRegistroServiziException {
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getPropertiesConnettore] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        return this.getPropertiesConnettore(nomeConnettore, con);
    }

    public ConnettoreProperty[] getPropertiesConnettore(String nomeConnettore, Connection connection) throws DriverRegistroServiziException {
        try {
            return DBUtils.getPropertiesConnettore(nomeConnettore, connection, this.tipoDB);
        }
        catch (DriverException e) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getPropertiesConnettore] DriverException : " + e.getMessage(), e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private ServizioSpcoop getServizioSPCoop(int type, IDServizio idService, IDSoggetto idSoggetto, IDAccordo idAccordo, boolean readContenutoAllegati, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ServizioSpcoop servizioSPcoop = null;
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        Statement stm1 = null;
        ResultSet rs1 = null;
        boolean isServizioCorrelato = false;
        this.log.debug((Object)("chiamato getServizioSPCoop type = " + type));
        switch (type) {
            case 1: 
            case 2: {
                if (idService == null || idService.getServizio() == null || idService.getServizio().trim().equals("") || idService.getTipoServizio() == null || idService.getTipoServizio().trim().equals("") || idService.getSoggettoErogatore() == null || idService.getSoggettoErogatore().getNome() == null || idService.getSoggettoErogatore().getNome().trim().equals("") || idService.getSoggettoErogatore().getTipo() == null || idService.getSoggettoErogatore().getTipo().trim().equals("")) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getServizioSPCoop] : errore nei parametri d'ingresso, type :" + type);
                }
                if (type != 2) break;
                isServizioCorrelato = true;
                break;
            }
            case 3: {
                if (idAccordo == null || idAccordo.getNome() == null || idAccordo.getNome().trim().equals("") || idSoggetto == null || idSoggetto.getNome() == null || idSoggetto.getNome().trim().equals("") || idSoggetto.getTipo() == null || idSoggetto.getTipo().trim().equals("")) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getServizioSPCoop] : errore nei parametri d'ingresso, type :" + type);
                }
                isServizioCorrelato = true;
                break;
            }
            default: {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getServizioSPCoop] tipo operazione incorretto. parametro type passato: " + type);
            }
        }
        if (conParam != null) {
            con = conParam;
        } else if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getServizioSPCoop] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("servizi");
        sqlQueryObject.addSelectField("*");
        sqlQueryObject.addWhereCondition("nomeservizio = ?");
        sqlQueryObject.addWhereCondition("tiposervizio = ?");
        sqlQueryObject.setANDLogicOperator(true);
        String sqlQuery = sqlQueryObject.createSQLQuery();
        servizioSPcoop = new ServizioSpcoop();
        String nomeSoggEr = null;
        String tipoSoggEr = null;
        long idAccordoServizio = 0L;
        String nomeServizio = null;
        String tipoServizio = null;
        String superUser = null;
        long idSoggErogatore = 0L;
        switch (type) {
            case 1: 
            case 2: {
                nomeServizio = idService.getServizio();
                tipoServizio = idService.getTipoServizio();
                nomeSoggEr = idService.getSoggettoErogatore().getNome();
                tipoSoggEr = idService.getSoggettoErogatore().getTipo();
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("nome_soggetto = ?");
                sqlQueryObject.addWhereCondition("tipo_soggetto = ?");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setString(1, nomeSoggEr);
                stm.setString(2, tipoSoggEr);
                this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, nomeSoggEr, tipoSoggEr)));
                rs = stm.executeQuery();
                if (rs.next()) {
                    idSoggErogatore = rs.getLong("id");
                }
                rs.close();
                stm.close();
                break;
            }
            case 3: {
                nomeSoggEr = idSoggetto.getNome();
                tipoSoggEr = idSoggetto.getTipo();
                idAccordoServizio = DBUtils.getIdAccordoServizio(idAccordo, con, this.tipoDB);
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("nome_soggetto = ?");
                sqlQueryObject.addWhereCondition("tipo_soggetto = ?");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setString(1, nomeSoggEr);
                stm.setString(2, tipoSoggEr);
                this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, nomeSoggEr, tipoSoggEr)));
                rs = stm.executeQuery();
                if (rs.next()) {
                    idSoggErogatore = rs.getLong("id");
                }
                rs.close();
                stm.close();
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_soggetto = ?");
                sqlQueryObject.addWhereCondition("id_accordo = ?");
                sqlQueryObject.addWhereCondition("servizio_correlato = ?");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setLong(1, idSoggErogatore);
                stm.setLong(2, idAccordoServizio);
                stm.setString(3, "abilitato");
                this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idSoggErogatore, idAccordoServizio, "abilitato")));
                rs = stm.executeQuery();
                if (rs.next()) {
                    nomeServizio = rs.getString("nome_servizio");
                    tipoServizio = rs.getString("tipo_servizio");
                    superUser = rs.getString("superuser");
                }
                rs.close();
                stm.close();
            }
        }
        servizioSPcoop.setNome(nomeServizio);
        servizioSPcoop.setTipo(tipoServizio);
        long idServ = 0L;
        long idConnettore = 0L;
        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("servizi");
        sqlQueryObject.addSelectField("*");
        sqlQueryObject.addWhereCondition("nome_servizio = ?");
        sqlQueryObject.addWhereCondition("tipo_servizio = ?");
        sqlQueryObject.addWhereCondition("id_soggetto = ?");
        sqlQueryObject.setANDLogicOperator(true);
        sqlQuery = sqlQueryObject.createSQLQuery();
        stm = con.prepareStatement(sqlQuery);
        stm.setString(1, nomeServizio);
        stm.setString(2, tipoServizio);
        stm.setLong(3, idSoggErogatore);
        this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, nomeServizio, tipoServizio, idSoggErogatore)));
        rs = stm.executeQuery();
        if (rs.next()) {
            String firma;
            String profilo;
            String tmp;
            idServ = rs.getLong("id");
            idConnettore = rs.getLong("id_connettore");
            superUser = rs.getString("superuser");
            servizioSPcoop.setId(idServ);
            servizioSPcoop.setConnettore(this.getConnettore(idConnettore, con));
            String wsdlimpler = rs.getString("wsdl_implementativo_erogatore");
            servizioSPcoop.setByteWsdlImplementativoErogatore(wsdlimpler != null && !wsdlimpler.trim().equals("") ? wsdlimpler.trim().getBytes() : null);
            String wsdlimplfru = rs.getString("wsdl_implementativo_fruitore");
            servizioSPcoop.setByteWsdlImplementativoFruitore(wsdlimplfru != null && !wsdlimplfru.trim().equals("") ? wsdlimplfru.trim().getBytes() : null);
            String servizioCorrelato = rs.getString("servizio_correlato");
            if ("abilitato".equals(servizioCorrelato)) {
                servizioSPcoop.setServizioCorrelato(true);
            } else {
                servizioSPcoop.setServizioCorrelato(false);
            }
            servizioSPcoop.setTipoSoggettoErogatore(tipoSoggEr);
            servizioSPcoop.setNomeSoggettoErogatore(nomeSoggEr);
            servizioSPcoop.setIdSoggetto(idSoggErogatore);
            if (rs.getInt("privato") == 1) {
                servizioSPcoop.setPrivato(true);
            } else {
                servizioSPcoop.setPrivato(false);
            }
            if (rs.getTimestamp("ora_registrazione") != null) {
                servizioSPcoop.setOraRegistrazione(new Date(rs.getTimestamp("ora_registrazione").getTime()));
            }
            if ((tmp = rs.getString("port_type")) != null && !"".equals(tmp)) {
                servizioSPcoop.setPortType(tmp);
            }
            if ((profilo = rs.getString("profilo")) != null) {
                profilo = profilo.trim();
                servizioSPcoop.setProfilo(profilo);
            }
            servizioSPcoop.setSuperUser(superUser);
            servizioSPcoop.setDescrizione(rs.getString("descrizione"));
            if (rs.getTimestamp("data_pubblicazione") != null) {
                servizioSPcoop.setDataPubblicazione(new Date(rs.getTimestamp("data_pubblicazione").getTime()));
            }
            servizioSPcoop.setByteFirma((firma = rs.getString("firma")) != null && !firma.trim().equals("") ? firma.trim().getBytes() : null);
            servizioSPcoop.setTipoAdesione(rs.getString("tipo_adesione"));
            servizioSPcoop.setStatoPackage(rs.getString("stato"));
            if (rs.getString("aps_nome") != null && rs.getString("aps_versione") != null) {
                ServizioSpcoopAccordoParteSpecifica aps = new ServizioSpcoopAccordoParteSpecifica();
                aps.setNome(rs.getString("aps_nome"));
                aps.setVersione(rs.getString("aps_versione"));
                servizioSPcoop.setAccordoParteSpecifica(aps);
            }
        } else {
            throw new DriverRegistroServiziNotFound("Servizio [" + tipoServizio + "/" + nomeServizio + "] erogato dal soggetto [" + tipoSoggEr + "/" + nomeSoggEr + "] non esiste");
        }
        rs.close();
        stm.close();
        long idSoggFruitore = 0L;
        Fruitore fruitore = null;
        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("servizi_fruitori");
        sqlQueryObject.addSelectField("*");
        sqlQueryObject.addWhereCondition("id_servizio = ?");
        sqlQuery = sqlQueryObject.createSQLQuery();
        stm = con.prepareStatement(sqlQuery);
        stm.setLong(1, idServ);
        this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idServ)));
        rs = stm.executeQuery();
        while (rs.next()) {
            String profilo;
            fruitore = new Fruitore();
            idSoggFruitore = rs.getLong("id_soggetto");
            idConnettore = rs.getLong("id_connettore");
            fruitore.setConnettore(this.getConnettore(idConnettore, con));
            String wsdlimpler = rs.getString("wsdl_implementativo_erogatore");
            fruitore.setByteWsdlImplementativoErogatore(wsdlimpler != null && !wsdlimpler.trim().equals("") ? wsdlimpler.getBytes() : null);
            String wsdlimplfru = rs.getString("wsdl_implementativo_fruitore");
            fruitore.setByteWsdlImplementativoFruitore(wsdlimplfru != null && !wsdlimplfru.trim().equals("") ? wsdlimplfru.getBytes() : null);
            if (rs.getTimestamp("ora_registrazione") != null) {
                fruitore.setOraRegistrazione(new Date(rs.getTimestamp("ora_registrazione").getTime()));
            }
            if ((profilo = rs.getString("profilo")) != null) {
                profilo = profilo.trim();
                fruitore.setProfilo(profilo);
            }
            fruitore.setStatoPackage(rs.getString("stato"));
            fruitore.setClientAuth(rs.getString("client_auth"));
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm1 = con.prepareStatement(sqlQuery);
            stm1.setLong(1, idSoggFruitore);
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idSoggFruitore)));
            rs1 = stm1.executeQuery();
            if (!rs1.next()) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getServizioSPCoop] Non ho trovato i dati del soggetto fruitore necessario eseguendo: \n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idSoggFruitore));
            }
            fruitore.setNome(rs1.getString("nome_soggetto"));
            fruitore.setTipo(rs1.getString("tipo_soggetto"));
            rs1.close();
            stm1.close();
            fruitore.setId(rs.getLong("id"));
            servizioSPcoop.addFruitore(fruitore);
        }
        rs.close();
        stm.close();
        ServizioSpcoopAzione azione = null;
        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("servizi_azioni");
        sqlQueryObject.addSelectField("*");
        sqlQueryObject.addWhereCondition("id_servizio = ?");
        sqlQuery = sqlQueryObject.createSQLQuery();
        stm = con.prepareStatement(sqlQuery);
        stm.setLong(1, idServ);
        this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idServ)));
        rs = stm.executeQuery();
        while (rs.next()) {
            azione = new ServizioSpcoopAzione();
            azione.setNome(rs.getString("nome_azione"));
            idConnettore = rs.getLong("id_connettore");
            azione.setConnettore(this.getConnettore(idConnettore, con));
            azione.setId(rs.getLong("id"));
            servizioSPcoop.addAzione(azione);
        }
        rs.close();
        stm.close();
        switch (type) {
            case 1: 
            case 2: {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("nome_servizio = ?");
                sqlQueryObject.addWhereCondition("tipo_servizio = ?");
                sqlQueryObject.addWhereCondition("id_soggetto = ?");
                if (isServizioCorrelato) {
                    sqlQueryObject.addWhereCondition("servizio_correlato = ?");
                } else {
                    sqlQueryObject.addWhereCondition(false, "servizio_correlato = ?", "servizio_correlato is null", "servizio_correlato = '\"\"'");
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setString(1, nomeServizio);
                stm.setString(2, tipoServizio);
                stm.setLong(3, idSoggErogatore);
                if (isServizioCorrelato) {
                    stm.setString(4, "abilitato");
                } else {
                    stm.setString(4, "disabilitato");
                }
                this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, nomeServizio, tipoServizio, idSoggErogatore, isServizioCorrelato ? "abilitato" : "disabilitato")));
                rs = stm.executeQuery();
                if (!rs.next()) {
                    rs.close();
                    stm.close();
                    throw new DriverRegistroServiziNotFound("Servizio non trovato");
                }
                idAccordoServizio = rs.getLong("id_accordo");
                rs.close();
                stm.close();
                break;
            }
        }
        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("accordi");
        sqlQueryObject.addSelectField("*");
        sqlQueryObject.addWhereCondition("id = ?");
        sqlQuery = sqlQueryObject.createSQLQuery();
        stm = con.prepareStatement(sqlQuery);
        stm.setLong(1, idAccordoServizio);
        this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idAccordoServizio)));
        rs = stm.executeQuery();
        if (rs.next()) {
            servizioSPcoop.setIdAccordo(idAccordoServizio);
            String tmp = rs.getString("nome");
            String tmpVersione = rs.getString("versione");
            long id_referente = rs.getLong("id_referente");
            IDSoggetto soggettoReferente = null;
            if (id_referente > 0L) {
                SoggettoSpcoop s = this.getSoggettoRegistro(id_referente);
                if (s == null) {
                    throw new Exception("Soggetto referente [" + id_referente + "] dell'accordo non esiste");
                }
                soggettoReferente = new IDSoggetto(s.getTipo(), s.getNome());
            }
            servizioSPcoop.setAccordoServizio(IDAccordo.getUriFromValues(tmp, soggettoReferente, tmpVersione));
        }
        rs.close();
        stm.close();
        try {
            List<Documento> allegati = DriverRegistroServiziDB_LIB.getListaDocumenti(RuoliDocumento.allegato.toString(), idServ, ProprietariDocumento.servizio, readContenutoAllegati, con);
            for (int i = 0; i < allegati.size(); ++i) {
                servizioSPcoop.addAllegato(allegati.get(i));
            }
        }
        catch (DriverRegistroServiziNotFound dNotFound) {
            // empty catch block
        }
        try {
            List<Documento> specificheSemiformali = DriverRegistroServiziDB_LIB.getListaDocumenti(RuoliDocumento.specificaSemiformale.toString(), idServ, ProprietariDocumento.servizio, readContenutoAllegati, con);
            for (int i = 0; i < specificheSemiformali.size(); ++i) {
                servizioSPcoop.addSpecificaSemiformale(specificheSemiformali.get(i));
            }
        }
        catch (DriverRegistroServiziNotFound dNotFound) {
            // empty catch block
        }
        try {
            List<Documento> specificheLivelloServizio = DriverRegistroServiziDB_LIB.getListaDocumenti(RuoliDocumento.specificaLivelloServizio.toString(), idServ, ProprietariDocumento.servizio, readContenutoAllegati, con);
            for (int i = 0; i < specificheLivelloServizio.size(); ++i) {
                servizioSPcoop.addSpecificaLivelloServizio(specificheLivelloServizio.get(i));
            }
        }
        catch (DriverRegistroServiziNotFound dNotFound) {
            // empty catch block
        }
        try {
            List<Documento> specificheSicurezza = DriverRegistroServiziDB_LIB.getListaDocumenti(RuoliDocumento.specificaSicurezza.toString(), idServ, ProprietariDocumento.servizio, readContenutoAllegati, con);
            for (int i = 0; i < specificheSicurezza.size(); ++i) {
                servizioSPcoop.addSpecificaSicurezza(specificheSicurezza.get(i));
            }
        }
        catch (DriverRegistroServiziNotFound dNotFound) {
            // empty catch block
        }
        ServizioSpcoop servizioSpcoop = servizioSPcoop;
        Object var40_47 = null;
        try {
            if (rs != null) {
                rs.close();
            }
            if (rs1 != null) {
                rs1.close();
            }
            if (stm != null) {
                stm.close();
            }
            if (stm1 != null) {
                stm1.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (conParam == null && this.atomica) {
                this.log.debug((Object)"rilascio le connessioni al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        {
            return servizioSpcoop;
            catch (DriverRegistroServiziNotFound e) {
                throw e;
            }
            catch (Exception se) {
                this.log.debug((Object)("[DriverRegistroServiziDB::getServizioSPCoop] SqlException:" + se.getMessage()));
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getServizioSPCoop] SqlException:" + se.getMessage(), se);
            }
        }
        catch (Throwable throwable) {
            Object var40_48 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (rs1 != null) {
                    rs1.close();
                }
                if (stm != null) {
                    stm.close();
                }
                if (stm1 != null) {
                    stm1.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (conParam == null && this.atomica) {
                    this.log.debug((Object)"rilascio le connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public List<Azione> accordiAzioniList(int idAccordo, ISearch ricerca) throws DriverRegistroServiziException {
        String queryString;
        ISQLQueryObject sqlQueryObject;
        String nomeMetodo = "accordiAzioniList";
        int idLista = 14;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<Azione> lista = new ArrayList<Azione>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        if (!search.equals("")) {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("accordi_azioni");
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
        } else {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("accordi_azioni");
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            queryString = sqlQueryObject.createSQLQuery();
        }
        stmt = con.prepareStatement(queryString);
        stmt.setInt(1, idAccordo);
        risultato = stmt.executeQuery();
        if (risultato.next()) {
            ricerca.setNumEntries(idLista, risultato.getInt(1));
        }
        risultato.close();
        stmt.close();
        if (limit == 0) {
            limit = 1000;
        }
        if (!search.equals("")) {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("accordi_azioni");
            sqlQueryObject.addSelectAliasField("id", "idAzione");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("conferma_ricezione");
            sqlQueryObject.addSelectField("consegna_in_ordine");
            sqlQueryObject.addSelectField("filtro_duplicati");
            sqlQueryObject.addSelectField("identificativo_collaborazione");
            sqlQueryObject.addSelectField("scadenza");
            sqlQueryObject.addSelectField("profilo_collaborazione");
            sqlQueryObject.addSelectField("profilo_azione");
            sqlQueryObject.addSelectField("id_accordo");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("nome");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
        } else {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("accordi_azioni");
            sqlQueryObject.addSelectAliasField("id", "idAzione");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("conferma_ricezione");
            sqlQueryObject.addSelectField("consegna_in_ordine");
            sqlQueryObject.addSelectField("filtro_duplicati");
            sqlQueryObject.addSelectField("identificativo_collaborazione");
            sqlQueryObject.addSelectField("scadenza");
            sqlQueryObject.addSelectField("profilo_collaborazione");
            sqlQueryObject.addSelectField("profilo_azione");
            sqlQueryObject.addSelectField("id_accordo");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQueryObject.addOrderBy("nome");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
        }
        stmt = con.prepareStatement(queryString);
        stmt.setInt(1, idAccordo);
        risultato = stmt.executeQuery();
        while (risultato.next()) {
            Azione az = new Azione();
            az.setId(risultato.getLong("idAzione"));
            az.setNome(risultato.getString("nome"));
            az.setConfermaRicezione(risultato.getString("conferma_ricezione"));
            az.setConsegnaInOrdine(risultato.getString("consegna_in_ordine"));
            az.setFiltroDuplicati(risultato.getString("filtro_duplicati"));
            az.setIdCollaborazione(risultato.getString("identificativo_collaborazione"));
            az.setScadenza(risultato.getString("scadenza"));
            az.setProfiloCollaborazione(risultato.getString("profilo_collaborazione"));
            az.setProfAzione(risultato.getString("profilo_azione"));
            lista.add(az);
        }
        ArrayList<Azione> arrayList = lista;
        Object var17_18 = null;
        try {
            if (risultato != null) {
                risultato.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (error && this.atomica) {
                this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                con.rollback();
                con.setAutoCommit(true);
                con.close();
            } else if (!error && this.atomica) {
                this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                con.commit();
                con.setAutoCommit(true);
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return arrayList;
        catch (Exception qe) {
            try {
                error = true;
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                Object var17_19 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (error && this.atomica) {
                        this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                        con.rollback();
                        con.setAutoCommit(true);
                        con.close();
                    } else if (!error && this.atomica) {
                        this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                        con.commit();
                        con.setAutoCommit(true);
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public List<Azione> accordiAzioniList(int idAccordo, String profiloCollaborazione, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiAzioniList";
        int idLista = 14;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<Azione> lista = new ArrayList<Azione>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("accordi");
        sqlQueryObject.addFromTable("accordi_azioni");
        sqlQueryObject.addSelectCountField("accordi_azioni.id", "cont");
        sqlQueryObject.addWhereCondition("accordi_azioni.id_accordo = accordi.id");
        sqlQueryObject.addWhereCondition("accordi_azioni.id_accordo = ?");
        sqlQueryObject.addWhereCondition(false, "accordi_azioni.profilo_collaborazione = ? AND accordi_azioni.profilo_azione= ?", "accordi.profilo_collaborazione=?");
        sqlQueryObject.setANDLogicOperator(true);
        if (!search.equals("")) {
            sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
        }
        String queryString = sqlQueryObject.createSQLQuery();
        stmt = con.prepareStatement(queryString);
        stmt.setInt(1, idAccordo);
        stmt.setString(2, profiloCollaborazione);
        stmt.setString(3, "ridefinito");
        stmt.setString(4, profiloCollaborazione);
        risultato = stmt.executeQuery();
        if (risultato.next()) {
            ricerca.setNumEntries(idLista, risultato.getInt(1));
        }
        risultato.close();
        stmt.close();
        if (limit == 0) {
            limit = 1000;
        }
        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("accordi");
        sqlQueryObject.addFromTable("accordi_azioni");
        sqlQueryObject.addSelectField("accordi_azioni", "nome");
        sqlQueryObject.addSelectField("accordi_azioni", "conferma_ricezione");
        sqlQueryObject.addSelectField("accordi_azioni", "consegna_in_ordine");
        sqlQueryObject.addSelectField("accordi_azioni", "filtro_duplicati");
        sqlQueryObject.addSelectField("accordi_azioni", "identificativo_collaborazione");
        sqlQueryObject.addSelectField("accordi_azioni", "scadenza");
        sqlQueryObject.addSelectField("accordi_azioni", "profilo_collaborazione");
        sqlQueryObject.addSelectField("accordi_azioni", "profilo_azione");
        sqlQueryObject.addSelectField("accordi_azioni", "id_accordo");
        sqlQueryObject.addWhereCondition("accordi_azioni.id_accordo = accordi.id");
        sqlQueryObject.addWhereCondition("accordi_azioni.id_accordo = ?");
        sqlQueryObject.addWhereCondition(false, "accordi_azioni.profilo_collaborazione = ? AND accordi_azioni.profilo_azione= ?", "accordi.profilo_collaborazione=?");
        sqlQueryObject.setANDLogicOperator(true);
        sqlQueryObject.setLimit(limit);
        sqlQueryObject.setOffset(offset);
        sqlQueryObject.addOrderBy("accordi_azioni.nome");
        if (!search.equals("")) {
            sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
        }
        queryString = sqlQueryObject.createSQLQuery();
        stmt = con.prepareStatement(queryString);
        stmt.setInt(1, idAccordo);
        stmt.setString(2, profiloCollaborazione);
        stmt.setString(3, "ridefinito");
        stmt.setString(4, profiloCollaborazione);
        risultato = stmt.executeQuery();
        while (risultato.next()) {
            Azione az = new Azione();
            az.setNome(risultato.getString("nome"));
            az.setConfermaRicezione(risultato.getString("conferma_ricezione"));
            az.setConsegnaInOrdine(risultato.getString("consegna_in_ordine"));
            az.setFiltroDuplicati(risultato.getString("filtro_duplicati"));
            az.setIdCollaborazione(risultato.getString("identificativo_collaborazione"));
            az.setScadenza(risultato.getString("scadenza"));
            az.setProfiloCollaborazione(risultato.getString("profilo_collaborazione"));
            az.setProfAzione(risultato.getString("profilo_azione"));
            lista.add(az);
        }
        ArrayList<Azione> arrayList = lista;
        Object var19_20 = null;
        try {
            if (risultato != null) {
                risultato.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (error && this.atomica) {
                this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                con.rollback();
                con.setAutoCommit(true);
                con.close();
            } else if (!error && this.atomica) {
                this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                con.commit();
                con.setAutoCommit(true);
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return arrayList;
        catch (Exception qe) {
            try {
                error = true;
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                Object var19_21 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (error && this.atomica) {
                        this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                        con.rollback();
                        con.setAutoCommit(true);
                        con.close();
                    } else if (!error && this.atomica) {
                        this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                        con.commit();
                        con.setAutoCommit(true);
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public List<ServizioSpcoop> serviziList(ISearch ricerca) throws DriverRegistroServiziException {
        String queryString;
        ISQLQueryObject sqlQueryObject;
        String nomeMetodo = "serviziList";
        int idLista = 13;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        this.log.debug((Object)("search : " + search));
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<ServizioSpcoop> lista = new ArrayList<ServizioSpcoop>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        if (!search.equals("")) {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.addWhereLikeCondition("nome_servizio", search, true, true);
            queryString = sqlQueryObject.createSQLQuery();
        } else {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectCountField("*", "cont");
            queryString = sqlQueryObject.createSQLQuery();
        }
        stmt = con.prepareStatement(queryString);
        risultato = stmt.executeQuery();
        if (risultato.next()) {
            ricerca.setNumEntries(idLista, risultato.getInt(1));
        }
        risultato.close();
        stmt.close();
        if (limit == 0) {
            limit = 1000;
        }
        if (!search.equals("")) {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addSelectField("nome_servizio");
            sqlQueryObject.addSelectField("tipo_servizio");
            sqlQueryObject.addSelectField("id_soggetto");
            sqlQueryObject.addSelectField("id_accordo");
            sqlQueryObject.addSelectField("servizio_correlato");
            sqlQueryObject.addSelectField("stato");
            sqlQueryObject.addWhereLikeCondition("nome_servizio", search, true, true);
            sqlQueryObject.addOrderBy("tipo_servizio");
            sqlQueryObject.addOrderBy("nome_servizio");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
        } else {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addSelectField("nome_servizio");
            sqlQueryObject.addSelectField("tipo_servizio");
            sqlQueryObject.addSelectField("id_soggetto");
            sqlQueryObject.addSelectField("id_accordo");
            sqlQueryObject.addSelectField("servizio_correlato");
            sqlQueryObject.addSelectField("stato");
            sqlQueryObject.addOrderBy("tipo_servizio");
            sqlQueryObject.addOrderBy("nome_servizio");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
        }
        this.log.debug((Object)("query : " + queryString));
        stmt = con.prepareStatement(queryString);
        risultato = stmt.executeQuery();
        while (risultato.next()) {
            ServizioSpcoop serv = new ServizioSpcoop();
            serv.setId(risultato.getLong("id"));
            serv.setNome(risultato.getString("nome_servizio"));
            serv.setTipo(risultato.getString("tipo_servizio"));
            serv.setIdSoggetto(risultato.getLong("id_soggetto"));
            serv.setIdAccordo(risultato.getLong("id_accordo"));
            String servizio_correlato = risultato.getString("servizio_correlato");
            serv.setServizioCorrelato(servizio_correlato != null && servizio_correlato.equalsIgnoreCase("abilitato"));
            SoggettoSpcoop sog = this.getSoggettoRegistro(serv.getIdSoggetto(), con);
            String nomeErogatore = sog.getNome();
            String tipoErogatore = sog.getTipo();
            serv.setNomeSoggettoErogatore(nomeErogatore);
            serv.setTipoSoggettoErogatore(tipoErogatore);
            AccordoServizio as = this.getAccordoServizio(serv.getIdAccordo(), con);
            serv.setAccordoServizio(IDAccordo.getUriFromAccordo(as));
            serv.setStatoPackage(risultato.getString("stato"));
            lista.add(serv);
        }
        this.log.debug((Object)("size lista :" + (lista == null ? null : Integer.valueOf(lista.size()))));
        ArrayList<ServizioSpcoop> arrayList = lista;
        Object var20_21 = null;
        try {
            if (risultato != null) {
                risultato.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (error && this.atomica) {
                this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                con.rollback();
                con.setAutoCommit(true);
                con.close();
            } else if (!error && this.atomica) {
                this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                con.commit();
                con.setAutoCommit(true);
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return arrayList;
        catch (Exception qe) {
            try {
                error = true;
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                Object var20_22 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (error && this.atomica) {
                        this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                        con.rollback();
                        con.setAutoCommit(true);
                        con.close();
                    } else if (!error && this.atomica) {
                        this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                        con.commit();
                        con.setAutoCommit(true);
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public List<ServizioSpcoop> servizioWithSoggettoFruitore(IDSoggetto idSoggetto) throws DriverRegistroServiziException {
        ArrayList<ServizioSpcoop> idServiziSPCoop;
        block22: {
            String nomeMetodo = "servizioWithSoggettoFruitore";
            Connection con = null;
            Statement stmt = null;
            ResultSet risultato = null;
            idServiziSPCoop = new ArrayList<ServizioSpcoop>();
            if (this.atomica) {
                try {
                    con = this.datasource.getConnection();
                }
                catch (SQLException e) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.globalConnection;
            }
            this.log.debug((Object)("operazione this.atomica = " + this.atomica));
            ISQLQueryObject sqlQueryObjectSoggetti = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObjectSoggetti.addFromTable("soggetti");
            sqlQueryObjectSoggetti.addFromTable("servizi_fruitori");
            sqlQueryObjectSoggetti.addFromTable("servizi");
            sqlQueryObjectSoggetti.setSelectDistinct(true);
            sqlQueryObjectSoggetti.addSelectAliasField("servizi", "id", "idServizio");
            sqlQueryObjectSoggetti.addWhereCondition("servizi_fruitori.id_servizio=servizi.id");
            sqlQueryObjectSoggetti.addWhereCondition("servizi_fruitori.id_soggetto=soggetti.id");
            sqlQueryObjectSoggetti.addWhereCondition("soggetti.tipo_soggetto=?");
            sqlQueryObjectSoggetti.addWhereCondition("soggetti.nome_soggetto=?");
            sqlQueryObjectSoggetti.setANDLogicOperator(true);
            String queryString = sqlQueryObjectSoggetti.createSQLQuery();
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(queryString, new Object[0])));
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, idSoggetto.getTipo());
            stmt.setString(2, idSoggetto.getNome());
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                long idServizioLong = risultato.getLong("idServizio");
                ServizioSpcoop serv = this.getServizioSpcoop(idServizioLong);
                SoggettoSpcoop s = this.getSoggettoRegistro(serv.getIdSoggetto());
                serv.setTipoSoggettoErogatore(s.getTipo());
                serv.setNomeSoggettoErogatore(s.getNome());
                idServiziSPCoop.add(serv);
            }
            Object var14_14 = null;
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
                break block22;
            }
            catch (Exception e) {}
            break block22;
            {
                catch (Exception se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
                }
            }
            catch (Throwable throwable) {
                Object var14_15 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return idServiziSPCoop;
    }

    @Override
    public List<AccordoServizio> accordiList(String superuser, ISearch ricerca) throws DriverRegistroServiziException {
        return this.accordiListEngine(superuser, ricerca, false, false);
    }

    public List<AccordoServizio> accordiServizioParteComuneList(String superuser, ISearch ricerca) throws DriverRegistroServiziException {
        return this.accordiListEngine(superuser, ricerca, false, true);
    }

    public List<AccordoServizio> accordiServizioCompostiList(String superuser, ISearch ricerca) throws DriverRegistroServiziException {
        return this.accordiListEngine(superuser, ricerca, true, false);
    }

    /*
     * Loose catch block
     */
    private List<AccordoServizio> accordiListEngine(String superuser, ISearch ricerca, boolean excludeASParteComune, boolean excludeASComposti) throws DriverRegistroServiziException {
        String queryString;
        ISQLQueryObject sqlQueryObject;
        String nomeMetodo = "accordiList";
        int idLista = 17;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        this.log.debug((Object)("search : " + search));
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<AccordoServizio> lista = new ArrayList<AccordoServizio>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        if (excludeASComposti && excludeASParteComune) {
            throw new Exception("Non e' possibile invocare il metodo accordiListEngine con entrambi i parametri excludeASParteComune,excludeASComposti impostati al valore true");
        }
        ISQLQueryObject sqlQueryObjectSoggetti = null;
        if (!search.equals("")) {
            sqlQueryObjectSoggetti = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObjectSoggetti.addFromTable("soggetti");
            sqlQueryObjectSoggetti.addSelectField("soggetti", "nome_soggetto");
            sqlQueryObjectSoggetti.addWhereCondition(true, sqlQueryObjectSoggetti.getWhereLikeCondition("nome_soggetto", search, true, true), "accordi.id_referente=soggetti.id");
        }
        ISQLQueryObject sqlQueryObjectExclude = null;
        if (excludeASComposti || excludeASParteComune) {
            sqlQueryObjectExclude = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObjectExclude.addFromTable("acc_serv_composti");
            sqlQueryObjectExclude.addSelectField("acc_serv_composti", "id_accordo");
            sqlQueryObjectExclude.addWhereCondition("acc_serv_composti.id_accordo=accordi.id");
        }
        if (!search.equals("")) {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addSelectCountField("*", "cont");
            if (superuser != null && !superuser.equals("")) {
                sqlQueryObject.addWhereCondition("superuser = ?");
            }
            sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("nome", search, true, true), sqlQueryObject.getWhereLikeCondition("versione", search, true, true), sqlQueryObject.getWhereExistsCondition(false, sqlQueryObjectSoggetti));
            if (excludeASParteComune) {
                sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectExclude);
            }
            if (excludeASComposti) {
                sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectExclude);
            }
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
        } else {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addSelectCountField("*", "cont");
            if (superuser != null && !superuser.equals("")) {
                sqlQueryObject.addWhereCondition("superuser = ?");
            }
            if (excludeASParteComune) {
                sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectExclude);
            }
            if (excludeASComposti) {
                sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectExclude);
            }
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
        }
        stmt = con.prepareStatement(queryString);
        if (superuser != null && !superuser.equals("")) {
            stmt.setString(1, superuser);
        }
        if ((risultato = stmt.executeQuery()).next()) {
            ricerca.setNumEntries(idLista, risultato.getInt(1));
        }
        risultato.close();
        stmt.close();
        if (limit == 0) {
            limit = 1000;
        }
        if (!search.equals("")) {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("versione");
            sqlQueryObject.addSelectField("id_referente");
            if (superuser != null && !superuser.equals("")) {
                sqlQueryObject.addWhereCondition("superuser = ?");
            }
            sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("nome", search, true, true), sqlQueryObject.getWhereLikeCondition("versione", search, true, true), sqlQueryObject.getWhereExistsCondition(false, sqlQueryObjectSoggetti));
            if (excludeASParteComune) {
                sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectExclude);
            }
            if (excludeASComposti) {
                sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectExclude);
            }
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("nome");
            sqlQueryObject.addOrderBy("versione");
            sqlQueryObject.addOrderBy("id_referente");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
        } else {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("versione");
            sqlQueryObject.addSelectField("id_referente");
            if (superuser != null && !superuser.equals("")) {
                sqlQueryObject.addWhereCondition("superuser = ?");
            }
            if (excludeASParteComune) {
                sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectExclude);
            }
            if (excludeASComposti) {
                sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectExclude);
            }
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("nome");
            sqlQueryObject.addOrderBy("versione");
            sqlQueryObject.addOrderBy("id_referente");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
        }
        this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(queryString, new Object[0])));
        stmt = con.prepareStatement(queryString);
        if (superuser != null && !superuser.equals("")) {
            stmt.setString(1, superuser);
        }
        risultato = stmt.executeQuery();
        AccordoServizio accordo = null;
        while (risultato.next()) {
            Long id = risultato.getLong("id");
            accordo = this.getAccordoServizio(id, con);
            lista.add(accordo);
        }
        this.log.debug((Object)("size lista :" + (lista == null ? null : Integer.valueOf(lista.size()))));
        ArrayList<AccordoServizio> arrayList = lista;
        Object var20_21 = null;
        try {
            if (risultato != null) {
                risultato.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessioni al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return arrayList;
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                Object var20_22 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public List<AccordoCooperazione> accordiCooperazioneList(String superuser, ISearch ricerca) throws DriverRegistroServiziException {
        ArrayList<IDAccordoCooperazione> idAccordi;
        block39: {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            String nomeMetodo = "accordiCooperazioneList";
            int idLista = 34;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
            ricerca.getSearchString(idLista);
            this.log.debug((Object)("search : " + search));
            Connection con = null;
            Statement stmt = null;
            ResultSet risultato = null;
            idAccordi = new ArrayList<IDAccordoCooperazione>();
            if (this.atomica) {
                try {
                    con = this.datasource.getConnection();
                }
                catch (SQLException e) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.globalConnection;
            }
            this.log.debug((Object)("operazione this.atomica = " + this.atomica));
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("accordi_cooperazione");
                sqlQueryObject.addSelectCountField("*", "cont");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("nome", search, true, true), sqlQueryObject.getWhereLikeCondition("versione", search, true, true));
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.setANDLogicOperator(true);
                }
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("accordi_cooperazione");
                sqlQueryObject.addSelectCountField("*", "cont");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            if (superuser != null && !superuser.equals("")) {
                stmt.setString(1, superuser);
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("accordi_cooperazione");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("descrizione");
                sqlQueryObject.addSelectField("versione");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("nome", search, true, true), sqlQueryObject.getWhereLikeCondition("versione", search, true, true));
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.setANDLogicOperator(true);
                }
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.addOrderBy("versione");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("accordi_cooperazione");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("descrizione");
                sqlQueryObject.addSelectField("versione");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.addOrderBy("versione");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(queryString, new Object[0])));
            stmt = con.prepareStatement(queryString);
            if (superuser != null && !superuser.equals("")) {
                stmt.setString(1, superuser);
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                String nomeAcc = risultato.getString("nome");
                String versioneAcc = risultato.getString("versione");
                IDAccordoCooperazione id = IDAccordoCooperazione.getIDAccordoFromValues(nomeAcc, versioneAcc);
                idAccordi.add(id);
            }
            this.log.debug((Object)("size lista :" + (idAccordi == null ? null : Integer.valueOf(idAccordi.size()))));
            Object var17_20 = null;
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
                break block39;
            }
            catch (Exception e) {}
            break block39;
            {
                catch (Exception se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
                }
            }
            catch (Throwable throwable) {
                Object var17_21 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        ArrayList<AccordoCooperazione> lista = new ArrayList<AccordoCooperazione>();
        for (int i = 0; i < idAccordi.size(); ++i) {
            try {
                lista.add(this.getAccordoCooperazione((IDAccordoCooperazione)idAccordi.get(i)));
                continue;
            }
            catch (DriverRegistroServiziNotFound dNot) {
                throw new DriverRegistroServiziException("Accordo non trovato con id?: " + dNot.getMessage(), dNot);
            }
        }
        return lista;
    }

    /*
     * Loose catch block
     */
    public List<IDSoggetto> accordiCoopPartecipantiList(long idAccordo, ISearch ricerca) throws DriverRegistroServiziException {
        ArrayList<IDSoggetto> idSoggetti;
        block28: {
            String queryString;
            ISQLQueryObject sqlQueryObjectSoggetti;
            String nomeMetodo = "accordiCoopPartecipantiList";
            int idLista = 36;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
            ricerca.getSearchString(idLista);
            this.log.debug((Object)("search : " + search));
            Connection con = null;
            Statement stmt = null;
            ResultSet risultato = null;
            idSoggetti = new ArrayList<IDSoggetto>();
            if (this.atomica) {
                try {
                    con = this.datasource.getConnection();
                }
                catch (SQLException e) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.globalConnection;
            }
            this.log.debug((Object)("operazione this.atomica = " + this.atomica));
            if (!search.equals("")) {
                sqlQueryObjectSoggetti = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObjectSoggetti.addFromTable("soggetti");
                sqlQueryObjectSoggetti.addFromTable("accordi_coop_partecipanti");
                sqlQueryObjectSoggetti.addSelectCountField("*", "cont");
                sqlQueryObjectSoggetti.addSelectField("soggetti", "nome_soggetto");
                sqlQueryObjectSoggetti.addWhereCondition(true, sqlQueryObjectSoggetti.getWhereLikeCondition("soggetti.nome_soggetto", search, true, true), "accordi_coop_partecipanti.id_soggetto=soggetti.id");
                sqlQueryObjectSoggetti.addWhereCondition("accordi_coop_partecipanti.id_accordo_cooperazione=?");
                sqlQueryObjectSoggetti.setANDLogicOperator(true);
                queryString = sqlQueryObjectSoggetti.createSQLQuery();
            } else {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("accordi_coop_partecipanti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("accordi_coop_partecipanti.id_accordo_cooperazione=?");
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordo);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObjectSoggetti = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObjectSoggetti.addFromTable("soggetti");
                sqlQueryObjectSoggetti.addFromTable("accordi_coop_partecipanti");
                sqlQueryObjectSoggetti.addSelectField("soggetti", "nome_soggetto");
                sqlQueryObjectSoggetti.addSelectField("soggetti", "tipo_soggetto");
                sqlQueryObjectSoggetti.addSelectField("soggetti", "id");
                sqlQueryObjectSoggetti.addSelectField("accordi_coop_partecipanti", "id_soggetto");
                sqlQueryObjectSoggetti.addSelectField("accordi_coop_partecipanti", "id_accordo_cooperazione");
                sqlQueryObjectSoggetti.addWhereCondition(true, sqlQueryObjectSoggetti.getWhereLikeCondition("soggetti.nome_soggetto", search, true, true), "accordi_coop_partecipanti.id_soggetto=soggetti.id");
                sqlQueryObjectSoggetti.addWhereCondition("accordi_coop_partecipanti.id_accordo_cooperazione=?");
                sqlQueryObjectSoggetti.setANDLogicOperator(true);
                sqlQueryObjectSoggetti.addOrderBy("tipo_soggetto");
                sqlQueryObjectSoggetti.addOrderBy("nome_soggetto");
                sqlQueryObjectSoggetti.setSortType(true);
                sqlQueryObjectSoggetti.setLimit(limit);
                sqlQueryObjectSoggetti.setOffset(offset);
                queryString = sqlQueryObjectSoggetti.createSQLQuery();
            } else {
                sqlQueryObjectSoggetti = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObjectSoggetti.addFromTable("soggetti");
                sqlQueryObjectSoggetti.addFromTable("accordi_coop_partecipanti");
                sqlQueryObjectSoggetti.addSelectField("soggetti", "nome_soggetto");
                sqlQueryObjectSoggetti.addSelectField("soggetti", "tipo_soggetto");
                sqlQueryObjectSoggetti.addSelectField("soggetti", "id");
                sqlQueryObjectSoggetti.addSelectField("accordi_coop_partecipanti", "id_soggetto");
                sqlQueryObjectSoggetti.addSelectField("accordi_coop_partecipanti", "id_accordo_cooperazione");
                sqlQueryObjectSoggetti.addWhereCondition("accordi_coop_partecipanti.id_accordo_cooperazione=?");
                sqlQueryObjectSoggetti.addWhereCondition("accordi_coop_partecipanti.id_soggetto=soggetti.id");
                sqlQueryObjectSoggetti.setANDLogicOperator(true);
                sqlQueryObjectSoggetti.addOrderBy("tipo_soggetto");
                sqlQueryObjectSoggetti.addOrderBy("nome_soggetto");
                sqlQueryObjectSoggetti.setSortType(true);
                sqlQueryObjectSoggetti.setLimit(limit);
                sqlQueryObjectSoggetti.setOffset(offset);
                queryString = sqlQueryObjectSoggetti.createSQLQuery();
            }
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(queryString, new Object[0])));
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordo);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                String tipo = risultato.getString("tipo_soggetto");
                String nome = risultato.getString("nome_soggetto");
                IDSoggetto idSogg = new IDSoggetto(tipo, nome);
                idSoggetti.add(idSogg);
            }
            Object var18_18 = null;
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
                break block28;
            }
            catch (Exception e) {}
            break block28;
            {
                catch (Exception se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
                }
            }
            catch (Throwable throwable) {
                Object var18_19 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return idSoggetti;
    }

    /*
     * Loose catch block
     */
    public List<AccordoCooperazione> accordiCoopWithSoggettoPartecipante(IDSoggetto idSoggetto) throws DriverRegistroServiziException {
        ArrayList<AccordoCooperazione> idAccordoCooperazione;
        block22: {
            String nomeMetodo = "accordiCoopWithSoggettoPartecipante";
            Connection con = null;
            Statement stmt = null;
            ResultSet risultato = null;
            idAccordoCooperazione = new ArrayList<AccordoCooperazione>();
            if (this.atomica) {
                try {
                    con = this.datasource.getConnection();
                }
                catch (SQLException e) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.globalConnection;
            }
            this.log.debug((Object)("operazione this.atomica = " + this.atomica));
            ISQLQueryObject sqlQueryObjectSoggetti = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObjectSoggetti.addFromTable("soggetti");
            sqlQueryObjectSoggetti.addFromTable("accordi_coop_partecipanti");
            sqlQueryObjectSoggetti.addFromTable("accordi_cooperazione");
            sqlQueryObjectSoggetti.addSelectAliasField("accordi_cooperazione", "id", "idAccordoCooperazione");
            sqlQueryObjectSoggetti.addWhereCondition("accordi_coop_partecipanti.id_accordo_cooperazione=accordi_cooperazione.id");
            sqlQueryObjectSoggetti.addWhereCondition("accordi_coop_partecipanti.id_soggetto=soggetti.id");
            sqlQueryObjectSoggetti.addWhereCondition("soggetti.tipo_soggetto=?");
            sqlQueryObjectSoggetti.addWhereCondition("soggetti.nome_soggetto=?");
            sqlQueryObjectSoggetti.setANDLogicOperator(true);
            String queryString = sqlQueryObjectSoggetti.createSQLQuery();
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(queryString, new Object[0])));
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, idSoggetto.getTipo());
            stmt.setString(2, idSoggetto.getNome());
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                long idAccordoCooperazioneLong = risultato.getLong("idAccordoCooperazione");
                idAccordoCooperazione.add(this.getAccordoCooperazione(idAccordoCooperazioneLong));
            }
            Object var12_12 = null;
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
                break block22;
            }
            catch (Exception e) {}
            break block22;
            {
                catch (Exception se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
                }
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return idAccordoCooperazione;
    }

    /*
     * Loose catch block
     */
    public List<AccordoServizio> accordiServizio_serviziComponentiConSoggettoErogatore(IDSoggetto idSoggetto) throws DriverRegistroServiziException {
        ArrayList<AccordoServizio> idAccordoServizio;
        block22: {
            String nomeMetodo = "accordiServizio_serviziComponentiConSoggettoErogatore";
            Connection con = null;
            Statement stmt = null;
            ResultSet risultato = null;
            idAccordoServizio = new ArrayList<AccordoServizio>();
            if (this.atomica) {
                try {
                    con = this.datasource.getConnection();
                }
                catch (SQLException e) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.globalConnection;
            }
            this.log.debug((Object)("operazione this.atomica = " + this.atomica));
            ISQLQueryObject sqlQueryObjectSoggetti = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObjectSoggetti.addFromTable("soggetti");
            sqlQueryObjectSoggetti.addFromTable("accordi");
            sqlQueryObjectSoggetti.addFromTable("acc_serv_composti");
            sqlQueryObjectSoggetti.addFromTable("acc_serv_componenti");
            sqlQueryObjectSoggetti.addFromTable("servizi");
            sqlQueryObjectSoggetti.addSelectAliasField("accordi", "id", "idAccordoServizio");
            sqlQueryObjectSoggetti.addWhereCondition("accordi.id=acc_serv_composti.id_accordo");
            sqlQueryObjectSoggetti.addWhereCondition("acc_serv_composti.id=acc_serv_componenti.id_servizio_composto");
            sqlQueryObjectSoggetti.addWhereCondition("acc_serv_componenti.id_servizio_componente=servizi.id");
            sqlQueryObjectSoggetti.addWhereCondition("soggetti.id=servizi.id_soggetto");
            sqlQueryObjectSoggetti.addWhereCondition("soggetti.tipo_soggetto=?");
            sqlQueryObjectSoggetti.addWhereCondition("soggetti.nome_soggetto=?");
            sqlQueryObjectSoggetti.setANDLogicOperator(true);
            String queryString = sqlQueryObjectSoggetti.createSQLQuery();
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(queryString, new Object[0])));
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, idSoggetto.getTipo());
            stmt.setString(2, idSoggetto.getNome());
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                long idAccordoServizioLong = risultato.getLong("idAccordoServizio");
                idAccordoServizio.add(this.getAccordoServizio(idAccordoServizioLong));
            }
            Object var12_12 = null;
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
                break block22;
            }
            catch (Exception e) {}
            break block22;
            {
                catch (Exception se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
                }
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return idAccordoServizio;
    }

    /*
     * Loose catch block
     */
    public List<AccordoServizio> accordiServizio_serviziComponenti(IDServizio idServizio) throws DriverRegistroServiziException {
        ArrayList<AccordoServizio> idAccordoServizio;
        block22: {
            String nomeMetodo = "accordiServizio_serviziComponenti";
            Connection con = null;
            Statement stmt = null;
            ResultSet risultato = null;
            idAccordoServizio = new ArrayList<AccordoServizio>();
            if (this.atomica) {
                try {
                    con = this.datasource.getConnection();
                }
                catch (SQLException e) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.globalConnection;
            }
            this.log.debug((Object)("operazione this.atomica = " + this.atomica));
            ISQLQueryObject sqlQueryObjectSoggetti = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObjectSoggetti.addFromTable("soggetti");
            sqlQueryObjectSoggetti.addFromTable("accordi");
            sqlQueryObjectSoggetti.addFromTable("acc_serv_composti");
            sqlQueryObjectSoggetti.addFromTable("acc_serv_componenti");
            sqlQueryObjectSoggetti.addFromTable("servizi");
            sqlQueryObjectSoggetti.addSelectAliasField("accordi", "id", "idAccordoServizio");
            sqlQueryObjectSoggetti.addWhereCondition("accordi.id=acc_serv_composti.id_accordo");
            sqlQueryObjectSoggetti.addWhereCondition("acc_serv_composti.id=acc_serv_componenti.id_servizio_composto");
            sqlQueryObjectSoggetti.addWhereCondition("acc_serv_componenti.id_servizio_componente=servizi.id");
            sqlQueryObjectSoggetti.addWhereCondition("soggetti.id=servizi.id_soggetto");
            sqlQueryObjectSoggetti.addWhereCondition("soggetti.tipo_soggetto=?");
            sqlQueryObjectSoggetti.addWhereCondition("soggetti.nome_soggetto=?");
            sqlQueryObjectSoggetti.addWhereCondition("servizi.tipo_servizio=?");
            sqlQueryObjectSoggetti.addWhereCondition("servizi.nome_servizio=?");
            sqlQueryObjectSoggetti.setANDLogicOperator(true);
            String queryString = sqlQueryObjectSoggetti.createSQLQuery();
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(queryString, new Object[0])));
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, idServizio.getSoggettoErogatore().getTipo());
            stmt.setString(2, idServizio.getSoggettoErogatore().getNome());
            stmt.setString(3, idServizio.getTipoServizio());
            stmt.setString(4, idServizio.getServizio());
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                long idAccordoServizioLong = risultato.getLong("idAccordoServizio");
                idAccordoServizio.add(this.getAccordoServizio(idAccordoServizioLong));
            }
            Object var12_12 = null;
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
                break block22;
            }
            catch (Exception e) {}
            break block22;
            {
                catch (Exception se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
                }
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return idAccordoServizio;
    }

    /*
     * Loose catch block
     */
    public List<AccordoServizio> accordiServizioWithAccordoCooperazione(IDAccordoCooperazione idAccordoCooperazione) throws DriverRegistroServiziException {
        ArrayList<AccordoServizio> idAccordoServizio;
        block22: {
            String nomeMetodo = "accordiServizioWithAccordoCooperazione";
            Connection con = null;
            Statement stmt = null;
            ResultSet risultato = null;
            idAccordoServizio = new ArrayList<AccordoServizio>();
            if (this.atomica) {
                try {
                    con = this.datasource.getConnection();
                }
                catch (SQLException e) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.globalConnection;
            }
            this.log.debug((Object)("operazione this.atomica = " + this.atomica));
            ISQLQueryObject sqlQueryObjectSoggetti = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObjectSoggetti.addFromTable("accordi");
            sqlQueryObjectSoggetti.addFromTable("acc_serv_composti");
            sqlQueryObjectSoggetti.addFromTable("accordi_cooperazione");
            sqlQueryObjectSoggetti.addSelectAliasField("accordi", "id", "idAccordoServizio");
            sqlQueryObjectSoggetti.addWhereCondition("accordi.id=acc_serv_composti.id_accordo");
            sqlQueryObjectSoggetti.addWhereCondition("acc_serv_composti.id_accordo_cooperazione=accordi_cooperazione.id");
            sqlQueryObjectSoggetti.addWhereCondition("accordi_cooperazione.nome=?");
            sqlQueryObjectSoggetti.addWhereCondition("accordi_cooperazione.versione=?");
            sqlQueryObjectSoggetti.setANDLogicOperator(true);
            String queryString = sqlQueryObjectSoggetti.createSQLQuery();
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(queryString, new Object[0])));
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, idAccordoCooperazione.getNome());
            stmt.setString(2, idAccordoCooperazione.getVersione());
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                long idAccordoServizioLong = risultato.getLong("idAccordoServizio");
                idAccordoServizio.add(this.getAccordoServizio(idAccordoServizioLong));
            }
            Object var12_12 = null;
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
                break block22;
            }
            catch (Exception e) {}
            break block22;
            {
                catch (Exception se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
                }
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return idAccordoServizio;
    }

    /*
     * Loose catch block
     */
    @Override
    public List<SoggettoSpcoop> accordiErogatoriList(int idAccordo, ISearch ricerca) throws DriverRegistroServiziException {
        String queryString;
        ISQLQueryObject sqlQueryObject;
        String nomeMetodo = "accordiErogatoriList";
        int idLista = 19;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<SoggettoSpcoop> lista = new ArrayList<SoggettoSpcoop>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        if (!search.equals("")) {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.addWhereCondition("servizi.id_accordo = ?");
            sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
            sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("soggetti.nome_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("soggetti.tipo_soggetto", search, true, true));
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
        } else {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.addWhereCondition("servizi.id_accordo = ?");
            sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
        }
        stmt = con.prepareStatement(queryString);
        stmt.setInt(1, idAccordo);
        risultato = stmt.executeQuery();
        if (risultato.next()) {
            ricerca.setNumEntries(idLista, risultato.getInt("cont"));
        }
        risultato.close();
        stmt.close();
        if (limit == 0) {
            limit = 1000;
        }
        if (!search.equals("")) {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("soggetti.nome_soggetto");
            sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
            sqlQueryObject.addSelectField("soggetti.id");
            sqlQueryObject.addSelectField("soggetti.descrizione");
            sqlQueryObject.addSelectField("soggetti.identificativo_porta");
            sqlQueryObject.addSelectField("soggetti.codice_ipa");
            sqlQueryObject.addSelectAliasField("servizi.id", "servid");
            sqlQueryObject.addSelectField("servizi.nome_servizio");
            sqlQueryObject.addSelectField("servizi.tipo_servizio");
            sqlQueryObject.addSelectField("servizi.servizio_correlato");
            sqlQueryObject.addSelectField("servizi.id_accordo");
            sqlQueryObject.addSelectField("servizi.id_soggetto");
            sqlQueryObject.addWhereCondition("servizi.id_accordo = ?");
            sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
            sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("soggetti.nome_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("soggetti.tipo_soggetto", search, true, true));
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("soggetti.tipo_soggetto");
            sqlQueryObject.addOrderBy("soggetti.nome_soggetto");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
        } else {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("soggetti.nome_soggetto");
            sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
            sqlQueryObject.addSelectField("soggetti.id");
            sqlQueryObject.addSelectField("soggetti.descrizione");
            sqlQueryObject.addSelectField("soggetti.identificativo_porta");
            sqlQueryObject.addSelectField("soggetti.codice_ipa");
            sqlQueryObject.addSelectAliasField("servizi.id", "servid");
            sqlQueryObject.addSelectField("servizi.nome_servizio");
            sqlQueryObject.addSelectField("servizi.tipo_servizio");
            sqlQueryObject.addSelectField("servizi.servizio_correlato");
            sqlQueryObject.addSelectField("servizi.id_accordo");
            sqlQueryObject.addSelectField("servizi.id_soggetto");
            sqlQueryObject.addWhereCondition("servizi.id_accordo = ?");
            sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("tipo_soggetto");
            sqlQueryObject.addOrderBy("nome_soggetto");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
        }
        stmt = con.prepareStatement(queryString);
        stmt.setInt(1, idAccordo);
        risultato = stmt.executeQuery();
        SoggettoSpcoop sog = null;
        String oldNome = "";
        String oldTipo = "";
        while (risultato.next()) {
            String newNome = risultato.getString("nome_soggetto");
            String newTipo = risultato.getString("tipo_soggetto");
            if (sog == null || !oldTipo.equals(newTipo) || !oldNome.equals(newNome)) {
                oldTipo = newTipo;
                oldNome = newNome;
                if (sog != null) {
                    lista.add(sog);
                }
                sog = new SoggettoSpcoop();
                sog.setId(risultato.getLong("id"));
                sog.setNome(risultato.getString("nome_soggetto"));
                sog.setTipo(risultato.getString("tipo_soggetto"));
                sog.setDescrizione(risultato.getString("descrizione"));
                sog.setIdentificativoPorta(risultato.getString("identificativo_porta"));
                sog.setCodiceIpa(risultato.getString("codice_ipa"));
            }
            ServizioSpcoop serv = new ServizioSpcoop();
            serv.setId(risultato.getLong("servid"));
            serv.setNome(risultato.getString("nome_servizio"));
            serv.setTipo(risultato.getString("tipo_servizio"));
            if (risultato.getString("servizio_correlato").equals("abilitato")) {
                serv.setServizioCorrelato(true);
                sog.addServizioCorrelato(serv);
                continue;
            }
            serv.setServizioCorrelato(false);
            sog.addServizio(serv);
        }
        if (sog != null) {
            lista.add(sog);
        }
        ArrayList<SoggettoSpcoop> arrayList = lista;
        Object var20_21 = null;
        try {
            if (risultato != null) {
                risultato.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessioni al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return arrayList;
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                Object var20_22 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public Fruitore getAccordoErogatoreFruitore(long id) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        this.log.debug((Object)("richiesto getAccordoErogatoreFruitore: " + id));
        if (id <= 0L) {
            return null;
        }
        Fruitore fruitore = null;
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("servizi_fruitori");
        sqlQueryObject.addFromTable("soggetti");
        sqlQueryObject.addSelectField("*");
        sqlQueryObject.addWhereCondition("servizi_fruitori.id = ?");
        sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
        sqlQueryObject.setANDLogicOperator(true);
        String sqlQuery = sqlQueryObject.createSQLQuery();
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
        stm = con.prepareStatement(sqlQuery);
        stm.setLong(1, id);
        this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id)));
        rs = stm.executeQuery();
        if (!rs.next()) {
            throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getAccordoErogatoreFruitore] rs.next non ha restituito valori con la seguente interrogazione :\n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id));
        }
        fruitore = new Fruitore();
        fruitore.setId(id);
        fruitore.setTipo(rs.getString("soggetti.tipo_soggetto"));
        fruitore.setNome(rs.getString("soggetti.nome_soggetto"));
        long idConnettore = rs.getLong("soggettiid_connettore");
        fruitore.setConnettore(this.getConnettore(idConnettore, con));
        Fruitore fruitore2 = fruitore;
        Object var12_13 = null;
        try {
            if (rs != null) {
                rs.close();
            }
            if (stm != null) {
                stm.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessione al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        {
            return fruitore2;
            catch (SQLException se) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoErogatoreFruitore] SQLException :" + se.getMessage(), se);
            }
            catch (DriverRegistroServiziNotFound e) {
                throw e;
            }
            catch (Exception se) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoErogatoreFruitore] Exception :" + se.getMessage(), se);
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public Fruitore getErogatoreFruitore(long id) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        this.log.debug((Object)("richiesto getErogatoreFruitore: " + id));
        if (id <= 0L) {
            return null;
        }
        Fruitore fruitore = null;
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("servizi_fruitori");
        sqlQueryObject.addFromTable("soggetti");
        sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
        sqlQueryObject.addSelectField("soggetti.nome_soggetto");
        sqlQueryObject.addSelectField("soggetti.id_connettore");
        sqlQueryObject.addSelectField("servizi_fruitori.stato");
        sqlQueryObject.addSelectField("servizi_fruitori.client_auth");
        sqlQueryObject.addSelectField("servizi_fruitori.profilo");
        sqlQueryObject.addWhereCondition("servizi_fruitori.id = ?");
        sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
        sqlQueryObject.setANDLogicOperator(true);
        String sqlQuery = sqlQueryObject.createSQLQuery();
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
        stm = con.prepareStatement(sqlQuery);
        stm.setLong(1, id);
        this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id)));
        rs = stm.executeQuery();
        if (!rs.next()) {
            throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getErogatoreFruitore] rs.next non ha restituito valori con la seguente interrogazione :\n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id));
        }
        fruitore = new Fruitore();
        fruitore.setId(id);
        fruitore.setTipo(rs.getString("tipo_soggetto"));
        fruitore.setNome(rs.getString("nome_soggetto"));
        fruitore.setStatoPackage(rs.getString("stato"));
        fruitore.setProfilo(rs.getString("profilo"));
        fruitore.setClientAuth(rs.getString("client_auth"));
        long idConnettore = rs.getLong("id_connettore");
        fruitore.setConnettore(this.getConnettore(idConnettore, con));
        Fruitore fruitore2 = fruitore;
        Object var12_13 = null;
        try {
            if (rs != null) {
                rs.close();
            }
            if (stm != null) {
                stm.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessione al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        {
            return fruitore2;
            catch (SQLException se) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getErogatoreFruitore] SQLException :" + se.getMessage(), se);
            }
            catch (DriverRegistroServiziNotFound e) {
                throw e;
            }
            catch (Exception se) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getErogatoreFruitore] Exception :" + se.getMessage(), se);
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public AccordoServizio[] getAllIdAccordiWithSoggettoReferente(IDSoggetto idsoggetto) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug((Object)"getAllIdAccordiWithSoggettoReferente...");
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("accordi");
        sqlQueryObject.addFromTable("soggetti");
        sqlQueryObject.addSelectAliasField("accordi", "id", "idAccordo");
        sqlQueryObject.addWhereCondition("accordi.id_referente=soggetti.id");
        sqlQueryObject.addWhereCondition("soggetti.tipo_soggetto=?");
        sqlQueryObject.addWhereCondition("soggetti.nome_soggetto=?");
        sqlQueryObject.setANDLogicOperator(true);
        String sqlQuery = sqlQueryObject.createSQLQuery();
        this.log.debug((Object)("eseguo query : " + sqlQuery));
        stm = con.prepareStatement(sqlQuery);
        stm.setString(1, idsoggetto.getTipo());
        stm.setString(2, idsoggetto.getNome());
        rs = stm.executeQuery();
        Vector<AccordoServizio> accordi = new Vector<AccordoServizio>();
        while (rs.next()) {
            accordi.add(this.getAccordoServizio(rs.getLong("idAccordo")));
        }
        if (accordi.size() == 0) {
            throw new DriverRegistroServiziNotFound("Accordi non trovati con soggetto referente [" + idsoggetto + "]");
        }
        AccordoServizio[] res = new AccordoServizio[1];
        AccordoServizio[] accordoServizioArray = accordi.toArray(res);
        Object var11_12 = null;
        try {
            if (rs != null) {
                rs.close();
            }
            if (stm != null) {
                stm.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessione al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        {
            return accordoServizioArray;
            catch (DriverRegistroServiziNotFound de) {
                throw de;
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("getAllIdAccordiWithSoggettoReferente error", e);
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public List<Fruitore> accordiErogatoriFruitoriList(long idServizio, ISearch ricerca) throws DriverRegistroServiziException {
        String queryString;
        ISQLQueryObject sqlQueryObject;
        String nomeMetodo = "accordiErogatoriFruitoriList";
        int idLista = 20;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<Fruitore> lista = new ArrayList<Fruitore>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        if (!search.equals("")) {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
            sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("soggetti.nome_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("soggetti.tipo_soggetto", search, true, true));
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
        } else {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
        }
        stmt = con.prepareStatement(queryString);
        stmt.setLong(1, idServizio);
        risultato = stmt.executeQuery();
        if (risultato.next()) {
            ricerca.setNumEntries(idLista, risultato.getInt(1));
        }
        risultato.close();
        stmt.close();
        if (limit == 0) {
            limit = 1000;
        }
        if (!search.equals("")) {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectAliasField("servizi_fruitori", "id", "idFruitore");
            sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
            sqlQueryObject.addSelectField("soggetti.nome_soggetto");
            sqlQueryObject.addSelectField("servizi_fruitori.id_servizio");
            sqlQueryObject.addSelectField("servizi_fruitori.id_soggetto");
            sqlQueryObject.addSelectField("servizi_fruitori.stato");
            sqlQueryObject.addSelectField("soggetti.id");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
            sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("soggetti.nome_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("soggetti.tipo_soggetto", search, true, true));
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("soggetti.tipo_soggetto");
            sqlQueryObject.addOrderBy("soggetti.nome_soggetto");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
        } else {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectAliasField("servizi_fruitori", "id", "idFruitore");
            sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
            sqlQueryObject.addSelectField("soggetti.nome_soggetto");
            sqlQueryObject.addSelectField("servizi_fruitori.id_servizio");
            sqlQueryObject.addSelectField("servizi_fruitori.id_soggetto");
            sqlQueryObject.addSelectField("servizi_fruitori.stato");
            sqlQueryObject.addSelectField("soggetti.id");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("soggetti.tipo_soggetto");
            sqlQueryObject.addOrderBy("soggetti.nome_soggetto");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
        }
        stmt = con.prepareStatement(queryString);
        stmt.setLong(1, idServizio);
        risultato = stmt.executeQuery();
        Fruitore f = null;
        while (risultato.next()) {
            f = new Fruitore();
            f.setId(risultato.getLong("idFruitore"));
            f.setNome(risultato.getString("nome_soggetto"));
            f.setTipo(risultato.getString("tipo_soggetto"));
            f.setStatoPackage(risultato.getString("stato"));
            lista.add(f);
        }
        ArrayList<Fruitore> arrayList = lista;
        Object var17_17 = null;
        try {
            if (risultato != null) {
                risultato.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessioni al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return arrayList;
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                Object var17_18 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public List<Fruitore> serviziFruitoriList(long idServizio, ISearch ricerca) throws DriverRegistroServiziException {
        String queryString;
        ISQLQueryObject sqlQueryObject;
        String nomeMetodo = "serviziFruitoriList";
        int idLista = 18;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<Fruitore> lista = new ArrayList<Fruitore>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        if (!search.equals("")) {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
            sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("soggetti.nome_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("soggetti.tipo_soggetto", search, true, true));
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
        } else {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
        }
        stmt = con.prepareStatement(queryString);
        stmt.setLong(1, idServizio);
        risultato = stmt.executeQuery();
        if (risultato.next()) {
            ricerca.setNumEntries(idLista, risultato.getInt(1));
        }
        risultato.close();
        stmt.close();
        if (limit == 0) {
            limit = 1000;
        }
        if (!search.equals("")) {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("servizi_fruitori.id");
            sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
            sqlQueryObject.addSelectField("soggetti.nome_soggetto");
            sqlQueryObject.addSelectField("servizi_fruitori.id_servizio");
            sqlQueryObject.addSelectField("servizi_fruitori.id_soggetto");
            sqlQueryObject.addSelectField("soggetti.id");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
            sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("soggetti.nome_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("soggetti.tipo_soggetto", search, true, true));
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("soggetti.tipo_soggetto");
            sqlQueryObject.addOrderBy("soggetti.nome_soggetto");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
        } else {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("servizi_fruitori.id");
            sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
            sqlQueryObject.addSelectField("soggetti.nome_soggetto");
            sqlQueryObject.addSelectField("servizi_fruitori.id_servizio");
            sqlQueryObject.addSelectField("servizi_fruitori.id_soggetto");
            sqlQueryObject.addSelectField("soggetti.id");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("soggetti.tipo_soggetto");
            sqlQueryObject.addOrderBy("soggetti.nome_soggetto");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
        }
        stmt = con.prepareStatement(queryString);
        stmt.setLong(1, idServizio);
        risultato = stmt.executeQuery();
        Fruitore f = null;
        while (risultato.next()) {
            f = new Fruitore();
            f.setId(risultato.getLong("id"));
            f.setNome(risultato.getString("nome_soggetto"));
            f.setTipo(risultato.getString("tipo_soggetto"));
            f.setIdSoggetto(risultato.getLong("id_soggetto"));
            f.setIdServizio(risultato.getLong("id_servizio"));
            lista.add(f);
        }
        ArrayList<Fruitore> arrayList = lista;
        Object var17_17 = null;
        try {
            if (risultato != null) {
                risultato.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessioni al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return arrayList;
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage());
            }
            catch (Throwable throwable) {
                Object var17_18 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public Fruitore getServizioFruitore(int idServFru) throws DriverRegistroServiziException {
        String nomeMetodo = "getServizioFruitore";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("servizi_fruitori");
        sqlQueryObject.addFromTable("soggetti");
        sqlQueryObject.addSelectField("servizi_fruitori.id");
        sqlQueryObject.addSelectField("servizi_fruitori.id_soggetto");
        sqlQueryObject.addSelectField("servizi_fruitori.id_servizio");
        sqlQueryObject.addSelectField("servizi_fruitori.id_connettore");
        sqlQueryObject.addSelectField("servizi_fruitori.wsdl_implementativo_erogatore");
        sqlQueryObject.addSelectField("servizi_fruitori.wsdl_implementativo_fruitore");
        sqlQueryObject.addSelectField("servizi_fruitori.profilo");
        sqlQueryObject.addSelectField("servizi_fruitori.client_auth");
        sqlQueryObject.addSelectField("servizi_fruitori.stato");
        sqlQueryObject.addSelectField("soggetti.nome_soggetto");
        sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
        sqlQueryObject.addWhereCondition("servizi_fruitori.id = ?");
        sqlQueryObject.addWhereCondition("soggetti.id = servizi_fruitori.id_soggetto");
        sqlQueryObject.setANDLogicOperator(true);
        String queryString = sqlQueryObject.createSQLQuery();
        stmt = con.prepareStatement(queryString);
        stmt.setLong(1, idServFru);
        risultato = stmt.executeQuery();
        Fruitore f = null;
        if (risultato.next()) {
            f = new Fruitore();
            f.setId(risultato.getLong("id"));
            f.setIdSoggetto(risultato.getLong("id_soggetto"));
            f.setIdServizio(risultato.getLong("id_servizio"));
            f.setNome(risultato.getString("nome_soggetto"));
            f.setTipo(risultato.getString("tipo_soggetto"));
            long idConnettore = risultato.getLong("id_connettore");
            f.setConnettore(this.getConnettore(idConnettore, con));
            f.setByteWsdlImplementativoErogatore(risultato.getString("wsdl_implementativo_erogatore") != null && !risultato.getString("wsdl_implementativo_erogatore").trim().equals("") ? risultato.getString("wsdl_implementativo_erogatore").trim().getBytes() : null);
            f.setByteWsdlImplementativoFruitore(risultato.getString("wsdl_implementativo_fruitore") != null && !risultato.getString("wsdl_implementativo_fruitore").trim().equals("") ? risultato.getString("wsdl_implementativo_fruitore").trim().getBytes() : null);
            f.setProfilo(risultato.getString("profilo"));
            f.setClientAuth(risultato.getString("client_auth"));
            f.setStatoPackage(risultato.getString("stato"));
        }
        Fruitore fruitore = f;
        Object var12_13 = null;
        try {
            if (risultato != null) {
                risultato.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessioni al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return fruitore;
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage());
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean isAccordoInUso(AccordoServizio as, Map<ErrorsHandlerCostant, String> whereIsInUso) throws DriverRegistroServiziException {
        String nomeMetodo = "isAccordoInUso";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        boolean isInUso = false;
        Vector<String> nomiServizi = new Vector<String>();
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("servizi");
        sqlQueryObject.addFromTable("soggetti");
        sqlQueryObject.addSelectField("*");
        sqlQueryObject.addWhereCondition("id_accordo = ?");
        sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
        sqlQueryObject.setANDLogicOperator(true);
        String queryString = sqlQueryObject.createSQLQuery();
        stmt = con.prepareStatement(queryString);
        stmt.setLong(1, as.getId());
        risultato = stmt.executeQuery();
        while (risultato.next()) {
            isInUso = true;
            String nomeServizio = risultato.getString("tipo_soggetto") + "/" + risultato.getString("nome_soggetto") + " - " + risultato.getString("tipo_servizio") + "/" + risultato.getString("nome_servizio");
            nomiServizi.add(nomeServizio);
        }
        risultato.close();
        stmt.close();
        if (nomiServizi.size() > 0) {
            whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_SERVIZI, nomiServizi.toString());
        }
        boolean bl = isInUso;
        Object var13_15 = null;
        try {
            if (risultato != null) {
                risultato.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessioni al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return bl;
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public boolean isInUso(AccordoServizio as, Map<ErrorsHandlerCostant, ArrayList<?>> whereIsInUso) throws DriverRegistroServiziException {
        String nomeMetodo = "isAccordoInUso";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        boolean isInUso = false;
        ArrayList<IDServizio> idServizi = new ArrayList<IDServizio>();
        ArrayList<IDPortaDelegata> idPorteDelegate = new ArrayList<IDPortaDelegata>();
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("servizi");
        sqlQueryObject.addSelectField("*");
        sqlQueryObject.addWhereCondition("id_accordo = ?");
        String queryString = sqlQueryObject.createSQLQuery();
        stmt = con.prepareStatement(queryString);
        stmt.setLong(1, as.getId());
        risultato = stmt.executeQuery();
        String uri = IDAccordo.getUriFromAccordo(as);
        while (risultato.next()) {
            isInUso = true;
            ServizioSpcoop ss = this.getServizioSpcoop(risultato.getLong("id"));
            IDServizio idSE = new IDServizio();
            idSE.setServizio(ss.getNome());
            idSE.setTipoServizio(ss.getTipo());
            idSE.setSoggettoErogatore(ss.getTipoSoggettoErogatore(), ss.getNomeSoggettoErogatore());
            idSE.setCorrelato(ss.getServizioCorrelato());
            idSE.setUriAccordo(uri);
            idServizi.add(idSE);
        }
        risultato.close();
        stmt.close();
        if (idServizi.size() > 0) {
            whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_SERVIZI, idServizi);
        }
        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("porte_delegate");
        sqlQueryObject.addSelectField("*");
        sqlQueryObject.addWhereCondition("id_accordo = ?");
        queryString = sqlQueryObject.createSQLQuery();
        stmt = con.prepareStatement(queryString);
        stmt.setLong(1, as.getId());
        risultato = stmt.executeQuery();
        uri = IDAccordo.getUriFromAccordo(as);
        while (risultato.next()) {
            isInUso = true;
            IDPortaDelegata idPD = new IDPortaDelegata();
            idPD.setLocationPD(risultato.getString("nome_porta"));
            SoggettoSpcoop fruitore = this.getSoggettoRegistro(risultato.getLong("id_soggetto"));
            IDSoggetto idSO = new IDSoggetto(fruitore.getTipo(), fruitore.getNome());
            idPD.setSoggettoFruitore(idSO);
            idPorteDelegate.add(idPD);
        }
        risultato.close();
        stmt.close();
        if (idPorteDelegate.size() > 0) {
            whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_PORTE_DELEGATE, idPorteDelegate);
        }
        boolean bl = isInUso;
        Object var17_19 = null;
        try {
            if (risultato != null) {
                risultato.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessioni al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return bl;
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                Object var17_20 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public boolean isServizioInUso(ServizioSpcoop ss, Map<ErrorsHandlerCostant, String> whereIsInUso) throws DriverRegistroServiziException {
        String nomeMetodo = "isServizioInUso";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        boolean isInUso = false;
        Vector<String> nomiAccordi = new Vector<String>();
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("acc_serv_componenti");
        sqlQueryObject.addFromTable("acc_serv_composti");
        sqlQueryObject.addSelectField("acc_serv_composti", "id_accordo");
        sqlQueryObject.addWhereCondition("acc_serv_componenti.id_servizio_componente = ?");
        sqlQueryObject.addWhereCondition("acc_serv_componenti.id_servizio_composto = acc_serv_composti.id");
        sqlQueryObject.setANDLogicOperator(true);
        String queryString = sqlQueryObject.createSQLQuery();
        stmt = con.prepareStatement(queryString);
        stmt.setLong(1, ss.getId());
        risultato = stmt.executeQuery();
        while (risultato.next()) {
            isInUso = true;
            AccordoServizio as = this.getAccordoServizio(risultato.getLong("id_accordo"), con);
            nomiAccordi.add(IDAccordo.getUriFromAccordo(as));
        }
        risultato.close();
        stmt.close();
        if (nomiAccordi.size() > 0) {
            whereIsInUso.put(ErrorsHandlerCostant.IS_SERVIZIO_COMPONENTE_IN_ACCORDI, nomiAccordi.toString());
        }
        boolean bl = isInUso;
        Object var13_15 = null;
        try {
            if (risultato != null) {
                risultato.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessioni al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return bl;
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public boolean isAccordoCooperazioneInUso(AccordoCooperazione ac, Map<ErrorsHandlerCostant, String> whereIsInUso) throws DriverRegistroServiziException {
        String nomeMetodo = "isAccordoCooperazioneInUso";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        boolean isInUso = false;
        Vector<String> nomiAccordi = new Vector<String>();
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("acc_serv_composti");
        sqlQueryObject.addFromTable("accordi");
        sqlQueryObject.addSelectField("*");
        sqlQueryObject.addWhereCondition("acc_serv_composti.id_accordo_cooperazione = ?");
        sqlQueryObject.addWhereCondition("acc_serv_composti.id_accordo = accordi.id");
        sqlQueryObject.setANDLogicOperator(true);
        String queryString = sqlQueryObject.createSQLQuery();
        stmt = con.prepareStatement(queryString);
        stmt.setLong(1, ac.getId());
        risultato = stmt.executeQuery();
        while (risultato.next()) {
            isInUso = true;
            AccordoServizio as = this.getAccordoServizio(risultato.getLong("id_accordo"));
            nomiAccordi.add(IDAccordo.getUriFromAccordo(as));
        }
        risultato.close();
        stmt.close();
        if (nomiAccordi.size() > 0) {
            whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_ACCORDI, nomiAccordi.toString());
        }
        boolean bl = isInUso;
        Object var13_15 = null;
        try {
            if (risultato != null) {
                risultato.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessioni al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return bl;
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    public boolean isSoggettoInUsoInPackageFinali(SoggettoSpcoop ss, Map<ErrorsHandlerCostant, String> whereIsInUso) throws DriverRegistroServiziException {
        return this.isSoggettoInUso(ss, whereIsInUso, true, false);
    }

    public boolean isSoggettoInUsoInPackagePubblici(SoggettoSpcoop ss, Map<ErrorsHandlerCostant, String> whereIsInUso) throws DriverRegistroServiziException {
        return this.isSoggettoInUso(ss, whereIsInUso, false, true);
    }

    public boolean isSoggettoInUso(SoggettoSpcoop ss, Map<ErrorsHandlerCostant, String> whereIsInUso) throws DriverRegistroServiziException {
        return this.isSoggettoInUso(ss, whereIsInUso, false, false);
    }

    /*
     * Loose catch block
     */
    private boolean isSoggettoInUso(SoggettoSpcoop ss, Map<ErrorsHandlerCostant, String> whereIsInUso, boolean checkOnlyStatiFinali, boolean checkOnlyStatiPubblici) throws DriverRegistroServiziException {
        Cloneable accordo;
        String nomeMetodo = "isSoggettoInUso";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        boolean isInUso = false;
        Vector<String> nomiServizi = new Vector<String>();
        Vector<String> serviziFruitori = new Vector<String>();
        Vector<String> accordi = new Vector<String>();
        Vector<String> accordi_cooperazione = new Vector<String>();
        Vector<String> partecipanti = new Vector<String>();
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("servizi");
        sqlQueryObject.addSelectField("*");
        sqlQueryObject.addWhereCondition("id_soggetto = ?");
        if (checkOnlyStatiFinali) {
            sqlQueryObject.addWhereCondition("stato = ?");
        }
        if (checkOnlyStatiPubblici) {
            sqlQueryObject.addWhereCondition("privato = ?");
        }
        sqlQueryObject.setANDLogicOperator(true);
        String queryString = sqlQueryObject.createSQLQuery();
        stmt = con.prepareStatement(queryString);
        stmt.setLong(1, ss.getId());
        int index = 2;
        if (checkOnlyStatiFinali) {
            stmt.setString(index, StatiAccordo.finale.toString());
            ++index;
        }
        if (checkOnlyStatiPubblici) {
            stmt.setInt(index, 0);
            ++index;
        }
        risultato = stmt.executeQuery();
        while (risultato.next()) {
            isInUso = true;
            String nomeServizio = risultato.getString("tipo_servizio") + "/" + risultato.getString("nome_servizio");
            nomiServizi.add(nomeServizio);
        }
        risultato.close();
        stmt.close();
        if (nomiServizi.size() > 0) {
            whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_SERVIZI, nomiServizi.toString());
        }
        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("servizi_fruitori");
        sqlQueryObject.addSelectField("*");
        sqlQueryObject.addWhereCondition("id_soggetto = ?");
        if (checkOnlyStatiFinali) {
            sqlQueryObject.addWhereCondition("stato = ?");
        }
        sqlQueryObject.setANDLogicOperator(true);
        queryString = sqlQueryObject.createSQLQuery();
        stmt = con.prepareStatement(queryString);
        stmt.setLong(1, ss.getId());
        if (checkOnlyStatiFinali) {
            stmt.setString(2, StatiAccordo.finale.toString());
        }
        risultato = stmt.executeQuery();
        while (risultato.next()) {
            isInUso = true;
            ServizioSpcoop servizio = this.getServizioSpcoop(risultato.getLong("id_servizio"));
            if (checkOnlyStatiPubblici) {
                if (servizio.getPrivato().booleanValue()) continue;
                serviziFruitori.add(servizio.getTipo() + "/" + servizio.getNome());
                continue;
            }
            serviziFruitori.add(servizio.getTipo() + "/" + servizio.getNome());
        }
        risultato.close();
        stmt.close();
        if (serviziFruitori.size() > 0) {
            whereIsInUso.put(ErrorsHandlerCostant.POSSIEDE_FRUITORI, serviziFruitori.toString());
        }
        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("accordi");
        sqlQueryObject.addSelectField("*");
        sqlQueryObject.addWhereCondition("id_referente = ?");
        if (checkOnlyStatiFinali) {
            sqlQueryObject.addWhereCondition("stato = ?");
        }
        if (checkOnlyStatiPubblici) {
            sqlQueryObject.addWhereCondition("privato = ?");
        }
        sqlQueryObject.setANDLogicOperator(true);
        queryString = sqlQueryObject.createSQLQuery();
        stmt = con.prepareStatement(queryString);
        stmt.setLong(1, ss.getId());
        index = 2;
        if (checkOnlyStatiFinali) {
            stmt.setString(index, StatiAccordo.finale.toString());
            ++index;
        }
        if (checkOnlyStatiPubblici) {
            stmt.setInt(index, 0);
            ++index;
        }
        risultato = stmt.executeQuery();
        while (risultato.next()) {
            isInUso = true;
            accordo = this.getAccordoServizio(risultato.getLong("id"));
            accordi.add(IDAccordo.getUriFromAccordo((AccordoServizio)accordo));
        }
        risultato.close();
        stmt.close();
        if (accordi.size() > 0) {
            whereIsInUso.put(ErrorsHandlerCostant.IS_REFERENTE, accordi.toString());
        }
        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("accordi_cooperazione");
        sqlQueryObject.addSelectField("*");
        sqlQueryObject.addWhereCondition("id_referente = ?");
        if (checkOnlyStatiFinali) {
            sqlQueryObject.addWhereCondition("stato = ?");
        }
        if (checkOnlyStatiPubblici) {
            sqlQueryObject.addWhereCondition("privato = ?");
        }
        sqlQueryObject.setANDLogicOperator(true);
        queryString = sqlQueryObject.createSQLQuery();
        stmt = con.prepareStatement(queryString);
        stmt.setLong(1, ss.getId());
        index = 2;
        if (checkOnlyStatiFinali) {
            stmt.setString(index, StatiAccordo.finale.toString());
            ++index;
        }
        if (checkOnlyStatiPubblici) {
            stmt.setInt(index, 0);
            ++index;
        }
        risultato = stmt.executeQuery();
        while (risultato.next()) {
            isInUso = true;
            accordo = this.getAccordoCooperazione(risultato.getLong("id"));
            accordi_cooperazione.add(IDAccordoCooperazione.getUriFromAccordo((AccordoCooperazione)accordo));
        }
        risultato.close();
        stmt.close();
        if (accordi_cooperazione.size() > 0) {
            whereIsInUso.put(ErrorsHandlerCostant.IS_REFERENTE_COOPERAZIONE, accordi_cooperazione.toString());
        }
        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("accordi_coop_partecipanti");
        sqlQueryObject.addSelectField("*");
        sqlQueryObject.addWhereCondition("id_soggetto = ?");
        sqlQueryObject.setANDLogicOperator(true);
        queryString = sqlQueryObject.createSQLQuery();
        stmt = con.prepareStatement(queryString);
        stmt.setLong(1, ss.getId());
        risultato = stmt.executeQuery();
        while (risultato.next()) {
            accordo = this.getAccordoCooperazione(risultato.getLong("id_accordo_cooperazione"));
            if (checkOnlyStatiFinali) {
                if (!StatiAccordo.finale.toString().equals(((AccordoCooperazione)accordo).getStatoPackage())) continue;
                isInUso = true;
                partecipanti.add(IDAccordoCooperazione.getUriFromAccordo((AccordoCooperazione)accordo));
                continue;
            }
            if (checkOnlyStatiPubblici) {
                if (((AccordoCooperazione)accordo).getPrivato().booleanValue()) continue;
                isInUso = true;
                partecipanti.add(IDAccordoCooperazione.getUriFromAccordo((AccordoCooperazione)accordo));
                continue;
            }
            isInUso = true;
            partecipanti.add(IDAccordoCooperazione.getUriFromAccordo((AccordoCooperazione)accordo));
        }
        risultato.close();
        stmt.close();
        if (partecipanti.size() > 0) {
            whereIsInUso.put(ErrorsHandlerCostant.IS_PARTECIPANTE_COOPERAZIONE, partecipanti.toString());
        }
        boolean bl = isInUso;
        Object var20_22 = null;
        try {
            if (risultato != null) {
                risultato.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessioni al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return bl;
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                Object var20_23 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public boolean isInUso(SoggettoSpcoop ss, Map<ErrorsHandlerCostant, ArrayList<?>> whereIsInUso, boolean checkOnlyStatiFinali, boolean checkOnlyStatiPubblici) throws DriverRegistroServiziException {
        IDServizio idSE;
        ServizioSpcoop servizio;
        String nomeMetodo = "isSoggettoInUso";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        boolean isInUso = false;
        ArrayList<IDServizio> idServizi = new ArrayList<IDServizio>();
        ArrayList<IDServizio> idServiziFruitori = new ArrayList<IDServizio>();
        ArrayList<IDAccordo> idAccordi = new ArrayList<IDAccordo>();
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("servizi");
        sqlQueryObject.addSelectField("*");
        sqlQueryObject.addWhereCondition("id_soggetto = ?");
        if (checkOnlyStatiFinali) {
            sqlQueryObject.addWhereCondition("stato = ?");
        }
        if (checkOnlyStatiPubblici) {
            sqlQueryObject.addWhereCondition("privato = ?");
        }
        sqlQueryObject.setANDLogicOperator(true);
        String queryString = sqlQueryObject.createSQLQuery();
        stmt = con.prepareStatement(queryString);
        stmt.setLong(1, ss.getId());
        int index = 2;
        if (checkOnlyStatiFinali) {
            stmt.setString(index, StatiAccordo.finale.toString());
            ++index;
        }
        if (checkOnlyStatiPubblici) {
            stmt.setInt(index, 0);
            ++index;
        }
        risultato = stmt.executeQuery();
        while (risultato.next()) {
            isInUso = true;
            servizio = this.getServizioSpcoop(risultato.getLong("id"));
            idSE = new IDServizio();
            idSE.setServizio(servizio.getNome());
            idSE.setTipoServizio(servizio.getTipo());
            idSE.setSoggettoErogatore(servizio.getTipoSoggettoErogatore(), servizio.getNomeSoggettoErogatore());
            idSE.setCorrelato(servizio.getServizioCorrelato());
            idSE.setUriAccordo(servizio.getAccordoServizio());
            idServizi.add(idSE);
        }
        risultato.close();
        stmt.close();
        if (idServizi.size() > 0) {
            whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_SERVIZI, idServizi);
        }
        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("servizi_fruitori");
        sqlQueryObject.addSelectField("*");
        sqlQueryObject.addWhereCondition("id_soggetto = ?");
        if (checkOnlyStatiFinali) {
            sqlQueryObject.addWhereCondition("stato = ?");
        }
        sqlQueryObject.setANDLogicOperator(true);
        queryString = sqlQueryObject.createSQLQuery();
        stmt = con.prepareStatement(queryString);
        stmt.setLong(1, ss.getId());
        if (checkOnlyStatiFinali) {
            stmt.setString(2, StatiAccordo.finale.toString());
        }
        risultato = stmt.executeQuery();
        while (risultato.next()) {
            isInUso = true;
            servizio = this.getServizioSpcoop(risultato.getLong("id_servizio"));
            if (checkOnlyStatiPubblici) {
                if (servizio.getPrivato().booleanValue()) continue;
                idSE = new IDServizio();
                idSE.setServizio(servizio.getNome());
                idSE.setTipoServizio(servizio.getTipo());
                idSE.setSoggettoErogatore(servizio.getTipoSoggettoErogatore(), servizio.getNomeSoggettoErogatore());
                idSE.setCorrelato(servizio.getServizioCorrelato());
                idSE.setUriAccordo(servizio.getAccordoServizio());
                idServiziFruitori.add(idSE);
                continue;
            }
            idSE = new IDServizio();
            idSE.setServizio(servizio.getNome());
            idSE.setTipoServizio(servizio.getTipo());
            idSE.setSoggettoErogatore(servizio.getTipoSoggettoErogatore(), servizio.getNomeSoggettoErogatore());
            idSE.setCorrelato(servizio.getServizioCorrelato());
            idSE.setUriAccordo(servizio.getAccordoServizio());
            idServiziFruitori.add(idSE);
        }
        risultato.close();
        stmt.close();
        if (idServiziFruitori.size() > 0) {
            whereIsInUso.put(ErrorsHandlerCostant.POSSIEDE_FRUITORI, idServiziFruitori);
        }
        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("accordi");
        sqlQueryObject.addSelectField("*");
        sqlQueryObject.addWhereCondition("id_referente = ?");
        if (checkOnlyStatiFinali) {
            sqlQueryObject.addWhereCondition("stato = ?");
        }
        if (checkOnlyStatiPubblici) {
            sqlQueryObject.addWhereCondition("privato = ?");
        }
        sqlQueryObject.setANDLogicOperator(true);
        queryString = sqlQueryObject.createSQLQuery();
        stmt = con.prepareStatement(queryString);
        stmt.setLong(1, ss.getId());
        index = 2;
        if (checkOnlyStatiFinali) {
            stmt.setString(index, StatiAccordo.finale.toString());
            ++index;
        }
        if (checkOnlyStatiPubblici) {
            stmt.setInt(index, 0);
            ++index;
        }
        risultato = stmt.executeQuery();
        while (risultato.next()) {
            isInUso = true;
            AccordoServizio accordo = this.getAccordoServizio(risultato.getLong("id"));
            idAccordi.add(IDAccordo.getIDAccordoFromAccordo(accordo));
        }
        risultato.close();
        stmt.close();
        if (idAccordi.size() > 0) {
            whereIsInUso.put(ErrorsHandlerCostant.IS_REFERENTE, idAccordi);
        }
        boolean bl = isInUso;
        Object var19_21 = null;
        try {
            if (risultato != null) {
                risultato.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessioni al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return bl;
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                Object var19_22 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean isAzioneInUso(String nomeAzione) throws DriverRegistroServiziException {
        ResultSet risultato;
        Statement stmt;
        Connection con;
        String nomeMetodo;
        block35: {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            block32: {
                nomeMetodo = "isAzioneInUso";
                con = null;
                stmt = null;
                risultato = null;
                if (this.atomica) {
                    try {
                        con = this.datasource.getConnection();
                    }
                    catch (SQLException e) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
                    }
                } else {
                    con = this.globalConnection;
                }
                this.log.debug((Object)("operazione this.atomica = " + this.atomica));
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("porte_applicative");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("azione = ?");
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                stmt.setString(1, nomeAzione);
                risultato = stmt.executeQuery();
                if (!risultato.next()) break block32;
                boolean bl = true;
                Object var10_13 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                return bl;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome_azione = ?");
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, nomeAzione);
            risultato = stmt.executeQuery();
            if (!risultato.next()) break block35;
            boolean bl = true;
            Object var10_14 = null;
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return bl;
        }
        boolean bl = false;
        Object var10_15 = null;
        try {
            if (risultato != null) {
                risultato.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessioni al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return bl;
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                Object var10_16 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public void deleteAzione(int idAccordo, String nomeAzione) throws DriverRegistroServiziException {
        block21: {
            String nomeMetodo = "deleteAzione";
            Connection con = null;
            Statement stmt = null;
            ResultSet risultato = null;
            if (this.atomica) {
                try {
                    con = this.datasource.getConnection();
                }
                catch (SQLException e) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.globalConnection;
            }
            this.log.debug((Object)("operazione this.atomica = " + this.atomica));
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("accordi_azioni");
            sqlQueryObject.addWhereCondition("id_accordo=?");
            sqlQueryObject.addWhereCondition("nome=?");
            sqlQueryObject.setANDLogicOperator(true);
            String updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.setLong(1, idAccordo);
            stmt.setString(2, nomeAzione);
            stmt.executeUpdate();
            stmt.close();
            Object var10_11 = null;
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
                break block21;
            }
            catch (Exception e) {}
            break block21;
            {
                catch (Exception se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    @Override
    public AccordoServizio getAccordoServizio(long id) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizio(id, null);
    }

    /*
     * Loose catch block
     */
    public AccordoServizio getAccordoServizio(long id, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        IDAccordo idAccordo;
        block24: {
            IDSoggetto referente;
            this.log.debug((Object)("richiesto getAccordoServizio: " + id));
            if (id <= 0L) {
                return null;
            }
            Connection con = null;
            Statement stm = null;
            ResultSet rs = null;
            idAccordo = null;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            con = conParam != null ? conParam : (this.atomica ? this.datasource.getConnection() : this.globalConnection);
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, id);
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id)));
            rs = stm.executeQuery();
            if (rs.next()) {
                referente = null;
                long idReferente = rs.getLong("id_referente");
                if (idReferente > 0L) {
                    SoggettoSpcoop s = this.getSoggettoRegistro(idReferente, con);
                    if (s == null) {
                        throw new Exception("Soggetto referente non presente?");
                    }
                    referente = new IDSoggetto(s.getTipo(), s.getNome());
                }
            } else {
                rs.close();
                stm.close();
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getAccordoServizio] rs.next non ha restituito valori con la seguente interrogazione :\n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id));
            }
            idAccordo = IDAccordo.getIDAccordoFromValues(rs.getString("nome"), referente, rs.getString("versione"));
            rs.close();
            stm.close();
            Object var15_15 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (conParam == null && this.atomica) {
                    this.log.debug((Object)"rilascio connessione al db...");
                    con.close();
                }
                break block24;
            }
            catch (Exception e) {}
            break block24;
            {
                catch (SQLException se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoServizio] SQLException :" + se.getMessage(), se);
                }
                catch (DriverRegistroServiziNotFound e) {
                    throw e;
                }
                catch (Exception se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoServizio] Exception :" + se.getMessage(), se);
                }
            }
            catch (Throwable throwable) {
                Object var15_16 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (conParam == null && this.atomica) {
                        this.log.debug((Object)"rilascio connessione al db...");
                        con.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return this.getAccordoServizio(idAccordo);
    }

    public List<SoggettoSpcoop> soggettiRegistroListByTipo(String tipoSoggetto, ISearch ricerca) throws DriverRegistroServiziException {
        return this.soggettiRegistroList("", tipoSoggetto, ricerca);
    }

    @Override
    public List<SoggettoSpcoop> soggettiRegistroList(String superuser, ISearch ricerca) throws DriverRegistroServiziException {
        return this.soggettiRegistroList(superuser, null, ricerca);
    }

    /*
     * Loose catch block
     */
    private List<SoggettoSpcoop> soggettiRegistroList(String superuser, String tipoSoggetto, ISearch ricerca) throws DriverRegistroServiziException {
        String queryString;
        ISQLQueryObject sqlQueryObject;
        String nomeMetodo = "soggettiRegistroList";
        int idLista = 1;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<SoggettoSpcoop> lista = new ArrayList<SoggettoSpcoop>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        if (!search.equals("")) {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectCountField("*", "cont");
            if (superuser != null && !superuser.equals("")) {
                sqlQueryObject.addWhereCondition("superuser = ?");
            }
            if (tipoSoggetto != null) {
                sqlQueryObject.addWhereCondition("tipo_soggetto=?");
            }
            sqlQueryObject.addWhereLikeCondition("nome_soggetto", search, true, true);
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
        } else {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectCountField("*", "cont");
            if (superuser != null && !superuser.equals("")) {
                sqlQueryObject.addWhereCondition("superuser = ?");
            }
            if (tipoSoggetto != null) {
                sqlQueryObject.addWhereCondition("tipo_soggetto=?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
        }
        stmt = con.prepareStatement(queryString);
        if (superuser != null && !superuser.equals("")) {
            stmt.setString(1, superuser);
            if (tipoSoggetto != null) {
                stmt.setString(2, tipoSoggetto);
            }
        } else if (tipoSoggetto != null) {
            stmt.setString(1, tipoSoggetto);
        }
        if ((risultato = stmt.executeQuery()).next()) {
            ricerca.setNumEntries(idLista, risultato.getInt(1));
        }
        risultato.close();
        stmt.close();
        if (limit == 0) {
            limit = 1000;
        }
        if (!search.equals("")) {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addSelectField("nome_soggetto");
            sqlQueryObject.addSelectField("tipo_soggetto");
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("identificativo_porta");
            sqlQueryObject.addSelectField("server");
            sqlQueryObject.addSelectField("id_connettore");
            sqlQueryObject.addSelectField("codice_ipa");
            if (superuser != null && !superuser.equals("")) {
                sqlQueryObject.addWhereCondition("superuser = ?");
            }
            if (tipoSoggetto != null) {
                sqlQueryObject.addWhereCondition("tipo_soggetto=?");
            }
            sqlQueryObject.addWhereLikeCondition("nome_soggetto", search, true, true);
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("tipo_soggetto");
            sqlQueryObject.addOrderBy("nome_soggetto");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
        } else {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addSelectField("nome_soggetto");
            sqlQueryObject.addSelectField("tipo_soggetto");
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("identificativo_porta");
            sqlQueryObject.addSelectField("server");
            sqlQueryObject.addSelectField("id_connettore");
            sqlQueryObject.addSelectField("codice_ipa");
            if (superuser != null && !superuser.equals("")) {
                sqlQueryObject.addWhereCondition("superuser = ?");
            }
            if (tipoSoggetto != null) {
                sqlQueryObject.addWhereCondition("tipo_soggetto=?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("tipo_soggetto");
            sqlQueryObject.addOrderBy("nome_soggetto");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
        }
        stmt = con.prepareStatement(queryString);
        if (superuser != null && !superuser.equals("")) {
            stmt.setString(1, superuser);
            if (tipoSoggetto != null) {
                stmt.setString(2, tipoSoggetto);
            }
        } else if (tipoSoggetto != null) {
            stmt.setString(1, tipoSoggetto);
        }
        risultato = stmt.executeQuery();
        while (risultato.next()) {
            SoggettoSpcoop sog = new SoggettoSpcoop();
            sog.setId(risultato.getLong("id"));
            sog.setNome(risultato.getString("nome_soggetto"));
            sog.setTipo(risultato.getString("tipo_soggetto"));
            sog.setDescrizione(risultato.getString("descrizione"));
            sog.setIdentificativoPorta(risultato.getString("identificativo_porta"));
            sog.setPortaDominio(risultato.getString("server"));
            sog.setCodiceIpa(risultato.getString("codice_ipa"));
            long idConnettore = risultato.getLong("id_connettore");
            sog.setConnettore(this.getConnettore(idConnettore, con));
            lista.add(sog);
        }
        ArrayList<SoggettoSpcoop> arrayList = lista;
        Object var19_20 = null;
        try {
            if (risultato != null) {
                risultato.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (error && this.atomica) {
                this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                con.rollback();
                con.setAutoCommit(true);
                con.close();
            } else if (!error && this.atomica) {
                this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                con.commit();
                con.setAutoCommit(true);
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return arrayList;
        catch (Exception qe) {
            try {
                error = true;
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                Object var19_21 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (error && this.atomica) {
                        this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                        con.rollback();
                        con.setAutoCommit(true);
                        con.close();
                    } else if (!error && this.atomica) {
                        this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                        con.commit();
                        con.setAutoCommit(true);
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    public SoggettoSpcoop getSoggettoRegistro(long idSoggetto) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getSoggettoRegistro(idSoggetto, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public SoggettoSpcoop getSoggettoRegistro(long idSoggetto, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connettore connettore;
        String tmp;
        if (idSoggetto <= 0L) {
            return null;
        }
        SoggettoSpcoop soggettoSPcoop = null;
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        if (conParam != null) {
            con = conParam;
        } else if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::getSoggetto] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("soggetti");
        sqlQueryObject.addSelectField("*");
        sqlQueryObject.addWhereCondition("id = ?");
        String sqlQuery = sqlQueryObject.createSQLQuery();
        stm = con.prepareStatement(sqlQuery);
        stm.setLong(1, idSoggetto);
        this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idSoggetto)));
        rs = stm.executeQuery();
        if (rs.next()) {
            soggettoSPcoop = new SoggettoSpcoop();
            soggettoSPcoop.setId(rs.getLong("id"));
            soggettoSPcoop.setNome(rs.getString("nome_soggetto"));
            soggettoSPcoop.setTipo(rs.getString("tipo_soggetto"));
            tmp = rs.getString("descrizione");
            soggettoSPcoop.setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
            tmp = rs.getString("identificativo_porta");
            soggettoSPcoop.setIdentificativoPorta(tmp == null || tmp.equals("") ? null : tmp);
            tmp = rs.getString("server");
            soggettoSPcoop.setPortaDominio(tmp == null || tmp.equals("") ? null : tmp);
            tmp = rs.getString("superuser");
            soggettoSPcoop.setSuperUser(tmp == null || tmp.equals("") ? null : tmp);
            if (rs.getInt("privato") == 1) {
                soggettoSPcoop.setPrivato(true);
            } else {
                soggettoSPcoop.setPrivato(false);
            }
            long idConnettore = rs.getLong("id_connettore");
            connettore = this.getConnettore(idConnettore, con);
            String profilo = rs.getString("profilo");
            if (profilo != null) {
                profilo = profilo.trim();
                soggettoSPcoop.setProfilo(profilo);
            }
        } else {
            throw new DriverRegistroServiziNotFound("Nessun risultato trovat eseguendo: " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idSoggetto));
        }
        tmp = rs.getString("codice_ipa");
        soggettoSPcoop.setCodiceIpa(tmp == null || tmp.equals("") ? null : tmp);
        soggettoSPcoop.setConnettore(connettore);
        SoggettoSpcoop soggettoSpcoop = soggettoSPcoop;
        Object var16_17 = null;
        try {
            if (rs != null) {
                rs.close();
            }
            if (stm != null) {
                stm.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (conParam == null && this.atomica) {
                this.log.debug((Object)"rilascio connessioni al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        {
            return soggettoSpcoop;
            catch (SQLException se) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getSoggetto] SqlException: " + se.getMessage(), se);
            }
            catch (DriverRegistroServiziNotFound se) {
                throw se;
            }
            catch (Exception se) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getSoggetto] Exception: " + se.getMessage(), se);
            }
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (conParam == null && this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
            throw throwable;
        }
    }

    public ServizioSpcoop getServizioSpcoop(long idServizio) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getServizioSpcoop(idServizio, null);
    }

    public ServizioSpcoop getServizioSpcoop(long idServizio, boolean readContenutoAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getServizioSpcoop(idServizio, null, readContenutoAllegati);
    }

    public ServizioSpcoop getServizioSpcoop(long idServizio, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getServizioSpcoop(idServizio, conParam, false);
    }

    /*
     * Loose catch block
     */
    public ServizioSpcoop getServizioSpcoop(long idServizio, Connection conParam, boolean readContenutoAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        IDServizio idServizioObject;
        Connection con;
        block30: {
            if (idServizio <= 0L) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getServizio] L'id del servizio deve essere > 0.");
            }
            con = null;
            Statement stm = null;
            ResultSet rs = null;
            if (conParam != null) {
                con = conParam;
            } else if (this.atomica) {
                try {
                    con = this.datasource.getConnection();
                }
                catch (SQLException e) {
                    throw new DriverRegistroServiziException("DriverRegistroServiziDB::getServizio] SQLException accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.globalConnection;
            }
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            idServizioObject = null;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("tipo_servizio");
            sqlQueryObject.addSelectField("nome_servizio");
            sqlQueryObject.addSelectField("tipo_soggetto");
            sqlQueryObject.addSelectField("nome_soggetto");
            sqlQueryObject.addSelectField("servizio_correlato");
            sqlQueryObject.addWhereCondition("servizi.id = ?");
            sqlQueryObject.addWhereCondition("servizi.id_soggetto=soggetti.id");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idServizio);
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idServizio)));
            rs = stm.executeQuery();
            if (rs.next()) {
                idServizioObject = new IDServizio(rs.getString("tipo_soggetto"), rs.getString("nome_soggetto"), rs.getString("tipo_servizio"), rs.getString("nome_servizio"));
                if ("abilitato".equals(rs.getString("servizio_correlato"))) {
                    idServizioObject.setCorrelato(true);
                }
            } else {
                throw new DriverRegistroServiziNotFound("Nessun Servizio trovato con id=" + idServizio);
            }
            rs.close();
            stm.close();
            Object var12_14 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (conParam == null && this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
                break block30;
            }
            catch (Exception e) {}
            break block30;
            {
                catch (SQLException se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getServizio] SqlException: " + se.getMessage(), se);
                }
                catch (DriverRegistroServiziNotFound nf) {
                    throw nf;
                }
                catch (Exception se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getServizio] Exception: " + se.getMessage(), se);
                }
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (conParam == null && this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (idServizioObject.isCorrelato()) {
            return this.getServizioCorrelato(idServizioObject, readContenutoAllegati, con);
        }
        return this.getServizio(idServizioObject, readContenutoAllegati, con);
    }

    /*
     * Loose catch block
     */
    @Override
    public void reset() throws DriverRegistroServiziException {
        block24: {
            Connection con = null;
            boolean error = false;
            Statement stmt = null;
            if (this.atomica) {
                try {
                    con = this.datasource.getConnection();
                    con.setAutoCommit(false);
                }
                catch (SQLException e) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::reset] SQLException accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.globalConnection;
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("servizi_fruitori");
            String updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("servizi_azioni");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("operation_messages");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("port_type_azioni");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("port_type");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("accordi_azioni");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("accordi_coop_partecipanti");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("acc_serv_componenti");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("acc_serv_composti");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("servizi");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("accordi");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("accordi_cooperazione");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("soggetti");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("connettori_custom");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("connettori");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("documenti");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("pdd");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            Object var7_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
                break block24;
            }
            catch (Exception e) {}
            break block24;
            {
                catch (SQLException qe) {
                    error = true;
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::reset] Errore durante il reset : " + qe.getMessage(), qe);
                }
                catch (Exception qe) {
                    error = true;
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::reset] Errore durante il reset : " + qe.getMessage(), qe);
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (error && this.atomica) {
                        this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                        con.rollback();
                        con.setAutoCommit(true);
                        con.close();
                    } else if (!error && this.atomica) {
                        this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                        con.commit();
                        con.setAutoCommit(true);
                        con.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void resetCtrlstat() throws DriverRegistroServiziException {
        block24: {
            Connection con = null;
            boolean error = false;
            Statement stmt = null;
            if (this.atomica) {
                try {
                    con = this.datasource.getConnection();
                    con.setAutoCommit(false);
                }
                catch (SQLException e) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::resetCtrlstat] SQLException accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.globalConnection;
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("ruoli_sa");
            String updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("politiche_sicurezza");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("porte_delegate_sa");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("porte_applicative_sa");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("servizi_applicativi");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("porte_applicative_prop");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("porte_applicative_ws_request");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("porte_applicative_ws_response");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("porte_appl_correlazione");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("porte_applicative");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("porte_delegate_ws_request");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("porte_delegate_ws_response");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("porte_delegate_correlazione");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("porte_delegate");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            Object var7_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
                break block24;
            }
            catch (Exception e) {}
            break block24;
            {
                catch (SQLException qe) {
                    error = true;
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::resetCtrlstat] Errore durante la reset : " + qe.getMessage(), qe);
                }
                catch (Exception qe) {
                    error = true;
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::resetCtrlstat] Errore durante la reset : " + qe.getMessage(), qe);
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (error && this.atomica) {
                        this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                        con.rollback();
                        con.setAutoCommit(true);
                        con.close();
                    } else if (!error && this.atomica) {
                        this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                        con.commit();
                        con.setAutoCommit(true);
                        con.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getIdServizioCorrelato(String nomeServizio, String tipoServizio, String nomeProprietario, String tipoProprietario, Connection con) throws DriverRegistroServiziException {
        long l;
        Statement stm = null;
        ResultSet rs = null;
        long idServizio = 0L;
        try {
            try {
                long idSoggetto = DBUtils.getIdSoggetto(nomeProprietario, tipoProprietario, con, this.tipoDB, this.tabellaSoggetti);
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("tipo_servizio = ?");
                sqlQueryObject.addWhereCondition("nome_servizio = ?");
                sqlQueryObject.addWhereCondition("id_soggetto = ?");
                sqlQueryObject.addWhereCondition("servizio_correlato = ?");
                sqlQueryObject.setANDLogicOperator(true);
                String query = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(query);
                stm.setString(1, tipoServizio);
                stm.setString(2, nomeServizio);
                stm.setLong(3, idSoggetto);
                stm.setString(4, "abilitato");
                rs = stm.executeQuery();
                if (rs.next()) {
                    idServizio = rs.getLong("id");
                }
                l = idServizio;
                Object var17_16 = null;
            }
            catch (DriverException e) {
                throw new DriverRegistroServiziException(e);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException(e);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException(e);
            }
        }
        catch (Throwable throwable) {
            Object var17_17 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm == null) throw throwable;
                stm.close();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return l;
        }
        if (rs != null) {
            rs.close();
        }
        if (stm == null) return l;
        stm.close();
        return l;
    }

    /*
     * Loose catch block
     */
    public List<String> getTipiSPCoop() throws DriverRegistroServiziException {
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException(e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        ArrayList<String> lista = new ArrayList<String>();
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("tipi_spcoop");
        sqlQueryObject.addSelectField("*");
        String sqlQuery = sqlQueryObject.createSQLQuery();
        stmt = con.prepareStatement(sqlQuery);
        risultato = stmt.executeQuery();
        while (risultato.next()) {
            String tipo = risultato.getString("nome");
            lista.add(tipo);
        }
        risultato.close();
        stmt.close();
        ArrayList<String> arrayList = lista;
        Object var9_10 = null;
        try {
            if (risultato != null) {
                risultato.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessioni al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return arrayList;
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException(se);
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public String getTipoSPCoopById(long id) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException(e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("tipi_spcoop");
        sqlQueryObject.addSelectField("*");
        sqlQueryObject.addWhereCondition("id = ?");
        String sqlQuery = sqlQueryObject.createSQLQuery();
        stmt = con.prepareStatement(sqlQuery);
        stmt.setLong(1, id);
        risultato = stmt.executeQuery();
        String tipo = "";
        if (!risultato.next()) {
            throw new DriverRegistroServiziNotFound("Impossibile trovare un tipo Soggetto SPCoop con id=" + id);
        }
        tipo = risultato.getString("nome");
        risultato.close();
        stmt.close();
        String string = tipo;
        Object var11_11 = null;
        try {
            if (risultato != null) {
                risultato.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessioni al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return string;
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziNotFound(se);
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public List<Fruitore> serviziFruitoriList(int idServiziSpcoop, ISearch ricerca) throws DriverRegistroServiziException {
        String queryString;
        ISQLQueryObject sqlQueryObject;
        String nomeMetodo = "serviziFruitoriList";
        int idLista = 18;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<Fruitore> lista = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        if (!search.equals("")) {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
            sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("soggetti.nome_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("soggetti.tipo_soggetto", search, true, true));
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
        } else {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
        }
        stmt = con.prepareStatement(queryString);
        stmt.setInt(1, idServiziSpcoop);
        risultato = stmt.executeQuery();
        if (risultato.next()) {
            ricerca.setNumEntries(idLista, risultato.getInt(1));
        }
        risultato.close();
        stmt.close();
        if (limit == 0) {
            limit = 1000;
        }
        if (!search.equals("")) {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectAliasField("servizi_fruitori", "id", "idFruitore");
            sqlQueryObject.addSelectAliasField("servizi_fruitori", "stato", "statoFruitore");
            sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
            sqlQueryObject.addSelectField("soggetti.nome_soggetto");
            sqlQueryObject.addSelectField("servizi_fruitori.id_servizio");
            sqlQueryObject.addSelectField("servizi_fruitori.id_soggetto");
            sqlQueryObject.addSelectField("soggetti.id");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
            sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("soggetti.nome_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("soggetti.tipo_soggetto", search, true, true));
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("soggetti.tipo_soggetto");
            sqlQueryObject.addOrderBy("soggetti.nome_soggetto");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
        } else {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectAliasField("servizi_fruitori", "id", "idFruitore");
            sqlQueryObject.addSelectAliasField("servizi_fruitori", "stato", "statoFruitore");
            sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
            sqlQueryObject.addSelectField("soggetti.nome_soggetto");
            sqlQueryObject.addSelectField("servizi_fruitori.id_servizio");
            sqlQueryObject.addSelectField("servizi_fruitori.id_soggetto");
            sqlQueryObject.addSelectField("soggetti.id");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("soggetti.tipo_soggetto");
            sqlQueryObject.addOrderBy("soggetti.nome_soggetto");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
        }
        stmt = con.prepareStatement(queryString);
        stmt.setInt(1, idServiziSpcoop);
        risultato = stmt.executeQuery();
        lista = new ArrayList<Fruitore>();
        while (risultato.next()) {
            Fruitore f = new Fruitore();
            f.setId(risultato.getLong("idFruitore"));
            f.setNome(risultato.getString("nome_soggetto"));
            f.setTipo(risultato.getString("tipo_soggetto"));
            f.setIdSoggetto(risultato.getLong("id_soggetto"));
            f.setIdServizio(risultato.getLong("id_servizio"));
            f.setStatoPackage(risultato.getString("statoFruitore"));
            lista.add(f);
        }
        ArrayList<Fruitore> arrayList = lista;
        Object var16_17 = null;
        try {
            if (risultato != null) {
                risultato.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessioni al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return arrayList;
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                Object var16_18 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public List<ServizioSpcoop> serviziSoggettoList(long idSoggetto) throws DriverRegistroServiziException {
        String nomeMetodo = "serviziSoggettoList";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        boolean error = false;
        ArrayList<ServizioSpcoop> lista = new ArrayList<ServizioSpcoop>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("soggetti");
        sqlQueryObject.addFromTable("servizi");
        sqlQueryObject.addSelectField("servizi.id");
        sqlQueryObject.addSelectField("servizi.tipo_servizio");
        sqlQueryObject.addSelectField("servizi.nome_servizio");
        sqlQueryObject.addWhereCondition("servizi.id_soggetto = ?");
        sqlQueryObject.addWhereCondition("soggetti.id = servizi.id_soggetto");
        sqlQueryObject.setANDLogicOperator(true);
        sqlQueryObject.addOrderBy("servizi.tipo_servizio");
        sqlQueryObject.addOrderBy("servizi.nome_servizio");
        sqlQueryObject.setSortType(true);
        String queryString = sqlQueryObject.createSQLQuery();
        stmt = con.prepareStatement(queryString);
        stmt.setLong(1, idSoggetto);
        risultato = stmt.executeQuery();
        while (risultato.next()) {
            ServizioSpcoop serv = new ServizioSpcoop();
            serv.setId(risultato.getLong("id"));
            serv.setNome(risultato.getString("nome_servizio"));
            serv.setTipo(risultato.getString("tipo_servizio"));
            lista.add(serv);
        }
        ArrayList<ServizioSpcoop> arrayList = lista;
        Object var14_14 = null;
        try {
            if (risultato != null) {
                risultato.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (error && this.atomica) {
                this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                con.rollback();
                con.setAutoCommit(true);
                con.close();
            } else if (!error && this.atomica) {
                this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                con.commit();
                con.setAutoCommit(true);
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return arrayList;
        catch (Exception qe) {
            try {
                error = true;
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                Object var14_15 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (error && this.atomica) {
                        this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                        con.rollback();
                        con.setAutoCommit(true);
                        con.close();
                    } else if (!error && this.atomica) {
                        this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                        con.commit();
                        con.setAutoCommit(true);
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public List<ServizioSpcoop> serviziWithIdAccordoList(long idAccordo) throws DriverRegistroServiziException {
        String nomeMetodo = "serviziWithIdAccordoList";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        boolean error = false;
        ArrayList<ServizioSpcoop> lista = new ArrayList<ServizioSpcoop>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("servizi");
        sqlQueryObject.addSelectField("*");
        sqlQueryObject.addWhereCondition("id_accordo = ?");
        String queryString = sqlQueryObject.createSQLQuery();
        stmt = con.prepareStatement(queryString);
        stmt.setLong(1, idAccordo);
        risultato = stmt.executeQuery();
        while (risultato.next()) {
            ServizioSpcoop serv = this.getServizioSpcoop(risultato.getLong("id"));
            lista.add(serv);
        }
        ArrayList<ServizioSpcoop> arrayList = lista;
        Object var13_13 = null;
        try {
            if (risultato != null) {
                risultato.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (error && this.atomica) {
                this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                con.rollback();
                con.setAutoCommit(true);
                con.close();
            } else if (!error && this.atomica) {
                this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                con.commit();
                con.setAutoCommit(true);
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return arrayList;
        catch (Exception qe) {
            try {
                error = true;
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (error && this.atomica) {
                        this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                        con.rollback();
                        con.setAutoCommit(true);
                        con.close();
                    } else if (!error && this.atomica) {
                        this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                        con.commit();
                        con.setAutoCommit(true);
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public int getIdServizioFruitore(int idServizio, int idSoggetto) throws DriverRegistroServiziException {
        int idFru;
        block22: {
            Connection connection;
            idFru = 0;
            Statement stm = null;
            ResultSet rs = null;
            if (this.atomica) {
                try {
                    connection = this.datasource.getConnection();
                    connection.setAutoCommit(false);
                }
                catch (SQLException e) {
                    throw new DriverRegistroServiziException("DriverRegistroServiziDB::getIdServizioFruitore] SQLException accedendo al datasource :" + e.getMessage());
                }
            } else {
                connection = this.globalConnection;
            }
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addSelectField("servizi_fruitori.id");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setInt(1, idServizio);
            stm.setInt(2, idSoggetto);
            rs = stm.executeQuery();
            if (rs.next()) {
                idFru = rs.getInt("id");
            }
            rs.close();
            stm.close();
            Object var10_11 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.atomica) {
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
            break block22;
            {
                catch (Exception e) {
                    throw new DriverRegistroServiziException(e);
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (this.atomica) {
                    try {
                        connection.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return idFru;
    }

    /*
     * Loose catch block
     */
    public List<Fruitore> getServiziFruitoriWithServizio(int idServizio) throws DriverRegistroServiziException {
        String nomeMetodo = "getServiziFruitoriWithServizio";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<Fruitore> lista = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("soggetti");
        sqlQueryObject.addFromTable("servizi_fruitori");
        sqlQueryObject.setSelectDistinct(true);
        sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
        sqlQueryObject.addSelectField("soggetti.nome_soggetto");
        sqlQueryObject.addWhereCondition("soggetti.id = servizi_fruitori.id_soggetto");
        sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
        sqlQueryObject.setANDLogicOperator(true);
        String queryString = sqlQueryObject.createSQLQuery();
        stmt = con.prepareStatement(queryString);
        stmt.setInt(1, idServizio);
        risultato = stmt.executeQuery();
        lista = new ArrayList<Fruitore>();
        while (risultato.next()) {
            Fruitore f = new Fruitore();
            f.setNome(risultato.getString("nome_soggetto"));
            f.setTipo(risultato.getString("tipo_soggetto"));
            lista.add(f);
        }
        ArrayList<Fruitore> arrayList = lista;
        Object var12_13 = null;
        try {
            if (risultato != null) {
                risultato.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessioni al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return arrayList;
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    public List<ServizioSpcoop> getServiziByIdErogatore(long idErogatore) throws DriverRegistroServiziException {
        return this.getServiziByIdErogatoreAndFilters(idErogatore, null);
    }

    public List<ServizioSpcoop> getServiziByIdErogatore(long idErogatore, ISearch filters) throws DriverRegistroServiziException {
        return this.getServiziByIdErogatoreAndFilters(idErogatore, filters);
    }

    /*
     * Loose catch block
     */
    private List<ServizioSpcoop> getServiziByIdErogatoreAndFilters(long idErogatore, ISearch filters) throws DriverRegistroServiziException {
        String nomeMetodo = "getServiziByIdErogatoreAndFilters";
        int idLista = 13;
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        int limit = filters.getPageSize(idLista);
        int offset = filters.getIndexIniziale(idLista);
        String search = "undefined".equals(filters.getSearchString(idLista)) ? "" : filters.getSearchString(idLista);
        ArrayList<ServizioSpcoop> lista = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("servizi");
        sqlQueryObject.addSelectCountField("*", "cont");
        sqlQueryObject.addWhereCondition("id_soggetto = ?");
        sqlQueryObject.setANDLogicOperator(true);
        if (!search.equals("")) {
            sqlQueryObject.addWhereLikeCondition("nome_servizio", search, true, true);
        }
        String queryString = sqlQueryObject.createSQLQuery();
        stmt = con.prepareStatement(queryString);
        stmt.setLong(1, idErogatore);
        risultato = stmt.executeQuery();
        if (risultato.next()) {
            filters.setNumEntries(idLista, risultato.getInt(1));
        }
        risultato.close();
        stmt.close();
        if (limit == 0) {
            limit = 1000;
        }
        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.setANDLogicOperator(true);
        sqlQueryObject.addFromTable("servizi");
        sqlQueryObject.addSelectField("id");
        sqlQueryObject.addSelectField("nome_servizio");
        sqlQueryObject.addSelectField("tipo_servizio");
        sqlQueryObject.addSelectField("id_soggetto");
        sqlQueryObject.addWhereCondition("id_soggetto = ?");
        if (!search.equals("")) {
            sqlQueryObject.addWhereLikeCondition("nome_servizio", search, true, true);
        }
        sqlQueryObject.addOrderBy("tipo_servizio");
        sqlQueryObject.addOrderBy("nome_servizio");
        sqlQueryObject.setSortType(true);
        sqlQueryObject.setLimit(limit);
        sqlQueryObject.setOffset(offset);
        queryString = sqlQueryObject.createSQLQuery();
        stmt = con.prepareStatement(queryString);
        stmt.setLong(1, idErogatore);
        risultato = stmt.executeQuery();
        lista = new ArrayList<ServizioSpcoop>();
        while (risultato.next()) {
            long id = risultato.getLong("id");
            ServizioSpcoop se = this.getServizioSpcoop(id, con);
            lista.add(se);
        }
        ArrayList<ServizioSpcoop> arrayList = lista;
        Object var19_19 = null;
        try {
            if (risultato != null) {
                risultato.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessioni al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return arrayList;
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                Object var19_20 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public List<ServizioSpcoop> getServiziByFruitore(Fruitore fruitore) throws DriverRegistroServiziException {
        String nomeMetodo = "getServiziByFruitore";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<ServizioSpcoop> lista = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        long idFruitore = DBUtils.getIdSoggetto(fruitore.getNome(), fruitore.getTipo(), con, this.tipoDB);
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("servizi_fruitori");
        sqlQueryObject.addWhereCondition("id_soggetto = ?");
        sqlQueryObject.setANDLogicOperator(true);
        String queryString = sqlQueryObject.createSQLQuery();
        stmt = con.prepareStatement(queryString);
        stmt.setLong(1, idFruitore);
        risultato = stmt.executeQuery();
        lista = new ArrayList<ServizioSpcoop>();
        while (risultato.next()) {
            long id = risultato.getLong("id");
            ServizioSpcoop se = this.getServizioSpcoop(id, con);
            lista.add(se);
        }
        ArrayList<ServizioSpcoop> arrayList = lista;
        Object var15_15 = null;
        try {
            if (risultato != null) {
                risultato.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessioni al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return arrayList;
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                Object var15_16 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public List<Fruitore> getSoggettiWithServizioNotFruitori(int idServizio) throws DriverRegistroServiziException {
        String nomeMetodo = "getSoggettiWithServizioNotFruitori";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<Fruitore> lista = new ArrayList<Fruitore>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        ISQLQueryObject sqlQueryObjectWhere = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObjectWhere.addFromTable("servizi_fruitori");
        sqlQueryObjectWhere.addSelectField("*");
        sqlQueryObjectWhere.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
        sqlQueryObjectWhere.addWhereCondition("servizi_fruitori.id_servizio = ?");
        sqlQueryObjectWhere.setANDLogicOperator(true);
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("soggetti");
        sqlQueryObject.addSelectField("soggetti.id");
        sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
        sqlQueryObject.addSelectField("soggetti.nome_soggetto");
        sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectWhere);
        sqlQueryObject.addOrderBy("soggetti.tipo_soggetto");
        sqlQueryObject.addOrderBy("soggetti.nome_soggetto");
        String queryString = sqlQueryObject.createSQLQuery();
        stmt = con.prepareStatement(queryString);
        stmt.setInt(1, idServizio);
        risultato = stmt.executeQuery();
        while (risultato.next()) {
            Fruitore f = new Fruitore();
            f.setId(risultato.getLong("id"));
            f.setNome(risultato.getString("nome_soggetto"));
            f.setTipo(risultato.getString("tipo_soggetto"));
            lista.add(f);
        }
        ArrayList<Fruitore> arrayList = lista;
        Object var13_14 = null;
        try {
            if (risultato != null) {
                risultato.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessioni al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return arrayList;
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public List<PortType> accordiPorttypeList(int idAccordo, ISearch ricerca) throws DriverRegistroServiziException {
        String queryString;
        ISQLQueryObject sqlQueryObject;
        String nomeMetodo = "accordiPorttypeList";
        int idLista = 30;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<PortType> lista = new ArrayList<PortType>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        if (!search.equals("")) {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("port_type");
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
        } else {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("port_type");
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            queryString = sqlQueryObject.createSQLQuery();
        }
        stmt = con.prepareStatement(queryString);
        stmt.setInt(1, idAccordo);
        risultato = stmt.executeQuery();
        if (risultato.next()) {
            ricerca.setNumEntries(idLista, risultato.getInt("cont"));
        }
        risultato.close();
        stmt.close();
        if (limit == 0) {
            limit = 1000;
        }
        if (!search.equals("")) {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("port_type");
            sqlQueryObject.addSelectField("id_accordo");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("profilo_collaborazione");
            sqlQueryObject.addSelectField("filtro_duplicati");
            sqlQueryObject.addSelectField("conferma_ricezione");
            sqlQueryObject.addSelectField("identificativo_collaborazione");
            sqlQueryObject.addSelectField("consegna_in_ordine");
            sqlQueryObject.addSelectField("scadenza");
            sqlQueryObject.addSelectField("profilo_pt");
            sqlQueryObject.addSelectField("soap_style");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("nome");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
        } else {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("port_type");
            sqlQueryObject.addSelectField("id_accordo");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("profilo_collaborazione");
            sqlQueryObject.addSelectField("filtro_duplicati");
            sqlQueryObject.addSelectField("conferma_ricezione");
            sqlQueryObject.addSelectField("identificativo_collaborazione");
            sqlQueryObject.addSelectField("consegna_in_ordine");
            sqlQueryObject.addSelectField("scadenza");
            sqlQueryObject.addSelectField("profilo_pt");
            sqlQueryObject.addSelectField("soap_style");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQueryObject.addOrderBy("nome");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
        }
        stmt = con.prepareStatement(queryString);
        stmt.setInt(1, idAccordo);
        risultato = stmt.executeQuery();
        while (risultato.next()) {
            PortType pt = new PortType();
            String tmp = risultato.getString("nome");
            pt.setNome(tmp == null || tmp.equals("") ? null : tmp);
            tmp = risultato.getString("descrizione");
            pt.setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
            tmp = risultato.getString("profilo_collaborazione");
            pt.setProfiloCollaborazione(tmp == null || tmp.equals("") ? null : tmp);
            tmp = risultato.getString("filtro_duplicati");
            pt.setFiltroDuplicati(tmp == null || tmp.equals("") ? null : tmp);
            tmp = risultato.getString("conferma_ricezione");
            pt.setConfermaRicezione(tmp == null || tmp.equals("") ? null : tmp);
            tmp = risultato.getString("identificativo_collaborazione");
            pt.setIdCollaborazione(tmp == null || tmp.equals("") ? null : tmp);
            tmp = risultato.getString("consegna_in_ordine");
            pt.setConsegnaInOrdine(tmp == null || tmp.equals("") ? null : tmp);
            tmp = risultato.getString("scadenza");
            pt.setScadenza(tmp == null || tmp.equals("") ? null : tmp);
            tmp = risultato.getString("profilo_pt");
            if (tmp == null || tmp.equals("")) {
                pt.setProfiloPT("default");
            } else {
                pt.setProfiloPT(tmp);
            }
            tmp = risultato.getString("soap_style");
            pt.setStyle(tmp == null || tmp.equals("") ? null : tmp);
            pt.setIdAccordo(risultato.getLong("id_accordo"));
            long idPortType = risultato.getLong("id");
            pt.setId(idPortType);
            lista.add(pt);
        }
        ArrayList<PortType> arrayList = lista;
        Object var18_18 = null;
        try {
            if (risultato != null) {
                risultato.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessioni al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return arrayList;
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                Object var18_19 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public List<PortType> accordiPorttypeList(int idAccordo, String profiloCollaborazione, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiPorttypeList";
        int idLista = 30;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<PortType> lista = new ArrayList<PortType>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("accordi");
        sqlQueryObject.addFromTable("port_type");
        sqlQueryObject.addSelectCountField("*", "cont");
        sqlQueryObject.setANDLogicOperator(true);
        sqlQueryObject.addWhereCondition("port_type.id_accordo = accordi.id");
        sqlQueryObject.addWhereCondition("port_type.id_accordo = ?");
        if (profiloCollaborazione != null) {
            sqlQueryObject.addWhereCondition(false, "accordi.profilo_collaborazione=?", "port_type.profilo_collaborazione = ? AND port_type.profilo_pt= ?");
        }
        if (!search.equals("")) {
            sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
        }
        String queryString = sqlQueryObject.createSQLQuery();
        stmt = con.prepareStatement(queryString);
        stmt.setInt(1, idAccordo);
        if (profiloCollaborazione != null) {
            stmt.setString(2, profiloCollaborazione);
            stmt.setString(3, profiloCollaborazione);
            stmt.setString(4, "ridefinito");
        }
        if ((risultato = stmt.executeQuery()).next()) {
            ricerca.setNumEntries(idLista, risultato.getInt("cont"));
        }
        risultato.close();
        stmt.close();
        if (limit == 0) {
            limit = 1000;
        }
        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("accordi");
        sqlQueryObject.addFromTable("port_type");
        sqlQueryObject.addSelectField("port_type", "id_accordo");
        sqlQueryObject.addSelectField("port_type", "nome");
        sqlQueryObject.addSelectField("port_type", "descrizione");
        sqlQueryObject.addSelectField("port_type", "profilo_collaborazione");
        sqlQueryObject.addSelectField("port_type", "filtro_duplicati");
        sqlQueryObject.addSelectField("port_type", "conferma_ricezione");
        sqlQueryObject.addSelectField("port_type", "identificativo_collaborazione");
        sqlQueryObject.addSelectField("port_type", "consegna_in_ordine");
        sqlQueryObject.addSelectField("port_type", "scadenza");
        sqlQueryObject.addSelectField("port_type", "profilo_pt");
        sqlQueryObject.addSelectField("port_type", "soap_style");
        sqlQueryObject.addSelectField("port_type", "id");
        sqlQueryObject.setANDLogicOperator(true);
        sqlQueryObject.addWhereCondition("port_type.id_accordo = accordi.id");
        sqlQueryObject.addWhereCondition("port_type.id_accordo = ?");
        if (profiloCollaborazione != null) {
            sqlQueryObject.addWhereCondition(false, "accordi.profilo_collaborazione=?", "port_type.profilo_collaborazione = ? AND port_type.profilo_pt= ?");
        }
        if (!search.equals("")) {
            sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
        }
        sqlQueryObject.addOrderBy("port_type.nome");
        sqlQueryObject.setSortType(true);
        sqlQueryObject.setLimit(limit);
        sqlQueryObject.setOffset(offset);
        queryString = sqlQueryObject.createSQLQuery();
        stmt = con.prepareStatement(queryString);
        stmt.setInt(1, idAccordo);
        if (profiloCollaborazione != null) {
            stmt.setString(2, profiloCollaborazione);
            stmt.setString(3, profiloCollaborazione);
            stmt.setString(4, "ridefinito");
        }
        risultato = stmt.executeQuery();
        while (risultato.next()) {
            PortType pt = new PortType();
            String tmp = risultato.getString("nome");
            pt.setNome(tmp == null || tmp.equals("") ? null : tmp);
            tmp = risultato.getString("descrizione");
            pt.setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
            tmp = risultato.getString("profilo_collaborazione");
            pt.setProfiloCollaborazione(tmp == null || tmp.equals("") ? null : tmp);
            tmp = risultato.getString("filtro_duplicati");
            pt.setFiltroDuplicati(tmp == null || tmp.equals("") ? null : tmp);
            tmp = risultato.getString("conferma_ricezione");
            pt.setConfermaRicezione(tmp == null || tmp.equals("") ? null : tmp);
            tmp = risultato.getString("identificativo_collaborazione");
            pt.setIdCollaborazione(tmp == null || tmp.equals("") ? null : tmp);
            tmp = risultato.getString("consegna_in_ordine");
            pt.setConsegnaInOrdine(tmp == null || tmp.equals("") ? null : tmp);
            tmp = risultato.getString("scadenza");
            pt.setScadenza(tmp == null || tmp.equals("") ? null : tmp);
            tmp = risultato.getString("profilo_pt");
            if (tmp == null || tmp.equals("")) {
                pt.setProfiloPT("default");
            } else {
                pt.setProfiloPT(tmp);
            }
            tmp = risultato.getString("soap_style");
            pt.setStyle(tmp == null || tmp.equals("") ? null : tmp);
            pt.setIdAccordo(risultato.getLong("id_accordo"));
            long idPortType = risultato.getLong("id");
            pt.setId(idPortType);
            lista.add(pt);
        }
        ArrayList<PortType> arrayList = lista;
        Object var20_20 = null;
        try {
            if (risultato != null) {
                risultato.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessioni al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return arrayList;
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                Object var20_21 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public List<Documento> accordiAllegatiList(int idAccordo, ISearch ricerca) throws DriverRegistroServiziException {
        String queryString;
        ISQLQueryObject sqlQueryObject;
        String nomeMetodo = "accordiAllegatiList";
        int idLista = 33;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<Documento> lista = new ArrayList<Documento>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        if (!search.equals("")) {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("documenti");
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.addWhereCondition("id_proprietario = ?");
            sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
            sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("roulo", search, true, true), sqlQueryObject.getWhereLikeCondition("nome", search, true, true));
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
        } else {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("documenti");
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.addWhereCondition("id_proprietario = ?");
            sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
        }
        stmt = con.prepareStatement(queryString);
        stmt.setInt(1, idAccordo);
        stmt.setString(2, ProprietariDocumento.accordoServizio.toString());
        risultato = stmt.executeQuery();
        if (risultato.next()) {
            ricerca.setNumEntries(idLista, risultato.getInt("cont"));
        }
        risultato.close();
        stmt.close();
        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("documenti");
        sqlQueryObject.addSelectField("id");
        sqlQueryObject.addSelectField("nome");
        sqlQueryObject.addSelectField("ruolo");
        sqlQueryObject.addSelectField("id_proprietario");
        sqlQueryObject.addSelectField("tipo_proprietario");
        sqlQueryObject.addWhereCondition("id_proprietario = ?");
        sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
        if (limit == 0) {
            limit = 1000;
        }
        if (!search.equals("")) {
            sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("roulo", search, true, true), sqlQueryObject.getWhereLikeCondition("nome", search, true, true));
        }
        sqlQueryObject.setANDLogicOperator(true);
        sqlQueryObject.addOrderBy("nome");
        sqlQueryObject.setSortType(true);
        sqlQueryObject.setLimit(limit);
        sqlQueryObject.setOffset(offset);
        queryString = sqlQueryObject.createSQLQuery();
        stmt = con.prepareStatement(queryString);
        stmt.setInt(1, idAccordo);
        stmt.setString(2, ProprietariDocumento.accordoServizio.toString());
        risultato = stmt.executeQuery();
        while (risultato.next()) {
            Documento doc = DriverRegistroServiziDB_LIB.getDocumento(risultato.getLong("id"), false, con);
            lista.add(doc);
        }
        ArrayList<Documento> arrayList = lista;
        Object var16_17 = null;
        try {
            if (risultato != null) {
                risultato.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessioni al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return arrayList;
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                Object var16_18 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public List<AccordoServizioServizioCompostoServizioComponente> accordiComponentiList(int idAccordo, ISearch ricerca) throws DriverRegistroServiziException {
        String queryString;
        ISQLQueryObject sqlQueryObject;
        String nomeMetodo = "accordiComponentiList";
        int idLista = 38;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<AccordoServizioServizioCompostoServizioComponente> lista = new ArrayList<AccordoServizioServizioCompostoServizioComponente>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        if (!search.equals("")) {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("acc_serv_composti");
            sqlQueryObject.addFromTable("acc_serv_componenti");
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectCountField("acc_serv_componenti.id_servizio_componente", "cont");
            sqlQueryObject.addWhereCondition("acc_serv_composti.id_accordo = ?");
            sqlQueryObject.addWhereCondition("acc_serv_composti.id = acc_serv_componenti.id_servizio_composto");
            sqlQueryObject.addWhereCondition("servizi.id = acc_serv_componenti.id_servizio_componente");
            sqlQueryObject.addWhereCondition("soggetti.id = servizi.id_soggetto");
            sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("tipo_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("nome_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("tipo_servizio", search, true, true), sqlQueryObject.getWhereLikeCondition("nome_servizio", search, true, true));
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
        } else {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("acc_serv_composti");
            sqlQueryObject.addFromTable("acc_serv_componenti");
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectCountField("acc_serv_componenti.id_servizio_componente", "cont");
            sqlQueryObject.addWhereCondition("acc_serv_composti.id_accordo = ?");
            sqlQueryObject.addWhereCondition("acc_serv_composti.id = acc_serv_componenti.id_servizio_composto");
            sqlQueryObject.addWhereCondition("servizi.id = acc_serv_componenti.id_servizio_componente");
            sqlQueryObject.addWhereCondition("soggetti.id = servizi.id_soggetto");
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
        }
        stmt = con.prepareStatement(queryString);
        stmt.setInt(1, idAccordo);
        risultato = stmt.executeQuery();
        if (risultato.next()) {
            ricerca.setNumEntries(idLista, risultato.getInt("cont"));
        }
        risultato.close();
        stmt.close();
        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("acc_serv_composti");
        sqlQueryObject.addFromTable("acc_serv_componenti");
        sqlQueryObject.addFromTable("servizi");
        sqlQueryObject.addFromTable("soggetti");
        sqlQueryObject.addSelectField("acc_serv_componenti", "id_servizio_componente");
        sqlQueryObject.addSelectField("acc_serv_componenti", "azione");
        sqlQueryObject.addSelectField("soggetti", "tipo_soggetto");
        sqlQueryObject.addSelectField("soggetti", "nome_soggetto");
        sqlQueryObject.addSelectField("servizi", "tipo_servizio");
        sqlQueryObject.addSelectField("servizi", "nome_servizio");
        sqlQueryObject.addWhereCondition("acc_serv_composti.id_accordo = ?");
        sqlQueryObject.addWhereCondition("acc_serv_composti.id = acc_serv_componenti.id_servizio_composto");
        sqlQueryObject.addWhereCondition("servizi.id = acc_serv_componenti.id_servizio_componente");
        sqlQueryObject.addWhereCondition("soggetti.id = servizi.id_soggetto");
        if (limit == 0) {
            limit = 1000;
        }
        if (!search.equals("")) {
            sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("tipo_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("nome_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("tipo_servizio", search, true, true), sqlQueryObject.getWhereLikeCondition("nome_servizio", search, true, true));
        }
        sqlQueryObject.setANDLogicOperator(true);
        sqlQueryObject.addOrderBy("tipo_soggetto");
        sqlQueryObject.addOrderBy("nome_soggetto");
        sqlQueryObject.addOrderBy("tipo_servizio");
        sqlQueryObject.addOrderBy("nome_servizio");
        sqlQueryObject.setSortType(true);
        sqlQueryObject.setLimit(limit);
        sqlQueryObject.setOffset(offset);
        queryString = sqlQueryObject.createSQLQuery();
        stmt = con.prepareStatement(queryString);
        stmt.setInt(1, idAccordo);
        risultato = stmt.executeQuery();
        while (risultato.next()) {
            long idServizioComponente = risultato.getLong("id_servizio_componente");
            String azione = risultato.getString("azione");
            AccordoServizioServizioCompostoServizioComponente asComponente = new AccordoServizioServizioCompostoServizioComponente();
            asComponente.setAzione(azione);
            asComponente.setIdServizioComponente(idServizioComponente);
            asComponente.setTipo(risultato.getString("tipo_servizio"));
            asComponente.setNome(risultato.getString("nome_servizio"));
            asComponente.setTipoSoggetto(risultato.getString("tipo_soggetto"));
            asComponente.setNomeSoggetto(risultato.getString("nome_soggetto"));
            lista.add(asComponente);
        }
        ArrayList<AccordoServizioServizioCompostoServizioComponente> arrayList = lista;
        Object var19_20 = null;
        try {
            if (risultato != null) {
                risultato.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessioni al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return arrayList;
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                Object var19_21 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public List<Documento> accordiCoopAllegatiList(int idAccordo, ISearch ricerca) throws DriverRegistroServiziException {
        String queryString;
        ISQLQueryObject sqlQueryObject;
        String nomeMetodo = "accordiCoopAllegatiList";
        int idLista = 37;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<Documento> lista = new ArrayList<Documento>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        if (!search.equals("")) {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("documenti");
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.addWhereCondition("id_proprietario = ?");
            sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
            sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("roulo", search, true, true), sqlQueryObject.getWhereLikeCondition("nome", search, true, true));
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
        } else {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("documenti");
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.addWhereCondition("id_proprietario = ?");
            sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
        }
        stmt = con.prepareStatement(queryString);
        stmt.setInt(1, idAccordo);
        stmt.setString(2, ProprietariDocumento.accordoCooperazione.toString());
        risultato = stmt.executeQuery();
        if (risultato.next()) {
            ricerca.setNumEntries(idLista, risultato.getInt("cont"));
        }
        risultato.close();
        stmt.close();
        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("documenti");
        sqlQueryObject.addSelectField("id");
        sqlQueryObject.addSelectField("nome");
        sqlQueryObject.addSelectField("ruolo");
        sqlQueryObject.addSelectField("id_proprietario");
        sqlQueryObject.addSelectField("tipo_proprietario");
        sqlQueryObject.addWhereCondition("id_proprietario = ?");
        sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
        if (limit == 0) {
            limit = 1000;
        }
        if (!search.equals("")) {
            sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("roulo", search, true, true), sqlQueryObject.getWhereLikeCondition("nome", search, true, true));
        }
        sqlQueryObject.setANDLogicOperator(true);
        sqlQueryObject.addOrderBy("nome");
        sqlQueryObject.setSortType(true);
        sqlQueryObject.setLimit(limit);
        sqlQueryObject.setOffset(offset);
        queryString = sqlQueryObject.createSQLQuery();
        stmt = con.prepareStatement(queryString);
        stmt.setInt(1, idAccordo);
        stmt.setString(2, ProprietariDocumento.accordoCooperazione.toString());
        risultato = stmt.executeQuery();
        while (risultato.next()) {
            Documento doc = DriverRegistroServiziDB_LIB.getDocumento(risultato.getLong("id"), false, con);
            lista.add(doc);
        }
        ArrayList<Documento> arrayList = lista;
        Object var16_17 = null;
        try {
            if (risultato != null) {
                risultato.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessioni al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return arrayList;
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                Object var16_18 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public List<Operation> accordiPorttypeOperationList(int idPortType, String profiloCollaborazione, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiPorttypeOperationsList";
        int idLista = 31;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<Operation> lista = new ArrayList<Operation>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("accordi");
        sqlQueryObject.addFromTable("port_type");
        sqlQueryObject.addFromTable("port_type_azioni");
        sqlQueryObject.addSelectCountField("port_type_azioni.id", "cont");
        sqlQueryObject.setANDLogicOperator(true);
        sqlQueryObject.addWhereCondition("port_type.id_accordo = accordi.id");
        sqlQueryObject.addWhereCondition("port_type_azioni.id_port_type = port_type.id");
        sqlQueryObject.addWhereCondition("port_type.id = ?");
        sqlQueryObject.addWhereCondition(false, "accordi.profilo_collaborazione=?", "port_type.profilo_collaborazione = ? AND port_type.profilo_pt= ?", "port_type_azioni.profilo_collaborazione = ? AND port_type_azioni.profilo_pt_azione= ?");
        if (!search.equals("")) {
            sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
        }
        String queryString = sqlQueryObject.createSQLQuery();
        stmt = con.prepareStatement(queryString);
        stmt.setInt(1, idPortType);
        stmt.setString(2, profiloCollaborazione);
        stmt.setString(3, profiloCollaborazione);
        stmt.setString(4, "ridefinito");
        stmt.setString(5, profiloCollaborazione);
        stmt.setString(6, "ridefinito");
        risultato = stmt.executeQuery();
        if (risultato.next()) {
            ricerca.setNumEntries(idLista, risultato.getInt("cont"));
        }
        risultato.close();
        stmt.close();
        if (limit == 0) {
            limit = 1000;
        }
        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("accordi");
        sqlQueryObject.addFromTable("port_type");
        sqlQueryObject.addFromTable("port_type_azioni");
        sqlQueryObject.addSelectField("port_type_azioni", "id_port_type");
        sqlQueryObject.addSelectAliasField("port_type_azioni", "nome", "nomePTAz");
        sqlQueryObject.addSelectAliasField("port_type_azioni", "profilo_collaborazione", "profCollPTAz");
        sqlQueryObject.addSelectAliasField("port_type_azioni", "filtro_duplicati", "filtro_duplicatiPTAz");
        sqlQueryObject.addSelectAliasField("port_type_azioni", "conferma_ricezione", "conferma_ricezionePTAz");
        sqlQueryObject.addSelectAliasField("port_type_azioni", "identificativo_collaborazione", "idCollPTAz");
        sqlQueryObject.addSelectAliasField("port_type_azioni", "consegna_in_ordine", "consegna_in_ordinePTAz");
        sqlQueryObject.addSelectAliasField("port_type_azioni", "scadenza", "scadenzaPTAz");
        sqlQueryObject.addSelectField("port_type_azioni", "profilo_pt_azione");
        sqlQueryObject.addSelectAliasField("port_type_azioni", "id", "idPTAz");
        sqlQueryObject.setANDLogicOperator(true);
        sqlQueryObject.addWhereCondition("port_type.id_accordo = accordi.id");
        sqlQueryObject.addWhereCondition("port_type_azioni.id_port_type = port_type.id");
        sqlQueryObject.addWhereCondition("port_type.id = ?");
        sqlQueryObject.addWhereCondition(false, "accordi.profilo_collaborazione=?", "port_type.profilo_collaborazione = ? AND port_type.profilo_pt= ?", "port_type_azioni.profilo_collaborazione = ? AND port_type_azioni.profilo_pt_azione= ?");
        if (!search.equals("")) {
            sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
        }
        sqlQueryObject.addOrderBy("port_type_azioni.nome");
        sqlQueryObject.setSortType(true);
        sqlQueryObject.setLimit(limit);
        sqlQueryObject.setOffset(offset);
        queryString = sqlQueryObject.createSQLQuery();
        this.log.debug((Object)("Query: " + queryString));
        stmt = con.prepareStatement(queryString);
        stmt.setInt(1, idPortType);
        stmt.setString(2, profiloCollaborazione);
        stmt.setString(3, profiloCollaborazione);
        stmt.setString(4, "ridefinito");
        stmt.setString(5, profiloCollaborazione);
        stmt.setString(6, "ridefinito");
        risultato = stmt.executeQuery();
        while (risultato.next()) {
            Operation op = new Operation();
            String tmp = risultato.getString("nomePTAz");
            op.setNome(tmp == null || tmp.equals("") ? null : tmp);
            tmp = risultato.getString("profCollPTAz");
            op.setProfiloCollaborazione(tmp == null || tmp.equals("") ? null : tmp);
            tmp = risultato.getString("filtro_duplicatiPTAz");
            op.setFiltroDuplicati(tmp == null || tmp.equals("") ? null : tmp);
            tmp = risultato.getString("conferma_ricezionePTAz");
            op.setConfermaRicezione(tmp == null || tmp.equals("") ? null : tmp);
            tmp = risultato.getString("idCollPTAz");
            op.setIdCollaborazione(tmp == null || tmp.equals("") ? null : tmp);
            tmp = risultato.getString("consegna_in_ordinePTAz");
            op.setConsegnaInOrdine(tmp == null || tmp.equals("") ? null : tmp);
            tmp = risultato.getString("scadenzaPTAz");
            op.setScadenza(tmp == null || tmp.equals("") ? null : tmp);
            tmp = risultato.getString("profilo_pt_azione");
            if (tmp == null || tmp.equals("")) {
                op.setProfAzione("default");
            } else {
                op.setProfAzione(tmp);
            }
            op.setIdPortType(risultato.getLong("id_port_type"));
            long idOperation = risultato.getLong("idPTAz");
            op.setId(idOperation);
            lista.add(op);
        }
        ArrayList<Operation> arrayList = lista;
        Object var20_20 = null;
        try {
            if (risultato != null) {
                risultato.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessioni al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return arrayList;
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                Object var20_21 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public List<Operation> accordiPorttypeOperationList(int idPortType, ISearch ricerca) throws DriverRegistroServiziException {
        String queryString;
        ISQLQueryObject sqlQueryObject;
        String nomeMetodo = "accordiPorttypeOperationsList";
        int idLista = 31;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<Operation> lista = new ArrayList<Operation>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        if (!search.equals("")) {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("port_type_azioni");
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.addWhereCondition("id_port_type = ?");
            sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
        } else {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("port_type_azioni");
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.addWhereCondition("id_port_type = ?");
            queryString = sqlQueryObject.createSQLQuery();
        }
        stmt = con.prepareStatement(queryString);
        stmt.setInt(1, idPortType);
        risultato = stmt.executeQuery();
        if (risultato.next()) {
            ricerca.setNumEntries(idLista, risultato.getInt("cont"));
        }
        risultato.close();
        stmt.close();
        if (limit == 0) {
            limit = 1000;
        }
        if (!search.equals("")) {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("port_type_azioni");
            sqlQueryObject.addSelectField("id_port_type");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("profilo_collaborazione");
            sqlQueryObject.addSelectField("filtro_duplicati");
            sqlQueryObject.addSelectField("conferma_ricezione");
            sqlQueryObject.addSelectField("identificativo_collaborazione");
            sqlQueryObject.addSelectField("consegna_in_ordine");
            sqlQueryObject.addSelectField("scadenza");
            sqlQueryObject.addSelectField("profilo_pt_azione");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("id_port_type = ?");
            sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("nome");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
        } else {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("port_type_azioni");
            sqlQueryObject.addSelectField("id_port_type");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("profilo_collaborazione");
            sqlQueryObject.addSelectField("filtro_duplicati");
            sqlQueryObject.addSelectField("conferma_ricezione");
            sqlQueryObject.addSelectField("identificativo_collaborazione");
            sqlQueryObject.addSelectField("consegna_in_ordine");
            sqlQueryObject.addSelectField("scadenza");
            sqlQueryObject.addSelectField("profilo_pt_azione");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("id_port_type = ?");
            sqlQueryObject.addOrderBy("nome");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
        }
        stmt = con.prepareStatement(queryString);
        stmt.setInt(1, idPortType);
        risultato = stmt.executeQuery();
        while (risultato.next()) {
            Operation op = new Operation();
            String tmp = risultato.getString("nome");
            op.setNome(tmp == null || tmp.equals("") ? null : tmp);
            tmp = risultato.getString("profilo_collaborazione");
            op.setProfiloCollaborazione(tmp == null || tmp.equals("") ? null : tmp);
            tmp = risultato.getString("filtro_duplicati");
            op.setFiltroDuplicati(tmp == null || tmp.equals("") ? null : tmp);
            tmp = risultato.getString("conferma_ricezione");
            op.setConfermaRicezione(tmp == null || tmp.equals("") ? null : tmp);
            tmp = risultato.getString("identificativo_collaborazione");
            op.setIdCollaborazione(tmp == null || tmp.equals("") ? null : tmp);
            tmp = risultato.getString("consegna_in_ordine");
            op.setConsegnaInOrdine(tmp == null || tmp.equals("") ? null : tmp);
            tmp = risultato.getString("scadenza");
            op.setScadenza(tmp == null || tmp.equals("") ? null : tmp);
            tmp = risultato.getString("profilo_pt_azione");
            if (tmp == null || tmp.equals("")) {
                op.setProfAzione("default");
            } else {
                op.setProfAzione(tmp);
            }
            op.setIdPortType(risultato.getLong("id_port_type"));
            long idOperation = risultato.getLong("id");
            op.setId(idOperation);
            lista.add(op);
        }
        ArrayList<Operation> arrayList = lista;
        Object var18_18 = null;
        try {
            if (risultato != null) {
                risultato.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessioni al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return arrayList;
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                Object var18_19 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public boolean isCorrelata(int idAccordo, String nomeAzione, String owner) throws DriverRegistroServiziException {
        String nomeMetodo = "isCorrelata";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("accordi_azioni");
        sqlQueryObject.addSelectCountField("id", "tot");
        sqlQueryObject.addWhereCondition("id_accordo = ?");
        sqlQueryObject.addWhereCondition("correlata = ?");
        sqlQueryObject.addWhereCondition("nome <> ?");
        sqlQueryObject.setANDLogicOperator(true);
        String queryString = sqlQueryObject.createSQLQuery();
        stmt = con.prepareStatement(queryString);
        stmt.setInt(1, idAccordo);
        stmt.setString(2, nomeAzione);
        stmt.setString(3, owner);
        risultato = stmt.executeQuery();
        int tot = 0;
        if (risultato.next()) {
            tot = risultato.getInt("tot");
        }
        risultato.close();
        boolean bl = tot > 0;
        Object var13_14 = null;
        try {
            if (risultato != null) {
                risultato.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessioni al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return bl;
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public boolean isOperationCorrelata(int idPortType, String nomeCorrelata, String owner) throws DriverRegistroServiziException {
        String nomeMetodo = "isOperationCorrelata";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("port_type_azioni");
        sqlQueryObject.addSelectCountField("id", "tot");
        sqlQueryObject.addWhereCondition("id_port_type = ?");
        sqlQueryObject.addWhereCondition("correlata = ?");
        sqlQueryObject.addWhereCondition("nome <> ?");
        sqlQueryObject.setANDLogicOperator(true);
        String queryString = sqlQueryObject.createSQLQuery();
        stmt = con.prepareStatement(queryString);
        stmt.setInt(1, idPortType);
        stmt.setString(2, nomeCorrelata);
        stmt.setString(3, owner);
        risultato = stmt.executeQuery();
        int tot = 0;
        if (risultato.next()) {
            tot = risultato.getInt("tot");
        }
        risultato.close();
        boolean bl = tot > 0;
        Object var13_14 = null;
        try {
            if (risultato != null) {
                risultato.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessioni al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return bl;
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    public boolean isOperationCorrelataDaAltraAzione(String nomePortType, long idPortType, String azioneDaVerificare, long idAzioneDaVerificare) throws DriverRegistroServiziException {
        return this.isOperationCorrelata(nomePortType, idPortType, azioneDaVerificare, idAzioneDaVerificare, false, true);
    }

    public boolean isOperationCorrelataRichiesta(String nomePortType, long idPortType, String azioneDaVerificare, long idAzioneDaVerificare) throws DriverRegistroServiziException {
        return this.isOperationCorrelata(nomePortType, idPortType, azioneDaVerificare, idAzioneDaVerificare, true, false);
    }

    public boolean isOperationCorrelata(String nomePortType, long idPortType, String azioneDaVerificare, long idAzioneDaVerificare) throws DriverRegistroServiziException {
        return this.isOperationCorrelata(nomePortType, idPortType, azioneDaVerificare, idAzioneDaVerificare, true, true);
    }

    /*
     * Loose catch block
     */
    private boolean isOperationCorrelata(String nomePortType, long idPortType, String azioneDaVerificare, long idAzioneDaVerificare, boolean checkCorrelazioneARichiesta, boolean checkCorrelazioneDaAltraAzione) throws DriverRegistroServiziException {
        ResultSet risultato;
        Statement stmt;
        Connection con;
        String nomeMetodo;
        block41: {
            boolean correlataDaUnAltraAzione;
            block38: {
                String queryString;
                nomeMetodo = "isOperationCorrelata";
                con = null;
                stmt = null;
                risultato = null;
                if (this.atomica) {
                    try {
                        con = this.datasource.getConnection();
                    }
                    catch (SQLException e) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
                    }
                } else {
                    con = this.globalConnection;
                }
                this.log.debug((Object)("operazione this.atomica = " + this.atomica));
                boolean correlataAdUnaRichiesta = false;
                if (checkCorrelazioneARichiesta) {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                    sqlQueryObject.addFromTable("port_type_azioni");
                    sqlQueryObject.addSelectCountField("id", "tot");
                    sqlQueryObject.addWhereCondition("port_type_azioni.id_port_type = ?");
                    sqlQueryObject.addWhereCondition("nome = ?");
                    sqlQueryObject.addWhereCondition(false, "port_type_azioni.correlata is not null", "port_type_azioni.correlata_servizio is not null");
                    sqlQueryObject.setANDLogicOperator(true);
                    queryString = sqlQueryObject.createSQLQuery();
                    this.log.debug((Object)("VERIFICO CORRELAZIONE AD UNA RICHIESTA [" + idPortType + "] [" + azioneDaVerificare + "]: " + queryString));
                    stmt = con.prepareStatement(queryString);
                    stmt.setLong(1, idPortType);
                    stmt.setString(2, azioneDaVerificare);
                    risultato = stmt.executeQuery();
                    int tot = 0;
                    if (risultato.next()) {
                        tot = risultato.getInt("tot");
                    }
                    risultato.close();
                    stmt.close();
                    correlataAdUnaRichiesta = tot > 0;
                    this.log.debug((Object)("VERIFICO CORRELAZIONE AD UNA RICHIESTA, risultato [" + tot + "]: " + correlataAdUnaRichiesta));
                }
                correlataDaUnAltraAzione = false;
                if (checkCorrelazioneDaAltraAzione) {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                    sqlQueryObject.addFromTable("port_type_azioni");
                    sqlQueryObject.addSelectCountField("id", "tot");
                    sqlQueryObject.addWhereCondition("port_type_azioni.id<>?");
                    sqlQueryObject.addWhereCondition(true, "port_type_azioni.correlata =?", "port_type_azioni.correlata_servizio =?");
                    sqlQueryObject.setANDLogicOperator(true);
                    queryString = sqlQueryObject.createSQLQuery();
                    stmt = con.prepareStatement(queryString);
                    this.log.debug((Object)("VERIFICO CHE NON SIA CORRELATA DA UN'ALTRA AZIONE (AS e AA con PT diverso) [" + idAzioneDaVerificare + "] [" + azioneDaVerificare + "] [" + nomePortType + "]: " + queryString));
                    stmt.setLong(1, idAzioneDaVerificare);
                    stmt.setString(2, azioneDaVerificare);
                    stmt.setString(3, nomePortType);
                    risultato = stmt.executeQuery();
                    int tot = 0;
                    if (risultato.next()) {
                        tot = risultato.getInt("tot");
                    }
                    risultato.close();
                    stmt.close();
                    correlataDaUnAltraAzione = tot > 0;
                    this.log.debug((Object)("VERIFICO CHE NON SIA CORRELATA DA UN'ALTRA AZIONE (AS e AA con PT diverso), risultato [" + tot + "]: " + correlataDaUnAltraAzione));
                    if (!correlataDaUnAltraAzione) {
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                        sqlQueryObject.addFromTable("port_type_azioni");
                        sqlQueryObject.addSelectCountField("id", "tot");
                        sqlQueryObject.addWhereCondition("port_type_azioni.id<>?");
                        sqlQueryObject.addWhereCondition(true, "port_type_azioni.correlata =?", "port_type_azioni.correlata_servizio is null", "port_type_azioni.id_port_type = ?");
                        sqlQueryObject.setANDLogicOperator(true);
                        queryString = sqlQueryObject.createSQLQuery();
                        stmt = con.prepareStatement(queryString);
                        this.log.debug((Object)("VERIFICO CHE NON SIA CORRELATA DA UN'ALTRA AZIONE (AA con stesso port type) [" + idAzioneDaVerificare + "] [" + azioneDaVerificare + "] [" + nomePortType + "] [" + azioneDaVerificare + "] [" + idPortType + "]: " + queryString));
                        stmt.setLong(1, idAzioneDaVerificare);
                        stmt.setString(2, azioneDaVerificare);
                        stmt.setLong(3, idPortType);
                        risultato = stmt.executeQuery();
                        tot = 0;
                        if (risultato.next()) {
                            tot = risultato.getInt("tot");
                        }
                        risultato.close();
                        stmt.close();
                        correlataDaUnAltraAzione = tot > 0;
                        this.log.debug((Object)("VERIFICO CHE NON SIA CORRELATA DA UN'ALTRA AZIONE (AA con stesso port type), risultato [" + tot + "]: " + correlataDaUnAltraAzione));
                    }
                }
                if (!correlataAdUnaRichiesta) break block38;
                boolean bl = true;
                Object var19_23 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                return bl;
            }
            if (!correlataDaUnAltraAzione) break block41;
            boolean bl = true;
            Object var19_24 = null;
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return bl;
        }
        boolean bl = false;
        Object var19_25 = null;
        try {
            if (risultato != null) {
                risultato.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessioni al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return bl;
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                Object var19_26 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public void isAlive() throws DriverException {
        block27: {
            block28: {
                if (!this.create) {
                    throw new DriverException("Driver non inizializzato");
                }
                if (!this.atomica) break block28;
                Connection con = null;
                Statement stmtTest = null;
                con = this.datasource.getConnection();
                if (con == null) {
                    throw new Exception("Connessione is null");
                }
                stmtTest = con.createStatement();
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("db_info");
                sqlQueryObject.addSelectField("*");
                String sqlQuery = sqlQueryObject.createSQLQuery();
                stmtTest.execute(sqlQuery);
                Object var6_10 = null;
                try {
                    if (stmtTest != null) {
                        stmtTest.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (con != null) {
                        con.close();
                    }
                    break block27;
                }
                catch (Exception e) {}
                break block27;
                {
                    catch (Exception e) {
                        throw new DriverException("Connessione al registro non disponibile: " + e.getMessage(), e);
                    }
                }
                catch (Throwable throwable) {
                    Object var6_11 = null;
                    try {
                        if (stmtTest != null) {
                            stmtTest.close();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        if (con != null) {
                            con.close();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            Statement stmtTest = null;
            if (this.globalConnection == null) {
                throw new Exception("Connessione is null");
            }
            stmtTest = this.globalConnection.createStatement();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("db_info");
            sqlQueryObject.addSelectField("*");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stmtTest.execute(sqlQuery);
            Object var9_15 = null;
            try {
                if (stmtTest != null) {
                    stmtTest.close();
                }
                break block27;
            }
            catch (Exception e) {}
            break block27;
            {
                catch (Exception e) {
                    throw new DriverException("Connessione al registro non disponibile: " + e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                Object var9_16 = null;
                try {
                    if (stmtTest != null) {
                        stmtTest.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public List<ServizioSpcoop> soggettiServizioList(long idSoggetto) throws DriverRegistroServiziException {
        String nomeMetodo = "soggettiServizioList";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        boolean error = false;
        ArrayList<ServizioSpcoop> serviziList = new ArrayList<ServizioSpcoop>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("servizi");
        sqlQueryObject.addSelectField("id");
        sqlQueryObject.addSelectField("tipo_servizio");
        sqlQueryObject.addSelectField("nome_servizio");
        sqlQueryObject.addWhereCondition("id_soggetto = ?");
        sqlQueryObject.addOrderBy("tipo_servizio");
        sqlQueryObject.addOrderBy("nome_servizio");
        sqlQueryObject.setSortType(true);
        String queryString = sqlQueryObject.createSQLQuery();
        stmt = con.prepareStatement(queryString);
        stmt.setLong(1, idSoggetto);
        risultato = stmt.executeQuery();
        while (risultato.next()) {
            ServizioSpcoop servSpcoop = new ServizioSpcoop();
            servSpcoop.setId(risultato.getLong("id"));
            servSpcoop.setTipo(risultato.getString("tipo_servizio"));
            servSpcoop.setNome(risultato.getString("nome_servizio"));
            serviziList.add(servSpcoop);
        }
        ArrayList<ServizioSpcoop> arrayList = serviziList;
        Object var13_13 = null;
        try {
            if (risultato != null) {
                risultato.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (error && this.atomica) {
                this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                con.rollback();
                con.setAutoCommit(true);
                con.close();
            } else if (!error && this.atomica) {
                this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                con.commit();
                con.setAutoCommit(true);
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return arrayList;
        catch (Exception qe) {
            try {
                error = true;
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (error && this.atomica) {
                        this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                        con.rollback();
                        con.setAutoCommit(true);
                        con.close();
                    } else if (!error && this.atomica) {
                        this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                        con.commit();
                        con.setAutoCommit(true);
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public List<ServizioSpcoop> soggettiServizioList(String superuser, ISearch ricerca) throws DriverRegistroServiziException {
        Cloneable serv;
        String queryString;
        ISQLQueryObject sqlQueryObject;
        String nomeMetodo = "soggettiServizioList";
        int idLista = 13;
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        boolean error = false;
        ArrayList<Cloneable> serviziList = new ArrayList<Cloneable>();
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        if (!search.equals("")) {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.addWhereCondition("id_soggetto = soggetti.id");
            if (superuser != null && !"".equals(superuser)) {
                sqlQueryObject.addWhereCondition("soggetti.superuser = ?");
            }
            sqlQueryObject.addWhereLikeCondition("nome_servizio", search, true, true);
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
        } else {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.addWhereCondition("id_soggetto = soggetti.id");
            if (superuser != null && !"".equals(superuser)) {
                sqlQueryObject.addWhereCondition("soggetti.superuser = ?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
        }
        stmt = con.prepareStatement(queryString);
        if (superuser != null && !"".equals(superuser)) {
            stmt.setString(1, superuser);
        }
        if ((risultato = stmt.executeQuery()).next()) {
            ricerca.setNumEntries(idLista, risultato.getInt(1));
        }
        risultato.close();
        stmt.close();
        if (limit == 0) {
            limit = 1000;
        }
        if (!search.equals("")) {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("servizi.id");
            sqlQueryObject.addSelectField("nome_servizio");
            sqlQueryObject.addSelectField("tipo_servizio");
            sqlQueryObject.addSelectField("id_soggetto");
            sqlQueryObject.addSelectField("id_accordo");
            sqlQueryObject.addSelectField("servizio_correlato");
            sqlQueryObject.addSelectField("stato");
            sqlQueryObject.addSelectAliasField("servizi", "descrizione", "descrizioneServizio");
            sqlQueryObject.addSelectField("aps_versione");
            sqlQueryObject.addSelectField("aps_nome");
            sqlQueryObject.addWhereCondition("id_soggetto = soggetti.id");
            if (superuser != null && !"".equals(superuser)) {
                sqlQueryObject.addWhereCondition("soggetti.superuser = ?");
            }
            sqlQueryObject.addWhereLikeCondition("nome_servizio", search, true, true);
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("tipo_servizio");
            sqlQueryObject.addOrderBy("nome_servizio");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
        } else {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("servizi.id");
            sqlQueryObject.addSelectField("nome_servizio");
            sqlQueryObject.addSelectField("tipo_servizio");
            sqlQueryObject.addSelectField("id_soggetto");
            sqlQueryObject.addSelectField("id_accordo");
            sqlQueryObject.addSelectField("servizio_correlato");
            sqlQueryObject.addSelectField("stato");
            sqlQueryObject.addSelectAliasField("servizi", "descrizione", "descrizioneServizio");
            sqlQueryObject.addSelectField("aps_versione");
            sqlQueryObject.addSelectField("aps_nome");
            sqlQueryObject.addWhereCondition("id_soggetto = soggetti.id");
            if (superuser != null && !"".equals(superuser)) {
                sqlQueryObject.addWhereCondition("soggetti.superuser = ?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("tipo_servizio");
            sqlQueryObject.addOrderBy("nome_servizio");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
        }
        this.log.debug((Object)("query : " + queryString));
        stmt = con.prepareStatement(queryString);
        if (superuser != null && !"".equals(superuser)) {
            stmt.setString(1, superuser);
        }
        risultato = stmt.executeQuery();
        while (risultato.next()) {
            serv = new ServizioSpcoop();
            ((ServizioSpcoop)serv).setId(risultato.getLong("id"));
            ((ServizioSpcoop)serv).setNome(risultato.getString("nome_servizio"));
            ((ServizioSpcoop)serv).setTipo(risultato.getString("tipo_servizio"));
            ((ServizioSpcoop)serv).setIdSoggetto(risultato.getLong("id_soggetto"));
            ((ServizioSpcoop)serv).setIdAccordo(risultato.getLong("id_accordo"));
            String servizio_correlato = risultato.getString("servizio_correlato");
            ((ServizioSpcoop)serv).setServizioCorrelato(servizio_correlato != null && servizio_correlato.equalsIgnoreCase("abilitato"));
            ((ServizioSpcoop)serv).setDescrizione(risultato.getString("descrizioneServizio"));
            SoggettoSpcoop sog = this.getSoggettoRegistro(((ServizioSpcoop)serv).getIdSoggetto(), con);
            String nomeErogatore = sog.getNome();
            String tipoErogatore = sog.getTipo();
            ((ServizioSpcoop)serv).setNomeSoggettoErogatore(nomeErogatore);
            ((ServizioSpcoop)serv).setTipoSoggettoErogatore(tipoErogatore);
            AccordoServizio as = this.getAccordoServizio(((ServizioSpcoop)serv).getIdAccordo(), con);
            ((ServizioSpcoop)serv).setAccordoServizio(IDAccordo.getUriFromAccordo(as));
            ((ServizioSpcoop)serv).setStatoPackage(risultato.getString("stato"));
            ServizioSpcoopAccordoParteSpecifica aps = new ServizioSpcoopAccordoParteSpecifica();
            aps.setNome(risultato.getString("aps_nome"));
            aps.setVersione(risultato.getString("aps_versione"));
            ((ServizioSpcoop)serv).setAccordoParteSpecifica(aps);
            serviziList.add(serv);
        }
        serv = serviziList;
        Object var22_23 = null;
        try {
            if (risultato != null) {
                risultato.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (error && this.atomica) {
                this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                con.rollback();
                con.setAutoCommit(true);
                con.close();
            } else if (!error && this.atomica) {
                this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                con.commit();
                con.setAutoCommit(true);
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return serv;
        catch (Exception qe) {
            try {
                error = true;
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                Object var22_24 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (error && this.atomica) {
                        this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                        con.rollback();
                        con.setAutoCommit(true);
                        con.close();
                    } else if (!error && this.atomica) {
                        this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                        con.commit();
                        con.setAutoCommit(true);
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createConnettore(Connettore connettore) throws DriverRegistroServiziException {
        if (connettore == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createConnettore] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createConnettore] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            try {
                this.log.debug((Object)"CRUDConnettore type = 1");
                DriverRegistroServiziDB_LIB.CRUDConnettore(1, connettore, con);
            }
            catch (DriverRegistroServiziException qe) {
                error = true;
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createConnettore] Errore durante la creazione del connettore : " + qe.getMessage(), qe);
            }
            catch (Exception qe) {
                error = true;
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createConnettore] Errore durante la creazione del connettore : " + qe.getMessage(), qe);
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                    throw throwable;
                }
                if (error) throw throwable;
                if (!this.atomica) throw throwable;
                this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                con.commit();
                con.setAutoCommit(true);
                con.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        if (error && this.atomica) {
            this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
            con.rollback();
            con.setAutoCommit(true);
            con.close();
            return;
        }
        if (error) return;
        if (!this.atomica) return;
        this.log.debug((Object)"eseguo commit e rilascio connessioni...");
        con.commit();
        con.setAutoCommit(true);
        con.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateConnettore(Connettore connettore) throws DriverRegistroServiziException {
        if (connettore == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateConnettore] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateConnettore] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            try {
                this.log.debug((Object)"CRUDConnettore type = 2");
                DriverRegistroServiziDB_LIB.CRUDConnettore(2, connettore, con);
            }
            catch (DriverRegistroServiziException qe) {
                error = true;
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateConnettore] Errore durante l'aggiornamento del connettore : " + qe.getMessage(), qe);
            }
            catch (Exception qe) {
                error = true;
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateConnettore] Errore durante l'aggiornamento del connettore : " + qe.getMessage(), qe);
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                    throw throwable;
                }
                if (error) throw throwable;
                if (!this.atomica) throw throwable;
                this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                con.commit();
                con.setAutoCommit(true);
                con.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        if (error && this.atomica) {
            this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
            con.rollback();
            con.setAutoCommit(true);
            con.close();
            return;
        }
        if (error) return;
        if (!this.atomica) return;
        this.log.debug((Object)"eseguo commit e rilascio connessioni...");
        con.commit();
        con.setAutoCommit(true);
        con.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteConnettore(Connettore connettore) throws DriverRegistroServiziException {
        if (connettore == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteConnettore] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteConnettore] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            try {
                this.log.debug((Object)"CRUDConnettore type = 3");
                DriverRegistroServiziDB_LIB.CRUDConnettore(3, connettore, con);
            }
            catch (DriverRegistroServiziException qe) {
                error = true;
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteConnettore] Errore durante la rimozione del connettore : " + qe.getMessage(), qe);
            }
            catch (Exception qe) {
                error = true;
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteConnettore] Errore durante la rimozione del connettore : " + qe.getMessage(), qe);
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                    throw throwable;
                }
                if (error) throw throwable;
                if (!this.atomica) throw throwable;
                this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                con.commit();
                con.setAutoCommit(true);
                con.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        if (error && this.atomica) {
            this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
            con.rollback();
            con.setAutoCommit(true);
            con.close();
            return;
        }
        if (error) return;
        if (!this.atomica) return;
        this.log.debug((Object)"eseguo commit e rilascio connessioni...");
        con.commit();
        con.setAutoCommit(true);
        con.close();
        return;
    }

    @Override
    public List<PortaDominio> porteDominioList(String superuser, ISearch ricerca) throws DriverRegistroServiziException {
        return this.porteDominioList(superuser, null, ricerca);
    }

    /*
     * Loose catch block
     */
    public List<PortaDominio> porteDominioList(String superuser, String tipo, ISearch ricerca) throws DriverRegistroServiziException {
        ISQLQueryObject sqlQueryObject;
        String queryString;
        ISQLQueryObject sqlQueryObject2;
        String nomeMetodo = "porteDominioList";
        int idLista = 23;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<PortaDominio> lista = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        if (!search.equals("")) {
            sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject2.addFromTable("pdd");
            sqlQueryObject2.addSelectCountField("*", "cont");
            if (superuser != null && !superuser.equals("")) {
                sqlQueryObject2.addWhereCondition("superuser = ?");
            }
            if (tipo != null && !tipo.equals("")) {
                sqlQueryObject2.addWhereCondition("tipo = ?");
            }
            sqlQueryObject2.addWhereLikeCondition("nome", search, true, true);
            sqlQueryObject2.setANDLogicOperator(true);
            queryString = sqlQueryObject2.createSQLQuery();
        } else {
            sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject2.addFromTable("pdd");
            sqlQueryObject2.addSelectCountField("*", "cont");
            if (superuser != null && !superuser.equals("")) {
                sqlQueryObject2.addWhereCondition("superuser = ?");
            }
            if (tipo != null && !tipo.equals("")) {
                sqlQueryObject2.addWhereCondition("tipo = ?");
            }
            sqlQueryObject2.setANDLogicOperator(true);
            queryString = sqlQueryObject2.createSQLQuery();
        }
        stmt = con.prepareStatement(queryString);
        int index = 1;
        if (superuser != null && !superuser.equals("")) {
            stmt.setString(index++, superuser);
        }
        if (tipo != null && !tipo.equals("")) {
            stmt.setString(index++, tipo);
        }
        if ((risultato = stmt.executeQuery()).next()) {
            ricerca.setNumEntries(idLista, risultato.getInt(1));
        }
        risultato.close();
        stmt.close();
        if (limit == 0) {
            limit = 1000;
        }
        if (!search.equals("")) {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("pdd");
            sqlQueryObject.addSelectField("nome");
            if (superuser != null && !superuser.equals("")) {
                sqlQueryObject.addWhereCondition("superuser = ?");
            }
            if (tipo != null && !tipo.equals("")) {
                sqlQueryObject.addWhereCondition("tipo = ?");
            }
            sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("nome");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
        } else {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("pdd");
            sqlQueryObject.addSelectField("nome");
            if (superuser != null && !superuser.equals("")) {
                sqlQueryObject.addWhereCondition("superuser = ?");
            }
            if (tipo != null && !tipo.equals("")) {
                sqlQueryObject.addWhereCondition("tipo = ?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("nome");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
        }
        stmt = con.prepareStatement(queryString);
        index = 1;
        if (superuser != null && !superuser.equals("")) {
            stmt.setString(index++, superuser);
        }
        if (tipo != null && !tipo.equals("")) {
            stmt.setString(index++, tipo);
        }
        risultato = stmt.executeQuery();
        lista = new ArrayList<PortaDominio>();
        while (risultato.next()) {
            String nome = risultato.getString("nome");
            PortaDominio pdd = this.getPortaDominio(nome);
            lista.add(pdd);
        }
        ArrayList<PortaDominio> arrayList = lista;
        Object var18_20 = null;
        try {
            if (risultato != null) {
                risultato.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessioni al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return arrayList;
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                Object var18_21 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public boolean isPddInUso(PortaDominio pdd, List<String> whereIsInUso) throws DriverRegistroServiziException {
        String nomeMetodo = "pddInUso";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("soggetti");
        sqlQueryObject.addSelectField("*");
        sqlQueryObject.addWhereCondition("server = ?");
        String queryString = sqlQueryObject.createSQLQuery();
        stmt = con.prepareStatement(queryString);
        stmt.setString(1, pdd.getNome());
        risultato = stmt.executeQuery();
        boolean isInUso = false;
        while (risultato.next()) {
            String tipo_soggetto = risultato.getString("tipo_soggetto");
            String nome_soggetto = risultato.getString("nome_soggetto");
            whereIsInUso.add(tipo_soggetto + "/" + nome_soggetto);
            isInUso = true;
        }
        boolean bl = isInUso;
        Object var13_15 = null;
        try {
            if (risultato != null) {
                risultato.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessioni al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return bl;
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziException::" + nomeMetodo + "] Exception: " + se.getMessage());
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public List<SoggettoSpcoop> pddSoggettiList(int idPdd, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "pddSoggettiList";
        int idLista = 0;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        ArrayList<SoggettoSpcoop> lista = null;
        String nomePdd = "";
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("pdd");
        sqlQueryObject.addSelectField("*");
        sqlQueryObject.addWhereCondition("id = ?");
        String queryString = sqlQueryObject.createSQLQuery();
        stmt = con.prepareStatement(queryString);
        stmt.setInt(1, idPdd);
        risultato = stmt.executeQuery();
        if (risultato.next()) {
            nomePdd = risultato.getString("nome");
        }
        risultato.close();
        stmt.close();
        if (!search.equals("")) {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.addWhereCondition("server = ?");
            sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("nome_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("tipo_soggetto", search, true, true));
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
        } else {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.addWhereCondition("server = ?");
            queryString = sqlQueryObject.createSQLQuery();
        }
        stmt = con.prepareStatement(queryString);
        stmt.setString(1, nomePdd);
        risultato = stmt.executeQuery();
        if (risultato.next()) {
            ricerca.setNumEntries(idLista, risultato.getInt(1));
        }
        risultato.close();
        stmt.close();
        if (limit == 0) {
            limit = 1000;
        }
        if (!search.equals("")) {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("tipo_soggetto");
            sqlQueryObject.addSelectField("nome_soggetto");
            sqlQueryObject.addSelectField("server");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("server = ?");
            sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("nome_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("tipo_soggetto", search, true, true));
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("tipo_soggetto");
            sqlQueryObject.addOrderBy("nome_soggetto");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
        } else {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("tipo_soggetto");
            sqlQueryObject.addSelectField("nome_soggetto");
            sqlQueryObject.addSelectField("server");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("server = ?");
            sqlQueryObject.addOrderBy("tipo_soggetto");
            sqlQueryObject.addOrderBy("nome_soggetto");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
        }
        stmt = con.prepareStatement(queryString);
        stmt.setString(1, nomePdd);
        risultato = stmt.executeQuery();
        lista = new ArrayList<SoggettoSpcoop>();
        SoggettoSpcoop sog = null;
        while (risultato.next()) {
            long ids = risultato.getLong("id");
            sog = this.getSoggettoRegistro(ids, con);
            lista.add(sog);
        }
        ArrayList<SoggettoSpcoop> arrayList = lista;
        Object var19_20 = null;
        try {
            if (risultato != null) {
                risultato.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessioni al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return arrayList;
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                Object var19_21 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public List<IDSoggetto> getAllIdSoggettiErogatori(String tipoServizio, String nomeServizio, String uriAccordo, String nomePortType, String tipoSoggetto) throws DriverRegistroServiziException {
        String nomeMetodo = "getAllIdSoggettiErogatori";
        ArrayList<IDSoggetto> lista = new ArrayList<IDSoggetto>();
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        IDAccordo idAccordo = IDAccordo.getIDAccordoFromUri(uriAccordo);
        long idAccordoLong = DBUtils.getIdAccordoServizio(idAccordo, con, this.tipoDB);
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("servizi");
        sqlQueryObject.addFromTable("soggetti");
        sqlQueryObject.setANDLogicOperator(true);
        sqlQueryObject.addSelectAliasField("soggetti", "tipo_soggetto", "tipoSoggetto");
        sqlQueryObject.addSelectAliasField("soggetti", "nome_soggetto", "nomeSoggetto");
        sqlQueryObject.addWhereCondition("soggetti.id=servizi.id_soggetto");
        sqlQueryObject.addWhereCondition("servizi.tipo_servizio= ?");
        sqlQueryObject.addWhereCondition("servizi.nome_servizio= ?");
        sqlQueryObject.addWhereCondition("servizi.id_accordo = ?");
        sqlQueryObject.addWhereCondition("servizi.port_type = ?");
        if (tipoSoggetto != null) {
            sqlQueryObject.addWhereCondition("soggetti.tipo_soggetto = ?");
        }
        String queryString = sqlQueryObject.createSQLQuery();
        stmt = con.prepareStatement(queryString);
        stmt.setString(1, tipoServizio);
        stmt.setString(2, nomeServizio);
        stmt.setLong(3, idAccordoLong);
        stmt.setString(4, nomePortType);
        if (tipoSoggetto != null) {
            stmt.setString(5, tipoSoggetto);
        }
        risultato = stmt.executeQuery();
        while (risultato.next()) {
            String tipo_soggetto = risultato.getString("tipoSoggetto");
            String nome_soggetto = risultato.getString("nomeSoggetto");
            lista.add(new IDSoggetto(tipo_soggetto, nome_soggetto));
        }
        ArrayList<IDSoggetto> arrayList = lista;
        Object var19_19 = null;
        try {
            if (risultato != null) {
                risultato.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessioni al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return arrayList;
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziException::" + nomeMetodo + "] Exception: " + se.getMessage());
            }
            catch (Throwable throwable) {
                Object var19_20 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public PortType getPortType(IDPortType idPT) throws DriverRegistroServiziException {
        String nomeMetodo = "getPortType";
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        long idAccordoLong = DBUtils.getIdAccordoServizio(idPT.getIdAccordo(), con, this.tipoDB);
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("port_type");
        sqlQueryObject.setANDLogicOperator(true);
        sqlQueryObject.addWhereCondition("port_type.id_accordo=?");
        sqlQueryObject.addWhereCondition("port_type.nome=?");
        String queryString = sqlQueryObject.createSQLQuery();
        stmt = con.prepareStatement(queryString);
        stmt.setLong(1, idAccordoLong);
        stmt.setString(2, idPT.getNome());
        rs = stmt.executeQuery();
        PortType pt = null;
        if (rs.next()) {
            pt = new PortType();
            String tmp = rs.getString("nome");
            pt.setNome(tmp == null || tmp.equals("") ? null : tmp);
            tmp = rs.getString("descrizione");
            pt.setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
            tmp = rs.getString("profilo_collaborazione");
            pt.setProfiloCollaborazione(tmp == null || tmp.equals("") ? null : tmp);
            tmp = rs.getString("filtro_duplicati");
            pt.setFiltroDuplicati(tmp == null || tmp.equals("") ? null : tmp);
            tmp = rs.getString("conferma_ricezione");
            pt.setConfermaRicezione(tmp == null || tmp.equals("") ? null : tmp);
            tmp = rs.getString("identificativo_collaborazione");
            pt.setIdCollaborazione(tmp == null || tmp.equals("") ? null : tmp);
            tmp = rs.getString("consegna_in_ordine");
            pt.setConsegnaInOrdine(tmp == null || tmp.equals("") ? null : tmp);
            tmp = rs.getString("scadenza");
            pt.setScadenza(tmp == null || tmp.equals("") ? null : tmp);
            tmp = rs.getString("profilo_pt");
            if (tmp == null || tmp.equals("")) {
                pt.setProfiloPT("default");
            } else {
                pt.setProfiloPT(tmp);
            }
            tmp = rs.getString("soap_style");
            pt.setStyle(tmp == null || tmp.equals("") ? null : tmp);
            pt.setIdAccordo(idAccordoLong);
            long idPortType = rs.getLong("id");
            pt.setId(idPortType);
            this.readAzioniPortTypes(pt, con);
        }
        PortType portType = pt;
        Object var15_14 = null;
        try {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessioni al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return portType;
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziException::" + nomeMetodo + "] Exception: " + se.getMessage());
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public Vector<IDServizio> getIdServiziSPCoopWithPortType(IDPortType idPT) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        String nomeMetodo = "getIdServiziSPCoopWithPortType";
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        Vector<IDServizio> idServiziSPCoop = new Vector<IDServizio>();
        long idAccordoLong = DBUtils.getIdAccordoServizio(idPT.getIdAccordo(), con, this.tipoDB);
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("servizi");
        sqlQueryObject.addFromTable("soggetti");
        sqlQueryObject.addSelectField("nome_servizio");
        sqlQueryObject.addSelectField("tipo_servizio");
        sqlQueryObject.addSelectField("nome_soggetto");
        sqlQueryObject.addSelectField("tipo_soggetto");
        sqlQueryObject.setANDLogicOperator(true);
        sqlQueryObject.addWhereCondition("servizi.id_accordo=?");
        sqlQueryObject.addWhereCondition("servizi.port_type=?");
        sqlQueryObject.addWhereCondition("servizi.id_soggetto=soggetti.id");
        String queryString = sqlQueryObject.createSQLQuery();
        stmt = con.prepareStatement(queryString);
        stmt.setLong(1, idAccordoLong);
        stmt.setString(2, idPT.getNome());
        rs = stmt.executeQuery();
        while (rs.next()) {
            IDServizio idServizio = new IDServizio(rs.getString("tipo_soggetto"), rs.getString("nome_soggetto"), rs.getString("tipo_servizio"), rs.getString("nome_servizio"));
            idServiziSPCoop.add(idServizio);
        }
        if (idServiziSPCoop.size() <= 0) {
            throw new DriverRegistroServiziNotFound("Servizi non trovato che implementano il servizio " + idPT.getNome() + " dell'accordo di servizio " + idPT.getIdAccordo().toString());
        }
        Vector<IDServizio> vector = idServiziSPCoop;
        Object var13_14 = null;
        try {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessioni al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        {
            return vector;
            catch (DriverRegistroServiziNotFound dNot) {
                throw dNot;
            }
            catch (Exception se) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziException::" + nomeMetodo + "] Exception: " + se.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public Vector<IDServizio> getIdServiziSPCoopWithAccordo(IDAccordo idAccordo, boolean checkPTisNull) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        String nomeMetodo = "getIdServiziSPCoopWithPortType";
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        Vector<IDServizio> idServiziSPCoop = new Vector<IDServizio>();
        long idAccordoLong = DBUtils.getIdAccordoServizio(idAccordo, con, this.tipoDB);
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("servizi");
        sqlQueryObject.addFromTable("soggetti");
        sqlQueryObject.addSelectField("nome_servizio");
        sqlQueryObject.addSelectField("tipo_servizio");
        sqlQueryObject.addSelectField("nome_soggetto");
        sqlQueryObject.addSelectField("tipo_soggetto");
        sqlQueryObject.setANDLogicOperator(true);
        sqlQueryObject.addWhereCondition("servizi.id_accordo=?");
        sqlQueryObject.addWhereCondition("servizi.id_soggetto=soggetti.id");
        if (checkPTisNull) {
            sqlQueryObject.addWhereCondition("servizi.port_type is null");
        }
        String queryString = sqlQueryObject.createSQLQuery();
        stmt = con.prepareStatement(queryString);
        stmt.setLong(1, idAccordoLong);
        rs = stmt.executeQuery();
        while (rs.next()) {
            IDServizio idServizio = new IDServizio(rs.getString("tipo_soggetto"), rs.getString("nome_soggetto"), rs.getString("tipo_servizio"), rs.getString("nome_servizio"));
            idServiziSPCoop.add(idServizio);
        }
        if (idServiziSPCoop.size() <= 0) {
            throw new DriverRegistroServiziNotFound("Servizi non trovato che implementano l'accordo di servizio " + idAccordo.toString());
        }
        Vector<IDServizio> vector = idServiziSPCoop;
        Object var14_15 = null;
        try {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessioni al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        {
            return vector;
            catch (DriverRegistroServiziNotFound dNot) {
                throw dNot;
            }
            catch (Exception se) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziException::" + nomeMetodo + "] Exception: " + se.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    public boolean isUnicaAzioneInAccordi(String azione) throws DriverRegistroServiziException {
        String nomeMetodo = "isUnicaAzioneInAccordi";
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("accordi_azioni");
        sqlQueryObject.addSelectCountField("nome", "countAzioni");
        sqlQueryObject.addWhereCondition("accordi_azioni.nome=?");
        String queryString = sqlQueryObject.createSQLQuery();
        stmt = con.prepareStatement(queryString);
        stmt.setString(1, azione);
        rs = stmt.executeQuery();
        int count = 0;
        if (!rs.next()) {
            throw new Exception("Azione [" + azione + "] non trovata (rs.next fallita)");
        }
        count = rs.getInt("countAzioni");
        rs.close();
        stmt.close();
        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("port_type_azioni");
        sqlQueryObject.addSelectCountField("nome", "countAzioni");
        sqlQueryObject.addWhereCondition("port_type_azioni.nome=?");
        queryString = sqlQueryObject.createSQLQuery();
        stmt = con.prepareStatement(queryString);
        stmt.setString(1, azione);
        rs = stmt.executeQuery();
        if (!rs.next()) {
            throw new Exception("Azione [" + azione + "] non trovata (rs.next fallita pt)");
        }
        if ((count += rs.getInt("countAzioni")) <= 0) {
            throw new Exception("Azione [" + azione + "] non trovata");
        }
        boolean bl = count == 1;
        Object var11_12 = null;
        try {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessioni al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return bl;
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziException::" + nomeMetodo + "] Exception: " + se.getMessage());
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public boolean existsDocumento(String nome, String tipo, String ruolo, long idProprietario, ProprietariDocumento proprietarioDocumento) throws DriverRegistroServiziException {
        boolean exist;
        block22: {
            Connection connection;
            exist = false;
            Statement stm = null;
            ResultSet rs = null;
            if (this.atomica) {
                try {
                    connection = this.datasource.getConnection();
                    connection.setAutoCommit(false);
                }
                catch (SQLException e) {
                    throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsDocumento] SQLException accedendo al datasource :" + e.getMessage());
                }
            } else {
                connection = this.globalConnection;
            }
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("documenti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_proprietario = ?");
            sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.addWhereCondition("tipo = ?");
            sqlQueryObject.addWhereCondition("ruolo = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idProprietario);
            stm.setString(2, proprietarioDocumento.toString());
            stm.setString(3, nome);
            stm.setString(4, tipo);
            stm.setString(5, ruolo);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
            Object var14_14 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.atomica) {
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
            break block22;
            {
                catch (Exception e) {
                    exist = false;
                    throw new DriverRegistroServiziException(e);
                }
            }
            catch (Throwable throwable) {
                Object var14_15 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (this.atomica) {
                    try {
                        connection.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return exist;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Documento getDocumento(String nome, String tipo, String ruolo, long idProprietario, boolean readBytes, ProprietariDocumento tipoProprietario) throws DriverRegistroServiziException {
        Documento documento;
        String nomeMetodo = "getDocumento";
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            try {
                long idDoc = DBUtils.getIdDocumento(nome, tipo, ruolo, idProprietario, con, this.tipoDB, tipoProprietario);
                documento = DriverRegistroServiziDB_LIB.getDocumento(idDoc, readBytes, con);
                Object var14_13 = null;
            }
            catch (Exception se) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziException::" + nomeMetodo + "] Exception: " + se.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            try {
                if (!this.atomica) throw throwable;
                this.log.debug((Object)"rilascio connessioni al db...");
                con.close();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return documento;
        }
        if (!this.atomica) return documento;
        this.log.debug((Object)"rilascio connessioni al db...");
        con.close();
        return documento;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Documento getDocumento(long idDocumento, boolean readBytes) throws DriverRegistroServiziException {
        Documento e2;
        String nomeMetodo = "getDocumento";
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e2) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e2.getMessage(), e2);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            try {
                e2 = DriverRegistroServiziDB_LIB.getDocumento(idDocumento, readBytes, con);
                Object var8_8 = null;
            }
            catch (Exception se) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziException::" + nomeMetodo + "] Exception: " + se.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (!this.atomica) throw throwable;
                this.log.debug((Object)"rilascio connessioni al db...");
                con.close();
                throw throwable;
            }
            catch (Exception e2) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e2) {
            // empty catch block
            return e2;
        }
        if (!this.atomica) return e2;
        this.log.debug((Object)"rilascio connessioni al db...");
        con.close();
        return e2;
    }

    /*
     * Loose catch block
     */
    public List<Documento> serviziAllegatiList(int idServizio, ISearch ricerca) throws DriverRegistroServiziException {
        String queryString;
        ISQLQueryObject sqlQueryObject;
        String nomeMetodo = "serviziAllegatiList";
        int idLista = 35;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<Documento> lista = new ArrayList<Documento>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        if (!search.equals("")) {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("documenti");
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.addWhereCondition("id_proprietario = ?");
            sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
            sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("roulo", search, true, true), sqlQueryObject.getWhereLikeCondition("nome", search, true, true));
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
        } else {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("documenti");
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.addWhereCondition("id_proprietario = ?");
            sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
        }
        stmt = con.prepareStatement(queryString);
        stmt.setInt(1, idServizio);
        stmt.setString(2, ProprietariDocumento.servizio.toString());
        risultato = stmt.executeQuery();
        if (risultato.next()) {
            ricerca.setNumEntries(idLista, risultato.getInt("cont"));
        }
        risultato.close();
        stmt.close();
        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("documenti");
        sqlQueryObject.addSelectField("id");
        sqlQueryObject.addSelectField("nome");
        sqlQueryObject.addSelectField("ruolo");
        sqlQueryObject.addSelectField("id_proprietario");
        sqlQueryObject.addSelectField("tipo_proprietario");
        sqlQueryObject.addWhereCondition("id_proprietario = ?");
        sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
        if (limit == 0) {
            limit = 1000;
        }
        if (!search.equals("")) {
            sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("roulo", search, true, true), sqlQueryObject.getWhereLikeCondition("nome", search, true, true));
        }
        sqlQueryObject.setANDLogicOperator(true);
        sqlQueryObject.addOrderBy("nome");
        sqlQueryObject.setSortType(true);
        sqlQueryObject.setLimit(limit);
        sqlQueryObject.setOffset(offset);
        queryString = sqlQueryObject.createSQLQuery();
        stmt = con.prepareStatement(queryString);
        stmt.setInt(1, idServizio);
        stmt.setString(2, ProprietariDocumento.servizio.toString());
        risultato = stmt.executeQuery();
        while (risultato.next()) {
            Documento doc = DriverRegistroServiziDB_LIB.getDocumento(risultato.getLong("id"), false, con);
            lista.add(doc);
        }
        ArrayList<Documento> arrayList = lista;
        Object var16_17 = null;
        try {
            if (risultato != null) {
                risultato.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessioni al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return arrayList;
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                Object var16_18 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    public void validaStatoAccordoServizio(AccordoServizio as, boolean lineeGuida11) throws ValidazioneStatoPackageException {
        ValidazioneStatoPackageException erroreValidazione;
        block47: {
            erroreValidazione = new ValidazioneStatoPackageException("AccordoServizio", as.getStatoPackage(), null);
            try {
                if (!as.getPrivato().booleanValue() && as.getSoggettoReferente() != null) {
                    IDSoggetto idS = new IDSoggetto(as.getSoggettoReferente().getTipo(), as.getSoggettoReferente().getNome());
                    try {
                        SoggettoSpcoop s = this.getSoggettoRegistro(idS);
                        if (s.getPrivato().booleanValue()) {
                            erroreValidazione.addErroreValidazione("soggetto referente [" + idS + "] con visibilita' privata, in un accordo di servizio con visibilita' pubblica");
                        }
                    }
                    catch (DriverRegistroServiziNotFound dNot) {
                        // empty catch block
                    }
                }
                if (as.getServizioComposto() != null) {
                    if (as.getServizioComposto().getIdAccordoCooperazione() > 0L) {
                        try {
                            AccordoCooperazione ac = this.getAccordoCooperazione(as.getServizioComposto().getIdAccordoCooperazione());
                            if (!as.getPrivato().booleanValue() && ac.getPrivato().booleanValue()) {
                                erroreValidazione.addErroreValidazione("accordo di cooperazione [" + IDAccordoCooperazione.getUriFromAccordo(ac) + "] con visibilita' privata, in un accordo di servizio con visibilita' pubblica");
                            }
                        }
                        catch (DriverRegistroServiziNotFound dNot) {
                            // empty catch block
                        }
                    }
                    if (as.getServizioComposto().sizeServizioComponenteList() >= 2) {
                        for (int i = 0; i < as.getServizioComposto().sizeServizioComponenteList(); ++i) {
                            if (as.getServizioComposto().getServizioComponente(i).getId() <= 0L) continue;
                            try {
                                ServizioSpcoop sc = this.getServizioSpcoop(as.getServizioComposto().getServizioComponente(i).getId());
                                if (as.getPrivato().booleanValue() || !sc.getPrivato().booleanValue()) continue;
                                erroreValidazione.addErroreValidazione("servizio componente [" + sc.getTipo() + "/" + sc.getNome() + "_" + sc.getTipoSoggettoErogatore() + "/" + sc.getNomeSoggettoErogatore() + "] con visibilita' privata, in un accordo di servizio con visibilita' pubblica");
                                continue;
                            }
                            catch (DriverRegistroServiziNotFound dNot) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (StatiAccordo.bozza.toString().equals(as.getStatoPackage())) break block47;
                if (lineeGuida11) {
                    if (as.sizePortTypeList() == 0) {
                        erroreValidazione.addErroreValidazione("non sono definiti Servizi");
                    }
                    for (int j = 0; j < as.sizePortTypeList(); ++j) {
                        if (as.getPortType(j).sizeAzioneList() != 0) continue;
                        erroreValidazione.addErroreValidazione("servizio[" + as.getPortType(j).getNome() + "] non possiede azioni");
                    }
                } else {
                    if (as.sizePortTypeList() == 0 && as.sizeAzioneList() == 0 && !as.getUtilizzoSenzaAzione()) {
                        erroreValidazione.addErroreValidazione("non sono definite ne Azioni (utilizzoSenzaAzione=false) ne Servizi");
                    }
                    if (as.sizePortTypeList() != 0) {
                        for (int j = 0; j < as.sizePortTypeList(); ++j) {
                            if (as.getPortType(j).sizeAzioneList() != 0) continue;
                            erroreValidazione.addErroreValidazione("servizio[" + as.getPortType(j).getNome() + "] non possiede azioni");
                        }
                    }
                    if (as.sizePortTypeList() != 0) {
                        for (int j = 0; j < as.sizePortTypeList(); ++j) {
                            PortType pt = as.getPortType(j);
                            for (int k = 0; k < pt.sizeAzioneList(); ++k) {
                                Operation op = pt.getAzione(k);
                                String profiloCollaborazioneOP = op.getProfiloCollaborazione();
                                if ("default".equals(op.getProfAzione())) {
                                    profiloCollaborazioneOP = pt.getProfiloCollaborazione();
                                    if ("default".equals(pt.getProfiloPT())) {
                                        profiloCollaborazioneOP = as.getProfiloCollaborazione();
                                    }
                                }
                                if (!"asincronoAsimmetrico".equals(profiloCollaborazioneOP) && !"asincronoSimmetrico".equals(profiloCollaborazioneOP) || op.getCorrelata() != null) continue;
                                boolean trovataCorrelazione = false;
                                block17: for (int verificaPTIndex = 0; verificaPTIndex < as.sizePortTypeList(); ++verificaPTIndex) {
                                    PortType ptVerifica = as.getPortType(verificaPTIndex);
                                    for (int verificaOPIndex = 0; verificaOPIndex < ptVerifica.sizeAzioneList(); ++verificaOPIndex) {
                                        Operation opVerifica = ptVerifica.getAzione(verificaOPIndex);
                                        if (opVerifica.getCorrelata() == null || !opVerifica.getCorrelata().equals(op.getNome())) continue;
                                        if (opVerifica.getCorrelataServizio() == null) {
                                            if (!"asincronoAsimmetrico".equals(profiloCollaborazioneOP) || !ptVerifica.getNome().equals(pt.getNome())) continue;
                                            trovataCorrelazione = true;
                                            continue block17;
                                        }
                                        if (!opVerifica.getCorrelataServizio().equals(pt.getNome())) continue;
                                        trovataCorrelazione = true;
                                        continue block17;
                                    }
                                }
                                if (trovataCorrelazione) continue;
                                erroreValidazione.addErroreValidazione("L'azione [" + op.getNome() + "] del servizio[" + as.getPortType(j).getNome() + "] non risulta correlata da altre azioni");
                            }
                        }
                    }
                }
                if (!StatiAccordo.finale.toString().equals(as.getStatoPackage())) break block47;
                String wsdlConcettuale = as.getByteWsdlConcettuale() != null ? new String(as.getByteWsdlConcettuale()) : null;
                String wsdlLogicoErogatore = as.getByteWsdlLogicoErogatore() != null ? new String(as.getByteWsdlLogicoErogatore()) : null;
                wsdlConcettuale = wsdlConcettuale != null && !"".equals(wsdlConcettuale.trim().replaceAll("\n", "")) ? wsdlConcettuale : null;
                String string = wsdlLogicoErogatore = wsdlLogicoErogatore != null && !"".equals(wsdlLogicoErogatore.trim().replaceAll("\n", "")) ? wsdlLogicoErogatore : null;
                if (wsdlConcettuale == null) {
                    erroreValidazione.addErroreValidazione("interfaccia WSDL Concettuale non definita");
                }
                if (wsdlLogicoErogatore == null) {
                    erroreValidazione.addErroreValidazione("interfaccia WSDL LogicoErogatore non definita");
                }
                if (as.getServizioComposto() == null) break block47;
                if (as.getServizioComposto().getIdAccordoCooperazione() <= 0L) {
                    erroreValidazione.addErroreValidazione("accordo di cooperazione (id) non definito");
                } else {
                    try {
                        AccordoCooperazione ac = this.getAccordoCooperazione(as.getServizioComposto().getIdAccordoCooperazione());
                        if (!StatiAccordo.finale.toString().equals(ac.getStatoPackage())) {
                            erroreValidazione.addErroreValidazione("accordo di cooperazione [" + IDAccordoCooperazione.getUriFromAccordo(ac) + "] in uno stato non finale [" + ac.getStatoPackage() + "]");
                        }
                    }
                    catch (DriverRegistroServiziNotFound dNot) {
                        erroreValidazione.addErroreValidazione("accordo di cooperazione non definito");
                    }
                }
                if (as.getServizioComposto().sizeSpecificaCoordinamentoList() <= 0) {
                    erroreValidazione.addErroreValidazione("specifica di coordinamento non definita");
                }
                if (as.getServizioComposto().sizeServizioComponenteList() <= 0) {
                    erroreValidazione.addErroreValidazione("servizi componenti non definiti");
                } else if (as.getServizioComposto().sizeServizioComponenteList() < 2) {
                    erroreValidazione.addErroreValidazione("almeno 2 servizi componenti sono necessari per realizzare un servizio composto");
                } else {
                    for (int i = 0; i < as.getServizioComposto().sizeServizioComponenteList(); ++i) {
                        if (as.getServizioComposto().getServizioComponente(i).getIdServizioComponente() <= 0L) {
                            erroreValidazione.addErroreValidazione("servizio componente [" + i + "] (id) non definito");
                            continue;
                        }
                        try {
                            ServizioSpcoop sc = this.getServizioSpcoop(as.getServizioComposto().getServizioComponente(i).getIdServizioComponente());
                            if (StatiAccordo.finale.toString().equals(sc.getStatoPackage())) continue;
                            erroreValidazione.addErroreValidazione("servizio componente [" + sc.getTipo() + "/" + sc.getNome() + "_" + sc.getTipoSoggettoErogatore() + "/" + sc.getNomeSoggettoErogatore() + "] in uno stato non finale [" + sc.getStatoPackage() + "]");
                            continue;
                        }
                        catch (DriverRegistroServiziNotFound dNot) {
                            erroreValidazione.addErroreValidazione("servizio componente [" + i + "] non definito");
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new ValidazioneStatoPackageException(e);
            }
        }
        if (erroreValidazione.sizeErroriValidazione() > 0) {
            throw erroreValidazione;
        }
    }

    public void validaStatoAccordoCooperazione(AccordoCooperazione ac) throws ValidazioneStatoPackageException {
        ValidazioneStatoPackageException erroreValidazione = new ValidazioneStatoPackageException("AccordoCooperazione", ac.getStatoPackage(), null);
        try {
            SoggettoSpcoop s;
            if (!ac.getPrivato().booleanValue() && ac.getSoggettoReferente() != null) {
                IDSoggetto idS = new IDSoggetto(ac.getSoggettoReferente().getTipo(), ac.getSoggettoReferente().getNome());
                try {
                    s = this.getSoggettoRegistro(idS);
                    if (s.getPrivato().booleanValue()) {
                        erroreValidazione.addErroreValidazione("soggetto referente [" + idS + "] con visibilita' privata, in un accordo di cooperazione con visibilita' pubblica");
                    }
                }
                catch (DriverRegistroServiziNotFound dNot) {
                    // empty catch block
                }
            }
            if (ac.sizeElencoPartecipantiList() >= 2) {
                for (int i = 0; i < ac.sizeElencoPartecipantiList(); ++i) {
                    if (ac.getElencoPartecipanti(i).getIdSoggetto() <= 0L) continue;
                    try {
                        s = this.getSoggettoRegistro(ac.getElencoPartecipanti(i).getIdSoggetto());
                        if (!s.getPrivato().booleanValue()) continue;
                        erroreValidazione.addErroreValidazione("soggetto partecipante [" + s.getTipo() + "/" + s.getNome() + "] con visibilita' privata, in un accordo di cooperazione con visibilita' pubblica");
                        continue;
                    }
                    catch (DriverRegistroServiziNotFound dNot) {
                        // empty catch block
                    }
                }
            }
            if (!StatiAccordo.bozza.toString().equals(ac.getStatoPackage())) {
                if (ac.sizeElencoPartecipantiList() <= 0) {
                    erroreValidazione.addErroreValidazione("soggetti partecipanti non definiti");
                } else if (ac.sizeElencoPartecipantiList() < 2) {
                    erroreValidazione.addErroreValidazione("almeno 2 soggetti partecipanti devono essere definiti");
                }
            }
        }
        catch (Exception e) {
            throw new ValidazioneStatoPackageException(e);
        }
        if (erroreValidazione.sizeErroriValidazione() > 0) {
            throw erroreValidazione;
        }
    }

    public void validaStatoServizioSPCoop(ServizioSpcoop servizio) throws ValidazioneStatoPackageException {
        ValidazioneStatoPackageException erroreValidazione;
        block18: {
            erroreValidazione = new ValidazioneStatoPackageException("ServizioSpcoop", servizio.getStatoPackage(), null);
            try {
                SoggettoSpcoop soggettoErogatore;
                if (!servizio.getPrivato().booleanValue()) {
                    IDSoggetto idS = new IDSoggetto(servizio.getTipoSoggettoErogatore(), servizio.getNomeSoggettoErogatore());
                    try {
                        SoggettoSpcoop s = this.getSoggettoRegistro(idS);
                        if (s.getPrivato().booleanValue()) {
                            erroreValidazione.addErroreValidazione("soggetto erogatore [" + idS + "] con visibilita' privata, in un servizio con visibilita' pubblica");
                        }
                    }
                    catch (DriverRegistroServiziNotFound dNot) {
                        // empty catch block
                    }
                    try {
                        AccordoServizio as = this.getAccordoServizio(IDAccordo.getIDAccordoFromUri(servizio.getAccordoServizio()));
                        if (as.getPrivato().booleanValue()) {
                            erroreValidazione.addErroreValidazione("accordo di servizio [" + servizio.getAccordoServizio() + "] con visibilita' privata, in un servizio con visibilita' pubblica");
                        }
                    }
                    catch (DriverRegistroServiziNotFound dNot) {
                        // empty catch block
                    }
                }
                if (StatiAccordo.bozza.toString().equals(servizio.getStatoPackage()) || !StatiAccordo.finale.toString().equals(servizio.getStatoPackage())) break block18;
                try {
                    AccordoServizio as = this.getAccordoServizio(IDAccordo.getIDAccordoFromUri(servizio.getAccordoServizio()));
                    if (!StatiAccordo.finale.toString().equals(as.getStatoPackage())) {
                        erroreValidazione.addErroreValidazione("accordo di servizio [" + IDAccordo.getUriFromAccordo(as) + "] in uno stato non finale [" + as.getStatoPackage() + "]");
                    }
                }
                catch (DriverRegistroServiziNotFound dNot) {
                    erroreValidazione.addErroreValidazione("accordo di servizio non definito");
                }
                if (servizio.getServizioCorrelato()) {
                    String wsdlImplementativoFruitore = servizio.getByteWsdlImplementativoFruitore() != null ? new String(servizio.getByteWsdlImplementativoFruitore()) : null;
                    String string = wsdlImplementativoFruitore = wsdlImplementativoFruitore != null && !"".equals(wsdlImplementativoFruitore.trim().replaceAll("\n", "")) ? wsdlImplementativoFruitore : null;
                    if (wsdlImplementativoFruitore == null) {
                        erroreValidazione.addErroreValidazione("WSDL Implementativo fruitore non definito");
                    }
                } else {
                    String wsdlImplementativoErogatore = servizio.getByteWsdlImplementativoErogatore() != null ? new String(servizio.getByteWsdlImplementativoErogatore()) : null;
                    String string = wsdlImplementativoErogatore = wsdlImplementativoErogatore != null && !"".equals(wsdlImplementativoErogatore.trim().replaceAll("\n", "")) ? wsdlImplementativoErogatore : null;
                    if (wsdlImplementativoErogatore == null) {
                        erroreValidazione.addErroreValidazione("WSDL Implementativo erogatore non definito");
                    }
                }
                if ((servizio.getConnettore() == null || "disabilitato".equals(servizio.getConnettore().getTipo())) && ((soggettoErogatore = this.getSoggettoRegistro(new IDSoggetto(servizio.getTipoSoggettoErogatore(), servizio.getNomeSoggettoErogatore()))).getConnettore() == null || "disabilitato".equals(soggettoErogatore.getConnettore().getTipo()))) {
                    erroreValidazione.addErroreValidazione("Sia l'Accordo di servizio parte specifica che il soggetto erogatore non possiedono un connettore");
                }
            }
            catch (Exception e) {
                throw new ValidazioneStatoPackageException(e);
            }
        }
        if (erroreValidazione.sizeErroriValidazione() > 0) {
            throw erroreValidazione;
        }
    }

    public void validaStatoFruitoreServizioSPCoop(Fruitore fruitore, ServizioSpcoop serv) throws ValidazioneStatoPackageException {
        ValidazioneStatoPackageException erroreValidazione = new ValidazioneStatoPackageException("FruitoreServizioSpcoop", fruitore.getStatoPackage(), null);
        try {
            if (!StatiAccordo.bozza.toString().equals(fruitore.getStatoPackage()) && StatiAccordo.finale.toString().equals(fruitore.getStatoPackage()) && !StatiAccordo.finale.toString().equals(serv.getStatoPackage())) {
                erroreValidazione.addErroreValidazione("servizio [" + serv.getTipo() + "/" + serv.getNome() + "] erogato dal soggetto [" + serv.getTipoSoggettoErogatore() + "/" + serv.getNomeSoggettoErogatore() + "] in uno stato non finale [" + serv.getStatoPackage() + "]");
            }
        }
        catch (Exception e) {
            throw new ValidazioneStatoPackageException(e);
        }
        if (erroreValidazione.sizeErroriValidazione() > 0) {
            throw erroreValidazione;
        }
    }

    /*
     * Loose catch block
     */
    public List<AccordoServizio> accordiCompatibiliList(ISearch ricerca) throws DriverRegistroServiziException {
        ArrayList<AccordoServizio> lista;
        block30: {
            String queryString;
            String nomeMetodo = "accordiCompatibiliList";
            int idLista = 17;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
            ricerca.getSearchString(idLista);
            this.log.debug((Object)("search : " + search));
            Connection con = null;
            Statement stmt = null;
            ResultSet risultato = null;
            lista = new ArrayList<AccordoServizio>();
            if (this.atomica) {
                try {
                    con = this.datasource.getConnection();
                }
                catch (SQLException e) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.globalConnection;
            }
            this.log.debug((Object)("operazione this.atomica = " + this.atomica));
            ISQLQueryObject sqlquery = DriverRegistroServiziDB_LIB.getSQLRicercaAccordiValidi();
            sqlquery.setANDLogicOperator(true);
            ISQLQueryObject sqlQueryObjectSoggetti = null;
            if (!search.equals("")) {
                sqlQueryObjectSoggetti = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObjectSoggetti.addFromTable("soggetti");
                sqlQueryObjectSoggetti.addSelectField("soggetti", "nome_soggetto");
                sqlQueryObjectSoggetti.addWhereCondition(true, sqlQueryObjectSoggetti.getWhereLikeCondition("nome_soggetto", search, true, true), "accordi.id_referente=soggetti.id");
            }
            if (!search.equals("")) {
                sqlquery.addSelectCountField("*", "cont");
                sqlquery.addWhereCondition(false, sqlquery.getWhereLikeCondition("nome", search, true, true), sqlquery.getWhereLikeCondition("versione", search, true, true), sqlquery.getWhereExistsCondition(false, sqlQueryObjectSoggetti));
                queryString = sqlquery.createSQLQuery();
            } else {
                sqlquery.addSelectCountField("*", "cont");
                queryString = sqlquery.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            sqlquery = DriverRegistroServiziDB_LIB.getSQLRicercaAccordiValidi();
            sqlquery.setANDLogicOperator(true);
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlquery.addSelectField("id");
                sqlquery.addSelectField("nome");
                sqlquery.addSelectField("descrizione");
                sqlquery.addSelectField("id_referente");
                sqlquery.addSelectField("versione");
                sqlquery.addSelectField("stato");
                sqlquery.addWhereCondition(false, sqlquery.getWhereLikeCondition("nome", search, true, true), sqlquery.getWhereLikeCondition("versione", search, true, true), sqlquery.getWhereExistsCondition(false, sqlQueryObjectSoggetti));
                sqlquery.addOrderBy("nome");
                sqlquery.addOrderBy("versione");
                sqlquery.addOrderBy("id_referente");
                sqlquery.setSortType(true);
                sqlquery.setLimit(limit);
                sqlquery.setOffset(offset);
                queryString = sqlquery.createSQLQuery();
            } else {
                sqlquery.addSelectField("id");
                sqlquery.addSelectField("nome");
                sqlquery.addSelectField("descrizione");
                sqlquery.addSelectField("id_referente");
                sqlquery.addSelectField("versione");
                sqlquery.addSelectField("stato");
                sqlquery.addOrderBy("nome");
                sqlquery.addOrderBy("versione");
                sqlquery.addOrderBy("id_referente");
                sqlquery.setSortType(true);
                sqlquery.setLimit(limit);
                sqlquery.setOffset(offset);
                queryString = sqlquery.createSQLQuery();
            }
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(queryString, new Object[0])));
            stmt = con.prepareStatement(queryString);
            risultato = stmt.executeQuery();
            AccordoServizio accordo = null;
            while (risultato.next()) {
                accordo = new AccordoServizio();
                accordo.setId(risultato.getLong("id"));
                accordo.setNome(risultato.getString("nome"));
                accordo.setDescrizione(risultato.getString("descrizione"));
                accordo.setStatoPackage(risultato.getString("stato"));
                accordo.setVersione(risultato.getString("versione"));
                if (risultato.getInt("id_referente") > 0) {
                    SoggettoSpcoop soggRef = this.getSoggettoRegistro(new Long(risultato.getInt("id_referente")), con);
                    AccordoServizioSoggettoReferente assr = new AccordoServizioSoggettoReferente();
                    assr.setTipo(soggRef.getTipo());
                    assr.setNome(soggRef.getNome());
                    accordo.setSoggettoReferente(assr);
                }
                lista.add(accordo);
                this.readAccordoServizioComposto(accordo, con);
            }
            Object var18_19 = null;
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
                break block30;
            }
            catch (Exception e) {}
            break block30;
            {
                catch (Exception se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
                }
            }
            catch (Throwable throwable) {
                Object var18_20 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return lista;
    }

    /*
     * Loose catch block
     */
    public List<PortType> accordiPorttypeCompatibiliList(int idAccordo, boolean isErogazione, ISearch ricerca) throws DriverRegistroServiziException {
        String queryString;
        String nomeMetodo = "accordiPorttypeCompatibiliList";
        int idLista = 30;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<PortType> lista = new ArrayList<PortType>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        ISQLQueryObject sqlquery = DriverRegistroServiziDB_LIB.getSQLRicercaServiziValidiByIdAccordo(isErogazione);
        sqlquery.setANDLogicOperator(true);
        if (!search.equals("")) {
            sqlquery.addSelectCountField("*", "cont");
            sqlquery.addWhereLikeCondition("nome", search, true, true);
            sqlquery.setANDLogicOperator(true);
            queryString = sqlquery.createSQLQuery();
        } else {
            sqlquery.addSelectCountField("*", "cont");
            queryString = sqlquery.createSQLQuery();
        }
        stmt = con.prepareStatement(queryString);
        stmt.setInt(1, idAccordo);
        risultato = stmt.executeQuery();
        if (risultato.next()) {
            ricerca.setNumEntries(idLista, risultato.getInt("cont"));
        }
        risultato.close();
        stmt.close();
        sqlquery = DriverRegistroServiziDB_LIB.getSQLRicercaServiziValidiByIdAccordo(isErogazione);
        sqlquery.setANDLogicOperator(true);
        if (limit == 0) {
            limit = 1000;
        }
        if (!search.equals("")) {
            sqlquery.addSelectField("id_accordo");
            sqlquery.addSelectField("nome");
            sqlquery.addSelectField("descrizione");
            sqlquery.addSelectField("profilo_collaborazione");
            sqlquery.addSelectField("filtro_duplicati");
            sqlquery.addSelectField("conferma_ricezione");
            sqlquery.addSelectField("identificativo_collaborazione");
            sqlquery.addSelectField("consegna_in_ordine");
            sqlquery.addSelectField("scadenza");
            sqlquery.addSelectField("profilo_pt");
            sqlquery.addSelectField("soap_style");
            sqlquery.addSelectField("id");
            sqlquery.addWhereLikeCondition("nome", search, true, true);
            sqlquery.setANDLogicOperator(true);
            sqlquery.addOrderBy("nome");
            sqlquery.setSortType(true);
            sqlquery.setLimit(limit);
            sqlquery.setOffset(offset);
            queryString = sqlquery.createSQLQuery();
        } else {
            sqlquery.addSelectField("id_accordo");
            sqlquery.addSelectField("nome");
            sqlquery.addSelectField("descrizione");
            sqlquery.addSelectField("profilo_collaborazione");
            sqlquery.addSelectField("filtro_duplicati");
            sqlquery.addSelectField("conferma_ricezione");
            sqlquery.addSelectField("identificativo_collaborazione");
            sqlquery.addSelectField("consegna_in_ordine");
            sqlquery.addSelectField("scadenza");
            sqlquery.addSelectField("profilo_pt");
            sqlquery.addSelectField("soap_style");
            sqlquery.addSelectField("id");
            sqlquery.addOrderBy("nome");
            sqlquery.setSortType(true);
            sqlquery.setLimit(limit);
            sqlquery.setOffset(offset);
            queryString = sqlquery.createSQLQuery();
        }
        stmt = con.prepareStatement(queryString);
        stmt.setInt(1, idAccordo);
        risultato = stmt.executeQuery();
        while (risultato.next()) {
            PortType pt = new PortType();
            String tmp = risultato.getString("nome");
            pt.setNome(tmp == null || tmp.equals("") ? null : tmp);
            tmp = risultato.getString("descrizione");
            pt.setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
            tmp = risultato.getString("profilo_collaborazione");
            pt.setProfiloCollaborazione(tmp == null || tmp.equals("") ? null : tmp);
            tmp = risultato.getString("filtro_duplicati");
            pt.setFiltroDuplicati(tmp == null || tmp.equals("") ? null : tmp);
            tmp = risultato.getString("conferma_ricezione");
            pt.setConfermaRicezione(tmp == null || tmp.equals("") ? null : tmp);
            tmp = risultato.getString("identificativo_collaborazione");
            pt.setIdCollaborazione(tmp == null || tmp.equals("") ? null : tmp);
            tmp = risultato.getString("consegna_in_ordine");
            pt.setConsegnaInOrdine(tmp == null || tmp.equals("") ? null : tmp);
            tmp = risultato.getString("scadenza");
            pt.setScadenza(tmp == null || tmp.equals("") ? null : tmp);
            tmp = risultato.getString("profilo_pt");
            if (tmp == null || tmp.equals("")) {
                pt.setProfiloPT("default");
            } else {
                pt.setProfiloPT(tmp);
            }
            tmp = risultato.getString("soap_style");
            pt.setStyle(tmp == null || tmp.equals("") ? null : tmp);
            pt.setIdAccordo(risultato.getLong("id_accordo"));
            long idPortType = risultato.getLong("id");
            pt.setId(idPortType);
            this.readAzioniPortTypes(pt, con);
            lista.add(pt);
        }
        ArrayList<PortType> arrayList = lista;
        Object var20_20 = null;
        try {
            if (risultato != null) {
                risultato.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.atomica) {
                this.log.debug((Object)"rilascio connessioni al db...");
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return arrayList;
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                Object var20_21 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.atomica) {
                        this.log.debug((Object)"rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public List<PortaDominio> porteDominioWithSubject(String subject) throws DriverRegistroServiziException {
        String nomeMetodo = "porteDominioWithSubject";
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<PortaDominio> lista = new ArrayList<PortaDominio>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        Hashtable<String, String> hashSubject = Utilities.getSubjectIntoHashtable(subject);
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("pdd");
        sqlQueryObject.addSelectField("nome");
        sqlQueryObject.addSelectField("subject");
        Enumeration<String> keys = hashSubject.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String value = hashSubject.get(key);
            sqlQueryObject.addWhereLikeCondition("subject", "/" + Utilities.formatKeySubject(key) + "=" + Utilities.formatValueSubject(value) + "/", true, false);
        }
        sqlQueryObject.setANDLogicOperator(true);
        String queryString = sqlQueryObject.createSQLQuery();
        stmt = con.prepareStatement(queryString);
        risultato = stmt.executeQuery();
        while (risultato.next()) {
            String subjectPotenziale = risultato.getString("subject");
            if (!Utilities.sslVerify(subjectPotenziale, subject)) continue;
            PortaDominio pdd = this.getPortaDominio(risultato.getString("nome"));
            lista.add(pdd);
        }
        ArrayList<PortaDominio> arrayList = lista;
        Object var15_16 = null;
        try {
            if (risultato != null) {
                risultato.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (error && this.atomica) {
                this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                con.rollback();
                con.setAutoCommit(true);
                con.close();
            } else if (!error && this.atomica) {
                this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                con.commit();
                con.setAutoCommit(true);
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return arrayList;
        catch (Exception qe) {
            try {
                error = true;
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                Object var15_17 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (error && this.atomica) {
                        this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                        con.rollback();
                        con.setAutoCommit(true);
                        con.close();
                    } else if (!error && this.atomica) {
                        this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                        con.commit();
                        con.setAutoCommit(true);
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public List<String> fruzioniWithClientAuthAbilitato(String nomePdD, boolean nomenclaturaAPS) throws DriverRegistroServiziException {
        String nomeMetodo = "fruzioniWithClientAuthAbilitato";
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<String> lista = new ArrayList<String>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        ISQLQueryObject sqlQueryObjectInner = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObjectInner.addFromTable(this.tabellaSoggetti);
        sqlQueryObjectInner.addSelectField("id");
        sqlQueryObjectInner.addWhereCondition("server=?");
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("servizi_fruitori");
        sqlQueryObject.addWhereCondition("client_auth=?");
        sqlQueryObject.addWhereINSelectSQLCondition(false, "id_soggetto", sqlQueryObjectInner);
        sqlQueryObject.setANDLogicOperator(true);
        String queryString = sqlQueryObject.createSQLQuery();
        this.log.debug((Object)("QUERY [" + queryString + "] 1[" + "abilitato" + "] 2[" + nomePdD + "]"));
        stmt = con.prepareStatement(queryString);
        stmt.setString(1, "abilitato");
        stmt.setString(2, nomePdD);
        risultato = stmt.executeQuery();
        while (risultato.next()) {
            SoggettoSpcoop fruitore = this.getSoggettoRegistro(risultato.getLong("id_soggetto"));
            ServizioSpcoop servizio = this.getServizioSpcoop(risultato.getLong("id_servizio"));
            if (nomenclaturaAPS) {
                lista.add("Adesione del fruitore " + fruitore.getTipo() + "/" + fruitore.getNome() + " verso l'accordo di servizio parte specifica " + IDAccordo.getUriFromAccordo(servizio));
                continue;
            }
            lista.add("Fruizione del soggetto " + fruitore.getTipo() + "/" + fruitore.getNome() + " verso il servizio spcoop " + servizio.getTipo() + "/" + servizio.getNome() + " erogato dal soggetto " + servizio.getTipoSoggettoErogatore() + "/" + servizio.getNomeSoggettoErogatore());
        }
        ArrayList<String> arrayList = lista;
        Object var15_16 = null;
        try {
            if (risultato != null) {
                risultato.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (error && this.atomica) {
                this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                con.rollback();
                con.setAutoCommit(true);
                con.close();
            } else if (!error && this.atomica) {
                this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                con.commit();
                con.setAutoCommit(true);
                con.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return arrayList;
        catch (Exception qe) {
            try {
                error = true;
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                Object var15_17 = null;
                try {
                    if (risultato != null) {
                        risultato.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (error && this.atomica) {
                        this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                        con.rollback();
                        con.setAutoCommit(true);
                        con.close();
                    } else if (!error && this.atomica) {
                        this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                        con.commit();
                        con.setAutoCommit(true);
                        con.close();
                    }
                }
                catch (Exception e) {}
                throw throwable;
            }
        }
    }
}

