/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.dao.registry.driver;

import it.gov.spcoop.sica.manifest.driver.TipiDocumentoCoordinamento;
import it.gov.spcoop.sica.manifest.driver.TipiDocumentoLivelloServizio;
import it.gov.spcoop.sica.manifest.driver.TipiDocumentoSemiformale;
import it.gov.spcoop.sica.manifest.driver.TipiDocumentoSicurezza;
import java.util.ArrayList;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.registry.AccordoCooperazione;
import org.openspcoop.dao.registry.AccordoCooperazioneSoggettoReferente;
import org.openspcoop.dao.registry.AccordoServizio;
import org.openspcoop.dao.registry.AccordoServizioSoggettoReferente;
import org.openspcoop.dao.registry.Documento;
import org.openspcoop.dao.registry.PortaDominio;
import org.openspcoop.dao.registry.RegistroServizi;
import org.openspcoop.dao.registry.ServizioSpcoop;
import org.openspcoop.dao.registry.SoggettoSpcoop;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziDB;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziException;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop.dao.registry.driver.FiltroAccordiSPCoop;
import org.openspcoop.dao.registry.driver.FiltroSPCoop;
import org.openspcoop.dao.registry.driver.FiltroServiziSPCoop;
import org.openspcoop.dao.registry.driver.IDAccordo;
import org.openspcoop.dao.registry.driver.IDAccordoCooperazione;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.dao.registry.driver.IDriverRegistroServiziGet;
import org.openspcoop.dao.registry.driver.RuoliDocumento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BeanUtilities
implements IDriverRegistroServiziGet {
    @Override
    public boolean verificaAccordoCooperazione(IDAccordoCooperazione idAccordo, AccordoCooperazione accordoCooperazione) throws DriverRegistroServiziException {
        return this.verificaAccordoCooperazione(idAccordo, accordoCooperazione, true);
    }

    @Override
    public boolean verificaAccordoCooperazione(IDAccordoCooperazione idAccordo, AccordoCooperazione accordoCooperazione, boolean checkID) throws DriverRegistroServiziException {
        AccordoCooperazione beanRegistro = null;
        try {
            beanRegistro = this instanceof DriverRegistroServiziDB ? ((DriverRegistroServiziDB)this).getAccordoCooperazione(idAccordo, true) : this.getAccordoCooperazione(idAccordo);
        }
        catch (DriverRegistroServiziNotFound dNotFound) {
            // empty catch block
        }
        if (beanRegistro == null) {
            return accordoCooperazione == null;
        }
        if (accordoCooperazione == null) {
            return false;
        }
        return beanRegistro.equals(accordoCooperazione, checkID);
    }

    @Override
    public boolean verificaAccordo(IDAccordo idAccordo, AccordoServizio accordoServizio) throws DriverRegistroServiziException {
        return this.verificaAccordo(idAccordo, accordoServizio, true);
    }

    @Override
    public boolean verificaAccordo(IDAccordo idAccordo, AccordoServizio accordoServizio, boolean checkID) throws DriverRegistroServiziException {
        AccordoServizio beanRegistro = null;
        try {
            beanRegistro = this instanceof DriverRegistroServiziDB ? ((DriverRegistroServiziDB)this).getAccordoServizio(idAccordo, true) : this.getAccordoServizio(idAccordo);
        }
        catch (DriverRegistroServiziNotFound dNotFound) {
            // empty catch block
        }
        if (beanRegistro == null) {
            return accordoServizio == null;
        }
        if (accordoServizio == null) {
            return false;
        }
        return beanRegistro.equals(accordoServizio, checkID);
    }

    @Override
    public boolean verificaPortaDominio(String nomePdd, PortaDominio pdd) throws DriverRegistroServiziException {
        return this.verificaPortaDominio(nomePdd, pdd, true);
    }

    @Override
    public boolean verificaPortaDominio(String nomePdd, PortaDominio pdd, boolean checkID) throws DriverRegistroServiziException {
        PortaDominio beanRegistro = null;
        try {
            beanRegistro = this.getPortaDominio(nomePdd);
        }
        catch (DriverRegistroServiziNotFound dNotFound) {
            // empty catch block
        }
        if (beanRegistro == null) {
            return pdd == null;
        }
        if (pdd == null) {
            return false;
        }
        return beanRegistro.equals(pdd, checkID);
    }

    @Override
    public boolean verificaSoggetto(IDSoggetto idSoggetto, SoggettoSpcoop soggetto) throws DriverRegistroServiziException {
        return this.verificaSoggetto(idSoggetto, soggetto, true);
    }

    @Override
    public boolean verificaSoggetto(IDSoggetto idSoggetto, SoggettoSpcoop soggetto, boolean checkID) throws DriverRegistroServiziException {
        SoggettoSpcoop beanRegistro = null;
        try {
            beanRegistro = this.getSoggettoRegistro(idSoggetto);
        }
        catch (DriverRegistroServiziNotFound dNotFound) {
            // empty catch block
        }
        if (beanRegistro == null) {
            return soggetto == null;
        }
        if (soggetto == null) {
            return false;
        }
        return beanRegistro.equals(soggetto, checkID);
    }

    @Override
    public boolean verificaServizio(IDServizio idService, ServizioSpcoop servizio) throws DriverRegistroServiziException {
        return this.verificaServizio(idService, servizio, true);
    }

    @Override
    public boolean verificaServizio(IDServizio idService, ServizioSpcoop servizio, boolean checkID) throws DriverRegistroServiziException {
        ServizioSpcoop beanRegistro = null;
        try {
            beanRegistro = this instanceof DriverRegistroServiziDB ? ((DriverRegistroServiziDB)this).getServizio(idService, true) : this.getServizio(idService);
        }
        catch (DriverRegistroServiziNotFound dNotFound) {
            // empty catch block
        }
        if (beanRegistro == null) {
            return servizio == null;
        }
        if (servizio == null) {
            return false;
        }
        return beanRegistro.equals(servizio, checkID);
    }

    @Override
    public boolean verificaServizioCorrelato(IDServizio idService, ServizioSpcoop servizio) throws DriverRegistroServiziException {
        return this.verificaServizioCorrelato(idService, servizio, true);
    }

    @Override
    public boolean verificaServizioCorrelato(IDServizio idService, ServizioSpcoop servizio, boolean checkID) throws DriverRegistroServiziException {
        ServizioSpcoop beanRegistro = null;
        try {
            beanRegistro = this instanceof DriverRegistroServiziDB ? ((DriverRegistroServiziDB)this).getServizioCorrelato(idService, true) : this.getServizioCorrelato(idService);
        }
        catch (DriverRegistroServiziNotFound dNotFound) {
            // empty catch block
        }
        if (beanRegistro == null) {
            return servizio == null;
        }
        if (servizio == null) {
            return false;
        }
        return beanRegistro.equals(servizio, checkID);
    }

    @Override
    public boolean verificaServizioCorrelato(IDSoggetto idSoggetto, IDAccordo idAccordo, ServizioSpcoop servizio) throws DriverRegistroServiziException {
        return this.verificaServizioCorrelato(idSoggetto, idAccordo, servizio, true);
    }

    @Override
    public boolean verificaServizioCorrelato(IDSoggetto idSoggetto, IDAccordo idAccordo, ServizioSpcoop servizio, boolean checkID) throws DriverRegistroServiziException {
        ServizioSpcoop beanRegistro = null;
        try {
            beanRegistro = this instanceof DriverRegistroServiziDB ? ((DriverRegistroServiziDB)this).getServizioCorrelato(idSoggetto, idAccordo, true) : this.getServizioCorrelato(idSoggetto, idAccordo);
        }
        catch (DriverRegistroServiziNotFound dNotFound) {
            // empty catch block
        }
        if (beanRegistro == null) {
            return servizio == null;
        }
        if (servizio == null) {
            return false;
        }
        return beanRegistro.equals(servizio, checkID);
    }

    public static IDSoggetto getSoggettoReferenteID(AccordoServizioSoggettoReferente ass) {
        if (ass != null && ass.getTipo() != null && ass.getNome() != null) {
            return new IDSoggetto(ass.getTipo(), ass.getNome());
        }
        return null;
    }

    public static IDSoggetto getSoggettoReferenteID(AccordoCooperazioneSoggettoReferente acs) {
        if (acs != null && acs.getTipo() != null && acs.getNome() != null) {
            return new IDSoggetto(acs.getTipo(), acs.getNome());
        }
        return null;
    }

    public static void validateTipoRuolo(String tipo, String ruolo) throws DriverRegistroServiziException {
        if (RuoliDocumento.allegato.toString().equals(ruolo)) {
            return;
        }
        if (RuoliDocumento.specificaSemiformale.toString().equals(ruolo)) {
            if (!(TipiDocumentoSemiformale.HTML.toString().equals(tipo) || TipiDocumentoSemiformale.LINGUAGGIO_NATURALE.toString().equals(tipo) || TipiDocumentoSemiformale.UML.toString().equals(tipo) || TipiDocumentoSemiformale.XML.toString().equals(tipo))) {
                throw new DriverRegistroServiziException("Tipo[" + tipo + "] non accettato per il Ruolo[" + ruolo + "], valori ammessi sono: " + TipiDocumentoSemiformale.HTML.toString() + "," + TipiDocumentoSemiformale.LINGUAGGIO_NATURALE.toString() + "," + TipiDocumentoSemiformale.UML.toString() + "," + TipiDocumentoSemiformale.XML.toString());
            }
        } else if (RuoliDocumento.specificaLivelloServizio.toString().equals(ruolo)) {
            if (!TipiDocumentoLivelloServizio.WSAGREEMENT.toString().equals(tipo) && !TipiDocumentoLivelloServizio.WSLA.toString().equals(tipo)) {
                throw new DriverRegistroServiziException("Tipo[" + tipo + "] non accettato per il Ruolo[" + ruolo + "], valori ammessi sono: " + TipiDocumentoLivelloServizio.WSAGREEMENT.toString() + "," + TipiDocumentoLivelloServizio.WSLA.toString());
            }
        } else if (RuoliDocumento.specificaSicurezza.toString().equals(ruolo)) {
            if (!TipiDocumentoSicurezza.LINGUAGGIO_NATURALE.toString().equals(tipo) && !TipiDocumentoSicurezza.WSPOLICY.toString().equals(tipo)) {
                throw new DriverRegistroServiziException("Tipo[" + tipo + "] non accettato per il Ruolo[" + ruolo + "], valori ammessi sono: " + TipiDocumentoSicurezza.LINGUAGGIO_NATURALE.toString() + "," + TipiDocumentoSicurezza.WSPOLICY.toString());
            }
        } else if (RuoliDocumento.specificaCoordinamento.toString().equals(ruolo)) {
            if (!TipiDocumentoCoordinamento.BPEL.toString().equals(tipo) && !TipiDocumentoCoordinamento.WSCDL.toString().equals(tipo)) {
                throw new DriverRegistroServiziException("Tipo[" + tipo + "] non accettato per il Ruolo[" + ruolo + "], valori ammessi sono: " + TipiDocumentoCoordinamento.BPEL.toString() + "," + TipiDocumentoCoordinamento.WSCDL.toString());
            }
        } else {
            throw new DriverRegistroServiziException("Ruolo non conosciuto");
        }
    }

    public static <T> ArrayList<Documento> getAllDocumenti(T o) {
        ArrayList<Documento> lista;
        block16: {
            block17: {
                block15: {
                    lista = new ArrayList<Documento>();
                    if (!(o instanceof AccordoServizio)) break block15;
                    AccordoServizio b = (AccordoServizio)o;
                    if (b.sizeAllegatoList() > 0) {
                        for (Documento documento : b.getAllegatoList()) {
                            lista.add(documento);
                        }
                    }
                    if (b.sizeSpecificaSemiformaleList() <= 0) break block16;
                    for (Documento documento : b.getSpecificaSemiformaleList()) {
                        lista.add(documento);
                    }
                    break block16;
                }
                if (!(o instanceof AccordoCooperazione)) break block17;
                AccordoCooperazione b = (AccordoCooperazione)o;
                if (b.sizeAllegatoList() > 0) {
                    for (Documento documento : b.getAllegatoList()) {
                        lista.add(documento);
                    }
                }
                if (b.sizeSpecificaSemiformaleList() <= 0) break block16;
                for (Documento documento : b.getSpecificaSemiformaleList()) {
                    lista.add(documento);
                }
                break block16;
            }
            if (o instanceof ServizioSpcoop) {
                ServizioSpcoop b = (ServizioSpcoop)o;
                if (b.sizeAllegatoList() > 0) {
                    for (Documento documento : b.getAllegatoList()) {
                        lista.add(documento);
                    }
                }
                if (b.sizeSpecificaSemiformaleList() > 0) {
                    for (Documento documento : b.getSpecificaSemiformaleList()) {
                        lista.add(documento);
                    }
                }
                if (b.sizeSpecificaLivelloServizioList() > 0) {
                    for (Documento documento : b.getSpecificaLivelloServizioList()) {
                        lista.add(documento);
                    }
                }
                if (b.sizeSpecificaSicurezzaList() > 0) {
                    for (Documento documento : b.getSpecificaSicurezzaList()) {
                        lista.add(documento);
                    }
                }
            }
        }
        return lista;
    }

    public RegistroServizi getImmagineCompletaRegistroServizi() throws DriverRegistroServiziException {
        RegistroServizi registroServizi = new RegistroServizi();
        String[] idPdd = null;
        try {
            idPdd = this.getAllIdPorteDominio(new FiltroSPCoop());
        }
        catch (DriverRegistroServiziNotFound dNotFound) {
            // empty catch block
        }
        if (idPdd != null) {
            for (int i = 0; i < idPdd.length; ++i) {
                try {
                    registroServizi.addPortaDominio(this.getPortaDominio(idPdd[i]));
                    continue;
                }
                catch (DriverRegistroServiziNotFound dNotfound) {
                    throw new DriverRegistroServiziException("Porta di Dominio [" + idPdd[i] + "] trovato tramite getAllId ma poi non recuperabile: " + dNotfound.getMessage(), dNotfound);
                }
            }
        }
        IDAccordoCooperazione[] idAccordiCooperazione = null;
        try {
            idAccordiCooperazione = this.getAllIdAccordiCooperazione(new FiltroAccordiSPCoop());
        }
        catch (DriverRegistroServiziNotFound dNotFound) {
            // empty catch block
        }
        if (idAccordiCooperazione != null) {
            for (int i = 0; i < idAccordiCooperazione.length; ++i) {
                try {
                    registroServizi.addAccordoCooperazione(this.getAccordoCooperazione(idAccordiCooperazione[i]));
                    continue;
                }
                catch (DriverRegistroServiziNotFound dNotfound) {
                    throw new DriverRegistroServiziException("Accordo di cooperazione [" + idAccordiCooperazione[i] + "] trovato tramite getAllId ma poi non recuperabile: " + dNotfound.getMessage(), dNotfound);
                }
            }
        }
        IDAccordo[] idAccordiServizio = null;
        try {
            idAccordiServizio = this.getAllIdAccordiServizio(new FiltroAccordiSPCoop());
        }
        catch (DriverRegistroServiziNotFound dNotFound) {
            // empty catch block
        }
        if (idAccordiServizio != null) {
            for (int i = 0; i < idAccordiServizio.length; ++i) {
                try {
                    registroServizi.addAccordoServizio(this.getAccordoServizio(idAccordiServizio[i]));
                    continue;
                }
                catch (DriverRegistroServiziNotFound dNotfound) {
                    throw new DriverRegistroServiziException("Accordo di servizio [" + idAccordiServizio[i] + "] trovato tramite getAllId ma poi non recuperabile: " + dNotfound.getMessage(), dNotfound);
                }
            }
        }
        IDSoggetto[] idSoggetti = null;
        try {
            idSoggetti = this.getAllIdSoggettiRegistro(new FiltroSPCoop());
        }
        catch (DriverRegistroServiziNotFound dNotFound) {
            // empty catch block
        }
        if (idSoggetti != null) {
            for (int i = 0; i < idSoggetti.length; ++i) {
                try {
                    SoggettoSpcoop soggetto = this.getSoggettoRegistro(idSoggetti[i]);
                    while (soggetto.sizeServizioList() > 0) {
                        soggetto.removeServizio(0);
                    }
                    while (soggetto.sizeServizioCorrelatoList() > 0) {
                        soggetto.removeServizioCorrelato(0);
                    }
                    FiltroServiziSPCoop filtro = new FiltroServiziSPCoop();
                    filtro.setTipoSoggettoErogatore(soggetto.getTipo());
                    filtro.setNomeSoggettoErogatore(soggetto.getNome());
                    IDServizio[] idServizi = null;
                    try {
                        idServizi = this.getAllIdServizi(filtro);
                    }
                    catch (DriverRegistroServiziNotFound dNotFound) {
                        // empty catch block
                    }
                    if (idServizi != null) {
                        for (int j = 0; j < idServizi.length; ++j) {
                            try {
                                ServizioSpcoop s = this.getServizio(idServizi[j]);
                                soggetto.addServizio(s);
                                continue;
                            }
                            catch (DriverRegistroServiziNotFound dNotfound) {
                                throw new DriverRegistroServiziException("Servizio SPCoop [" + idServizi[i] + "] trovato tramite getAllId ma poi non recuperabile: " + dNotfound.getMessage(), dNotfound);
                            }
                        }
                    }
                    IDServizio[] idServiziCorrelati = null;
                    try {
                        idServiziCorrelati = this.getAllIdServiziCorrelati(filtro);
                    }
                    catch (DriverRegistroServiziNotFound dNotFound) {
                        // empty catch block
                    }
                    if (idServiziCorrelati != null) {
                        for (int j = 0; j < idServiziCorrelati.length; ++j) {
                            try {
                                ServizioSpcoop s = this.getServizioCorrelato(idServiziCorrelati[j]);
                                soggetto.addServizioCorrelato(s);
                                continue;
                            }
                            catch (DriverRegistroServiziNotFound dNotfound) {
                                throw new DriverRegistroServiziException("Servizio SPCoop Correlato [" + idServiziCorrelati[i] + "] trovato tramite getAllId ma poi non recuperabile: " + dNotfound.getMessage(), dNotfound);
                            }
                        }
                    }
                    registroServizi.addSoggettoSpcoop(soggetto);
                    continue;
                }
                catch (DriverRegistroServiziNotFound dNotfound) {
                    throw new DriverRegistroServiziException("Soggetto SPCoop [" + idSoggetti[i] + "] trovato tramite getAllId ma poi non recuperabile: " + dNotfound.getMessage(), dNotfound);
                }
            }
        }
        return registroServizi;
    }
}

